import { ISortBy, ITransform, TableGridBreakpoint } from '@patternfly/react-table';
import React, { ReactNode } from 'react';
declare type SortFn<T> = (a: T, b: T) => number;
declare type CellFn<T> = (item: T) => ReactNode;
declare type SearchFn<T> = (item: T) => string | boolean | number | string[] | boolean[] | number[];
export interface IAcmTableColumn<T> {
    /** the header of the column */
    header: string;
    tooltip?: string;
    /** enables sort either on field name of using sort function */
    sort?: SortFn<T> | string;
    /** if defined will enable search of the search field */
    search?: SearchFn<T> | string;
    /** cell content, either on field name of using cell function */
    cell: CellFn<T> | string;
    transforms?: ITransform[];
    cellTransforms?: ITransform[];
}
export interface IAcmTableAction {
    id: string;
    title: string | React.ReactNode;
    click: () => void;
}
export interface IAcmRowAction<T> {
    id: string;
    title: string | React.ReactNode;
    click: (item: T) => void;
}
export interface IAcmTableBulkAction<T> {
    id: string;
    title: string | React.ReactNode;
    click: (items: T[]) => void;
}
export declare function AcmTablePaginationContextProvider(props: {
    children: ReactNode;
    localStorageKey: string;
}): JSX.Element;
export declare function AcmTable<T>(props: {
    plural: string;
    items?: T[];
    columns: IAcmTableColumn<T>[];
    keyFn: (item: T) => string;
    tableActions: IAcmTableAction[];
    rowActions: IAcmRowAction<T>[];
    bulkActions: IAcmTableBulkAction<T>[];
    extraToolbarControls?: ReactNode;
    emptyState?: ReactNode;
    page?: number;
    setPage?: (page: number) => void;
    search?: string;
    setSearch?: (search: string) => void;
    sort?: ISortBy | undefined;
    setSort?: (sort: ISortBy | undefined) => void;
    gridBreakPoint?: TableGridBreakpoint;
}): JSX.Element;
export declare function compareItems(path: string): (a: unknown, b: unknown) => 0 | 1 | -1;
export declare function compareUnknowns(a: unknown | undefined | null, b: unknown | undefined | null): 0 | 1 | -1;
export declare function compareStrings(a: string | undefined | null, b: string | undefined | null): 0 | 1 | -1;
export declare function compareNumbers(a: number | undefined | null, b: number | undefined | null): 0 | 1 | -1;
export {};
