"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartTooltip = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const victory_tooltip_1 = require("victory-tooltip");
const ChartLabel_1 = require("../ChartLabel");
const ChartUtils_1 = require("../ChartUtils");
exports.ChartTooltip = (_a) => {
    var { constrainToVisibleArea = false, labelComponent = React.createElement(ChartLabel_1.ChartLabel, null), // Note that Victory provides its own label component here
    labelTextAnchor, themeColor, themeVariant, 
    // destructure last
    theme = ChartUtils_1.getTheme(themeColor, themeVariant) } = _a, rest = tslib_1.__rest(_a, ["constrainToVisibleArea", "labelComponent", "labelTextAnchor", "themeColor", "themeVariant", "theme"]);
    const chartLabelComponent = React.cloneElement(labelComponent, Object.assign({ textAnchor: labelTextAnchor, theme }, labelComponent.props));
    return (React.createElement(victory_tooltip_1.VictoryTooltip, Object.assign({ constrainToVisibleArea: constrainToVisibleArea, labelComponent: chartLabelComponent, theme: theme }, rest)));
};
exports.ChartTooltip.displayName = 'ChartTooltip';
// Note: VictoryTooltip.defaultEvents must be hoisted
hoist_non_react_statics_1.default(exports.ChartTooltip, victory_tooltip_1.VictoryTooltip);
//# sourceMappingURL=ChartTooltip.js.map