"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var invariant = require('invariant');
var isCallingCanDrop = false;
var DropTargetMonitorImpl = /** @class */ (function () {
    function DropTargetMonitorImpl(manager) {
        this.targetId = null;
        this.internalMonitor = manager.getMonitor();
    }
    DropTargetMonitorImpl.prototype.receiveHandlerId = function (targetId) {
        this.targetId = targetId;
    };
    DropTargetMonitorImpl.prototype.getHandlerId = function () {
        return this.targetId;
    };
    DropTargetMonitorImpl.prototype.subscribeToStateChange = function (listener, options) {
        return this.internalMonitor.subscribeToStateChange(listener, options);
    };
    DropTargetMonitorImpl.prototype.canDrop = function () {
        // Cut out early if the target id has not been set. This should prevent errors
        // where the user has an older version of dnd-core like in
        // https://github.com/react-dnd/react-dnd/issues/1310
        if (!this.targetId) {
            return false;
        }
        invariant(!isCallingCanDrop, 'You may not call monitor.canDrop() inside your canDrop() implementation. ' +
            'Read more: http://react-dnd.github.io/react-dnd/docs/api/drop-target-monitor');
        try {
            isCallingCanDrop = true;
            return this.internalMonitor.canDropOnTarget(this.targetId);
        }
        finally {
            isCallingCanDrop = false;
        }
    };
    DropTargetMonitorImpl.prototype.isOver = function (options) {
        if (!this.targetId) {
            return false;
        }
        return this.internalMonitor.isOverTarget(this.targetId, options);
    };
    DropTargetMonitorImpl.prototype.getItemType = function () {
        return this.internalMonitor.getItemType();
    };
    DropTargetMonitorImpl.prototype.getItem = function () {
        return this.internalMonitor.getItem();
    };
    DropTargetMonitorImpl.prototype.getDropResult = function () {
        return this.internalMonitor.getDropResult();
    };
    DropTargetMonitorImpl.prototype.didDrop = function () {
        return this.internalMonitor.didDrop();
    };
    DropTargetMonitorImpl.prototype.getInitialClientOffset = function () {
        return this.internalMonitor.getInitialClientOffset();
    };
    DropTargetMonitorImpl.prototype.getInitialSourceClientOffset = function () {
        return this.internalMonitor.getInitialSourceClientOffset();
    };
    DropTargetMonitorImpl.prototype.getSourceClientOffset = function () {
        return this.internalMonitor.getSourceClientOffset();
    };
    DropTargetMonitorImpl.prototype.getClientOffset = function () {
        return this.internalMonitor.getClientOffset();
    };
    DropTargetMonitorImpl.prototype.getDifferenceFromInitialOffset = function () {
        return this.internalMonitor.getDifferenceFromInitialOffset();
    };
    return DropTargetMonitorImpl;
}());
exports.default = DropTargetMonitorImpl;
