"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TreeViewRoot = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const react_styles_1 = require("@patternfly/react-styles");
const tree_view_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/TreeView/tree-view"));
const util_1 = require("../../helpers/util");
class TreeViewRoot extends React.Component {
    constructor() {
        super(...arguments);
        this.displayName = 'TreeViewRoot';
        this.treeRef = React.createRef();
        this.handleKeys = (event) => {
            if (this.treeRef.current !== event.target.closest('.pf-c-tree-view')) {
                return;
            }
            const activeElement = document.activeElement;
            const key = event.key;
            let moveFocus = false;
            let currentIndex = -1;
            const treeItems = Array.from(this.treeRef.current.getElementsByClassName('pf-c-tree-view__node'));
            if (key === 'Space') {
                document.activeElement.click();
                event.preventDefault();
            }
            if (['ArrowUp', 'ArrowDown'].includes(key)) {
                treeItems.forEach((treeItem, index) => {
                    if (activeElement === treeItem) {
                        const increment = key === 'ArrowUp' ? -1 : 1;
                        currentIndex = index + increment;
                        while (currentIndex < treeItems.length &&
                            currentIndex >= 0 &&
                            treeItems[currentIndex].classList.contains('pf-m-disabled')) {
                            currentIndex = currentIndex + increment;
                        }
                        moveFocus = true;
                        event.preventDefault();
                    }
                });
                if (moveFocus && treeItems[currentIndex]) {
                    activeElement.tabIndex = -1;
                    treeItems[currentIndex].tabIndex = 0;
                    treeItems[currentIndex].focus();
                }
            }
            if (['ArrowLeft', 'ArrowRight'].includes(key)) {
                const isExpandable = activeElement.firstElementChild.classList.contains('pf-c-tree-view__node-toggle');
                const isExpanded = activeElement.closest('li').classList.contains('pf-m-expanded');
                if (key === 'ArrowLeft') {
                    if (isExpandable && isExpanded) {
                        activeElement.click();
                    }
                    else {
                        const parentList = activeElement.closest('ul').parentElement;
                        if (parentList.tagName !== 'DIV') {
                            const parentButton = parentList.querySelector('button');
                            activeElement.tabIndex = -1;
                            parentButton.tabIndex = 0;
                            parentButton.focus();
                        }
                    }
                }
                else {
                    if (isExpandable && !isExpanded) {
                        activeElement.tabIndex = -1;
                        activeElement.click();
                        const childElement = activeElement
                            .closest('li')
                            .querySelector('ul > li')
                            .querySelector('button');
                        childElement.tabIndex = 0;
                        childElement.focus();
                    }
                }
                event.preventDefault();
            }
        };
        this.handleKeysCheckbox = (event) => {
            if (this.treeRef.current !== event.target.closest('.pf-c-tree-view')) {
                return;
            }
            const activeElement = document.activeElement;
            const key = event.key;
            let moveFocus = false;
            let currentIndex = -1;
            let innerIndex = -1;
            let previousIndex = -1;
            const treeNodes = Array.from(this.treeRef.current.getElementsByClassName('pf-c-tree-view__node'));
            const mappedItems = treeNodes.map(item => {
                const itemChildren = item.childNodes;
                const firstItem = itemChildren[0];
                if (firstItem.tagName === 'SPAN') {
                    return [null, firstItem.firstChild];
                }
                else {
                    return [itemChildren[0], itemChildren[1].firstChild];
                }
            });
            if (key === 'Space') {
                document.activeElement.click();
                event.preventDefault();
            }
            if (['ArrowUp', 'ArrowDown'].includes(key)) {
                mappedItems.forEach((treeItem, treeItemIndex) => {
                    treeItem.forEach((element, index) => {
                        if (activeElement === element) {
                            const increment = key === 'ArrowUp' ? -1 : 1;
                            innerIndex = index;
                            previousIndex = treeItemIndex;
                            currentIndex = treeItemIndex + increment;
                            while (currentIndex < mappedItems.length &&
                                currentIndex >= 0 &&
                                (!mappedItems[currentIndex][index] ||
                                    mappedItems[currentIndex][index].classList.contains('pf-m-disabled'))) {
                                currentIndex = currentIndex + increment;
                            }
                            moveFocus = true;
                            event.preventDefault();
                        }
                    });
                });
                if (moveFocus && mappedItems[currentIndex] && mappedItems[currentIndex][innerIndex]) {
                    if (mappedItems[previousIndex][0]) {
                        mappedItems[previousIndex][0].tabIndex = -1;
                    }
                    mappedItems[previousIndex][1].tabIndex = -1;
                    if (mappedItems[currentIndex][0]) {
                        mappedItems[currentIndex][0].tabIndex = 0;
                    }
                    mappedItems[currentIndex][1].tabIndex = 0;
                    mappedItems[currentIndex][innerIndex].focus();
                }
            }
            if (['ArrowLeft', 'ArrowRight'].includes(key)) {
                if (key === 'ArrowLeft') {
                    if (activeElement.tagName === 'INPUT') {
                        activeElement.parentElement.previousSibling &&
                            activeElement.parentElement.previousSibling.focus();
                    }
                    else if (activeElement.previousSibling) {
                        if (activeElement.previousElementSibling.tagName === 'SPAN') {
                            activeElement.previousSibling.firstChild.focus();
                        }
                        else {
                            activeElement.previousSibling.focus();
                        }
                    }
                }
                else {
                    if (activeElement.tagName === 'INPUT') {
                        activeElement.parentElement.nextSibling && activeElement.parentElement.nextSibling.focus();
                    }
                    else if (activeElement.nextSibling) {
                        if (activeElement.nextElementSibling.tagName === 'SPAN') {
                            activeElement.nextSibling.firstChild.focus();
                        }
                        else {
                            activeElement.nextSibling.focus();
                        }
                    }
                }
                event.preventDefault();
            }
        };
    }
    componentDidMount() {
        if (util_1.canUseDOM) {
            window.addEventListener('keydown', this.props.hasChecks ? this.handleKeysCheckbox : this.handleKeys);
        }
        if (this.props.hasChecks) {
            const firstToggle = this.treeRef.current.getElementsByClassName('pf-c-tree-view__node-toggle')[0];
            if (firstToggle) {
                firstToggle.tabIndex = 0;
            }
            const firstInput = this.treeRef.current.getElementsByTagName('INPUT')[0];
            if (firstInput) {
                firstInput.tabIndex = 0;
            }
        }
        else {
            this.treeRef.current.getElementsByClassName('pf-c-tree-view__node')[0].tabIndex = 0;
        }
    }
    componentWillUnmount() {
        if (util_1.canUseDOM) {
            window.removeEventListener('keydown', this.props.hasChecks ? this.handleKeysCheckbox : this.handleKeys);
        }
    }
    render() {
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        const _a = this.props, { children, hasChecks, className } = _a, props = tslib_1.__rest(_a, ["children", "hasChecks", "className"]);
        return (React.createElement("div", Object.assign({ className: react_styles_1.css(tree_view_1.default.treeView, className), ref: this.treeRef }, props), children));
    }
}
exports.TreeViewRoot = TreeViewRoot;
//# sourceMappingURL=TreeViewRoot.js.map