"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmDonutChart = exports.loadingDonutChart = void 0;
var react_1 = __importDefault(require("react"));
var react_core_1 = require("@patternfly/react-core");
var react_charts_1 = require("@patternfly/react-charts");
var styles_1 = require("@material-ui/styles");
var AcmChartGroup_1 = require("../AcmChartGroup");
/* istanbul ignore next */
var useStyles = styles_1.makeStyles({
    card: {
        maxHeight: '259px',
        minWidth: function (props) { return (props.viewWidth > 376 ? '376px' : undefined); },
        maxWidth: function (props) { return (props.viewWidth < 376 ? '376px' : undefined); },
        '& .pf-c-chart > svg g path:last-of-type': {
            fill: function (props) { return (props.danger ? '#E62325 !important' : undefined); },
        },
    },
    cardTitle: {
        paddingBottom: 'unset !important',
    },
    chartContainer: {
        maxWidth: '376px',
    },
});
var loadingDonutChart = function (title) {
    var useStyles = styles_1.makeStyles({
        chartContainer: {
            maxWidth: '376px',
        },
        skeleton: {
            margin: '0 0 20px 35px',
        },
    });
    var classes = useStyles();
    return (react_1.default.createElement(react_core_1.Card, null,
        react_1.default.createElement(react_core_1.CardTitle, null, title),
        react_1.default.createElement("div", { className: classes.chartContainer },
            react_1.default.createElement(react_core_1.Skeleton, { shape: "circle", width: "45%", className: classes.skeleton }))));
};
exports.loadingDonutChart = loadingDonutChart;
var LegendLabel = function (_a) {
    var _b;
    var props = __rest(_a, []);
    /*istanbul ignore next */
    var link = (_b = props.datum) === null || _b === void 0 ? void 0 : _b.link;
    return link ? (react_1.default.createElement("a", { href: link },
        react_1.default.createElement(react_charts_1.ChartLabel, __assign({}, props)))) : (react_1.default.createElement(react_charts_1.ChartLabel, __assign({}, props)));
};
function buildLegendWithLinks(legendData, colorScale) {
    return react_1.default.createElement(react_charts_1.ChartLegend, { data: legendData, labelComponent: react_1.default.createElement(LegendLabel, null), colorScale: colorScale });
}
function AcmDonutChart(props) {
    var _a, _b;
    var chartData = props.data.map(function (d) { return ({ x: d.key, y: d.value }); });
    var legendData = props.data.map(function (d) { return ({ name: d.value + " " + d.key, link: d.link }); });
    var total = props.data.reduce(function (a, b) { return a + b.value; }, 0);
    /* istanbul ignore next */
    var primary = props.data.find(function (d) { return d.isPrimary; }) || { key: '', value: 0 };
    var donutLabel = '';
    if (props.donutLabel) {
        donutLabel = props.donutLabel.title;
    }
    else if (total === 0) {
        donutLabel = '0%';
    }
    else {
        donutLabel = Math.round((primary.value / total) * 100) + "%";
    }
    var viewWidth = AcmChartGroup_1.useViewport().viewWidth;
    var classes = useStyles(__assign(__assign({}, props), { danger: props.data.some(function (d) { return d.isDanger; }), viewWidth: viewWidth }));
    if (props.loading)
        return exports.loadingDonutChart(props.title);
    return (react_1.default.createElement(react_core_1.Card, { className: classes.card, id: props.title.toLowerCase().replace(/\s+/g, '-') + "-chart" },
        react_1.default.createElement(react_core_1.CardTitle, { className: classes.cardTitle },
            props.title,
            " ",
            react_1.default.createElement(react_core_1.Badge, { isRead: true }, total)),
        react_1.default.createElement("div", { className: classes.chartContainer },
            react_1.default.createElement(react_charts_1.ChartDonut, { ariaTitle: props.title, ariaDesc: props.description, legendOrientation: "vertical", legendPosition: "right", constrainToVisibleArea: true, data: chartData, legendData: legendData, legendComponent: buildLegendWithLinks(legendData, props.colorScale), labels: function (_a) {
                    var datum = _a.datum;
                    return datum.x + ": " + ((datum.y / total) * 100).toFixed(2) + "%";
                }, padding: {
                    bottom: 20,
                    left: 20,
                    right: 145,
                    top: 20,
                }, title: donutLabel, subTitle: (_b = (_a = props.donutLabel) === null || _a === void 0 ? void 0 : _a.subTitle) !== null && _b !== void 0 ? _b : primary.key, width: /* istanbul ignore next */ viewWidth < 376 ? viewWidth : 376, height: /* istanbul ignore next */ viewWidth < 376 ? 150 : 200, 
                // Devs can supply an array of colors the donut chart will use ex: ['#E62325', '#EC7A08', '#F4C145', '#2B9AF3', '#72767B']
                // Defaults to blue theme
                colorScale: props.colorScale }))));
}
exports.AcmDonutChart = AcmDonutChart;
//# sourceMappingURL=AcmDonutChart.js.map