"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmScrollable = void 0;
var react_1 = __importStar(require("react"));
/** Scollable container that adds a top and bottom shadow on scroll */
function AcmScrollable(props) {
    var divEl = react_1.useRef(null);
    var _a = react_1.useState(0), topShadow = _a[0], setTopShadow = _a[1];
    var _b = react_1.useState(0), bottomShadow = _b[0], setBottomShadow = _b[1];
    var update = react_1.useCallback(function () {
        /* istanbul ignore else */
        if (divEl.current) {
            setTopShadow(Math.min(1, divEl.current.scrollTop / 8));
            var scrollBottom = divEl.current.scrollHeight - divEl.current.scrollTop - divEl.current.clientHeight;
            setBottomShadow(Math.max(0, Math.min(1, scrollBottom / 8)));
        }
    }, []);
    react_1.useEffect(update, [update, props.children]);
    var shadowOpacityTop = 0.08 * topShadow;
    var shadowOpacityBottom = 0.06 * bottomShadow;
    /* istanbul ignore next */
    var borderTop = props.borderTop ? 'thin solid rgba(0, 0, 0, 0.12)' : '';
    /* istanbul ignore next */
    var borderBottom = props.borderBottom ? 'thin solid rgba(0, 0, 0, 0.12)' : '';
    return (react_1.default.createElement("div", { style: { display: 'flex', flexDirection: 'column', flexGrow: 1, overflowY: 'hidden', position: 'relative' } },
        react_1.default.createElement("div", { ref: divEl, style: {
                display: 'flex',
                flexDirection: 'column',
                flexGrow: 1,
                overflowY: 'auto',
                borderTop: borderTop,
                borderBottom: borderBottom,
            }, onScroll: update }, props.children),
        /* istanbul ignore next */ shadowOpacityTop > 0 && (react_1.default.createElement("div", { style: {
                position: 'absolute',
                top: 0,
                height: '8px',
                width: '100%',
                background: "linear-gradient(rgba(0,0,0," + shadowOpacityTop + "), rgba(0,0,0,0))",
            } })),
        /* istanbul ignore next */ shadowOpacityBottom > 0 && (react_1.default.createElement("div", { style: {
                position: 'absolute',
                bottom: 0,
                height: '6px',
                width: '100%',
                background: "linear-gradient(rgba(0,0,0,0), rgba(0,0,0," + shadowOpacityBottom + "))",
            } }))));
}
exports.AcmScrollable = AcmScrollable;
//# sourceMappingURL=AcmScrollable.js.map