"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getQualitativeRangeData = exports.getPrimarySegmentedMeasureData = exports.getPrimaryDotMeasureData = exports.getComparativeWarningMeasureData = exports.getComparativeErrorMeasureData = exports.getComparativeMeasureData = void 0;
const victory_core_1 = require("victory-core");
const ChartUtils_1 = require("../../ChartUtils");
exports.getComparativeMeasureData = ({ data, themeColor, themeVariant, 
// destructure last
theme = ChartUtils_1.getBulletComparativeMeasureTheme(themeColor, themeVariant), y }) => {
    const datum = [];
    victory_core_1.Data.formatData(data, { y }, ['y']).forEach((dataPoint, index) => {
        datum.push(Object.assign(Object.assign({}, dataPoint), { _index: index // Save to sync legend color
         }));
    });
    const computedData = datum.map((dataPoint) => (Object.assign(Object.assign({}, dataPoint), { x: 1, _x: 1, y0: dataPoint._y, _y0: dataPoint._y, _color: theme.bar.style.data.fill // Save to sync legend color
     })));
    return computedData;
};
exports.getComparativeErrorMeasureData = ({ data, themeColor, themeVariant, 
// destructure last
theme = ChartUtils_1.getBulletComparativeErrorMeasureTheme(themeColor, themeVariant), y }) => exports.getComparativeMeasureData({
    data,
    theme,
    themeColor,
    themeVariant,
    y
});
exports.getComparativeWarningMeasureData = ({ data, themeColor, themeVariant, 
// destructure last
theme = ChartUtils_1.getBulletComparativeWarningMeasureTheme(themeColor, themeVariant), y }) => exports.getComparativeMeasureData({
    data,
    theme,
    themeColor,
    themeVariant,
    y
});
exports.getPrimaryDotMeasureData = ({ data, invert, themeColor, themeVariant, 
// destructure last
theme = ChartUtils_1.getBulletPrimaryDotMeasureTheme(themeColor, themeVariant), y, y0 }) => exports.getComparativeMeasureData({
    data,
    invert,
    theme,
    themeColor,
    themeVariant,
    y,
    y0
});
exports.getPrimarySegmentedMeasureData = ({ data, invert, themeColor, themeVariant, 
// destructure last
theme = ChartUtils_1.getBulletPrimarySegmentedMeasureTheme(themeColor, themeVariant), negativeMeasureTheme = ChartUtils_1.getBulletPrimaryNegativeMeasureTheme(themeColor, themeVariant), y, y0 }) => {
    const negativeDatum = [];
    const positiveDatum = [];
    victory_core_1.Data.formatData(data, { y, y0 }, ['y', 'y0']).forEach((dataPoint, index) => {
        if (dataPoint._y < 0) {
            negativeDatum.push(Object.assign(Object.assign({}, dataPoint), { _index: index // Save to sync legend color
             }));
        }
        else {
            positiveDatum.push(Object.assign(Object.assign({}, dataPoint), { _index: index // Save to sync legend color
             }));
        }
    });
    // Instead of relying on colorScale, colors must be added to each measure in ascending order
    const negativeComputedData = negativeDatum
        .sort((a, b) => b._y - a._y)
        .map((dataPoint, index) => (Object.assign(Object.assign({}, dataPoint), { x: 1, _x: 1, _color: invert
            ? theme.group.colorScale[index % theme.group.colorScale.length]
            : negativeMeasureTheme.group.colorScale[index % theme.group.colorScale.length] }))
    // Sort descending so largest bar is appears behind others
    )
        .reverse();
    // Instead of relying on colorScale, colors must be added to each measure in ascending order
    const positiveComputedData = positiveDatum
        .sort((a, b) => a._y - b._y)
        .map((dataPoint, index) => (Object.assign(Object.assign({}, dataPoint), { x: 1, _x: 1, _color: invert
            ? negativeMeasureTheme.group.colorScale[index % theme.group.colorScale.length]
            : theme.group.colorScale[index % theme.group.colorScale.length] }))
    // Sort descending so largest bar is appears behind others
    )
        .reverse();
    return [...negativeComputedData, ...positiveComputedData];
};
exports.getQualitativeRangeData = ({ data, invert, themeColor, themeVariant, 
// destructure last
theme = ChartUtils_1.getBulletQualitativeRangeTheme(themeColor, themeVariant), y, y0 }) => {
    const datum = [];
    victory_core_1.Data.formatData(data, { y, y0 }, ['y', 'y0']).forEach((dataPoint, index) => {
        datum.push(Object.assign(Object.assign({}, dataPoint), { _index: index // Save to sync legend color
         }));
    });
    const computedData = datum
        .sort((a, b) => (invert ? b._y - a._y : a._y - b._y))
        .map((dataPoint, index) => (Object.assign(Object.assign({}, dataPoint), { x: 1, _x: 1, 
        // Instead of relying on colorScale, colors must be added to each measure in ascending order
        _color: theme.group.colorScale[index % theme.group.colorScale.length] }))
    // Sort descending so largest bar is appears behind others
    )
        .reverse();
    return computedData;
};
//# sourceMappingURL=chart-bullet-data.js.map