"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ChartDonutThreshold = exports.ChartDonutThresholdSubTitlePosition = exports.ChartDonutThresholdSortOrder = exports.ChartDonutThresholdLabelPosition = exports.ChartDonutThresholdLabelOrientation = exports.ChartDonutThresholdDonutOrientation = void 0;
const tslib_1 = require("tslib");
const React = tslib_1.__importStar(require("react"));
const victory_core_1 = require("victory-core");
const victory_pie_1 = require("victory-pie");
const hoist_non_react_statics_1 = tslib_1.__importDefault(require("hoist-non-react-statics"));
const ChartContainer_1 = require("../ChartContainer");
const ChartDonut_1 = require("../ChartDonut");
const ChartTheme_1 = require("../ChartTheme");
const ChartUtils_1 = require("../ChartUtils");
var ChartDonutThresholdDonutOrientation;
(function (ChartDonutThresholdDonutOrientation) {
    ChartDonutThresholdDonutOrientation["left"] = "left";
    ChartDonutThresholdDonutOrientation["right"] = "right";
    ChartDonutThresholdDonutOrientation["top"] = "top";
})(ChartDonutThresholdDonutOrientation = exports.ChartDonutThresholdDonutOrientation || (exports.ChartDonutThresholdDonutOrientation = {}));
var ChartDonutThresholdLabelOrientation;
(function (ChartDonutThresholdLabelOrientation) {
    ChartDonutThresholdLabelOrientation["horizontal"] = "horizontal";
    ChartDonutThresholdLabelOrientation["vertical"] = "vertical";
})(ChartDonutThresholdLabelOrientation = exports.ChartDonutThresholdLabelOrientation || (exports.ChartDonutThresholdLabelOrientation = {}));
var ChartDonutThresholdLabelPosition;
(function (ChartDonutThresholdLabelPosition) {
    ChartDonutThresholdLabelPosition["centroid"] = "centroid";
    ChartDonutThresholdLabelPosition["endAngle"] = "endAngle";
    ChartDonutThresholdLabelPosition["startAngle"] = "startAngle";
})(ChartDonutThresholdLabelPosition = exports.ChartDonutThresholdLabelPosition || (exports.ChartDonutThresholdLabelPosition = {}));
var ChartDonutThresholdSortOrder;
(function (ChartDonutThresholdSortOrder) {
    ChartDonutThresholdSortOrder["ascending"] = "ascending";
    ChartDonutThresholdSortOrder["descending"] = "descending";
})(ChartDonutThresholdSortOrder = exports.ChartDonutThresholdSortOrder || (exports.ChartDonutThresholdSortOrder = {}));
var ChartDonutThresholdSubTitlePosition;
(function (ChartDonutThresholdSubTitlePosition) {
    ChartDonutThresholdSubTitlePosition["bottom"] = "bottom";
    ChartDonutThresholdSubTitlePosition["center"] = "center";
    ChartDonutThresholdSubTitlePosition["right"] = "right";
})(ChartDonutThresholdSubTitlePosition = exports.ChartDonutThresholdSubTitlePosition || (exports.ChartDonutThresholdSubTitlePosition = {}));
const ChartDonutThreshold = (_a) => {
    var { allowTooltip = true, ariaDesc, ariaTitle, children, constrainToVisibleArea = false, containerComponent = React.createElement(ChartContainer_1.ChartContainer, null), data = [], invert = false, labels = [], // Don't show any tooltip labels by default, let consumer override if needed
    padding, radius, standalone = true, subTitlePosition = ChartTheme_1.ChartDonutStyles.label.subTitlePosition, themeColor, themeVariant, x, y, 
    // destructure last
    theme = ChartUtils_1.getDonutThresholdStaticTheme(themeColor, themeVariant, invert), height = theme.pie.height, width = theme.pie.width } = _a, rest = tslib_1.__rest(_a, ["allowTooltip", "ariaDesc", "ariaTitle", "children", "constrainToVisibleArea", "containerComponent", "data", "invert", "labels", "padding", "radius", "standalone", "subTitlePosition", "themeColor", "themeVariant", "x", "y", "theme", "height", "width"]);
    const defaultPadding = {
        bottom: ChartUtils_1.getPaddingForSide('bottom', padding, theme.pie.padding),
        left: ChartUtils_1.getPaddingForSide('left', padding, theme.pie.padding),
        right: ChartUtils_1.getPaddingForSide('right', padding, theme.pie.padding),
        top: ChartUtils_1.getPaddingForSide('top', padding, theme.pie.padding)
    };
    const chartRadius = radius ||
        victory_core_1.Helpers.getRadius({
            height,
            width,
            padding: defaultPadding
        });
    // Returns computed data representing pie chart slices
    const getComputedData = () => {
        // Format and sort data. Sorting ensures thresholds are displayed in the correct order and simplifies calculations.
        const datum = victory_core_1.Data.formatData(data, Object.assign({ x, y }, rest), ['x', 'y']).sort((a, b) => a._y - b._y);
        // Data must be offset so that the sum of all data point y-values (including the final slice) == 100.
        const [prev, computedData] = datum.reduce((acc, dataPoint) => [
            dataPoint._y,
            [
                ...acc[1],
                {
                    x: dataPoint._x,
                    y: dataPoint._y - acc[0] // Must be offset by previous value
                }
            ]
        ], [0, []]);
        return [
            ...computedData,
            {
                y: prev ? 100 - prev : 0
            }
        ];
    };
    // Render dynamic utilization donut cart
    const renderChildren = () => React.Children.toArray(children).map((child, index) => {
        if (React.isValidElement(child)) {
            const _a = child.props, { data: childData } = _a, childProps = tslib_1.__rest(_a, ["data"]);
            const datum = victory_core_1.Data.formatData([childData], childProps, ['x', 'y']); // Format child data independently of this component's props
            const dynamicTheme = childProps.theme ||
                ChartUtils_1.getDonutThresholdDynamicTheme(childProps.themeColor || themeColor, childProps.themeVariant || themeVariant);
            return React.cloneElement(child, Object.assign({ constrainToVisibleArea, data: childData, endAngle: 360 * (datum[0]._y ? datum[0]._y / 100 : 0), height,
                invert, key: `pf-chart-donut-threshold-child-${index}`, padding: defaultPadding, radius: chartRadius - 14, showStatic: false, standalone: false, subTitlePosition: childProps.subTitlePosition || subTitlePosition, theme: dynamicTheme, width }, childProps));
        }
        return child;
    });
    // Static threshold donut chart
    const chart = (React.createElement(ChartDonut_1.ChartDonut, Object.assign({ allowTooltip: allowTooltip, constrainToVisibleArea: constrainToVisibleArea, data: getComputedData(), height: height, key: "pf-chart-donut-threshold", labels: labels, padding: defaultPadding, standalone: false, theme: theme, width: width }, rest)));
    // Clone so users can override container props
    const container = React.cloneElement(containerComponent, Object.assign({ desc: ariaDesc, height, title: ariaTitle, width,
        theme }, containerComponent.props), [chart, renderChildren()]);
    return standalone ? (React.createElement(React.Fragment, null, container)) : (React.createElement(React.Fragment, null,
        chart,
        renderChildren()));
};
exports.ChartDonutThreshold = ChartDonutThreshold;
exports.ChartDonutThreshold.displayName = 'ChartDonutThreshold';
// Note: VictoryPie.role must be hoisted
hoist_non_react_statics_1.default(exports.ChartDonutThreshold, victory_pie_1.VictoryPie);
//# sourceMappingURL=ChartDonutThreshold.js.map