"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmInlineStatus = exports.StatusType = void 0;
var core_1 = require("@material-ui/core");
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
var react_1 = __importDefault(require("react"));
var AcmIcons_1 = require("../AcmIcons/AcmIcons");
var useStyles = core_1.makeStyles({
    container: {
        display: 'flex',
    },
    icon: {
        width: '18px', // Progress size md is 18px
    },
    iconMargin: {
        margin: '3px 2px 1px 2px',
    },
    button: {
        padding: 0,
        fontSize: 'inherit',
    },
});
var StatusType;
(function (StatusType) {
    StatusType["healthy"] = "healthy";
    StatusType["danger"] = "danger";
    StatusType["warning"] = "warning";
    StatusType["progress"] = "progress";
    StatusType["detached"] = "detached";
    StatusType["pending"] = "pending";
    StatusType["unknown"] = "unknown";
    StatusType["sleep"] = "sleep";
    StatusType["empty"] = "empty";
    StatusType["draft"] = "draft";
})(StatusType = exports.StatusType || (exports.StatusType = {}));
function AcmInlineStatus(props) {
    var classes = useStyles();
    return (react_1.default.createElement("div", { className: classes.container },
        react_1.default.createElement("div", { className: classes.icon },
            react_1.default.createElement(StatusIcon, { type: props.type })),
        react_1.default.createElement("span", { style: { marginLeft: '.4rem' } }, props.popover ? (react_1.default.createElement(react_core_1.Popover, __assign({ hasAutoWidth: true }, props.popover),
            react_1.default.createElement(react_core_1.Button, { variant: "link", className: classes.button }, props.status))) : (props.status))));
}
exports.AcmInlineStatus = AcmInlineStatus;
function StatusIcon(props) {
    var classes = useStyles();
    switch (props.type) {
        case StatusType.healthy:
            return react_1.default.createElement(react_icons_1.CheckCircleIcon, { className: classes.iconMargin, color: "var(--pf-global--success-color--100)" });
        case StatusType.danger:
            return react_1.default.createElement(react_icons_1.ExclamationCircleIcon, { className: classes.iconMargin, color: "var(--pf-global--danger-color--100)" });
        case StatusType.warning:
            return (react_1.default.createElement(react_icons_1.ExclamationTriangleIcon, { className: classes.iconMargin, color: "var(--pf-global--warning-color--100)" }));
        case StatusType.progress:
            return react_1.default.createElement(react_core_1.Spinner, { size: "md", style: { verticalAlign: 'middle' } });
        case StatusType.detached:
            return react_1.default.createElement(AcmIcons_1.AcmIcon, { icon: AcmIcons_1.AcmIconVariant.brokenlink });
        case StatusType.pending:
            return react_1.default.createElement(react_icons_1.MinusCircleIcon, { className: classes.iconMargin, color: "var(--pf-global--disabled-color--100)" });
        case StatusType.sleep:
            return react_1.default.createElement(react_icons_1.AsleepIcon, { className: classes.iconMargin, color: "var(--pf-global--palette--purple-500)" });
        case StatusType.empty:
            return react_1.default.createElement(react_icons_1.ResourcesEmptyIcon, { className: classes.iconMargin, color: "var(--pf-global--disabled-color--100)" });
        case StatusType.draft:
            return react_1.default.createElement(react_icons_1.FileAltIcon, { className: classes.iconMargin, color: "var(--pf-global--disabled-color--100)" });
        case 'unknown':
        default:
            return react_1.default.createElement(react_icons_1.UnknownIcon, { className: classes.iconMargin, color: "var(--pf-global--disabled-color--100)" });
    }
}
//# sourceMappingURL=AcmInlineStatus.js.map