"use strict";
/* Copyright Contributors to the Open Cluster Management project */
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AcmProviderCard = exports.AcmOverviewProviders = void 0;
var react_1 = __importDefault(require("react"));
var react_core_1 = require("@patternfly/react-core");
var react_icons_1 = require("@patternfly/react-icons");
var styles_1 = require("@material-ui/styles");
var AcmIcons_1 = require("../../AcmIcons/AcmIcons");
var __1 = require("../");
var useStyles = styles_1.makeStyles({
    icon: {
        '& svg, & img': {
            width: '56px',
            height: '56px',
        },
    },
    providerTitle: {
        marginTop: '4px',
        fontSize: 'var(--pf-c-title--m-3xl--FontSize)',
        lineHeight: 'var(--pf-c-title--m-3xl--LineHeight)',
    },
    dangerIcon: {
        width: '16px',
        height: '16px',
        marginLeft: '8px',
        verticalAlign: 'unset !important',
    },
    clusterCount: {
        fontSize: '28px',
    },
    clusterText: {
        fontSize: '14px',
        fontWeight: 600,
    },
});
function AcmOverviewProviders(props) {
    return (react_1.default.createElement(react_core_1.Gallery, { hasGutter: true }, props.providers.map(function (provider) { return (react_1.default.createElement(react_core_1.GalleryItem, { key: provider.provider },
        react_1.default.createElement(AcmProviderCard, __assign({}, provider)))); })));
}
exports.AcmOverviewProviders = AcmOverviewProviders;
function AcmProviderCard(props) {
    var classes = useStyles();
    return (react_1.default.createElement(react_core_1.Card, { onClick: function () { return props.onClick(props.provider); }, onKeyDown: function (event) {
            return [13, 32].includes(event.keyCode) && props.onClick(props.provider);
        }, isSelectable: true, isSelected: props.isSelected, id: props.provider + "-provider-card" },
        react_1.default.createElement(react_core_1.Stack, null,
            react_1.default.createElement(react_core_1.StackItem, null,
                react_1.default.createElement(react_core_1.CardHeader, null,
                    react_1.default.createElement(react_core_1.CardHeaderMain, null,
                        react_1.default.createElement("div", { className: classes.icon },
                            react_1.default.createElement(AcmIcons_1.AcmIcon, { icon: __1.ProviderIconMap[props.provider] })),
                        react_1.default.createElement(react_core_1.Title, { headingLevel: "h2", size: "3xl", className: classes.providerTitle, style: { fontWeight: 300 } },
                            __1.ProviderShortTextMap[props.provider],
                            props.danger && (react_1.default.createElement(react_icons_1.ExclamationCircleIcon, { color: "var(--pf-global--palette--red-100)", className: classes.dangerIcon + " danger-icon" })))))),
            react_1.default.createElement(react_core_1.StackItem, { isFilled: true }),
            react_1.default.createElement(react_core_1.StackItem, null,
                react_1.default.createElement(react_core_1.CardFooter, null,
                    react_1.default.createElement(react_core_1.Text, { component: react_core_1.TextVariants.p, className: classes.clusterCount }, props.clusterCount),
                    react_1.default.createElement(react_core_1.Text, { component: react_core_1.TextVariants.p, className: classes.clusterText }, props.clusterCount === 1 ? 'Cluster' : 'Clusters'))))));
}
exports.AcmProviderCard = AcmProviderCard;
//# sourceMappingURL=AcmProviderCard.js.map