---
layout: "docs"
page_title: "TOTP - Secrets Engines"
sidebar_current: "docs-secrets-totp"
description: |-
  The TOTP secrets engine for Vault generates time-based one-time use passwords.
---

# TOTP Secrets Engine

The TOTP secrets engine generates time-based credentials according to the TOTP
standard. The secrets engine can also be used to generate a new key and validate
passwords generated by that key.

The TOTP secrets engine can act as both a generator (like Google Authenticator)
and a provider (like the Google.com sign in service).

## As a Generator

The TOTP secrets engine can act as a TOTP code generator. In this mode, it can
replace traditional TOTP generators like Google Authenticator. It provides an
added layer of security since the ability to generate codes is guarded by
policies and the entire process is audited.

### Setup

Most secrets engines must be configured in advance before they can perform their
functions. These steps are usually completed by an operator or configuration
management tool.

1. Enable the TOTP secrets engine:

    ```text
    $ vault secrets enable totp
    Success! Enabled the totp secrets engine at: totp/
    ```

    By default, the secrets engine will mount at the name of the engine. To
    enable the secrets engine at a different path, use the `-path` argument.

1. Configure a named key. The name of this key will be a human identifier as to
its purpose.

    ```text
    $ vault write totp/keys/my-key \
        url="otpauth://totp/Vault:test@test.com?secret=Y64VEVMBTSXCYIWRSHRNDZW62MPGVU2G&issuer=Vault"
    Success! Data written to: totp/keys/my-key
    ```

    The `url` corresponds to the secret key or value from the barcode provided
    by the third-party service.

### Usage

After the secrets engine is configured and a user/machine has a Vault token with
the proper permission, it can generate credentials.

1. Generate a new time-based OTP by reading from the `/code` endpoint with the
name of the key:

    ```text
    $ vault read totp/code/my-key
    Key     Value
    ---     -----
    code    260610
    ```

    Using ACLs, it is possible to restrict using the TOTP secrets engine such
    that trusted operators can manage the key definitions, and both users and
    applications are restricted in the credentials they are allowed to read.

## As a Provider

The TOTP secrets engine can also act as a TOTP provider. In this mode, it can be
used to generate new keys and validate passwords generated using those keys.

### Setup

Most secrets engines must be configured in advance before they can perform their
functions. These steps are usually completed by an operator or configuration
management tool.

1. Enable the TOTP secrets engine:

    ```text
    $ vault secrets enable totp
    Success! Enabled the totp secrets engine at: totp/
    ```

    By default, the secrets engine will mount at the name of the engine. To
    enable the secrets engine at a different path, use the `-path` argument.

1. Create a named key, using the `generate` option. This tells Vault to be the
provider:

    ```text
    $ vault write totp/keys/my-user \
        generate=true \
        issuer=Vault \
        account_name=user@test.com

    Key        Value
    ---        -----
    barcode    iVBORw0KGgoAAAANSUhEUgAAAMgAAADIEAAAAADYoy0BA...
    url        otpauth://totp/Vault:user@test.com?algorithm=SHA1&digits=6&issuer=Vault&period=30&secret=V7MBSK324I7KF6KVW34NDFH2GYHIF6JY
    ```

    The response includes a base64-encoded barcode and OTP url. Both are
    equivalent. Give these to the user who is authenticating with TOTP.

### Usage

1. As a user, validate a TOTP code generated by a third-party app:

    ```text
    $ vault write totp/code/my-user code=886531
    Key      Value
    ---      -----
    valid    true
    ```

## API

The TOTP secrets engine has a full HTTP API. Please see the
[TOTP secrets engine API](/api/secret/totp/index.html) for more
details.
