// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package worklinkiface provides an interface to enable mocking the Amazon WorkLink service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package worklinkiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/worklink"
)

// WorkLinkAPI provides an interface to enable mocking the
// worklink.WorkLink service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // Amazon WorkLink.
//    func myFunc(svc worklinkiface.WorkLinkAPI) bool {
//        // Make svc.AssociateDomain request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := worklink.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockWorkLinkClient struct {
//        worklinkiface.WorkLinkAPI
//    }
//    func (m *mockWorkLinkClient) AssociateDomain(input *worklink.AssociateDomainInput) (*worklink.AssociateDomainOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockWorkLinkClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type WorkLinkAPI interface {
	AssociateDomain(*worklink.AssociateDomainInput) (*worklink.AssociateDomainOutput, error)
	AssociateDomainWithContext(aws.Context, *worklink.AssociateDomainInput, ...request.Option) (*worklink.AssociateDomainOutput, error)
	AssociateDomainRequest(*worklink.AssociateDomainInput) (*request.Request, *worklink.AssociateDomainOutput)

	AssociateWebsiteAuthorizationProvider(*worklink.AssociateWebsiteAuthorizationProviderInput) (*worklink.AssociateWebsiteAuthorizationProviderOutput, error)
	AssociateWebsiteAuthorizationProviderWithContext(aws.Context, *worklink.AssociateWebsiteAuthorizationProviderInput, ...request.Option) (*worklink.AssociateWebsiteAuthorizationProviderOutput, error)
	AssociateWebsiteAuthorizationProviderRequest(*worklink.AssociateWebsiteAuthorizationProviderInput) (*request.Request, *worklink.AssociateWebsiteAuthorizationProviderOutput)

	AssociateWebsiteCertificateAuthority(*worklink.AssociateWebsiteCertificateAuthorityInput) (*worklink.AssociateWebsiteCertificateAuthorityOutput, error)
	AssociateWebsiteCertificateAuthorityWithContext(aws.Context, *worklink.AssociateWebsiteCertificateAuthorityInput, ...request.Option) (*worklink.AssociateWebsiteCertificateAuthorityOutput, error)
	AssociateWebsiteCertificateAuthorityRequest(*worklink.AssociateWebsiteCertificateAuthorityInput) (*request.Request, *worklink.AssociateWebsiteCertificateAuthorityOutput)

	CreateFleet(*worklink.CreateFleetInput) (*worklink.CreateFleetOutput, error)
	CreateFleetWithContext(aws.Context, *worklink.CreateFleetInput, ...request.Option) (*worklink.CreateFleetOutput, error)
	CreateFleetRequest(*worklink.CreateFleetInput) (*request.Request, *worklink.CreateFleetOutput)

	DeleteFleet(*worklink.DeleteFleetInput) (*worklink.DeleteFleetOutput, error)
	DeleteFleetWithContext(aws.Context, *worklink.DeleteFleetInput, ...request.Option) (*worklink.DeleteFleetOutput, error)
	DeleteFleetRequest(*worklink.DeleteFleetInput) (*request.Request, *worklink.DeleteFleetOutput)

	DescribeAuditStreamConfiguration(*worklink.DescribeAuditStreamConfigurationInput) (*worklink.DescribeAuditStreamConfigurationOutput, error)
	DescribeAuditStreamConfigurationWithContext(aws.Context, *worklink.DescribeAuditStreamConfigurationInput, ...request.Option) (*worklink.DescribeAuditStreamConfigurationOutput, error)
	DescribeAuditStreamConfigurationRequest(*worklink.DescribeAuditStreamConfigurationInput) (*request.Request, *worklink.DescribeAuditStreamConfigurationOutput)

	DescribeCompanyNetworkConfiguration(*worklink.DescribeCompanyNetworkConfigurationInput) (*worklink.DescribeCompanyNetworkConfigurationOutput, error)
	DescribeCompanyNetworkConfigurationWithContext(aws.Context, *worklink.DescribeCompanyNetworkConfigurationInput, ...request.Option) (*worklink.DescribeCompanyNetworkConfigurationOutput, error)
	DescribeCompanyNetworkConfigurationRequest(*worklink.DescribeCompanyNetworkConfigurationInput) (*request.Request, *worklink.DescribeCompanyNetworkConfigurationOutput)

	DescribeDevice(*worklink.DescribeDeviceInput) (*worklink.DescribeDeviceOutput, error)
	DescribeDeviceWithContext(aws.Context, *worklink.DescribeDeviceInput, ...request.Option) (*worklink.DescribeDeviceOutput, error)
	DescribeDeviceRequest(*worklink.DescribeDeviceInput) (*request.Request, *worklink.DescribeDeviceOutput)

	DescribeDevicePolicyConfiguration(*worklink.DescribeDevicePolicyConfigurationInput) (*worklink.DescribeDevicePolicyConfigurationOutput, error)
	DescribeDevicePolicyConfigurationWithContext(aws.Context, *worklink.DescribeDevicePolicyConfigurationInput, ...request.Option) (*worklink.DescribeDevicePolicyConfigurationOutput, error)
	DescribeDevicePolicyConfigurationRequest(*worklink.DescribeDevicePolicyConfigurationInput) (*request.Request, *worklink.DescribeDevicePolicyConfigurationOutput)

	DescribeDomain(*worklink.DescribeDomainInput) (*worklink.DescribeDomainOutput, error)
	DescribeDomainWithContext(aws.Context, *worklink.DescribeDomainInput, ...request.Option) (*worklink.DescribeDomainOutput, error)
	DescribeDomainRequest(*worklink.DescribeDomainInput) (*request.Request, *worklink.DescribeDomainOutput)

	DescribeFleetMetadata(*worklink.DescribeFleetMetadataInput) (*worklink.DescribeFleetMetadataOutput, error)
	DescribeFleetMetadataWithContext(aws.Context, *worklink.DescribeFleetMetadataInput, ...request.Option) (*worklink.DescribeFleetMetadataOutput, error)
	DescribeFleetMetadataRequest(*worklink.DescribeFleetMetadataInput) (*request.Request, *worklink.DescribeFleetMetadataOutput)

	DescribeIdentityProviderConfiguration(*worklink.DescribeIdentityProviderConfigurationInput) (*worklink.DescribeIdentityProviderConfigurationOutput, error)
	DescribeIdentityProviderConfigurationWithContext(aws.Context, *worklink.DescribeIdentityProviderConfigurationInput, ...request.Option) (*worklink.DescribeIdentityProviderConfigurationOutput, error)
	DescribeIdentityProviderConfigurationRequest(*worklink.DescribeIdentityProviderConfigurationInput) (*request.Request, *worklink.DescribeIdentityProviderConfigurationOutput)

	DescribeWebsiteCertificateAuthority(*worklink.DescribeWebsiteCertificateAuthorityInput) (*worklink.DescribeWebsiteCertificateAuthorityOutput, error)
	DescribeWebsiteCertificateAuthorityWithContext(aws.Context, *worklink.DescribeWebsiteCertificateAuthorityInput, ...request.Option) (*worklink.DescribeWebsiteCertificateAuthorityOutput, error)
	DescribeWebsiteCertificateAuthorityRequest(*worklink.DescribeWebsiteCertificateAuthorityInput) (*request.Request, *worklink.DescribeWebsiteCertificateAuthorityOutput)

	DisassociateDomain(*worklink.DisassociateDomainInput) (*worklink.DisassociateDomainOutput, error)
	DisassociateDomainWithContext(aws.Context, *worklink.DisassociateDomainInput, ...request.Option) (*worklink.DisassociateDomainOutput, error)
	DisassociateDomainRequest(*worklink.DisassociateDomainInput) (*request.Request, *worklink.DisassociateDomainOutput)

	DisassociateWebsiteAuthorizationProvider(*worklink.DisassociateWebsiteAuthorizationProviderInput) (*worklink.DisassociateWebsiteAuthorizationProviderOutput, error)
	DisassociateWebsiteAuthorizationProviderWithContext(aws.Context, *worklink.DisassociateWebsiteAuthorizationProviderInput, ...request.Option) (*worklink.DisassociateWebsiteAuthorizationProviderOutput, error)
	DisassociateWebsiteAuthorizationProviderRequest(*worklink.DisassociateWebsiteAuthorizationProviderInput) (*request.Request, *worklink.DisassociateWebsiteAuthorizationProviderOutput)

	DisassociateWebsiteCertificateAuthority(*worklink.DisassociateWebsiteCertificateAuthorityInput) (*worklink.DisassociateWebsiteCertificateAuthorityOutput, error)
	DisassociateWebsiteCertificateAuthorityWithContext(aws.Context, *worklink.DisassociateWebsiteCertificateAuthorityInput, ...request.Option) (*worklink.DisassociateWebsiteCertificateAuthorityOutput, error)
	DisassociateWebsiteCertificateAuthorityRequest(*worklink.DisassociateWebsiteCertificateAuthorityInput) (*request.Request, *worklink.DisassociateWebsiteCertificateAuthorityOutput)

	ListDevices(*worklink.ListDevicesInput) (*worklink.ListDevicesOutput, error)
	ListDevicesWithContext(aws.Context, *worklink.ListDevicesInput, ...request.Option) (*worklink.ListDevicesOutput, error)
	ListDevicesRequest(*worklink.ListDevicesInput) (*request.Request, *worklink.ListDevicesOutput)

	ListDevicesPages(*worklink.ListDevicesInput, func(*worklink.ListDevicesOutput, bool) bool) error
	ListDevicesPagesWithContext(aws.Context, *worklink.ListDevicesInput, func(*worklink.ListDevicesOutput, bool) bool, ...request.Option) error

	ListDomains(*worklink.ListDomainsInput) (*worklink.ListDomainsOutput, error)
	ListDomainsWithContext(aws.Context, *worklink.ListDomainsInput, ...request.Option) (*worklink.ListDomainsOutput, error)
	ListDomainsRequest(*worklink.ListDomainsInput) (*request.Request, *worklink.ListDomainsOutput)

	ListDomainsPages(*worklink.ListDomainsInput, func(*worklink.ListDomainsOutput, bool) bool) error
	ListDomainsPagesWithContext(aws.Context, *worklink.ListDomainsInput, func(*worklink.ListDomainsOutput, bool) bool, ...request.Option) error

	ListFleets(*worklink.ListFleetsInput) (*worklink.ListFleetsOutput, error)
	ListFleetsWithContext(aws.Context, *worklink.ListFleetsInput, ...request.Option) (*worklink.ListFleetsOutput, error)
	ListFleetsRequest(*worklink.ListFleetsInput) (*request.Request, *worklink.ListFleetsOutput)

	ListFleetsPages(*worklink.ListFleetsInput, func(*worklink.ListFleetsOutput, bool) bool) error
	ListFleetsPagesWithContext(aws.Context, *worklink.ListFleetsInput, func(*worklink.ListFleetsOutput, bool) bool, ...request.Option) error

	ListWebsiteAuthorizationProviders(*worklink.ListWebsiteAuthorizationProvidersInput) (*worklink.ListWebsiteAuthorizationProvidersOutput, error)
	ListWebsiteAuthorizationProvidersWithContext(aws.Context, *worklink.ListWebsiteAuthorizationProvidersInput, ...request.Option) (*worklink.ListWebsiteAuthorizationProvidersOutput, error)
	ListWebsiteAuthorizationProvidersRequest(*worklink.ListWebsiteAuthorizationProvidersInput) (*request.Request, *worklink.ListWebsiteAuthorizationProvidersOutput)

	ListWebsiteAuthorizationProvidersPages(*worklink.ListWebsiteAuthorizationProvidersInput, func(*worklink.ListWebsiteAuthorizationProvidersOutput, bool) bool) error
	ListWebsiteAuthorizationProvidersPagesWithContext(aws.Context, *worklink.ListWebsiteAuthorizationProvidersInput, func(*worklink.ListWebsiteAuthorizationProvidersOutput, bool) bool, ...request.Option) error

	ListWebsiteCertificateAuthorities(*worklink.ListWebsiteCertificateAuthoritiesInput) (*worklink.ListWebsiteCertificateAuthoritiesOutput, error)
	ListWebsiteCertificateAuthoritiesWithContext(aws.Context, *worklink.ListWebsiteCertificateAuthoritiesInput, ...request.Option) (*worklink.ListWebsiteCertificateAuthoritiesOutput, error)
	ListWebsiteCertificateAuthoritiesRequest(*worklink.ListWebsiteCertificateAuthoritiesInput) (*request.Request, *worklink.ListWebsiteCertificateAuthoritiesOutput)

	ListWebsiteCertificateAuthoritiesPages(*worklink.ListWebsiteCertificateAuthoritiesInput, func(*worklink.ListWebsiteCertificateAuthoritiesOutput, bool) bool) error
	ListWebsiteCertificateAuthoritiesPagesWithContext(aws.Context, *worklink.ListWebsiteCertificateAuthoritiesInput, func(*worklink.ListWebsiteCertificateAuthoritiesOutput, bool) bool, ...request.Option) error

	RestoreDomainAccess(*worklink.RestoreDomainAccessInput) (*worklink.RestoreDomainAccessOutput, error)
	RestoreDomainAccessWithContext(aws.Context, *worklink.RestoreDomainAccessInput, ...request.Option) (*worklink.RestoreDomainAccessOutput, error)
	RestoreDomainAccessRequest(*worklink.RestoreDomainAccessInput) (*request.Request, *worklink.RestoreDomainAccessOutput)

	RevokeDomainAccess(*worklink.RevokeDomainAccessInput) (*worklink.RevokeDomainAccessOutput, error)
	RevokeDomainAccessWithContext(aws.Context, *worklink.RevokeDomainAccessInput, ...request.Option) (*worklink.RevokeDomainAccessOutput, error)
	RevokeDomainAccessRequest(*worklink.RevokeDomainAccessInput) (*request.Request, *worklink.RevokeDomainAccessOutput)

	SignOutUser(*worklink.SignOutUserInput) (*worklink.SignOutUserOutput, error)
	SignOutUserWithContext(aws.Context, *worklink.SignOutUserInput, ...request.Option) (*worklink.SignOutUserOutput, error)
	SignOutUserRequest(*worklink.SignOutUserInput) (*request.Request, *worklink.SignOutUserOutput)

	UpdateAuditStreamConfiguration(*worklink.UpdateAuditStreamConfigurationInput) (*worklink.UpdateAuditStreamConfigurationOutput, error)
	UpdateAuditStreamConfigurationWithContext(aws.Context, *worklink.UpdateAuditStreamConfigurationInput, ...request.Option) (*worklink.UpdateAuditStreamConfigurationOutput, error)
	UpdateAuditStreamConfigurationRequest(*worklink.UpdateAuditStreamConfigurationInput) (*request.Request, *worklink.UpdateAuditStreamConfigurationOutput)

	UpdateCompanyNetworkConfiguration(*worklink.UpdateCompanyNetworkConfigurationInput) (*worklink.UpdateCompanyNetworkConfigurationOutput, error)
	UpdateCompanyNetworkConfigurationWithContext(aws.Context, *worklink.UpdateCompanyNetworkConfigurationInput, ...request.Option) (*worklink.UpdateCompanyNetworkConfigurationOutput, error)
	UpdateCompanyNetworkConfigurationRequest(*worklink.UpdateCompanyNetworkConfigurationInput) (*request.Request, *worklink.UpdateCompanyNetworkConfigurationOutput)

	UpdateDevicePolicyConfiguration(*worklink.UpdateDevicePolicyConfigurationInput) (*worklink.UpdateDevicePolicyConfigurationOutput, error)
	UpdateDevicePolicyConfigurationWithContext(aws.Context, *worklink.UpdateDevicePolicyConfigurationInput, ...request.Option) (*worklink.UpdateDevicePolicyConfigurationOutput, error)
	UpdateDevicePolicyConfigurationRequest(*worklink.UpdateDevicePolicyConfigurationInput) (*request.Request, *worklink.UpdateDevicePolicyConfigurationOutput)

	UpdateDomainMetadata(*worklink.UpdateDomainMetadataInput) (*worklink.UpdateDomainMetadataOutput, error)
	UpdateDomainMetadataWithContext(aws.Context, *worklink.UpdateDomainMetadataInput, ...request.Option) (*worklink.UpdateDomainMetadataOutput, error)
	UpdateDomainMetadataRequest(*worklink.UpdateDomainMetadataInput) (*request.Request, *worklink.UpdateDomainMetadataOutput)

	UpdateFleetMetadata(*worklink.UpdateFleetMetadataInput) (*worklink.UpdateFleetMetadataOutput, error)
	UpdateFleetMetadataWithContext(aws.Context, *worklink.UpdateFleetMetadataInput, ...request.Option) (*worklink.UpdateFleetMetadataOutput, error)
	UpdateFleetMetadataRequest(*worklink.UpdateFleetMetadataInput) (*request.Request, *worklink.UpdateFleetMetadataOutput)

	UpdateIdentityProviderConfiguration(*worklink.UpdateIdentityProviderConfigurationInput) (*worklink.UpdateIdentityProviderConfigurationOutput, error)
	UpdateIdentityProviderConfigurationWithContext(aws.Context, *worklink.UpdateIdentityProviderConfigurationInput, ...request.Option) (*worklink.UpdateIdentityProviderConfigurationOutput, error)
	UpdateIdentityProviderConfigurationRequest(*worklink.UpdateIdentityProviderConfigurationInput) (*request.Request, *worklink.UpdateIdentityProviderConfigurationOutput)
}

var _ WorkLinkAPI = (*worklink.WorkLink)(nil)
