// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/securitycenter/v1/securitycenter_service.proto

package securitycenter // import "google.golang.org/genproto/googleapis/cloud/securitycenter/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import duration "github.com/golang/protobuf/ptypes/duration"
import _ "github.com/golang/protobuf/ptypes/empty"
import _struct "github.com/golang/protobuf/ptypes/struct"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import v1 "google.golang.org/genproto/googleapis/iam/v1"
import longrunning "google.golang.org/genproto/googleapis/longrunning"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The change in state of the asset.
//
// When querying across two points in time this describes
// the change between the two points: ADDED, REMOVED, or ACTIVE.
// If there was no compare_duration supplied in the request the state change
// will be: UNUSED
type ListAssetsResponse_ListAssetsResult_StateChange int32

const (
	// State change is unused, this is the canonical default for this enum.
	ListAssetsResponse_ListAssetsResult_UNUSED ListAssetsResponse_ListAssetsResult_StateChange = 0
	// Asset was added between the points in time.
	ListAssetsResponse_ListAssetsResult_ADDED ListAssetsResponse_ListAssetsResult_StateChange = 1
	// Asset was removed between the points in time.
	ListAssetsResponse_ListAssetsResult_REMOVED ListAssetsResponse_ListAssetsResult_StateChange = 2
	// Asset was present at both point(s) in time.
	ListAssetsResponse_ListAssetsResult_ACTIVE ListAssetsResponse_ListAssetsResult_StateChange = 3
)

var ListAssetsResponse_ListAssetsResult_StateChange_name = map[int32]string{
	0: "UNUSED",
	1: "ADDED",
	2: "REMOVED",
	3: "ACTIVE",
}
var ListAssetsResponse_ListAssetsResult_StateChange_value = map[string]int32{
	"UNUSED":  0,
	"ADDED":   1,
	"REMOVED": 2,
	"ACTIVE":  3,
}

func (x ListAssetsResponse_ListAssetsResult_StateChange) String() string {
	return proto.EnumName(ListAssetsResponse_ListAssetsResult_StateChange_name, int32(x))
}
func (ListAssetsResponse_ListAssetsResult_StateChange) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{12, 0, 0}
}

// The change in state of the finding.
//
// When querying across two points in time this describes
// the change in the finding between the two points: CHANGED, UNCHANGED,
// ADDED, or REMOVED. Findings can not be deleted, so REMOVED implies that
// the finding at timestamp does not match the filter specified, but it did
// at timestamp - compare_duration. If there was no compare_duration
// supplied in the request the state change will be: UNUSED
type ListFindingsResponse_ListFindingsResult_StateChange int32

const (
	// State change is unused, this is the canonical default for this enum.
	ListFindingsResponse_ListFindingsResult_UNUSED ListFindingsResponse_ListFindingsResult_StateChange = 0
	// The finding has changed state in some way between the points in time
	// and existed at both points.
	ListFindingsResponse_ListFindingsResult_CHANGED ListFindingsResponse_ListFindingsResult_StateChange = 1
	// The finding has not changed state between the points in time and
	// existed at both points.
	ListFindingsResponse_ListFindingsResult_UNCHANGED ListFindingsResponse_ListFindingsResult_StateChange = 2
	// The finding was created between the points in time.
	ListFindingsResponse_ListFindingsResult_ADDED ListFindingsResponse_ListFindingsResult_StateChange = 3
	// The finding at timestamp does not match the filter specified, but it
	// did at timestamp - compare_duration.
	ListFindingsResponse_ListFindingsResult_REMOVED ListFindingsResponse_ListFindingsResult_StateChange = 4
)

var ListFindingsResponse_ListFindingsResult_StateChange_name = map[int32]string{
	0: "UNUSED",
	1: "CHANGED",
	2: "UNCHANGED",
	3: "ADDED",
	4: "REMOVED",
}
var ListFindingsResponse_ListFindingsResult_StateChange_value = map[string]int32{
	"UNUSED":    0,
	"CHANGED":   1,
	"UNCHANGED": 2,
	"ADDED":     3,
	"REMOVED":   4,
}

func (x ListFindingsResponse_ListFindingsResult_StateChange) String() string {
	return proto.EnumName(ListFindingsResponse_ListFindingsResult_StateChange_name, int32(x))
}
func (ListFindingsResponse_ListFindingsResult_StateChange) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{14, 0, 0}
}

// Request message for creating a finding.
type CreateFindingRequest struct {
	// Resource name of the new finding's parent. Its format should be
	// "organizations/[organization_id]/sources/[source_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Unique identifier provided by the client within the parent scope.
	// It must be alphanumeric and less than or equal to 32 characters and
	// greater than 0 characters in length.
	FindingId string `protobuf:"bytes,2,opt,name=finding_id,json=findingId,proto3" json:"finding_id,omitempty"`
	// The Finding being created. The name and security_marks will be ignored as
	// they are both output only fields on this resource.
	Finding              *Finding `protobuf:"bytes,3,opt,name=finding,proto3" json:"finding,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateFindingRequest) Reset()         { *m = CreateFindingRequest{} }
func (m *CreateFindingRequest) String() string { return proto.CompactTextString(m) }
func (*CreateFindingRequest) ProtoMessage()    {}
func (*CreateFindingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{0}
}
func (m *CreateFindingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateFindingRequest.Unmarshal(m, b)
}
func (m *CreateFindingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateFindingRequest.Marshal(b, m, deterministic)
}
func (dst *CreateFindingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateFindingRequest.Merge(dst, src)
}
func (m *CreateFindingRequest) XXX_Size() int {
	return xxx_messageInfo_CreateFindingRequest.Size(m)
}
func (m *CreateFindingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateFindingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateFindingRequest proto.InternalMessageInfo

func (m *CreateFindingRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateFindingRequest) GetFindingId() string {
	if m != nil {
		return m.FindingId
	}
	return ""
}

func (m *CreateFindingRequest) GetFinding() *Finding {
	if m != nil {
		return m.Finding
	}
	return nil
}

// Request message for creating a source.
type CreateSourceRequest struct {
	// Resource name of the new source's parent. Its format should be
	// "organizations/[organization_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The Source being created, only the display_name and description will be
	// used. All other fields will be ignored.
	Source               *Source  `protobuf:"bytes,2,opt,name=source,proto3" json:"source,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateSourceRequest) Reset()         { *m = CreateSourceRequest{} }
func (m *CreateSourceRequest) String() string { return proto.CompactTextString(m) }
func (*CreateSourceRequest) ProtoMessage()    {}
func (*CreateSourceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{1}
}
func (m *CreateSourceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateSourceRequest.Unmarshal(m, b)
}
func (m *CreateSourceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateSourceRequest.Marshal(b, m, deterministic)
}
func (dst *CreateSourceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateSourceRequest.Merge(dst, src)
}
func (m *CreateSourceRequest) XXX_Size() int {
	return xxx_messageInfo_CreateSourceRequest.Size(m)
}
func (m *CreateSourceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateSourceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateSourceRequest proto.InternalMessageInfo

func (m *CreateSourceRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateSourceRequest) GetSource() *Source {
	if m != nil {
		return m.Source
	}
	return nil
}

// Request message for getting organization settings.
type GetOrganizationSettingsRequest struct {
	// Name of the organization to get organization settings for. Its format is
	// "organizations/[organization_id]/organizationSettings".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetOrganizationSettingsRequest) Reset()         { *m = GetOrganizationSettingsRequest{} }
func (m *GetOrganizationSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*GetOrganizationSettingsRequest) ProtoMessage()    {}
func (*GetOrganizationSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{2}
}
func (m *GetOrganizationSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetOrganizationSettingsRequest.Unmarshal(m, b)
}
func (m *GetOrganizationSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetOrganizationSettingsRequest.Marshal(b, m, deterministic)
}
func (dst *GetOrganizationSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetOrganizationSettingsRequest.Merge(dst, src)
}
func (m *GetOrganizationSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_GetOrganizationSettingsRequest.Size(m)
}
func (m *GetOrganizationSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetOrganizationSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetOrganizationSettingsRequest proto.InternalMessageInfo

func (m *GetOrganizationSettingsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for getting a source.
type GetSourceRequest struct {
	// Relative resource name of the source. Its format is
	// "organizations/[organization_id]/source/[source_id]".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetSourceRequest) Reset()         { *m = GetSourceRequest{} }
func (m *GetSourceRequest) String() string { return proto.CompactTextString(m) }
func (*GetSourceRequest) ProtoMessage()    {}
func (*GetSourceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{3}
}
func (m *GetSourceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetSourceRequest.Unmarshal(m, b)
}
func (m *GetSourceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetSourceRequest.Marshal(b, m, deterministic)
}
func (dst *GetSourceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetSourceRequest.Merge(dst, src)
}
func (m *GetSourceRequest) XXX_Size() int {
	return xxx_messageInfo_GetSourceRequest.Size(m)
}
func (m *GetSourceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetSourceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetSourceRequest proto.InternalMessageInfo

func (m *GetSourceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request message for grouping by assets.
type GroupAssetsRequest struct {
	// Name of the organization to groupBy. Its format is
	// "organizations/[organization_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across assets.
	// The expression is a list of zero or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. The fields map to those
	// defined in the Asset resource. Examples include:
	//
	// * name
	// * security_center_properties.resource_name
	// * resource_properties.a_property
	// * security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following field and operator combinations are supported:
	// name | '='
	// update_time | '>', '<', '>=', '<=', '='
	// create_time | '>', '<', '>=', '<=', '='
	// iam_policy.policy_blob | '=', ':'
	// resource_properties | '=', ':', '>', '<', '>=', '<='
	// security_marks | '=', ':'
	// security_center_properties.resource_name | '=', ':'
	// security_center_properties.resource_type | '=', ':'
	// security_center_properties.resource_parent | '=', ':'
	// security_center_properties.resource_project | '=', ':'
	// security_center_properties.resource_owners | '=', ':'
	//
	// For example, `resource_properties.size = 100` is a valid filter string.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Expression that defines what assets fields to use for grouping. The string
	// value should follow SQL syntax: comma separated list of fields. For
	// example:
	// "security_center_properties.resource_project,security_center_properties.project".
	//
	// The following fields are supported when compare_duration is not set:
	//
	// * security_center_properties.resource_project
	// * security_center_properties.resource_type
	// * security_center_properties.resource_parent
	//
	// The following fields are supported when compare_duration is set:
	//
	// * security_center_properties.resource_type
	GroupBy string `protobuf:"bytes,3,opt,name=group_by,json=groupBy,proto3" json:"group_by,omitempty"`
	// When compare_duration is set, the GroupResult's "state_change" property is
	// updated to indicate whether the asset was added, removed, or remained
	// present during the compare_duration period of time that precedes the
	// read_time. This is the time between (read_time - compare_duration) and
	// read_time.
	//
	// The state change value is derived based on the presence of the asset at the
	// two points in time. Intermediate state changes between the two times don't
	// affect the result. For example, the results aren't affected if the asset is
	// removed and re-created again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	// * "ADDED":   indicates that the asset was not present at the start of
	//                compare_duration, but present at reference_time.
	// * "REMOVED": indicates that the asset was present at the start of
	//                compare_duration, but not present at reference_time.
	// * "ACTIVE":  indicates that the asset was present at both the
	//                start and the end of the time period defined by
	//                compare_duration and reference_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED", which will be the state_change set for all assets present at
	// read_time.
	//
	// If this field is set then `state_change` must be a specified field in
	// `group_by`.
	CompareDuration *duration.Duration `protobuf:"bytes,4,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// Time used as a reference point when filtering assets. The filter is limited
	// to assets existing at the supplied time and their values are those at that
	// specific time. Absence of this field will default to the API's version of
	// NOW.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,5,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// The value returned by the last `GroupAssetsResponse`; indicates
	// that this is a continuation of a prior `GroupAssets` call, and that the
	// system should return the next page of data.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize             int32    `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupAssetsRequest) Reset()         { *m = GroupAssetsRequest{} }
func (m *GroupAssetsRequest) String() string { return proto.CompactTextString(m) }
func (*GroupAssetsRequest) ProtoMessage()    {}
func (*GroupAssetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{4}
}
func (m *GroupAssetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GroupAssetsRequest.Unmarshal(m, b)
}
func (m *GroupAssetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GroupAssetsRequest.Marshal(b, m, deterministic)
}
func (dst *GroupAssetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupAssetsRequest.Merge(dst, src)
}
func (m *GroupAssetsRequest) XXX_Size() int {
	return xxx_messageInfo_GroupAssetsRequest.Size(m)
}
func (m *GroupAssetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupAssetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GroupAssetsRequest proto.InternalMessageInfo

func (m *GroupAssetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *GroupAssetsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *GroupAssetsRequest) GetGroupBy() string {
	if m != nil {
		return m.GroupBy
	}
	return ""
}

func (m *GroupAssetsRequest) GetCompareDuration() *duration.Duration {
	if m != nil {
		return m.CompareDuration
	}
	return nil
}

func (m *GroupAssetsRequest) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *GroupAssetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *GroupAssetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for grouping by assets.
type GroupAssetsResponse struct {
	// Group results. There exists an element for each existing unique
	// combination of property/values. The element contains a count for the number
	// of times those specific property/values appear.
	GroupByResults []*GroupResult `protobuf:"bytes,1,rep,name=group_by_results,json=groupByResults,proto3" json:"group_by_results,omitempty"`
	// Time used for executing the groupBy request.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of results matching the query.
	TotalSize            int32    `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupAssetsResponse) Reset()         { *m = GroupAssetsResponse{} }
func (m *GroupAssetsResponse) String() string { return proto.CompactTextString(m) }
func (*GroupAssetsResponse) ProtoMessage()    {}
func (*GroupAssetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{5}
}
func (m *GroupAssetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GroupAssetsResponse.Unmarshal(m, b)
}
func (m *GroupAssetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GroupAssetsResponse.Marshal(b, m, deterministic)
}
func (dst *GroupAssetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupAssetsResponse.Merge(dst, src)
}
func (m *GroupAssetsResponse) XXX_Size() int {
	return xxx_messageInfo_GroupAssetsResponse.Size(m)
}
func (m *GroupAssetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupAssetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GroupAssetsResponse proto.InternalMessageInfo

func (m *GroupAssetsResponse) GetGroupByResults() []*GroupResult {
	if m != nil {
		return m.GroupByResults
	}
	return nil
}

func (m *GroupAssetsResponse) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *GroupAssetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *GroupAssetsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Request message for grouping by findings.
type GroupFindingsRequest struct {
	// Name of the source to groupBy. Its format is
	// "organizations/[organization_id]/sources/[source_id]". To groupBy across
	// all sources provide a source_id of `-`. For example:
	// organizations/123/sources/-
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across findings.
	// The expression is a list of one or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. Examples include:
	//
	//  * name
	//  * source_properties.a_property
	//  * security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following field and operator combinations are supported:
	// name | `=`
	// parent | '=', ':'
	// resource_name | '=', ':'
	// state | '=', ':'
	// category | '=', ':'
	// external_uri | '=', ':'
	// event_time | `>`, `<`, `>=`, `<=`
	// security_marks | '=', ':'
	// source_properties | '=', ':', `>`, `<`, `>=`, `<=`
	//
	// For example, `source_properties.size = 100` is a valid filter string.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Expression that defines what assets fields to use for grouping (including
	// `state_change`). The string value should follow SQL syntax: comma separated
	// list of fields. For example: "parent,resource_name".
	//
	// The following fields are supported:
	//
	// * resource_name
	// * category
	// * state
	// * parent
	//
	// The following fields are supported when compare_duration is set:
	//
	// * state_change
	GroupBy string `protobuf:"bytes,3,opt,name=group_by,json=groupBy,proto3" json:"group_by,omitempty"`
	// Time used as a reference point when filtering findings. The filter is
	// limited to findings existing at the supplied time and their values are
	// those at that specific time. Absence of this field will default to the
	// API's version of NOW.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// When compare_duration is set, the GroupResult's "state_change" attribute is
	// updated to indicate whether the finding had its state changed, the
	// finding's state remained unchanged, or if the finding was added during the
	// compare_duration period of time that precedes the read_time. This is the
	// time between (read_time - compare_duration) and read_time.
	//
	// The state_change value is derived based on the presence and state of the
	// finding at the two points in time. Intermediate state changes between the
	// two times don't affect the result. For example, the results aren't affected
	// if the finding is made inactive and then active again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	// * "CHANGED":   indicates that the finding was present at the start of
	//                  compare_duration, but changed its state at read_time.
	// * "UNCHANGED": indicates that the finding was present at the start of
	//                  compare_duration and did not change state at read_time.
	// * "ADDED":     indicates that the finding was not present at the start
	//                  of compare_duration, but was present at read_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED",  which will be the state_change set for all findings present
	// at read_time.
	//
	// If this field is set then `state_change` must be a specified field in
	// `group_by`.
	CompareDuration *duration.Duration `protobuf:"bytes,5,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// The value returned by the last `GroupFindingsResponse`; indicates
	// that this is a continuation of a prior `GroupFindings` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize             int32    `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupFindingsRequest) Reset()         { *m = GroupFindingsRequest{} }
func (m *GroupFindingsRequest) String() string { return proto.CompactTextString(m) }
func (*GroupFindingsRequest) ProtoMessage()    {}
func (*GroupFindingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{6}
}
func (m *GroupFindingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GroupFindingsRequest.Unmarshal(m, b)
}
func (m *GroupFindingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GroupFindingsRequest.Marshal(b, m, deterministic)
}
func (dst *GroupFindingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupFindingsRequest.Merge(dst, src)
}
func (m *GroupFindingsRequest) XXX_Size() int {
	return xxx_messageInfo_GroupFindingsRequest.Size(m)
}
func (m *GroupFindingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupFindingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GroupFindingsRequest proto.InternalMessageInfo

func (m *GroupFindingsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *GroupFindingsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *GroupFindingsRequest) GetGroupBy() string {
	if m != nil {
		return m.GroupBy
	}
	return ""
}

func (m *GroupFindingsRequest) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *GroupFindingsRequest) GetCompareDuration() *duration.Duration {
	if m != nil {
		return m.CompareDuration
	}
	return nil
}

func (m *GroupFindingsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *GroupFindingsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for group by findings.
type GroupFindingsResponse struct {
	// Group results. There exists an element for each existing unique
	// combination of property/values. The element contains a count for the number
	// of times those specific property/values appear.
	GroupByResults []*GroupResult `protobuf:"bytes,1,rep,name=group_by_results,json=groupByResults,proto3" json:"group_by_results,omitempty"`
	// Time used for executing the groupBy request.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of results matching the query.
	TotalSize            int32    `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupFindingsResponse) Reset()         { *m = GroupFindingsResponse{} }
func (m *GroupFindingsResponse) String() string { return proto.CompactTextString(m) }
func (*GroupFindingsResponse) ProtoMessage()    {}
func (*GroupFindingsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{7}
}
func (m *GroupFindingsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GroupFindingsResponse.Unmarshal(m, b)
}
func (m *GroupFindingsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GroupFindingsResponse.Marshal(b, m, deterministic)
}
func (dst *GroupFindingsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupFindingsResponse.Merge(dst, src)
}
func (m *GroupFindingsResponse) XXX_Size() int {
	return xxx_messageInfo_GroupFindingsResponse.Size(m)
}
func (m *GroupFindingsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupFindingsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GroupFindingsResponse proto.InternalMessageInfo

func (m *GroupFindingsResponse) GetGroupByResults() []*GroupResult {
	if m != nil {
		return m.GroupByResults
	}
	return nil
}

func (m *GroupFindingsResponse) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *GroupFindingsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *GroupFindingsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Result containing the properties and count of a groupBy request.
type GroupResult struct {
	// Properties matching the groupBy fields in the request.
	Properties map[string]*_struct.Value `protobuf:"bytes,1,rep,name=properties,proto3" json:"properties,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Total count of resources for the given properties.
	Count                int64    `protobuf:"varint,2,opt,name=count,proto3" json:"count,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GroupResult) Reset()         { *m = GroupResult{} }
func (m *GroupResult) String() string { return proto.CompactTextString(m) }
func (*GroupResult) ProtoMessage()    {}
func (*GroupResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{8}
}
func (m *GroupResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GroupResult.Unmarshal(m, b)
}
func (m *GroupResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GroupResult.Marshal(b, m, deterministic)
}
func (dst *GroupResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GroupResult.Merge(dst, src)
}
func (m *GroupResult) XXX_Size() int {
	return xxx_messageInfo_GroupResult.Size(m)
}
func (m *GroupResult) XXX_DiscardUnknown() {
	xxx_messageInfo_GroupResult.DiscardUnknown(m)
}

var xxx_messageInfo_GroupResult proto.InternalMessageInfo

func (m *GroupResult) GetProperties() map[string]*_struct.Value {
	if m != nil {
		return m.Properties
	}
	return nil
}

func (m *GroupResult) GetCount() int64 {
	if m != nil {
		return m.Count
	}
	return 0
}

// Request message for listing sources.
type ListSourcesRequest struct {
	// Resource name of the parent of sources to list. Its format should be
	// "organizations/[organization_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The value returned by the last `ListSourcesResponse`; indicates
	// that this is a continuation of a prior `ListSources` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize             int32    `protobuf:"varint,7,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSourcesRequest) Reset()         { *m = ListSourcesRequest{} }
func (m *ListSourcesRequest) String() string { return proto.CompactTextString(m) }
func (*ListSourcesRequest) ProtoMessage()    {}
func (*ListSourcesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{9}
}
func (m *ListSourcesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSourcesRequest.Unmarshal(m, b)
}
func (m *ListSourcesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSourcesRequest.Marshal(b, m, deterministic)
}
func (dst *ListSourcesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSourcesRequest.Merge(dst, src)
}
func (m *ListSourcesRequest) XXX_Size() int {
	return xxx_messageInfo_ListSourcesRequest.Size(m)
}
func (m *ListSourcesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSourcesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListSourcesRequest proto.InternalMessageInfo

func (m *ListSourcesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListSourcesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListSourcesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for listing sources.
type ListSourcesResponse struct {
	// Sources belonging to the requested parent.
	Sources []*Source `protobuf:"bytes,1,rep,name=sources,proto3" json:"sources,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListSourcesResponse) Reset()         { *m = ListSourcesResponse{} }
func (m *ListSourcesResponse) String() string { return proto.CompactTextString(m) }
func (*ListSourcesResponse) ProtoMessage()    {}
func (*ListSourcesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{10}
}
func (m *ListSourcesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListSourcesResponse.Unmarshal(m, b)
}
func (m *ListSourcesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListSourcesResponse.Marshal(b, m, deterministic)
}
func (dst *ListSourcesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListSourcesResponse.Merge(dst, src)
}
func (m *ListSourcesResponse) XXX_Size() int {
	return xxx_messageInfo_ListSourcesResponse.Size(m)
}
func (m *ListSourcesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListSourcesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListSourcesResponse proto.InternalMessageInfo

func (m *ListSourcesResponse) GetSources() []*Source {
	if m != nil {
		return m.Sources
	}
	return nil
}

func (m *ListSourcesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Request message for listing assets.
type ListAssetsRequest struct {
	// Name of the organization assets should belong to. Its format is
	// "organizations/[organization_id]".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across assets.
	// The expression is a list of zero or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. The fields map to those
	// defined in the Asset resource. Examples include:
	//
	// * name
	// * security_center_properties.resource_name
	// * resource_properties.a_property
	// * security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following are the allowed field and operator combinations:
	// name | `=`
	// update_time | `>`, `<`, `>=`, `<=`
	// iam_policy.policy_blob | '=', ':'
	// resource_properties | '=', ':', `>`, `<`, `>=`, `<=`
	// security_marks | '=', ':'
	// security_center_properties.resource_name | '=', ':'
	// security_center_properties.resource_type | '=', ':'
	// security_center_properties.resource_parent | '=', ':'
	// security_center_properties.resource_project | '=', ':'
	// security_center_properties.resource_owners | '=', ':'
	//
	// For example, `resource_properties.size = 100` is a valid filter string.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Expression that defines what fields and order to use for sorting. The
	// string value should follow SQL syntax: comma separated list of fields. For
	// example: "name,resource_properties.a_property". The default sorting order
	// is ascending. To specify descending order for a field, a suffix " desc"
	// should be appended to the field name. For example: "name
	// desc,resource_properties.a_property". Redundant space characters in the
	// syntax are insignificant. "name desc,resource_properties.a_property" and "
	// name     desc  ,   resource_properties.a_property  " are equivalent.
	//
	// The following fields are supported:
	// name
	// update_time
	// resource_properties
	// security_marks
	// security_center_properties.resource_name
	// security_center_properties.resource_parent
	// security_center_properties.resource_project
	// security_center_properties.resource_type
	OrderBy string `protobuf:"bytes,3,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Time used as a reference point when filtering assets. The filter is limited
	// to assets existing at the supplied time and their values are those at that
	// specific time. Absence of this field will default to the API's version of
	// NOW.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// When compare_duration is set, the ListAssetsResult's "state_change"
	// attribute is updated to indicate whether the asset was added, removed, or
	// remained present during the compare_duration period of time that precedes
	// the read_time. This is the time between (read_time - compare_duration) and
	// read_time.
	//
	// The state_change value is derived based on the presence of the asset at the
	// two points in time. Intermediate state changes between the two times don't
	// affect the result. For example, the results aren't affected if the asset is
	// removed and re-created again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	// * "ADDED":   indicates that the asset was not present at the start of
	//                compare_duration, but present at read_time.
	// * "REMOVED": indicates that the asset was present at the start of
	//                compare_duration, but not present at read_time.
	// * "ACTIVE":  indicates that the asset was present at both the
	//                start and the end of the time period defined by
	//                compare_duration and read_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED",  which will be the state_change set for all assets present at
	// read_time.
	CompareDuration *duration.Duration `protobuf:"bytes,5,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// Optional.
	//
	// A field mask to specify the ListAssetsResult fields to be listed in the
	// response.
	// An empty field mask will list all fields.
	FieldMask *field_mask.FieldMask `protobuf:"bytes,7,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// The value returned by the last `ListAssetsResponse`; indicates
	// that this is a continuation of a prior `ListAssets` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,8,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize             int32    `protobuf:"varint,9,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAssetsRequest) Reset()         { *m = ListAssetsRequest{} }
func (m *ListAssetsRequest) String() string { return proto.CompactTextString(m) }
func (*ListAssetsRequest) ProtoMessage()    {}
func (*ListAssetsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{11}
}
func (m *ListAssetsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAssetsRequest.Unmarshal(m, b)
}
func (m *ListAssetsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAssetsRequest.Marshal(b, m, deterministic)
}
func (dst *ListAssetsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAssetsRequest.Merge(dst, src)
}
func (m *ListAssetsRequest) XXX_Size() int {
	return xxx_messageInfo_ListAssetsRequest.Size(m)
}
func (m *ListAssetsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAssetsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListAssetsRequest proto.InternalMessageInfo

func (m *ListAssetsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListAssetsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListAssetsRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

func (m *ListAssetsRequest) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *ListAssetsRequest) GetCompareDuration() *duration.Duration {
	if m != nil {
		return m.CompareDuration
	}
	return nil
}

func (m *ListAssetsRequest) GetFieldMask() *field_mask.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

func (m *ListAssetsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListAssetsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for listing assets.
type ListAssetsResponse struct {
	// Assets matching the list request.
	ListAssetsResults []*ListAssetsResponse_ListAssetsResult `protobuf:"bytes,1,rep,name=list_assets_results,json=listAssetsResults,proto3" json:"list_assets_results,omitempty"`
	// Time used for executing the list request.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of assets matching the query.
	TotalSize            int32    `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListAssetsResponse) Reset()         { *m = ListAssetsResponse{} }
func (m *ListAssetsResponse) String() string { return proto.CompactTextString(m) }
func (*ListAssetsResponse) ProtoMessage()    {}
func (*ListAssetsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{12}
}
func (m *ListAssetsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAssetsResponse.Unmarshal(m, b)
}
func (m *ListAssetsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAssetsResponse.Marshal(b, m, deterministic)
}
func (dst *ListAssetsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAssetsResponse.Merge(dst, src)
}
func (m *ListAssetsResponse) XXX_Size() int {
	return xxx_messageInfo_ListAssetsResponse.Size(m)
}
func (m *ListAssetsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAssetsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListAssetsResponse proto.InternalMessageInfo

func (m *ListAssetsResponse) GetListAssetsResults() []*ListAssetsResponse_ListAssetsResult {
	if m != nil {
		return m.ListAssetsResults
	}
	return nil
}

func (m *ListAssetsResponse) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *ListAssetsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListAssetsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Result containing the Asset and its State.
type ListAssetsResponse_ListAssetsResult struct {
	// Asset matching the search request.
	Asset *Asset `protobuf:"bytes,1,opt,name=asset,proto3" json:"asset,omitempty"`
	// State change of the asset between the points in time.
	StateChange          ListAssetsResponse_ListAssetsResult_StateChange `protobuf:"varint,2,opt,name=state_change,json=stateChange,proto3,enum=google.cloud.securitycenter.v1.ListAssetsResponse_ListAssetsResult_StateChange" json:"state_change,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                        `json:"-"`
	XXX_unrecognized     []byte                                          `json:"-"`
	XXX_sizecache        int32                                           `json:"-"`
}

func (m *ListAssetsResponse_ListAssetsResult) Reset()         { *m = ListAssetsResponse_ListAssetsResult{} }
func (m *ListAssetsResponse_ListAssetsResult) String() string { return proto.CompactTextString(m) }
func (*ListAssetsResponse_ListAssetsResult) ProtoMessage()    {}
func (*ListAssetsResponse_ListAssetsResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{12, 0}
}
func (m *ListAssetsResponse_ListAssetsResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListAssetsResponse_ListAssetsResult.Unmarshal(m, b)
}
func (m *ListAssetsResponse_ListAssetsResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListAssetsResponse_ListAssetsResult.Marshal(b, m, deterministic)
}
func (dst *ListAssetsResponse_ListAssetsResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListAssetsResponse_ListAssetsResult.Merge(dst, src)
}
func (m *ListAssetsResponse_ListAssetsResult) XXX_Size() int {
	return xxx_messageInfo_ListAssetsResponse_ListAssetsResult.Size(m)
}
func (m *ListAssetsResponse_ListAssetsResult) XXX_DiscardUnknown() {
	xxx_messageInfo_ListAssetsResponse_ListAssetsResult.DiscardUnknown(m)
}

var xxx_messageInfo_ListAssetsResponse_ListAssetsResult proto.InternalMessageInfo

func (m *ListAssetsResponse_ListAssetsResult) GetAsset() *Asset {
	if m != nil {
		return m.Asset
	}
	return nil
}

func (m *ListAssetsResponse_ListAssetsResult) GetStateChange() ListAssetsResponse_ListAssetsResult_StateChange {
	if m != nil {
		return m.StateChange
	}
	return ListAssetsResponse_ListAssetsResult_UNUSED
}

// Request message for listing findings.
type ListFindingsRequest struct {
	// Name of the source the findings belong to. Its format is
	// "organizations/[organization_id]/sources/[source_id]". To list across all
	// sources provide a source_id of `-`. For example:
	// organizations/123/sources/-
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Expression that defines the filter to apply across findings.
	// The expression is a list of one or more restrictions combined via logical
	// operators `AND` and `OR`.
	// Parentheses are supported, and `OR` has higher precedence than `AND`.
	//
	// Restrictions have the form `<field> <operator> <value>` and may have a `-`
	// character in front of them to indicate negation. Examples include:
	//
	//  * name
	//  * source_properties.a_property
	//  * security_marks.marks.marka
	//
	// The supported operators are:
	//
	// * `=` for all value types.
	// * `>`, `<`, `>=`, `<=` for integer values.
	// * `:`, meaning substring matching, for strings.
	//
	// The supported value types are:
	//
	// * string literals in quotes.
	// * integer literals without quotes.
	// * boolean literals `true` and `false` without quotes.
	//
	// The following field and operator combinations are supported:
	// name | `=`
	// parent | '=', ':'
	// resource_name | '=', ':'
	// state | '=', ':'
	// category | '=', ':'
	// external_uri | '=', ':'
	// event_time | `>`, `<`, `>=`, `<=`
	// security_marks | '=', ':'
	// source_properties | '=', ':', `>`, `<`, `>=`, `<=`
	//
	// For example, `source_properties.size = 100` is a valid filter string.
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Expression that defines what fields and order to use for sorting. The
	// string value should follow SQL syntax: comma separated list of fields. For
	// example: "name,resource_properties.a_property". The default sorting order
	// is ascending. To specify descending order for a field, a suffix " desc"
	// should be appended to the field name. For example: "name
	// desc,source_properties.a_property". Redundant space characters in the
	// syntax are insignificant. "name desc,source_properties.a_property" and "
	// name     desc  ,   source_properties.a_property  " are equivalent.
	//
	// The following fields are supported:
	// name
	// parent
	// state
	// category
	// resource_name
	// event_time
	// source_properties
	// security_marks
	OrderBy string `protobuf:"bytes,3,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Time used as a reference point when filtering findings. The filter is
	// limited to findings existing at the supplied time and their values are
	// those at that specific time. Absence of this field will default to the
	// API's version of NOW.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// When compare_duration is set, the ListFindingsResult's "state_change"
	// attribute is updated to indicate whether the finding had its state changed,
	// the finding's state remained unchanged, or if the finding was added in any
	// state during the compare_duration period of time that precedes the
	// read_time. This is the time between (read_time - compare_duration) and
	// read_time.
	//
	// The state_change value is derived based on the presence and state of the
	// finding at the two points in time. Intermediate state changes between the
	// two times don't affect the result. For example, the results aren't affected
	// if the finding is made inactive and then active again.
	//
	// Possible "state_change" values when compare_duration is specified:
	//
	// * "CHANGED":   indicates that the finding was present at the start of
	//                  compare_duration, but changed its state at read_time.
	// * "UNCHANGED": indicates that the finding was present at the start of
	//                  compare_duration and did not change state at read_time.
	// * "ADDED":     indicates that the finding was not present at the start
	//                  of compare_duration, but was present at read_time.
	//
	// If compare_duration is not specified, then the only possible state_change
	// is "UNUSED", which will be the state_change set for all findings present at
	// read_time.
	CompareDuration *duration.Duration `protobuf:"bytes,5,opt,name=compare_duration,json=compareDuration,proto3" json:"compare_duration,omitempty"`
	// Optional.
	//
	// A field mask to specify the Finding fields to be listed in the response.
	// An empty field mask will list all fields.
	FieldMask *field_mask.FieldMask `protobuf:"bytes,7,opt,name=field_mask,json=fieldMask,proto3" json:"field_mask,omitempty"`
	// The value returned by the last `ListFindingsResponse`; indicates
	// that this is a continuation of a prior `ListFindings` call, and
	// that the system should return the next page of data.
	PageToken string `protobuf:"bytes,8,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single response. Default is
	// 10, minimum is 1, maximum is 1000.
	PageSize             int32    `protobuf:"varint,9,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFindingsRequest) Reset()         { *m = ListFindingsRequest{} }
func (m *ListFindingsRequest) String() string { return proto.CompactTextString(m) }
func (*ListFindingsRequest) ProtoMessage()    {}
func (*ListFindingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{13}
}
func (m *ListFindingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFindingsRequest.Unmarshal(m, b)
}
func (m *ListFindingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFindingsRequest.Marshal(b, m, deterministic)
}
func (dst *ListFindingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFindingsRequest.Merge(dst, src)
}
func (m *ListFindingsRequest) XXX_Size() int {
	return xxx_messageInfo_ListFindingsRequest.Size(m)
}
func (m *ListFindingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFindingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListFindingsRequest proto.InternalMessageInfo

func (m *ListFindingsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListFindingsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListFindingsRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

func (m *ListFindingsRequest) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *ListFindingsRequest) GetCompareDuration() *duration.Duration {
	if m != nil {
		return m.CompareDuration
	}
	return nil
}

func (m *ListFindingsRequest) GetFieldMask() *field_mask.FieldMask {
	if m != nil {
		return m.FieldMask
	}
	return nil
}

func (m *ListFindingsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListFindingsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Response message for listing findings.
type ListFindingsResponse struct {
	// Findings matching the list request.
	ListFindingsResults []*ListFindingsResponse_ListFindingsResult `protobuf:"bytes,1,rep,name=list_findings_results,json=listFindingsResults,proto3" json:"list_findings_results,omitempty"`
	// Time used for executing the list request.
	ReadTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=read_time,json=readTime,proto3" json:"read_time,omitempty"`
	// Token to retrieve the next page of results, or empty if there are no more
	// results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The total number of findings matching the query.
	TotalSize            int32    `protobuf:"varint,4,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListFindingsResponse) Reset()         { *m = ListFindingsResponse{} }
func (m *ListFindingsResponse) String() string { return proto.CompactTextString(m) }
func (*ListFindingsResponse) ProtoMessage()    {}
func (*ListFindingsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{14}
}
func (m *ListFindingsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFindingsResponse.Unmarshal(m, b)
}
func (m *ListFindingsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFindingsResponse.Marshal(b, m, deterministic)
}
func (dst *ListFindingsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFindingsResponse.Merge(dst, src)
}
func (m *ListFindingsResponse) XXX_Size() int {
	return xxx_messageInfo_ListFindingsResponse.Size(m)
}
func (m *ListFindingsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFindingsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListFindingsResponse proto.InternalMessageInfo

func (m *ListFindingsResponse) GetListFindingsResults() []*ListFindingsResponse_ListFindingsResult {
	if m != nil {
		return m.ListFindingsResults
	}
	return nil
}

func (m *ListFindingsResponse) GetReadTime() *timestamp.Timestamp {
	if m != nil {
		return m.ReadTime
	}
	return nil
}

func (m *ListFindingsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListFindingsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

// Result containing the Finding and its StateChange.
type ListFindingsResponse_ListFindingsResult struct {
	// Finding matching the search request.
	Finding *Finding `protobuf:"bytes,1,opt,name=finding,proto3" json:"finding,omitempty"`
	// State change of the finding between the points in time.
	StateChange          ListFindingsResponse_ListFindingsResult_StateChange `protobuf:"varint,2,opt,name=state_change,json=stateChange,proto3,enum=google.cloud.securitycenter.v1.ListFindingsResponse_ListFindingsResult_StateChange" json:"state_change,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_unrecognized     []byte                                              `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *ListFindingsResponse_ListFindingsResult) Reset() {
	*m = ListFindingsResponse_ListFindingsResult{}
}
func (m *ListFindingsResponse_ListFindingsResult) String() string { return proto.CompactTextString(m) }
func (*ListFindingsResponse_ListFindingsResult) ProtoMessage()    {}
func (*ListFindingsResponse_ListFindingsResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{14, 0}
}
func (m *ListFindingsResponse_ListFindingsResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListFindingsResponse_ListFindingsResult.Unmarshal(m, b)
}
func (m *ListFindingsResponse_ListFindingsResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListFindingsResponse_ListFindingsResult.Marshal(b, m, deterministic)
}
func (dst *ListFindingsResponse_ListFindingsResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListFindingsResponse_ListFindingsResult.Merge(dst, src)
}
func (m *ListFindingsResponse_ListFindingsResult) XXX_Size() int {
	return xxx_messageInfo_ListFindingsResponse_ListFindingsResult.Size(m)
}
func (m *ListFindingsResponse_ListFindingsResult) XXX_DiscardUnknown() {
	xxx_messageInfo_ListFindingsResponse_ListFindingsResult.DiscardUnknown(m)
}

var xxx_messageInfo_ListFindingsResponse_ListFindingsResult proto.InternalMessageInfo

func (m *ListFindingsResponse_ListFindingsResult) GetFinding() *Finding {
	if m != nil {
		return m.Finding
	}
	return nil
}

func (m *ListFindingsResponse_ListFindingsResult) GetStateChange() ListFindingsResponse_ListFindingsResult_StateChange {
	if m != nil {
		return m.StateChange
	}
	return ListFindingsResponse_ListFindingsResult_UNUSED
}

// Request message for updating a finding's state.
type SetFindingStateRequest struct {
	// The relative resource name of the finding. See:
	// https://cloud.google.com/apis/design/resource_names#relative_resource_name
	// Example:
	// "organizations/123/sources/456/finding/789".
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// The desired State of the finding.
	State Finding_State `protobuf:"varint,2,opt,name=state,proto3,enum=google.cloud.securitycenter.v1.Finding_State" json:"state,omitempty"`
	// The time at which the updated state takes effect.
	StartTime            *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *SetFindingStateRequest) Reset()         { *m = SetFindingStateRequest{} }
func (m *SetFindingStateRequest) String() string { return proto.CompactTextString(m) }
func (*SetFindingStateRequest) ProtoMessage()    {}
func (*SetFindingStateRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{15}
}
func (m *SetFindingStateRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SetFindingStateRequest.Unmarshal(m, b)
}
func (m *SetFindingStateRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SetFindingStateRequest.Marshal(b, m, deterministic)
}
func (dst *SetFindingStateRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SetFindingStateRequest.Merge(dst, src)
}
func (m *SetFindingStateRequest) XXX_Size() int {
	return xxx_messageInfo_SetFindingStateRequest.Size(m)
}
func (m *SetFindingStateRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SetFindingStateRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SetFindingStateRequest proto.InternalMessageInfo

func (m *SetFindingStateRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *SetFindingStateRequest) GetState() Finding_State {
	if m != nil {
		return m.State
	}
	return Finding_STATE_UNSPECIFIED
}

func (m *SetFindingStateRequest) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

// Request message for running asset discovery for an organization.
type RunAssetDiscoveryRequest struct {
	// Name of the organization to run asset discovery for. Its format is
	// "organizations/[organization_id]".
	Parent               string   `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RunAssetDiscoveryRequest) Reset()         { *m = RunAssetDiscoveryRequest{} }
func (m *RunAssetDiscoveryRequest) String() string { return proto.CompactTextString(m) }
func (*RunAssetDiscoveryRequest) ProtoMessage()    {}
func (*RunAssetDiscoveryRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{16}
}
func (m *RunAssetDiscoveryRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RunAssetDiscoveryRequest.Unmarshal(m, b)
}
func (m *RunAssetDiscoveryRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RunAssetDiscoveryRequest.Marshal(b, m, deterministic)
}
func (dst *RunAssetDiscoveryRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RunAssetDiscoveryRequest.Merge(dst, src)
}
func (m *RunAssetDiscoveryRequest) XXX_Size() int {
	return xxx_messageInfo_RunAssetDiscoveryRequest.Size(m)
}
func (m *RunAssetDiscoveryRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_RunAssetDiscoveryRequest.DiscardUnknown(m)
}

var xxx_messageInfo_RunAssetDiscoveryRequest proto.InternalMessageInfo

func (m *RunAssetDiscoveryRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

// Request message for updating or creating a finding.
type UpdateFindingRequest struct {
	// The finding resource to update or create if it does not already exist.
	// parent, security_marks, and update_time will be ignored.
	//
	// In the case of creation, the finding id portion of the name must be
	// alphanumeric and less than or equal to 32 characters and greater than 0
	// characters in length.
	Finding *Finding `protobuf:"bytes,1,opt,name=finding,proto3" json:"finding,omitempty"`
	// The FieldMask to use when updating the finding resource. This field should
	// not be specified when creating a finding.
	//
	// When updating a finding, an empty mask is treated as updating all mutable
	// fields and replacing source_properties.  Individual source_properties can
	// be added/updated by using "source_properties.<property key>" in the field
	// mask.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateFindingRequest) Reset()         { *m = UpdateFindingRequest{} }
func (m *UpdateFindingRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateFindingRequest) ProtoMessage()    {}
func (*UpdateFindingRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{17}
}
func (m *UpdateFindingRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateFindingRequest.Unmarshal(m, b)
}
func (m *UpdateFindingRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateFindingRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateFindingRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateFindingRequest.Merge(dst, src)
}
func (m *UpdateFindingRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateFindingRequest.Size(m)
}
func (m *UpdateFindingRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateFindingRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateFindingRequest proto.InternalMessageInfo

func (m *UpdateFindingRequest) GetFinding() *Finding {
	if m != nil {
		return m.Finding
	}
	return nil
}

func (m *UpdateFindingRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for updating an organization's settings.
type UpdateOrganizationSettingsRequest struct {
	// The organization settings resource to update.
	OrganizationSettings *OrganizationSettings `protobuf:"bytes,1,opt,name=organization_settings,json=organizationSettings,proto3" json:"organization_settings,omitempty"`
	// The FieldMask to use when updating the settings resource.
	//
	//  If empty all mutable fields will be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateOrganizationSettingsRequest) Reset()         { *m = UpdateOrganizationSettingsRequest{} }
func (m *UpdateOrganizationSettingsRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateOrganizationSettingsRequest) ProtoMessage()    {}
func (*UpdateOrganizationSettingsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{18}
}
func (m *UpdateOrganizationSettingsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateOrganizationSettingsRequest.Unmarshal(m, b)
}
func (m *UpdateOrganizationSettingsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateOrganizationSettingsRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateOrganizationSettingsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateOrganizationSettingsRequest.Merge(dst, src)
}
func (m *UpdateOrganizationSettingsRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateOrganizationSettingsRequest.Size(m)
}
func (m *UpdateOrganizationSettingsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateOrganizationSettingsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateOrganizationSettingsRequest proto.InternalMessageInfo

func (m *UpdateOrganizationSettingsRequest) GetOrganizationSettings() *OrganizationSettings {
	if m != nil {
		return m.OrganizationSettings
	}
	return nil
}

func (m *UpdateOrganizationSettingsRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for updating a source.
type UpdateSourceRequest struct {
	// The source resource to update.
	Source *Source `protobuf:"bytes,1,opt,name=source,proto3" json:"source,omitempty"`
	// The FieldMask to use when updating the source resource.
	//
	// If empty all mutable fields will be updated.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateSourceRequest) Reset()         { *m = UpdateSourceRequest{} }
func (m *UpdateSourceRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSourceRequest) ProtoMessage()    {}
func (*UpdateSourceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{19}
}
func (m *UpdateSourceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSourceRequest.Unmarshal(m, b)
}
func (m *UpdateSourceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSourceRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateSourceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSourceRequest.Merge(dst, src)
}
func (m *UpdateSourceRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSourceRequest.Size(m)
}
func (m *UpdateSourceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSourceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSourceRequest proto.InternalMessageInfo

func (m *UpdateSourceRequest) GetSource() *Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *UpdateSourceRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Request message for updating a SecurityMarks resource.
type UpdateSecurityMarksRequest struct {
	// The security marks resource to update.
	SecurityMarks *SecurityMarks `protobuf:"bytes,1,opt,name=security_marks,json=securityMarks,proto3" json:"security_marks,omitempty"`
	// The FieldMask to use when updating the security marks resource.
	//
	// The field mask must not contain duplicate fields.
	// If empty or set to "marks", all marks will be replaced.  Individual
	// marks can be updated using "marks.<mark_key>".
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The time at which the updated SecurityMarks take effect.
	// If not set uses current server time.  Updates will be applied to the
	// SecurityMarks that are active immediately preceding this time.
	StartTime            *timestamp.Timestamp `protobuf:"bytes,3,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *UpdateSecurityMarksRequest) Reset()         { *m = UpdateSecurityMarksRequest{} }
func (m *UpdateSecurityMarksRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateSecurityMarksRequest) ProtoMessage()    {}
func (*UpdateSecurityMarksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_securitycenter_service_0a41679950f5c36f, []int{20}
}
func (m *UpdateSecurityMarksRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateSecurityMarksRequest.Unmarshal(m, b)
}
func (m *UpdateSecurityMarksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateSecurityMarksRequest.Marshal(b, m, deterministic)
}
func (dst *UpdateSecurityMarksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateSecurityMarksRequest.Merge(dst, src)
}
func (m *UpdateSecurityMarksRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateSecurityMarksRequest.Size(m)
}
func (m *UpdateSecurityMarksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateSecurityMarksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateSecurityMarksRequest proto.InternalMessageInfo

func (m *UpdateSecurityMarksRequest) GetSecurityMarks() *SecurityMarks {
	if m != nil {
		return m.SecurityMarks
	}
	return nil
}

func (m *UpdateSecurityMarksRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateSecurityMarksRequest) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateFindingRequest)(nil), "google.cloud.securitycenter.v1.CreateFindingRequest")
	proto.RegisterType((*CreateSourceRequest)(nil), "google.cloud.securitycenter.v1.CreateSourceRequest")
	proto.RegisterType((*GetOrganizationSettingsRequest)(nil), "google.cloud.securitycenter.v1.GetOrganizationSettingsRequest")
	proto.RegisterType((*GetSourceRequest)(nil), "google.cloud.securitycenter.v1.GetSourceRequest")
	proto.RegisterType((*GroupAssetsRequest)(nil), "google.cloud.securitycenter.v1.GroupAssetsRequest")
	proto.RegisterType((*GroupAssetsResponse)(nil), "google.cloud.securitycenter.v1.GroupAssetsResponse")
	proto.RegisterType((*GroupFindingsRequest)(nil), "google.cloud.securitycenter.v1.GroupFindingsRequest")
	proto.RegisterType((*GroupFindingsResponse)(nil), "google.cloud.securitycenter.v1.GroupFindingsResponse")
	proto.RegisterType((*GroupResult)(nil), "google.cloud.securitycenter.v1.GroupResult")
	proto.RegisterMapType((map[string]*_struct.Value)(nil), "google.cloud.securitycenter.v1.GroupResult.PropertiesEntry")
	proto.RegisterType((*ListSourcesRequest)(nil), "google.cloud.securitycenter.v1.ListSourcesRequest")
	proto.RegisterType((*ListSourcesResponse)(nil), "google.cloud.securitycenter.v1.ListSourcesResponse")
	proto.RegisterType((*ListAssetsRequest)(nil), "google.cloud.securitycenter.v1.ListAssetsRequest")
	proto.RegisterType((*ListAssetsResponse)(nil), "google.cloud.securitycenter.v1.ListAssetsResponse")
	proto.RegisterType((*ListAssetsResponse_ListAssetsResult)(nil), "google.cloud.securitycenter.v1.ListAssetsResponse.ListAssetsResult")
	proto.RegisterType((*ListFindingsRequest)(nil), "google.cloud.securitycenter.v1.ListFindingsRequest")
	proto.RegisterType((*ListFindingsResponse)(nil), "google.cloud.securitycenter.v1.ListFindingsResponse")
	proto.RegisterType((*ListFindingsResponse_ListFindingsResult)(nil), "google.cloud.securitycenter.v1.ListFindingsResponse.ListFindingsResult")
	proto.RegisterType((*SetFindingStateRequest)(nil), "google.cloud.securitycenter.v1.SetFindingStateRequest")
	proto.RegisterType((*RunAssetDiscoveryRequest)(nil), "google.cloud.securitycenter.v1.RunAssetDiscoveryRequest")
	proto.RegisterType((*UpdateFindingRequest)(nil), "google.cloud.securitycenter.v1.UpdateFindingRequest")
	proto.RegisterType((*UpdateOrganizationSettingsRequest)(nil), "google.cloud.securitycenter.v1.UpdateOrganizationSettingsRequest")
	proto.RegisterType((*UpdateSourceRequest)(nil), "google.cloud.securitycenter.v1.UpdateSourceRequest")
	proto.RegisterType((*UpdateSecurityMarksRequest)(nil), "google.cloud.securitycenter.v1.UpdateSecurityMarksRequest")
	proto.RegisterEnum("google.cloud.securitycenter.v1.ListAssetsResponse_ListAssetsResult_StateChange", ListAssetsResponse_ListAssetsResult_StateChange_name, ListAssetsResponse_ListAssetsResult_StateChange_value)
	proto.RegisterEnum("google.cloud.securitycenter.v1.ListFindingsResponse_ListFindingsResult_StateChange", ListFindingsResponse_ListFindingsResult_StateChange_name, ListFindingsResponse_ListFindingsResult_StateChange_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// SecurityCenterClient is the client API for SecurityCenter service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type SecurityCenterClient interface {
	// Creates a source.
	CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Creates a finding. The corresponding source must exist for finding creation
	// to succeed.
	CreateFinding(ctx context.Context, in *CreateFindingRequest, opts ...grpc.CallOption) (*Finding, error)
	// Gets the access control policy on the specified Source.
	GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Gets the settings for an organization.
	GetOrganizationSettings(ctx context.Context, in *GetOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error)
	// Gets a source.
	GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Filters an organization's assets and  groups them by their specified
	// properties.
	GroupAssets(ctx context.Context, in *GroupAssetsRequest, opts ...grpc.CallOption) (*GroupAssetsResponse, error)
	// Filters an organization or source's findings and  groups them by their
	// specified properties.
	//
	// To group across all sources provide a `-` as the source id.
	// Example: /v1/organizations/123/sources/-/findings
	GroupFindings(ctx context.Context, in *GroupFindingsRequest, opts ...grpc.CallOption) (*GroupFindingsResponse, error)
	// Lists an organization's assets.
	ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error)
	// Lists an organization or source's findings.
	//
	// To list across all sources provide a `-` as the source id.
	// Example: /v1/organizations/123/sources/-/findings
	ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error)
	// Lists all sources belonging to an organization.
	ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error)
	// Runs asset discovery. The discovery is tracked with a long-running
	// operation.
	//
	// This API can only be called with limited frequency for an organization. If
	// it is called too frequently the caller will receive a TOO_MANY_REQUESTS
	// error.
	RunAssetDiscovery(ctx context.Context, in *RunAssetDiscoveryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Updates the state of a finding.
	SetFindingState(ctx context.Context, in *SetFindingStateRequest, opts ...grpc.CallOption) (*Finding, error)
	// Sets the access control policy on the specified Source.
	SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error)
	// Returns the permissions that a caller has on the specified source.
	TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error)
	// Creates or updates a finding. The corresponding source must exist for a
	// finding creation to succeed.
	UpdateFinding(ctx context.Context, in *UpdateFindingRequest, opts ...grpc.CallOption) (*Finding, error)
	// Updates an organization's settings.
	UpdateOrganizationSettings(ctx context.Context, in *UpdateOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error)
	// Updates a source.
	UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*Source, error)
	// Updates security marks.
	UpdateSecurityMarks(ctx context.Context, in *UpdateSecurityMarksRequest, opts ...grpc.CallOption) (*SecurityMarks, error)
}

type securityCenterClient struct {
	cc *grpc.ClientConn
}

func NewSecurityCenterClient(cc *grpc.ClientConn) SecurityCenterClient {
	return &securityCenterClient{cc}
}

func (c *securityCenterClient) CreateSource(ctx context.Context, in *CreateSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/CreateSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) CreateFinding(ctx context.Context, in *CreateFindingRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/CreateFinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetIamPolicy(ctx context.Context, in *v1.GetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetOrganizationSettings(ctx context.Context, in *GetOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error) {
	out := new(OrganizationSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetOrganizationSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GetSource(ctx context.Context, in *GetSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GetSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GroupAssets(ctx context.Context, in *GroupAssetsRequest, opts ...grpc.CallOption) (*GroupAssetsResponse, error) {
	out := new(GroupAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GroupAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) GroupFindings(ctx context.Context, in *GroupFindingsRequest, opts ...grpc.CallOption) (*GroupFindingsResponse, error) {
	out := new(GroupFindingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/GroupFindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListAssets(ctx context.Context, in *ListAssetsRequest, opts ...grpc.CallOption) (*ListAssetsResponse, error) {
	out := new(ListAssetsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListAssets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListFindings(ctx context.Context, in *ListFindingsRequest, opts ...grpc.CallOption) (*ListFindingsResponse, error) {
	out := new(ListFindingsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListFindings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) ListSources(ctx context.Context, in *ListSourcesRequest, opts ...grpc.CallOption) (*ListSourcesResponse, error) {
	out := new(ListSourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/ListSources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) RunAssetDiscovery(ctx context.Context, in *RunAssetDiscoveryRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/RunAssetDiscovery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetFindingState(ctx context.Context, in *SetFindingStateRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/SetFindingState", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) SetIamPolicy(ctx context.Context, in *v1.SetIamPolicyRequest, opts ...grpc.CallOption) (*v1.Policy, error) {
	out := new(v1.Policy)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/SetIamPolicy", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) TestIamPermissions(ctx context.Context, in *v1.TestIamPermissionsRequest, opts ...grpc.CallOption) (*v1.TestIamPermissionsResponse, error) {
	out := new(v1.TestIamPermissionsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/TestIamPermissions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateFinding(ctx context.Context, in *UpdateFindingRequest, opts ...grpc.CallOption) (*Finding, error) {
	out := new(Finding)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateFinding", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateOrganizationSettings(ctx context.Context, in *UpdateOrganizationSettingsRequest, opts ...grpc.CallOption) (*OrganizationSettings, error) {
	out := new(OrganizationSettings)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateOrganizationSettings", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSource(ctx context.Context, in *UpdateSourceRequest, opts ...grpc.CallOption) (*Source, error) {
	out := new(Source)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *securityCenterClient) UpdateSecurityMarks(ctx context.Context, in *UpdateSecurityMarksRequest, opts ...grpc.CallOption) (*SecurityMarks, error) {
	out := new(SecurityMarks)
	err := c.cc.Invoke(ctx, "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSecurityMarks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// SecurityCenterServer is the server API for SecurityCenter service.
type SecurityCenterServer interface {
	// Creates a source.
	CreateSource(context.Context, *CreateSourceRequest) (*Source, error)
	// Creates a finding. The corresponding source must exist for finding creation
	// to succeed.
	CreateFinding(context.Context, *CreateFindingRequest) (*Finding, error)
	// Gets the access control policy on the specified Source.
	GetIamPolicy(context.Context, *v1.GetIamPolicyRequest) (*v1.Policy, error)
	// Gets the settings for an organization.
	GetOrganizationSettings(context.Context, *GetOrganizationSettingsRequest) (*OrganizationSettings, error)
	// Gets a source.
	GetSource(context.Context, *GetSourceRequest) (*Source, error)
	// Filters an organization's assets and  groups them by their specified
	// properties.
	GroupAssets(context.Context, *GroupAssetsRequest) (*GroupAssetsResponse, error)
	// Filters an organization or source's findings and  groups them by their
	// specified properties.
	//
	// To group across all sources provide a `-` as the source id.
	// Example: /v1/organizations/123/sources/-/findings
	GroupFindings(context.Context, *GroupFindingsRequest) (*GroupFindingsResponse, error)
	// Lists an organization's assets.
	ListAssets(context.Context, *ListAssetsRequest) (*ListAssetsResponse, error)
	// Lists an organization or source's findings.
	//
	// To list across all sources provide a `-` as the source id.
	// Example: /v1/organizations/123/sources/-/findings
	ListFindings(context.Context, *ListFindingsRequest) (*ListFindingsResponse, error)
	// Lists all sources belonging to an organization.
	ListSources(context.Context, *ListSourcesRequest) (*ListSourcesResponse, error)
	// Runs asset discovery. The discovery is tracked with a long-running
	// operation.
	//
	// This API can only be called with limited frequency for an organization. If
	// it is called too frequently the caller will receive a TOO_MANY_REQUESTS
	// error.
	RunAssetDiscovery(context.Context, *RunAssetDiscoveryRequest) (*longrunning.Operation, error)
	// Updates the state of a finding.
	SetFindingState(context.Context, *SetFindingStateRequest) (*Finding, error)
	// Sets the access control policy on the specified Source.
	SetIamPolicy(context.Context, *v1.SetIamPolicyRequest) (*v1.Policy, error)
	// Returns the permissions that a caller has on the specified source.
	TestIamPermissions(context.Context, *v1.TestIamPermissionsRequest) (*v1.TestIamPermissionsResponse, error)
	// Creates or updates a finding. The corresponding source must exist for a
	// finding creation to succeed.
	UpdateFinding(context.Context, *UpdateFindingRequest) (*Finding, error)
	// Updates an organization's settings.
	UpdateOrganizationSettings(context.Context, *UpdateOrganizationSettingsRequest) (*OrganizationSettings, error)
	// Updates a source.
	UpdateSource(context.Context, *UpdateSourceRequest) (*Source, error)
	// Updates security marks.
	UpdateSecurityMarks(context.Context, *UpdateSecurityMarksRequest) (*SecurityMarks, error)
}

func RegisterSecurityCenterServer(s *grpc.Server, srv SecurityCenterServer) {
	s.RegisterService(&_SecurityCenter_serviceDesc, srv)
}

func _SecurityCenter_CreateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/CreateSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateSource(ctx, req.(*CreateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_CreateFinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateFindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).CreateFinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/CreateFinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).CreateFinding(ctx, req.(*CreateFindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.GetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetIamPolicy(ctx, req.(*v1.GetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetOrganizationSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOrganizationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetOrganizationSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetOrganizationSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetOrganizationSettings(ctx, req.(*GetOrganizationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GetSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GetSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GetSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GetSource(ctx, req.(*GetSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GroupAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GroupAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GroupAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GroupAssets(ctx, req.(*GroupAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_GroupFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GroupFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).GroupFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/GroupFindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).GroupFindings(ctx, req.(*GroupFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListAssets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListAssetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListAssets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListAssets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListAssets(ctx, req.(*ListAssetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListFindings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListFindingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListFindings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListFindings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListFindings(ctx, req.(*ListFindingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_ListSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).ListSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/ListSources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).ListSources(ctx, req.(*ListSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_RunAssetDiscovery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RunAssetDiscoveryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).RunAssetDiscovery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/RunAssetDiscovery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).RunAssetDiscovery(ctx, req.(*RunAssetDiscoveryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetFindingState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SetFindingStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetFindingState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/SetFindingState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetFindingState(ctx, req.(*SetFindingStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_SetIamPolicy_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.SetIamPolicyRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).SetIamPolicy(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/SetIamPolicy",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).SetIamPolicy(ctx, req.(*v1.SetIamPolicyRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_TestIamPermissions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(v1.TestIamPermissionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).TestIamPermissions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/TestIamPermissions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).TestIamPermissions(ctx, req.(*v1.TestIamPermissionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateFinding_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateFindingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateFinding(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateFinding",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateFinding(ctx, req.(*UpdateFindingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateOrganizationSettings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateOrganizationSettingsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateOrganizationSettings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateOrganizationSettings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateOrganizationSettings(ctx, req.(*UpdateOrganizationSettingsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSource(ctx, req.(*UpdateSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _SecurityCenter_UpdateSecurityMarks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateSecurityMarksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(SecurityCenterServer).UpdateSecurityMarks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.securitycenter.v1.SecurityCenter/UpdateSecurityMarks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(SecurityCenterServer).UpdateSecurityMarks(ctx, req.(*UpdateSecurityMarksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _SecurityCenter_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.securitycenter.v1.SecurityCenter",
	HandlerType: (*SecurityCenterServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateSource",
			Handler:    _SecurityCenter_CreateSource_Handler,
		},
		{
			MethodName: "CreateFinding",
			Handler:    _SecurityCenter_CreateFinding_Handler,
		},
		{
			MethodName: "GetIamPolicy",
			Handler:    _SecurityCenter_GetIamPolicy_Handler,
		},
		{
			MethodName: "GetOrganizationSettings",
			Handler:    _SecurityCenter_GetOrganizationSettings_Handler,
		},
		{
			MethodName: "GetSource",
			Handler:    _SecurityCenter_GetSource_Handler,
		},
		{
			MethodName: "GroupAssets",
			Handler:    _SecurityCenter_GroupAssets_Handler,
		},
		{
			MethodName: "GroupFindings",
			Handler:    _SecurityCenter_GroupFindings_Handler,
		},
		{
			MethodName: "ListAssets",
			Handler:    _SecurityCenter_ListAssets_Handler,
		},
		{
			MethodName: "ListFindings",
			Handler:    _SecurityCenter_ListFindings_Handler,
		},
		{
			MethodName: "ListSources",
			Handler:    _SecurityCenter_ListSources_Handler,
		},
		{
			MethodName: "RunAssetDiscovery",
			Handler:    _SecurityCenter_RunAssetDiscovery_Handler,
		},
		{
			MethodName: "SetFindingState",
			Handler:    _SecurityCenter_SetFindingState_Handler,
		},
		{
			MethodName: "SetIamPolicy",
			Handler:    _SecurityCenter_SetIamPolicy_Handler,
		},
		{
			MethodName: "TestIamPermissions",
			Handler:    _SecurityCenter_TestIamPermissions_Handler,
		},
		{
			MethodName: "UpdateFinding",
			Handler:    _SecurityCenter_UpdateFinding_Handler,
		},
		{
			MethodName: "UpdateOrganizationSettings",
			Handler:    _SecurityCenter_UpdateOrganizationSettings_Handler,
		},
		{
			MethodName: "UpdateSource",
			Handler:    _SecurityCenter_UpdateSource_Handler,
		},
		{
			MethodName: "UpdateSecurityMarks",
			Handler:    _SecurityCenter_UpdateSecurityMarks_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/securitycenter/v1/securitycenter_service.proto",
}

func init() {
	proto.RegisterFile("google/cloud/securitycenter/v1/securitycenter_service.proto", fileDescriptor_securitycenter_service_0a41679950f5c36f)
}

var fileDescriptor_securitycenter_service_0a41679950f5c36f = []byte{
	// 1987 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x5a, 0xcd, 0x6f, 0x1b, 0xc7,
	0x15, 0xef, 0xac, 0x3e, 0xf9, 0x68, 0xd9, 0xf4, 0x48, 0x76, 0x99, 0x4d, 0xec, 0x2a, 0x9b, 0xc4,
	0x55, 0x6c, 0x97, 0x8c, 0x28, 0xbb, 0x76, 0x57, 0x70, 0x60, 0x99, 0x92, 0x15, 0x17, 0xfe, 0x02,
	0x29, 0xe9, 0x90, 0x1a, 0x21, 0xd6, 0xe4, 0x98, 0x59, 0x88, 0xdc, 0x65, 0x77, 0x86, 0x42, 0xe5,
	0xc0, 0x28, 0x90, 0x6b, 0x81, 0x22, 0x68, 0x80, 0x1e, 0x8b, 0xb4, 0xe8, 0xa1, 0x2d, 0x72, 0x68,
	0x83, 0x02, 0x6d, 0x81, 0xa2, 0xe7, 0xa2, 0x3d, 0xf6, 0x50, 0x20, 0xe8, 0xb1, 0xa7, 0xa0, 0xe8,
	0x3f, 0xd0, 0x4b, 0x31, 0x5f, 0xd4, 0xee, 0x72, 0xc5, 0x5d, 0x5a, 0x0a, 0x0c, 0x14, 0xbd, 0x71,
	0x66, 0xde, 0x7b, 0xf3, 0x7b, 0x6f, 0xde, 0x7b, 0xf3, 0xde, 0x2c, 0x61, 0xb5, 0xed, 0xfb, 0xed,
	0x0e, 0x29, 0x37, 0x3b, 0x7e, 0xbf, 0x55, 0xa6, 0xa4, 0xd9, 0x0f, 0x5c, 0xb6, 0xdf, 0x24, 0x1e,
	0x23, 0x41, 0x79, 0x6f, 0x39, 0x36, 0xd3, 0xa0, 0x24, 0xd8, 0x73, 0x9b, 0xa4, 0xd4, 0x0b, 0x7c,
	0xe6, 0xe3, 0xf3, 0x92, 0xb9, 0x24, 0x98, 0x4b, 0x51, 0xd2, 0xd2, 0xde, 0xb2, 0xf9, 0x8a, 0x12,
	0xee, 0xf4, 0xdc, 0xb2, 0xe3, 0x79, 0x3e, 0x73, 0x98, 0xeb, 0x7b, 0x54, 0x72, 0x9b, 0x17, 0x53,
	0xb6, 0x76, 0x28, 0x25, 0x4c, 0xd1, 0x5e, 0x4e, 0xa1, 0x7d, 0xe2, 0x7a, 0x2d, 0xd7, 0x6b, 0x2b,
	0x6a, 0x3b, 0x85, 0xda, 0x0f, 0xda, 0x8e, 0xe7, 0x3e, 0x15, 0x68, 0x1a, 0x94, 0x30, 0xe6, 0x7a,
	0x6d, 0x8d, 0x6a, 0x25, 0xa3, 0x41, 0x1a, 0x5d, 0x27, 0xd8, 0xd5, 0x4c, 0x97, 0xd2, 0x98, 0xfc,
	0x7e, 0xa0, 0xad, 0x66, 0x2a, 0xab, 0x95, 0x5d, 0xa7, 0xcb, 0xd7, 0x5c, 0xa7, 0xdb, 0xe8, 0xf9,
	0x1d, 0xb7, 0xb9, 0xaf, 0xd6, 0xcd, 0xe8, 0x7a, 0x64, 0xed, 0x35, 0xb5, 0xd6, 0xf1, 0xbd, 0x76,
	0xd0, 0xf7, 0x3c, 0xd7, 0x6b, 0x97, 0xfd, 0x1e, 0x09, 0x22, 0x86, 0xd5, 0x1b, 0x88, 0xd1, 0xe3,
	0xfe, 0x93, 0x72, 0xab, 0x2f, 0x09, 0xd4, 0xfa, 0xcb, 0xf1, 0x75, 0xd2, 0xed, 0x31, 0xbd, 0xc3,
	0x62, 0x7c, 0xf1, 0x89, 0x4b, 0x3a, 0xad, 0x46, 0xd7, 0xa1, 0xbb, 0x8a, 0xe2, 0x95, 0x38, 0x05,
	0x65, 0x41, 0xbf, 0xa9, 0x4f, 0xea, 0x6b, 0xf1, 0x55, 0xe6, 0x76, 0x09, 0x65, 0x4e, 0xb7, 0x27,
	0x09, 0xac, 0x8f, 0x10, 0x2c, 0x54, 0x03, 0xe2, 0x30, 0x72, 0x5b, 0x1e, 0x5a, 0x8d, 0x7c, 0xb7,
	0x4f, 0x28, 0xc3, 0x67, 0x61, 0xba, 0xe7, 0x04, 0xc4, 0x63, 0x45, 0xb4, 0x88, 0x96, 0x72, 0x35,
	0x35, 0xc2, 0xe7, 0x00, 0xd4, 0xf1, 0x36, 0xdc, 0x56, 0xd1, 0x10, 0x6b, 0x39, 0x35, 0x73, 0xa7,
	0x85, 0xd7, 0x60, 0x46, 0x0d, 0x8a, 0x13, 0x8b, 0x68, 0x29, 0x5f, 0xf9, 0x7a, 0x69, 0xb4, 0x5b,
	0x96, 0xf4, 0xbe, 0x9a, 0xcf, 0xea, 0xc2, 0xbc, 0x44, 0x54, 0x17, 0xe7, 0x94, 0x06, 0xe8, 0x6d,
	0x98, 0x96, 0x07, 0x2a, 0xc0, 0xe4, 0x2b, 0x17, 0xd2, 0x36, 0x54, 0x62, 0x15, 0x97, 0x75, 0x05,
	0xce, 0x6f, 0x12, 0xf6, 0x20, 0xe4, 0x84, 0x75, 0xe5, 0x83, 0x7a, 0x67, 0x0c, 0x93, 0x9e, 0xd3,
	0x25, 0x6a, 0x5f, 0xf1, 0xdb, 0xba, 0x00, 0x85, 0x4d, 0xc2, 0xa2, 0x08, 0x93, 0xe8, 0x3e, 0x31,
	0x00, 0x6f, 0x06, 0x7e, 0xbf, 0xb7, 0xc6, 0xe3, 0x87, 0xa6, 0x29, 0x73, 0x16, 0xa6, 0x9f, 0xb8,
	0x1d, 0x46, 0x02, 0x65, 0x59, 0x35, 0xc2, 0x2f, 0xc1, 0x6c, 0x9b, 0x4b, 0x69, 0x3c, 0xde, 0x17,
	0x76, 0xcd, 0xd5, 0x66, 0xc4, 0xf8, 0xd6, 0x3e, 0x5e, 0x87, 0x42, 0xd3, 0xef, 0x72, 0xfe, 0x86,
	0xf6, 0xac, 0xe2, 0xa4, 0xb0, 0xc4, 0x4b, 0xda, 0x12, 0xfa, 0xf4, 0x4b, 0xeb, 0x8a, 0xa0, 0x76,
	0x4a, 0xb1, 0xe8, 0x09, 0x7c, 0x0d, 0x72, 0x01, 0x71, 0x5a, 0x0d, 0xee, 0x1f, 0xc5, 0x29, 0xc1,
	0x6e, 0x0e, 0xb1, 0x6f, 0x69, 0xe7, 0xa9, 0xcd, 0x72, 0x62, 0x3e, 0xe4, 0xfe, 0xd0, 0x73, 0xda,
	0xa4, 0xc1, 0xfc, 0x5d, 0xe2, 0x15, 0x67, 0xa4, 0x3f, 0xf0, 0x99, 0x2d, 0x3e, 0x81, 0x5f, 0x06,
	0x31, 0x68, 0x50, 0xf7, 0x29, 0x29, 0xce, 0x2e, 0xa2, 0xa5, 0xa9, 0xda, 0x2c, 0x9f, 0xa8, 0xbb,
	0x4f, 0xc9, 0xb7, 0x27, 0x67, 0xa7, 0x0b, 0x33, 0xd6, 0xbf, 0x10, 0xcc, 0x47, 0x4c, 0x44, 0x7b,
	0xbe, 0x47, 0x09, 0xde, 0x86, 0x82, 0xd6, 0xb9, 0x11, 0x10, 0xda, 0xef, 0x30, 0x5a, 0x44, 0x8b,
	0x13, 0x4b, 0xf9, 0xca, 0xa5, 0xb4, 0x23, 0x16, 0xe2, 0x6a, 0x82, 0xa7, 0x76, 0x52, 0x19, 0x4a,
	0x0e, 0x69, 0x54, 0x53, 0x63, 0x0c, 0x4d, 0x2f, 0xc0, 0x29, 0x8f, 0x7c, 0x8f, 0x35, 0x42, 0xea,
	0xca, 0xa3, 0x98, 0xe3, 0xd3, 0x0f, 0x07, 0x2a, 0x9f, 0x03, 0x60, 0x3e, 0x73, 0x3a, 0x52, 0xe7,
	0x49, 0xa1, 0x73, 0x4e, 0xcc, 0x70, 0xa5, 0xad, 0x9f, 0x19, 0xb0, 0x20, 0xf0, 0x29, 0xc7, 0xff,
	0x32, 0x7c, 0x22, 0xa2, 0xe3, 0xe4, 0x18, 0x3a, 0x26, 0x39, 0xd3, 0xd4, 0xd8, 0xce, 0x74, 0x74,
	0x9f, 0xf8, 0x37, 0x82, 0x33, 0x31, 0x23, 0xfd, 0x6f, 0x7b, 0xc5, 0xdf, 0x11, 0xe4, 0x43, 0xf8,
	0xf0, 0x77, 0x00, 0x7a, 0x01, 0xbf, 0x4b, 0x98, 0x4b, 0xb4, 0x82, 0xab, 0x63, 0x28, 0x58, 0x7a,
	0x38, 0xe0, 0xde, 0xf0, 0x58, 0xb0, 0x5f, 0x0b, 0x89, 0xc3, 0x0b, 0x30, 0xd5, 0xf4, 0xfb, 0x1e,
	0x13, 0x8a, 0x4e, 0xd4, 0xe4, 0xc0, 0xdc, 0x86, 0x53, 0x31, 0x26, 0x5c, 0x80, 0x89, 0x5d, 0xb2,
	0xaf, 0xfc, 0x91, 0xff, 0xc4, 0x97, 0x61, 0x6a, 0xcf, 0xe9, 0xf4, 0xb5, 0x8d, 0xce, 0x0e, 0xd9,
	0x68, 0x87, 0xaf, 0xd6, 0x24, 0x91, 0x6d, 0x5c, 0x47, 0xd6, 0xfb, 0x80, 0xef, 0xba, 0x54, 0xa5,
	0x4a, 0x9a, 0xe1, 0x7a, 0x09, 0x59, 0xd2, 0x18, 0xe9, 0x3a, 0x33, 0x51, 0xd7, 0xb1, 0xbe, 0x0f,
	0xf3, 0x91, 0x9d, 0x94, 0xc7, 0xdc, 0x84, 0x19, 0x99, 0xea, 0xb5, 0x1d, 0xb3, 0xde, 0x10, 0x9a,
	0x2d, 0xe9, 0x8c, 0x8d, 0x84, 0x33, 0xb6, 0x3e, 0x37, 0xe0, 0x34, 0x47, 0x70, 0xe4, 0x5c, 0xef,
	0x07, 0x2d, 0x12, 0x84, 0xe2, 0x5a, 0x8c, 0x5f, 0x7c, 0x5c, 0x7f, 0x8b, 0xdf, 0xfd, 0xba, 0xfe,
	0x10, 0xe6, 0x4f, 0xda, 0xff, 0x36, 0x27, 0xb9, 0xe7, 0xd0, 0x5d, 0x5e, 0x17, 0xa8, 0x9f, 0xb1,
	0x73, 0x9d, 0x1d, 0x79, 0xae, 0xb9, 0xc4, 0x94, 0xf0, 0xc3, 0x49, 0xe9, 0x48, 0xb1, 0x5b, 0x82,
	0xc2, 0x7c, 0xc7, 0xa5, 0xac, 0x21, 0xea, 0x53, 0x1a, 0x4b, 0x09, 0xd5, 0xb4, 0x93, 0x1e, 0x16,
	0x18, 0x9d, 0xe2, 0xa9, 0xe2, 0x74, 0x27, 0x36, 0xf3, 0xc2, 0xb3, 0x85, 0xf9, 0xa1, 0x01, 0x85,
	0x38, 0x4e, 0xbc, 0x0a, 0x53, 0xc2, 0x08, 0xc2, 0xcd, 0xf2, 0x95, 0x37, 0xd2, 0x74, 0x17, 0xcc,
	0x35, 0xc9, 0x83, 0x03, 0x38, 0x41, 0x99, 0xc3, 0x48, 0xa3, 0xf9, 0xbe, 0xe3, 0xb5, 0xa5, 0x52,
	0x27, 0x2b, 0x0f, 0x8e, 0xc1, 0x7e, 0xa5, 0x3a, 0x97, 0x5b, 0x15, 0x62, 0x6b, 0x79, 0x7a, 0x30,
	0xb0, 0x6e, 0x40, 0x3e, 0xb4, 0x86, 0x01, 0xa6, 0xb7, 0xef, 0x6f, 0xd7, 0x37, 0xd6, 0x0b, 0x5f,
	0xc1, 0x39, 0x98, 0x5a, 0x5b, 0x5f, 0xdf, 0x58, 0x2f, 0x20, 0x9c, 0x87, 0x99, 0xda, 0xc6, 0xbd,
	0x07, 0x3b, 0x1b, 0xeb, 0x05, 0x83, 0xd3, 0xac, 0x55, 0xb7, 0xee, 0xec, 0x6c, 0x14, 0x26, 0xac,
	0x7f, 0x18, 0x32, 0xde, 0x8f, 0xe1, 0x1e, 0xfd, 0x7f, 0xbc, 0x0d, 0xc7, 0xdb, 0x6f, 0x27, 0x61,
	0x21, 0x6a, 0x5e, 0x15, 0x71, 0x1f, 0xc0, 0x19, 0x11, 0x71, 0xaa, 0x5e, 0x8f, 0xc7, 0xdc, 0x66,
	0x16, 0x9f, 0x89, 0x0b, 0x8d, 0x4f, 0xf2, 0xb8, 0x13, 0x71, 0x1d, 0x9d, 0x7b, 0xf1, 0x91, 0xf7,
	0x13, 0x43, 0x66, 0xa1, 0x28, 0xae, 0x70, 0xdb, 0x83, 0x9e, 0xaf, 0xed, 0xc1, 0x7b, 0x89, 0x11,
	0x58, 0x3f, 0x26, 0x6b, 0x1e, 0x1e, 0x85, 0xf7, 0x0e, 0x8f, 0xc2, 0x3c, 0xcc, 0x54, 0xdf, 0x59,
	0xbb, 0xbf, 0x29, 0xe2, 0x70, 0x0e, 0x72, 0xdb, 0xf7, 0xf5, 0xd0, 0x38, 0x88, 0xd0, 0x89, 0x70,
	0x84, 0x4e, 0x5a, 0x9f, 0x22, 0x38, 0x5b, 0x27, 0x7a, 0x77, 0x21, 0x79, 0x44, 0x7f, 0x84, 0xab,
	0x30, 0x25, 0xc0, 0x28, 0x75, 0xbf, 0x91, 0xd1, 0x6c, 0x52, 0x9d, 0x9a, 0xe4, 0xe5, 0x71, 0x42,
	0x99, 0x13, 0x30, 0xe9, 0x15, 0x13, 0xa9, 0x5e, 0x91, 0x13, 0xd4, 0x7c, 0x6c, 0x55, 0xa0, 0x58,
	0xeb, 0x7b, 0x22, 0x5f, 0xad, 0xbb, 0xb4, 0xe9, 0xef, 0x91, 0x60, 0x3f, 0x25, 0x91, 0x58, 0x3f,
	0x46, 0xb0, 0xb0, 0xdd, 0x6b, 0x0d, 0xf7, 0xcc, 0xc7, 0xe0, 0x05, 0xab, 0x90, 0xef, 0x0b, 0xd1,
	0x32, 0xe6, 0x8d, 0xd4, 0x98, 0x07, 0x49, 0xce, 0x7f, 0x5b, 0x7f, 0x45, 0xf0, 0xaa, 0x04, 0x36,
	0xaa, 0x9d, 0x75, 0xe1, 0x4c, 0xe2, 0x93, 0x8b, 0xc2, 0x7c, 0x25, 0x0d, 0x73, 0xa2, 0xec, 0x05,
	0x3f, 0x61, 0xf6, 0x68, 0xda, 0xfc, 0x08, 0xc1, 0xbc, 0xd4, 0x26, 0xda, 0x66, 0x1f, 0x34, 0xfc,
	0xe8, 0x79, 0x1a, 0xfe, 0xa3, 0x81, 0xfa, 0x02, 0x81, 0xa9, 0x40, 0xa9, 0x7d, 0xee, 0x39, 0xc1,
	0xee, 0xc0, 0xb6, 0x5b, 0x70, 0x32, 0xfa, 0x24, 0xa5, 0x30, 0xa6, 0xfa, 0x75, 0x54, 0xda, 0x1c,
	0x0d, 0x0f, 0x8f, 0x84, 0xf8, 0x08, 0xc1, 0x51, 0xf9, 0xc8, 0x84, 0x93, 0x1a, 0x58, 0x55, 0x40,
	0xc5, 0x3f, 0x45, 0x70, 0x22, 0xfc, 0x3a, 0x83, 0x57, 0xd2, 0x34, 0x4b, 0x78, 0xcb, 0x31, 0x33,
	0x1e, 0x99, 0x75, 0xe5, 0xc3, 0xbf, 0xfd, 0xf3, 0x63, 0xa3, 0x64, 0xbd, 0x5e, 0xde, 0x5b, 0x2e,
	0x7f, 0x20, 0xc3, 0xef, 0x46, 0xd8, 0xd3, 0x68, 0xf9, 0xe2, 0x33, 0xf5, 0x9e, 0x47, 0x6d, 0x7d,
	0xc0, 0xbf, 0x46, 0x30, 0x17, 0x79, 0xd3, 0xc2, 0x57, 0xb2, 0x81, 0x8c, 0x86, 0xb3, 0x99, 0x35,
	0x7a, 0xad, 0x9b, 0x02, 0xa6, 0x6d, 0x95, 0x47, 0xc0, 0xd4, 0x28, 0x39, 0x60, 0x7d, 0x73, 0xda,
	0x83, 0xb0, 0xff, 0x01, 0x82, 0x13, 0x9b, 0x84, 0xdd, 0x71, 0xba, 0x0f, 0xc5, 0x03, 0x23, 0xb6,
	0xf4, 0xde, 0xae, 0xd3, 0x15, 0xad, 0x5d, 0x68, 0x51, 0xe3, 0x3b, 0x13, 0xa3, 0x91, 0xab, 0x03,
	0x34, 0x57, 0x05, 0x9a, 0x80, 0xc8, 0x8d, 0x47, 0xe0, 0xb1, 0xdb, 0x21, 0xe1, 0x36, 0xba, 0x88,
	0xff, 0x8c, 0xe0, 0xab, 0x87, 0xbc, 0x89, 0xe1, 0xb7, 0x53, 0x9b, 0xd0, 0x91, 0x8f, 0x69, 0xe6,
	0x73, 0xa5, 0x17, 0xeb, 0x9a, 0xd0, 0x69, 0x19, 0x4b, 0x0b, 0xf3, 0x9b, 0x63, 0x48, 0x9f, 0xa4,
	0x04, 0xf4, 0x0c, 0x7f, 0x8c, 0x20, 0x37, 0x78, 0xa8, 0xc3, 0x6f, 0x65, 0x00, 0xff, 0x7c, 0x9e,
	0x7a, 0x59, 0x00, 0xbc, 0x80, 0x5f, 0x3f, 0x1c, 0xe0, 0x81, 0xc1, 0xf1, 0xa7, 0xba, 0xdb, 0x97,
	0x85, 0x32, 0xae, 0x64, 0xea, 0xec, 0x23, 0x6d, 0xa5, 0xb9, 0x32, 0x16, 0x8f, 0x2c, 0x0c, 0x06,
	0x01, 0xf5, 0xe6, 0xc8, 0x80, 0x92, 0xbd, 0x94, 0x2d, 0x9e, 0x48, 0xb8, 0x3f, 0xfc, 0x09, 0xc1,
	0x5c, 0xe4, 0x35, 0x26, 0x3d, 0xa0, 0x92, 0x5e, 0xb8, 0xcc, 0xab, 0x63, 0x72, 0x29, 0xd0, 0x51,
	0x87, 0x1e, 0x23, 0xbc, 0x06, 0x0a, 0x7c, 0x82, 0x00, 0x0e, 0xfa, 0x12, 0xbc, 0x3c, 0x4e, 0x5b,
	0x23, 0xa1, 0x57, 0xc6, 0xef, 0x84, 0xac, 0x4b, 0x02, 0xf7, 0x1b, 0xf8, 0xb5, 0x0c, 0xc6, 0xc6,
	0x9f, 0x21, 0x38, 0x11, 0x2e, 0xdb, 0xd2, 0x13, 0x6b, 0x42, 0xef, 0x93, 0x1e, 0x5d, 0x49, 0xe5,
	0x62, 0x2c, 0xba, 0xb2, 0x1b, 0x18, 0xff, 0x1c, 0x41, 0x3e, 0xf4, 0xe4, 0x82, 0x33, 0x59, 0x29,
	0xfa, 0x12, 0x64, 0xae, 0x8c, 0xc5, 0xa3, 0x10, 0x47, 0xc3, 0x2d, 0xe5, 0x62, 0xc0, 0xbf, 0x44,
	0x70, 0x7a, 0xa8, 0xca, 0xc3, 0xd7, 0xd3, 0x36, 0x3e, 0xac, 0x30, 0x34, 0xcf, 0x69, 0xce, 0xd0,
	0x87, 0x9f, 0xd2, 0x03, 0xfd, 0xe1, 0xc7, 0x5a, 0x15, 0xe0, 0xae, 0x5a, 0x6f, 0x65, 0x09, 0xb2,
	0xa0, 0xef, 0x0d, 0xe4, 0x73, 0x57, 0xfd, 0x1d, 0x82, 0x53, 0xb1, 0xfa, 0x19, 0x7f, 0x33, 0xbd,
	0x7a, 0x48, 0x2a, 0xb8, 0xb3, 0x5f, 0x60, 0x55, 0x81, 0xf8, 0x86, 0x75, 0x3d, 0x43, 0xf6, 0x1a,
	0x9c, 0x3e, 0xbf, 0x39, 0x28, 0x61, 0x62, 0x47, 0x8e, 0x9c, 0xdf, 0x61, 0xf5, 0x51, 0x77, 0x58,
	0xfd, 0xcb, 0xbc, 0xc3, 0x68, 0xec, 0x0e, 0xfb, 0x0d, 0x02, 0xbc, 0x45, 0xa8, 0x98, 0x24, 0x41,
	0xd7, 0xa5, 0x94, 0xf3, 0xe0, 0xa5, 0xd8, 0x7e, 0xc3, 0x24, 0x1a, 0xd9, 0x9b, 0x19, 0x28, 0x95,
	0x37, 0xde, 0x16, 0x68, 0x6f, 0x5a, 0xab, 0x99, 0xd1, 0xb2, 0x21, 0x61, 0x1c, 0xf3, 0xef, 0x11,
	0xcc, 0x45, 0x1a, 0x8b, 0xf4, 0x3c, 0x9b, 0xd4, 0x87, 0x64, 0x3f, 0xf7, 0x77, 0x04, 0xf0, 0x5b,
	0x95, 0x6b, 0x02, 0xb8, 0xfe, 0x6c, 0x3b, 0xc6, 0xf9, 0x0f, 0x0a, 0x98, 0xff, 0x0c, 0xea, 0xe2,
	0xc4, 0xaa, 0x61, 0x2d, 0x9b, 0x1e, 0xc7, 0x5f, 0x38, 0xb4, 0x84, 0x86, 0xef, 0x55, 0x36, 0x84,
	0x86, 0xc9, 0x9f, 0x9a, 0xb3, 0x97, 0x13, 0x76, 0x72, 0xe7, 0x84, 0x7f, 0x81, 0xe0, 0x44, 0xb8,
	0x55, 0x49, 0x4f, 0xde, 0x09, 0x8d, 0x4d, 0xe6, 0x5a, 0x43, 0xe5, 0x97, 0xca, 0x25, 0xa1, 0x93,
	0xfa, 0x9a, 0x9d, 0x52, 0x72, 0x0c, 0x8a, 0xe3, 0x3f, 0x1a, 0x83, 0xae, 0x2a, 0xd2, 0x63, 0xd8,
	0x19, 0x11, 0x27, 0x74, 0x3d, 0xe6, 0x78, 0xdd, 0x8d, 0xf5, 0x07, 0x24, 0x14, 0xf8, 0x0c, 0x55,
	0x6e, 0x4a, 0x0d, 0xa2, 0x1f, 0xf1, 0x13, 0x35, 0x91, 0xd9, 0x92, 0xab, 0x14, 0x16, 0xf5, 0xcc,
	0x8e, 0xb5, 0x5b, 0xef, 0xbe, 0x57, 0xb9, 0x9b, 0x59, 0x66, 0x92, 0x4b, 0xa7, 0xc8, 0xbf, 0xf5,
	0x39, 0x02, 0xab, 0xe9, 0x77, 0x53, 0x14, 0x7e, 0x88, 0xde, 0xbd, 0xab, 0x28, 0xda, 0x7e, 0xc7,
	0xf1, 0xda, 0x25, 0x3f, 0x68, 0x97, 0xdb, 0xc4, 0x13, 0xfd, 0x56, 0x59, 0x2e, 0x39, 0x3d, 0x97,
	0x1e, 0xf6, 0x1f, 0x85, 0xd5, 0xe8, 0xcc, 0xaf, 0x8c, 0xf3, 0x9b, 0x52, 0x5c, 0x55, 0x6c, 0x18,
	0x6d, 0xca, 0x4a, 0x3b, 0xcb, 0x7f, 0xd1, 0x04, 0x8f, 0x04, 0xc1, 0xa3, 0x28, 0xc1, 0xa3, 0x9d,
	0xe5, 0x2f, 0x8c, 0x57, 0x25, 0x81, 0x6d, 0x0b, 0x0a, 0xdb, 0x8e, 0x92, 0xd8, 0xf6, 0xce, 0xf2,
	0xe3, 0x69, 0x01, 0x6f, 0xe5, 0xbf, 0x01, 0x00, 0x00, 0xff, 0xff, 0x95, 0xc1, 0xf5, 0xe5, 0x87,
	0x22, 0x00, 0x00,
}
