// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/automl/v1beta1/tables.proto

package automl // import "google.golang.org/genproto/googleapis/cloud/automl/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _struct "github.com/golang/protobuf/ptypes/struct"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Metadata for a dataset used for AutoML Tables.
type TablesDatasetMetadata struct {
	// Output only. The table_spec_id of the primary table of this dataset.
	PrimaryTableSpecId string `protobuf:"bytes,1,opt,name=primary_table_spec_id,json=primaryTableSpecId,proto3" json:"primary_table_spec_id,omitempty"`
	// column_spec_id of the primary table's column that should be used as the
	// training & prediction target.
	// This column must be non-nullable and have one of following data types
	// (otherwise model creation will error):
	// * CATEGORY
	// * ARRAY(CATEGORY)
	// * FLOAT64
	// Furthermore, if the type is CATEGORY or ARRAY(CATEGORY), then only up to
	// 40 unique values may exist in that column across all rows, but for
	// ARRAY(CATEGORY) unique values are counted as elements of the ARRAY (i.e.
	// following 3 ARRAY-s: [A, B], [A], [B] are counted as having 2 unique
	// values).
	//
	// NOTE: Updates of this field will instantly affect any other users
	// concurrently working with the dataset.
	TargetColumnSpecId string `protobuf:"bytes,2,opt,name=target_column_spec_id,json=targetColumnSpecId,proto3" json:"target_column_spec_id,omitempty"`
	// column_spec_id of the primary table's column that should be used as the
	// weight column, i.e. the higher the value the more important the row will be
	// during model training.
	// Required type: FLOAT64.
	// Allowed values: 0 to 10000, inclusive on both ends; 0 means the row is
	//                 ignored for training.
	// If not set all rows are assumed to have equal weight of 1.
	// NOTE: Updates of this field will instantly affect any other users
	// concurrently working with the dataset.
	WeightColumnSpecId string `protobuf:"bytes,3,opt,name=weight_column_spec_id,json=weightColumnSpecId,proto3" json:"weight_column_spec_id,omitempty"`
	// column_spec_id of the primary table column which specifies a possible ML
	// use of the row, i.e. the column will be used to split the rows into TRAIN,
	// VALIDATE and TEST sets.
	// Required type: STRING.
	// This column, if set, must either have all of `TRAIN`, `VALIDATE`, `TEST`
	// among its values, or only have `TEST`, `UNASSIGNED` values. In the latter
	// case the rows with `UNASSIGNED` value will be assigned by AutoML. Note
	// that if a given ml use distribution makes it impossible to create a "good"
	// model, that call will error describing the issue.
	// If both this column_spec_id and primary table's time_column_spec_id are not
	// set, then all rows are treated as `UNASSIGNED`.
	// NOTE: Updates of this field will instantly affect any other users
	// concurrently working with the dataset.
	MlUseColumnSpecId string `protobuf:"bytes,4,opt,name=ml_use_column_spec_id,json=mlUseColumnSpecId,proto3" json:"ml_use_column_spec_id,omitempty"`
	// Output only. Correlations between
	//
	// [target_column][google.cloud.automl.v1beta1.TablesDatasetMetadata.target_column],
	// and other columns of the
	//
	// [primary_table][google.cloud.automl.v1beta1.TablesDatasetMetadata.primary_table_spec_id].
	// Only set if the target column is set. Mapping from other column spec id to
	// its CorrelationStats with the target column.
	// This field may be stale, see the stats_update_time field for
	// for the timestamp at which these stats were last updated.
	TargetColumnCorrelations map[string]*CorrelationStats `protobuf:"bytes,6,rep,name=target_column_correlations,json=targetColumnCorrelations,proto3" json:"target_column_correlations,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The most recent timestamp when target_column_correlations field and all
	// descendant ColumnSpec.data_stats and ColumnSpec.top_correlated_columns
	// fields were last (re-)generated. Any changes that happened to the dataset
	// afterwards are not reflected in these fields values. The regeneration
	// happens in the background on a best effort basis.
	StatsUpdateTime      *timestamp.Timestamp `protobuf:"bytes,7,opt,name=stats_update_time,json=statsUpdateTime,proto3" json:"stats_update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *TablesDatasetMetadata) Reset()         { *m = TablesDatasetMetadata{} }
func (m *TablesDatasetMetadata) String() string { return proto.CompactTextString(m) }
func (*TablesDatasetMetadata) ProtoMessage()    {}
func (*TablesDatasetMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_tables_2ffb928805ee705e, []int{0}
}
func (m *TablesDatasetMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TablesDatasetMetadata.Unmarshal(m, b)
}
func (m *TablesDatasetMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TablesDatasetMetadata.Marshal(b, m, deterministic)
}
func (dst *TablesDatasetMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TablesDatasetMetadata.Merge(dst, src)
}
func (m *TablesDatasetMetadata) XXX_Size() int {
	return xxx_messageInfo_TablesDatasetMetadata.Size(m)
}
func (m *TablesDatasetMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_TablesDatasetMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_TablesDatasetMetadata proto.InternalMessageInfo

func (m *TablesDatasetMetadata) GetPrimaryTableSpecId() string {
	if m != nil {
		return m.PrimaryTableSpecId
	}
	return ""
}

func (m *TablesDatasetMetadata) GetTargetColumnSpecId() string {
	if m != nil {
		return m.TargetColumnSpecId
	}
	return ""
}

func (m *TablesDatasetMetadata) GetWeightColumnSpecId() string {
	if m != nil {
		return m.WeightColumnSpecId
	}
	return ""
}

func (m *TablesDatasetMetadata) GetMlUseColumnSpecId() string {
	if m != nil {
		return m.MlUseColumnSpecId
	}
	return ""
}

func (m *TablesDatasetMetadata) GetTargetColumnCorrelations() map[string]*CorrelationStats {
	if m != nil {
		return m.TargetColumnCorrelations
	}
	return nil
}

func (m *TablesDatasetMetadata) GetStatsUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.StatsUpdateTime
	}
	return nil
}

// Model metadata specific to AutoML Tables.
type TablesModelMetadata struct {
	// Column spec of the dataset's primary table's column the model is
	// predicting. Snapshotted when model creation started.
	// Only 3 fields are used:
	// name - May be set on CreateModel, if it's not then the ColumnSpec
	//        corresponding to the current target_column_spec_id of the dataset
	//        the model is trained from is used.
	//        If neither is set, CreateModel will error.
	// display_name - Output only.
	// data_type - Output only.
	TargetColumnSpec *ColumnSpec `protobuf:"bytes,2,opt,name=target_column_spec,json=targetColumnSpec,proto3" json:"target_column_spec,omitempty"`
	// Column specs of the dataset's primary table's columns, on which
	// the model is trained and which are used as the input for predictions.
	// The
	//
	// [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
	// as well as, according to dataset's state upon model creation,
	//
	// [weight_column][google.cloud.automl.v1beta1.TablesDatasetMetadata.weight_column_spec_id],
	// and
	//
	// [ml_use_column][google.cloud.automl.v1beta1.TablesDatasetMetadata.ml_use_column_spec_id]
	// must never be included here.
	// Only 3 fields are used:
	// name - May be set on CreateModel, if set only the columns specified are
	//        used, otherwise all primary table's columns (except the ones listed
	//        above) are used for the training and prediction input.
	// display_name - Output only.
	// data_type - Output only.
	InputFeatureColumnSpecs []*ColumnSpec `protobuf:"bytes,3,rep,name=input_feature_column_specs,json=inputFeatureColumnSpecs,proto3" json:"input_feature_column_specs,omitempty"`
	// Objective function the model is optimizing towards. The training process
	// creates a model that maximizes/minimizes the value of the objective
	// function over the validation set.
	//
	// The supported optimization objectives depend on the prediction_type.
	// If the field is not set, a default objective function is used.
	//
	// CLASSIFICATION_BINARY:
	//   "MAXIMIZE_AU_ROC" (default) - Maximize the area under the receiver
	//                                 operating characteristic (ROC) curve.
	//   "MINIMIZE_LOG_LOSS" - Minimize log loss.
	//   "MAXIMIZE_AU_PRC" - Maximize the area under the precision-recall curve.
	//
	// CLASSIFICATION_MULTI_CLASS :
	//   "MINIMIZE_LOG_LOSS" (default) - Minimize log loss.
	//
	// CLASSIFICATION_MULTI_LABEL:
	//   "MINIMIZE_LOG_LOSS" (default) - Minimize log loss.
	//
	// REGRESSION:
	//   "MINIMIZE_RMSE" (default) - Minimize root-mean-squared error (RMSE).
	//   "MINIMIZE_MAE" - Minimize mean-absolute error (MAE).
	//   "MINIMIZE_RMSLE" - Minimize root-mean-squared log error (RMSLE).
	//
	// FORECASTING:
	//   "MINIMIZE_RMSE" (default) - Minimize root-mean-squared error (RMSE).
	//   "MINIMIZE_MAE" - Minimize mean-absolute error (MAE).
	OptimizationObjective string `protobuf:"bytes,4,opt,name=optimization_objective,json=optimizationObjective,proto3" json:"optimization_objective,omitempty"`
	// Output only. Auxiliary information for each of the
	// input_feature_column_specs, with respect to this particular model.
	TablesModelColumnInfo []*TablesModelColumnInfo `protobuf:"bytes,5,rep,name=tables_model_column_info,json=tablesModelColumnInfo,proto3" json:"tables_model_column_info,omitempty"`
	// The train budget of creating this model, expressed in milli node hours
	// i.e. 1,000 value in this field means 1 node hour.
	//
	// The training cost of the model will not exceed this budget. The final cost
	// will be attempted to be close to the budget, though may end up being (even)
	// noticeably smaller - at the backend's discretion. This especially may
	// happen when further model training ceases to provide any improvements.
	//
	// If the budget is set to a value known to be insufficient to train a
	// model for the given dataset, the training won't be attempted and
	// will error.
	TrainBudgetMilliNodeHours int64 `protobuf:"varint,6,opt,name=train_budget_milli_node_hours,json=trainBudgetMilliNodeHours,proto3" json:"train_budget_milli_node_hours,omitempty"`
	// Output only. The actual training cost of the model, expressed in milli
	// node hours, i.e. 1,000 value in this field means 1 node hour. Guaranteed
	// to not exceed the train budget.
	TrainCostMilliNodeHours int64    `protobuf:"varint,7,opt,name=train_cost_milli_node_hours,json=trainCostMilliNodeHours,proto3" json:"train_cost_milli_node_hours,omitempty"`
	XXX_NoUnkeyedLiteral    struct{} `json:"-"`
	XXX_unrecognized        []byte   `json:"-"`
	XXX_sizecache           int32    `json:"-"`
}

func (m *TablesModelMetadata) Reset()         { *m = TablesModelMetadata{} }
func (m *TablesModelMetadata) String() string { return proto.CompactTextString(m) }
func (*TablesModelMetadata) ProtoMessage()    {}
func (*TablesModelMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_tables_2ffb928805ee705e, []int{1}
}
func (m *TablesModelMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TablesModelMetadata.Unmarshal(m, b)
}
func (m *TablesModelMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TablesModelMetadata.Marshal(b, m, deterministic)
}
func (dst *TablesModelMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TablesModelMetadata.Merge(dst, src)
}
func (m *TablesModelMetadata) XXX_Size() int {
	return xxx_messageInfo_TablesModelMetadata.Size(m)
}
func (m *TablesModelMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_TablesModelMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_TablesModelMetadata proto.InternalMessageInfo

func (m *TablesModelMetadata) GetTargetColumnSpec() *ColumnSpec {
	if m != nil {
		return m.TargetColumnSpec
	}
	return nil
}

func (m *TablesModelMetadata) GetInputFeatureColumnSpecs() []*ColumnSpec {
	if m != nil {
		return m.InputFeatureColumnSpecs
	}
	return nil
}

func (m *TablesModelMetadata) GetOptimizationObjective() string {
	if m != nil {
		return m.OptimizationObjective
	}
	return ""
}

func (m *TablesModelMetadata) GetTablesModelColumnInfo() []*TablesModelColumnInfo {
	if m != nil {
		return m.TablesModelColumnInfo
	}
	return nil
}

func (m *TablesModelMetadata) GetTrainBudgetMilliNodeHours() int64 {
	if m != nil {
		return m.TrainBudgetMilliNodeHours
	}
	return 0
}

func (m *TablesModelMetadata) GetTrainCostMilliNodeHours() int64 {
	if m != nil {
		return m.TrainCostMilliNodeHours
	}
	return 0
}

// Contains annotation details specific to Tables.
type TablesAnnotation struct {
	// Output only. A confidence estimate between 0.0 and 1.0, inclusive. A higher
	// value means greater confidence in the returned value.
	// For
	//
	// [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
	// of ARRAY(CATEGORY) data type, this is a confidence that one of the values
	// in the ARRAY would be the provided value.
	// For
	//
	// [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
	// of FLOAT64 data type the score is not populated.
	Score float32 `protobuf:"fixed32,1,opt,name=score,proto3" json:"score,omitempty"`
	// Output only. Only populated when
	//
	// [target_column_spec][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec]
	// has FLOAT64 data type (i.e. for regression predictions). An interval in
	// which the exactly correct target value has 95% chance to be in.
	PredictionInterval *DoubleRange `protobuf:"bytes,4,opt,name=prediction_interval,json=predictionInterval,proto3" json:"prediction_interval,omitempty"`
	// The predicted value of the row's
	//
	// [target_column][google.cloud.automl.v1beta1.TablesModelMetadata.target_column_spec].
	// The value depends on the column's DataType:
	// CATEGORY - the predicted (with the above confidence `score`) CATEGORY
	//            value.
	// FLOAT64 - the predicted (with the above confidence `score`) FLOAT64 value.
	// ARRAY(CATEGORY) - CATEGORY value meaning that this value would be in the
	//                   ARRAY in that column (with the above confidence `score`).
	Value *_struct.Value `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Output only. Auxiliary information for each of the model's
	//
	// [input_feature_column_specs'][google.cloud.automl.v1beta1.TablesModelMetadata.input_feature_column_specs]
	// with respect to this particular prediction.
	TablesModelColumnInfo []*TablesModelColumnInfo `protobuf:"bytes,3,rep,name=tables_model_column_info,json=tablesModelColumnInfo,proto3" json:"tables_model_column_info,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}                 `json:"-"`
	XXX_unrecognized      []byte                   `json:"-"`
	XXX_sizecache         int32                    `json:"-"`
}

func (m *TablesAnnotation) Reset()         { *m = TablesAnnotation{} }
func (m *TablesAnnotation) String() string { return proto.CompactTextString(m) }
func (*TablesAnnotation) ProtoMessage()    {}
func (*TablesAnnotation) Descriptor() ([]byte, []int) {
	return fileDescriptor_tables_2ffb928805ee705e, []int{2}
}
func (m *TablesAnnotation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TablesAnnotation.Unmarshal(m, b)
}
func (m *TablesAnnotation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TablesAnnotation.Marshal(b, m, deterministic)
}
func (dst *TablesAnnotation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TablesAnnotation.Merge(dst, src)
}
func (m *TablesAnnotation) XXX_Size() int {
	return xxx_messageInfo_TablesAnnotation.Size(m)
}
func (m *TablesAnnotation) XXX_DiscardUnknown() {
	xxx_messageInfo_TablesAnnotation.DiscardUnknown(m)
}

var xxx_messageInfo_TablesAnnotation proto.InternalMessageInfo

func (m *TablesAnnotation) GetScore() float32 {
	if m != nil {
		return m.Score
	}
	return 0
}

func (m *TablesAnnotation) GetPredictionInterval() *DoubleRange {
	if m != nil {
		return m.PredictionInterval
	}
	return nil
}

func (m *TablesAnnotation) GetValue() *_struct.Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *TablesAnnotation) GetTablesModelColumnInfo() []*TablesModelColumnInfo {
	if m != nil {
		return m.TablesModelColumnInfo
	}
	return nil
}

// An information specific to given column and Tables Model, in context
// of the Model and the predictions created by it.
type TablesModelColumnInfo struct {
	// Output only. The name of the ColumnSpec describing the column. Not
	// populated when this proto is outputted to BigQuery.
	ColumnSpecName string `protobuf:"bytes,1,opt,name=column_spec_name,json=columnSpecName,proto3" json:"column_spec_name,omitempty"`
	// Output only. The display name of the column (same as the display_name of
	// its ColumnSpec).
	ColumnDisplayName string `protobuf:"bytes,2,opt,name=column_display_name,json=columnDisplayName,proto3" json:"column_display_name,omitempty"`
	// Output only.
	//
	// When given as part of a Model:
	// Measurement of how much model predictions correctness on the TEST data
	// depend on values in this column. A value between 0 and 1, higher means
	// higher influence. These values are normalized - for all input feature
	// columns of a given model they add to 1.
	//
	// When given back by Predict or Batch Predict:
	// Measurement of how impactful for the prediction returned for the given row
	// the value in this column was. A value between 0 and 1, higher means larger
	// impact. These values are normalized - for all input feature columns of a
	// single predicted row they add to 1.
	FeatureImportance    float32  `protobuf:"fixed32,3,opt,name=feature_importance,json=featureImportance,proto3" json:"feature_importance,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *TablesModelColumnInfo) Reset()         { *m = TablesModelColumnInfo{} }
func (m *TablesModelColumnInfo) String() string { return proto.CompactTextString(m) }
func (*TablesModelColumnInfo) ProtoMessage()    {}
func (*TablesModelColumnInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_tables_2ffb928805ee705e, []int{3}
}
func (m *TablesModelColumnInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TablesModelColumnInfo.Unmarshal(m, b)
}
func (m *TablesModelColumnInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TablesModelColumnInfo.Marshal(b, m, deterministic)
}
func (dst *TablesModelColumnInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TablesModelColumnInfo.Merge(dst, src)
}
func (m *TablesModelColumnInfo) XXX_Size() int {
	return xxx_messageInfo_TablesModelColumnInfo.Size(m)
}
func (m *TablesModelColumnInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_TablesModelColumnInfo.DiscardUnknown(m)
}

var xxx_messageInfo_TablesModelColumnInfo proto.InternalMessageInfo

func (m *TablesModelColumnInfo) GetColumnSpecName() string {
	if m != nil {
		return m.ColumnSpecName
	}
	return ""
}

func (m *TablesModelColumnInfo) GetColumnDisplayName() string {
	if m != nil {
		return m.ColumnDisplayName
	}
	return ""
}

func (m *TablesModelColumnInfo) GetFeatureImportance() float32 {
	if m != nil {
		return m.FeatureImportance
	}
	return 0
}

func init() {
	proto.RegisterType((*TablesDatasetMetadata)(nil), "google.cloud.automl.v1beta1.TablesDatasetMetadata")
	proto.RegisterMapType((map[string]*CorrelationStats)(nil), "google.cloud.automl.v1beta1.TablesDatasetMetadata.TargetColumnCorrelationsEntry")
	proto.RegisterType((*TablesModelMetadata)(nil), "google.cloud.automl.v1beta1.TablesModelMetadata")
	proto.RegisterType((*TablesAnnotation)(nil), "google.cloud.automl.v1beta1.TablesAnnotation")
	proto.RegisterType((*TablesModelColumnInfo)(nil), "google.cloud.automl.v1beta1.TablesModelColumnInfo")
}

func init() {
	proto.RegisterFile("google/cloud/automl/v1beta1/tables.proto", fileDescriptor_tables_2ffb928805ee705e)
}

var fileDescriptor_tables_2ffb928805ee705e = []byte{
	// 797 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0xcd, 0x6e, 0xdb, 0x38,
	0x10, 0x86, 0xec, 0xfc, 0x60, 0x69, 0x60, 0xd7, 0x66, 0xd6, 0x89, 0xd7, 0xd9, 0x20, 0x81, 0x2f,
	0xeb, 0x43, 0x22, 0x6d, 0x5c, 0x14, 0x28, 0xda, 0x1e, 0x9a, 0x38, 0x4d, 0xeb, 0x83, 0xd3, 0x40,
	0xf9, 0x01, 0x5a, 0x04, 0x10, 0x68, 0x89, 0x56, 0xd8, 0x50, 0xa4, 0x40, 0x51, 0x2e, 0x9c, 0x73,
	0xcf, 0x7d, 0x84, 0xa2, 0x6f, 0xd1, 0x77, 0xe8, 0x03, 0xf5, 0x5c, 0x90, 0x94, 0x1c, 0xdb, 0x71,
	0xd5, 0x1c, 0x7a, 0xb3, 0xf8, 0x7d, 0xdf, 0x70, 0x66, 0xbe, 0xe1, 0x18, 0xb4, 0x43, 0xce, 0x43,
	0x8a, 0x1d, 0x9f, 0xf2, 0x34, 0x70, 0x50, 0x2a, 0x79, 0x44, 0x9d, 0xd1, 0xfe, 0x00, 0x4b, 0xb4,
	0xef, 0x48, 0x34, 0xa0, 0x38, 0xb1, 0x63, 0xc1, 0x25, 0x87, 0x9b, 0x86, 0x69, 0x6b, 0xa6, 0x6d,
	0x98, 0x76, 0xc6, 0x6c, 0xfe, 0x9b, 0x85, 0x41, 0x31, 0x71, 0x10, 0x63, 0x5c, 0x22, 0x49, 0x38,
	0xcb, 0xa4, 0xcd, 0xbd, 0xa2, 0x4b, 0x7c, 0x4e, 0xd3, 0x88, 0x79, 0x49, 0x8c, 0xfd, 0x8c, 0xbe,
	0x5b, 0x44, 0x0f, 0x90, 0x44, 0x5e, 0x22, 0x91, 0xcc, 0x83, 0x17, 0x56, 0x20, 0x10, 0x0b, 0xf3,
	0x0a, 0x26, 0x49, 0xea, 0xaf, 0x41, 0x3a, 0x74, 0x12, 0x29, 0x52, 0x5f, 0x66, 0xe8, 0xf6, 0x3c,
	0x2a, 0x49, 0x84, 0x13, 0x89, 0xa2, 0xd8, 0x10, 0x5a, 0x5f, 0x97, 0x40, 0xfd, 0x5c, 0x77, 0xe4,
	0x08, 0x49, 0x94, 0x60, 0xd9, 0xc7, 0x12, 0xa9, 0x74, 0xe0, 0x3e, 0xa8, 0xc7, 0x82, 0x44, 0x48,
	0x8c, 0x3d, 0xdd, 0x32, 0x5d, 0x8c, 0x47, 0x82, 0x86, 0xb5, 0x63, 0xb5, 0xff, 0x70, 0x61, 0x06,
	0x6a, 0xf1, 0x59, 0x8c, 0xfd, 0x5e, 0xa0, 0x24, 0x12, 0x89, 0x10, 0x4b, 0x6f, 0xaa, 0x7e, 0x25,
	0x29, 0x19, 0x89, 0x01, 0xbb, 0x1a, 0xbb, 0x93, 0x7c, 0xc0, 0x24, 0xbc, 0xbe, 0x27, 0x29, 0x1b,
	0x89, 0x01, 0x67, 0x24, 0xff, 0x83, 0x7a, 0x44, 0xbd, 0x34, 0xc1, 0xf3, 0x92, 0x25, 0x2d, 0xa9,
	0x45, 0xf4, 0x22, 0xc1, 0x33, 0x8a, 0x4f, 0x16, 0x68, 0xce, 0x26, 0xe6, 0x73, 0x21, 0x30, 0x35,
	0x7e, 0x36, 0x56, 0x76, 0xca, 0xed, 0x4a, 0xe7, 0xd4, 0x2e, 0x98, 0x05, 0x7b, 0x61, 0x8f, 0xec,
	0xf3, 0xa9, 0x82, 0xba, 0x53, 0x21, 0x5f, 0x32, 0x29, 0xc6, 0x6e, 0x43, 0xfe, 0x04, 0x86, 0xc7,
	0xa0, 0xa6, 0xdd, 0xf6, 0xd2, 0x38, 0x40, 0x12, 0x7b, 0xca, 0x95, 0xc6, 0xea, 0x8e, 0xd5, 0xae,
	0x74, 0x9a, 0x79, 0x1a, 0xb9, 0x65, 0xf6, 0x79, 0x6e, 0x99, 0xfb, 0x97, 0x16, 0x5d, 0x68, 0x8d,
	0x3a, 0x6d, 0xde, 0x82, 0xad, 0xc2, 0x14, 0x60, 0x15, 0x94, 0x6f, 0xf0, 0x38, 0xb3, 0x4c, 0xfd,
	0x84, 0x5d, 0xb0, 0x3c, 0x42, 0x34, 0xc5, 0xda, 0x93, 0x4a, 0x67, 0xaf, 0xb0, 0xea, 0xa9, 0x80,
	0x67, 0xea, 0x6a, 0xd7, 0x68, 0x9f, 0x96, 0x9e, 0x58, 0xad, 0xef, 0x65, 0xb0, 0x66, 0xba, 0xd2,
	0xe7, 0x01, 0xa6, 0x93, 0xb9, 0xb9, 0x00, 0xf0, 0xfe, 0x10, 0x64, 0xb7, 0xfd, 0xf7, 0x8b, 0xdb,
	0x72, 0xcf, 0xdc, 0xea, 0xfc, 0xa8, 0xc0, 0x00, 0x34, 0x09, 0x8b, 0x53, 0xe9, 0x0d, 0x31, 0x92,
	0xa9, 0x98, 0x31, 0x3f, 0x69, 0x94, 0xb5, 0x85, 0x0f, 0x0e, 0xbf, 0xa1, 0x43, 0x1d, 0x9b, 0x48,
	0x77, 0xe7, 0x09, 0x7c, 0x0c, 0xd6, 0x79, 0x2c, 0x49, 0x44, 0x6e, 0x75, 0xd1, 0x1e, 0x1f, 0xbc,
	0xc7, 0xbe, 0x24, 0x23, 0x9c, 0x0d, 0x57, 0x7d, 0x1a, 0x7d, 0x93, 0x83, 0xf0, 0x06, 0x34, 0xcc,
	0x5a, 0xf1, 0x22, 0xd5, 0x8b, 0x3c, 0x37, 0xc2, 0x86, 0xbc, 0xb1, 0xac, 0x53, 0xeb, 0x3c, 0x60,
	0xba, 0x74, 0x1f, 0x4d, 0x36, 0x3d, 0x36, 0xe4, 0x6e, 0x5d, 0x2e, 0x3a, 0x86, 0x2f, 0xc0, 0x96,
	0x14, 0x88, 0x30, 0x6f, 0x90, 0x06, 0xaa, 0xcd, 0x11, 0xa1, 0x94, 0x78, 0x8c, 0x07, 0xd8, 0xbb,
	0xe6, 0xa9, 0x50, 0xf3, 0x6c, 0xb5, 0xcb, 0xee, 0x3f, 0x9a, 0x74, 0xa8, 0x39, 0x7d, 0x45, 0x39,
	0xe1, 0x01, 0x7e, 0xad, 0x08, 0xf0, 0x39, 0xd8, 0x34, 0x11, 0x7c, 0x9e, 0x2c, 0xd0, 0xaf, 0x6a,
	0xfd, 0x86, 0xa6, 0x74, 0x79, 0x32, 0xa7, 0x6e, 0x7d, 0x2e, 0x81, 0xaa, 0x49, 0xf8, 0x60, 0xb2,
	0x14, 0xe1, 0xdf, 0x60, 0x39, 0xf1, 0xb9, 0xc0, 0x7a, 0xd4, 0x4a, 0xae, 0xf9, 0x80, 0x6f, 0xc1,
	0x5a, 0x2c, 0x70, 0x40, 0x7c, 0xdd, 0x4c, 0xc2, 0x24, 0x16, 0x23, 0x44, 0x75, 0x2f, 0x2b, 0x9d,
	0x76, 0x61, 0x4b, 0x8e, 0x78, 0x3a, 0xa0, 0xd8, 0x55, 0xab, 0x4e, 0xed, 0x9a, 0x3c, 0x48, 0x2f,
	0x8b, 0x01, 0x77, 0x67, 0xe7, 0x78, 0xfd, 0xde, 0xb3, 0xb9, 0x54, 0x68, 0x36, 0xb0, 0x85, 0x06,
	0x95, 0x7f, 0xb3, 0x41, 0xad, 0x2f, 0x56, 0xbe, 0x53, 0xe7, 0xad, 0x6b, 0x83, 0xea, 0xf4, 0xce,
	0x62, 0x28, 0xc2, 0xd9, 0xdb, 0xfc, 0xd3, 0x9f, 0x4c, 0xe1, 0x09, 0x8a, 0x30, 0xb4, 0xc1, 0x5a,
	0xc6, 0x0c, 0x48, 0x12, 0x53, 0x34, 0x36, 0x64, 0xb3, 0x48, 0x6b, 0x06, 0x3a, 0x32, 0x88, 0xe6,
	0xef, 0x01, 0x98, 0x3f, 0x0c, 0x12, 0xc5, 0x5c, 0x48, 0xc4, 0x7c, 0xac, 0x97, 0x68, 0xc9, 0xad,
	0x65, 0x48, 0x6f, 0x02, 0x1c, 0x7e, 0xb4, 0xc0, 0xb6, 0xcf, 0xa3, 0xa2, 0x9a, 0x4f, 0xad, 0x77,
	0x07, 0x19, 0x1c, 0x72, 0x8a, 0x58, 0x68, 0x73, 0x11, 0x3a, 0x21, 0x66, 0xba, 0xc3, 0x8e, 0x81,
	0x50, 0x4c, 0x92, 0x85, 0x7f, 0x52, 0xcf, 0xcc, 0xe7, 0xb7, 0xd2, 0xe6, 0x2b, 0x4d, 0xbc, 0xea,
	0x2a, 0xd2, 0xd5, 0x41, 0x2a, 0x79, 0x9f, 0x5e, 0x5d, 0x1a, 0xd2, 0x60, 0x45, 0xc7, 0x7a, 0xf4,
	0x23, 0x00, 0x00, 0xff, 0xff, 0x13, 0x68, 0xa2, 0x3d, 0xb1, 0x07, 0x00, 0x00,
}
