// Package xselinux is the X client API for the SELinux extension.
package xselinux

// This file is automatically generated from xselinux.xml. Edit at your peril!

import (
	"github.com/BurntSushi/xgb"

	"github.com/BurntSushi/xgb/xproto"
)

// Init must be called before using the SELinux extension.
func Init(c *xgb.Conn) error {
	reply, err := xproto.QueryExtension(c, 7, "SELinux").Reply()
	switch {
	case err != nil:
		return err
	case !reply.Present:
		return xgb.Errorf("No extension named SELinux could be found on on the server.")
	}

	c.ExtLock.Lock()
	c.Extensions["SELinux"] = reply.MajorOpcode
	c.ExtLock.Unlock()
	for evNum, fun := range xgb.NewExtEventFuncs["SELinux"] {
		xgb.NewEventFuncs[int(reply.FirstEvent)+evNum] = fun
	}
	for errNum, fun := range xgb.NewExtErrorFuncs["SELinux"] {
		xgb.NewErrorFuncs[int(reply.FirstError)+errNum] = fun
	}
	return nil
}

func init() {
	xgb.NewExtEventFuncs["SELinux"] = make(map[int]xgb.NewEventFun)
	xgb.NewExtErrorFuncs["SELinux"] = make(map[int]xgb.NewErrorFun)
}

type ListItem struct {
	Name             xproto.Atom
	ObjectContextLen uint32
	DataContextLen   uint32
	ObjectContext    string // size: xgb.Pad((int(ObjectContextLen) * 1))
	DataContext      string // size: xgb.Pad((int(DataContextLen) * 1))
}

// ListItemRead reads a byte slice into a ListItem value.
func ListItemRead(buf []byte, v *ListItem) int {
	b := 0

	v.Name = xproto.Atom(xgb.Get32(buf[b:]))
	b += 4

	v.ObjectContextLen = xgb.Get32(buf[b:])
	b += 4

	v.DataContextLen = xgb.Get32(buf[b:])
	b += 4

	{
		byteString := make([]byte, v.ObjectContextLen)
		copy(byteString[:v.ObjectContextLen], buf[b:])
		v.ObjectContext = string(byteString)
		b += int(v.ObjectContextLen)
	}

	{
		byteString := make([]byte, v.DataContextLen)
		copy(byteString[:v.DataContextLen], buf[b:])
		v.DataContext = string(byteString)
		b += int(v.DataContextLen)
	}

	return b
}

// ListItemReadList reads a byte slice into a list of ListItem values.
func ListItemReadList(buf []byte, dest []ListItem) int {
	b := 0
	for i := 0; i < len(dest); i++ {
		dest[i] = ListItem{}
		b += ListItemRead(buf[b:], &dest[i])
	}
	return xgb.Pad(b)
}

// Bytes writes a ListItem value to a byte slice.
func (v ListItem) Bytes() []byte {
	buf := make([]byte, ((12 + xgb.Pad((int(v.ObjectContextLen) * 1))) + xgb.Pad((int(v.DataContextLen) * 1))))
	b := 0

	xgb.Put32(buf[b:], uint32(v.Name))
	b += 4

	xgb.Put32(buf[b:], v.ObjectContextLen)
	b += 4

	xgb.Put32(buf[b:], v.DataContextLen)
	b += 4

	copy(buf[b:], v.ObjectContext[:v.ObjectContextLen])
	b += int(v.ObjectContextLen)

	copy(buf[b:], v.DataContext[:v.DataContextLen])
	b += int(v.DataContextLen)

	return buf[:b]
}

// ListItemListBytes writes a list of ListItem values to a byte slice.
func ListItemListBytes(buf []byte, list []ListItem) int {
	b := 0
	var structBytes []byte
	for _, item := range list {
		structBytes = item.Bytes()
		copy(buf[b:], structBytes)
		b += len(structBytes)
	}
	return xgb.Pad(b)
}

// ListItemListSize computes the size (bytes) of a list of ListItem values.
func ListItemListSize(list []ListItem) int {
	size := 0
	for _, item := range list {
		size += ((12 + xgb.Pad((int(item.ObjectContextLen) * 1))) + xgb.Pad((int(item.DataContextLen) * 1)))
	}
	return size
}

// Skipping definition for base type 'Bool'

// Skipping definition for base type 'Byte'

// Skipping definition for base type 'Card8'

// Skipping definition for base type 'Char'

// Skipping definition for base type 'Void'

// Skipping definition for base type 'Double'

// Skipping definition for base type 'Float'

// Skipping definition for base type 'Int16'

// Skipping definition for base type 'Int32'

// Skipping definition for base type 'Int8'

// Skipping definition for base type 'Card16'

// Skipping definition for base type 'Card32'

// GetClientContextCookie is a cookie used only for GetClientContext requests.
type GetClientContextCookie struct {
	*xgb.Cookie
}

// GetClientContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetClientContextCookie.Reply()
func GetClientContext(c *xgb.Conn, Resource uint32) GetClientContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetClientContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getClientContextRequest(c, Resource), cookie)
	return GetClientContextCookie{cookie}
}

// GetClientContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetClientContextUnchecked(c *xgb.Conn, Resource uint32) GetClientContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetClientContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getClientContextRequest(c, Resource), cookie)
	return GetClientContextCookie{cookie}
}

// GetClientContextReply represents the data returned from a GetClientContext request.
type GetClientContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ContextLen uint32
	// padding: 20 bytes
	Context string // size: xgb.Pad((int(ContextLen) * 1))
}

// Reply blocks and returns the reply data for a GetClientContext request.
func (cook GetClientContextCookie) Reply() (*GetClientContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getClientContextReply(buf), nil
}

// getClientContextReply reads a byte slice into a GetClientContextReply value.
func getClientContextReply(buf []byte) *GetClientContextReply {
	v := new(GetClientContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ContextLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	{
		byteString := make([]byte, v.ContextLen)
		copy(byteString[:v.ContextLen], buf[b:])
		v.Context = string(byteString)
		b += int(v.ContextLen)
	}

	return v
}

// Write request to wire for GetClientContext
// getClientContextRequest writes a GetClientContext request to a byte slice.
func getClientContextRequest(c *xgb.Conn, Resource uint32) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 22 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Resource)
	b += 4

	return buf
}

// GetDeviceContextCookie is a cookie used only for GetDeviceContext requests.
type GetDeviceContextCookie struct {
	*xgb.Cookie
}

// GetDeviceContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetDeviceContextCookie.Reply()
func GetDeviceContext(c *xgb.Conn, Device uint32) GetDeviceContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetDeviceContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getDeviceContextRequest(c, Device), cookie)
	return GetDeviceContextCookie{cookie}
}

// GetDeviceContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetDeviceContextUnchecked(c *xgb.Conn, Device uint32) GetDeviceContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetDeviceContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getDeviceContextRequest(c, Device), cookie)
	return GetDeviceContextCookie{cookie}
}

// GetDeviceContextReply represents the data returned from a GetDeviceContext request.
type GetDeviceContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ContextLen uint32
	// padding: 20 bytes
	Context string // size: xgb.Pad((int(ContextLen) * 1))
}

// Reply blocks and returns the reply data for a GetDeviceContext request.
func (cook GetDeviceContextCookie) Reply() (*GetDeviceContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getDeviceContextReply(buf), nil
}

// getDeviceContextReply reads a byte slice into a GetDeviceContextReply value.
func getDeviceContextReply(buf []byte) *GetDeviceContextReply {
	v := new(GetDeviceContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ContextLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	{
		byteString := make([]byte, v.ContextLen)
		copy(byteString[:v.ContextLen], buf[b:])
		v.Context = string(byteString)
		b += int(v.ContextLen)
	}

	return v
}

// Write request to wire for GetDeviceContext
// getDeviceContextRequest writes a GetDeviceContext request to a byte slice.
func getDeviceContextRequest(c *xgb.Conn, Device uint32) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 4 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Device)
	b += 4

	return buf
}

// GetDeviceCreateContextCookie is a cookie used only for GetDeviceCreateContext requests.
type GetDeviceCreateContextCookie struct {
	*xgb.Cookie
}

// GetDeviceCreateContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetDeviceCreateContextCookie.Reply()
func GetDeviceCreateContext(c *xgb.Conn) GetDeviceCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetDeviceCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getDeviceCreateContextRequest(c), cookie)
	return GetDeviceCreateContextCookie{cookie}
}

// GetDeviceCreateContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetDeviceCreateContextUnchecked(c *xgb.Conn) GetDeviceCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetDeviceCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getDeviceCreateContextRequest(c), cookie)
	return GetDeviceCreateContextCookie{cookie}
}

// GetDeviceCreateContextReply represents the data returned from a GetDeviceCreateContext request.
type GetDeviceCreateContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ContextLen uint32
	// padding: 20 bytes
	Context string // size: xgb.Pad((int(ContextLen) * 1))
}

// Reply blocks and returns the reply data for a GetDeviceCreateContext request.
func (cook GetDeviceCreateContextCookie) Reply() (*GetDeviceCreateContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getDeviceCreateContextReply(buf), nil
}

// getDeviceCreateContextReply reads a byte slice into a GetDeviceCreateContextReply value.
func getDeviceCreateContextReply(buf []byte) *GetDeviceCreateContextReply {
	v := new(GetDeviceCreateContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ContextLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	{
		byteString := make([]byte, v.ContextLen)
		copy(byteString[:v.ContextLen], buf[b:])
		v.Context = string(byteString)
		b += int(v.ContextLen)
	}

	return v
}

// Write request to wire for GetDeviceCreateContext
// getDeviceCreateContextRequest writes a GetDeviceCreateContext request to a byte slice.
func getDeviceCreateContextRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 2 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// GetPropertyContextCookie is a cookie used only for GetPropertyContext requests.
type GetPropertyContextCookie struct {
	*xgb.Cookie
}

// GetPropertyContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetPropertyContextCookie.Reply()
func GetPropertyContext(c *xgb.Conn, Window xproto.Window, Property xproto.Atom) GetPropertyContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetPropertyContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getPropertyContextRequest(c, Window, Property), cookie)
	return GetPropertyContextCookie{cookie}
}

// GetPropertyContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetPropertyContextUnchecked(c *xgb.Conn, Window xproto.Window, Property xproto.Atom) GetPropertyContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetPropertyContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getPropertyContextRequest(c, Window, Property), cookie)
	return GetPropertyContextCookie{cookie}
}

// GetPropertyContextReply represents the data returned from a GetPropertyContext request.
type GetPropertyContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ContextLen uint32
	// padding: 20 bytes
	Context string // size: xgb.Pad((int(ContextLen) * 1))
}

// Reply blocks and returns the reply data for a GetPropertyContext request.
func (cook GetPropertyContextCookie) Reply() (*GetPropertyContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getPropertyContextReply(buf), nil
}

// getPropertyContextReply reads a byte slice into a GetPropertyContextReply value.
func getPropertyContextReply(buf []byte) *GetPropertyContextReply {
	v := new(GetPropertyContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ContextLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	{
		byteString := make([]byte, v.ContextLen)
		copy(byteString[:v.ContextLen], buf[b:])
		v.Context = string(byteString)
		b += int(v.ContextLen)
	}

	return v
}

// Write request to wire for GetPropertyContext
// getPropertyContextRequest writes a GetPropertyContext request to a byte slice.
func getPropertyContextRequest(c *xgb.Conn, Window xproto.Window, Property xproto.Atom) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 12 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	xgb.Put32(buf[b:], uint32(Property))
	b += 4

	return buf
}

// GetPropertyCreateContextCookie is a cookie used only for GetPropertyCreateContext requests.
type GetPropertyCreateContextCookie struct {
	*xgb.Cookie
}

// GetPropertyCreateContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetPropertyCreateContextCookie.Reply()
func GetPropertyCreateContext(c *xgb.Conn) GetPropertyCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetPropertyCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getPropertyCreateContextRequest(c), cookie)
	return GetPropertyCreateContextCookie{cookie}
}

// GetPropertyCreateContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetPropertyCreateContextUnchecked(c *xgb.Conn) GetPropertyCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetPropertyCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getPropertyCreateContextRequest(c), cookie)
	return GetPropertyCreateContextCookie{cookie}
}

// GetPropertyCreateContextReply represents the data returned from a GetPropertyCreateContext request.
type GetPropertyCreateContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ContextLen uint32
	// padding: 20 bytes
	Context string // size: xgb.Pad((int(ContextLen) * 1))
}

// Reply blocks and returns the reply data for a GetPropertyCreateContext request.
func (cook GetPropertyCreateContextCookie) Reply() (*GetPropertyCreateContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getPropertyCreateContextReply(buf), nil
}

// getPropertyCreateContextReply reads a byte slice into a GetPropertyCreateContextReply value.
func getPropertyCreateContextReply(buf []byte) *GetPropertyCreateContextReply {
	v := new(GetPropertyCreateContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ContextLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	{
		byteString := make([]byte, v.ContextLen)
		copy(byteString[:v.ContextLen], buf[b:])
		v.Context = string(byteString)
		b += int(v.ContextLen)
	}

	return v
}

// Write request to wire for GetPropertyCreateContext
// getPropertyCreateContextRequest writes a GetPropertyCreateContext request to a byte slice.
func getPropertyCreateContextRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 9 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// GetPropertyDataContextCookie is a cookie used only for GetPropertyDataContext requests.
type GetPropertyDataContextCookie struct {
	*xgb.Cookie
}

// GetPropertyDataContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetPropertyDataContextCookie.Reply()
func GetPropertyDataContext(c *xgb.Conn, Window xproto.Window, Property xproto.Atom) GetPropertyDataContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetPropertyDataContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getPropertyDataContextRequest(c, Window, Property), cookie)
	return GetPropertyDataContextCookie{cookie}
}

// GetPropertyDataContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetPropertyDataContextUnchecked(c *xgb.Conn, Window xproto.Window, Property xproto.Atom) GetPropertyDataContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetPropertyDataContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getPropertyDataContextRequest(c, Window, Property), cookie)
	return GetPropertyDataContextCookie{cookie}
}

// GetPropertyDataContextReply represents the data returned from a GetPropertyDataContext request.
type GetPropertyDataContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ContextLen uint32
	// padding: 20 bytes
	Context string // size: xgb.Pad((int(ContextLen) * 1))
}

// Reply blocks and returns the reply data for a GetPropertyDataContext request.
func (cook GetPropertyDataContextCookie) Reply() (*GetPropertyDataContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getPropertyDataContextReply(buf), nil
}

// getPropertyDataContextReply reads a byte slice into a GetPropertyDataContextReply value.
func getPropertyDataContextReply(buf []byte) *GetPropertyDataContextReply {
	v := new(GetPropertyDataContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ContextLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	{
		byteString := make([]byte, v.ContextLen)
		copy(byteString[:v.ContextLen], buf[b:])
		v.Context = string(byteString)
		b += int(v.ContextLen)
	}

	return v
}

// Write request to wire for GetPropertyDataContext
// getPropertyDataContextRequest writes a GetPropertyDataContext request to a byte slice.
func getPropertyDataContextRequest(c *xgb.Conn, Window xproto.Window, Property xproto.Atom) []byte {
	size := 12
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 13 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	xgb.Put32(buf[b:], uint32(Property))
	b += 4

	return buf
}

// GetPropertyUseContextCookie is a cookie used only for GetPropertyUseContext requests.
type GetPropertyUseContextCookie struct {
	*xgb.Cookie
}

// GetPropertyUseContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetPropertyUseContextCookie.Reply()
func GetPropertyUseContext(c *xgb.Conn) GetPropertyUseContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetPropertyUseContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getPropertyUseContextRequest(c), cookie)
	return GetPropertyUseContextCookie{cookie}
}

// GetPropertyUseContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetPropertyUseContextUnchecked(c *xgb.Conn) GetPropertyUseContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetPropertyUseContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getPropertyUseContextRequest(c), cookie)
	return GetPropertyUseContextCookie{cookie}
}

// GetPropertyUseContextReply represents the data returned from a GetPropertyUseContext request.
type GetPropertyUseContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ContextLen uint32
	// padding: 20 bytes
	Context string // size: xgb.Pad((int(ContextLen) * 1))
}

// Reply blocks and returns the reply data for a GetPropertyUseContext request.
func (cook GetPropertyUseContextCookie) Reply() (*GetPropertyUseContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getPropertyUseContextReply(buf), nil
}

// getPropertyUseContextReply reads a byte slice into a GetPropertyUseContextReply value.
func getPropertyUseContextReply(buf []byte) *GetPropertyUseContextReply {
	v := new(GetPropertyUseContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ContextLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	{
		byteString := make([]byte, v.ContextLen)
		copy(byteString[:v.ContextLen], buf[b:])
		v.Context = string(byteString)
		b += int(v.ContextLen)
	}

	return v
}

// Write request to wire for GetPropertyUseContext
// getPropertyUseContextRequest writes a GetPropertyUseContext request to a byte slice.
func getPropertyUseContextRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 11 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// GetSelectionContextCookie is a cookie used only for GetSelectionContext requests.
type GetSelectionContextCookie struct {
	*xgb.Cookie
}

// GetSelectionContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetSelectionContextCookie.Reply()
func GetSelectionContext(c *xgb.Conn, Selection xproto.Atom) GetSelectionContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetSelectionContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getSelectionContextRequest(c, Selection), cookie)
	return GetSelectionContextCookie{cookie}
}

// GetSelectionContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetSelectionContextUnchecked(c *xgb.Conn, Selection xproto.Atom) GetSelectionContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetSelectionContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getSelectionContextRequest(c, Selection), cookie)
	return GetSelectionContextCookie{cookie}
}

// GetSelectionContextReply represents the data returned from a GetSelectionContext request.
type GetSelectionContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ContextLen uint32
	// padding: 20 bytes
	Context string // size: xgb.Pad((int(ContextLen) * 1))
}

// Reply blocks and returns the reply data for a GetSelectionContext request.
func (cook GetSelectionContextCookie) Reply() (*GetSelectionContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getSelectionContextReply(buf), nil
}

// getSelectionContextReply reads a byte slice into a GetSelectionContextReply value.
func getSelectionContextReply(buf []byte) *GetSelectionContextReply {
	v := new(GetSelectionContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ContextLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	{
		byteString := make([]byte, v.ContextLen)
		copy(byteString[:v.ContextLen], buf[b:])
		v.Context = string(byteString)
		b += int(v.ContextLen)
	}

	return v
}

// Write request to wire for GetSelectionContext
// getSelectionContextRequest writes a GetSelectionContext request to a byte slice.
func getSelectionContextRequest(c *xgb.Conn, Selection xproto.Atom) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 19 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Selection))
	b += 4

	return buf
}

// GetSelectionCreateContextCookie is a cookie used only for GetSelectionCreateContext requests.
type GetSelectionCreateContextCookie struct {
	*xgb.Cookie
}

// GetSelectionCreateContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetSelectionCreateContextCookie.Reply()
func GetSelectionCreateContext(c *xgb.Conn) GetSelectionCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetSelectionCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getSelectionCreateContextRequest(c), cookie)
	return GetSelectionCreateContextCookie{cookie}
}

// GetSelectionCreateContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetSelectionCreateContextUnchecked(c *xgb.Conn) GetSelectionCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetSelectionCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getSelectionCreateContextRequest(c), cookie)
	return GetSelectionCreateContextCookie{cookie}
}

// GetSelectionCreateContextReply represents the data returned from a GetSelectionCreateContext request.
type GetSelectionCreateContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ContextLen uint32
	// padding: 20 bytes
	Context string // size: xgb.Pad((int(ContextLen) * 1))
}

// Reply blocks and returns the reply data for a GetSelectionCreateContext request.
func (cook GetSelectionCreateContextCookie) Reply() (*GetSelectionCreateContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getSelectionCreateContextReply(buf), nil
}

// getSelectionCreateContextReply reads a byte slice into a GetSelectionCreateContextReply value.
func getSelectionCreateContextReply(buf []byte) *GetSelectionCreateContextReply {
	v := new(GetSelectionCreateContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ContextLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	{
		byteString := make([]byte, v.ContextLen)
		copy(byteString[:v.ContextLen], buf[b:])
		v.Context = string(byteString)
		b += int(v.ContextLen)
	}

	return v
}

// Write request to wire for GetSelectionCreateContext
// getSelectionCreateContextRequest writes a GetSelectionCreateContext request to a byte slice.
func getSelectionCreateContextRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 16 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// GetSelectionDataContextCookie is a cookie used only for GetSelectionDataContext requests.
type GetSelectionDataContextCookie struct {
	*xgb.Cookie
}

// GetSelectionDataContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetSelectionDataContextCookie.Reply()
func GetSelectionDataContext(c *xgb.Conn, Selection xproto.Atom) GetSelectionDataContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetSelectionDataContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getSelectionDataContextRequest(c, Selection), cookie)
	return GetSelectionDataContextCookie{cookie}
}

// GetSelectionDataContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetSelectionDataContextUnchecked(c *xgb.Conn, Selection xproto.Atom) GetSelectionDataContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetSelectionDataContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getSelectionDataContextRequest(c, Selection), cookie)
	return GetSelectionDataContextCookie{cookie}
}

// GetSelectionDataContextReply represents the data returned from a GetSelectionDataContext request.
type GetSelectionDataContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ContextLen uint32
	// padding: 20 bytes
	Context string // size: xgb.Pad((int(ContextLen) * 1))
}

// Reply blocks and returns the reply data for a GetSelectionDataContext request.
func (cook GetSelectionDataContextCookie) Reply() (*GetSelectionDataContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getSelectionDataContextReply(buf), nil
}

// getSelectionDataContextReply reads a byte slice into a GetSelectionDataContextReply value.
func getSelectionDataContextReply(buf []byte) *GetSelectionDataContextReply {
	v := new(GetSelectionDataContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ContextLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	{
		byteString := make([]byte, v.ContextLen)
		copy(byteString[:v.ContextLen], buf[b:])
		v.Context = string(byteString)
		b += int(v.ContextLen)
	}

	return v
}

// Write request to wire for GetSelectionDataContext
// getSelectionDataContextRequest writes a GetSelectionDataContext request to a byte slice.
func getSelectionDataContextRequest(c *xgb.Conn, Selection xproto.Atom) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 20 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Selection))
	b += 4

	return buf
}

// GetSelectionUseContextCookie is a cookie used only for GetSelectionUseContext requests.
type GetSelectionUseContextCookie struct {
	*xgb.Cookie
}

// GetSelectionUseContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetSelectionUseContextCookie.Reply()
func GetSelectionUseContext(c *xgb.Conn) GetSelectionUseContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetSelectionUseContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getSelectionUseContextRequest(c), cookie)
	return GetSelectionUseContextCookie{cookie}
}

// GetSelectionUseContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetSelectionUseContextUnchecked(c *xgb.Conn) GetSelectionUseContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetSelectionUseContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getSelectionUseContextRequest(c), cookie)
	return GetSelectionUseContextCookie{cookie}
}

// GetSelectionUseContextReply represents the data returned from a GetSelectionUseContext request.
type GetSelectionUseContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ContextLen uint32
	// padding: 20 bytes
	Context string // size: xgb.Pad((int(ContextLen) * 1))
}

// Reply blocks and returns the reply data for a GetSelectionUseContext request.
func (cook GetSelectionUseContextCookie) Reply() (*GetSelectionUseContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getSelectionUseContextReply(buf), nil
}

// getSelectionUseContextReply reads a byte slice into a GetSelectionUseContextReply value.
func getSelectionUseContextReply(buf []byte) *GetSelectionUseContextReply {
	v := new(GetSelectionUseContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ContextLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	{
		byteString := make([]byte, v.ContextLen)
		copy(byteString[:v.ContextLen], buf[b:])
		v.Context = string(byteString)
		b += int(v.ContextLen)
	}

	return v
}

// Write request to wire for GetSelectionUseContext
// getSelectionUseContextRequest writes a GetSelectionUseContext request to a byte slice.
func getSelectionUseContextRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 18 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// GetWindowContextCookie is a cookie used only for GetWindowContext requests.
type GetWindowContextCookie struct {
	*xgb.Cookie
}

// GetWindowContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetWindowContextCookie.Reply()
func GetWindowContext(c *xgb.Conn, Window xproto.Window) GetWindowContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetWindowContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getWindowContextRequest(c, Window), cookie)
	return GetWindowContextCookie{cookie}
}

// GetWindowContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetWindowContextUnchecked(c *xgb.Conn, Window xproto.Window) GetWindowContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetWindowContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getWindowContextRequest(c, Window), cookie)
	return GetWindowContextCookie{cookie}
}

// GetWindowContextReply represents the data returned from a GetWindowContext request.
type GetWindowContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ContextLen uint32
	// padding: 20 bytes
	Context string // size: xgb.Pad((int(ContextLen) * 1))
}

// Reply blocks and returns the reply data for a GetWindowContext request.
func (cook GetWindowContextCookie) Reply() (*GetWindowContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getWindowContextReply(buf), nil
}

// getWindowContextReply reads a byte slice into a GetWindowContextReply value.
func getWindowContextReply(buf []byte) *GetWindowContextReply {
	v := new(GetWindowContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ContextLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	{
		byteString := make([]byte, v.ContextLen)
		copy(byteString[:v.ContextLen], buf[b:])
		v.Context = string(byteString)
		b += int(v.ContextLen)
	}

	return v
}

// Write request to wire for GetWindowContext
// getWindowContextRequest writes a GetWindowContext request to a byte slice.
func getWindowContextRequest(c *xgb.Conn, Window xproto.Window) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 7 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	return buf
}

// GetWindowCreateContextCookie is a cookie used only for GetWindowCreateContext requests.
type GetWindowCreateContextCookie struct {
	*xgb.Cookie
}

// GetWindowCreateContext sends a checked request.
// If an error occurs, it will be returned with the reply by calling GetWindowCreateContextCookie.Reply()
func GetWindowCreateContext(c *xgb.Conn) GetWindowCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetWindowCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(getWindowCreateContextRequest(c), cookie)
	return GetWindowCreateContextCookie{cookie}
}

// GetWindowCreateContextUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func GetWindowCreateContextUnchecked(c *xgb.Conn) GetWindowCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'GetWindowCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(getWindowCreateContextRequest(c), cookie)
	return GetWindowCreateContextCookie{cookie}
}

// GetWindowCreateContextReply represents the data returned from a GetWindowCreateContext request.
type GetWindowCreateContextReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ContextLen uint32
	// padding: 20 bytes
	Context string // size: xgb.Pad((int(ContextLen) * 1))
}

// Reply blocks and returns the reply data for a GetWindowCreateContext request.
func (cook GetWindowCreateContextCookie) Reply() (*GetWindowCreateContextReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return getWindowCreateContextReply(buf), nil
}

// getWindowCreateContextReply reads a byte slice into a GetWindowCreateContextReply value.
func getWindowCreateContextReply(buf []byte) *GetWindowCreateContextReply {
	v := new(GetWindowCreateContextReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ContextLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	{
		byteString := make([]byte, v.ContextLen)
		copy(byteString[:v.ContextLen], buf[b:])
		v.Context = string(byteString)
		b += int(v.ContextLen)
	}

	return v
}

// Write request to wire for GetWindowCreateContext
// getWindowCreateContextRequest writes a GetWindowCreateContext request to a byte slice.
func getWindowCreateContextRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 6 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// ListPropertiesCookie is a cookie used only for ListProperties requests.
type ListPropertiesCookie struct {
	*xgb.Cookie
}

// ListProperties sends a checked request.
// If an error occurs, it will be returned with the reply by calling ListPropertiesCookie.Reply()
func ListProperties(c *xgb.Conn, Window xproto.Window) ListPropertiesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'ListProperties' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(listPropertiesRequest(c, Window), cookie)
	return ListPropertiesCookie{cookie}
}

// ListPropertiesUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ListPropertiesUnchecked(c *xgb.Conn, Window xproto.Window) ListPropertiesCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'ListProperties' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(listPropertiesRequest(c, Window), cookie)
	return ListPropertiesCookie{cookie}
}

// ListPropertiesReply represents the data returned from a ListProperties request.
type ListPropertiesReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	PropertiesLen uint32
	// padding: 20 bytes
	Properties []ListItem // size: ListItemListSize(Properties)
}

// Reply blocks and returns the reply data for a ListProperties request.
func (cook ListPropertiesCookie) Reply() (*ListPropertiesReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return listPropertiesReply(buf), nil
}

// listPropertiesReply reads a byte slice into a ListPropertiesReply value.
func listPropertiesReply(buf []byte) *ListPropertiesReply {
	v := new(ListPropertiesReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.PropertiesLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	v.Properties = make([]ListItem, v.PropertiesLen)
	b += ListItemReadList(buf[b:], v.Properties)

	return v
}

// Write request to wire for ListProperties
// listPropertiesRequest writes a ListProperties request to a byte slice.
func listPropertiesRequest(c *xgb.Conn, Window xproto.Window) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 14 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], uint32(Window))
	b += 4

	return buf
}

// ListSelectionsCookie is a cookie used only for ListSelections requests.
type ListSelectionsCookie struct {
	*xgb.Cookie
}

// ListSelections sends a checked request.
// If an error occurs, it will be returned with the reply by calling ListSelectionsCookie.Reply()
func ListSelections(c *xgb.Conn) ListSelectionsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'ListSelections' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(listSelectionsRequest(c), cookie)
	return ListSelectionsCookie{cookie}
}

// ListSelectionsUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func ListSelectionsUnchecked(c *xgb.Conn) ListSelectionsCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'ListSelections' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(listSelectionsRequest(c), cookie)
	return ListSelectionsCookie{cookie}
}

// ListSelectionsReply represents the data returned from a ListSelections request.
type ListSelectionsReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	SelectionsLen uint32
	// padding: 20 bytes
	Selections []ListItem // size: ListItemListSize(Selections)
}

// Reply blocks and returns the reply data for a ListSelections request.
func (cook ListSelectionsCookie) Reply() (*ListSelectionsReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return listSelectionsReply(buf), nil
}

// listSelectionsReply reads a byte slice into a ListSelectionsReply value.
func listSelectionsReply(buf []byte) *ListSelectionsReply {
	v := new(ListSelectionsReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.SelectionsLen = xgb.Get32(buf[b:])
	b += 4

	b += 20 // padding

	v.Selections = make([]ListItem, v.SelectionsLen)
	b += ListItemReadList(buf[b:], v.Selections)

	return v
}

// Write request to wire for ListSelections
// listSelectionsRequest writes a ListSelections request to a byte slice.
func listSelectionsRequest(c *xgb.Conn) []byte {
	size := 4
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 21 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	return buf
}

// QueryVersionCookie is a cookie used only for QueryVersion requests.
type QueryVersionCookie struct {
	*xgb.Cookie
}

// QueryVersion sends a checked request.
// If an error occurs, it will be returned with the reply by calling QueryVersionCookie.Reply()
func QueryVersion(c *xgb.Conn, ClientMajor byte, ClientMinor byte) QueryVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'QueryVersion' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, true)
	c.NewRequest(queryVersionRequest(c, ClientMajor, ClientMinor), cookie)
	return QueryVersionCookie{cookie}
}

// QueryVersionUnchecked sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func QueryVersionUnchecked(c *xgb.Conn, ClientMajor byte, ClientMinor byte) QueryVersionCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'QueryVersion' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, true)
	c.NewRequest(queryVersionRequest(c, ClientMajor, ClientMinor), cookie)
	return QueryVersionCookie{cookie}
}

// QueryVersionReply represents the data returned from a QueryVersion request.
type QueryVersionReply struct {
	Sequence uint16 // sequence number of the request for this reply
	Length   uint32 // number of bytes in this reply
	// padding: 1 bytes
	ServerMajor uint16
	ServerMinor uint16
}

// Reply blocks and returns the reply data for a QueryVersion request.
func (cook QueryVersionCookie) Reply() (*QueryVersionReply, error) {
	buf, err := cook.Cookie.Reply()
	if err != nil {
		return nil, err
	}
	if buf == nil {
		return nil, nil
	}
	return queryVersionReply(buf), nil
}

// queryVersionReply reads a byte slice into a QueryVersionReply value.
func queryVersionReply(buf []byte) *QueryVersionReply {
	v := new(QueryVersionReply)
	b := 1 // skip reply determinant

	b += 1 // padding

	v.Sequence = xgb.Get16(buf[b:])
	b += 2

	v.Length = xgb.Get32(buf[b:]) // 4-byte units
	b += 4

	v.ServerMajor = xgb.Get16(buf[b:])
	b += 2

	v.ServerMinor = xgb.Get16(buf[b:])
	b += 2

	return v
}

// Write request to wire for QueryVersion
// queryVersionRequest writes a QueryVersion request to a byte slice.
func queryVersionRequest(c *xgb.Conn, ClientMajor byte, ClientMinor byte) []byte {
	size := 8
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 0 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	buf[b] = ClientMajor
	b += 1

	buf[b] = ClientMinor
	b += 1

	return buf
}

// SetDeviceContextCookie is a cookie used only for SetDeviceContext requests.
type SetDeviceContextCookie struct {
	*xgb.Cookie
}

// SetDeviceContext sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetDeviceContext(c *xgb.Conn, Device uint32, ContextLen uint32, Context string) SetDeviceContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'SetDeviceContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setDeviceContextRequest(c, Device, ContextLen, Context), cookie)
	return SetDeviceContextCookie{cookie}
}

// SetDeviceContextChecked sends a checked request.
// If an error occurs, it can be retrieved using SetDeviceContextCookie.Check()
func SetDeviceContextChecked(c *xgb.Conn, Device uint32, ContextLen uint32, Context string) SetDeviceContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'SetDeviceContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setDeviceContextRequest(c, Device, ContextLen, Context), cookie)
	return SetDeviceContextCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetDeviceContextCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetDeviceContext
// setDeviceContextRequest writes a SetDeviceContext request to a byte slice.
func setDeviceContextRequest(c *xgb.Conn, Device uint32, ContextLen uint32, Context string) []byte {
	size := xgb.Pad((12 + xgb.Pad((int(ContextLen) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 3 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], Device)
	b += 4

	xgb.Put32(buf[b:], ContextLen)
	b += 4

	copy(buf[b:], Context[:ContextLen])
	b += int(ContextLen)

	return buf
}

// SetDeviceCreateContextCookie is a cookie used only for SetDeviceCreateContext requests.
type SetDeviceCreateContextCookie struct {
	*xgb.Cookie
}

// SetDeviceCreateContext sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetDeviceCreateContext(c *xgb.Conn, ContextLen uint32, Context string) SetDeviceCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'SetDeviceCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setDeviceCreateContextRequest(c, ContextLen, Context), cookie)
	return SetDeviceCreateContextCookie{cookie}
}

// SetDeviceCreateContextChecked sends a checked request.
// If an error occurs, it can be retrieved using SetDeviceCreateContextCookie.Check()
func SetDeviceCreateContextChecked(c *xgb.Conn, ContextLen uint32, Context string) SetDeviceCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'SetDeviceCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setDeviceCreateContextRequest(c, ContextLen, Context), cookie)
	return SetDeviceCreateContextCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetDeviceCreateContextCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetDeviceCreateContext
// setDeviceCreateContextRequest writes a SetDeviceCreateContext request to a byte slice.
func setDeviceCreateContextRequest(c *xgb.Conn, ContextLen uint32, Context string) []byte {
	size := xgb.Pad((8 + xgb.Pad((int(ContextLen) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 1 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], ContextLen)
	b += 4

	copy(buf[b:], Context[:ContextLen])
	b += int(ContextLen)

	return buf
}

// SetPropertyCreateContextCookie is a cookie used only for SetPropertyCreateContext requests.
type SetPropertyCreateContextCookie struct {
	*xgb.Cookie
}

// SetPropertyCreateContext sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetPropertyCreateContext(c *xgb.Conn, ContextLen uint32, Context string) SetPropertyCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'SetPropertyCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setPropertyCreateContextRequest(c, ContextLen, Context), cookie)
	return SetPropertyCreateContextCookie{cookie}
}

// SetPropertyCreateContextChecked sends a checked request.
// If an error occurs, it can be retrieved using SetPropertyCreateContextCookie.Check()
func SetPropertyCreateContextChecked(c *xgb.Conn, ContextLen uint32, Context string) SetPropertyCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'SetPropertyCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setPropertyCreateContextRequest(c, ContextLen, Context), cookie)
	return SetPropertyCreateContextCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetPropertyCreateContextCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetPropertyCreateContext
// setPropertyCreateContextRequest writes a SetPropertyCreateContext request to a byte slice.
func setPropertyCreateContextRequest(c *xgb.Conn, ContextLen uint32, Context string) []byte {
	size := xgb.Pad((8 + xgb.Pad((int(ContextLen) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 8 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], ContextLen)
	b += 4

	copy(buf[b:], Context[:ContextLen])
	b += int(ContextLen)

	return buf
}

// SetPropertyUseContextCookie is a cookie used only for SetPropertyUseContext requests.
type SetPropertyUseContextCookie struct {
	*xgb.Cookie
}

// SetPropertyUseContext sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetPropertyUseContext(c *xgb.Conn, ContextLen uint32, Context string) SetPropertyUseContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'SetPropertyUseContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setPropertyUseContextRequest(c, ContextLen, Context), cookie)
	return SetPropertyUseContextCookie{cookie}
}

// SetPropertyUseContextChecked sends a checked request.
// If an error occurs, it can be retrieved using SetPropertyUseContextCookie.Check()
func SetPropertyUseContextChecked(c *xgb.Conn, ContextLen uint32, Context string) SetPropertyUseContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'SetPropertyUseContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setPropertyUseContextRequest(c, ContextLen, Context), cookie)
	return SetPropertyUseContextCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetPropertyUseContextCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetPropertyUseContext
// setPropertyUseContextRequest writes a SetPropertyUseContext request to a byte slice.
func setPropertyUseContextRequest(c *xgb.Conn, ContextLen uint32, Context string) []byte {
	size := xgb.Pad((8 + xgb.Pad((int(ContextLen) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 10 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], ContextLen)
	b += 4

	copy(buf[b:], Context[:ContextLen])
	b += int(ContextLen)

	return buf
}

// SetSelectionCreateContextCookie is a cookie used only for SetSelectionCreateContext requests.
type SetSelectionCreateContextCookie struct {
	*xgb.Cookie
}

// SetSelectionCreateContext sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetSelectionCreateContext(c *xgb.Conn, ContextLen uint32, Context string) SetSelectionCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'SetSelectionCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setSelectionCreateContextRequest(c, ContextLen, Context), cookie)
	return SetSelectionCreateContextCookie{cookie}
}

// SetSelectionCreateContextChecked sends a checked request.
// If an error occurs, it can be retrieved using SetSelectionCreateContextCookie.Check()
func SetSelectionCreateContextChecked(c *xgb.Conn, ContextLen uint32, Context string) SetSelectionCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'SetSelectionCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setSelectionCreateContextRequest(c, ContextLen, Context), cookie)
	return SetSelectionCreateContextCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetSelectionCreateContextCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetSelectionCreateContext
// setSelectionCreateContextRequest writes a SetSelectionCreateContext request to a byte slice.
func setSelectionCreateContextRequest(c *xgb.Conn, ContextLen uint32, Context string) []byte {
	size := xgb.Pad((8 + xgb.Pad((int(ContextLen) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 15 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], ContextLen)
	b += 4

	copy(buf[b:], Context[:ContextLen])
	b += int(ContextLen)

	return buf
}

// SetSelectionUseContextCookie is a cookie used only for SetSelectionUseContext requests.
type SetSelectionUseContextCookie struct {
	*xgb.Cookie
}

// SetSelectionUseContext sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetSelectionUseContext(c *xgb.Conn, ContextLen uint32, Context string) SetSelectionUseContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'SetSelectionUseContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setSelectionUseContextRequest(c, ContextLen, Context), cookie)
	return SetSelectionUseContextCookie{cookie}
}

// SetSelectionUseContextChecked sends a checked request.
// If an error occurs, it can be retrieved using SetSelectionUseContextCookie.Check()
func SetSelectionUseContextChecked(c *xgb.Conn, ContextLen uint32, Context string) SetSelectionUseContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'SetSelectionUseContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setSelectionUseContextRequest(c, ContextLen, Context), cookie)
	return SetSelectionUseContextCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetSelectionUseContextCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetSelectionUseContext
// setSelectionUseContextRequest writes a SetSelectionUseContext request to a byte slice.
func setSelectionUseContextRequest(c *xgb.Conn, ContextLen uint32, Context string) []byte {
	size := xgb.Pad((8 + xgb.Pad((int(ContextLen) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 17 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], ContextLen)
	b += 4

	copy(buf[b:], Context[:ContextLen])
	b += int(ContextLen)

	return buf
}

// SetWindowCreateContextCookie is a cookie used only for SetWindowCreateContext requests.
type SetWindowCreateContextCookie struct {
	*xgb.Cookie
}

// SetWindowCreateContext sends an unchecked request.
// If an error occurs, it can only be retrieved using xgb.WaitForEvent or xgb.PollForEvent.
func SetWindowCreateContext(c *xgb.Conn, ContextLen uint32, Context string) SetWindowCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'SetWindowCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(false, false)
	c.NewRequest(setWindowCreateContextRequest(c, ContextLen, Context), cookie)
	return SetWindowCreateContextCookie{cookie}
}

// SetWindowCreateContextChecked sends a checked request.
// If an error occurs, it can be retrieved using SetWindowCreateContextCookie.Check()
func SetWindowCreateContextChecked(c *xgb.Conn, ContextLen uint32, Context string) SetWindowCreateContextCookie {
	c.ExtLock.RLock()
	defer c.ExtLock.RUnlock()
	if _, ok := c.Extensions["SELinux"]; !ok {
		panic("Cannot issue request 'SetWindowCreateContext' using the uninitialized extension 'SELinux'. xselinux.Init(connObj) must be called first.")
	}
	cookie := c.NewCookie(true, false)
	c.NewRequest(setWindowCreateContextRequest(c, ContextLen, Context), cookie)
	return SetWindowCreateContextCookie{cookie}
}

// Check returns an error if one occurred for checked requests that are not expecting a reply.
// This cannot be called for requests expecting a reply, nor for unchecked requests.
func (cook SetWindowCreateContextCookie) Check() error {
	return cook.Cookie.Check()
}

// Write request to wire for SetWindowCreateContext
// setWindowCreateContextRequest writes a SetWindowCreateContext request to a byte slice.
func setWindowCreateContextRequest(c *xgb.Conn, ContextLen uint32, Context string) []byte {
	size := xgb.Pad((8 + xgb.Pad((int(ContextLen) * 1))))
	b := 0
	buf := make([]byte, size)

	c.ExtLock.RLock()
	buf[b] = c.Extensions["SELinux"]
	c.ExtLock.RUnlock()
	b += 1

	buf[b] = 5 // request opcode
	b += 1

	xgb.Put16(buf[b:], uint16(size/4)) // write request size in 4-byte units
	b += 2

	xgb.Put32(buf[b:], ContextLen)
	b += 4

	copy(buf[b:], Context[:ContextLen])
	b += int(ContextLen)

	return buf
}
