// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/datastore/admin/v1/datastore_admin.proto

package admin // import "google.golang.org/genproto/googleapis/datastore/admin/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import longrunning "google.golang.org/genproto/googleapis/longrunning"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Operation types.
type OperationType int32

const (
	// Unspecified.
	OperationType_OPERATION_TYPE_UNSPECIFIED OperationType = 0
	// ExportEntities.
	OperationType_EXPORT_ENTITIES OperationType = 1
	// ImportEntities.
	OperationType_IMPORT_ENTITIES OperationType = 2
	// CreateIndex.
	OperationType_CREATE_INDEX OperationType = 3
	// DeleteIndex.
	OperationType_DELETE_INDEX OperationType = 4
)

var OperationType_name = map[int32]string{
	0: "OPERATION_TYPE_UNSPECIFIED",
	1: "EXPORT_ENTITIES",
	2: "IMPORT_ENTITIES",
	3: "CREATE_INDEX",
	4: "DELETE_INDEX",
}
var OperationType_value = map[string]int32{
	"OPERATION_TYPE_UNSPECIFIED": 0,
	"EXPORT_ENTITIES":            1,
	"IMPORT_ENTITIES":            2,
	"CREATE_INDEX":               3,
	"DELETE_INDEX":               4,
}

func (x OperationType) String() string {
	return proto.EnumName(OperationType_name, int32(x))
}
func (OperationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_datastore_admin_35408641d3652505, []int{0}
}

// The various possible states for an ongoing Operation.
type CommonMetadata_State int32

const (
	// Unspecified.
	CommonMetadata_STATE_UNSPECIFIED CommonMetadata_State = 0
	// Request is being prepared for processing.
	CommonMetadata_INITIALIZING CommonMetadata_State = 1
	// Request is actively being processed.
	CommonMetadata_PROCESSING CommonMetadata_State = 2
	// Request is in the process of being cancelled after user called
	// google.longrunning.Operations.CancelOperation on the operation.
	CommonMetadata_CANCELLING CommonMetadata_State = 3
	// Request has been processed and is in its finalization stage.
	CommonMetadata_FINALIZING CommonMetadata_State = 4
	// Request has completed successfully.
	CommonMetadata_SUCCESSFUL CommonMetadata_State = 5
	// Request has finished being processed, but encountered an error.
	CommonMetadata_FAILED CommonMetadata_State = 6
	// Request has finished being cancelled after user called
	// google.longrunning.Operations.CancelOperation.
	CommonMetadata_CANCELLED CommonMetadata_State = 7
)

var CommonMetadata_State_name = map[int32]string{
	0: "STATE_UNSPECIFIED",
	1: "INITIALIZING",
	2: "PROCESSING",
	3: "CANCELLING",
	4: "FINALIZING",
	5: "SUCCESSFUL",
	6: "FAILED",
	7: "CANCELLED",
}
var CommonMetadata_State_value = map[string]int32{
	"STATE_UNSPECIFIED": 0,
	"INITIALIZING":      1,
	"PROCESSING":        2,
	"CANCELLING":        3,
	"FINALIZING":        4,
	"SUCCESSFUL":        5,
	"FAILED":            6,
	"CANCELLED":         7,
}

func (x CommonMetadata_State) String() string {
	return proto.EnumName(CommonMetadata_State_name, int32(x))
}
func (CommonMetadata_State) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_datastore_admin_35408641d3652505, []int{0, 0}
}

// Metadata common to all Datastore Admin operations.
type CommonMetadata struct {
	// The time that work began on the operation.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// The time the operation ended, either successfully or otherwise.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// The type of the operation. Can be used as a filter in
	// ListOperationsRequest.
	OperationType OperationType `protobuf:"varint,3,opt,name=operation_type,json=operationType,proto3,enum=google.datastore.admin.v1.OperationType" json:"operation_type,omitempty"`
	// The client-assigned labels which were provided when the operation was
	// created. May also include additional labels.
	Labels map[string]string `protobuf:"bytes,4,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The current state of the Operation.
	State                CommonMetadata_State `protobuf:"varint,5,opt,name=state,proto3,enum=google.datastore.admin.v1.CommonMetadata_State" json:"state,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *CommonMetadata) Reset()         { *m = CommonMetadata{} }
func (m *CommonMetadata) String() string { return proto.CompactTextString(m) }
func (*CommonMetadata) ProtoMessage()    {}
func (*CommonMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_admin_35408641d3652505, []int{0}
}
func (m *CommonMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CommonMetadata.Unmarshal(m, b)
}
func (m *CommonMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CommonMetadata.Marshal(b, m, deterministic)
}
func (dst *CommonMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CommonMetadata.Merge(dst, src)
}
func (m *CommonMetadata) XXX_Size() int {
	return xxx_messageInfo_CommonMetadata.Size(m)
}
func (m *CommonMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CommonMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CommonMetadata proto.InternalMessageInfo

func (m *CommonMetadata) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *CommonMetadata) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *CommonMetadata) GetOperationType() OperationType {
	if m != nil {
		return m.OperationType
	}
	return OperationType_OPERATION_TYPE_UNSPECIFIED
}

func (m *CommonMetadata) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *CommonMetadata) GetState() CommonMetadata_State {
	if m != nil {
		return m.State
	}
	return CommonMetadata_STATE_UNSPECIFIED
}

// Measures the progress of a particular metric.
type Progress struct {
	// The amount of work that has been completed. Note that this may be greater
	// than work_estimated.
	WorkCompleted int64 `protobuf:"varint,1,opt,name=work_completed,json=workCompleted,proto3" json:"work_completed,omitempty"`
	// An estimate of how much work needs to be performed. May be zero if the
	// work estimate is unavailable.
	WorkEstimated        int64    `protobuf:"varint,2,opt,name=work_estimated,json=workEstimated,proto3" json:"work_estimated,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Progress) Reset()         { *m = Progress{} }
func (m *Progress) String() string { return proto.CompactTextString(m) }
func (*Progress) ProtoMessage()    {}
func (*Progress) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_admin_35408641d3652505, []int{1}
}
func (m *Progress) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Progress.Unmarshal(m, b)
}
func (m *Progress) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Progress.Marshal(b, m, deterministic)
}
func (dst *Progress) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Progress.Merge(dst, src)
}
func (m *Progress) XXX_Size() int {
	return xxx_messageInfo_Progress.Size(m)
}
func (m *Progress) XXX_DiscardUnknown() {
	xxx_messageInfo_Progress.DiscardUnknown(m)
}

var xxx_messageInfo_Progress proto.InternalMessageInfo

func (m *Progress) GetWorkCompleted() int64 {
	if m != nil {
		return m.WorkCompleted
	}
	return 0
}

func (m *Progress) GetWorkEstimated() int64 {
	if m != nil {
		return m.WorkEstimated
	}
	return 0
}

// The request for
// [google.datastore.admin.v1.DatastoreAdmin.ExportEntities][google.datastore.admin.v1.DatastoreAdmin.ExportEntities].
type ExportEntitiesRequest struct {
	// Project ID against which to make the request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Client-assigned labels.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Description of what data from the project is included in the export.
	EntityFilter *EntityFilter `protobuf:"bytes,3,opt,name=entity_filter,json=entityFilter,proto3" json:"entity_filter,omitempty"`
	// Location for the export metadata and data files.
	//
	// The full resource URL of the external storage location. Currently, only
	// Google Cloud Storage is supported. So output_url_prefix should be of the
	// form: `gs://BUCKET_NAME[/NAMESPACE_PATH]`, where `BUCKET_NAME` is the
	// name of the Cloud Storage bucket and `NAMESPACE_PATH` is an optional Cloud
	// Storage namespace path (this is not a Cloud Datastore namespace). For more
	// information about Cloud Storage namespace paths, see
	// [Object name
	// considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
	//
	// The resulting files will be nested deeper than the specified URL prefix.
	// The final output URL will be provided in the
	// [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url]
	// field. That value should be used for subsequent ImportEntities operations.
	//
	// By nesting the data files deeper, the same Cloud Storage bucket can be used
	// in multiple ExportEntities operations without conflict.
	OutputUrlPrefix      string   `protobuf:"bytes,4,opt,name=output_url_prefix,json=outputUrlPrefix,proto3" json:"output_url_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportEntitiesRequest) Reset()         { *m = ExportEntitiesRequest{} }
func (m *ExportEntitiesRequest) String() string { return proto.CompactTextString(m) }
func (*ExportEntitiesRequest) ProtoMessage()    {}
func (*ExportEntitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_admin_35408641d3652505, []int{2}
}
func (m *ExportEntitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportEntitiesRequest.Unmarshal(m, b)
}
func (m *ExportEntitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportEntitiesRequest.Marshal(b, m, deterministic)
}
func (dst *ExportEntitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportEntitiesRequest.Merge(dst, src)
}
func (m *ExportEntitiesRequest) XXX_Size() int {
	return xxx_messageInfo_ExportEntitiesRequest.Size(m)
}
func (m *ExportEntitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportEntitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ExportEntitiesRequest proto.InternalMessageInfo

func (m *ExportEntitiesRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ExportEntitiesRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ExportEntitiesRequest) GetEntityFilter() *EntityFilter {
	if m != nil {
		return m.EntityFilter
	}
	return nil
}

func (m *ExportEntitiesRequest) GetOutputUrlPrefix() string {
	if m != nil {
		return m.OutputUrlPrefix
	}
	return ""
}

// The request for
// [google.datastore.admin.v1.DatastoreAdmin.ImportEntities][google.datastore.admin.v1.DatastoreAdmin.ImportEntities].
type ImportEntitiesRequest struct {
	// Project ID against which to make the request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Client-assigned labels.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The full resource URL of the external storage location. Currently, only
	// Google Cloud Storage is supported. So input_url should be of the form:
	// `gs://BUCKET_NAME[/NAMESPACE_PATH]/OVERALL_EXPORT_METADATA_FILE`, where
	// `BUCKET_NAME` is the name of the Cloud Storage bucket, `NAMESPACE_PATH` is
	// an optional Cloud Storage namespace path (this is not a Cloud Datastore
	// namespace), and `OVERALL_EXPORT_METADATA_FILE` is the metadata file written
	// by the ExportEntities operation. For more information about Cloud Storage
	// namespace paths, see
	// [Object name
	// considerations](https://cloud.google.com/storage/docs/naming#object-considerations).
	//
	// For more information, see
	// [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url].
	InputUrl string `protobuf:"bytes,3,opt,name=input_url,json=inputUrl,proto3" json:"input_url,omitempty"`
	// Optionally specify which kinds/namespaces are to be imported. If provided,
	// the list must be a subset of the EntityFilter used in creating the export,
	// otherwise a FAILED_PRECONDITION error will be returned. If no filter is
	// specified then all entities from the export are imported.
	EntityFilter         *EntityFilter `protobuf:"bytes,4,opt,name=entity_filter,json=entityFilter,proto3" json:"entity_filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{}      `json:"-"`
	XXX_unrecognized     []byte        `json:"-"`
	XXX_sizecache        int32         `json:"-"`
}

func (m *ImportEntitiesRequest) Reset()         { *m = ImportEntitiesRequest{} }
func (m *ImportEntitiesRequest) String() string { return proto.CompactTextString(m) }
func (*ImportEntitiesRequest) ProtoMessage()    {}
func (*ImportEntitiesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_admin_35408641d3652505, []int{3}
}
func (m *ImportEntitiesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportEntitiesRequest.Unmarshal(m, b)
}
func (m *ImportEntitiesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportEntitiesRequest.Marshal(b, m, deterministic)
}
func (dst *ImportEntitiesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportEntitiesRequest.Merge(dst, src)
}
func (m *ImportEntitiesRequest) XXX_Size() int {
	return xxx_messageInfo_ImportEntitiesRequest.Size(m)
}
func (m *ImportEntitiesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportEntitiesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ImportEntitiesRequest proto.InternalMessageInfo

func (m *ImportEntitiesRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ImportEntitiesRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ImportEntitiesRequest) GetInputUrl() string {
	if m != nil {
		return m.InputUrl
	}
	return ""
}

func (m *ImportEntitiesRequest) GetEntityFilter() *EntityFilter {
	if m != nil {
		return m.EntityFilter
	}
	return nil
}

// The response for
// [google.datastore.admin.v1.DatastoreAdmin.ExportEntities][google.datastore.admin.v1.DatastoreAdmin.ExportEntities].
type ExportEntitiesResponse struct {
	// Location of the output metadata file. This can be used to begin an import
	// into Cloud Datastore (this project or another project). See
	// [google.datastore.admin.v1.ImportEntitiesRequest.input_url][google.datastore.admin.v1.ImportEntitiesRequest.input_url].
	// Only present if the operation completed successfully.
	OutputUrl            string   `protobuf:"bytes,1,opt,name=output_url,json=outputUrl,proto3" json:"output_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportEntitiesResponse) Reset()         { *m = ExportEntitiesResponse{} }
func (m *ExportEntitiesResponse) String() string { return proto.CompactTextString(m) }
func (*ExportEntitiesResponse) ProtoMessage()    {}
func (*ExportEntitiesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_admin_35408641d3652505, []int{4}
}
func (m *ExportEntitiesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportEntitiesResponse.Unmarshal(m, b)
}
func (m *ExportEntitiesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportEntitiesResponse.Marshal(b, m, deterministic)
}
func (dst *ExportEntitiesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportEntitiesResponse.Merge(dst, src)
}
func (m *ExportEntitiesResponse) XXX_Size() int {
	return xxx_messageInfo_ExportEntitiesResponse.Size(m)
}
func (m *ExportEntitiesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportEntitiesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ExportEntitiesResponse proto.InternalMessageInfo

func (m *ExportEntitiesResponse) GetOutputUrl() string {
	if m != nil {
		return m.OutputUrl
	}
	return ""
}

// Metadata for ExportEntities operations.
type ExportEntitiesMetadata struct {
	// Metadata common to all Datastore Admin operations.
	Common *CommonMetadata `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	// An estimate of the number of entities processed.
	ProgressEntities *Progress `protobuf:"bytes,2,opt,name=progress_entities,json=progressEntities,proto3" json:"progress_entities,omitempty"`
	// An estimate of the number of bytes processed.
	ProgressBytes *Progress `protobuf:"bytes,3,opt,name=progress_bytes,json=progressBytes,proto3" json:"progress_bytes,omitempty"`
	// Description of which entities are being exported.
	EntityFilter *EntityFilter `protobuf:"bytes,4,opt,name=entity_filter,json=entityFilter,proto3" json:"entity_filter,omitempty"`
	// Location for the export metadata and data files. This will be the same
	// value as the
	// [google.datastore.admin.v1.ExportEntitiesRequest.output_url_prefix][google.datastore.admin.v1.ExportEntitiesRequest.output_url_prefix]
	// field. The final output location is provided in
	// [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url].
	OutputUrlPrefix      string   `protobuf:"bytes,5,opt,name=output_url_prefix,json=outputUrlPrefix,proto3" json:"output_url_prefix,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportEntitiesMetadata) Reset()         { *m = ExportEntitiesMetadata{} }
func (m *ExportEntitiesMetadata) String() string { return proto.CompactTextString(m) }
func (*ExportEntitiesMetadata) ProtoMessage()    {}
func (*ExportEntitiesMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_admin_35408641d3652505, []int{5}
}
func (m *ExportEntitiesMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportEntitiesMetadata.Unmarshal(m, b)
}
func (m *ExportEntitiesMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportEntitiesMetadata.Marshal(b, m, deterministic)
}
func (dst *ExportEntitiesMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportEntitiesMetadata.Merge(dst, src)
}
func (m *ExportEntitiesMetadata) XXX_Size() int {
	return xxx_messageInfo_ExportEntitiesMetadata.Size(m)
}
func (m *ExportEntitiesMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportEntitiesMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ExportEntitiesMetadata proto.InternalMessageInfo

func (m *ExportEntitiesMetadata) GetCommon() *CommonMetadata {
	if m != nil {
		return m.Common
	}
	return nil
}

func (m *ExportEntitiesMetadata) GetProgressEntities() *Progress {
	if m != nil {
		return m.ProgressEntities
	}
	return nil
}

func (m *ExportEntitiesMetadata) GetProgressBytes() *Progress {
	if m != nil {
		return m.ProgressBytes
	}
	return nil
}

func (m *ExportEntitiesMetadata) GetEntityFilter() *EntityFilter {
	if m != nil {
		return m.EntityFilter
	}
	return nil
}

func (m *ExportEntitiesMetadata) GetOutputUrlPrefix() string {
	if m != nil {
		return m.OutputUrlPrefix
	}
	return ""
}

// Metadata for ImportEntities operations.
type ImportEntitiesMetadata struct {
	// Metadata common to all Datastore Admin operations.
	Common *CommonMetadata `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	// An estimate of the number of entities processed.
	ProgressEntities *Progress `protobuf:"bytes,2,opt,name=progress_entities,json=progressEntities,proto3" json:"progress_entities,omitempty"`
	// An estimate of the number of bytes processed.
	ProgressBytes *Progress `protobuf:"bytes,3,opt,name=progress_bytes,json=progressBytes,proto3" json:"progress_bytes,omitempty"`
	// Description of which entities are being imported.
	EntityFilter *EntityFilter `protobuf:"bytes,4,opt,name=entity_filter,json=entityFilter,proto3" json:"entity_filter,omitempty"`
	// The location of the import metadata file. This will be the same value as
	// the
	// [google.datastore.admin.v1.ExportEntitiesResponse.output_url][google.datastore.admin.v1.ExportEntitiesResponse.output_url]
	// field.
	InputUrl             string   `protobuf:"bytes,5,opt,name=input_url,json=inputUrl,proto3" json:"input_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImportEntitiesMetadata) Reset()         { *m = ImportEntitiesMetadata{} }
func (m *ImportEntitiesMetadata) String() string { return proto.CompactTextString(m) }
func (*ImportEntitiesMetadata) ProtoMessage()    {}
func (*ImportEntitiesMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_admin_35408641d3652505, []int{6}
}
func (m *ImportEntitiesMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportEntitiesMetadata.Unmarshal(m, b)
}
func (m *ImportEntitiesMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportEntitiesMetadata.Marshal(b, m, deterministic)
}
func (dst *ImportEntitiesMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportEntitiesMetadata.Merge(dst, src)
}
func (m *ImportEntitiesMetadata) XXX_Size() int {
	return xxx_messageInfo_ImportEntitiesMetadata.Size(m)
}
func (m *ImportEntitiesMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportEntitiesMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ImportEntitiesMetadata proto.InternalMessageInfo

func (m *ImportEntitiesMetadata) GetCommon() *CommonMetadata {
	if m != nil {
		return m.Common
	}
	return nil
}

func (m *ImportEntitiesMetadata) GetProgressEntities() *Progress {
	if m != nil {
		return m.ProgressEntities
	}
	return nil
}

func (m *ImportEntitiesMetadata) GetProgressBytes() *Progress {
	if m != nil {
		return m.ProgressBytes
	}
	return nil
}

func (m *ImportEntitiesMetadata) GetEntityFilter() *EntityFilter {
	if m != nil {
		return m.EntityFilter
	}
	return nil
}

func (m *ImportEntitiesMetadata) GetInputUrl() string {
	if m != nil {
		return m.InputUrl
	}
	return ""
}

// Identifies a subset of entities in a project. This is specified as
// combinations of kinds and namespaces (either or both of which may be all, as
// described in the following examples).
// Example usage:
//
// Entire project:
//   kinds=[], namespace_ids=[]
//
// Kinds Foo and Bar in all namespaces:
//   kinds=['Foo', 'Bar'], namespace_ids=[]
//
// Kinds Foo and Bar only in the default namespace:
//   kinds=['Foo', 'Bar'], namespace_ids=['']
//
// Kinds Foo and Bar in both the default and Baz namespaces:
//   kinds=['Foo', 'Bar'], namespace_ids=['', 'Baz']
//
// The entire Baz namespace:
//   kinds=[], namespace_ids=['Baz']
type EntityFilter struct {
	// If empty, then this represents all kinds.
	Kinds []string `protobuf:"bytes,1,rep,name=kinds,proto3" json:"kinds,omitempty"`
	// An empty list represents all namespaces. This is the preferred
	// usage for projects that don't use namespaces.
	//
	// An empty string element represents the default namespace. This should be
	// used if the project has data in non-default namespaces, but doesn't want to
	// include them.
	// Each namespace in this list must be unique.
	NamespaceIds         []string `protobuf:"bytes,2,rep,name=namespace_ids,json=namespaceIds,proto3" json:"namespace_ids,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EntityFilter) Reset()         { *m = EntityFilter{} }
func (m *EntityFilter) String() string { return proto.CompactTextString(m) }
func (*EntityFilter) ProtoMessage()    {}
func (*EntityFilter) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_admin_35408641d3652505, []int{7}
}
func (m *EntityFilter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityFilter.Unmarshal(m, b)
}
func (m *EntityFilter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityFilter.Marshal(b, m, deterministic)
}
func (dst *EntityFilter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityFilter.Merge(dst, src)
}
func (m *EntityFilter) XXX_Size() int {
	return xxx_messageInfo_EntityFilter.Size(m)
}
func (m *EntityFilter) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityFilter.DiscardUnknown(m)
}

var xxx_messageInfo_EntityFilter proto.InternalMessageInfo

func (m *EntityFilter) GetKinds() []string {
	if m != nil {
		return m.Kinds
	}
	return nil
}

func (m *EntityFilter) GetNamespaceIds() []string {
	if m != nil {
		return m.NamespaceIds
	}
	return nil
}

// The request for
// [google.datastore.admin.v1.DatastoreAdmin.GetIndex][google.datastore.admin.v1.DatastoreAdmin.GetIndex].
type GetIndexRequest struct {
	// Project ID against which to make the request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The resource ID of the index to get.
	IndexId              string   `protobuf:"bytes,3,opt,name=index_id,json=indexId,proto3" json:"index_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetIndexRequest) Reset()         { *m = GetIndexRequest{} }
func (m *GetIndexRequest) String() string { return proto.CompactTextString(m) }
func (*GetIndexRequest) ProtoMessage()    {}
func (*GetIndexRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_admin_35408641d3652505, []int{8}
}
func (m *GetIndexRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetIndexRequest.Unmarshal(m, b)
}
func (m *GetIndexRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetIndexRequest.Marshal(b, m, deterministic)
}
func (dst *GetIndexRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetIndexRequest.Merge(dst, src)
}
func (m *GetIndexRequest) XXX_Size() int {
	return xxx_messageInfo_GetIndexRequest.Size(m)
}
func (m *GetIndexRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetIndexRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetIndexRequest proto.InternalMessageInfo

func (m *GetIndexRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *GetIndexRequest) GetIndexId() string {
	if m != nil {
		return m.IndexId
	}
	return ""
}

// The request for
// [google.datastore.admin.v1.DatastoreAdmin.ListIndexes][google.datastore.admin.v1.DatastoreAdmin.ListIndexes].
type ListIndexesRequest struct {
	// Project ID against which to make the request.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	Filter    string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// The maximum number of items to return.  If zero, then all results will be
	// returned.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The next_page_token value returned from a previous List request, if any.
	PageToken            string   `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListIndexesRequest) Reset()         { *m = ListIndexesRequest{} }
func (m *ListIndexesRequest) String() string { return proto.CompactTextString(m) }
func (*ListIndexesRequest) ProtoMessage()    {}
func (*ListIndexesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_admin_35408641d3652505, []int{9}
}
func (m *ListIndexesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIndexesRequest.Unmarshal(m, b)
}
func (m *ListIndexesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIndexesRequest.Marshal(b, m, deterministic)
}
func (dst *ListIndexesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIndexesRequest.Merge(dst, src)
}
func (m *ListIndexesRequest) XXX_Size() int {
	return xxx_messageInfo_ListIndexesRequest.Size(m)
}
func (m *ListIndexesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIndexesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListIndexesRequest proto.InternalMessageInfo

func (m *ListIndexesRequest) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *ListIndexesRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListIndexesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListIndexesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

// The response for
// [google.datastore.admin.v1.DatastoreAdmin.ListIndexes][google.datastore.admin.v1.DatastoreAdmin.ListIndexes].
type ListIndexesResponse struct {
	// The indexes.
	Indexes []*Index `protobuf:"bytes,1,rep,name=indexes,proto3" json:"indexes,omitempty"`
	// The standard List next-page token.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListIndexesResponse) Reset()         { *m = ListIndexesResponse{} }
func (m *ListIndexesResponse) String() string { return proto.CompactTextString(m) }
func (*ListIndexesResponse) ProtoMessage()    {}
func (*ListIndexesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_admin_35408641d3652505, []int{10}
}
func (m *ListIndexesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListIndexesResponse.Unmarshal(m, b)
}
func (m *ListIndexesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListIndexesResponse.Marshal(b, m, deterministic)
}
func (dst *ListIndexesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListIndexesResponse.Merge(dst, src)
}
func (m *ListIndexesResponse) XXX_Size() int {
	return xxx_messageInfo_ListIndexesResponse.Size(m)
}
func (m *ListIndexesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListIndexesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListIndexesResponse proto.InternalMessageInfo

func (m *ListIndexesResponse) GetIndexes() []*Index {
	if m != nil {
		return m.Indexes
	}
	return nil
}

func (m *ListIndexesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// Metadata for Index operations.
type IndexOperationMetadata struct {
	// Metadata common to all Datastore Admin operations.
	Common *CommonMetadata `protobuf:"bytes,1,opt,name=common,proto3" json:"common,omitempty"`
	// An estimate of the number of entities processed.
	ProgressEntities *Progress `protobuf:"bytes,2,opt,name=progress_entities,json=progressEntities,proto3" json:"progress_entities,omitempty"`
	// The index resource ID that this operation is acting on.
	IndexId              string   `protobuf:"bytes,3,opt,name=index_id,json=indexId,proto3" json:"index_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IndexOperationMetadata) Reset()         { *m = IndexOperationMetadata{} }
func (m *IndexOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*IndexOperationMetadata) ProtoMessage()    {}
func (*IndexOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_datastore_admin_35408641d3652505, []int{11}
}
func (m *IndexOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IndexOperationMetadata.Unmarshal(m, b)
}
func (m *IndexOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IndexOperationMetadata.Marshal(b, m, deterministic)
}
func (dst *IndexOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IndexOperationMetadata.Merge(dst, src)
}
func (m *IndexOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_IndexOperationMetadata.Size(m)
}
func (m *IndexOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_IndexOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_IndexOperationMetadata proto.InternalMessageInfo

func (m *IndexOperationMetadata) GetCommon() *CommonMetadata {
	if m != nil {
		return m.Common
	}
	return nil
}

func (m *IndexOperationMetadata) GetProgressEntities() *Progress {
	if m != nil {
		return m.ProgressEntities
	}
	return nil
}

func (m *IndexOperationMetadata) GetIndexId() string {
	if m != nil {
		return m.IndexId
	}
	return ""
}

func init() {
	proto.RegisterType((*CommonMetadata)(nil), "google.datastore.admin.v1.CommonMetadata")
	proto.RegisterMapType((map[string]string)(nil), "google.datastore.admin.v1.CommonMetadata.LabelsEntry")
	proto.RegisterType((*Progress)(nil), "google.datastore.admin.v1.Progress")
	proto.RegisterType((*ExportEntitiesRequest)(nil), "google.datastore.admin.v1.ExportEntitiesRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.datastore.admin.v1.ExportEntitiesRequest.LabelsEntry")
	proto.RegisterType((*ImportEntitiesRequest)(nil), "google.datastore.admin.v1.ImportEntitiesRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.datastore.admin.v1.ImportEntitiesRequest.LabelsEntry")
	proto.RegisterType((*ExportEntitiesResponse)(nil), "google.datastore.admin.v1.ExportEntitiesResponse")
	proto.RegisterType((*ExportEntitiesMetadata)(nil), "google.datastore.admin.v1.ExportEntitiesMetadata")
	proto.RegisterType((*ImportEntitiesMetadata)(nil), "google.datastore.admin.v1.ImportEntitiesMetadata")
	proto.RegisterType((*EntityFilter)(nil), "google.datastore.admin.v1.EntityFilter")
	proto.RegisterType((*GetIndexRequest)(nil), "google.datastore.admin.v1.GetIndexRequest")
	proto.RegisterType((*ListIndexesRequest)(nil), "google.datastore.admin.v1.ListIndexesRequest")
	proto.RegisterType((*ListIndexesResponse)(nil), "google.datastore.admin.v1.ListIndexesResponse")
	proto.RegisterType((*IndexOperationMetadata)(nil), "google.datastore.admin.v1.IndexOperationMetadata")
	proto.RegisterEnum("google.datastore.admin.v1.OperationType", OperationType_name, OperationType_value)
	proto.RegisterEnum("google.datastore.admin.v1.CommonMetadata_State", CommonMetadata_State_name, CommonMetadata_State_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DatastoreAdminClient is the client API for DatastoreAdmin service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DatastoreAdminClient interface {
	// Exports a copy of all or a subset of entities from Google Cloud Datastore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// entities may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	ExportEntities(ctx context.Context, in *ExportEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Imports entities into Google Cloud Datastore. Existing entities with the
	// same key are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportEntities operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Datastore.
	ImportEntities(ctx context.Context, in *ImportEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets an index.
	GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error)
	// Lists the indexes that match the specified filters.  Datastore uses an
	// eventually consistent query to fetch the list of indexes and may
	// occasionally return stale results.
	ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error)
}

type datastoreAdminClient struct {
	cc *grpc.ClientConn
}

func NewDatastoreAdminClient(cc *grpc.ClientConn) DatastoreAdminClient {
	return &datastoreAdminClient{cc}
}

func (c *datastoreAdminClient) ExportEntities(ctx context.Context, in *ExportEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.datastore.admin.v1.DatastoreAdmin/ExportEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) ImportEntities(ctx context.Context, in *ImportEntitiesRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.datastore.admin.v1.DatastoreAdmin/ImportEntities", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) GetIndex(ctx context.Context, in *GetIndexRequest, opts ...grpc.CallOption) (*Index, error) {
	out := new(Index)
	err := c.cc.Invoke(ctx, "/google.datastore.admin.v1.DatastoreAdmin/GetIndex", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *datastoreAdminClient) ListIndexes(ctx context.Context, in *ListIndexesRequest, opts ...grpc.CallOption) (*ListIndexesResponse, error) {
	out := new(ListIndexesResponse)
	err := c.cc.Invoke(ctx, "/google.datastore.admin.v1.DatastoreAdmin/ListIndexes", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DatastoreAdminServer is the server API for DatastoreAdmin service.
type DatastoreAdminServer interface {
	// Exports a copy of all or a subset of entities from Google Cloud Datastore
	// to another storage system, such as Google Cloud Storage. Recent updates to
	// entities may not be reflected in the export. The export occurs in the
	// background and its progress can be monitored and managed via the
	// Operation resource that is created. The output of an export may only be
	// used once the associated operation is done. If an export operation is
	// cancelled before completion it may leave partial data behind in Google
	// Cloud Storage.
	ExportEntities(context.Context, *ExportEntitiesRequest) (*longrunning.Operation, error)
	// Imports entities into Google Cloud Datastore. Existing entities with the
	// same key are overwritten. The import occurs in the background and its
	// progress can be monitored and managed via the Operation resource that is
	// created. If an ImportEntities operation is cancelled, it is possible
	// that a subset of the data has already been imported to Cloud Datastore.
	ImportEntities(context.Context, *ImportEntitiesRequest) (*longrunning.Operation, error)
	// Gets an index.
	GetIndex(context.Context, *GetIndexRequest) (*Index, error)
	// Lists the indexes that match the specified filters.  Datastore uses an
	// eventually consistent query to fetch the list of indexes and may
	// occasionally return stale results.
	ListIndexes(context.Context, *ListIndexesRequest) (*ListIndexesResponse, error)
}

func RegisterDatastoreAdminServer(s *grpc.Server, srv DatastoreAdminServer) {
	s.RegisterService(&_DatastoreAdmin_serviceDesc, srv)
}

func _DatastoreAdmin_ExportEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).ExportEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.admin.v1.DatastoreAdmin/ExportEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).ExportEntities(ctx, req.(*ExportEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_ImportEntities_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportEntitiesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).ImportEntities(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.admin.v1.DatastoreAdmin/ImportEntities",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).ImportEntities(ctx, req.(*ImportEntitiesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_GetIndex_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetIndexRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).GetIndex(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.admin.v1.DatastoreAdmin/GetIndex",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).GetIndex(ctx, req.(*GetIndexRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DatastoreAdmin_ListIndexes_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListIndexesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DatastoreAdminServer).ListIndexes(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.datastore.admin.v1.DatastoreAdmin/ListIndexes",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DatastoreAdminServer).ListIndexes(ctx, req.(*ListIndexesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DatastoreAdmin_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.datastore.admin.v1.DatastoreAdmin",
	HandlerType: (*DatastoreAdminServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ExportEntities",
			Handler:    _DatastoreAdmin_ExportEntities_Handler,
		},
		{
			MethodName: "ImportEntities",
			Handler:    _DatastoreAdmin_ImportEntities_Handler,
		},
		{
			MethodName: "GetIndex",
			Handler:    _DatastoreAdmin_GetIndex_Handler,
		},
		{
			MethodName: "ListIndexes",
			Handler:    _DatastoreAdmin_ListIndexes_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/datastore/admin/v1/datastore_admin.proto",
}

func init() {
	proto.RegisterFile("google/datastore/admin/v1/datastore_admin.proto", fileDescriptor_datastore_admin_35408641d3652505)
}

var fileDescriptor_datastore_admin_35408641d3652505 = []byte{
	// 1216 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x57, 0xcd, 0x92, 0xdb, 0xc4,
	0x13, 0xff, 0x4b, 0xfe, 0x88, 0xdd, 0x5e, 0x7b, 0x9d, 0xc9, 0x3f, 0x5b, 0x8e, 0x21, 0xc4, 0x68,
	0x2b, 0xb0, 0x59, 0x40, 0x22, 0x86, 0x14, 0x64, 0xa1, 0xa8, 0x72, 0x6c, 0x6d, 0x4a, 0xe0, 0xd8,
	0x2e, 0x59, 0x4b, 0x85, 0x5c, 0x54, 0xda, 0xd5, 0xc4, 0x25, 0x56, 0xd6, 0x08, 0x69, 0x1c, 0xd6,
	0x49, 0xe5, 0xc2, 0x85, 0x03, 0x55, 0x5c, 0x38, 0xc0, 0x33, 0x70, 0xcc, 0x1b, 0x70, 0xe3, 0xce,
	0x99, 0x5b, 0xde, 0x80, 0x17, 0xa0, 0x66, 0xf4, 0xb1, 0xf6, 0xc6, 0xeb, 0x35, 0x6c, 0xa8, 0xe2,
	0xc0, 0xcd, 0xdd, 0xd3, 0xbf, 0xee, 0x9e, 0xdf, 0x74, 0xb7, 0x5b, 0xa0, 0x8c, 0x08, 0x19, 0xb9,
	0x58, 0xb1, 0x2d, 0x6a, 0x85, 0x94, 0x04, 0x58, 0xb1, 0xec, 0xb1, 0xe3, 0x29, 0x8f, 0x6e, 0x1e,
	0xab, 0x4c, 0xae, 0x92, 0xfd, 0x80, 0x50, 0x82, 0xae, 0x44, 0x00, 0x39, 0x3d, 0x95, 0xa3, 0xd3,
	0x47, 0x37, 0xeb, 0xaf, 0xc6, 0xbe, 0x2c, 0xdf, 0x51, 0x2c, 0xcf, 0x23, 0xd4, 0xa2, 0x0e, 0xf1,
	0xc2, 0x08, 0x58, 0xbf, 0x7e, 0x7a, 0x24, 0xc7, 0xb3, 0xf1, 0x51, 0x6c, 0xb6, 0x19, 0x9b, 0xb9,
	0xc4, 0x1b, 0x05, 0x13, 0xcf, 0x73, 0xbc, 0x91, 0x42, 0x7c, 0x1c, 0xcc, 0xf9, 0xba, 0x16, 0x1b,
	0x71, 0x69, 0x7f, 0xf2, 0x50, 0xa1, 0xce, 0x18, 0x87, 0xd4, 0x1a, 0xfb, 0x91, 0x81, 0xf4, 0x2c,
	0x0b, 0x95, 0x36, 0x19, 0x8f, 0x89, 0x77, 0x0f, 0x53, 0x8b, 0x85, 0x44, 0xb7, 0x01, 0x42, 0x6a,
	0x05, 0xd4, 0x64, 0xb6, 0x35, 0xa1, 0x21, 0x6c, 0x95, 0x9a, 0x75, 0x39, 0xbe, 0x4d, 0xe2, 0x48,
	0x36, 0x12, 0x47, 0x7a, 0x91, 0x5b, 0x33, 0x19, 0xdd, 0x82, 0x02, 0xf6, 0xec, 0x08, 0x28, 0x9e,
	0x09, 0xbc, 0x80, 0x3d, 0x9b, 0xc3, 0xfa, 0x50, 0x49, 0x33, 0x37, 0xe9, 0xd4, 0xc7, 0xb5, 0x4c,
	0x43, 0xd8, 0xaa, 0x34, 0xb7, 0xe4, 0x53, 0x39, 0x94, 0xfb, 0x09, 0xc0, 0x98, 0xfa, 0x58, 0x2f,
	0x93, 0x59, 0x11, 0xdd, 0x83, 0xbc, 0x6b, 0xed, 0x63, 0x37, 0xac, 0x65, 0x1b, 0x99, 0xad, 0x52,
	0xf3, 0xd6, 0x12, 0x47, 0xf3, 0xb7, 0x97, 0xbb, 0x1c, 0xa7, 0x7a, 0x34, 0x98, 0xea, 0xb1, 0x13,
	0xa4, 0x42, 0x2e, 0xa4, 0x16, 0xc5, 0xb5, 0x1c, 0x4f, 0x4b, 0x59, 0xdd, 0xdb, 0x90, 0xc1, 0xf4,
	0x08, 0x5d, 0xbf, 0x0d, 0xa5, 0x19, 0xef, 0xa8, 0x0a, 0x99, 0x43, 0x3c, 0xe5, 0x04, 0x17, 0x75,
	0xf6, 0x13, 0xfd, 0x1f, 0x72, 0x8f, 0x2c, 0x77, 0x12, 0x71, 0x57, 0xd4, 0x23, 0x61, 0x47, 0xfc,
	0x50, 0x90, 0xbe, 0x13, 0x20, 0xc7, 0x7d, 0xa1, 0xcb, 0x70, 0x71, 0x68, 0xb4, 0x0c, 0xd5, 0xdc,
	0xeb, 0x0d, 0x07, 0x6a, 0x5b, 0xdb, 0xd5, 0xd4, 0x4e, 0xf5, 0x7f, 0xa8, 0x0a, 0x6b, 0x5a, 0x4f,
	0x33, 0xb4, 0x56, 0x57, 0x7b, 0xa0, 0xf5, 0xee, 0x56, 0x05, 0x54, 0x01, 0x18, 0xe8, 0xfd, 0xb6,
	0x3a, 0x1c, 0x32, 0x59, 0x64, 0x72, 0xbb, 0xd5, 0x6b, 0xab, 0xdd, 0x2e, 0x93, 0x33, 0x4c, 0xde,
	0xd5, 0x7a, 0x89, 0x7d, 0x96, 0xc9, 0xc3, 0xbd, 0x36, 0xb3, 0xdf, 0xdd, 0xeb, 0x56, 0x73, 0x08,
	0x20, 0xbf, 0xdb, 0xd2, 0xba, 0x6a, 0xa7, 0x9a, 0x47, 0x65, 0x28, 0xc6, 0x58, 0xb5, 0x53, 0xbd,
	0x20, 0xdd, 0x87, 0xc2, 0x20, 0x20, 0xa3, 0x00, 0x87, 0x21, 0xba, 0x0e, 0x95, 0xaf, 0x49, 0x70,
	0x68, 0x1e, 0x90, 0xb1, 0xef, 0x62, 0x8a, 0x6d, 0x7e, 0xa1, 0x8c, 0x5e, 0x66, 0xda, 0x76, 0xa2,
	0x4c, 0xcd, 0x70, 0x48, 0x9d, 0xb1, 0xc5, 0xcc, 0xc4, 0x63, 0x33, 0x35, 0x51, 0x4a, 0xbf, 0x88,
	0x70, 0x59, 0x3d, 0xf2, 0x49, 0x40, 0x55, 0x8f, 0x3a, 0xd4, 0xc1, 0xa1, 0x8e, 0xbf, 0x9a, 0xe0,
	0x90, 0xa2, 0xab, 0x00, 0x7e, 0x40, 0xbe, 0xc4, 0x07, 0xd4, 0x74, 0xec, 0x98, 0xb4, 0x62, 0xac,
	0xd1, 0x6c, 0x64, 0xa4, 0x2f, 0x2e, 0xf2, 0x17, 0xff, 0x78, 0xc9, 0x1b, 0x2d, 0x0c, 0xb0, 0xf0,
	0xe1, 0xbb, 0x50, 0xc6, 0xcc, 0x6c, 0x6a, 0x3e, 0x74, 0x5c, 0x8a, 0x03, 0x5e, 0x97, 0xa5, 0xe6,
	0x9b, 0xcb, 0x9c, 0x73, 0xfb, 0x5d, 0x6e, 0xae, 0xaf, 0xe1, 0x19, 0x09, 0x6d, 0xc3, 0x45, 0x32,
	0xa1, 0xfe, 0x84, 0x9a, 0x93, 0xc0, 0x35, 0xfd, 0x00, 0x3f, 0x74, 0x8e, 0x6a, 0x59, 0x7e, 0x93,
	0xf5, 0xe8, 0x60, 0x2f, 0x70, 0x07, 0x5c, 0x7d, 0x9e, 0x5a, 0x79, 0x26, 0xc2, 0x65, 0x6d, 0xfc,
	0x0f, 0x73, 0xb8, 0x30, 0xc0, 0x42, 0x0e, 0x5f, 0x81, 0xa2, 0xe3, 0xc5, 0x97, 0xe6, 0xfc, 0x15,
	0xf5, 0x02, 0x57, 0xec, 0x05, 0xee, 0x8b, 0x04, 0x67, 0xcf, 0x41, 0xf0, 0x79, 0x48, 0xfb, 0x00,
	0x36, 0x4e, 0x96, 0x45, 0xe8, 0x13, 0x2f, 0xc4, 0x8c, 0xb4, 0xe3, 0x57, 0x4b, 0x48, 0x4b, 0x9f,
	0x4b, 0xfa, 0x43, 0x3c, 0x89, 0x4c, 0x07, 0x69, 0x0b, 0xf2, 0x07, 0x7c, 0x1c, 0xc4, 0x43, 0xf4,
	0xc6, 0xca, 0x73, 0x43, 0x8f, 0x81, 0x68, 0x00, 0x17, 0xfd, 0xb8, 0xd3, 0x4c, 0x1c, 0xfb, 0x8f,
	0x27, 0xeb, 0xe6, 0x12, 0x6f, 0x49, 0x77, 0xea, 0xd5, 0x04, 0x9d, 0x24, 0x87, 0x3e, 0x85, 0x4a,
	0xea, 0x71, 0x7f, 0x4a, 0x71, 0x18, 0xd7, 0xf4, 0x4a, 0xee, 0xca, 0x09, 0xf4, 0x0e, 0x43, 0xbe,
	0xdc, 0xd7, 0x5b, 0xdc, 0x1e, 0xb9, 0x85, 0xed, 0x21, 0x3d, 0x17, 0x61, 0x63, 0xbe, 0x04, 0xff,
	0x63, 0xfd, 0xef, 0xb1, 0x3e, 0xd7, 0x9e, 0xb9, 0xf9, 0xf6, 0x94, 0x34, 0x58, 0x9b, 0x85, 0xb2,
	0xfe, 0x39, 0x74, 0x3c, 0x3b, 0xac, 0x09, 0x8d, 0x0c, 0xeb, 0x1f, 0x2e, 0xa0, 0x4d, 0x28, 0x7b,
	0xd6, 0x18, 0x87, 0xbe, 0x75, 0x80, 0x4d, 0xc7, 0x8e, 0xc6, 0x47, 0x51, 0x5f, 0x4b, 0x95, 0x9a,
	0x1d, 0x4a, 0x9f, 0xc1, 0xfa, 0x5d, 0x4c, 0x35, 0xb6, 0xc0, 0xac, 0x38, 0x8e, 0xae, 0x40, 0x81,
	0xef, 0x3b, 0xec, 0x30, 0x9a, 0x1b, 0x17, 0xb8, 0xac, 0xd9, 0xd2, 0xb7, 0x02, 0xa0, 0xae, 0x13,
	0x46, 0xee, 0x56, 0x9e, 0x6f, 0x1b, 0x90, 0x9f, 0x19, 0xe3, 0x45, 0x3d, 0x96, 0x18, 0x05, 0xbe,
	0x35, 0xc2, 0x66, 0xe8, 0x3c, 0xc6, 0x9c, 0xcc, 0x9c, 0x5e, 0x60, 0x8a, 0xa1, 0xf3, 0x98, 0xb7,
	0x3f, 0x3f, 0xa4, 0xe4, 0x10, 0x7b, 0x31, 0x41, 0xdc, 0xdc, 0x60, 0x0a, 0x69, 0x0a, 0x97, 0xe6,
	0x12, 0x89, 0x87, 0xc6, 0x0e, 0x44, 0xb9, 0xe2, 0x88, 0xaa, 0x52, 0xb3, 0xb1, 0x6c, 0x96, 0x72,
	0x52, 0x12, 0x00, 0x7a, 0x03, 0xd6, 0x3d, 0x7c, 0x44, 0xcd, 0x99, 0xb0, 0xd1, 0xb8, 0x2a, 0x33,
	0xf5, 0x20, 0x0d, 0xfd, 0xab, 0x00, 0x1b, 0x1c, 0x9a, 0xae, 0x42, 0xff, 0xee, 0x1e, 0x38, 0xfd,
	0x3d, 0xb7, 0x9f, 0x42, 0x79, 0x6e, 0x9f, 0x43, 0xaf, 0x41, 0xbd, 0x3f, 0x50, 0xf5, 0x96, 0xa1,
	0xf5, 0x7b, 0xa6, 0xf1, 0xc5, 0xe0, 0xe4, 0xba, 0x73, 0x09, 0xd6, 0xd5, 0xfb, 0x83, 0xbe, 0x6e,
	0x98, 0x6a, 0xcf, 0xd0, 0x0c, 0x4d, 0x1d, 0x56, 0x05, 0xa6, 0xd4, 0xee, 0xcd, 0x2b, 0x45, 0xb6,
	0x18, 0xb5, 0x75, 0x95, 0x2d, 0x4c, 0x5a, 0xaf, 0xa3, 0xde, 0xaf, 0x66, 0x98, 0xa6, 0xa3, 0x76,
	0xd5, 0x54, 0x93, 0x6d, 0xfe, 0x9e, 0x85, 0x4a, 0x27, 0xb9, 0x4b, 0x8b, 0x5d, 0x05, 0x7d, 0x2f,
	0x40, 0x65, 0x7e, 0xac, 0xa3, 0x77, 0xff, 0xea, 0x4a, 0x51, 0xbf, 0x9a, 0x20, 0x66, 0x76, 0xf4,
	0xe3, 0xc5, 0x55, 0x7a, 0xeb, 0x9b, 0xdf, 0x9e, 0xff, 0x20, 0x5e, 0x97, 0x1a, 0x6c, 0xb5, 0x8f,
	0xcb, 0x34, 0x54, 0x9e, 0x1c, 0x97, 0xf0, 0xd3, 0x1d, 0xcc, 0xfd, 0xee, 0x08, 0xdb, 0x3c, 0xa1,
	0xf9, 0x89, 0xb7, 0x34, 0xa1, 0x85, 0xff, 0xcf, 0x2f, 0x21, 0x21, 0x67, 0x3c, 0x93, 0x50, 0x21,
	0xe9, 0x68, 0xb4, 0xbd, 0x24, 0x95, 0x13, 0x6d, 0x5f, 0x3f, 0xb3, 0x15, 0xa4, 0xf7, 0x79, 0x1e,
	0x32, 0x7a, 0xfb, 0xd4, 0x3c, 0x94, 0xb8, 0x59, 0x94, 0x27, 0x49, 0x49, 0x3d, 0x45, 0x3f, 0x0a,
	0x50, 0x9a, 0xe9, 0x45, 0xf4, 0xce, 0x92, 0x38, 0x2f, 0x0e, 0x8f, 0xba, 0xbc, 0xaa, 0x79, 0xd4,
	0xe2, 0xd2, 0x0d, 0x9e, 0xe4, 0x26, 0x7a, 0xfd, 0xcc, 0x24, 0xef, 0xfc, 0x24, 0xc0, 0xd5, 0x03,
	0x32, 0x3e, 0x3d, 0xc0, 0x9d, 0x4b, 0xf3, 0xe5, 0x37, 0x60, 0x1f, 0x4b, 0x03, 0xe1, 0xc1, 0x27,
	0x31, 0x62, 0x44, 0x5c, 0xcb, 0x1b, 0xc9, 0x24, 0x18, 0x29, 0x23, 0xec, 0xf1, 0x4f, 0xa9, 0xf8,
	0x7b, 0xd4, 0xf2, 0x9d, 0x70, 0xc1, 0x97, 0xe2, 0x47, 0xfc, 0xc7, 0xcf, 0xe2, 0xb5, 0xbb, 0x91,
	0x83, 0xb6, 0x4b, 0x26, 0xb6, 0x9c, 0x06, 0x91, 0x79, 0x14, 0xf9, 0xf3, 0x9b, 0xfb, 0x79, 0xee,
	0xec, 0xbd, 0x3f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x9b, 0xe0, 0xf0, 0x1a, 0xdf, 0x0e, 0x00, 0x00,
}
