// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/resources/recommendation.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import common "google.golang.org/genproto/googleapis/ads/googleads/v1/common"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// A recommendation.
type Recommendation struct {
	// The resource name of the recommendation.
	//
	// `customers/{customer_id}/recommendations/{recommendation_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The type of recommendation.
	Type enums.RecommendationTypeEnum_RecommendationType `protobuf:"varint,2,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.RecommendationTypeEnum_RecommendationType" json:"type,omitempty"`
	// The impact on account performance as a result of applying the
	// recommendation.
	Impact *Recommendation_RecommendationImpact `protobuf:"bytes,3,opt,name=impact,proto3" json:"impact,omitempty"`
	// The budget targeted by this recommendation. This will be set only when
	// the recommendation affects a single campaign budget.
	//
	// This field will be set for the following recommendation types:
	// CAMPAIGN_BUDGET
	CampaignBudget *wrappers.StringValue `protobuf:"bytes,5,opt,name=campaign_budget,json=campaignBudget,proto3" json:"campaign_budget,omitempty"`
	// The campaign targeted by this recommendation. This will be set only when
	// the recommendation affects a single campaign.
	//
	// This field will be set for the following recommendation types:
	// ENHANCED_CPC_OPT_IN, KEYWORD, MAXIMIZE_CLICKS_OPT_IN,
	// MAXIMIZE_CONVERSIONS_OPT_IN, OPTIMIZE_AD_ROTATION, SEARCH_PARTNERS_OPT_IN,
	// TARGET_CPA_OPT_IN, TEXT_AD
	Campaign *wrappers.StringValue `protobuf:"bytes,6,opt,name=campaign,proto3" json:"campaign,omitempty"`
	// The ad group targeted by this recommendation. This will be set only when
	// the recommendation affects a single ad group.
	//
	// This field will be set for the following recommendation types:
	// KEYWORD, OPTIMIZE_AD_ROTATION, TEXT_AD
	AdGroup *wrappers.StringValue `protobuf:"bytes,7,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// Whether the recommendation is dismissed or not.
	Dismissed *wrappers.BoolValue `protobuf:"bytes,13,opt,name=dismissed,proto3" json:"dismissed,omitempty"`
	// The details of recommendation.
	//
	// Types that are valid to be assigned to Recommendation:
	//	*Recommendation_CampaignBudgetRecommendation_
	//	*Recommendation_KeywordRecommendation_
	//	*Recommendation_TextAdRecommendation_
	//	*Recommendation_TargetCpaOptInRecommendation_
	//	*Recommendation_MaximizeConversionsOptInRecommendation_
	//	*Recommendation_EnhancedCpcOptInRecommendation_
	//	*Recommendation_SearchPartnersOptInRecommendation_
	//	*Recommendation_MaximizeClicksOptInRecommendation_
	//	*Recommendation_OptimizeAdRotationRecommendation_
	//	*Recommendation_CalloutExtensionRecommendation_
	//	*Recommendation_SitelinkExtensionRecommendation_
	//	*Recommendation_CallExtensionRecommendation_
	//	*Recommendation_KeywordMatchTypeRecommendation_
	//	*Recommendation_MoveUnusedBudgetRecommendation_
	Recommendation       isRecommendation_Recommendation `protobuf_oneof:"recommendation"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *Recommendation) Reset()         { *m = Recommendation{} }
func (m *Recommendation) String() string { return proto.CompactTextString(m) }
func (*Recommendation) ProtoMessage()    {}
func (*Recommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0}
}
func (m *Recommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation.Unmarshal(m, b)
}
func (m *Recommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation.Merge(dst, src)
}
func (m *Recommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation.Size(m)
}
func (m *Recommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation proto.InternalMessageInfo

func (m *Recommendation) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *Recommendation) GetType() enums.RecommendationTypeEnum_RecommendationType {
	if m != nil {
		return m.Type
	}
	return enums.RecommendationTypeEnum_UNSPECIFIED
}

func (m *Recommendation) GetImpact() *Recommendation_RecommendationImpact {
	if m != nil {
		return m.Impact
	}
	return nil
}

func (m *Recommendation) GetCampaignBudget() *wrappers.StringValue {
	if m != nil {
		return m.CampaignBudget
	}
	return nil
}

func (m *Recommendation) GetCampaign() *wrappers.StringValue {
	if m != nil {
		return m.Campaign
	}
	return nil
}

func (m *Recommendation) GetAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *Recommendation) GetDismissed() *wrappers.BoolValue {
	if m != nil {
		return m.Dismissed
	}
	return nil
}

type isRecommendation_Recommendation interface {
	isRecommendation_Recommendation()
}

type Recommendation_CampaignBudgetRecommendation_ struct {
	CampaignBudgetRecommendation *Recommendation_CampaignBudgetRecommendation `protobuf:"bytes,4,opt,name=campaign_budget_recommendation,json=campaignBudgetRecommendation,proto3,oneof"`
}

type Recommendation_KeywordRecommendation_ struct {
	KeywordRecommendation *Recommendation_KeywordRecommendation `protobuf:"bytes,8,opt,name=keyword_recommendation,json=keywordRecommendation,proto3,oneof"`
}

type Recommendation_TextAdRecommendation_ struct {
	TextAdRecommendation *Recommendation_TextAdRecommendation `protobuf:"bytes,9,opt,name=text_ad_recommendation,json=textAdRecommendation,proto3,oneof"`
}

type Recommendation_TargetCpaOptInRecommendation_ struct {
	TargetCpaOptInRecommendation *Recommendation_TargetCpaOptInRecommendation `protobuf:"bytes,10,opt,name=target_cpa_opt_in_recommendation,json=targetCpaOptInRecommendation,proto3,oneof"`
}

type Recommendation_MaximizeConversionsOptInRecommendation_ struct {
	MaximizeConversionsOptInRecommendation *Recommendation_MaximizeConversionsOptInRecommendation `protobuf:"bytes,11,opt,name=maximize_conversions_opt_in_recommendation,json=maximizeConversionsOptInRecommendation,proto3,oneof"`
}

type Recommendation_EnhancedCpcOptInRecommendation_ struct {
	EnhancedCpcOptInRecommendation *Recommendation_EnhancedCpcOptInRecommendation `protobuf:"bytes,12,opt,name=enhanced_cpc_opt_in_recommendation,json=enhancedCpcOptInRecommendation,proto3,oneof"`
}

type Recommendation_SearchPartnersOptInRecommendation_ struct {
	SearchPartnersOptInRecommendation *Recommendation_SearchPartnersOptInRecommendation `protobuf:"bytes,14,opt,name=search_partners_opt_in_recommendation,json=searchPartnersOptInRecommendation,proto3,oneof"`
}

type Recommendation_MaximizeClicksOptInRecommendation_ struct {
	MaximizeClicksOptInRecommendation *Recommendation_MaximizeClicksOptInRecommendation `protobuf:"bytes,15,opt,name=maximize_clicks_opt_in_recommendation,json=maximizeClicksOptInRecommendation,proto3,oneof"`
}

type Recommendation_OptimizeAdRotationRecommendation_ struct {
	OptimizeAdRotationRecommendation *Recommendation_OptimizeAdRotationRecommendation `protobuf:"bytes,16,opt,name=optimize_ad_rotation_recommendation,json=optimizeAdRotationRecommendation,proto3,oneof"`
}

type Recommendation_CalloutExtensionRecommendation_ struct {
	CalloutExtensionRecommendation *Recommendation_CalloutExtensionRecommendation `protobuf:"bytes,17,opt,name=callout_extension_recommendation,json=calloutExtensionRecommendation,proto3,oneof"`
}

type Recommendation_SitelinkExtensionRecommendation_ struct {
	SitelinkExtensionRecommendation *Recommendation_SitelinkExtensionRecommendation `protobuf:"bytes,18,opt,name=sitelink_extension_recommendation,json=sitelinkExtensionRecommendation,proto3,oneof"`
}

type Recommendation_CallExtensionRecommendation_ struct {
	CallExtensionRecommendation *Recommendation_CallExtensionRecommendation `protobuf:"bytes,19,opt,name=call_extension_recommendation,json=callExtensionRecommendation,proto3,oneof"`
}

type Recommendation_KeywordMatchTypeRecommendation_ struct {
	KeywordMatchTypeRecommendation *Recommendation_KeywordMatchTypeRecommendation `protobuf:"bytes,20,opt,name=keyword_match_type_recommendation,json=keywordMatchTypeRecommendation,proto3,oneof"`
}

type Recommendation_MoveUnusedBudgetRecommendation_ struct {
	MoveUnusedBudgetRecommendation *Recommendation_MoveUnusedBudgetRecommendation `protobuf:"bytes,21,opt,name=move_unused_budget_recommendation,json=moveUnusedBudgetRecommendation,proto3,oneof"`
}

func (*Recommendation_CampaignBudgetRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_KeywordRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_TextAdRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_TargetCpaOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_MaximizeConversionsOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_EnhancedCpcOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_SearchPartnersOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_MaximizeClicksOptInRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_OptimizeAdRotationRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_CalloutExtensionRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_SitelinkExtensionRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_CallExtensionRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_KeywordMatchTypeRecommendation_) isRecommendation_Recommendation() {}

func (*Recommendation_MoveUnusedBudgetRecommendation_) isRecommendation_Recommendation() {}

func (m *Recommendation) GetRecommendation() isRecommendation_Recommendation {
	if m != nil {
		return m.Recommendation
	}
	return nil
}

func (m *Recommendation) GetCampaignBudgetRecommendation() *Recommendation_CampaignBudgetRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_CampaignBudgetRecommendation_); ok {
		return x.CampaignBudgetRecommendation
	}
	return nil
}

func (m *Recommendation) GetKeywordRecommendation() *Recommendation_KeywordRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_KeywordRecommendation_); ok {
		return x.KeywordRecommendation
	}
	return nil
}

func (m *Recommendation) GetTextAdRecommendation() *Recommendation_TextAdRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_TextAdRecommendation_); ok {
		return x.TextAdRecommendation
	}
	return nil
}

func (m *Recommendation) GetTargetCpaOptInRecommendation() *Recommendation_TargetCpaOptInRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_TargetCpaOptInRecommendation_); ok {
		return x.TargetCpaOptInRecommendation
	}
	return nil
}

func (m *Recommendation) GetMaximizeConversionsOptInRecommendation() *Recommendation_MaximizeConversionsOptInRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_MaximizeConversionsOptInRecommendation_); ok {
		return x.MaximizeConversionsOptInRecommendation
	}
	return nil
}

func (m *Recommendation) GetEnhancedCpcOptInRecommendation() *Recommendation_EnhancedCpcOptInRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_EnhancedCpcOptInRecommendation_); ok {
		return x.EnhancedCpcOptInRecommendation
	}
	return nil
}

func (m *Recommendation) GetSearchPartnersOptInRecommendation() *Recommendation_SearchPartnersOptInRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_SearchPartnersOptInRecommendation_); ok {
		return x.SearchPartnersOptInRecommendation
	}
	return nil
}

func (m *Recommendation) GetMaximizeClicksOptInRecommendation() *Recommendation_MaximizeClicksOptInRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_MaximizeClicksOptInRecommendation_); ok {
		return x.MaximizeClicksOptInRecommendation
	}
	return nil
}

func (m *Recommendation) GetOptimizeAdRotationRecommendation() *Recommendation_OptimizeAdRotationRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_OptimizeAdRotationRecommendation_); ok {
		return x.OptimizeAdRotationRecommendation
	}
	return nil
}

func (m *Recommendation) GetCalloutExtensionRecommendation() *Recommendation_CalloutExtensionRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_CalloutExtensionRecommendation_); ok {
		return x.CalloutExtensionRecommendation
	}
	return nil
}

func (m *Recommendation) GetSitelinkExtensionRecommendation() *Recommendation_SitelinkExtensionRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_SitelinkExtensionRecommendation_); ok {
		return x.SitelinkExtensionRecommendation
	}
	return nil
}

func (m *Recommendation) GetCallExtensionRecommendation() *Recommendation_CallExtensionRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_CallExtensionRecommendation_); ok {
		return x.CallExtensionRecommendation
	}
	return nil
}

func (m *Recommendation) GetKeywordMatchTypeRecommendation() *Recommendation_KeywordMatchTypeRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_KeywordMatchTypeRecommendation_); ok {
		return x.KeywordMatchTypeRecommendation
	}
	return nil
}

func (m *Recommendation) GetMoveUnusedBudgetRecommendation() *Recommendation_MoveUnusedBudgetRecommendation {
	if x, ok := m.GetRecommendation().(*Recommendation_MoveUnusedBudgetRecommendation_); ok {
		return x.MoveUnusedBudgetRecommendation
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Recommendation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Recommendation_OneofMarshaler, _Recommendation_OneofUnmarshaler, _Recommendation_OneofSizer, []interface{}{
		(*Recommendation_CampaignBudgetRecommendation_)(nil),
		(*Recommendation_KeywordRecommendation_)(nil),
		(*Recommendation_TextAdRecommendation_)(nil),
		(*Recommendation_TargetCpaOptInRecommendation_)(nil),
		(*Recommendation_MaximizeConversionsOptInRecommendation_)(nil),
		(*Recommendation_EnhancedCpcOptInRecommendation_)(nil),
		(*Recommendation_SearchPartnersOptInRecommendation_)(nil),
		(*Recommendation_MaximizeClicksOptInRecommendation_)(nil),
		(*Recommendation_OptimizeAdRotationRecommendation_)(nil),
		(*Recommendation_CalloutExtensionRecommendation_)(nil),
		(*Recommendation_SitelinkExtensionRecommendation_)(nil),
		(*Recommendation_CallExtensionRecommendation_)(nil),
		(*Recommendation_KeywordMatchTypeRecommendation_)(nil),
		(*Recommendation_MoveUnusedBudgetRecommendation_)(nil),
	}
}

func _Recommendation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Recommendation)
	// recommendation
	switch x := m.Recommendation.(type) {
	case *Recommendation_CampaignBudgetRecommendation_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CampaignBudgetRecommendation); err != nil {
			return err
		}
	case *Recommendation_KeywordRecommendation_:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.KeywordRecommendation); err != nil {
			return err
		}
	case *Recommendation_TextAdRecommendation_:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TextAdRecommendation); err != nil {
			return err
		}
	case *Recommendation_TargetCpaOptInRecommendation_:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TargetCpaOptInRecommendation); err != nil {
			return err
		}
	case *Recommendation_MaximizeConversionsOptInRecommendation_:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MaximizeConversionsOptInRecommendation); err != nil {
			return err
		}
	case *Recommendation_EnhancedCpcOptInRecommendation_:
		b.EncodeVarint(12<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.EnhancedCpcOptInRecommendation); err != nil {
			return err
		}
	case *Recommendation_SearchPartnersOptInRecommendation_:
		b.EncodeVarint(14<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SearchPartnersOptInRecommendation); err != nil {
			return err
		}
	case *Recommendation_MaximizeClicksOptInRecommendation_:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MaximizeClicksOptInRecommendation); err != nil {
			return err
		}
	case *Recommendation_OptimizeAdRotationRecommendation_:
		b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.OptimizeAdRotationRecommendation); err != nil {
			return err
		}
	case *Recommendation_CalloutExtensionRecommendation_:
		b.EncodeVarint(17<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CalloutExtensionRecommendation); err != nil {
			return err
		}
	case *Recommendation_SitelinkExtensionRecommendation_:
		b.EncodeVarint(18<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SitelinkExtensionRecommendation); err != nil {
			return err
		}
	case *Recommendation_CallExtensionRecommendation_:
		b.EncodeVarint(19<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CallExtensionRecommendation); err != nil {
			return err
		}
	case *Recommendation_KeywordMatchTypeRecommendation_:
		b.EncodeVarint(20<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.KeywordMatchTypeRecommendation); err != nil {
			return err
		}
	case *Recommendation_MoveUnusedBudgetRecommendation_:
		b.EncodeVarint(21<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MoveUnusedBudgetRecommendation); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Recommendation.Recommendation has unexpected type %T", x)
	}
	return nil
}

func _Recommendation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Recommendation)
	switch tag {
	case 4: // recommendation.campaign_budget_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_CampaignBudgetRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_CampaignBudgetRecommendation_{msg}
		return true, err
	case 8: // recommendation.keyword_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_KeywordRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_KeywordRecommendation_{msg}
		return true, err
	case 9: // recommendation.text_ad_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_TextAdRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_TextAdRecommendation_{msg}
		return true, err
	case 10: // recommendation.target_cpa_opt_in_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_TargetCpaOptInRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_TargetCpaOptInRecommendation_{msg}
		return true, err
	case 11: // recommendation.maximize_conversions_opt_in_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_MaximizeConversionsOptInRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_MaximizeConversionsOptInRecommendation_{msg}
		return true, err
	case 12: // recommendation.enhanced_cpc_opt_in_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_EnhancedCpcOptInRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_EnhancedCpcOptInRecommendation_{msg}
		return true, err
	case 14: // recommendation.search_partners_opt_in_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_SearchPartnersOptInRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_SearchPartnersOptInRecommendation_{msg}
		return true, err
	case 15: // recommendation.maximize_clicks_opt_in_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_MaximizeClicksOptInRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_MaximizeClicksOptInRecommendation_{msg}
		return true, err
	case 16: // recommendation.optimize_ad_rotation_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_OptimizeAdRotationRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_OptimizeAdRotationRecommendation_{msg}
		return true, err
	case 17: // recommendation.callout_extension_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_CalloutExtensionRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_CalloutExtensionRecommendation_{msg}
		return true, err
	case 18: // recommendation.sitelink_extension_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_SitelinkExtensionRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_SitelinkExtensionRecommendation_{msg}
		return true, err
	case 19: // recommendation.call_extension_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_CallExtensionRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_CallExtensionRecommendation_{msg}
		return true, err
	case 20: // recommendation.keyword_match_type_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_KeywordMatchTypeRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_KeywordMatchTypeRecommendation_{msg}
		return true, err
	case 21: // recommendation.move_unused_budget_recommendation
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Recommendation_MoveUnusedBudgetRecommendation)
		err := b.DecodeMessage(msg)
		m.Recommendation = &Recommendation_MoveUnusedBudgetRecommendation_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Recommendation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Recommendation)
	// recommendation
	switch x := m.Recommendation.(type) {
	case *Recommendation_CampaignBudgetRecommendation_:
		s := proto.Size(x.CampaignBudgetRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_KeywordRecommendation_:
		s := proto.Size(x.KeywordRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_TextAdRecommendation_:
		s := proto.Size(x.TextAdRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_TargetCpaOptInRecommendation_:
		s := proto.Size(x.TargetCpaOptInRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_MaximizeConversionsOptInRecommendation_:
		s := proto.Size(x.MaximizeConversionsOptInRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_EnhancedCpcOptInRecommendation_:
		s := proto.Size(x.EnhancedCpcOptInRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_SearchPartnersOptInRecommendation_:
		s := proto.Size(x.SearchPartnersOptInRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_MaximizeClicksOptInRecommendation_:
		s := proto.Size(x.MaximizeClicksOptInRecommendation)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_OptimizeAdRotationRecommendation_:
		s := proto.Size(x.OptimizeAdRotationRecommendation)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_CalloutExtensionRecommendation_:
		s := proto.Size(x.CalloutExtensionRecommendation)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_SitelinkExtensionRecommendation_:
		s := proto.Size(x.SitelinkExtensionRecommendation)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_CallExtensionRecommendation_:
		s := proto.Size(x.CallExtensionRecommendation)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_KeywordMatchTypeRecommendation_:
		s := proto.Size(x.KeywordMatchTypeRecommendation)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Recommendation_MoveUnusedBudgetRecommendation_:
		s := proto.Size(x.MoveUnusedBudgetRecommendation)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The impact of making the change as described in the recommendation.
// Some types of recommendations may not have impact information.
type Recommendation_RecommendationImpact struct {
	// Base metrics at the time the recommendation was generated.
	BaseMetrics *Recommendation_RecommendationMetrics `protobuf:"bytes,1,opt,name=base_metrics,json=baseMetrics,proto3" json:"base_metrics,omitempty"`
	// Estimated metrics if the recommendation is applied.
	PotentialMetrics     *Recommendation_RecommendationMetrics `protobuf:"bytes,2,opt,name=potential_metrics,json=potentialMetrics,proto3" json:"potential_metrics,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *Recommendation_RecommendationImpact) Reset()         { *m = Recommendation_RecommendationImpact{} }
func (m *Recommendation_RecommendationImpact) String() string { return proto.CompactTextString(m) }
func (*Recommendation_RecommendationImpact) ProtoMessage()    {}
func (*Recommendation_RecommendationImpact) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 0}
}
func (m *Recommendation_RecommendationImpact) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_RecommendationImpact.Unmarshal(m, b)
}
func (m *Recommendation_RecommendationImpact) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_RecommendationImpact.Marshal(b, m, deterministic)
}
func (dst *Recommendation_RecommendationImpact) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_RecommendationImpact.Merge(dst, src)
}
func (m *Recommendation_RecommendationImpact) XXX_Size() int {
	return xxx_messageInfo_Recommendation_RecommendationImpact.Size(m)
}
func (m *Recommendation_RecommendationImpact) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_RecommendationImpact.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_RecommendationImpact proto.InternalMessageInfo

func (m *Recommendation_RecommendationImpact) GetBaseMetrics() *Recommendation_RecommendationMetrics {
	if m != nil {
		return m.BaseMetrics
	}
	return nil
}

func (m *Recommendation_RecommendationImpact) GetPotentialMetrics() *Recommendation_RecommendationMetrics {
	if m != nil {
		return m.PotentialMetrics
	}
	return nil
}

// Weekly account performance metrics. For some recommendation types, these
// are averaged over the past 90-day period and hence can be fractional.
type Recommendation_RecommendationMetrics struct {
	// Number of ad impressions.
	Impressions *wrappers.DoubleValue `protobuf:"bytes,1,opt,name=impressions,proto3" json:"impressions,omitempty"`
	// Number of ad clicks.
	Clicks *wrappers.DoubleValue `protobuf:"bytes,2,opt,name=clicks,proto3" json:"clicks,omitempty"`
	// Cost (in micros) for advertising, in the local currency for the account.
	CostMicros *wrappers.Int64Value `protobuf:"bytes,3,opt,name=cost_micros,json=costMicros,proto3" json:"cost_micros,omitempty"`
	// Number of conversions.
	Conversions *wrappers.DoubleValue `protobuf:"bytes,4,opt,name=conversions,proto3" json:"conversions,omitempty"`
	// Number of video views for a video ad campaign.
	VideoViews           *wrappers.DoubleValue `protobuf:"bytes,5,opt,name=video_views,json=videoViews,proto3" json:"video_views,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Recommendation_RecommendationMetrics) Reset()         { *m = Recommendation_RecommendationMetrics{} }
func (m *Recommendation_RecommendationMetrics) String() string { return proto.CompactTextString(m) }
func (*Recommendation_RecommendationMetrics) ProtoMessage()    {}
func (*Recommendation_RecommendationMetrics) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 1}
}
func (m *Recommendation_RecommendationMetrics) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_RecommendationMetrics.Unmarshal(m, b)
}
func (m *Recommendation_RecommendationMetrics) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_RecommendationMetrics.Marshal(b, m, deterministic)
}
func (dst *Recommendation_RecommendationMetrics) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_RecommendationMetrics.Merge(dst, src)
}
func (m *Recommendation_RecommendationMetrics) XXX_Size() int {
	return xxx_messageInfo_Recommendation_RecommendationMetrics.Size(m)
}
func (m *Recommendation_RecommendationMetrics) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_RecommendationMetrics.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_RecommendationMetrics proto.InternalMessageInfo

func (m *Recommendation_RecommendationMetrics) GetImpressions() *wrappers.DoubleValue {
	if m != nil {
		return m.Impressions
	}
	return nil
}

func (m *Recommendation_RecommendationMetrics) GetClicks() *wrappers.DoubleValue {
	if m != nil {
		return m.Clicks
	}
	return nil
}

func (m *Recommendation_RecommendationMetrics) GetCostMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CostMicros
	}
	return nil
}

func (m *Recommendation_RecommendationMetrics) GetConversions() *wrappers.DoubleValue {
	if m != nil {
		return m.Conversions
	}
	return nil
}

func (m *Recommendation_RecommendationMetrics) GetVideoViews() *wrappers.DoubleValue {
	if m != nil {
		return m.VideoViews
	}
	return nil
}

// The budget recommendation for budget constrained campaigns.
type Recommendation_CampaignBudgetRecommendation struct {
	// The current budget amount in micros.
	CurrentBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=current_budget_amount_micros,json=currentBudgetAmountMicros,proto3" json:"current_budget_amount_micros,omitempty"`
	// The recommended budget amount in micros.
	RecommendedBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
	// The budget amounts and associated impact estimates for some values of
	// possible budget amounts.
	BudgetOptions        []*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption `protobuf:"bytes,3,rep,name=budget_options,json=budgetOptions,proto3" json:"budget_options,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                                          `json:"-"`
	XXX_unrecognized     []byte                                                                            `json:"-"`
	XXX_sizecache        int32                                                                             `json:"-"`
}

func (m *Recommendation_CampaignBudgetRecommendation) Reset() {
	*m = Recommendation_CampaignBudgetRecommendation{}
}
func (m *Recommendation_CampaignBudgetRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_CampaignBudgetRecommendation) ProtoMessage() {}
func (*Recommendation_CampaignBudgetRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 2}
}
func (m *Recommendation_CampaignBudgetRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_CampaignBudgetRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_CampaignBudgetRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_CampaignBudgetRecommendation.Merge(dst, src)
}
func (m *Recommendation_CampaignBudgetRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation.Size(m)
}
func (m *Recommendation_CampaignBudgetRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_CampaignBudgetRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_CampaignBudgetRecommendation proto.InternalMessageInfo

func (m *Recommendation_CampaignBudgetRecommendation) GetCurrentBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CurrentBudgetAmountMicros
	}
	return nil
}

func (m *Recommendation_CampaignBudgetRecommendation) GetRecommendedBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetAmountMicros
	}
	return nil
}

func (m *Recommendation_CampaignBudgetRecommendation) GetBudgetOptions() []*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption {
	if m != nil {
		return m.BudgetOptions
	}
	return nil
}

// The impact estimates for a given budget amount.
type Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption struct {
	// The budget amount for this option.
	BudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=budget_amount_micros,json=budgetAmountMicros,proto3" json:"budget_amount_micros,omitempty"`
	// The impact estimate if budget is changed to amount specified in this
	// option.
	Impact               *Recommendation_RecommendationImpact `protobuf:"bytes,2,opt,name=impact,proto3" json:"impact,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) Reset() {
	*m = Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption{}
}
func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) ProtoMessage() {
}
func (*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 2, 0}
}
func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.Unmarshal(m, b)
}
func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.Marshal(b, m, deterministic)
}
func (dst *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.Merge(dst, src)
}
func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) XXX_Size() int {
	return xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.Size(m)
}
func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption proto.InternalMessageInfo

func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) GetBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.BudgetAmountMicros
	}
	return nil
}

func (m *Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption) GetImpact() *Recommendation_RecommendationImpact {
	if m != nil {
		return m.Impact
	}
	return nil
}

// The keyword recommendation.
type Recommendation_KeywordRecommendation struct {
	// The recommended keyword.
	Keyword *common.KeywordInfo `protobuf:"bytes,1,opt,name=keyword,proto3" json:"keyword,omitempty"`
	// The recommended CPC (cost-per-click) bid.
	RecommendedCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=recommended_cpc_bid_micros,json=recommendedCpcBidMicros,proto3" json:"recommended_cpc_bid_micros,omitempty"`
	XXX_NoUnkeyedLiteral    struct{}             `json:"-"`
	XXX_unrecognized        []byte               `json:"-"`
	XXX_sizecache           int32                `json:"-"`
}

func (m *Recommendation_KeywordRecommendation) Reset()         { *m = Recommendation_KeywordRecommendation{} }
func (m *Recommendation_KeywordRecommendation) String() string { return proto.CompactTextString(m) }
func (*Recommendation_KeywordRecommendation) ProtoMessage()    {}
func (*Recommendation_KeywordRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 3}
}
func (m *Recommendation_KeywordRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_KeywordRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_KeywordRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_KeywordRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_KeywordRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_KeywordRecommendation.Merge(dst, src)
}
func (m *Recommendation_KeywordRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_KeywordRecommendation.Size(m)
}
func (m *Recommendation_KeywordRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_KeywordRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_KeywordRecommendation proto.InternalMessageInfo

func (m *Recommendation_KeywordRecommendation) GetKeyword() *common.KeywordInfo {
	if m != nil {
		return m.Keyword
	}
	return nil
}

func (m *Recommendation_KeywordRecommendation) GetRecommendedCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedCpcBidMicros
	}
	return nil
}

// The text ad recommendation.
type Recommendation_TextAdRecommendation struct {
	// Recommended ad.
	Ad *Ad `protobuf:"bytes,1,opt,name=ad,proto3" json:"ad,omitempty"`
	// Creation date of the recommended ad.
	// YYYY-MM-DD format, e.g., 2018-04-17.
	CreationDate *wrappers.StringValue `protobuf:"bytes,2,opt,name=creation_date,json=creationDate,proto3" json:"creation_date,omitempty"`
	// Date, if present, is the earliest when the recommendation will be auto
	// applied.
	// YYYY-MM-DD format, e.g., 2018-04-17.
	AutoApplyDate        *wrappers.StringValue `protobuf:"bytes,3,opt,name=auto_apply_date,json=autoApplyDate,proto3" json:"auto_apply_date,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *Recommendation_TextAdRecommendation) Reset()         { *m = Recommendation_TextAdRecommendation{} }
func (m *Recommendation_TextAdRecommendation) String() string { return proto.CompactTextString(m) }
func (*Recommendation_TextAdRecommendation) ProtoMessage()    {}
func (*Recommendation_TextAdRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 4}
}
func (m *Recommendation_TextAdRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_TextAdRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_TextAdRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_TextAdRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_TextAdRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_TextAdRecommendation.Merge(dst, src)
}
func (m *Recommendation_TextAdRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_TextAdRecommendation.Size(m)
}
func (m *Recommendation_TextAdRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_TextAdRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_TextAdRecommendation proto.InternalMessageInfo

func (m *Recommendation_TextAdRecommendation) GetAd() *Ad {
	if m != nil {
		return m.Ad
	}
	return nil
}

func (m *Recommendation_TextAdRecommendation) GetCreationDate() *wrappers.StringValue {
	if m != nil {
		return m.CreationDate
	}
	return nil
}

func (m *Recommendation_TextAdRecommendation) GetAutoApplyDate() *wrappers.StringValue {
	if m != nil {
		return m.AutoApplyDate
	}
	return nil
}

// The Target CPA opt-in recommendation.
type Recommendation_TargetCpaOptInRecommendation struct {
	// The available goals and corresponding options for Target CPA strategy.
	Options []*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption `protobuf:"bytes,1,rep,name=options,proto3" json:"options,omitempty"`
	// The recommended average CPA target. See required budget amount and impact
	// of using this recommendation in options list.
	RecommendedTargetCpaMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=recommended_target_cpa_micros,json=recommendedTargetCpaMicros,proto3" json:"recommended_target_cpa_micros,omitempty"`
	XXX_NoUnkeyedLiteral       struct{}             `json:"-"`
	XXX_unrecognized           []byte               `json:"-"`
	XXX_sizecache              int32                `json:"-"`
}

func (m *Recommendation_TargetCpaOptInRecommendation) Reset() {
	*m = Recommendation_TargetCpaOptInRecommendation{}
}
func (m *Recommendation_TargetCpaOptInRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_TargetCpaOptInRecommendation) ProtoMessage() {}
func (*Recommendation_TargetCpaOptInRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 5}
}
func (m *Recommendation_TargetCpaOptInRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_TargetCpaOptInRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_TargetCpaOptInRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation.Merge(dst, src)
}
func (m *Recommendation_TargetCpaOptInRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation.Size(m)
}
func (m *Recommendation_TargetCpaOptInRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation proto.InternalMessageInfo

func (m *Recommendation_TargetCpaOptInRecommendation) GetOptions() []*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption {
	if m != nil {
		return m.Options
	}
	return nil
}

func (m *Recommendation_TargetCpaOptInRecommendation) GetRecommendedTargetCpaMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedTargetCpaMicros
	}
	return nil
}

// The Target CPA opt-in option with impact estimate.
type Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption struct {
	// The goal achieved by this option.
	Goal enums.TargetCpaOptInRecommendationGoalEnum_TargetCpaOptInRecommendationGoal `protobuf:"varint,1,opt,name=goal,proto3,enum=google.ads.googleads.v1.enums.TargetCpaOptInRecommendationGoalEnum_TargetCpaOptInRecommendationGoal" json:"goal,omitempty"`
	// Average CPA target.
	TargetCpaMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=target_cpa_micros,json=targetCpaMicros,proto3" json:"target_cpa_micros,omitempty"`
	// The minimum campaign budget, in local currency for the account,
	// required to achieve the target CPA.
	// Amount is specified in micros, where one million is equivalent to one
	// currency unit.
	RequiredCampaignBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,3,opt,name=required_campaign_budget_amount_micros,json=requiredCampaignBudgetAmountMicros,proto3" json:"required_campaign_budget_amount_micros,omitempty"`
	// The impact estimate if this option is selected.
	Impact               *Recommendation_RecommendationImpact `protobuf:"bytes,4,opt,name=impact,proto3" json:"impact,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) Reset() {
	*m = Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption{}
}
func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) ProtoMessage() {
}
func (*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 5, 0}
}
func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.Unmarshal(m, b)
}
func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.Marshal(b, m, deterministic)
}
func (dst *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.Merge(dst, src)
}
func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) XXX_Size() int {
	return xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.Size(m)
}
func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption proto.InternalMessageInfo

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetGoal() enums.TargetCpaOptInRecommendationGoalEnum_TargetCpaOptInRecommendationGoal {
	if m != nil {
		return m.Goal
	}
	return enums.TargetCpaOptInRecommendationGoalEnum_UNSPECIFIED
}

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetTargetCpaMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TargetCpaMicros
	}
	return nil
}

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetRequiredCampaignBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RequiredCampaignBudgetAmountMicros
	}
	return nil
}

func (m *Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption) GetImpact() *Recommendation_RecommendationImpact {
	if m != nil {
		return m.Impact
	}
	return nil
}

// The keyword match type recommendation.
type Recommendation_KeywordMatchTypeRecommendation struct {
	// The existing keyword where the match type should be more broad.
	Keyword *common.KeywordInfo `protobuf:"bytes,1,opt,name=keyword,proto3" json:"keyword,omitempty"`
	// The recommended new match type.
	RecommendedMatchType enums.KeywordMatchTypeEnum_KeywordMatchType `protobuf:"varint,2,opt,name=recommended_match_type,json=recommendedMatchType,proto3,enum=google.ads.googleads.v1.enums.KeywordMatchTypeEnum_KeywordMatchType" json:"recommended_match_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                    `json:"-"`
	XXX_unrecognized     []byte                                      `json:"-"`
	XXX_sizecache        int32                                       `json:"-"`
}

func (m *Recommendation_KeywordMatchTypeRecommendation) Reset() {
	*m = Recommendation_KeywordMatchTypeRecommendation{}
}
func (m *Recommendation_KeywordMatchTypeRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_KeywordMatchTypeRecommendation) ProtoMessage() {}
func (*Recommendation_KeywordMatchTypeRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 6}
}
func (m *Recommendation_KeywordMatchTypeRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_KeywordMatchTypeRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_KeywordMatchTypeRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_KeywordMatchTypeRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_KeywordMatchTypeRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_KeywordMatchTypeRecommendation.Merge(dst, src)
}
func (m *Recommendation_KeywordMatchTypeRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_KeywordMatchTypeRecommendation.Size(m)
}
func (m *Recommendation_KeywordMatchTypeRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_KeywordMatchTypeRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_KeywordMatchTypeRecommendation proto.InternalMessageInfo

func (m *Recommendation_KeywordMatchTypeRecommendation) GetKeyword() *common.KeywordInfo {
	if m != nil {
		return m.Keyword
	}
	return nil
}

func (m *Recommendation_KeywordMatchTypeRecommendation) GetRecommendedMatchType() enums.KeywordMatchTypeEnum_KeywordMatchType {
	if m != nil {
		return m.RecommendedMatchType
	}
	return enums.KeywordMatchTypeEnum_UNSPECIFIED
}

// The Maximize Conversions Opt-In recommendation.
type Recommendation_MaximizeConversionsOptInRecommendation struct {
	// The recommended new budget amount.
	RecommendedBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
	XXX_NoUnkeyedLiteral          struct{}             `json:"-"`
	XXX_unrecognized              []byte               `json:"-"`
	XXX_sizecache                 int32                `json:"-"`
}

func (m *Recommendation_MaximizeConversionsOptInRecommendation) Reset() {
	*m = Recommendation_MaximizeConversionsOptInRecommendation{}
}
func (m *Recommendation_MaximizeConversionsOptInRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_MaximizeConversionsOptInRecommendation) ProtoMessage() {}
func (*Recommendation_MaximizeConversionsOptInRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 7}
}
func (m *Recommendation_MaximizeConversionsOptInRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_MaximizeConversionsOptInRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_MaximizeConversionsOptInRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation.Merge(dst, src)
}
func (m *Recommendation_MaximizeConversionsOptInRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation.Size(m)
}
func (m *Recommendation_MaximizeConversionsOptInRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_MaximizeConversionsOptInRecommendation proto.InternalMessageInfo

func (m *Recommendation_MaximizeConversionsOptInRecommendation) GetRecommendedBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetAmountMicros
	}
	return nil
}

// The Enhanced Cost-Per-Click Opt-In recommendation.
type Recommendation_EnhancedCpcOptInRecommendation struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Recommendation_EnhancedCpcOptInRecommendation) Reset() {
	*m = Recommendation_EnhancedCpcOptInRecommendation{}
}
func (m *Recommendation_EnhancedCpcOptInRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_EnhancedCpcOptInRecommendation) ProtoMessage() {}
func (*Recommendation_EnhancedCpcOptInRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 8}
}
func (m *Recommendation_EnhancedCpcOptInRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_EnhancedCpcOptInRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_EnhancedCpcOptInRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation.Merge(dst, src)
}
func (m *Recommendation_EnhancedCpcOptInRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation.Size(m)
}
func (m *Recommendation_EnhancedCpcOptInRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_EnhancedCpcOptInRecommendation proto.InternalMessageInfo

// The Call extension recommendation.
type Recommendation_CallExtensionRecommendation struct {
	// Call extensions recommended to be added.
	RecommendedExtensions []*common.CallFeedItem `protobuf:"bytes,1,rep,name=recommended_extensions,json=recommendedExtensions,proto3" json:"recommended_extensions,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}               `json:"-"`
	XXX_unrecognized      []byte                 `json:"-"`
	XXX_sizecache         int32                  `json:"-"`
}

func (m *Recommendation_CallExtensionRecommendation) Reset() {
	*m = Recommendation_CallExtensionRecommendation{}
}
func (m *Recommendation_CallExtensionRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_CallExtensionRecommendation) ProtoMessage() {}
func (*Recommendation_CallExtensionRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 9}
}
func (m *Recommendation_CallExtensionRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_CallExtensionRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_CallExtensionRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_CallExtensionRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_CallExtensionRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_CallExtensionRecommendation.Merge(dst, src)
}
func (m *Recommendation_CallExtensionRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_CallExtensionRecommendation.Size(m)
}
func (m *Recommendation_CallExtensionRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_CallExtensionRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_CallExtensionRecommendation proto.InternalMessageInfo

func (m *Recommendation_CallExtensionRecommendation) GetRecommendedExtensions() []*common.CallFeedItem {
	if m != nil {
		return m.RecommendedExtensions
	}
	return nil
}

// The Search Partners Opt-In recommendation.
type Recommendation_SearchPartnersOptInRecommendation struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Recommendation_SearchPartnersOptInRecommendation) Reset() {
	*m = Recommendation_SearchPartnersOptInRecommendation{}
}
func (m *Recommendation_SearchPartnersOptInRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_SearchPartnersOptInRecommendation) ProtoMessage() {}
func (*Recommendation_SearchPartnersOptInRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 10}
}
func (m *Recommendation_SearchPartnersOptInRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_SearchPartnersOptInRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_SearchPartnersOptInRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation.Merge(dst, src)
}
func (m *Recommendation_SearchPartnersOptInRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation.Size(m)
}
func (m *Recommendation_SearchPartnersOptInRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_SearchPartnersOptInRecommendation proto.InternalMessageInfo

// The Maximize Clicks opt-in recommendation.
type Recommendation_MaximizeClicksOptInRecommendation struct {
	// The recommended new budget amount.
	// Only set if the current budget is too high.
	RecommendedBudgetAmountMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=recommended_budget_amount_micros,json=recommendedBudgetAmountMicros,proto3" json:"recommended_budget_amount_micros,omitempty"`
	XXX_NoUnkeyedLiteral          struct{}             `json:"-"`
	XXX_unrecognized              []byte               `json:"-"`
	XXX_sizecache                 int32                `json:"-"`
}

func (m *Recommendation_MaximizeClicksOptInRecommendation) Reset() {
	*m = Recommendation_MaximizeClicksOptInRecommendation{}
}
func (m *Recommendation_MaximizeClicksOptInRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_MaximizeClicksOptInRecommendation) ProtoMessage() {}
func (*Recommendation_MaximizeClicksOptInRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 11}
}
func (m *Recommendation_MaximizeClicksOptInRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_MaximizeClicksOptInRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_MaximizeClicksOptInRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation.Merge(dst, src)
}
func (m *Recommendation_MaximizeClicksOptInRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation.Size(m)
}
func (m *Recommendation_MaximizeClicksOptInRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_MaximizeClicksOptInRecommendation proto.InternalMessageInfo

func (m *Recommendation_MaximizeClicksOptInRecommendation) GetRecommendedBudgetAmountMicros() *wrappers.Int64Value {
	if m != nil {
		return m.RecommendedBudgetAmountMicros
	}
	return nil
}

// The Optimize Ad Rotation recommendation.
type Recommendation_OptimizeAdRotationRecommendation struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Recommendation_OptimizeAdRotationRecommendation) Reset() {
	*m = Recommendation_OptimizeAdRotationRecommendation{}
}
func (m *Recommendation_OptimizeAdRotationRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_OptimizeAdRotationRecommendation) ProtoMessage() {}
func (*Recommendation_OptimizeAdRotationRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 12}
}
func (m *Recommendation_OptimizeAdRotationRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_OptimizeAdRotationRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_OptimizeAdRotationRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation.Merge(dst, src)
}
func (m *Recommendation_OptimizeAdRotationRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation.Size(m)
}
func (m *Recommendation_OptimizeAdRotationRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_OptimizeAdRotationRecommendation proto.InternalMessageInfo

// The move unused budget recommendation.
type Recommendation_MoveUnusedBudgetRecommendation struct {
	// The excess budget's resource_name.
	ExcessCampaignBudget *wrappers.StringValue `protobuf:"bytes,1,opt,name=excess_campaign_budget,json=excessCampaignBudget,proto3" json:"excess_campaign_budget,omitempty"`
	// The recommendation for the constrained budget to increase.
	BudgetRecommendation *Recommendation_CampaignBudgetRecommendation `protobuf:"bytes,2,opt,name=budget_recommendation,json=budgetRecommendation,proto3" json:"budget_recommendation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                     `json:"-"`
	XXX_unrecognized     []byte                                       `json:"-"`
	XXX_sizecache        int32                                        `json:"-"`
}

func (m *Recommendation_MoveUnusedBudgetRecommendation) Reset() {
	*m = Recommendation_MoveUnusedBudgetRecommendation{}
}
func (m *Recommendation_MoveUnusedBudgetRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_MoveUnusedBudgetRecommendation) ProtoMessage() {}
func (*Recommendation_MoveUnusedBudgetRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 13}
}
func (m *Recommendation_MoveUnusedBudgetRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_MoveUnusedBudgetRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_MoveUnusedBudgetRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_MoveUnusedBudgetRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_MoveUnusedBudgetRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_MoveUnusedBudgetRecommendation.Merge(dst, src)
}
func (m *Recommendation_MoveUnusedBudgetRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_MoveUnusedBudgetRecommendation.Size(m)
}
func (m *Recommendation_MoveUnusedBudgetRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_MoveUnusedBudgetRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_MoveUnusedBudgetRecommendation proto.InternalMessageInfo

func (m *Recommendation_MoveUnusedBudgetRecommendation) GetExcessCampaignBudget() *wrappers.StringValue {
	if m != nil {
		return m.ExcessCampaignBudget
	}
	return nil
}

func (m *Recommendation_MoveUnusedBudgetRecommendation) GetBudgetRecommendation() *Recommendation_CampaignBudgetRecommendation {
	if m != nil {
		return m.BudgetRecommendation
	}
	return nil
}

// The Callout extension recommendation.
type Recommendation_CalloutExtensionRecommendation struct {
	// Callout extensions recommended to be added.
	RecommendedExtensions []*common.CalloutFeedItem `protobuf:"bytes,1,rep,name=recommended_extensions,json=recommendedExtensions,proto3" json:"recommended_extensions,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}                  `json:"-"`
	XXX_unrecognized      []byte                    `json:"-"`
	XXX_sizecache         int32                     `json:"-"`
}

func (m *Recommendation_CalloutExtensionRecommendation) Reset() {
	*m = Recommendation_CalloutExtensionRecommendation{}
}
func (m *Recommendation_CalloutExtensionRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_CalloutExtensionRecommendation) ProtoMessage() {}
func (*Recommendation_CalloutExtensionRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 14}
}
func (m *Recommendation_CalloutExtensionRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_CalloutExtensionRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_CalloutExtensionRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_CalloutExtensionRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_CalloutExtensionRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_CalloutExtensionRecommendation.Merge(dst, src)
}
func (m *Recommendation_CalloutExtensionRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_CalloutExtensionRecommendation.Size(m)
}
func (m *Recommendation_CalloutExtensionRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_CalloutExtensionRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_CalloutExtensionRecommendation proto.InternalMessageInfo

func (m *Recommendation_CalloutExtensionRecommendation) GetRecommendedExtensions() []*common.CalloutFeedItem {
	if m != nil {
		return m.RecommendedExtensions
	}
	return nil
}

// The Sitelink extension recommendation.
type Recommendation_SitelinkExtensionRecommendation struct {
	// Sitelink extensions recommended to be added.
	RecommendedExtensions []*common.SitelinkFeedItem `protobuf:"bytes,1,rep,name=recommended_extensions,json=recommendedExtensions,proto3" json:"recommended_extensions,omitempty"`
	XXX_NoUnkeyedLiteral  struct{}                   `json:"-"`
	XXX_unrecognized      []byte                     `json:"-"`
	XXX_sizecache         int32                      `json:"-"`
}

func (m *Recommendation_SitelinkExtensionRecommendation) Reset() {
	*m = Recommendation_SitelinkExtensionRecommendation{}
}
func (m *Recommendation_SitelinkExtensionRecommendation) String() string {
	return proto.CompactTextString(m)
}
func (*Recommendation_SitelinkExtensionRecommendation) ProtoMessage() {}
func (*Recommendation_SitelinkExtensionRecommendation) Descriptor() ([]byte, []int) {
	return fileDescriptor_recommendation_f16744120f29f1ae, []int{0, 15}
}
func (m *Recommendation_SitelinkExtensionRecommendation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Recommendation_SitelinkExtensionRecommendation.Unmarshal(m, b)
}
func (m *Recommendation_SitelinkExtensionRecommendation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Recommendation_SitelinkExtensionRecommendation.Marshal(b, m, deterministic)
}
func (dst *Recommendation_SitelinkExtensionRecommendation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Recommendation_SitelinkExtensionRecommendation.Merge(dst, src)
}
func (m *Recommendation_SitelinkExtensionRecommendation) XXX_Size() int {
	return xxx_messageInfo_Recommendation_SitelinkExtensionRecommendation.Size(m)
}
func (m *Recommendation_SitelinkExtensionRecommendation) XXX_DiscardUnknown() {
	xxx_messageInfo_Recommendation_SitelinkExtensionRecommendation.DiscardUnknown(m)
}

var xxx_messageInfo_Recommendation_SitelinkExtensionRecommendation proto.InternalMessageInfo

func (m *Recommendation_SitelinkExtensionRecommendation) GetRecommendedExtensions() []*common.SitelinkFeedItem {
	if m != nil {
		return m.RecommendedExtensions
	}
	return nil
}

func init() {
	proto.RegisterType((*Recommendation)(nil), "google.ads.googleads.v1.resources.Recommendation")
	proto.RegisterType((*Recommendation_RecommendationImpact)(nil), "google.ads.googleads.v1.resources.Recommendation.RecommendationImpact")
	proto.RegisterType((*Recommendation_RecommendationMetrics)(nil), "google.ads.googleads.v1.resources.Recommendation.RecommendationMetrics")
	proto.RegisterType((*Recommendation_CampaignBudgetRecommendation)(nil), "google.ads.googleads.v1.resources.Recommendation.CampaignBudgetRecommendation")
	proto.RegisterType((*Recommendation_CampaignBudgetRecommendation_CampaignBudgetRecommendationOption)(nil), "google.ads.googleads.v1.resources.Recommendation.CampaignBudgetRecommendation.CampaignBudgetRecommendationOption")
	proto.RegisterType((*Recommendation_KeywordRecommendation)(nil), "google.ads.googleads.v1.resources.Recommendation.KeywordRecommendation")
	proto.RegisterType((*Recommendation_TextAdRecommendation)(nil), "google.ads.googleads.v1.resources.Recommendation.TextAdRecommendation")
	proto.RegisterType((*Recommendation_TargetCpaOptInRecommendation)(nil), "google.ads.googleads.v1.resources.Recommendation.TargetCpaOptInRecommendation")
	proto.RegisterType((*Recommendation_TargetCpaOptInRecommendation_TargetCpaOptInRecommendationOption)(nil), "google.ads.googleads.v1.resources.Recommendation.TargetCpaOptInRecommendation.TargetCpaOptInRecommendationOption")
	proto.RegisterType((*Recommendation_KeywordMatchTypeRecommendation)(nil), "google.ads.googleads.v1.resources.Recommendation.KeywordMatchTypeRecommendation")
	proto.RegisterType((*Recommendation_MaximizeConversionsOptInRecommendation)(nil), "google.ads.googleads.v1.resources.Recommendation.MaximizeConversionsOptInRecommendation")
	proto.RegisterType((*Recommendation_EnhancedCpcOptInRecommendation)(nil), "google.ads.googleads.v1.resources.Recommendation.EnhancedCpcOptInRecommendation")
	proto.RegisterType((*Recommendation_CallExtensionRecommendation)(nil), "google.ads.googleads.v1.resources.Recommendation.CallExtensionRecommendation")
	proto.RegisterType((*Recommendation_SearchPartnersOptInRecommendation)(nil), "google.ads.googleads.v1.resources.Recommendation.SearchPartnersOptInRecommendation")
	proto.RegisterType((*Recommendation_MaximizeClicksOptInRecommendation)(nil), "google.ads.googleads.v1.resources.Recommendation.MaximizeClicksOptInRecommendation")
	proto.RegisterType((*Recommendation_OptimizeAdRotationRecommendation)(nil), "google.ads.googleads.v1.resources.Recommendation.OptimizeAdRotationRecommendation")
	proto.RegisterType((*Recommendation_MoveUnusedBudgetRecommendation)(nil), "google.ads.googleads.v1.resources.Recommendation.MoveUnusedBudgetRecommendation")
	proto.RegisterType((*Recommendation_CalloutExtensionRecommendation)(nil), "google.ads.googleads.v1.resources.Recommendation.CalloutExtensionRecommendation")
	proto.RegisterType((*Recommendation_SitelinkExtensionRecommendation)(nil), "google.ads.googleads.v1.resources.Recommendation.SitelinkExtensionRecommendation")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/resources/recommendation.proto", fileDescriptor_recommendation_f16744120f29f1ae)
}

var fileDescriptor_recommendation_f16744120f29f1ae = []byte{
	// 1671 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xbc, 0x59, 0x4b, 0x6f, 0xdc, 0x46,
	0x12, 0xde, 0x1e, 0xc9, 0x92, 0x5d, 0x7a, 0xd9, 0x6d, 0x49, 0x3b, 0x4b, 0xcb, 0xe3, 0x91, 0x0c,
	0x19, 0x82, 0x77, 0x77, 0x66, 0xa5, 0xf5, 0xda, 0xc6, 0xec, 0x03, 0x18, 0x3d, 0x2c, 0x6b, 0x17,
	0xb2, 0xb5, 0xb4, 0x23, 0x18, 0x81, 0x60, 0xa2, 0x45, 0xb6, 0xc7, 0x8c, 0x86, 0x6c, 0x9a, 0x6c,
	0xca, 0x92, 0x0f, 0x81, 0x91, 0x5c, 0xf2, 0x00, 0x72, 0x09, 0x10, 0xf8, 0x90, 0xc4, 0x40, 0x72,
	0x08, 0x90, 0x1f, 0x10, 0xf8, 0x1f, 0x04, 0xf0, 0xd5, 0x40, 0xfe, 0x40, 0x6e, 0xf9, 0x05, 0x41,
	0x4e, 0x01, 0x9b, 0x4d, 0x8a, 0xf3, 0x20, 0x39, 0x9a, 0xd8, 0xb9, 0x0d, 0xd9, 0xf5, 0x7d, 0xf5,
	0x75, 0x75, 0x75, 0x77, 0x15, 0x07, 0xae, 0x36, 0x18, 0x6b, 0x34, 0x69, 0x95, 0x18, 0x5e, 0x35,
	0xfc, 0x19, 0xfc, 0xda, 0x5f, 0xac, 0xba, 0xd4, 0x63, 0xbe, 0xab, 0x53, 0xaf, 0xea, 0x52, 0x9d,
	0x59, 0x16, 0xb5, 0x0d, 0xc2, 0x4d, 0x66, 0x57, 0x1c, 0x97, 0x71, 0x86, 0x67, 0x43, 0xe3, 0x0a,
	0x31, 0xbc, 0x4a, 0x8c, 0xab, 0xec, 0x2f, 0x56, 0x62, 0x9c, 0xf2, 0xd7, 0x34, 0xea, 0x80, 0x8e,
	0xd9, 0x55, 0xdd, 0x35, 0x39, 0x75, 0x4d, 0x12, 0x32, 0x2a, 0xd5, 0x1c, 0x73, 0x7a, 0xc0, 0xa9,
	0xed, 0x99, 0xcc, 0xf6, 0x24, 0x20, 0x55, 0x3a, 0xb5, 0x7d, 0xcb, 0xab, 0xee, 0xd1, 0xc3, 0xc7,
	0xcc, 0x35, 0x34, 0x8b, 0x70, 0xfd, 0xa1, 0xc6, 0x0f, 0x1d, 0x2a, 0x71, 0xd7, 0xb2, 0x71, 0xad,
	0xd3, 0x4d, 0x02, 0x37, 0xb2, 0x81, 0x9c, 0xb8, 0x0d, 0xca, 0x35, 0xdd, 0x21, 0x1a, 0x73, 0xb8,
	0x66, 0xda, 0x5a, 0x1b, 0x55, 0x83, 0x91, 0xa6, 0xa4, 0xba, 0x9c, 0x1f, 0x76, 0x62, 0x48, 0xdb,
	0x92, 0xb4, 0x15, 0x4f, 0xbb, 0xfe, 0x83, 0xea, 0x63, 0x97, 0x38, 0x0e, 0x75, 0xa3, 0x38, 0xcc,
	0x44, 0x5c, 0x8e, 0x59, 0x25, 0xb6, 0xcd, 0xb8, 0xf0, 0x26, 0x47, 0xe7, 0x9e, 0x2f, 0xc2, 0xb8,
	0xda, 0xa2, 0x03, 0x5f, 0x84, 0xb1, 0xc8, 0x8d, 0x66, 0x13, 0x8b, 0x16, 0x51, 0x19, 0x2d, 0x9c,
	0x52, 0x47, 0xa3, 0x97, 0xb7, 0x88, 0x45, 0xf1, 0x0e, 0x0c, 0x06, 0x53, 0x2f, 0x16, 0xca, 0x68,
	0x61, 0x7c, 0xe9, 0x66, 0x25, 0x6d, 0xbd, 0xc5, 0xdc, 0x2b, 0xad, 0x1e, 0xee, 0x1e, 0x3a, 0x74,
	0xcd, 0xf6, 0xad, 0x2e, 0xaf, 0x55, 0xc1, 0x8a, 0xef, 0xc3, 0x90, 0x69, 0x39, 0x44, 0xe7, 0xc5,
	0x81, 0x32, 0x5a, 0x18, 0x59, 0xba, 0x51, 0xc9, 0xcd, 0xa7, 0x36, 0xb2, 0xb6, 0xc7, 0x0d, 0xc1,
	0xa6, 0x4a, 0x56, 0xbc, 0x06, 0x13, 0x3a, 0xb1, 0x1c, 0x62, 0x36, 0x6c, 0x6d, 0xd7, 0x37, 0x1a,
	0x94, 0x17, 0x4f, 0x08, 0x47, 0x33, 0x91, 0xa3, 0x28, 0x9a, 0x95, 0x3b, 0xdc, 0x35, 0xed, 0xc6,
	0x36, 0x69, 0xfa, 0x54, 0x1d, 0x8f, 0x40, 0xcb, 0x02, 0x83, 0xaf, 0xc3, 0xc9, 0xe8, 0x4d, 0x71,
	0xa8, 0x07, 0x7c, 0x6c, 0x8d, 0xaf, 0xc1, 0x49, 0x62, 0x68, 0x0d, 0x97, 0xf9, 0x4e, 0x71, 0xb8,
	0x07, 0xe4, 0x30, 0x31, 0xd6, 0x03, 0x63, 0x7c, 0x1d, 0x4e, 0x19, 0xa6, 0x67, 0x99, 0x9e, 0x47,
	0x8d, 0xe2, 0x98, 0x40, 0x2a, 0x1d, 0xc8, 0x65, 0xc6, 0x9a, 0x21, 0xee, 0xc8, 0x18, 0x7f, 0x86,
	0xa0, 0xd4, 0x36, 0xe9, 0xb6, 0x0c, 0x2c, 0x0e, 0x0a, 0xbe, 0x5b, 0xc7, 0x0f, 0xf6, 0x4a, 0x4b,
	0x5c, 0x5a, 0x07, 0x6f, 0xfe, 0x41, 0x9d, 0xd1, 0x33, 0xc6, 0xf1, 0x53, 0x04, 0xd3, 0xd1, 0x6e,
	0x6c, 0x13, 0x74, 0x52, 0x08, 0x5a, 0x3f, 0xbe, 0xa0, 0xff, 0x85, 0x7c, 0x1d, 0x4a, 0xa6, 0xf6,
	0xba, 0x0d, 0xe0, 0x77, 0x61, 0x9a, 0xd3, 0x03, 0xae, 0x91, 0x0e, 0x05, 0xa7, 0xfa, 0xcd, 0xbf,
	0xbb, 0xf4, 0x80, 0xd7, 0x3b, 0x05, 0x4c, 0xf2, 0x2e, 0xef, 0xf1, 0x33, 0x04, 0xe5, 0xbc, 0xf3,
	0xa1, 0x08, 0xfd, 0xae, 0xce, 0x5d, 0xc1, 0xbc, 0xe2, 0x90, 0xdb, 0x0e, 0xdf, 0xb0, 0x3b, 0x57,
	0x87, 0x67, 0x8c, 0xe3, 0xef, 0x10, 0x5c, 0xb6, 0xc8, 0x81, 0x69, 0x99, 0x4f, 0xa8, 0xa6, 0x33,
	0x7b, 0x9f, 0xba, 0xe2, 0x94, 0x4d, 0x11, 0x39, 0x22, 0x44, 0xde, 0x3b, 0xbe, 0xc8, 0x4d, 0xe9,
	0x63, 0xe5, 0xc8, 0x45, 0x77, 0xb9, 0x97, 0xac, 0x9e, 0x2c, 0xf1, 0x97, 0x08, 0xe6, 0xa8, 0xfd,
	0x90, 0xd8, 0x3a, 0x35, 0x34, 0xdd, 0xd1, 0x53, 0x04, 0x8f, 0x0a, 0xc1, 0x5b, 0xc7, 0x17, 0xbc,
	0x26, 0xb9, 0x57, 0x1c, 0xbd, 0xbb, 0xd0, 0x12, 0xcd, 0xb4, 0xc0, 0xdf, 0x20, 0x98, 0xf7, 0x28,
	0x71, 0xf5, 0x87, 0x9a, 0x43, 0x5c, 0x6e, 0x53, 0x37, 0x2d, 0xa8, 0xe3, 0x42, 0xe3, 0x9d, 0xe3,
	0x6b, 0xbc, 0x23, 0xe8, 0xb7, 0x24, 0x7b, 0x77, 0x99, 0xb3, 0x5e, 0x9e, 0x91, 0x50, 0x7a, 0x94,
	0x03, 0x4d, 0x53, 0xdf, 0x4b, 0x53, 0x3a, 0xd1, 0xaf, 0xd2, 0x78, 0xf9, 0x05, 0x7b, 0x8a, 0x52,
	0x2b, 0xcf, 0x08, 0x7f, 0x8d, 0xe0, 0x22, 0x73, 0x78, 0xa8, 0x34, 0xd8, 0xcd, 0xf2, 0xba, 0x6b,
	0xd7, 0x79, 0x5a, 0xe8, 0x54, 0x8f, 0xaf, 0xf3, 0xb6, 0x24, 0xaf, 0x1b, 0xaa, 0xa4, 0xee, 0x90,
	0x59, 0x66, 0x39, 0x36, 0xf8, 0x73, 0x04, 0x65, 0x9d, 0x34, 0x9b, 0xcc, 0xe7, 0x5a, 0x5c, 0xb7,
	0xb4, 0x4b, 0x3c, 0xd3, 0x6f, 0x62, 0xae, 0x84, 0xcc, 0x6b, 0x11, 0x71, 0x67, 0x62, 0xea, 0x99,
	0x16, 0xf8, 0x39, 0x82, 0x59, 0xcf, 0xe4, 0xb4, 0x69, 0xda, 0x7b, 0xe9, 0xfa, 0xb0, 0xd0, 0xf7,
	0xff, 0x3e, 0x92, 0x52, 0x52, 0xa7, 0x0b, 0xbc, 0xe0, 0x65, 0x9b, 0xe0, 0x4f, 0x11, 0x9c, 0x0f,
	0x26, 0x91, 0xae, 0xee, 0xac, 0x50, 0xb7, 0xd9, 0x5f, 0xf4, 0xd2, 0x95, 0x9d, 0xd3, 0xd3, 0x87,
	0xf1, 0x17, 0x08, 0x66, 0x3b, 0xcb, 0xca, 0x76, 0x65, 0x93, 0xfd, 0xae, 0xab, 0xbc, 0xd3, 0x36,
	0x03, 0x66, 0x51, 0x2b, 0x75, 0xac, 0xeb, 0x5e, 0xa6, 0x85, 0xd0, 0x67, 0xb1, 0x7d, 0xaa, 0xf9,
	0xb6, 0xef, 0x51, 0x23, 0xa5, 0x08, 0x98, 0xea, 0x57, 0xdf, 0x26, 0xdb, 0xa7, 0x6f, 0x09, 0xe6,
	0x94, 0x32, 0xa0, 0x64, 0x65, 0x5a, 0x28, 0x3f, 0x23, 0x98, 0xec, 0x56, 0xb6, 0xe1, 0x77, 0x60,
	0x74, 0x97, 0x78, 0x54, 0xb3, 0x28, 0x77, 0x4d, 0xdd, 0x13, 0x05, 0x69, 0x5f, 0x65, 0x41, 0xeb,
	0xe3, 0x66, 0x48, 0xa7, 0x8e, 0x04, 0xe4, 0xf2, 0x01, 0x73, 0x38, 0xe3, 0x30, 0x4e, 0x6d, 0x6e,
	0x92, 0x66, 0xec, 0xb0, 0xf0, 0x7a, 0x1d, 0x9e, 0x8e, 0x3d, 0xc8, 0x37, 0xca, 0xcb, 0x02, 0x4c,
	0x75, 0xb5, 0xc5, 0xff, 0x81, 0x11, 0xd3, 0x72, 0x5c, 0xea, 0x89, 0x8b, 0x4e, 0x4e, 0xbd, 0xb3,
	0x58, 0x5c, 0x65, 0xfe, 0x6e, 0x93, 0x86, 0x45, 0x5f, 0x12, 0x80, 0xaf, 0xc0, 0x50, 0x78, 0x62,
	0xcb, 0x49, 0x64, 0x43, 0xa5, 0x2d, 0xfe, 0x17, 0x8c, 0xe8, 0xcc, 0xe3, 0x9a, 0x65, 0xea, 0x2e,
	0xf3, 0x64, 0x15, 0x7e, 0xae, 0x03, 0xba, 0x61, 0xf3, 0xab, 0x57, 0x42, 0x24, 0x04, 0xf6, 0x9b,
	0xc2, 0x3c, 0xd0, 0x9c, 0xa8, 0x14, 0x64, 0x59, 0x99, 0xa3, 0x39, 0x01, 0xc0, 0xff, 0x86, 0x91,
	0x7d, 0xd3, 0xa0, 0x4c, 0xdb, 0x37, 0xe9, 0x63, 0x2f, 0xb5, 0x34, 0x4f, 0xe2, 0x41, 0x00, 0xb6,
	0x03, 0x7b, 0xe5, 0xd5, 0x20, 0xcc, 0x64, 0x55, 0xa4, 0x78, 0x07, 0x66, 0x74, 0xdf, 0x75, 0xa9,
	0xcd, 0xa3, 0x3d, 0x40, 0x2c, 0xe6, 0xdb, 0xf1, 0x74, 0x51, 0xfe, 0x74, 0xff, 0x24, 0x09, 0x42,
	0xfe, 0xba, 0x80, 0xcb, 0xd9, 0x1b, 0x50, 0x8e, 0xb7, 0xd4, 0xd1, 0x2e, 0x6b, 0xf5, 0x50, 0xc8,
	0xf7, 0x70, 0x3e, 0x41, 0xd2, 0xc5, 0xcb, 0x33, 0x04, 0xe3, 0x92, 0x3a, 0xb8, 0x6f, 0x82, 0x38,
	0x0f, 0x94, 0x07, 0x16, 0x46, 0x96, 0x1e, 0xbd, 0xde, 0xf2, 0x3d, 0x73, 0xf0, 0xb6, 0xf0, 0xac,
	0x8e, 0x85, 0x42, 0xc2, 0x27, 0x4f, 0x79, 0x85, 0x60, 0x2e, 0x1f, 0x85, 0x37, 0x61, 0xb2, 0xdf,
	0xe8, 0xe3, 0xdd, 0xce, 0x80, 0x1c, 0xf5, 0x8c, 0x85, 0x37, 0xd1, 0x33, 0x2a, 0x2f, 0x10, 0x4c,
	0x75, 0x6d, 0x2b, 0xf0, 0x1a, 0x0c, 0xcb, 0x93, 0x57, 0x6a, 0xff, 0x73, 0xaa, 0xeb, 0xf0, 0x63,
	0x45, 0x74, 0x94, 0x6f, 0xd8, 0x0f, 0x98, 0x1a, 0x61, 0xf1, 0x3d, 0x50, 0x92, 0x79, 0x13, 0x94,
	0xac, 0xbb, 0xa6, 0x71, 0x8c, 0x8c, 0xf9, 0x63, 0x02, 0xbe, 0xe2, 0xe8, 0xcb, 0xa6, 0x11, 0x86,
	0x46, 0xf9, 0x01, 0xc1, 0x64, 0xb7, 0x7e, 0x04, 0xff, 0x03, 0x0a, 0x24, 0x12, 0x3d, 0xdf, 0x43,
	0xbc, 0xea, 0x86, 0x5a, 0x20, 0x06, 0xae, 0xc3, 0x98, 0xee, 0xd2, 0xb0, 0xb0, 0x32, 0x08, 0xa7,
	0xa9, 0x47, 0x4b, 0xb2, 0x85, 0x1d, 0x8d, 0x20, 0xab, 0x84, 0x53, 0xbc, 0x0a, 0x13, 0xc4, 0xe7,
	0x4c, 0x23, 0x8e, 0xd3, 0x3c, 0x0c, 0x49, 0x06, 0x7a, 0x20, 0x19, 0x0b, 0x40, 0xf5, 0x00, 0x13,
	0xb0, 0x28, 0xdf, 0x9f, 0x80, 0x99, 0xac, 0xee, 0x06, 0x7f, 0x8c, 0x60, 0x38, 0xda, 0x1e, 0xa8,
	0xdf, 0xed, 0x91, 0xe5, 0x21, 0x73, 0x50, 0x6e, 0x8f, 0x48, 0x01, 0xbe, 0x0f, 0xc9, 0x4d, 0xad,
	0x25, 0x3a, 0xbe, 0xde, 0x17, 0x39, 0x99, 0x23, 0xb1, 0x6f, 0xb9, 0xce, 0x2f, 0x06, 0x60, 0x2e,
	0x5f, 0x0f, 0x3e, 0x80, 0xc1, 0x06, 0x23, 0x4d, 0xb1, 0xee, 0xe3, 0x4b, 0x46, 0xce, 0xb7, 0x9b,
	0x2c, 0xc2, 0x75, 0x46, 0x9a, 0xe2, 0x4b, 0x4e, 0x9e, 0x91, 0x2a, 0x3c, 0xe2, 0x75, 0x38, 0xd3,
	0xd7, 0xa4, 0x27, 0x78, 0xeb, 0x4c, 0x31, 0x83, 0x4b, 0x2e, 0x7d, 0xe4, 0x9b, 0x6e, 0xb0, 0x51,
	0xda, 0x3e, 0x6a, 0xb4, 0x9e, 0x26, 0x3d, 0x5c, 0x5d, 0x73, 0x11, 0x55, 0xeb, 0xa1, 0x95, 0x72,
	0xba, 0x0c, 0xbe, 0x91, 0xd3, 0xe5, 0x47, 0x04, 0xa5, 0xec, 0x02, 0xef, 0x75, 0x1d, 0x33, 0x4f,
	0x60, 0x3a, 0x99, 0x84, 0x47, 0x85, 0xaa, 0xfc, 0x96, 0xb7, 0x9a, 0x93, 0x0f, 0xed, 0x2a, 0xc5,
	0xfa, 0x77, 0x48, 0x9f, 0x4c, 0xf8, 0x88, 0xdf, 0x2a, 0x9f, 0x20, 0xb8, 0xd4, 0x5b, 0xa3, 0xdf,
	0xd3, 0x2d, 0x8a, 0x7e, 0xeb, 0x2d, 0xaa, 0x94, 0xa1, 0x94, 0xdd, 0xc7, 0x2b, 0xef, 0x21, 0x38,
	0x97, 0xd1, 0x13, 0x60, 0xbd, 0x35, 0x9c, 0x47, 0x9f, 0xa1, 0xe5, 0x79, 0xf3, 0x97, 0xbc, 0x45,
	0x0a, 0xc8, 0x6f, 0x50, 0x6a, 0x6c, 0x70, 0x6a, 0xa9, 0x53, 0x09, 0xae, 0xd8, 0xa3, 0xa7, 0x5c,
	0x84, 0xd9, 0xdc, 0x56, 0x5e, 0xf9, 0x10, 0xc1, 0x6c, 0x6e, 0x1b, 0xfd, 0x3b, 0xc5, 0x75, 0x0e,
	0xca, 0x79, 0x9d, 0xb2, 0xf2, 0x0b, 0x82, 0x52, 0x76, 0xcf, 0x80, 0x55, 0x98, 0xa6, 0x07, 0x3a,
	0xf5, 0xbc, 0xf6, 0x4d, 0x9e, 0x5a, 0x07, 0x27, 0x2f, 0x8b, 0xc9, 0x10, 0xdb, 0xba, 0xab, 0xf1,
	0xfb, 0x08, 0xa6, 0xba, 0x77, 0x3e, 0x85, 0x37, 0xf1, 0xf9, 0x53, 0x95, 0x45, 0x4e, 0xdb, 0xe4,
	0x3f, 0x40, 0x50, 0xca, 0x6e, 0xd4, 0xf1, 0x83, 0x9c, 0xcc, 0xaa, 0xf6, 0x92, 0x59, 0xcc, 0xe7,
	0x79, 0xc9, 0xf5, 0x11, 0x82, 0x0b, 0x39, 0x3d, 0x39, 0x6e, 0xe4, 0x68, 0xf9, 0x5b, 0x9e, 0x96,
	0xc8, 0x41, 0x8e, 0x98, 0xe5, 0xd3, 0x30, 0xde, 0xba, 0x2a, 0xcb, 0x4f, 0x0b, 0x30, 0xaf, 0x33,
	0x2b, 0x7f, 0x55, 0x96, 0xcf, 0xb6, 0x8a, 0xde, 0x0a, 0x72, 0x62, 0x0b, 0xbd, 0xfd, 0x5f, 0x89,
	0x6c, 0xb0, 0x26, 0xb1, 0x1b, 0x15, 0xe6, 0x36, 0xaa, 0x0d, 0x6a, 0x8b, 0x8c, 0x89, 0xfe, 0x5c,
	0x71, 0x4c, 0x2f, 0xe3, 0xbf, 0x96, 0x7f, 0xc6, 0xbf, 0xbe, 0x2a, 0x0c, 0xac, 0xd7, 0xeb, 0xdf,
	0x16, 0x66, 0xd7, 0x43, 0xca, 0xba, 0xe1, 0x55, 0xc2, 0x9f, 0xc1, 0xaf, 0xed, 0xc5, 0x8a, 0x1a,
	0x59, 0xbe, 0x8c, 0x6c, 0x76, 0xea, 0x86, 0xb7, 0x13, 0xdb, 0xec, 0x6c, 0x2f, 0xee, 0xc4, 0x36,
	0x3f, 0x15, 0xe6, 0xc3, 0x81, 0x5a, 0xad, 0x6e, 0x78, 0xb5, 0x5a, 0x6c, 0x55, 0xab, 0x6d, 0x2f,
	0xd6, 0x6a, 0xb1, 0xdd, 0xee, 0x90, 0x10, 0xfb, 0xf7, 0x5f, 0x03, 0x00, 0x00, 0xff, 0xff, 0x7b,
	0x2f, 0x09, 0x52, 0x8e, 0x1b, 0x00, 0x00,
}
