// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package opsworkscm

import (
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateNode = "AssociateNode"

// AssociateNodeRequest generates a "aws/request.Request" representing the
// client's request for the AssociateNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateNode for more information on using the AssociateNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateNodeRequest method.
//    req, resp := client.AssociateNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/AssociateNode
func (c *OpsWorksCM) AssociateNodeRequest(input *AssociateNodeInput) (req *request.Request, output *AssociateNodeOutput) {
	op := &request.Operation{
		Name:       opAssociateNode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateNodeInput{}
	}

	output = &AssociateNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateNode API operation for AWS OpsWorks CM.
//
// Associates a new node with the server. For more information about how to
// disassociate a node, see DisassociateNode.
//
// On a Chef server: This command is an alternative to knife bootstrap.
//
// Example (Chef): aws opsworks-cm associate-node --server-name MyServer --node-name
// MyManagedNode --engine-attributes "Name=CHEF_ORGANIZATION,Value=default"
// "Name=CHEF_NODE_PUBLIC_KEY,Value=public-key-pem"
//
// On a Puppet server, this command is an alternative to the puppet cert sign
// command that signs a Puppet node CSR.
//
// Example (Chef): aws opsworks-cm associate-node --server-name MyServer --node-name
// MyManagedNode --engine-attributes "Name=PUPPET_NODE_CSR,Value=csr-pem"
//
// A node can can only be associated with servers that are in a HEALTHY state.
// Otherwise, an InvalidStateException is thrown. A ResourceNotFoundException
// is thrown when the server does not exist. A ValidationException is raised
// when parameters of the request are not valid. The AssociateNode API call
// can be integrated into Auto Scaling configurations, AWS Cloudformation templates,
// or the user data of a server's instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation AssociateNode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidStateException "InvalidStateException"
//   The resource is in a state that does not allow you to perform a specified
//   action.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist, or access was denied.
//
//   * ErrCodeValidationException "ValidationException"
//   One or more of the provided request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/AssociateNode
func (c *OpsWorksCM) AssociateNode(input *AssociateNodeInput) (*AssociateNodeOutput, error) {
	req, out := c.AssociateNodeRequest(input)
	return out, req.Send()
}

// AssociateNodeWithContext is the same as AssociateNode with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) AssociateNodeWithContext(ctx aws.Context, input *AssociateNodeInput, opts ...request.Option) (*AssociateNodeOutput, error) {
	req, out := c.AssociateNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBackup = "CreateBackup"

// CreateBackupRequest generates a "aws/request.Request" representing the
// client's request for the CreateBackup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateBackup for more information on using the CreateBackup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateBackupRequest method.
//    req, resp := client.CreateBackupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/CreateBackup
func (c *OpsWorksCM) CreateBackupRequest(input *CreateBackupInput) (req *request.Request, output *CreateBackupOutput) {
	op := &request.Operation{
		Name:       opCreateBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBackupInput{}
	}

	output = &CreateBackupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateBackup API operation for AWS OpsWorks CM.
//
// Creates an application-level backup of a server. While the server is in the
// BACKING_UP state, the server cannot be changed, and no additional backup
// can be created.
//
// Backups can be created for servers in RUNNING, HEALTHY, and UNHEALTHY states.
// By default, you can create a maximum of 50 manual backups.
//
// This operation is asynchronous.
//
// A LimitExceededException is thrown when the maximum number of manual backups
// is reached. An InvalidStateException is thrown when the server is not in
// any of the following states: RUNNING, HEALTHY, or UNHEALTHY. A ResourceNotFoundException
// is thrown when the server is not found. A ValidationException is thrown when
// parameters of the request are not valid.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation CreateBackup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidStateException "InvalidStateException"
//   The resource is in a state that does not allow you to perform a specified
//   action.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The limit of servers or backups has been reached.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist, or access was denied.
//
//   * ErrCodeValidationException "ValidationException"
//   One or more of the provided request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/CreateBackup
func (c *OpsWorksCM) CreateBackup(input *CreateBackupInput) (*CreateBackupOutput, error) {
	req, out := c.CreateBackupRequest(input)
	return out, req.Send()
}

// CreateBackupWithContext is the same as CreateBackup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBackup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) CreateBackupWithContext(ctx aws.Context, input *CreateBackupInput, opts ...request.Option) (*CreateBackupOutput, error) {
	req, out := c.CreateBackupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateServer = "CreateServer"

// CreateServerRequest generates a "aws/request.Request" representing the
// client's request for the CreateServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateServer for more information on using the CreateServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateServerRequest method.
//    req, resp := client.CreateServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/CreateServer
func (c *OpsWorksCM) CreateServerRequest(input *CreateServerInput) (req *request.Request, output *CreateServerOutput) {
	op := &request.Operation{
		Name:       opCreateServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServerInput{}
	}

	output = &CreateServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateServer API operation for AWS OpsWorks CM.
//
// Creates and immedately starts a new server. The server is ready to use when
// it is in the HEALTHY state. By default, you can create a maximum of 10 servers.
//
// This operation is asynchronous.
//
// A LimitExceededException is thrown when you have created the maximum number
// of servers (10). A ResourceAlreadyExistsException is thrown when a server
// with the same name already exists in the account. A ResourceNotFoundException
// is thrown when you specify a backup ID that is not valid or is for a backup
// that does not exist. A ValidationException is thrown when parameters of the
// request are not valid.
//
// If you do not specify a security group by adding the SecurityGroupIds parameter,
// AWS OpsWorks creates a new security group.
//
// Chef Automate: The default security group opens the Chef server to the world
// on TCP port 443. If a KeyName is present, AWS OpsWorks enables SSH access.
// SSH is also open to the world on TCP port 22.
//
// Puppet Enterprise: The default security group opens TCP ports 22, 443, 4433,
// 8140, 8142, 8143, and 8170. If a KeyName is present, AWS OpsWorks enables
// SSH access. SSH is also open to the world on TCP port 22.
//
// By default, your server is accessible from any IP address. We recommend that
// you update your security group rules to allow access from known IP addresses
// and address ranges only. To edit security group rules, open Security Groups
// in the navigation pane of the EC2 management console.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation CreateServer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeLimitExceededException "LimitExceededException"
//   The limit of servers or backups has been reached.
//
//   * ErrCodeResourceAlreadyExistsException "ResourceAlreadyExistsException"
//   The requested resource cannot be created because it already exists.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist, or access was denied.
//
//   * ErrCodeValidationException "ValidationException"
//   One or more of the provided request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/CreateServer
func (c *OpsWorksCM) CreateServer(input *CreateServerInput) (*CreateServerOutput, error) {
	req, out := c.CreateServerRequest(input)
	return out, req.Send()
}

// CreateServerWithContext is the same as CreateServer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) CreateServerWithContext(ctx aws.Context, input *CreateServerInput, opts ...request.Option) (*CreateServerOutput, error) {
	req, out := c.CreateServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteBackup = "DeleteBackup"

// DeleteBackupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteBackup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteBackup for more information on using the DeleteBackup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteBackupRequest method.
//    req, resp := client.DeleteBackupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DeleteBackup
func (c *OpsWorksCM) DeleteBackupRequest(input *DeleteBackupInput) (req *request.Request, output *DeleteBackupOutput) {
	op := &request.Operation{
		Name:       opDeleteBackup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteBackupInput{}
	}

	output = &DeleteBackupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteBackup API operation for AWS OpsWorks CM.
//
// Deletes a backup. You can delete both manual and automated backups. This
// operation is asynchronous.
//
// An InvalidStateException is thrown when a backup deletion is already in progress.
// A ResourceNotFoundException is thrown when the backup does not exist. A ValidationException
// is thrown when parameters of the request are not valid.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation DeleteBackup for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidStateException "InvalidStateException"
//   The resource is in a state that does not allow you to perform a specified
//   action.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist, or access was denied.
//
//   * ErrCodeValidationException "ValidationException"
//   One or more of the provided request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DeleteBackup
func (c *OpsWorksCM) DeleteBackup(input *DeleteBackupInput) (*DeleteBackupOutput, error) {
	req, out := c.DeleteBackupRequest(input)
	return out, req.Send()
}

// DeleteBackupWithContext is the same as DeleteBackup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteBackup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) DeleteBackupWithContext(ctx aws.Context, input *DeleteBackupInput, opts ...request.Option) (*DeleteBackupOutput, error) {
	req, out := c.DeleteBackupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteServer = "DeleteServer"

// DeleteServerRequest generates a "aws/request.Request" representing the
// client's request for the DeleteServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteServer for more information on using the DeleteServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteServerRequest method.
//    req, resp := client.DeleteServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DeleteServer
func (c *OpsWorksCM) DeleteServerRequest(input *DeleteServerInput) (req *request.Request, output *DeleteServerOutput) {
	op := &request.Operation{
		Name:       opDeleteServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteServerInput{}
	}

	output = &DeleteServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteServer API operation for AWS OpsWorks CM.
//
// Deletes the server and the underlying AWS CloudFormation stacks (including
// the server's EC2 instance). When you run this command, the server state is
// updated to DELETING. After the server is deleted, it is no longer returned
// by DescribeServer requests. If the AWS CloudFormation stack cannot be deleted,
// the server cannot be deleted.
//
// This operation is asynchronous.
//
// An InvalidStateException is thrown when a server deletion is already in progress.
// A ResourceNotFoundException is thrown when the server does not exist. A ValidationException
// is raised when parameters of the request are not valid.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation DeleteServer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidStateException "InvalidStateException"
//   The resource is in a state that does not allow you to perform a specified
//   action.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist, or access was denied.
//
//   * ErrCodeValidationException "ValidationException"
//   One or more of the provided request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DeleteServer
func (c *OpsWorksCM) DeleteServer(input *DeleteServerInput) (*DeleteServerOutput, error) {
	req, out := c.DeleteServerRequest(input)
	return out, req.Send()
}

// DeleteServerWithContext is the same as DeleteServer with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) DeleteServerWithContext(ctx aws.Context, input *DeleteServerInput, opts ...request.Option) (*DeleteServerOutput, error) {
	req, out := c.DeleteServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountAttributes = "DescribeAccountAttributes"

// DescribeAccountAttributesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountAttributes for more information on using the DescribeAccountAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountAttributesRequest method.
//    req, resp := client.DescribeAccountAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeAccountAttributes
func (c *OpsWorksCM) DescribeAccountAttributesRequest(input *DescribeAccountAttributesInput) (req *request.Request, output *DescribeAccountAttributesOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountAttributesInput{}
	}

	output = &DescribeAccountAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountAttributes API operation for AWS OpsWorks CM.
//
// Describes your OpsWorks-CM account attributes.
//
// This operation is synchronous.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation DescribeAccountAttributes for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeAccountAttributes
func (c *OpsWorksCM) DescribeAccountAttributes(input *DescribeAccountAttributesInput) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	return out, req.Send()
}

// DescribeAccountAttributesWithContext is the same as DescribeAccountAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) DescribeAccountAttributesWithContext(ctx aws.Context, input *DescribeAccountAttributesInput, opts ...request.Option) (*DescribeAccountAttributesOutput, error) {
	req, out := c.DescribeAccountAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeBackups = "DescribeBackups"

// DescribeBackupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeBackups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeBackups for more information on using the DescribeBackups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeBackupsRequest method.
//    req, resp := client.DescribeBackupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeBackups
func (c *OpsWorksCM) DescribeBackupsRequest(input *DescribeBackupsInput) (req *request.Request, output *DescribeBackupsOutput) {
	op := &request.Operation{
		Name:       opDescribeBackups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeBackupsInput{}
	}

	output = &DescribeBackupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeBackups API operation for AWS OpsWorks CM.
//
// Describes backups. The results are ordered by time, with newest backups first.
// If you do not specify a BackupId or ServerName, the command returns all backups.
//
// This operation is synchronous.
//
// A ResourceNotFoundException is thrown when the backup does not exist. A ValidationException
// is raised when parameters of the request are not valid.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation DescribeBackups for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more of the provided request parameters are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist, or access was denied.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   This occurs when the provided nextToken is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeBackups
func (c *OpsWorksCM) DescribeBackups(input *DescribeBackupsInput) (*DescribeBackupsOutput, error) {
	req, out := c.DescribeBackupsRequest(input)
	return out, req.Send()
}

// DescribeBackupsWithContext is the same as DescribeBackups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeBackups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) DescribeBackupsWithContext(ctx aws.Context, input *DescribeBackupsInput, opts ...request.Option) (*DescribeBackupsOutput, error) {
	req, out := c.DescribeBackupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEvents = "DescribeEvents"

// DescribeEventsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvents operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvents for more information on using the DescribeEvents
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeEventsRequest method.
//    req, resp := client.DescribeEventsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeEvents
func (c *OpsWorksCM) DescribeEventsRequest(input *DescribeEventsInput) (req *request.Request, output *DescribeEventsOutput) {
	op := &request.Operation{
		Name:       opDescribeEvents,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeEventsInput{}
	}

	output = &DescribeEventsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvents API operation for AWS OpsWorks CM.
//
// Describes events for a specified server. Results are ordered by time, with
// newest events first.
//
// This operation is synchronous.
//
// A ResourceNotFoundException is thrown when the server does not exist. A ValidationException
// is raised when parameters of the request are not valid.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation DescribeEvents for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more of the provided request parameters are not valid.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   This occurs when the provided nextToken is not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist, or access was denied.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeEvents
func (c *OpsWorksCM) DescribeEvents(input *DescribeEventsInput) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	return out, req.Send()
}

// DescribeEventsWithContext is the same as DescribeEvents with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvents for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) DescribeEventsWithContext(ctx aws.Context, input *DescribeEventsInput, opts ...request.Option) (*DescribeEventsOutput, error) {
	req, out := c.DescribeEventsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeNodeAssociationStatus = "DescribeNodeAssociationStatus"

// DescribeNodeAssociationStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeNodeAssociationStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeNodeAssociationStatus for more information on using the DescribeNodeAssociationStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeNodeAssociationStatusRequest method.
//    req, resp := client.DescribeNodeAssociationStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeNodeAssociationStatus
func (c *OpsWorksCM) DescribeNodeAssociationStatusRequest(input *DescribeNodeAssociationStatusInput) (req *request.Request, output *DescribeNodeAssociationStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeNodeAssociationStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeNodeAssociationStatusInput{}
	}

	output = &DescribeNodeAssociationStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeNodeAssociationStatus API operation for AWS OpsWorks CM.
//
// Returns the current status of an existing association or disassociation request.
//
// A ResourceNotFoundException is thrown when no recent association or disassociation
// request with the specified token is found, or when the server does not exist.
// A ValidationException is raised when parameters of the request are not valid.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation DescribeNodeAssociationStatus for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist, or access was denied.
//
//   * ErrCodeValidationException "ValidationException"
//   One or more of the provided request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeNodeAssociationStatus
func (c *OpsWorksCM) DescribeNodeAssociationStatus(input *DescribeNodeAssociationStatusInput) (*DescribeNodeAssociationStatusOutput, error) {
	req, out := c.DescribeNodeAssociationStatusRequest(input)
	return out, req.Send()
}

// DescribeNodeAssociationStatusWithContext is the same as DescribeNodeAssociationStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeNodeAssociationStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) DescribeNodeAssociationStatusWithContext(ctx aws.Context, input *DescribeNodeAssociationStatusInput, opts ...request.Option) (*DescribeNodeAssociationStatusOutput, error) {
	req, out := c.DescribeNodeAssociationStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeServers = "DescribeServers"

// DescribeServersRequest generates a "aws/request.Request" representing the
// client's request for the DescribeServers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeServers for more information on using the DescribeServers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeServersRequest method.
//    req, resp := client.DescribeServersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeServers
func (c *OpsWorksCM) DescribeServersRequest(input *DescribeServersInput) (req *request.Request, output *DescribeServersOutput) {
	op := &request.Operation{
		Name:       opDescribeServers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeServersInput{}
	}

	output = &DescribeServersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeServers API operation for AWS OpsWorks CM.
//
// Lists all configuration management servers that are identified with your
// account. Only the stored results from Amazon DynamoDB are returned. AWS OpsWorks
// CM does not query other services.
//
// This operation is synchronous.
//
// A ResourceNotFoundException is thrown when the server does not exist. A ValidationException
// is raised when parameters of the request are not valid.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation DescribeServers for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more of the provided request parameters are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist, or access was denied.
//
//   * ErrCodeInvalidNextTokenException "InvalidNextTokenException"
//   This occurs when the provided nextToken is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DescribeServers
func (c *OpsWorksCM) DescribeServers(input *DescribeServersInput) (*DescribeServersOutput, error) {
	req, out := c.DescribeServersRequest(input)
	return out, req.Send()
}

// DescribeServersWithContext is the same as DescribeServers with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeServers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) DescribeServersWithContext(ctx aws.Context, input *DescribeServersInput, opts ...request.Option) (*DescribeServersOutput, error) {
	req, out := c.DescribeServersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateNode = "DisassociateNode"

// DisassociateNodeRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateNode operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateNode for more information on using the DisassociateNode
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateNodeRequest method.
//    req, resp := client.DisassociateNodeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DisassociateNode
func (c *OpsWorksCM) DisassociateNodeRequest(input *DisassociateNodeInput) (req *request.Request, output *DisassociateNodeOutput) {
	op := &request.Operation{
		Name:       opDisassociateNode,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateNodeInput{}
	}

	output = &DisassociateNodeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateNode API operation for AWS OpsWorks CM.
//
// Disassociates a node from an AWS OpsWorks CM server, and removes the node
// from the server's managed nodes. After a node is disassociated, the node
// key pair is no longer valid for accessing the configuration manager's API.
// For more information about how to associate a node, see AssociateNode.
//
// A node can can only be disassociated from a server that is in a HEALTHY state.
// Otherwise, an InvalidStateException is thrown. A ResourceNotFoundException
// is thrown when the server does not exist. A ValidationException is raised
// when parameters of the request are not valid.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation DisassociateNode for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidStateException "InvalidStateException"
//   The resource is in a state that does not allow you to perform a specified
//   action.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist, or access was denied.
//
//   * ErrCodeValidationException "ValidationException"
//   One or more of the provided request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/DisassociateNode
func (c *OpsWorksCM) DisassociateNode(input *DisassociateNodeInput) (*DisassociateNodeOutput, error) {
	req, out := c.DisassociateNodeRequest(input)
	return out, req.Send()
}

// DisassociateNodeWithContext is the same as DisassociateNode with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateNode for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) DisassociateNodeWithContext(ctx aws.Context, input *DisassociateNodeInput, opts ...request.Option) (*DisassociateNodeOutput, error) {
	req, out := c.DisassociateNodeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExportServerEngineAttribute = "ExportServerEngineAttribute"

// ExportServerEngineAttributeRequest generates a "aws/request.Request" representing the
// client's request for the ExportServerEngineAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ExportServerEngineAttribute for more information on using the ExportServerEngineAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ExportServerEngineAttributeRequest method.
//    req, resp := client.ExportServerEngineAttributeRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/ExportServerEngineAttribute
func (c *OpsWorksCM) ExportServerEngineAttributeRequest(input *ExportServerEngineAttributeInput) (req *request.Request, output *ExportServerEngineAttributeOutput) {
	op := &request.Operation{
		Name:       opExportServerEngineAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExportServerEngineAttributeInput{}
	}

	output = &ExportServerEngineAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ExportServerEngineAttribute API operation for AWS OpsWorks CM.
//
// Exports a specified server engine attribute as a base64-encoded string. For
// example, you can export user data that you can use in EC2 to associate nodes
// with a server.
//
// This operation is synchronous.
//
// A ValidationException is raised when parameters of the request are not valid.
// A ResourceNotFoundException is thrown when the server does not exist. An
// InvalidStateException is thrown when the server is in any of the following
// states: CREATING, TERMINATED, FAILED or DELETING.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation ExportServerEngineAttribute for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeValidationException "ValidationException"
//   One or more of the provided request parameters are not valid.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist, or access was denied.
//
//   * ErrCodeInvalidStateException "InvalidStateException"
//   The resource is in a state that does not allow you to perform a specified
//   action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/ExportServerEngineAttribute
func (c *OpsWorksCM) ExportServerEngineAttribute(input *ExportServerEngineAttributeInput) (*ExportServerEngineAttributeOutput, error) {
	req, out := c.ExportServerEngineAttributeRequest(input)
	return out, req.Send()
}

// ExportServerEngineAttributeWithContext is the same as ExportServerEngineAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See ExportServerEngineAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) ExportServerEngineAttributeWithContext(ctx aws.Context, input *ExportServerEngineAttributeInput, opts ...request.Option) (*ExportServerEngineAttributeOutput, error) {
	req, out := c.ExportServerEngineAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreServer = "RestoreServer"

// RestoreServerRequest generates a "aws/request.Request" representing the
// client's request for the RestoreServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreServer for more information on using the RestoreServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreServerRequest method.
//    req, resp := client.RestoreServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/RestoreServer
func (c *OpsWorksCM) RestoreServerRequest(input *RestoreServerInput) (req *request.Request, output *RestoreServerOutput) {
	op := &request.Operation{
		Name:       opRestoreServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreServerInput{}
	}

	output = &RestoreServerOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RestoreServer API operation for AWS OpsWorks CM.
//
// Restores a backup to a server that is in a CONNECTION_LOST, HEALTHY, RUNNING,
// UNHEALTHY, or TERMINATED state. When you run RestoreServer, the server's
// EC2 instance is deleted, and a new EC2 instance is configured. RestoreServer
// maintains the existing server endpoint, so configuration management of the
// server's client devices (nodes) should continue to work.
//
// This operation is asynchronous.
//
// An InvalidStateException is thrown when the server is not in a valid state.
// A ResourceNotFoundException is thrown when the server does not exist. A ValidationException
// is raised when parameters of the request are not valid.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation RestoreServer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidStateException "InvalidStateException"
//   The resource is in a state that does not allow you to perform a specified
//   action.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist, or access was denied.
//
//   * ErrCodeValidationException "ValidationException"
//   One or more of the provided request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/RestoreServer
func (c *OpsWorksCM) RestoreServer(input *RestoreServerInput) (*RestoreServerOutput, error) {
	req, out := c.RestoreServerRequest(input)
	return out, req.Send()
}

// RestoreServerWithContext is the same as RestoreServer with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) RestoreServerWithContext(ctx aws.Context, input *RestoreServerInput, opts ...request.Option) (*RestoreServerOutput, error) {
	req, out := c.RestoreServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartMaintenance = "StartMaintenance"

// StartMaintenanceRequest generates a "aws/request.Request" representing the
// client's request for the StartMaintenance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartMaintenance for more information on using the StartMaintenance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartMaintenanceRequest method.
//    req, resp := client.StartMaintenanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/StartMaintenance
func (c *OpsWorksCM) StartMaintenanceRequest(input *StartMaintenanceInput) (req *request.Request, output *StartMaintenanceOutput) {
	op := &request.Operation{
		Name:       opStartMaintenance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartMaintenanceInput{}
	}

	output = &StartMaintenanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartMaintenance API operation for AWS OpsWorks CM.
//
// Manually starts server maintenance. This command can be useful if an earlier
// maintenance attempt failed, and the underlying cause of maintenance failure
// has been resolved. The server is in an UNDER_MAINTENANCE state while maintenance
// is in progress.
//
// Maintenance can only be started on servers in HEALTHY and UNHEALTHY states.
// Otherwise, an InvalidStateException is thrown. A ResourceNotFoundException
// is thrown when the server does not exist. A ValidationException is raised
// when parameters of the request are not valid.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation StartMaintenance for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidStateException "InvalidStateException"
//   The resource is in a state that does not allow you to perform a specified
//   action.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist, or access was denied.
//
//   * ErrCodeValidationException "ValidationException"
//   One or more of the provided request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/StartMaintenance
func (c *OpsWorksCM) StartMaintenance(input *StartMaintenanceInput) (*StartMaintenanceOutput, error) {
	req, out := c.StartMaintenanceRequest(input)
	return out, req.Send()
}

// StartMaintenanceWithContext is the same as StartMaintenance with the addition of
// the ability to pass a context and additional request options.
//
// See StartMaintenance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) StartMaintenanceWithContext(ctx aws.Context, input *StartMaintenanceInput, opts ...request.Option) (*StartMaintenanceOutput, error) {
	req, out := c.StartMaintenanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServer = "UpdateServer"

// UpdateServerRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServer operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServer for more information on using the UpdateServer
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateServerRequest method.
//    req, resp := client.UpdateServerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/UpdateServer
func (c *OpsWorksCM) UpdateServerRequest(input *UpdateServerInput) (req *request.Request, output *UpdateServerOutput) {
	op := &request.Operation{
		Name:       opUpdateServer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServerInput{}
	}

	output = &UpdateServerOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateServer API operation for AWS OpsWorks CM.
//
// Updates settings for a server.
//
// This operation is synchronous.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation UpdateServer for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidStateException "InvalidStateException"
//   The resource is in a state that does not allow you to perform a specified
//   action.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist, or access was denied.
//
//   * ErrCodeValidationException "ValidationException"
//   One or more of the provided request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/UpdateServer
func (c *OpsWorksCM) UpdateServer(input *UpdateServerInput) (*UpdateServerOutput, error) {
	req, out := c.UpdateServerRequest(input)
	return out, req.Send()
}

// UpdateServerWithContext is the same as UpdateServer with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) UpdateServerWithContext(ctx aws.Context, input *UpdateServerInput, opts ...request.Option) (*UpdateServerOutput, error) {
	req, out := c.UpdateServerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateServerEngineAttributes = "UpdateServerEngineAttributes"

// UpdateServerEngineAttributesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateServerEngineAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateServerEngineAttributes for more information on using the UpdateServerEngineAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateServerEngineAttributesRequest method.
//    req, resp := client.UpdateServerEngineAttributesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/UpdateServerEngineAttributes
func (c *OpsWorksCM) UpdateServerEngineAttributesRequest(input *UpdateServerEngineAttributesInput) (req *request.Request, output *UpdateServerEngineAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateServerEngineAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateServerEngineAttributesInput{}
	}

	output = &UpdateServerEngineAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateServerEngineAttributes API operation for AWS OpsWorks CM.
//
// Updates engine-specific attributes on a specified server. The server enters
// the MODIFYING state when this operation is in progress. Only one update can
// occur at a time. You can use this command to reset a Chef server's public
// key (CHEF_PIVOTAL_KEY) or a Puppet server's admin password (PUPPET_ADMIN_PASSWORD).
//
// This operation is asynchronous.
//
// This operation can only be called for servers in HEALTHY or UNHEALTHY states.
// Otherwise, an InvalidStateException is raised. A ResourceNotFoundException
// is thrown when the server does not exist. A ValidationException is raised
// when parameters of the request are not valid.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS OpsWorks CM's
// API operation UpdateServerEngineAttributes for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidStateException "InvalidStateException"
//   The resource is in a state that does not allow you to perform a specified
//   action.
//
//   * ErrCodeResourceNotFoundException "ResourceNotFoundException"
//   The requested resource does not exist, or access was denied.
//
//   * ErrCodeValidationException "ValidationException"
//   One or more of the provided request parameters are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/opsworkscm-2016-11-01/UpdateServerEngineAttributes
func (c *OpsWorksCM) UpdateServerEngineAttributes(input *UpdateServerEngineAttributesInput) (*UpdateServerEngineAttributesOutput, error) {
	req, out := c.UpdateServerEngineAttributesRequest(input)
	return out, req.Send()
}

// UpdateServerEngineAttributesWithContext is the same as UpdateServerEngineAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateServerEngineAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *OpsWorksCM) UpdateServerEngineAttributesWithContext(ctx aws.Context, input *UpdateServerEngineAttributesInput, opts ...request.Option) (*UpdateServerEngineAttributesOutput, error) {
	req, out := c.UpdateServerEngineAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Stores account attributes.
type AccountAttribute struct {
	_ struct{} `type:"structure"`

	// The maximum allowed value.
	Maximum *int64 `type:"integer"`

	// The attribute name. The following are supported attribute names.
	//
	//    * ServerLimit: The number of current servers/maximum number of servers
	//    allowed. By default, you can have a maximum of 10 servers.
	//
	//    * ManualBackupLimit: The number of current manual backups/maximum number
	//    of backups allowed. By default, you can have a maximum of 50 manual backups
	//    saved.
	Name *string `type:"string"`

	// The current usage, such as the current number of servers that are associated
	// with the account.
	Used *int64 `type:"integer"`
}

// String returns the string representation
func (s AccountAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccountAttribute) GoString() string {
	return s.String()
}

// SetMaximum sets the Maximum field's value.
func (s *AccountAttribute) SetMaximum(v int64) *AccountAttribute {
	s.Maximum = &v
	return s
}

// SetName sets the Name field's value.
func (s *AccountAttribute) SetName(v string) *AccountAttribute {
	s.Name = &v
	return s
}

// SetUsed sets the Used field's value.
func (s *AccountAttribute) SetUsed(v int64) *AccountAttribute {
	s.Used = &v
	return s
}

type AssociateNodeInput struct {
	_ struct{} `type:"structure"`

	// Engine attributes used for associating the node.
	//
	// Attributes accepted in a AssociateNode request for Chef
	//
	//    * CHEF_ORGANIZATION: The Chef organization with which the node is associated.
	//    By default only one organization named default can exist.
	//
	//    * CHEF_NODE_PUBLIC_KEY: A PEM-formatted public key. This key is required
	//    for the chef-client agent to access the Chef API.
	//
	// Attributes accepted in a AssociateNode request for Puppet
	//
	//    * PUPPET_NODE_CSR: A PEM-formatted certificate-signing request (CSR) that
	//    is created by the node.
	//
	// EngineAttributes is a required field
	EngineAttributes []*EngineAttribute `type:"list" required:"true"`

	// The name of the node.
	//
	// NodeName is a required field
	NodeName *string `type:"string" required:"true"`

	// The name of the server with which to associate the node.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s AssociateNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateNodeInput"}
	if s.EngineAttributes == nil {
		invalidParams.Add(request.NewErrParamRequired("EngineAttributes"))
	}
	if s.NodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeName"))
	}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngineAttributes sets the EngineAttributes field's value.
func (s *AssociateNodeInput) SetEngineAttributes(v []*EngineAttribute) *AssociateNodeInput {
	s.EngineAttributes = v
	return s
}

// SetNodeName sets the NodeName field's value.
func (s *AssociateNodeInput) SetNodeName(v string) *AssociateNodeInput {
	s.NodeName = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *AssociateNodeInput) SetServerName(v string) *AssociateNodeInput {
	s.ServerName = &v
	return s
}

type AssociateNodeOutput struct {
	_ struct{} `type:"structure"`

	// Contains a token which can be passed to the DescribeNodeAssociationStatus
	// API call to get the status of the association request.
	NodeAssociationStatusToken *string `type:"string"`
}

// String returns the string representation
func (s AssociateNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AssociateNodeOutput) GoString() string {
	return s.String()
}

// SetNodeAssociationStatusToken sets the NodeAssociationStatusToken field's value.
func (s *AssociateNodeOutput) SetNodeAssociationStatusToken(v string) *AssociateNodeOutput {
	s.NodeAssociationStatusToken = &v
	return s
}

// Describes a single backup.
type Backup struct {
	_ struct{} `type:"structure"`

	// The ARN of the backup.
	BackupArn *string `type:"string"`

	// The generated ID of the backup. Example: myServerName-yyyyMMddHHmmssSSS
	BackupId *string `type:"string"`

	// The backup type. Valid values are automated or manual.
	BackupType *string `type:"string" enum:"BackupType"`

	// The time stamp when the backup was created in the database. Example: 2016-07-29T13:38:47.520Z
	CreatedAt *time.Time `type:"timestamp"`

	// A user-provided description for a manual backup. This field is empty for
	// automated backups.
	Description *string `type:"string"`

	// The engine type that is obtained from the server when the backup is created.
	Engine *string `type:"string"`

	// The engine model that is obtained from the server when the backup is created.
	EngineModel *string `type:"string"`

	// The engine version that is obtained from the server when the backup is created.
	EngineVersion *string `type:"string"`

	// The EC2 instance profile ARN that is obtained from the server when the backup
	// is created. Because this value is stored, you are not required to provide
	// the InstanceProfileArn again if you restore a backup.
	InstanceProfileArn *string `type:"string"`

	// The instance type that is obtained from the server when the backup is created.
	InstanceType *string `type:"string"`

	// The key pair that is obtained from the server when the backup is created.
	KeyPair *string `type:"string"`

	// The preferred backup period that is obtained from the server when the backup
	// is created.
	PreferredBackupWindow *string `type:"string"`

	// The preferred maintenance period that is obtained from the server when the
	// backup is created.
	PreferredMaintenanceWindow *string `type:"string"`

	// This field is deprecated and is no longer used.
	//
	// Deprecated: S3DataSize has been deprecated
	S3DataSize *int64 `deprecated:"true" type:"integer"`

	// This field is deprecated and is no longer used.
	//
	// Deprecated: S3DataUrl has been deprecated
	S3DataUrl *string `deprecated:"true" type:"string"`

	// The Amazon S3 URL of the backup's log file.
	S3LogUrl *string `type:"string"`

	// The security group IDs that are obtained from the server when the backup
	// is created.
	SecurityGroupIds []*string `type:"list"`

	// The name of the server from which the backup was made.
	ServerName *string `min:"1" type:"string"`

	// The service role ARN that is obtained from the server when the backup is
	// created.
	ServiceRoleArn *string `type:"string"`

	// The status of a backup while in progress.
	Status *string `type:"string" enum:"BackupStatus"`

	// An informational message about backup status.
	StatusDescription *string `type:"string"`

	// The subnet IDs that are obtained from the server when the backup is created.
	SubnetIds []*string `type:"list"`

	// The version of AWS OpsWorks CM-specific tools that is obtained from the server
	// when the backup is created.
	ToolsVersion *string `type:"string"`

	// The IAM user ARN of the requester for manual backups. This field is empty
	// for automated backups.
	UserArn *string `type:"string"`
}

// String returns the string representation
func (s Backup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Backup) GoString() string {
	return s.String()
}

// SetBackupArn sets the BackupArn field's value.
func (s *Backup) SetBackupArn(v string) *Backup {
	s.BackupArn = &v
	return s
}

// SetBackupId sets the BackupId field's value.
func (s *Backup) SetBackupId(v string) *Backup {
	s.BackupId = &v
	return s
}

// SetBackupType sets the BackupType field's value.
func (s *Backup) SetBackupType(v string) *Backup {
	s.BackupType = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Backup) SetCreatedAt(v time.Time) *Backup {
	s.CreatedAt = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Backup) SetDescription(v string) *Backup {
	s.Description = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *Backup) SetEngine(v string) *Backup {
	s.Engine = &v
	return s
}

// SetEngineModel sets the EngineModel field's value.
func (s *Backup) SetEngineModel(v string) *Backup {
	s.EngineModel = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *Backup) SetEngineVersion(v string) *Backup {
	s.EngineVersion = &v
	return s
}

// SetInstanceProfileArn sets the InstanceProfileArn field's value.
func (s *Backup) SetInstanceProfileArn(v string) *Backup {
	s.InstanceProfileArn = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *Backup) SetInstanceType(v string) *Backup {
	s.InstanceType = &v
	return s
}

// SetKeyPair sets the KeyPair field's value.
func (s *Backup) SetKeyPair(v string) *Backup {
	s.KeyPair = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *Backup) SetPreferredBackupWindow(v string) *Backup {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *Backup) SetPreferredMaintenanceWindow(v string) *Backup {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetS3DataSize sets the S3DataSize field's value.
func (s *Backup) SetS3DataSize(v int64) *Backup {
	s.S3DataSize = &v
	return s
}

// SetS3DataUrl sets the S3DataUrl field's value.
func (s *Backup) SetS3DataUrl(v string) *Backup {
	s.S3DataUrl = &v
	return s
}

// SetS3LogUrl sets the S3LogUrl field's value.
func (s *Backup) SetS3LogUrl(v string) *Backup {
	s.S3LogUrl = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *Backup) SetSecurityGroupIds(v []*string) *Backup {
	s.SecurityGroupIds = v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *Backup) SetServerName(v string) *Backup {
	s.ServerName = &v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *Backup) SetServiceRoleArn(v string) *Backup {
	s.ServiceRoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Backup) SetStatus(v string) *Backup {
	s.Status = &v
	return s
}

// SetStatusDescription sets the StatusDescription field's value.
func (s *Backup) SetStatusDescription(v string) *Backup {
	s.StatusDescription = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *Backup) SetSubnetIds(v []*string) *Backup {
	s.SubnetIds = v
	return s
}

// SetToolsVersion sets the ToolsVersion field's value.
func (s *Backup) SetToolsVersion(v string) *Backup {
	s.ToolsVersion = &v
	return s
}

// SetUserArn sets the UserArn field's value.
func (s *Backup) SetUserArn(v string) *Backup {
	s.UserArn = &v
	return s
}

type CreateBackupInput struct {
	_ struct{} `type:"structure"`

	// A user-defined description of the backup.
	Description *string `type:"string"`

	// The name of the server that you want to back up.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateBackupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBackupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBackupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBackupInput"}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateBackupInput) SetDescription(v string) *CreateBackupInput {
	s.Description = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *CreateBackupInput) SetServerName(v string) *CreateBackupInput {
	s.ServerName = &v
	return s
}

type CreateBackupOutput struct {
	_ struct{} `type:"structure"`

	// Backup created by request.
	Backup *Backup `type:"structure"`
}

// String returns the string representation
func (s CreateBackupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBackupOutput) GoString() string {
	return s.String()
}

// SetBackup sets the Backup field's value.
func (s *CreateBackupOutput) SetBackup(v *Backup) *CreateBackupOutput {
	s.Backup = v
	return s
}

type CreateServerInput struct {
	_ struct{} `type:"structure"`

	// Associate a public IP address with a server that you are launching. Valid
	// values are true or false. The default value is true.
	AssociatePublicIpAddress *bool `type:"boolean"`

	// If you specify this field, AWS OpsWorks CM creates the server by using the
	// backup represented by BackupId.
	BackupId *string `type:"string"`

	// The number of automated backups that you want to keep. Whenever a new backup
	// is created, AWS OpsWorks CM deletes the oldest backups if this number is
	// exceeded. The default value is 1.
	BackupRetentionCount *int64 `min:"1" type:"integer"`

	// Enable or disable scheduled backups. Valid values are true or false. The
	// default value is true.
	DisableAutomatedBackup *bool `type:"boolean"`

	// The configuration management engine to use. Valid values include ChefAutomate
	// and Puppet.
	Engine *string `type:"string"`

	// Optional engine attributes on a specified server.
	//
	// Attributes accepted in a Chef createServer request:
	//
	//    * CHEF_AUTOMATE_PIVOTAL_KEY: A base64-encoded RSA public key. The corresponding
	//    private key is required to access the Chef API. When no CHEF_AUTOMATE_PIVOTAL_KEY
	//    is set, a private key is generated and returned in the response.
	//
	//    * CHEF_AUTOMATE_ADMIN_PASSWORD: The password for the administrative user
	//    in the Chef Automate web-based dashboard. The password length is a minimum
	//    of eight characters, and a maximum of 32. The password can contain letters,
	//    numbers, and special characters (!/@#$%^&+=_). The password must contain
	//    at least one lower case letter, one upper case letter, one number, and
	//    one special character. When no CHEF_AUTOMATE_ADMIN_PASSWORD is set, one
	//    is generated and returned in the response.
	//
	// Attributes accepted in a Puppet createServer request:
	//
	//    * PUPPET_ADMIN_PASSWORD: To work with the Puppet Enterprise console, a
	//    password must use ASCII characters.
	//
	//    * PUPPET_R10K_REMOTE: The r10k remote is the URL of your control repository
	//    (for example, ssh://git@your.git-repo.com:user/control-repo.git). Specifying
	//    an r10k remote opens TCP port 8170.
	//
	//    * PUPPET_R10K_PRIVATE_KEY: If you are using a private Git repository,
	//    add PUPPET_R10K_PRIVATE_KEY to specify a PEM-encoded private SSH key.
	EngineAttributes []*EngineAttribute `type:"list"`

	// The engine model of the server. Valid values in this release include Monolithic
	// for Puppet and Single for Chef.
	EngineModel *string `type:"string"`

	// The major release version of the engine that you want to use. For a Chef
	// server, the valid value for EngineVersion is currently 12. For a Puppet server,
	// the valid value is 2017.
	EngineVersion *string `type:"string"`

	// The ARN of the instance profile that your Amazon EC2 instances use. Although
	// the AWS OpsWorks console typically creates the instance profile for you,
	// if you are using API commands instead, run the service-role-creation.yaml
	// AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml.
	// This template creates a CloudFormation stack that includes the instance profile
	// you need.
	//
	// InstanceProfileArn is a required field
	InstanceProfileArn *string `type:"string" required:"true"`

	// The Amazon EC2 instance type to use. For example, m5.large.
	//
	// InstanceType is a required field
	InstanceType *string `type:"string" required:"true"`

	// The Amazon EC2 key pair to set for the instance. This parameter is optional;
	// if desired, you may specify this parameter to connect to your instances by
	// using SSH.
	KeyPair *string `type:"string"`

	// The start time for a one-hour period during which AWS OpsWorks CM backs up
	// application-level data on your server if automated backups are enabled. Valid
	// values must be specified in one of the following formats:
	//
	//    * HH:MM for daily backups
	//
	//    * DDD:HH:MM for weekly backups
	//
	// The specified time is in coordinated universal time (UTC). The default value
	// is a random, daily start time.
	//
	// Example: 08:00, which represents a daily start time of 08:00 UTC.
	//
	// Example: Mon:08:00, which represents a start time of every Monday at 08:00
	// UTC. (8:00 a.m.)
	PreferredBackupWindow *string `type:"string"`

	// The start time for a one-hour period each week during which AWS OpsWorks
	// CM performs maintenance on the instance. Valid values must be specified in
	// the following format: DDD:HH:MM. The specified time is in coordinated universal
	// time (UTC). The default value is a random one-hour period on Tuesday, Wednesday,
	// or Friday. See TimeWindowDefinition for more information.
	//
	// Example: Mon:08:00, which represents a start time of every Monday at 08:00
	// UTC. (8:00 a.m.)
	PreferredMaintenanceWindow *string `type:"string"`

	// A list of security group IDs to attach to the Amazon EC2 instance. If you
	// add this parameter, the specified security groups must be within the VPC
	// that is specified by SubnetIds.
	//
	// If you do not specify this parameter, AWS OpsWorks CM creates one new security
	// group that uses TCP ports 22 and 443, open to 0.0.0.0/0 (everyone).
	SecurityGroupIds []*string `type:"list"`

	// The name of the server. The server name must be unique within your AWS account,
	// within each region. Server names must start with a letter; then letters,
	// numbers, or hyphens (-) are allowed, up to a maximum of 40 characters.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`

	// The service role that the AWS OpsWorks CM service backend uses to work with
	// your account. Although the AWS OpsWorks management console typically creates
	// the service role for you, if you are using the AWS CLI or API commands, run
	// the service-role-creation.yaml AWS CloudFormation template, located at https://s3.amazonaws.com/opsworks-cm-us-east-1-prod-default-assets/misc/opsworks-cm-roles.yaml.
	// This template creates a CloudFormation stack that includes the service role
	// and instance profile that you need.
	//
	// ServiceRoleArn is a required field
	ServiceRoleArn *string `type:"string" required:"true"`

	// The IDs of subnets in which to launch the server EC2 instance.
	//
	// Amazon EC2-Classic customers: This field is required. All servers must run
	// within a VPC. The VPC must have "Auto Assign Public IP" enabled.
	//
	// EC2-VPC customers: This field is optional. If you do not specify subnet IDs,
	// your EC2 instances are created in a default subnet that is selected by Amazon
	// EC2. If you specify subnet IDs, the VPC must have "Auto Assign Public IP"
	// enabled.
	//
	// For more information about supported Amazon EC2 platforms, see Supported
	// Platforms (https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-platforms.html).
	SubnetIds []*string `type:"list"`
}

// String returns the string representation
func (s CreateServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServerInput"}
	if s.BackupRetentionCount != nil && *s.BackupRetentionCount < 1 {
		invalidParams.Add(request.NewErrParamMinValue("BackupRetentionCount", 1))
	}
	if s.InstanceProfileArn == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceProfileArn"))
	}
	if s.InstanceType == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceType"))
	}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}
	if s.ServiceRoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceRoleArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAssociatePublicIpAddress sets the AssociatePublicIpAddress field's value.
func (s *CreateServerInput) SetAssociatePublicIpAddress(v bool) *CreateServerInput {
	s.AssociatePublicIpAddress = &v
	return s
}

// SetBackupId sets the BackupId field's value.
func (s *CreateServerInput) SetBackupId(v string) *CreateServerInput {
	s.BackupId = &v
	return s
}

// SetBackupRetentionCount sets the BackupRetentionCount field's value.
func (s *CreateServerInput) SetBackupRetentionCount(v int64) *CreateServerInput {
	s.BackupRetentionCount = &v
	return s
}

// SetDisableAutomatedBackup sets the DisableAutomatedBackup field's value.
func (s *CreateServerInput) SetDisableAutomatedBackup(v bool) *CreateServerInput {
	s.DisableAutomatedBackup = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *CreateServerInput) SetEngine(v string) *CreateServerInput {
	s.Engine = &v
	return s
}

// SetEngineAttributes sets the EngineAttributes field's value.
func (s *CreateServerInput) SetEngineAttributes(v []*EngineAttribute) *CreateServerInput {
	s.EngineAttributes = v
	return s
}

// SetEngineModel sets the EngineModel field's value.
func (s *CreateServerInput) SetEngineModel(v string) *CreateServerInput {
	s.EngineModel = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *CreateServerInput) SetEngineVersion(v string) *CreateServerInput {
	s.EngineVersion = &v
	return s
}

// SetInstanceProfileArn sets the InstanceProfileArn field's value.
func (s *CreateServerInput) SetInstanceProfileArn(v string) *CreateServerInput {
	s.InstanceProfileArn = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *CreateServerInput) SetInstanceType(v string) *CreateServerInput {
	s.InstanceType = &v
	return s
}

// SetKeyPair sets the KeyPair field's value.
func (s *CreateServerInput) SetKeyPair(v string) *CreateServerInput {
	s.KeyPair = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *CreateServerInput) SetPreferredBackupWindow(v string) *CreateServerInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *CreateServerInput) SetPreferredMaintenanceWindow(v string) *CreateServerInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *CreateServerInput) SetSecurityGroupIds(v []*string) *CreateServerInput {
	s.SecurityGroupIds = v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *CreateServerInput) SetServerName(v string) *CreateServerInput {
	s.ServerName = &v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *CreateServerInput) SetServiceRoleArn(v string) *CreateServerInput {
	s.ServiceRoleArn = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *CreateServerInput) SetSubnetIds(v []*string) *CreateServerInput {
	s.SubnetIds = v
	return s
}

type CreateServerOutput struct {
	_ struct{} `type:"structure"`

	// The server that is created by the request.
	Server *Server `type:"structure"`
}

// String returns the string representation
func (s CreateServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServerOutput) GoString() string {
	return s.String()
}

// SetServer sets the Server field's value.
func (s *CreateServerOutput) SetServer(v *Server) *CreateServerOutput {
	s.Server = v
	return s
}

type DeleteBackupInput struct {
	_ struct{} `type:"structure"`

	// The ID of the backup to delete. Run the DescribeBackups command to get a
	// list of backup IDs. Backup IDs are in the format ServerName-yyyyMMddHHmmssSSS.
	//
	// BackupId is a required field
	BackupId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteBackupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBackupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteBackupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteBackupInput"}
	if s.BackupId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupId sets the BackupId field's value.
func (s *DeleteBackupInput) SetBackupId(v string) *DeleteBackupInput {
	s.BackupId = &v
	return s
}

type DeleteBackupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteBackupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteBackupOutput) GoString() string {
	return s.String()
}

type DeleteServerInput struct {
	_ struct{} `type:"structure"`

	// The ID of the server to delete.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteServerInput"}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetServerName sets the ServerName field's value.
func (s *DeleteServerInput) SetServerName(v string) *DeleteServerInput {
	s.ServerName = &v
	return s
}

type DeleteServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteServerOutput) GoString() string {
	return s.String()
}

type DescribeAccountAttributesInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DescribeAccountAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesInput) GoString() string {
	return s.String()
}

type DescribeAccountAttributesOutput struct {
	_ struct{} `type:"structure"`

	// The attributes that are currently set for the account.
	Attributes []*AccountAttribute `type:"list"`
}

// String returns the string representation
func (s DescribeAccountAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAccountAttributesOutput) GoString() string {
	return s.String()
}

// SetAttributes sets the Attributes field's value.
func (s *DescribeAccountAttributesOutput) SetAttributes(v []*AccountAttribute) *DescribeAccountAttributesOutput {
	s.Attributes = v
	return s
}

type DescribeBackupsInput struct {
	_ struct{} `type:"structure"`

	// Describes a single backup.
	BackupId *string `type:"string"`

	// This is not currently implemented for DescribeBackups requests.
	MaxResults *int64 `min:"1" type:"integer"`

	// This is not currently implemented for DescribeBackups requests.
	NextToken *string `type:"string"`

	// Returns backups for the server with the specified ServerName.
	ServerName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeBackupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBackupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeBackupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeBackupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupId sets the BackupId field's value.
func (s *DescribeBackupsInput) SetBackupId(v string) *DescribeBackupsInput {
	s.BackupId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeBackupsInput) SetMaxResults(v int64) *DescribeBackupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBackupsInput) SetNextToken(v string) *DescribeBackupsInput {
	s.NextToken = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *DescribeBackupsInput) SetServerName(v string) *DescribeBackupsInput {
	s.ServerName = &v
	return s
}

type DescribeBackupsOutput struct {
	_ struct{} `type:"structure"`

	// Contains the response to a DescribeBackups request.
	Backups []*Backup `type:"list"`

	// This is not currently implemented for DescribeBackups requests.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s DescribeBackupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeBackupsOutput) GoString() string {
	return s.String()
}

// SetBackups sets the Backups field's value.
func (s *DescribeBackupsOutput) SetBackups(v []*Backup) *DescribeBackupsOutput {
	s.Backups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeBackupsOutput) SetNextToken(v string) *DescribeBackupsOutput {
	s.NextToken = &v
	return s
}

type DescribeEventsInput struct {
	_ struct{} `type:"structure"`

	// To receive a paginated response, use this parameter to specify the maximum
	// number of results to be returned with a single call. If the number of available
	// results exceeds this maximum, the response includes a NextToken value that
	// you can assign to the NextToken request parameter to get the next set of
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// NextToken is a string that is returned in some command responses. It indicates
	// that not all entries have been returned, and that you must run at least one
	// more request to get remaining items. To get remaining results, call DescribeEvents
	// again, and assign the token from the previous results as the value of the
	// nextToken parameter. If there are no more results, the response object's
	// nextToken parameter value is null. Setting a nextToken value that was not
	// returned in your previous results causes an InvalidNextTokenException to
	// occur.
	NextToken *string `type:"string"`

	// The name of the server for which you want to view events.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeEventsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeEventsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeEventsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeEventsInput) SetMaxResults(v int64) *DescribeEventsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEventsInput) SetNextToken(v string) *DescribeEventsInput {
	s.NextToken = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *DescribeEventsInput) SetServerName(v string) *DescribeEventsInput {
	s.ServerName = &v
	return s
}

type DescribeEventsOutput struct {
	_ struct{} `type:"structure"`

	// NextToken is a string that is returned in some command responses. It indicates
	// that not all entries have been returned, and that you must run at least one
	// more request to get remaining items. To get remaining results, call DescribeEvents
	// again, and assign the token from the previous results as the value of the
	// nextToken parameter. If there are no more results, the response object's
	// nextToken parameter value is null. Setting a nextToken value that was not
	// returned in your previous results causes an InvalidNextTokenException to
	// occur.
	NextToken *string `type:"string"`

	// Contains the response to a DescribeEvents request.
	ServerEvents []*ServerEvent `type:"list"`
}

// String returns the string representation
func (s DescribeEventsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeEventsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeEventsOutput) SetNextToken(v string) *DescribeEventsOutput {
	s.NextToken = &v
	return s
}

// SetServerEvents sets the ServerEvents field's value.
func (s *DescribeEventsOutput) SetServerEvents(v []*ServerEvent) *DescribeEventsOutput {
	s.ServerEvents = v
	return s
}

type DescribeNodeAssociationStatusInput struct {
	_ struct{} `type:"structure"`

	// The token returned in either the AssociateNodeResponse or the DisassociateNodeResponse.
	//
	// NodeAssociationStatusToken is a required field
	NodeAssociationStatusToken *string `type:"string" required:"true"`

	// The name of the server from which to disassociate the node.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeNodeAssociationStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNodeAssociationStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeNodeAssociationStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeNodeAssociationStatusInput"}
	if s.NodeAssociationStatusToken == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeAssociationStatusToken"))
	}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNodeAssociationStatusToken sets the NodeAssociationStatusToken field's value.
func (s *DescribeNodeAssociationStatusInput) SetNodeAssociationStatusToken(v string) *DescribeNodeAssociationStatusInput {
	s.NodeAssociationStatusToken = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *DescribeNodeAssociationStatusInput) SetServerName(v string) *DescribeNodeAssociationStatusInput {
	s.ServerName = &v
	return s
}

type DescribeNodeAssociationStatusOutput struct {
	_ struct{} `type:"structure"`

	// Attributes specific to the node association. In Puppet, the attibute PUPPET_NODE_CERT
	// contains the signed certificate (the result of the CSR).
	EngineAttributes []*EngineAttribute `type:"list"`

	// The status of the association or disassociation request.
	//
	// Possible values:
	//
	//    * SUCCESS: The association or disassociation succeeded.
	//
	//    * FAILED: The association or disassociation failed.
	//
	//    * IN_PROGRESS: The association or disassociation is still in progress.
	NodeAssociationStatus *string `type:"string" enum:"NodeAssociationStatus"`
}

// String returns the string representation
func (s DescribeNodeAssociationStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeNodeAssociationStatusOutput) GoString() string {
	return s.String()
}

// SetEngineAttributes sets the EngineAttributes field's value.
func (s *DescribeNodeAssociationStatusOutput) SetEngineAttributes(v []*EngineAttribute) *DescribeNodeAssociationStatusOutput {
	s.EngineAttributes = v
	return s
}

// SetNodeAssociationStatus sets the NodeAssociationStatus field's value.
func (s *DescribeNodeAssociationStatusOutput) SetNodeAssociationStatus(v string) *DescribeNodeAssociationStatusOutput {
	s.NodeAssociationStatus = &v
	return s
}

type DescribeServersInput struct {
	_ struct{} `type:"structure"`

	// This is not currently implemented for DescribeServers requests.
	MaxResults *int64 `min:"1" type:"integer"`

	// This is not currently implemented for DescribeServers requests.
	NextToken *string `type:"string"`

	// Describes the server with the specified ServerName.
	ServerName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DescribeServersInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeServersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeServersInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeServersInput) SetMaxResults(v int64) *DescribeServersInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeServersInput) SetNextToken(v string) *DescribeServersInput {
	s.NextToken = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *DescribeServersInput) SetServerName(v string) *DescribeServersInput {
	s.ServerName = &v
	return s
}

type DescribeServersOutput struct {
	_ struct{} `type:"structure"`

	// This is not currently implemented for DescribeServers requests.
	NextToken *string `type:"string"`

	// Contains the response to a DescribeServers request.
	//
	// For Puppet Server: DescribeServersResponse$Servers$EngineAttributes contains
	// PUPPET_API_CA_CERT. This is the PEM-encoded CA certificate that is used by
	// the Puppet API over TCP port number 8140. The CA certificate is also used
	// to sign node certificates.
	Servers []*Server `type:"list"`
}

// String returns the string representation
func (s DescribeServersOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeServersOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeServersOutput) SetNextToken(v string) *DescribeServersOutput {
	s.NextToken = &v
	return s
}

// SetServers sets the Servers field's value.
func (s *DescribeServersOutput) SetServers(v []*Server) *DescribeServersOutput {
	s.Servers = v
	return s
}

type DisassociateNodeInput struct {
	_ struct{} `type:"structure"`

	// Engine attributes that are used for disassociating the node. No attributes
	// are required for Puppet.
	//
	// Attributes required in a DisassociateNode request for Chef
	//
	//    * CHEF_ORGANIZATION: The Chef organization with which the node was associated.
	//    By default only one organization named default can exist.
	EngineAttributes []*EngineAttribute `type:"list"`

	// The name of the client node.
	//
	// NodeName is a required field
	NodeName *string `type:"string" required:"true"`

	// The name of the server from which to disassociate the node.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DisassociateNodeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateNodeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateNodeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateNodeInput"}
	if s.NodeName == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeName"))
	}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngineAttributes sets the EngineAttributes field's value.
func (s *DisassociateNodeInput) SetEngineAttributes(v []*EngineAttribute) *DisassociateNodeInput {
	s.EngineAttributes = v
	return s
}

// SetNodeName sets the NodeName field's value.
func (s *DisassociateNodeInput) SetNodeName(v string) *DisassociateNodeInput {
	s.NodeName = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *DisassociateNodeInput) SetServerName(v string) *DisassociateNodeInput {
	s.ServerName = &v
	return s
}

type DisassociateNodeOutput struct {
	_ struct{} `type:"structure"`

	// Contains a token which can be passed to the DescribeNodeAssociationStatus
	// API call to get the status of the disassociation request.
	NodeAssociationStatusToken *string `type:"string"`
}

// String returns the string representation
func (s DisassociateNodeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisassociateNodeOutput) GoString() string {
	return s.String()
}

// SetNodeAssociationStatusToken sets the NodeAssociationStatusToken field's value.
func (s *DisassociateNodeOutput) SetNodeAssociationStatusToken(v string) *DisassociateNodeOutput {
	s.NodeAssociationStatusToken = &v
	return s
}

// A name and value pair that is specific to the engine of the server.
type EngineAttribute struct {
	_ struct{} `type:"structure"`

	// The name of the engine attribute.
	Name *string `type:"string"`

	// The value of the engine attribute.
	Value *string `type:"string" sensitive:"true"`
}

// String returns the string representation
func (s EngineAttribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s EngineAttribute) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *EngineAttribute) SetName(v string) *EngineAttribute {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EngineAttribute) SetValue(v string) *EngineAttribute {
	s.Value = &v
	return s
}

type ExportServerEngineAttributeInput struct {
	_ struct{} `type:"structure"`

	// The name of the export attribute. Currently, the supported export attribute
	// is Userdata. This exports a user data script that includes parameters and
	// values provided in the InputAttributes list.
	//
	// ExportAttributeName is a required field
	ExportAttributeName *string `type:"string" required:"true"`

	// The list of engine attributes. The list type is EngineAttribute. An EngineAttribute
	// list item is a pair that includes an attribute name and its value. For the
	// Userdata ExportAttributeName, the following are supported engine attribute
	// names.
	//
	//    * RunList In Chef, a list of roles or recipes that are run in the specified
	//    order. In Puppet, this parameter is ignored.
	//
	//    * OrganizationName In Chef, an organization name. AWS OpsWorks for Chef
	//    Automate always creates the organization default. In Puppet, this parameter
	//    is ignored.
	//
	//    * NodeEnvironment In Chef, a node environment (for example, development,
	//    staging, or one-box). In Puppet, this parameter is ignored.
	//
	//    * NodeClientVersion In Chef, the version of the Chef engine (three numbers
	//    separated by dots, such as 13.8.5). If this attribute is empty, OpsWorks
	//    for Chef Automate uses the most current version. In Puppet, this parameter
	//    is ignored.
	InputAttributes []*EngineAttribute `type:"list"`

	// The name of the server from which you are exporting the attribute.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ExportServerEngineAttributeInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportServerEngineAttributeInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExportServerEngineAttributeInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExportServerEngineAttributeInput"}
	if s.ExportAttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("ExportAttributeName"))
	}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExportAttributeName sets the ExportAttributeName field's value.
func (s *ExportServerEngineAttributeInput) SetExportAttributeName(v string) *ExportServerEngineAttributeInput {
	s.ExportAttributeName = &v
	return s
}

// SetInputAttributes sets the InputAttributes field's value.
func (s *ExportServerEngineAttributeInput) SetInputAttributes(v []*EngineAttribute) *ExportServerEngineAttributeInput {
	s.InputAttributes = v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *ExportServerEngineAttributeInput) SetServerName(v string) *ExportServerEngineAttributeInput {
	s.ServerName = &v
	return s
}

type ExportServerEngineAttributeOutput struct {
	_ struct{} `type:"structure"`

	// The requested engine attribute pair with attribute name and value.
	EngineAttribute *EngineAttribute `type:"structure"`

	// The server name used in the request.
	ServerName *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ExportServerEngineAttributeOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExportServerEngineAttributeOutput) GoString() string {
	return s.String()
}

// SetEngineAttribute sets the EngineAttribute field's value.
func (s *ExportServerEngineAttributeOutput) SetEngineAttribute(v *EngineAttribute) *ExportServerEngineAttributeOutput {
	s.EngineAttribute = v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *ExportServerEngineAttributeOutput) SetServerName(v string) *ExportServerEngineAttributeOutput {
	s.ServerName = &v
	return s
}

type RestoreServerInput struct {
	_ struct{} `type:"structure"`

	// The ID of the backup that you want to use to restore a server.
	//
	// BackupId is a required field
	BackupId *string `type:"string" required:"true"`

	// The type of the instance to create. Valid values must be specified in the
	// following format: ^([cm][34]|t2).* For example, m5.large. Valid values are
	// m5.large, r5.xlarge, and r5.2xlarge. If you do not specify this parameter,
	// RestoreServer uses the instance type from the specified backup.
	InstanceType *string `type:"string"`

	// The name of the key pair to set on the new EC2 instance. This can be helpful
	// if the administrator no longer has the SSH key.
	KeyPair *string `type:"string"`

	// The name of the server that you want to restore.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RestoreServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreServerInput"}
	if s.BackupId == nil {
		invalidParams.Add(request.NewErrParamRequired("BackupId"))
	}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupId sets the BackupId field's value.
func (s *RestoreServerInput) SetBackupId(v string) *RestoreServerInput {
	s.BackupId = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *RestoreServerInput) SetInstanceType(v string) *RestoreServerInput {
	s.InstanceType = &v
	return s
}

// SetKeyPair sets the KeyPair field's value.
func (s *RestoreServerInput) SetKeyPair(v string) *RestoreServerInput {
	s.KeyPair = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *RestoreServerInput) SetServerName(v string) *RestoreServerInput {
	s.ServerName = &v
	return s
}

type RestoreServerOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s RestoreServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RestoreServerOutput) GoString() string {
	return s.String()
}

// Describes a configuration management server.
type Server struct {
	_ struct{} `type:"structure"`

	// Associate a public IP address with a server that you are launching.
	AssociatePublicIpAddress *bool `type:"boolean"`

	// The number of automated backups to keep.
	BackupRetentionCount *int64 `type:"integer"`

	// The ARN of the CloudFormation stack that was used to create the server.
	CloudFormationStackArn *string `type:"string"`

	// Time stamp of server creation. Example 2016-07-29T13:38:47.520Z
	CreatedAt *time.Time `type:"timestamp"`

	// Disables automated backups. The number of stored backups is dependent on
	// the value of PreferredBackupCount.
	DisableAutomatedBackup *bool `type:"boolean"`

	// A DNS name that can be used to access the engine. Example: myserver-asdfghjkl.us-east-1.opsworks.io
	Endpoint *string `type:"string"`

	// The engine type of the server. Valid values in this release include ChefAutomate
	// and Puppet.
	Engine *string `type:"string"`

	// The response of a createServer() request returns the master credential to
	// access the server in EngineAttributes. These credentials are not stored by
	// AWS OpsWorks CM; they are returned only as part of the result of createServer().
	//
	// Attributes returned in a createServer response for Chef
	//
	//    * CHEF_AUTOMATE_PIVOTAL_KEY: A base64-encoded RSA private key that is
	//    generated by AWS OpsWorks for Chef Automate. This private key is required
	//    to access the Chef API.
	//
	//    * CHEF_STARTER_KIT: A base64-encoded ZIP file. The ZIP file contains a
	//    Chef starter kit, which includes a README, a configuration file, and the
	//    required RSA private key. Save this file, unzip it, and then change to
	//    the directory where you've unzipped the file contents. From this directory,
	//    you can run Knife commands.
	//
	// Attributes returned in a createServer response for Puppet
	//
	//    * PUPPET_STARTER_KIT: A base64-encoded ZIP file. The ZIP file contains
	//    a Puppet starter kit, including a README and a required private key. Save
	//    this file, unzip it, and then change to the directory where you've unzipped
	//    the file contents.
	//
	//    * PUPPET_ADMIN_PASSWORD: An administrator password that you can use to
	//    sign in to the Puppet Enterprise console after the server is online.
	EngineAttributes []*EngineAttribute `type:"list"`

	// The engine model of the server. Valid values in this release include Monolithic
	// for Puppet and Single for Chef.
	EngineModel *string `type:"string"`

	// The engine version of the server. For a Chef server, the valid value for
	// EngineVersion is currently 12. For a Puppet server, the valid value is 2017.
	EngineVersion *string `type:"string"`

	// The instance profile ARN of the server.
	InstanceProfileArn *string `type:"string"`

	// The instance type for the server, as specified in the CloudFormation stack.
	// This might not be the same instance type that is shown in the EC2 console.
	InstanceType *string `type:"string"`

	// The key pair associated with the server.
	KeyPair *string `type:"string"`

	// The status of the most recent server maintenance run. Shows SUCCESS or FAILED.
	MaintenanceStatus *string `type:"string" enum:"MaintenanceStatus"`

	// The preferred backup period specified for the server.
	PreferredBackupWindow *string `type:"string"`

	// The preferred maintenance period specified for the server.
	PreferredMaintenanceWindow *string `type:"string"`

	// The security group IDs for the server, as specified in the CloudFormation
	// stack. These might not be the same security groups that are shown in the
	// EC2 console.
	SecurityGroupIds []*string `type:"list"`

	// The ARN of the server.
	ServerArn *string `type:"string"`

	// The name of the server.
	ServerName *string `type:"string"`

	// The service role ARN used to create the server.
	ServiceRoleArn *string `type:"string"`

	// The server's status. This field displays the states of actions in progress,
	// such as creating, running, or backing up the server, as well as the server's
	// health state.
	Status *string `type:"string" enum:"ServerStatus"`

	// Depending on the server status, this field has either a human-readable message
	// (such as a create or backup error), or an escaped block of JSON (used for
	// health check results).
	StatusReason *string `type:"string"`

	// The subnet IDs specified in a CreateServer request.
	SubnetIds []*string `type:"list"`
}

// String returns the string representation
func (s Server) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Server) GoString() string {
	return s.String()
}

// SetAssociatePublicIpAddress sets the AssociatePublicIpAddress field's value.
func (s *Server) SetAssociatePublicIpAddress(v bool) *Server {
	s.AssociatePublicIpAddress = &v
	return s
}

// SetBackupRetentionCount sets the BackupRetentionCount field's value.
func (s *Server) SetBackupRetentionCount(v int64) *Server {
	s.BackupRetentionCount = &v
	return s
}

// SetCloudFormationStackArn sets the CloudFormationStackArn field's value.
func (s *Server) SetCloudFormationStackArn(v string) *Server {
	s.CloudFormationStackArn = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *Server) SetCreatedAt(v time.Time) *Server {
	s.CreatedAt = &v
	return s
}

// SetDisableAutomatedBackup sets the DisableAutomatedBackup field's value.
func (s *Server) SetDisableAutomatedBackup(v bool) *Server {
	s.DisableAutomatedBackup = &v
	return s
}

// SetEndpoint sets the Endpoint field's value.
func (s *Server) SetEndpoint(v string) *Server {
	s.Endpoint = &v
	return s
}

// SetEngine sets the Engine field's value.
func (s *Server) SetEngine(v string) *Server {
	s.Engine = &v
	return s
}

// SetEngineAttributes sets the EngineAttributes field's value.
func (s *Server) SetEngineAttributes(v []*EngineAttribute) *Server {
	s.EngineAttributes = v
	return s
}

// SetEngineModel sets the EngineModel field's value.
func (s *Server) SetEngineModel(v string) *Server {
	s.EngineModel = &v
	return s
}

// SetEngineVersion sets the EngineVersion field's value.
func (s *Server) SetEngineVersion(v string) *Server {
	s.EngineVersion = &v
	return s
}

// SetInstanceProfileArn sets the InstanceProfileArn field's value.
func (s *Server) SetInstanceProfileArn(v string) *Server {
	s.InstanceProfileArn = &v
	return s
}

// SetInstanceType sets the InstanceType field's value.
func (s *Server) SetInstanceType(v string) *Server {
	s.InstanceType = &v
	return s
}

// SetKeyPair sets the KeyPair field's value.
func (s *Server) SetKeyPair(v string) *Server {
	s.KeyPair = &v
	return s
}

// SetMaintenanceStatus sets the MaintenanceStatus field's value.
func (s *Server) SetMaintenanceStatus(v string) *Server {
	s.MaintenanceStatus = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *Server) SetPreferredBackupWindow(v string) *Server {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *Server) SetPreferredMaintenanceWindow(v string) *Server {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *Server) SetSecurityGroupIds(v []*string) *Server {
	s.SecurityGroupIds = v
	return s
}

// SetServerArn sets the ServerArn field's value.
func (s *Server) SetServerArn(v string) *Server {
	s.ServerArn = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *Server) SetServerName(v string) *Server {
	s.ServerName = &v
	return s
}

// SetServiceRoleArn sets the ServiceRoleArn field's value.
func (s *Server) SetServiceRoleArn(v string) *Server {
	s.ServiceRoleArn = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Server) SetStatus(v string) *Server {
	s.Status = &v
	return s
}

// SetStatusReason sets the StatusReason field's value.
func (s *Server) SetStatusReason(v string) *Server {
	s.StatusReason = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *Server) SetSubnetIds(v []*string) *Server {
	s.SubnetIds = v
	return s
}

// An event that is related to the server, such as the start of maintenance
// or backup.
type ServerEvent struct {
	_ struct{} `type:"structure"`

	// The time when the event occurred.
	CreatedAt *time.Time `type:"timestamp"`

	// The Amazon S3 URL of the event's log file.
	LogUrl *string `type:"string"`

	// A human-readable informational or status message.
	Message *string `type:"string"`

	// The name of the server on or for which the event occurred.
	ServerName *string `type:"string"`
}

// String returns the string representation
func (s ServerEvent) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServerEvent) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *ServerEvent) SetCreatedAt(v time.Time) *ServerEvent {
	s.CreatedAt = &v
	return s
}

// SetLogUrl sets the LogUrl field's value.
func (s *ServerEvent) SetLogUrl(v string) *ServerEvent {
	s.LogUrl = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ServerEvent) SetMessage(v string) *ServerEvent {
	s.Message = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *ServerEvent) SetServerName(v string) *ServerEvent {
	s.ServerName = &v
	return s
}

type StartMaintenanceInput struct {
	_ struct{} `type:"structure"`

	// Engine attributes that are specific to the server on which you want to run
	// maintenance.
	EngineAttributes []*EngineAttribute `type:"list"`

	// The name of the server on which to run maintenance.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartMaintenanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMaintenanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartMaintenanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartMaintenanceInput"}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEngineAttributes sets the EngineAttributes field's value.
func (s *StartMaintenanceInput) SetEngineAttributes(v []*EngineAttribute) *StartMaintenanceInput {
	s.EngineAttributes = v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *StartMaintenanceInput) SetServerName(v string) *StartMaintenanceInput {
	s.ServerName = &v
	return s
}

type StartMaintenanceOutput struct {
	_ struct{} `type:"structure"`

	// Contains the response to a StartMaintenance request.
	Server *Server `type:"structure"`
}

// String returns the string representation
func (s StartMaintenanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartMaintenanceOutput) GoString() string {
	return s.String()
}

// SetServer sets the Server field's value.
func (s *StartMaintenanceOutput) SetServer(v *Server) *StartMaintenanceOutput {
	s.Server = v
	return s
}

type UpdateServerEngineAttributesInput struct {
	_ struct{} `type:"structure"`

	// The name of the engine attribute to update.
	//
	// AttributeName is a required field
	AttributeName *string `min:"1" type:"string" required:"true"`

	// The value to set for the attribute.
	AttributeValue *string `type:"string"`

	// The name of the server to update.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServerEngineAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServerEngineAttributesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServerEngineAttributesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServerEngineAttributesInput"}
	if s.AttributeName == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeName"))
	}
	if s.AttributeName != nil && len(*s.AttributeName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeName", 1))
	}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeName sets the AttributeName field's value.
func (s *UpdateServerEngineAttributesInput) SetAttributeName(v string) *UpdateServerEngineAttributesInput {
	s.AttributeName = &v
	return s
}

// SetAttributeValue sets the AttributeValue field's value.
func (s *UpdateServerEngineAttributesInput) SetAttributeValue(v string) *UpdateServerEngineAttributesInput {
	s.AttributeValue = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *UpdateServerEngineAttributesInput) SetServerName(v string) *UpdateServerEngineAttributesInput {
	s.ServerName = &v
	return s
}

type UpdateServerEngineAttributesOutput struct {
	_ struct{} `type:"structure"`

	// Contains the response to an UpdateServerEngineAttributes request.
	Server *Server `type:"structure"`
}

// String returns the string representation
func (s UpdateServerEngineAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServerEngineAttributesOutput) GoString() string {
	return s.String()
}

// SetServer sets the Server field's value.
func (s *UpdateServerEngineAttributesOutput) SetServer(v *Server) *UpdateServerEngineAttributesOutput {
	s.Server = v
	return s
}

type UpdateServerInput struct {
	_ struct{} `type:"structure"`

	// Sets the number of automated backups that you want to keep.
	BackupRetentionCount *int64 `type:"integer"`

	// Setting DisableAutomatedBackup to true disables automated or scheduled backups.
	// Automated backups are enabled by default.
	DisableAutomatedBackup *bool `type:"boolean"`

	// DDD:HH:MM (weekly start time) or HH:MM (daily start time).
	//
	// Time windows always use coordinated universal time (UTC). Valid strings for
	// day of week (DDD) are: Mon, Tue, Wed, Thr, Fri, Sat, or Sun.
	PreferredBackupWindow *string `type:"string"`

	// DDD:HH:MM (weekly start time) or HH:MM (daily start time).
	//
	// Time windows always use coordinated universal time (UTC). Valid strings for
	// day of week (DDD) are: Mon, Tue, Wed, Thr, Fri, Sat, or Sun.
	PreferredMaintenanceWindow *string `type:"string"`

	// The name of the server to update.
	//
	// ServerName is a required field
	ServerName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateServerInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateServerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateServerInput"}
	if s.ServerName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServerName"))
	}
	if s.ServerName != nil && len(*s.ServerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ServerName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBackupRetentionCount sets the BackupRetentionCount field's value.
func (s *UpdateServerInput) SetBackupRetentionCount(v int64) *UpdateServerInput {
	s.BackupRetentionCount = &v
	return s
}

// SetDisableAutomatedBackup sets the DisableAutomatedBackup field's value.
func (s *UpdateServerInput) SetDisableAutomatedBackup(v bool) *UpdateServerInput {
	s.DisableAutomatedBackup = &v
	return s
}

// SetPreferredBackupWindow sets the PreferredBackupWindow field's value.
func (s *UpdateServerInput) SetPreferredBackupWindow(v string) *UpdateServerInput {
	s.PreferredBackupWindow = &v
	return s
}

// SetPreferredMaintenanceWindow sets the PreferredMaintenanceWindow field's value.
func (s *UpdateServerInput) SetPreferredMaintenanceWindow(v string) *UpdateServerInput {
	s.PreferredMaintenanceWindow = &v
	return s
}

// SetServerName sets the ServerName field's value.
func (s *UpdateServerInput) SetServerName(v string) *UpdateServerInput {
	s.ServerName = &v
	return s
}

type UpdateServerOutput struct {
	_ struct{} `type:"structure"`

	// Contains the response to a UpdateServer request.
	Server *Server `type:"structure"`
}

// String returns the string representation
func (s UpdateServerOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateServerOutput) GoString() string {
	return s.String()
}

// SetServer sets the Server field's value.
func (s *UpdateServerOutput) SetServer(v *Server) *UpdateServerOutput {
	s.Server = v
	return s
}

const (
	// BackupStatusInProgress is a BackupStatus enum value
	BackupStatusInProgress = "IN_PROGRESS"

	// BackupStatusOk is a BackupStatus enum value
	BackupStatusOk = "OK"

	// BackupStatusFailed is a BackupStatus enum value
	BackupStatusFailed = "FAILED"

	// BackupStatusDeleting is a BackupStatus enum value
	BackupStatusDeleting = "DELETING"
)

const (
	// BackupTypeAutomated is a BackupType enum value
	BackupTypeAutomated = "AUTOMATED"

	// BackupTypeManual is a BackupType enum value
	BackupTypeManual = "MANUAL"
)

const (
	// MaintenanceStatusSuccess is a MaintenanceStatus enum value
	MaintenanceStatusSuccess = "SUCCESS"

	// MaintenanceStatusFailed is a MaintenanceStatus enum value
	MaintenanceStatusFailed = "FAILED"
)

// The status of the association or disassociation request.
//
// Possible values:
//
//    * SUCCESS: The association or disassociation succeeded.
//
//    * FAILED: The association or disassociation failed.
//
//    * IN_PROGRESS: The association or disassociation is still in progress.
const (
	// NodeAssociationStatusSuccess is a NodeAssociationStatus enum value
	NodeAssociationStatusSuccess = "SUCCESS"

	// NodeAssociationStatusFailed is a NodeAssociationStatus enum value
	NodeAssociationStatusFailed = "FAILED"

	// NodeAssociationStatusInProgress is a NodeAssociationStatus enum value
	NodeAssociationStatusInProgress = "IN_PROGRESS"
)

const (
	// ServerStatusBackingUp is a ServerStatus enum value
	ServerStatusBackingUp = "BACKING_UP"

	// ServerStatusConnectionLost is a ServerStatus enum value
	ServerStatusConnectionLost = "CONNECTION_LOST"

	// ServerStatusCreating is a ServerStatus enum value
	ServerStatusCreating = "CREATING"

	// ServerStatusDeleting is a ServerStatus enum value
	ServerStatusDeleting = "DELETING"

	// ServerStatusModifying is a ServerStatus enum value
	ServerStatusModifying = "MODIFYING"

	// ServerStatusFailed is a ServerStatus enum value
	ServerStatusFailed = "FAILED"

	// ServerStatusHealthy is a ServerStatus enum value
	ServerStatusHealthy = "HEALTHY"

	// ServerStatusRunning is a ServerStatus enum value
	ServerStatusRunning = "RUNNING"

	// ServerStatusRestoring is a ServerStatus enum value
	ServerStatusRestoring = "RESTORING"

	// ServerStatusSetup is a ServerStatus enum value
	ServerStatusSetup = "SETUP"

	// ServerStatusUnderMaintenance is a ServerStatus enum value
	ServerStatusUnderMaintenance = "UNDER_MAINTENANCE"

	// ServerStatusUnhealthy is a ServerStatus enum value
	ServerStatusUnhealthy = "UNHEALTHY"

	// ServerStatusTerminated is a ServerStatus enum value
	ServerStatusTerminated = "TERMINATED"
)
