// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/common/extensions.proto

package common // import "google.golang.org/genproto/googleapis/ads/googleads/v1/common"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Represents an App extension.
type AppFeedItem struct {
	// The visible text displayed when the link is rendered in an ad.
	// The length of this string should be between 1 and 25, inclusive.
	LinkText *wrappers.StringValue `protobuf:"bytes,1,opt,name=link_text,json=linkText,proto3" json:"link_text,omitempty"`
	// The store-specific ID for the target application.
	// This string must not be empty.
	AppId *wrappers.StringValue `protobuf:"bytes,2,opt,name=app_id,json=appId,proto3" json:"app_id,omitempty"`
	// The application store that the target application belongs to.
	AppStore enums.AppStoreEnum_AppStore `protobuf:"varint,3,opt,name=app_store,json=appStore,proto3,enum=google.ads.googleads.v1.enums.AppStoreEnum_AppStore" json:"app_store,omitempty"`
	// A list of possible final URLs after all cross domain redirects.
	FinalUrls []*wrappers.StringValue `protobuf:"bytes,4,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// A list of possible final mobile URLs after all cross domain redirects.
	FinalMobileUrls []*wrappers.StringValue `protobuf:"bytes,5,rep,name=final_mobile_urls,json=finalMobileUrls,proto3" json:"final_mobile_urls,omitempty"`
	// URL template for constructing a tracking URL. Default value is "{lpurl}".
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,6,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// A list of mappings to be used for substituting URL custom parameter tags in
	// the tracking_url_template, final_urls, and/or final_mobile_urls.
	UrlCustomParameters []*CustomParameter `protobuf:"bytes,7,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// URL template for appending params to landing page URLs served with parallel
	// tracking.
	FinalUrlSuffix       *wrappers.StringValue `protobuf:"bytes,8,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *AppFeedItem) Reset()         { *m = AppFeedItem{} }
func (m *AppFeedItem) String() string { return proto.CompactTextString(m) }
func (*AppFeedItem) ProtoMessage()    {}
func (*AppFeedItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_extensions_29e88682b0f69f9b, []int{0}
}
func (m *AppFeedItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AppFeedItem.Unmarshal(m, b)
}
func (m *AppFeedItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AppFeedItem.Marshal(b, m, deterministic)
}
func (dst *AppFeedItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AppFeedItem.Merge(dst, src)
}
func (m *AppFeedItem) XXX_Size() int {
	return xxx_messageInfo_AppFeedItem.Size(m)
}
func (m *AppFeedItem) XXX_DiscardUnknown() {
	xxx_messageInfo_AppFeedItem.DiscardUnknown(m)
}

var xxx_messageInfo_AppFeedItem proto.InternalMessageInfo

func (m *AppFeedItem) GetLinkText() *wrappers.StringValue {
	if m != nil {
		return m.LinkText
	}
	return nil
}

func (m *AppFeedItem) GetAppId() *wrappers.StringValue {
	if m != nil {
		return m.AppId
	}
	return nil
}

func (m *AppFeedItem) GetAppStore() enums.AppStoreEnum_AppStore {
	if m != nil {
		return m.AppStore
	}
	return enums.AppStoreEnum_UNSPECIFIED
}

func (m *AppFeedItem) GetFinalUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalUrls
	}
	return nil
}

func (m *AppFeedItem) GetFinalMobileUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalMobileUrls
	}
	return nil
}

func (m *AppFeedItem) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *AppFeedItem) GetUrlCustomParameters() []*CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

func (m *AppFeedItem) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

// Represents a Call extension.
type CallFeedItem struct {
	// The advertiser's phone number to append to the ad.
	// This string must not be empty.
	PhoneNumber *wrappers.StringValue `protobuf:"bytes,1,opt,name=phone_number,json=phoneNumber,proto3" json:"phone_number,omitempty"`
	// Uppercase two-letter country code of the advertiser's phone number.
	// This string must not be empty.
	CountryCode *wrappers.StringValue `protobuf:"bytes,2,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// Indicates whether call tracking is enabled. By default, call tracking is
	// not enabled.
	CallTrackingEnabled *wrappers.BoolValue `protobuf:"bytes,3,opt,name=call_tracking_enabled,json=callTrackingEnabled,proto3" json:"call_tracking_enabled,omitempty"`
	// The conversion action to attribute a call conversion to. If not set a
	// default conversion action is used. This field only has effect if
	// call_tracking_enabled is set to true. Otherwise this field is ignored.
	CallConversionAction *wrappers.StringValue `protobuf:"bytes,4,opt,name=call_conversion_action,json=callConversionAction,proto3" json:"call_conversion_action,omitempty"`
	// If true, disable call conversion tracking. call_conversion_action should
	// not be set if this is true. Optional.
	CallConversionTrackingDisabled *wrappers.BoolValue `protobuf:"bytes,5,opt,name=call_conversion_tracking_disabled,json=callConversionTrackingDisabled,proto3" json:"call_conversion_tracking_disabled,omitempty"`
	// Enum value that indicates whether this call extension uses its own call
	// conversion setting (or just have call conversion disabled), or following
	// the account level setting.
	CallConversionReportingState enums.CallConversionReportingStateEnum_CallConversionReportingState `protobuf:"varint,6,opt,name=call_conversion_reporting_state,json=callConversionReportingState,proto3,enum=google.ads.googleads.v1.enums.CallConversionReportingStateEnum_CallConversionReportingState" json:"call_conversion_reporting_state,omitempty"`
	XXX_NoUnkeyedLiteral         struct{}                                                            `json:"-"`
	XXX_unrecognized             []byte                                                              `json:"-"`
	XXX_sizecache                int32                                                               `json:"-"`
}

func (m *CallFeedItem) Reset()         { *m = CallFeedItem{} }
func (m *CallFeedItem) String() string { return proto.CompactTextString(m) }
func (*CallFeedItem) ProtoMessage()    {}
func (*CallFeedItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_extensions_29e88682b0f69f9b, []int{1}
}
func (m *CallFeedItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CallFeedItem.Unmarshal(m, b)
}
func (m *CallFeedItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CallFeedItem.Marshal(b, m, deterministic)
}
func (dst *CallFeedItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CallFeedItem.Merge(dst, src)
}
func (m *CallFeedItem) XXX_Size() int {
	return xxx_messageInfo_CallFeedItem.Size(m)
}
func (m *CallFeedItem) XXX_DiscardUnknown() {
	xxx_messageInfo_CallFeedItem.DiscardUnknown(m)
}

var xxx_messageInfo_CallFeedItem proto.InternalMessageInfo

func (m *CallFeedItem) GetPhoneNumber() *wrappers.StringValue {
	if m != nil {
		return m.PhoneNumber
	}
	return nil
}

func (m *CallFeedItem) GetCountryCode() *wrappers.StringValue {
	if m != nil {
		return m.CountryCode
	}
	return nil
}

func (m *CallFeedItem) GetCallTrackingEnabled() *wrappers.BoolValue {
	if m != nil {
		return m.CallTrackingEnabled
	}
	return nil
}

func (m *CallFeedItem) GetCallConversionAction() *wrappers.StringValue {
	if m != nil {
		return m.CallConversionAction
	}
	return nil
}

func (m *CallFeedItem) GetCallConversionTrackingDisabled() *wrappers.BoolValue {
	if m != nil {
		return m.CallConversionTrackingDisabled
	}
	return nil
}

func (m *CallFeedItem) GetCallConversionReportingState() enums.CallConversionReportingStateEnum_CallConversionReportingState {
	if m != nil {
		return m.CallConversionReportingState
	}
	return enums.CallConversionReportingStateEnum_UNSPECIFIED
}

// Represents a callout extension.
type CalloutFeedItem struct {
	// The callout text.
	// The length of this string should be between 1 and 25, inclusive.
	CalloutText          *wrappers.StringValue `protobuf:"bytes,1,opt,name=callout_text,json=calloutText,proto3" json:"callout_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *CalloutFeedItem) Reset()         { *m = CalloutFeedItem{} }
func (m *CalloutFeedItem) String() string { return proto.CompactTextString(m) }
func (*CalloutFeedItem) ProtoMessage()    {}
func (*CalloutFeedItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_extensions_29e88682b0f69f9b, []int{2}
}
func (m *CalloutFeedItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CalloutFeedItem.Unmarshal(m, b)
}
func (m *CalloutFeedItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CalloutFeedItem.Marshal(b, m, deterministic)
}
func (dst *CalloutFeedItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CalloutFeedItem.Merge(dst, src)
}
func (m *CalloutFeedItem) XXX_Size() int {
	return xxx_messageInfo_CalloutFeedItem.Size(m)
}
func (m *CalloutFeedItem) XXX_DiscardUnknown() {
	xxx_messageInfo_CalloutFeedItem.DiscardUnknown(m)
}

var xxx_messageInfo_CalloutFeedItem proto.InternalMessageInfo

func (m *CalloutFeedItem) GetCalloutText() *wrappers.StringValue {
	if m != nil {
		return m.CalloutText
	}
	return nil
}

// Represents a location extension.
type LocationFeedItem struct {
	// The name of the business.
	BusinessName *wrappers.StringValue `protobuf:"bytes,1,opt,name=business_name,json=businessName,proto3" json:"business_name,omitempty"`
	// Line 1 of the business address.
	AddressLine_1 *wrappers.StringValue `protobuf:"bytes,2,opt,name=address_line_1,json=addressLine1,proto3" json:"address_line_1,omitempty"`
	// Line 2 of the business address.
	AddressLine_2 *wrappers.StringValue `protobuf:"bytes,3,opt,name=address_line_2,json=addressLine2,proto3" json:"address_line_2,omitempty"`
	// City of the business address.
	City *wrappers.StringValue `protobuf:"bytes,4,opt,name=city,proto3" json:"city,omitempty"`
	// Province of the business address.
	Province *wrappers.StringValue `protobuf:"bytes,5,opt,name=province,proto3" json:"province,omitempty"`
	// Postal code of the business address.
	PostalCode *wrappers.StringValue `protobuf:"bytes,6,opt,name=postal_code,json=postalCode,proto3" json:"postal_code,omitempty"`
	// Country code of the business address.
	CountryCode *wrappers.StringValue `protobuf:"bytes,7,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// Phone number of the business.
	PhoneNumber          *wrappers.StringValue `protobuf:"bytes,8,opt,name=phone_number,json=phoneNumber,proto3" json:"phone_number,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *LocationFeedItem) Reset()         { *m = LocationFeedItem{} }
func (m *LocationFeedItem) String() string { return proto.CompactTextString(m) }
func (*LocationFeedItem) ProtoMessage()    {}
func (*LocationFeedItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_extensions_29e88682b0f69f9b, []int{3}
}
func (m *LocationFeedItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_LocationFeedItem.Unmarshal(m, b)
}
func (m *LocationFeedItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_LocationFeedItem.Marshal(b, m, deterministic)
}
func (dst *LocationFeedItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_LocationFeedItem.Merge(dst, src)
}
func (m *LocationFeedItem) XXX_Size() int {
	return xxx_messageInfo_LocationFeedItem.Size(m)
}
func (m *LocationFeedItem) XXX_DiscardUnknown() {
	xxx_messageInfo_LocationFeedItem.DiscardUnknown(m)
}

var xxx_messageInfo_LocationFeedItem proto.InternalMessageInfo

func (m *LocationFeedItem) GetBusinessName() *wrappers.StringValue {
	if m != nil {
		return m.BusinessName
	}
	return nil
}

func (m *LocationFeedItem) GetAddressLine_1() *wrappers.StringValue {
	if m != nil {
		return m.AddressLine_1
	}
	return nil
}

func (m *LocationFeedItem) GetAddressLine_2() *wrappers.StringValue {
	if m != nil {
		return m.AddressLine_2
	}
	return nil
}

func (m *LocationFeedItem) GetCity() *wrappers.StringValue {
	if m != nil {
		return m.City
	}
	return nil
}

func (m *LocationFeedItem) GetProvince() *wrappers.StringValue {
	if m != nil {
		return m.Province
	}
	return nil
}

func (m *LocationFeedItem) GetPostalCode() *wrappers.StringValue {
	if m != nil {
		return m.PostalCode
	}
	return nil
}

func (m *LocationFeedItem) GetCountryCode() *wrappers.StringValue {
	if m != nil {
		return m.CountryCode
	}
	return nil
}

func (m *LocationFeedItem) GetPhoneNumber() *wrappers.StringValue {
	if m != nil {
		return m.PhoneNumber
	}
	return nil
}

// Represents an affiliate location extension.
type AffiliateLocationFeedItem struct {
	// The name of the business.
	BusinessName *wrappers.StringValue `protobuf:"bytes,1,opt,name=business_name,json=businessName,proto3" json:"business_name,omitempty"`
	// Line 1 of the business address.
	AddressLine_1 *wrappers.StringValue `protobuf:"bytes,2,opt,name=address_line_1,json=addressLine1,proto3" json:"address_line_1,omitempty"`
	// Line 2 of the business address.
	AddressLine_2 *wrappers.StringValue `protobuf:"bytes,3,opt,name=address_line_2,json=addressLine2,proto3" json:"address_line_2,omitempty"`
	// City of the business address.
	City *wrappers.StringValue `protobuf:"bytes,4,opt,name=city,proto3" json:"city,omitempty"`
	// Province of the business address.
	Province *wrappers.StringValue `protobuf:"bytes,5,opt,name=province,proto3" json:"province,omitempty"`
	// Postal code of the business address.
	PostalCode *wrappers.StringValue `protobuf:"bytes,6,opt,name=postal_code,json=postalCode,proto3" json:"postal_code,omitempty"`
	// Country code of the business address.
	CountryCode *wrappers.StringValue `protobuf:"bytes,7,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// Phone number of the business.
	PhoneNumber *wrappers.StringValue `protobuf:"bytes,8,opt,name=phone_number,json=phoneNumber,proto3" json:"phone_number,omitempty"`
	// Id of the retail chain that is advertised as a seller of your product.
	ChainId *wrappers.Int64Value `protobuf:"bytes,9,opt,name=chain_id,json=chainId,proto3" json:"chain_id,omitempty"`
	// Name of chain.
	ChainName            *wrappers.StringValue `protobuf:"bytes,10,opt,name=chain_name,json=chainName,proto3" json:"chain_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *AffiliateLocationFeedItem) Reset()         { *m = AffiliateLocationFeedItem{} }
func (m *AffiliateLocationFeedItem) String() string { return proto.CompactTextString(m) }
func (*AffiliateLocationFeedItem) ProtoMessage()    {}
func (*AffiliateLocationFeedItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_extensions_29e88682b0f69f9b, []int{4}
}
func (m *AffiliateLocationFeedItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AffiliateLocationFeedItem.Unmarshal(m, b)
}
func (m *AffiliateLocationFeedItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AffiliateLocationFeedItem.Marshal(b, m, deterministic)
}
func (dst *AffiliateLocationFeedItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AffiliateLocationFeedItem.Merge(dst, src)
}
func (m *AffiliateLocationFeedItem) XXX_Size() int {
	return xxx_messageInfo_AffiliateLocationFeedItem.Size(m)
}
func (m *AffiliateLocationFeedItem) XXX_DiscardUnknown() {
	xxx_messageInfo_AffiliateLocationFeedItem.DiscardUnknown(m)
}

var xxx_messageInfo_AffiliateLocationFeedItem proto.InternalMessageInfo

func (m *AffiliateLocationFeedItem) GetBusinessName() *wrappers.StringValue {
	if m != nil {
		return m.BusinessName
	}
	return nil
}

func (m *AffiliateLocationFeedItem) GetAddressLine_1() *wrappers.StringValue {
	if m != nil {
		return m.AddressLine_1
	}
	return nil
}

func (m *AffiliateLocationFeedItem) GetAddressLine_2() *wrappers.StringValue {
	if m != nil {
		return m.AddressLine_2
	}
	return nil
}

func (m *AffiliateLocationFeedItem) GetCity() *wrappers.StringValue {
	if m != nil {
		return m.City
	}
	return nil
}

func (m *AffiliateLocationFeedItem) GetProvince() *wrappers.StringValue {
	if m != nil {
		return m.Province
	}
	return nil
}

func (m *AffiliateLocationFeedItem) GetPostalCode() *wrappers.StringValue {
	if m != nil {
		return m.PostalCode
	}
	return nil
}

func (m *AffiliateLocationFeedItem) GetCountryCode() *wrappers.StringValue {
	if m != nil {
		return m.CountryCode
	}
	return nil
}

func (m *AffiliateLocationFeedItem) GetPhoneNumber() *wrappers.StringValue {
	if m != nil {
		return m.PhoneNumber
	}
	return nil
}

func (m *AffiliateLocationFeedItem) GetChainId() *wrappers.Int64Value {
	if m != nil {
		return m.ChainId
	}
	return nil
}

func (m *AffiliateLocationFeedItem) GetChainName() *wrappers.StringValue {
	if m != nil {
		return m.ChainName
	}
	return nil
}

// An extension that users can click on to send a text message to the
// advertiser.
type TextMessageFeedItem struct {
	// The business name to prepend to the message text.
	// This field is required.
	BusinessName *wrappers.StringValue `protobuf:"bytes,1,opt,name=business_name,json=businessName,proto3" json:"business_name,omitempty"`
	// Uppercase two-letter country code of the advertiser's phone number.
	// This field is required.
	CountryCode *wrappers.StringValue `protobuf:"bytes,2,opt,name=country_code,json=countryCode,proto3" json:"country_code,omitempty"`
	// The advertiser's phone number the message will be sent to. Required.
	PhoneNumber *wrappers.StringValue `protobuf:"bytes,3,opt,name=phone_number,json=phoneNumber,proto3" json:"phone_number,omitempty"`
	// The text to show in the ad.
	// This field is required.
	Text *wrappers.StringValue `protobuf:"bytes,4,opt,name=text,proto3" json:"text,omitempty"`
	// The message text populated in the messaging app.
	ExtensionText        *wrappers.StringValue `protobuf:"bytes,5,opt,name=extension_text,json=extensionText,proto3" json:"extension_text,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *TextMessageFeedItem) Reset()         { *m = TextMessageFeedItem{} }
func (m *TextMessageFeedItem) String() string { return proto.CompactTextString(m) }
func (*TextMessageFeedItem) ProtoMessage()    {}
func (*TextMessageFeedItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_extensions_29e88682b0f69f9b, []int{5}
}
func (m *TextMessageFeedItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_TextMessageFeedItem.Unmarshal(m, b)
}
func (m *TextMessageFeedItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_TextMessageFeedItem.Marshal(b, m, deterministic)
}
func (dst *TextMessageFeedItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_TextMessageFeedItem.Merge(dst, src)
}
func (m *TextMessageFeedItem) XXX_Size() int {
	return xxx_messageInfo_TextMessageFeedItem.Size(m)
}
func (m *TextMessageFeedItem) XXX_DiscardUnknown() {
	xxx_messageInfo_TextMessageFeedItem.DiscardUnknown(m)
}

var xxx_messageInfo_TextMessageFeedItem proto.InternalMessageInfo

func (m *TextMessageFeedItem) GetBusinessName() *wrappers.StringValue {
	if m != nil {
		return m.BusinessName
	}
	return nil
}

func (m *TextMessageFeedItem) GetCountryCode() *wrappers.StringValue {
	if m != nil {
		return m.CountryCode
	}
	return nil
}

func (m *TextMessageFeedItem) GetPhoneNumber() *wrappers.StringValue {
	if m != nil {
		return m.PhoneNumber
	}
	return nil
}

func (m *TextMessageFeedItem) GetText() *wrappers.StringValue {
	if m != nil {
		return m.Text
	}
	return nil
}

func (m *TextMessageFeedItem) GetExtensionText() *wrappers.StringValue {
	if m != nil {
		return m.ExtensionText
	}
	return nil
}

// Represents a Price extension.
type PriceFeedItem struct {
	// Price extension type of this extension.
	Type enums.PriceExtensionTypeEnum_PriceExtensionType `protobuf:"varint,1,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.PriceExtensionTypeEnum_PriceExtensionType" json:"type,omitempty"`
	// Price qualifier for all offers of this price extension.
	PriceQualifier enums.PriceExtensionPriceQualifierEnum_PriceExtensionPriceQualifier `protobuf:"varint,2,opt,name=price_qualifier,json=priceQualifier,proto3,enum=google.ads.googleads.v1.enums.PriceExtensionPriceQualifierEnum_PriceExtensionPriceQualifier" json:"price_qualifier,omitempty"`
	// Tracking URL template for all offers of this price extension.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,3,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The code of the language used for this price extension.
	LanguageCode *wrappers.StringValue `protobuf:"bytes,4,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// The price offerings in this price extension.
	PriceOfferings []*PriceOffer `protobuf:"bytes,5,rep,name=price_offerings,json=priceOfferings,proto3" json:"price_offerings,omitempty"`
	// URL template for appending params to landing page URLs served with parallel
	// tracking.
	FinalUrlSuffix       *wrappers.StringValue `protobuf:"bytes,6,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *PriceFeedItem) Reset()         { *m = PriceFeedItem{} }
func (m *PriceFeedItem) String() string { return proto.CompactTextString(m) }
func (*PriceFeedItem) ProtoMessage()    {}
func (*PriceFeedItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_extensions_29e88682b0f69f9b, []int{6}
}
func (m *PriceFeedItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PriceFeedItem.Unmarshal(m, b)
}
func (m *PriceFeedItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PriceFeedItem.Marshal(b, m, deterministic)
}
func (dst *PriceFeedItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PriceFeedItem.Merge(dst, src)
}
func (m *PriceFeedItem) XXX_Size() int {
	return xxx_messageInfo_PriceFeedItem.Size(m)
}
func (m *PriceFeedItem) XXX_DiscardUnknown() {
	xxx_messageInfo_PriceFeedItem.DiscardUnknown(m)
}

var xxx_messageInfo_PriceFeedItem proto.InternalMessageInfo

func (m *PriceFeedItem) GetType() enums.PriceExtensionTypeEnum_PriceExtensionType {
	if m != nil {
		return m.Type
	}
	return enums.PriceExtensionTypeEnum_UNSPECIFIED
}

func (m *PriceFeedItem) GetPriceQualifier() enums.PriceExtensionPriceQualifierEnum_PriceExtensionPriceQualifier {
	if m != nil {
		return m.PriceQualifier
	}
	return enums.PriceExtensionPriceQualifierEnum_UNSPECIFIED
}

func (m *PriceFeedItem) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *PriceFeedItem) GetLanguageCode() *wrappers.StringValue {
	if m != nil {
		return m.LanguageCode
	}
	return nil
}

func (m *PriceFeedItem) GetPriceOfferings() []*PriceOffer {
	if m != nil {
		return m.PriceOfferings
	}
	return nil
}

func (m *PriceFeedItem) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

// Represents one price offer in a price extension.
type PriceOffer struct {
	// Header text of this offer.
	Header *wrappers.StringValue `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// Description text of this offer.
	Description *wrappers.StringValue `protobuf:"bytes,2,opt,name=description,proto3" json:"description,omitempty"`
	// Price value of this offer.
	Price *Money `protobuf:"bytes,3,opt,name=price,proto3" json:"price,omitempty"`
	// Price unit for this offer.
	Unit enums.PriceExtensionPriceUnitEnum_PriceExtensionPriceUnit `protobuf:"varint,4,opt,name=unit,proto3,enum=google.ads.googleads.v1.enums.PriceExtensionPriceUnitEnum_PriceExtensionPriceUnit" json:"unit,omitempty"`
	// A list of possible final URLs after all cross domain redirects.
	FinalUrls []*wrappers.StringValue `protobuf:"bytes,5,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// A list of possible final mobile URLs after all cross domain redirects.
	FinalMobileUrls      []*wrappers.StringValue `protobuf:"bytes,6,rep,name=final_mobile_urls,json=finalMobileUrls,proto3" json:"final_mobile_urls,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *PriceOffer) Reset()         { *m = PriceOffer{} }
func (m *PriceOffer) String() string { return proto.CompactTextString(m) }
func (*PriceOffer) ProtoMessage()    {}
func (*PriceOffer) Descriptor() ([]byte, []int) {
	return fileDescriptor_extensions_29e88682b0f69f9b, []int{7}
}
func (m *PriceOffer) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PriceOffer.Unmarshal(m, b)
}
func (m *PriceOffer) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PriceOffer.Marshal(b, m, deterministic)
}
func (dst *PriceOffer) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PriceOffer.Merge(dst, src)
}
func (m *PriceOffer) XXX_Size() int {
	return xxx_messageInfo_PriceOffer.Size(m)
}
func (m *PriceOffer) XXX_DiscardUnknown() {
	xxx_messageInfo_PriceOffer.DiscardUnknown(m)
}

var xxx_messageInfo_PriceOffer proto.InternalMessageInfo

func (m *PriceOffer) GetHeader() *wrappers.StringValue {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *PriceOffer) GetDescription() *wrappers.StringValue {
	if m != nil {
		return m.Description
	}
	return nil
}

func (m *PriceOffer) GetPrice() *Money {
	if m != nil {
		return m.Price
	}
	return nil
}

func (m *PriceOffer) GetUnit() enums.PriceExtensionPriceUnitEnum_PriceExtensionPriceUnit {
	if m != nil {
		return m.Unit
	}
	return enums.PriceExtensionPriceUnitEnum_UNSPECIFIED
}

func (m *PriceOffer) GetFinalUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalUrls
	}
	return nil
}

func (m *PriceOffer) GetFinalMobileUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalMobileUrls
	}
	return nil
}

// Represents a Promotion extension.
type PromotionFeedItem struct {
	// A freeform description of what the promotion is targeting.
	// This field is required.
	PromotionTarget *wrappers.StringValue `protobuf:"bytes,1,opt,name=promotion_target,json=promotionTarget,proto3" json:"promotion_target,omitempty"`
	// Enum that modifies the qualification of the discount.
	DiscountModifier enums.PromotionExtensionDiscountModifierEnum_PromotionExtensionDiscountModifier `protobuf:"varint,2,opt,name=discount_modifier,json=discountModifier,proto3,enum=google.ads.googleads.v1.enums.PromotionExtensionDiscountModifierEnum_PromotionExtensionDiscountModifier" json:"discount_modifier,omitempty"`
	// Start date of when the promotion is eligible to be redeemed.
	PromotionStartDate *wrappers.StringValue `protobuf:"bytes,7,opt,name=promotion_start_date,json=promotionStartDate,proto3" json:"promotion_start_date,omitempty"`
	// End date of when the promotion is eligible to be redeemed.
	PromotionEndDate *wrappers.StringValue `protobuf:"bytes,8,opt,name=promotion_end_date,json=promotionEndDate,proto3" json:"promotion_end_date,omitempty"`
	// The occasion the promotion was intended for.
	// If an occasion is set, the redemption window will need to fall within
	// the date range associated with the occasion.
	Occasion enums.PromotionExtensionOccasionEnum_PromotionExtensionOccasion `protobuf:"varint,9,opt,name=occasion,proto3,enum=google.ads.googleads.v1.enums.PromotionExtensionOccasionEnum_PromotionExtensionOccasion" json:"occasion,omitempty"`
	// A list of possible final URLs after all cross domain redirects.
	// This field is required.
	FinalUrls []*wrappers.StringValue `protobuf:"bytes,10,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// A list of possible final mobile URLs after all cross domain redirects.
	FinalMobileUrls []*wrappers.StringValue `protobuf:"bytes,11,rep,name=final_mobile_urls,json=finalMobileUrls,proto3" json:"final_mobile_urls,omitempty"`
	// URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,12,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// A list of mappings to be used for substituting URL custom parameter tags in
	// the tracking_url_template, final_urls, and/or final_mobile_urls.
	UrlCustomParameters []*CustomParameter `protobuf:"bytes,13,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// URL template for appending params to landing page URLs served with parallel
	// tracking.
	FinalUrlSuffix *wrappers.StringValue `protobuf:"bytes,14,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	// The language of the promotion.
	// Represented as BCP 47 language tag.
	LanguageCode *wrappers.StringValue `protobuf:"bytes,15,opt,name=language_code,json=languageCode,proto3" json:"language_code,omitempty"`
	// Discount type, can be percentage off or amount off.
	//
	// Types that are valid to be assigned to DiscountType:
	//	*PromotionFeedItem_PercentOff
	//	*PromotionFeedItem_MoneyAmountOff
	DiscountType isPromotionFeedItem_DiscountType `protobuf_oneof:"discount_type"`
	// Promotion trigger. Can be by promotion code or promo by eligible order
	// amount.
	//
	// Types that are valid to be assigned to PromotionTrigger:
	//	*PromotionFeedItem_PromotionCode
	//	*PromotionFeedItem_OrdersOverAmount
	PromotionTrigger     isPromotionFeedItem_PromotionTrigger `protobuf_oneof:"promotion_trigger"`
	XXX_NoUnkeyedLiteral struct{}                             `json:"-"`
	XXX_unrecognized     []byte                               `json:"-"`
	XXX_sizecache        int32                                `json:"-"`
}

func (m *PromotionFeedItem) Reset()         { *m = PromotionFeedItem{} }
func (m *PromotionFeedItem) String() string { return proto.CompactTextString(m) }
func (*PromotionFeedItem) ProtoMessage()    {}
func (*PromotionFeedItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_extensions_29e88682b0f69f9b, []int{8}
}
func (m *PromotionFeedItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PromotionFeedItem.Unmarshal(m, b)
}
func (m *PromotionFeedItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PromotionFeedItem.Marshal(b, m, deterministic)
}
func (dst *PromotionFeedItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PromotionFeedItem.Merge(dst, src)
}
func (m *PromotionFeedItem) XXX_Size() int {
	return xxx_messageInfo_PromotionFeedItem.Size(m)
}
func (m *PromotionFeedItem) XXX_DiscardUnknown() {
	xxx_messageInfo_PromotionFeedItem.DiscardUnknown(m)
}

var xxx_messageInfo_PromotionFeedItem proto.InternalMessageInfo

func (m *PromotionFeedItem) GetPromotionTarget() *wrappers.StringValue {
	if m != nil {
		return m.PromotionTarget
	}
	return nil
}

func (m *PromotionFeedItem) GetDiscountModifier() enums.PromotionExtensionDiscountModifierEnum_PromotionExtensionDiscountModifier {
	if m != nil {
		return m.DiscountModifier
	}
	return enums.PromotionExtensionDiscountModifierEnum_UNSPECIFIED
}

func (m *PromotionFeedItem) GetPromotionStartDate() *wrappers.StringValue {
	if m != nil {
		return m.PromotionStartDate
	}
	return nil
}

func (m *PromotionFeedItem) GetPromotionEndDate() *wrappers.StringValue {
	if m != nil {
		return m.PromotionEndDate
	}
	return nil
}

func (m *PromotionFeedItem) GetOccasion() enums.PromotionExtensionOccasionEnum_PromotionExtensionOccasion {
	if m != nil {
		return m.Occasion
	}
	return enums.PromotionExtensionOccasionEnum_UNSPECIFIED
}

func (m *PromotionFeedItem) GetFinalUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalUrls
	}
	return nil
}

func (m *PromotionFeedItem) GetFinalMobileUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalMobileUrls
	}
	return nil
}

func (m *PromotionFeedItem) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *PromotionFeedItem) GetUrlCustomParameters() []*CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

func (m *PromotionFeedItem) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

func (m *PromotionFeedItem) GetLanguageCode() *wrappers.StringValue {
	if m != nil {
		return m.LanguageCode
	}
	return nil
}

type isPromotionFeedItem_DiscountType interface {
	isPromotionFeedItem_DiscountType()
}

type PromotionFeedItem_PercentOff struct {
	PercentOff *wrappers.Int64Value `protobuf:"bytes,3,opt,name=percent_off,json=percentOff,proto3,oneof"`
}

type PromotionFeedItem_MoneyAmountOff struct {
	MoneyAmountOff *Money `protobuf:"bytes,4,opt,name=money_amount_off,json=moneyAmountOff,proto3,oneof"`
}

func (*PromotionFeedItem_PercentOff) isPromotionFeedItem_DiscountType() {}

func (*PromotionFeedItem_MoneyAmountOff) isPromotionFeedItem_DiscountType() {}

func (m *PromotionFeedItem) GetDiscountType() isPromotionFeedItem_DiscountType {
	if m != nil {
		return m.DiscountType
	}
	return nil
}

func (m *PromotionFeedItem) GetPercentOff() *wrappers.Int64Value {
	if x, ok := m.GetDiscountType().(*PromotionFeedItem_PercentOff); ok {
		return x.PercentOff
	}
	return nil
}

func (m *PromotionFeedItem) GetMoneyAmountOff() *Money {
	if x, ok := m.GetDiscountType().(*PromotionFeedItem_MoneyAmountOff); ok {
		return x.MoneyAmountOff
	}
	return nil
}

type isPromotionFeedItem_PromotionTrigger interface {
	isPromotionFeedItem_PromotionTrigger()
}

type PromotionFeedItem_PromotionCode struct {
	PromotionCode *wrappers.StringValue `protobuf:"bytes,5,opt,name=promotion_code,json=promotionCode,proto3,oneof"`
}

type PromotionFeedItem_OrdersOverAmount struct {
	OrdersOverAmount *Money `protobuf:"bytes,6,opt,name=orders_over_amount,json=ordersOverAmount,proto3,oneof"`
}

func (*PromotionFeedItem_PromotionCode) isPromotionFeedItem_PromotionTrigger() {}

func (*PromotionFeedItem_OrdersOverAmount) isPromotionFeedItem_PromotionTrigger() {}

func (m *PromotionFeedItem) GetPromotionTrigger() isPromotionFeedItem_PromotionTrigger {
	if m != nil {
		return m.PromotionTrigger
	}
	return nil
}

func (m *PromotionFeedItem) GetPromotionCode() *wrappers.StringValue {
	if x, ok := m.GetPromotionTrigger().(*PromotionFeedItem_PromotionCode); ok {
		return x.PromotionCode
	}
	return nil
}

func (m *PromotionFeedItem) GetOrdersOverAmount() *Money {
	if x, ok := m.GetPromotionTrigger().(*PromotionFeedItem_OrdersOverAmount); ok {
		return x.OrdersOverAmount
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*PromotionFeedItem) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _PromotionFeedItem_OneofMarshaler, _PromotionFeedItem_OneofUnmarshaler, _PromotionFeedItem_OneofSizer, []interface{}{
		(*PromotionFeedItem_PercentOff)(nil),
		(*PromotionFeedItem_MoneyAmountOff)(nil),
		(*PromotionFeedItem_PromotionCode)(nil),
		(*PromotionFeedItem_OrdersOverAmount)(nil),
	}
}

func _PromotionFeedItem_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*PromotionFeedItem)
	// discount_type
	switch x := m.DiscountType.(type) {
	case *PromotionFeedItem_PercentOff:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PercentOff); err != nil {
			return err
		}
	case *PromotionFeedItem_MoneyAmountOff:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MoneyAmountOff); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("PromotionFeedItem.DiscountType has unexpected type %T", x)
	}
	// promotion_trigger
	switch x := m.PromotionTrigger.(type) {
	case *PromotionFeedItem_PromotionCode:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.PromotionCode); err != nil {
			return err
		}
	case *PromotionFeedItem_OrdersOverAmount:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.OrdersOverAmount); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("PromotionFeedItem.PromotionTrigger has unexpected type %T", x)
	}
	return nil
}

func _PromotionFeedItem_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*PromotionFeedItem)
	switch tag {
	case 3: // discount_type.percent_off
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(wrappers.Int64Value)
		err := b.DecodeMessage(msg)
		m.DiscountType = &PromotionFeedItem_PercentOff{msg}
		return true, err
	case 4: // discount_type.money_amount_off
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Money)
		err := b.DecodeMessage(msg)
		m.DiscountType = &PromotionFeedItem_MoneyAmountOff{msg}
		return true, err
	case 5: // promotion_trigger.promotion_code
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(wrappers.StringValue)
		err := b.DecodeMessage(msg)
		m.PromotionTrigger = &PromotionFeedItem_PromotionCode{msg}
		return true, err
	case 6: // promotion_trigger.orders_over_amount
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Money)
		err := b.DecodeMessage(msg)
		m.PromotionTrigger = &PromotionFeedItem_OrdersOverAmount{msg}
		return true, err
	default:
		return false, nil
	}
}

func _PromotionFeedItem_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*PromotionFeedItem)
	// discount_type
	switch x := m.DiscountType.(type) {
	case *PromotionFeedItem_PercentOff:
		s := proto.Size(x.PercentOff)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PromotionFeedItem_MoneyAmountOff:
		s := proto.Size(x.MoneyAmountOff)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	// promotion_trigger
	switch x := m.PromotionTrigger.(type) {
	case *PromotionFeedItem_PromotionCode:
		s := proto.Size(x.PromotionCode)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *PromotionFeedItem_OrdersOverAmount:
		s := proto.Size(x.OrdersOverAmount)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Represents a structured snippet extension.
type StructuredSnippetFeedItem struct {
	// The header of the snippet.
	// This string must not be empty.
	Header *wrappers.StringValue `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// The values in the snippet.
	// The maximum size of this collection is 10.
	Values               []*wrappers.StringValue `protobuf:"bytes,2,rep,name=values,proto3" json:"values,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *StructuredSnippetFeedItem) Reset()         { *m = StructuredSnippetFeedItem{} }
func (m *StructuredSnippetFeedItem) String() string { return proto.CompactTextString(m) }
func (*StructuredSnippetFeedItem) ProtoMessage()    {}
func (*StructuredSnippetFeedItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_extensions_29e88682b0f69f9b, []int{9}
}
func (m *StructuredSnippetFeedItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StructuredSnippetFeedItem.Unmarshal(m, b)
}
func (m *StructuredSnippetFeedItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StructuredSnippetFeedItem.Marshal(b, m, deterministic)
}
func (dst *StructuredSnippetFeedItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StructuredSnippetFeedItem.Merge(dst, src)
}
func (m *StructuredSnippetFeedItem) XXX_Size() int {
	return xxx_messageInfo_StructuredSnippetFeedItem.Size(m)
}
func (m *StructuredSnippetFeedItem) XXX_DiscardUnknown() {
	xxx_messageInfo_StructuredSnippetFeedItem.DiscardUnknown(m)
}

var xxx_messageInfo_StructuredSnippetFeedItem proto.InternalMessageInfo

func (m *StructuredSnippetFeedItem) GetHeader() *wrappers.StringValue {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *StructuredSnippetFeedItem) GetValues() []*wrappers.StringValue {
	if m != nil {
		return m.Values
	}
	return nil
}

// Represents a sitelink extension.
type SitelinkFeedItem struct {
	// URL display text for the sitelink.
	// The length of this string should be between 1 and 25, inclusive.
	LinkText *wrappers.StringValue `protobuf:"bytes,1,opt,name=link_text,json=linkText,proto3" json:"link_text,omitempty"`
	// First line of the description for the sitelink.
	// If this value is set, line2 must also be set.
	// The length of this string should be between 0 and 35, inclusive.
	Line1 *wrappers.StringValue `protobuf:"bytes,2,opt,name=line1,proto3" json:"line1,omitempty"`
	// Second line of the description for the sitelink.
	// If this value is set, line1 must also be set.
	// The length of this string should be between 0 and 35, inclusive.
	Line2 *wrappers.StringValue `protobuf:"bytes,3,opt,name=line2,proto3" json:"line2,omitempty"`
	// A list of possible final URLs after all cross domain redirects.
	FinalUrls []*wrappers.StringValue `protobuf:"bytes,4,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// A list of possible final mobile URLs after all cross domain redirects.
	FinalMobileUrls []*wrappers.StringValue `protobuf:"bytes,5,rep,name=final_mobile_urls,json=finalMobileUrls,proto3" json:"final_mobile_urls,omitempty"`
	// URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,6,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// A list of mappings to be used for substituting URL custom parameter tags in
	// the tracking_url_template, final_urls, and/or final_mobile_urls.
	UrlCustomParameters []*CustomParameter `protobuf:"bytes,7,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// Final URL suffix to be appended to landing page URLs served with
	// parallel tracking.
	FinalUrlSuffix       *wrappers.StringValue `protobuf:"bytes,8,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *SitelinkFeedItem) Reset()         { *m = SitelinkFeedItem{} }
func (m *SitelinkFeedItem) String() string { return proto.CompactTextString(m) }
func (*SitelinkFeedItem) ProtoMessage()    {}
func (*SitelinkFeedItem) Descriptor() ([]byte, []int) {
	return fileDescriptor_extensions_29e88682b0f69f9b, []int{10}
}
func (m *SitelinkFeedItem) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SitelinkFeedItem.Unmarshal(m, b)
}
func (m *SitelinkFeedItem) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SitelinkFeedItem.Marshal(b, m, deterministic)
}
func (dst *SitelinkFeedItem) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SitelinkFeedItem.Merge(dst, src)
}
func (m *SitelinkFeedItem) XXX_Size() int {
	return xxx_messageInfo_SitelinkFeedItem.Size(m)
}
func (m *SitelinkFeedItem) XXX_DiscardUnknown() {
	xxx_messageInfo_SitelinkFeedItem.DiscardUnknown(m)
}

var xxx_messageInfo_SitelinkFeedItem proto.InternalMessageInfo

func (m *SitelinkFeedItem) GetLinkText() *wrappers.StringValue {
	if m != nil {
		return m.LinkText
	}
	return nil
}

func (m *SitelinkFeedItem) GetLine1() *wrappers.StringValue {
	if m != nil {
		return m.Line1
	}
	return nil
}

func (m *SitelinkFeedItem) GetLine2() *wrappers.StringValue {
	if m != nil {
		return m.Line2
	}
	return nil
}

func (m *SitelinkFeedItem) GetFinalUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalUrls
	}
	return nil
}

func (m *SitelinkFeedItem) GetFinalMobileUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalMobileUrls
	}
	return nil
}

func (m *SitelinkFeedItem) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *SitelinkFeedItem) GetUrlCustomParameters() []*CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

func (m *SitelinkFeedItem) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

func init() {
	proto.RegisterType((*AppFeedItem)(nil), "google.ads.googleads.v1.common.AppFeedItem")
	proto.RegisterType((*CallFeedItem)(nil), "google.ads.googleads.v1.common.CallFeedItem")
	proto.RegisterType((*CalloutFeedItem)(nil), "google.ads.googleads.v1.common.CalloutFeedItem")
	proto.RegisterType((*LocationFeedItem)(nil), "google.ads.googleads.v1.common.LocationFeedItem")
	proto.RegisterType((*AffiliateLocationFeedItem)(nil), "google.ads.googleads.v1.common.AffiliateLocationFeedItem")
	proto.RegisterType((*TextMessageFeedItem)(nil), "google.ads.googleads.v1.common.TextMessageFeedItem")
	proto.RegisterType((*PriceFeedItem)(nil), "google.ads.googleads.v1.common.PriceFeedItem")
	proto.RegisterType((*PriceOffer)(nil), "google.ads.googleads.v1.common.PriceOffer")
	proto.RegisterType((*PromotionFeedItem)(nil), "google.ads.googleads.v1.common.PromotionFeedItem")
	proto.RegisterType((*StructuredSnippetFeedItem)(nil), "google.ads.googleads.v1.common.StructuredSnippetFeedItem")
	proto.RegisterType((*SitelinkFeedItem)(nil), "google.ads.googleads.v1.common.SitelinkFeedItem")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/common/extensions.proto", fileDescriptor_extensions_29e88682b0f69f9b)
}

var fileDescriptor_extensions_29e88682b0f69f9b = []byte{
	// 1575 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xec, 0x59, 0xdf, 0x4e, 0x1b, 0xc7,
	0x1a, 0x8f, 0xc1, 0x10, 0xf8, 0x0c, 0x06, 0x96, 0xe4, 0xc8, 0xe1, 0x44, 0x39, 0x39, 0x96, 0x8e,
	0x14, 0x1d, 0xa9, 0x76, 0x70, 0x68, 0x94, 0x3a, 0x6a, 0x5a, 0x63, 0x48, 0xa0, 0x0a, 0x7f, 0xb2,
	0x06, 0x54, 0x55, 0x48, 0xab, 0x61, 0x77, 0x6c, 0x46, 0xd9, 0x9d, 0xd9, 0xce, 0xcc, 0x52, 0x78,
	0x80, 0xaa, 0x55, 0xef, 0xfb, 0x02, 0xad, 0xd4, 0x4a, 0xbd, 0xe8, 0x0b, 0xf4, 0xaa, 0xb7, 0xbd,
	0xeb, 0x4d, 0x1f, 0x22, 0x4f, 0x51, 0xcd, 0xec, 0xec, 0x1a, 0x4c, 0x60, 0xd7, 0x94, 0x4a, 0xbd,
	0xc8, 0x15, 0xbb, 0xeb, 0xef, 0xf7, 0x9b, 0x99, 0x6f, 0x7f, 0xdf, 0xbf, 0x05, 0xea, 0x3d, 0xc6,
	0x7a, 0x3e, 0xae, 0x23, 0x4f, 0x98, 0x4b, 0x75, 0x75, 0xb4, 0x58, 0x77, 0x59, 0x10, 0x30, 0x5a,
	0xc7, 0xc7, 0x12, 0x53, 0x41, 0x18, 0x15, 0xb5, 0x90, 0x33, 0xc9, 0xac, 0x7b, 0xb1, 0x55, 0x0d,
	0x79, 0xa2, 0x96, 0x02, 0x6a, 0x47, 0x8b, 0xb5, 0x18, 0xb0, 0xf0, 0x7e, 0x06, 0xa1, 0x1b, 0x09,
	0xc9, 0x02, 0x27, 0x44, 0x1c, 0x05, 0x58, 0x62, 0x1e, 0xd3, 0x2e, 0x3c, 0xcc, 0x80, 0x75, 0x31,
	0xf6, 0x9c, 0xf8, 0xda, 0x20, 0xde, 0xbb, 0x08, 0x81, 0x69, 0x14, 0x88, 0x3a, 0x0a, 0x43, 0x47,
	0x48, 0xc6, 0xb1, 0x31, 0x6f, 0x5f, 0x6e, 0xee, 0x22, 0xdf, 0x77, 0x5c, 0x46, 0x8f, 0x30, 0x57,
	0xa7, 0x75, 0x38, 0x0e, 0x19, 0x97, 0x84, 0xf6, 0x1c, 0x21, 0x91, 0xcc, 0x49, 0x12, 0x72, 0xe2,
	0x62, 0x27, 0x75, 0x99, 0x13, 0xdf, 0x7f, 0x1e, 0x21, 0x9f, 0x74, 0x49, 0x7a, 0xd4, 0x67, 0x57,
	0x21, 0x89, 0x28, 0x91, 0x06, 0xff, 0x64, 0x38, 0xbc, 0x3c, 0x09, 0x93, 0xed, 0xaf, 0x67, 0x21,
	0x59, 0xc0, 0xa4, 0xc2, 0xf4, 0xd1, 0x1e, 0x11, 0x2e, 0x8b, 0xa8, 0x74, 0x02, 0xe6, 0x9d, 0x3e,
	0xc4, 0xc7, 0xc3, 0x53, 0x31, 0xd7, 0x45, 0xea, 0xc2, 0x30, 0x18, 0x21, 0xd5, 0xf5, 0xdd, 0x41,
	0xd4, 0xad, 0x7f, 0xc1, 0x51, 0x18, 0x62, 0x6e, 0x84, 0xb6, 0x70, 0x37, 0x59, 0x21, 0x24, 0x75,
	0x44, 0x29, 0x93, 0x48, 0xf6, 0x65, 0x58, 0xfd, 0xa3, 0x08, 0xa5, 0x56, 0x18, 0x3e, 0xc7, 0xd8,
	0x5b, 0x97, 0x38, 0xb0, 0x3e, 0x80, 0x49, 0x9f, 0xd0, 0xd7, 0x8e, 0xc4, 0xc7, 0xb2, 0x52, 0xb8,
	0x5f, 0x78, 0x50, 0x6a, 0xdc, 0x35, 0xfa, 0xac, 0x25, 0x2b, 0xd4, 0x3a, 0x92, 0x13, 0xda, 0xdb,
	0x43, 0x7e, 0x84, 0xed, 0x09, 0x65, 0xbe, 0x83, 0x8f, 0xa5, 0xf5, 0x08, 0xc6, 0x95, 0x58, 0x88,
	0x57, 0x19, 0xc9, 0x81, 0x1b, 0x43, 0x61, 0xb8, 0xee, 0x59, 0xaf, 0x60, 0x32, 0x55, 0x58, 0x65,
	0xf4, 0x7e, 0xe1, 0x41, 0xb9, 0xb1, 0x54, 0xbb, 0x28, 0x34, 0xb4, 0x4f, 0x6a, 0xad, 0x30, 0xec,
	0x28, 0xf3, 0x55, 0x1a, 0x05, 0xe9, 0x8d, 0x3d, 0x81, 0xcc, 0x95, 0xf5, 0x14, 0xa0, 0x4b, 0x28,
	0xf2, 0x9d, 0x88, 0xfb, 0xa2, 0x52, 0xbc, 0x3f, 0x9a, 0xb9, 0x97, 0x49, 0x6d, 0xbf, 0xcb, 0x7d,
	0x61, 0xad, 0xc1, 0x5c, 0x0c, 0x0e, 0xd8, 0x01, 0xf1, 0x71, 0xcc, 0x31, 0x96, 0x83, 0x63, 0x46,
	0xc3, 0x36, 0x34, 0x4a, 0x33, 0x6d, 0xc3, 0x6d, 0xc9, 0x91, 0xfb, 0x5a, 0x69, 0x3f, 0xe2, 0xbe,
	0x23, 0x71, 0x10, 0xfa, 0x48, 0xe2, 0xca, 0x78, 0x0e, 0xef, 0xcc, 0x27, 0xd0, 0x5d, 0xee, 0xef,
	0x18, 0xa0, 0xe5, 0xc2, 0x6d, 0x45, 0x34, 0x18, 0xf9, 0xa2, 0x72, 0x53, 0xef, 0xaf, 0x5e, 0xbb,
	0x3c, 0xa5, 0xd4, 0xda, 0x1a, 0xb8, 0x9d, 0xe0, 0xec, 0xf9, 0x88, 0xfb, 0x03, 0xcf, 0x84, 0xf5,
	0x1c, 0x66, 0x53, 0xef, 0x39, 0x22, 0xea, 0x76, 0xc9, 0x71, 0x65, 0x22, 0xc7, 0x8e, 0xcb, 0x89,
	0x0f, 0x3b, 0x1a, 0x53, 0xfd, 0xb5, 0x08, 0x53, 0x6d, 0xe4, 0xfb, 0xa9, 0xb2, 0x3e, 0x82, 0xa9,
	0xf0, 0x90, 0x51, 0xec, 0xd0, 0x28, 0x38, 0xc0, 0x3c, 0x97, 0xb8, 0x4a, 0x1a, 0xb1, 0xa9, 0x01,
	0x8a, 0x40, 0x87, 0x10, 0x3f, 0x71, 0x5c, 0xe6, 0xe1, 0x5c, 0x2a, 0x2b, 0x19, 0x44, 0x9b, 0x79,
	0xd8, 0xda, 0x84, 0xdb, 0x3a, 0x3d, 0xa5, 0xaf, 0x05, 0x53, 0x74, 0xe0, 0x63, 0x4f, 0xeb, 0xae,
	0xd4, 0x58, 0x38, 0xc7, 0xb4, 0xcc, 0x98, 0x6f, 0xde, 0x87, 0x02, 0xee, 0x18, 0xdc, 0x6a, 0x0c,
	0xb3, 0x6c, 0xf8, 0xd7, 0x60, 0xba, 0x43, 0xae, 0x0a, 0xae, 0x4a, 0x31, 0xc7, 0xd6, 0x6e, 0x29,
	0x6c, 0x3b, 0x85, 0xb6, 0x34, 0xd2, 0xc2, 0xf0, 0xdf, 0x41, 0xce, 0x74, 0xbb, 0x1e, 0x11, 0xf1,
	0x7e, 0xc7, 0x32, 0xf7, 0x7b, 0xef, 0x2c, 0x79, 0xb2, 0xf3, 0x15, 0xc3, 0x60, 0x7d, 0x5f, 0x80,
	0xff, 0x64, 0xa4, 0x6a, 0xad, 0xd3, 0x72, 0x63, 0x3f, 0x23, 0x1a, 0xdb, 0x67, 0x16, 0xb2, 0x13,
	0x8e, 0x8e, 0xa2, 0xd0, 0x11, 0x7a, 0x99, 0x81, 0x7d, 0xd7, 0xbd, 0xe4, 0xd7, 0xaa, 0x0d, 0x33,
	0x0a, 0xcd, 0x22, 0x79, 0x5a, 0x45, 0x6e, 0xfc, 0x28, 0x7f, 0x8a, 0x2a, 0x19, 0x84, 0xca, 0x52,
	0xd5, 0x6f, 0x8a, 0x30, 0xfb, 0x92, 0xb9, 0x3a, 0x09, 0xa6, 0xac, 0x2d, 0x98, 0x3e, 0x88, 0x04,
	0xa1, 0x58, 0x08, 0x87, 0xa2, 0x00, 0xe7, 0xa2, 0x9d, 0x4a, 0x20, 0x9b, 0x28, 0xc0, 0xd6, 0x32,
	0x94, 0x91, 0xe7, 0x71, 0xc5, 0xe0, 0x13, 0x8a, 0x9d, 0xc5, 0x5c, 0xfa, 0x9c, 0x32, 0x98, 0x97,
	0x84, 0xe2, 0xc5, 0x73, 0x1c, 0x0d, 0xa3, 0xcc, 0xfc, 0x1c, 0x0d, 0xeb, 0x21, 0x14, 0x5d, 0x22,
	0x4f, 0x72, 0x49, 0x50, 0x5b, 0x5a, 0x4f, 0x60, 0x22, 0xe4, 0xec, 0x88, 0x50, 0x17, 0x1b, 0x65,
	0x65, 0x64, 0xfc, 0xc4, 0xda, 0xfa, 0x10, 0x4a, 0x21, 0x13, 0x12, 0xf9, 0x71, 0x40, 0xe6, 0x49,
	0x6c, 0x10, 0x03, 0x74, 0x3c, 0x0e, 0x06, 0xf4, 0xcd, 0x61, 0x03, 0x7a, 0x30, 0xa5, 0x4c, 0x0c,
	0x99, 0x52, 0xaa, 0x5f, 0x8f, 0xc1, 0x9d, 0x56, 0xb7, 0x4b, 0x7c, 0x82, 0x24, 0x7e, 0xa7, 0x8a,
	0x77, 0xaa, 0xd0, 0x85, 0xe6, 0x31, 0x4c, 0xb8, 0x87, 0x88, 0x50, 0xd5, 0xca, 0x4c, 0x6a, 0xf0,
	0xbf, 0xcf, 0x81, 0xd7, 0xa9, 0x7c, 0xbc, 0x14, 0x63, 0x6f, 0x6a, 0xe3, 0x75, 0x4f, 0x35, 0x1e,
	0x31, 0x4e, 0x8b, 0x05, 0x72, 0x2c, 0x3b, 0xa9, 0xed, 0x95, 0x52, 0xaa, 0xbf, 0x8f, 0xc0, 0xbc,
	0x4a, 0x50, 0x1b, 0x58, 0x08, 0xd4, 0xc3, 0xd7, 0x29, 0xc2, 0xbf, 0x5c, 0x38, 0x07, 0x3d, 0x3a,
	0x3a, 0xac, 0x47, 0x1f, 0x42, 0x51, 0x67, 0xeb, 0x5c, 0xf2, 0x53, 0x96, 0x56, 0x1b, 0xca, 0xa7,
	0x5a, 0x6f, 0x85, 0xcd, 0x23, 0xc2, 0xe9, 0x14, 0xa3, 0x73, 0xfd, 0x8f, 0x45, 0x98, 0xde, 0x56,
	0x6d, 0x7c, 0xea, 0xcd, 0x7d, 0x28, 0xaa, 0x3e, 0x5e, 0x3b, 0xb1, 0xdc, 0x58, 0xcb, 0xa8, 0x6d,
	0x1a, 0xbb, 0x9a, 0x52, 0x9e, 0x84, 0x71, 0x45, 0x3b, 0xff, 0xd8, 0xd6, 0xac, 0xd6, 0x97, 0x05,
	0x98, 0x19, 0x98, 0x55, 0xb4, 0xb3, 0xb3, 0xab, 0xe8, 0x59, 0x4a, 0x7d, 0xf7, 0x2a, 0xa1, 0x78,
	0xcb, 0x9a, 0x67, 0x0d, 0xec, 0x72, 0x78, 0xe6, 0xfe, 0xe2, 0xd6, 0x73, 0xf4, 0xaa, 0xad, 0x67,
	0x0b, 0xa6, 0x7d, 0x44, 0x7b, 0x11, 0xea, 0xe1, 0x58, 0x43, 0x79, 0xde, 0xe4, 0x54, 0x02, 0xd1,
	0x22, 0xea, 0x24, 0xbe, 0x61, 0xdd, 0x2e, 0x56, 0x46, 0x49, 0x5f, 0xfd, 0xff, 0xac, 0xbe, 0x55,
	0x9f, 0x76, 0x4b, 0xa1, 0xcc, 0x49, 0xb7, 0x12, 0x86, 0xb7, 0x76, 0xab, 0xe3, 0x57, 0xe8, 0x56,
	0x7f, 0x1e, 0x05, 0xe8, 0x2f, 0x63, 0x2d, 0xc1, 0xf8, 0x21, 0x46, 0x5e, 0xce, 0x2e, 0xd5, 0xd8,
	0x5a, 0xcf, 0xa0, 0xe4, 0x61, 0xe1, 0x72, 0x12, 0xea, 0x26, 0x30, 0x57, 0x98, 0x9d, 0x02, 0x58,
	0x4f, 0x61, 0x4c, 0x1f, 0xcf, 0xbc, 0xa6, 0xff, 0x65, 0xf9, 0x65, 0x83, 0x51, 0x7c, 0x62, 0xc7,
	0x18, 0xab, 0x0b, 0x45, 0x35, 0xdb, 0xea, 0x17, 0x53, 0x6e, 0xd8, 0xc3, 0xeb, 0x6d, 0x97, 0x12,
	0x79, 0x91, 0xd4, 0xd4, 0x6f, 0xb6, 0xe6, 0x1f, 0x98, 0xae, 0xc6, 0xae, 0x61, 0xba, 0x1a, 0xbf,
	0xc2, 0x74, 0x55, 0xfd, 0x01, 0x60, 0x6e, 0x3b, 0x19, 0x8e, 0xd3, 0xf0, 0x7e, 0x01, 0xb3, 0xfd,
	0x89, 0x59, 0x22, 0xde, 0xc3, 0xf9, 0x3a, 0xc4, 0x99, 0x14, 0xb5, 0xa3, 0x41, 0xd6, 0xb7, 0x05,
	0x98, 0x3b, 0x37, 0xb2, 0x9b, 0x58, 0x3e, 0xcc, 0xf4, 0xad, 0xe1, 0x4a, 0x7d, 0xb8, 0x62, 0x98,
	0x36, 0x0c, 0x91, 0x71, 0x73, 0x96, 0x99, 0x3d, 0xeb, 0x0d, 0x3c, 0xb1, 0x36, 0xe1, 0x56, 0xff,
	0x80, 0x42, 0x22, 0x2e, 0x1d, 0x4f, 0x05, 0x76, 0x9e, 0x22, 0x69, 0xa5, 0xc8, 0x8e, 0x02, 0xae,
	0xa8, 0xb8, 0xfe, 0x04, 0xac, 0x53, 0x9f, 0x18, 0xa8, 0x17, 0xb3, 0xe5, 0xa9, 0x98, 0x7d, 0x47,
	0xaf, 0x52, 0x4f, 0x73, 0x49, 0x98, 0x48, 0x3e, 0x4d, 0xe8, 0xb2, 0x59, 0x6e, 0x7c, 0x3a, 0xb4,
	0xa7, 0xb6, 0x0c, 0xc1, 0x05, 0x1e, 0x4a, 0x7e, 0xb6, 0xd3, 0x95, 0x06, 0xf4, 0x08, 0xd7, 0xa0,
	0xc7, 0xd2, 0xb5, 0x4e, 0xfb, 0x53, 0xd7, 0x3e, 0xed, 0x4f, 0xff, 0xcd, 0xd3, 0x7e, 0x79, 0xf8,
	0xfc, 0x79, 0xbe, 0x3e, 0xcc, 0x0c, 0x5d, 0x1f, 0x9e, 0x41, 0x29, 0xc4, 0xdc, 0xc5, 0x54, 0xaa,
	0x0a, 0x61, 0x72, 0xe0, 0x65, 0x8d, 0xd7, 0xda, 0x0d, 0x1b, 0x0c, 0x62, 0xab, 0xdb, 0xb5, 0x5e,
	0xc1, 0x6c, 0xa0, 0x12, 0xa2, 0x83, 0x02, 0x1d, 0xb5, 0x8a, 0xa4, 0x38, 0x44, 0x22, 0x5d, 0xbb,
	0x61, 0x97, 0x35, 0x41, 0x4b, 0xe3, 0x15, 0xe5, 0x2a, 0x94, 0xfb, 0xd1, 0xa1, 0x8f, 0x95, 0xa3,
	0x09, 0x59, 0x2b, 0xd8, 0xd3, 0x29, 0x4a, 0x9f, 0x6c, 0x17, 0x2c, 0xc6, 0x3d, 0xcc, 0x85, 0xc3,
	0x8e, 0x30, 0x37, 0xfb, 0x33, 0x65, 0x2a, 0xe7, 0xde, 0x0a, 0xf6, 0x6c, 0x4c, 0xb1, 0x75, 0x84,
	0x79, 0xbc, 0xc1, 0xe5, 0x19, 0x98, 0x4e, 0x53, 0x94, 0x6a, 0x3f, 0x96, 0xe7, 0x61, 0xee, 0x54,
	0xf6, 0xe3, 0xa4, 0xd7, 0xc3, 0xbc, 0xfa, 0x55, 0x01, 0xee, 0x74, 0x24, 0x8f, 0x5c, 0x19, 0x71,
	0xec, 0x75, 0x28, 0x09, 0x43, 0xdc, 0x1f, 0xa7, 0xaf, 0x56, 0xe8, 0x96, 0x60, 0xfc, 0x48, 0x3d,
	0x10, 0x95, 0x91, 0x1c, 0xb1, 0x62, 0x6c, 0xab, 0xbf, 0x14, 0x61, 0xb6, 0x43, 0x24, 0xf6, 0x09,
	0x7d, 0x7d, 0x1d, 0xdf, 0x1b, 0x1b, 0x30, 0xa6, 0xe6, 0xa1, 0x7c, 0x23, 0x55, 0x6c, 0x9a, 0x60,
	0xf2, 0x8d, 0x50, 0xb1, 0xe9, 0xbb, 0xef, 0x89, 0xff, 0x84, 0xef, 0x89, 0xcb, 0x6f, 0x0a, 0x50,
	0x75, 0x59, 0x90, 0xb1, 0xa7, 0xe5, 0x99, 0xb4, 0x56, 0x88, 0x6d, 0x45, 0xbb, 0x5d, 0xf8, 0x6c,
	0xc5, 0x40, 0x7a, 0x4c, 0xe5, 0x9b, 0x1a, 0xe3, 0xbd, 0x7a, 0x0f, 0x53, 0xbd, 0x68, 0xf2, 0xc9,
	0x3d, 0x24, 0xe2, 0xa2, 0xff, 0x98, 0x3c, 0x8d, 0xff, 0x7c, 0x37, 0x32, 0xfa, 0xa2, 0xd5, 0xfa,
	0x69, 0xe4, 0xde, 0x8b, 0x98, 0xac, 0xe5, 0x89, 0x5a, 0x7c, 0xa9, 0xae, 0xf6, 0x16, 0x6b, 0x6d,
	0x6d, 0xf6, 0x5b, 0x62, 0xb0, 0xdf, 0xf2, 0xc4, 0x7e, 0x6a, 0xb0, 0xbf, 0xb7, 0xb8, 0x1f, 0x1b,
	0xbc, 0x19, 0xa9, 0xc6, 0x4f, 0x9b, 0xcd, 0x96, 0x27, 0x9a, 0xcd, 0xd4, 0xa4, 0xd9, 0xdc, 0x5b,
	0x6c, 0x36, 0x63, 0xa3, 0x83, 0x71, 0xbd, 0xbb, 0x47, 0x7f, 0x06, 0x00, 0x00, 0xff, 0xff, 0xac,
	0x90, 0x60, 0xa0, 0x56, 0x1a, 0x00, 0x00,
}
