// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package textract

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
)

const opAnalyzeDocument = "AnalyzeDocument"

// AnalyzeDocumentRequest generates a "aws/request.Request" representing the
// client's request for the AnalyzeDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AnalyzeDocument for more information on using the AnalyzeDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AnalyzeDocumentRequest method.
//    req, resp := client.AnalyzeDocumentRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeDocument
func (c *Textract) AnalyzeDocumentRequest(input *AnalyzeDocumentInput) (req *request.Request, output *AnalyzeDocumentOutput) {
	op := &request.Operation{
		Name:       opAnalyzeDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AnalyzeDocumentInput{}
	}

	output = &AnalyzeDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AnalyzeDocument API operation for Amazon Textract.
//
// Analyzes an input document for relationships between detected items.
//
// The types of information returned are as follows:
//
//    * Words and lines that are related to nearby lines and words. The related
//    information is returned in two Block objects each of type KEY_VALUE_SET:
//    a KEY Block object and a VALUE Block object. For example, Name: Ana Silva
//    Carolina contains a key and value. Name: is the key. Ana Silva Carolina
//    is the value.
//
//    * Table and table cell data. A TABLE Block object contains information
//    about a detected table. A CELL Block object is returned for each cell
//    in a table.
//
//    * Selectable elements such as checkboxes and radio buttons. A SELECTION_ELEMENT
//    Block object contains information about a selectable element.
//
//    * Lines and words of text. A LINE Block object contains one or more WORD
//    Block objects.
//
// You can choose which type of analysis to perform by specifying the FeatureTypes
// list.
//
// The output is returned in a list of BLOCK objects.
//
// AnalyzeDocument is a synchronous operation. To analyze documents asynchronously,
// use StartDocumentAnalysis.
//
// For more information, see Document Text Analysis (https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation AnalyzeDocument for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   An input parameter violated a constraint. For example, in synchronous operations,
//   an InvalidParameterException exception occurs when neither of the S3Object
//   or Bytes values are supplied in the Document request parameter. Validate
//   your parameter before calling the API operation again.
//
//   * ErrCodeInvalidS3ObjectException "InvalidS3ObjectException"
//   Amazon Textract is unable to access the S3 object that's specified in the
//   request.
//
//   * ErrCodeUnsupportedDocumentException "UnsupportedDocumentException"
//   The format of the input document isn't supported. Amazon Textract supports
//   documents that are .png or .jpg format.
//
//   * ErrCodeDocumentTooLargeException "DocumentTooLargeException"
//   The document can't be processed because it's too large. The maximum document
//   size for synchronous operations 5 MB. The maximum document size for asynchronous
//   operations is 500 MB for PDF format files.
//
//   * ErrCodeBadDocumentException "BadDocumentException"
//   Amazon Textract isn't able to read the document.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You aren't authorized to perform the action.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Textract.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Amazon Textract experienced a service issue. Try your call again.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Amazon Textract is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeDocument
func (c *Textract) AnalyzeDocument(input *AnalyzeDocumentInput) (*AnalyzeDocumentOutput, error) {
	req, out := c.AnalyzeDocumentRequest(input)
	return out, req.Send()
}

// AnalyzeDocumentWithContext is the same as AnalyzeDocument with the addition of
// the ability to pass a context and additional request options.
//
// See AnalyzeDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) AnalyzeDocumentWithContext(ctx aws.Context, input *AnalyzeDocumentInput, opts ...request.Option) (*AnalyzeDocumentOutput, error) {
	req, out := c.AnalyzeDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectDocumentText = "DetectDocumentText"

// DetectDocumentTextRequest generates a "aws/request.Request" representing the
// client's request for the DetectDocumentText operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectDocumentText for more information on using the DetectDocumentText
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DetectDocumentTextRequest method.
//    req, resp := client.DetectDocumentTextRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/DetectDocumentText
func (c *Textract) DetectDocumentTextRequest(input *DetectDocumentTextInput) (req *request.Request, output *DetectDocumentTextOutput) {
	op := &request.Operation{
		Name:       opDetectDocumentText,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectDocumentTextInput{}
	}

	output = &DetectDocumentTextOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectDocumentText API operation for Amazon Textract.
//
// Detects text in the input document. Amazon Textract can detect lines of text
// and the words that make up a line of text. The input document must be an
// image in JPG or PNG format. DetectDocumentText returns the detected text
// in an array of Block objects.
//
// Each document page has as an associated Block of type PAGE. Each PAGE Block
// object is the parent of LINE Block objects that represent the lines of detected
// text on a page. A LINE Block object is a parent for each word that makes
// up the line. Words are represented by Block objects of type WORD.
//
// DetectDocumentText is a synchronous operation. To analyze documents asynchronously,
// use StartDocumentTextDetection.
//
// For more information, see Document Text Detection (https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation DetectDocumentText for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   An input parameter violated a constraint. For example, in synchronous operations,
//   an InvalidParameterException exception occurs when neither of the S3Object
//   or Bytes values are supplied in the Document request parameter. Validate
//   your parameter before calling the API operation again.
//
//   * ErrCodeInvalidS3ObjectException "InvalidS3ObjectException"
//   Amazon Textract is unable to access the S3 object that's specified in the
//   request.
//
//   * ErrCodeUnsupportedDocumentException "UnsupportedDocumentException"
//   The format of the input document isn't supported. Amazon Textract supports
//   documents that are .png or .jpg format.
//
//   * ErrCodeDocumentTooLargeException "DocumentTooLargeException"
//   The document can't be processed because it's too large. The maximum document
//   size for synchronous operations 5 MB. The maximum document size for asynchronous
//   operations is 500 MB for PDF format files.
//
//   * ErrCodeBadDocumentException "BadDocumentException"
//   Amazon Textract isn't able to read the document.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You aren't authorized to perform the action.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Textract.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Amazon Textract experienced a service issue. Try your call again.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Amazon Textract is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/DetectDocumentText
func (c *Textract) DetectDocumentText(input *DetectDocumentTextInput) (*DetectDocumentTextOutput, error) {
	req, out := c.DetectDocumentTextRequest(input)
	return out, req.Send()
}

// DetectDocumentTextWithContext is the same as DetectDocumentText with the addition of
// the ability to pass a context and additional request options.
//
// See DetectDocumentText for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) DetectDocumentTextWithContext(ctx aws.Context, input *DetectDocumentTextInput, opts ...request.Option) (*DetectDocumentTextOutput, error) {
	req, out := c.DetectDocumentTextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDocumentAnalysis = "GetDocumentAnalysis"

// GetDocumentAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the GetDocumentAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDocumentAnalysis for more information on using the GetDocumentAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDocumentAnalysisRequest method.
//    req, resp := client.GetDocumentAnalysisRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetDocumentAnalysis
func (c *Textract) GetDocumentAnalysisRequest(input *GetDocumentAnalysisInput) (req *request.Request, output *GetDocumentAnalysisOutput) {
	op := &request.Operation{
		Name:       opGetDocumentAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDocumentAnalysisInput{}
	}

	output = &GetDocumentAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDocumentAnalysis API operation for Amazon Textract.
//
// Gets the results for an Amazon Textract asynchronous operation that analyzes
// text in a document.
//
// You start asynchronous text analysis by calling StartDocumentAnalysis, which
// returns a job identifier (JobId). When the text analysis operation finishes,
// Amazon Textract publishes a completion status to the Amazon Simple Notification
// Service (Amazon SNS) topic that's registered in the initial call to StartDocumentAnalysis.
// To get the results of the text-detection operation, first check that the
// status value published to the Amazon SNS topic is SUCCEEDED. If so, call
// GetDocumentAnalysis, and pass the job identifier (JobId) from the initial
// call to StartDocumentAnalysis.
//
// GetDocumentAnalysis returns an array of Block objects. The following types
// of information are returned:
//
//    * Words and lines that are related to nearby lines and words. The related
//    information is returned in two Block objects each of type KEY_VALUE_SET:
//    a KEY Block object and a VALUE Block object. For example, Name: Ana Silva
//    Carolina contains a key and value. Name: is the key. Ana Silva Carolina
//    is the value.
//
//    * Table and table cell data. A TABLE Block object contains information
//    about a detected table. A CELL Block object is returned for each cell
//    in a table.
//
//    * Selectable elements such as checkboxes and radio buttons. A SELECTION_ELEMENT
//    Block object contains information about a selectable element.
//
//    * Lines and words of text. A LINE Block object contains one or more WORD
//    Block objects.
//
// Use the MaxResults parameter to limit the number of blocks returned. If there
// are more results than specified in MaxResults, the value of NextToken in
// the operation response contains a pagination token for getting the next set
// of results. To get the next page of results, call GetDocumentAnalysis, and
// populate the NextToken request parameter with the token value that's returned
// from the previous call to GetDocumentAnalysis.
//
// For more information, see Document Text Analysis (https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation GetDocumentAnalysis for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   An input parameter violated a constraint. For example, in synchronous operations,
//   an InvalidParameterException exception occurs when neither of the S3Object
//   or Bytes values are supplied in the Document request parameter. Validate
//   your parameter before calling the API operation again.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You aren't authorized to perform the action.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Textract.
//
//   * ErrCodeInvalidJobIdException "InvalidJobIdException"
//   An invalid job identifier was passed to GetDocumentAnalysis or to GetDocumentAnalysis.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Amazon Textract experienced a service issue. Try your call again.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Amazon Textract is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetDocumentAnalysis
func (c *Textract) GetDocumentAnalysis(input *GetDocumentAnalysisInput) (*GetDocumentAnalysisOutput, error) {
	req, out := c.GetDocumentAnalysisRequest(input)
	return out, req.Send()
}

// GetDocumentAnalysisWithContext is the same as GetDocumentAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See GetDocumentAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) GetDocumentAnalysisWithContext(ctx aws.Context, input *GetDocumentAnalysisInput, opts ...request.Option) (*GetDocumentAnalysisOutput, error) {
	req, out := c.GetDocumentAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDocumentTextDetection = "GetDocumentTextDetection"

// GetDocumentTextDetectionRequest generates a "aws/request.Request" representing the
// client's request for the GetDocumentTextDetection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDocumentTextDetection for more information on using the GetDocumentTextDetection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDocumentTextDetectionRequest method.
//    req, resp := client.GetDocumentTextDetectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetDocumentTextDetection
func (c *Textract) GetDocumentTextDetectionRequest(input *GetDocumentTextDetectionInput) (req *request.Request, output *GetDocumentTextDetectionOutput) {
	op := &request.Operation{
		Name:       opGetDocumentTextDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDocumentTextDetectionInput{}
	}

	output = &GetDocumentTextDetectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDocumentTextDetection API operation for Amazon Textract.
//
// Gets the results for an Amazon Textract asynchronous operation that detects
// text in a document. Amazon Textract can detect lines of text and the words
// that make up a line of text.
//
// You start asynchronous text detection by calling StartDocumentTextDetection,
// which returns a job identifier (JobId). When the text detection operation
// finishes, Amazon Textract publishes a completion status to the Amazon Simple
// Notification Service (Amazon SNS) topic that's registered in the initial
// call to StartDocumentTextDetection. To get the results of the text-detection
// operation, first check that the status value published to the Amazon SNS
// topic is SUCCEEDED. If so, call GetDocumentTextDetection, and pass the job
// identifier (JobId) from the initial call to StartDocumentTextDetection.
//
// GetDocumentTextDetection returns an array of Block objects.
//
// Each document page has as an associated Block of type PAGE. Each PAGE Block
// object is the parent of LINE Block objects that represent the lines of detected
// text on a page. A LINE Block object is a parent for each word that makes
// up the line. Words are represented by Block objects of type WORD.
//
// Use the MaxResults parameter to limit the number of blocks that are returned.
// If there are more results than specified in MaxResults, the value of NextToken
// in the operation response contains a pagination token for getting the next
// set of results. To get the next page of results, call GetDocumentTextDetection,
// and populate the NextToken request parameter with the token value that's
// returned from the previous call to GetDocumentTextDetection.
//
// For more information, see Document Text Detection (https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation GetDocumentTextDetection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   An input parameter violated a constraint. For example, in synchronous operations,
//   an InvalidParameterException exception occurs when neither of the S3Object
//   or Bytes values are supplied in the Document request parameter. Validate
//   your parameter before calling the API operation again.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You aren't authorized to perform the action.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Textract.
//
//   * ErrCodeInvalidJobIdException "InvalidJobIdException"
//   An invalid job identifier was passed to GetDocumentAnalysis or to GetDocumentAnalysis.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Amazon Textract experienced a service issue. Try your call again.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Amazon Textract is temporarily unable to process the request. Try your call
//   again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetDocumentTextDetection
func (c *Textract) GetDocumentTextDetection(input *GetDocumentTextDetectionInput) (*GetDocumentTextDetectionOutput, error) {
	req, out := c.GetDocumentTextDetectionRequest(input)
	return out, req.Send()
}

// GetDocumentTextDetectionWithContext is the same as GetDocumentTextDetection with the addition of
// the ability to pass a context and additional request options.
//
// See GetDocumentTextDetection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) GetDocumentTextDetectionWithContext(ctx aws.Context, input *GetDocumentTextDetectionInput, opts ...request.Option) (*GetDocumentTextDetectionOutput, error) {
	req, out := c.GetDocumentTextDetectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDocumentAnalysis = "StartDocumentAnalysis"

// StartDocumentAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the StartDocumentAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDocumentAnalysis for more information on using the StartDocumentAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDocumentAnalysisRequest method.
//    req, resp := client.StartDocumentAnalysisRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartDocumentAnalysis
func (c *Textract) StartDocumentAnalysisRequest(input *StartDocumentAnalysisInput) (req *request.Request, output *StartDocumentAnalysisOutput) {
	op := &request.Operation{
		Name:       opStartDocumentAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDocumentAnalysisInput{}
	}

	output = &StartDocumentAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDocumentAnalysis API operation for Amazon Textract.
//
// Starts asynchronous analysis of an input document for relationships between
// detected items such as key and value pairs, tables, and selection elements.
//
// StartDocumentAnalysis can analyze text in documents that are in JPG, PNG,
// and PDF format. The documents are stored in an Amazon S3 bucket. Use DocumentLocation
// to specify the bucket name and file name of the document.
//
// StartDocumentAnalysis returns a job identifier (JobId) that you use to get
// the results of the operation. When text analysis is finished, Amazon Textract
// publishes a completion status to the Amazon Simple Notification Service (Amazon
// SNS) topic that you specify in NotificationChannel. To get the results of
// the text analysis operation, first check that the status value published
// to the Amazon SNS topic is SUCCEEDED. If so, call GetDocumentAnalysis, and
// pass the job identifier (JobId) from the initial call to StartDocumentAnalysis.
//
// For more information, see Document Text Analysis (https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation StartDocumentAnalysis for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   An input parameter violated a constraint. For example, in synchronous operations,
//   an InvalidParameterException exception occurs when neither of the S3Object
//   or Bytes values are supplied in the Document request parameter. Validate
//   your parameter before calling the API operation again.
//
//   * ErrCodeInvalidS3ObjectException "InvalidS3ObjectException"
//   Amazon Textract is unable to access the S3 object that's specified in the
//   request.
//
//   * ErrCodeUnsupportedDocumentException "UnsupportedDocumentException"
//   The format of the input document isn't supported. Amazon Textract supports
//   documents that are .png or .jpg format.
//
//   * ErrCodeDocumentTooLargeException "DocumentTooLargeException"
//   The document can't be processed because it's too large. The maximum document
//   size for synchronous operations 5 MB. The maximum document size for asynchronous
//   operations is 500 MB for PDF format files.
//
//   * ErrCodeBadDocumentException "BadDocumentException"
//   Amazon Textract isn't able to read the document.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You aren't authorized to perform the action.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Textract.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Amazon Textract experienced a service issue. Try your call again.
//
//   * ErrCodeIdempotentParameterMismatchException "IdempotentParameterMismatchException"
//   A ClientRequestToken input parameter was reused with an operation, but at
//   least one of the other input parameters is different from the previous call
//   to the operation.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Amazon Textract is temporarily unable to process the request. Try your call
//   again.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   An Amazon Textract service limit was exceeded. For example, if you start
//   too many asynchronous jobs concurrently, calls to start operations (StartDocumentTextDetection,
//   for example) raise a LimitExceededException exception (HTTP status code:
//   400) until the number of concurrently running jobs is below the Amazon Textract
//   service limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartDocumentAnalysis
func (c *Textract) StartDocumentAnalysis(input *StartDocumentAnalysisInput) (*StartDocumentAnalysisOutput, error) {
	req, out := c.StartDocumentAnalysisRequest(input)
	return out, req.Send()
}

// StartDocumentAnalysisWithContext is the same as StartDocumentAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See StartDocumentAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) StartDocumentAnalysisWithContext(ctx aws.Context, input *StartDocumentAnalysisInput, opts ...request.Option) (*StartDocumentAnalysisOutput, error) {
	req, out := c.StartDocumentAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDocumentTextDetection = "StartDocumentTextDetection"

// StartDocumentTextDetectionRequest generates a "aws/request.Request" representing the
// client's request for the StartDocumentTextDetection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDocumentTextDetection for more information on using the StartDocumentTextDetection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartDocumentTextDetectionRequest method.
//    req, resp := client.StartDocumentTextDetectionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartDocumentTextDetection
func (c *Textract) StartDocumentTextDetectionRequest(input *StartDocumentTextDetectionInput) (req *request.Request, output *StartDocumentTextDetectionOutput) {
	op := &request.Operation{
		Name:       opStartDocumentTextDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDocumentTextDetectionInput{}
	}

	output = &StartDocumentTextDetectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDocumentTextDetection API operation for Amazon Textract.
//
// Starts the asynchronous detection of text in a document. Amazon Textract
// can detect lines of text and the words that make up a line of text.
//
// StartDocumentTextDetection can analyze text in documents that are in JPG,
// PNG, and PDF format. The documents are stored in an Amazon S3 bucket. Use
// DocumentLocation to specify the bucket name and file name of the document.
//
// StartTextDetection returns a job identifier (JobId) that you use to get the
// results of the operation. When text detection is finished, Amazon Textract
// publishes a completion status to the Amazon Simple Notification Service (Amazon
// SNS) topic that you specify in NotificationChannel. To get the results of
// the text detection operation, first check that the status value published
// to the Amazon SNS topic is SUCCEEDED. If so, call GetDocumentTextDetection,
// and pass the job identifier (JobId) from the initial call to StartDocumentTextDetection.
//
// For more information, see Document Text Detection (https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation StartDocumentTextDetection for usage and error information.
//
// Returned Error Codes:
//   * ErrCodeInvalidParameterException "InvalidParameterException"
//   An input parameter violated a constraint. For example, in synchronous operations,
//   an InvalidParameterException exception occurs when neither of the S3Object
//   or Bytes values are supplied in the Document request parameter. Validate
//   your parameter before calling the API operation again.
//
//   * ErrCodeInvalidS3ObjectException "InvalidS3ObjectException"
//   Amazon Textract is unable to access the S3 object that's specified in the
//   request.
//
//   * ErrCodeUnsupportedDocumentException "UnsupportedDocumentException"
//   The format of the input document isn't supported. Amazon Textract supports
//   documents that are .png or .jpg format.
//
//   * ErrCodeDocumentTooLargeException "DocumentTooLargeException"
//   The document can't be processed because it's too large. The maximum document
//   size for synchronous operations 5 MB. The maximum document size for asynchronous
//   operations is 500 MB for PDF format files.
//
//   * ErrCodeBadDocumentException "BadDocumentException"
//   Amazon Textract isn't able to read the document.
//
//   * ErrCodeAccessDeniedException "AccessDeniedException"
//   You aren't authorized to perform the action.
//
//   * ErrCodeProvisionedThroughputExceededException "ProvisionedThroughputExceededException"
//   The number of requests exceeded your throughput limit. If you want to increase
//   this limit, contact Amazon Textract.
//
//   * ErrCodeInternalServerError "InternalServerError"
//   Amazon Textract experienced a service issue. Try your call again.
//
//   * ErrCodeIdempotentParameterMismatchException "IdempotentParameterMismatchException"
//   A ClientRequestToken input parameter was reused with an operation, but at
//   least one of the other input parameters is different from the previous call
//   to the operation.
//
//   * ErrCodeThrottlingException "ThrottlingException"
//   Amazon Textract is temporarily unable to process the request. Try your call
//   again.
//
//   * ErrCodeLimitExceededException "LimitExceededException"
//   An Amazon Textract service limit was exceeded. For example, if you start
//   too many asynchronous jobs concurrently, calls to start operations (StartDocumentTextDetection,
//   for example) raise a LimitExceededException exception (HTTP status code:
//   400) until the number of concurrently running jobs is below the Amazon Textract
//   service limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartDocumentTextDetection
func (c *Textract) StartDocumentTextDetection(input *StartDocumentTextDetectionInput) (*StartDocumentTextDetectionOutput, error) {
	req, out := c.StartDocumentTextDetectionRequest(input)
	return out, req.Send()
}

// StartDocumentTextDetectionWithContext is the same as StartDocumentTextDetection with the addition of
// the ability to pass a context and additional request options.
//
// See StartDocumentTextDetection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) StartDocumentTextDetectionWithContext(ctx aws.Context, input *StartDocumentTextDetectionInput, opts ...request.Option) (*StartDocumentTextDetectionOutput, error) {
	req, out := c.StartDocumentTextDetectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AnalyzeDocumentInput struct {
	_ struct{} `type:"structure"`

	// The input document as base64-encoded bytes or an Amazon S3 object. If you
	// use the AWS CLI to call Amazon Textract operations, you can't pass image
	// bytes. The document must be an image in JPG or PNG format.
	//
	// If you are using an AWS SDK to call Amazon Textract, you might not need to
	// base64-encode image bytes passed using the Bytes field.
	//
	// Document is a required field
	Document *Document `type:"structure" required:"true"`

	// A list of the types of analysis to perform. Add TABLES to the list to return
	// information about the tables detected in the input document. Add FORMS to
	// return detected fields and the associated text. To perform both types of
	// analysis, add TABLES and FORMS to FeatureTypes.
	//
	// FeatureTypes is a required field
	FeatureTypes []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s AnalyzeDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyzeDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyzeDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyzeDocumentInput"}
	if s.Document == nil {
		invalidParams.Add(request.NewErrParamRequired("Document"))
	}
	if s.FeatureTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureTypes"))
	}
	if s.Document != nil {
		if err := s.Document.Validate(); err != nil {
			invalidParams.AddNested("Document", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocument sets the Document field's value.
func (s *AnalyzeDocumentInput) SetDocument(v *Document) *AnalyzeDocumentInput {
	s.Document = v
	return s
}

// SetFeatureTypes sets the FeatureTypes field's value.
func (s *AnalyzeDocumentInput) SetFeatureTypes(v []*string) *AnalyzeDocumentInput {
	s.FeatureTypes = v
	return s
}

type AnalyzeDocumentOutput struct {
	_ struct{} `type:"structure"`

	// The text that's detected and analyzed by AnalyzeDocument.
	Blocks []*Block `type:"list"`

	// Metadata about the analyzed document. An example is the number of pages.
	DocumentMetadata *DocumentMetadata `type:"structure"`
}

// String returns the string representation
func (s AnalyzeDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AnalyzeDocumentOutput) GoString() string {
	return s.String()
}

// SetBlocks sets the Blocks field's value.
func (s *AnalyzeDocumentOutput) SetBlocks(v []*Block) *AnalyzeDocumentOutput {
	s.Blocks = v
	return s
}

// SetDocumentMetadata sets the DocumentMetadata field's value.
func (s *AnalyzeDocumentOutput) SetDocumentMetadata(v *DocumentMetadata) *AnalyzeDocumentOutput {
	s.DocumentMetadata = v
	return s
}

// A Block represents items that are recognized in a document within a group
// of pixels close to each other. The information returned in a Block depends
// on the type of operation. In document-text detection (for example DetectDocumentText),
// you get information about the detected words and lines of text. In text analysis
// (for example AnalyzeDocument), you can also get information about the fields,
// tables and selection elements that are detected in the document.
//
// An array of Block objects is returned by both synchronous and asynchronous
// operations. In synchronous operations, such as DetectDocumentText, the array
// of Block objects is the entire set of results. In asynchronous operations,
// such as GetDocumentAnalysis, the array is returned over one or more responses.
//
// For more information, see How Amazon Textract Works (https://docs.aws.amazon.com/textract/latest/dg/how-it-works.html).
type Block struct {
	_ struct{} `type:"structure"`

	// The type of text that's recognized in a block. In text-detection operations,
	// the following types are returned:
	//
	//    * PAGE - Contains a list of the LINE Block objects that are detected on
	//    a document page.
	//
	//    * WORD - A word detected on a document page. A word is one or more ISO
	//    basic Latin script characters that aren't separated by spaces.
	//
	//    * LINE - A string of tab-delimited, contiguous words that's detected on
	//    a document page.
	//
	// In text analysis operations, the following types are returned:
	//
	//    * PAGE - Contains a list of child Block objects that are detected on a
	//    document page.
	//
	//    * KEY_VALUE_SET - Stores the KEY and VALUE Block objects for a field that's
	//    detected on a document page. Use the EntityType field to determine if
	//    a KEY_VALUE_SET object is a KEY Block object or a VALUE Block object.
	//
	//    * WORD - A word detected on a document page. A word is one or more ISO
	//    basic Latin script characters that aren't separated by spaces that's detected
	//    on a document page.
	//
	//    * LINE - A string of tab-delimited, contiguous words that's detected on
	//    a document page.
	//
	//    * TABLE - A table that's detected on a document page. A table is any grid-based
	//    information with 2 or more rows or columns with a cell span of 1 row and
	//    1 column each.
	//
	//    * CELL - A cell within a detected table. The cell is the parent of the
	//    block that contains the text in the cell.
	//
	//    * SELECTION_ELEMENT - A selectable element such as a radio button or checkbox
	//    that's detected on a document page. Use the value of SelectionStatus to
	//    determine the status of the selection element.
	BlockType *string `type:"string" enum:"BlockType"`

	// The column in which a table cell appears. The first column position is 1.
	// ColumnIndex isn't returned by DetectDocumentText and GetDocumentTextDetection.
	ColumnIndex *int64 `type:"integer"`

	// The number of columns that a table cell spans. ColumnSpan isn't returned
	// by DetectDocumentText and GetDocumentTextDetection.
	ColumnSpan *int64 `type:"integer"`

	// The confidence that Amazon Textract has in the accuracy of the recognized
	// text and the accuracy of the geometry points around the recognized text.
	Confidence *float64 `type:"float"`

	// The type of entity. The following can be returned:
	//
	//    * KEY - An identifier for a field on the document.
	//
	//    * VALUE - The field text.
	//
	// EntityTypes isn't returned by DetectDocumentText and GetDocumentTextDetection.
	EntityTypes []*string `type:"list"`

	// The location of the recognized text on the image. It includes an axis-aligned,
	// coarse bounding box that surrounds the text, and a finer-grain polygon for
	// more accurate spatial information.
	Geometry *Geometry `type:"structure"`

	// The identifier for the recognized text. The identifier is only unique for
	// a single operation.
	Id *string `type:"string"`

	// The page in which a block was detected. Page is returned by asynchronous
	// operations. Page values greater than 1 are only returned for multi-page documents
	// that are in PDF format. A scanned image (JPG/PNG), even if it contains multiple
	// document pages, is always considered to be a single-page document and the
	// value of Page is always 1. Synchronous operations don't return Page as every
	// input document is considered to be a single-page document.
	Page *int64 `type:"integer"`

	// A list of child blocks of the current block. For example a LINE object has
	// child blocks for each WORD block that's part of the line of text. There aren't
	// Relationship objects in the list for relationships that don't exist, such
	// as when the current block has no child blocks. The list size can be the following:
	//
	//    * 0 - The block has no child blocks.
	//
	//    * 1 - The block has child blocks.
	Relationships []*Relationship `type:"list"`

	// The row in which a table cell is located. The first row position is 1. RowIndex
	// isn't returned by DetectDocumentText and GetDocumentTextDetection.
	RowIndex *int64 `type:"integer"`

	// The number of rows that a table spans. RowSpan isn't returned by DetectDocumentText
	// and GetDocumentTextDetection.
	RowSpan *int64 `type:"integer"`

	// The selection status of a selectable element such as a radio button or checkbox.
	SelectionStatus *string `type:"string" enum:"SelectionStatus"`

	// The word or line of text that's recognized by Amazon Textract.
	Text *string `type:"string"`
}

// String returns the string representation
func (s Block) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Block) GoString() string {
	return s.String()
}

// SetBlockType sets the BlockType field's value.
func (s *Block) SetBlockType(v string) *Block {
	s.BlockType = &v
	return s
}

// SetColumnIndex sets the ColumnIndex field's value.
func (s *Block) SetColumnIndex(v int64) *Block {
	s.ColumnIndex = &v
	return s
}

// SetColumnSpan sets the ColumnSpan field's value.
func (s *Block) SetColumnSpan(v int64) *Block {
	s.ColumnSpan = &v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *Block) SetConfidence(v float64) *Block {
	s.Confidence = &v
	return s
}

// SetEntityTypes sets the EntityTypes field's value.
func (s *Block) SetEntityTypes(v []*string) *Block {
	s.EntityTypes = v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *Block) SetGeometry(v *Geometry) *Block {
	s.Geometry = v
	return s
}

// SetId sets the Id field's value.
func (s *Block) SetId(v string) *Block {
	s.Id = &v
	return s
}

// SetPage sets the Page field's value.
func (s *Block) SetPage(v int64) *Block {
	s.Page = &v
	return s
}

// SetRelationships sets the Relationships field's value.
func (s *Block) SetRelationships(v []*Relationship) *Block {
	s.Relationships = v
	return s
}

// SetRowIndex sets the RowIndex field's value.
func (s *Block) SetRowIndex(v int64) *Block {
	s.RowIndex = &v
	return s
}

// SetRowSpan sets the RowSpan field's value.
func (s *Block) SetRowSpan(v int64) *Block {
	s.RowSpan = &v
	return s
}

// SetSelectionStatus sets the SelectionStatus field's value.
func (s *Block) SetSelectionStatus(v string) *Block {
	s.SelectionStatus = &v
	return s
}

// SetText sets the Text field's value.
func (s *Block) SetText(v string) *Block {
	s.Text = &v
	return s
}

// The bounding box around the recognized text, key, value, table or table cell
// on a document page. The left (x-coordinate) and top (y-coordinate) are coordinates
// that represent the top and left sides of the bounding box. Note that the
// upper-left corner of the image is the origin (0,0).
//
// The top and left values returned are ratios of the overall document page
// size. For example, if the input image is 700 x 200 pixels, and the top-left
// coordinate of the bounding box is 350 x 50 pixels, the API returns a left
// value of 0.5 (350/700) and a top value of 0.25 (50/200).
//
// The width and height values represent the dimensions of the bounding box
// as a ratio of the overall document page dimension. For example, if the document
// page size is 700 x 200 pixels, and the bounding box width is 70 pixels, the
// width returned is 0.1.
type BoundingBox struct {
	_ struct{} `type:"structure"`

	// The height of the bounding box as a ratio of the overall document page height.
	Height *float64 `type:"float"`

	// The left coordinate of the bounding box as a ratio of overall document page
	// width.
	Left *float64 `type:"float"`

	// The top coordinate of the bounding box as a ratio of overall document page
	// height.
	Top *float64 `type:"float"`

	// The width of the bounding box as a ratio of the overall document page width.
	Width *float64 `type:"float"`
}

// String returns the string representation
func (s BoundingBox) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BoundingBox) GoString() string {
	return s.String()
}

// SetHeight sets the Height field's value.
func (s *BoundingBox) SetHeight(v float64) *BoundingBox {
	s.Height = &v
	return s
}

// SetLeft sets the Left field's value.
func (s *BoundingBox) SetLeft(v float64) *BoundingBox {
	s.Left = &v
	return s
}

// SetTop sets the Top field's value.
func (s *BoundingBox) SetTop(v float64) *BoundingBox {
	s.Top = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *BoundingBox) SetWidth(v float64) *BoundingBox {
	s.Width = &v
	return s
}

type DetectDocumentTextInput struct {
	_ struct{} `type:"structure"`

	// The input document as base64-encoded bytes or an Amazon S3 object. If you
	// use the AWS CLI to call Amazon Textract operations, you can't pass image
	// bytes. The document must be an image in JPG or PNG format.
	//
	// If you are using an AWS SDK to call Amazon Textract, you might not need to
	// base64-encode image bytes passed using the Bytes field.
	//
	// Document is a required field
	Document *Document `type:"structure" required:"true"`
}

// String returns the string representation
func (s DetectDocumentTextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectDocumentTextInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectDocumentTextInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectDocumentTextInput"}
	if s.Document == nil {
		invalidParams.Add(request.NewErrParamRequired("Document"))
	}
	if s.Document != nil {
		if err := s.Document.Validate(); err != nil {
			invalidParams.AddNested("Document", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocument sets the Document field's value.
func (s *DetectDocumentTextInput) SetDocument(v *Document) *DetectDocumentTextInput {
	s.Document = v
	return s
}

type DetectDocumentTextOutput struct {
	_ struct{} `type:"structure"`

	// An array of Block objects containing the text detected in the document.
	Blocks []*Block `type:"list"`

	// Metadata about the document. Contains the number of pages that are detected
	// in the document.
	DocumentMetadata *DocumentMetadata `type:"structure"`
}

// String returns the string representation
func (s DetectDocumentTextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DetectDocumentTextOutput) GoString() string {
	return s.String()
}

// SetBlocks sets the Blocks field's value.
func (s *DetectDocumentTextOutput) SetBlocks(v []*Block) *DetectDocumentTextOutput {
	s.Blocks = v
	return s
}

// SetDocumentMetadata sets the DocumentMetadata field's value.
func (s *DetectDocumentTextOutput) SetDocumentMetadata(v *DocumentMetadata) *DetectDocumentTextOutput {
	s.DocumentMetadata = v
	return s
}

// The input document, either as bytes or as an S3 object.
//
// You pass image bytes to an Amazon Textract API operation by using the Bytes
// property. For example, you would use the Bytes property to pass a document
// loaded from a local file system. Image bytes passed by using the Bytes property
// must be base64 encoded. Your code might not need to encode document file
// bytes if you're using an AWS SDK to call Amazon Textract API operations.
//
// You pass images stored in an S3 bucket to an Amazon Textract API operation
// by using the S3Object property. Documents stored in an S3 bucket don't need
// to be base64 encoded.
//
// The AWS Region for the S3 bucket that contains the S3 object must match the
// AWS Region that you use for Amazon Textract operations.
//
// If you use the AWS CLI to call Amazon Textract operations, passing image
// bytes using the Bytes property isn't supported. You must first upload the
// document to an Amazon S3 bucket, and then call the operation using the S3Object
// property.
//
// For Amazon Textract to process an S3 object, the user must have permission
// to access the S3 object.
type Document struct {
	_ struct{} `type:"structure"`

	// A blob of base-64 encoded documents bytes. The maximum size of a document
	// that's provided in a blob of bytes is 5 MB. The document bytes must be in
	// PNG or JPG format.
	//
	// If you are using an AWS SDK to call Amazon Textract, you might not need to
	// base64-encode image bytes passed using the Bytes field.
	//
	// Bytes is automatically base64 encoded/decoded by the SDK.
	Bytes []byte `min:"1" type:"blob"`

	// Identifies an S3 object as the document source. The maximum size of a document
	// stored in an S3 bucket is 5 MB.
	S3Object *S3Object `type:"structure"`
}

// String returns the string representation
func (s Document) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Document) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Document) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Document"}
	if s.Bytes != nil && len(s.Bytes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bytes", 1))
	}
	if s.S3Object != nil {
		if err := s.S3Object.Validate(); err != nil {
			invalidParams.AddNested("S3Object", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBytes sets the Bytes field's value.
func (s *Document) SetBytes(v []byte) *Document {
	s.Bytes = v
	return s
}

// SetS3Object sets the S3Object field's value.
func (s *Document) SetS3Object(v *S3Object) *Document {
	s.S3Object = v
	return s
}

// The Amazon S3 bucket that contains the document to be processed. It's used
// by asynchronous operations such as StartDocumentTextDetection.
//
// The input document can be an image file in JPG or PNG format. It can also
// be a file in PDF format.
type DocumentLocation struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket that contains the input document.
	S3Object *S3Object `type:"structure"`
}

// String returns the string representation
func (s DocumentLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentLocation"}
	if s.S3Object != nil {
		if err := s.S3Object.Validate(); err != nil {
			invalidParams.AddNested("S3Object", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Object sets the S3Object field's value.
func (s *DocumentLocation) SetS3Object(v *S3Object) *DocumentLocation {
	s.S3Object = v
	return s
}

// Information about the input document.
type DocumentMetadata struct {
	_ struct{} `type:"structure"`

	// The number of pages detected in the document.
	Pages *int64 `type:"integer"`
}

// String returns the string representation
func (s DocumentMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DocumentMetadata) GoString() string {
	return s.String()
}

// SetPages sets the Pages field's value.
func (s *DocumentMetadata) SetPages(v int64) *DocumentMetadata {
	s.Pages = &v
	return s
}

// Information about where a recognized text, key, value, table, or table cell
// is located on a document page.
type Geometry struct {
	_ struct{} `type:"structure"`

	// An axis-aligned coarse representation of the location of the recognized text
	// on the document page.
	BoundingBox *BoundingBox `type:"structure"`

	// Within the bounding box, a fine-grained polygon around the recognized text.
	Polygon []*Point `type:"list"`
}

// String returns the string representation
func (s Geometry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Geometry) GoString() string {
	return s.String()
}

// SetBoundingBox sets the BoundingBox field's value.
func (s *Geometry) SetBoundingBox(v *BoundingBox) *Geometry {
	s.BoundingBox = v
	return s
}

// SetPolygon sets the Polygon field's value.
func (s *Geometry) SetPolygon(v []*Point) *Geometry {
	s.Polygon = v
	return s
}

type GetDocumentAnalysisInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the text-detection job. The JobId is returned from
	// StartDocumentAnalysis.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The maximum number of results to return per paginated call. The largest value
	// that you can specify is 1,000. If you specify a value greater than 1,000,
	// a maximum of 1,000 results is returned. The default value is 1,000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there are more blocks to
	// retrieve), Amazon Textract returns a pagination token in the response. You
	// can use this pagination token to retrieve the next set of blocks.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetDocumentAnalysisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentAnalysisInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDocumentAnalysisInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDocumentAnalysisInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetDocumentAnalysisInput) SetJobId(v string) *GetDocumentAnalysisInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDocumentAnalysisInput) SetMaxResults(v int64) *GetDocumentAnalysisInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDocumentAnalysisInput) SetNextToken(v string) *GetDocumentAnalysisInput {
	s.NextToken = &v
	return s
}

type GetDocumentAnalysisOutput struct {
	_ struct{} `type:"structure"`

	// The results of the text analysis operation.
	Blocks []*Block `type:"list"`

	// Information about a document that Amazon Textract processed. DocumentMetadata
	// is returned in every page of paginated responses from an Amazon Textract
	// video operation.
	DocumentMetadata *DocumentMetadata `type:"structure"`

	// The current status of the text detection job.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// If the response is truncated, Amazon Textract returns this token. You can
	// use this token in the subsequent request to retrieve the next set of text
	// detection results.
	NextToken *string `min:"1" type:"string"`

	// The current status of an asynchronous document analysis operation.
	StatusMessage *string `type:"string"`

	// A list of warnings that occurred during the document analysis operation.
	Warnings []*Warning `type:"list"`
}

// String returns the string representation
func (s GetDocumentAnalysisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentAnalysisOutput) GoString() string {
	return s.String()
}

// SetBlocks sets the Blocks field's value.
func (s *GetDocumentAnalysisOutput) SetBlocks(v []*Block) *GetDocumentAnalysisOutput {
	s.Blocks = v
	return s
}

// SetDocumentMetadata sets the DocumentMetadata field's value.
func (s *GetDocumentAnalysisOutput) SetDocumentMetadata(v *DocumentMetadata) *GetDocumentAnalysisOutput {
	s.DocumentMetadata = v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *GetDocumentAnalysisOutput) SetJobStatus(v string) *GetDocumentAnalysisOutput {
	s.JobStatus = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDocumentAnalysisOutput) SetNextToken(v string) *GetDocumentAnalysisOutput {
	s.NextToken = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetDocumentAnalysisOutput) SetStatusMessage(v string) *GetDocumentAnalysisOutput {
	s.StatusMessage = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *GetDocumentAnalysisOutput) SetWarnings(v []*Warning) *GetDocumentAnalysisOutput {
	s.Warnings = v
	return s
}

type GetDocumentTextDetectionInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the text detection job. The JobId is returned from
	// StartDocumentTextDetection.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The maximum number of results to return per paginated call. The largest value
	// you can specify is 1,000. If you specify a value greater than 1,000, a maximum
	// of 1,000 results is returned. The default value is 1,000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there are more blocks to
	// retrieve), Amazon Textract returns a pagination token in the response. You
	// can use this pagination token to retrieve the next set of blocks.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetDocumentTextDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentTextDetectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDocumentTextDetectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDocumentTextDetectionInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetDocumentTextDetectionInput) SetJobId(v string) *GetDocumentTextDetectionInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDocumentTextDetectionInput) SetMaxResults(v int64) *GetDocumentTextDetectionInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDocumentTextDetectionInput) SetNextToken(v string) *GetDocumentTextDetectionInput {
	s.NextToken = &v
	return s
}

type GetDocumentTextDetectionOutput struct {
	_ struct{} `type:"structure"`

	// The results of the text-detection operation.
	Blocks []*Block `type:"list"`

	// Information about a document that Amazon Textract processed. DocumentMetadata
	// is returned in every page of paginated responses from an Amazon Textract
	// video operation.
	DocumentMetadata *DocumentMetadata `type:"structure"`

	// The current status of the text detection job.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// If the response is truncated, Amazon Textract returns this token. You can
	// use this token in the subsequent request to retrieve the next set of text-detection
	// results.
	NextToken *string `min:"1" type:"string"`

	// The current status of an asynchronous document text-detection operation.
	StatusMessage *string `type:"string"`

	// A list of warnings that occurred during the document text-detection operation.
	Warnings []*Warning `type:"list"`
}

// String returns the string representation
func (s GetDocumentTextDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetDocumentTextDetectionOutput) GoString() string {
	return s.String()
}

// SetBlocks sets the Blocks field's value.
func (s *GetDocumentTextDetectionOutput) SetBlocks(v []*Block) *GetDocumentTextDetectionOutput {
	s.Blocks = v
	return s
}

// SetDocumentMetadata sets the DocumentMetadata field's value.
func (s *GetDocumentTextDetectionOutput) SetDocumentMetadata(v *DocumentMetadata) *GetDocumentTextDetectionOutput {
	s.DocumentMetadata = v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *GetDocumentTextDetectionOutput) SetJobStatus(v string) *GetDocumentTextDetectionOutput {
	s.JobStatus = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDocumentTextDetectionOutput) SetNextToken(v string) *GetDocumentTextDetectionOutput {
	s.NextToken = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetDocumentTextDetectionOutput) SetStatusMessage(v string) *GetDocumentTextDetectionOutput {
	s.StatusMessage = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *GetDocumentTextDetectionOutput) SetWarnings(v []*Warning) *GetDocumentTextDetectionOutput {
	s.Warnings = v
	return s
}

// The Amazon Simple Notification Service (Amazon SNS) topic to which Amazon
// Textract publishes the completion status of an asynchronous document operation,
// such as StartDocumentTextDetection.
type NotificationChannel struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that gives Amazon Textract
	// publishing permissions to the Amazon SNS topic.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The Amazon SNS topic that Amazon Textract posts the completion status to.
	//
	// SNSTopicArn is a required field
	SNSTopicArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s NotificationChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotificationChannel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationChannel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationChannel"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.SNSTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SNSTopicArn"))
	}
	if s.SNSTopicArn != nil && len(*s.SNSTopicArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SNSTopicArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *NotificationChannel) SetRoleArn(v string) *NotificationChannel {
	s.RoleArn = &v
	return s
}

// SetSNSTopicArn sets the SNSTopicArn field's value.
func (s *NotificationChannel) SetSNSTopicArn(v string) *NotificationChannel {
	s.SNSTopicArn = &v
	return s
}

// The X and Y coordinates of a point on a document page. The X and Y values
// returned are ratios of the overall document page size. For example, if the
// input document is 700 x 200 and the operation returns X=0.5 and Y=0.25, then
// the point is at the (350,50) pixel coordinate on the document page.
//
// An array of Point objects, Polygon, is returned by DetectDocumentText. Polygon
// represents a fine-grained polygon around detected text. For more information,
// see Geometry in the Amazon Textract Developer Guide.
type Point struct {
	_ struct{} `type:"structure"`

	// The value of the X coordinate for a point on a Polygon.
	X *float64 `type:"float"`

	// The value of the Y coordinate for a point on a Polygon.
	Y *float64 `type:"float"`
}

// String returns the string representation
func (s Point) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Point) GoString() string {
	return s.String()
}

// SetX sets the X field's value.
func (s *Point) SetX(v float64) *Point {
	s.X = &v
	return s
}

// SetY sets the Y field's value.
func (s *Point) SetY(v float64) *Point {
	s.Y = &v
	return s
}

// Information about how blocks are related to each other. A Block object contains
// 0 or more Relation objects in a list, Relationships. For more information,
// see Block.
//
// The Type element provides the type of the relationship for all blocks in
// the IDs array.
type Relationship struct {
	_ struct{} `type:"structure"`

	// An array of IDs for related blocks. You can get the type of the relationship
	// from the Type element.
	Ids []*string `type:"list"`

	// The type of relationship that the blocks in the IDs array have with the current
	// block. The relationship can be VALUE or CHILD.
	Type *string `type:"string" enum:"RelationshipType"`
}

// String returns the string representation
func (s Relationship) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Relationship) GoString() string {
	return s.String()
}

// SetIds sets the Ids field's value.
func (s *Relationship) SetIds(v []*string) *Relationship {
	s.Ids = v
	return s
}

// SetType sets the Type field's value.
func (s *Relationship) SetType(v string) *Relationship {
	s.Type = &v
	return s
}

// The S3 bucket name and file name that identifies the document.
//
// The AWS Region for the S3 bucket that contains the document must match the
// Region that you use for Amazon Textract operations.
//
// For Amazon Textract to process a file in an S3 bucket, the user must have
// permission to access the S3 bucket and file.
type S3Object struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket.
	Bucket *string `min:"3" type:"string"`

	// The file name of the input document. It must be an image file (.JPG or .PNG
	// format). Asynchronous operations also support PDF files.
	Name *string `min:"1" type:"string"`

	// If the bucket has versioning enabled, you can specify the object version.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation
func (s S3Object) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s S3Object) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Object) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Object"}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3Object) SetBucket(v string) *S3Object {
	s.Bucket = &v
	return s
}

// SetName sets the Name field's value.
func (s *S3Object) SetName(v string) *S3Object {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *S3Object) SetVersion(v string) *S3Object {
	s.Version = &v
	return s
}

type StartDocumentAnalysisInput struct {
	_ struct{} `type:"structure"`

	// The idempotent token that you use to identify the start request. If you use
	// the same token with multiple StartDocumentAnalysis requests, the same JobId
	// is returned. Use ClientRequestToken to prevent the same job from being accidentally
	// started more than once.
	ClientRequestToken *string `min:"1" type:"string"`

	// The location of the document to be processed.
	//
	// DocumentLocation is a required field
	DocumentLocation *DocumentLocation `type:"structure" required:"true"`

	// A list of the types of analysis to perform. Add TABLES to the list to return
	// information about the tables that are detected in the input document. Add
	// FORMS to return detected fields and the associated text. To perform both
	// types of analysis, add TABLES and FORMS to FeatureTypes. All selectable elements
	// (SELECTION_ELEMENT) that are detected are returned, whatever the value of
	// FeatureTypes.
	//
	// FeatureTypes is a required field
	FeatureTypes []*string `type:"list" required:"true"`

	// An identifier you specify that's included in the completion notification
	// that's published to the Amazon SNS topic. For example, you can use JobTag
	// to identify the type of document, such as a tax form or a receipt, that the
	// completion notification corresponds to.
	JobTag *string `min:"1" type:"string"`

	// The Amazon SNS topic ARN that you want Amazon Textract to publish the completion
	// status of the operation to.
	NotificationChannel *NotificationChannel `type:"structure"`
}

// String returns the string representation
func (s StartDocumentAnalysisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDocumentAnalysisInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDocumentAnalysisInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDocumentAnalysisInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DocumentLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentLocation"))
	}
	if s.FeatureTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureTypes"))
	}
	if s.JobTag != nil && len(*s.JobTag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobTag", 1))
	}
	if s.DocumentLocation != nil {
		if err := s.DocumentLocation.Validate(); err != nil {
			invalidParams.AddNested("DocumentLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartDocumentAnalysisInput) SetClientRequestToken(v string) *StartDocumentAnalysisInput {
	s.ClientRequestToken = &v
	return s
}

// SetDocumentLocation sets the DocumentLocation field's value.
func (s *StartDocumentAnalysisInput) SetDocumentLocation(v *DocumentLocation) *StartDocumentAnalysisInput {
	s.DocumentLocation = v
	return s
}

// SetFeatureTypes sets the FeatureTypes field's value.
func (s *StartDocumentAnalysisInput) SetFeatureTypes(v []*string) *StartDocumentAnalysisInput {
	s.FeatureTypes = v
	return s
}

// SetJobTag sets the JobTag field's value.
func (s *StartDocumentAnalysisInput) SetJobTag(v string) *StartDocumentAnalysisInput {
	s.JobTag = &v
	return s
}

// SetNotificationChannel sets the NotificationChannel field's value.
func (s *StartDocumentAnalysisInput) SetNotificationChannel(v *NotificationChannel) *StartDocumentAnalysisInput {
	s.NotificationChannel = v
	return s
}

type StartDocumentAnalysisOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the document text detection job. Use JobId to identify
	// the job in a subsequent call to GetDocumentAnalysis.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartDocumentAnalysisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDocumentAnalysisOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartDocumentAnalysisOutput) SetJobId(v string) *StartDocumentAnalysisOutput {
	s.JobId = &v
	return s
}

type StartDocumentTextDetectionInput struct {
	_ struct{} `type:"structure"`

	// The idempotent token that's used to identify the start request. If you use
	// the same token with multiple StartDocumentTextDetection requests, the same
	// JobId is returned. Use ClientRequestToken to prevent the same job from being
	// accidentally started more than once.
	ClientRequestToken *string `min:"1" type:"string"`

	// The location of the document to be processed.
	//
	// DocumentLocation is a required field
	DocumentLocation *DocumentLocation `type:"structure" required:"true"`

	// An identifier you specify that's included in the completion notification
	// that's published to the Amazon SNS topic. For example, you can use JobTag
	// to identify the type of document, such as a tax form or a receipt, that the
	// completion notification corresponds to.
	JobTag *string `min:"1" type:"string"`

	// The Amazon SNS topic ARN that you want Amazon Textract to publish the completion
	// status of the operation to.
	NotificationChannel *NotificationChannel `type:"structure"`
}

// String returns the string representation
func (s StartDocumentTextDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDocumentTextDetectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDocumentTextDetectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDocumentTextDetectionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DocumentLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentLocation"))
	}
	if s.JobTag != nil && len(*s.JobTag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobTag", 1))
	}
	if s.DocumentLocation != nil {
		if err := s.DocumentLocation.Validate(); err != nil {
			invalidParams.AddNested("DocumentLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartDocumentTextDetectionInput) SetClientRequestToken(v string) *StartDocumentTextDetectionInput {
	s.ClientRequestToken = &v
	return s
}

// SetDocumentLocation sets the DocumentLocation field's value.
func (s *StartDocumentTextDetectionInput) SetDocumentLocation(v *DocumentLocation) *StartDocumentTextDetectionInput {
	s.DocumentLocation = v
	return s
}

// SetJobTag sets the JobTag field's value.
func (s *StartDocumentTextDetectionInput) SetJobTag(v string) *StartDocumentTextDetectionInput {
	s.JobTag = &v
	return s
}

// SetNotificationChannel sets the NotificationChannel field's value.
func (s *StartDocumentTextDetectionInput) SetNotificationChannel(v *NotificationChannel) *StartDocumentTextDetectionInput {
	s.NotificationChannel = v
	return s
}

type StartDocumentTextDetectionOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the document text-detection job. Use JobId to identify
	// the job in a subsequent call to GetDocumentTextDetection.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s StartDocumentTextDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StartDocumentTextDetectionOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartDocumentTextDetectionOutput) SetJobId(v string) *StartDocumentTextDetectionOutput {
	s.JobId = &v
	return s
}

// A warning about an issue that occurred during asynchronous text analysis
// (StartDocumentAnalysis) or asynchronous document-text detection (StartDocumentTextDetection).
type Warning struct {
	_ struct{} `type:"structure"`

	// The error code for the warning.
	ErrorCode *string `type:"string"`

	// A list of the pages that the warning applies to.
	Pages []*int64 `type:"list"`
}

// String returns the string representation
func (s Warning) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Warning) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Warning) SetErrorCode(v string) *Warning {
	s.ErrorCode = &v
	return s
}

// SetPages sets the Pages field's value.
func (s *Warning) SetPages(v []*int64) *Warning {
	s.Pages = v
	return s
}

const (
	// BlockTypeKeyValueSet is a BlockType enum value
	BlockTypeKeyValueSet = "KEY_VALUE_SET"

	// BlockTypePage is a BlockType enum value
	BlockTypePage = "PAGE"

	// BlockTypeLine is a BlockType enum value
	BlockTypeLine = "LINE"

	// BlockTypeWord is a BlockType enum value
	BlockTypeWord = "WORD"

	// BlockTypeTable is a BlockType enum value
	BlockTypeTable = "TABLE"

	// BlockTypeCell is a BlockType enum value
	BlockTypeCell = "CELL"

	// BlockTypeSelectionElement is a BlockType enum value
	BlockTypeSelectionElement = "SELECTION_ELEMENT"
)

const (
	// EntityTypeKey is a EntityType enum value
	EntityTypeKey = "KEY"

	// EntityTypeValue is a EntityType enum value
	EntityTypeValue = "VALUE"
)

const (
	// FeatureTypeTables is a FeatureType enum value
	FeatureTypeTables = "TABLES"

	// FeatureTypeForms is a FeatureType enum value
	FeatureTypeForms = "FORMS"
)

const (
	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "IN_PROGRESS"

	// JobStatusSucceeded is a JobStatus enum value
	JobStatusSucceeded = "SUCCEEDED"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"

	// JobStatusPartialSuccess is a JobStatus enum value
	JobStatusPartialSuccess = "PARTIAL_SUCCESS"
)

const (
	// RelationshipTypeValue is a RelationshipType enum value
	RelationshipTypeValue = "VALUE"

	// RelationshipTypeChild is a RelationshipType enum value
	RelationshipTypeChild = "CHILD"
)

const (
	// SelectionStatusSelected is a SelectionStatus enum value
	SelectionStatusSelected = "SELECTED"

	// SelectionStatusNotSelected is a SelectionStatus enum value
	SelectionStatusNotSelected = "NOT_SELECTED"
)
