package visualsearch

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
)

// Currency enumerates the values for currency.
type Currency string

const (
	// AED ...
	AED Currency = "AED"
	// AFN ...
	AFN Currency = "AFN"
	// ALL ...
	ALL Currency = "ALL"
	// AMD ...
	AMD Currency = "AMD"
	// ANG ...
	ANG Currency = "ANG"
	// AOA ...
	AOA Currency = "AOA"
	// ARS ...
	ARS Currency = "ARS"
	// AUD ...
	AUD Currency = "AUD"
	// AWG ...
	AWG Currency = "AWG"
	// AZN ...
	AZN Currency = "AZN"
	// BAM ...
	BAM Currency = "BAM"
	// BBD ...
	BBD Currency = "BBD"
	// BDT ...
	BDT Currency = "BDT"
	// BGN ...
	BGN Currency = "BGN"
	// BHD ...
	BHD Currency = "BHD"
	// BIF ...
	BIF Currency = "BIF"
	// BMD ...
	BMD Currency = "BMD"
	// BND ...
	BND Currency = "BND"
	// BOB ...
	BOB Currency = "BOB"
	// BOV ...
	BOV Currency = "BOV"
	// BRL ...
	BRL Currency = "BRL"
	// BSD ...
	BSD Currency = "BSD"
	// BTN ...
	BTN Currency = "BTN"
	// BWP ...
	BWP Currency = "BWP"
	// BYR ...
	BYR Currency = "BYR"
	// BZD ...
	BZD Currency = "BZD"
	// CAD ...
	CAD Currency = "CAD"
	// CDF ...
	CDF Currency = "CDF"
	// CHE ...
	CHE Currency = "CHE"
	// CHF ...
	CHF Currency = "CHF"
	// CHW ...
	CHW Currency = "CHW"
	// CLF ...
	CLF Currency = "CLF"
	// CLP ...
	CLP Currency = "CLP"
	// CNY ...
	CNY Currency = "CNY"
	// COP ...
	COP Currency = "COP"
	// COU ...
	COU Currency = "COU"
	// CRC ...
	CRC Currency = "CRC"
	// CUC ...
	CUC Currency = "CUC"
	// CUP ...
	CUP Currency = "CUP"
	// CVE ...
	CVE Currency = "CVE"
	// CZK ...
	CZK Currency = "CZK"
	// DJF ...
	DJF Currency = "DJF"
	// DKK ...
	DKK Currency = "DKK"
	// DOP ...
	DOP Currency = "DOP"
	// DZD ...
	DZD Currency = "DZD"
	// EGP ...
	EGP Currency = "EGP"
	// ERN ...
	ERN Currency = "ERN"
	// ETB ...
	ETB Currency = "ETB"
	// EUR ...
	EUR Currency = "EUR"
	// FJD ...
	FJD Currency = "FJD"
	// FKP ...
	FKP Currency = "FKP"
	// GBP ...
	GBP Currency = "GBP"
	// GEL ...
	GEL Currency = "GEL"
	// GHS ...
	GHS Currency = "GHS"
	// GIP ...
	GIP Currency = "GIP"
	// GMD ...
	GMD Currency = "GMD"
	// GNF ...
	GNF Currency = "GNF"
	// GTQ ...
	GTQ Currency = "GTQ"
	// GYD ...
	GYD Currency = "GYD"
	// HKD ...
	HKD Currency = "HKD"
	// HNL ...
	HNL Currency = "HNL"
	// HRK ...
	HRK Currency = "HRK"
	// HTG ...
	HTG Currency = "HTG"
	// HUF ...
	HUF Currency = "HUF"
	// IDR ...
	IDR Currency = "IDR"
	// ILS ...
	ILS Currency = "ILS"
	// INR ...
	INR Currency = "INR"
	// IQD ...
	IQD Currency = "IQD"
	// IRR ...
	IRR Currency = "IRR"
	// ISK ...
	ISK Currency = "ISK"
	// JMD ...
	JMD Currency = "JMD"
	// JOD ...
	JOD Currency = "JOD"
	// JPY ...
	JPY Currency = "JPY"
	// KES ...
	KES Currency = "KES"
	// KGS ...
	KGS Currency = "KGS"
	// KHR ...
	KHR Currency = "KHR"
	// KMF ...
	KMF Currency = "KMF"
	// KPW ...
	KPW Currency = "KPW"
	// KRW ...
	KRW Currency = "KRW"
	// KWD ...
	KWD Currency = "KWD"
	// KYD ...
	KYD Currency = "KYD"
	// KZT ...
	KZT Currency = "KZT"
	// LAK ...
	LAK Currency = "LAK"
	// LBP ...
	LBP Currency = "LBP"
	// LKR ...
	LKR Currency = "LKR"
	// LRD ...
	LRD Currency = "LRD"
	// LSL ...
	LSL Currency = "LSL"
	// LYD ...
	LYD Currency = "LYD"
	// MAD ...
	MAD Currency = "MAD"
	// MDL ...
	MDL Currency = "MDL"
	// MGA ...
	MGA Currency = "MGA"
	// MKD ...
	MKD Currency = "MKD"
	// MMK ...
	MMK Currency = "MMK"
	// MNT ...
	MNT Currency = "MNT"
	// MOP ...
	MOP Currency = "MOP"
	// MRO ...
	MRO Currency = "MRO"
	// MUR ...
	MUR Currency = "MUR"
	// MVR ...
	MVR Currency = "MVR"
	// MWK ...
	MWK Currency = "MWK"
	// MXN ...
	MXN Currency = "MXN"
	// MXV ...
	MXV Currency = "MXV"
	// MYR ...
	MYR Currency = "MYR"
	// MZN ...
	MZN Currency = "MZN"
	// NAD ...
	NAD Currency = "NAD"
	// NGN ...
	NGN Currency = "NGN"
	// NIO ...
	NIO Currency = "NIO"
	// NOK ...
	NOK Currency = "NOK"
	// NPR ...
	NPR Currency = "NPR"
	// NZD ...
	NZD Currency = "NZD"
	// OMR ...
	OMR Currency = "OMR"
	// PAB ...
	PAB Currency = "PAB"
	// PEN ...
	PEN Currency = "PEN"
	// PGK ...
	PGK Currency = "PGK"
	// PHP ...
	PHP Currency = "PHP"
	// PKR ...
	PKR Currency = "PKR"
	// PLN ...
	PLN Currency = "PLN"
	// PYG ...
	PYG Currency = "PYG"
	// QAR ...
	QAR Currency = "QAR"
	// RON ...
	RON Currency = "RON"
	// RSD ...
	RSD Currency = "RSD"
	// RUB ...
	RUB Currency = "RUB"
	// RWF ...
	RWF Currency = "RWF"
	// SAR ...
	SAR Currency = "SAR"
	// SBD ...
	SBD Currency = "SBD"
	// SCR ...
	SCR Currency = "SCR"
	// SDG ...
	SDG Currency = "SDG"
	// SEK ...
	SEK Currency = "SEK"
	// SGD ...
	SGD Currency = "SGD"
	// SHP ...
	SHP Currency = "SHP"
	// SLL ...
	SLL Currency = "SLL"
	// SOS ...
	SOS Currency = "SOS"
	// SRD ...
	SRD Currency = "SRD"
	// SSP ...
	SSP Currency = "SSP"
	// STD ...
	STD Currency = "STD"
	// SYP ...
	SYP Currency = "SYP"
	// SZL ...
	SZL Currency = "SZL"
	// THB ...
	THB Currency = "THB"
	// TJS ...
	TJS Currency = "TJS"
	// TMT ...
	TMT Currency = "TMT"
	// TND ...
	TND Currency = "TND"
	// TOP ...
	TOP Currency = "TOP"
	// TRY ...
	TRY Currency = "TRY"
	// TTD ...
	TTD Currency = "TTD"
	// TWD ...
	TWD Currency = "TWD"
	// TZS ...
	TZS Currency = "TZS"
	// UAH ...
	UAH Currency = "UAH"
	// UGX ...
	UGX Currency = "UGX"
	// USD ...
	USD Currency = "USD"
	// UYU ...
	UYU Currency = "UYU"
	// UZS ...
	UZS Currency = "UZS"
	// VEF ...
	VEF Currency = "VEF"
	// VND ...
	VND Currency = "VND"
	// VUV ...
	VUV Currency = "VUV"
	// WST ...
	WST Currency = "WST"
	// XAF ...
	XAF Currency = "XAF"
	// XCD ...
	XCD Currency = "XCD"
	// XOF ...
	XOF Currency = "XOF"
	// XPF ...
	XPF Currency = "XPF"
	// YER ...
	YER Currency = "YER"
	// ZAR ...
	ZAR Currency = "ZAR"
	// ZMW ...
	ZMW Currency = "ZMW"
)

// PossibleCurrencyValues returns an array of possible values for the Currency const type.
func PossibleCurrencyValues() []Currency {
	return []Currency{AED, AFN, ALL, AMD, ANG, AOA, ARS, AUD, AWG, AZN, BAM, BBD, BDT, BGN, BHD, BIF, BMD, BND, BOB, BOV, BRL, BSD, BTN, BWP, BYR, BZD, CAD, CDF, CHE, CHF, CHW, CLF, CLP, CNY, COP, COU, CRC, CUC, CUP, CVE, CZK, DJF, DKK, DOP, DZD, EGP, ERN, ETB, EUR, FJD, FKP, GBP, GEL, GHS, GIP, GMD, GNF, GTQ, GYD, HKD, HNL, HRK, HTG, HUF, IDR, ILS, INR, IQD, IRR, ISK, JMD, JOD, JPY, KES, KGS, KHR, KMF, KPW, KRW, KWD, KYD, KZT, LAK, LBP, LKR, LRD, LSL, LYD, MAD, MDL, MGA, MKD, MMK, MNT, MOP, MRO, MUR, MVR, MWK, MXN, MXV, MYR, MZN, NAD, NGN, NIO, NOK, NPR, NZD, OMR, PAB, PEN, PGK, PHP, PKR, PLN, PYG, QAR, RON, RSD, RUB, RWF, SAR, SBD, SCR, SDG, SEK, SGD, SHP, SLL, SOS, SRD, SSP, STD, SYP, SZL, THB, TJS, TMT, TND, TOP, TRY, TTD, TWD, TZS, UAH, UGX, USD, UYU, UZS, VEF, VND, VUV, WST, XAF, XCD, XOF, XPF, YER, ZAR, ZMW}
}

// ErrorCode enumerates the values for error code.
type ErrorCode string

const (
	// InsufficientAuthorization ...
	InsufficientAuthorization ErrorCode = "InsufficientAuthorization"
	// InvalidAuthorization ...
	InvalidAuthorization ErrorCode = "InvalidAuthorization"
	// InvalidRequest ...
	InvalidRequest ErrorCode = "InvalidRequest"
	// None ...
	None ErrorCode = "None"
	// RateLimitExceeded ...
	RateLimitExceeded ErrorCode = "RateLimitExceeded"
	// ServerError ...
	ServerError ErrorCode = "ServerError"
)

// PossibleErrorCodeValues returns an array of possible values for the ErrorCode const type.
func PossibleErrorCodeValues() []ErrorCode {
	return []ErrorCode{InsufficientAuthorization, InvalidAuthorization, InvalidRequest, None, RateLimitExceeded, ServerError}
}

// ErrorSubCode enumerates the values for error sub code.
type ErrorSubCode string

const (
	// AuthorizationDisabled ...
	AuthorizationDisabled ErrorSubCode = "AuthorizationDisabled"
	// AuthorizationExpired ...
	AuthorizationExpired ErrorSubCode = "AuthorizationExpired"
	// AuthorizationMissing ...
	AuthorizationMissing ErrorSubCode = "AuthorizationMissing"
	// AuthorizationRedundancy ...
	AuthorizationRedundancy ErrorSubCode = "AuthorizationRedundancy"
	// Blocked ...
	Blocked ErrorSubCode = "Blocked"
	// HTTPNotAllowed ...
	HTTPNotAllowed ErrorSubCode = "HttpNotAllowed"
	// NotImplemented ...
	NotImplemented ErrorSubCode = "NotImplemented"
	// ParameterInvalidValue ...
	ParameterInvalidValue ErrorSubCode = "ParameterInvalidValue"
	// ParameterMissing ...
	ParameterMissing ErrorSubCode = "ParameterMissing"
	// ResourceError ...
	ResourceError ErrorSubCode = "ResourceError"
	// UnexpectedError ...
	UnexpectedError ErrorSubCode = "UnexpectedError"
)

// PossibleErrorSubCodeValues returns an array of possible values for the ErrorSubCode const type.
func PossibleErrorSubCodeValues() []ErrorSubCode {
	return []ErrorSubCode{AuthorizationDisabled, AuthorizationExpired, AuthorizationMissing, AuthorizationRedundancy, Blocked, HTTPNotAllowed, NotImplemented, ParameterInvalidValue, ParameterMissing, ResourceError, UnexpectedError}
}

// ItemAvailability enumerates the values for item availability.
type ItemAvailability string

const (
	// Discontinued ...
	Discontinued ItemAvailability = "Discontinued"
	// InStock ...
	InStock ItemAvailability = "InStock"
	// InStoreOnly ...
	InStoreOnly ItemAvailability = "InStoreOnly"
	// LimitedAvailability ...
	LimitedAvailability ItemAvailability = "LimitedAvailability"
	// OnlineOnly ...
	OnlineOnly ItemAvailability = "OnlineOnly"
	// OutOfStock ...
	OutOfStock ItemAvailability = "OutOfStock"
	// PreOrder ...
	PreOrder ItemAvailability = "PreOrder"
	// SoldOut ...
	SoldOut ItemAvailability = "SoldOut"
)

// PossibleItemAvailabilityValues returns an array of possible values for the ItemAvailability const type.
func PossibleItemAvailabilityValues() []ItemAvailability {
	return []ItemAvailability{Discontinued, InStock, InStoreOnly, LimitedAvailability, OnlineOnly, OutOfStock, PreOrder, SoldOut}
}

// SafeSearch enumerates the values for safe search.
type SafeSearch string

const (
	// Moderate ...
	Moderate SafeSearch = "Moderate"
	// Off ...
	Off SafeSearch = "Off"
	// Strict ...
	Strict SafeSearch = "Strict"
)

// PossibleSafeSearchValues returns an array of possible values for the SafeSearch const type.
func PossibleSafeSearchValues() []SafeSearch {
	return []SafeSearch{Moderate, Off, Strict}
}

// Type enumerates the values for type.
type Type string

const (
	// TypeAction ...
	TypeAction Type = "Action"
	// TypeAggregateOffer ...
	TypeAggregateOffer Type = "AggregateOffer"
	// TypeCreativeWork ...
	TypeCreativeWork Type = "CreativeWork"
	// TypeErrorResponse ...
	TypeErrorResponse Type = "ErrorResponse"
	// TypeIdentifiable ...
	TypeIdentifiable Type = "Identifiable"
	// TypeImageAction ...
	TypeImageAction Type = "ImageAction"
	// TypeImageEntityAction ...
	TypeImageEntityAction Type = "ImageEntityAction"
	// TypeImageKnowledge ...
	TypeImageKnowledge Type = "ImageKnowledge"
	// TypeImageModuleAction ...
	TypeImageModuleAction Type = "ImageModuleAction"
	// TypeImageObject ...
	TypeImageObject Type = "ImageObject"
	// TypeImageRecipesAction ...
	TypeImageRecipesAction Type = "ImageRecipesAction"
	// TypeImageRelatedSearchesAction ...
	TypeImageRelatedSearchesAction Type = "ImageRelatedSearchesAction"
	// TypeImageShoppingSourcesAction ...
	TypeImageShoppingSourcesAction Type = "ImageShoppingSourcesAction"
	// TypeImageTag ...
	TypeImageTag Type = "ImageTag"
	// TypeIntangible ...
	TypeIntangible Type = "Intangible"
	// TypeMediaObject ...
	TypeMediaObject Type = "MediaObject"
	// TypeNormalizedQuadrilateral ...
	TypeNormalizedQuadrilateral Type = "NormalizedQuadrilateral"
	// TypeOffer ...
	TypeOffer Type = "Offer"
	// TypeOrganization ...
	TypeOrganization Type = "Organization"
	// TypePerson ...
	TypePerson Type = "Person"
	// TypePoint2D ...
	TypePoint2D Type = "Point2D"
	// TypeRecipe ...
	TypeRecipe Type = "Recipe"
	// TypeResponse ...
	TypeResponse Type = "Response"
	// TypeResponseBase ...
	TypeResponseBase Type = "ResponseBase"
	// TypeStructuredValue ...
	TypeStructuredValue Type = "StructuredValue"
	// TypeThing ...
	TypeThing Type = "Thing"
)

// PossibleTypeValues returns an array of possible values for the Type const type.
func PossibleTypeValues() []Type {
	return []Type{TypeAction, TypeAggregateOffer, TypeCreativeWork, TypeErrorResponse, TypeIdentifiable, TypeImageAction, TypeImageEntityAction, TypeImageKnowledge, TypeImageModuleAction, TypeImageObject, TypeImageRecipesAction, TypeImageRelatedSearchesAction, TypeImageShoppingSourcesAction, TypeImageTag, TypeIntangible, TypeMediaObject, TypeNormalizedQuadrilateral, TypeOffer, TypeOrganization, TypePerson, TypePoint2D, TypeRecipe, TypeResponse, TypeResponseBase, TypeStructuredValue, TypeThing}
}

// TypeBasicPropertiesItem enumerates the values for type basic properties item.
type TypeBasicPropertiesItem string

const (
	// TypeAggregateRating ...
	TypeAggregateRating TypeBasicPropertiesItem = "AggregateRating"
	// TypePropertiesItem ...
	TypePropertiesItem TypeBasicPropertiesItem = "Properties/Item"
	// TypeRating ...
	TypeRating TypeBasicPropertiesItem = "Rating"
)

// PossibleTypeBasicPropertiesItemValues returns an array of possible values for the TypeBasicPropertiesItem const type.
func PossibleTypeBasicPropertiesItemValues() []TypeBasicPropertiesItem {
	return []TypeBasicPropertiesItem{TypeAggregateRating, TypePropertiesItem, TypeRating}
}

// BasicAction defines an action.
type BasicAction interface {
	AsImageAction() (*ImageAction, bool)
	AsBasicImageAction() (BasicImageAction, bool)
	AsImageEntityAction() (*ImageEntityAction, bool)
	AsImageModuleAction() (*ImageModuleAction, bool)
	AsImageRecipesAction() (*ImageRecipesAction, bool)
	AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool)
	AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool)
	AsAction() (*Action, bool)
}

// Action defines an action.
type Action struct {
	// Result - The result produced in the action.
	Result *[]BasicThing `json:"result,omitempty"`
	// DisplayName - A display name for the action.
	DisplayName *string `json:"displayName,omitempty"`
	// IsTopAction - A Boolean representing whether this result is the top action.
	IsTopAction *bool `json:"isTopAction,omitempty"`
	// ServiceURL - Use this URL to get additional data to determine how to take the appropriate action. For example, the serviceUrl might return JSON along with an image URL.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work.
	Text *string `json:"text,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicAction(body []byte) (BasicAction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageAction):
		var ia ImageAction
		err := json.Unmarshal(body, &ia)
		return ia, err
	case string(TypeImageEntityAction):
		var iea ImageEntityAction
		err := json.Unmarshal(body, &iea)
		return iea, err
	case string(TypeImageModuleAction):
		var ima ImageModuleAction
		err := json.Unmarshal(body, &ima)
		return ima, err
	case string(TypeImageRecipesAction):
		var ira ImageRecipesAction
		err := json.Unmarshal(body, &ira)
		return ira, err
	case string(TypeImageRelatedSearchesAction):
		var irsa ImageRelatedSearchesAction
		err := json.Unmarshal(body, &irsa)
		return irsa, err
	case string(TypeImageShoppingSourcesAction):
		var issa ImageShoppingSourcesAction
		err := json.Unmarshal(body, &issa)
		return issa, err
	default:
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	}
}
func unmarshalBasicActionArray(body []byte) ([]BasicAction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	aArray := make([]BasicAction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		a, err := unmarshalBasicAction(*rawMessage)
		if err != nil {
			return nil, err
		}
		aArray[index] = a
	}
	return aArray, nil
}

// MarshalJSON is the custom marshaler for Action.
func (a Action) MarshalJSON() ([]byte, error) {
	a.Type = TypeAction
	objectMap := make(map[string]interface{})
	if a.Result != nil {
		objectMap["result"] = a.Result
	}
	if a.DisplayName != nil {
		objectMap["displayName"] = a.DisplayName
	}
	if a.IsTopAction != nil {
		objectMap["isTopAction"] = a.IsTopAction
	}
	if a.ServiceURL != nil {
		objectMap["serviceUrl"] = a.ServiceURL
	}
	if a.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = a.ThumbnailURL
	}
	if a.Provider != nil {
		objectMap["provider"] = a.Provider
	}
	if a.DatePublished != nil {
		objectMap["datePublished"] = a.DatePublished
	}
	if a.Text != nil {
		objectMap["text"] = a.Text
	}
	if a.Name != nil {
		objectMap["name"] = a.Name
	}
	if a.URL != nil {
		objectMap["url"] = a.URL
	}
	if a.Image != nil {
		objectMap["image"] = a.Image
	}
	if a.Description != nil {
		objectMap["description"] = a.Description
	}
	if a.AlternateName != nil {
		objectMap["alternateName"] = a.AlternateName
	}
	if a.BingID != nil {
		objectMap["bingId"] = a.BingID
	}
	if a.ReadLink != nil {
		objectMap["readLink"] = a.ReadLink
	}
	if a.WebSearchURL != nil {
		objectMap["webSearchUrl"] = a.WebSearchURL
	}
	if a.ID != nil {
		objectMap["id"] = a.ID
	}
	if a.Type != "" {
		objectMap["_type"] = a.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for Action.
func (a Action) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for Action.
func (a Action) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for Action.
func (a Action) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for Action.
func (a Action) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for Action.
func (a Action) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Action.
func (a Action) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Action.
func (a Action) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Action.
func (a Action) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Action.
func (a Action) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Action.
func (a Action) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for Action.
func (a Action) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Action.
func (a Action) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Action.
func (a Action) AsBasicResponse() (BasicResponse, bool) {
	return &a, true
}

// AsIdentifiable is the BasicResponseBase implementation for Action.
func (a Action) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Action.
func (a Action) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &a, true
}

// AsErrorResponse is the BasicResponseBase implementation for Action.
func (a Action) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Action.
func (a Action) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Action.
func (a Action) AsBasicThing() (BasicThing, bool) {
	return &a, true
}

// AsAction is the BasicResponseBase implementation for Action.
func (a Action) AsAction() (*Action, bool) {
	return &a, true
}

// AsBasicAction is the BasicResponseBase implementation for Action.
func (a Action) AsBasicAction() (BasicAction, bool) {
	return &a, true
}

// AsMediaObject is the BasicResponseBase implementation for Action.
func (a Action) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Action.
func (a Action) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Action.
func (a Action) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Action.
func (a Action) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &a, true
}

// AsPerson is the BasicResponseBase implementation for Action.
func (a Action) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Action.
func (a Action) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Action.
func (a Action) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for Action.
func (a Action) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for Action.
func (a Action) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Action.
func (a Action) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for Action.
func (a Action) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for Action.
func (a Action) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for Action.
func (a Action) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Action.
func (a Action) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Action.
func (a Action) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Action.
func (a Action) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Action.
func (a Action) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &a, true
}

// UnmarshalJSON is the custom unmarshaler for Action struct.
func (a *Action) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "result":
			if v != nil {
				resultVar, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				a.Result = &resultVar
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				a.DisplayName = &displayName
			}
		case "isTopAction":
			if v != nil {
				var isTopAction bool
				err = json.Unmarshal(*v, &isTopAction)
				if err != nil {
					return err
				}
				a.IsTopAction = &isTopAction
			}
		case "serviceUrl":
			if v != nil {
				var serviceURL string
				err = json.Unmarshal(*v, &serviceURL)
				if err != nil {
					return err
				}
				a.ServiceURL = &serviceURL
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				a.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				a.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				a.DatePublished = &datePublished
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				a.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				a.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				a.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				a.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				a.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				a.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				a.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				a.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				a.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				a.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				a.Type = typeVar
			}
		}
	}

	return nil
}

// AggregateOffer defines a list of offers from merchants that are related to the image.
type AggregateOffer struct {
	// Offers - A list of offers from merchants that have offerings related to the image.
	Offers *[]BasicOffer `json:"offers,omitempty"`
	// Seller - Seller for this offer.
	Seller *Organization `json:"seller,omitempty"`
	// Price - The item's price.
	Price *float64 `json:"price,omitempty"`
	// PriceCurrency - The monetary currency. For example, USD. Possible values include: 'USD', 'CAD', 'GBP', 'EUR', 'COP', 'JPY', 'CNY', 'AUD', 'INR', 'AED', 'AFN', 'ALL', 'AMD', 'ANG', 'AOA', 'ARS', 'AWG', 'AZN', 'BAM', 'BBD', 'BDT', 'BGN', 'BHD', 'BIF', 'BMD', 'BND', 'BOB', 'BOV', 'BRL', 'BSD', 'BTN', 'BWP', 'BYR', 'BZD', 'CDF', 'CHE', 'CHF', 'CHW', 'CLF', 'CLP', 'COU', 'CRC', 'CUC', 'CUP', 'CVE', 'CZK', 'DJF', 'DKK', 'DOP', 'DZD', 'EGP', 'ERN', 'ETB', 'FJD', 'FKP', 'GEL', 'GHS', 'GIP', 'GMD', 'GNF', 'GTQ', 'GYD', 'HKD', 'HNL', 'HRK', 'HTG', 'HUF', 'IDR', 'ILS', 'IQD', 'IRR', 'ISK', 'JMD', 'JOD', 'KES', 'KGS', 'KHR', 'KMF', 'KPW', 'KRW', 'KWD', 'KYD', 'KZT', 'LAK', 'LBP', 'LKR', 'LRD', 'LSL', 'LYD', 'MAD', 'MDL', 'MGA', 'MKD', 'MMK', 'MNT', 'MOP', 'MRO', 'MUR', 'MVR', 'MWK', 'MXN', 'MXV', 'MYR', 'MZN', 'NAD', 'NGN', 'NIO', 'NOK', 'NPR', 'NZD', 'OMR', 'PAB', 'PEN', 'PGK', 'PHP', 'PKR', 'PLN', 'PYG', 'QAR', 'RON', 'RSD', 'RUB', 'RWF', 'SAR', 'SBD', 'SCR', 'SDG', 'SEK', 'SGD', 'SHP', 'SLL', 'SOS', 'SRD', 'SSP', 'STD', 'SYP', 'SZL', 'THB', 'TJS', 'TMT', 'TND', 'TOP', 'TRY', 'TTD', 'TWD', 'TZS', 'UAH', 'UGX', 'UYU', 'UZS', 'VEF', 'VND', 'VUV', 'WST', 'XAF', 'XCD', 'XOF', 'XPF', 'YER', 'ZAR', 'ZMW'
	PriceCurrency Currency `json:"priceCurrency,omitempty"`
	// Availability - The item's availability. The following are the possible values: Discontinued, InStock, InStoreOnly, LimitedAvailability, OnlineOnly, OutOfStock, PreOrder, SoldOut. Possible values include: 'Discontinued', 'InStock', 'InStoreOnly', 'LimitedAvailability', 'OnlineOnly', 'OutOfStock', 'PreOrder', 'SoldOut'
	Availability ItemAvailability `json:"availability,omitempty"`
	// AggregateRating - An aggregated rating that indicates how well the product has been rated by others.
	AggregateRating *AggregateRating `json:"aggregateRating,omitempty"`
	// LastUpdated - The last date that the offer was updated. The date is in the form YYYY-MM-DD.
	LastUpdated *string `json:"lastUpdated,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for AggregateOffer.
func (ao AggregateOffer) MarshalJSON() ([]byte, error) {
	ao.Type = TypeAggregateOffer
	objectMap := make(map[string]interface{})
	if ao.Offers != nil {
		objectMap["offers"] = ao.Offers
	}
	if ao.Seller != nil {
		objectMap["seller"] = ao.Seller
	}
	if ao.Price != nil {
		objectMap["price"] = ao.Price
	}
	if ao.PriceCurrency != "" {
		objectMap["priceCurrency"] = ao.PriceCurrency
	}
	if ao.Availability != "" {
		objectMap["availability"] = ao.Availability
	}
	if ao.AggregateRating != nil {
		objectMap["aggregateRating"] = ao.AggregateRating
	}
	if ao.LastUpdated != nil {
		objectMap["lastUpdated"] = ao.LastUpdated
	}
	if ao.Name != nil {
		objectMap["name"] = ao.Name
	}
	if ao.URL != nil {
		objectMap["url"] = ao.URL
	}
	if ao.Image != nil {
		objectMap["image"] = ao.Image
	}
	if ao.Description != nil {
		objectMap["description"] = ao.Description
	}
	if ao.AlternateName != nil {
		objectMap["alternateName"] = ao.AlternateName
	}
	if ao.BingID != nil {
		objectMap["bingId"] = ao.BingID
	}
	if ao.ReadLink != nil {
		objectMap["readLink"] = ao.ReadLink
	}
	if ao.WebSearchURL != nil {
		objectMap["webSearchUrl"] = ao.WebSearchURL
	}
	if ao.ID != nil {
		objectMap["id"] = ao.ID
	}
	if ao.Type != "" {
		objectMap["_type"] = ao.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicOffer() (BasicOffer, bool) {
	return &ao, true
}

// AsAggregateOffer is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsAggregateOffer() (*AggregateOffer, bool) {
	return &ao, true
}

// AsImageObject is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicResponse() (BasicResponse, bool) {
	return &ao, true
}

// AsIdentifiable is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ao, true
}

// AsErrorResponse is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicThing() (BasicThing, bool) {
	return &ao, true
}

// AsAction is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for AggregateOffer.
func (ao AggregateOffer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ao, true
}

// UnmarshalJSON is the custom unmarshaler for AggregateOffer struct.
func (ao *AggregateOffer) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "offers":
			if v != nil {
				offers, err := unmarshalBasicOfferArray(*v)
				if err != nil {
					return err
				}
				ao.Offers = &offers
			}
		case "seller":
			if v != nil {
				var seller Organization
				err = json.Unmarshal(*v, &seller)
				if err != nil {
					return err
				}
				ao.Seller = &seller
			}
		case "price":
			if v != nil {
				var price float64
				err = json.Unmarshal(*v, &price)
				if err != nil {
					return err
				}
				ao.Price = &price
			}
		case "priceCurrency":
			if v != nil {
				var priceCurrency Currency
				err = json.Unmarshal(*v, &priceCurrency)
				if err != nil {
					return err
				}
				ao.PriceCurrency = priceCurrency
			}
		case "availability":
			if v != nil {
				var availability ItemAvailability
				err = json.Unmarshal(*v, &availability)
				if err != nil {
					return err
				}
				ao.Availability = availability
			}
		case "aggregateRating":
			if v != nil {
				var aggregateRating AggregateRating
				err = json.Unmarshal(*v, &aggregateRating)
				if err != nil {
					return err
				}
				ao.AggregateRating = &aggregateRating
			}
		case "lastUpdated":
			if v != nil {
				var lastUpdated string
				err = json.Unmarshal(*v, &lastUpdated)
				if err != nil {
					return err
				}
				ao.LastUpdated = &lastUpdated
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ao.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				ao.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				ao.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ao.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				ao.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				ao.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				ao.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				ao.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ao.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ao.Type = typeVar
			}
		}
	}

	return nil
}

// AggregateRating defines the metrics that indicate how well an item was rated by others.
type AggregateRating struct {
	// ReviewCount - The number of times the recipe has been rated or reviewed.
	ReviewCount *int32 `json:"reviewCount,omitempty"`
	// RatingValue - The mean (average) rating. The possible values are 1.0 through 5.0.
	RatingValue *float64 `json:"ratingValue,omitempty"`
	// BestRating - The highest rated review. The possible values are 1.0 through 5.0.
	BestRating *float64 `json:"bestRating,omitempty"`
	// Text - Text representation of an item.
	Text *string `json:"text,omitempty"`
	// Type - Possible values include: 'TypePropertiesItem', 'TypeAggregateRating', 'TypeRating'
	Type TypeBasicPropertiesItem `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for AggregateRating.
func (ar AggregateRating) MarshalJSON() ([]byte, error) {
	ar.Type = TypeAggregateRating
	objectMap := make(map[string]interface{})
	if ar.ReviewCount != nil {
		objectMap["reviewCount"] = ar.ReviewCount
	}
	if ar.RatingValue != nil {
		objectMap["ratingValue"] = ar.RatingValue
	}
	if ar.BestRating != nil {
		objectMap["bestRating"] = ar.BestRating
	}
	if ar.Text != nil {
		objectMap["text"] = ar.Text
	}
	if ar.Type != "" {
		objectMap["_type"] = ar.Type
	}
	return json.Marshal(objectMap)
}

// AsAggregateRating is the BasicPropertiesItem implementation for AggregateRating.
func (ar AggregateRating) AsAggregateRating() (*AggregateRating, bool) {
	return &ar, true
}

// AsRating is the BasicPropertiesItem implementation for AggregateRating.
func (ar AggregateRating) AsRating() (*Rating, bool) {
	return nil, false
}

// AsBasicRating is the BasicPropertiesItem implementation for AggregateRating.
func (ar AggregateRating) AsBasicRating() (BasicRating, bool) {
	return &ar, true
}

// AsPropertiesItem is the BasicPropertiesItem implementation for AggregateRating.
func (ar AggregateRating) AsPropertiesItem() (*PropertiesItem, bool) {
	return nil, false
}

// AsBasicPropertiesItem is the BasicPropertiesItem implementation for AggregateRating.
func (ar AggregateRating) AsBasicPropertiesItem() (BasicPropertiesItem, bool) {
	return &ar, true
}

// BasicCreativeWork the most generic kind of creative work, including books, movies, photographs, software programs,
// etc.
type BasicCreativeWork interface {
	AsImageAction() (*ImageAction, bool)
	AsBasicImageAction() (BasicImageAction, bool)
	AsImageObject() (*ImageObject, bool)
	AsAction() (*Action, bool)
	AsBasicAction() (BasicAction, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsImageEntityAction() (*ImageEntityAction, bool)
	AsImageModuleAction() (*ImageModuleAction, bool)
	AsRecipe() (*Recipe, bool)
	AsImageRecipesAction() (*ImageRecipesAction, bool)
	AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool)
	AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool)
	AsCreativeWork() (*CreativeWork, bool)
}

// CreativeWork the most generic kind of creative work, including books, movies, photographs, software programs,
// etc.
type CreativeWork struct {
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work.
	Text *string `json:"text,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicCreativeWork(body []byte) (BasicCreativeWork, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageAction):
		var ia ImageAction
		err := json.Unmarshal(body, &ia)
		return ia, err
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeAction):
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeImageEntityAction):
		var iea ImageEntityAction
		err := json.Unmarshal(body, &iea)
		return iea, err
	case string(TypeImageModuleAction):
		var ima ImageModuleAction
		err := json.Unmarshal(body, &ima)
		return ima, err
	case string(TypeRecipe):
		var r Recipe
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeImageRecipesAction):
		var ira ImageRecipesAction
		err := json.Unmarshal(body, &ira)
		return ira, err
	case string(TypeImageRelatedSearchesAction):
		var irsa ImageRelatedSearchesAction
		err := json.Unmarshal(body, &irsa)
		return irsa, err
	case string(TypeImageShoppingSourcesAction):
		var issa ImageShoppingSourcesAction
		err := json.Unmarshal(body, &issa)
		return issa, err
	default:
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	}
}
func unmarshalBasicCreativeWorkArray(body []byte) ([]BasicCreativeWork, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cwArray := make([]BasicCreativeWork, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cw, err := unmarshalBasicCreativeWork(*rawMessage)
		if err != nil {
			return nil, err
		}
		cwArray[index] = cw
	}
	return cwArray, nil
}

// MarshalJSON is the custom marshaler for CreativeWork.
func (cw CreativeWork) MarshalJSON() ([]byte, error) {
	cw.Type = TypeCreativeWork
	objectMap := make(map[string]interface{})
	if cw.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = cw.ThumbnailURL
	}
	if cw.Provider != nil {
		objectMap["provider"] = cw.Provider
	}
	if cw.DatePublished != nil {
		objectMap["datePublished"] = cw.DatePublished
	}
	if cw.Text != nil {
		objectMap["text"] = cw.Text
	}
	if cw.Name != nil {
		objectMap["name"] = cw.Name
	}
	if cw.URL != nil {
		objectMap["url"] = cw.URL
	}
	if cw.Image != nil {
		objectMap["image"] = cw.Image
	}
	if cw.Description != nil {
		objectMap["description"] = cw.Description
	}
	if cw.AlternateName != nil {
		objectMap["alternateName"] = cw.AlternateName
	}
	if cw.BingID != nil {
		objectMap["bingId"] = cw.BingID
	}
	if cw.ReadLink != nil {
		objectMap["readLink"] = cw.ReadLink
	}
	if cw.WebSearchURL != nil {
		objectMap["webSearchUrl"] = cw.WebSearchURL
	}
	if cw.ID != nil {
		objectMap["id"] = cw.ID
	}
	if cw.Type != "" {
		objectMap["_type"] = cw.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponse() (BasicResponse, bool) {
	return &cw, true
}

// AsIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &cw, true
}

// AsErrorResponse is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicThing() (BasicThing, bool) {
	return &cw, true
}

// AsAction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsCreativeWork() (*CreativeWork, bool) {
	return &cw, true
}

// AsBasicCreativeWork is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &cw, true
}

// AsPerson is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for CreativeWork.
func (cw CreativeWork) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &cw, true
}

// UnmarshalJSON is the custom unmarshaler for CreativeWork struct.
func (cw *CreativeWork) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				cw.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				cw.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				cw.DatePublished = &datePublished
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				cw.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cw.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				cw.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				cw.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				cw.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				cw.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				cw.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				cw.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				cw.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cw.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cw.Type = typeVar
			}
		}
	}

	return nil
}

// CropArea a JSON object consisting of coordinates specifying the four corners of a cropped rectangle within the
// input image.
type CropArea struct {
	// Top - The top coordinate of the region to be cropped. The coordinate is a fractional value of the original image's height and is measured from the top edge of the image. Specify the coordinate as a value from 0.0 through 1.0.
	Top *float64 `json:"top,omitempty"`
	// Bottom - The bottom coordinate of the region to be cropped. The coordinate is a fractional value of the original image's height and is measured from the top edge of the image. Specify the coordinate as a value from 0.0 through 1.0.
	Bottom *float64 `json:"bottom,omitempty"`
	// Left - The left coordinate of the region to be cropped. The coordinate is a fractional value of the original image's width and is measured from the left edge of the image. Specify the coordinate as a value from 0.0 through 1.0.
	Left *float64 `json:"left,omitempty"`
	// Right - The right coordinate of the region to be cropped. The coordinate is a fractional value of the original image's width and is measured from the left edge of the image. Specify the coordinate as a value from 0.0 through 1.0.
	Right *float64 `json:"right,omitempty"`
}

// Error defines the error that occurred.
type Error struct {
	// Code - The error code that identifies the category of error. Possible values include: 'None', 'ServerError', 'InvalidRequest', 'RateLimitExceeded', 'InvalidAuthorization', 'InsufficientAuthorization'
	Code ErrorCode `json:"code,omitempty"`
	// SubCode - The error code that further helps to identify the error. Possible values include: 'UnexpectedError', 'ResourceError', 'NotImplemented', 'ParameterMissing', 'ParameterInvalidValue', 'HTTPNotAllowed', 'Blocked', 'AuthorizationMissing', 'AuthorizationRedundancy', 'AuthorizationDisabled', 'AuthorizationExpired'
	SubCode ErrorSubCode `json:"subCode,omitempty"`
	// Message - A description of the error.
	Message *string `json:"message,omitempty"`
	// MoreDetails - A description that provides additional information about the error.
	MoreDetails *string `json:"moreDetails,omitempty"`
	// Parameter - The parameter in the request that caused the error.
	Parameter *string `json:"parameter,omitempty"`
	// Value - The parameter's value in the request that was not valid.
	Value *string `json:"value,omitempty"`
}

// ErrorResponse the top-level response that represents a failed request.
type ErrorResponse struct {
	// Errors - A list of errors that describe the reasons why the request failed.
	Errors *[]Error `json:"errors,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ErrorResponse.
func (er ErrorResponse) MarshalJSON() ([]byte, error) {
	er.Type = TypeErrorResponse
	objectMap := make(map[string]interface{})
	if er.Errors != nil {
		objectMap["errors"] = er.Errors
	}
	if er.ReadLink != nil {
		objectMap["readLink"] = er.ReadLink
	}
	if er.WebSearchURL != nil {
		objectMap["webSearchUrl"] = er.WebSearchURL
	}
	if er.ID != nil {
		objectMap["id"] = er.ID
	}
	if er.Type != "" {
		objectMap["_type"] = er.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponse() (BasicResponse, bool) {
	return &er, true
}

// AsIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &er, true
}

// AsErrorResponse is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsErrorResponse() (*ErrorResponse, bool) {
	return &er, true
}

// AsThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ErrorResponse.
func (er ErrorResponse) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &er, true
}

// Filters a key-value object consisting of filters that may be specified to limit the results returned by the API.
// Current available filters: site.
type Filters struct {
	// Site - The URL of the site to return similar images and similar products from. (e.g., "www.bing.com", "bing.com").
	Site *string `json:"site,omitempty"`
}

// BasicIdentifiable defines the identity of a resource.
type BasicIdentifiable interface {
	AsPoint2D() (*Point2D, bool)
	AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool)
	AsImageAction() (*ImageAction, bool)
	AsBasicImageAction() (BasicImageAction, bool)
	AsImageTag() (*ImageTag, bool)
	AsOrganization() (*Organization, bool)
	AsOffer() (*Offer, bool)
	AsBasicOffer() (BasicOffer, bool)
	AsAggregateOffer() (*AggregateOffer, bool)
	AsImageObject() (*ImageObject, bool)
	AsImageKnowledge() (*ImageKnowledge, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsAction() (*Action, bool)
	AsBasicAction() (BasicAction, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsPerson() (*Person, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsImageEntityAction() (*ImageEntityAction, bool)
	AsImageModuleAction() (*ImageModuleAction, bool)
	AsRecipe() (*Recipe, bool)
	AsImageRecipesAction() (*ImageRecipesAction, bool)
	AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool)
	AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsIdentifiable() (*Identifiable, bool)
}

// Identifiable defines the identity of a resource.
type Identifiable struct {
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicIdentifiable(body []byte) (BasicIdentifiable, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypePoint2D):
		var p2 Point2D
		err := json.Unmarshal(body, &p2)
		return p2, err
	case string(TypeNormalizedQuadrilateral):
		var nq NormalizedQuadrilateral
		err := json.Unmarshal(body, &nq)
		return nq, err
	case string(TypeImageAction):
		var ia ImageAction
		err := json.Unmarshal(body, &ia)
		return ia, err
	case string(TypeImageTag):
		var it ImageTag
		err := json.Unmarshal(body, &it)
		return it, err
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeOffer):
		var o Offer
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeAggregateOffer):
		var ao AggregateOffer
		err := json.Unmarshal(body, &ao)
		return ao, err
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeImageKnowledge):
		var ik ImageKnowledge
		err := json.Unmarshal(body, &ik)
		return ik, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeAction):
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypePerson):
		var p Person
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeImageEntityAction):
		var iea ImageEntityAction
		err := json.Unmarshal(body, &iea)
		return iea, err
	case string(TypeImageModuleAction):
		var ima ImageModuleAction
		err := json.Unmarshal(body, &ima)
		return ima, err
	case string(TypeRecipe):
		var r Recipe
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeImageRecipesAction):
		var ira ImageRecipesAction
		err := json.Unmarshal(body, &ira)
		return ira, err
	case string(TypeImageRelatedSearchesAction):
		var irsa ImageRelatedSearchesAction
		err := json.Unmarshal(body, &irsa)
		return irsa, err
	case string(TypeImageShoppingSourcesAction):
		var issa ImageShoppingSourcesAction
		err := json.Unmarshal(body, &issa)
		return issa, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIdentifiableArray(body []byte) ([]BasicIdentifiable, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIdentifiable, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIdentifiable(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Identifiable.
func (i Identifiable) MarshalJSON() ([]byte, error) {
	i.Type = TypeIdentifiable
	objectMap := make(map[string]interface{})
	if i.ID != nil {
		objectMap["id"] = i.ID
	}
	if i.Type != "" {
		objectMap["_type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIdentifiable() (*Identifiable, bool) {
	return &i, true
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsErrorResponse is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Identifiable.
func (i Identifiable) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// BasicImageAction defines an image action.
type BasicImageAction interface {
	AsImageEntityAction() (*ImageEntityAction, bool)
	AsImageModuleAction() (*ImageModuleAction, bool)
	AsImageRecipesAction() (*ImageRecipesAction, bool)
	AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool)
	AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool)
	AsImageAction() (*ImageAction, bool)
}

// ImageAction defines an image action.
type ImageAction struct {
	// ActionType - A string representing the type of action.
	ActionType *string `json:"actionType,omitempty"`
	// Result - The result produced in the action.
	Result *[]BasicThing `json:"result,omitempty"`
	// DisplayName - A display name for the action.
	DisplayName *string `json:"displayName,omitempty"`
	// IsTopAction - A Boolean representing whether this result is the top action.
	IsTopAction *bool `json:"isTopAction,omitempty"`
	// ServiceURL - Use this URL to get additional data to determine how to take the appropriate action. For example, the serviceUrl might return JSON along with an image URL.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work.
	Text *string `json:"text,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicImageAction(body []byte) (BasicImageAction, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageEntityAction):
		var iea ImageEntityAction
		err := json.Unmarshal(body, &iea)
		return iea, err
	case string(TypeImageModuleAction):
		var ima ImageModuleAction
		err := json.Unmarshal(body, &ima)
		return ima, err
	case string(TypeImageRecipesAction):
		var ira ImageRecipesAction
		err := json.Unmarshal(body, &ira)
		return ira, err
	case string(TypeImageRelatedSearchesAction):
		var irsa ImageRelatedSearchesAction
		err := json.Unmarshal(body, &irsa)
		return irsa, err
	case string(TypeImageShoppingSourcesAction):
		var issa ImageShoppingSourcesAction
		err := json.Unmarshal(body, &issa)
		return issa, err
	default:
		var ia ImageAction
		err := json.Unmarshal(body, &ia)
		return ia, err
	}
}
func unmarshalBasicImageActionArray(body []byte) ([]BasicImageAction, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iaArray := make([]BasicImageAction, len(rawMessages))

	for index, rawMessage := range rawMessages {
		ia, err := unmarshalBasicImageAction(*rawMessage)
		if err != nil {
			return nil, err
		}
		iaArray[index] = ia
	}
	return iaArray, nil
}

// MarshalJSON is the custom marshaler for ImageAction.
func (ia ImageAction) MarshalJSON() ([]byte, error) {
	ia.Type = TypeImageAction
	objectMap := make(map[string]interface{})
	if ia.ActionType != nil {
		objectMap["actionType"] = ia.ActionType
	}
	if ia.Result != nil {
		objectMap["result"] = ia.Result
	}
	if ia.DisplayName != nil {
		objectMap["displayName"] = ia.DisplayName
	}
	if ia.IsTopAction != nil {
		objectMap["isTopAction"] = ia.IsTopAction
	}
	if ia.ServiceURL != nil {
		objectMap["serviceUrl"] = ia.ServiceURL
	}
	if ia.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = ia.ThumbnailURL
	}
	if ia.Provider != nil {
		objectMap["provider"] = ia.Provider
	}
	if ia.DatePublished != nil {
		objectMap["datePublished"] = ia.DatePublished
	}
	if ia.Text != nil {
		objectMap["text"] = ia.Text
	}
	if ia.Name != nil {
		objectMap["name"] = ia.Name
	}
	if ia.URL != nil {
		objectMap["url"] = ia.URL
	}
	if ia.Image != nil {
		objectMap["image"] = ia.Image
	}
	if ia.Description != nil {
		objectMap["description"] = ia.Description
	}
	if ia.AlternateName != nil {
		objectMap["alternateName"] = ia.AlternateName
	}
	if ia.BingID != nil {
		objectMap["bingId"] = ia.BingID
	}
	if ia.ReadLink != nil {
		objectMap["readLink"] = ia.ReadLink
	}
	if ia.WebSearchURL != nil {
		objectMap["webSearchUrl"] = ia.WebSearchURL
	}
	if ia.ID != nil {
		objectMap["id"] = ia.ID
	}
	if ia.Type != "" {
		objectMap["_type"] = ia.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsImageAction() (*ImageAction, bool) {
	return &ia, true
}

// AsBasicImageAction is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsBasicImageAction() (BasicImageAction, bool) {
	return &ia, true
}

// AsImageTag is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsBasicResponse() (BasicResponse, bool) {
	return &ia, true
}

// AsIdentifiable is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ia, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsBasicThing() (BasicThing, bool) {
	return &ia, true
}

// AsAction is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsBasicAction() (BasicAction, bool) {
	return &ia, true
}

// AsMediaObject is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &ia, true
}

// AsPerson is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageAction.
func (ia ImageAction) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ia, true
}

// UnmarshalJSON is the custom unmarshaler for ImageAction struct.
func (ia *ImageAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "actionType":
			if v != nil {
				var actionType string
				err = json.Unmarshal(*v, &actionType)
				if err != nil {
					return err
				}
				ia.ActionType = &actionType
			}
		case "result":
			if v != nil {
				resultVar, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				ia.Result = &resultVar
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				ia.DisplayName = &displayName
			}
		case "isTopAction":
			if v != nil {
				var isTopAction bool
				err = json.Unmarshal(*v, &isTopAction)
				if err != nil {
					return err
				}
				ia.IsTopAction = &isTopAction
			}
		case "serviceUrl":
			if v != nil {
				var serviceURL string
				err = json.Unmarshal(*v, &serviceURL)
				if err != nil {
					return err
				}
				ia.ServiceURL = &serviceURL
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				ia.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				ia.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				ia.DatePublished = &datePublished
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				ia.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ia.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				ia.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				ia.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ia.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				ia.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				ia.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				ia.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				ia.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ia.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ia.Type = typeVar
			}
		}
	}

	return nil
}

// ImageEntityAction defines an entity action.
type ImageEntityAction struct {
	// ActionType - A string representing the type of action.
	ActionType *string `json:"actionType,omitempty"`
	// Result - The result produced in the action.
	Result *[]BasicThing `json:"result,omitempty"`
	// DisplayName - A display name for the action.
	DisplayName *string `json:"displayName,omitempty"`
	// IsTopAction - A Boolean representing whether this result is the top action.
	IsTopAction *bool `json:"isTopAction,omitempty"`
	// ServiceURL - Use this URL to get additional data to determine how to take the appropriate action. For example, the serviceUrl might return JSON along with an image URL.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work.
	Text *string `json:"text,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageEntityAction.
func (iea ImageEntityAction) MarshalJSON() ([]byte, error) {
	iea.Type = TypeImageEntityAction
	objectMap := make(map[string]interface{})
	if iea.ActionType != nil {
		objectMap["actionType"] = iea.ActionType
	}
	if iea.Result != nil {
		objectMap["result"] = iea.Result
	}
	if iea.DisplayName != nil {
		objectMap["displayName"] = iea.DisplayName
	}
	if iea.IsTopAction != nil {
		objectMap["isTopAction"] = iea.IsTopAction
	}
	if iea.ServiceURL != nil {
		objectMap["serviceUrl"] = iea.ServiceURL
	}
	if iea.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = iea.ThumbnailURL
	}
	if iea.Provider != nil {
		objectMap["provider"] = iea.Provider
	}
	if iea.DatePublished != nil {
		objectMap["datePublished"] = iea.DatePublished
	}
	if iea.Text != nil {
		objectMap["text"] = iea.Text
	}
	if iea.Name != nil {
		objectMap["name"] = iea.Name
	}
	if iea.URL != nil {
		objectMap["url"] = iea.URL
	}
	if iea.Image != nil {
		objectMap["image"] = iea.Image
	}
	if iea.Description != nil {
		objectMap["description"] = iea.Description
	}
	if iea.AlternateName != nil {
		objectMap["alternateName"] = iea.AlternateName
	}
	if iea.BingID != nil {
		objectMap["bingId"] = iea.BingID
	}
	if iea.ReadLink != nil {
		objectMap["readLink"] = iea.ReadLink
	}
	if iea.WebSearchURL != nil {
		objectMap["webSearchUrl"] = iea.WebSearchURL
	}
	if iea.ID != nil {
		objectMap["id"] = iea.ID
	}
	if iea.Type != "" {
		objectMap["_type"] = iea.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsBasicImageAction() (BasicImageAction, bool) {
	return &iea, true
}

// AsImageTag is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsBasicResponse() (BasicResponse, bool) {
	return &iea, true
}

// AsIdentifiable is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &iea, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsBasicThing() (BasicThing, bool) {
	return &iea, true
}

// AsAction is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsBasicAction() (BasicAction, bool) {
	return &iea, true
}

// AsMediaObject is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &iea, true
}

// AsPerson is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsImageEntityAction() (*ImageEntityAction, bool) {
	return &iea, true
}

// AsImageModuleAction is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageEntityAction.
func (iea ImageEntityAction) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &iea, true
}

// UnmarshalJSON is the custom unmarshaler for ImageEntityAction struct.
func (iea *ImageEntityAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "actionType":
			if v != nil {
				var actionType string
				err = json.Unmarshal(*v, &actionType)
				if err != nil {
					return err
				}
				iea.ActionType = &actionType
			}
		case "result":
			if v != nil {
				resultVar, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				iea.Result = &resultVar
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				iea.DisplayName = &displayName
			}
		case "isTopAction":
			if v != nil {
				var isTopAction bool
				err = json.Unmarshal(*v, &isTopAction)
				if err != nil {
					return err
				}
				iea.IsTopAction = &isTopAction
			}
		case "serviceUrl":
			if v != nil {
				var serviceURL string
				err = json.Unmarshal(*v, &serviceURL)
				if err != nil {
					return err
				}
				iea.ServiceURL = &serviceURL
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				iea.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				iea.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				iea.DatePublished = &datePublished
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				iea.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				iea.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				iea.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				iea.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				iea.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				iea.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				iea.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				iea.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				iea.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				iea.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				iea.Type = typeVar
			}
		}
	}

	return nil
}

// ImageInfo a JSON object that identities the image to get insights of . It also includes the optional crop area
// that you use to identify the region of interest in the image.
type ImageInfo struct {
	// ImageInsightsToken - An image insights token. To get the insights token, call one of the Image Search APIs (for example, /images/search). In the search results, the [Image](https://docs.microsoft.com/en-us/rest/api/cognitiveservices/bing-images-api-v7-reference#image) object's [imageInsightsToken](https://docs.microsoft.com/en-us/rest/api/cognitiveservices/bing-images-api-v7-reference#image-imageinsightstoken) field contains the token. The imageInsightsToken and url fields mutually exclusive; do not specify both. Do not specify an insights token if the request includes the image form data.
	ImageInsightsToken *string `json:"imageInsightsToken,omitempty"`
	// URL - The URL of the input image. The imageInsightsToken and url fields are mutually exclusive; do not specify both. Do not specify the URL if the request includes the image form data.
	URL *string `json:"url,omitempty"`
	// CropArea - A JSON object consisting of coordinates specifying the four corners of a cropped rectangle within the input image. Use the crop area to identify the region of interest in the image. You can apply the crop area to the images specified using the imageInsightsToken or url fields, or an image binary specified in an image form data.
	CropArea *CropArea `json:"cropArea,omitempty"`
}

// ImageKnowledge defines a visual search API response.
type ImageKnowledge struct {
	autorest.Response `json:"-"`
	// Tags - A list of visual search tags.
	Tags *[]ImageTag `json:"tags,omitempty"`
	// Image - Image object containing metadata about the requested image.
	Image *ImageObject `json:"image,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageKnowledge.
func (ik ImageKnowledge) MarshalJSON() ([]byte, error) {
	ik.Type = TypeImageKnowledge
	objectMap := make(map[string]interface{})
	if ik.Tags != nil {
		objectMap["tags"] = ik.Tags
	}
	if ik.Image != nil {
		objectMap["image"] = ik.Image
	}
	if ik.ReadLink != nil {
		objectMap["readLink"] = ik.ReadLink
	}
	if ik.WebSearchURL != nil {
		objectMap["webSearchUrl"] = ik.WebSearchURL
	}
	if ik.ID != nil {
		objectMap["id"] = ik.ID
	}
	if ik.Type != "" {
		objectMap["_type"] = ik.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsImageKnowledge() (*ImageKnowledge, bool) {
	return &ik, true
}

// AsResponse is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsBasicResponse() (BasicResponse, bool) {
	return &ik, true
}

// AsIdentifiable is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ik, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageKnowledge.
func (ik ImageKnowledge) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ik, true
}

// ImageModuleAction defines an image list action.
type ImageModuleAction struct {
	// Data - A list of images.
	Data *ImagesModule `json:"data,omitempty"`
	// ActionType - A string representing the type of action.
	ActionType *string `json:"actionType,omitempty"`
	// Result - The result produced in the action.
	Result *[]BasicThing `json:"result,omitempty"`
	// DisplayName - A display name for the action.
	DisplayName *string `json:"displayName,omitempty"`
	// IsTopAction - A Boolean representing whether this result is the top action.
	IsTopAction *bool `json:"isTopAction,omitempty"`
	// ServiceURL - Use this URL to get additional data to determine how to take the appropriate action. For example, the serviceUrl might return JSON along with an image URL.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work.
	Text *string `json:"text,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageModuleAction.
func (ima ImageModuleAction) MarshalJSON() ([]byte, error) {
	ima.Type = TypeImageModuleAction
	objectMap := make(map[string]interface{})
	if ima.Data != nil {
		objectMap["data"] = ima.Data
	}
	if ima.ActionType != nil {
		objectMap["actionType"] = ima.ActionType
	}
	if ima.Result != nil {
		objectMap["result"] = ima.Result
	}
	if ima.DisplayName != nil {
		objectMap["displayName"] = ima.DisplayName
	}
	if ima.IsTopAction != nil {
		objectMap["isTopAction"] = ima.IsTopAction
	}
	if ima.ServiceURL != nil {
		objectMap["serviceUrl"] = ima.ServiceURL
	}
	if ima.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = ima.ThumbnailURL
	}
	if ima.Provider != nil {
		objectMap["provider"] = ima.Provider
	}
	if ima.DatePublished != nil {
		objectMap["datePublished"] = ima.DatePublished
	}
	if ima.Text != nil {
		objectMap["text"] = ima.Text
	}
	if ima.Name != nil {
		objectMap["name"] = ima.Name
	}
	if ima.URL != nil {
		objectMap["url"] = ima.URL
	}
	if ima.Image != nil {
		objectMap["image"] = ima.Image
	}
	if ima.Description != nil {
		objectMap["description"] = ima.Description
	}
	if ima.AlternateName != nil {
		objectMap["alternateName"] = ima.AlternateName
	}
	if ima.BingID != nil {
		objectMap["bingId"] = ima.BingID
	}
	if ima.ReadLink != nil {
		objectMap["readLink"] = ima.ReadLink
	}
	if ima.WebSearchURL != nil {
		objectMap["webSearchUrl"] = ima.WebSearchURL
	}
	if ima.ID != nil {
		objectMap["id"] = ima.ID
	}
	if ima.Type != "" {
		objectMap["_type"] = ima.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsBasicImageAction() (BasicImageAction, bool) {
	return &ima, true
}

// AsImageTag is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsBasicResponse() (BasicResponse, bool) {
	return &ima, true
}

// AsIdentifiable is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ima, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsBasicThing() (BasicThing, bool) {
	return &ima, true
}

// AsAction is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsBasicAction() (BasicAction, bool) {
	return &ima, true
}

// AsMediaObject is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &ima, true
}

// AsPerson is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsImageModuleAction() (*ImageModuleAction, bool) {
	return &ima, true
}

// AsRecipe is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageModuleAction.
func (ima ImageModuleAction) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ima, true
}

// UnmarshalJSON is the custom unmarshaler for ImageModuleAction struct.
func (ima *ImageModuleAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "data":
			if v != nil {
				var data ImagesModule
				err = json.Unmarshal(*v, &data)
				if err != nil {
					return err
				}
				ima.Data = &data
			}
		case "actionType":
			if v != nil {
				var actionType string
				err = json.Unmarshal(*v, &actionType)
				if err != nil {
					return err
				}
				ima.ActionType = &actionType
			}
		case "result":
			if v != nil {
				resultVar, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				ima.Result = &resultVar
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				ima.DisplayName = &displayName
			}
		case "isTopAction":
			if v != nil {
				var isTopAction bool
				err = json.Unmarshal(*v, &isTopAction)
				if err != nil {
					return err
				}
				ima.IsTopAction = &isTopAction
			}
		case "serviceUrl":
			if v != nil {
				var serviceURL string
				err = json.Unmarshal(*v, &serviceURL)
				if err != nil {
					return err
				}
				ima.ServiceURL = &serviceURL
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				ima.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				ima.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				ima.DatePublished = &datePublished
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				ima.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ima.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				ima.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				ima.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ima.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				ima.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				ima.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				ima.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				ima.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ima.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ima.Type = typeVar
			}
		}
	}

	return nil
}

// ImageObject defines an image.
type ImageObject struct {
	// Thumbnail - The URL to a thumbnail of the image.
	Thumbnail *ImageObject `json:"thumbnail,omitempty"`
	// ImageInsightsToken - The token that you use in a subsequent call to Visual Search API to get additional information about the image. For information about using this token, see the imageInsightsToken field inside the knowledgeRequest request parameter.
	ImageInsightsToken *string `json:"imageInsightsToken,omitempty"`
	// InsightsMetadata - A count of the number of websites where you can shop or perform other actions related to the image. For example, if the image is of an apple pie, this object includes a count of the number of websites where you can buy an apple pie. To indicate the number of offers in your UX, include badging such as a shopping cart icon that contains the count. When the user clicks on the icon, use imageInisghtsToken in a subsequent Visual Search API call to get the list of shopping websites.
	InsightsMetadata *ImagesImageMetadata `json:"insightsMetadata,omitempty"`
	// ImageID - Unique Id for the image.
	ImageID *string `json:"imageId,omitempty"`
	// AccentColor - A three-byte hexadecimal number that represents the color that dominates the image. Use the color as the temporary background in your client until the image is loaded.
	AccentColor *string `json:"accentColor,omitempty"`
	// VisualWords - For interal use only.
	VisualWords *string `json:"visualWords,omitempty"`
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g., the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// ContentSize - Size of the media object content. Use format "value unit" (e.g., "1024 B").
	ContentSize *string `json:"contentSize,omitempty"`
	// EncodingFormat - Encoding format (e.g., mp3, mp4, jpeg, etc).
	EncodingFormat *string `json:"encodingFormat,omitempty"`
	// HostPageDisplayURL - Display URL of the page that hosts the media object.
	HostPageDisplayURL *string `json:"hostPageDisplayUrl,omitempty"`
	// Width - The width of the media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the media object, in pixels.
	Height *int32 `json:"height,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work.
	Text *string `json:"text,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageObject.
func (ioVar ImageObject) MarshalJSON() ([]byte, error) {
	ioVar.Type = TypeImageObject
	objectMap := make(map[string]interface{})
	if ioVar.Thumbnail != nil {
		objectMap["thumbnail"] = ioVar.Thumbnail
	}
	if ioVar.ImageInsightsToken != nil {
		objectMap["imageInsightsToken"] = ioVar.ImageInsightsToken
	}
	if ioVar.InsightsMetadata != nil {
		objectMap["insightsMetadata"] = ioVar.InsightsMetadata
	}
	if ioVar.ImageID != nil {
		objectMap["imageId"] = ioVar.ImageID
	}
	if ioVar.AccentColor != nil {
		objectMap["accentColor"] = ioVar.AccentColor
	}
	if ioVar.VisualWords != nil {
		objectMap["visualWords"] = ioVar.VisualWords
	}
	if ioVar.ContentURL != nil {
		objectMap["contentUrl"] = ioVar.ContentURL
	}
	if ioVar.HostPageURL != nil {
		objectMap["hostPageUrl"] = ioVar.HostPageURL
	}
	if ioVar.ContentSize != nil {
		objectMap["contentSize"] = ioVar.ContentSize
	}
	if ioVar.EncodingFormat != nil {
		objectMap["encodingFormat"] = ioVar.EncodingFormat
	}
	if ioVar.HostPageDisplayURL != nil {
		objectMap["hostPageDisplayUrl"] = ioVar.HostPageDisplayURL
	}
	if ioVar.Width != nil {
		objectMap["width"] = ioVar.Width
	}
	if ioVar.Height != nil {
		objectMap["height"] = ioVar.Height
	}
	if ioVar.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = ioVar.ThumbnailURL
	}
	if ioVar.Provider != nil {
		objectMap["provider"] = ioVar.Provider
	}
	if ioVar.DatePublished != nil {
		objectMap["datePublished"] = ioVar.DatePublished
	}
	if ioVar.Text != nil {
		objectMap["text"] = ioVar.Text
	}
	if ioVar.Name != nil {
		objectMap["name"] = ioVar.Name
	}
	if ioVar.URL != nil {
		objectMap["url"] = ioVar.URL
	}
	if ioVar.Image != nil {
		objectMap["image"] = ioVar.Image
	}
	if ioVar.Description != nil {
		objectMap["description"] = ioVar.Description
	}
	if ioVar.AlternateName != nil {
		objectMap["alternateName"] = ioVar.AlternateName
	}
	if ioVar.BingID != nil {
		objectMap["bingId"] = ioVar.BingID
	}
	if ioVar.ReadLink != nil {
		objectMap["readLink"] = ioVar.ReadLink
	}
	if ioVar.WebSearchURL != nil {
		objectMap["webSearchUrl"] = ioVar.WebSearchURL
	}
	if ioVar.ID != nil {
		objectMap["id"] = ioVar.ID
	}
	if ioVar.Type != "" {
		objectMap["_type"] = ioVar.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageObject() (*ImageObject, bool) {
	return &ioVar, true
}

// AsImageKnowledge is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponse() (BasicResponse, bool) {
	return &ioVar, true
}

// AsIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ioVar, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicThing() (BasicThing, bool) {
	return &ioVar, true
}

// AsAction is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &ioVar, true
}

// AsCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &ioVar, true
}

// AsPerson is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageObject.
func (ioVar ImageObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ioVar, true
}

// UnmarshalJSON is the custom unmarshaler for ImageObject struct.
func (ioVar *ImageObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "thumbnail":
			if v != nil {
				var thumbnail ImageObject
				err = json.Unmarshal(*v, &thumbnail)
				if err != nil {
					return err
				}
				ioVar.Thumbnail = &thumbnail
			}
		case "imageInsightsToken":
			if v != nil {
				var imageInsightsToken string
				err = json.Unmarshal(*v, &imageInsightsToken)
				if err != nil {
					return err
				}
				ioVar.ImageInsightsToken = &imageInsightsToken
			}
		case "insightsMetadata":
			if v != nil {
				var insightsMetadata ImagesImageMetadata
				err = json.Unmarshal(*v, &insightsMetadata)
				if err != nil {
					return err
				}
				ioVar.InsightsMetadata = &insightsMetadata
			}
		case "imageId":
			if v != nil {
				var imageID string
				err = json.Unmarshal(*v, &imageID)
				if err != nil {
					return err
				}
				ioVar.ImageID = &imageID
			}
		case "accentColor":
			if v != nil {
				var accentColor string
				err = json.Unmarshal(*v, &accentColor)
				if err != nil {
					return err
				}
				ioVar.AccentColor = &accentColor
			}
		case "visualWords":
			if v != nil {
				var visualWords string
				err = json.Unmarshal(*v, &visualWords)
				if err != nil {
					return err
				}
				ioVar.VisualWords = &visualWords
			}
		case "contentUrl":
			if v != nil {
				var contentURL string
				err = json.Unmarshal(*v, &contentURL)
				if err != nil {
					return err
				}
				ioVar.ContentURL = &contentURL
			}
		case "hostPageUrl":
			if v != nil {
				var hostPageURL string
				err = json.Unmarshal(*v, &hostPageURL)
				if err != nil {
					return err
				}
				ioVar.HostPageURL = &hostPageURL
			}
		case "contentSize":
			if v != nil {
				var contentSize string
				err = json.Unmarshal(*v, &contentSize)
				if err != nil {
					return err
				}
				ioVar.ContentSize = &contentSize
			}
		case "encodingFormat":
			if v != nil {
				var encodingFormat string
				err = json.Unmarshal(*v, &encodingFormat)
				if err != nil {
					return err
				}
				ioVar.EncodingFormat = &encodingFormat
			}
		case "hostPageDisplayUrl":
			if v != nil {
				var hostPageDisplayURL string
				err = json.Unmarshal(*v, &hostPageDisplayURL)
				if err != nil {
					return err
				}
				ioVar.HostPageDisplayURL = &hostPageDisplayURL
			}
		case "width":
			if v != nil {
				var width int32
				err = json.Unmarshal(*v, &width)
				if err != nil {
					return err
				}
				ioVar.Width = &width
			}
		case "height":
			if v != nil {
				var height int32
				err = json.Unmarshal(*v, &height)
				if err != nil {
					return err
				}
				ioVar.Height = &height
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				ioVar.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				ioVar.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				ioVar.DatePublished = &datePublished
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				ioVar.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ioVar.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				ioVar.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				ioVar.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ioVar.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				ioVar.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				ioVar.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				ioVar.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				ioVar.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ioVar.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ioVar.Type = typeVar
			}
		}
	}

	return nil
}

// ImageRecipesAction defines an recipe action.
type ImageRecipesAction struct {
	// Data - A list of recipes related to the image.
	Data *RecipesModule `json:"data,omitempty"`
	// ActionType - A string representing the type of action.
	ActionType *string `json:"actionType,omitempty"`
	// Result - The result produced in the action.
	Result *[]BasicThing `json:"result,omitempty"`
	// DisplayName - A display name for the action.
	DisplayName *string `json:"displayName,omitempty"`
	// IsTopAction - A Boolean representing whether this result is the top action.
	IsTopAction *bool `json:"isTopAction,omitempty"`
	// ServiceURL - Use this URL to get additional data to determine how to take the appropriate action. For example, the serviceUrl might return JSON along with an image URL.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work.
	Text *string `json:"text,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageRecipesAction.
func (ira ImageRecipesAction) MarshalJSON() ([]byte, error) {
	ira.Type = TypeImageRecipesAction
	objectMap := make(map[string]interface{})
	if ira.Data != nil {
		objectMap["data"] = ira.Data
	}
	if ira.ActionType != nil {
		objectMap["actionType"] = ira.ActionType
	}
	if ira.Result != nil {
		objectMap["result"] = ira.Result
	}
	if ira.DisplayName != nil {
		objectMap["displayName"] = ira.DisplayName
	}
	if ira.IsTopAction != nil {
		objectMap["isTopAction"] = ira.IsTopAction
	}
	if ira.ServiceURL != nil {
		objectMap["serviceUrl"] = ira.ServiceURL
	}
	if ira.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = ira.ThumbnailURL
	}
	if ira.Provider != nil {
		objectMap["provider"] = ira.Provider
	}
	if ira.DatePublished != nil {
		objectMap["datePublished"] = ira.DatePublished
	}
	if ira.Text != nil {
		objectMap["text"] = ira.Text
	}
	if ira.Name != nil {
		objectMap["name"] = ira.Name
	}
	if ira.URL != nil {
		objectMap["url"] = ira.URL
	}
	if ira.Image != nil {
		objectMap["image"] = ira.Image
	}
	if ira.Description != nil {
		objectMap["description"] = ira.Description
	}
	if ira.AlternateName != nil {
		objectMap["alternateName"] = ira.AlternateName
	}
	if ira.BingID != nil {
		objectMap["bingId"] = ira.BingID
	}
	if ira.ReadLink != nil {
		objectMap["readLink"] = ira.ReadLink
	}
	if ira.WebSearchURL != nil {
		objectMap["webSearchUrl"] = ira.WebSearchURL
	}
	if ira.ID != nil {
		objectMap["id"] = ira.ID
	}
	if ira.Type != "" {
		objectMap["_type"] = ira.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsBasicImageAction() (BasicImageAction, bool) {
	return &ira, true
}

// AsImageTag is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsBasicResponse() (BasicResponse, bool) {
	return &ira, true
}

// AsIdentifiable is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &ira, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsBasicThing() (BasicThing, bool) {
	return &ira, true
}

// AsAction is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsBasicAction() (BasicAction, bool) {
	return &ira, true
}

// AsMediaObject is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &ira, true
}

// AsPerson is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return &ira, true
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageRecipesAction.
func (ira ImageRecipesAction) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &ira, true
}

// UnmarshalJSON is the custom unmarshaler for ImageRecipesAction struct.
func (ira *ImageRecipesAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "data":
			if v != nil {
				var data RecipesModule
				err = json.Unmarshal(*v, &data)
				if err != nil {
					return err
				}
				ira.Data = &data
			}
		case "actionType":
			if v != nil {
				var actionType string
				err = json.Unmarshal(*v, &actionType)
				if err != nil {
					return err
				}
				ira.ActionType = &actionType
			}
		case "result":
			if v != nil {
				resultVar, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				ira.Result = &resultVar
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				ira.DisplayName = &displayName
			}
		case "isTopAction":
			if v != nil {
				var isTopAction bool
				err = json.Unmarshal(*v, &isTopAction)
				if err != nil {
					return err
				}
				ira.IsTopAction = &isTopAction
			}
		case "serviceUrl":
			if v != nil {
				var serviceURL string
				err = json.Unmarshal(*v, &serviceURL)
				if err != nil {
					return err
				}
				ira.ServiceURL = &serviceURL
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				ira.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				ira.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				ira.DatePublished = &datePublished
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				ira.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				ira.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				ira.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				ira.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				ira.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				ira.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				ira.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				ira.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				ira.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				ira.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				ira.Type = typeVar
			}
		}
	}

	return nil
}

// ImageRelatedSearchesAction defines an related search action.
type ImageRelatedSearchesAction struct {
	// Data - A list of queries related to the image.
	Data *RelatedSearchesModule `json:"data,omitempty"`
	// ActionType - A string representing the type of action.
	ActionType *string `json:"actionType,omitempty"`
	// Result - The result produced in the action.
	Result *[]BasicThing `json:"result,omitempty"`
	// DisplayName - A display name for the action.
	DisplayName *string `json:"displayName,omitempty"`
	// IsTopAction - A Boolean representing whether this result is the top action.
	IsTopAction *bool `json:"isTopAction,omitempty"`
	// ServiceURL - Use this URL to get additional data to determine how to take the appropriate action. For example, the serviceUrl might return JSON along with an image URL.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work.
	Text *string `json:"text,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) MarshalJSON() ([]byte, error) {
	irsa.Type = TypeImageRelatedSearchesAction
	objectMap := make(map[string]interface{})
	if irsa.Data != nil {
		objectMap["data"] = irsa.Data
	}
	if irsa.ActionType != nil {
		objectMap["actionType"] = irsa.ActionType
	}
	if irsa.Result != nil {
		objectMap["result"] = irsa.Result
	}
	if irsa.DisplayName != nil {
		objectMap["displayName"] = irsa.DisplayName
	}
	if irsa.IsTopAction != nil {
		objectMap["isTopAction"] = irsa.IsTopAction
	}
	if irsa.ServiceURL != nil {
		objectMap["serviceUrl"] = irsa.ServiceURL
	}
	if irsa.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = irsa.ThumbnailURL
	}
	if irsa.Provider != nil {
		objectMap["provider"] = irsa.Provider
	}
	if irsa.DatePublished != nil {
		objectMap["datePublished"] = irsa.DatePublished
	}
	if irsa.Text != nil {
		objectMap["text"] = irsa.Text
	}
	if irsa.Name != nil {
		objectMap["name"] = irsa.Name
	}
	if irsa.URL != nil {
		objectMap["url"] = irsa.URL
	}
	if irsa.Image != nil {
		objectMap["image"] = irsa.Image
	}
	if irsa.Description != nil {
		objectMap["description"] = irsa.Description
	}
	if irsa.AlternateName != nil {
		objectMap["alternateName"] = irsa.AlternateName
	}
	if irsa.BingID != nil {
		objectMap["bingId"] = irsa.BingID
	}
	if irsa.ReadLink != nil {
		objectMap["readLink"] = irsa.ReadLink
	}
	if irsa.WebSearchURL != nil {
		objectMap["webSearchUrl"] = irsa.WebSearchURL
	}
	if irsa.ID != nil {
		objectMap["id"] = irsa.ID
	}
	if irsa.Type != "" {
		objectMap["_type"] = irsa.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsBasicImageAction() (BasicImageAction, bool) {
	return &irsa, true
}

// AsImageTag is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsBasicResponse() (BasicResponse, bool) {
	return &irsa, true
}

// AsIdentifiable is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &irsa, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsBasicThing() (BasicThing, bool) {
	return &irsa, true
}

// AsAction is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsBasicAction() (BasicAction, bool) {
	return &irsa, true
}

// AsMediaObject is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &irsa, true
}

// AsPerson is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return &irsa, true
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageRelatedSearchesAction.
func (irsa ImageRelatedSearchesAction) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &irsa, true
}

// UnmarshalJSON is the custom unmarshaler for ImageRelatedSearchesAction struct.
func (irsa *ImageRelatedSearchesAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "data":
			if v != nil {
				var data RelatedSearchesModule
				err = json.Unmarshal(*v, &data)
				if err != nil {
					return err
				}
				irsa.Data = &data
			}
		case "actionType":
			if v != nil {
				var actionType string
				err = json.Unmarshal(*v, &actionType)
				if err != nil {
					return err
				}
				irsa.ActionType = &actionType
			}
		case "result":
			if v != nil {
				resultVar, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				irsa.Result = &resultVar
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				irsa.DisplayName = &displayName
			}
		case "isTopAction":
			if v != nil {
				var isTopAction bool
				err = json.Unmarshal(*v, &isTopAction)
				if err != nil {
					return err
				}
				irsa.IsTopAction = &isTopAction
			}
		case "serviceUrl":
			if v != nil {
				var serviceURL string
				err = json.Unmarshal(*v, &serviceURL)
				if err != nil {
					return err
				}
				irsa.ServiceURL = &serviceURL
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				irsa.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				irsa.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				irsa.DatePublished = &datePublished
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				irsa.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				irsa.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				irsa.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				irsa.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				irsa.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				irsa.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				irsa.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				irsa.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				irsa.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				irsa.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				irsa.Type = typeVar
			}
		}
	}

	return nil
}

// ImageShoppingSourcesAction defines a shopping sources action.
type ImageShoppingSourcesAction struct {
	// Data - A list of merchants that offer items related to the image.
	Data *AggregateOffer `json:"data,omitempty"`
	// ActionType - A string representing the type of action.
	ActionType *string `json:"actionType,omitempty"`
	// Result - The result produced in the action.
	Result *[]BasicThing `json:"result,omitempty"`
	// DisplayName - A display name for the action.
	DisplayName *string `json:"displayName,omitempty"`
	// IsTopAction - A Boolean representing whether this result is the top action.
	IsTopAction *bool `json:"isTopAction,omitempty"`
	// ServiceURL - Use this URL to get additional data to determine how to take the appropriate action. For example, the serviceUrl might return JSON along with an image URL.
	ServiceURL *string `json:"serviceUrl,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work.
	Text *string `json:"text,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) MarshalJSON() ([]byte, error) {
	issa.Type = TypeImageShoppingSourcesAction
	objectMap := make(map[string]interface{})
	if issa.Data != nil {
		objectMap["data"] = issa.Data
	}
	if issa.ActionType != nil {
		objectMap["actionType"] = issa.ActionType
	}
	if issa.Result != nil {
		objectMap["result"] = issa.Result
	}
	if issa.DisplayName != nil {
		objectMap["displayName"] = issa.DisplayName
	}
	if issa.IsTopAction != nil {
		objectMap["isTopAction"] = issa.IsTopAction
	}
	if issa.ServiceURL != nil {
		objectMap["serviceUrl"] = issa.ServiceURL
	}
	if issa.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = issa.ThumbnailURL
	}
	if issa.Provider != nil {
		objectMap["provider"] = issa.Provider
	}
	if issa.DatePublished != nil {
		objectMap["datePublished"] = issa.DatePublished
	}
	if issa.Text != nil {
		objectMap["text"] = issa.Text
	}
	if issa.Name != nil {
		objectMap["name"] = issa.Name
	}
	if issa.URL != nil {
		objectMap["url"] = issa.URL
	}
	if issa.Image != nil {
		objectMap["image"] = issa.Image
	}
	if issa.Description != nil {
		objectMap["description"] = issa.Description
	}
	if issa.AlternateName != nil {
		objectMap["alternateName"] = issa.AlternateName
	}
	if issa.BingID != nil {
		objectMap["bingId"] = issa.BingID
	}
	if issa.ReadLink != nil {
		objectMap["readLink"] = issa.ReadLink
	}
	if issa.WebSearchURL != nil {
		objectMap["webSearchUrl"] = issa.WebSearchURL
	}
	if issa.ID != nil {
		objectMap["id"] = issa.ID
	}
	if issa.Type != "" {
		objectMap["_type"] = issa.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsBasicImageAction() (BasicImageAction, bool) {
	return &issa, true
}

// AsImageTag is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsBasicResponse() (BasicResponse, bool) {
	return &issa, true
}

// AsIdentifiable is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &issa, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsBasicThing() (BasicThing, bool) {
	return &issa, true
}

// AsAction is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsBasicAction() (BasicAction, bool) {
	return &issa, true
}

// AsMediaObject is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &issa, true
}

// AsPerson is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return &issa, true
}

// AsStructuredValue is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageShoppingSourcesAction.
func (issa ImageShoppingSourcesAction) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &issa, true
}

// UnmarshalJSON is the custom unmarshaler for ImageShoppingSourcesAction struct.
func (issa *ImageShoppingSourcesAction) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "data":
			if v != nil {
				var data AggregateOffer
				err = json.Unmarshal(*v, &data)
				if err != nil {
					return err
				}
				issa.Data = &data
			}
		case "actionType":
			if v != nil {
				var actionType string
				err = json.Unmarshal(*v, &actionType)
				if err != nil {
					return err
				}
				issa.ActionType = &actionType
			}
		case "result":
			if v != nil {
				resultVar, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				issa.Result = &resultVar
			}
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				issa.DisplayName = &displayName
			}
		case "isTopAction":
			if v != nil {
				var isTopAction bool
				err = json.Unmarshal(*v, &isTopAction)
				if err != nil {
					return err
				}
				issa.IsTopAction = &isTopAction
			}
		case "serviceUrl":
			if v != nil {
				var serviceURL string
				err = json.Unmarshal(*v, &serviceURL)
				if err != nil {
					return err
				}
				issa.ServiceURL = &serviceURL
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				issa.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				issa.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				issa.DatePublished = &datePublished
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				issa.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				issa.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				issa.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				issa.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				issa.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				issa.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				issa.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				issa.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				issa.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				issa.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				issa.Type = typeVar
			}
		}
	}

	return nil
}

// ImagesImageMetadata defines a count of the number of websites where you can shop or perform other actions
// related to the image.
type ImagesImageMetadata struct {
	// ShoppingSourcesCount - The number of websites that sell the products seen in the image.
	ShoppingSourcesCount *int32 `json:"shoppingSourcesCount,omitempty"`
	// RecipeSourcesCount - The number of websites that offer recipes of the food seen in the image.
	RecipeSourcesCount *int32 `json:"recipeSourcesCount,omitempty"`
	// AggregateOffer - A summary of the online offers of products found in the image. For example, if the image is of a dress, the offer might identify the lowest price and the number of offers found. Only visually similar products insights include this field. The offer includes the following fields: Name, AggregateRating, OfferCount, and LowPrice.
	AggregateOffer *AggregateOffer `json:"aggregateOffer,omitempty"`
}

// ImagesModule defines a list of images.
type ImagesModule struct {
	// Value - A list of images.
	Value *[]ImageObject `json:"value,omitempty"`
}

// ImageTag a visual search tag.
type ImageTag struct {
	// DisplayName - Display name for this tag. For the default tag, the display name is empty.
	DisplayName *string `json:"displayName,omitempty"`
	// BoundingBox - The bounding box for this tag. For the default tag, there is no bounding box.
	BoundingBox *ImageTagRegion `json:"boundingBox,omitempty"`
	// Actions - Actions within this tag. The order of the items denotes the default ranking order of these actions, with the first action being the most likely user intent.
	Actions *[]BasicImageAction `json:"actions,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for ImageTag.
func (it ImageTag) MarshalJSON() ([]byte, error) {
	it.Type = TypeImageTag
	objectMap := make(map[string]interface{})
	if it.DisplayName != nil {
		objectMap["displayName"] = it.DisplayName
	}
	if it.BoundingBox != nil {
		objectMap["boundingBox"] = it.BoundingBox
	}
	if it.Actions != nil {
		objectMap["actions"] = it.Actions
	}
	if it.Name != nil {
		objectMap["name"] = it.Name
	}
	if it.URL != nil {
		objectMap["url"] = it.URL
	}
	if it.Image != nil {
		objectMap["image"] = it.Image
	}
	if it.Description != nil {
		objectMap["description"] = it.Description
	}
	if it.AlternateName != nil {
		objectMap["alternateName"] = it.AlternateName
	}
	if it.BingID != nil {
		objectMap["bingId"] = it.BingID
	}
	if it.ReadLink != nil {
		objectMap["readLink"] = it.ReadLink
	}
	if it.WebSearchURL != nil {
		objectMap["webSearchUrl"] = it.WebSearchURL
	}
	if it.ID != nil {
		objectMap["id"] = it.ID
	}
	if it.Type != "" {
		objectMap["_type"] = it.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsImageTag() (*ImageTag, bool) {
	return &it, true
}

// AsOrganization is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsBasicResponse() (BasicResponse, bool) {
	return &it, true
}

// AsIdentifiable is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &it, true
}

// AsErrorResponse is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsBasicThing() (BasicThing, bool) {
	return &it, true
}

// AsAction is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for ImageTag.
func (it ImageTag) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &it, true
}

// UnmarshalJSON is the custom unmarshaler for ImageTag struct.
func (it *ImageTag) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "displayName":
			if v != nil {
				var displayName string
				err = json.Unmarshal(*v, &displayName)
				if err != nil {
					return err
				}
				it.DisplayName = &displayName
			}
		case "boundingBox":
			if v != nil {
				var boundingBox ImageTagRegion
				err = json.Unmarshal(*v, &boundingBox)
				if err != nil {
					return err
				}
				it.BoundingBox = &boundingBox
			}
		case "actions":
			if v != nil {
				actions, err := unmarshalBasicImageActionArray(*v)
				if err != nil {
					return err
				}
				it.Actions = &actions
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				it.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				it.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				it.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				it.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				it.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				it.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				it.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				it.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				it.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				it.Type = typeVar
			}
		}
	}

	return nil
}

// ImageTagRegion defines an image region relevant to the ImageTag.
type ImageTagRegion struct {
	// QueryRectangle - A rectangle that outlines the area of interest for this tag.
	QueryRectangle *NormalizedQuadrilateral `json:"queryRectangle,omitempty"`
	// DisplayRectangle - A recommended rectangle to show to the user.
	DisplayRectangle *NormalizedQuadrilateral `json:"displayRectangle,omitempty"`
}

// BasicIntangible a utility class that serves as the umbrella for a number of 'intangible' things such as quantities,
// structured values, etc.
type BasicIntangible interface {
	AsPoint2D() (*Point2D, bool)
	AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsIntangible() (*Intangible, bool)
}

// Intangible a utility class that serves as the umbrella for a number of 'intangible' things such as quantities,
// structured values, etc.
type Intangible struct {
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicIntangible(body []byte) (BasicIntangible, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypePoint2D):
		var p2 Point2D
		err := json.Unmarshal(body, &p2)
		return p2, err
	case string(TypeNormalizedQuadrilateral):
		var nq NormalizedQuadrilateral
		err := json.Unmarshal(body, &nq)
		return nq, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	}
}
func unmarshalBasicIntangibleArray(body []byte) ([]BasicIntangible, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	iArray := make([]BasicIntangible, len(rawMessages))

	for index, rawMessage := range rawMessages {
		i, err := unmarshalBasicIntangible(*rawMessage)
		if err != nil {
			return nil, err
		}
		iArray[index] = i
	}
	return iArray, nil
}

// MarshalJSON is the custom marshaler for Intangible.
func (i Intangible) MarshalJSON() ([]byte, error) {
	i.Type = TypeIntangible
	objectMap := make(map[string]interface{})
	if i.Name != nil {
		objectMap["name"] = i.Name
	}
	if i.URL != nil {
		objectMap["url"] = i.URL
	}
	if i.Image != nil {
		objectMap["image"] = i.Image
	}
	if i.Description != nil {
		objectMap["description"] = i.Description
	}
	if i.AlternateName != nil {
		objectMap["alternateName"] = i.AlternateName
	}
	if i.BingID != nil {
		objectMap["bingId"] = i.BingID
	}
	if i.ReadLink != nil {
		objectMap["readLink"] = i.ReadLink
	}
	if i.WebSearchURL != nil {
		objectMap["webSearchUrl"] = i.WebSearchURL
	}
	if i.ID != nil {
		objectMap["id"] = i.ID
	}
	if i.Type != "" {
		objectMap["_type"] = i.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicResponse() (BasicResponse, bool) {
	return &i, true
}

// AsIdentifiable is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &i, true
}

// AsErrorResponse is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicThing() (BasicThing, bool) {
	return &i, true
}

// AsAction is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsIntangible() (*Intangible, bool) {
	return &i, true
}

// AsBasicIntangible is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicIntangible() (BasicIntangible, bool) {
	return &i, true
}

// AsImageEntityAction is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Intangible.
func (i Intangible) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &i, true
}

// KnowledgeRequest a JSON object containing information about the request, such as filters for the resulting
// actions.
type KnowledgeRequest struct {
	// Filters - A key-value object consisting of filters that may be specified to limit the results returned by the API.
	Filters *Filters `json:"filters,omitempty"`
}

// BasicMediaObject defines a media object.
type BasicMediaObject interface {
	AsImageObject() (*ImageObject, bool)
	AsMediaObject() (*MediaObject, bool)
}

// MediaObject defines a media object.
type MediaObject struct {
	// ContentURL - Original URL to retrieve the source (file) for the media object (e.g., the source URL for the image).
	ContentURL *string `json:"contentUrl,omitempty"`
	// HostPageURL - URL of the page that hosts the media object.
	HostPageURL *string `json:"hostPageUrl,omitempty"`
	// ContentSize - Size of the media object content. Use format "value unit" (e.g., "1024 B").
	ContentSize *string `json:"contentSize,omitempty"`
	// EncodingFormat - Encoding format (e.g., mp3, mp4, jpeg, etc).
	EncodingFormat *string `json:"encodingFormat,omitempty"`
	// HostPageDisplayURL - Display URL of the page that hosts the media object.
	HostPageDisplayURL *string `json:"hostPageDisplayUrl,omitempty"`
	// Width - The width of the media object, in pixels.
	Width *int32 `json:"width,omitempty"`
	// Height - The height of the media object, in pixels.
	Height *int32 `json:"height,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work.
	Text *string `json:"text,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicMediaObject(body []byte) (BasicMediaObject, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	default:
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	}
}
func unmarshalBasicMediaObjectArray(body []byte) ([]BasicMediaObject, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	moArray := make([]BasicMediaObject, len(rawMessages))

	for index, rawMessage := range rawMessages {
		mo, err := unmarshalBasicMediaObject(*rawMessage)
		if err != nil {
			return nil, err
		}
		moArray[index] = mo
	}
	return moArray, nil
}

// MarshalJSON is the custom marshaler for MediaObject.
func (mo MediaObject) MarshalJSON() ([]byte, error) {
	mo.Type = TypeMediaObject
	objectMap := make(map[string]interface{})
	if mo.ContentURL != nil {
		objectMap["contentUrl"] = mo.ContentURL
	}
	if mo.HostPageURL != nil {
		objectMap["hostPageUrl"] = mo.HostPageURL
	}
	if mo.ContentSize != nil {
		objectMap["contentSize"] = mo.ContentSize
	}
	if mo.EncodingFormat != nil {
		objectMap["encodingFormat"] = mo.EncodingFormat
	}
	if mo.HostPageDisplayURL != nil {
		objectMap["hostPageDisplayUrl"] = mo.HostPageDisplayURL
	}
	if mo.Width != nil {
		objectMap["width"] = mo.Width
	}
	if mo.Height != nil {
		objectMap["height"] = mo.Height
	}
	if mo.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = mo.ThumbnailURL
	}
	if mo.Provider != nil {
		objectMap["provider"] = mo.Provider
	}
	if mo.DatePublished != nil {
		objectMap["datePublished"] = mo.DatePublished
	}
	if mo.Text != nil {
		objectMap["text"] = mo.Text
	}
	if mo.Name != nil {
		objectMap["name"] = mo.Name
	}
	if mo.URL != nil {
		objectMap["url"] = mo.URL
	}
	if mo.Image != nil {
		objectMap["image"] = mo.Image
	}
	if mo.Description != nil {
		objectMap["description"] = mo.Description
	}
	if mo.AlternateName != nil {
		objectMap["alternateName"] = mo.AlternateName
	}
	if mo.BingID != nil {
		objectMap["bingId"] = mo.BingID
	}
	if mo.ReadLink != nil {
		objectMap["readLink"] = mo.ReadLink
	}
	if mo.WebSearchURL != nil {
		objectMap["webSearchUrl"] = mo.WebSearchURL
	}
	if mo.ID != nil {
		objectMap["id"] = mo.ID
	}
	if mo.Type != "" {
		objectMap["_type"] = mo.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponse() (BasicResponse, bool) {
	return &mo, true
}

// AsIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &mo, true
}

// AsErrorResponse is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicThing() (BasicThing, bool) {
	return &mo, true
}

// AsAction is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsMediaObject() (*MediaObject, bool) {
	return &mo, true
}

// AsBasicMediaObject is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicMediaObject() (BasicMediaObject, bool) {
	return &mo, true
}

// AsCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &mo, true
}

// AsPerson is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for MediaObject.
func (mo MediaObject) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &mo, true
}

// UnmarshalJSON is the custom unmarshaler for MediaObject struct.
func (mo *MediaObject) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "contentUrl":
			if v != nil {
				var contentURL string
				err = json.Unmarshal(*v, &contentURL)
				if err != nil {
					return err
				}
				mo.ContentURL = &contentURL
			}
		case "hostPageUrl":
			if v != nil {
				var hostPageURL string
				err = json.Unmarshal(*v, &hostPageURL)
				if err != nil {
					return err
				}
				mo.HostPageURL = &hostPageURL
			}
		case "contentSize":
			if v != nil {
				var contentSize string
				err = json.Unmarshal(*v, &contentSize)
				if err != nil {
					return err
				}
				mo.ContentSize = &contentSize
			}
		case "encodingFormat":
			if v != nil {
				var encodingFormat string
				err = json.Unmarshal(*v, &encodingFormat)
				if err != nil {
					return err
				}
				mo.EncodingFormat = &encodingFormat
			}
		case "hostPageDisplayUrl":
			if v != nil {
				var hostPageDisplayURL string
				err = json.Unmarshal(*v, &hostPageDisplayURL)
				if err != nil {
					return err
				}
				mo.HostPageDisplayURL = &hostPageDisplayURL
			}
		case "width":
			if v != nil {
				var width int32
				err = json.Unmarshal(*v, &width)
				if err != nil {
					return err
				}
				mo.Width = &width
			}
		case "height":
			if v != nil {
				var height int32
				err = json.Unmarshal(*v, &height)
				if err != nil {
					return err
				}
				mo.Height = &height
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				mo.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				mo.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				mo.DatePublished = &datePublished
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				mo.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mo.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				mo.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				mo.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				mo.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				mo.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				mo.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				mo.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				mo.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mo.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mo.Type = typeVar
			}
		}
	}

	return nil
}

// NormalizedQuadrilateral defines a region of an image. The region is a convex quadrilateral defined by
// coordinates of its top left, top right, bottom left, and bottom right points. The coordinates are fractional
// values of the original image's width and height in the range 0.0 through 1.0.
type NormalizedQuadrilateral struct {
	// TopLeft - The top left corner coordinate.
	TopLeft *Point2D `json:"topLeft,omitempty"`
	// TopRight - The top right corner coordinate.
	TopRight *Point2D `json:"topRight,omitempty"`
	// BottomRight - The bottom right corner coordinate.
	BottomRight *Point2D `json:"bottomRight,omitempty"`
	// BottomLeft - The bottom left corner coordinate.
	BottomLeft *Point2D `json:"bottomLeft,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) MarshalJSON() ([]byte, error) {
	nq.Type = TypeNormalizedQuadrilateral
	objectMap := make(map[string]interface{})
	if nq.TopLeft != nil {
		objectMap["topLeft"] = nq.TopLeft
	}
	if nq.TopRight != nil {
		objectMap["topRight"] = nq.TopRight
	}
	if nq.BottomRight != nil {
		objectMap["bottomRight"] = nq.BottomRight
	}
	if nq.BottomLeft != nil {
		objectMap["bottomLeft"] = nq.BottomLeft
	}
	if nq.Name != nil {
		objectMap["name"] = nq.Name
	}
	if nq.URL != nil {
		objectMap["url"] = nq.URL
	}
	if nq.Image != nil {
		objectMap["image"] = nq.Image
	}
	if nq.Description != nil {
		objectMap["description"] = nq.Description
	}
	if nq.AlternateName != nil {
		objectMap["alternateName"] = nq.AlternateName
	}
	if nq.BingID != nil {
		objectMap["bingId"] = nq.BingID
	}
	if nq.ReadLink != nil {
		objectMap["readLink"] = nq.ReadLink
	}
	if nq.WebSearchURL != nil {
		objectMap["webSearchUrl"] = nq.WebSearchURL
	}
	if nq.ID != nil {
		objectMap["id"] = nq.ID
	}
	if nq.Type != "" {
		objectMap["_type"] = nq.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return &nq, true
}

// AsImageAction is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsBasicResponse() (BasicResponse, bool) {
	return &nq, true
}

// AsIdentifiable is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &nq, true
}

// AsErrorResponse is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsBasicThing() (BasicThing, bool) {
	return &nq, true
}

// AsAction is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsBasicIntangible() (BasicIntangible, bool) {
	return &nq, true
}

// AsImageEntityAction is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return &nq, true
}

// AsResponseBase is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for NormalizedQuadrilateral.
func (nq NormalizedQuadrilateral) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &nq, true
}

// BasicOffer defines a merchant's offer.
type BasicOffer interface {
	AsAggregateOffer() (*AggregateOffer, bool)
	AsOffer() (*Offer, bool)
}

// Offer defines a merchant's offer.
type Offer struct {
	// Seller - Seller for this offer.
	Seller *Organization `json:"seller,omitempty"`
	// Price - The item's price.
	Price *float64 `json:"price,omitempty"`
	// PriceCurrency - The monetary currency. For example, USD. Possible values include: 'USD', 'CAD', 'GBP', 'EUR', 'COP', 'JPY', 'CNY', 'AUD', 'INR', 'AED', 'AFN', 'ALL', 'AMD', 'ANG', 'AOA', 'ARS', 'AWG', 'AZN', 'BAM', 'BBD', 'BDT', 'BGN', 'BHD', 'BIF', 'BMD', 'BND', 'BOB', 'BOV', 'BRL', 'BSD', 'BTN', 'BWP', 'BYR', 'BZD', 'CDF', 'CHE', 'CHF', 'CHW', 'CLF', 'CLP', 'COU', 'CRC', 'CUC', 'CUP', 'CVE', 'CZK', 'DJF', 'DKK', 'DOP', 'DZD', 'EGP', 'ERN', 'ETB', 'FJD', 'FKP', 'GEL', 'GHS', 'GIP', 'GMD', 'GNF', 'GTQ', 'GYD', 'HKD', 'HNL', 'HRK', 'HTG', 'HUF', 'IDR', 'ILS', 'IQD', 'IRR', 'ISK', 'JMD', 'JOD', 'KES', 'KGS', 'KHR', 'KMF', 'KPW', 'KRW', 'KWD', 'KYD', 'KZT', 'LAK', 'LBP', 'LKR', 'LRD', 'LSL', 'LYD', 'MAD', 'MDL', 'MGA', 'MKD', 'MMK', 'MNT', 'MOP', 'MRO', 'MUR', 'MVR', 'MWK', 'MXN', 'MXV', 'MYR', 'MZN', 'NAD', 'NGN', 'NIO', 'NOK', 'NPR', 'NZD', 'OMR', 'PAB', 'PEN', 'PGK', 'PHP', 'PKR', 'PLN', 'PYG', 'QAR', 'RON', 'RSD', 'RUB', 'RWF', 'SAR', 'SBD', 'SCR', 'SDG', 'SEK', 'SGD', 'SHP', 'SLL', 'SOS', 'SRD', 'SSP', 'STD', 'SYP', 'SZL', 'THB', 'TJS', 'TMT', 'TND', 'TOP', 'TRY', 'TTD', 'TWD', 'TZS', 'UAH', 'UGX', 'UYU', 'UZS', 'VEF', 'VND', 'VUV', 'WST', 'XAF', 'XCD', 'XOF', 'XPF', 'YER', 'ZAR', 'ZMW'
	PriceCurrency Currency `json:"priceCurrency,omitempty"`
	// Availability - The item's availability. The following are the possible values: Discontinued, InStock, InStoreOnly, LimitedAvailability, OnlineOnly, OutOfStock, PreOrder, SoldOut. Possible values include: 'Discontinued', 'InStock', 'InStoreOnly', 'LimitedAvailability', 'OnlineOnly', 'OutOfStock', 'PreOrder', 'SoldOut'
	Availability ItemAvailability `json:"availability,omitempty"`
	// AggregateRating - An aggregated rating that indicates how well the product has been rated by others.
	AggregateRating *AggregateRating `json:"aggregateRating,omitempty"`
	// LastUpdated - The last date that the offer was updated. The date is in the form YYYY-MM-DD.
	LastUpdated *string `json:"lastUpdated,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicOffer(body []byte) (BasicOffer, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeAggregateOffer):
		var ao AggregateOffer
		err := json.Unmarshal(body, &ao)
		return ao, err
	default:
		var o Offer
		err := json.Unmarshal(body, &o)
		return o, err
	}
}
func unmarshalBasicOfferArray(body []byte) ([]BasicOffer, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	oArray := make([]BasicOffer, len(rawMessages))

	for index, rawMessage := range rawMessages {
		o, err := unmarshalBasicOffer(*rawMessage)
		if err != nil {
			return nil, err
		}
		oArray[index] = o
	}
	return oArray, nil
}

// MarshalJSON is the custom marshaler for Offer.
func (o Offer) MarshalJSON() ([]byte, error) {
	o.Type = TypeOffer
	objectMap := make(map[string]interface{})
	if o.Seller != nil {
		objectMap["seller"] = o.Seller
	}
	if o.Price != nil {
		objectMap["price"] = o.Price
	}
	if o.PriceCurrency != "" {
		objectMap["priceCurrency"] = o.PriceCurrency
	}
	if o.Availability != "" {
		objectMap["availability"] = o.Availability
	}
	if o.AggregateRating != nil {
		objectMap["aggregateRating"] = o.AggregateRating
	}
	if o.LastUpdated != nil {
		objectMap["lastUpdated"] = o.LastUpdated
	}
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.URL != nil {
		objectMap["url"] = o.URL
	}
	if o.Image != nil {
		objectMap["image"] = o.Image
	}
	if o.Description != nil {
		objectMap["description"] = o.Description
	}
	if o.AlternateName != nil {
		objectMap["alternateName"] = o.AlternateName
	}
	if o.BingID != nil {
		objectMap["bingId"] = o.BingID
	}
	if o.ReadLink != nil {
		objectMap["readLink"] = o.ReadLink
	}
	if o.WebSearchURL != nil {
		objectMap["webSearchUrl"] = o.WebSearchURL
	}
	if o.ID != nil {
		objectMap["id"] = o.ID
	}
	if o.Type != "" {
		objectMap["_type"] = o.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for Offer.
func (o Offer) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for Offer.
func (o Offer) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for Offer.
func (o Offer) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for Offer.
func (o Offer) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Offer.
func (o Offer) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Offer.
func (o Offer) AsOffer() (*Offer, bool) {
	return &o, true
}

// AsBasicOffer is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicOffer() (BasicOffer, bool) {
	return &o, true
}

// AsAggregateOffer is the BasicResponseBase implementation for Offer.
func (o Offer) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Offer.
func (o Offer) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for Offer.
func (o Offer) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Offer.
func (o Offer) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicResponse() (BasicResponse, bool) {
	return &o, true
}

// AsIdentifiable is the BasicResponseBase implementation for Offer.
func (o Offer) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &o, true
}

// AsErrorResponse is the BasicResponseBase implementation for Offer.
func (o Offer) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Offer.
func (o Offer) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicThing() (BasicThing, bool) {
	return &o, true
}

// AsAction is the BasicResponseBase implementation for Offer.
func (o Offer) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Offer.
func (o Offer) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Offer.
func (o Offer) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Offer.
func (o Offer) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Offer.
func (o Offer) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for Offer.
func (o Offer) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for Offer.
func (o Offer) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Offer.
func (o Offer) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for Offer.
func (o Offer) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for Offer.
func (o Offer) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for Offer.
func (o Offer) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Offer.
func (o Offer) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Offer.
func (o Offer) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Offer.
func (o Offer) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &o, true
}

// Organization defines an organization.
type Organization struct {
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for Organization.
func (o Organization) MarshalJSON() ([]byte, error) {
	o.Type = TypeOrganization
	objectMap := make(map[string]interface{})
	if o.Name != nil {
		objectMap["name"] = o.Name
	}
	if o.URL != nil {
		objectMap["url"] = o.URL
	}
	if o.Image != nil {
		objectMap["image"] = o.Image
	}
	if o.Description != nil {
		objectMap["description"] = o.Description
	}
	if o.AlternateName != nil {
		objectMap["alternateName"] = o.AlternateName
	}
	if o.BingID != nil {
		objectMap["bingId"] = o.BingID
	}
	if o.ReadLink != nil {
		objectMap["readLink"] = o.ReadLink
	}
	if o.WebSearchURL != nil {
		objectMap["webSearchUrl"] = o.WebSearchURL
	}
	if o.ID != nil {
		objectMap["id"] = o.ID
	}
	if o.Type != "" {
		objectMap["_type"] = o.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for Organization.
func (o Organization) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for Organization.
func (o Organization) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for Organization.
func (o Organization) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for Organization.
func (o Organization) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Organization.
func (o Organization) AsOrganization() (*Organization, bool) {
	return &o, true
}

// AsOffer is the BasicResponseBase implementation for Organization.
func (o Organization) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Organization.
func (o Organization) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Organization.
func (o Organization) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for Organization.
func (o Organization) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Organization.
func (o Organization) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicResponse() (BasicResponse, bool) {
	return &o, true
}

// AsIdentifiable is the BasicResponseBase implementation for Organization.
func (o Organization) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &o, true
}

// AsErrorResponse is the BasicResponseBase implementation for Organization.
func (o Organization) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Organization.
func (o Organization) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicThing() (BasicThing, bool) {
	return &o, true
}

// AsAction is the BasicResponseBase implementation for Organization.
func (o Organization) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Organization.
func (o Organization) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Organization.
func (o Organization) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Organization.
func (o Organization) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Organization.
func (o Organization) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for Organization.
func (o Organization) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for Organization.
func (o Organization) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Organization.
func (o Organization) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for Organization.
func (o Organization) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for Organization.
func (o Organization) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for Organization.
func (o Organization) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Organization.
func (o Organization) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Organization.
func (o Organization) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Organization.
func (o Organization) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &o, true
}

// Person defines a person.
type Person struct {
	// JobTitle - The person's job title.
	JobTitle *string `json:"jobTitle,omitempty"`
	// TwitterProfile - The URL of the person's twitter profile.
	TwitterProfile *string `json:"twitterProfile,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for Person.
func (p Person) MarshalJSON() ([]byte, error) {
	p.Type = TypePerson
	objectMap := make(map[string]interface{})
	if p.JobTitle != nil {
		objectMap["jobTitle"] = p.JobTitle
	}
	if p.TwitterProfile != nil {
		objectMap["twitterProfile"] = p.TwitterProfile
	}
	if p.Name != nil {
		objectMap["name"] = p.Name
	}
	if p.URL != nil {
		objectMap["url"] = p.URL
	}
	if p.Image != nil {
		objectMap["image"] = p.Image
	}
	if p.Description != nil {
		objectMap["description"] = p.Description
	}
	if p.AlternateName != nil {
		objectMap["alternateName"] = p.AlternateName
	}
	if p.BingID != nil {
		objectMap["bingId"] = p.BingID
	}
	if p.ReadLink != nil {
		objectMap["readLink"] = p.ReadLink
	}
	if p.WebSearchURL != nil {
		objectMap["webSearchUrl"] = p.WebSearchURL
	}
	if p.ID != nil {
		objectMap["id"] = p.ID
	}
	if p.Type != "" {
		objectMap["_type"] = p.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for Person.
func (p Person) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for Person.
func (p Person) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for Person.
func (p Person) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for Person.
func (p Person) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for Person.
func (p Person) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Person.
func (p Person) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Person.
func (p Person) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Person.
func (p Person) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Person.
func (p Person) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Person.
func (p Person) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for Person.
func (p Person) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Person.
func (p Person) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Person.
func (p Person) AsBasicResponse() (BasicResponse, bool) {
	return &p, true
}

// AsIdentifiable is the BasicResponseBase implementation for Person.
func (p Person) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Person.
func (p Person) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &p, true
}

// AsErrorResponse is the BasicResponseBase implementation for Person.
func (p Person) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Person.
func (p Person) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Person.
func (p Person) AsBasicThing() (BasicThing, bool) {
	return &p, true
}

// AsAction is the BasicResponseBase implementation for Person.
func (p Person) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Person.
func (p Person) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Person.
func (p Person) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Person.
func (p Person) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Person.
func (p Person) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Person.
func (p Person) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Person.
func (p Person) AsPerson() (*Person, bool) {
	return &p, true
}

// AsIntangible is the BasicResponseBase implementation for Person.
func (p Person) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Person.
func (p Person) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for Person.
func (p Person) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for Person.
func (p Person) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Person.
func (p Person) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for Person.
func (p Person) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for Person.
func (p Person) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for Person.
func (p Person) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Person.
func (p Person) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Person.
func (p Person) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Person.
func (p Person) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Person.
func (p Person) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &p, true
}

// Point2D defines a 2D point with X and Y coordinates.
type Point2D struct {
	// X - The x-coordinate of the point.
	X *float64 `json:"x,omitempty"`
	// Y - The y-coordinate of the point.
	Y *float64 `json:"y,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for Point2D.
func (p2 Point2D) MarshalJSON() ([]byte, error) {
	p2.Type = TypePoint2D
	objectMap := make(map[string]interface{})
	if p2.X != nil {
		objectMap["x"] = p2.X
	}
	if p2.Y != nil {
		objectMap["y"] = p2.Y
	}
	if p2.Name != nil {
		objectMap["name"] = p2.Name
	}
	if p2.URL != nil {
		objectMap["url"] = p2.URL
	}
	if p2.Image != nil {
		objectMap["image"] = p2.Image
	}
	if p2.Description != nil {
		objectMap["description"] = p2.Description
	}
	if p2.AlternateName != nil {
		objectMap["alternateName"] = p2.AlternateName
	}
	if p2.BingID != nil {
		objectMap["bingId"] = p2.BingID
	}
	if p2.ReadLink != nil {
		objectMap["readLink"] = p2.ReadLink
	}
	if p2.WebSearchURL != nil {
		objectMap["webSearchUrl"] = p2.WebSearchURL
	}
	if p2.ID != nil {
		objectMap["id"] = p2.ID
	}
	if p2.Type != "" {
		objectMap["_type"] = p2.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsPoint2D() (*Point2D, bool) {
	return &p2, true
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsBasicResponse() (BasicResponse, bool) {
	return &p2, true
}

// AsIdentifiable is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &p2, true
}

// AsErrorResponse is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsBasicThing() (BasicThing, bool) {
	return &p2, true
}

// AsAction is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsBasicIntangible() (BasicIntangible, bool) {
	return &p2, true
}

// AsImageEntityAction is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return &p2, true
}

// AsResponseBase is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Point2D.
func (p2 Point2D) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &p2, true
}

// BasicPropertiesItem defines an item.
type BasicPropertiesItem interface {
	AsAggregateRating() (*AggregateRating, bool)
	AsRating() (*Rating, bool)
	AsBasicRating() (BasicRating, bool)
	AsPropertiesItem() (*PropertiesItem, bool)
}

// PropertiesItem defines an item.
type PropertiesItem struct {
	// Text - Text representation of an item.
	Text *string `json:"text,omitempty"`
	// Type - Possible values include: 'TypePropertiesItem', 'TypeAggregateRating', 'TypeRating'
	Type TypeBasicPropertiesItem `json:"_type,omitempty"`
}

func unmarshalBasicPropertiesItem(body []byte) (BasicPropertiesItem, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeAggregateRating):
		var ar AggregateRating
		err := json.Unmarshal(body, &ar)
		return ar, err
	case string(TypeRating):
		var r Rating
		err := json.Unmarshal(body, &r)
		return r, err
	default:
		var pi PropertiesItem
		err := json.Unmarshal(body, &pi)
		return pi, err
	}
}
func unmarshalBasicPropertiesItemArray(body []byte) ([]BasicPropertiesItem, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	piArray := make([]BasicPropertiesItem, len(rawMessages))

	for index, rawMessage := range rawMessages {
		pi, err := unmarshalBasicPropertiesItem(*rawMessage)
		if err != nil {
			return nil, err
		}
		piArray[index] = pi
	}
	return piArray, nil
}

// MarshalJSON is the custom marshaler for PropertiesItem.
func (pi PropertiesItem) MarshalJSON() ([]byte, error) {
	pi.Type = TypePropertiesItem
	objectMap := make(map[string]interface{})
	if pi.Text != nil {
		objectMap["text"] = pi.Text
	}
	if pi.Type != "" {
		objectMap["_type"] = pi.Type
	}
	return json.Marshal(objectMap)
}

// AsAggregateRating is the BasicPropertiesItem implementation for PropertiesItem.
func (pi PropertiesItem) AsAggregateRating() (*AggregateRating, bool) {
	return nil, false
}

// AsRating is the BasicPropertiesItem implementation for PropertiesItem.
func (pi PropertiesItem) AsRating() (*Rating, bool) {
	return nil, false
}

// AsBasicRating is the BasicPropertiesItem implementation for PropertiesItem.
func (pi PropertiesItem) AsBasicRating() (BasicRating, bool) {
	return nil, false
}

// AsPropertiesItem is the BasicPropertiesItem implementation for PropertiesItem.
func (pi PropertiesItem) AsPropertiesItem() (*PropertiesItem, bool) {
	return &pi, true
}

// AsBasicPropertiesItem is the BasicPropertiesItem implementation for PropertiesItem.
func (pi PropertiesItem) AsBasicPropertiesItem() (BasicPropertiesItem, bool) {
	return &pi, true
}

// Query defines a search query.
type Query struct {
	// Text - The query string. Use this string as the query term in a new search request.
	Text *string `json:"text,omitempty"`
	// DisplayText - The display version of the query term.
	DisplayText *string `json:"displayText,omitempty"`
	// WebSearchURL - The URL that takes the user to the Bing search results page for the query.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// SearchLink - The URL that you use to get the results of the related search. Before using the URL, you must append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header. Use this URL if you're displaying the results in your own user interface. Otherwise, use the webSearchUrl URL.
	SearchLink *string `json:"searchLink,omitempty"`
	// Thumbnail - The URL to a thumbnail of a related image.
	Thumbnail *ImageObject `json:"thumbnail,omitempty"`
}

// BasicRating defines a rating.
type BasicRating interface {
	AsAggregateRating() (*AggregateRating, bool)
	AsRating() (*Rating, bool)
}

// Rating defines a rating.
type Rating struct {
	// RatingValue - The mean (average) rating. The possible values are 1.0 through 5.0.
	RatingValue *float64 `json:"ratingValue,omitempty"`
	// BestRating - The highest rated review. The possible values are 1.0 through 5.0.
	BestRating *float64 `json:"bestRating,omitempty"`
	// Text - Text representation of an item.
	Text *string `json:"text,omitempty"`
	// Type - Possible values include: 'TypePropertiesItem', 'TypeAggregateRating', 'TypeRating'
	Type TypeBasicPropertiesItem `json:"_type,omitempty"`
}

func unmarshalBasicRating(body []byte) (BasicRating, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypeAggregateRating):
		var ar AggregateRating
		err := json.Unmarshal(body, &ar)
		return ar, err
	default:
		var r Rating
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicRatingArray(body []byte) ([]BasicRating, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicRating, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicRating(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Rating.
func (r Rating) MarshalJSON() ([]byte, error) {
	r.Type = TypeRating
	objectMap := make(map[string]interface{})
	if r.RatingValue != nil {
		objectMap["ratingValue"] = r.RatingValue
	}
	if r.BestRating != nil {
		objectMap["bestRating"] = r.BestRating
	}
	if r.Text != nil {
		objectMap["text"] = r.Text
	}
	if r.Type != "" {
		objectMap["_type"] = r.Type
	}
	return json.Marshal(objectMap)
}

// AsAggregateRating is the BasicPropertiesItem implementation for Rating.
func (r Rating) AsAggregateRating() (*AggregateRating, bool) {
	return nil, false
}

// AsRating is the BasicPropertiesItem implementation for Rating.
func (r Rating) AsRating() (*Rating, bool) {
	return &r, true
}

// AsBasicRating is the BasicPropertiesItem implementation for Rating.
func (r Rating) AsBasicRating() (BasicRating, bool) {
	return &r, true
}

// AsPropertiesItem is the BasicPropertiesItem implementation for Rating.
func (r Rating) AsPropertiesItem() (*PropertiesItem, bool) {
	return nil, false
}

// AsBasicPropertiesItem is the BasicPropertiesItem implementation for Rating.
func (r Rating) AsBasicPropertiesItem() (BasicPropertiesItem, bool) {
	return &r, true
}

// Recipe defines a cooking recipe.
type Recipe struct {
	// CookTime - The amount of time the food takes to cook. For example, PT25M. For information about the time format, see http://en.wikipedia.org/wiki/ISO_8601#Durations.
	CookTime *string `json:"cookTime,omitempty"`
	// PrepTime - The amount of time required to prepare the ingredients. For example, PT15M. For information about the time format, see http://en.wikipedia.org/wiki/ISO_8601#Durations.
	PrepTime *string `json:"prepTime,omitempty"`
	// TotalTime - The total amount of time it takes to prepare and cook the recipe. For example, PT45M. For information about the time format, see http://en.wikipedia.org/wiki/ISO_8601#Durations.
	TotalTime *string `json:"totalTime,omitempty"`
	// ThumbnailURL - The URL to a thumbnail of the item.
	ThumbnailURL *string `json:"thumbnailUrl,omitempty"`
	// Provider - The source of the creative work.
	Provider *[]BasicThing `json:"provider,omitempty"`
	// DatePublished - The date on which the CreativeWork was published.
	DatePublished *string `json:"datePublished,omitempty"`
	// Text - Text content of this creative work.
	Text *string `json:"text,omitempty"`
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

// MarshalJSON is the custom marshaler for Recipe.
func (r Recipe) MarshalJSON() ([]byte, error) {
	r.Type = TypeRecipe
	objectMap := make(map[string]interface{})
	if r.CookTime != nil {
		objectMap["cookTime"] = r.CookTime
	}
	if r.PrepTime != nil {
		objectMap["prepTime"] = r.PrepTime
	}
	if r.TotalTime != nil {
		objectMap["totalTime"] = r.TotalTime
	}
	if r.ThumbnailURL != nil {
		objectMap["thumbnailUrl"] = r.ThumbnailURL
	}
	if r.Provider != nil {
		objectMap["provider"] = r.Provider
	}
	if r.DatePublished != nil {
		objectMap["datePublished"] = r.DatePublished
	}
	if r.Text != nil {
		objectMap["text"] = r.Text
	}
	if r.Name != nil {
		objectMap["name"] = r.Name
	}
	if r.URL != nil {
		objectMap["url"] = r.URL
	}
	if r.Image != nil {
		objectMap["image"] = r.Image
	}
	if r.Description != nil {
		objectMap["description"] = r.Description
	}
	if r.AlternateName != nil {
		objectMap["alternateName"] = r.AlternateName
	}
	if r.BingID != nil {
		objectMap["bingId"] = r.BingID
	}
	if r.ReadLink != nil {
		objectMap["readLink"] = r.ReadLink
	}
	if r.WebSearchURL != nil {
		objectMap["webSearchUrl"] = r.WebSearchURL
	}
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Type != "" {
		objectMap["_type"] = r.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicResponse() (BasicResponse, bool) {
	return &r, true
}

// AsIdentifiable is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &r, true
}

// AsErrorResponse is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicThing() (BasicThing, bool) {
	return &r, true
}

// AsAction is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return &r, true
}

// AsPerson is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsRecipe() (*Recipe, bool) {
	return &r, true
}

// AsImageRecipesAction is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Recipe.
func (r Recipe) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &r, true
}

// UnmarshalJSON is the custom unmarshaler for Recipe struct.
func (r *Recipe) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "cookTime":
			if v != nil {
				var cookTime string
				err = json.Unmarshal(*v, &cookTime)
				if err != nil {
					return err
				}
				r.CookTime = &cookTime
			}
		case "prepTime":
			if v != nil {
				var prepTime string
				err = json.Unmarshal(*v, &prepTime)
				if err != nil {
					return err
				}
				r.PrepTime = &prepTime
			}
		case "totalTime":
			if v != nil {
				var totalTime string
				err = json.Unmarshal(*v, &totalTime)
				if err != nil {
					return err
				}
				r.TotalTime = &totalTime
			}
		case "thumbnailUrl":
			if v != nil {
				var thumbnailURL string
				err = json.Unmarshal(*v, &thumbnailURL)
				if err != nil {
					return err
				}
				r.ThumbnailURL = &thumbnailURL
			}
		case "provider":
			if v != nil {
				provider, err := unmarshalBasicThingArray(*v)
				if err != nil {
					return err
				}
				r.Provider = &provider
			}
		case "datePublished":
			if v != nil {
				var datePublished string
				err = json.Unmarshal(*v, &datePublished)
				if err != nil {
					return err
				}
				r.DatePublished = &datePublished
			}
		case "text":
			if v != nil {
				var textVar string
				err = json.Unmarshal(*v, &textVar)
				if err != nil {
					return err
				}
				r.Text = &textVar
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				r.Name = &name
			}
		case "url":
			if v != nil {
				var URL string
				err = json.Unmarshal(*v, &URL)
				if err != nil {
					return err
				}
				r.URL = &URL
			}
		case "image":
			if v != nil {
				var imageVar ImageObject
				err = json.Unmarshal(*v, &imageVar)
				if err != nil {
					return err
				}
				r.Image = &imageVar
			}
		case "description":
			if v != nil {
				var description string
				err = json.Unmarshal(*v, &description)
				if err != nil {
					return err
				}
				r.Description = &description
			}
		case "alternateName":
			if v != nil {
				var alternateName string
				err = json.Unmarshal(*v, &alternateName)
				if err != nil {
					return err
				}
				r.AlternateName = &alternateName
			}
		case "bingId":
			if v != nil {
				var bingID string
				err = json.Unmarshal(*v, &bingID)
				if err != nil {
					return err
				}
				r.BingID = &bingID
			}
		case "readLink":
			if v != nil {
				var readLink string
				err = json.Unmarshal(*v, &readLink)
				if err != nil {
					return err
				}
				r.ReadLink = &readLink
			}
		case "webSearchUrl":
			if v != nil {
				var webSearchURL string
				err = json.Unmarshal(*v, &webSearchURL)
				if err != nil {
					return err
				}
				r.WebSearchURL = &webSearchURL
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				r.ID = &ID
			}
		case "_type":
			if v != nil {
				var typeVar Type
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				r.Type = typeVar
			}
		}
	}

	return nil
}

// RecipesModule defines a list of recipes.
type RecipesModule struct {
	// Value - A list of recipes.
	Value *[]Recipe `json:"value,omitempty"`
}

// RelatedSearchesModule defines a list of related searches.
type RelatedSearchesModule struct {
	// Value - A list of related searches.
	Value *[]Query `json:"value,omitempty"`
}

// Request a JSON object that contains information about the image to get insights of. Specify this object only in
// a knowledgeRequest form data.
type Request struct {
	// ImageInfo - A JSON object that identities the image to get insights of.
	ImageInfo *ImageInfo `json:"imageInfo,omitempty"`
	// KnowledgeRequest - A JSON object containing information about the request, such as filters, or a description.
	KnowledgeRequest *KnowledgeRequest `json:"knowledgeRequest,omitempty"`
}

// BasicResponse defines a response. All schemas that return at the root of the response must inherit from this object.
type BasicResponse interface {
	AsPoint2D() (*Point2D, bool)
	AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool)
	AsImageAction() (*ImageAction, bool)
	AsBasicImageAction() (BasicImageAction, bool)
	AsImageTag() (*ImageTag, bool)
	AsOrganization() (*Organization, bool)
	AsOffer() (*Offer, bool)
	AsBasicOffer() (BasicOffer, bool)
	AsAggregateOffer() (*AggregateOffer, bool)
	AsImageObject() (*ImageObject, bool)
	AsImageKnowledge() (*ImageKnowledge, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsAction() (*Action, bool)
	AsBasicAction() (BasicAction, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsPerson() (*Person, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsImageEntityAction() (*ImageEntityAction, bool)
	AsImageModuleAction() (*ImageModuleAction, bool)
	AsRecipe() (*Recipe, bool)
	AsImageRecipesAction() (*ImageRecipesAction, bool)
	AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool)
	AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsResponse() (*Response, bool)
}

// Response defines a response. All schemas that return at the root of the response must inherit from this object.
type Response struct {
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicResponse(body []byte) (BasicResponse, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypePoint2D):
		var p2 Point2D
		err := json.Unmarshal(body, &p2)
		return p2, err
	case string(TypeNormalizedQuadrilateral):
		var nq NormalizedQuadrilateral
		err := json.Unmarshal(body, &nq)
		return nq, err
	case string(TypeImageAction):
		var ia ImageAction
		err := json.Unmarshal(body, &ia)
		return ia, err
	case string(TypeImageTag):
		var it ImageTag
		err := json.Unmarshal(body, &it)
		return it, err
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeOffer):
		var o Offer
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeAggregateOffer):
		var ao AggregateOffer
		err := json.Unmarshal(body, &ao)
		return ao, err
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeImageKnowledge):
		var ik ImageKnowledge
		err := json.Unmarshal(body, &ik)
		return ik, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeAction):
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypePerson):
		var p Person
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeImageEntityAction):
		var iea ImageEntityAction
		err := json.Unmarshal(body, &iea)
		return iea, err
	case string(TypeImageModuleAction):
		var ima ImageModuleAction
		err := json.Unmarshal(body, &ima)
		return ima, err
	case string(TypeRecipe):
		var r Recipe
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeImageRecipesAction):
		var ira ImageRecipesAction
		err := json.Unmarshal(body, &ira)
		return ira, err
	case string(TypeImageRelatedSearchesAction):
		var irsa ImageRelatedSearchesAction
		err := json.Unmarshal(body, &irsa)
		return irsa, err
	case string(TypeImageShoppingSourcesAction):
		var issa ImageShoppingSourcesAction
		err := json.Unmarshal(body, &issa)
		return issa, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	}
}
func unmarshalBasicResponseArray(body []byte) ([]BasicResponse, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rArray := make([]BasicResponse, len(rawMessages))

	for index, rawMessage := range rawMessages {
		r, err := unmarshalBasicResponse(*rawMessage)
		if err != nil {
			return nil, err
		}
		rArray[index] = r
	}
	return rArray, nil
}

// MarshalJSON is the custom marshaler for Response.
func (r Response) MarshalJSON() ([]byte, error) {
	r.Type = TypeResponse
	objectMap := make(map[string]interface{})
	if r.ReadLink != nil {
		objectMap["readLink"] = r.ReadLink
	}
	if r.WebSearchURL != nil {
		objectMap["webSearchUrl"] = r.WebSearchURL
	}
	if r.ID != nil {
		objectMap["id"] = r.ID
	}
	if r.Type != "" {
		objectMap["_type"] = r.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for Response.
func (r Response) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for Response.
func (r Response) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for Response.
func (r Response) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for Response.
func (r Response) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for Response.
func (r Response) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Response.
func (r Response) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Response.
func (r Response) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Response.
func (r Response) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Response.
func (r Response) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Response.
func (r Response) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for Response.
func (r Response) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Response.
func (r Response) AsResponse() (*Response, bool) {
	return &r, true
}

// AsBasicResponse is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponse() (BasicResponse, bool) {
	return &r, true
}

// AsIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &r, true
}

// AsErrorResponse is the BasicResponseBase implementation for Response.
func (r Response) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Response.
func (r Response) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for Response.
func (r Response) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for Response.
func (r Response) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Response.
func (r Response) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Response.
func (r Response) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Response.
func (r Response) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Response.
func (r Response) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Response.
func (r Response) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Response.
func (r Response) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for Response.
func (r Response) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for Response.
func (r Response) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Response.
func (r Response) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for Response.
func (r Response) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for Response.
func (r Response) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for Response.
func (r Response) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Response.
func (r Response) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Response.
func (r Response) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Response.
func (r Response) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &r, true
}

// BasicResponseBase response base.
type BasicResponseBase interface {
	AsPoint2D() (*Point2D, bool)
	AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool)
	AsImageAction() (*ImageAction, bool)
	AsBasicImageAction() (BasicImageAction, bool)
	AsImageTag() (*ImageTag, bool)
	AsOrganization() (*Organization, bool)
	AsOffer() (*Offer, bool)
	AsBasicOffer() (BasicOffer, bool)
	AsAggregateOffer() (*AggregateOffer, bool)
	AsImageObject() (*ImageObject, bool)
	AsImageKnowledge() (*ImageKnowledge, bool)
	AsResponse() (*Response, bool)
	AsBasicResponse() (BasicResponse, bool)
	AsIdentifiable() (*Identifiable, bool)
	AsBasicIdentifiable() (BasicIdentifiable, bool)
	AsErrorResponse() (*ErrorResponse, bool)
	AsThing() (*Thing, bool)
	AsBasicThing() (BasicThing, bool)
	AsAction() (*Action, bool)
	AsBasicAction() (BasicAction, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsPerson() (*Person, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsImageEntityAction() (*ImageEntityAction, bool)
	AsImageModuleAction() (*ImageModuleAction, bool)
	AsRecipe() (*Recipe, bool)
	AsImageRecipesAction() (*ImageRecipesAction, bool)
	AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool)
	AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsResponseBase() (*ResponseBase, bool)
}

// ResponseBase response base.
type ResponseBase struct {
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicResponseBase(body []byte) (BasicResponseBase, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypePoint2D):
		var p2 Point2D
		err := json.Unmarshal(body, &p2)
		return p2, err
	case string(TypeNormalizedQuadrilateral):
		var nq NormalizedQuadrilateral
		err := json.Unmarshal(body, &nq)
		return nq, err
	case string(TypeImageAction):
		var ia ImageAction
		err := json.Unmarshal(body, &ia)
		return ia, err
	case string(TypeImageTag):
		var it ImageTag
		err := json.Unmarshal(body, &it)
		return it, err
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeOffer):
		var o Offer
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeAggregateOffer):
		var ao AggregateOffer
		err := json.Unmarshal(body, &ao)
		return ao, err
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeImageKnowledge):
		var ik ImageKnowledge
		err := json.Unmarshal(body, &ik)
		return ik, err
	case string(TypeResponse):
		var r Response
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeIdentifiable):
		var i Identifiable
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeErrorResponse):
		var er ErrorResponse
		err := json.Unmarshal(body, &er)
		return er, err
	case string(TypeThing):
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	case string(TypeAction):
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypePerson):
		var p Person
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeImageEntityAction):
		var iea ImageEntityAction
		err := json.Unmarshal(body, &iea)
		return iea, err
	case string(TypeImageModuleAction):
		var ima ImageModuleAction
		err := json.Unmarshal(body, &ima)
		return ima, err
	case string(TypeRecipe):
		var r Recipe
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeImageRecipesAction):
		var ira ImageRecipesAction
		err := json.Unmarshal(body, &ira)
		return ira, err
	case string(TypeImageRelatedSearchesAction):
		var irsa ImageRelatedSearchesAction
		err := json.Unmarshal(body, &irsa)
		return irsa, err
	case string(TypeImageShoppingSourcesAction):
		var issa ImageShoppingSourcesAction
		err := json.Unmarshal(body, &issa)
		return issa, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var rb ResponseBase
		err := json.Unmarshal(body, &rb)
		return rb, err
	}
}
func unmarshalBasicResponseBaseArray(body []byte) ([]BasicResponseBase, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	rbArray := make([]BasicResponseBase, len(rawMessages))

	for index, rawMessage := range rawMessages {
		rb, err := unmarshalBasicResponseBase(*rawMessage)
		if err != nil {
			return nil, err
		}
		rbArray[index] = rb
	}
	return rbArray, nil
}

// MarshalJSON is the custom marshaler for ResponseBase.
func (rb ResponseBase) MarshalJSON() ([]byte, error) {
	rb.Type = TypeResponseBase
	objectMap := make(map[string]interface{})
	if rb.Type != "" {
		objectMap["_type"] = rb.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponse() (BasicResponse, bool) {
	return nil, false
}

// AsIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return nil, false
}

// AsErrorResponse is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicThing() (BasicThing, bool) {
	return nil, false
}

// AsAction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsResponseBase() (*ResponseBase, bool) {
	return &rb, true
}

// AsBasicResponseBase is the BasicResponseBase implementation for ResponseBase.
func (rb ResponseBase) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &rb, true
}

// BasicStructuredValue ...
type BasicStructuredValue interface {
	AsPoint2D() (*Point2D, bool)
	AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool)
	AsStructuredValue() (*StructuredValue, bool)
}

// StructuredValue ...
type StructuredValue struct {
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicStructuredValue(body []byte) (BasicStructuredValue, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypePoint2D):
		var p2 Point2D
		err := json.Unmarshal(body, &p2)
		return p2, err
	case string(TypeNormalizedQuadrilateral):
		var nq NormalizedQuadrilateral
		err := json.Unmarshal(body, &nq)
		return nq, err
	default:
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	}
}
func unmarshalBasicStructuredValueArray(body []byte) ([]BasicStructuredValue, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	svArray := make([]BasicStructuredValue, len(rawMessages))

	for index, rawMessage := range rawMessages {
		sv, err := unmarshalBasicStructuredValue(*rawMessage)
		if err != nil {
			return nil, err
		}
		svArray[index] = sv
	}
	return svArray, nil
}

// MarshalJSON is the custom marshaler for StructuredValue.
func (sv StructuredValue) MarshalJSON() ([]byte, error) {
	sv.Type = TypeStructuredValue
	objectMap := make(map[string]interface{})
	if sv.Name != nil {
		objectMap["name"] = sv.Name
	}
	if sv.URL != nil {
		objectMap["url"] = sv.URL
	}
	if sv.Image != nil {
		objectMap["image"] = sv.Image
	}
	if sv.Description != nil {
		objectMap["description"] = sv.Description
	}
	if sv.AlternateName != nil {
		objectMap["alternateName"] = sv.AlternateName
	}
	if sv.BingID != nil {
		objectMap["bingId"] = sv.BingID
	}
	if sv.ReadLink != nil {
		objectMap["readLink"] = sv.ReadLink
	}
	if sv.WebSearchURL != nil {
		objectMap["webSearchUrl"] = sv.WebSearchURL
	}
	if sv.ID != nil {
		objectMap["id"] = sv.ID
	}
	if sv.Type != "" {
		objectMap["_type"] = sv.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicResponse() (BasicResponse, bool) {
	return &sv, true
}

// AsIdentifiable is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &sv, true
}

// AsErrorResponse is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsThing() (*Thing, bool) {
	return nil, false
}

// AsBasicThing is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicThing() (BasicThing, bool) {
	return &sv, true
}

// AsAction is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicIntangible() (BasicIntangible, bool) {
	return &sv, true
}

// AsImageEntityAction is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsStructuredValue() (*StructuredValue, bool) {
	return &sv, true
}

// AsBasicStructuredValue is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return &sv, true
}

// AsResponseBase is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for StructuredValue.
func (sv StructuredValue) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &sv, true
}

// BasicThing defines a thing.
type BasicThing interface {
	AsPoint2D() (*Point2D, bool)
	AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool)
	AsImageAction() (*ImageAction, bool)
	AsBasicImageAction() (BasicImageAction, bool)
	AsImageTag() (*ImageTag, bool)
	AsOrganization() (*Organization, bool)
	AsOffer() (*Offer, bool)
	AsBasicOffer() (BasicOffer, bool)
	AsAggregateOffer() (*AggregateOffer, bool)
	AsImageObject() (*ImageObject, bool)
	AsAction() (*Action, bool)
	AsBasicAction() (BasicAction, bool)
	AsMediaObject() (*MediaObject, bool)
	AsBasicMediaObject() (BasicMediaObject, bool)
	AsCreativeWork() (*CreativeWork, bool)
	AsBasicCreativeWork() (BasicCreativeWork, bool)
	AsPerson() (*Person, bool)
	AsIntangible() (*Intangible, bool)
	AsBasicIntangible() (BasicIntangible, bool)
	AsImageEntityAction() (*ImageEntityAction, bool)
	AsImageModuleAction() (*ImageModuleAction, bool)
	AsRecipe() (*Recipe, bool)
	AsImageRecipesAction() (*ImageRecipesAction, bool)
	AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool)
	AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool)
	AsStructuredValue() (*StructuredValue, bool)
	AsBasicStructuredValue() (BasicStructuredValue, bool)
	AsThing() (*Thing, bool)
}

// Thing defines a thing.
type Thing struct {
	// Name - The name of the thing represented by this object.
	Name *string `json:"name,omitempty"`
	// URL - The URL to get more information about the thing represented by this object.
	URL *string `json:"url,omitempty"`
	// Image - An image of the item.
	Image *ImageObject `json:"image,omitempty"`
	// Description - A short description of the item.
	Description *string `json:"description,omitempty"`
	// AlternateName - An alias for the item.
	AlternateName *string `json:"alternateName,omitempty"`
	// BingID - An ID that uniquely identifies this item.
	BingID *string `json:"bingId,omitempty"`
	// ReadLink - The URL that returns this resource. To use the URL, append query parameters as appropriate and include the Ocp-Apim-Subscription-Key header.
	ReadLink *string `json:"readLink,omitempty"`
	// WebSearchURL - The URL to Bing's search result for this item.
	WebSearchURL *string `json:"webSearchUrl,omitempty"`
	// ID - A String identifier.
	ID *string `json:"id,omitempty"`
	// Type - Possible values include: 'TypeResponseBase', 'TypePoint2D', 'TypeNormalizedQuadrilateral', 'TypeImageAction', 'TypeImageTag', 'TypeOrganization', 'TypeOffer', 'TypeAggregateOffer', 'TypeImageObject', 'TypeImageKnowledge', 'TypeResponse', 'TypeIdentifiable', 'TypeErrorResponse', 'TypeThing', 'TypeAction', 'TypeMediaObject', 'TypeCreativeWork', 'TypePerson', 'TypeIntangible', 'TypeImageEntityAction', 'TypeImageModuleAction', 'TypeRecipe', 'TypeImageRecipesAction', 'TypeImageRelatedSearchesAction', 'TypeImageShoppingSourcesAction', 'TypeStructuredValue'
	Type Type `json:"_type,omitempty"`
}

func unmarshalBasicThing(body []byte) (BasicThing, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["_type"] {
	case string(TypePoint2D):
		var p2 Point2D
		err := json.Unmarshal(body, &p2)
		return p2, err
	case string(TypeNormalizedQuadrilateral):
		var nq NormalizedQuadrilateral
		err := json.Unmarshal(body, &nq)
		return nq, err
	case string(TypeImageAction):
		var ia ImageAction
		err := json.Unmarshal(body, &ia)
		return ia, err
	case string(TypeImageTag):
		var it ImageTag
		err := json.Unmarshal(body, &it)
		return it, err
	case string(TypeOrganization):
		var o Organization
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeOffer):
		var o Offer
		err := json.Unmarshal(body, &o)
		return o, err
	case string(TypeAggregateOffer):
		var ao AggregateOffer
		err := json.Unmarshal(body, &ao)
		return ao, err
	case string(TypeImageObject):
		var ioVar ImageObject
		err := json.Unmarshal(body, &ioVar)
		return ioVar, err
	case string(TypeAction):
		var a Action
		err := json.Unmarshal(body, &a)
		return a, err
	case string(TypeMediaObject):
		var mo MediaObject
		err := json.Unmarshal(body, &mo)
		return mo, err
	case string(TypeCreativeWork):
		var cw CreativeWork
		err := json.Unmarshal(body, &cw)
		return cw, err
	case string(TypePerson):
		var p Person
		err := json.Unmarshal(body, &p)
		return p, err
	case string(TypeIntangible):
		var i Intangible
		err := json.Unmarshal(body, &i)
		return i, err
	case string(TypeImageEntityAction):
		var iea ImageEntityAction
		err := json.Unmarshal(body, &iea)
		return iea, err
	case string(TypeImageModuleAction):
		var ima ImageModuleAction
		err := json.Unmarshal(body, &ima)
		return ima, err
	case string(TypeRecipe):
		var r Recipe
		err := json.Unmarshal(body, &r)
		return r, err
	case string(TypeImageRecipesAction):
		var ira ImageRecipesAction
		err := json.Unmarshal(body, &ira)
		return ira, err
	case string(TypeImageRelatedSearchesAction):
		var irsa ImageRelatedSearchesAction
		err := json.Unmarshal(body, &irsa)
		return irsa, err
	case string(TypeImageShoppingSourcesAction):
		var issa ImageShoppingSourcesAction
		err := json.Unmarshal(body, &issa)
		return issa, err
	case string(TypeStructuredValue):
		var sv StructuredValue
		err := json.Unmarshal(body, &sv)
		return sv, err
	default:
		var t Thing
		err := json.Unmarshal(body, &t)
		return t, err
	}
}
func unmarshalBasicThingArray(body []byte) ([]BasicThing, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	tArray := make([]BasicThing, len(rawMessages))

	for index, rawMessage := range rawMessages {
		t, err := unmarshalBasicThing(*rawMessage)
		if err != nil {
			return nil, err
		}
		tArray[index] = t
	}
	return tArray, nil
}

// MarshalJSON is the custom marshaler for Thing.
func (t Thing) MarshalJSON() ([]byte, error) {
	t.Type = TypeThing
	objectMap := make(map[string]interface{})
	if t.Name != nil {
		objectMap["name"] = t.Name
	}
	if t.URL != nil {
		objectMap["url"] = t.URL
	}
	if t.Image != nil {
		objectMap["image"] = t.Image
	}
	if t.Description != nil {
		objectMap["description"] = t.Description
	}
	if t.AlternateName != nil {
		objectMap["alternateName"] = t.AlternateName
	}
	if t.BingID != nil {
		objectMap["bingId"] = t.BingID
	}
	if t.ReadLink != nil {
		objectMap["readLink"] = t.ReadLink
	}
	if t.WebSearchURL != nil {
		objectMap["webSearchUrl"] = t.WebSearchURL
	}
	if t.ID != nil {
		objectMap["id"] = t.ID
	}
	if t.Type != "" {
		objectMap["_type"] = t.Type
	}
	return json.Marshal(objectMap)
}

// AsPoint2D is the BasicResponseBase implementation for Thing.
func (t Thing) AsPoint2D() (*Point2D, bool) {
	return nil, false
}

// AsNormalizedQuadrilateral is the BasicResponseBase implementation for Thing.
func (t Thing) AsNormalizedQuadrilateral() (*NormalizedQuadrilateral, bool) {
	return nil, false
}

// AsImageAction is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageAction() (*ImageAction, bool) {
	return nil, false
}

// AsBasicImageAction is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicImageAction() (BasicImageAction, bool) {
	return nil, false
}

// AsImageTag is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageTag() (*ImageTag, bool) {
	return nil, false
}

// AsOrganization is the BasicResponseBase implementation for Thing.
func (t Thing) AsOrganization() (*Organization, bool) {
	return nil, false
}

// AsOffer is the BasicResponseBase implementation for Thing.
func (t Thing) AsOffer() (*Offer, bool) {
	return nil, false
}

// AsBasicOffer is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicOffer() (BasicOffer, bool) {
	return nil, false
}

// AsAggregateOffer is the BasicResponseBase implementation for Thing.
func (t Thing) AsAggregateOffer() (*AggregateOffer, bool) {
	return nil, false
}

// AsImageObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageObject() (*ImageObject, bool) {
	return nil, false
}

// AsImageKnowledge is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageKnowledge() (*ImageKnowledge, bool) {
	return nil, false
}

// AsResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponse() (*Response, bool) {
	return nil, false
}

// AsBasicResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponse() (BasicResponse, bool) {
	return &t, true
}

// AsIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsIdentifiable() (*Identifiable, bool) {
	return nil, false
}

// AsBasicIdentifiable is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIdentifiable() (BasicIdentifiable, bool) {
	return &t, true
}

// AsErrorResponse is the BasicResponseBase implementation for Thing.
func (t Thing) AsErrorResponse() (*ErrorResponse, bool) {
	return nil, false
}

// AsThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsThing() (*Thing, bool) {
	return &t, true
}

// AsBasicThing is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicThing() (BasicThing, bool) {
	return &t, true
}

// AsAction is the BasicResponseBase implementation for Thing.
func (t Thing) AsAction() (*Action, bool) {
	return nil, false
}

// AsBasicAction is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicAction() (BasicAction, bool) {
	return nil, false
}

// AsMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsMediaObject() (*MediaObject, bool) {
	return nil, false
}

// AsBasicMediaObject is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicMediaObject() (BasicMediaObject, bool) {
	return nil, false
}

// AsCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsCreativeWork() (*CreativeWork, bool) {
	return nil, false
}

// AsBasicCreativeWork is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicCreativeWork() (BasicCreativeWork, bool) {
	return nil, false
}

// AsPerson is the BasicResponseBase implementation for Thing.
func (t Thing) AsPerson() (*Person, bool) {
	return nil, false
}

// AsIntangible is the BasicResponseBase implementation for Thing.
func (t Thing) AsIntangible() (*Intangible, bool) {
	return nil, false
}

// AsBasicIntangible is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicIntangible() (BasicIntangible, bool) {
	return nil, false
}

// AsImageEntityAction is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageEntityAction() (*ImageEntityAction, bool) {
	return nil, false
}

// AsImageModuleAction is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageModuleAction() (*ImageModuleAction, bool) {
	return nil, false
}

// AsRecipe is the BasicResponseBase implementation for Thing.
func (t Thing) AsRecipe() (*Recipe, bool) {
	return nil, false
}

// AsImageRecipesAction is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageRecipesAction() (*ImageRecipesAction, bool) {
	return nil, false
}

// AsImageRelatedSearchesAction is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageRelatedSearchesAction() (*ImageRelatedSearchesAction, bool) {
	return nil, false
}

// AsImageShoppingSourcesAction is the BasicResponseBase implementation for Thing.
func (t Thing) AsImageShoppingSourcesAction() (*ImageShoppingSourcesAction, bool) {
	return nil, false
}

// AsStructuredValue is the BasicResponseBase implementation for Thing.
func (t Thing) AsStructuredValue() (*StructuredValue, bool) {
	return nil, false
}

// AsBasicStructuredValue is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicStructuredValue() (BasicStructuredValue, bool) {
	return nil, false
}

// AsResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsResponseBase() (*ResponseBase, bool) {
	return nil, false
}

// AsBasicResponseBase is the BasicResponseBase implementation for Thing.
func (t Thing) AsBasicResponseBase() (BasicResponseBase, bool) {
	return &t, true
}
