// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/appengine/v1/version.proto

package appengine // import "google.golang.org/genproto/googleapis/appengine/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import duration "github.com/golang/protobuf/ptypes/duration"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Available inbound services.
type InboundServiceType int32

const (
	// Not specified.
	InboundServiceType_INBOUND_SERVICE_UNSPECIFIED InboundServiceType = 0
	// Allows an application to receive mail.
	InboundServiceType_INBOUND_SERVICE_MAIL InboundServiceType = 1
	// Allows an application to receive email-bound notifications.
	InboundServiceType_INBOUND_SERVICE_MAIL_BOUNCE InboundServiceType = 2
	// Allows an application to receive error stanzas.
	InboundServiceType_INBOUND_SERVICE_XMPP_ERROR InboundServiceType = 3
	// Allows an application to receive instant messages.
	InboundServiceType_INBOUND_SERVICE_XMPP_MESSAGE InboundServiceType = 4
	// Allows an application to receive user subscription POSTs.
	InboundServiceType_INBOUND_SERVICE_XMPP_SUBSCRIBE InboundServiceType = 5
	// Allows an application to receive a user's chat presence.
	InboundServiceType_INBOUND_SERVICE_XMPP_PRESENCE InboundServiceType = 6
	// Registers an application for notifications when a client connects or
	// disconnects from a channel.
	InboundServiceType_INBOUND_SERVICE_CHANNEL_PRESENCE InboundServiceType = 7
	// Enables warmup requests.
	InboundServiceType_INBOUND_SERVICE_WARMUP InboundServiceType = 9
)

var InboundServiceType_name = map[int32]string{
	0: "INBOUND_SERVICE_UNSPECIFIED",
	1: "INBOUND_SERVICE_MAIL",
	2: "INBOUND_SERVICE_MAIL_BOUNCE",
	3: "INBOUND_SERVICE_XMPP_ERROR",
	4: "INBOUND_SERVICE_XMPP_MESSAGE",
	5: "INBOUND_SERVICE_XMPP_SUBSCRIBE",
	6: "INBOUND_SERVICE_XMPP_PRESENCE",
	7: "INBOUND_SERVICE_CHANNEL_PRESENCE",
	9: "INBOUND_SERVICE_WARMUP",
}
var InboundServiceType_value = map[string]int32{
	"INBOUND_SERVICE_UNSPECIFIED":      0,
	"INBOUND_SERVICE_MAIL":             1,
	"INBOUND_SERVICE_MAIL_BOUNCE":      2,
	"INBOUND_SERVICE_XMPP_ERROR":       3,
	"INBOUND_SERVICE_XMPP_MESSAGE":     4,
	"INBOUND_SERVICE_XMPP_SUBSCRIBE":   5,
	"INBOUND_SERVICE_XMPP_PRESENCE":    6,
	"INBOUND_SERVICE_CHANNEL_PRESENCE": 7,
	"INBOUND_SERVICE_WARMUP":           9,
}

func (x InboundServiceType) String() string {
	return proto.EnumName(InboundServiceType_name, int32(x))
}
func (InboundServiceType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_version_8e5786bd40ede622, []int{0}
}

// Run states of a version.
type ServingStatus int32

const (
	// Not specified.
	ServingStatus_SERVING_STATUS_UNSPECIFIED ServingStatus = 0
	// Currently serving. Instances are created according to the
	// scaling settings of the version.
	ServingStatus_SERVING ServingStatus = 1
	// Disabled. No instances will be created and the scaling
	// settings are ignored until the state of the version changes
	// to `SERVING`.
	ServingStatus_STOPPED ServingStatus = 2
)

var ServingStatus_name = map[int32]string{
	0: "SERVING_STATUS_UNSPECIFIED",
	1: "SERVING",
	2: "STOPPED",
}
var ServingStatus_value = map[string]int32{
	"SERVING_STATUS_UNSPECIFIED": 0,
	"SERVING":                    1,
	"STOPPED":                    2,
}

func (x ServingStatus) String() string {
	return proto.EnumName(ServingStatus_name, int32(x))
}
func (ServingStatus) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_version_8e5786bd40ede622, []int{1}
}

// A Version resource is a specific set of source code and configuration files
// that are deployed into a service.
type Version struct {
	// Full path to the Version resource in the API.  Example:
	// `apps/myapp/services/default/versions/v1`.
	//
	// @OutputOnly
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Relative name of the version within the service.  Example: `v1`.
	// Version names can contain only lowercase letters, numbers, or hyphens.
	// Reserved names: "default", "latest", and any name with the prefix "ah-".
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Controls how instances are created.
	//
	// Defaults to `AutomaticScaling`.
	//
	// Types that are valid to be assigned to Scaling:
	//	*Version_AutomaticScaling
	//	*Version_BasicScaling
	//	*Version_ManualScaling
	Scaling isVersion_Scaling `protobuf_oneof:"scaling"`
	// Before an application can receive email or XMPP messages, the application
	// must be configured to enable the service.
	InboundServices []InboundServiceType `protobuf:"varint,6,rep,packed,name=inbound_services,json=inboundServices,proto3,enum=google.appengine.v1.InboundServiceType" json:"inbound_services,omitempty"`
	// Instance class that is used to run this version. Valid values are:
	// * AutomaticScaling: `F1`, `F2`, `F4`, `F4_1G`
	// * ManualScaling or BasicScaling: `B1`, `B2`, `B4`, `B8`, `B4_1G`
	//
	// Defaults to `F1` for AutomaticScaling and `B1` for ManualScaling or
	// BasicScaling.
	InstanceClass string `protobuf:"bytes,7,opt,name=instance_class,json=instanceClass,proto3" json:"instance_class,omitempty"`
	// Extra network settings. Only applicable for VM runtimes.
	Network *Network `protobuf:"bytes,8,opt,name=network,proto3" json:"network,omitempty"`
	// Machine resources for this version. Only applicable for VM runtimes.
	Resources *Resources `protobuf:"bytes,9,opt,name=resources,proto3" json:"resources,omitempty"`
	// Desired runtime. Example: `python27`.
	Runtime string `protobuf:"bytes,10,opt,name=runtime,proto3" json:"runtime,omitempty"`
	// Whether multiple requests can be dispatched to this version at once.
	Threadsafe bool `protobuf:"varint,11,opt,name=threadsafe,proto3" json:"threadsafe,omitempty"`
	// Whether to deploy this version in a container on a virtual machine.
	Vm bool `protobuf:"varint,12,opt,name=vm,proto3" json:"vm,omitempty"`
	// Metadata settings that are supplied to this version to enable
	// beta runtime features.
	BetaSettings map[string]string `protobuf:"bytes,13,rep,name=beta_settings,json=betaSettings,proto3" json:"beta_settings,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// App Engine execution environment for this version.
	//
	// Defaults to `standard`.
	Env string `protobuf:"bytes,14,opt,name=env,proto3" json:"env,omitempty"`
	// Current serving status of this version. Only the versions with a
	// `SERVING` status create instances and can be billed.
	//
	// `SERVING_STATUS_UNSPECIFIED` is an invalid value. Defaults to `SERVING`.
	ServingStatus ServingStatus `protobuf:"varint,15,opt,name=serving_status,json=servingStatus,proto3,enum=google.appengine.v1.ServingStatus" json:"serving_status,omitempty"`
	// Email address of the user who created this version.
	//
	// @OutputOnly
	CreatedBy string `protobuf:"bytes,16,opt,name=created_by,json=createdBy,proto3" json:"created_by,omitempty"`
	// Time that this version was created.
	//
	// @OutputOnly
	CreateTime *timestamp.Timestamp `protobuf:"bytes,17,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Total size in bytes of all the files that are included in this version
	// and curerntly hosted on the App Engine disk.
	//
	// @OutputOnly
	DiskUsageBytes int64 `protobuf:"varint,18,opt,name=disk_usage_bytes,json=diskUsageBytes,proto3" json:"disk_usage_bytes,omitempty"`
	// An ordered list of URL-matching patterns that should be applied to incoming
	// requests. The first matching URL handles the request and other request
	// handlers are not attempted.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	Handlers []*UrlMap `protobuf:"bytes,100,rep,name=handlers,proto3" json:"handlers,omitempty"`
	// Custom static error pages. Limited to 10KB per page.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	ErrorHandlers []*ErrorHandler `protobuf:"bytes,101,rep,name=error_handlers,json=errorHandlers,proto3" json:"error_handlers,omitempty"`
	// Configuration for third-party Python runtime libraries that are required
	// by the application.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	Libraries []*Library `protobuf:"bytes,102,rep,name=libraries,proto3" json:"libraries,omitempty"`
	// Serving configuration for
	// [Google Cloud
	// Endpoints](https://cloud.google.com/appengine/docs/python/endpoints/).
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	ApiConfig *ApiConfigHandler `protobuf:"bytes,103,opt,name=api_config,json=apiConfig,proto3" json:"api_config,omitempty"`
	// Environment variables available to the application.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	EnvVariables map[string]string `protobuf:"bytes,104,rep,name=env_variables,json=envVariables,proto3" json:"env_variables,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Duration that static files should be cached by web proxies and browsers.
	// Only applicable if the corresponding
	// [StaticFilesHandler](https://cloud.google.com/appengine/docs/admin-api/reference/rest/v1/apps.services.versions#staticfileshandler)
	// does not specify its own expiration time.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	DefaultExpiration *duration.Duration `protobuf:"bytes,105,opt,name=default_expiration,json=defaultExpiration,proto3" json:"default_expiration,omitempty"`
	// Configures health checking for VM instances. Unhealthy instances are
	// stopped and replaced with new instances. Only applicable for VM
	// runtimes.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	HealthCheck *HealthCheck `protobuf:"bytes,106,opt,name=health_check,json=healthCheck,proto3" json:"health_check,omitempty"`
	// Files that match this pattern will not be built into this version.
	// Only applicable for Go runtimes.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	NobuildFilesRegex string `protobuf:"bytes,107,opt,name=nobuild_files_regex,json=nobuildFilesRegex,proto3" json:"nobuild_files_regex,omitempty"`
	// Code and application artifacts that make up this version.
	//
	// Only returned in `GET` requests if `view=FULL` is set.
	Deployment *Deployment `protobuf:"bytes,108,opt,name=deployment,proto3" json:"deployment,omitempty"`
	// Serving URL for this version. Example:
	// "https://myversion-dot-myservice-dot-myapp.appspot.com"
	//
	// @OutputOnly
	VersionUrl           string   `protobuf:"bytes,109,opt,name=version_url,json=versionUrl,proto3" json:"version_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Version) Reset()         { *m = Version{} }
func (m *Version) String() string { return proto.CompactTextString(m) }
func (*Version) ProtoMessage()    {}
func (*Version) Descriptor() ([]byte, []int) {
	return fileDescriptor_version_8e5786bd40ede622, []int{0}
}
func (m *Version) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Version.Unmarshal(m, b)
}
func (m *Version) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Version.Marshal(b, m, deterministic)
}
func (dst *Version) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Version.Merge(dst, src)
}
func (m *Version) XXX_Size() int {
	return xxx_messageInfo_Version.Size(m)
}
func (m *Version) XXX_DiscardUnknown() {
	xxx_messageInfo_Version.DiscardUnknown(m)
}

var xxx_messageInfo_Version proto.InternalMessageInfo

func (m *Version) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *Version) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

type isVersion_Scaling interface {
	isVersion_Scaling()
}

type Version_AutomaticScaling struct {
	AutomaticScaling *AutomaticScaling `protobuf:"bytes,3,opt,name=automatic_scaling,json=automaticScaling,proto3,oneof"`
}

type Version_BasicScaling struct {
	BasicScaling *BasicScaling `protobuf:"bytes,4,opt,name=basic_scaling,json=basicScaling,proto3,oneof"`
}

type Version_ManualScaling struct {
	ManualScaling *ManualScaling `protobuf:"bytes,5,opt,name=manual_scaling,json=manualScaling,proto3,oneof"`
}

func (*Version_AutomaticScaling) isVersion_Scaling() {}

func (*Version_BasicScaling) isVersion_Scaling() {}

func (*Version_ManualScaling) isVersion_Scaling() {}

func (m *Version) GetScaling() isVersion_Scaling {
	if m != nil {
		return m.Scaling
	}
	return nil
}

func (m *Version) GetAutomaticScaling() *AutomaticScaling {
	if x, ok := m.GetScaling().(*Version_AutomaticScaling); ok {
		return x.AutomaticScaling
	}
	return nil
}

func (m *Version) GetBasicScaling() *BasicScaling {
	if x, ok := m.GetScaling().(*Version_BasicScaling); ok {
		return x.BasicScaling
	}
	return nil
}

func (m *Version) GetManualScaling() *ManualScaling {
	if x, ok := m.GetScaling().(*Version_ManualScaling); ok {
		return x.ManualScaling
	}
	return nil
}

func (m *Version) GetInboundServices() []InboundServiceType {
	if m != nil {
		return m.InboundServices
	}
	return nil
}

func (m *Version) GetInstanceClass() string {
	if m != nil {
		return m.InstanceClass
	}
	return ""
}

func (m *Version) GetNetwork() *Network {
	if m != nil {
		return m.Network
	}
	return nil
}

func (m *Version) GetResources() *Resources {
	if m != nil {
		return m.Resources
	}
	return nil
}

func (m *Version) GetRuntime() string {
	if m != nil {
		return m.Runtime
	}
	return ""
}

func (m *Version) GetThreadsafe() bool {
	if m != nil {
		return m.Threadsafe
	}
	return false
}

func (m *Version) GetVm() bool {
	if m != nil {
		return m.Vm
	}
	return false
}

func (m *Version) GetBetaSettings() map[string]string {
	if m != nil {
		return m.BetaSettings
	}
	return nil
}

func (m *Version) GetEnv() string {
	if m != nil {
		return m.Env
	}
	return ""
}

func (m *Version) GetServingStatus() ServingStatus {
	if m != nil {
		return m.ServingStatus
	}
	return ServingStatus_SERVING_STATUS_UNSPECIFIED
}

func (m *Version) GetCreatedBy() string {
	if m != nil {
		return m.CreatedBy
	}
	return ""
}

func (m *Version) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *Version) GetDiskUsageBytes() int64 {
	if m != nil {
		return m.DiskUsageBytes
	}
	return 0
}

func (m *Version) GetHandlers() []*UrlMap {
	if m != nil {
		return m.Handlers
	}
	return nil
}

func (m *Version) GetErrorHandlers() []*ErrorHandler {
	if m != nil {
		return m.ErrorHandlers
	}
	return nil
}

func (m *Version) GetLibraries() []*Library {
	if m != nil {
		return m.Libraries
	}
	return nil
}

func (m *Version) GetApiConfig() *ApiConfigHandler {
	if m != nil {
		return m.ApiConfig
	}
	return nil
}

func (m *Version) GetEnvVariables() map[string]string {
	if m != nil {
		return m.EnvVariables
	}
	return nil
}

func (m *Version) GetDefaultExpiration() *duration.Duration {
	if m != nil {
		return m.DefaultExpiration
	}
	return nil
}

func (m *Version) GetHealthCheck() *HealthCheck {
	if m != nil {
		return m.HealthCheck
	}
	return nil
}

func (m *Version) GetNobuildFilesRegex() string {
	if m != nil {
		return m.NobuildFilesRegex
	}
	return ""
}

func (m *Version) GetDeployment() *Deployment {
	if m != nil {
		return m.Deployment
	}
	return nil
}

func (m *Version) GetVersionUrl() string {
	if m != nil {
		return m.VersionUrl
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Version) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Version_OneofMarshaler, _Version_OneofUnmarshaler, _Version_OneofSizer, []interface{}{
		(*Version_AutomaticScaling)(nil),
		(*Version_BasicScaling)(nil),
		(*Version_ManualScaling)(nil),
	}
}

func _Version_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Version)
	// scaling
	switch x := m.Scaling.(type) {
	case *Version_AutomaticScaling:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AutomaticScaling); err != nil {
			return err
		}
	case *Version_BasicScaling:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BasicScaling); err != nil {
			return err
		}
	case *Version_ManualScaling:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ManualScaling); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Version.Scaling has unexpected type %T", x)
	}
	return nil
}

func _Version_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Version)
	switch tag {
	case 3: // scaling.automatic_scaling
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(AutomaticScaling)
		err := b.DecodeMessage(msg)
		m.Scaling = &Version_AutomaticScaling{msg}
		return true, err
	case 4: // scaling.basic_scaling
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BasicScaling)
		err := b.DecodeMessage(msg)
		m.Scaling = &Version_BasicScaling{msg}
		return true, err
	case 5: // scaling.manual_scaling
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ManualScaling)
		err := b.DecodeMessage(msg)
		m.Scaling = &Version_ManualScaling{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Version_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Version)
	// scaling
	switch x := m.Scaling.(type) {
	case *Version_AutomaticScaling:
		s := proto.Size(x.AutomaticScaling)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Version_BasicScaling:
		s := proto.Size(x.BasicScaling)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Version_ManualScaling:
		s := proto.Size(x.ManualScaling)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Automatic scaling is based on request rate, response latencies, and other
// application metrics.
type AutomaticScaling struct {
	// Amount of time that the
	// [Autoscaler](https://cloud.google.com/compute/docs/autoscaler/)
	// should wait between changes to the number of virtual machines.
	// Only applicable for VM runtimes.
	CoolDownPeriod *duration.Duration `protobuf:"bytes,1,opt,name=cool_down_period,json=coolDownPeriod,proto3" json:"cool_down_period,omitempty"`
	// Target scaling by CPU usage.
	CpuUtilization *CpuUtilization `protobuf:"bytes,2,opt,name=cpu_utilization,json=cpuUtilization,proto3" json:"cpu_utilization,omitempty"`
	// Number of concurrent requests an automatic scaling instance can accept
	// before the scheduler spawns a new instance.
	//
	// Defaults to a runtime-specific value.
	MaxConcurrentRequests int32 `protobuf:"varint,3,opt,name=max_concurrent_requests,json=maxConcurrentRequests,proto3" json:"max_concurrent_requests,omitempty"`
	// Maximum number of idle instances that should be maintained for this
	// version.
	MaxIdleInstances int32 `protobuf:"varint,4,opt,name=max_idle_instances,json=maxIdleInstances,proto3" json:"max_idle_instances,omitempty"`
	// Maximum number of instances that should be started to handle requests.
	MaxTotalInstances int32 `protobuf:"varint,5,opt,name=max_total_instances,json=maxTotalInstances,proto3" json:"max_total_instances,omitempty"`
	// Maximum amount of time that a request should wait in the pending queue
	// before starting a new instance to handle it.
	MaxPendingLatency *duration.Duration `protobuf:"bytes,6,opt,name=max_pending_latency,json=maxPendingLatency,proto3" json:"max_pending_latency,omitempty"`
	// Minimum number of idle instances that should be maintained for
	// this version. Only applicable for the default version of a service.
	MinIdleInstances int32 `protobuf:"varint,7,opt,name=min_idle_instances,json=minIdleInstances,proto3" json:"min_idle_instances,omitempty"`
	// Minimum number of instances that should be maintained for this version.
	MinTotalInstances int32 `protobuf:"varint,8,opt,name=min_total_instances,json=minTotalInstances,proto3" json:"min_total_instances,omitempty"`
	// Minimum amount of time a request should wait in the pending queue before
	// starting a new instance to handle it.
	MinPendingLatency *duration.Duration `protobuf:"bytes,9,opt,name=min_pending_latency,json=minPendingLatency,proto3" json:"min_pending_latency,omitempty"`
	// Target scaling by request utilization.
	RequestUtilization *RequestUtilization `protobuf:"bytes,10,opt,name=request_utilization,json=requestUtilization,proto3" json:"request_utilization,omitempty"`
	// Target scaling by disk usage.
	DiskUtilization *DiskUtilization `protobuf:"bytes,11,opt,name=disk_utilization,json=diskUtilization,proto3" json:"disk_utilization,omitempty"`
	// Target scaling by network usage.
	NetworkUtilization   *NetworkUtilization `protobuf:"bytes,12,opt,name=network_utilization,json=networkUtilization,proto3" json:"network_utilization,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *AutomaticScaling) Reset()         { *m = AutomaticScaling{} }
func (m *AutomaticScaling) String() string { return proto.CompactTextString(m) }
func (*AutomaticScaling) ProtoMessage()    {}
func (*AutomaticScaling) Descriptor() ([]byte, []int) {
	return fileDescriptor_version_8e5786bd40ede622, []int{1}
}
func (m *AutomaticScaling) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AutomaticScaling.Unmarshal(m, b)
}
func (m *AutomaticScaling) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AutomaticScaling.Marshal(b, m, deterministic)
}
func (dst *AutomaticScaling) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AutomaticScaling.Merge(dst, src)
}
func (m *AutomaticScaling) XXX_Size() int {
	return xxx_messageInfo_AutomaticScaling.Size(m)
}
func (m *AutomaticScaling) XXX_DiscardUnknown() {
	xxx_messageInfo_AutomaticScaling.DiscardUnknown(m)
}

var xxx_messageInfo_AutomaticScaling proto.InternalMessageInfo

func (m *AutomaticScaling) GetCoolDownPeriod() *duration.Duration {
	if m != nil {
		return m.CoolDownPeriod
	}
	return nil
}

func (m *AutomaticScaling) GetCpuUtilization() *CpuUtilization {
	if m != nil {
		return m.CpuUtilization
	}
	return nil
}

func (m *AutomaticScaling) GetMaxConcurrentRequests() int32 {
	if m != nil {
		return m.MaxConcurrentRequests
	}
	return 0
}

func (m *AutomaticScaling) GetMaxIdleInstances() int32 {
	if m != nil {
		return m.MaxIdleInstances
	}
	return 0
}

func (m *AutomaticScaling) GetMaxTotalInstances() int32 {
	if m != nil {
		return m.MaxTotalInstances
	}
	return 0
}

func (m *AutomaticScaling) GetMaxPendingLatency() *duration.Duration {
	if m != nil {
		return m.MaxPendingLatency
	}
	return nil
}

func (m *AutomaticScaling) GetMinIdleInstances() int32 {
	if m != nil {
		return m.MinIdleInstances
	}
	return 0
}

func (m *AutomaticScaling) GetMinTotalInstances() int32 {
	if m != nil {
		return m.MinTotalInstances
	}
	return 0
}

func (m *AutomaticScaling) GetMinPendingLatency() *duration.Duration {
	if m != nil {
		return m.MinPendingLatency
	}
	return nil
}

func (m *AutomaticScaling) GetRequestUtilization() *RequestUtilization {
	if m != nil {
		return m.RequestUtilization
	}
	return nil
}

func (m *AutomaticScaling) GetDiskUtilization() *DiskUtilization {
	if m != nil {
		return m.DiskUtilization
	}
	return nil
}

func (m *AutomaticScaling) GetNetworkUtilization() *NetworkUtilization {
	if m != nil {
		return m.NetworkUtilization
	}
	return nil
}

// A service with basic scaling will create an instance when the application
// receives a request. The instance will be turned down when the app becomes
// idle. Basic scaling is ideal for work that is intermittent or driven by
// user activity.
type BasicScaling struct {
	// Duration of time after the last request that an instance must wait before
	// the instance is shut down.
	IdleTimeout *duration.Duration `protobuf:"bytes,1,opt,name=idle_timeout,json=idleTimeout,proto3" json:"idle_timeout,omitempty"`
	// Maximum number of instances to create for this version.
	MaxInstances         int32    `protobuf:"varint,2,opt,name=max_instances,json=maxInstances,proto3" json:"max_instances,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BasicScaling) Reset()         { *m = BasicScaling{} }
func (m *BasicScaling) String() string { return proto.CompactTextString(m) }
func (*BasicScaling) ProtoMessage()    {}
func (*BasicScaling) Descriptor() ([]byte, []int) {
	return fileDescriptor_version_8e5786bd40ede622, []int{2}
}
func (m *BasicScaling) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BasicScaling.Unmarshal(m, b)
}
func (m *BasicScaling) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BasicScaling.Marshal(b, m, deterministic)
}
func (dst *BasicScaling) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BasicScaling.Merge(dst, src)
}
func (m *BasicScaling) XXX_Size() int {
	return xxx_messageInfo_BasicScaling.Size(m)
}
func (m *BasicScaling) XXX_DiscardUnknown() {
	xxx_messageInfo_BasicScaling.DiscardUnknown(m)
}

var xxx_messageInfo_BasicScaling proto.InternalMessageInfo

func (m *BasicScaling) GetIdleTimeout() *duration.Duration {
	if m != nil {
		return m.IdleTimeout
	}
	return nil
}

func (m *BasicScaling) GetMaxInstances() int32 {
	if m != nil {
		return m.MaxInstances
	}
	return 0
}

// A service with manual scaling runs continuously, allowing you to perform
// complex initialization and rely on the state of its memory over time.
type ManualScaling struct {
	// Number of instances to assign to the service at the start. This number
	// can later be altered by using the
	// [Modules
	// API](https://cloud.google.com/appengine/docs/python/modules/functions)
	// `set_num_instances()` function.
	Instances            int32    `protobuf:"varint,1,opt,name=instances,proto3" json:"instances,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ManualScaling) Reset()         { *m = ManualScaling{} }
func (m *ManualScaling) String() string { return proto.CompactTextString(m) }
func (*ManualScaling) ProtoMessage()    {}
func (*ManualScaling) Descriptor() ([]byte, []int) {
	return fileDescriptor_version_8e5786bd40ede622, []int{3}
}
func (m *ManualScaling) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ManualScaling.Unmarshal(m, b)
}
func (m *ManualScaling) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ManualScaling.Marshal(b, m, deterministic)
}
func (dst *ManualScaling) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ManualScaling.Merge(dst, src)
}
func (m *ManualScaling) XXX_Size() int {
	return xxx_messageInfo_ManualScaling.Size(m)
}
func (m *ManualScaling) XXX_DiscardUnknown() {
	xxx_messageInfo_ManualScaling.DiscardUnknown(m)
}

var xxx_messageInfo_ManualScaling proto.InternalMessageInfo

func (m *ManualScaling) GetInstances() int32 {
	if m != nil {
		return m.Instances
	}
	return 0
}

// Target scaling by CPU usage.
type CpuUtilization struct {
	// Period of time over which CPU utilization is calculated.
	AggregationWindowLength *duration.Duration `protobuf:"bytes,1,opt,name=aggregation_window_length,json=aggregationWindowLength,proto3" json:"aggregation_window_length,omitempty"`
	// Target CPU utilization ratio to maintain when scaling. Must be between 0
	// and 1.
	TargetUtilization    float64  `protobuf:"fixed64,2,opt,name=target_utilization,json=targetUtilization,proto3" json:"target_utilization,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CpuUtilization) Reset()         { *m = CpuUtilization{} }
func (m *CpuUtilization) String() string { return proto.CompactTextString(m) }
func (*CpuUtilization) ProtoMessage()    {}
func (*CpuUtilization) Descriptor() ([]byte, []int) {
	return fileDescriptor_version_8e5786bd40ede622, []int{4}
}
func (m *CpuUtilization) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CpuUtilization.Unmarshal(m, b)
}
func (m *CpuUtilization) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CpuUtilization.Marshal(b, m, deterministic)
}
func (dst *CpuUtilization) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CpuUtilization.Merge(dst, src)
}
func (m *CpuUtilization) XXX_Size() int {
	return xxx_messageInfo_CpuUtilization.Size(m)
}
func (m *CpuUtilization) XXX_DiscardUnknown() {
	xxx_messageInfo_CpuUtilization.DiscardUnknown(m)
}

var xxx_messageInfo_CpuUtilization proto.InternalMessageInfo

func (m *CpuUtilization) GetAggregationWindowLength() *duration.Duration {
	if m != nil {
		return m.AggregationWindowLength
	}
	return nil
}

func (m *CpuUtilization) GetTargetUtilization() float64 {
	if m != nil {
		return m.TargetUtilization
	}
	return 0
}

// Target scaling by request utilization. Only applicable for VM runtimes.
type RequestUtilization struct {
	// Target requests per second.
	TargetRequestCountPerSecond int32 `protobuf:"varint,1,opt,name=target_request_count_per_second,json=targetRequestCountPerSecond,proto3" json:"target_request_count_per_second,omitempty"`
	// Target number of concurrent requests.
	TargetConcurrentRequests int32    `protobuf:"varint,2,opt,name=target_concurrent_requests,json=targetConcurrentRequests,proto3" json:"target_concurrent_requests,omitempty"`
	XXX_NoUnkeyedLiteral     struct{} `json:"-"`
	XXX_unrecognized         []byte   `json:"-"`
	XXX_sizecache            int32    `json:"-"`
}

func (m *RequestUtilization) Reset()         { *m = RequestUtilization{} }
func (m *RequestUtilization) String() string { return proto.CompactTextString(m) }
func (*RequestUtilization) ProtoMessage()    {}
func (*RequestUtilization) Descriptor() ([]byte, []int) {
	return fileDescriptor_version_8e5786bd40ede622, []int{5}
}
func (m *RequestUtilization) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RequestUtilization.Unmarshal(m, b)
}
func (m *RequestUtilization) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RequestUtilization.Marshal(b, m, deterministic)
}
func (dst *RequestUtilization) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RequestUtilization.Merge(dst, src)
}
func (m *RequestUtilization) XXX_Size() int {
	return xxx_messageInfo_RequestUtilization.Size(m)
}
func (m *RequestUtilization) XXX_DiscardUnknown() {
	xxx_messageInfo_RequestUtilization.DiscardUnknown(m)
}

var xxx_messageInfo_RequestUtilization proto.InternalMessageInfo

func (m *RequestUtilization) GetTargetRequestCountPerSecond() int32 {
	if m != nil {
		return m.TargetRequestCountPerSecond
	}
	return 0
}

func (m *RequestUtilization) GetTargetConcurrentRequests() int32 {
	if m != nil {
		return m.TargetConcurrentRequests
	}
	return 0
}

// Target scaling by disk usage. Only applicable for VM runtimes.
type DiskUtilization struct {
	// Target bytes written per second.
	TargetWriteBytesPerSecond int32 `protobuf:"varint,14,opt,name=target_write_bytes_per_second,json=targetWriteBytesPerSecond,proto3" json:"target_write_bytes_per_second,omitempty"`
	// Target ops written per second.
	TargetWriteOpsPerSecond int32 `protobuf:"varint,15,opt,name=target_write_ops_per_second,json=targetWriteOpsPerSecond,proto3" json:"target_write_ops_per_second,omitempty"`
	// Target bytes read per second.
	TargetReadBytesPerSecond int32 `protobuf:"varint,16,opt,name=target_read_bytes_per_second,json=targetReadBytesPerSecond,proto3" json:"target_read_bytes_per_second,omitempty"`
	// Target ops read per seconds.
	TargetReadOpsPerSecond int32    `protobuf:"varint,17,opt,name=target_read_ops_per_second,json=targetReadOpsPerSecond,proto3" json:"target_read_ops_per_second,omitempty"`
	XXX_NoUnkeyedLiteral   struct{} `json:"-"`
	XXX_unrecognized       []byte   `json:"-"`
	XXX_sizecache          int32    `json:"-"`
}

func (m *DiskUtilization) Reset()         { *m = DiskUtilization{} }
func (m *DiskUtilization) String() string { return proto.CompactTextString(m) }
func (*DiskUtilization) ProtoMessage()    {}
func (*DiskUtilization) Descriptor() ([]byte, []int) {
	return fileDescriptor_version_8e5786bd40ede622, []int{6}
}
func (m *DiskUtilization) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DiskUtilization.Unmarshal(m, b)
}
func (m *DiskUtilization) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DiskUtilization.Marshal(b, m, deterministic)
}
func (dst *DiskUtilization) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DiskUtilization.Merge(dst, src)
}
func (m *DiskUtilization) XXX_Size() int {
	return xxx_messageInfo_DiskUtilization.Size(m)
}
func (m *DiskUtilization) XXX_DiscardUnknown() {
	xxx_messageInfo_DiskUtilization.DiscardUnknown(m)
}

var xxx_messageInfo_DiskUtilization proto.InternalMessageInfo

func (m *DiskUtilization) GetTargetWriteBytesPerSecond() int32 {
	if m != nil {
		return m.TargetWriteBytesPerSecond
	}
	return 0
}

func (m *DiskUtilization) GetTargetWriteOpsPerSecond() int32 {
	if m != nil {
		return m.TargetWriteOpsPerSecond
	}
	return 0
}

func (m *DiskUtilization) GetTargetReadBytesPerSecond() int32 {
	if m != nil {
		return m.TargetReadBytesPerSecond
	}
	return 0
}

func (m *DiskUtilization) GetTargetReadOpsPerSecond() int32 {
	if m != nil {
		return m.TargetReadOpsPerSecond
	}
	return 0
}

// Target scaling by network usage. Only applicable for VM runtimes.
type NetworkUtilization struct {
	// Target bytes sent per second.
	TargetSentBytesPerSecond int32 `protobuf:"varint,1,opt,name=target_sent_bytes_per_second,json=targetSentBytesPerSecond,proto3" json:"target_sent_bytes_per_second,omitempty"`
	// Target packets sent per second.
	TargetSentPacketsPerSecond int32 `protobuf:"varint,11,opt,name=target_sent_packets_per_second,json=targetSentPacketsPerSecond,proto3" json:"target_sent_packets_per_second,omitempty"`
	// Target bytes received per second.
	TargetReceivedBytesPerSecond int32 `protobuf:"varint,12,opt,name=target_received_bytes_per_second,json=targetReceivedBytesPerSecond,proto3" json:"target_received_bytes_per_second,omitempty"`
	// Target packets received per second.
	TargetReceivedPacketsPerSecond int32    `protobuf:"varint,13,opt,name=target_received_packets_per_second,json=targetReceivedPacketsPerSecond,proto3" json:"target_received_packets_per_second,omitempty"`
	XXX_NoUnkeyedLiteral           struct{} `json:"-"`
	XXX_unrecognized               []byte   `json:"-"`
	XXX_sizecache                  int32    `json:"-"`
}

func (m *NetworkUtilization) Reset()         { *m = NetworkUtilization{} }
func (m *NetworkUtilization) String() string { return proto.CompactTextString(m) }
func (*NetworkUtilization) ProtoMessage()    {}
func (*NetworkUtilization) Descriptor() ([]byte, []int) {
	return fileDescriptor_version_8e5786bd40ede622, []int{7}
}
func (m *NetworkUtilization) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_NetworkUtilization.Unmarshal(m, b)
}
func (m *NetworkUtilization) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_NetworkUtilization.Marshal(b, m, deterministic)
}
func (dst *NetworkUtilization) XXX_Merge(src proto.Message) {
	xxx_messageInfo_NetworkUtilization.Merge(dst, src)
}
func (m *NetworkUtilization) XXX_Size() int {
	return xxx_messageInfo_NetworkUtilization.Size(m)
}
func (m *NetworkUtilization) XXX_DiscardUnknown() {
	xxx_messageInfo_NetworkUtilization.DiscardUnknown(m)
}

var xxx_messageInfo_NetworkUtilization proto.InternalMessageInfo

func (m *NetworkUtilization) GetTargetSentBytesPerSecond() int32 {
	if m != nil {
		return m.TargetSentBytesPerSecond
	}
	return 0
}

func (m *NetworkUtilization) GetTargetSentPacketsPerSecond() int32 {
	if m != nil {
		return m.TargetSentPacketsPerSecond
	}
	return 0
}

func (m *NetworkUtilization) GetTargetReceivedBytesPerSecond() int32 {
	if m != nil {
		return m.TargetReceivedBytesPerSecond
	}
	return 0
}

func (m *NetworkUtilization) GetTargetReceivedPacketsPerSecond() int32 {
	if m != nil {
		return m.TargetReceivedPacketsPerSecond
	}
	return 0
}

// Extra network settings. Only applicable for VM runtimes.
type Network struct {
	// List of ports, or port pairs, to forward from the virtual machine to the
	// application container.
	ForwardedPorts []string `protobuf:"bytes,1,rep,name=forwarded_ports,json=forwardedPorts,proto3" json:"forwarded_ports,omitempty"`
	// Tag to apply to the VM instance during creation.
	InstanceTag string `protobuf:"bytes,2,opt,name=instance_tag,json=instanceTag,proto3" json:"instance_tag,omitempty"`
	// Google Cloud Platform network where the virtual machines are created.
	// Specify the short name, not the resource path.
	//
	// Defaults to `default`.
	Name                 string   `protobuf:"bytes,3,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Network) Reset()         { *m = Network{} }
func (m *Network) String() string { return proto.CompactTextString(m) }
func (*Network) ProtoMessage()    {}
func (*Network) Descriptor() ([]byte, []int) {
	return fileDescriptor_version_8e5786bd40ede622, []int{8}
}
func (m *Network) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Network.Unmarshal(m, b)
}
func (m *Network) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Network.Marshal(b, m, deterministic)
}
func (dst *Network) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Network.Merge(dst, src)
}
func (m *Network) XXX_Size() int {
	return xxx_messageInfo_Network.Size(m)
}
func (m *Network) XXX_DiscardUnknown() {
	xxx_messageInfo_Network.DiscardUnknown(m)
}

var xxx_messageInfo_Network proto.InternalMessageInfo

func (m *Network) GetForwardedPorts() []string {
	if m != nil {
		return m.ForwardedPorts
	}
	return nil
}

func (m *Network) GetInstanceTag() string {
	if m != nil {
		return m.InstanceTag
	}
	return ""
}

func (m *Network) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Machine resources for a version.
type Resources struct {
	// Number of CPU cores needed.
	Cpu float64 `protobuf:"fixed64,1,opt,name=cpu,proto3" json:"cpu,omitempty"`
	// Disk size (GB) needed.
	DiskGb float64 `protobuf:"fixed64,2,opt,name=disk_gb,json=diskGb,proto3" json:"disk_gb,omitempty"`
	// Memory (GB) needed.
	MemoryGb             float64  `protobuf:"fixed64,3,opt,name=memory_gb,json=memoryGb,proto3" json:"memory_gb,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Resources) Reset()         { *m = Resources{} }
func (m *Resources) String() string { return proto.CompactTextString(m) }
func (*Resources) ProtoMessage()    {}
func (*Resources) Descriptor() ([]byte, []int) {
	return fileDescriptor_version_8e5786bd40ede622, []int{9}
}
func (m *Resources) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Resources.Unmarshal(m, b)
}
func (m *Resources) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Resources.Marshal(b, m, deterministic)
}
func (dst *Resources) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Resources.Merge(dst, src)
}
func (m *Resources) XXX_Size() int {
	return xxx_messageInfo_Resources.Size(m)
}
func (m *Resources) XXX_DiscardUnknown() {
	xxx_messageInfo_Resources.DiscardUnknown(m)
}

var xxx_messageInfo_Resources proto.InternalMessageInfo

func (m *Resources) GetCpu() float64 {
	if m != nil {
		return m.Cpu
	}
	return 0
}

func (m *Resources) GetDiskGb() float64 {
	if m != nil {
		return m.DiskGb
	}
	return 0
}

func (m *Resources) GetMemoryGb() float64 {
	if m != nil {
		return m.MemoryGb
	}
	return 0
}

func init() {
	proto.RegisterType((*Version)(nil), "google.appengine.v1.Version")
	proto.RegisterMapType((map[string]string)(nil), "google.appengine.v1.Version.BetaSettingsEntry")
	proto.RegisterMapType((map[string]string)(nil), "google.appengine.v1.Version.EnvVariablesEntry")
	proto.RegisterType((*AutomaticScaling)(nil), "google.appengine.v1.AutomaticScaling")
	proto.RegisterType((*BasicScaling)(nil), "google.appengine.v1.BasicScaling")
	proto.RegisterType((*ManualScaling)(nil), "google.appengine.v1.ManualScaling")
	proto.RegisterType((*CpuUtilization)(nil), "google.appengine.v1.CpuUtilization")
	proto.RegisterType((*RequestUtilization)(nil), "google.appengine.v1.RequestUtilization")
	proto.RegisterType((*DiskUtilization)(nil), "google.appengine.v1.DiskUtilization")
	proto.RegisterType((*NetworkUtilization)(nil), "google.appengine.v1.NetworkUtilization")
	proto.RegisterType((*Network)(nil), "google.appengine.v1.Network")
	proto.RegisterType((*Resources)(nil), "google.appengine.v1.Resources")
	proto.RegisterEnum("google.appengine.v1.InboundServiceType", InboundServiceType_name, InboundServiceType_value)
	proto.RegisterEnum("google.appengine.v1.ServingStatus", ServingStatus_name, ServingStatus_value)
}

func init() {
	proto.RegisterFile("google/appengine/v1/version.proto", fileDescriptor_version_8e5786bd40ede622)
}

var fileDescriptor_version_8e5786bd40ede622 = []byte{
	// 1767 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x58, 0x5d, 0x73, 0xdb, 0xc6,
	0x15, 0x0d, 0x29, 0x4b, 0x14, 0x2f, 0x3f, 0x04, 0xad, 0xd3, 0x08, 0x96, 0x64, 0x89, 0x66, 0x92,
	0xb1, 0x26, 0xd3, 0x50, 0x13, 0x77, 0x26, 0xed, 0x38, 0x9e, 0xa6, 0x22, 0x45, 0x5b, 0x6c, 0xf5,
	0xc1, 0x01, 0x48, 0x3b, 0xd3, 0x17, 0xcc, 0x12, 0x58, 0x41, 0x5b, 0x01, 0x0b, 0x64, 0xb1, 0xa0,
	0xc4, 0xfe, 0x87, 0x3e, 0xb6, 0xd3, 0x1f, 0xd1, 0xc7, 0xbe, 0xf5, 0xcf, 0x75, 0x76, 0x01, 0x90,
	0x20, 0x89, 0xd8, 0xed, 0x1b, 0xf7, 0xee, 0x39, 0x67, 0x0f, 0xee, 0xde, 0xbd, 0x0b, 0x10, 0x5e,
	0xb8, 0x41, 0xe0, 0x7a, 0xe4, 0x14, 0x87, 0x21, 0x61, 0x2e, 0x65, 0xe4, 0x74, 0xfa, 0xdd, 0xe9,
	0x94, 0xf0, 0x88, 0x06, 0xac, 0x13, 0xf2, 0x40, 0x04, 0xe8, 0x69, 0x02, 0xe9, 0xcc, 0x21, 0x9d,
	0xe9, 0x77, 0xfb, 0x87, 0x73, 0x1e, 0x3d, 0xc5, 0x8c, 0x05, 0x02, 0x0b, 0x1a, 0xb0, 0x28, 0xa1,
	0xec, 0xb7, 0x8b, 0x54, 0x71, 0x18, 0x5a, 0x33, 0xec, 0x7b, 0x29, 0xa6, 0x55, 0x84, 0x71, 0x48,
	0xe8, 0x05, 0xb3, 0x14, 0x71, 0x94, 0x22, 0xd4, 0x68, 0x12, 0xdf, 0x9e, 0x3a, 0x31, 0x57, 0xcb,
	0xa4, 0xf3, 0xc7, 0xab, 0xf3, 0x82, 0xfa, 0x24, 0x12, 0xd8, 0x0f, 0x13, 0x40, 0xfb, 0xef, 0x0d,
	0xa8, 0xbc, 0x4f, 0x9e, 0x05, 0x21, 0x78, 0xc2, 0xb0, 0x4f, 0xf4, 0x52, 0xab, 0x74, 0x52, 0x35,
	0xd4, 0x6f, 0xd4, 0x84, 0x32, 0x75, 0xf4, 0xb2, 0x8a, 0x94, 0xa9, 0x83, 0x46, 0xb0, 0x8b, 0x63,
	0x11, 0xf8, 0x58, 0x50, 0xdb, 0x8a, 0x6c, 0xec, 0x51, 0xe6, 0xea, 0x1b, 0xad, 0xd2, 0x49, 0xed,
	0xd5, 0xd7, 0x9d, 0x82, 0x2c, 0x74, 0xce, 0x32, 0xb4, 0x99, 0x80, 0x2f, 0x3e, 0x33, 0x34, 0xbc,
	0x12, 0x43, 0x17, 0xd0, 0x98, 0xe0, 0x28, 0xa7, 0xf8, 0x44, 0x29, 0xbe, 0x28, 0x54, 0xec, 0x4a,
	0xe4, 0x42, 0xad, 0x3e, 0xc9, 0x8d, 0xd1, 0x9f, 0xa0, 0xe9, 0x63, 0x16, 0x63, 0x6f, 0x2e, 0xb5,
	0xa9, 0xa4, 0xda, 0x85, 0x52, 0x57, 0x0a, 0xba, 0xd0, 0x6a, 0xf8, 0xf9, 0x00, 0x32, 0x40, 0xa3,
	0x6c, 0x12, 0xc4, 0xcc, 0xb1, 0x22, 0xc2, 0xa7, 0xd4, 0x26, 0x91, 0xbe, 0xd5, 0xda, 0x38, 0x69,
	0xbe, 0x7a, 0x59, 0x28, 0x37, 0x48, 0xc0, 0x66, 0x82, 0x1d, 0xcd, 0x42, 0x62, 0xec, 0xd0, 0xa5,
	0x58, 0x84, 0xbe, 0x86, 0x26, 0x65, 0x91, 0xc0, 0xcc, 0x26, 0x96, 0xed, 0xe1, 0x28, 0xd2, 0x2b,
	0x2a, 0xb9, 0x8d, 0x2c, 0xda, 0x93, 0x41, 0xf4, 0x3d, 0x54, 0x18, 0x11, 0x0f, 0x01, 0xbf, 0xd7,
	0xb7, 0xd5, 0x03, 0x1c, 0x16, 0xae, 0x78, 0x9d, 0x60, 0x8c, 0x0c, 0x8c, 0xde, 0x40, 0x95, 0x93,
	0x28, 0x88, 0xb9, 0xf4, 0x5a, 0x55, 0xcc, 0xa3, 0x42, 0xa6, 0x91, 0xa1, 0x8c, 0x05, 0x01, 0xe9,
	0x50, 0xe1, 0x31, 0x93, 0x35, 0xa2, 0x83, 0x72, 0x95, 0x0d, 0xd1, 0x11, 0x80, 0xb8, 0xe3, 0x04,
	0x3b, 0x11, 0xbe, 0x25, 0x7a, 0xad, 0x55, 0x3a, 0xd9, 0x36, 0x72, 0x11, 0x59, 0x27, 0x53, 0x5f,
	0xaf, 0xab, 0x78, 0x79, 0xea, 0x23, 0x13, 0x1a, 0x13, 0x22, 0xb0, 0x15, 0x11, 0x21, 0x28, 0x73,
	0x23, 0xbd, 0xd1, 0xda, 0x38, 0xa9, 0xbd, 0xea, 0x14, 0x7a, 0x49, 0x0b, 0xb0, 0xd3, 0x25, 0x02,
	0x9b, 0x29, 0xa1, 0xcf, 0x04, 0x9f, 0x19, 0xf5, 0x49, 0x2e, 0x84, 0x34, 0xd8, 0x20, 0x6c, 0xaa,
	0x37, 0x95, 0x35, 0xf9, 0x13, 0x0d, 0xa0, 0xa9, 0x76, 0x86, 0xb9, 0x56, 0x24, 0xb0, 0x88, 0x23,
	0x7d, 0xa7, 0x55, 0x3a, 0x69, 0xfe, 0xc2, 0x76, 0x9b, 0x09, 0xd4, 0x54, 0x48, 0xa3, 0x11, 0xe5,
	0x87, 0xe8, 0x39, 0x80, 0xcd, 0x09, 0x16, 0xc4, 0xb1, 0x26, 0x33, 0x5d, 0x53, 0x6b, 0x54, 0xd3,
	0x48, 0x77, 0x86, 0x7e, 0x80, 0x5a, 0x32, 0xb0, 0x54, 0x7a, 0x76, 0x55, 0x6a, 0xf7, 0xb3, 0x65,
	0xb2, 0xf3, 0xd5, 0x19, 0x65, 0xe7, 0xcb, 0x48, 0xd5, 0x64, 0x00, 0x9d, 0x80, 0xe6, 0xd0, 0xe8,
	0xde, 0x8a, 0x23, 0xec, 0x12, 0x6b, 0x32, 0x13, 0x24, 0xd2, 0x51, 0xab, 0x74, 0xb2, 0x61, 0x34,
	0x65, 0x7c, 0x2c, 0xc3, 0x5d, 0x19, 0x45, 0xbf, 0x85, 0xed, 0x3b, 0xcc, 0x1c, 0x8f, 0xf0, 0x48,
	0x77, 0x54, 0xca, 0x0e, 0x0a, 0x1f, 0x65, 0xcc, 0xbd, 0x2b, 0x1c, 0x1a, 0x73, 0x30, 0xba, 0x80,
	0x26, 0xe1, 0x3c, 0xe0, 0xd6, 0x9c, 0x4e, 0x14, 0xbd, 0xf8, 0x0c, 0xf5, 0x25, 0xf4, 0x22, 0x41,
	0x1a, 0x0d, 0x92, 0x1b, 0x45, 0xe8, 0x35, 0x54, 0x3d, 0x3a, 0xe1, 0x98, 0x53, 0x12, 0xe9, 0xb7,
	0x4a, 0xa4, 0xb8, 0xf8, 0x2e, 0x15, 0x6a, 0x66, 0x2c, 0xe0, 0xe8, 0x1c, 0x00, 0x87, 0xd4, 0xb2,
	0x03, 0x76, 0x4b, 0x5d, 0xdd, 0xfd, 0x58, 0x5f, 0x08, 0x69, 0x4f, 0xa1, 0x32, 0x17, 0x55, 0x9c,
	0x45, 0x64, 0xf1, 0x10, 0x36, 0xb5, 0xa6, 0x98, 0x53, 0x3c, 0xf1, 0x48, 0xa4, 0xdf, 0xfd, 0x0f,
	0xc5, 0xd3, 0x67, 0xd3, 0xf7, 0x19, 0x21, 0x2d, 0x1e, 0x92, 0x0b, 0xa1, 0x0b, 0x40, 0x0e, 0xb9,
	0xc5, 0xb1, 0x27, 0x2c, 0xf2, 0x18, 0xd2, 0xa4, 0x4d, 0xea, 0x54, 0x59, 0x7c, 0xb6, 0xb6, 0x8f,
	0xe7, 0x69, 0x1f, 0x35, 0x76, 0x53, 0x52, 0x7f, 0xce, 0x41, 0x3d, 0xa8, 0xdf, 0x11, 0xec, 0x89,
	0x3b, 0xcb, 0xbe, 0x23, 0xf6, 0xbd, 0xfe, 0x17, 0xa5, 0xd1, 0x2a, 0x74, 0x77, 0xa1, 0x80, 0x3d,
	0x89, 0x33, 0x6a, 0x77, 0x8b, 0x01, 0xea, 0xc0, 0x53, 0x16, 0x4c, 0x62, 0xea, 0x39, 0xd6, 0x2d,
	0xf5, 0x48, 0x64, 0x71, 0xe2, 0x92, 0x47, 0xfd, 0x5e, 0xd5, 0xdd, 0x6e, 0x3a, 0xf5, 0x56, 0xce,
	0x18, 0x72, 0x02, 0xfd, 0x08, 0x90, 0x74, 0x7e, 0x9f, 0x30, 0xa1, 0x7b, 0x6a, 0xc9, 0xe3, 0xc2,
	0x25, 0xcf, 0xe7, 0x30, 0x23, 0x47, 0x41, 0xc7, 0x50, 0x4b, 0x2f, 0x2d, 0x2b, 0xe6, 0x9e, 0xee,
	0xab, 0x85, 0x20, 0x0d, 0x8d, 0xb9, 0xb7, 0xff, 0x23, 0xec, 0xae, 0x1d, 0x40, 0x79, 0xe4, 0xee,
	0xc9, 0x2c, 0xbd, 0x12, 0xe4, 0x4f, 0xf4, 0x39, 0x6c, 0x4e, 0xb1, 0x17, 0x93, 0xf4, 0x52, 0x48,
	0x06, 0xaf, 0xcb, 0xbf, 0x2b, 0x49, 0x81, 0xb5, 0x4d, 0xf8, 0x7f, 0x04, 0xba, 0x55, 0xa8, 0xa4,
	0x5d, 0xbb, 0xfd, 0xef, 0x2d, 0xd0, 0x56, 0xaf, 0x0e, 0xd4, 0x03, 0xcd, 0x0e, 0x02, 0xcf, 0x72,
	0x82, 0x07, 0x66, 0x85, 0x84, 0xd3, 0xc0, 0x51, 0xc2, 0x1f, 0xdd, 0xc0, 0xa6, 0xa4, 0x9c, 0x07,
	0x0f, 0x6c, 0xa8, 0x08, 0xe8, 0x12, 0x76, 0xec, 0x30, 0xb6, 0x62, 0x41, 0x3d, 0xfa, 0xd7, 0xa4,
	0x08, 0xca, 0x4a, 0xe3, 0xcb, 0xc2, 0x6c, 0xf6, 0xc2, 0x78, 0xbc, 0x80, 0x1a, 0x4d, 0x7b, 0x69,
	0x8c, 0xbe, 0x87, 0x3d, 0x1f, 0x3f, 0xca, 0x82, 0xb7, 0x63, 0xce, 0x09, 0x13, 0x16, 0x27, 0x3f,
	0xc7, 0x24, 0x12, 0x91, 0xba, 0x15, 0x37, 0x8d, 0x5f, 0xf9, 0xf8, 0xb1, 0x37, 0x9f, 0x35, 0xd2,
	0x49, 0xf4, 0x6b, 0x40, 0x92, 0x47, 0x1d, 0x8f, 0x58, 0x59, 0xe7, 0x8f, 0xd4, 0xb5, 0xb7, 0x69,
	0x68, 0x3e, 0x7e, 0x1c, 0x38, 0x1e, 0x19, 0x64, 0x71, 0x59, 0x2c, 0x12, 0x2d, 0x02, 0x81, 0xbd,
	0x1c, 0x7c, 0x53, 0xc1, 0x77, 0x7d, 0xfc, 0x38, 0x92, 0x33, 0x0b, 0xfc, 0x20, 0xc1, 0x87, 0x84,
	0x39, 0xb2, 0x35, 0x7a, 0x58, 0x10, 0x66, 0xcf, 0xf4, 0xad, 0x4f, 0x16, 0xbb, 0x8f, 0x1f, 0x87,
	0x09, 0xe9, 0x32, 0xe1, 0x28, 0xa3, 0x94, 0xad, 0x1a, 0xad, 0xa4, 0x46, 0x29, 0x5b, 0x37, 0x4a,
	0xd9, 0x9a, 0xd1, 0xed, 0xd4, 0x28, 0x65, 0x05, 0x46, 0x29, 0x5b, 0x33, 0x5a, 0xfd, 0xb4, 0x51,
	0xca, 0x56, 0x8c, 0xfe, 0x04, 0x4f, 0xd3, 0xd4, 0x2f, 0xed, 0x2d, 0x28, 0xa9, 0x97, 0xbf, 0x70,
	0x07, 0x2a, 0x7c, 0x7e, 0x7f, 0x11, 0x5f, 0x8b, 0xa1, 0x9b, 0xac, 0x7b, 0xe7, 0x64, 0x6b, 0x4a,
	0xf6, 0xab, 0xe2, 0x03, 0x28, 0x5b, 0x7a, 0x4e, 0x73, 0xc7, 0x59, 0x0e, 0x48, 0xab, 0xe9, 0x7d,
	0xbd, 0xa4, 0x59, 0xff, 0x88, 0xd5, 0xf4, 0xa2, 0x5f, 0xb2, 0xca, 0xd6, 0x62, 0xed, 0x9f, 0xa1,
	0x9e, 0x7f, 0x3d, 0x42, 0x6f, 0xa0, 0xae, 0x76, 0x4e, 0xde, 0x59, 0x41, 0x2c, 0x3e, 0x7d, 0x5a,
	0x6a, 0x12, 0x3e, 0x4a, 0xd0, 0xe8, 0x4b, 0x68, 0xa8, 0x22, 0x9d, 0xef, 0x63, 0x59, 0xed, 0x63,
	0x5d, 0xd6, 0x67, 0x16, 0x6b, 0x7f, 0x0b, 0x8d, 0xa5, 0xd7, 0x28, 0x74, 0x08, 0xd5, 0x05, 0xa3,
	0xa4, 0x18, 0x8b, 0x40, 0xfb, 0x1f, 0x25, 0x68, 0x2e, 0x9f, 0x29, 0x34, 0x86, 0x67, 0xd8, 0x75,
	0x39, 0x71, 0xd5, 0xd0, 0x7a, 0xa0, 0xcc, 0x09, 0x1e, 0x2c, 0x8f, 0x30, 0x57, 0xdc, 0x7d, 0xda,
	0xf1, 0x5e, 0x8e, 0xfb, 0x41, 0x51, 0x2f, 0x15, 0x13, 0x7d, 0x0b, 0x48, 0x60, 0xee, 0x12, 0xb1,
	0x76, 0xd6, 0x4b, 0xc6, 0x6e, 0x32, 0x93, 0x4f, 0xdd, 0x3f, 0x4b, 0x80, 0xd6, 0x0b, 0x02, 0x9d,
	0xc3, 0x71, 0xaa, 0x92, 0x55, 0x97, 0x1d, 0xc4, 0x4c, 0xc8, 0xf6, 0x63, 0x45, 0xc4, 0x0e, 0x98,
	0x93, 0x3e, 0xe3, 0x41, 0x02, 0x4b, 0x25, 0x7a, 0x12, 0x34, 0x24, 0xdc, 0x54, 0x10, 0xf4, 0x06,
	0xf6, 0x53, 0x95, 0xa2, 0x4e, 0x91, 0xa4, 0x55, 0x4f, 0x10, 0xeb, 0xcd, 0xa2, 0xfd, 0xb7, 0x32,
	0xec, 0xac, 0x14, 0x15, 0xfa, 0x03, 0x3c, 0x4f, 0x15, 0x1f, 0x38, 0x15, 0xe9, 0x4b, 0x45, 0xde,
	0x55, 0x53, 0x89, 0x3e, 0x4b, 0x40, 0x1f, 0x24, 0x46, 0xbd, 0x61, 0xe4, 0x3d, 0x1d, 0x2c, 0x29,
	0x04, 0xe1, 0x12, 0x7f, 0x47, 0xf1, 0xf7, 0x72, 0xfc, 0x9b, 0x30, 0xc7, 0xfe, 0x3d, 0x1c, 0xce,
	0xf3, 0x82, 0x9d, 0xf5, 0xe5, 0xb5, 0xfc, 0x33, 0x19, 0x04, 0x3b, 0x2b, 0xab, 0xbf, 0x9e, 0x67,
	0x44, 0xf1, 0x57, 0x16, 0xdf, 0x55, 0xec, 0x2f, 0x16, 0xec, 0xfc, 0xda, 0xed, 0x7f, 0x95, 0x01,
	0xad, 0x1f, 0x88, 0x9c, 0xa5, 0x48, 0xa6, 0x77, 0xcd, 0x52, 0x29, 0x6f, 0xc9, 0x24, 0x4c, 0xac,
	0x58, 0xea, 0xc2, 0x51, 0x9e, 0x1f, 0x62, 0xfb, 0x9e, 0x88, 0x25, 0x85, 0x9a, 0x52, 0xd8, 0x5f,
	0x28, 0x0c, 0x13, 0xcc, 0x42, 0xe3, 0x2d, 0xb4, 0xe6, 0x8f, 0x65, 0x13, 0x3a, 0x25, 0x05, 0xa9,
	0xa9, 0x2b, 0x95, 0xc3, 0xec, 0xe1, 0x12, 0xd8, 0x8a, 0x97, 0x3f, 0x42, 0x7b, 0x55, 0xa7, 0xc0,
	0x4f, 0x43, 0x29, 0x1d, 0x2d, 0x2b, 0xad, 0x7a, 0x6a, 0x53, 0xa8, 0xa4, 0xd9, 0x42, 0x2f, 0x61,
	0xe7, 0x36, 0xe0, 0x0f, 0x98, 0x3b, 0x52, 0x30, 0xe0, 0x42, 0x9e, 0xd0, 0x8d, 0x93, 0xaa, 0xd1,
	0x9c, 0x87, 0x87, 0x32, 0x8a, 0x5e, 0x40, 0x7d, 0xfe, 0x99, 0x22, 0xb0, 0x9b, 0xde, 0xd5, 0xb5,
	0x2c, 0x36, 0xc2, 0xee, 0xfc, 0x73, 0x71, 0x63, 0xf1, 0xb9, 0xd8, 0x36, 0xa1, 0x3a, 0xff, 0xb0,
	0x90, 0x57, 0xbf, 0x1d, 0xc6, 0x2a, 0xed, 0x25, 0x43, 0xfe, 0x44, 0x7b, 0x50, 0x51, 0x9d, 0xd4,
	0x9d, 0xa4, 0xe7, 0x70, 0x4b, 0x0e, 0xdf, 0x4d, 0xd0, 0x01, 0x54, 0x7d, 0xe2, 0x07, 0x7c, 0x26,
	0xa7, 0x36, 0xd4, 0xd4, 0x76, 0x12, 0x78, 0x37, 0xf9, 0xe6, 0x3f, 0x65, 0x40, 0xeb, 0x9f, 0x56,
	0xe8, 0x18, 0x0e, 0x06, 0xd7, 0xdd, 0x9b, 0xf1, 0xf5, 0xb9, 0x65, 0xf6, 0x8d, 0xf7, 0x83, 0x5e,
	0xdf, 0x1a, 0x5f, 0x9b, 0xc3, 0x7e, 0x6f, 0xf0, 0x76, 0xd0, 0x3f, 0xd7, 0x3e, 0x43, 0x3a, 0x7c,
	0xbe, 0x0a, 0xb8, 0x3a, 0x1b, 0x5c, 0x6a, 0xa5, 0x22, 0xaa, 0x9c, 0xb1, 0x64, 0xa8, 0xd7, 0xd7,
	0xca, 0xe8, 0x08, 0xf6, 0x57, 0x01, 0x3f, 0x5d, 0x0d, 0x87, 0x56, 0xdf, 0x30, 0x6e, 0x0c, 0x6d,
	0x03, 0xb5, 0xe0, 0xb0, 0x70, 0xfe, 0xaa, 0x6f, 0x9a, 0x67, 0xef, 0xfa, 0xda, 0x13, 0xd4, 0x86,
	0xa3, 0x42, 0x84, 0x39, 0xee, 0x9a, 0x3d, 0x63, 0xd0, 0xed, 0x6b, 0x9b, 0xe8, 0x05, 0x3c, 0x2f,
	0xc4, 0x0c, 0x8d, 0xbe, 0xd9, 0x97, 0x46, 0xb6, 0xd0, 0x57, 0xd0, 0x5a, 0x85, 0xf4, 0x2e, 0xce,
	0xae, 0xaf, 0xfb, 0x97, 0x0b, 0x54, 0x05, 0xed, 0xc3, 0x17, 0xab, 0xa8, 0x0f, 0x67, 0xc6, 0xd5,
	0x78, 0xa8, 0x55, 0xbf, 0x19, 0x40, 0x63, 0xe9, 0xbb, 0x47, 0x3e, 0x9b, 0x02, 0x5d, 0xbf, 0xb3,
	0xcc, 0xd1, 0xd9, 0x68, 0x6c, 0xae, 0xa4, 0xad, 0x06, 0x95, 0x74, 0x5e, 0x2b, 0xa9, 0xc1, 0xe8,
	0x66, 0x38, 0xec, 0x9f, 0x6b, 0xe5, 0xae, 0x0b, 0x7b, 0x76, 0xe0, 0x17, 0xdd, 0x4f, 0xdd, 0x7a,
	0xfa, 0x1a, 0x3e, 0x94, 0xfd, 0x79, 0x58, 0xfa, 0xf3, 0x9b, 0x14, 0xe4, 0x06, 0x1e, 0x66, 0x6e,
	0x27, 0xe0, 0xee, 0xa9, 0x4b, 0x98, 0xea, 0xde, 0xa7, 0xc9, 0x14, 0x0e, 0x69, 0xb4, 0xf4, 0xcf,
	0xc6, 0x0f, 0xf3, 0xc1, 0x64, 0x4b, 0x01, 0x7f, 0xf3, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0x2f,
	0xe1, 0xd6, 0xfa, 0x7b, 0x11, 0x00, 0x00,
}
