// Package vmwarecloudsimple implements the Azure ARM Vmwarecloudsimple service API version 2019-04-01.
//
// Description of the new service
package vmwarecloudsimple

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

const (
	// DefaultBaseURI is the default URI used for the service Vmwarecloudsimple
	DefaultBaseURI = "https://management.azure.com"
)

// BaseClient is the base client for Vmwarecloudsimple.
type BaseClient struct {
	autorest.Client
	BaseURI        string
	Referer        string
	RegionID       string
	SubscriptionID string
}

// New creates an instance of the BaseClient client.
func New(referer string, regionID string, subscriptionID string) BaseClient {
	return NewWithBaseURI(DefaultBaseURI, referer, regionID, subscriptionID)
}

// NewWithBaseURI creates an instance of the BaseClient client.
func NewWithBaseURI(baseURI string, referer string, regionID string, subscriptionID string) BaseClient {
	return BaseClient{
		Client:         autorest.NewClientWithUserAgent(UserAgent()),
		BaseURI:        baseURI,
		Referer:        referer,
		RegionID:       regionID,
		SubscriptionID: subscriptionID,
	}
}

// GetOperationResultByRegion return an async operation
// Parameters:
// operationID - operation id
func (client BaseClient) GetOperationResultByRegion(ctx context.Context, operationID string) (result OperationResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetOperationResultByRegion")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetOperationResultByRegionPreparer(ctx, operationID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmwarecloudsimple.BaseClient", "GetOperationResultByRegion", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetOperationResultByRegionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "vmwarecloudsimple.BaseClient", "GetOperationResultByRegion", resp, "Failure sending request")
		return
	}

	result, err = client.GetOperationResultByRegionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmwarecloudsimple.BaseClient", "GetOperationResultByRegion", resp, "Failure responding to request")
	}

	return
}

// GetOperationResultByRegionPreparer prepares the GetOperationResultByRegion request.
func (client BaseClient) GetOperationResultByRegionPreparer(ctx context.Context, operationID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"operationId":    autorest.Encode("path", operationID),
		"regionId":       autorest.Encode("path", client.RegionID),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.VMwareCloudSimple/locations/{regionId}/operationResults/{operationId}", pathParameters),
		autorest.WithQueryParameters(queryParameters),
		autorest.WithHeader("Referer", client.Referer))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetOperationResultByRegionSender sends the GetOperationResultByRegion request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetOperationResultByRegionSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetOperationResultByRegionResponder handles the response to the GetOperationResultByRegion request. The method always
// closes the http.Response Body.
func (client BaseClient) GetOperationResultByRegionResponder(resp *http.Response) (result OperationResource, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetPrivateCloud returns private cloud by its name
// Parameters:
// pcName - the private cloud name
func (client BaseClient) GetPrivateCloud(ctx context.Context, pcName string) (result PrivateCloud, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/BaseClient.GetPrivateCloud")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPrivateCloudPreparer(ctx, pcName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmwarecloudsimple.BaseClient", "GetPrivateCloud", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetPrivateCloudSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "vmwarecloudsimple.BaseClient", "GetPrivateCloud", resp, "Failure sending request")
		return
	}

	result, err = client.GetPrivateCloudResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "vmwarecloudsimple.BaseClient", "GetPrivateCloud", resp, "Failure responding to request")
	}

	return
}

// GetPrivateCloudPreparer prepares the GetPrivateCloud request.
func (client BaseClient) GetPrivateCloudPreparer(ctx context.Context, pcName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"pcName":         autorest.Encode("path", pcName),
		"regionId":       autorest.Encode("path", client.RegionID),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-04-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.VMwareCloudSimple/locations/{regionId}/privateClouds/{pcName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetPrivateCloudSender sends the GetPrivateCloud request. The method will close the
// http.Response Body if it receives an error.
func (client BaseClient) GetPrivateCloudSender(req *http.Request) (*http.Response, error) {
	sd := autorest.GetSendDecorators(req.Context(), azure.DoRetryWithRegistration(client.Client))
	return autorest.SendWithSender(client, req, sd...)
}

// GetPrivateCloudResponder handles the response to the GetPrivateCloud request. The method always
// closes the http.Response Body.
func (client BaseClient) GetPrivateCloudResponder(resp *http.Response) (result PrivateCloud, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
