---
layout: "guides"
page_title: "Upgrading to Vault 0.6.4 - Guides"
sidebar_current: "guides-upgrading-to-0.6.4"
description: |-
  This page contains the list of deprecations and important or breaking changes
  for Vault 0.6.4. Please read it carefully.
---

# Overview

This page contains the list of deprecations and important or breaking changes
for Vault 0.6.4. Please read it carefully.

Note: both of these are security sensitive changes.

## Changes to `default` Policy Addition Rules for `auth/token/create`

An issue was reported indicating that in some cases, the stated behavior of the
`default` policy being added to tokens unless specifically requested could lead
to a privilege escalation scenario if the parent token did not itself have the
`default` policy. In most cases (e.g. using the default `default` policy) the
escalated privileges are unlikely to be dangerous, but this behavior is
undesired.

As such, we have modified the rules around `default` in a few ways when
creating tokens using this endpoint:

1. If a token creation request does not specify desired policies, the parent's
   policies will be used (as normal) but `default` will not be automatically
   added, so the child token will only have `default` if the parent does
2. If a token creation request specifies desired policies, `default` will be
   added automatically if and only if the parent token has `default`
3. If the parent token has `sudo` capability on the token creation endpoint,
   `default` is always added; since `sudo` capability on this endpoint allows
   adding any policy, this is not privilege escalation with respect to the
   parent token-holder
4. When using token store roles, `default` is always added to the list of child
   token policies unless `default` is contained in `disallowed_policies`

**Regardless of provenance**, if a token being created has the `default` policy
and `no_default_policy` has been set `true` for the request, the `default`
policy will be stripped from the final set of policies.

## Many Users Should Run `auth/token/tidy`

While investigating a report of accessor entries not being removed correctly
from Vault's data store, a security issue was discovered: if limited use-count
tokens are being used and expire due to the use-count dropping to zero (rather
than due to the token's TTL expiring or the token being explicitly revoked),
several pieces of Vault's token revocation logic would not be properly run.
This included cleaning up the associated accessor entry from the data store,
but more importantly, included the logic used to immediately expire leases
associated with the token.

These leases would not live forever; they would still be expired when their TTL
ran out. This limits the severity of this issue, but it is still a potentially
serious bug depending on each particular operational scenario.

To mitigate this issue we have taken the following steps:

1. Updated the token revocation logic to be more resilient to failures that can
  happen as it performs its various steps; the revocation will now properly
  only be considered successful if no error has occurred. In addition, the
  token entry will remain in the data store (but _not_ be usable for
  performing Vault functions) until all aspects of revocation report success,
  allowing future revocation requests to succeed if the underlying cause of the
  failure has been addressed.

2. Added a function `auth/token/tidy` that can both clean up the leaked
  accessor entries and expire the leases associated with those accessors'
  tokens.

In most cases, running `auth/token/tidy` should expire all outstanding
leases that were generated by these revoked limited-use-count tokens.

If you are both using limited-use-count tokens *and* you are using them to
issue leased secrets, you should consider upgrading to 0.6.4 and running the
`auth/token/tidy` endpoint immediately. Please note that running this function
involves a lot of requests to the data store, so plan load accordingly.

Note: response wrapping tokens do not allow generating leases but have still
been subject to leaking the accessor entries, so if you have been a heavy user
of response wrapping you should still consider running the tidy function.
