#!/bin/bash

# Copyright 2019 The Jetstack cert-manager contributors.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

set -o errexit
set -o nounset
set -o pipefail

# This script should be run via `bazel run //hack:update-bazel`
REPO_ROOT=${BUILD_WORKSPACE_DIRECTORY:-"$(cd "$(dirname "$0")" && pwd -P)"/..}
export runfiles="${runfiles:-$(pwd)}"
export PATH="${runfiles}/hack/bin:${PATH}"
cd "${REPO_ROOT}"

touch vendor/BUILD.bazel

# Generate BUILD.bazel files for golang types
gazelle fix \
    -exclude docs/generated/reference/generate/json_swagger \
    -external vendored \
    -build_file_name BUILD.bazel \
    -go_prefix github.com/jetstack/cert-manager

# Update autogenerated package-srcs and all-srcs rules
kazel

# Add manual tags to all rules in vendor/
buildozer -types 'go_library,go_binary,go_test' 'add tags manual' '//vendor/...:*' || [[ $? -eq 3 ]]

echo "SUCCESS"
