// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/expr/v1alpha1/syntax.proto

package expr // import "google.golang.org/genproto/googleapis/api/expr/v1alpha1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import duration "github.com/golang/protobuf/ptypes/duration"
import _struct "github.com/golang/protobuf/ptypes/struct"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// An expression together with source information as returned by the parser.
type ParsedExpr struct {
	// The parsed expression.
	Expr *Expr `protobuf:"bytes,2,opt,name=expr,proto3" json:"expr,omitempty"`
	// The source info derived from input that generated the parsed `expr`.
	SourceInfo           *SourceInfo `protobuf:"bytes,3,opt,name=source_info,json=sourceInfo,proto3" json:"source_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *ParsedExpr) Reset()         { *m = ParsedExpr{} }
func (m *ParsedExpr) String() string { return proto.CompactTextString(m) }
func (*ParsedExpr) ProtoMessage()    {}
func (*ParsedExpr) Descriptor() ([]byte, []int) {
	return fileDescriptor_syntax_467031a7c35e4eba, []int{0}
}
func (m *ParsedExpr) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ParsedExpr.Unmarshal(m, b)
}
func (m *ParsedExpr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ParsedExpr.Marshal(b, m, deterministic)
}
func (dst *ParsedExpr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ParsedExpr.Merge(dst, src)
}
func (m *ParsedExpr) XXX_Size() int {
	return xxx_messageInfo_ParsedExpr.Size(m)
}
func (m *ParsedExpr) XXX_DiscardUnknown() {
	xxx_messageInfo_ParsedExpr.DiscardUnknown(m)
}

var xxx_messageInfo_ParsedExpr proto.InternalMessageInfo

func (m *ParsedExpr) GetExpr() *Expr {
	if m != nil {
		return m.Expr
	}
	return nil
}

func (m *ParsedExpr) GetSourceInfo() *SourceInfo {
	if m != nil {
		return m.SourceInfo
	}
	return nil
}

// An abstract representation of a common expression.
//
// Expressions are abstractly represented as a collection of identifiers,
// select statements, function calls, literals, and comprehensions. All
// operators with the exception of the '.' operator are modelled as function
// calls. This makes it easy to represent new operators into the existing AST.
//
// All references within expressions must resolve to a
// [Decl][google.api.expr.v1alpha1.Decl] provided at type-check for an
// expression to be valid. A reference may either be a bare identifier `name` or
// a qualified identifier `google.api.name`. References may either refer to a
// value or a function declaration.
//
// For example, the expression `google.api.name.startsWith('expr')` references
// the declaration `google.api.name` within a
// [Expr.Select][google.api.expr.v1alpha1.Expr.Select] expression, and the
// function declaration `startsWith`.
type Expr struct {
	// Required. An id assigned to this node by the parser which is unique in a
	// given expression tree. This is used to associate type information and other
	// attributes to a node in the parse tree.
	Id int64 `protobuf:"varint,2,opt,name=id,proto3" json:"id,omitempty"`
	// Required. Variants of expressions.
	//
	// Types that are valid to be assigned to ExprKind:
	//	*Expr_ConstExpr
	//	*Expr_IdentExpr
	//	*Expr_SelectExpr
	//	*Expr_CallExpr
	//	*Expr_ListExpr
	//	*Expr_StructExpr
	//	*Expr_ComprehensionExpr
	ExprKind             isExpr_ExprKind `protobuf_oneof:"expr_kind"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *Expr) Reset()         { *m = Expr{} }
func (m *Expr) String() string { return proto.CompactTextString(m) }
func (*Expr) ProtoMessage()    {}
func (*Expr) Descriptor() ([]byte, []int) {
	return fileDescriptor_syntax_467031a7c35e4eba, []int{1}
}
func (m *Expr) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr.Unmarshal(m, b)
}
func (m *Expr) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr.Marshal(b, m, deterministic)
}
func (dst *Expr) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr.Merge(dst, src)
}
func (m *Expr) XXX_Size() int {
	return xxx_messageInfo_Expr.Size(m)
}
func (m *Expr) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr.DiscardUnknown(m)
}

var xxx_messageInfo_Expr proto.InternalMessageInfo

func (m *Expr) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

type isExpr_ExprKind interface {
	isExpr_ExprKind()
}

type Expr_ConstExpr struct {
	ConstExpr *Constant `protobuf:"bytes,3,opt,name=const_expr,json=constExpr,proto3,oneof"`
}

type Expr_IdentExpr struct {
	IdentExpr *Expr_Ident `protobuf:"bytes,4,opt,name=ident_expr,json=identExpr,proto3,oneof"`
}

type Expr_SelectExpr struct {
	SelectExpr *Expr_Select `protobuf:"bytes,5,opt,name=select_expr,json=selectExpr,proto3,oneof"`
}

type Expr_CallExpr struct {
	CallExpr *Expr_Call `protobuf:"bytes,6,opt,name=call_expr,json=callExpr,proto3,oneof"`
}

type Expr_ListExpr struct {
	ListExpr *Expr_CreateList `protobuf:"bytes,7,opt,name=list_expr,json=listExpr,proto3,oneof"`
}

type Expr_StructExpr struct {
	StructExpr *Expr_CreateStruct `protobuf:"bytes,8,opt,name=struct_expr,json=structExpr,proto3,oneof"`
}

type Expr_ComprehensionExpr struct {
	ComprehensionExpr *Expr_Comprehension `protobuf:"bytes,9,opt,name=comprehension_expr,json=comprehensionExpr,proto3,oneof"`
}

func (*Expr_ConstExpr) isExpr_ExprKind() {}

func (*Expr_IdentExpr) isExpr_ExprKind() {}

func (*Expr_SelectExpr) isExpr_ExprKind() {}

func (*Expr_CallExpr) isExpr_ExprKind() {}

func (*Expr_ListExpr) isExpr_ExprKind() {}

func (*Expr_StructExpr) isExpr_ExprKind() {}

func (*Expr_ComprehensionExpr) isExpr_ExprKind() {}

func (m *Expr) GetExprKind() isExpr_ExprKind {
	if m != nil {
		return m.ExprKind
	}
	return nil
}

func (m *Expr) GetConstExpr() *Constant {
	if x, ok := m.GetExprKind().(*Expr_ConstExpr); ok {
		return x.ConstExpr
	}
	return nil
}

func (m *Expr) GetIdentExpr() *Expr_Ident {
	if x, ok := m.GetExprKind().(*Expr_IdentExpr); ok {
		return x.IdentExpr
	}
	return nil
}

func (m *Expr) GetSelectExpr() *Expr_Select {
	if x, ok := m.GetExprKind().(*Expr_SelectExpr); ok {
		return x.SelectExpr
	}
	return nil
}

func (m *Expr) GetCallExpr() *Expr_Call {
	if x, ok := m.GetExprKind().(*Expr_CallExpr); ok {
		return x.CallExpr
	}
	return nil
}

func (m *Expr) GetListExpr() *Expr_CreateList {
	if x, ok := m.GetExprKind().(*Expr_ListExpr); ok {
		return x.ListExpr
	}
	return nil
}

func (m *Expr) GetStructExpr() *Expr_CreateStruct {
	if x, ok := m.GetExprKind().(*Expr_StructExpr); ok {
		return x.StructExpr
	}
	return nil
}

func (m *Expr) GetComprehensionExpr() *Expr_Comprehension {
	if x, ok := m.GetExprKind().(*Expr_ComprehensionExpr); ok {
		return x.ComprehensionExpr
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Expr) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Expr_OneofMarshaler, _Expr_OneofUnmarshaler, _Expr_OneofSizer, []interface{}{
		(*Expr_ConstExpr)(nil),
		(*Expr_IdentExpr)(nil),
		(*Expr_SelectExpr)(nil),
		(*Expr_CallExpr)(nil),
		(*Expr_ListExpr)(nil),
		(*Expr_StructExpr)(nil),
		(*Expr_ComprehensionExpr)(nil),
	}
}

func _Expr_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Expr)
	// expr_kind
	switch x := m.ExprKind.(type) {
	case *Expr_ConstExpr:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ConstExpr); err != nil {
			return err
		}
	case *Expr_IdentExpr:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.IdentExpr); err != nil {
			return err
		}
	case *Expr_SelectExpr:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SelectExpr); err != nil {
			return err
		}
	case *Expr_CallExpr:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CallExpr); err != nil {
			return err
		}
	case *Expr_ListExpr:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ListExpr); err != nil {
			return err
		}
	case *Expr_StructExpr:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StructExpr); err != nil {
			return err
		}
	case *Expr_ComprehensionExpr:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ComprehensionExpr); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Expr.ExprKind has unexpected type %T", x)
	}
	return nil
}

func _Expr_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Expr)
	switch tag {
	case 3: // expr_kind.const_expr
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Constant)
		err := b.DecodeMessage(msg)
		m.ExprKind = &Expr_ConstExpr{msg}
		return true, err
	case 4: // expr_kind.ident_expr
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Expr_Ident)
		err := b.DecodeMessage(msg)
		m.ExprKind = &Expr_IdentExpr{msg}
		return true, err
	case 5: // expr_kind.select_expr
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Expr_Select)
		err := b.DecodeMessage(msg)
		m.ExprKind = &Expr_SelectExpr{msg}
		return true, err
	case 6: // expr_kind.call_expr
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Expr_Call)
		err := b.DecodeMessage(msg)
		m.ExprKind = &Expr_CallExpr{msg}
		return true, err
	case 7: // expr_kind.list_expr
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Expr_CreateList)
		err := b.DecodeMessage(msg)
		m.ExprKind = &Expr_ListExpr{msg}
		return true, err
	case 8: // expr_kind.struct_expr
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Expr_CreateStruct)
		err := b.DecodeMessage(msg)
		m.ExprKind = &Expr_StructExpr{msg}
		return true, err
	case 9: // expr_kind.comprehension_expr
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Expr_Comprehension)
		err := b.DecodeMessage(msg)
		m.ExprKind = &Expr_ComprehensionExpr{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Expr_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Expr)
	// expr_kind
	switch x := m.ExprKind.(type) {
	case *Expr_ConstExpr:
		s := proto.Size(x.ConstExpr)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Expr_IdentExpr:
		s := proto.Size(x.IdentExpr)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Expr_SelectExpr:
		s := proto.Size(x.SelectExpr)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Expr_CallExpr:
		s := proto.Size(x.CallExpr)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Expr_ListExpr:
		s := proto.Size(x.ListExpr)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Expr_StructExpr:
		s := proto.Size(x.StructExpr)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Expr_ComprehensionExpr:
		s := proto.Size(x.ComprehensionExpr)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// An identifier expression. e.g. `request`.
type Expr_Ident struct {
	// Required. Holds a single, unqualified identifier, possibly preceded by a
	// '.'.
	//
	// Qualified names are represented by the
	// [Expr.Select][google.api.expr.v1alpha1.Expr.Select] expression.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Expr_Ident) Reset()         { *m = Expr_Ident{} }
func (m *Expr_Ident) String() string { return proto.CompactTextString(m) }
func (*Expr_Ident) ProtoMessage()    {}
func (*Expr_Ident) Descriptor() ([]byte, []int) {
	return fileDescriptor_syntax_467031a7c35e4eba, []int{1, 0}
}
func (m *Expr_Ident) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr_Ident.Unmarshal(m, b)
}
func (m *Expr_Ident) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr_Ident.Marshal(b, m, deterministic)
}
func (dst *Expr_Ident) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_Ident.Merge(dst, src)
}
func (m *Expr_Ident) XXX_Size() int {
	return xxx_messageInfo_Expr_Ident.Size(m)
}
func (m *Expr_Ident) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_Ident.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_Ident proto.InternalMessageInfo

func (m *Expr_Ident) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A field selection expression. e.g. `request.auth`.
type Expr_Select struct {
	// Required. The target of the selection expression.
	//
	// For example, in the select expression `request.auth`, the `request`
	// portion of the expression is the `operand`.
	Operand *Expr `protobuf:"bytes,1,opt,name=operand,proto3" json:"operand,omitempty"`
	// Required. The name of the field to select.
	//
	// For example, in the select expression `request.auth`, the `auth` portion
	// of the expression would be the `field`.
	Field string `protobuf:"bytes,2,opt,name=field,proto3" json:"field,omitempty"`
	// Whether the select is to be interpreted as a field presence test.
	//
	// This results from the macro `has(request.auth)`.
	TestOnly             bool     `protobuf:"varint,3,opt,name=test_only,json=testOnly,proto3" json:"test_only,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Expr_Select) Reset()         { *m = Expr_Select{} }
func (m *Expr_Select) String() string { return proto.CompactTextString(m) }
func (*Expr_Select) ProtoMessage()    {}
func (*Expr_Select) Descriptor() ([]byte, []int) {
	return fileDescriptor_syntax_467031a7c35e4eba, []int{1, 1}
}
func (m *Expr_Select) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr_Select.Unmarshal(m, b)
}
func (m *Expr_Select) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr_Select.Marshal(b, m, deterministic)
}
func (dst *Expr_Select) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_Select.Merge(dst, src)
}
func (m *Expr_Select) XXX_Size() int {
	return xxx_messageInfo_Expr_Select.Size(m)
}
func (m *Expr_Select) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_Select.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_Select proto.InternalMessageInfo

func (m *Expr_Select) GetOperand() *Expr {
	if m != nil {
		return m.Operand
	}
	return nil
}

func (m *Expr_Select) GetField() string {
	if m != nil {
		return m.Field
	}
	return ""
}

func (m *Expr_Select) GetTestOnly() bool {
	if m != nil {
		return m.TestOnly
	}
	return false
}

// A call expression, including calls to predefined functions and operators.
//
// For example, `value == 10`, `size(map_value)`.
type Expr_Call struct {
	// The target of an method call-style expression. For example, `x` in
	// `x.f()`.
	Target *Expr `protobuf:"bytes,1,opt,name=target,proto3" json:"target,omitempty"`
	// Required. The name of the function or method being called.
	Function string `protobuf:"bytes,2,opt,name=function,proto3" json:"function,omitempty"`
	// The arguments.
	Args                 []*Expr  `protobuf:"bytes,3,rep,name=args,proto3" json:"args,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Expr_Call) Reset()         { *m = Expr_Call{} }
func (m *Expr_Call) String() string { return proto.CompactTextString(m) }
func (*Expr_Call) ProtoMessage()    {}
func (*Expr_Call) Descriptor() ([]byte, []int) {
	return fileDescriptor_syntax_467031a7c35e4eba, []int{1, 2}
}
func (m *Expr_Call) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr_Call.Unmarshal(m, b)
}
func (m *Expr_Call) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr_Call.Marshal(b, m, deterministic)
}
func (dst *Expr_Call) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_Call.Merge(dst, src)
}
func (m *Expr_Call) XXX_Size() int {
	return xxx_messageInfo_Expr_Call.Size(m)
}
func (m *Expr_Call) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_Call.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_Call proto.InternalMessageInfo

func (m *Expr_Call) GetTarget() *Expr {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *Expr_Call) GetFunction() string {
	if m != nil {
		return m.Function
	}
	return ""
}

func (m *Expr_Call) GetArgs() []*Expr {
	if m != nil {
		return m.Args
	}
	return nil
}

// A list creation expression.
//
// Lists may either be homogenous, e.g. `[1, 2, 3]`, or heterogenous, e.g.
// `dyn([1, 'hello', 2.0])`
type Expr_CreateList struct {
	// The elements part of the list.
	Elements             []*Expr  `protobuf:"bytes,1,rep,name=elements,proto3" json:"elements,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Expr_CreateList) Reset()         { *m = Expr_CreateList{} }
func (m *Expr_CreateList) String() string { return proto.CompactTextString(m) }
func (*Expr_CreateList) ProtoMessage()    {}
func (*Expr_CreateList) Descriptor() ([]byte, []int) {
	return fileDescriptor_syntax_467031a7c35e4eba, []int{1, 3}
}
func (m *Expr_CreateList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr_CreateList.Unmarshal(m, b)
}
func (m *Expr_CreateList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr_CreateList.Marshal(b, m, deterministic)
}
func (dst *Expr_CreateList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_CreateList.Merge(dst, src)
}
func (m *Expr_CreateList) XXX_Size() int {
	return xxx_messageInfo_Expr_CreateList.Size(m)
}
func (m *Expr_CreateList) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_CreateList.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_CreateList proto.InternalMessageInfo

func (m *Expr_CreateList) GetElements() []*Expr {
	if m != nil {
		return m.Elements
	}
	return nil
}

// A map or message creation expression.
//
// Maps are constructed as `{'key_name': 'value'}`. Message construction is
// similar, but prefixed with a type name and composed of field ids:
// `types.MyType{field_id: 'value'}`.
type Expr_CreateStruct struct {
	// The type name of the message to be created, empty when creating map
	// literals.
	MessageName string `protobuf:"bytes,1,opt,name=message_name,json=messageName,proto3" json:"message_name,omitempty"`
	// The entries in the creation expression.
	Entries              []*Expr_CreateStruct_Entry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *Expr_CreateStruct) Reset()         { *m = Expr_CreateStruct{} }
func (m *Expr_CreateStruct) String() string { return proto.CompactTextString(m) }
func (*Expr_CreateStruct) ProtoMessage()    {}
func (*Expr_CreateStruct) Descriptor() ([]byte, []int) {
	return fileDescriptor_syntax_467031a7c35e4eba, []int{1, 4}
}
func (m *Expr_CreateStruct) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr_CreateStruct.Unmarshal(m, b)
}
func (m *Expr_CreateStruct) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr_CreateStruct.Marshal(b, m, deterministic)
}
func (dst *Expr_CreateStruct) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_CreateStruct.Merge(dst, src)
}
func (m *Expr_CreateStruct) XXX_Size() int {
	return xxx_messageInfo_Expr_CreateStruct.Size(m)
}
func (m *Expr_CreateStruct) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_CreateStruct.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_CreateStruct proto.InternalMessageInfo

func (m *Expr_CreateStruct) GetMessageName() string {
	if m != nil {
		return m.MessageName
	}
	return ""
}

func (m *Expr_CreateStruct) GetEntries() []*Expr_CreateStruct_Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

// Represents an entry.
type Expr_CreateStruct_Entry struct {
	// Required. An id assigned to this node by the parser which is unique
	// in a given expression tree. This is used to associate type
	// information and other attributes to the node.
	Id int64 `protobuf:"varint,1,opt,name=id,proto3" json:"id,omitempty"`
	// The `Entry` key kinds.
	//
	// Types that are valid to be assigned to KeyKind:
	//	*Expr_CreateStruct_Entry_FieldKey
	//	*Expr_CreateStruct_Entry_MapKey
	KeyKind isExpr_CreateStruct_Entry_KeyKind `protobuf_oneof:"key_kind"`
	// Required. The value assigned to the key.
	Value                *Expr    `protobuf:"bytes,4,opt,name=value,proto3" json:"value,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Expr_CreateStruct_Entry) Reset()         { *m = Expr_CreateStruct_Entry{} }
func (m *Expr_CreateStruct_Entry) String() string { return proto.CompactTextString(m) }
func (*Expr_CreateStruct_Entry) ProtoMessage()    {}
func (*Expr_CreateStruct_Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor_syntax_467031a7c35e4eba, []int{1, 4, 0}
}
func (m *Expr_CreateStruct_Entry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr_CreateStruct_Entry.Unmarshal(m, b)
}
func (m *Expr_CreateStruct_Entry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr_CreateStruct_Entry.Marshal(b, m, deterministic)
}
func (dst *Expr_CreateStruct_Entry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_CreateStruct_Entry.Merge(dst, src)
}
func (m *Expr_CreateStruct_Entry) XXX_Size() int {
	return xxx_messageInfo_Expr_CreateStruct_Entry.Size(m)
}
func (m *Expr_CreateStruct_Entry) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_CreateStruct_Entry.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_CreateStruct_Entry proto.InternalMessageInfo

func (m *Expr_CreateStruct_Entry) GetId() int64 {
	if m != nil {
		return m.Id
	}
	return 0
}

type isExpr_CreateStruct_Entry_KeyKind interface {
	isExpr_CreateStruct_Entry_KeyKind()
}

type Expr_CreateStruct_Entry_FieldKey struct {
	FieldKey string `protobuf:"bytes,2,opt,name=field_key,json=fieldKey,proto3,oneof"`
}

type Expr_CreateStruct_Entry_MapKey struct {
	MapKey *Expr `protobuf:"bytes,3,opt,name=map_key,json=mapKey,proto3,oneof"`
}

func (*Expr_CreateStruct_Entry_FieldKey) isExpr_CreateStruct_Entry_KeyKind() {}

func (*Expr_CreateStruct_Entry_MapKey) isExpr_CreateStruct_Entry_KeyKind() {}

func (m *Expr_CreateStruct_Entry) GetKeyKind() isExpr_CreateStruct_Entry_KeyKind {
	if m != nil {
		return m.KeyKind
	}
	return nil
}

func (m *Expr_CreateStruct_Entry) GetFieldKey() string {
	if x, ok := m.GetKeyKind().(*Expr_CreateStruct_Entry_FieldKey); ok {
		return x.FieldKey
	}
	return ""
}

func (m *Expr_CreateStruct_Entry) GetMapKey() *Expr {
	if x, ok := m.GetKeyKind().(*Expr_CreateStruct_Entry_MapKey); ok {
		return x.MapKey
	}
	return nil
}

func (m *Expr_CreateStruct_Entry) GetValue() *Expr {
	if m != nil {
		return m.Value
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Expr_CreateStruct_Entry) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Expr_CreateStruct_Entry_OneofMarshaler, _Expr_CreateStruct_Entry_OneofUnmarshaler, _Expr_CreateStruct_Entry_OneofSizer, []interface{}{
		(*Expr_CreateStruct_Entry_FieldKey)(nil),
		(*Expr_CreateStruct_Entry_MapKey)(nil),
	}
}

func _Expr_CreateStruct_Entry_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Expr_CreateStruct_Entry)
	// key_kind
	switch x := m.KeyKind.(type) {
	case *Expr_CreateStruct_Entry_FieldKey:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.FieldKey)
	case *Expr_CreateStruct_Entry_MapKey:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MapKey); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Expr_CreateStruct_Entry.KeyKind has unexpected type %T", x)
	}
	return nil
}

func _Expr_CreateStruct_Entry_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Expr_CreateStruct_Entry)
	switch tag {
	case 2: // key_kind.field_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.KeyKind = &Expr_CreateStruct_Entry_FieldKey{x}
		return true, err
	case 3: // key_kind.map_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Expr)
		err := b.DecodeMessage(msg)
		m.KeyKind = &Expr_CreateStruct_Entry_MapKey{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Expr_CreateStruct_Entry_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Expr_CreateStruct_Entry)
	// key_kind
	switch x := m.KeyKind.(type) {
	case *Expr_CreateStruct_Entry_FieldKey:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.FieldKey)))
		n += len(x.FieldKey)
	case *Expr_CreateStruct_Entry_MapKey:
		s := proto.Size(x.MapKey)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A comprehension expression applied to a list or map.
//
// Comprehensions are not part of the core syntax, but enabled with macros.
// A macro matches a specific call signature within a parsed AST and replaces
// the call with an alternate AST block. Macro expansion happens at parse
// time.
//
// The following macros are supported within CEL:
//
// Aggregate type macros may be applied to all elements in a list or all keys
// in a map:
//
// *  `all`, `exists`, `exists_one` -  test a predicate expression against
//    the inputs and return `true` if the predicate is satisfied for all,
//    any, or only one value `list.all(x, x < 10)`.
// *  `filter` - test a predicate expression against the inputs and return
//    the subset of elements which satisfy the predicate:
//    `payments.filter(p, p > 1000)`.
// *  `map` - apply an expression to all elements in the input and return the
//    output aggregate type: `[1, 2, 3].map(i, i * i)`.
//
// The `has(m.x)` macro tests whether the property `x` is present in struct
// `m`. The semantics of this macro depend on the type of `m`. For proto2
// messages `has(m.x)` is defined as 'defined, but not set`. For proto3, the
// macro tests whether the property is set to its default. For map and struct
// types, the macro tests whether the property `x` is defined on `m`.
type Expr_Comprehension struct {
	// The name of the iteration variable.
	IterVar string `protobuf:"bytes,1,opt,name=iter_var,json=iterVar,proto3" json:"iter_var,omitempty"`
	// The range over which var iterates.
	IterRange *Expr `protobuf:"bytes,2,opt,name=iter_range,json=iterRange,proto3" json:"iter_range,omitempty"`
	// The name of the variable used for accumulation of the result.
	AccuVar string `protobuf:"bytes,3,opt,name=accu_var,json=accuVar,proto3" json:"accu_var,omitempty"`
	// The initial value of the accumulator.
	AccuInit *Expr `protobuf:"bytes,4,opt,name=accu_init,json=accuInit,proto3" json:"accu_init,omitempty"`
	// An expression which can contain iter_var and accu_var.
	//
	// Returns false when the result has been computed and may be used as
	// a hint to short-circuit the remainder of the comprehension.
	LoopCondition *Expr `protobuf:"bytes,5,opt,name=loop_condition,json=loopCondition,proto3" json:"loop_condition,omitempty"`
	// An expression which can contain iter_var and accu_var.
	//
	// Computes the next value of accu_var.
	LoopStep *Expr `protobuf:"bytes,6,opt,name=loop_step,json=loopStep,proto3" json:"loop_step,omitempty"`
	// An expression which can contain accu_var.
	//
	// Computes the result.
	Result               *Expr    `protobuf:"bytes,7,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *Expr_Comprehension) Reset()         { *m = Expr_Comprehension{} }
func (m *Expr_Comprehension) String() string { return proto.CompactTextString(m) }
func (*Expr_Comprehension) ProtoMessage()    {}
func (*Expr_Comprehension) Descriptor() ([]byte, []int) {
	return fileDescriptor_syntax_467031a7c35e4eba, []int{1, 5}
}
func (m *Expr_Comprehension) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Expr_Comprehension.Unmarshal(m, b)
}
func (m *Expr_Comprehension) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Expr_Comprehension.Marshal(b, m, deterministic)
}
func (dst *Expr_Comprehension) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Expr_Comprehension.Merge(dst, src)
}
func (m *Expr_Comprehension) XXX_Size() int {
	return xxx_messageInfo_Expr_Comprehension.Size(m)
}
func (m *Expr_Comprehension) XXX_DiscardUnknown() {
	xxx_messageInfo_Expr_Comprehension.DiscardUnknown(m)
}

var xxx_messageInfo_Expr_Comprehension proto.InternalMessageInfo

func (m *Expr_Comprehension) GetIterVar() string {
	if m != nil {
		return m.IterVar
	}
	return ""
}

func (m *Expr_Comprehension) GetIterRange() *Expr {
	if m != nil {
		return m.IterRange
	}
	return nil
}

func (m *Expr_Comprehension) GetAccuVar() string {
	if m != nil {
		return m.AccuVar
	}
	return ""
}

func (m *Expr_Comprehension) GetAccuInit() *Expr {
	if m != nil {
		return m.AccuInit
	}
	return nil
}

func (m *Expr_Comprehension) GetLoopCondition() *Expr {
	if m != nil {
		return m.LoopCondition
	}
	return nil
}

func (m *Expr_Comprehension) GetLoopStep() *Expr {
	if m != nil {
		return m.LoopStep
	}
	return nil
}

func (m *Expr_Comprehension) GetResult() *Expr {
	if m != nil {
		return m.Result
	}
	return nil
}

// Represents a primitive literal.
//
// Named 'Constant' here for backwards compatibility.
//
// This is similar as the primitives supported in the well-known type
// `google.protobuf.Value`, but richer so it can represent CEL's full range of
// primitives.
//
// Lists and structs are not included as constants as these aggregate types may
// contain [Expr][google.api.expr.v1alpha1.Expr] elements which require
// evaluation and are thus not constant.
//
// Examples of literals include: `"hello"`, `b'bytes'`, `1u`, `4.2`, `-2`,
// `true`, `null`.
type Constant struct {
	// Required. The valid constant kinds.
	//
	// Types that are valid to be assigned to ConstantKind:
	//	*Constant_NullValue
	//	*Constant_BoolValue
	//	*Constant_Int64Value
	//	*Constant_Uint64Value
	//	*Constant_DoubleValue
	//	*Constant_StringValue
	//	*Constant_BytesValue
	//	*Constant_DurationValue
	//	*Constant_TimestampValue
	ConstantKind         isConstant_ConstantKind `protobuf_oneof:"constant_kind"`
	XXX_NoUnkeyedLiteral struct{}                `json:"-"`
	XXX_unrecognized     []byte                  `json:"-"`
	XXX_sizecache        int32                   `json:"-"`
}

func (m *Constant) Reset()         { *m = Constant{} }
func (m *Constant) String() string { return proto.CompactTextString(m) }
func (*Constant) ProtoMessage()    {}
func (*Constant) Descriptor() ([]byte, []int) {
	return fileDescriptor_syntax_467031a7c35e4eba, []int{2}
}
func (m *Constant) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Constant.Unmarshal(m, b)
}
func (m *Constant) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Constant.Marshal(b, m, deterministic)
}
func (dst *Constant) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Constant.Merge(dst, src)
}
func (m *Constant) XXX_Size() int {
	return xxx_messageInfo_Constant.Size(m)
}
func (m *Constant) XXX_DiscardUnknown() {
	xxx_messageInfo_Constant.DiscardUnknown(m)
}

var xxx_messageInfo_Constant proto.InternalMessageInfo

type isConstant_ConstantKind interface {
	isConstant_ConstantKind()
}

type Constant_NullValue struct {
	NullValue _struct.NullValue `protobuf:"varint,1,opt,name=null_value,json=nullValue,proto3,enum=google.protobuf.NullValue,oneof"`
}

type Constant_BoolValue struct {
	BoolValue bool `protobuf:"varint,2,opt,name=bool_value,json=boolValue,proto3,oneof"`
}

type Constant_Int64Value struct {
	Int64Value int64 `protobuf:"varint,3,opt,name=int64_value,json=int64Value,proto3,oneof"`
}

type Constant_Uint64Value struct {
	Uint64Value uint64 `protobuf:"varint,4,opt,name=uint64_value,json=uint64Value,proto3,oneof"`
}

type Constant_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,5,opt,name=double_value,json=doubleValue,proto3,oneof"`
}

type Constant_StringValue struct {
	StringValue string `protobuf:"bytes,6,opt,name=string_value,json=stringValue,proto3,oneof"`
}

type Constant_BytesValue struct {
	BytesValue []byte `protobuf:"bytes,7,opt,name=bytes_value,json=bytesValue,proto3,oneof"`
}

type Constant_DurationValue struct {
	DurationValue *duration.Duration `protobuf:"bytes,8,opt,name=duration_value,json=durationValue,proto3,oneof"`
}

type Constant_TimestampValue struct {
	TimestampValue *timestamp.Timestamp `protobuf:"bytes,9,opt,name=timestamp_value,json=timestampValue,proto3,oneof"`
}

func (*Constant_NullValue) isConstant_ConstantKind() {}

func (*Constant_BoolValue) isConstant_ConstantKind() {}

func (*Constant_Int64Value) isConstant_ConstantKind() {}

func (*Constant_Uint64Value) isConstant_ConstantKind() {}

func (*Constant_DoubleValue) isConstant_ConstantKind() {}

func (*Constant_StringValue) isConstant_ConstantKind() {}

func (*Constant_BytesValue) isConstant_ConstantKind() {}

func (*Constant_DurationValue) isConstant_ConstantKind() {}

func (*Constant_TimestampValue) isConstant_ConstantKind() {}

func (m *Constant) GetConstantKind() isConstant_ConstantKind {
	if m != nil {
		return m.ConstantKind
	}
	return nil
}

func (m *Constant) GetNullValue() _struct.NullValue {
	if x, ok := m.GetConstantKind().(*Constant_NullValue); ok {
		return x.NullValue
	}
	return _struct.NullValue_NULL_VALUE
}

func (m *Constant) GetBoolValue() bool {
	if x, ok := m.GetConstantKind().(*Constant_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (m *Constant) GetInt64Value() int64 {
	if x, ok := m.GetConstantKind().(*Constant_Int64Value); ok {
		return x.Int64Value
	}
	return 0
}

func (m *Constant) GetUint64Value() uint64 {
	if x, ok := m.GetConstantKind().(*Constant_Uint64Value); ok {
		return x.Uint64Value
	}
	return 0
}

func (m *Constant) GetDoubleValue() float64 {
	if x, ok := m.GetConstantKind().(*Constant_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *Constant) GetStringValue() string {
	if x, ok := m.GetConstantKind().(*Constant_StringValue); ok {
		return x.StringValue
	}
	return ""
}

func (m *Constant) GetBytesValue() []byte {
	if x, ok := m.GetConstantKind().(*Constant_BytesValue); ok {
		return x.BytesValue
	}
	return nil
}

func (m *Constant) GetDurationValue() *duration.Duration {
	if x, ok := m.GetConstantKind().(*Constant_DurationValue); ok {
		return x.DurationValue
	}
	return nil
}

func (m *Constant) GetTimestampValue() *timestamp.Timestamp {
	if x, ok := m.GetConstantKind().(*Constant_TimestampValue); ok {
		return x.TimestampValue
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Constant) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Constant_OneofMarshaler, _Constant_OneofUnmarshaler, _Constant_OneofSizer, []interface{}{
		(*Constant_NullValue)(nil),
		(*Constant_BoolValue)(nil),
		(*Constant_Int64Value)(nil),
		(*Constant_Uint64Value)(nil),
		(*Constant_DoubleValue)(nil),
		(*Constant_StringValue)(nil),
		(*Constant_BytesValue)(nil),
		(*Constant_DurationValue)(nil),
		(*Constant_TimestampValue)(nil),
	}
}

func _Constant_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Constant)
	// constant_kind
	switch x := m.ConstantKind.(type) {
	case *Constant_NullValue:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.NullValue))
	case *Constant_BoolValue:
		t := uint64(0)
		if x.BoolValue {
			t = 1
		}
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *Constant_Int64Value:
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Int64Value))
	case *Constant_Uint64Value:
		b.EncodeVarint(4<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Uint64Value))
	case *Constant_DoubleValue:
		b.EncodeVarint(5<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case *Constant_StringValue:
		b.EncodeVarint(6<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.StringValue)
	case *Constant_BytesValue:
		b.EncodeVarint(7<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.BytesValue)
	case *Constant_DurationValue:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DurationValue); err != nil {
			return err
		}
	case *Constant_TimestampValue:
		b.EncodeVarint(9<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.TimestampValue); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("Constant.ConstantKind has unexpected type %T", x)
	}
	return nil
}

func _Constant_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Constant)
	switch tag {
	case 1: // constant_kind.null_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ConstantKind = &Constant_NullValue{_struct.NullValue(x)}
		return true, err
	case 2: // constant_kind.bool_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ConstantKind = &Constant_BoolValue{x != 0}
		return true, err
	case 3: // constant_kind.int64_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ConstantKind = &Constant_Int64Value{int64(x)}
		return true, err
	case 4: // constant_kind.uint64_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.ConstantKind = &Constant_Uint64Value{x}
		return true, err
	case 5: // constant_kind.double_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.ConstantKind = &Constant_DoubleValue{math.Float64frombits(x)}
		return true, err
	case 6: // constant_kind.string_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.ConstantKind = &Constant_StringValue{x}
		return true, err
	case 7: // constant_kind.bytes_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.ConstantKind = &Constant_BytesValue{x}
		return true, err
	case 8: // constant_kind.duration_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(duration.Duration)
		err := b.DecodeMessage(msg)
		m.ConstantKind = &Constant_DurationValue{msg}
		return true, err
	case 9: // constant_kind.timestamp_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(timestamp.Timestamp)
		err := b.DecodeMessage(msg)
		m.ConstantKind = &Constant_TimestampValue{msg}
		return true, err
	default:
		return false, nil
	}
}

func _Constant_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Constant)
	// constant_kind
	switch x := m.ConstantKind.(type) {
	case *Constant_NullValue:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.NullValue))
	case *Constant_BoolValue:
		n += 1 // tag and wire
		n += 1
	case *Constant_Int64Value:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Int64Value))
	case *Constant_Uint64Value:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Uint64Value))
	case *Constant_DoubleValue:
		n += 1 // tag and wire
		n += 8
	case *Constant_StringValue:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.StringValue)))
		n += len(x.StringValue)
	case *Constant_BytesValue:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.BytesValue)))
		n += len(x.BytesValue)
	case *Constant_DurationValue:
		s := proto.Size(x.DurationValue)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *Constant_TimestampValue:
		s := proto.Size(x.TimestampValue)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Source information collected at parse time.
type SourceInfo struct {
	// The syntax version of the source, e.g. `cel1`.
	SyntaxVersion string `protobuf:"bytes,1,opt,name=syntax_version,json=syntaxVersion,proto3" json:"syntax_version,omitempty"`
	// The location name. All position information attached to an expression is
	// relative to this location.
	//
	// The location could be a file, UI element, or similar. For example,
	// `acme/app/AnvilPolicy.cel`.
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Monotonically increasing list of character offsets where newlines appear.
	//
	// The line number of a given position is the index `i` where for a given
	// `id` the `line_offsets[i] < id_positions[id] < line_offsets[i+1]`. The
	// column may be derivd from `id_positions[id] - line_offsets[i]`.
	LineOffsets []int32 `protobuf:"varint,3,rep,packed,name=line_offsets,json=lineOffsets,proto3" json:"line_offsets,omitempty"`
	// A map from the parse node id (e.g. `Expr.id`) to the character offset
	// within source.
	Positions            map[int64]int32 `protobuf:"bytes,4,rep,name=positions,proto3" json:"positions,omitempty" protobuf_key:"varint,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *SourceInfo) Reset()         { *m = SourceInfo{} }
func (m *SourceInfo) String() string { return proto.CompactTextString(m) }
func (*SourceInfo) ProtoMessage()    {}
func (*SourceInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_syntax_467031a7c35e4eba, []int{3}
}
func (m *SourceInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SourceInfo.Unmarshal(m, b)
}
func (m *SourceInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SourceInfo.Marshal(b, m, deterministic)
}
func (dst *SourceInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SourceInfo.Merge(dst, src)
}
func (m *SourceInfo) XXX_Size() int {
	return xxx_messageInfo_SourceInfo.Size(m)
}
func (m *SourceInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SourceInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SourceInfo proto.InternalMessageInfo

func (m *SourceInfo) GetSyntaxVersion() string {
	if m != nil {
		return m.SyntaxVersion
	}
	return ""
}

func (m *SourceInfo) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *SourceInfo) GetLineOffsets() []int32 {
	if m != nil {
		return m.LineOffsets
	}
	return nil
}

func (m *SourceInfo) GetPositions() map[int64]int32 {
	if m != nil {
		return m.Positions
	}
	return nil
}

// A specific position in source.
type SourcePosition struct {
	// The soucre location name (e.g. file name).
	Location string `protobuf:"bytes,1,opt,name=location,proto3" json:"location,omitempty"`
	// The character offset.
	Offset int32 `protobuf:"varint,2,opt,name=offset,proto3" json:"offset,omitempty"`
	// The 1-based index of the starting line in the source text
	// where the issue occurs, or 0 if unknown.
	Line int32 `protobuf:"varint,3,opt,name=line,proto3" json:"line,omitempty"`
	// The 0-based index of the starting position within the line of source text
	// where the issue occurs.  Only meaningful if line is nonzero.
	Column               int32    `protobuf:"varint,4,opt,name=column,proto3" json:"column,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SourcePosition) Reset()         { *m = SourcePosition{} }
func (m *SourcePosition) String() string { return proto.CompactTextString(m) }
func (*SourcePosition) ProtoMessage()    {}
func (*SourcePosition) Descriptor() ([]byte, []int) {
	return fileDescriptor_syntax_467031a7c35e4eba, []int{4}
}
func (m *SourcePosition) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SourcePosition.Unmarshal(m, b)
}
func (m *SourcePosition) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SourcePosition.Marshal(b, m, deterministic)
}
func (dst *SourcePosition) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SourcePosition.Merge(dst, src)
}
func (m *SourcePosition) XXX_Size() int {
	return xxx_messageInfo_SourcePosition.Size(m)
}
func (m *SourcePosition) XXX_DiscardUnknown() {
	xxx_messageInfo_SourcePosition.DiscardUnknown(m)
}

var xxx_messageInfo_SourcePosition proto.InternalMessageInfo

func (m *SourcePosition) GetLocation() string {
	if m != nil {
		return m.Location
	}
	return ""
}

func (m *SourcePosition) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *SourcePosition) GetLine() int32 {
	if m != nil {
		return m.Line
	}
	return 0
}

func (m *SourcePosition) GetColumn() int32 {
	if m != nil {
		return m.Column
	}
	return 0
}

func init() {
	proto.RegisterType((*ParsedExpr)(nil), "google.api.expr.v1alpha1.ParsedExpr")
	proto.RegisterType((*Expr)(nil), "google.api.expr.v1alpha1.Expr")
	proto.RegisterType((*Expr_Ident)(nil), "google.api.expr.v1alpha1.Expr.Ident")
	proto.RegisterType((*Expr_Select)(nil), "google.api.expr.v1alpha1.Expr.Select")
	proto.RegisterType((*Expr_Call)(nil), "google.api.expr.v1alpha1.Expr.Call")
	proto.RegisterType((*Expr_CreateList)(nil), "google.api.expr.v1alpha1.Expr.CreateList")
	proto.RegisterType((*Expr_CreateStruct)(nil), "google.api.expr.v1alpha1.Expr.CreateStruct")
	proto.RegisterType((*Expr_CreateStruct_Entry)(nil), "google.api.expr.v1alpha1.Expr.CreateStruct.Entry")
	proto.RegisterType((*Expr_Comprehension)(nil), "google.api.expr.v1alpha1.Expr.Comprehension")
	proto.RegisterType((*Constant)(nil), "google.api.expr.v1alpha1.Constant")
	proto.RegisterType((*SourceInfo)(nil), "google.api.expr.v1alpha1.SourceInfo")
	proto.RegisterMapType((map[int64]int32)(nil), "google.api.expr.v1alpha1.SourceInfo.PositionsEntry")
	proto.RegisterType((*SourcePosition)(nil), "google.api.expr.v1alpha1.SourcePosition")
}

func init() {
	proto.RegisterFile("google/api/expr/v1alpha1/syntax.proto", fileDescriptor_syntax_467031a7c35e4eba)
}

var fileDescriptor_syntax_467031a7c35e4eba = []byte{
	// 1134 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0xcf, 0x6e, 0x1b, 0xb7,
	0x13, 0xd6, 0xea, 0x9f, 0xb5, 0x23, 0x5b, 0xf9, 0xfd, 0x88, 0xa2, 0x50, 0x36, 0x69, 0xe2, 0x38,
	0x35, 0x90, 0xa2, 0x85, 0x04, 0x3b, 0x41, 0x90, 0xc6, 0xe9, 0x45, 0xae, 0x0b, 0x19, 0x29, 0x1c,
	0x77, 0x5d, 0xf8, 0x50, 0xa0, 0x10, 0xe8, 0x15, 0xa5, 0x2c, 0x4c, 0x91, 0x8b, 0x25, 0xd7, 0xb0,
	0xce, 0x3d, 0xf4, 0xd6, 0x97, 0x69, 0x5f, 0xa0, 0xef, 0xd1, 0x07, 0xe9, 0xa5, 0x40, 0x31, 0x43,
	0xae, 0xfc, 0x0f, 0x86, 0xd4, 0x1b, 0x39, 0xfc, 0xbe, 0x8f, 0xc3, 0x99, 0xe1, 0x90, 0xb0, 0x3d,
	0xd5, 0x7a, 0x2a, 0x45, 0x9f, 0x67, 0x69, 0x5f, 0x5c, 0x66, 0x79, 0xff, 0x62, 0x87, 0xcb, 0xec,
	0x23, 0xdf, 0xe9, 0x9b, 0xb9, 0xb2, 0xfc, 0xb2, 0x97, 0xe5, 0xda, 0x6a, 0xd6, 0x75, 0xb0, 0x1e,
	0xcf, 0xd2, 0x1e, 0xc2, 0x7a, 0x25, 0x2c, 0x7a, 0xe2, 0x05, 0x08, 0x77, 0x56, 0x4c, 0xfa, 0xe3,
	0x22, 0xe7, 0x36, 0xd5, 0xca, 0x31, 0xa3, 0xc7, 0xb7, 0xd7, 0x8d, 0xcd, 0x8b, 0xc4, 0xfa, 0xd5,
	0xa7, 0xb7, 0x57, 0x6d, 0x3a, 0x13, 0xc6, 0xf2, 0x59, 0xe6, 0x00, 0x5b, 0xbf, 0x06, 0x00, 0xc7,
	0x3c, 0x37, 0x62, 0x7c, 0x70, 0x99, 0xe5, 0x6c, 0x17, 0xea, 0xb8, 0x7d, 0xb7, 0xba, 0x19, 0xbc,
	0x68, 0xef, 0x3e, 0xe9, 0xdd, 0xe7, 0x56, 0x0f, 0xd1, 0x31, 0x61, 0xd9, 0x01, 0xb4, 0x8d, 0x2e,
	0xf2, 0x44, 0x8c, 0x52, 0x35, 0xd1, 0xdd, 0x1a, 0x51, 0x3f, 0xbf, 0x9f, 0x7a, 0x42, 0xe0, 0x43,
	0x35, 0xd1, 0x31, 0x98, 0xc5, 0x78, 0xeb, 0xaf, 0x75, 0xa8, 0x93, 0x0f, 0x1d, 0xa8, 0xa6, 0x63,
	0xf2, 0xa0, 0x16, 0x57, 0xd3, 0x31, 0xdb, 0x07, 0x48, 0xb4, 0x32, 0x76, 0x44, 0x9e, 0x39, 0xf9,
	0xad, 0xfb, 0xe5, 0xf7, 0x11, 0xcb, 0x95, 0x1d, 0x56, 0xe2, 0x90, 0x78, 0x07, 0xce, 0x49, 0x48,
	0xc7, 0x42, 0x79, 0x91, 0xfa, 0x32, 0x1f, 0x91, 0xd3, 0x3b, 0x44, 0x02, 0xca, 0x10, 0x93, 0x64,
	0x86, 0xd0, 0x36, 0x42, 0x8a, 0xc4, 0xeb, 0x34, 0x48, 0x67, 0x7b, 0x89, 0xce, 0x09, 0x31, 0x86,
	0x95, 0x18, 0x1c, 0x97, 0x94, 0x06, 0x10, 0x26, 0x5c, 0x4a, 0xa7, 0xd3, 0x24, 0x9d, 0xe7, 0x4b,
	0x74, 0xf6, 0xb9, 0x94, 0xc3, 0x4a, 0xdc, 0x42, 0x9e, 0xf7, 0x26, 0x94, 0x69, 0x19, 0x98, 0x35,
	0xd2, 0xf8, 0x62, 0x99, 0x46, 0x2e, 0xb8, 0x15, 0xdf, 0xa7, 0x06, 0xfd, 0x69, 0x21, 0x9b, 0x94,
	0x8e, 0xa0, 0xed, 0xea, 0xc6, 0x69, 0xb5, 0x48, 0xeb, 0xcb, 0x95, 0xb4, 0x4e, 0x88, 0x47, 0xa7,
	0xa3, 0x11, 0xe9, 0xfd, 0x0c, 0x2c, 0xd1, 0xb3, 0x2c, 0x17, 0x1f, 0x85, 0x32, 0xa9, 0x56, 0x4e,
	0x36, 0x24, 0xd9, 0xaf, 0x96, 0xc9, 0x5e, 0x27, 0x0e, 0x2b, 0xf1, 0xff, 0x6f, 0x28, 0x21, 0x24,
	0x7a, 0x04, 0x0d, 0x4a, 0x0e, 0x63, 0x50, 0x57, 0x7c, 0x26, 0xba, 0xc1, 0x66, 0xf0, 0x22, 0x8c,
	0x69, 0x1c, 0x15, 0xd0, 0x74, 0x11, 0x67, 0x6f, 0x60, 0x4d, 0x67, 0x22, 0xe7, 0x6a, 0x4c, 0x80,
	0xe5, 0x05, 0x5d, 0xc2, 0xd9, 0x27, 0xd0, 0x98, 0xa4, 0x42, 0xba, 0x32, 0x0c, 0x63, 0x37, 0x61,
	0x8f, 0x20, 0xb4, 0xc2, 0xd8, 0x91, 0x56, 0x72, 0x4e, 0x85, 0xd8, 0x8a, 0x5b, 0x68, 0xf8, 0xa0,
	0xe4, 0x3c, 0xfa, 0x2d, 0x80, 0x3a, 0x66, 0x88, 0xbd, 0x86, 0xa6, 0xe5, 0xf9, 0x54, 0xd8, 0x15,
	0x37, 0xf5, 0x68, 0x16, 0x41, 0x6b, 0x52, 0xa8, 0x04, 0xef, 0xb6, 0xdf, 0x76, 0x31, 0xc7, 0x7b,
	0xc9, 0xf3, 0xa9, 0xe9, 0xd6, 0x36, 0x6b, 0xab, 0xdc, 0x4b, 0xc4, 0x46, 0x43, 0x80, 0xab, 0x6c,
	0xb3, 0xb7, 0xd0, 0x12, 0x52, 0xcc, 0x84, 0xb2, 0xa6, 0x1b, 0xac, 0xa4, 0xb2, 0xc0, 0x47, 0x7f,
	0x54, 0x61, 0xfd, 0x7a, 0xb2, 0xd9, 0x33, 0x58, 0x9f, 0x09, 0x63, 0xf8, 0x54, 0x8c, 0xae, 0x85,
	0xbf, 0xed, 0x6d, 0x47, 0x7c, 0x26, 0xd8, 0x7b, 0x58, 0x13, 0xca, 0xe6, 0xa9, 0x30, 0xdd, 0x2a,
	0x6d, 0xb7, 0xf3, 0x1f, 0xaa, 0xa9, 0x77, 0xa0, 0x6c, 0x3e, 0x8f, 0x4b, 0x85, 0xe8, 0xf7, 0x00,
	0x1a, 0x64, 0xf2, 0xcd, 0x21, 0x58, 0x34, 0x87, 0xcf, 0x20, 0xa4, 0xdc, 0x8c, 0xce, 0xc5, 0xdc,
	0x45, 0x0d, 0xeb, 0x9a, 0x4c, 0xef, 0xc5, 0x9c, 0x7d, 0x0d, 0x6b, 0x33, 0x9e, 0xd1, 0x62, 0x6d,
	0x95, 0x64, 0x0c, 0x2b, 0x71, 0x73, 0xc6, 0x33, 0xa4, 0xbe, 0x82, 0xc6, 0x05, 0x97, 0x85, 0xf0,
	0xcd, 0x62, 0x59, 0xb4, 0x1c, 0x78, 0x00, 0xd0, 0x3a, 0x17, 0xf3, 0xd1, 0x79, 0xaa, 0xc6, 0xd1,
	0x3f, 0x55, 0xd8, 0xb8, 0x51, 0xcc, 0xec, 0x21, 0xb4, 0x52, 0x2b, 0xf2, 0xd1, 0x05, 0xcf, 0x7d,
	0xcc, 0xd6, 0x70, 0x7e, 0xca, 0x73, 0xf6, 0x0d, 0x00, 0x2d, 0xe5, 0x5c, 0x4d, 0xc5, 0x8a, 0xfd,
	0x37, 0x44, 0x46, 0x8c, 0x04, 0x54, 0xe6, 0x49, 0x52, 0x90, 0x72, 0xcd, 0x29, 0xe3, 0x1c, 0x95,
	0xf7, 0x20, 0xa4, 0xa5, 0x54, 0xa5, 0x76, 0xc5, 0xc3, 0x90, 0xd6, 0xa1, 0x4a, 0x2d, 0x3b, 0x80,
	0x8e, 0xd4, 0x3a, 0x1b, 0x25, 0x5a, 0x8d, 0x53, 0x2a, 0xcd, 0xc6, 0x4a, 0x0a, 0x1b, 0xc8, 0xda,
	0x2f, 0x49, 0xe8, 0x03, 0xc9, 0x18, 0x2b, 0x32, 0xdf, 0xed, 0x96, 0xfa, 0x80, 0x84, 0x13, 0x2b,
	0x32, 0xbc, 0x50, 0xb9, 0x30, 0x85, 0xb4, 0xbe, 0xc7, 0x2d, 0xbd, 0x50, 0x0e, 0x3d, 0x68, 0x43,
	0x88, 0xab, 0x94, 0x8c, 0xad, 0x3f, 0x6b, 0xd0, 0x2a, 0x9f, 0x06, 0xb6, 0x07, 0xa0, 0x0a, 0x29,
	0x47, 0x2e, 0xc1, 0x98, 0x89, 0xce, 0x6e, 0x54, 0xaa, 0x96, 0x6f, 0x65, 0xef, 0xa8, 0x90, 0xf2,
	0x14, 0x11, 0xf8, 0x06, 0xa8, 0x72, 0xc2, 0x9e, 0x02, 0x9c, 0x69, 0x5d, 0x92, 0x31, 0x53, 0x2d,
	0x04, 0xa0, 0xcd, 0x01, 0x9e, 0x41, 0x3b, 0x55, 0xf6, 0xf5, 0x2b, 0x8f, 0xc0, 0x74, 0xd4, 0xb0,
	0x3f, 0x92, 0xd1, 0x41, 0x9e, 0xc3, 0x7a, 0x71, 0x1d, 0x83, 0x69, 0xa9, 0x0f, 0x2b, 0x71, 0xbb,
	0xb8, 0x09, 0x1a, 0xeb, 0xe2, 0x4c, 0x0a, 0x0f, 0xc2, 0xc8, 0x07, 0x08, 0x72, 0xd6, 0x05, 0xc8,
	0xd8, 0x3c, 0x55, 0x53, 0x0f, 0x6a, 0xfa, 0x3b, 0xd0, 0x76, 0xd6, 0x85, 0x47, 0x67, 0x73, 0x2b,
	0x8c, 0xc7, 0x60, 0x18, 0xd7, 0xd1, 0x23, 0x32, 0x3a, 0xc8, 0x77, 0xd0, 0x29, 0x7f, 0x16, 0x1e,
	0xe5, 0x1e, 0x81, 0x87, 0x77, 0xc2, 0xf2, 0xad, 0x87, 0x0d, 0xaa, 0x5d, 0xf4, 0x66, 0xa3, 0xa4,
	0x39, 0x9d, 0x43, 0x78, 0xb0, 0xf8, 0x63, 0x78, 0x21, 0xd7, 0xf6, 0xef, 0xc6, 0xf7, 0xc7, 0x12,
	0xe7, 0x95, 0x3a, 0x0b, 0x22, 0x49, 0x0d, 0x1e, 0xc0, 0x46, 0xe2, 0x33, 0xe6, 0x72, 0xf8, 0x4b,
	0x15, 0xe0, 0xea, 0xf7, 0xc0, 0xb6, 0xa1, 0xe3, 0x3e, 0x51, 0xa3, 0x0b, 0x91, 0xe3, 0xfd, 0xf2,
	0x77, 0x6a, 0xc3, 0x59, 0x4f, 0x9d, 0x11, 0xfb, 0xaa, 0xd4, 0x09, 0xbf, 0xde, 0x57, 0xcb, 0x39,
	0x36, 0x32, 0x99, 0x2a, 0x31, 0xd2, 0x93, 0x89, 0x11, 0xd6, 0xf5, 0xd7, 0x46, 0xdc, 0x46, 0xdb,
	0x07, 0x67, 0x62, 0x3f, 0x40, 0x98, 0x69, 0x43, 0x65, 0x6c, 0xba, 0x75, 0x6a, 0x65, 0x2f, 0x57,
	0xf9, 0xdc, 0xf4, 0x8e, 0x4b, 0x96, 0x6b, 0x66, 0x57, 0x2a, 0xd1, 0x3b, 0xe8, 0xdc, 0x5c, 0x64,
	0xff, 0x83, 0x1a, 0xf6, 0x28, 0xd7, 0xd7, 0x70, 0x88, 0x2f, 0xd0, 0x55, 0x81, 0x35, 0x7c, 0x7b,
	0x79, 0x5b, 0x7d, 0x13, 0x6c, 0x65, 0xd0, 0x71, 0xbb, 0x94, 0x1a, 0x37, 0x4e, 0x18, 0xdc, 0x3a,
	0xe1, 0xa7, 0xd0, 0x74, 0x87, 0xf3, 0x42, 0x7e, 0x86, 0x2f, 0x27, 0x9e, 0x92, 0xaa, 0xb3, 0x11,
	0xd3, 0x18, 0xb1, 0x89, 0x96, 0xc5, 0x4c, 0x51, 0x3d, 0x36, 0x62, 0x3f, 0x1b, 0x28, 0x78, 0x9c,
	0xe8, 0xd9, 0xbd, 0x87, 0x1e, 0xb4, 0x4f, 0x28, 0xe0, 0xc7, 0x98, 0xd8, 0xe3, 0xe0, 0xa7, 0x77,
	0x1e, 0x38, 0xd5, 0x92, 0xab, 0x69, 0x4f, 0xe7, 0xd3, 0xfe, 0x54, 0x28, 0x4a, 0x7b, 0xdf, 0x2d,
	0xf1, 0x2c, 0x35, 0x77, 0xbf, 0xc4, 0x7b, 0x38, 0xfb, 0x3b, 0x08, 0xce, 0x9a, 0x84, 0x7d, 0xf9,
	0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0d, 0x25, 0xe3, 0xe8, 0x3d, 0x0b, 0x00, 0x00,
}
