// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/bigtable/v1/bigtable_service_messages.proto

package bigtable // import "google.golang.org/genproto/googleapis/bigtable/v1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import status "google.golang.org/genproto/googleapis/rpc/status"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for BigtableServer.ReadRows.
type ReadRowsRequest struct {
	// The unique name of the table from which to read.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// If neither row_key nor row_range is set, reads from all rows.
	//
	// Types that are valid to be assigned to Target:
	//	*ReadRowsRequest_RowKey
	//	*ReadRowsRequest_RowRange
	//	*ReadRowsRequest_RowSet
	Target isReadRowsRequest_Target `protobuf_oneof:"target"`
	// The filter to apply to the contents of the specified row(s). If unset,
	// reads the entire table.
	Filter *RowFilter `protobuf:"bytes,5,opt,name=filter,proto3" json:"filter,omitempty"`
	// By default, rows are read sequentially, producing results which are
	// guaranteed to arrive in increasing row order. Setting
	// "allow_row_interleaving" to true allows multiple rows to be interleaved in
	// the response stream, which increases throughput but breaks this guarantee,
	// and may force the client to use more memory to buffer partially-received
	// rows. Cannot be set to true when specifying "num_rows_limit".
	AllowRowInterleaving bool `protobuf:"varint,6,opt,name=allow_row_interleaving,json=allowRowInterleaving,proto3" json:"allow_row_interleaving,omitempty"`
	// The read will terminate after committing to N rows' worth of results. The
	// default (zero) is to return all results.
	// Note that "allow_row_interleaving" cannot be set to true when this is set.
	NumRowsLimit         int64    `protobuf:"varint,7,opt,name=num_rows_limit,json=numRowsLimit,proto3" json:"num_rows_limit,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ReadRowsRequest) Reset()         { *m = ReadRowsRequest{} }
func (m *ReadRowsRequest) String() string { return proto.CompactTextString(m) }
func (*ReadRowsRequest) ProtoMessage()    {}
func (*ReadRowsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_service_messages_4f7fbb80f2eeca84, []int{0}
}
func (m *ReadRowsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadRowsRequest.Unmarshal(m, b)
}
func (m *ReadRowsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadRowsRequest.Marshal(b, m, deterministic)
}
func (dst *ReadRowsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadRowsRequest.Merge(dst, src)
}
func (m *ReadRowsRequest) XXX_Size() int {
	return xxx_messageInfo_ReadRowsRequest.Size(m)
}
func (m *ReadRowsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadRowsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReadRowsRequest proto.InternalMessageInfo

func (m *ReadRowsRequest) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

type isReadRowsRequest_Target interface {
	isReadRowsRequest_Target()
}

type ReadRowsRequest_RowKey struct {
	RowKey []byte `protobuf:"bytes,2,opt,name=row_key,json=rowKey,proto3,oneof"`
}

type ReadRowsRequest_RowRange struct {
	RowRange *RowRange `protobuf:"bytes,3,opt,name=row_range,json=rowRange,proto3,oneof"`
}

type ReadRowsRequest_RowSet struct {
	RowSet *RowSet `protobuf:"bytes,8,opt,name=row_set,json=rowSet,proto3,oneof"`
}

func (*ReadRowsRequest_RowKey) isReadRowsRequest_Target() {}

func (*ReadRowsRequest_RowRange) isReadRowsRequest_Target() {}

func (*ReadRowsRequest_RowSet) isReadRowsRequest_Target() {}

func (m *ReadRowsRequest) GetTarget() isReadRowsRequest_Target {
	if m != nil {
		return m.Target
	}
	return nil
}

func (m *ReadRowsRequest) GetRowKey() []byte {
	if x, ok := m.GetTarget().(*ReadRowsRequest_RowKey); ok {
		return x.RowKey
	}
	return nil
}

func (m *ReadRowsRequest) GetRowRange() *RowRange {
	if x, ok := m.GetTarget().(*ReadRowsRequest_RowRange); ok {
		return x.RowRange
	}
	return nil
}

func (m *ReadRowsRequest) GetRowSet() *RowSet {
	if x, ok := m.GetTarget().(*ReadRowsRequest_RowSet); ok {
		return x.RowSet
	}
	return nil
}

func (m *ReadRowsRequest) GetFilter() *RowFilter {
	if m != nil {
		return m.Filter
	}
	return nil
}

func (m *ReadRowsRequest) GetAllowRowInterleaving() bool {
	if m != nil {
		return m.AllowRowInterleaving
	}
	return false
}

func (m *ReadRowsRequest) GetNumRowsLimit() int64 {
	if m != nil {
		return m.NumRowsLimit
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ReadRowsRequest) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ReadRowsRequest_OneofMarshaler, _ReadRowsRequest_OneofUnmarshaler, _ReadRowsRequest_OneofSizer, []interface{}{
		(*ReadRowsRequest_RowKey)(nil),
		(*ReadRowsRequest_RowRange)(nil),
		(*ReadRowsRequest_RowSet)(nil),
	}
}

func _ReadRowsRequest_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ReadRowsRequest)
	// target
	switch x := m.Target.(type) {
	case *ReadRowsRequest_RowKey:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.RowKey)
	case *ReadRowsRequest_RowRange:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RowRange); err != nil {
			return err
		}
	case *ReadRowsRequest_RowSet:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RowSet); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("ReadRowsRequest.Target has unexpected type %T", x)
	}
	return nil
}

func _ReadRowsRequest_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ReadRowsRequest)
	switch tag {
	case 2: // target.row_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Target = &ReadRowsRequest_RowKey{x}
		return true, err
	case 3: // target.row_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RowRange)
		err := b.DecodeMessage(msg)
		m.Target = &ReadRowsRequest_RowRange{msg}
		return true, err
	case 8: // target.row_set
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(RowSet)
		err := b.DecodeMessage(msg)
		m.Target = &ReadRowsRequest_RowSet{msg}
		return true, err
	default:
		return false, nil
	}
}

func _ReadRowsRequest_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ReadRowsRequest)
	// target
	switch x := m.Target.(type) {
	case *ReadRowsRequest_RowKey:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.RowKey)))
		n += len(x.RowKey)
	case *ReadRowsRequest_RowRange:
		s := proto.Size(x.RowRange)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ReadRowsRequest_RowSet:
		s := proto.Size(x.RowSet)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for BigtableService.ReadRows.
type ReadRowsResponse struct {
	// The key of the row for which we're receiving data.
	// Results will be received in increasing row key order, unless
	// "allow_row_interleaving" was specified in the request.
	RowKey []byte `protobuf:"bytes,1,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// One or more chunks of the row specified by "row_key".
	Chunks               []*ReadRowsResponse_Chunk `protobuf:"bytes,2,rep,name=chunks,proto3" json:"chunks,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *ReadRowsResponse) Reset()         { *m = ReadRowsResponse{} }
func (m *ReadRowsResponse) String() string { return proto.CompactTextString(m) }
func (*ReadRowsResponse) ProtoMessage()    {}
func (*ReadRowsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_service_messages_4f7fbb80f2eeca84, []int{1}
}
func (m *ReadRowsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadRowsResponse.Unmarshal(m, b)
}
func (m *ReadRowsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadRowsResponse.Marshal(b, m, deterministic)
}
func (dst *ReadRowsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadRowsResponse.Merge(dst, src)
}
func (m *ReadRowsResponse) XXX_Size() int {
	return xxx_messageInfo_ReadRowsResponse.Size(m)
}
func (m *ReadRowsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadRowsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ReadRowsResponse proto.InternalMessageInfo

func (m *ReadRowsResponse) GetRowKey() []byte {
	if m != nil {
		return m.RowKey
	}
	return nil
}

func (m *ReadRowsResponse) GetChunks() []*ReadRowsResponse_Chunk {
	if m != nil {
		return m.Chunks
	}
	return nil
}

// Specifies a piece of a row's contents returned as part of the read
// response stream.
type ReadRowsResponse_Chunk struct {
	// Types that are valid to be assigned to Chunk:
	//	*ReadRowsResponse_Chunk_RowContents
	//	*ReadRowsResponse_Chunk_ResetRow
	//	*ReadRowsResponse_Chunk_CommitRow
	Chunk                isReadRowsResponse_Chunk_Chunk `protobuf_oneof:"chunk"`
	XXX_NoUnkeyedLiteral struct{}                       `json:"-"`
	XXX_unrecognized     []byte                         `json:"-"`
	XXX_sizecache        int32                          `json:"-"`
}

func (m *ReadRowsResponse_Chunk) Reset()         { *m = ReadRowsResponse_Chunk{} }
func (m *ReadRowsResponse_Chunk) String() string { return proto.CompactTextString(m) }
func (*ReadRowsResponse_Chunk) ProtoMessage()    {}
func (*ReadRowsResponse_Chunk) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_service_messages_4f7fbb80f2eeca84, []int{1, 0}
}
func (m *ReadRowsResponse_Chunk) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadRowsResponse_Chunk.Unmarshal(m, b)
}
func (m *ReadRowsResponse_Chunk) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadRowsResponse_Chunk.Marshal(b, m, deterministic)
}
func (dst *ReadRowsResponse_Chunk) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadRowsResponse_Chunk.Merge(dst, src)
}
func (m *ReadRowsResponse_Chunk) XXX_Size() int {
	return xxx_messageInfo_ReadRowsResponse_Chunk.Size(m)
}
func (m *ReadRowsResponse_Chunk) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadRowsResponse_Chunk.DiscardUnknown(m)
}

var xxx_messageInfo_ReadRowsResponse_Chunk proto.InternalMessageInfo

type isReadRowsResponse_Chunk_Chunk interface {
	isReadRowsResponse_Chunk_Chunk()
}

type ReadRowsResponse_Chunk_RowContents struct {
	RowContents *Family `protobuf:"bytes,1,opt,name=row_contents,json=rowContents,proto3,oneof"`
}

type ReadRowsResponse_Chunk_ResetRow struct {
	ResetRow bool `protobuf:"varint,2,opt,name=reset_row,json=resetRow,proto3,oneof"`
}

type ReadRowsResponse_Chunk_CommitRow struct {
	CommitRow bool `protobuf:"varint,3,opt,name=commit_row,json=commitRow,proto3,oneof"`
}

func (*ReadRowsResponse_Chunk_RowContents) isReadRowsResponse_Chunk_Chunk() {}

func (*ReadRowsResponse_Chunk_ResetRow) isReadRowsResponse_Chunk_Chunk() {}

func (*ReadRowsResponse_Chunk_CommitRow) isReadRowsResponse_Chunk_Chunk() {}

func (m *ReadRowsResponse_Chunk) GetChunk() isReadRowsResponse_Chunk_Chunk {
	if m != nil {
		return m.Chunk
	}
	return nil
}

func (m *ReadRowsResponse_Chunk) GetRowContents() *Family {
	if x, ok := m.GetChunk().(*ReadRowsResponse_Chunk_RowContents); ok {
		return x.RowContents
	}
	return nil
}

func (m *ReadRowsResponse_Chunk) GetResetRow() bool {
	if x, ok := m.GetChunk().(*ReadRowsResponse_Chunk_ResetRow); ok {
		return x.ResetRow
	}
	return false
}

func (m *ReadRowsResponse_Chunk) GetCommitRow() bool {
	if x, ok := m.GetChunk().(*ReadRowsResponse_Chunk_CommitRow); ok {
		return x.CommitRow
	}
	return false
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ReadRowsResponse_Chunk) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ReadRowsResponse_Chunk_OneofMarshaler, _ReadRowsResponse_Chunk_OneofUnmarshaler, _ReadRowsResponse_Chunk_OneofSizer, []interface{}{
		(*ReadRowsResponse_Chunk_RowContents)(nil),
		(*ReadRowsResponse_Chunk_ResetRow)(nil),
		(*ReadRowsResponse_Chunk_CommitRow)(nil),
	}
}

func _ReadRowsResponse_Chunk_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ReadRowsResponse_Chunk)
	// chunk
	switch x := m.Chunk.(type) {
	case *ReadRowsResponse_Chunk_RowContents:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.RowContents); err != nil {
			return err
		}
	case *ReadRowsResponse_Chunk_ResetRow:
		t := uint64(0)
		if x.ResetRow {
			t = 1
		}
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *ReadRowsResponse_Chunk_CommitRow:
		t := uint64(0)
		if x.CommitRow {
			t = 1
		}
		b.EncodeVarint(3<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case nil:
	default:
		return fmt.Errorf("ReadRowsResponse_Chunk.Chunk has unexpected type %T", x)
	}
	return nil
}

func _ReadRowsResponse_Chunk_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ReadRowsResponse_Chunk)
	switch tag {
	case 1: // chunk.row_contents
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(Family)
		err := b.DecodeMessage(msg)
		m.Chunk = &ReadRowsResponse_Chunk_RowContents{msg}
		return true, err
	case 2: // chunk.reset_row
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Chunk = &ReadRowsResponse_Chunk_ResetRow{x != 0}
		return true, err
	case 3: // chunk.commit_row
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Chunk = &ReadRowsResponse_Chunk_CommitRow{x != 0}
		return true, err
	default:
		return false, nil
	}
}

func _ReadRowsResponse_Chunk_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ReadRowsResponse_Chunk)
	// chunk
	switch x := m.Chunk.(type) {
	case *ReadRowsResponse_Chunk_RowContents:
		s := proto.Size(x.RowContents)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *ReadRowsResponse_Chunk_ResetRow:
		n += 1 // tag and wire
		n += 1
	case *ReadRowsResponse_Chunk_CommitRow:
		n += 1 // tag and wire
		n += 1
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Request message for BigtableService.SampleRowKeys.
type SampleRowKeysRequest struct {
	// The unique name of the table from which to sample row keys.
	TableName            string   `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SampleRowKeysRequest) Reset()         { *m = SampleRowKeysRequest{} }
func (m *SampleRowKeysRequest) String() string { return proto.CompactTextString(m) }
func (*SampleRowKeysRequest) ProtoMessage()    {}
func (*SampleRowKeysRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_service_messages_4f7fbb80f2eeca84, []int{2}
}
func (m *SampleRowKeysRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SampleRowKeysRequest.Unmarshal(m, b)
}
func (m *SampleRowKeysRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SampleRowKeysRequest.Marshal(b, m, deterministic)
}
func (dst *SampleRowKeysRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SampleRowKeysRequest.Merge(dst, src)
}
func (m *SampleRowKeysRequest) XXX_Size() int {
	return xxx_messageInfo_SampleRowKeysRequest.Size(m)
}
func (m *SampleRowKeysRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SampleRowKeysRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SampleRowKeysRequest proto.InternalMessageInfo

func (m *SampleRowKeysRequest) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

// Response message for BigtableService.SampleRowKeys.
type SampleRowKeysResponse struct {
	// Sorted streamed sequence of sample row keys in the table. The table might
	// have contents before the first row key in the list and after the last one,
	// but a key containing the empty string indicates "end of table" and will be
	// the last response given, if present.
	// Note that row keys in this list may not have ever been written to or read
	// from, and users should therefore not make any assumptions about the row key
	// structure that are specific to their use case.
	RowKey []byte `protobuf:"bytes,1,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Approximate total storage space used by all rows in the table which precede
	// "row_key". Buffering the contents of all rows between two subsequent
	// samples would require space roughly equal to the difference in their
	// "offset_bytes" fields.
	OffsetBytes          int64    `protobuf:"varint,2,opt,name=offset_bytes,json=offsetBytes,proto3" json:"offset_bytes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SampleRowKeysResponse) Reset()         { *m = SampleRowKeysResponse{} }
func (m *SampleRowKeysResponse) String() string { return proto.CompactTextString(m) }
func (*SampleRowKeysResponse) ProtoMessage()    {}
func (*SampleRowKeysResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_service_messages_4f7fbb80f2eeca84, []int{3}
}
func (m *SampleRowKeysResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SampleRowKeysResponse.Unmarshal(m, b)
}
func (m *SampleRowKeysResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SampleRowKeysResponse.Marshal(b, m, deterministic)
}
func (dst *SampleRowKeysResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SampleRowKeysResponse.Merge(dst, src)
}
func (m *SampleRowKeysResponse) XXX_Size() int {
	return xxx_messageInfo_SampleRowKeysResponse.Size(m)
}
func (m *SampleRowKeysResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SampleRowKeysResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SampleRowKeysResponse proto.InternalMessageInfo

func (m *SampleRowKeysResponse) GetRowKey() []byte {
	if m != nil {
		return m.RowKey
	}
	return nil
}

func (m *SampleRowKeysResponse) GetOffsetBytes() int64 {
	if m != nil {
		return m.OffsetBytes
	}
	return 0
}

// Request message for BigtableService.MutateRow.
type MutateRowRequest struct {
	// The unique name of the table to which the mutation should be applied.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// The key of the row to which the mutation should be applied.
	RowKey []byte `protobuf:"bytes,2,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Changes to be atomically applied to the specified row. Entries are applied
	// in order, meaning that earlier mutations can be masked by later ones.
	// Must contain at least one entry and at most 100000.
	Mutations            []*Mutation `protobuf:"bytes,3,rep,name=mutations,proto3" json:"mutations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *MutateRowRequest) Reset()         { *m = MutateRowRequest{} }
func (m *MutateRowRequest) String() string { return proto.CompactTextString(m) }
func (*MutateRowRequest) ProtoMessage()    {}
func (*MutateRowRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_service_messages_4f7fbb80f2eeca84, []int{4}
}
func (m *MutateRowRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateRowRequest.Unmarshal(m, b)
}
func (m *MutateRowRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateRowRequest.Marshal(b, m, deterministic)
}
func (dst *MutateRowRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateRowRequest.Merge(dst, src)
}
func (m *MutateRowRequest) XXX_Size() int {
	return xxx_messageInfo_MutateRowRequest.Size(m)
}
func (m *MutateRowRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateRowRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateRowRequest proto.InternalMessageInfo

func (m *MutateRowRequest) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

func (m *MutateRowRequest) GetRowKey() []byte {
	if m != nil {
		return m.RowKey
	}
	return nil
}

func (m *MutateRowRequest) GetMutations() []*Mutation {
	if m != nil {
		return m.Mutations
	}
	return nil
}

// Request message for BigtableService.MutateRows.
type MutateRowsRequest struct {
	// The unique name of the table to which the mutations should be applied.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// The row keys/mutations to be applied in bulk.
	// Each entry is applied as an atomic mutation, but the entries may be
	// applied in arbitrary order (even between entries for the same row).
	// At least one entry must be specified, and in total the entries may
	// contain at most 100000 mutations.
	Entries              []*MutateRowsRequest_Entry `protobuf:"bytes,2,rep,name=entries,proto3" json:"entries,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                   `json:"-"`
	XXX_unrecognized     []byte                     `json:"-"`
	XXX_sizecache        int32                      `json:"-"`
}

func (m *MutateRowsRequest) Reset()         { *m = MutateRowsRequest{} }
func (m *MutateRowsRequest) String() string { return proto.CompactTextString(m) }
func (*MutateRowsRequest) ProtoMessage()    {}
func (*MutateRowsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_service_messages_4f7fbb80f2eeca84, []int{5}
}
func (m *MutateRowsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateRowsRequest.Unmarshal(m, b)
}
func (m *MutateRowsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateRowsRequest.Marshal(b, m, deterministic)
}
func (dst *MutateRowsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateRowsRequest.Merge(dst, src)
}
func (m *MutateRowsRequest) XXX_Size() int {
	return xxx_messageInfo_MutateRowsRequest.Size(m)
}
func (m *MutateRowsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateRowsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateRowsRequest proto.InternalMessageInfo

func (m *MutateRowsRequest) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

func (m *MutateRowsRequest) GetEntries() []*MutateRowsRequest_Entry {
	if m != nil {
		return m.Entries
	}
	return nil
}

type MutateRowsRequest_Entry struct {
	// The key of the row to which the `mutations` should be applied.
	RowKey []byte `protobuf:"bytes,1,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Changes to be atomically applied to the specified row. Mutations are
	// applied in order, meaning that earlier mutations can be masked by
	// later ones.
	// At least one mutation must be specified.
	Mutations            []*Mutation `protobuf:"bytes,2,rep,name=mutations,proto3" json:"mutations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *MutateRowsRequest_Entry) Reset()         { *m = MutateRowsRequest_Entry{} }
func (m *MutateRowsRequest_Entry) String() string { return proto.CompactTextString(m) }
func (*MutateRowsRequest_Entry) ProtoMessage()    {}
func (*MutateRowsRequest_Entry) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_service_messages_4f7fbb80f2eeca84, []int{5, 0}
}
func (m *MutateRowsRequest_Entry) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateRowsRequest_Entry.Unmarshal(m, b)
}
func (m *MutateRowsRequest_Entry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateRowsRequest_Entry.Marshal(b, m, deterministic)
}
func (dst *MutateRowsRequest_Entry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateRowsRequest_Entry.Merge(dst, src)
}
func (m *MutateRowsRequest_Entry) XXX_Size() int {
	return xxx_messageInfo_MutateRowsRequest_Entry.Size(m)
}
func (m *MutateRowsRequest_Entry) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateRowsRequest_Entry.DiscardUnknown(m)
}

var xxx_messageInfo_MutateRowsRequest_Entry proto.InternalMessageInfo

func (m *MutateRowsRequest_Entry) GetRowKey() []byte {
	if m != nil {
		return m.RowKey
	}
	return nil
}

func (m *MutateRowsRequest_Entry) GetMutations() []*Mutation {
	if m != nil {
		return m.Mutations
	}
	return nil
}

// Response message for BigtableService.MutateRows.
type MutateRowsResponse struct {
	// The results for each Entry from the request, presented in the order
	// in which the entries were originally given.
	// Depending on how requests are batched during execution, it is possible
	// for one Entry to fail due to an error with another Entry. In the event
	// that this occurs, the same error will be reported for both entries.
	Statuses             []*status.Status `protobuf:"bytes,1,rep,name=statuses,proto3" json:"statuses,omitempty"`
	XXX_NoUnkeyedLiteral struct{}         `json:"-"`
	XXX_unrecognized     []byte           `json:"-"`
	XXX_sizecache        int32            `json:"-"`
}

func (m *MutateRowsResponse) Reset()         { *m = MutateRowsResponse{} }
func (m *MutateRowsResponse) String() string { return proto.CompactTextString(m) }
func (*MutateRowsResponse) ProtoMessage()    {}
func (*MutateRowsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_service_messages_4f7fbb80f2eeca84, []int{6}
}
func (m *MutateRowsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateRowsResponse.Unmarshal(m, b)
}
func (m *MutateRowsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateRowsResponse.Marshal(b, m, deterministic)
}
func (dst *MutateRowsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateRowsResponse.Merge(dst, src)
}
func (m *MutateRowsResponse) XXX_Size() int {
	return xxx_messageInfo_MutateRowsResponse.Size(m)
}
func (m *MutateRowsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateRowsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateRowsResponse proto.InternalMessageInfo

func (m *MutateRowsResponse) GetStatuses() []*status.Status {
	if m != nil {
		return m.Statuses
	}
	return nil
}

// Request message for BigtableService.CheckAndMutateRowRequest
type CheckAndMutateRowRequest struct {
	// The unique name of the table to which the conditional mutation should be
	// applied.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// The key of the row to which the conditional mutation should be applied.
	RowKey []byte `protobuf:"bytes,2,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// The filter to be applied to the contents of the specified row. Depending
	// on whether or not any results are yielded, either "true_mutations" or
	// "false_mutations" will be executed. If unset, checks that the row contains
	// any values at all.
	PredicateFilter *RowFilter `protobuf:"bytes,6,opt,name=predicate_filter,json=predicateFilter,proto3" json:"predicate_filter,omitempty"`
	// Changes to be atomically applied to the specified row if "predicate_filter"
	// yields at least one cell when applied to "row_key". Entries are applied in
	// order, meaning that earlier mutations can be masked by later ones.
	// Must contain at least one entry if "false_mutations" is empty, and at most
	// 100000.
	TrueMutations []*Mutation `protobuf:"bytes,4,rep,name=true_mutations,json=trueMutations,proto3" json:"true_mutations,omitempty"`
	// Changes to be atomically applied to the specified row if "predicate_filter"
	// does not yield any cells when applied to "row_key". Entries are applied in
	// order, meaning that earlier mutations can be masked by later ones.
	// Must contain at least one entry if "true_mutations" is empty, and at most
	// 100000.
	FalseMutations       []*Mutation `protobuf:"bytes,5,rep,name=false_mutations,json=falseMutations,proto3" json:"false_mutations,omitempty"`
	XXX_NoUnkeyedLiteral struct{}    `json:"-"`
	XXX_unrecognized     []byte      `json:"-"`
	XXX_sizecache        int32       `json:"-"`
}

func (m *CheckAndMutateRowRequest) Reset()         { *m = CheckAndMutateRowRequest{} }
func (m *CheckAndMutateRowRequest) String() string { return proto.CompactTextString(m) }
func (*CheckAndMutateRowRequest) ProtoMessage()    {}
func (*CheckAndMutateRowRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_service_messages_4f7fbb80f2eeca84, []int{7}
}
func (m *CheckAndMutateRowRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckAndMutateRowRequest.Unmarshal(m, b)
}
func (m *CheckAndMutateRowRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckAndMutateRowRequest.Marshal(b, m, deterministic)
}
func (dst *CheckAndMutateRowRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckAndMutateRowRequest.Merge(dst, src)
}
func (m *CheckAndMutateRowRequest) XXX_Size() int {
	return xxx_messageInfo_CheckAndMutateRowRequest.Size(m)
}
func (m *CheckAndMutateRowRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckAndMutateRowRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckAndMutateRowRequest proto.InternalMessageInfo

func (m *CheckAndMutateRowRequest) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

func (m *CheckAndMutateRowRequest) GetRowKey() []byte {
	if m != nil {
		return m.RowKey
	}
	return nil
}

func (m *CheckAndMutateRowRequest) GetPredicateFilter() *RowFilter {
	if m != nil {
		return m.PredicateFilter
	}
	return nil
}

func (m *CheckAndMutateRowRequest) GetTrueMutations() []*Mutation {
	if m != nil {
		return m.TrueMutations
	}
	return nil
}

func (m *CheckAndMutateRowRequest) GetFalseMutations() []*Mutation {
	if m != nil {
		return m.FalseMutations
	}
	return nil
}

// Response message for BigtableService.CheckAndMutateRowRequest.
type CheckAndMutateRowResponse struct {
	// Whether or not the request's "predicate_filter" yielded any results for
	// the specified row.
	PredicateMatched     bool     `protobuf:"varint,1,opt,name=predicate_matched,json=predicateMatched,proto3" json:"predicate_matched,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckAndMutateRowResponse) Reset()         { *m = CheckAndMutateRowResponse{} }
func (m *CheckAndMutateRowResponse) String() string { return proto.CompactTextString(m) }
func (*CheckAndMutateRowResponse) ProtoMessage()    {}
func (*CheckAndMutateRowResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_service_messages_4f7fbb80f2eeca84, []int{8}
}
func (m *CheckAndMutateRowResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckAndMutateRowResponse.Unmarshal(m, b)
}
func (m *CheckAndMutateRowResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckAndMutateRowResponse.Marshal(b, m, deterministic)
}
func (dst *CheckAndMutateRowResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckAndMutateRowResponse.Merge(dst, src)
}
func (m *CheckAndMutateRowResponse) XXX_Size() int {
	return xxx_messageInfo_CheckAndMutateRowResponse.Size(m)
}
func (m *CheckAndMutateRowResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckAndMutateRowResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckAndMutateRowResponse proto.InternalMessageInfo

func (m *CheckAndMutateRowResponse) GetPredicateMatched() bool {
	if m != nil {
		return m.PredicateMatched
	}
	return false
}

// Request message for BigtableService.ReadModifyWriteRowRequest.
type ReadModifyWriteRowRequest struct {
	// The unique name of the table to which the read/modify/write rules should be
	// applied.
	TableName string `protobuf:"bytes,1,opt,name=table_name,json=tableName,proto3" json:"table_name,omitempty"`
	// The key of the row to which the read/modify/write rules should be applied.
	RowKey []byte `protobuf:"bytes,2,opt,name=row_key,json=rowKey,proto3" json:"row_key,omitempty"`
	// Rules specifying how the specified row's contents are to be transformed
	// into writes. Entries are applied in order, meaning that earlier rules will
	// affect the results of later ones.
	Rules                []*ReadModifyWriteRule `protobuf:"bytes,3,rep,name=rules,proto3" json:"rules,omitempty"`
	XXX_NoUnkeyedLiteral struct{}               `json:"-"`
	XXX_unrecognized     []byte                 `json:"-"`
	XXX_sizecache        int32                  `json:"-"`
}

func (m *ReadModifyWriteRowRequest) Reset()         { *m = ReadModifyWriteRowRequest{} }
func (m *ReadModifyWriteRowRequest) String() string { return proto.CompactTextString(m) }
func (*ReadModifyWriteRowRequest) ProtoMessage()    {}
func (*ReadModifyWriteRowRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_bigtable_service_messages_4f7fbb80f2eeca84, []int{9}
}
func (m *ReadModifyWriteRowRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ReadModifyWriteRowRequest.Unmarshal(m, b)
}
func (m *ReadModifyWriteRowRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ReadModifyWriteRowRequest.Marshal(b, m, deterministic)
}
func (dst *ReadModifyWriteRowRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ReadModifyWriteRowRequest.Merge(dst, src)
}
func (m *ReadModifyWriteRowRequest) XXX_Size() int {
	return xxx_messageInfo_ReadModifyWriteRowRequest.Size(m)
}
func (m *ReadModifyWriteRowRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ReadModifyWriteRowRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ReadModifyWriteRowRequest proto.InternalMessageInfo

func (m *ReadModifyWriteRowRequest) GetTableName() string {
	if m != nil {
		return m.TableName
	}
	return ""
}

func (m *ReadModifyWriteRowRequest) GetRowKey() []byte {
	if m != nil {
		return m.RowKey
	}
	return nil
}

func (m *ReadModifyWriteRowRequest) GetRules() []*ReadModifyWriteRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func init() {
	proto.RegisterType((*ReadRowsRequest)(nil), "google.bigtable.v1.ReadRowsRequest")
	proto.RegisterType((*ReadRowsResponse)(nil), "google.bigtable.v1.ReadRowsResponse")
	proto.RegisterType((*ReadRowsResponse_Chunk)(nil), "google.bigtable.v1.ReadRowsResponse.Chunk")
	proto.RegisterType((*SampleRowKeysRequest)(nil), "google.bigtable.v1.SampleRowKeysRequest")
	proto.RegisterType((*SampleRowKeysResponse)(nil), "google.bigtable.v1.SampleRowKeysResponse")
	proto.RegisterType((*MutateRowRequest)(nil), "google.bigtable.v1.MutateRowRequest")
	proto.RegisterType((*MutateRowsRequest)(nil), "google.bigtable.v1.MutateRowsRequest")
	proto.RegisterType((*MutateRowsRequest_Entry)(nil), "google.bigtable.v1.MutateRowsRequest.Entry")
	proto.RegisterType((*MutateRowsResponse)(nil), "google.bigtable.v1.MutateRowsResponse")
	proto.RegisterType((*CheckAndMutateRowRequest)(nil), "google.bigtable.v1.CheckAndMutateRowRequest")
	proto.RegisterType((*CheckAndMutateRowResponse)(nil), "google.bigtable.v1.CheckAndMutateRowResponse")
	proto.RegisterType((*ReadModifyWriteRowRequest)(nil), "google.bigtable.v1.ReadModifyWriteRowRequest")
}

func init() {
	proto.RegisterFile("google/bigtable/v1/bigtable_service_messages.proto", fileDescriptor_bigtable_service_messages_4f7fbb80f2eeca84)
}

var fileDescriptor_bigtable_service_messages_4f7fbb80f2eeca84 = []byte{
	// 788 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x55, 0x5f, 0x8b, 0x23, 0x45,
	0x10, 0xdf, 0x49, 0xcc, 0xbf, 0x4a, 0xdc, 0xdd, 0x6b, 0xce, 0xdb, 0xd9, 0x70, 0x8b, 0x71, 0x10,
	0x0d, 0x1e, 0x4c, 0xb8, 0xd5, 0x7d, 0xb9, 0x43, 0xc4, 0xc4, 0x3d, 0x22, 0x1a, 0x39, 0x3a, 0x0f,
	0x82, 0x08, 0xa1, 0x33, 0xa9, 0xcc, 0x0e, 0x3b, 0xd3, 0x1d, 0xbb, 0x7b, 0x32, 0xe4, 0x59, 0xf0,
	0x5d, 0x3f, 0x85, 0xdf, 0xc8, 0x17, 0x3f, 0x8c, 0x74, 0xcf, 0xe4, 0x8f, 0x6b, 0xa2, 0x11, 0xf6,
	0xad, 0xa7, 0xaa, 0x7e, 0xbf, 0xaa, 0xfa, 0x75, 0x4d, 0x17, 0x5c, 0x87, 0x42, 0x84, 0x31, 0xf6,
	0xa6, 0x51, 0xa8, 0xd9, 0x34, 0xc6, 0xde, 0xf2, 0xe5, 0xe6, 0x3c, 0x51, 0x28, 0x97, 0x51, 0x80,
	0x93, 0x04, 0x95, 0x62, 0x21, 0x2a, 0x7f, 0x21, 0x85, 0x16, 0x84, 0xe4, 0x18, 0x7f, 0x1d, 0xe7,
	0x2f, 0x5f, 0xb6, 0x3f, 0xfa, 0x37, 0x9e, 0x19, 0xd3, 0x2c, 0xc7, 0xb6, 0x2f, 0x8a, 0x38, 0xb9,
	0x08, 0x7a, 0x4a, 0x33, 0x9d, 0x16, 0xa4, 0xde, 0x9f, 0x25, 0x38, 0xa3, 0xc8, 0x66, 0x54, 0x64,
	0x8a, 0xe2, 0x4f, 0x29, 0x2a, 0x4d, 0xae, 0x00, 0x72, 0x02, 0xce, 0x12, 0x74, 0x9d, 0x8e, 0xd3,
	0x6d, 0xd0, 0x86, 0xb5, 0x7c, 0xc7, 0x12, 0x24, 0x97, 0x50, 0x93, 0x22, 0x9b, 0xdc, 0xe3, 0xca,
	0x2d, 0x75, 0x9c, 0x6e, 0x6b, 0x78, 0x42, 0xab, 0x52, 0x64, 0xdf, 0xe0, 0x8a, 0xbc, 0x86, 0x86,
	0x71, 0x49, 0xc6, 0x43, 0x74, 0xcb, 0x1d, 0xa7, 0xdb, 0xbc, 0x7e, 0xee, 0xff, 0xb3, 0x6c, 0x9f,
	0x8a, 0x8c, 0x9a, 0x98, 0xe1, 0x09, 0xad, 0xcb, 0xe2, 0x4c, 0x6e, 0x72, 0x5e, 0x85, 0xda, 0xad,
	0x5b, 0x68, 0xfb, 0x00, 0x74, 0x8c, 0xba, 0xc8, 0x39, 0x46, 0x4d, 0x6e, 0xa0, 0x3a, 0x8f, 0x62,
	0x8d, 0xd2, 0xad, 0x58, 0xd4, 0xd5, 0x01, 0xd4, 0x1b, 0x1b, 0x44, 0x8b, 0x60, 0xf2, 0x19, 0x3c,
	0x63, 0x71, 0x6c, 0x8a, 0x15, 0xd9, 0x24, 0xe2, 0x1a, 0x65, 0x8c, 0x6c, 0x19, 0xf1, 0xd0, 0xad,
	0x76, 0x9c, 0x6e, 0x9d, 0x3e, 0xb5, 0x5e, 0x2a, 0xb2, 0xaf, 0x77, 0x7c, 0xe4, 0x43, 0x38, 0xe5,
	0x69, 0x62, 0x30, 0x6a, 0x12, 0x47, 0x49, 0xa4, 0xdd, 0x5a, 0xc7, 0xe9, 0x96, 0x69, 0x8b, 0xa7,
	0x89, 0x91, 0xf0, 0x5b, 0x63, 0xeb, 0xd7, 0xa1, 0xaa, 0x99, 0x0c, 0x51, 0x7b, 0x3f, 0x97, 0xe0,
	0x7c, 0x2b, 0xaf, 0x5a, 0x08, 0xae, 0x90, 0x5c, 0x6c, 0x05, 0x34, 0xe2, 0xb6, 0x36, 0xf2, 0xf5,
	0xa1, 0x1a, 0xdc, 0xa5, 0xfc, 0x5e, 0xb9, 0xa5, 0x4e, 0xb9, 0xdb, 0xbc, 0xfe, 0x64, 0x6f, 0x2b,
	0x0f, 0xe8, 0xfc, 0x81, 0x81, 0xd0, 0x02, 0xd9, 0xfe, 0xd5, 0x81, 0x8a, 0xb5, 0x90, 0x2f, 0xa0,
	0x65, 0xd2, 0x04, 0x82, 0x6b, 0xe4, 0x5a, 0xd9, 0x5c, 0x07, 0x44, 0x7d, 0xc3, 0x92, 0x28, 0x5e,
	0x0d, 0x4f, 0x68, 0x53, 0x8a, 0x6c, 0x50, 0x00, 0xc8, 0x15, 0x34, 0x24, 0x2a, 0xd4, 0xa6, 0x5d,
	0x7b, 0xd5, 0x75, 0x7b, 0x5f, 0xc6, 0x44, 0x45, 0x46, 0xde, 0x07, 0x08, 0x44, 0x92, 0x44, 0xb9,
	0xbf, 0x5c, 0xf8, 0x1b, 0xb9, 0x8d, 0x8a, 0xac, 0x5f, 0x83, 0x8a, 0x2d, 0xca, 0xbb, 0x81, 0xa7,
	0x63, 0x96, 0x2c, 0x62, 0xa4, 0xb6, 0xcf, 0x23, 0x07, 0xcd, 0x1b, 0xc3, 0x7b, 0x0f, 0x60, 0xff,
	0x25, 0xe0, 0x07, 0xd0, 0x12, 0xf3, 0xb9, 0x29, 0x79, 0xba, 0xd2, 0xa8, 0x6c, 0xd1, 0x65, 0xda,
	0xcc, 0x6d, 0x7d, 0x63, 0xf2, 0x7e, 0x71, 0xe0, 0x7c, 0x94, 0x6a, 0xa6, 0x0d, 0xeb, 0x91, 0x13,
	0x7f, 0xf1, 0x60, 0xe2, 0x37, 0xf9, 0x5e, 0x41, 0x23, 0x31, 0x5c, 0x91, 0xe0, 0xca, 0x2d, 0xdb,
	0x3b, 0xdb, 0x3b, 0xef, 0xa3, 0x22, 0x88, 0x6e, 0xc3, 0xbd, 0x3f, 0x1c, 0x78, 0xb2, 0x29, 0xe4,
	0xd8, 0x7f, 0xef, 0x16, 0x6a, 0xc8, 0xb5, 0x8c, 0x70, 0x3d, 0x22, 0x2f, 0x0e, 0xa6, 0xdb, 0xa5,
	0xf5, 0x6f, 0xb9, 0x96, 0x2b, 0xba, 0xc6, 0xb6, 0x7f, 0x84, 0x8a, 0xb5, 0x1c, 0x56, 0xf2, 0x6f,
	0x9d, 0x95, 0xfe, 0x5f, 0x67, 0x5f, 0x01, 0xd9, 0xad, 0xa0, 0xb8, 0x34, 0x1f, 0xea, 0xf9, 0xcb,
	0x83, 0x66, 0x14, 0x0d, 0x21, 0x59, 0x13, 0xca, 0x45, 0xe0, 0x8f, 0xad, 0x8f, 0x6e, 0x62, 0xbc,
	0xdf, 0x4b, 0xe0, 0x0e, 0xee, 0x30, 0xb8, 0xff, 0x92, 0xcf, 0x1e, 0xed, 0xc2, 0x86, 0x70, 0xbe,
	0x90, 0x38, 0x8b, 0x02, 0xa6, 0x71, 0x52, 0x3c, 0x1b, 0xd5, 0x63, 0x9e, 0x8d, 0xb3, 0x0d, 0x2c,
	0x37, 0x90, 0x01, 0x9c, 0x6a, 0x99, 0xe2, 0x64, 0xab, 0xd2, 0x3b, 0x47, 0xa8, 0xf4, 0xae, 0xc1,
	0xac, 0xbf, 0x14, 0xb9, 0x85, 0xb3, 0x39, 0x8b, 0xd5, 0x2e, 0x4b, 0xe5, 0x08, 0x96, 0x53, 0x0b,
	0xda, 0xd0, 0x78, 0x43, 0xb8, 0xdc, 0xa3, 0x54, 0xa1, 0xfb, 0x0b, 0x78, 0xb2, 0x6d, 0x39, 0x61,
	0x3a, 0xb8, 0xc3, 0x99, 0x55, 0xac, 0x4e, 0xb7, 0x5a, 0x8c, 0x72, 0xbb, 0xf7, 0x9b, 0x03, 0x97,
	0xe6, 0x81, 0x19, 0x89, 0x59, 0x34, 0x5f, 0x7d, 0x2f, 0xa3, 0x47, 0x51, 0xfd, 0x73, 0xa8, 0xc8,
	0x34, 0xc6, 0xf5, 0x2f, 0xf2, 0xf1, 0xa1, 0x67, 0x6d, 0x37, 0x6b, 0x1a, 0x23, 0xcd, 0x51, 0x7d,
	0x0d, 0xcf, 0x02, 0x91, 0xec, 0x01, 0xf5, 0x9f, 0xf7, 0x8b, 0x8f, 0x71, 0xbe, 0x32, 0x47, 0xc5,
	0xc6, 0x7c, 0x6b, 0x76, 0xdb, 0x5b, 0xe7, 0x87, 0x57, 0x05, 0x26, 0x14, 0x31, 0xe3, 0xa1, 0x2f,
	0x64, 0xd8, 0x0b, 0x91, 0xdb, 0xcd, 0xd7, 0xcb, 0x5d, 0x6c, 0x11, 0xa9, 0xdd, 0xed, 0xf9, 0x7a,
	0x7d, 0x9e, 0x56, 0x6d, 0xd8, 0xa7, 0x7f, 0x05, 0x00, 0x00, 0xff, 0xff, 0x16, 0x55, 0x90, 0x95,
	0xab, 0x07, 0x00, 0x00,
}
