// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/event_service.proto

package talent // import "google.golang.org/genproto/googleapis/cloud/talent/v4beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// The report event request.
type CreateClientEventRequest struct {
	// Required.
	//
	// Resource name of the tenant under which the event is created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/api-test-project/tenant/foo".
	//
	// Tenant id is optional and a default tenant is created if unspecified, for
	// example, "projects/api-test-project".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	//
	// Events issued when end user interacts with customer's application that
	// uses Cloud Talent Solution.
	ClientEvent          *ClientEvent `protobuf:"bytes,2,opt,name=client_event,json=clientEvent,proto3" json:"client_event,omitempty"`
	XXX_NoUnkeyedLiteral struct{}     `json:"-"`
	XXX_unrecognized     []byte       `json:"-"`
	XXX_sizecache        int32        `json:"-"`
}

func (m *CreateClientEventRequest) Reset()         { *m = CreateClientEventRequest{} }
func (m *CreateClientEventRequest) String() string { return proto.CompactTextString(m) }
func (*CreateClientEventRequest) ProtoMessage()    {}
func (*CreateClientEventRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_event_service_e4985594ba4916cb, []int{0}
}
func (m *CreateClientEventRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateClientEventRequest.Unmarshal(m, b)
}
func (m *CreateClientEventRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateClientEventRequest.Marshal(b, m, deterministic)
}
func (dst *CreateClientEventRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateClientEventRequest.Merge(dst, src)
}
func (m *CreateClientEventRequest) XXX_Size() int {
	return xxx_messageInfo_CreateClientEventRequest.Size(m)
}
func (m *CreateClientEventRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateClientEventRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateClientEventRequest proto.InternalMessageInfo

func (m *CreateClientEventRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateClientEventRequest) GetClientEvent() *ClientEvent {
	if m != nil {
		return m.ClientEvent
	}
	return nil
}

func init() {
	proto.RegisterType((*CreateClientEventRequest)(nil), "google.cloud.talent.v4beta1.CreateClientEventRequest")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// EventServiceClient is the client API for EventService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type EventServiceClient interface {
	// Report events issued when end user interacts with customer's application
	// that uses Cloud Talent Solution. You may inspect the created events in
	// [self service
	// tools](https://console.cloud.google.com/talent-solution/overview).
	// [Learn
	// more](https://cloud.google.com/talent-solution/docs/management-tools)
	// about self service tools.
	CreateClientEvent(ctx context.Context, in *CreateClientEventRequest, opts ...grpc.CallOption) (*ClientEvent, error)
}

type eventServiceClient struct {
	cc *grpc.ClientConn
}

func NewEventServiceClient(cc *grpc.ClientConn) EventServiceClient {
	return &eventServiceClient{cc}
}

func (c *eventServiceClient) CreateClientEvent(ctx context.Context, in *CreateClientEventRequest, opts ...grpc.CallOption) (*ClientEvent, error) {
	out := new(ClientEvent)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.EventService/CreateClientEvent", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// EventServiceServer is the server API for EventService service.
type EventServiceServer interface {
	// Report events issued when end user interacts with customer's application
	// that uses Cloud Talent Solution. You may inspect the created events in
	// [self service
	// tools](https://console.cloud.google.com/talent-solution/overview).
	// [Learn
	// more](https://cloud.google.com/talent-solution/docs/management-tools)
	// about self service tools.
	CreateClientEvent(context.Context, *CreateClientEventRequest) (*ClientEvent, error)
}

func RegisterEventServiceServer(s *grpc.Server, srv EventServiceServer) {
	s.RegisterService(&_EventService_serviceDesc, srv)
}

func _EventService_CreateClientEvent_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateClientEventRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(EventServiceServer).CreateClientEvent(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.EventService/CreateClientEvent",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(EventServiceServer).CreateClientEvent(ctx, req.(*CreateClientEventRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _EventService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.talent.v4beta1.EventService",
	HandlerType: (*EventServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateClientEvent",
			Handler:    _EventService_CreateClientEvent_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/talent/v4beta1/event_service.proto",
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/event_service.proto", fileDescriptor_event_service_e4985594ba4916cb)
}

var fileDescriptor_event_service_e4985594ba4916cb = []byte{
	// 327 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x8c, 0x92, 0xb1, 0x4e, 0x3a, 0x41,
	0x10, 0xc6, 0xb3, 0xfc, 0x13, 0x92, 0xff, 0x42, 0xc3, 0x15, 0x86, 0xa0, 0x89, 0xe4, 0x1a, 0x91,
	0x62, 0x37, 0x82, 0x36, 0x1a, 0x0b, 0x21, 0x56, 0x36, 0x04, 0xac, 0x68, 0xc8, 0x72, 0x4e, 0xce,
	0x33, 0xe7, 0xec, 0xb9, 0x3b, 0xd0, 0x18, 0x43, 0xe2, 0x2b, 0xf8, 0x06, 0xbe, 0x92, 0xaf, 0xc0,
	0x2b, 0xd8, 0x1b, 0x76, 0x2f, 0x7a, 0x09, 0x7a, 0xda, 0xcd, 0xe4, 0xe6, 0xf7, 0xdd, 0xf7, 0xcd,
	0x2c, 0x97, 0xb1, 0xd6, 0x71, 0x0a, 0x32, 0x4a, 0xf5, 0xe2, 0x46, 0x92, 0x4a, 0x01, 0x49, 0x2e,
	0x8f, 0xe7, 0x40, 0xea, 0x48, 0xc2, 0x12, 0x90, 0x66, 0x16, 0xcc, 0x32, 0x89, 0x40, 0x64, 0x46,
	0x93, 0x0e, 0x76, 0x3d, 0x20, 0x1c, 0x20, 0x3c, 0x20, 0x72, 0xa0, 0xb5, 0x97, 0xab, 0xa9, 0x2c,
	0x91, 0x0a, 0x51, 0x93, 0xa2, 0x44, 0xa3, 0xf5, 0x68, 0xeb, 0xe0, 0xd7, 0x7f, 0xf9, 0xc1, 0x70,
	0xc5, 0x9b, 0x43, 0x03, 0x8a, 0x60, 0x98, 0x26, 0x80, 0x74, 0xb9, 0xf9, 0x34, 0x86, 0x87, 0x05,
	0x58, 0x0a, 0x76, 0x78, 0x35, 0x53, 0x06, 0x90, 0x9a, 0xac, 0xcd, 0x3a, 0xff, 0xc7, 0x79, 0x17,
	0x5c, 0xf1, 0x7a, 0xe4, 0xa6, 0x67, 0x4e, 0xa9, 0x59, 0x69, 0xb3, 0x4e, 0xad, 0xd7, 0x11, 0x25,
	0x76, 0x45, 0x51, 0xbe, 0x16, 0x7d, 0x35, 0xbd, 0x77, 0xc6, 0xeb, 0xae, 0x9a, 0xf8, 0xec, 0xc1,
	0x9a, 0xf1, 0xc6, 0x96, 0xa5, 0xe0, 0xa4, 0x5c, 0xfd, 0x87, 0x08, 0xad, 0x3f, 0x9b, 0x0a, 0xf1,
	0xf9, 0x6d, 0xfd, 0x52, 0xb9, 0x0d, 0xfb, 0x9f, 0x6b, 0x7a, 0xf4, 0x71, 0xcf, 0x33, 0xa3, 0xef,
	0x20, 0x22, 0x2b, 0xbb, 0x92, 0x00, 0x15, 0x6e, 0xaa, 0x27, 0x59, 0xc8, 0x60, 0x4f, 0x59, 0x77,
	0x2a, 0xc2, 0xc3, 0x12, 0x72, 0x6b, 0x7e, 0xb0, 0xe2, 0xfb, 0x91, 0xbe, 0x2f, 0xb3, 0x37, 0x68,
	0x14, 0xf7, 0x32, 0xda, 0x9c, 0x6b, 0xc4, 0xa6, 0x17, 0x39, 0x11, 0xeb, 0x54, 0x61, 0x2c, 0xb4,
	0x89, 0x65, 0x0c, 0xe8, 0x8e, 0x99, 0x3f, 0x30, 0x95, 0x25, 0xf6, 0xdb, 0xc3, 0x9f, 0xf9, 0xf6,
	0xb5, 0xf2, 0x6f, 0x78, 0x3d, 0x99, 0x57, 0x1d, 0xd3, 0xff, 0x08, 0x00, 0x00, 0xff, 0xff, 0xb3,
	0x27, 0x4c, 0x92, 0x97, 0x02, 0x00, 0x00,
}
