// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/privacy/dlp/v2/storage.proto

package dlp // import "google.golang.org/genproto/googleapis/privacy/dlp/v2"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Categorization of results based on how likely they are to represent a match,
// based on the number of elements they contain which imply a match.
type Likelihood int32

const (
	// Default value; same as POSSIBLE.
	Likelihood_LIKELIHOOD_UNSPECIFIED Likelihood = 0
	// Few matching elements.
	Likelihood_VERY_UNLIKELY Likelihood = 1
	Likelihood_UNLIKELY      Likelihood = 2
	// Some matching elements.
	Likelihood_POSSIBLE Likelihood = 3
	Likelihood_LIKELY   Likelihood = 4
	// Many matching elements.
	Likelihood_VERY_LIKELY Likelihood = 5
)

var Likelihood_name = map[int32]string{
	0: "LIKELIHOOD_UNSPECIFIED",
	1: "VERY_UNLIKELY",
	2: "UNLIKELY",
	3: "POSSIBLE",
	4: "LIKELY",
	5: "VERY_LIKELY",
}
var Likelihood_value = map[string]int32{
	"LIKELIHOOD_UNSPECIFIED": 0,
	"VERY_UNLIKELY":          1,
	"UNLIKELY":               2,
	"POSSIBLE":               3,
	"LIKELY":                 4,
	"VERY_LIKELY":            5,
}

func (x Likelihood) String() string {
	return proto.EnumName(Likelihood_name, int32(x))
}
func (Likelihood) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{0}
}

// Definitions of file type groups to scan.
type FileType int32

const (
	// Includes all files.
	FileType_FILE_TYPE_UNSPECIFIED FileType = 0
	// Includes all file extensions not covered by text file types.
	FileType_BINARY_FILE FileType = 1
	// Included file extensions:
	//   asc, brf, c, cc, cpp, csv, cxx, c++, cs, css, dart, eml, go, h, hh, hpp,
	//   hxx, h++, hs, html, htm, shtml, shtm, xhtml, lhs, ini, java, js, json,
	//   ocaml, md, mkd, markdown, m, ml, mli, pl, pm, php, phtml, pht, py, pyw,
	//   rb, rbw, rs, rc, scala, sh, sql, tex, txt, text, tsv, vcard, vcs, wml,
	//   xml, xsl, xsd, yml, yaml.
	FileType_TEXT_FILE FileType = 2
	// Included file extensions:
	//   bmp, gif, jpg, jpeg, jpe, png.
	// bytes_limit_per_file has no effect on image files.
	FileType_IMAGE FileType = 3
)

var FileType_name = map[int32]string{
	0: "FILE_TYPE_UNSPECIFIED",
	1: "BINARY_FILE",
	2: "TEXT_FILE",
	3: "IMAGE",
}
var FileType_value = map[string]int32{
	"FILE_TYPE_UNSPECIFIED": 0,
	"BINARY_FILE":           1,
	"TEXT_FILE":             2,
	"IMAGE":                 3,
}

func (x FileType) String() string {
	return proto.EnumName(FileType_name, int32(x))
}
func (FileType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{1}
}

type CustomInfoType_ExclusionType int32

const (
	// A finding of this custom info type will not be excluded from results.
	CustomInfoType_EXCLUSION_TYPE_UNSPECIFIED CustomInfoType_ExclusionType = 0
	// A finding of this custom info type will be excluded from final results,
	// but can still affect rule execution.
	CustomInfoType_EXCLUSION_TYPE_EXCLUDE CustomInfoType_ExclusionType = 1
)

var CustomInfoType_ExclusionType_name = map[int32]string{
	0: "EXCLUSION_TYPE_UNSPECIFIED",
	1: "EXCLUSION_TYPE_EXCLUDE",
}
var CustomInfoType_ExclusionType_value = map[string]int32{
	"EXCLUSION_TYPE_UNSPECIFIED": 0,
	"EXCLUSION_TYPE_EXCLUDE":     1,
}

func (x CustomInfoType_ExclusionType) String() string {
	return proto.EnumName(CustomInfoType_ExclusionType_name, int32(x))
}
func (CustomInfoType_ExclusionType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{2, 0}
}

// How to sample bytes if not all bytes are scanned. Meaningful only when used
// in conjunction with bytes_limit_per_file. If not specified, scanning would
// start from the top.
type CloudStorageOptions_SampleMethod int32

const (
	CloudStorageOptions_SAMPLE_METHOD_UNSPECIFIED CloudStorageOptions_SampleMethod = 0
	// Scan from the top (default).
	CloudStorageOptions_TOP CloudStorageOptions_SampleMethod = 1
	// For each file larger than bytes_limit_per_file, randomly pick the offset
	// to start scanning. The scanned bytes are contiguous.
	CloudStorageOptions_RANDOM_START CloudStorageOptions_SampleMethod = 2
)

var CloudStorageOptions_SampleMethod_name = map[int32]string{
	0: "SAMPLE_METHOD_UNSPECIFIED",
	1: "TOP",
	2: "RANDOM_START",
}
var CloudStorageOptions_SampleMethod_value = map[string]int32{
	"SAMPLE_METHOD_UNSPECIFIED": 0,
	"TOP":                       1,
	"RANDOM_START":              2,
}

func (x CloudStorageOptions_SampleMethod) String() string {
	return proto.EnumName(CloudStorageOptions_SampleMethod_name, int32(x))
}
func (CloudStorageOptions_SampleMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{8, 0}
}

// How to sample rows if not all rows are scanned. Meaningful only when used
// in conjunction with either rows_limit or rows_limit_percent. If not
// specified, scanning would start from the top.
type BigQueryOptions_SampleMethod int32

const (
	BigQueryOptions_SAMPLE_METHOD_UNSPECIFIED BigQueryOptions_SampleMethod = 0
	// Scan from the top (default).
	BigQueryOptions_TOP BigQueryOptions_SampleMethod = 1
	// Randomly pick the row to start scanning. The scanned rows are contiguous.
	BigQueryOptions_RANDOM_START BigQueryOptions_SampleMethod = 2
)

var BigQueryOptions_SampleMethod_name = map[int32]string{
	0: "SAMPLE_METHOD_UNSPECIFIED",
	1: "TOP",
	2: "RANDOM_START",
}
var BigQueryOptions_SampleMethod_value = map[string]int32{
	"SAMPLE_METHOD_UNSPECIFIED": 0,
	"TOP":                       1,
	"RANDOM_START":              2,
}

func (x BigQueryOptions_SampleMethod) String() string {
	return proto.EnumName(BigQueryOptions_SampleMethod_name, int32(x))
}
func (BigQueryOptions_SampleMethod) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{11, 0}
}

// Type of information detected by the API.
type InfoType struct {
	// Name of the information type. Either a name of your choosing when
	// creating a CustomInfoType, or one of the names listed
	// at https://cloud.google.com/dlp/docs/infotypes-reference when specifying
	// a built-in type. InfoType names should conform to the pattern
	// [a-zA-Z0-9_]{1,64}.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *InfoType) Reset()         { *m = InfoType{} }
func (m *InfoType) String() string { return proto.CompactTextString(m) }
func (*InfoType) ProtoMessage()    {}
func (*InfoType) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{0}
}
func (m *InfoType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_InfoType.Unmarshal(m, b)
}
func (m *InfoType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_InfoType.Marshal(b, m, deterministic)
}
func (dst *InfoType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_InfoType.Merge(dst, src)
}
func (m *InfoType) XXX_Size() int {
	return xxx_messageInfo_InfoType.Size(m)
}
func (m *InfoType) XXX_DiscardUnknown() {
	xxx_messageInfo_InfoType.DiscardUnknown(m)
}

var xxx_messageInfo_InfoType proto.InternalMessageInfo

func (m *InfoType) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A reference to a StoredInfoType to use with scanning.
type StoredType struct {
	// Resource name of the requested `StoredInfoType`, for example
	// `organizations/433245324/storedInfoTypes/432452342` or
	// `projects/project-id/storedInfoTypes/432452342`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Timestamp indicating when the version of the `StoredInfoType` used for
	// inspection was created. Output-only field, populated by the system.
	CreateTime           *timestamp.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StoredType) Reset()         { *m = StoredType{} }
func (m *StoredType) String() string { return proto.CompactTextString(m) }
func (*StoredType) ProtoMessage()    {}
func (*StoredType) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{1}
}
func (m *StoredType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StoredType.Unmarshal(m, b)
}
func (m *StoredType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StoredType.Marshal(b, m, deterministic)
}
func (dst *StoredType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StoredType.Merge(dst, src)
}
func (m *StoredType) XXX_Size() int {
	return xxx_messageInfo_StoredType.Size(m)
}
func (m *StoredType) XXX_DiscardUnknown() {
	xxx_messageInfo_StoredType.DiscardUnknown(m)
}

var xxx_messageInfo_StoredType proto.InternalMessageInfo

func (m *StoredType) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *StoredType) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

// Custom information type provided by the user. Used to find domain-specific
// sensitive information configurable to the data in question.
type CustomInfoType struct {
	// CustomInfoType can either be a new infoType, or an extension of built-in
	// infoType, when the name matches one of existing infoTypes and that infoType
	// is specified in `InspectContent.info_types` field. Specifying the latter
	// adds findings to the one detected by the system. If built-in info type is
	// not specified in `InspectContent.info_types` list then the name is treated
	// as a custom info type.
	InfoType *InfoType `protobuf:"bytes,1,opt,name=info_type,json=infoType,proto3" json:"info_type,omitempty"`
	// Likelihood to return for this CustomInfoType. This base value can be
	// altered by a detection rule if the finding meets the criteria specified by
	// the rule. Defaults to `VERY_LIKELY` if not specified.
	Likelihood Likelihood `protobuf:"varint,6,opt,name=likelihood,proto3,enum=google.privacy.dlp.v2.Likelihood" json:"likelihood,omitempty"`
	// Types that are valid to be assigned to Type:
	//	*CustomInfoType_Dictionary_
	//	*CustomInfoType_Regex_
	//	*CustomInfoType_SurrogateType_
	//	*CustomInfoType_StoredType
	Type isCustomInfoType_Type `protobuf_oneof:"type"`
	// Set of detection rules to apply to all findings of this CustomInfoType.
	// Rules are applied in order that they are specified. Not supported for the
	// `surrogate_type` CustomInfoType.
	DetectionRules []*CustomInfoType_DetectionRule `protobuf:"bytes,7,rep,name=detection_rules,json=detectionRules,proto3" json:"detection_rules,omitempty"`
	// If set to EXCLUSION_TYPE_EXCLUDE this infoType will not cause a finding
	// to be returned. It still can be used for rules matching.
	ExclusionType        CustomInfoType_ExclusionType `protobuf:"varint,8,opt,name=exclusion_type,json=exclusionType,proto3,enum=google.privacy.dlp.v2.CustomInfoType_ExclusionType" json:"exclusion_type,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *CustomInfoType) Reset()         { *m = CustomInfoType{} }
func (m *CustomInfoType) String() string { return proto.CompactTextString(m) }
func (*CustomInfoType) ProtoMessage()    {}
func (*CustomInfoType) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{2}
}
func (m *CustomInfoType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomInfoType.Unmarshal(m, b)
}
func (m *CustomInfoType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomInfoType.Marshal(b, m, deterministic)
}
func (dst *CustomInfoType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomInfoType.Merge(dst, src)
}
func (m *CustomInfoType) XXX_Size() int {
	return xxx_messageInfo_CustomInfoType.Size(m)
}
func (m *CustomInfoType) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomInfoType.DiscardUnknown(m)
}

var xxx_messageInfo_CustomInfoType proto.InternalMessageInfo

func (m *CustomInfoType) GetInfoType() *InfoType {
	if m != nil {
		return m.InfoType
	}
	return nil
}

func (m *CustomInfoType) GetLikelihood() Likelihood {
	if m != nil {
		return m.Likelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

type isCustomInfoType_Type interface {
	isCustomInfoType_Type()
}

type CustomInfoType_Dictionary_ struct {
	Dictionary *CustomInfoType_Dictionary `protobuf:"bytes,2,opt,name=dictionary,proto3,oneof"`
}

type CustomInfoType_Regex_ struct {
	Regex *CustomInfoType_Regex `protobuf:"bytes,3,opt,name=regex,proto3,oneof"`
}

type CustomInfoType_SurrogateType_ struct {
	SurrogateType *CustomInfoType_SurrogateType `protobuf:"bytes,4,opt,name=surrogate_type,json=surrogateType,proto3,oneof"`
}

type CustomInfoType_StoredType struct {
	StoredType *StoredType `protobuf:"bytes,5,opt,name=stored_type,json=storedType,proto3,oneof"`
}

func (*CustomInfoType_Dictionary_) isCustomInfoType_Type() {}

func (*CustomInfoType_Regex_) isCustomInfoType_Type() {}

func (*CustomInfoType_SurrogateType_) isCustomInfoType_Type() {}

func (*CustomInfoType_StoredType) isCustomInfoType_Type() {}

func (m *CustomInfoType) GetType() isCustomInfoType_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *CustomInfoType) GetDictionary() *CustomInfoType_Dictionary {
	if x, ok := m.GetType().(*CustomInfoType_Dictionary_); ok {
		return x.Dictionary
	}
	return nil
}

func (m *CustomInfoType) GetRegex() *CustomInfoType_Regex {
	if x, ok := m.GetType().(*CustomInfoType_Regex_); ok {
		return x.Regex
	}
	return nil
}

func (m *CustomInfoType) GetSurrogateType() *CustomInfoType_SurrogateType {
	if x, ok := m.GetType().(*CustomInfoType_SurrogateType_); ok {
		return x.SurrogateType
	}
	return nil
}

func (m *CustomInfoType) GetStoredType() *StoredType {
	if x, ok := m.GetType().(*CustomInfoType_StoredType); ok {
		return x.StoredType
	}
	return nil
}

func (m *CustomInfoType) GetDetectionRules() []*CustomInfoType_DetectionRule {
	if m != nil {
		return m.DetectionRules
	}
	return nil
}

func (m *CustomInfoType) GetExclusionType() CustomInfoType_ExclusionType {
	if m != nil {
		return m.ExclusionType
	}
	return CustomInfoType_EXCLUSION_TYPE_UNSPECIFIED
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CustomInfoType) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CustomInfoType_OneofMarshaler, _CustomInfoType_OneofUnmarshaler, _CustomInfoType_OneofSizer, []interface{}{
		(*CustomInfoType_Dictionary_)(nil),
		(*CustomInfoType_Regex_)(nil),
		(*CustomInfoType_SurrogateType_)(nil),
		(*CustomInfoType_StoredType)(nil),
	}
}

func _CustomInfoType_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CustomInfoType)
	// type
	switch x := m.Type.(type) {
	case *CustomInfoType_Dictionary_:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Dictionary); err != nil {
			return err
		}
	case *CustomInfoType_Regex_:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Regex); err != nil {
			return err
		}
	case *CustomInfoType_SurrogateType_:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.SurrogateType); err != nil {
			return err
		}
	case *CustomInfoType_StoredType:
		b.EncodeVarint(5<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.StoredType); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CustomInfoType.Type has unexpected type %T", x)
	}
	return nil
}

func _CustomInfoType_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CustomInfoType)
	switch tag {
	case 2: // type.dictionary
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CustomInfoType_Dictionary)
		err := b.DecodeMessage(msg)
		m.Type = &CustomInfoType_Dictionary_{msg}
		return true, err
	case 3: // type.regex
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CustomInfoType_Regex)
		err := b.DecodeMessage(msg)
		m.Type = &CustomInfoType_Regex_{msg}
		return true, err
	case 4: // type.surrogate_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CustomInfoType_SurrogateType)
		err := b.DecodeMessage(msg)
		m.Type = &CustomInfoType_SurrogateType_{msg}
		return true, err
	case 5: // type.stored_type
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(StoredType)
		err := b.DecodeMessage(msg)
		m.Type = &CustomInfoType_StoredType{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CustomInfoType_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CustomInfoType)
	// type
	switch x := m.Type.(type) {
	case *CustomInfoType_Dictionary_:
		s := proto.Size(x.Dictionary)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CustomInfoType_Regex_:
		s := proto.Size(x.Regex)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CustomInfoType_SurrogateType_:
		s := proto.Size(x.SurrogateType)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CustomInfoType_StoredType:
		s := proto.Size(x.StoredType)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Custom information type based on a dictionary of words or phrases. This can
// be used to match sensitive information specific to the data, such as a list
// of employee IDs or job titles.
//
// Dictionary words are case-insensitive and all characters other than letters
// and digits in the unicode [Basic Multilingual
// Plane](https://en.wikipedia.org/wiki/Plane_%28Unicode%29#Basic_Multilingual_Plane)
// will be replaced with whitespace when scanning for matches, so the
// dictionary phrase "Sam Johnson" will match all three phrases "sam johnson",
// "Sam, Johnson", and "Sam (Johnson)". Additionally, the characters
// surrounding any match must be of a different type than the adjacent
// characters within the word, so letters must be next to non-letters and
// digits next to non-digits. For example, the dictionary word "jen" will
// match the first three letters of the text "jen123" but will return no
// matches for "jennifer".
//
// Dictionary words containing a large number of characters that are not
// letters or digits may result in unexpected findings because such characters
// are treated as whitespace. The
// [limits](https://cloud.google.com/dlp/limits) page contains details about
// the size limits of dictionaries. For dictionaries that do not fit within
// these constraints, consider using `LargeCustomDictionaryConfig` in the
// `StoredInfoType` API.
type CustomInfoType_Dictionary struct {
	// Types that are valid to be assigned to Source:
	//	*CustomInfoType_Dictionary_WordList_
	//	*CustomInfoType_Dictionary_CloudStoragePath
	Source               isCustomInfoType_Dictionary_Source `protobuf_oneof:"source"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *CustomInfoType_Dictionary) Reset()         { *m = CustomInfoType_Dictionary{} }
func (m *CustomInfoType_Dictionary) String() string { return proto.CompactTextString(m) }
func (*CustomInfoType_Dictionary) ProtoMessage()    {}
func (*CustomInfoType_Dictionary) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{2, 0}
}
func (m *CustomInfoType_Dictionary) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomInfoType_Dictionary.Unmarshal(m, b)
}
func (m *CustomInfoType_Dictionary) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomInfoType_Dictionary.Marshal(b, m, deterministic)
}
func (dst *CustomInfoType_Dictionary) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomInfoType_Dictionary.Merge(dst, src)
}
func (m *CustomInfoType_Dictionary) XXX_Size() int {
	return xxx_messageInfo_CustomInfoType_Dictionary.Size(m)
}
func (m *CustomInfoType_Dictionary) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomInfoType_Dictionary.DiscardUnknown(m)
}

var xxx_messageInfo_CustomInfoType_Dictionary proto.InternalMessageInfo

type isCustomInfoType_Dictionary_Source interface {
	isCustomInfoType_Dictionary_Source()
}

type CustomInfoType_Dictionary_WordList_ struct {
	WordList *CustomInfoType_Dictionary_WordList `protobuf:"bytes,1,opt,name=word_list,json=wordList,proto3,oneof"`
}

type CustomInfoType_Dictionary_CloudStoragePath struct {
	CloudStoragePath *CloudStoragePath `protobuf:"bytes,3,opt,name=cloud_storage_path,json=cloudStoragePath,proto3,oneof"`
}

func (*CustomInfoType_Dictionary_WordList_) isCustomInfoType_Dictionary_Source() {}

func (*CustomInfoType_Dictionary_CloudStoragePath) isCustomInfoType_Dictionary_Source() {}

func (m *CustomInfoType_Dictionary) GetSource() isCustomInfoType_Dictionary_Source {
	if m != nil {
		return m.Source
	}
	return nil
}

func (m *CustomInfoType_Dictionary) GetWordList() *CustomInfoType_Dictionary_WordList {
	if x, ok := m.GetSource().(*CustomInfoType_Dictionary_WordList_); ok {
		return x.WordList
	}
	return nil
}

func (m *CustomInfoType_Dictionary) GetCloudStoragePath() *CloudStoragePath {
	if x, ok := m.GetSource().(*CustomInfoType_Dictionary_CloudStoragePath); ok {
		return x.CloudStoragePath
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CustomInfoType_Dictionary) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CustomInfoType_Dictionary_OneofMarshaler, _CustomInfoType_Dictionary_OneofUnmarshaler, _CustomInfoType_Dictionary_OneofSizer, []interface{}{
		(*CustomInfoType_Dictionary_WordList_)(nil),
		(*CustomInfoType_Dictionary_CloudStoragePath)(nil),
	}
}

func _CustomInfoType_Dictionary_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CustomInfoType_Dictionary)
	// source
	switch x := m.Source.(type) {
	case *CustomInfoType_Dictionary_WordList_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.WordList); err != nil {
			return err
		}
	case *CustomInfoType_Dictionary_CloudStoragePath:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CloudStoragePath); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CustomInfoType_Dictionary.Source has unexpected type %T", x)
	}
	return nil
}

func _CustomInfoType_Dictionary_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CustomInfoType_Dictionary)
	switch tag {
	case 1: // source.word_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CustomInfoType_Dictionary_WordList)
		err := b.DecodeMessage(msg)
		m.Source = &CustomInfoType_Dictionary_WordList_{msg}
		return true, err
	case 3: // source.cloud_storage_path
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CloudStoragePath)
		err := b.DecodeMessage(msg)
		m.Source = &CustomInfoType_Dictionary_CloudStoragePath{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CustomInfoType_Dictionary_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CustomInfoType_Dictionary)
	// source
	switch x := m.Source.(type) {
	case *CustomInfoType_Dictionary_WordList_:
		s := proto.Size(x.WordList)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *CustomInfoType_Dictionary_CloudStoragePath:
		s := proto.Size(x.CloudStoragePath)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Message defining a list of words or phrases to search for in the data.
type CustomInfoType_Dictionary_WordList struct {
	// Words or phrases defining the dictionary. The dictionary must contain
	// at least one phrase and every phrase must contain at least 2 characters
	// that are letters or digits. [required]
	Words                []string `protobuf:"bytes,1,rep,name=words,proto3" json:"words,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CustomInfoType_Dictionary_WordList) Reset()         { *m = CustomInfoType_Dictionary_WordList{} }
func (m *CustomInfoType_Dictionary_WordList) String() string { return proto.CompactTextString(m) }
func (*CustomInfoType_Dictionary_WordList) ProtoMessage()    {}
func (*CustomInfoType_Dictionary_WordList) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{2, 0, 0}
}
func (m *CustomInfoType_Dictionary_WordList) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomInfoType_Dictionary_WordList.Unmarshal(m, b)
}
func (m *CustomInfoType_Dictionary_WordList) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomInfoType_Dictionary_WordList.Marshal(b, m, deterministic)
}
func (dst *CustomInfoType_Dictionary_WordList) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomInfoType_Dictionary_WordList.Merge(dst, src)
}
func (m *CustomInfoType_Dictionary_WordList) XXX_Size() int {
	return xxx_messageInfo_CustomInfoType_Dictionary_WordList.Size(m)
}
func (m *CustomInfoType_Dictionary_WordList) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomInfoType_Dictionary_WordList.DiscardUnknown(m)
}

var xxx_messageInfo_CustomInfoType_Dictionary_WordList proto.InternalMessageInfo

func (m *CustomInfoType_Dictionary_WordList) GetWords() []string {
	if m != nil {
		return m.Words
	}
	return nil
}

// Message defining a custom regular expression.
type CustomInfoType_Regex struct {
	// Pattern defining the regular expression. Its syntax
	// (https://github.com/google/re2/wiki/Syntax) can be found under the
	// google/re2 repository on GitHub.
	Pattern string `protobuf:"bytes,1,opt,name=pattern,proto3" json:"pattern,omitempty"`
	// The index of the submatch to extract as findings. When not
	// specified, the entire match is returned. No more than 3 may be included.
	GroupIndexes         []int32  `protobuf:"varint,2,rep,packed,name=group_indexes,json=groupIndexes,proto3" json:"group_indexes,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CustomInfoType_Regex) Reset()         { *m = CustomInfoType_Regex{} }
func (m *CustomInfoType_Regex) String() string { return proto.CompactTextString(m) }
func (*CustomInfoType_Regex) ProtoMessage()    {}
func (*CustomInfoType_Regex) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{2, 1}
}
func (m *CustomInfoType_Regex) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomInfoType_Regex.Unmarshal(m, b)
}
func (m *CustomInfoType_Regex) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomInfoType_Regex.Marshal(b, m, deterministic)
}
func (dst *CustomInfoType_Regex) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomInfoType_Regex.Merge(dst, src)
}
func (m *CustomInfoType_Regex) XXX_Size() int {
	return xxx_messageInfo_CustomInfoType_Regex.Size(m)
}
func (m *CustomInfoType_Regex) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomInfoType_Regex.DiscardUnknown(m)
}

var xxx_messageInfo_CustomInfoType_Regex proto.InternalMessageInfo

func (m *CustomInfoType_Regex) GetPattern() string {
	if m != nil {
		return m.Pattern
	}
	return ""
}

func (m *CustomInfoType_Regex) GetGroupIndexes() []int32 {
	if m != nil {
		return m.GroupIndexes
	}
	return nil
}

// Message for detecting output from deidentification transformations
// such as
// [`CryptoReplaceFfxFpeConfig`](/dlp/docs/reference/rest/v2/organizations.deidentifyTemplates#cryptoreplaceffxfpeconfig).
// These types of transformations are
// those that perform pseudonymization, thereby producing a "surrogate" as
// output. This should be used in conjunction with a field on the
// transformation such as `surrogate_info_type`. This CustomInfoType does
// not support the use of `detection_rules`.
type CustomInfoType_SurrogateType struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CustomInfoType_SurrogateType) Reset()         { *m = CustomInfoType_SurrogateType{} }
func (m *CustomInfoType_SurrogateType) String() string { return proto.CompactTextString(m) }
func (*CustomInfoType_SurrogateType) ProtoMessage()    {}
func (*CustomInfoType_SurrogateType) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{2, 2}
}
func (m *CustomInfoType_SurrogateType) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomInfoType_SurrogateType.Unmarshal(m, b)
}
func (m *CustomInfoType_SurrogateType) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomInfoType_SurrogateType.Marshal(b, m, deterministic)
}
func (dst *CustomInfoType_SurrogateType) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomInfoType_SurrogateType.Merge(dst, src)
}
func (m *CustomInfoType_SurrogateType) XXX_Size() int {
	return xxx_messageInfo_CustomInfoType_SurrogateType.Size(m)
}
func (m *CustomInfoType_SurrogateType) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomInfoType_SurrogateType.DiscardUnknown(m)
}

var xxx_messageInfo_CustomInfoType_SurrogateType proto.InternalMessageInfo

// Rule for modifying a CustomInfoType to alter behavior under certain
// circumstances, depending on the specific details of the rule. Not supported
// for the `surrogate_type` custom info type.
type CustomInfoType_DetectionRule struct {
	// Types that are valid to be assigned to Type:
	//	*CustomInfoType_DetectionRule_HotwordRule_
	Type                 isCustomInfoType_DetectionRule_Type `protobuf_oneof:"type"`
	XXX_NoUnkeyedLiteral struct{}                            `json:"-"`
	XXX_unrecognized     []byte                              `json:"-"`
	XXX_sizecache        int32                               `json:"-"`
}

func (m *CustomInfoType_DetectionRule) Reset()         { *m = CustomInfoType_DetectionRule{} }
func (m *CustomInfoType_DetectionRule) String() string { return proto.CompactTextString(m) }
func (*CustomInfoType_DetectionRule) ProtoMessage()    {}
func (*CustomInfoType_DetectionRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{2, 3}
}
func (m *CustomInfoType_DetectionRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomInfoType_DetectionRule.Unmarshal(m, b)
}
func (m *CustomInfoType_DetectionRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomInfoType_DetectionRule.Marshal(b, m, deterministic)
}
func (dst *CustomInfoType_DetectionRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomInfoType_DetectionRule.Merge(dst, src)
}
func (m *CustomInfoType_DetectionRule) XXX_Size() int {
	return xxx_messageInfo_CustomInfoType_DetectionRule.Size(m)
}
func (m *CustomInfoType_DetectionRule) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomInfoType_DetectionRule.DiscardUnknown(m)
}

var xxx_messageInfo_CustomInfoType_DetectionRule proto.InternalMessageInfo

type isCustomInfoType_DetectionRule_Type interface {
	isCustomInfoType_DetectionRule_Type()
}

type CustomInfoType_DetectionRule_HotwordRule_ struct {
	HotwordRule *CustomInfoType_DetectionRule_HotwordRule `protobuf:"bytes,1,opt,name=hotword_rule,json=hotwordRule,proto3,oneof"`
}

func (*CustomInfoType_DetectionRule_HotwordRule_) isCustomInfoType_DetectionRule_Type() {}

func (m *CustomInfoType_DetectionRule) GetType() isCustomInfoType_DetectionRule_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *CustomInfoType_DetectionRule) GetHotwordRule() *CustomInfoType_DetectionRule_HotwordRule {
	if x, ok := m.GetType().(*CustomInfoType_DetectionRule_HotwordRule_); ok {
		return x.HotwordRule
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CustomInfoType_DetectionRule) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CustomInfoType_DetectionRule_OneofMarshaler, _CustomInfoType_DetectionRule_OneofUnmarshaler, _CustomInfoType_DetectionRule_OneofSizer, []interface{}{
		(*CustomInfoType_DetectionRule_HotwordRule_)(nil),
	}
}

func _CustomInfoType_DetectionRule_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CustomInfoType_DetectionRule)
	// type
	switch x := m.Type.(type) {
	case *CustomInfoType_DetectionRule_HotwordRule_:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.HotwordRule); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("CustomInfoType_DetectionRule.Type has unexpected type %T", x)
	}
	return nil
}

func _CustomInfoType_DetectionRule_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CustomInfoType_DetectionRule)
	switch tag {
	case 1: // type.hotword_rule
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CustomInfoType_DetectionRule_HotwordRule)
		err := b.DecodeMessage(msg)
		m.Type = &CustomInfoType_DetectionRule_HotwordRule_{msg}
		return true, err
	default:
		return false, nil
	}
}

func _CustomInfoType_DetectionRule_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CustomInfoType_DetectionRule)
	// type
	switch x := m.Type.(type) {
	case *CustomInfoType_DetectionRule_HotwordRule_:
		s := proto.Size(x.HotwordRule)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Message for specifying a window around a finding to apply a detection
// rule.
type CustomInfoType_DetectionRule_Proximity struct {
	// Number of characters before the finding to consider.
	WindowBefore int32 `protobuf:"varint,1,opt,name=window_before,json=windowBefore,proto3" json:"window_before,omitempty"`
	// Number of characters after the finding to consider.
	WindowAfter          int32    `protobuf:"varint,2,opt,name=window_after,json=windowAfter,proto3" json:"window_after,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CustomInfoType_DetectionRule_Proximity) Reset() {
	*m = CustomInfoType_DetectionRule_Proximity{}
}
func (m *CustomInfoType_DetectionRule_Proximity) String() string { return proto.CompactTextString(m) }
func (*CustomInfoType_DetectionRule_Proximity) ProtoMessage()    {}
func (*CustomInfoType_DetectionRule_Proximity) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{2, 3, 0}
}
func (m *CustomInfoType_DetectionRule_Proximity) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomInfoType_DetectionRule_Proximity.Unmarshal(m, b)
}
func (m *CustomInfoType_DetectionRule_Proximity) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomInfoType_DetectionRule_Proximity.Marshal(b, m, deterministic)
}
func (dst *CustomInfoType_DetectionRule_Proximity) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomInfoType_DetectionRule_Proximity.Merge(dst, src)
}
func (m *CustomInfoType_DetectionRule_Proximity) XXX_Size() int {
	return xxx_messageInfo_CustomInfoType_DetectionRule_Proximity.Size(m)
}
func (m *CustomInfoType_DetectionRule_Proximity) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomInfoType_DetectionRule_Proximity.DiscardUnknown(m)
}

var xxx_messageInfo_CustomInfoType_DetectionRule_Proximity proto.InternalMessageInfo

func (m *CustomInfoType_DetectionRule_Proximity) GetWindowBefore() int32 {
	if m != nil {
		return m.WindowBefore
	}
	return 0
}

func (m *CustomInfoType_DetectionRule_Proximity) GetWindowAfter() int32 {
	if m != nil {
		return m.WindowAfter
	}
	return 0
}

// Message for specifying an adjustment to the likelihood of a finding as
// part of a detection rule.
type CustomInfoType_DetectionRule_LikelihoodAdjustment struct {
	// Types that are valid to be assigned to Adjustment:
	//	*CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood
	//	*CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood
	Adjustment           isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment `protobuf_oneof:"adjustment"`
	XXX_NoUnkeyedLiteral struct{}                                                       `json:"-"`
	XXX_unrecognized     []byte                                                         `json:"-"`
	XXX_sizecache        int32                                                          `json:"-"`
}

func (m *CustomInfoType_DetectionRule_LikelihoodAdjustment) Reset() {
	*m = CustomInfoType_DetectionRule_LikelihoodAdjustment{}
}
func (m *CustomInfoType_DetectionRule_LikelihoodAdjustment) String() string {
	return proto.CompactTextString(m)
}
func (*CustomInfoType_DetectionRule_LikelihoodAdjustment) ProtoMessage() {}
func (*CustomInfoType_DetectionRule_LikelihoodAdjustment) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{2, 3, 1}
}
func (m *CustomInfoType_DetectionRule_LikelihoodAdjustment) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomInfoType_DetectionRule_LikelihoodAdjustment.Unmarshal(m, b)
}
func (m *CustomInfoType_DetectionRule_LikelihoodAdjustment) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomInfoType_DetectionRule_LikelihoodAdjustment.Marshal(b, m, deterministic)
}
func (dst *CustomInfoType_DetectionRule_LikelihoodAdjustment) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomInfoType_DetectionRule_LikelihoodAdjustment.Merge(dst, src)
}
func (m *CustomInfoType_DetectionRule_LikelihoodAdjustment) XXX_Size() int {
	return xxx_messageInfo_CustomInfoType_DetectionRule_LikelihoodAdjustment.Size(m)
}
func (m *CustomInfoType_DetectionRule_LikelihoodAdjustment) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomInfoType_DetectionRule_LikelihoodAdjustment.DiscardUnknown(m)
}

var xxx_messageInfo_CustomInfoType_DetectionRule_LikelihoodAdjustment proto.InternalMessageInfo

type isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment interface {
	isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment()
}

type CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood struct {
	FixedLikelihood Likelihood `protobuf:"varint,1,opt,name=fixed_likelihood,json=fixedLikelihood,proto3,enum=google.privacy.dlp.v2.Likelihood,oneof"`
}

type CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood struct {
	RelativeLikelihood int32 `protobuf:"varint,2,opt,name=relative_likelihood,json=relativeLikelihood,proto3,oneof"`
}

func (*CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood) isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment() {
}

func (*CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood) isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment() {
}

func (m *CustomInfoType_DetectionRule_LikelihoodAdjustment) GetAdjustment() isCustomInfoType_DetectionRule_LikelihoodAdjustment_Adjustment {
	if m != nil {
		return m.Adjustment
	}
	return nil
}

func (m *CustomInfoType_DetectionRule_LikelihoodAdjustment) GetFixedLikelihood() Likelihood {
	if x, ok := m.GetAdjustment().(*CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood); ok {
		return x.FixedLikelihood
	}
	return Likelihood_LIKELIHOOD_UNSPECIFIED
}

func (m *CustomInfoType_DetectionRule_LikelihoodAdjustment) GetRelativeLikelihood() int32 {
	if x, ok := m.GetAdjustment().(*CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood); ok {
		return x.RelativeLikelihood
	}
	return 0
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*CustomInfoType_DetectionRule_LikelihoodAdjustment) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _CustomInfoType_DetectionRule_LikelihoodAdjustment_OneofMarshaler, _CustomInfoType_DetectionRule_LikelihoodAdjustment_OneofUnmarshaler, _CustomInfoType_DetectionRule_LikelihoodAdjustment_OneofSizer, []interface{}{
		(*CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood)(nil),
		(*CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood)(nil),
	}
}

func _CustomInfoType_DetectionRule_LikelihoodAdjustment_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*CustomInfoType_DetectionRule_LikelihoodAdjustment)
	// adjustment
	switch x := m.Adjustment.(type) {
	case *CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood:
		b.EncodeVarint(1<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.FixedLikelihood))
	case *CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.RelativeLikelihood))
	case nil:
	default:
		return fmt.Errorf("CustomInfoType_DetectionRule_LikelihoodAdjustment.Adjustment has unexpected type %T", x)
	}
	return nil
}

func _CustomInfoType_DetectionRule_LikelihoodAdjustment_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*CustomInfoType_DetectionRule_LikelihoodAdjustment)
	switch tag {
	case 1: // adjustment.fixed_likelihood
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Adjustment = &CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood{Likelihood(x)}
		return true, err
	case 2: // adjustment.relative_likelihood
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Adjustment = &CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood{int32(x)}
		return true, err
	default:
		return false, nil
	}
}

func _CustomInfoType_DetectionRule_LikelihoodAdjustment_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*CustomInfoType_DetectionRule_LikelihoodAdjustment)
	// adjustment
	switch x := m.Adjustment.(type) {
	case *CustomInfoType_DetectionRule_LikelihoodAdjustment_FixedLikelihood:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.FixedLikelihood))
	case *CustomInfoType_DetectionRule_LikelihoodAdjustment_RelativeLikelihood:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.RelativeLikelihood))
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// The rule that adjusts the likelihood of findings within a certain
// proximity of hotwords.
type CustomInfoType_DetectionRule_HotwordRule struct {
	// Regular expression pattern defining what qualifies as a hotword.
	HotwordRegex *CustomInfoType_Regex `protobuf:"bytes,1,opt,name=hotword_regex,json=hotwordRegex,proto3" json:"hotword_regex,omitempty"`
	// Proximity of the finding within which the entire hotword must reside.
	// The total length of the window cannot exceed 1000 characters. Note that
	// the finding itself will be included in the window, so that hotwords may
	// be used to match substrings of the finding itself. For example, the
	// certainty of a phone number regex "\(\d{3}\) \d{3}-\d{4}" could be
	// adjusted upwards if the area code is known to be the local area code of
	// a company office using the hotword regex "\(xxx\)", where "xxx"
	// is the area code in question.
	Proximity *CustomInfoType_DetectionRule_Proximity `protobuf:"bytes,2,opt,name=proximity,proto3" json:"proximity,omitempty"`
	// Likelihood adjustment to apply to all matching findings.
	LikelihoodAdjustment *CustomInfoType_DetectionRule_LikelihoodAdjustment `protobuf:"bytes,3,opt,name=likelihood_adjustment,json=likelihoodAdjustment,proto3" json:"likelihood_adjustment,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                           `json:"-"`
	XXX_unrecognized     []byte                                             `json:"-"`
	XXX_sizecache        int32                                              `json:"-"`
}

func (m *CustomInfoType_DetectionRule_HotwordRule) Reset() {
	*m = CustomInfoType_DetectionRule_HotwordRule{}
}
func (m *CustomInfoType_DetectionRule_HotwordRule) String() string { return proto.CompactTextString(m) }
func (*CustomInfoType_DetectionRule_HotwordRule) ProtoMessage()    {}
func (*CustomInfoType_DetectionRule_HotwordRule) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{2, 3, 2}
}
func (m *CustomInfoType_DetectionRule_HotwordRule) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CustomInfoType_DetectionRule_HotwordRule.Unmarshal(m, b)
}
func (m *CustomInfoType_DetectionRule_HotwordRule) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CustomInfoType_DetectionRule_HotwordRule.Marshal(b, m, deterministic)
}
func (dst *CustomInfoType_DetectionRule_HotwordRule) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CustomInfoType_DetectionRule_HotwordRule.Merge(dst, src)
}
func (m *CustomInfoType_DetectionRule_HotwordRule) XXX_Size() int {
	return xxx_messageInfo_CustomInfoType_DetectionRule_HotwordRule.Size(m)
}
func (m *CustomInfoType_DetectionRule_HotwordRule) XXX_DiscardUnknown() {
	xxx_messageInfo_CustomInfoType_DetectionRule_HotwordRule.DiscardUnknown(m)
}

var xxx_messageInfo_CustomInfoType_DetectionRule_HotwordRule proto.InternalMessageInfo

func (m *CustomInfoType_DetectionRule_HotwordRule) GetHotwordRegex() *CustomInfoType_Regex {
	if m != nil {
		return m.HotwordRegex
	}
	return nil
}

func (m *CustomInfoType_DetectionRule_HotwordRule) GetProximity() *CustomInfoType_DetectionRule_Proximity {
	if m != nil {
		return m.Proximity
	}
	return nil
}

func (m *CustomInfoType_DetectionRule_HotwordRule) GetLikelihoodAdjustment() *CustomInfoType_DetectionRule_LikelihoodAdjustment {
	if m != nil {
		return m.LikelihoodAdjustment
	}
	return nil
}

// General identifier of a data field in a storage service.
type FieldId struct {
	// Name describing the field.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *FieldId) Reset()         { *m = FieldId{} }
func (m *FieldId) String() string { return proto.CompactTextString(m) }
func (*FieldId) ProtoMessage()    {}
func (*FieldId) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{3}
}
func (m *FieldId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_FieldId.Unmarshal(m, b)
}
func (m *FieldId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_FieldId.Marshal(b, m, deterministic)
}
func (dst *FieldId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_FieldId.Merge(dst, src)
}
func (m *FieldId) XXX_Size() int {
	return xxx_messageInfo_FieldId.Size(m)
}
func (m *FieldId) XXX_DiscardUnknown() {
	xxx_messageInfo_FieldId.DiscardUnknown(m)
}

var xxx_messageInfo_FieldId proto.InternalMessageInfo

func (m *FieldId) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Datastore partition ID.
// A partition ID identifies a grouping of entities. The grouping is always
// by project and namespace, however the namespace ID may be empty.
//
// A partition ID contains several dimensions:
// project ID and namespace ID.
type PartitionId struct {
	// The ID of the project to which the entities belong.
	ProjectId string `protobuf:"bytes,2,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// If not empty, the ID of the namespace to which the entities belong.
	NamespaceId          string   `protobuf:"bytes,4,opt,name=namespace_id,json=namespaceId,proto3" json:"namespace_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *PartitionId) Reset()         { *m = PartitionId{} }
func (m *PartitionId) String() string { return proto.CompactTextString(m) }
func (*PartitionId) ProtoMessage()    {}
func (*PartitionId) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{4}
}
func (m *PartitionId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_PartitionId.Unmarshal(m, b)
}
func (m *PartitionId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_PartitionId.Marshal(b, m, deterministic)
}
func (dst *PartitionId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_PartitionId.Merge(dst, src)
}
func (m *PartitionId) XXX_Size() int {
	return xxx_messageInfo_PartitionId.Size(m)
}
func (m *PartitionId) XXX_DiscardUnknown() {
	xxx_messageInfo_PartitionId.DiscardUnknown(m)
}

var xxx_messageInfo_PartitionId proto.InternalMessageInfo

func (m *PartitionId) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *PartitionId) GetNamespaceId() string {
	if m != nil {
		return m.NamespaceId
	}
	return ""
}

// A representation of a Datastore kind.
type KindExpression struct {
	// The name of the kind.
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *KindExpression) Reset()         { *m = KindExpression{} }
func (m *KindExpression) String() string { return proto.CompactTextString(m) }
func (*KindExpression) ProtoMessage()    {}
func (*KindExpression) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{5}
}
func (m *KindExpression) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_KindExpression.Unmarshal(m, b)
}
func (m *KindExpression) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_KindExpression.Marshal(b, m, deterministic)
}
func (dst *KindExpression) XXX_Merge(src proto.Message) {
	xxx_messageInfo_KindExpression.Merge(dst, src)
}
func (m *KindExpression) XXX_Size() int {
	return xxx_messageInfo_KindExpression.Size(m)
}
func (m *KindExpression) XXX_DiscardUnknown() {
	xxx_messageInfo_KindExpression.DiscardUnknown(m)
}

var xxx_messageInfo_KindExpression proto.InternalMessageInfo

func (m *KindExpression) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Options defining a data set within Google Cloud Datastore.
type DatastoreOptions struct {
	// A partition ID identifies a grouping of entities. The grouping is always
	// by project and namespace, however the namespace ID may be empty.
	PartitionId *PartitionId `protobuf:"bytes,1,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	// The kind to process.
	Kind                 *KindExpression `protobuf:"bytes,2,opt,name=kind,proto3" json:"kind,omitempty"`
	XXX_NoUnkeyedLiteral struct{}        `json:"-"`
	XXX_unrecognized     []byte          `json:"-"`
	XXX_sizecache        int32           `json:"-"`
}

func (m *DatastoreOptions) Reset()         { *m = DatastoreOptions{} }
func (m *DatastoreOptions) String() string { return proto.CompactTextString(m) }
func (*DatastoreOptions) ProtoMessage()    {}
func (*DatastoreOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{6}
}
func (m *DatastoreOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DatastoreOptions.Unmarshal(m, b)
}
func (m *DatastoreOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DatastoreOptions.Marshal(b, m, deterministic)
}
func (dst *DatastoreOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DatastoreOptions.Merge(dst, src)
}
func (m *DatastoreOptions) XXX_Size() int {
	return xxx_messageInfo_DatastoreOptions.Size(m)
}
func (m *DatastoreOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_DatastoreOptions.DiscardUnknown(m)
}

var xxx_messageInfo_DatastoreOptions proto.InternalMessageInfo

func (m *DatastoreOptions) GetPartitionId() *PartitionId {
	if m != nil {
		return m.PartitionId
	}
	return nil
}

func (m *DatastoreOptions) GetKind() *KindExpression {
	if m != nil {
		return m.Kind
	}
	return nil
}

// Message representing a set of files in a Cloud Storage bucket. Regular
// expressions are used to allow fine-grained control over which files in the
// bucket to include.
//
// Included files are those that match at least one item in `include_regex` and
// do not match any items in `exclude_regex`. Note that a file that matches
// items from both lists will _not_ be included. For a match to occur, the
// entire file path (i.e., everything in the url after the bucket name) must
// match the regular expression.
//
// For example, given the input `{bucket_name: "mybucket", include_regex:
// ["directory1/.*"], exclude_regex:
// ["directory1/excluded.*"]}`:
//
// * `gs://mybucket/directory1/myfile` will be included
// * `gs://mybucket/directory1/directory2/myfile` will be included (`.*` matches
// across `/`)
// * `gs://mybucket/directory0/directory1/myfile` will _not_ be included (the
// full path doesn't match any items in `include_regex`)
// * `gs://mybucket/directory1/excludedfile` will _not_ be included (the path
// matches an item in `exclude_regex`)
//
// If `include_regex` is left empty, it will match all files by default
// (this is equivalent to setting `include_regex: [".*"]`).
//
// Some other common use cases:
//
// * `{bucket_name: "mybucket", exclude_regex: [".*\.pdf"]}` will include all
// files in `mybucket` except for .pdf files
// * `{bucket_name: "mybucket", include_regex: ["directory/[^/]+"]}` will
// include all files directly under `gs://mybucket/directory/`, without matching
// across `/`
type CloudStorageRegexFileSet struct {
	// The name of a Cloud Storage bucket. Required.
	BucketName string `protobuf:"bytes,1,opt,name=bucket_name,json=bucketName,proto3" json:"bucket_name,omitempty"`
	// A list of regular expressions matching file paths to include. All files in
	// the bucket that match at least one of these regular expressions will be
	// included in the set of files, except for those that also match an item in
	// `exclude_regex`. Leaving this field empty will match all files by default
	// (this is equivalent to including `.*` in the list).
	//
	// Regular expressions use RE2
	// [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
	// under the google/re2 repository on GitHub.
	IncludeRegex []string `protobuf:"bytes,2,rep,name=include_regex,json=includeRegex,proto3" json:"include_regex,omitempty"`
	// A list of regular expressions matching file paths to exclude. All files in
	// the bucket that match at least one of these regular expressions will be
	// excluded from the scan.
	//
	// Regular expressions use RE2
	// [syntax](https://github.com/google/re2/wiki/Syntax); a guide can be found
	// under the google/re2 repository on GitHub.
	ExcludeRegex         []string `protobuf:"bytes,3,rep,name=exclude_regex,json=excludeRegex,proto3" json:"exclude_regex,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloudStorageRegexFileSet) Reset()         { *m = CloudStorageRegexFileSet{} }
func (m *CloudStorageRegexFileSet) String() string { return proto.CompactTextString(m) }
func (*CloudStorageRegexFileSet) ProtoMessage()    {}
func (*CloudStorageRegexFileSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{7}
}
func (m *CloudStorageRegexFileSet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudStorageRegexFileSet.Unmarshal(m, b)
}
func (m *CloudStorageRegexFileSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudStorageRegexFileSet.Marshal(b, m, deterministic)
}
func (dst *CloudStorageRegexFileSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudStorageRegexFileSet.Merge(dst, src)
}
func (m *CloudStorageRegexFileSet) XXX_Size() int {
	return xxx_messageInfo_CloudStorageRegexFileSet.Size(m)
}
func (m *CloudStorageRegexFileSet) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudStorageRegexFileSet.DiscardUnknown(m)
}

var xxx_messageInfo_CloudStorageRegexFileSet proto.InternalMessageInfo

func (m *CloudStorageRegexFileSet) GetBucketName() string {
	if m != nil {
		return m.BucketName
	}
	return ""
}

func (m *CloudStorageRegexFileSet) GetIncludeRegex() []string {
	if m != nil {
		return m.IncludeRegex
	}
	return nil
}

func (m *CloudStorageRegexFileSet) GetExcludeRegex() []string {
	if m != nil {
		return m.ExcludeRegex
	}
	return nil
}

// Options defining a file or a set of files within a Google Cloud Storage
// bucket.
type CloudStorageOptions struct {
	// The set of one or more files to scan.
	FileSet *CloudStorageOptions_FileSet `protobuf:"bytes,1,opt,name=file_set,json=fileSet,proto3" json:"file_set,omitempty"`
	// Max number of bytes to scan from a file. If a scanned file's size is bigger
	// than this value then the rest of the bytes are omitted. Only one
	// of bytes_limit_per_file and bytes_limit_per_file_percent can be specified.
	BytesLimitPerFile int64 `protobuf:"varint,4,opt,name=bytes_limit_per_file,json=bytesLimitPerFile,proto3" json:"bytes_limit_per_file,omitempty"`
	// Max percentage of bytes to scan from a file. The rest are omitted. The
	// number of bytes scanned is rounded down. Must be between 0 and 100,
	// inclusively. Both 0 and 100 means no limit. Defaults to 0. Only one
	// of bytes_limit_per_file and bytes_limit_per_file_percent can be specified.
	BytesLimitPerFilePercent int32 `protobuf:"varint,8,opt,name=bytes_limit_per_file_percent,json=bytesLimitPerFilePercent,proto3" json:"bytes_limit_per_file_percent,omitempty"`
	// List of file type groups to include in the scan.
	// If empty, all files are scanned and available data format processors
	// are applied. In addition, the binary content of the selected files
	// is always scanned as well.
	FileTypes    []FileType                       `protobuf:"varint,5,rep,packed,name=file_types,json=fileTypes,proto3,enum=google.privacy.dlp.v2.FileType" json:"file_types,omitempty"`
	SampleMethod CloudStorageOptions_SampleMethod `protobuf:"varint,6,opt,name=sample_method,json=sampleMethod,proto3,enum=google.privacy.dlp.v2.CloudStorageOptions_SampleMethod" json:"sample_method,omitempty"`
	// Limits the number of files to scan to this percentage of the input FileSet.
	// Number of files scanned is rounded down. Must be between 0 and 100,
	// inclusively. Both 0 and 100 means no limit. Defaults to 0.
	FilesLimitPercent    int32    `protobuf:"varint,7,opt,name=files_limit_percent,json=filesLimitPercent,proto3" json:"files_limit_percent,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloudStorageOptions) Reset()         { *m = CloudStorageOptions{} }
func (m *CloudStorageOptions) String() string { return proto.CompactTextString(m) }
func (*CloudStorageOptions) ProtoMessage()    {}
func (*CloudStorageOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{8}
}
func (m *CloudStorageOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudStorageOptions.Unmarshal(m, b)
}
func (m *CloudStorageOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudStorageOptions.Marshal(b, m, deterministic)
}
func (dst *CloudStorageOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudStorageOptions.Merge(dst, src)
}
func (m *CloudStorageOptions) XXX_Size() int {
	return xxx_messageInfo_CloudStorageOptions.Size(m)
}
func (m *CloudStorageOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudStorageOptions.DiscardUnknown(m)
}

var xxx_messageInfo_CloudStorageOptions proto.InternalMessageInfo

func (m *CloudStorageOptions) GetFileSet() *CloudStorageOptions_FileSet {
	if m != nil {
		return m.FileSet
	}
	return nil
}

func (m *CloudStorageOptions) GetBytesLimitPerFile() int64 {
	if m != nil {
		return m.BytesLimitPerFile
	}
	return 0
}

func (m *CloudStorageOptions) GetBytesLimitPerFilePercent() int32 {
	if m != nil {
		return m.BytesLimitPerFilePercent
	}
	return 0
}

func (m *CloudStorageOptions) GetFileTypes() []FileType {
	if m != nil {
		return m.FileTypes
	}
	return nil
}

func (m *CloudStorageOptions) GetSampleMethod() CloudStorageOptions_SampleMethod {
	if m != nil {
		return m.SampleMethod
	}
	return CloudStorageOptions_SAMPLE_METHOD_UNSPECIFIED
}

func (m *CloudStorageOptions) GetFilesLimitPercent() int32 {
	if m != nil {
		return m.FilesLimitPercent
	}
	return 0
}

// Set of files to scan.
type CloudStorageOptions_FileSet struct {
	// The Cloud Storage url of the file(s) to scan, in the format
	// `gs://<bucket>/<path>`. Trailing wildcard in the path is allowed.
	//
	// If the url ends in a trailing slash, the bucket or directory represented
	// by the url will be scanned non-recursively (content in sub-directories
	// will not be scanned). This means that `gs://mybucket/` is equivalent to
	// `gs://mybucket/*`, and `gs://mybucket/directory/` is equivalent to
	// `gs://mybucket/directory/*`.
	//
	// Exactly one of `url` or `regex_file_set` must be set.
	Url string `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	// The regex-filtered set of files to scan. Exactly one of `url` or
	// `regex_file_set` must be set.
	RegexFileSet         *CloudStorageRegexFileSet `protobuf:"bytes,2,opt,name=regex_file_set,json=regexFileSet,proto3" json:"regex_file_set,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                  `json:"-"`
	XXX_unrecognized     []byte                    `json:"-"`
	XXX_sizecache        int32                     `json:"-"`
}

func (m *CloudStorageOptions_FileSet) Reset()         { *m = CloudStorageOptions_FileSet{} }
func (m *CloudStorageOptions_FileSet) String() string { return proto.CompactTextString(m) }
func (*CloudStorageOptions_FileSet) ProtoMessage()    {}
func (*CloudStorageOptions_FileSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{8, 0}
}
func (m *CloudStorageOptions_FileSet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudStorageOptions_FileSet.Unmarshal(m, b)
}
func (m *CloudStorageOptions_FileSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudStorageOptions_FileSet.Marshal(b, m, deterministic)
}
func (dst *CloudStorageOptions_FileSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudStorageOptions_FileSet.Merge(dst, src)
}
func (m *CloudStorageOptions_FileSet) XXX_Size() int {
	return xxx_messageInfo_CloudStorageOptions_FileSet.Size(m)
}
func (m *CloudStorageOptions_FileSet) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudStorageOptions_FileSet.DiscardUnknown(m)
}

var xxx_messageInfo_CloudStorageOptions_FileSet proto.InternalMessageInfo

func (m *CloudStorageOptions_FileSet) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

func (m *CloudStorageOptions_FileSet) GetRegexFileSet() *CloudStorageRegexFileSet {
	if m != nil {
		return m.RegexFileSet
	}
	return nil
}

// Message representing a set of files in Cloud Storage.
type CloudStorageFileSet struct {
	// The url, in the format `gs://<bucket>/<path>`. Trailing wildcard in the
	// path is allowed.
	Url                  string   `protobuf:"bytes,1,opt,name=url,proto3" json:"url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloudStorageFileSet) Reset()         { *m = CloudStorageFileSet{} }
func (m *CloudStorageFileSet) String() string { return proto.CompactTextString(m) }
func (*CloudStorageFileSet) ProtoMessage()    {}
func (*CloudStorageFileSet) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{9}
}
func (m *CloudStorageFileSet) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudStorageFileSet.Unmarshal(m, b)
}
func (m *CloudStorageFileSet) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudStorageFileSet.Marshal(b, m, deterministic)
}
func (dst *CloudStorageFileSet) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudStorageFileSet.Merge(dst, src)
}
func (m *CloudStorageFileSet) XXX_Size() int {
	return xxx_messageInfo_CloudStorageFileSet.Size(m)
}
func (m *CloudStorageFileSet) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudStorageFileSet.DiscardUnknown(m)
}

var xxx_messageInfo_CloudStorageFileSet proto.InternalMessageInfo

func (m *CloudStorageFileSet) GetUrl() string {
	if m != nil {
		return m.Url
	}
	return ""
}

// Message representing a single file or path in Cloud Storage.
type CloudStoragePath struct {
	// A url representing a file or path (no wildcards) in Cloud Storage.
	// Example: gs://[BUCKET_NAME]/dictionary.txt
	Path                 string   `protobuf:"bytes,1,opt,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CloudStoragePath) Reset()         { *m = CloudStoragePath{} }
func (m *CloudStoragePath) String() string { return proto.CompactTextString(m) }
func (*CloudStoragePath) ProtoMessage()    {}
func (*CloudStoragePath) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{10}
}
func (m *CloudStoragePath) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CloudStoragePath.Unmarshal(m, b)
}
func (m *CloudStoragePath) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CloudStoragePath.Marshal(b, m, deterministic)
}
func (dst *CloudStoragePath) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CloudStoragePath.Merge(dst, src)
}
func (m *CloudStoragePath) XXX_Size() int {
	return xxx_messageInfo_CloudStoragePath.Size(m)
}
func (m *CloudStoragePath) XXX_DiscardUnknown() {
	xxx_messageInfo_CloudStoragePath.DiscardUnknown(m)
}

var xxx_messageInfo_CloudStoragePath proto.InternalMessageInfo

func (m *CloudStoragePath) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// Options defining BigQuery table and row identifiers.
type BigQueryOptions struct {
	// Complete BigQuery table reference.
	TableReference *BigQueryTable `protobuf:"bytes,1,opt,name=table_reference,json=tableReference,proto3" json:"table_reference,omitempty"`
	// References to fields uniquely identifying rows within the table.
	// Nested fields in the format, like `person.birthdate.year`, are allowed.
	IdentifyingFields []*FieldId `protobuf:"bytes,2,rep,name=identifying_fields,json=identifyingFields,proto3" json:"identifying_fields,omitempty"`
	// Max number of rows to scan. If the table has more rows than this value, the
	// rest of the rows are omitted. If not set, or if set to 0, all rows will be
	// scanned. Only one of rows_limit and rows_limit_percent can be specified.
	// Cannot be used in conjunction with TimespanConfig.
	RowsLimit int64 `protobuf:"varint,3,opt,name=rows_limit,json=rowsLimit,proto3" json:"rows_limit,omitempty"`
	// Max percentage of rows to scan. The rest are omitted. The number of rows
	// scanned is rounded down. Must be between 0 and 100, inclusively. Both 0 and
	// 100 means no limit. Defaults to 0. Only one of rows_limit and
	// rows_limit_percent can be specified. Cannot be used in conjunction with
	// TimespanConfig.
	RowsLimitPercent int32                        `protobuf:"varint,6,opt,name=rows_limit_percent,json=rowsLimitPercent,proto3" json:"rows_limit_percent,omitempty"`
	SampleMethod     BigQueryOptions_SampleMethod `protobuf:"varint,4,opt,name=sample_method,json=sampleMethod,proto3,enum=google.privacy.dlp.v2.BigQueryOptions_SampleMethod" json:"sample_method,omitempty"`
	// References to fields excluded from scanning. This allows you to skip
	// inspection of entire columns which you know have no findings.
	ExcludedFields       []*FieldId `protobuf:"bytes,5,rep,name=excluded_fields,json=excludedFields,proto3" json:"excluded_fields,omitempty"`
	XXX_NoUnkeyedLiteral struct{}   `json:"-"`
	XXX_unrecognized     []byte     `json:"-"`
	XXX_sizecache        int32      `json:"-"`
}

func (m *BigQueryOptions) Reset()         { *m = BigQueryOptions{} }
func (m *BigQueryOptions) String() string { return proto.CompactTextString(m) }
func (*BigQueryOptions) ProtoMessage()    {}
func (*BigQueryOptions) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{11}
}
func (m *BigQueryOptions) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BigQueryOptions.Unmarshal(m, b)
}
func (m *BigQueryOptions) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BigQueryOptions.Marshal(b, m, deterministic)
}
func (dst *BigQueryOptions) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BigQueryOptions.Merge(dst, src)
}
func (m *BigQueryOptions) XXX_Size() int {
	return xxx_messageInfo_BigQueryOptions.Size(m)
}
func (m *BigQueryOptions) XXX_DiscardUnknown() {
	xxx_messageInfo_BigQueryOptions.DiscardUnknown(m)
}

var xxx_messageInfo_BigQueryOptions proto.InternalMessageInfo

func (m *BigQueryOptions) GetTableReference() *BigQueryTable {
	if m != nil {
		return m.TableReference
	}
	return nil
}

func (m *BigQueryOptions) GetIdentifyingFields() []*FieldId {
	if m != nil {
		return m.IdentifyingFields
	}
	return nil
}

func (m *BigQueryOptions) GetRowsLimit() int64 {
	if m != nil {
		return m.RowsLimit
	}
	return 0
}

func (m *BigQueryOptions) GetRowsLimitPercent() int32 {
	if m != nil {
		return m.RowsLimitPercent
	}
	return 0
}

func (m *BigQueryOptions) GetSampleMethod() BigQueryOptions_SampleMethod {
	if m != nil {
		return m.SampleMethod
	}
	return BigQueryOptions_SAMPLE_METHOD_UNSPECIFIED
}

func (m *BigQueryOptions) GetExcludedFields() []*FieldId {
	if m != nil {
		return m.ExcludedFields
	}
	return nil
}

// Shared message indicating Cloud storage type.
type StorageConfig struct {
	// Types that are valid to be assigned to Type:
	//	*StorageConfig_DatastoreOptions
	//	*StorageConfig_CloudStorageOptions
	//	*StorageConfig_BigQueryOptions
	Type                 isStorageConfig_Type          `protobuf_oneof:"type"`
	TimespanConfig       *StorageConfig_TimespanConfig `protobuf:"bytes,6,opt,name=timespan_config,json=timespanConfig,proto3" json:"timespan_config,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                      `json:"-"`
	XXX_unrecognized     []byte                        `json:"-"`
	XXX_sizecache        int32                         `json:"-"`
}

func (m *StorageConfig) Reset()         { *m = StorageConfig{} }
func (m *StorageConfig) String() string { return proto.CompactTextString(m) }
func (*StorageConfig) ProtoMessage()    {}
func (*StorageConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{12}
}
func (m *StorageConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StorageConfig.Unmarshal(m, b)
}
func (m *StorageConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StorageConfig.Marshal(b, m, deterministic)
}
func (dst *StorageConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageConfig.Merge(dst, src)
}
func (m *StorageConfig) XXX_Size() int {
	return xxx_messageInfo_StorageConfig.Size(m)
}
func (m *StorageConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StorageConfig proto.InternalMessageInfo

type isStorageConfig_Type interface {
	isStorageConfig_Type()
}

type StorageConfig_DatastoreOptions struct {
	DatastoreOptions *DatastoreOptions `protobuf:"bytes,2,opt,name=datastore_options,json=datastoreOptions,proto3,oneof"`
}

type StorageConfig_CloudStorageOptions struct {
	CloudStorageOptions *CloudStorageOptions `protobuf:"bytes,3,opt,name=cloud_storage_options,json=cloudStorageOptions,proto3,oneof"`
}

type StorageConfig_BigQueryOptions struct {
	BigQueryOptions *BigQueryOptions `protobuf:"bytes,4,opt,name=big_query_options,json=bigQueryOptions,proto3,oneof"`
}

func (*StorageConfig_DatastoreOptions) isStorageConfig_Type() {}

func (*StorageConfig_CloudStorageOptions) isStorageConfig_Type() {}

func (*StorageConfig_BigQueryOptions) isStorageConfig_Type() {}

func (m *StorageConfig) GetType() isStorageConfig_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *StorageConfig) GetDatastoreOptions() *DatastoreOptions {
	if x, ok := m.GetType().(*StorageConfig_DatastoreOptions); ok {
		return x.DatastoreOptions
	}
	return nil
}

func (m *StorageConfig) GetCloudStorageOptions() *CloudStorageOptions {
	if x, ok := m.GetType().(*StorageConfig_CloudStorageOptions); ok {
		return x.CloudStorageOptions
	}
	return nil
}

func (m *StorageConfig) GetBigQueryOptions() *BigQueryOptions {
	if x, ok := m.GetType().(*StorageConfig_BigQueryOptions); ok {
		return x.BigQueryOptions
	}
	return nil
}

func (m *StorageConfig) GetTimespanConfig() *StorageConfig_TimespanConfig {
	if m != nil {
		return m.TimespanConfig
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*StorageConfig) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _StorageConfig_OneofMarshaler, _StorageConfig_OneofUnmarshaler, _StorageConfig_OneofSizer, []interface{}{
		(*StorageConfig_DatastoreOptions)(nil),
		(*StorageConfig_CloudStorageOptions)(nil),
		(*StorageConfig_BigQueryOptions)(nil),
	}
}

func _StorageConfig_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*StorageConfig)
	// type
	switch x := m.Type.(type) {
	case *StorageConfig_DatastoreOptions:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DatastoreOptions); err != nil {
			return err
		}
	case *StorageConfig_CloudStorageOptions:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CloudStorageOptions); err != nil {
			return err
		}
	case *StorageConfig_BigQueryOptions:
		b.EncodeVarint(4<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BigQueryOptions); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("StorageConfig.Type has unexpected type %T", x)
	}
	return nil
}

func _StorageConfig_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*StorageConfig)
	switch tag {
	case 2: // type.datastore_options
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DatastoreOptions)
		err := b.DecodeMessage(msg)
		m.Type = &StorageConfig_DatastoreOptions{msg}
		return true, err
	case 3: // type.cloud_storage_options
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CloudStorageOptions)
		err := b.DecodeMessage(msg)
		m.Type = &StorageConfig_CloudStorageOptions{msg}
		return true, err
	case 4: // type.big_query_options
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BigQueryOptions)
		err := b.DecodeMessage(msg)
		m.Type = &StorageConfig_BigQueryOptions{msg}
		return true, err
	default:
		return false, nil
	}
}

func _StorageConfig_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*StorageConfig)
	// type
	switch x := m.Type.(type) {
	case *StorageConfig_DatastoreOptions:
		s := proto.Size(x.DatastoreOptions)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageConfig_CloudStorageOptions:
		s := proto.Size(x.CloudStorageOptions)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *StorageConfig_BigQueryOptions:
		s := proto.Size(x.BigQueryOptions)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Configuration of the timespan of the items to include in scanning.
// Currently only supported when inspecting Google Cloud Storage and BigQuery.
type StorageConfig_TimespanConfig struct {
	// Exclude files or rows older than this value.
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// Exclude files or rows newer than this value.
	// If set to zero, no upper time limit is applied.
	EndTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Specification of the field containing the timestamp of scanned items.
	// Used for data sources like Datastore or BigQuery.
	// If not specified for BigQuery, table last modification timestamp
	// is checked against given time span.
	// The valid data types of the timestamp field are:
	// for BigQuery - timestamp, date, datetime;
	// for Datastore - timestamp.
	// Datastore entity will be scanned if the timestamp property does not exist
	// or its value is empty or invalid.
	TimestampField *FieldId `protobuf:"bytes,3,opt,name=timestamp_field,json=timestampField,proto3" json:"timestamp_field,omitempty"`
	// When the job is started by a JobTrigger we will automatically figure out
	// a valid start_time to avoid scanning files that have not been modified
	// since the last time the JobTrigger executed. This will be based on the
	// time of the execution of the last run of the JobTrigger.
	EnableAutoPopulationOfTimespanConfig bool     `protobuf:"varint,4,opt,name=enable_auto_population_of_timespan_config,json=enableAutoPopulationOfTimespanConfig,proto3" json:"enable_auto_population_of_timespan_config,omitempty"`
	XXX_NoUnkeyedLiteral                 struct{} `json:"-"`
	XXX_unrecognized                     []byte   `json:"-"`
	XXX_sizecache                        int32    `json:"-"`
}

func (m *StorageConfig_TimespanConfig) Reset()         { *m = StorageConfig_TimespanConfig{} }
func (m *StorageConfig_TimespanConfig) String() string { return proto.CompactTextString(m) }
func (*StorageConfig_TimespanConfig) ProtoMessage()    {}
func (*StorageConfig_TimespanConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{12, 0}
}
func (m *StorageConfig_TimespanConfig) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StorageConfig_TimespanConfig.Unmarshal(m, b)
}
func (m *StorageConfig_TimespanConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StorageConfig_TimespanConfig.Marshal(b, m, deterministic)
}
func (dst *StorageConfig_TimespanConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StorageConfig_TimespanConfig.Merge(dst, src)
}
func (m *StorageConfig_TimespanConfig) XXX_Size() int {
	return xxx_messageInfo_StorageConfig_TimespanConfig.Size(m)
}
func (m *StorageConfig_TimespanConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_StorageConfig_TimespanConfig.DiscardUnknown(m)
}

var xxx_messageInfo_StorageConfig_TimespanConfig proto.InternalMessageInfo

func (m *StorageConfig_TimespanConfig) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *StorageConfig_TimespanConfig) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

func (m *StorageConfig_TimespanConfig) GetTimestampField() *FieldId {
	if m != nil {
		return m.TimestampField
	}
	return nil
}

func (m *StorageConfig_TimespanConfig) GetEnableAutoPopulationOfTimespanConfig() bool {
	if m != nil {
		return m.EnableAutoPopulationOfTimespanConfig
	}
	return false
}

// Row key for identifying a record in BigQuery table.
type BigQueryKey struct {
	// Complete BigQuery table reference.
	TableReference *BigQueryTable `protobuf:"bytes,1,opt,name=table_reference,json=tableReference,proto3" json:"table_reference,omitempty"`
	// Absolute number of the row from the beginning of the table at the time
	// of scanning.
	RowNumber            int64    `protobuf:"varint,2,opt,name=row_number,json=rowNumber,proto3" json:"row_number,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BigQueryKey) Reset()         { *m = BigQueryKey{} }
func (m *BigQueryKey) String() string { return proto.CompactTextString(m) }
func (*BigQueryKey) ProtoMessage()    {}
func (*BigQueryKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{13}
}
func (m *BigQueryKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BigQueryKey.Unmarshal(m, b)
}
func (m *BigQueryKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BigQueryKey.Marshal(b, m, deterministic)
}
func (dst *BigQueryKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BigQueryKey.Merge(dst, src)
}
func (m *BigQueryKey) XXX_Size() int {
	return xxx_messageInfo_BigQueryKey.Size(m)
}
func (m *BigQueryKey) XXX_DiscardUnknown() {
	xxx_messageInfo_BigQueryKey.DiscardUnknown(m)
}

var xxx_messageInfo_BigQueryKey proto.InternalMessageInfo

func (m *BigQueryKey) GetTableReference() *BigQueryTable {
	if m != nil {
		return m.TableReference
	}
	return nil
}

func (m *BigQueryKey) GetRowNumber() int64 {
	if m != nil {
		return m.RowNumber
	}
	return 0
}

// Record key for a finding in Cloud Datastore.
type DatastoreKey struct {
	// Datastore entity key.
	EntityKey            *Key     `protobuf:"bytes,1,opt,name=entity_key,json=entityKey,proto3" json:"entity_key,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DatastoreKey) Reset()         { *m = DatastoreKey{} }
func (m *DatastoreKey) String() string { return proto.CompactTextString(m) }
func (*DatastoreKey) ProtoMessage()    {}
func (*DatastoreKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{14}
}
func (m *DatastoreKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DatastoreKey.Unmarshal(m, b)
}
func (m *DatastoreKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DatastoreKey.Marshal(b, m, deterministic)
}
func (dst *DatastoreKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DatastoreKey.Merge(dst, src)
}
func (m *DatastoreKey) XXX_Size() int {
	return xxx_messageInfo_DatastoreKey.Size(m)
}
func (m *DatastoreKey) XXX_DiscardUnknown() {
	xxx_messageInfo_DatastoreKey.DiscardUnknown(m)
}

var xxx_messageInfo_DatastoreKey proto.InternalMessageInfo

func (m *DatastoreKey) GetEntityKey() *Key {
	if m != nil {
		return m.EntityKey
	}
	return nil
}

// A unique identifier for a Datastore entity.
// If a key's partition ID or any of its path kinds or names are
// reserved/read-only, the key is reserved/read-only.
// A reserved/read-only key is forbidden in certain documented contexts.
type Key struct {
	// Entities are partitioned into subsets, currently identified by a project
	// ID and namespace ID.
	// Queries are scoped to a single partition.
	PartitionId *PartitionId `protobuf:"bytes,1,opt,name=partition_id,json=partitionId,proto3" json:"partition_id,omitempty"`
	// The entity path.
	// An entity path consists of one or more elements composed of a kind and a
	// string or numerical identifier, which identify entities. The first
	// element identifies a _root entity_, the second element identifies
	// a _child_ of the root entity, the third element identifies a child of the
	// second entity, and so forth. The entities identified by all prefixes of
	// the path are called the element's _ancestors_.
	//
	// A path can never be empty, and a path can have at most 100 elements.
	Path                 []*Key_PathElement `protobuf:"bytes,2,rep,name=path,proto3" json:"path,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *Key) Reset()         { *m = Key{} }
func (m *Key) String() string { return proto.CompactTextString(m) }
func (*Key) ProtoMessage()    {}
func (*Key) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{15}
}
func (m *Key) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Key.Unmarshal(m, b)
}
func (m *Key) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Key.Marshal(b, m, deterministic)
}
func (dst *Key) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Key.Merge(dst, src)
}
func (m *Key) XXX_Size() int {
	return xxx_messageInfo_Key.Size(m)
}
func (m *Key) XXX_DiscardUnknown() {
	xxx_messageInfo_Key.DiscardUnknown(m)
}

var xxx_messageInfo_Key proto.InternalMessageInfo

func (m *Key) GetPartitionId() *PartitionId {
	if m != nil {
		return m.PartitionId
	}
	return nil
}

func (m *Key) GetPath() []*Key_PathElement {
	if m != nil {
		return m.Path
	}
	return nil
}

// A (kind, ID/name) pair used to construct a key path.
//
// If either name or ID is set, the element is complete.
// If neither is set, the element is incomplete.
type Key_PathElement struct {
	// The kind of the entity.
	// A kind matching regex `__.*__` is reserved/read-only.
	// A kind must not contain more than 1500 bytes when UTF-8 encoded.
	// Cannot be `""`.
	Kind string `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	// The type of ID.
	//
	// Types that are valid to be assigned to IdType:
	//	*Key_PathElement_Id
	//	*Key_PathElement_Name
	IdType               isKey_PathElement_IdType `protobuf_oneof:"id_type"`
	XXX_NoUnkeyedLiteral struct{}                 `json:"-"`
	XXX_unrecognized     []byte                   `json:"-"`
	XXX_sizecache        int32                    `json:"-"`
}

func (m *Key_PathElement) Reset()         { *m = Key_PathElement{} }
func (m *Key_PathElement) String() string { return proto.CompactTextString(m) }
func (*Key_PathElement) ProtoMessage()    {}
func (*Key_PathElement) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{15, 0}
}
func (m *Key_PathElement) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_Key_PathElement.Unmarshal(m, b)
}
func (m *Key_PathElement) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_Key_PathElement.Marshal(b, m, deterministic)
}
func (dst *Key_PathElement) XXX_Merge(src proto.Message) {
	xxx_messageInfo_Key_PathElement.Merge(dst, src)
}
func (m *Key_PathElement) XXX_Size() int {
	return xxx_messageInfo_Key_PathElement.Size(m)
}
func (m *Key_PathElement) XXX_DiscardUnknown() {
	xxx_messageInfo_Key_PathElement.DiscardUnknown(m)
}

var xxx_messageInfo_Key_PathElement proto.InternalMessageInfo

func (m *Key_PathElement) GetKind() string {
	if m != nil {
		return m.Kind
	}
	return ""
}

type isKey_PathElement_IdType interface {
	isKey_PathElement_IdType()
}

type Key_PathElement_Id struct {
	Id int64 `protobuf:"varint,2,opt,name=id,proto3,oneof"`
}

type Key_PathElement_Name struct {
	Name string `protobuf:"bytes,3,opt,name=name,proto3,oneof"`
}

func (*Key_PathElement_Id) isKey_PathElement_IdType() {}

func (*Key_PathElement_Name) isKey_PathElement_IdType() {}

func (m *Key_PathElement) GetIdType() isKey_PathElement_IdType {
	if m != nil {
		return m.IdType
	}
	return nil
}

func (m *Key_PathElement) GetId() int64 {
	if x, ok := m.GetIdType().(*Key_PathElement_Id); ok {
		return x.Id
	}
	return 0
}

func (m *Key_PathElement) GetName() string {
	if x, ok := m.GetIdType().(*Key_PathElement_Name); ok {
		return x.Name
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*Key_PathElement) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _Key_PathElement_OneofMarshaler, _Key_PathElement_OneofUnmarshaler, _Key_PathElement_OneofSizer, []interface{}{
		(*Key_PathElement_Id)(nil),
		(*Key_PathElement_Name)(nil),
	}
}

func _Key_PathElement_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*Key_PathElement)
	// id_type
	switch x := m.IdType.(type) {
	case *Key_PathElement_Id:
		b.EncodeVarint(2<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.Id))
	case *Key_PathElement_Name:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Name)
	case nil:
	default:
		return fmt.Errorf("Key_PathElement.IdType has unexpected type %T", x)
	}
	return nil
}

func _Key_PathElement_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*Key_PathElement)
	switch tag {
	case 2: // id_type.id
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.IdType = &Key_PathElement_Id{int64(x)}
		return true, err
	case 3: // id_type.name
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.IdType = &Key_PathElement_Name{x}
		return true, err
	default:
		return false, nil
	}
}

func _Key_PathElement_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*Key_PathElement)
	// id_type
	switch x := m.IdType.(type) {
	case *Key_PathElement_Id:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(x.Id))
	case *Key_PathElement_Name:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Name)))
		n += len(x.Name)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Message for a unique key indicating a record that contains a finding.
type RecordKey struct {
	// Types that are valid to be assigned to Type:
	//	*RecordKey_DatastoreKey
	//	*RecordKey_BigQueryKey
	Type isRecordKey_Type `protobuf_oneof:"type"`
	// Values of identifying columns in the given row. Order of values matches
	// the order of field identifiers specified in the scanning request.
	IdValues             []string `protobuf:"bytes,5,rep,name=id_values,json=idValues,proto3" json:"id_values,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *RecordKey) Reset()         { *m = RecordKey{} }
func (m *RecordKey) String() string { return proto.CompactTextString(m) }
func (*RecordKey) ProtoMessage()    {}
func (*RecordKey) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{16}
}
func (m *RecordKey) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_RecordKey.Unmarshal(m, b)
}
func (m *RecordKey) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_RecordKey.Marshal(b, m, deterministic)
}
func (dst *RecordKey) XXX_Merge(src proto.Message) {
	xxx_messageInfo_RecordKey.Merge(dst, src)
}
func (m *RecordKey) XXX_Size() int {
	return xxx_messageInfo_RecordKey.Size(m)
}
func (m *RecordKey) XXX_DiscardUnknown() {
	xxx_messageInfo_RecordKey.DiscardUnknown(m)
}

var xxx_messageInfo_RecordKey proto.InternalMessageInfo

type isRecordKey_Type interface {
	isRecordKey_Type()
}

type RecordKey_DatastoreKey struct {
	DatastoreKey *DatastoreKey `protobuf:"bytes,2,opt,name=datastore_key,json=datastoreKey,proto3,oneof"`
}

type RecordKey_BigQueryKey struct {
	BigQueryKey *BigQueryKey `protobuf:"bytes,3,opt,name=big_query_key,json=bigQueryKey,proto3,oneof"`
}

func (*RecordKey_DatastoreKey) isRecordKey_Type() {}

func (*RecordKey_BigQueryKey) isRecordKey_Type() {}

func (m *RecordKey) GetType() isRecordKey_Type {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *RecordKey) GetDatastoreKey() *DatastoreKey {
	if x, ok := m.GetType().(*RecordKey_DatastoreKey); ok {
		return x.DatastoreKey
	}
	return nil
}

func (m *RecordKey) GetBigQueryKey() *BigQueryKey {
	if x, ok := m.GetType().(*RecordKey_BigQueryKey); ok {
		return x.BigQueryKey
	}
	return nil
}

func (m *RecordKey) GetIdValues() []string {
	if m != nil {
		return m.IdValues
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*RecordKey) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _RecordKey_OneofMarshaler, _RecordKey_OneofUnmarshaler, _RecordKey_OneofSizer, []interface{}{
		(*RecordKey_DatastoreKey)(nil),
		(*RecordKey_BigQueryKey)(nil),
	}
}

func _RecordKey_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*RecordKey)
	// type
	switch x := m.Type.(type) {
	case *RecordKey_DatastoreKey:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DatastoreKey); err != nil {
			return err
		}
	case *RecordKey_BigQueryKey:
		b.EncodeVarint(3<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BigQueryKey); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("RecordKey.Type has unexpected type %T", x)
	}
	return nil
}

func _RecordKey_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*RecordKey)
	switch tag {
	case 2: // type.datastore_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DatastoreKey)
		err := b.DecodeMessage(msg)
		m.Type = &RecordKey_DatastoreKey{msg}
		return true, err
	case 3: // type.big_query_key
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BigQueryKey)
		err := b.DecodeMessage(msg)
		m.Type = &RecordKey_BigQueryKey{msg}
		return true, err
	default:
		return false, nil
	}
}

func _RecordKey_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*RecordKey)
	// type
	switch x := m.Type.(type) {
	case *RecordKey_DatastoreKey:
		s := proto.Size(x.DatastoreKey)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *RecordKey_BigQueryKey:
		s := proto.Size(x.BigQueryKey)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Message defining the location of a BigQuery table. A table is uniquely
// identified  by its project_id, dataset_id, and table_name. Within a query
// a table is often referenced with a string in the format of:
// `<project_id>:<dataset_id>.<table_id>` or
// `<project_id>.<dataset_id>.<table_id>`.
type BigQueryTable struct {
	// The Google Cloud Platform project ID of the project containing the table.
	// If omitted, project ID is inferred from the API call.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// Dataset ID of the table.
	DatasetId string `protobuf:"bytes,2,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// Name of the table.
	TableId              string   `protobuf:"bytes,3,opt,name=table_id,json=tableId,proto3" json:"table_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BigQueryTable) Reset()         { *m = BigQueryTable{} }
func (m *BigQueryTable) String() string { return proto.CompactTextString(m) }
func (*BigQueryTable) ProtoMessage()    {}
func (*BigQueryTable) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{17}
}
func (m *BigQueryTable) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BigQueryTable.Unmarshal(m, b)
}
func (m *BigQueryTable) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BigQueryTable.Marshal(b, m, deterministic)
}
func (dst *BigQueryTable) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BigQueryTable.Merge(dst, src)
}
func (m *BigQueryTable) XXX_Size() int {
	return xxx_messageInfo_BigQueryTable.Size(m)
}
func (m *BigQueryTable) XXX_DiscardUnknown() {
	xxx_messageInfo_BigQueryTable.DiscardUnknown(m)
}

var xxx_messageInfo_BigQueryTable proto.InternalMessageInfo

func (m *BigQueryTable) GetProjectId() string {
	if m != nil {
		return m.ProjectId
	}
	return ""
}

func (m *BigQueryTable) GetDatasetId() string {
	if m != nil {
		return m.DatasetId
	}
	return ""
}

func (m *BigQueryTable) GetTableId() string {
	if m != nil {
		return m.TableId
	}
	return ""
}

// Message defining a field of a BigQuery table.
type BigQueryField struct {
	// Source table of the field.
	Table *BigQueryTable `protobuf:"bytes,1,opt,name=table,proto3" json:"table,omitempty"`
	// Designated field in the BigQuery table.
	Field                *FieldId `protobuf:"bytes,2,opt,name=field,proto3" json:"field,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BigQueryField) Reset()         { *m = BigQueryField{} }
func (m *BigQueryField) String() string { return proto.CompactTextString(m) }
func (*BigQueryField) ProtoMessage()    {}
func (*BigQueryField) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{18}
}
func (m *BigQueryField) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BigQueryField.Unmarshal(m, b)
}
func (m *BigQueryField) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BigQueryField.Marshal(b, m, deterministic)
}
func (dst *BigQueryField) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BigQueryField.Merge(dst, src)
}
func (m *BigQueryField) XXX_Size() int {
	return xxx_messageInfo_BigQueryField.Size(m)
}
func (m *BigQueryField) XXX_DiscardUnknown() {
	xxx_messageInfo_BigQueryField.DiscardUnknown(m)
}

var xxx_messageInfo_BigQueryField proto.InternalMessageInfo

func (m *BigQueryField) GetTable() *BigQueryTable {
	if m != nil {
		return m.Table
	}
	return nil
}

func (m *BigQueryField) GetField() *FieldId {
	if m != nil {
		return m.Field
	}
	return nil
}

// An entity in a dataset is a field or set of fields that correspond to a
// single person. For example, in medical records the `EntityId` might be a
// patient identifier, or for financial records it might be an account
// identifier. This message is used when generalizations or analysis must take
// into account that multiple rows correspond to the same entity.
type EntityId struct {
	// Composite key indicating which field contains the entity identifier.
	Field                *FieldId `protobuf:"bytes,1,opt,name=field,proto3" json:"field,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EntityId) Reset()         { *m = EntityId{} }
func (m *EntityId) String() string { return proto.CompactTextString(m) }
func (*EntityId) ProtoMessage()    {}
func (*EntityId) Descriptor() ([]byte, []int) {
	return fileDescriptor_storage_0642a70333f19630, []int{19}
}
func (m *EntityId) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EntityId.Unmarshal(m, b)
}
func (m *EntityId) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EntityId.Marshal(b, m, deterministic)
}
func (dst *EntityId) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EntityId.Merge(dst, src)
}
func (m *EntityId) XXX_Size() int {
	return xxx_messageInfo_EntityId.Size(m)
}
func (m *EntityId) XXX_DiscardUnknown() {
	xxx_messageInfo_EntityId.DiscardUnknown(m)
}

var xxx_messageInfo_EntityId proto.InternalMessageInfo

func (m *EntityId) GetField() *FieldId {
	if m != nil {
		return m.Field
	}
	return nil
}

func init() {
	proto.RegisterType((*InfoType)(nil), "google.privacy.dlp.v2.InfoType")
	proto.RegisterType((*StoredType)(nil), "google.privacy.dlp.v2.StoredType")
	proto.RegisterType((*CustomInfoType)(nil), "google.privacy.dlp.v2.CustomInfoType")
	proto.RegisterType((*CustomInfoType_Dictionary)(nil), "google.privacy.dlp.v2.CustomInfoType.Dictionary")
	proto.RegisterType((*CustomInfoType_Dictionary_WordList)(nil), "google.privacy.dlp.v2.CustomInfoType.Dictionary.WordList")
	proto.RegisterType((*CustomInfoType_Regex)(nil), "google.privacy.dlp.v2.CustomInfoType.Regex")
	proto.RegisterType((*CustomInfoType_SurrogateType)(nil), "google.privacy.dlp.v2.CustomInfoType.SurrogateType")
	proto.RegisterType((*CustomInfoType_DetectionRule)(nil), "google.privacy.dlp.v2.CustomInfoType.DetectionRule")
	proto.RegisterType((*CustomInfoType_DetectionRule_Proximity)(nil), "google.privacy.dlp.v2.CustomInfoType.DetectionRule.Proximity")
	proto.RegisterType((*CustomInfoType_DetectionRule_LikelihoodAdjustment)(nil), "google.privacy.dlp.v2.CustomInfoType.DetectionRule.LikelihoodAdjustment")
	proto.RegisterType((*CustomInfoType_DetectionRule_HotwordRule)(nil), "google.privacy.dlp.v2.CustomInfoType.DetectionRule.HotwordRule")
	proto.RegisterType((*FieldId)(nil), "google.privacy.dlp.v2.FieldId")
	proto.RegisterType((*PartitionId)(nil), "google.privacy.dlp.v2.PartitionId")
	proto.RegisterType((*KindExpression)(nil), "google.privacy.dlp.v2.KindExpression")
	proto.RegisterType((*DatastoreOptions)(nil), "google.privacy.dlp.v2.DatastoreOptions")
	proto.RegisterType((*CloudStorageRegexFileSet)(nil), "google.privacy.dlp.v2.CloudStorageRegexFileSet")
	proto.RegisterType((*CloudStorageOptions)(nil), "google.privacy.dlp.v2.CloudStorageOptions")
	proto.RegisterType((*CloudStorageOptions_FileSet)(nil), "google.privacy.dlp.v2.CloudStorageOptions.FileSet")
	proto.RegisterType((*CloudStorageFileSet)(nil), "google.privacy.dlp.v2.CloudStorageFileSet")
	proto.RegisterType((*CloudStoragePath)(nil), "google.privacy.dlp.v2.CloudStoragePath")
	proto.RegisterType((*BigQueryOptions)(nil), "google.privacy.dlp.v2.BigQueryOptions")
	proto.RegisterType((*StorageConfig)(nil), "google.privacy.dlp.v2.StorageConfig")
	proto.RegisterType((*StorageConfig_TimespanConfig)(nil), "google.privacy.dlp.v2.StorageConfig.TimespanConfig")
	proto.RegisterType((*BigQueryKey)(nil), "google.privacy.dlp.v2.BigQueryKey")
	proto.RegisterType((*DatastoreKey)(nil), "google.privacy.dlp.v2.DatastoreKey")
	proto.RegisterType((*Key)(nil), "google.privacy.dlp.v2.Key")
	proto.RegisterType((*Key_PathElement)(nil), "google.privacy.dlp.v2.Key.PathElement")
	proto.RegisterType((*RecordKey)(nil), "google.privacy.dlp.v2.RecordKey")
	proto.RegisterType((*BigQueryTable)(nil), "google.privacy.dlp.v2.BigQueryTable")
	proto.RegisterType((*BigQueryField)(nil), "google.privacy.dlp.v2.BigQueryField")
	proto.RegisterType((*EntityId)(nil), "google.privacy.dlp.v2.EntityId")
	proto.RegisterEnum("google.privacy.dlp.v2.Likelihood", Likelihood_name, Likelihood_value)
	proto.RegisterEnum("google.privacy.dlp.v2.FileType", FileType_name, FileType_value)
	proto.RegisterEnum("google.privacy.dlp.v2.CustomInfoType_ExclusionType", CustomInfoType_ExclusionType_name, CustomInfoType_ExclusionType_value)
	proto.RegisterEnum("google.privacy.dlp.v2.CloudStorageOptions_SampleMethod", CloudStorageOptions_SampleMethod_name, CloudStorageOptions_SampleMethod_value)
	proto.RegisterEnum("google.privacy.dlp.v2.BigQueryOptions_SampleMethod", BigQueryOptions_SampleMethod_name, BigQueryOptions_SampleMethod_value)
}

func init() {
	proto.RegisterFile("google/privacy/dlp/v2/storage.proto", fileDescriptor_storage_0642a70333f19630)
}

var fileDescriptor_storage_0642a70333f19630 = []byte{
	// 2075 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x58, 0xdd, 0x72, 0x1b, 0x49,
	0xf5, 0xd7, 0x48, 0x96, 0x2d, 0x1d, 0x7d, 0x58, 0xee, 0x24, 0x5b, 0xb2, 0xfe, 0x9b, 0xc4, 0x2b,
	0xe7, 0x9f, 0x35, 0x81, 0x92, 0xc0, 0x0b, 0x05, 0xd9, 0x85, 0x05, 0xcb, 0x92, 0xa3, 0xc1, 0x5f,
	0xa2, 0xa5, 0x38, 0xc9, 0x62, 0x6a, 0x18, 0x69, 0x5a, 0xf2, 0x6c, 0x46, 0x33, 0xc3, 0x4c, 0x8f,
	0x6d, 0x15, 0xc5, 0x05, 0x17, 0x5c, 0x73, 0xc3, 0x23, 0x50, 0x45, 0x15, 0xc5, 0x13, 0xc0, 0x3d,
	0x17, 0x3c, 0x04, 0x55, 0x7b, 0x49, 0xf1, 0x12, 0x54, 0x7f, 0xcc, 0x68, 0xa4, 0x58, 0x89, 0x9c,
	0xca, 0xdd, 0xf4, 0xe9, 0xf3, 0x3b, 0xdd, 0xe7, 0x9c, 0x5f, 0x9f, 0x3e, 0x3d, 0xb0, 0x3d, 0x72,
	0x9c, 0x91, 0x45, 0xea, 0xae, 0x67, 0x5e, 0xea, 0x83, 0x49, 0xdd, 0xb0, 0xdc, 0xfa, 0xe5, 0x6e,
	0xdd, 0xa7, 0x8e, 0xa7, 0x8f, 0x48, 0xcd, 0xf5, 0x1c, 0xea, 0xa0, 0x7b, 0x42, 0xa9, 0x26, 0x95,
	0x6a, 0x86, 0xe5, 0xd6, 0x2e, 0x77, 0x2b, 0x1f, 0x4b, 0xac, 0xee, 0x9a, 0x75, 0xdd, 0xb6, 0x1d,
	0xaa, 0x53, 0xd3, 0xb1, 0x7d, 0x01, 0xaa, 0x6c, 0xc6, 0x66, 0x3d, 0xe2, 0x3b, 0x81, 0x37, 0x90,
	0xf6, 0x2a, 0x0f, 0xa3, 0x45, 0x1d, 0xea, 0xf4, 0x83, 0x61, 0x9d, 0x9a, 0x63, 0xe2, 0x53, 0x7d,
	0xec, 0x0a, 0x85, 0xea, 0x03, 0xc8, 0xa8, 0xf6, 0xd0, 0xe9, 0x4d, 0x5c, 0x82, 0x10, 0xac, 0xd8,
	0xfa, 0x98, 0x94, 0x95, 0x2d, 0x65, 0x27, 0x8b, 0xf9, 0x77, 0xf5, 0x57, 0x00, 0x5d, 0xea, 0x78,
	0xc4, 0x58, 0xa4, 0x81, 0xbe, 0x80, 0xdc, 0xc0, 0x23, 0x3a, 0x25, 0x1a, 0xb3, 0x5d, 0x4e, 0x6e,
	0x29, 0x3b, 0xb9, 0xdd, 0x4a, 0x2d, 0x72, 0x44, 0x2c, 0x5c, 0xeb, 0x85, 0x0b, 0x63, 0x10, 0xea,
	0x4c, 0x50, 0xfd, 0xa6, 0x00, 0xc5, 0xfd, 0xc0, 0xa7, 0xce, 0x38, 0xda, 0xc5, 0x8f, 0x21, 0x6b,
	0xda, 0x43, 0x47, 0xa3, 0x13, 0x57, 0x2c, 0x94, 0xdb, 0x7d, 0x58, 0xbb, 0x31, 0x2c, 0xb5, 0x10,
	0x83, 0x33, 0x66, 0x88, 0xde, 0x03, 0xb0, 0xcc, 0xd7, 0xc4, 0x32, 0x2f, 0x1c, 0xc7, 0x28, 0xaf,
	0x6e, 0x29, 0x3b, 0xc5, 0xdd, 0x4f, 0x16, 0xc0, 0x8f, 0x22, 0x45, 0x1c, 0x03, 0x21, 0x0c, 0x60,
	0x98, 0x03, 0x16, 0x60, 0xdd, 0x9b, 0x48, 0x7f, 0xbe, 0xbb, 0xc0, 0xc4, 0xec, 0xde, 0x6b, 0xcd,
	0x08, 0xd7, 0x4e, 0xe0, 0x98, 0x15, 0xb4, 0x0f, 0x69, 0x8f, 0x8c, 0xc8, 0x75, 0x39, 0xc5, 0xcd,
	0x7d, 0x7b, 0x39, 0x73, 0x98, 0x41, 0xda, 0x09, 0x2c, 0xb0, 0xe8, 0x1c, 0x8a, 0x7e, 0xe0, 0x79,
	0xce, 0x88, 0x07, 0x9b, 0x85, 0x67, 0x85, 0x5b, 0xfb, 0x6c, 0x39, 0x6b, 0xdd, 0x10, 0xcb, 0x46,
	0xed, 0x04, 0x2e, 0xf8, 0x71, 0x01, 0x6a, 0x42, 0xce, 0xe7, 0x99, 0x16, 0xa6, 0xd3, 0xdc, 0xf4,
	0xa2, 0xd0, 0x4d, 0x39, 0xc1, 0x1c, 0xf5, 0xa7, 0x0c, 0x39, 0x87, 0x75, 0x83, 0x50, 0xc2, 0x1d,
	0xd7, 0xbc, 0xc0, 0x22, 0x7e, 0x79, 0x6d, 0x2b, 0xb5, 0xfc, 0x26, 0x9b, 0x21, 0x18, 0x07, 0x16,
	0xc1, 0x45, 0x23, 0x3e, 0xf4, 0xd1, 0x57, 0x50, 0x24, 0xd7, 0x03, 0x2b, 0xf0, 0x99, 0x75, 0xbe,
	0xcd, 0x0c, 0xcf, 0xf0, 0x92, 0xc6, 0x5b, 0x21, 0x96, 0x93, 0xa6, 0x40, 0xe2, 0xc3, 0xca, 0x7f,
	0x15, 0x80, 0x69, 0xfe, 0xd0, 0x4b, 0xc8, 0x5e, 0x39, 0x9e, 0xa1, 0x59, 0xa6, 0x4f, 0x25, 0x0d,
	0x9f, 0xde, 0x96, 0x04, 0xb5, 0x17, 0x8e, 0x67, 0x1c, 0x99, 0x3e, 0x6d, 0x27, 0x70, 0xe6, 0x4a,
	0x7e, 0xa3, 0x17, 0x80, 0x06, 0x96, 0x13, 0x18, 0x9a, 0x3c, 0xfa, 0x9a, 0xab, 0xd3, 0x0b, 0x49,
	0x8c, 0x4f, 0x17, 0x2d, 0xc1, 0x00, 0x5d, 0xa1, 0xdf, 0xd1, 0xe9, 0x45, 0x3b, 0x81, 0x4b, 0x83,
	0x39, 0x59, 0x65, 0x0b, 0x32, 0xe1, 0x82, 0xe8, 0x2e, 0xa4, 0xd9, 0x82, 0x7e, 0x59, 0xd9, 0x4a,
	0xed, 0x64, 0xb1, 0x18, 0x34, 0x32, 0xb0, 0x2a, 0xca, 0x43, 0xe5, 0x00, 0xd2, 0x9c, 0x5d, 0xa8,
	0x0c, 0x6b, 0xae, 0x4e, 0x29, 0xf1, 0x6c, 0x79, 0xaa, 0xc3, 0x21, 0xda, 0x86, 0xc2, 0xc8, 0x73,
	0x02, 0x57, 0x33, 0x6d, 0x83, 0x5c, 0x13, 0xbf, 0x9c, 0xdc, 0x4a, 0xed, 0xa4, 0x71, 0x9e, 0x0b,
	0x55, 0x21, 0xab, 0xac, 0x43, 0x61, 0x86, 0x57, 0x95, 0xbf, 0xa7, 0xa1, 0x30, 0x93, 0x44, 0x64,
	0x40, 0xfe, 0xc2, 0xa1, 0x3c, 0x98, 0x8c, 0x10, 0x32, 0x98, 0x3f, 0x7d, 0x0f, 0x3e, 0xd4, 0xda,
	0xc2, 0x0e, 0xfb, 0x6e, 0x27, 0x70, 0xee, 0x62, 0x3a, 0xac, 0x74, 0x21, 0xdb, 0xf1, 0x9c, 0x6b,
	0x73, 0x6c, 0xd2, 0x09, 0xdb, 0xfa, 0x95, 0x69, 0x1b, 0xce, 0x95, 0xd6, 0x27, 0x43, 0xc7, 0x13,
	0x6b, 0xa6, 0x71, 0x5e, 0x08, 0x1b, 0x5c, 0x86, 0x3e, 0x01, 0x39, 0xd6, 0xf4, 0x21, 0x25, 0x1e,
	0x3f, 0xe9, 0x69, 0x9c, 0x13, 0xb2, 0x3d, 0x26, 0xaa, 0xfc, 0x45, 0x81, 0xbb, 0xd3, 0x2a, 0xb1,
	0x67, 0x7c, 0x1d, 0xf8, 0x74, 0x4c, 0x6c, 0x8a, 0x4e, 0xa0, 0x34, 0x34, 0xaf, 0x09, 0xa3, 0x47,
	0x54, 0x6c, 0x94, 0x25, 0x8b, 0x4d, 0x3b, 0x81, 0xd7, 0x39, 0x78, 0x2a, 0x42, 0xdf, 0x83, 0x3b,
	0x1e, 0xb1, 0x74, 0x6a, 0x5e, 0x92, 0xb8, 0x49, 0xbe, 0xa5, 0x76, 0x02, 0xa3, 0x70, 0x72, 0x0a,
	0x69, 0xe4, 0x01, 0xf4, 0x68, 0x43, 0x95, 0x7f, 0x24, 0x21, 0x17, 0x8b, 0x0e, 0xea, 0x40, 0x21,
	0x0a, 0x3a, 0x2f, 0x3c, 0xca, 0xad, 0x0b, 0x0f, 0x0e, 0xd3, 0x26, 0x88, 0xf2, 0x4b, 0xc8, 0xba,
	0x61, 0x80, 0x65, 0x55, 0xfc, 0xc9, 0xfb, 0xe4, 0x30, 0xca, 0x12, 0x9e, 0xda, 0x43, 0xbf, 0x83,
	0x7b, 0x53, 0xb7, 0xb5, 0xa9, 0x5f, 0xf2, 0x58, 0xb4, 0xdf, 0x67, 0xa1, 0x9b, 0x12, 0x87, 0xef,
	0x5a, 0x37, 0x48, 0x1b, 0xab, 0xb0, 0xc2, 0xaa, 0x49, 0xf5, 0x10, 0x0a, 0x33, 0x35, 0x02, 0x3d,
	0x80, 0x4a, 0xeb, 0xe5, 0xfe, 0xd1, 0xf3, 0xae, 0x7a, 0x7a, 0xa2, 0xf5, 0x5e, 0x75, 0x5a, 0xda,
	0xf3, 0x93, 0x6e, 0xa7, 0xb5, 0xaf, 0x1e, 0xa8, 0xad, 0x66, 0x29, 0x81, 0x2a, 0xf0, 0xd1, 0xdc,
	0x3c, 0x1f, 0x36, 0x5b, 0x25, 0x25, 0x32, 0x7a, 0x1f, 0xd6, 0x0e, 0x4c, 0x62, 0x19, 0xaa, 0x71,
	0xe3, 0x0d, 0x7b, 0x0a, 0xb9, 0x8e, 0xee, 0x51, 0x93, 0xed, 0x5b, 0x35, 0xd0, 0x7d, 0x00, 0xd7,
	0x73, 0xbe, 0x26, 0x03, 0xaa, 0x99, 0x82, 0x00, 0x59, 0x1e, 0x28, 0x26, 0x51, 0x0d, 0x46, 0x5a,
	0x86, 0xf2, 0x5d, 0x7d, 0x40, 0x98, 0xc2, 0x0a, 0x57, 0xc8, 0x45, 0x32, 0xd5, 0xa8, 0x3e, 0x82,
	0xe2, 0xa1, 0x69, 0x1b, 0xad, 0x6b, 0xd7, 0x23, 0x3e, 0xf3, 0xe4, 0xc6, 0x65, 0xff, 0xa4, 0x40,
	0xa9, 0xa9, 0x53, 0x9d, 0xd7, 0xee, 0x53, 0x97, 0xf7, 0x13, 0xa8, 0x05, 0x79, 0x37, 0xdc, 0x0b,
	0xb3, 0x2e, 0x48, 0x53, 0x5d, 0x10, 0xfd, 0xd8, 0xb6, 0x71, 0xce, 0x8d, 0xf9, 0xf0, 0x14, 0x56,
	0x5e, 0x9b, 0xb6, 0x21, 0x59, 0xf2, 0xff, 0x0b, 0xe0, 0xb3, 0x9b, 0xc4, 0x1c, 0x52, 0xfd, 0x83,
	0x02, 0xe5, 0x78, 0xb1, 0xe3, 0xdc, 0x3b, 0x30, 0x2d, 0xd2, 0x25, 0x14, 0x3d, 0x84, 0x5c, 0x3f,
	0x18, 0xbc, 0x26, 0x54, 0x8b, 0xb9, 0x03, 0x42, 0x74, 0xc2, 0x7a, 0x91, 0x6d, 0x28, 0x98, 0xf6,
	0xc0, 0x0a, 0x0c, 0x22, 0x59, 0x9f, 0xe4, 0xd5, 0x2f, 0x2f, 0x85, 0x82, 0xc8, 0xdb, 0x20, 0x2a,
	0x7f, 0xa4, 0x94, 0x12, 0x4a, 0x52, 0xc8, 0x95, 0xaa, 0xdf, 0xac, 0xc0, 0x9d, 0xf8, 0x3e, 0xc2,
	0x08, 0x1d, 0x43, 0x66, 0x68, 0x5a, 0x44, 0xf3, 0x49, 0x78, 0x2b, 0xec, 0x2e, 0x51, 0xb2, 0x25,
	0xba, 0x26, 0x1d, 0xc1, 0x6b, 0x43, 0xe9, 0x51, 0x1d, 0xee, 0xf6, 0x27, 0x94, 0xf8, 0x9a, 0xc5,
	0xce, 0x81, 0xe6, 0x12, 0x4f, 0x63, 0x53, 0x3c, 0xad, 0x29, 0xbc, 0xc1, 0xe7, 0x8e, 0xd8, 0x54,
	0x87, 0x78, 0x0c, 0x8c, 0xbe, 0x84, 0x8f, 0x6f, 0x02, 0xb0, 0x8f, 0x01, 0x3b, 0x2f, 0x19, 0x5e,
	0xc4, 0xca, 0x6f, 0x00, 0x3b, 0x62, 0x1e, 0x7d, 0x09, 0xc0, 0xf5, 0x19, 0x33, 0xfd, 0x72, 0x7a,
	0x2b, 0xb5, 0x53, 0x5c, 0xd8, 0x5e, 0x31, 0x1c, 0xbf, 0x29, 0xb3, 0x43, 0xf9, 0xe5, 0xa3, 0x73,
	0x28, 0xf8, 0xfa, 0xd8, 0xb5, 0x88, 0x36, 0x26, 0xf4, 0x22, 0x6a, 0xb1, 0x7e, 0x78, 0x8b, 0x20,
	0x74, 0x39, 0xfe, 0x98, 0xc3, 0x71, 0xde, 0x8f, 0x8d, 0x50, 0x0d, 0xee, 0xb0, 0xa5, 0x62, 0xde,
	0x71, 0xa7, 0xd6, 0xb8, 0x53, 0x1b, 0x7c, 0x2a, 0x74, 0x8a, 0x4d, 0x54, 0x3c, 0x76, 0xb4, 0x44,
	0x24, 0x4b, 0x90, 0x0a, 0x3c, 0x4b, 0x72, 0x82, 0x7d, 0xa2, 0xe7, 0x50, 0xe4, 0xf9, 0xd5, 0xa2,
	0x84, 0x09, 0x3e, 0xd6, 0x97, 0xd8, 0x6b, 0x9c, 0x76, 0x38, 0xef, 0xc5, 0x46, 0xd5, 0x36, 0xe4,
	0xe3, 0x1e, 0xa0, 0xfb, 0xb0, 0xd9, 0xdd, 0x3b, 0xee, 0x1c, 0xb5, 0xb4, 0xe3, 0x56, 0xaf, 0x7d,
	0xda, 0x9c, 0xab, 0x10, 0x6b, 0x90, 0xea, 0x9d, 0x76, 0x4a, 0x0a, 0x2a, 0x41, 0x1e, 0xef, 0x9d,
	0x34, 0x4f, 0x8f, 0xb5, 0x6e, 0x6f, 0x0f, 0xf7, 0x4a, 0xc9, 0xea, 0xa7, 0xb3, 0x14, 0x5b, 0xe8,
	0x49, 0xf5, 0x31, 0x94, 0xe6, 0x1b, 0x00, 0x76, 0xa6, 0x79, 0xdf, 0x20, 0xcf, 0x34, 0xfb, 0xae,
	0xfe, 0x27, 0x05, 0xeb, 0x0d, 0x73, 0xf4, 0x8b, 0x80, 0x78, 0x93, 0x29, 0x61, 0xd7, 0xa9, 0xde,
	0xb7, 0x18, 0xd7, 0x87, 0xc4, 0x23, 0xf6, 0x20, 0xbc, 0x80, 0x1f, 0x2d, 0x08, 0x43, 0x68, 0xa0,
	0xc7, 0x50, 0xb8, 0xc8, 0xc1, 0x38, 0xc4, 0xa2, 0x63, 0x40, 0xa6, 0x41, 0x6c, 0x6a, 0x0e, 0x27,
	0xa6, 0x3d, 0xd2, 0x86, 0xac, 0xb0, 0x89, 0xce, 0x20, 0xb7, 0xfb, 0x60, 0x21, 0x8f, 0x78, 0xf5,
	0xc3, 0x1b, 0x31, 0x24, 0x97, 0xf9, 0xac, 0xda, 0x79, 0xce, 0x95, 0xcc, 0x37, 0x2f, 0xf6, 0x29,
	0x9c, 0x65, 0x12, 0x9e, 0x66, 0xf4, 0x1d, 0x40, 0xd3, 0xe9, 0x88, 0x0e, 0xab, 0x9c, 0x0e, 0xa5,
	0x48, 0x2d, 0xe4, 0xf6, 0xcb, 0x79, 0x6e, 0xae, 0xbc, 0xb5, 0x39, 0x9c, 0x8b, 0xd4, 0xdb, 0x78,
	0xf9, 0x0c, 0xd6, 0x65, 0x75, 0x30, 0x42, 0x97, 0xd3, 0x4b, 0xb9, 0x5c, 0x0c, 0x61, 0xc2, 0xdf,
	0x0f, 0x48, 0x9e, 0xbf, 0xa5, 0xa1, 0x20, 0xf9, 0xb0, 0xef, 0xd8, 0x43, 0x73, 0x84, 0xce, 0x60,
	0xc3, 0x08, 0x0b, 0xba, 0xe6, 0x08, 0xa7, 0x24, 0xe5, 0x17, 0xb5, 0x95, 0xf3, 0x17, 0x00, 0x6b,
	0x2b, 0x8d, 0xf9, 0x4b, 0xe1, 0xd7, 0x70, 0x6f, 0xb6, 0x5f, 0x0d, 0x6d, 0x8b, 0xbb, 0xf9, 0xc9,
	0xf2, 0x47, 0xbf, 0x9d, 0xc0, 0x77, 0x06, 0x37, 0x14, 0xd5, 0x1e, 0x6c, 0xf4, 0xcd, 0x91, 0xf6,
	0x1b, 0x96, 0x8d, 0xc8, 0xba, 0x78, 0xdb, 0x3c, 0x5e, 0x2e, 0x79, 0xac, 0xa7, 0xea, 0xcf, 0x31,
	0xff, 0x1c, 0xd6, 0xf9, 0x6b, 0xd7, 0xd5, 0x6d, 0x6d, 0xc0, 0x43, 0xc4, 0x99, 0xb3, 0xf8, 0x29,
	0x32, 0x13, 0x4e, 0xf1, 0x60, 0x75, 0x75, 0x5b, 0x0c, 0x71, 0x91, 0xce, 0x8c, 0x2b, 0x7f, 0x4e,
	0x42, 0x71, 0x56, 0x05, 0x3d, 0x05, 0xf0, 0xa9, 0xee, 0x51, 0xf1, 0x10, 0x56, 0xde, 0xf9, 0x10,
	0xce, 0x72, 0x6d, 0x36, 0x46, 0x3f, 0x80, 0x0c, 0xb1, 0x8d, 0x65, 0x5f, 0xd0, 0x6b, 0xc4, 0x36,
	0x38, 0xec, 0x99, 0x74, 0x91, 0x49, 0x05, 0x31, 0x65, 0x52, 0xde, 0xc9, 0xcb, 0x08, 0xc6, 0x25,
	0xe8, 0x05, 0x7c, 0x8b, 0xd8, 0xbc, 0x4c, 0xe8, 0x01, 0x75, 0x34, 0xd7, 0x71, 0x03, 0x8b, 0xff,
	0x63, 0xd0, 0x9c, 0xa1, 0x36, 0x1f, 0x45, 0x96, 0x99, 0x0c, 0x7e, 0x24, 0x00, 0x7b, 0x01, 0x75,
	0x3a, 0x91, 0xfa, 0xe9, 0x70, 0x36, 0x26, 0x51, 0x13, 0xf4, 0x5b, 0xc8, 0x85, 0x29, 0x3b, 0x24,
	0x93, 0x0f, 0x5d, 0x95, 0x44, 0x19, 0xd1, 0xec, 0x60, 0xdc, 0x97, 0x8d, 0xbc, 0x28, 0x23, 0x27,
	0x5c, 0x50, 0x55, 0x21, 0x1f, 0x31, 0x9d, 0xad, 0xfe, 0x14, 0x80, 0x15, 0x22, 0x3a, 0xd1, 0x5e,
	0x93, 0xc9, 0x9b, 0x89, 0x9a, 0xed, 0x52, 0xc8, 0x04, 0x67, 0x85, 0xf6, 0x21, 0x99, 0x54, 0xff,
	0xad, 0x40, 0x8a, 0x99, 0xf8, 0x40, 0x9d, 0xd2, 0xe7, 0xb2, 0x8a, 0x8b, 0x02, 0xfa, 0x78, 0xf1,
	0x1e, 0x6a, 0xac, 0xe8, 0xb7, 0x2c, 0xc2, 0x9b, 0x58, 0x8e, 0xa9, 0xf4, 0x58, 0xe3, 0x18, 0x09,
	0xd9, 0x85, 0xc0, 0x9b, 0x2e, 0x79, 0x21, 0xb0, 0x6f, 0x54, 0x82, 0xa4, 0x6c, 0x22, 0x53, 0xed,
	0x04, 0x4e, 0x9a, 0x06, 0xba, 0x2b, 0x5b, 0x41, 0x46, 0x93, 0x6c, 0x3b, 0x21, 0x9a, 0xc1, 0x46,
	0x16, 0xd6, 0x4c, 0xf1, 0xee, 0xaf, 0xfe, 0x53, 0x81, 0x2c, 0x26, 0x03, 0xc7, 0x33, 0x98, 0x9b,
	0x3f, 0x87, 0xc2, 0xb4, 0xa6, 0xb0, 0x60, 0x09, 0x72, 0x6e, 0xbf, 0xab, 0x9e, 0x1c, 0x92, 0x49,
	0x3b, 0x81, 0xf3, 0x46, 0x3c, 0xea, 0x6d, 0x28, 0x4c, 0x4f, 0x39, 0xb3, 0x95, 0x7a, 0x6b, 0xcc,
	0x62, 0x74, 0x61, 0x6f, 0xbd, 0x7e, 0x8c, 0x3d, 0xff, 0x07, 0x59, 0xd3, 0xd0, 0x2e, 0x75, 0x2b,
	0x90, 0x3d, 0x4c, 0x16, 0x67, 0x4c, 0xe3, 0x8c, 0x8f, 0x23, 0xc6, 0x5d, 0x40, 0x61, 0x86, 0x34,
	0x73, 0x9d, 0xb5, 0x32, 0xdf, 0x59, 0xdf, 0x07, 0xe0, 0xdb, 0x25, 0xf1, 0xc6, 0x5b, 0x4a, 0x54,
	0x03, 0x6d, 0x42, 0x46, 0x30, 0xd6, 0x14, 0x67, 0x2c, 0x8b, 0xd7, 0xf8, 0x58, 0x35, 0xaa, 0xbf,
	0x57, 0xa6, 0x4b, 0x89, 0xe3, 0xf4, 0x39, 0xa4, 0xf9, 0xe4, 0xad, 0x48, 0x2d, 0x20, 0xe8, 0xfb,
	0x90, 0x16, 0x27, 0x39, 0xb9, 0xd4, 0x49, 0x16, 0xca, 0xd5, 0x9f, 0x41, 0xa6, 0xc5, 0x49, 0xaa,
	0x1a, 0x53, 0x0b, 0xca, 0x2d, 0x2c, 0x3c, 0xa1, 0x00, 0xb1, 0x07, 0x69, 0x05, 0x3e, 0x3a, 0x52,
	0x0f, 0x5b, 0x47, 0x6a, 0xfb, 0xf4, 0x8d, 0x5b, 0x69, 0x03, 0x0a, 0x67, 0x2d, 0xfc, 0x4a, 0x7b,
	0x7e, 0xc2, 0x55, 0x5e, 0x95, 0x14, 0x94, 0x87, 0x4c, 0x34, 0x4a, 0xb2, 0x51, 0xe7, 0xb4, 0xdb,
	0x55, 0x1b, 0x47, 0xad, 0x52, 0x0a, 0x01, 0xac, 0xca, 0x99, 0x15, 0xb4, 0x0e, 0x39, 0x0e, 0x95,
	0x82, 0xf4, 0x93, 0x0e, 0x64, 0xc2, 0x36, 0x13, 0x6d, 0xc2, 0xbd, 0x03, 0xf5, 0xa8, 0x75, 0xd3,
	0x3b, 0x6b, 0x1d, 0x72, 0x0d, 0xf5, 0x64, 0x0f, 0xbf, 0xd2, 0x98, 0x46, 0x49, 0x41, 0x05, 0xc8,
	0xf6, 0x5a, 0x2f, 0x7b, 0x62, 0x98, 0x44, 0x59, 0x48, 0xab, 0xc7, 0x7b, 0xcf, 0x5a, 0xa5, 0x54,
	0xe3, 0x8f, 0x0a, 0x6c, 0x0e, 0x9c, 0xf1, 0xcd, 0x4e, 0x37, 0xa0, 0x69, 0xb9, 0x61, 0x1b, 0xa5,
	0x7c, 0xf5, 0x23, 0xa9, 0x34, 0x72, 0x2c, 0xdd, 0x1e, 0xd5, 0x1c, 0x6f, 0x54, 0x1f, 0x11, 0x9b,
	0x57, 0xdc, 0xba, 0x98, 0xd2, 0x5d, 0xd3, 0x9f, 0xfb, 0x65, 0xfb, 0x85, 0x61, 0xb9, 0x7f, 0x4d,
	0xde, 0x79, 0x26, 0xa0, 0xfc, 0x9a, 0xab, 0x35, 0x2d, 0xb7, 0x76, 0xb6, 0xfb, 0xaf, 0x50, 0x7a,
	0xce, 0xa5, 0xe7, 0x4d, 0xcb, 0x3d, 0x3f, 0xdb, 0xed, 0xaf, 0x72, 0x83, 0x9f, 0xfd, 0x2f, 0x00,
	0x00, 0xff, 0xff, 0xdc, 0x22, 0xe3, 0x78, 0x02, 0x16, 0x00, 0x00,
}
