// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/resources/ad_group_criterion.proto

package resources // import "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import wrappers "github.com/golang/protobuf/ptypes/wrappers"
import common "google.golang.org/genproto/googleapis/ads/googleads/v1/common"
import enums "google.golang.org/genproto/googleapis/ads/googleads/v1/enums"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// An ad group criterion.
type AdGroupCriterion struct {
	// The resource name of the ad group criterion.
	// Ad group criterion resource names have the form:
	//
	// `customers/{customer_id}/adGroupCriteria/{ad_group_id}~{criterion_id}`
	ResourceName string `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	// The ID of the criterion.
	//
	// This field is ignored for mutates.
	CriterionId *wrappers.Int64Value `protobuf:"bytes,26,opt,name=criterion_id,json=criterionId,proto3" json:"criterion_id,omitempty"`
	// The status of the criterion.
	Status enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus `protobuf:"varint,3,opt,name=status,proto3,enum=google.ads.googleads.v1.enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus" json:"status,omitempty"`
	// Information regarding the quality of the criterion.
	QualityInfo *AdGroupCriterion_QualityInfo `protobuf:"bytes,4,opt,name=quality_info,json=qualityInfo,proto3" json:"quality_info,omitempty"`
	// The ad group to which the criterion belongs.
	AdGroup *wrappers.StringValue `protobuf:"bytes,5,opt,name=ad_group,json=adGroup,proto3" json:"ad_group,omitempty"`
	// The type of the criterion.
	Type enums.CriterionTypeEnum_CriterionType `protobuf:"varint,25,opt,name=type,proto3,enum=google.ads.googleads.v1.enums.CriterionTypeEnum_CriterionType" json:"type,omitempty"`
	// Whether to target (`false`) or exclude (`true`) the criterion.
	//
	// This field is immutable. To switch a criterion from positive to negative,
	// remove then re-add it.
	Negative *wrappers.BoolValue `protobuf:"bytes,31,opt,name=negative,proto3" json:"negative,omitempty"`
	// Serving status of the criterion.
	SystemServingStatus enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus `protobuf:"varint,52,opt,name=system_serving_status,json=systemServingStatus,proto3,enum=google.ads.googleads.v1.enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus" json:"system_serving_status,omitempty"`
	// Approval status of the criterion.
	ApprovalStatus enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus `protobuf:"varint,53,opt,name=approval_status,json=approvalStatus,proto3,enum=google.ads.googleads.v1.enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus" json:"approval_status,omitempty"`
	// The modifier for the bid when the criterion matches. The modifier must be
	// in the range: 0.1 - 10.0. Most targetable criteria types support modifiers.
	BidModifier *wrappers.DoubleValue `protobuf:"bytes,44,opt,name=bid_modifier,json=bidModifier,proto3" json:"bid_modifier,omitempty"`
	// The CPC (cost-per-click) bid.
	CpcBidMicros *wrappers.Int64Value `protobuf:"bytes,16,opt,name=cpc_bid_micros,json=cpcBidMicros,proto3" json:"cpc_bid_micros,omitempty"`
	// The CPM (cost-per-thousand viewable impressions) bid.
	CpmBidMicros *wrappers.Int64Value `protobuf:"bytes,17,opt,name=cpm_bid_micros,json=cpmBidMicros,proto3" json:"cpm_bid_micros,omitempty"`
	// The CPV (cost-per-view) bid.
	CpvBidMicros *wrappers.Int64Value `protobuf:"bytes,24,opt,name=cpv_bid_micros,json=cpvBidMicros,proto3" json:"cpv_bid_micros,omitempty"`
	// The CPC bid amount, expressed as a fraction of the advertised price
	// for some good or service. The valid range for the fraction is [0,1) and the
	// value stored here is 1,000,000 * [fraction].
	PercentCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,33,opt,name=percent_cpc_bid_micros,json=percentCpcBidMicros,proto3" json:"percent_cpc_bid_micros,omitempty"`
	// The effective CPC (cost-per-click) bid.
	EffectiveCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,18,opt,name=effective_cpc_bid_micros,json=effectiveCpcBidMicros,proto3" json:"effective_cpc_bid_micros,omitempty"`
	// The effective CPM (cost-per-thousand viewable impressions) bid.
	EffectiveCpmBidMicros *wrappers.Int64Value `protobuf:"bytes,19,opt,name=effective_cpm_bid_micros,json=effectiveCpmBidMicros,proto3" json:"effective_cpm_bid_micros,omitempty"`
	// The effective CPV (cost-per-view) bid.
	EffectiveCpvBidMicros *wrappers.Int64Value `protobuf:"bytes,20,opt,name=effective_cpv_bid_micros,json=effectiveCpvBidMicros,proto3" json:"effective_cpv_bid_micros,omitempty"`
	// The effective Percent CPC bid amount.
	EffectivePercentCpcBidMicros *wrappers.Int64Value `protobuf:"bytes,34,opt,name=effective_percent_cpc_bid_micros,json=effectivePercentCpcBidMicros,proto3" json:"effective_percent_cpc_bid_micros,omitempty"`
	// Source of the effective CPC bid.
	EffectiveCpcBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,21,opt,name=effective_cpc_bid_source,json=effectiveCpcBidSource,proto3,enum=google.ads.googleads.v1.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpc_bid_source,omitempty"`
	// Source of the effective CPM bid.
	EffectiveCpmBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,22,opt,name=effective_cpm_bid_source,json=effectiveCpmBidSource,proto3,enum=google.ads.googleads.v1.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpm_bid_source,omitempty"`
	// Source of the effective CPV bid.
	EffectiveCpvBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,23,opt,name=effective_cpv_bid_source,json=effectiveCpvBidSource,proto3,enum=google.ads.googleads.v1.enums.BiddingSourceEnum_BiddingSource" json:"effective_cpv_bid_source,omitempty"`
	// Source of the effective Percent CPC bid.
	EffectivePercentCpcBidSource enums.BiddingSourceEnum_BiddingSource `protobuf:"varint,35,opt,name=effective_percent_cpc_bid_source,json=effectivePercentCpcBidSource,proto3,enum=google.ads.googleads.v1.enums.BiddingSourceEnum_BiddingSource" json:"effective_percent_cpc_bid_source,omitempty"`
	// Estimates for criterion bids at various positions.
	PositionEstimates *AdGroupCriterion_PositionEstimates `protobuf:"bytes,10,opt,name=position_estimates,json=positionEstimates,proto3" json:"position_estimates,omitempty"`
	// The list of possible final URLs after all cross-domain redirects for the
	// ad.
	FinalUrls []*wrappers.StringValue `protobuf:"bytes,11,rep,name=final_urls,json=finalUrls,proto3" json:"final_urls,omitempty"`
	// The list of possible final mobile URLs after all cross-domain redirects.
	FinalMobileUrls []*wrappers.StringValue `protobuf:"bytes,51,rep,name=final_mobile_urls,json=finalMobileUrls,proto3" json:"final_mobile_urls,omitempty"`
	// URL template for appending params to final URL.
	FinalUrlSuffix *wrappers.StringValue `protobuf:"bytes,50,opt,name=final_url_suffix,json=finalUrlSuffix,proto3" json:"final_url_suffix,omitempty"`
	// The URL template for constructing a tracking URL.
	TrackingUrlTemplate *wrappers.StringValue `protobuf:"bytes,13,opt,name=tracking_url_template,json=trackingUrlTemplate,proto3" json:"tracking_url_template,omitempty"`
	// The list of mappings used to substitute custom parameter tags in a
	// `tracking_url_template`, `final_urls`, or `mobile_final_urls`.
	UrlCustomParameters []*common.CustomParameter `protobuf:"bytes,14,rep,name=url_custom_parameters,json=urlCustomParameters,proto3" json:"url_custom_parameters,omitempty"`
	// The ad group criterion.
	//
	// Exactly one must be set.
	//
	// Types that are valid to be assigned to Criterion:
	//	*AdGroupCriterion_Keyword
	//	*AdGroupCriterion_Placement
	//	*AdGroupCriterion_MobileAppCategory
	//	*AdGroupCriterion_MobileApplication
	//	*AdGroupCriterion_ListingGroup
	//	*AdGroupCriterion_AgeRange
	//	*AdGroupCriterion_Gender
	//	*AdGroupCriterion_IncomeRange
	//	*AdGroupCriterion_ParentalStatus
	//	*AdGroupCriterion_UserList
	//	*AdGroupCriterion_YoutubeVideo
	//	*AdGroupCriterion_YoutubeChannel
	//	*AdGroupCriterion_Topic
	//	*AdGroupCriterion_UserInterest
	//	*AdGroupCriterion_Webpage
	//	*AdGroupCriterion_AppPaymentModel
	//	*AdGroupCriterion_CustomAffinity
	//	*AdGroupCriterion_CustomIntent
	Criterion            isAdGroupCriterion_Criterion `protobuf_oneof:"criterion"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *AdGroupCriterion) Reset()         { *m = AdGroupCriterion{} }
func (m *AdGroupCriterion) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterion) ProtoMessage()    {}
func (*AdGroupCriterion) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_criterion_18b9ede2c7927371, []int{0}
}
func (m *AdGroupCriterion) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterion.Unmarshal(m, b)
}
func (m *AdGroupCriterion) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterion.Marshal(b, m, deterministic)
}
func (dst *AdGroupCriterion) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterion.Merge(dst, src)
}
func (m *AdGroupCriterion) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterion.Size(m)
}
func (m *AdGroupCriterion) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterion.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterion proto.InternalMessageInfo

func (m *AdGroupCriterion) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func (m *AdGroupCriterion) GetCriterionId() *wrappers.Int64Value {
	if m != nil {
		return m.CriterionId
	}
	return nil
}

func (m *AdGroupCriterion) GetStatus() enums.AdGroupCriterionStatusEnum_AdGroupCriterionStatus {
	if m != nil {
		return m.Status
	}
	return enums.AdGroupCriterionStatusEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetQualityInfo() *AdGroupCriterion_QualityInfo {
	if m != nil {
		return m.QualityInfo
	}
	return nil
}

func (m *AdGroupCriterion) GetAdGroup() *wrappers.StringValue {
	if m != nil {
		return m.AdGroup
	}
	return nil
}

func (m *AdGroupCriterion) GetType() enums.CriterionTypeEnum_CriterionType {
	if m != nil {
		return m.Type
	}
	return enums.CriterionTypeEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetNegative() *wrappers.BoolValue {
	if m != nil {
		return m.Negative
	}
	return nil
}

func (m *AdGroupCriterion) GetSystemServingStatus() enums.CriterionSystemServingStatusEnum_CriterionSystemServingStatus {
	if m != nil {
		return m.SystemServingStatus
	}
	return enums.CriterionSystemServingStatusEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetApprovalStatus() enums.AdGroupCriterionApprovalStatusEnum_AdGroupCriterionApprovalStatus {
	if m != nil {
		return m.ApprovalStatus
	}
	return enums.AdGroupCriterionApprovalStatusEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetBidModifier() *wrappers.DoubleValue {
	if m != nil {
		return m.BidModifier
	}
	return nil
}

func (m *AdGroupCriterion) GetCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetCpmBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpmBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetCpvBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.CpvBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetPercentCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.PercentCpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveCpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpmBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveCpmBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpvBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectiveCpvBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectivePercentCpcBidMicros() *wrappers.Int64Value {
	if m != nil {
		return m.EffectivePercentCpcBidMicros
	}
	return nil
}

func (m *AdGroupCriterion) GetEffectiveCpcBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveCpcBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetEffectiveCpmBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveCpmBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetEffectiveCpvBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectiveCpvBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetEffectivePercentCpcBidSource() enums.BiddingSourceEnum_BiddingSource {
	if m != nil {
		return m.EffectivePercentCpcBidSource
	}
	return enums.BiddingSourceEnum_UNSPECIFIED
}

func (m *AdGroupCriterion) GetPositionEstimates() *AdGroupCriterion_PositionEstimates {
	if m != nil {
		return m.PositionEstimates
	}
	return nil
}

func (m *AdGroupCriterion) GetFinalUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalUrls
	}
	return nil
}

func (m *AdGroupCriterion) GetFinalMobileUrls() []*wrappers.StringValue {
	if m != nil {
		return m.FinalMobileUrls
	}
	return nil
}

func (m *AdGroupCriterion) GetFinalUrlSuffix() *wrappers.StringValue {
	if m != nil {
		return m.FinalUrlSuffix
	}
	return nil
}

func (m *AdGroupCriterion) GetTrackingUrlTemplate() *wrappers.StringValue {
	if m != nil {
		return m.TrackingUrlTemplate
	}
	return nil
}

func (m *AdGroupCriterion) GetUrlCustomParameters() []*common.CustomParameter {
	if m != nil {
		return m.UrlCustomParameters
	}
	return nil
}

type isAdGroupCriterion_Criterion interface {
	isAdGroupCriterion_Criterion()
}

type AdGroupCriterion_Keyword struct {
	Keyword *common.KeywordInfo `protobuf:"bytes,27,opt,name=keyword,proto3,oneof"`
}

type AdGroupCriterion_Placement struct {
	Placement *common.PlacementInfo `protobuf:"bytes,28,opt,name=placement,proto3,oneof"`
}

type AdGroupCriterion_MobileAppCategory struct {
	MobileAppCategory *common.MobileAppCategoryInfo `protobuf:"bytes,29,opt,name=mobile_app_category,json=mobileAppCategory,proto3,oneof"`
}

type AdGroupCriterion_MobileApplication struct {
	MobileApplication *common.MobileApplicationInfo `protobuf:"bytes,30,opt,name=mobile_application,json=mobileApplication,proto3,oneof"`
}

type AdGroupCriterion_ListingGroup struct {
	ListingGroup *common.ListingGroupInfo `protobuf:"bytes,32,opt,name=listing_group,json=listingGroup,proto3,oneof"`
}

type AdGroupCriterion_AgeRange struct {
	AgeRange *common.AgeRangeInfo `protobuf:"bytes,36,opt,name=age_range,json=ageRange,proto3,oneof"`
}

type AdGroupCriterion_Gender struct {
	Gender *common.GenderInfo `protobuf:"bytes,37,opt,name=gender,proto3,oneof"`
}

type AdGroupCriterion_IncomeRange struct {
	IncomeRange *common.IncomeRangeInfo `protobuf:"bytes,38,opt,name=income_range,json=incomeRange,proto3,oneof"`
}

type AdGroupCriterion_ParentalStatus struct {
	ParentalStatus *common.ParentalStatusInfo `protobuf:"bytes,39,opt,name=parental_status,json=parentalStatus,proto3,oneof"`
}

type AdGroupCriterion_UserList struct {
	UserList *common.UserListInfo `protobuf:"bytes,42,opt,name=user_list,json=userList,proto3,oneof"`
}

type AdGroupCriterion_YoutubeVideo struct {
	YoutubeVideo *common.YouTubeVideoInfo `protobuf:"bytes,40,opt,name=youtube_video,json=youtubeVideo,proto3,oneof"`
}

type AdGroupCriterion_YoutubeChannel struct {
	YoutubeChannel *common.YouTubeChannelInfo `protobuf:"bytes,41,opt,name=youtube_channel,json=youtubeChannel,proto3,oneof"`
}

type AdGroupCriterion_Topic struct {
	Topic *common.TopicInfo `protobuf:"bytes,43,opt,name=topic,proto3,oneof"`
}

type AdGroupCriterion_UserInterest struct {
	UserInterest *common.UserInterestInfo `protobuf:"bytes,45,opt,name=user_interest,json=userInterest,proto3,oneof"`
}

type AdGroupCriterion_Webpage struct {
	Webpage *common.WebpageInfo `protobuf:"bytes,46,opt,name=webpage,proto3,oneof"`
}

type AdGroupCriterion_AppPaymentModel struct {
	AppPaymentModel *common.AppPaymentModelInfo `protobuf:"bytes,47,opt,name=app_payment_model,json=appPaymentModel,proto3,oneof"`
}

type AdGroupCriterion_CustomAffinity struct {
	CustomAffinity *common.CustomAffinityInfo `protobuf:"bytes,48,opt,name=custom_affinity,json=customAffinity,proto3,oneof"`
}

type AdGroupCriterion_CustomIntent struct {
	CustomIntent *common.CustomIntentInfo `protobuf:"bytes,49,opt,name=custom_intent,json=customIntent,proto3,oneof"`
}

func (*AdGroupCriterion_Keyword) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Placement) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_MobileAppCategory) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_MobileApplication) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_ListingGroup) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_AgeRange) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Gender) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_IncomeRange) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_ParentalStatus) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_UserList) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_YoutubeVideo) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_YoutubeChannel) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Topic) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_UserInterest) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_Webpage) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_AppPaymentModel) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_CustomAffinity) isAdGroupCriterion_Criterion() {}

func (*AdGroupCriterion_CustomIntent) isAdGroupCriterion_Criterion() {}

func (m *AdGroupCriterion) GetCriterion() isAdGroupCriterion_Criterion {
	if m != nil {
		return m.Criterion
	}
	return nil
}

func (m *AdGroupCriterion) GetKeyword() *common.KeywordInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Keyword); ok {
		return x.Keyword
	}
	return nil
}

func (m *AdGroupCriterion) GetPlacement() *common.PlacementInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Placement); ok {
		return x.Placement
	}
	return nil
}

func (m *AdGroupCriterion) GetMobileAppCategory() *common.MobileAppCategoryInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_MobileAppCategory); ok {
		return x.MobileAppCategory
	}
	return nil
}

func (m *AdGroupCriterion) GetMobileApplication() *common.MobileApplicationInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_MobileApplication); ok {
		return x.MobileApplication
	}
	return nil
}

func (m *AdGroupCriterion) GetListingGroup() *common.ListingGroupInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_ListingGroup); ok {
		return x.ListingGroup
	}
	return nil
}

func (m *AdGroupCriterion) GetAgeRange() *common.AgeRangeInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_AgeRange); ok {
		return x.AgeRange
	}
	return nil
}

func (m *AdGroupCriterion) GetGender() *common.GenderInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Gender); ok {
		return x.Gender
	}
	return nil
}

func (m *AdGroupCriterion) GetIncomeRange() *common.IncomeRangeInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_IncomeRange); ok {
		return x.IncomeRange
	}
	return nil
}

func (m *AdGroupCriterion) GetParentalStatus() *common.ParentalStatusInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_ParentalStatus); ok {
		return x.ParentalStatus
	}
	return nil
}

func (m *AdGroupCriterion) GetUserList() *common.UserListInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_UserList); ok {
		return x.UserList
	}
	return nil
}

func (m *AdGroupCriterion) GetYoutubeVideo() *common.YouTubeVideoInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_YoutubeVideo); ok {
		return x.YoutubeVideo
	}
	return nil
}

func (m *AdGroupCriterion) GetYoutubeChannel() *common.YouTubeChannelInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_YoutubeChannel); ok {
		return x.YoutubeChannel
	}
	return nil
}

func (m *AdGroupCriterion) GetTopic() *common.TopicInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Topic); ok {
		return x.Topic
	}
	return nil
}

func (m *AdGroupCriterion) GetUserInterest() *common.UserInterestInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_UserInterest); ok {
		return x.UserInterest
	}
	return nil
}

func (m *AdGroupCriterion) GetWebpage() *common.WebpageInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_Webpage); ok {
		return x.Webpage
	}
	return nil
}

func (m *AdGroupCriterion) GetAppPaymentModel() *common.AppPaymentModelInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_AppPaymentModel); ok {
		return x.AppPaymentModel
	}
	return nil
}

func (m *AdGroupCriterion) GetCustomAffinity() *common.CustomAffinityInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_CustomAffinity); ok {
		return x.CustomAffinity
	}
	return nil
}

func (m *AdGroupCriterion) GetCustomIntent() *common.CustomIntentInfo {
	if x, ok := m.GetCriterion().(*AdGroupCriterion_CustomIntent); ok {
		return x.CustomIntent
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*AdGroupCriterion) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _AdGroupCriterion_OneofMarshaler, _AdGroupCriterion_OneofUnmarshaler, _AdGroupCriterion_OneofSizer, []interface{}{
		(*AdGroupCriterion_Keyword)(nil),
		(*AdGroupCriterion_Placement)(nil),
		(*AdGroupCriterion_MobileAppCategory)(nil),
		(*AdGroupCriterion_MobileApplication)(nil),
		(*AdGroupCriterion_ListingGroup)(nil),
		(*AdGroupCriterion_AgeRange)(nil),
		(*AdGroupCriterion_Gender)(nil),
		(*AdGroupCriterion_IncomeRange)(nil),
		(*AdGroupCriterion_ParentalStatus)(nil),
		(*AdGroupCriterion_UserList)(nil),
		(*AdGroupCriterion_YoutubeVideo)(nil),
		(*AdGroupCriterion_YoutubeChannel)(nil),
		(*AdGroupCriterion_Topic)(nil),
		(*AdGroupCriterion_UserInterest)(nil),
		(*AdGroupCriterion_Webpage)(nil),
		(*AdGroupCriterion_AppPaymentModel)(nil),
		(*AdGroupCriterion_CustomAffinity)(nil),
		(*AdGroupCriterion_CustomIntent)(nil),
	}
}

func _AdGroupCriterion_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*AdGroupCriterion)
	// criterion
	switch x := m.Criterion.(type) {
	case *AdGroupCriterion_Keyword:
		b.EncodeVarint(27<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Keyword); err != nil {
			return err
		}
	case *AdGroupCriterion_Placement:
		b.EncodeVarint(28<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Placement); err != nil {
			return err
		}
	case *AdGroupCriterion_MobileAppCategory:
		b.EncodeVarint(29<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MobileAppCategory); err != nil {
			return err
		}
	case *AdGroupCriterion_MobileApplication:
		b.EncodeVarint(30<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.MobileApplication); err != nil {
			return err
		}
	case *AdGroupCriterion_ListingGroup:
		b.EncodeVarint(32<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ListingGroup); err != nil {
			return err
		}
	case *AdGroupCriterion_AgeRange:
		b.EncodeVarint(36<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AgeRange); err != nil {
			return err
		}
	case *AdGroupCriterion_Gender:
		b.EncodeVarint(37<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Gender); err != nil {
			return err
		}
	case *AdGroupCriterion_IncomeRange:
		b.EncodeVarint(38<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.IncomeRange); err != nil {
			return err
		}
	case *AdGroupCriterion_ParentalStatus:
		b.EncodeVarint(39<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ParentalStatus); err != nil {
			return err
		}
	case *AdGroupCriterion_UserList:
		b.EncodeVarint(42<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.UserList); err != nil {
			return err
		}
	case *AdGroupCriterion_YoutubeVideo:
		b.EncodeVarint(40<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.YoutubeVideo); err != nil {
			return err
		}
	case *AdGroupCriterion_YoutubeChannel:
		b.EncodeVarint(41<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.YoutubeChannel); err != nil {
			return err
		}
	case *AdGroupCriterion_Topic:
		b.EncodeVarint(43<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Topic); err != nil {
			return err
		}
	case *AdGroupCriterion_UserInterest:
		b.EncodeVarint(45<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.UserInterest); err != nil {
			return err
		}
	case *AdGroupCriterion_Webpage:
		b.EncodeVarint(46<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Webpage); err != nil {
			return err
		}
	case *AdGroupCriterion_AppPaymentModel:
		b.EncodeVarint(47<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.AppPaymentModel); err != nil {
			return err
		}
	case *AdGroupCriterion_CustomAffinity:
		b.EncodeVarint(48<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CustomAffinity); err != nil {
			return err
		}
	case *AdGroupCriterion_CustomIntent:
		b.EncodeVarint(49<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CustomIntent); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("AdGroupCriterion.Criterion has unexpected type %T", x)
	}
	return nil
}

func _AdGroupCriterion_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*AdGroupCriterion)
	switch tag {
	case 27: // criterion.keyword
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.KeywordInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_Keyword{msg}
		return true, err
	case 28: // criterion.placement
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.PlacementInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_Placement{msg}
		return true, err
	case 29: // criterion.mobile_app_category
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.MobileAppCategoryInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_MobileAppCategory{msg}
		return true, err
	case 30: // criterion.mobile_application
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.MobileApplicationInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_MobileApplication{msg}
		return true, err
	case 32: // criterion.listing_group
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.ListingGroupInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_ListingGroup{msg}
		return true, err
	case 36: // criterion.age_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.AgeRangeInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_AgeRange{msg}
		return true, err
	case 37: // criterion.gender
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.GenderInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_Gender{msg}
		return true, err
	case 38: // criterion.income_range
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.IncomeRangeInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_IncomeRange{msg}
		return true, err
	case 39: // criterion.parental_status
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.ParentalStatusInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_ParentalStatus{msg}
		return true, err
	case 42: // criterion.user_list
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.UserListInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_UserList{msg}
		return true, err
	case 40: // criterion.youtube_video
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.YouTubeVideoInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_YoutubeVideo{msg}
		return true, err
	case 41: // criterion.youtube_channel
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.YouTubeChannelInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_YoutubeChannel{msg}
		return true, err
	case 43: // criterion.topic
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.TopicInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_Topic{msg}
		return true, err
	case 45: // criterion.user_interest
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.UserInterestInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_UserInterest{msg}
		return true, err
	case 46: // criterion.webpage
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.WebpageInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_Webpage{msg}
		return true, err
	case 47: // criterion.app_payment_model
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.AppPaymentModelInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_AppPaymentModel{msg}
		return true, err
	case 48: // criterion.custom_affinity
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.CustomAffinityInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_CustomAffinity{msg}
		return true, err
	case 49: // criterion.custom_intent
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(common.CustomIntentInfo)
		err := b.DecodeMessage(msg)
		m.Criterion = &AdGroupCriterion_CustomIntent{msg}
		return true, err
	default:
		return false, nil
	}
}

func _AdGroupCriterion_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*AdGroupCriterion)
	// criterion
	switch x := m.Criterion.(type) {
	case *AdGroupCriterion_Keyword:
		s := proto.Size(x.Keyword)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_Placement:
		s := proto.Size(x.Placement)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_MobileAppCategory:
		s := proto.Size(x.MobileAppCategory)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_MobileApplication:
		s := proto.Size(x.MobileApplication)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_ListingGroup:
		s := proto.Size(x.ListingGroup)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_AgeRange:
		s := proto.Size(x.AgeRange)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_Gender:
		s := proto.Size(x.Gender)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_IncomeRange:
		s := proto.Size(x.IncomeRange)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_ParentalStatus:
		s := proto.Size(x.ParentalStatus)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_UserList:
		s := proto.Size(x.UserList)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_YoutubeVideo:
		s := proto.Size(x.YoutubeVideo)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_YoutubeChannel:
		s := proto.Size(x.YoutubeChannel)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_Topic:
		s := proto.Size(x.Topic)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_UserInterest:
		s := proto.Size(x.UserInterest)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_Webpage:
		s := proto.Size(x.Webpage)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_AppPaymentModel:
		s := proto.Size(x.AppPaymentModel)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_CustomAffinity:
		s := proto.Size(x.CustomAffinity)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *AdGroupCriterion_CustomIntent:
		s := proto.Size(x.CustomIntent)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// A container for ad group criterion quality information.
type AdGroupCriterion_QualityInfo struct {
	// The quality score.
	//
	// This field may not be populated if Google does not have enough
	// information to determine a value.
	QualityScore *wrappers.Int32Value `protobuf:"bytes,1,opt,name=quality_score,json=qualityScore,proto3" json:"quality_score,omitempty"`
	// The performance of the ad compared to other advertisers.
	CreativeQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,2,opt,name=creative_quality_score,json=creativeQualityScore,proto3,enum=google.ads.googleads.v1.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"creative_quality_score,omitempty"`
	// The quality score of the landing page.
	PostClickQualityScore enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,3,opt,name=post_click_quality_score,json=postClickQualityScore,proto3,enum=google.ads.googleads.v1.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"post_click_quality_score,omitempty"`
	// The click-through rate compared to that of other advertisers.
	SearchPredictedCtr   enums.QualityScoreBucketEnum_QualityScoreBucket `protobuf:"varint,4,opt,name=search_predicted_ctr,json=searchPredictedCtr,proto3,enum=google.ads.googleads.v1.enums.QualityScoreBucketEnum_QualityScoreBucket" json:"search_predicted_ctr,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                        `json:"-"`
	XXX_unrecognized     []byte                                          `json:"-"`
	XXX_sizecache        int32                                           `json:"-"`
}

func (m *AdGroupCriterion_QualityInfo) Reset()         { *m = AdGroupCriterion_QualityInfo{} }
func (m *AdGroupCriterion_QualityInfo) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterion_QualityInfo) ProtoMessage()    {}
func (*AdGroupCriterion_QualityInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_criterion_18b9ede2c7927371, []int{0, 0}
}
func (m *AdGroupCriterion_QualityInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterion_QualityInfo.Unmarshal(m, b)
}
func (m *AdGroupCriterion_QualityInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterion_QualityInfo.Marshal(b, m, deterministic)
}
func (dst *AdGroupCriterion_QualityInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterion_QualityInfo.Merge(dst, src)
}
func (m *AdGroupCriterion_QualityInfo) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterion_QualityInfo.Size(m)
}
func (m *AdGroupCriterion_QualityInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterion_QualityInfo.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterion_QualityInfo proto.InternalMessageInfo

func (m *AdGroupCriterion_QualityInfo) GetQualityScore() *wrappers.Int32Value {
	if m != nil {
		return m.QualityScore
	}
	return nil
}

func (m *AdGroupCriterion_QualityInfo) GetCreativeQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.CreativeQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *AdGroupCriterion_QualityInfo) GetPostClickQualityScore() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.PostClickQualityScore
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

func (m *AdGroupCriterion_QualityInfo) GetSearchPredictedCtr() enums.QualityScoreBucketEnum_QualityScoreBucket {
	if m != nil {
		return m.SearchPredictedCtr
	}
	return enums.QualityScoreBucketEnum_UNSPECIFIED
}

// Estimates for criterion bids at various positions.
type AdGroupCriterion_PositionEstimates struct {
	// The estimate of the CPC bid required for ad to be shown on first
	// page of search results.
	FirstPageCpcMicros *wrappers.Int64Value `protobuf:"bytes,1,opt,name=first_page_cpc_micros,json=firstPageCpcMicros,proto3" json:"first_page_cpc_micros,omitempty"`
	// The estimate of the CPC bid required for ad to be displayed in first
	// position, at the top of the first page of search results.
	FirstPositionCpcMicros *wrappers.Int64Value `protobuf:"bytes,2,opt,name=first_position_cpc_micros,json=firstPositionCpcMicros,proto3" json:"first_position_cpc_micros,omitempty"`
	// The estimate of the CPC bid required for ad to be displayed at the top
	// of the first page of search results.
	TopOfPageCpcMicros *wrappers.Int64Value `protobuf:"bytes,3,opt,name=top_of_page_cpc_micros,json=topOfPageCpcMicros,proto3" json:"top_of_page_cpc_micros,omitempty"`
	// Estimate of how many clicks per week you might get by changing your
	// keyword bid to the value in first_position_cpc_micros.
	EstimatedAddClicksAtFirstPositionCpc *wrappers.Int64Value `protobuf:"bytes,4,opt,name=estimated_add_clicks_at_first_position_cpc,json=estimatedAddClicksAtFirstPositionCpc,proto3" json:"estimated_add_clicks_at_first_position_cpc,omitempty"`
	// Estimate of how your cost per week might change when changing your
	// keyword bid to the value in first_position_cpc_micros.
	EstimatedAddCostAtFirstPositionCpc *wrappers.Int64Value `protobuf:"bytes,5,opt,name=estimated_add_cost_at_first_position_cpc,json=estimatedAddCostAtFirstPositionCpc,proto3" json:"estimated_add_cost_at_first_position_cpc,omitempty"`
	XXX_NoUnkeyedLiteral               struct{}             `json:"-"`
	XXX_unrecognized                   []byte               `json:"-"`
	XXX_sizecache                      int32                `json:"-"`
}

func (m *AdGroupCriterion_PositionEstimates) Reset()         { *m = AdGroupCriterion_PositionEstimates{} }
func (m *AdGroupCriterion_PositionEstimates) String() string { return proto.CompactTextString(m) }
func (*AdGroupCriterion_PositionEstimates) ProtoMessage()    {}
func (*AdGroupCriterion_PositionEstimates) Descriptor() ([]byte, []int) {
	return fileDescriptor_ad_group_criterion_18b9ede2c7927371, []int{0, 1}
}
func (m *AdGroupCriterion_PositionEstimates) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_AdGroupCriterion_PositionEstimates.Unmarshal(m, b)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_AdGroupCriterion_PositionEstimates.Marshal(b, m, deterministic)
}
func (dst *AdGroupCriterion_PositionEstimates) XXX_Merge(src proto.Message) {
	xxx_messageInfo_AdGroupCriterion_PositionEstimates.Merge(dst, src)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_Size() int {
	return xxx_messageInfo_AdGroupCriterion_PositionEstimates.Size(m)
}
func (m *AdGroupCriterion_PositionEstimates) XXX_DiscardUnknown() {
	xxx_messageInfo_AdGroupCriterion_PositionEstimates.DiscardUnknown(m)
}

var xxx_messageInfo_AdGroupCriterion_PositionEstimates proto.InternalMessageInfo

func (m *AdGroupCriterion_PositionEstimates) GetFirstPageCpcMicros() *wrappers.Int64Value {
	if m != nil {
		return m.FirstPageCpcMicros
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetFirstPositionCpcMicros() *wrappers.Int64Value {
	if m != nil {
		return m.FirstPositionCpcMicros
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetTopOfPageCpcMicros() *wrappers.Int64Value {
	if m != nil {
		return m.TopOfPageCpcMicros
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetEstimatedAddClicksAtFirstPositionCpc() *wrappers.Int64Value {
	if m != nil {
		return m.EstimatedAddClicksAtFirstPositionCpc
	}
	return nil
}

func (m *AdGroupCriterion_PositionEstimates) GetEstimatedAddCostAtFirstPositionCpc() *wrappers.Int64Value {
	if m != nil {
		return m.EstimatedAddCostAtFirstPositionCpc
	}
	return nil
}

func init() {
	proto.RegisterType((*AdGroupCriterion)(nil), "google.ads.googleads.v1.resources.AdGroupCriterion")
	proto.RegisterType((*AdGroupCriterion_QualityInfo)(nil), "google.ads.googleads.v1.resources.AdGroupCriterion.QualityInfo")
	proto.RegisterType((*AdGroupCriterion_PositionEstimates)(nil), "google.ads.googleads.v1.resources.AdGroupCriterion.PositionEstimates")
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/resources/ad_group_criterion.proto", fileDescriptor_ad_group_criterion_18b9ede2c7927371)
}

var fileDescriptor_ad_group_criterion_18b9ede2c7927371 = []byte{
	// 1706 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xac, 0x98, 0xdd, 0x72, 0x1b, 0xb7,
	0x15, 0xc7, 0x4b, 0x29, 0x76, 0x2c, 0x48, 0x96, 0x2d, 0xc8, 0x52, 0x11, 0xc5, 0x4d, 0x65, 0x27,
	0x6e, 0x14, 0x27, 0x26, 0x23, 0x39, 0x4e, 0x3b, 0xcc, 0x34, 0x29, 0xc5, 0xd8, 0xb2, 0x9a, 0x2a,
	0x61, 0x28, 0x59, 0x9e, 0x76, 0xd4, 0xd9, 0x82, 0xbb, 0xe0, 0x1a, 0xe3, 0xdd, 0x05, 0x0c, 0x60,
	0xa9, 0xb2, 0x17, 0x9d, 0x69, 0x2f, 0x3a, 0xd3, 0xbb, 0x3e, 0x43, 0x2f, 0xfb, 0x1a, 0xbd, 0xeb,
	0x4d, 0xdf, 0xa3, 0x0f, 0xd0, 0xeb, 0x0e, 0xbe, 0xc8, 0x25, 0x29, 0x72, 0xa9, 0x8e, 0xee, 0x76,
	0xcf, 0xe2, 0xff, 0x3b, 0x07, 0x07, 0x67, 0xb1, 0x07, 0x0b, 0xea, 0x31, 0x63, 0x71, 0x42, 0x6a,
	0x38, 0x92, 0x35, 0x7b, 0xa9, 0xaf, 0x7a, 0xbb, 0x35, 0x41, 0x24, 0xcb, 0x45, 0x48, 0x64, 0x0d,
	0x47, 0x41, 0x2c, 0x58, 0xce, 0x83, 0x50, 0x50, 0x45, 0x04, 0x65, 0x59, 0x95, 0x0b, 0xa6, 0x18,
	0xbc, 0x67, 0x05, 0x55, 0x1c, 0xc9, 0xea, 0x40, 0x5b, 0xed, 0xed, 0x56, 0x07, 0xda, 0xad, 0x47,
	0xd3, 0xf0, 0x21, 0x4b, 0x53, 0x96, 0xd5, 0x1c, 0x12, 0x5b, 0xe2, 0xd6, 0x93, 0xb2, 0xe1, 0xb9,
	0x54, 0x2c, 0x0d, 0x38, 0x16, 0x38, 0x25, 0x8a, 0x08, 0x27, 0x7b, 0x36, 0x4d, 0x46, 0xb2, 0x3c,
	0xbd, 0x68, 0x02, 0x01, 0xe6, 0x5c, 0xb0, 0x1e, 0x4e, 0x02, 0xa9, 0xb0, 0xca, 0xa5, 0xe3, 0xfc,
	0xfc, 0xd2, 0x9c, 0x11, 0xf9, 0xde, 0x6c, 0x79, 0x87, 0x46, 0x11, 0xcd, 0xe2, 0xc0, 0xe6, 0xc6,
	0x69, 0x9a, 0xb3, 0x35, 0x05, 0x4f, 0x7d, 0xa9, 0x48, 0x1a, 0x48, 0x22, 0x7a, 0x06, 0x72, 0x09,
	0xc7, 0x43, 0x88, 0xea, 0x73, 0xef, 0xf8, 0x67, 0xb3, 0x35, 0x6f, 0x72, 0x9c, 0x50, 0xd5, 0x0f,
	0x64, 0xc8, 0x04, 0x09, 0x3a, 0x79, 0xf8, 0x9a, 0x28, 0xa7, 0x7c, 0xcf, 0x29, 0xcd, 0x5d, 0x27,
	0xef, 0xd6, 0xce, 0x05, 0xe6, 0x9c, 0x08, 0x1f, 0xcd, 0x5d, 0x4f, 0xe6, 0xb4, 0x86, 0xb3, 0x8c,
	0x29, 0xac, 0x28, 0xcb, 0xdc, 0xd3, 0xfb, 0xff, 0xfc, 0x10, 0xdc, 0x6e, 0x44, 0x07, 0x3a, 0x8f,
	0x4d, 0x1f, 0x17, 0x7c, 0x1f, 0xdc, 0xf4, 0x35, 0x13, 0x64, 0x38, 0x25, 0xa8, 0xb2, 0x5d, 0xd9,
	0x59, 0x6a, 0xaf, 0x78, 0xe3, 0xb7, 0x38, 0x25, 0xf0, 0x4b, 0xb0, 0x32, 0x9c, 0x09, 0x8d, 0xd0,
	0xd6, 0x76, 0x65, 0x67, 0x79, 0xef, 0x5d, 0x57, 0x7a, 0x55, 0x1f, 0x4e, 0xf5, 0x30, 0x53, 0x9f,
	0x7f, 0x76, 0x8a, 0x93, 0x9c, 0xb4, 0x97, 0x07, 0x82, 0xc3, 0x08, 0xbe, 0x02, 0xd7, 0x6d, 0xd6,
	0xd0, 0xe2, 0x76, 0x65, 0x67, 0x75, 0xaf, 0x55, 0x9d, 0x56, 0xbf, 0x26, 0x05, 0xd5, 0xf1, 0x28,
	0x8f, 0x8d, 0xf8, 0x69, 0x96, 0xa7, 0x53, 0x1e, 0xb5, 0x1d, 0x1f, 0x76, 0xc0, 0x8a, 0xcf, 0x1f,
	0xcd, 0xba, 0x0c, 0xbd, 0x65, 0x22, 0xfd, 0xaa, 0x5a, 0xfa, 0xbe, 0x4c, 0x80, 0xab, 0xdf, 0x5b,
	0xce, 0x61, 0xd6, 0x65, 0xed, 0xe5, 0x37, 0xc3, 0x1b, 0xf8, 0x53, 0x70, 0xc3, 0xd7, 0x23, 0xba,
	0x66, 0xf8, 0x77, 0x27, 0x32, 0x71, 0xac, 0x04, 0xcd, 0x62, 0x9b, 0x8a, 0xb7, 0xb1, 0x45, 0xc3,
	0x36, 0x78, 0x4b, 0x97, 0x01, 0x7a, 0xc7, 0x24, 0xe1, 0xcb, 0x92, 0x24, 0x0c, 0x22, 0x39, 0xe9,
	0x73, 0x62, 0xe6, 0x3e, 0x62, 0x69, 0x1b, 0x16, 0xfc, 0x1c, 0xdc, 0xc8, 0x48, 0x8c, 0x15, 0xed,
	0x11, 0xf4, 0x63, 0x13, 0xcc, 0xd6, 0x44, 0x30, 0xfb, 0x8c, 0x25, 0x36, 0x94, 0xc1, 0x58, 0xf8,
	0xb7, 0x0a, 0xd8, 0xb8, 0xb0, 0xb0, 0xd1, 0x67, 0x26, 0xba, 0xb3, 0x79, 0xa3, 0x3b, 0x36, 0x90,
	0x63, 0xcb, 0x28, 0x2c, 0xd4, 0xac, 0x01, 0xed, 0x75, 0x39, 0x69, 0x84, 0x7f, 0xad, 0x80, 0x5b,
	0x63, 0xbb, 0x03, 0x7a, 0x62, 0x82, 0xf9, 0xdd, 0x25, 0xeb, 0xa5, 0xe1, 0x28, 0x33, 0xea, 0x66,
	0x74, 0x48, 0x7b, 0x15, 0x8f, 0xdc, 0xc3, 0xaf, 0xc0, 0x4a, 0x87, 0x46, 0x41, 0xca, 0x22, 0xda,
	0xa5, 0x44, 0xa0, 0x4f, 0xa6, 0xac, 0xf3, 0xd7, 0x2c, 0xef, 0x24, 0xc4, 0x95, 0x7c, 0x87, 0x46,
	0x47, 0x4e, 0x00, 0x1b, 0x60, 0x35, 0xe4, 0x61, 0x60, 0x20, 0x34, 0x14, 0x4c, 0xa2, 0xdb, 0xe5,
	0x2f, 0xcd, 0x4a, 0xc8, 0xc3, 0x7d, 0x1a, 0x1d, 0x19, 0x81, 0x45, 0xa4, 0x45, 0xc4, 0xda, 0x5c,
	0x88, 0x74, 0x0c, 0xd1, 0x2b, 0x22, 0xd0, 0x5c, 0x88, 0xde, 0x10, 0xd1, 0x02, 0x9b, 0x9c, 0x88,
	0x90, 0x64, 0x2a, 0x18, 0x9b, 0xd0, 0xbd, 0x72, 0xd4, 0xba, 0x93, 0x36, 0x8b, 0xf3, 0x3a, 0x01,
	0x88, 0x74, 0xbb, 0x24, 0xd4, 0x75, 0x38, 0xce, 0x84, 0xe5, 0xcc, 0x8d, 0x81, 0x78, 0x16, 0x75,
	0x24, 0x6f, 0xeb, 0x97, 0xa3, 0xa6, 0x53, 0xa9, 0x23, 0xa9, 0xbc, 0x73, 0x39, 0x6a, 0x21, 0xa7,
	0x21, 0xd8, 0x1e, 0x52, 0xa7, 0x64, 0xf7, 0x7e, 0x39, 0xfd, 0xee, 0x00, 0xd2, 0xba, 0x20, 0xcd,
	0xe7, 0x17, 0xa5, 0xd9, 0xee, 0x76, 0x68, 0x63, 0xae, 0x1d, 0x68, 0xdf, 0x7e, 0x36, 0x8f, 0x8d,
	0xc6, 0xbc, 0x45, 0x23, 0x96, 0x89, 0x95, 0xb0, 0xe6, 0x71, 0xc7, 0x69, 0xd1, 0xf1, 0xe6, 0x95,
	0x3b, 0x4e, 0xa7, 0x3a, 0xee, 0x15, 0x1d, 0xff, 0xf0, 0xca, 0x1d, 0xf7, 0x86, 0x8e, 0xff, 0x52,
	0x99, 0xb5, 0xa0, 0x2e, 0x82, 0xf7, 0xaf, 0x24, 0x82, 0x29, 0x6b, 0xee, 0x02, 0x51, 0x00, 0x72,
	0x26, 0xa9, 0xfe, 0xea, 0x07, 0x44, 0x2a, 0x9a, 0x62, 0x45, 0x24, 0x02, 0xa6, 0x94, 0x9e, 0xfe,
	0x3f, 0x1f, 0xc1, 0x96, 0xa3, 0x3d, 0xf5, 0xb0, 0xf6, 0x1a, 0x1f, 0x37, 0xc1, 0x2f, 0x00, 0xe8,
	0xd2, 0x0c, 0x27, 0x41, 0x2e, 0x12, 0x89, 0x96, 0xb7, 0x17, 0x4b, 0x3f, 0x89, 0x4b, 0x66, 0xfc,
	0x0b, 0x91, 0x48, 0xf8, 0x1c, 0xac, 0x59, 0x71, 0xca, 0x3a, 0x34, 0x21, 0x96, 0xf1, 0x78, 0x0e,
	0xc6, 0x2d, 0x23, 0x3b, 0x32, 0x2a, 0x43, 0x7a, 0x06, 0x6e, 0x0f, 0xc2, 0x08, 0x64, 0xde, 0xed,
	0xd2, 0xdf, 0xa3, 0xbd, 0x39, 0xbe, 0xcf, 0xab, 0x3e, 0x98, 0x63, 0xa3, 0x81, 0x2d, 0xb0, 0xa1,
	0x04, 0x0e, 0x5f, 0xeb, 0x6f, 0xa2, 0x46, 0x29, 0x92, 0xf2, 0x04, 0x2b, 0x82, 0x6e, 0xce, 0x01,
	0x5b, 0xf7, 0xd2, 0x17, 0x22, 0x39, 0x71, 0x42, 0x18, 0x82, 0x0d, 0x0d, 0x1a, 0xef, 0xa1, 0x25,
	0x5a, 0x35, 0xf3, 0xac, 0x4d, 0x5d, 0x19, 0xdb, 0x7c, 0x57, 0x9b, 0x46, 0xd8, 0xf2, 0xba, 0xf6,
	0x7a, 0x2e, 0x92, 0x31, 0x9b, 0x84, 0x07, 0xe0, 0xed, 0xd7, 0xa4, 0x7f, 0xce, 0x44, 0x84, 0xde,
	0x35, 0x81, 0x7e, 0x5c, 0x86, 0xfd, 0xc6, 0x0e, 0xd7, 0x4d, 0xcd, 0xf3, 0x1f, 0xb4, 0xbd, 0x1a,
	0x1e, 0x81, 0x25, 0x9e, 0xe0, 0x90, 0xa4, 0x24, 0x53, 0xe8, 0xae, 0x41, 0x3d, 0x2a, 0x43, 0xb5,
	0xbc, 0xc0, 0xc1, 0x86, 0x04, 0x18, 0x83, 0x75, 0xb7, 0xb4, 0x98, 0xf3, 0x20, 0xc4, 0x8a, 0xc4,
	0x4c, 0xf4, 0xd1, 0x8f, 0x0c, 0xf8, 0x49, 0x19, 0xd8, 0xae, 0x6f, 0x83, 0xf3, 0xa6, 0x13, 0x3a,
	0x07, 0x6b, 0xe9, 0xf8, 0x03, 0xd8, 0x05, 0x70, 0xe8, 0x28, 0xa1, 0xa1, 0x69, 0x7e, 0xd1, 0x7b,
	0x97, 0xf4, 0xe3, 0x85, 0x13, 0x7e, 0xfc, 0x03, 0xf8, 0x12, 0xdc, 0x4c, 0xa8, 0x54, 0xba, 0x3c,
	0x6c, 0x13, 0xb8, 0x6d, 0x5c, 0x7c, 0x5a, 0xe6, 0xe2, 0x57, 0x56, 0x64, 0xde, 0x30, 0x47, 0x5f,
	0x49, 0x0a, 0x36, 0xf8, 0x0d, 0x58, 0xc2, 0x31, 0x09, 0x04, 0xce, 0x62, 0x82, 0x3e, 0x30, 0xd0,
	0x4f, 0xca, 0xa0, 0x8d, 0x98, 0xb4, 0xf5, 0x78, 0x07, 0xbc, 0x81, 0xdd, 0x3d, 0xfc, 0x1a, 0x5c,
	0x8f, 0x49, 0x16, 0x11, 0x81, 0x1e, 0x18, 0xd2, 0xc3, 0x32, 0xd2, 0x81, 0x19, 0xed, 0x38, 0x4e,
	0x0b, 0x4f, 0xc0, 0x0a, 0xcd, 0x42, 0x96, 0xfa, 0xa8, 0x7e, 0x62, 0x58, 0xa5, 0x05, 0x7b, 0x68,
	0x34, 0xc5, 0xc0, 0x96, 0xe9, 0xd0, 0x04, 0x7f, 0x0b, 0x6e, 0x71, 0x2c, 0x48, 0xa6, 0x86, 0x8d,
	0xde, 0x87, 0x06, 0xbc, 0x57, 0x5a, 0x67, 0x4e, 0x66, 0xdb, 0x34, 0xc7, 0x5e, 0xe5, 0x23, 0x56,
	0x9d, 0xc7, 0x5c, 0x12, 0x11, 0xe8, 0xe4, 0xa2, 0x87, 0xf3, 0xe5, 0xf1, 0x85, 0x24, 0x42, 0x2f,
	0x90, 0xcf, 0x63, 0xee, 0xee, 0xf5, 0x6a, 0xf7, 0x59, 0xae, 0xf2, 0x0e, 0x09, 0x7a, 0x34, 0x22,
	0x0c, 0xed, 0xcc, 0xb7, 0xda, 0xbf, 0x66, 0xf9, 0x49, 0xde, 0x21, 0xa7, 0x5a, 0xe3, 0x57, 0xdb,
	0x81, 0x8c, 0x4d, 0x27, 0xc1, 0x83, 0xc3, 0x57, 0x38, 0xcb, 0x48, 0x82, 0x3e, 0x9a, 0x2f, 0x09,
	0x0e, 0xdd, 0xb4, 0x2a, 0x9f, 0x04, 0x07, 0x73, 0x56, 0xd8, 0x00, 0xd7, 0x14, 0xe3, 0x34, 0x44,
	0x1f, 0x1b, 0xe8, 0x47, 0x65, 0xd0, 0x13, 0x3d, 0xd8, 0xb1, 0xac, 0x52, 0x4f, 0xdd, 0xe4, 0x91,
	0x66, 0x8a, 0x08, 0x22, 0x15, 0x7a, 0x34, 0xdf, 0xd4, 0x75, 0x2e, 0x0f, 0x9d, 0xc6, 0x4f, 0x3d,
	0x2f, 0xd8, 0xf4, 0x56, 0x75, 0x4e, 0x3a, 0x1c, 0xc7, 0x04, 0x55, 0xe7, 0xdb, 0xaa, 0x5e, 0xda,
	0xe1, 0x7e, 0xab, 0x72, 0x6a, 0x88, 0xc1, 0x9a, 0xde, 0x54, 0x38, 0xee, 0xeb, 0xad, 0x46, 0xb7,
	0xeb, 0x24, 0x41, 0x35, 0x83, 0x7c, 0x5c, 0xfa, 0xe6, 0x70, 0xde, 0xb2, 0xba, 0x23, 0x2d, 0x73,
	0x68, 0x7d, 0x02, 0x29, 0x9a, 0xf5, 0x32, 0xb9, 0x7d, 0x1b, 0x77, 0xbb, 0x34, 0xa3, 0xaa, 0x8f,
	0x3e, 0x9d, 0x6f, 0x99, 0xec, 0x0e, 0xdd, 0x70, 0x2a, 0xbf, 0x4c, 0xe1, 0x88, 0x55, 0xe7, 0xd8,
	0xe1, 0x75, 0x96, 0x33, 0x85, 0x76, 0xe7, 0xcb, 0xb1, 0x85, 0x1f, 0x1a, 0x8d, 0xcf, 0x71, 0x58,
	0xb0, 0x6d, 0xfd, 0x7b, 0x11, 0x2c, 0x17, 0x8e, 0xb0, 0xf0, 0x17, 0xe0, 0xe6, 0xc8, 0x9f, 0x05,
	0x73, 0xd0, 0x9f, 0xd2, 0x60, 0x3e, 0xde, 0x73, 0x27, 0x01, 0xa7, 0x38, 0xd6, 0x02, 0xf8, 0x47,
	0xb0, 0x19, 0x0a, 0x62, 0x8e, 0x8f, 0xc1, 0x28, 0x6a, 0xc1, 0xb4, 0x36, 0xcf, 0x4b, 0x5a, 0x9b,
	0xef, 0x0b, 0xb0, 0x7d, 0xf3, 0x5b, 0xc3, 0xf4, 0x37, 0x93, 0xe6, 0xf6, 0x1d, 0xef, 0xa7, 0xf8,
	0x0c, 0xfe, 0xa9, 0x02, 0x10, 0x67, 0x52, 0x05, 0x61, 0x42, 0xc3, 0xd7, 0x63, 0x21, 0x2c, 0x5e,
	0x71, 0x08, 0x1b, 0xda, 0x53, 0x53, 0x3b, 0x1a, 0x89, 0xe1, 0x0f, 0xe0, 0x8e, 0x24, 0x58, 0x84,
	0xaf, 0x02, 0x2e, 0x48, 0x44, 0x43, 0x45, 0xa2, 0x20, 0x54, 0xc2, 0xfc, 0x67, 0xb8, 0x4a, 0xf7,
	0xd0, 0x7a, 0x69, 0x79, 0x27, 0x4d, 0x25, 0xb6, 0xfe, 0xbb, 0x08, 0xd6, 0x26, 0xfa, 0x31, 0xf8,
	0x2d, 0xd8, 0xe8, 0x52, 0x21, 0x55, 0xa0, 0x5f, 0x08, 0xd3, 0x73, 0xba, 0x03, 0x44, 0xa5, 0xfc,
	0x00, 0x01, 0x8d, 0xb2, 0x85, 0x63, 0xdd, 0xc0, 0xbb, 0x63, 0xc3, 0x29, 0x78, 0xc7, 0xf1, 0x7c,
	0x23, 0x59, 0x60, 0x2e, 0x94, 0x33, 0x37, 0x2d, 0xd3, 0x89, 0x87, 0xdc, 0xef, 0xc0, 0xa6, 0x62,
	0x3c, 0x60, 0xdd, 0x89, 0x40, 0x17, 0xe7, 0x08, 0x54, 0x31, 0xfe, 0x5d, 0x77, 0x34, 0xd0, 0x1c,
	0x3c, 0xf4, 0x2d, 0x6e, 0x14, 0xe0, 0x28, 0xb2, 0x65, 0x21, 0x03, 0xac, 0x82, 0xc9, 0x09, 0xb8,
	0x1f, 0x41, 0x33, 0x9d, 0x7c, 0x30, 0xc0, 0x35, 0xa2, 0xc8, 0x2c, 0xbd, 0x6c, 0xa8, 0x67, 0x63,
	0xb3, 0x81, 0x6f, 0xc0, 0xce, 0x98, 0x5b, 0x5d, 0x92, 0x17, 0x3b, 0xbd, 0x56, 0xee, 0xf4, 0xfe,
	0x88, 0x53, 0x26, 0xd5, 0xa4, 0xcb, 0xfd, 0x65, 0xb0, 0x34, 0xf8, 0x9b, 0xb6, 0xff, 0xe7, 0x05,
	0xf0, 0x20, 0x64, 0x69, 0x79, 0x33, 0xbf, 0xbf, 0x31, 0xde, 0xcd, 0xb7, 0xb4, 0xff, 0x56, 0xe5,
	0x37, 0xbf, 0x74, 0xda, 0x98, 0x25, 0x38, 0x8b, 0xab, 0x4c, 0xc4, 0xb5, 0x98, 0x64, 0x26, 0x3a,
	0xff, 0x43, 0x92, 0x53, 0x39, 0xe3, 0xc7, 0xf4, 0x17, 0x83, 0xab, 0xbf, 0x2f, 0x2c, 0x1e, 0x34,
	0x1a, 0xff, 0x58, 0xb8, 0x77, 0x60, 0x91, 0x8d, 0x48, 0x56, 0xed, 0xa5, 0xbe, 0x3a, 0xdd, 0xad,
	0xb6, 0xfd, 0xc8, 0x7f, 0xf9, 0x31, 0x67, 0x8d, 0x48, 0x9e, 0x0d, 0xc6, 0x9c, 0x9d, 0xee, 0x9e,
	0x0d, 0xc6, 0xfc, 0x67, 0xe1, 0x81, 0x7d, 0x50, 0xaf, 0x37, 0x22, 0x59, 0xaf, 0x0f, 0x46, 0xd5,
	0xeb, 0xa7, 0xbb, 0xf5, 0xfa, 0x60, 0x5c, 0xe7, 0xba, 0x09, 0xf6, 0xf1, 0xff, 0x02, 0x00, 0x00,
	0xff, 0xff, 0x2a, 0xaa, 0x4c, 0x2a, 0x44, 0x17, 0x00, 0x00,
}
