// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/automl/v1beta1/operations.proto

package automl // import "google.golang.org/genproto/googleapis/cloud/automl/v1beta1"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/golang/protobuf/ptypes/empty"
import timestamp "github.com/golang/protobuf/ptypes/timestamp"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import status "google.golang.org/genproto/googleapis/rpc/status"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Metadata used across all long running operations returned by AutoML API.
type OperationMetadata struct {
	// Ouptut only. Details of specific operation. Even if this field is empty,
	// the presence allows to distinguish different types of operations.
	//
	// Types that are valid to be assigned to Details:
	//	*OperationMetadata_DeleteDetails
	//	*OperationMetadata_DeployModelDetails
	//	*OperationMetadata_UndeployModelDetails
	//	*OperationMetadata_CreateModelDetails
	//	*OperationMetadata_ImportDataDetails
	//	*OperationMetadata_BatchPredictDetails
	//	*OperationMetadata_ExportDataDetails
	//	*OperationMetadata_ExportModelDetails
	//	*OperationMetadata_ExportEvaluatedExamplesDetails
	Details isOperationMetadata_Details `protobuf_oneof:"details"`
	// Output only. Progress of operation. Range: [0, 100].
	// Not used currently.
	ProgressPercent int32 `protobuf:"varint,13,opt,name=progress_percent,json=progressPercent,proto3" json:"progress_percent,omitempty"`
	// Output only. Partial failures encountered.
	// E.g. single files that couldn't be read.
	// This field should never exceed 20 entries.
	// Status details field will contain standard GCP error details.
	PartialFailures []*status.Status `protobuf:"bytes,2,rep,name=partial_failures,json=partialFailures,proto3" json:"partial_failures,omitempty"`
	// Output only. Time when the operation was created.
	CreateTime *timestamp.Timestamp `protobuf:"bytes,3,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Time when the operation was updated for the last time.
	UpdateTime           *timestamp.Timestamp `protobuf:"bytes,4,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *OperationMetadata) Reset()         { *m = OperationMetadata{} }
func (m *OperationMetadata) String() string { return proto.CompactTextString(m) }
func (*OperationMetadata) ProtoMessage()    {}
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_operations_3312906655c3448c, []int{0}
}
func (m *OperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_OperationMetadata.Unmarshal(m, b)
}
func (m *OperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_OperationMetadata.Marshal(b, m, deterministic)
}
func (dst *OperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_OperationMetadata.Merge(dst, src)
}
func (m *OperationMetadata) XXX_Size() int {
	return xxx_messageInfo_OperationMetadata.Size(m)
}
func (m *OperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_OperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_OperationMetadata proto.InternalMessageInfo

type isOperationMetadata_Details interface {
	isOperationMetadata_Details()
}

type OperationMetadata_DeleteDetails struct {
	DeleteDetails *DeleteOperationMetadata `protobuf:"bytes,8,opt,name=delete_details,json=deleteDetails,proto3,oneof"`
}

type OperationMetadata_DeployModelDetails struct {
	DeployModelDetails *DeployModelOperationMetadata `protobuf:"bytes,24,opt,name=deploy_model_details,json=deployModelDetails,proto3,oneof"`
}

type OperationMetadata_UndeployModelDetails struct {
	UndeployModelDetails *UndeployModelOperationMetadata `protobuf:"bytes,25,opt,name=undeploy_model_details,json=undeployModelDetails,proto3,oneof"`
}

type OperationMetadata_CreateModelDetails struct {
	CreateModelDetails *CreateModelOperationMetadata `protobuf:"bytes,10,opt,name=create_model_details,json=createModelDetails,proto3,oneof"`
}

type OperationMetadata_ImportDataDetails struct {
	ImportDataDetails *ImportDataOperationMetadata `protobuf:"bytes,15,opt,name=import_data_details,json=importDataDetails,proto3,oneof"`
}

type OperationMetadata_BatchPredictDetails struct {
	BatchPredictDetails *BatchPredictOperationMetadata `protobuf:"bytes,16,opt,name=batch_predict_details,json=batchPredictDetails,proto3,oneof"`
}

type OperationMetadata_ExportDataDetails struct {
	ExportDataDetails *ExportDataOperationMetadata `protobuf:"bytes,21,opt,name=export_data_details,json=exportDataDetails,proto3,oneof"`
}

type OperationMetadata_ExportModelDetails struct {
	ExportModelDetails *ExportModelOperationMetadata `protobuf:"bytes,22,opt,name=export_model_details,json=exportModelDetails,proto3,oneof"`
}

type OperationMetadata_ExportEvaluatedExamplesDetails struct {
	ExportEvaluatedExamplesDetails *ExportEvaluatedExamplesOperationMetadata `protobuf:"bytes,26,opt,name=export_evaluated_examples_details,json=exportEvaluatedExamplesDetails,proto3,oneof"`
}

func (*OperationMetadata_DeleteDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_DeployModelDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_UndeployModelDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_CreateModelDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_ImportDataDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_BatchPredictDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_ExportDataDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_ExportModelDetails) isOperationMetadata_Details() {}

func (*OperationMetadata_ExportEvaluatedExamplesDetails) isOperationMetadata_Details() {}

func (m *OperationMetadata) GetDetails() isOperationMetadata_Details {
	if m != nil {
		return m.Details
	}
	return nil
}

func (m *OperationMetadata) GetDeleteDetails() *DeleteOperationMetadata {
	if x, ok := m.GetDetails().(*OperationMetadata_DeleteDetails); ok {
		return x.DeleteDetails
	}
	return nil
}

func (m *OperationMetadata) GetDeployModelDetails() *DeployModelOperationMetadata {
	if x, ok := m.GetDetails().(*OperationMetadata_DeployModelDetails); ok {
		return x.DeployModelDetails
	}
	return nil
}

func (m *OperationMetadata) GetUndeployModelDetails() *UndeployModelOperationMetadata {
	if x, ok := m.GetDetails().(*OperationMetadata_UndeployModelDetails); ok {
		return x.UndeployModelDetails
	}
	return nil
}

func (m *OperationMetadata) GetCreateModelDetails() *CreateModelOperationMetadata {
	if x, ok := m.GetDetails().(*OperationMetadata_CreateModelDetails); ok {
		return x.CreateModelDetails
	}
	return nil
}

func (m *OperationMetadata) GetImportDataDetails() *ImportDataOperationMetadata {
	if x, ok := m.GetDetails().(*OperationMetadata_ImportDataDetails); ok {
		return x.ImportDataDetails
	}
	return nil
}

func (m *OperationMetadata) GetBatchPredictDetails() *BatchPredictOperationMetadata {
	if x, ok := m.GetDetails().(*OperationMetadata_BatchPredictDetails); ok {
		return x.BatchPredictDetails
	}
	return nil
}

func (m *OperationMetadata) GetExportDataDetails() *ExportDataOperationMetadata {
	if x, ok := m.GetDetails().(*OperationMetadata_ExportDataDetails); ok {
		return x.ExportDataDetails
	}
	return nil
}

func (m *OperationMetadata) GetExportModelDetails() *ExportModelOperationMetadata {
	if x, ok := m.GetDetails().(*OperationMetadata_ExportModelDetails); ok {
		return x.ExportModelDetails
	}
	return nil
}

func (m *OperationMetadata) GetExportEvaluatedExamplesDetails() *ExportEvaluatedExamplesOperationMetadata {
	if x, ok := m.GetDetails().(*OperationMetadata_ExportEvaluatedExamplesDetails); ok {
		return x.ExportEvaluatedExamplesDetails
	}
	return nil
}

func (m *OperationMetadata) GetProgressPercent() int32 {
	if m != nil {
		return m.ProgressPercent
	}
	return 0
}

func (m *OperationMetadata) GetPartialFailures() []*status.Status {
	if m != nil {
		return m.PartialFailures
	}
	return nil
}

func (m *OperationMetadata) GetCreateTime() *timestamp.Timestamp {
	if m != nil {
		return m.CreateTime
	}
	return nil
}

func (m *OperationMetadata) GetUpdateTime() *timestamp.Timestamp {
	if m != nil {
		return m.UpdateTime
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*OperationMetadata) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _OperationMetadata_OneofMarshaler, _OperationMetadata_OneofUnmarshaler, _OperationMetadata_OneofSizer, []interface{}{
		(*OperationMetadata_DeleteDetails)(nil),
		(*OperationMetadata_DeployModelDetails)(nil),
		(*OperationMetadata_UndeployModelDetails)(nil),
		(*OperationMetadata_CreateModelDetails)(nil),
		(*OperationMetadata_ImportDataDetails)(nil),
		(*OperationMetadata_BatchPredictDetails)(nil),
		(*OperationMetadata_ExportDataDetails)(nil),
		(*OperationMetadata_ExportModelDetails)(nil),
		(*OperationMetadata_ExportEvaluatedExamplesDetails)(nil),
	}
}

func _OperationMetadata_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*OperationMetadata)
	// details
	switch x := m.Details.(type) {
	case *OperationMetadata_DeleteDetails:
		b.EncodeVarint(8<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeleteDetails); err != nil {
			return err
		}
	case *OperationMetadata_DeployModelDetails:
		b.EncodeVarint(24<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.DeployModelDetails); err != nil {
			return err
		}
	case *OperationMetadata_UndeployModelDetails:
		b.EncodeVarint(25<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.UndeployModelDetails); err != nil {
			return err
		}
	case *OperationMetadata_CreateModelDetails:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.CreateModelDetails); err != nil {
			return err
		}
	case *OperationMetadata_ImportDataDetails:
		b.EncodeVarint(15<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ImportDataDetails); err != nil {
			return err
		}
	case *OperationMetadata_BatchPredictDetails:
		b.EncodeVarint(16<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.BatchPredictDetails); err != nil {
			return err
		}
	case *OperationMetadata_ExportDataDetails:
		b.EncodeVarint(21<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExportDataDetails); err != nil {
			return err
		}
	case *OperationMetadata_ExportModelDetails:
		b.EncodeVarint(22<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExportModelDetails); err != nil {
			return err
		}
	case *OperationMetadata_ExportEvaluatedExamplesDetails:
		b.EncodeVarint(26<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.ExportEvaluatedExamplesDetails); err != nil {
			return err
		}
	case nil:
	default:
		return fmt.Errorf("OperationMetadata.Details has unexpected type %T", x)
	}
	return nil
}

func _OperationMetadata_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*OperationMetadata)
	switch tag {
	case 8: // details.delete_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DeleteOperationMetadata)
		err := b.DecodeMessage(msg)
		m.Details = &OperationMetadata_DeleteDetails{msg}
		return true, err
	case 24: // details.deploy_model_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(DeployModelOperationMetadata)
		err := b.DecodeMessage(msg)
		m.Details = &OperationMetadata_DeployModelDetails{msg}
		return true, err
	case 25: // details.undeploy_model_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(UndeployModelOperationMetadata)
		err := b.DecodeMessage(msg)
		m.Details = &OperationMetadata_UndeployModelDetails{msg}
		return true, err
	case 10: // details.create_model_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(CreateModelOperationMetadata)
		err := b.DecodeMessage(msg)
		m.Details = &OperationMetadata_CreateModelDetails{msg}
		return true, err
	case 15: // details.import_data_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ImportDataOperationMetadata)
		err := b.DecodeMessage(msg)
		m.Details = &OperationMetadata_ImportDataDetails{msg}
		return true, err
	case 16: // details.batch_predict_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(BatchPredictOperationMetadata)
		err := b.DecodeMessage(msg)
		m.Details = &OperationMetadata_BatchPredictDetails{msg}
		return true, err
	case 21: // details.export_data_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ExportDataOperationMetadata)
		err := b.DecodeMessage(msg)
		m.Details = &OperationMetadata_ExportDataDetails{msg}
		return true, err
	case 22: // details.export_model_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ExportModelOperationMetadata)
		err := b.DecodeMessage(msg)
		m.Details = &OperationMetadata_ExportModelDetails{msg}
		return true, err
	case 26: // details.export_evaluated_examples_details
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(ExportEvaluatedExamplesOperationMetadata)
		err := b.DecodeMessage(msg)
		m.Details = &OperationMetadata_ExportEvaluatedExamplesDetails{msg}
		return true, err
	default:
		return false, nil
	}
}

func _OperationMetadata_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*OperationMetadata)
	// details
	switch x := m.Details.(type) {
	case *OperationMetadata_DeleteDetails:
		s := proto.Size(x.DeleteDetails)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OperationMetadata_DeployModelDetails:
		s := proto.Size(x.DeployModelDetails)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OperationMetadata_UndeployModelDetails:
		s := proto.Size(x.UndeployModelDetails)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OperationMetadata_CreateModelDetails:
		s := proto.Size(x.CreateModelDetails)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OperationMetadata_ImportDataDetails:
		s := proto.Size(x.ImportDataDetails)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OperationMetadata_BatchPredictDetails:
		s := proto.Size(x.BatchPredictDetails)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OperationMetadata_ExportDataDetails:
		s := proto.Size(x.ExportDataDetails)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OperationMetadata_ExportModelDetails:
		s := proto.Size(x.ExportModelDetails)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *OperationMetadata_ExportEvaluatedExamplesDetails:
		s := proto.Size(x.ExportEvaluatedExamplesDetails)
		n += 2 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Details of operations that perform deletes of any entities.
type DeleteOperationMetadata struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteOperationMetadata) Reset()         { *m = DeleteOperationMetadata{} }
func (m *DeleteOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*DeleteOperationMetadata) ProtoMessage()    {}
func (*DeleteOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_operations_3312906655c3448c, []int{1}
}
func (m *DeleteOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteOperationMetadata.Unmarshal(m, b)
}
func (m *DeleteOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteOperationMetadata.Marshal(b, m, deterministic)
}
func (dst *DeleteOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteOperationMetadata.Merge(dst, src)
}
func (m *DeleteOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_DeleteOperationMetadata.Size(m)
}
func (m *DeleteOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteOperationMetadata proto.InternalMessageInfo

// Details of DeployModel operation.
type DeployModelOperationMetadata struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeployModelOperationMetadata) Reset()         { *m = DeployModelOperationMetadata{} }
func (m *DeployModelOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*DeployModelOperationMetadata) ProtoMessage()    {}
func (*DeployModelOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_operations_3312906655c3448c, []int{2}
}
func (m *DeployModelOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeployModelOperationMetadata.Unmarshal(m, b)
}
func (m *DeployModelOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeployModelOperationMetadata.Marshal(b, m, deterministic)
}
func (dst *DeployModelOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeployModelOperationMetadata.Merge(dst, src)
}
func (m *DeployModelOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_DeployModelOperationMetadata.Size(m)
}
func (m *DeployModelOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_DeployModelOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_DeployModelOperationMetadata proto.InternalMessageInfo

// Details of UndeployModel operation.
type UndeployModelOperationMetadata struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UndeployModelOperationMetadata) Reset()         { *m = UndeployModelOperationMetadata{} }
func (m *UndeployModelOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*UndeployModelOperationMetadata) ProtoMessage()    {}
func (*UndeployModelOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_operations_3312906655c3448c, []int{3}
}
func (m *UndeployModelOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UndeployModelOperationMetadata.Unmarshal(m, b)
}
func (m *UndeployModelOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UndeployModelOperationMetadata.Marshal(b, m, deterministic)
}
func (dst *UndeployModelOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UndeployModelOperationMetadata.Merge(dst, src)
}
func (m *UndeployModelOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_UndeployModelOperationMetadata.Size(m)
}
func (m *UndeployModelOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_UndeployModelOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_UndeployModelOperationMetadata proto.InternalMessageInfo

// Details of CreateModel operation.
type CreateModelOperationMetadata struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateModelOperationMetadata) Reset()         { *m = CreateModelOperationMetadata{} }
func (m *CreateModelOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*CreateModelOperationMetadata) ProtoMessage()    {}
func (*CreateModelOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_operations_3312906655c3448c, []int{4}
}
func (m *CreateModelOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateModelOperationMetadata.Unmarshal(m, b)
}
func (m *CreateModelOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateModelOperationMetadata.Marshal(b, m, deterministic)
}
func (dst *CreateModelOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateModelOperationMetadata.Merge(dst, src)
}
func (m *CreateModelOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_CreateModelOperationMetadata.Size(m)
}
func (m *CreateModelOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateModelOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_CreateModelOperationMetadata proto.InternalMessageInfo

// Details of ImportData operation.
type ImportDataOperationMetadata struct {
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ImportDataOperationMetadata) Reset()         { *m = ImportDataOperationMetadata{} }
func (m *ImportDataOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*ImportDataOperationMetadata) ProtoMessage()    {}
func (*ImportDataOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_operations_3312906655c3448c, []int{5}
}
func (m *ImportDataOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ImportDataOperationMetadata.Unmarshal(m, b)
}
func (m *ImportDataOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ImportDataOperationMetadata.Marshal(b, m, deterministic)
}
func (dst *ImportDataOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ImportDataOperationMetadata.Merge(dst, src)
}
func (m *ImportDataOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_ImportDataOperationMetadata.Size(m)
}
func (m *ImportDataOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ImportDataOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ImportDataOperationMetadata proto.InternalMessageInfo

// Details of ExportData operation.
type ExportDataOperationMetadata struct {
	// Output only. Information further describing this export data's output.
	OutputInfo           *ExportDataOperationMetadata_ExportDataOutputInfo `protobuf:"bytes,1,opt,name=output_info,json=outputInfo,proto3" json:"output_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                          `json:"-"`
	XXX_unrecognized     []byte                                            `json:"-"`
	XXX_sizecache        int32                                             `json:"-"`
}

func (m *ExportDataOperationMetadata) Reset()         { *m = ExportDataOperationMetadata{} }
func (m *ExportDataOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*ExportDataOperationMetadata) ProtoMessage()    {}
func (*ExportDataOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_operations_3312906655c3448c, []int{6}
}
func (m *ExportDataOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportDataOperationMetadata.Unmarshal(m, b)
}
func (m *ExportDataOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportDataOperationMetadata.Marshal(b, m, deterministic)
}
func (dst *ExportDataOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportDataOperationMetadata.Merge(dst, src)
}
func (m *ExportDataOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_ExportDataOperationMetadata.Size(m)
}
func (m *ExportDataOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportDataOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ExportDataOperationMetadata proto.InternalMessageInfo

func (m *ExportDataOperationMetadata) GetOutputInfo() *ExportDataOperationMetadata_ExportDataOutputInfo {
	if m != nil {
		return m.OutputInfo
	}
	return nil
}

// Further describes this export data's output.
// Supplements
// [OutputConfig][google.cloud.automl.v1beta1.OutputConfig].
type ExportDataOperationMetadata_ExportDataOutputInfo struct {
	// The output location to which the exported data is written.
	//
	// Types that are valid to be assigned to OutputLocation:
	//	*ExportDataOperationMetadata_ExportDataOutputInfo_GcsOutputDirectory
	//	*ExportDataOperationMetadata_ExportDataOutputInfo_BigqueryOutputDataset
	OutputLocation       isExportDataOperationMetadata_ExportDataOutputInfo_OutputLocation `protobuf_oneof:"output_location"`
	XXX_NoUnkeyedLiteral struct{}                                                          `json:"-"`
	XXX_unrecognized     []byte                                                            `json:"-"`
	XXX_sizecache        int32                                                             `json:"-"`
}

func (m *ExportDataOperationMetadata_ExportDataOutputInfo) Reset() {
	*m = ExportDataOperationMetadata_ExportDataOutputInfo{}
}
func (m *ExportDataOperationMetadata_ExportDataOutputInfo) String() string {
	return proto.CompactTextString(m)
}
func (*ExportDataOperationMetadata_ExportDataOutputInfo) ProtoMessage() {}
func (*ExportDataOperationMetadata_ExportDataOutputInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_operations_3312906655c3448c, []int{6, 0}
}
func (m *ExportDataOperationMetadata_ExportDataOutputInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportDataOperationMetadata_ExportDataOutputInfo.Unmarshal(m, b)
}
func (m *ExportDataOperationMetadata_ExportDataOutputInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportDataOperationMetadata_ExportDataOutputInfo.Marshal(b, m, deterministic)
}
func (dst *ExportDataOperationMetadata_ExportDataOutputInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportDataOperationMetadata_ExportDataOutputInfo.Merge(dst, src)
}
func (m *ExportDataOperationMetadata_ExportDataOutputInfo) XXX_Size() int {
	return xxx_messageInfo_ExportDataOperationMetadata_ExportDataOutputInfo.Size(m)
}
func (m *ExportDataOperationMetadata_ExportDataOutputInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportDataOperationMetadata_ExportDataOutputInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ExportDataOperationMetadata_ExportDataOutputInfo proto.InternalMessageInfo

type isExportDataOperationMetadata_ExportDataOutputInfo_OutputLocation interface {
	isExportDataOperationMetadata_ExportDataOutputInfo_OutputLocation()
}

type ExportDataOperationMetadata_ExportDataOutputInfo_GcsOutputDirectory struct {
	GcsOutputDirectory string `protobuf:"bytes,1,opt,name=gcs_output_directory,json=gcsOutputDirectory,proto3,oneof"`
}

type ExportDataOperationMetadata_ExportDataOutputInfo_BigqueryOutputDataset struct {
	BigqueryOutputDataset string `protobuf:"bytes,2,opt,name=bigquery_output_dataset,json=bigqueryOutputDataset,proto3,oneof"`
}

func (*ExportDataOperationMetadata_ExportDataOutputInfo_GcsOutputDirectory) isExportDataOperationMetadata_ExportDataOutputInfo_OutputLocation() {
}

func (*ExportDataOperationMetadata_ExportDataOutputInfo_BigqueryOutputDataset) isExportDataOperationMetadata_ExportDataOutputInfo_OutputLocation() {
}

func (m *ExportDataOperationMetadata_ExportDataOutputInfo) GetOutputLocation() isExportDataOperationMetadata_ExportDataOutputInfo_OutputLocation {
	if m != nil {
		return m.OutputLocation
	}
	return nil
}

func (m *ExportDataOperationMetadata_ExportDataOutputInfo) GetGcsOutputDirectory() string {
	if x, ok := m.GetOutputLocation().(*ExportDataOperationMetadata_ExportDataOutputInfo_GcsOutputDirectory); ok {
		return x.GcsOutputDirectory
	}
	return ""
}

func (m *ExportDataOperationMetadata_ExportDataOutputInfo) GetBigqueryOutputDataset() string {
	if x, ok := m.GetOutputLocation().(*ExportDataOperationMetadata_ExportDataOutputInfo_BigqueryOutputDataset); ok {
		return x.BigqueryOutputDataset
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*ExportDataOperationMetadata_ExportDataOutputInfo) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _ExportDataOperationMetadata_ExportDataOutputInfo_OneofMarshaler, _ExportDataOperationMetadata_ExportDataOutputInfo_OneofUnmarshaler, _ExportDataOperationMetadata_ExportDataOutputInfo_OneofSizer, []interface{}{
		(*ExportDataOperationMetadata_ExportDataOutputInfo_GcsOutputDirectory)(nil),
		(*ExportDataOperationMetadata_ExportDataOutputInfo_BigqueryOutputDataset)(nil),
	}
}

func _ExportDataOperationMetadata_ExportDataOutputInfo_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*ExportDataOperationMetadata_ExportDataOutputInfo)
	// output_location
	switch x := m.OutputLocation.(type) {
	case *ExportDataOperationMetadata_ExportDataOutputInfo_GcsOutputDirectory:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.GcsOutputDirectory)
	case *ExportDataOperationMetadata_ExportDataOutputInfo_BigqueryOutputDataset:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.BigqueryOutputDataset)
	case nil:
	default:
		return fmt.Errorf("ExportDataOperationMetadata_ExportDataOutputInfo.OutputLocation has unexpected type %T", x)
	}
	return nil
}

func _ExportDataOperationMetadata_ExportDataOutputInfo_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*ExportDataOperationMetadata_ExportDataOutputInfo)
	switch tag {
	case 1: // output_location.gcs_output_directory
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.OutputLocation = &ExportDataOperationMetadata_ExportDataOutputInfo_GcsOutputDirectory{x}
		return true, err
	case 2: // output_location.bigquery_output_dataset
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.OutputLocation = &ExportDataOperationMetadata_ExportDataOutputInfo_BigqueryOutputDataset{x}
		return true, err
	default:
		return false, nil
	}
}

func _ExportDataOperationMetadata_ExportDataOutputInfo_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*ExportDataOperationMetadata_ExportDataOutputInfo)
	// output_location
	switch x := m.OutputLocation.(type) {
	case *ExportDataOperationMetadata_ExportDataOutputInfo_GcsOutputDirectory:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.GcsOutputDirectory)))
		n += len(x.GcsOutputDirectory)
	case *ExportDataOperationMetadata_ExportDataOutputInfo_BigqueryOutputDataset:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.BigqueryOutputDataset)))
		n += len(x.BigqueryOutputDataset)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Details of BatchPredict operation.
type BatchPredictOperationMetadata struct {
	// Output only. The input config that was given upon starting this
	// batch predict operation.
	InputConfig *BatchPredictInputConfig `protobuf:"bytes,1,opt,name=input_config,json=inputConfig,proto3" json:"input_config,omitempty"`
	// Output only. Information further describing this batch predict's output.
	OutputInfo           *BatchPredictOperationMetadata_BatchPredictOutputInfo `protobuf:"bytes,2,opt,name=output_info,json=outputInfo,proto3" json:"output_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                              `json:"-"`
	XXX_unrecognized     []byte                                                `json:"-"`
	XXX_sizecache        int32                                                 `json:"-"`
}

func (m *BatchPredictOperationMetadata) Reset()         { *m = BatchPredictOperationMetadata{} }
func (m *BatchPredictOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*BatchPredictOperationMetadata) ProtoMessage()    {}
func (*BatchPredictOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_operations_3312906655c3448c, []int{7}
}
func (m *BatchPredictOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchPredictOperationMetadata.Unmarshal(m, b)
}
func (m *BatchPredictOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchPredictOperationMetadata.Marshal(b, m, deterministic)
}
func (dst *BatchPredictOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchPredictOperationMetadata.Merge(dst, src)
}
func (m *BatchPredictOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_BatchPredictOperationMetadata.Size(m)
}
func (m *BatchPredictOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchPredictOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_BatchPredictOperationMetadata proto.InternalMessageInfo

func (m *BatchPredictOperationMetadata) GetInputConfig() *BatchPredictInputConfig {
	if m != nil {
		return m.InputConfig
	}
	return nil
}

func (m *BatchPredictOperationMetadata) GetOutputInfo() *BatchPredictOperationMetadata_BatchPredictOutputInfo {
	if m != nil {
		return m.OutputInfo
	}
	return nil
}

// Further describes this batch predict's output.
// Supplements
//
// [BatchPredictionOutputConfig][google.cloud.automl.v1beta1.BatchPredictionOutputConfig].
type BatchPredictOperationMetadata_BatchPredictOutputInfo struct {
	// The output location into which prediction output is written.
	//
	// Types that are valid to be assigned to OutputLocation:
	//	*BatchPredictOperationMetadata_BatchPredictOutputInfo_GcsOutputDirectory
	//	*BatchPredictOperationMetadata_BatchPredictOutputInfo_BigqueryOutputDataset
	OutputLocation       isBatchPredictOperationMetadata_BatchPredictOutputInfo_OutputLocation `protobuf_oneof:"output_location"`
	XXX_NoUnkeyedLiteral struct{}                                                              `json:"-"`
	XXX_unrecognized     []byte                                                                `json:"-"`
	XXX_sizecache        int32                                                                 `json:"-"`
}

func (m *BatchPredictOperationMetadata_BatchPredictOutputInfo) Reset() {
	*m = BatchPredictOperationMetadata_BatchPredictOutputInfo{}
}
func (m *BatchPredictOperationMetadata_BatchPredictOutputInfo) String() string {
	return proto.CompactTextString(m)
}
func (*BatchPredictOperationMetadata_BatchPredictOutputInfo) ProtoMessage() {}
func (*BatchPredictOperationMetadata_BatchPredictOutputInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_operations_3312906655c3448c, []int{7, 0}
}
func (m *BatchPredictOperationMetadata_BatchPredictOutputInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchPredictOperationMetadata_BatchPredictOutputInfo.Unmarshal(m, b)
}
func (m *BatchPredictOperationMetadata_BatchPredictOutputInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchPredictOperationMetadata_BatchPredictOutputInfo.Marshal(b, m, deterministic)
}
func (dst *BatchPredictOperationMetadata_BatchPredictOutputInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchPredictOperationMetadata_BatchPredictOutputInfo.Merge(dst, src)
}
func (m *BatchPredictOperationMetadata_BatchPredictOutputInfo) XXX_Size() int {
	return xxx_messageInfo_BatchPredictOperationMetadata_BatchPredictOutputInfo.Size(m)
}
func (m *BatchPredictOperationMetadata_BatchPredictOutputInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchPredictOperationMetadata_BatchPredictOutputInfo.DiscardUnknown(m)
}

var xxx_messageInfo_BatchPredictOperationMetadata_BatchPredictOutputInfo proto.InternalMessageInfo

type isBatchPredictOperationMetadata_BatchPredictOutputInfo_OutputLocation interface {
	isBatchPredictOperationMetadata_BatchPredictOutputInfo_OutputLocation()
}

type BatchPredictOperationMetadata_BatchPredictOutputInfo_GcsOutputDirectory struct {
	GcsOutputDirectory string `protobuf:"bytes,1,opt,name=gcs_output_directory,json=gcsOutputDirectory,proto3,oneof"`
}

type BatchPredictOperationMetadata_BatchPredictOutputInfo_BigqueryOutputDataset struct {
	BigqueryOutputDataset string `protobuf:"bytes,2,opt,name=bigquery_output_dataset,json=bigqueryOutputDataset,proto3,oneof"`
}

func (*BatchPredictOperationMetadata_BatchPredictOutputInfo_GcsOutputDirectory) isBatchPredictOperationMetadata_BatchPredictOutputInfo_OutputLocation() {
}

func (*BatchPredictOperationMetadata_BatchPredictOutputInfo_BigqueryOutputDataset) isBatchPredictOperationMetadata_BatchPredictOutputInfo_OutputLocation() {
}

func (m *BatchPredictOperationMetadata_BatchPredictOutputInfo) GetOutputLocation() isBatchPredictOperationMetadata_BatchPredictOutputInfo_OutputLocation {
	if m != nil {
		return m.OutputLocation
	}
	return nil
}

func (m *BatchPredictOperationMetadata_BatchPredictOutputInfo) GetGcsOutputDirectory() string {
	if x, ok := m.GetOutputLocation().(*BatchPredictOperationMetadata_BatchPredictOutputInfo_GcsOutputDirectory); ok {
		return x.GcsOutputDirectory
	}
	return ""
}

func (m *BatchPredictOperationMetadata_BatchPredictOutputInfo) GetBigqueryOutputDataset() string {
	if x, ok := m.GetOutputLocation().(*BatchPredictOperationMetadata_BatchPredictOutputInfo_BigqueryOutputDataset); ok {
		return x.BigqueryOutputDataset
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*BatchPredictOperationMetadata_BatchPredictOutputInfo) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _BatchPredictOperationMetadata_BatchPredictOutputInfo_OneofMarshaler, _BatchPredictOperationMetadata_BatchPredictOutputInfo_OneofUnmarshaler, _BatchPredictOperationMetadata_BatchPredictOutputInfo_OneofSizer, []interface{}{
		(*BatchPredictOperationMetadata_BatchPredictOutputInfo_GcsOutputDirectory)(nil),
		(*BatchPredictOperationMetadata_BatchPredictOutputInfo_BigqueryOutputDataset)(nil),
	}
}

func _BatchPredictOperationMetadata_BatchPredictOutputInfo_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*BatchPredictOperationMetadata_BatchPredictOutputInfo)
	// output_location
	switch x := m.OutputLocation.(type) {
	case *BatchPredictOperationMetadata_BatchPredictOutputInfo_GcsOutputDirectory:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.GcsOutputDirectory)
	case *BatchPredictOperationMetadata_BatchPredictOutputInfo_BigqueryOutputDataset:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.BigqueryOutputDataset)
	case nil:
	default:
		return fmt.Errorf("BatchPredictOperationMetadata_BatchPredictOutputInfo.OutputLocation has unexpected type %T", x)
	}
	return nil
}

func _BatchPredictOperationMetadata_BatchPredictOutputInfo_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*BatchPredictOperationMetadata_BatchPredictOutputInfo)
	switch tag {
	case 1: // output_location.gcs_output_directory
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.OutputLocation = &BatchPredictOperationMetadata_BatchPredictOutputInfo_GcsOutputDirectory{x}
		return true, err
	case 2: // output_location.bigquery_output_dataset
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.OutputLocation = &BatchPredictOperationMetadata_BatchPredictOutputInfo_BigqueryOutputDataset{x}
		return true, err
	default:
		return false, nil
	}
}

func _BatchPredictOperationMetadata_BatchPredictOutputInfo_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*BatchPredictOperationMetadata_BatchPredictOutputInfo)
	// output_location
	switch x := m.OutputLocation.(type) {
	case *BatchPredictOperationMetadata_BatchPredictOutputInfo_GcsOutputDirectory:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.GcsOutputDirectory)))
		n += len(x.GcsOutputDirectory)
	case *BatchPredictOperationMetadata_BatchPredictOutputInfo_BigqueryOutputDataset:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.BigqueryOutputDataset)))
		n += len(x.BigqueryOutputDataset)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Details of ExportModel operation.
type ExportModelOperationMetadata struct {
	// Output only. Information further describing the output of this model
	// export.
	OutputInfo           *ExportModelOperationMetadata_ExportModelOutputInfo `protobuf:"bytes,2,opt,name=output_info,json=outputInfo,proto3" json:"output_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                            `json:"-"`
	XXX_unrecognized     []byte                                              `json:"-"`
	XXX_sizecache        int32                                               `json:"-"`
}

func (m *ExportModelOperationMetadata) Reset()         { *m = ExportModelOperationMetadata{} }
func (m *ExportModelOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*ExportModelOperationMetadata) ProtoMessage()    {}
func (*ExportModelOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_operations_3312906655c3448c, []int{8}
}
func (m *ExportModelOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportModelOperationMetadata.Unmarshal(m, b)
}
func (m *ExportModelOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportModelOperationMetadata.Marshal(b, m, deterministic)
}
func (dst *ExportModelOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportModelOperationMetadata.Merge(dst, src)
}
func (m *ExportModelOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_ExportModelOperationMetadata.Size(m)
}
func (m *ExportModelOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportModelOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ExportModelOperationMetadata proto.InternalMessageInfo

func (m *ExportModelOperationMetadata) GetOutputInfo() *ExportModelOperationMetadata_ExportModelOutputInfo {
	if m != nil {
		return m.OutputInfo
	}
	return nil
}

// Further describes the output of model export.
// Supplements
//
// [ModelExportOutputConfig][google.cloud.automl.v1beta1.ModelExportOutputConfig].
type ExportModelOperationMetadata_ExportModelOutputInfo struct {
	// The full path of the Google Cloud Storage directory created, into which
	// the model will be exported.
	GcsOutputDirectory   string   `protobuf:"bytes,1,opt,name=gcs_output_directory,json=gcsOutputDirectory,proto3" json:"gcs_output_directory,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ExportModelOperationMetadata_ExportModelOutputInfo) Reset() {
	*m = ExportModelOperationMetadata_ExportModelOutputInfo{}
}
func (m *ExportModelOperationMetadata_ExportModelOutputInfo) String() string {
	return proto.CompactTextString(m)
}
func (*ExportModelOperationMetadata_ExportModelOutputInfo) ProtoMessage() {}
func (*ExportModelOperationMetadata_ExportModelOutputInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_operations_3312906655c3448c, []int{8, 0}
}
func (m *ExportModelOperationMetadata_ExportModelOutputInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportModelOperationMetadata_ExportModelOutputInfo.Unmarshal(m, b)
}
func (m *ExportModelOperationMetadata_ExportModelOutputInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportModelOperationMetadata_ExportModelOutputInfo.Marshal(b, m, deterministic)
}
func (dst *ExportModelOperationMetadata_ExportModelOutputInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportModelOperationMetadata_ExportModelOutputInfo.Merge(dst, src)
}
func (m *ExportModelOperationMetadata_ExportModelOutputInfo) XXX_Size() int {
	return xxx_messageInfo_ExportModelOperationMetadata_ExportModelOutputInfo.Size(m)
}
func (m *ExportModelOperationMetadata_ExportModelOutputInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportModelOperationMetadata_ExportModelOutputInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ExportModelOperationMetadata_ExportModelOutputInfo proto.InternalMessageInfo

func (m *ExportModelOperationMetadata_ExportModelOutputInfo) GetGcsOutputDirectory() string {
	if m != nil {
		return m.GcsOutputDirectory
	}
	return ""
}

// Details of EvaluatedExamples operation.
type ExportEvaluatedExamplesOperationMetadata struct {
	// Output only. Information further describing the output of this evaluated
	// examples export.
	OutputInfo           *ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo `protobuf:"bytes,2,opt,name=output_info,json=outputInfo,proto3" json:"output_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                                                                    `json:"-"`
	XXX_unrecognized     []byte                                                                      `json:"-"`
	XXX_sizecache        int32                                                                       `json:"-"`
}

func (m *ExportEvaluatedExamplesOperationMetadata) Reset() {
	*m = ExportEvaluatedExamplesOperationMetadata{}
}
func (m *ExportEvaluatedExamplesOperationMetadata) String() string { return proto.CompactTextString(m) }
func (*ExportEvaluatedExamplesOperationMetadata) ProtoMessage()    {}
func (*ExportEvaluatedExamplesOperationMetadata) Descriptor() ([]byte, []int) {
	return fileDescriptor_operations_3312906655c3448c, []int{9}
}
func (m *ExportEvaluatedExamplesOperationMetadata) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportEvaluatedExamplesOperationMetadata.Unmarshal(m, b)
}
func (m *ExportEvaluatedExamplesOperationMetadata) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportEvaluatedExamplesOperationMetadata.Marshal(b, m, deterministic)
}
func (dst *ExportEvaluatedExamplesOperationMetadata) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportEvaluatedExamplesOperationMetadata.Merge(dst, src)
}
func (m *ExportEvaluatedExamplesOperationMetadata) XXX_Size() int {
	return xxx_messageInfo_ExportEvaluatedExamplesOperationMetadata.Size(m)
}
func (m *ExportEvaluatedExamplesOperationMetadata) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportEvaluatedExamplesOperationMetadata.DiscardUnknown(m)
}

var xxx_messageInfo_ExportEvaluatedExamplesOperationMetadata proto.InternalMessageInfo

func (m *ExportEvaluatedExamplesOperationMetadata) GetOutputInfo() *ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo {
	if m != nil {
		return m.OutputInfo
	}
	return nil
}

// Further describes the output of the evaluated examples export.
// Supplements
//
// [ExportEvaluatedExamplesOutputConfig][google.cloud.automl.v1beta1.ExportEvaluatedExamplesOutputConfig].
type ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo struct {
	// The path of the BigQuery dataset created, in bq://projectId.bqDatasetId
	// format, into which the output of export evaluated examples is written.
	BigqueryOutputDataset string   `protobuf:"bytes,2,opt,name=bigquery_output_dataset,json=bigqueryOutputDataset,proto3" json:"bigquery_output_dataset,omitempty"`
	XXX_NoUnkeyedLiteral  struct{} `json:"-"`
	XXX_unrecognized      []byte   `json:"-"`
	XXX_sizecache         int32    `json:"-"`
}

func (m *ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo) Reset() {
	*m = ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo{}
}
func (m *ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo) String() string {
	return proto.CompactTextString(m)
}
func (*ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo) ProtoMessage() {}
func (*ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_operations_3312906655c3448c, []int{9, 0}
}
func (m *ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo.Unmarshal(m, b)
}
func (m *ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo.Marshal(b, m, deterministic)
}
func (dst *ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo.Merge(dst, src)
}
func (m *ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo) XXX_Size() int {
	return xxx_messageInfo_ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo.Size(m)
}
func (m *ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo proto.InternalMessageInfo

func (m *ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo) GetBigqueryOutputDataset() string {
	if m != nil {
		return m.BigqueryOutputDataset
	}
	return ""
}

func init() {
	proto.RegisterType((*OperationMetadata)(nil), "google.cloud.automl.v1beta1.OperationMetadata")
	proto.RegisterType((*DeleteOperationMetadata)(nil), "google.cloud.automl.v1beta1.DeleteOperationMetadata")
	proto.RegisterType((*DeployModelOperationMetadata)(nil), "google.cloud.automl.v1beta1.DeployModelOperationMetadata")
	proto.RegisterType((*UndeployModelOperationMetadata)(nil), "google.cloud.automl.v1beta1.UndeployModelOperationMetadata")
	proto.RegisterType((*CreateModelOperationMetadata)(nil), "google.cloud.automl.v1beta1.CreateModelOperationMetadata")
	proto.RegisterType((*ImportDataOperationMetadata)(nil), "google.cloud.automl.v1beta1.ImportDataOperationMetadata")
	proto.RegisterType((*ExportDataOperationMetadata)(nil), "google.cloud.automl.v1beta1.ExportDataOperationMetadata")
	proto.RegisterType((*ExportDataOperationMetadata_ExportDataOutputInfo)(nil), "google.cloud.automl.v1beta1.ExportDataOperationMetadata.ExportDataOutputInfo")
	proto.RegisterType((*BatchPredictOperationMetadata)(nil), "google.cloud.automl.v1beta1.BatchPredictOperationMetadata")
	proto.RegisterType((*BatchPredictOperationMetadata_BatchPredictOutputInfo)(nil), "google.cloud.automl.v1beta1.BatchPredictOperationMetadata.BatchPredictOutputInfo")
	proto.RegisterType((*ExportModelOperationMetadata)(nil), "google.cloud.automl.v1beta1.ExportModelOperationMetadata")
	proto.RegisterType((*ExportModelOperationMetadata_ExportModelOutputInfo)(nil), "google.cloud.automl.v1beta1.ExportModelOperationMetadata.ExportModelOutputInfo")
	proto.RegisterType((*ExportEvaluatedExamplesOperationMetadata)(nil), "google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata")
	proto.RegisterType((*ExportEvaluatedExamplesOperationMetadata_ExportEvaluatedExamplesOutputInfo)(nil), "google.cloud.automl.v1beta1.ExportEvaluatedExamplesOperationMetadata.ExportEvaluatedExamplesOutputInfo")
}

func init() {
	proto.RegisterFile("google/cloud/automl/v1beta1/operations.proto", fileDescriptor_operations_3312906655c3448c)
}

var fileDescriptor_operations_3312906655c3448c = []byte{
	// 884 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x96, 0xdd, 0x6e, 0x1b, 0x45,
	0x14, 0xc7, 0x59, 0x87, 0xaf, 0x1e, 0x53, 0x92, 0x4c, 0x9d, 0xc4, 0x75, 0xd2, 0x34, 0x5d, 0x21,
	0x11, 0x24, 0xb4, 0x4b, 0x43, 0x85, 0x0a, 0x11, 0x17, 0x4d, 0x62, 0xc0, 0x17, 0x56, 0x83, 0xf9,
	0x92, 0x20, 0x68, 0x35, 0xde, 0x1d, 0x2f, 0x83, 0x76, 0x77, 0x86, 0xd9, 0xd9, 0xca, 0xbe, 0x45,
	0x5c, 0xf4, 0xba, 0x37, 0x88, 0x27, 0xe0, 0x5d, 0x78, 0x05, 0x5e, 0x06, 0xed, 0xec, 0xac, 0x3f,
	0xd2, 0xf1, 0xd8, 0x8a, 0x90, 0x7a, 0xe7, 0x9d, 0xf3, 0xff, 0x9f, 0xdf, 0x9c, 0x33, 0x33, 0x47,
	0x86, 0x0f, 0x63, 0xc6, 0xe2, 0x84, 0xf8, 0x61, 0xc2, 0x8a, 0xc8, 0xc7, 0x85, 0x64, 0x69, 0xe2,
	0x3f, 0x7b, 0x38, 0x24, 0x12, 0x3f, 0xf4, 0x19, 0x27, 0x02, 0x4b, 0xca, 0xb2, 0xdc, 0xe3, 0x82,
	0x49, 0x86, 0xf6, 0x2b, 0xb5, 0xa7, 0xd4, 0x5e, 0xa5, 0xf6, 0xb4, 0xba, 0x73, 0xa0, 0x53, 0x61,
	0x4e, 0x7d, 0x9c, 0x65, 0x4c, 0xce, 0x5b, 0x3b, 0xef, 0xd9, 0x40, 0x94, 0x69, 0xd5, 0xfb, 0x36,
	0x55, 0xca, 0x22, 0x92, 0x68, 0xe1, 0xc9, 0x4a, 0x61, 0x40, 0x9e, 0xe1, 0xa4, 0x50, 0x7b, 0xd0,
	0x1e, 0xbd, 0x7b, 0x5f, 0x7d, 0x0d, 0x8b, 0x91, 0x4f, 0x52, 0x2e, 0x27, 0x3a, 0x78, 0xff, 0x7a,
	0x50, 0xd2, 0x94, 0xe4, 0x12, 0xa7, 0x5c, 0x0b, 0xf6, 0xb4, 0x40, 0xf0, 0xd0, 0xcf, 0x25, 0x96,
	0x85, 0xae, 0xcc, 0xfd, 0x1d, 0x60, 0xfb, 0x69, 0xdd, 0xa9, 0x3e, 0x91, 0x38, 0xc2, 0x12, 0xa3,
	0x9f, 0xe1, 0xdd, 0x88, 0x24, 0x44, 0x92, 0x20, 0x22, 0x12, 0xd3, 0x24, 0x6f, 0xbf, 0x7d, 0xe4,
	0x1c, 0x37, 0x4f, 0x1e, 0x79, 0x96, 0x1e, 0x7a, 0x17, 0xca, 0xf2, 0x52, 0xb6, 0xaf, 0x5e, 0x1b,
	0xdc, 0xae, 0xb2, 0x5d, 0x54, 0xc9, 0x50, 0x0a, 0xad, 0x88, 0xf0, 0x84, 0x4d, 0x82, 0xaa, 0xd8,
	0x1a, 0xd2, 0x56, 0x90, 0x4f, 0x57, 0x40, 0x4a, 0x63, 0xbf, 0xf4, 0x99, 0x48, 0x28, 0x9a, 0xc5,
	0x6b, 0x5c, 0x0e, 0xbb, 0x45, 0x66, 0x04, 0xde, 0x55, 0xc0, 0x53, 0x2b, 0xf0, 0xbb, 0x2c, 0xb2,
	0x23, 0x5b, 0x45, 0x66, 0x80, 0xa6, 0xd0, 0x0a, 0x05, 0xc1, 0x92, 0x5c, 0x43, 0xc2, 0x1a, 0x35,
	0x9e, 0x2b, 0xe3, 0xf2, 0x1a, 0xc3, 0x59, 0xbc, 0xc6, 0xfd, 0x0a, 0x77, 0x68, 0xca, 0x99, 0x90,
	0x41, 0x29, 0x9a, 0xd2, 0x36, 0x15, 0xed, 0xb1, 0x95, 0xd6, 0x53, 0xbe, 0x0b, 0x2c, 0xb1, 0x09,
	0xb6, 0x4d, 0xa7, 0xe1, 0x9a, 0xc5, 0x61, 0x67, 0x88, 0x65, 0xf8, 0x4b, 0xc0, 0x05, 0x89, 0x68,
	0x28, 0xa7, 0xb4, 0x2d, 0x45, 0xfb, 0xcc, 0x4a, 0x3b, 0x2b, 0x9d, 0x97, 0x95, 0xd1, 0xc4, 0xbb,
	0x33, 0x9c, 0x13, 0xcc, 0x55, 0x47, 0xc6, 0x2f, 0x57, 0xb7, 0xb3, 0x46, 0x75, 0xdd, 0xb1, 0xb5,
	0x3a, 0x32, 0xbe, 0x5e, 0x5d, 0x0a, 0x2d, 0xcd, 0x5a, 0x3c, 0xb8, 0xdd, 0x35, 0x0e, 0xae, 0x82,
	0x2d, 0x3f, 0x38, 0x32, 0x8b, 0xd7, 0xb8, 0x17, 0x0e, 0x3c, 0xd0, 0x3c, 0xfd, 0xe6, 0x49, 0x14,
	0x90, 0x31, 0x4e, 0x79, 0x42, 0xf2, 0x29, 0xbc, 0xa3, 0xe0, 0xdd, 0x35, 0xe0, 0xdd, 0x3a, 0x49,
	0x57, 0xe7, 0x30, 0x6d, 0xe4, 0x90, 0x98, 0xb5, 0xf5, 0xa6, 0x3e, 0x80, 0x2d, 0x2e, 0x58, 0x2c,
	0x48, 0x9e, 0x07, 0x9c, 0x88, 0x90, 0x64, 0xb2, 0x7d, 0xfb, 0xc8, 0x39, 0x7e, 0x63, 0xb0, 0x59,
	0xaf, 0x5f, 0x56, 0xcb, 0xe8, 0x73, 0xd8, 0xe2, 0x58, 0x48, 0x8a, 0x93, 0x60, 0x84, 0x69, 0x52,
	0x08, 0x92, 0xb7, 0x1b, 0x47, 0x1b, 0xc7, 0xcd, 0x13, 0x54, 0xef, 0x56, 0xf0, 0xd0, 0xfb, 0x46,
	0x0d, 0x9d, 0xc1, 0xa6, 0xd6, 0x7e, 0xa1, 0xa5, 0xe8, 0x14, 0x9a, 0xfa, 0x99, 0x94, 0x23, 0xab,
	0xbd, 0xa1, 0xea, 0xec, 0xd4, 0xce, 0x7a, 0x9e, 0x79, 0xdf, 0xd6, 0xf3, 0x6c, 0x00, 0x95, 0xbc,
	0x5c, 0x28, 0xcd, 0x05, 0x8f, 0xa6, 0xe6, 0xd7, 0x57, 0x9b, 0x2b, 0x79, 0xb9, 0x70, 0x76, 0x0b,
	0xde, 0xd2, 0xdd, 0x75, 0xef, 0xc2, 0xde, 0x92, 0xd9, 0xe5, 0x1e, 0xc2, 0x81, 0x6d, 0xe2, 0xb8,
	0x47, 0x70, 0x68, 0x1f, 0x10, 0x65, 0x06, 0xdb, 0x7b, 0x76, 0xef, 0xc1, 0xbe, 0xe5, 0x05, 0xba,
	0x7f, 0x37, 0x60, 0xdf, 0x72, 0x87, 0x51, 0x06, 0x4d, 0x56, 0x48, 0x5e, 0xc8, 0x80, 0x66, 0x23,
	0xd6, 0x76, 0x54, 0x0f, 0xfa, 0x37, 0x7d, 0x12, 0xf3, 0x31, 0x95, 0xb5, 0x97, 0x8d, 0xd8, 0x00,
	0xd8, 0xf4, 0x77, 0xe7, 0x4f, 0x07, 0x5a, 0x26, 0x11, 0x3a, 0x81, 0x56, 0x1c, 0xe6, 0x81, 0xde,
	0x4c, 0x44, 0x05, 0x09, 0x25, 0x13, 0x13, 0xb5, 0xa3, 0x5b, 0xe5, 0xe5, 0x8f, 0xc3, 0xbc, 0x92,
	0x5f, 0xd4, 0x31, 0xf4, 0x18, 0xf6, 0x86, 0x34, 0xfe, 0xad, 0x20, 0x62, 0x32, 0x35, 0x62, 0x89,
	0x73, 0x22, 0xdb, 0x0d, 0x6d, 0xdb, 0xa9, 0x05, 0xda, 0x5b, 0x85, 0xcf, 0xb6, 0x61, 0x53, 0x1b,
	0x12, 0x16, 0xaa, 0x12, 0xdc, 0xe7, 0x1b, 0x70, 0xcf, 0x3a, 0x5d, 0xd0, 0x0f, 0xf0, 0x0e, 0xcd,
	0x4a, 0x4f, 0xc8, 0xb2, 0x11, 0x8d, 0x75, 0xb3, 0x1e, 0xad, 0x3d, 0xaf, 0x7a, 0xa5, 0xf9, 0x5c,
	0x79, 0x07, 0x4d, 0x3a, 0xfb, 0x40, 0x62, 0xf1, 0x10, 0x1a, 0x2a, 0xef, 0xd7, 0x37, 0x9f, 0x83,
	0x8b, 0x51, 0xf3, 0x41, 0xfc, 0xe5, 0xc0, 0xae, 0x59, 0xf6, 0xea, 0x8f, 0xe2, 0x5f, 0x07, 0x0e,
	0x6c, 0xb3, 0x10, 0x71, 0x53, 0xc3, 0x9e, 0xde, 0x78, 0xb6, 0x2e, 0x04, 0xcd, 0xed, 0xea, 0xc1,
	0x8e, 0x51, 0x84, 0x3e, 0xb2, 0x35, 0xcb, 0xd4, 0x2a, 0xf7, 0x45, 0x03, 0x8e, 0xd7, 0x1d, 0xb6,
	0xe8, 0xb9, 0x63, 0x2a, 0x35, 0xfe, 0x5f, 0x26, 0xf9, 0x52, 0xa1, 0xb9, 0x05, 0x3f, 0xc1, 0x83,
	0x95, 0x06, 0xf4, 0xc9, 0x8a, 0x7b, 0xb0, 0xec, 0x16, 0xfc, 0xe1, 0xc0, 0xfd, 0x90, 0xa5, 0xb6,
	0xba, 0x2e, 0x9d, 0x1f, 0x9f, 0xe8, 0x70, 0xcc, 0x12, 0x9c, 0xc5, 0x1e, 0x13, 0xb1, 0x1f, 0x93,
	0x4c, 0x4d, 0x6a, 0xbf, 0x0a, 0x61, 0x4e, 0x73, 0xe3, 0x1f, 0xe3, 0xd3, 0xea, 0xf3, 0x9f, 0xc6,
	0xfe, 0x97, 0x4a, 0x78, 0x75, 0x5e, 0x8a, 0xae, 0x9e, 0x14, 0x92, 0xf5, 0x93, 0xab, 0xef, 0x2b,
	0xd1, 0xf0, 0x4d, 0x95, 0xeb, 0xe3, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0x12, 0x19, 0x35, 0xdb,
	0x1b, 0x0c, 0x00, 0x00,
}
