// Copyright (c) 2020 Red Hat, Inc.
package util

import (
	"crypto/x509"
	"testing"

	"github.com/stretchr/testify/assert"
)

func TestDecodeCertificateBytes(t *testing.T) {
	var certBytes []byte = []byte("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")
	var certs []*x509.Certificate = DecodeCertificateBytes(certBytes)
	assert.True(t, len(certs) == 0)

	var singlecert string = `
-----BEGIN CERTIFICATE-----
MIIDKjCCAhKgAwIBAgIQaVca4F33zuF/67tQLGJBFTANBgkqhkiG9w0BAQsFADAw
MRAwDgYDVQQKEwdSZWQgSGF0MRwwGgYDVQQDExNjb25zb2xlLWNoYXJ0LWIyNmQz
MB4XDTIwMDUxOTAwMzg1MVoXDTIwMDgxNzAwMzg1MVowMDEQMA4GA1UEChMHUmVk
IEhhdDEcMBoGA1UEAxMTY29uc29sZS1jaGFydC1iMjZkMzCCASIwDQYJKoZIhvcN
AQEBBQADggEPADCCAQoCggEBAMeVa8sV/J9Q2aolArgJ7zbEUceb/SRHV3/thrAJ
JI2GBtmN/1fianGQiDhT5uyYbI4sPS+ezMb+sMeebHFKBpV5WFfXxggx53gC8i6D
E1mopT8GMaDrufvptrTMezZwCdpbL9eaPmF95my5QVLtwLdbomajDHFiIObyquMq
SWTZuRM6YVkds3LX6slXsx11fR+asGCejYDcnZSfYZjj23vGoJ0rdx5IDC6phkts
FOdRkjE4quEaQr8uzGOKMoiwMf8lKHp6HOzkNlkMPKHi3ZkSV/FzqM3fgSB2aV3A
A/FRQZxcxvOkPq79K97xxbrVJZQOMcIBCa/ZmeYUUUH+EbsCAwEAAaNAMD4wDgYD
VR0PAQH/BAQDAgWgMAwGA1UdEwEB/wQCMAAwHgYDVR0RBBcwFYITY29uc29sZS1j
aGFydC1iMjZkMzANBgkqhkiG9w0BAQsFAAOCAQEAC3eIxBvgJAdMiFX1/LKbco3e
y8mqtWhX4dBXHsh1FXoVQdONysaEYaCNpwj8P9rNqn++RnsCnqxMxYKO6C8C7A1w
SWjZRqmKN3NxMADap8VFrgLtK64pEeABCUFtaNE7NrkVVsXriP/Ou0zDqhHbkWnx
DkfucIiFsArdyVItIRrXz1QnxmzDxV4/hcVswabW7XyJ8O2zr80NpkHt+xkzAxUM
eYT4R967QQjq7D3aVq6YnpJLY//L4c1AmdUY+nMl5BH4U0rqv9punL1FGda/nbrW
24/SYHsZQtLryXxqs5PGoo13OUKLIAOlwM1EPcLwErFjKtkhmbC3MsiLkG7qfw==
-----END CERTIFICATE-----`
	certBytes = []byte(singlecert)
	certs = DecodeCertificateBytes(certBytes)
	assert.True(t, len(certs) == 1)

	var multicert string = `-----BEGIN CERTIFICATE-----
MIICADCCAaagAwIBAgIUQ0hq1Lmd6ujao+8Iy6LfpMdyNI8wCgYIKoZIzj0EAwIw
TDELMAkGA1UEBhMCVVMxFjAUBgNVBAgTDVNhbiBGcmFuY2lzY28xCzAJBgNVBAcT
AkNBMRgwFgYDVQQDEw9ldGNkcHJveHktdGVzdHMwHhcNMTgwNzMwMTExMDAwWhcN
MjMwNzI5MTExMDAwWjBMMQswCQYDVQQGEwJVUzEWMBQGA1UECBMNU2FuIEZyYW5j
aXNjbzELMAkGA1UEBxMCQ0ExGDAWBgNVBAMTD2V0Y2Rwcm94eS10ZXN0czBZMBMG
ByqGSM49AgEGCCqGSM49AwEHA0IABGoowUY2eQdvaHG4S/UMYD6mjs6/P7mmhizl
KWO03gq2eVSsbiYAnCJok3o2WQ01GtcS6bOUJ1DOG0gLTRfQ/lWjZjBkMA4GA1Ud
DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgECMB0GA1UdDgQWBBQmqCeN+suT
0JjgSxtCqTln7zonHjAfBgNVHSMEGDAWgBQmqCeN+suT0JjgSxtCqTln7zonHjAK
BggqhkjOPQQDAgNIADBFAiAUKV8vkiIoCiqtHQsp3PrUUV3He2B9K1tQgA8loTa+
IQIhANPbCDVoPSFsX0I5iG/DQl/MmTo/tlsmNkN99j1j2JIM
-----END CERTIFICATE-----
-----BEGIN CERTIFICATE-----
MIICADCCAaagAwIBAgIUU8ZsD37pcA1UYkgwhR6d/KjdGeAwCgYIKoZIzj0EAwIw
TDELMAkGA1UEBhMCVVMxFjAUBgNVBAgTDVNhbiBGcmFuY2lzY28xCzAJBgNVBAcT
AkNBMRgwFgYDVQQDEw9ldGNkcHJveHktdGVzdHMwHhcNMTgwNzMwMTExMTAwWhcN
MjMwNzI5MTExMTAwWjBMMQswCQYDVQQGEwJVUzEWMBQGA1UECBMNU2FuIEZyYW5j
aXNjbzELMAkGA1UEBxMCQ0ExGDAWBgNVBAMTD2V0Y2Rwcm94eS10ZXN0czBZMBMG
ByqGSM49AgEGCCqGSM49AwEHA0IABLupsOF50q6GE7z2US77t5iLGe9wdOFwHssC
jUjCEGvJ/d2sGMxdiABJrrB8gau6TilrJCy9ZTYj56fzdReUnsKjZjBkMA4GA1Ud
DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgECMB0GA1UdDgQWBBRhaKyklrnI
wd2kg84t1D8CvDVtdjAfBgNVHSMEGDAWgBRhaKyklrnIwd2kg84t1D8CvDVtdjAK
BggqhkjOPQQDAgNIADBFAiAOCYqtOamRapNc+XxR7IFzlr7Si7EvjQ+ej5SKHb7g
rgIhAIBd1dtMc0KJSFsoxnQZailkFi5Nlea2eHU1wEDKVb40
-----END CERTIFICATE-----
-----BEGIN CERTIFICATE-----
MIIB/zCCAaagAwIBAgIUVCSMefpK8uxDKy87jKnwc97DseIwCgYIKoZIzj0EAwIw
TDELMAkGA1UEBhMCVVMxFjAUBgNVBAgTDVNhbiBGcmFuY2lzY28xCzAJBgNVBAcT
AkNBMRgwFgYDVQQDEw9ldGNkcHJveHktdGVzdHMwHhcNMTgwNzMwMTExMTAwWhcN
MjMwNzI5MTExMTAwWjBMMQswCQYDVQQGEwJVUzEWMBQGA1UECBMNU2FuIEZyYW5j
aXNjbzELMAkGA1UEBxMCQ0ExGDAWBgNVBAMTD2V0Y2Rwcm94eS10ZXN0czBZMBMG
ByqGSM49AgEGCCqGSM49AwEHA0IABOhGVuxW0nEQ5REqQdRF1eJ7OUOdXB/oDJed
Jr1ezcyhJyCRvD9DfadSBvMHFyzw7ssBIIMm4C3Eufj96M3tSACjZjBkMA4GA1Ud
DwEB/wQEAwIBBjASBgNVHRMBAf8ECDAGAQH/AgECMB0GA1UdDgQWBBTLR9qOF3Hh
if8KUbkrRYUK13xSSDAfBgNVHSMEGDAWgBTLR9qOF3Hhif8KUbkrRYUK13xSSDAK
BggqhkjOPQQDAgNHADBEAiAFD2zRXnp40wVeffwpkU+ToFF6Nts/HJk02iMr/+km
RgIgRLZxonlkyLlUHucMKC2V+4UJ9akEbu/bhCXKuQb2DgY=
-----END CERTIFICATE-----
-----BEGIN RSA PRIVATE KEY-----
MIIEowIBAAKCAQEAx5VryxX8n1DZqiUCuAnvNsRRx5v9JEdXf+2GsAkkjYYG2Y3/
V+JqcZCIOFPm7Jhsjiw9L57Mxv6wx55scUoGlXlYV9fGCDHneALyLoMTWailPwYx
oOu5++m2tMx7NnAJ2lsv15o+YX3mbLlBUu3At1uiZqMMcWIg5vKq4ypJZNm5Ezph
WR2zctfqyVezHXV9H5qwYJ6NgNydlJ9hmOPbe8agnSt3HkgMLqmGS2wU51GSMTiq
4RpCvy7MY4oyiLAx/yUoenoc7OQ2WQw8oeLdmRJX8XOozd+BIHZpXcAD8VFBnFzG
86Q+rv0r3vHFutUllA4xwgEJr9mZ5hRRQf4RuwIDAQABAoIBABiSsBvoEBt5c+M7
/VK1fmtqznraHNfLpN1OXGfuKD74gn1ku0yRxvNGjU8KHYOB3NPAZKQpVCMoFpHt
UoK8T4U11Ie0PGCj7FDdY/4QC2Ddn8Lbu16Jx3NZujIWfxEbyErHMWPFTOrp+mXm
hUF1nmW09ZDXgF+xakWlGR8xBKpS4GeN6ztb3IdILlAZX7ViYiHlDLJsYS2EfVNw
DijgRKoaFyLp5xicloNpGpC8YNYSUc+vRT/bDIkdpGWm63FNhU5LUVedVffqmDfS
SEbbM2UmP93KZ4zd/UtX392L3BBfXxfwAbVm9tAmxYxsIM7Ud5qXSbL8ivgW7g0S
dUeqDekCgYEA0sj1hmDI/1yuwNv+rZ7dTjjuiJuWE/UT9z+qFtvvmiBVJRaANw/p
WxcSlFTKcDiNL9sqBJC6PasiuwXoNdhmUvvHg6mzobz3VDSObknxTO9ARYiWFh5k
eRzG0qaTcWgxcEa6zbtlauphbmuY2S0viWECl55+SwwC+jqobJ+vEg0CgYEA8mVa
X2MWTSFGNMzm0AsTbHkdlwz8bnHv9rJxk63e2sYttRv40iPDc2Jpm+UWqec8L8Oj
Mc+OfI33RVL+j8PVSggzPLk2fQ0SaVC73BOfIczjthWrn/he4oj2hbJkZDUxunMy
0MmQAhW2z+i+wiLxQ4W6RzqhreZvadR1jvgN6OcCgYAlLvApAV/TtFzbhrN5m0G8
78wcax3hbWVVQ3TUzX2J+dQrU7nQfM0UlZBgfEit3TwCyi2yWnmQMWVSCqu4+/Cp
CONcNY6LpJMY1qCdkguwH7B906duRXRB7TKhrGLsKY43GTMQ4dL1Nl1zpiVzgkYV
fPiBGKN8x6Sq0bguWUj/7QKBgQCTtS9c8QSl+6DMjBAatqUfdK6TXVZ19vhDXHnZ
hBpJNnqj4me9pg10QoQYe4FUB5SlhpHryI8LV3dWxzxYXv2aH2UZm8OYcF7Hzmqr
sUlHT5NzYcEzuiYX5V5UGmESr1eeRpSwpiMbIiBEkY+svZ5HhzX8Mb5UOheqZc09
UesoAQKBgHp04UHDxMzUV+jcOYT+J7+/bLnzJW4jF7Z/27/oSbPVTIh7FyrVygSl
t/CIranv84u4TYG6vvr5S+w5v/5bk86XHme2oU7+tBVQ8qTxCo6XJRDfvQn1ZEik
5M4dhSKmWDLa07P6Vune8wodpNDJjrT1o4ahIdTYA3ibbE1gnAV+
-----END RSA PRIVATE KEY-----`
	certBytes = []byte(multicert)
	certs = DecodeCertificateBytes(certBytes)
	assert.True(t, len(certs) == 3)
}
