---
title: "Velero 1.0 Has Arrived: Delivering Enhanced Stability, Usability and Extensibility Features"
slug: velero-1.0-has-arrived
# image: https://placehold.it/200x200
excerpt: Just three months after the release of Velero 0.11, the community’s momentum continues with the delivery of the landmark version 1.0 release.
author_name: Tom Spoonemore
# author_avatar: https://placehold.it/64x64
categories: ['velero','release']
# Tag should match author to drive author pages
tags: ['Velero Team', 'Tom Spoonemore']
---
Just three months after the release of Velero 0.11, the community’s momentum continues with the delivery of the landmark version 1.0 release. This significant release improves the installation experience, Helm support, the plugin system, and overall stability. We want to thank the community and the team, and acknowledge all of their hard work and amazing contributions to this major milestone.

Data protection is always a chief concern for application owners who want to make sure that they can restore a cluster to a known good state, recover from a crashed cluster, or migrate to a new environment. With Velero 1.0, Kubernetes cluster administrators can feel confident that they have a production-grade backup solution for their cluster resources and applications.

Following are the highlights of Velero 1.0.

## Improved Installation and Helm Support

Velero now has a new `velero install` command to help get up and running quickly. The new installation lets you specify cloud provider information in one step. If you want to see what changes will be made to your cluster or customize the YAML that the Velero installation will make, you can use the new `--dry-run` option to output the full configuration.

Helm is one of the best ways to manage packages for Kubernetes deployments, and while the Velero team has always contributed to the community developing the Velero Helm chart, we can now announce that it is fully supported and a great way to make your Velero server installation quicker, simpler, and more easily customizable.

## Better Plugin Support

This release overhauls the plugin interface to enhance the extensibility of Velero. It is now easier for developers to contribute and maintain plugins. We’ve reworked the import surface, reducing the number of modules that need to be called directly by plugin developers. We’ve also improved plugin name checking to prevent collisions of plugins that have the same name.

When problems happen, you need to have as much data as possible for troubleshooting. Now Velero traps plugin panics and logs errors, which are annotated with the file and line where the error occurred.

Plugin authors now have the flexibility to add custom logic to govern whether a particular item should be restored. This can be helpful in a number of upgrade and migration use cases.

## Updated Portworx Plugin

In conjunction with the Velero 1.0 release, we are happy to announce an update to the Portworx plugin. Here’s what **Vick Kelkar**, Director Product Management at Portworx, is saying about cloud native data protection and Velero:

> “As organizations move critical applications to Kubernetes, they must be able to meet strict requirements around business continuity and disaster recovery. This means backing up the Kubernetes control plane as well as application data. Velero backs up control plane information and now, with the Portworx Enterprise Velero plugin, organizations can back up, protect and migrate their mission data across Kubernetes clusters and environments with zero downtime.”

Thanks to Vick and the Portworx team for their support and contributions to Velero.

## Restic is Now Beta

We have moved our support for Restic to beta with the 1.0 release. For admins running Kubernetes on-premises or using  storage systems that aren’t yet supported by Velero plugins, Restic offers file system level backups and restores that are fully supported in Velero. While we put in the final touches to meet our bar for stability and performance, we are upgrading the status of Restic to beta in recognition of all the admins that are finding value in file system backup support.

## Stability and Usability Improvements

We’ve now added safety checks to ensure that Velero doesn’t overwrite an existing backup in Object Storage. Because that would be bad. Now, if a backup needs to be replaced with the same name, it will need to be deleted first, and then recreated.

In the real world, not every backup or restore succeeds fully every time. In the past, Velero marked these incomplete actions with a `failed` status. With Velero 1.0, we have introduced an additional phrase to indicate `partial failure`. This phrase lets a cluster admin know that there are issues with the backup or restore, but indicates that the action was able to finish.

The restoration of resources that you selectively backed up is now improved with better support for related items, such as dynamic volumes. Previously, if you partially restored data by using a label selector, dynamically provisioned persistent volumes were not restored because they didn't get a label when they are created. Now Velero has better logic to handle related items and will restore volumes attached to pods that meet the label selector condition.

## Breaking Changes

No major release is complete without a few breaking changes. We have a couple in this release.

We are saying goodbye to the Heptio Ark API data types. We left these around after the name of Heptio Ark was changed to Velero in version 0.11, but now it is time for them to go. If you have software using the older API data types, you’ll want to make updates before upgrading to Velero 1.0.

Though technically not a breaking change, we have changed the way we are handing Azure secrets. You will create a credential file and pass it to `velero install`. It is now more consistent with how we handle secrets for the other providers and is the method used by both the Helm chart and `velero install`. We still support the old method for now.

## Join the Movement – Contribute!

Velero is better because of our contributors and maintainers. It is because of them that we can bring great software to the community. Please join us during our [online community meetings twice a month](https://github.com/vmware-tanzu/velero-community) and catch up with past meetings on YouTube at the [VMware Cloud Native Apps channel](https://www.youtube.com/channel/UCdkGV51Nu0unDNT58bHt9bg/featured) and the [Velero Community Meetings playlist](https://www.youtube.com/watch?v=nc48ocI-6go&list=PL7bmigfV0EqQRysvqvqOtRNk4L5S7uqwM).

You can always find the latest project information at [https://velero.io](https://velero.io). Look for issues on GitHub marked [“Good first issue”](https://github.com/vmware-tanzu/velero/issues?q=is:open+is:issue+label:%22Good+first+issue%22) or [“Help wanted”](https://github.com/vmware-tanzu/velero/issues?utf8=✓&q=is:open+is:issue+label:%22Help+wanted%22+) if you want to roll up your sleeves and write some code with us.

You can find us on [Kubernetes Slack at the #velero channel](https://kubernetes.slack.com/messages/C6VCGP4MT). Follow us on Twitter at [@ProjectVelero](https://twitter.com/projectvelero).

Tom Spoonemore  
Velero SME  
Product Line Manager, VMware  
[@tunemore](https://twitter.com/tunemore)
