// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codebuild_test

import (
	"context"
	"fmt"
	"strings"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/aws/awserr"
	"github.com/aws/aws-sdk-go-v2/aws/external"
	"github.com/aws/aws-sdk-go-v2/service/codebuild"
)

var _ time.Duration
var _ strings.Reader
var _ aws.Config

func parseTime(layout, value string) *time.Time {
	t, err := time.Parse(layout, value)
	if err != nil {
		panic(err)
	}
	return &t
}

// To get information about builds
//
// The following example gets information about builds with the specified build IDs.
func ExampleClient_BatchGetBuildsRequest_shared00() {
	cfg, err := external.LoadDefaultAWSConfig()
	if err != nil {
		panic("failed to load config, " + err.Error())
	}

	svc := codebuild.New(cfg)
	input := &codebuild.BatchGetBuildsInput{
		Ids: []string{
			"codebuild-demo-project:9b0ac37f-d19e-4254-9079-f47e9a389eEX",
			"codebuild-demo-project:b79a46f7-1473-4636-a23f-da9c45c208EX",
		},
	}

	req := svc.BatchGetBuildsRequest(input)
	result, err := req.Send(context.Background())
	if err != nil {
		if aerr, ok := err.(awserr.Error); ok {
			switch aerr.Code() {
			case codebuild.ErrCodeInvalidInputException:
				fmt.Println(codebuild.ErrCodeInvalidInputException, aerr.Error())
			default:
				fmt.Println(aerr.Error())
			}
		} else {
			// Print the error, cast err to awserr.Error to get the Code and
			// Message from an error.
			fmt.Println(err.Error())
		}
		return
	}

	fmt.Println(result)
}
