// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package comprehend

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type CreateEntityRecognizerInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the request. If you don't set the client request
	// token, Amazon Comprehend generates one.
	ClientRequestToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The Amazon Resource Name (ARN) of the AWS Identity and Management (IAM) role
	// that grants Amazon Comprehend read access to your input data.
	//
	// DataAccessRoleArn is a required field
	DataAccessRoleArn *string `min:"20" type:"string" required:"true"`

	// Specifies the format and location of the input data. The S3 bucket containing
	// the input data must be located in the same region as the entity recognizer
	// being created.
	//
	// InputDataConfig is a required field
	InputDataConfig *EntityRecognizerInputDataConfig `type:"structure" required:"true"`

	// The language of the input documents. All documents must be in the same language.
	// Only English ("en") is currently supported.
	//
	// LanguageCode is a required field
	LanguageCode LanguageCode `type:"string" required:"true" enum:"true"`

	// The name given to the newly created recognizer. Recognizer names can be a
	// maximum of 256 characters. Alphanumeric characters, hyphens (-) and underscores
	// (_) are allowed. The name must be unique in the account/region.
	//
	// RecognizerName is a required field
	RecognizerName *string `type:"string" required:"true"`

	// Tags to be associated with the entity recognizer being created. A tag is
	// a key-value pair that adds as a metadata to a resource used by Amazon Comprehend.
	// For example, a tag with "Sales" as the key might be added to a resource to
	// indicate its use by the sales department.
	Tags []Tag `type:"list"`

	// ID for the AWS Key Management Service (KMS) key that Amazon Comprehend uses
	// to encrypt data on the storage volume attached to the ML compute instance(s)
	// that process the analysis job. The VolumeKmsKeyId can be either of the following
	// formats:
	//
	//    * KMS Key ID: "1234abcd-12ab-34cd-56ef-1234567890ab"
	//
	//    * Amazon Resource Name (ARN) of a KMS Key: "arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab"
	VolumeKmsKeyId *string `type:"string"`

	// Configuration parameters for an optional private Virtual Private Cloud (VPC)
	// containing the resources you are using for your custom entity recognizer.
	// For more information, see Amazon VPC (https://docs.aws.amazon.com/vpc/latest/userguide/what-is-amazon-vpc.html).
	VpcConfig *VpcConfig `type:"structure"`
}

// String returns the string representation
func (s CreateEntityRecognizerInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEntityRecognizerInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "CreateEntityRecognizerInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ClientRequestToken", 1))
	}

	if s.DataAccessRoleArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("DataAccessRoleArn"))
	}
	if s.DataAccessRoleArn != nil && len(*s.DataAccessRoleArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("DataAccessRoleArn", 20))
	}

	if s.InputDataConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("InputDataConfig"))
	}
	if len(s.LanguageCode) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("LanguageCode"))
	}

	if s.RecognizerName == nil {
		invalidParams.Add(aws.NewErrParamRequired("RecognizerName"))
	}
	if s.InputDataConfig != nil {
		if err := s.InputDataConfig.Validate(); err != nil {
			invalidParams.AddNested("InputDataConfig", err.(aws.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.VpcConfig != nil {
		if err := s.VpcConfig.Validate(); err != nil {
			invalidParams.AddNested("VpcConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type CreateEntityRecognizerOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) that identifies the entity recognizer.
	EntityRecognizerArn *string `type:"string"`
}

// String returns the string representation
func (s CreateEntityRecognizerOutput) String() string {
	return awsutil.Prettify(s)
}

const opCreateEntityRecognizer = "CreateEntityRecognizer"

// CreateEntityRecognizerRequest returns a request value for making API operation for
// Amazon Comprehend.
//
// Creates an entity recognizer using submitted files. After your CreateEntityRecognizer
// request is submitted, you can check job status using the API.
//
//    // Example sending a request using CreateEntityRecognizerRequest.
//    req := client.CreateEntityRecognizerRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/comprehend-2017-11-27/CreateEntityRecognizer
func (c *Client) CreateEntityRecognizerRequest(input *CreateEntityRecognizerInput) CreateEntityRecognizerRequest {
	op := &aws.Operation{
		Name:       opCreateEntityRecognizer,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateEntityRecognizerInput{}
	}

	req := c.newRequest(op, input, &CreateEntityRecognizerOutput{})
	return CreateEntityRecognizerRequest{Request: req, Input: input, Copy: c.CreateEntityRecognizerRequest}
}

// CreateEntityRecognizerRequest is the request type for the
// CreateEntityRecognizer API operation.
type CreateEntityRecognizerRequest struct {
	*aws.Request
	Input *CreateEntityRecognizerInput
	Copy  func(*CreateEntityRecognizerInput) CreateEntityRecognizerRequest
}

// Send marshals and sends the CreateEntityRecognizer API request.
func (r CreateEntityRecognizerRequest) Send(ctx context.Context) (*CreateEntityRecognizerResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &CreateEntityRecognizerResponse{
		CreateEntityRecognizerOutput: r.Request.Data.(*CreateEntityRecognizerOutput),
		response:                     &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// CreateEntityRecognizerResponse is the response type for the
// CreateEntityRecognizer API operation.
type CreateEntityRecognizerResponse struct {
	*CreateEntityRecognizerOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// CreateEntityRecognizer request.
func (r *CreateEntityRecognizerResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
