/**
 * Represents the map of configuration settings
 */
export interface ConfigValues {
    [key: string]: string | string[];
}
/**
 * Represents the current git configuration, as defined by the output from `git log`
 */
export interface ConfigListSummary {
    /**
     * All configuration settings, where local/user settings override user/global settings
     * the overridden value will appear in this object.
     */
    readonly all: ConfigValues;
    /**
     * The file paths configuration was read from
     */
    files: string[];
    /**
     * The `ConfigValues` for each of the `files`, use this object to determine
     * local repo, user and global settings.
     */
    values: {
        [fileName: string]: ConfigValues;
    };
}
export declare class ConfigList implements ConfigListSummary {
    private _all;
    get all(): ConfigValues;
    files: string[];
    values: {
        [fileName: string]: ConfigValues;
    };
    addFile(file: string): ConfigValues;
    addValue(file: string, key: string, value: string): void;
}
export declare function configListParser(text: string): ConfigList;
