import { DocumentNode, GraphQLError, GraphQLSchema } from 'graphql';
import { Trace } from 'apollo-engine-reporting-protobuf';
import { RequestAgent } from 'apollo-server-env';
import { GraphQLRequestContext, Logger } from 'apollo-server-types';
import { ApolloServerPlugin } from 'apollo-server-plugin-base';
export interface ClientInfo {
    clientName?: string;
    clientVersion?: string;
    clientReferenceId?: string;
}
export declare type SendValuesBaseOptions = {
    onlyNames: Array<String>;
} | {
    exceptNames: Array<String>;
} | {
    all: true;
} | {
    none: true;
};
declare type VariableValueTransformOptions = {
    variables: Record<string, any>;
    operationString?: string;
};
export declare type VariableValueOptions = {
    transform: (options: VariableValueTransformOptions) => Record<string, any>;
} | SendValuesBaseOptions;
export declare type GenerateClientInfo<TContext> = (requestContext: GraphQLRequestContext<TContext>) => ClientInfo;
export declare function getEngineApiKey({ engine, skipWarn, logger, }: {
    engine: EngineReportingOptions<any> | boolean | undefined;
    skipWarn?: boolean;
    logger?: Logger;
}): string;
export declare function getEngineGraphVariant(engine: EngineReportingOptions<any> | boolean | undefined, logger?: Logger): string | undefined;
export interface EngineReportingOptions<TContext> {
    apiKey?: string;
    calculateSignature?: (ast: DocumentNode, operationName: string) => string;
    reportIntervalMs?: number;
    maxUncompressedReportSize?: number;
    endpointUrl?: string;
    tracesEndpointUrl?: string;
    debugPrintReports?: boolean;
    requestAgent?: RequestAgent | false;
    maxAttempts?: number;
    minimumRetryDelayMs?: number;
    reportErrorFunction?: (err: Error) => void;
    sendVariableValues?: VariableValueOptions;
    privateVariables?: Array<String> | boolean;
    sendHeaders?: SendValuesBaseOptions;
    privateHeaders?: Array<String> | boolean;
    handleSignals?: boolean;
    sendReportsImmediately?: boolean;
    maskErrorDetails?: boolean;
    rewriteError?: (err: GraphQLError) => GraphQLError | null;
    schemaTag?: string;
    graphVariant?: string;
    generateClientInfo?: GenerateClientInfo<TContext>;
    experimental_schemaReporting?: boolean;
    experimental_overrideReportedSchema?: string;
    experimental_schemaReportingInitialDelayMaxMs?: number;
    schemaReportingUrl?: string;
    logger?: Logger;
}
export interface AddTraceArgs {
    trace: Trace;
    operationName: string;
    queryHash: string;
    executableSchemaId: string;
    source?: string;
    document?: DocumentNode;
    logger: Logger;
}
export declare class EngineReportingAgent<TContext = any> {
    private readonly options;
    private readonly apiKey;
    private readonly logger;
    private readonly graphVariant;
    private readonly reportDataByExecutableSchemaId;
    private reportTimer;
    private readonly sendReportsImmediately?;
    private stopped;
    private signatureCache;
    private signalHandlers;
    private currentSchemaReporter?;
    private readonly bootId;
    private lastSeenExecutableSchemaToId?;
    private readonly tracesEndpointUrl;
    private readonly schemaReport;
    constructor(options?: EngineReportingOptions<TContext>);
    private executableSchemaIdGenerator;
    newPlugin(): ApolloServerPlugin<TContext>;
    private getReportData;
    addTrace({ trace, queryHash, document, operationName, source, executableSchemaId, logger, }: AddTraceArgs): Promise<void>;
    sendAllReports(): Promise<void>;
    sendReport(executableSchemaId: string): Promise<void>;
    startSchemaReporting({ executableSchemaId, executableSchema, }: {
        executableSchemaId: string;
        executableSchema: string;
    }): void;
    stop(): void;
    private getTraceSignature;
    private sendAllReportsAndReportErrors;
    private sendReportAndReportErrors;
}
export declare function signatureCacheKey(queryHash: string, operationName: string): string;
export declare function handleLegacyOptions(options: EngineReportingOptions<any>): void;
export declare function computeExecutableSchemaId(schema: string | GraphQLSchema): string;
export {};
//# sourceMappingURL=agent.d.ts.map