/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * 
 * @format
 */
// flowlint ambiguous-object-type:error
'use strict';

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _asyncToGenerator = require("@babel/runtime/helpers/asyncToGenerator");

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2["default"])(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var CodeMarker = require('../util/CodeMarker');

var createPrintRequireModuleDependency = require('./createPrintRequireModuleDependency');

var dedupeJSONStringify = require('../util/dedupeJSONStringify');

var invariant = require("fbjs/lib/invariant");

var md5 = require('../util/md5');

var _require = require('relay-runtime'),
    RelayConcreteNode = _require.RelayConcreteNode;

function getConcreteType(node) {
  switch (node.kind) {
    case RelayConcreteNode.FRAGMENT:
      return 'ReaderFragment';

    case RelayConcreteNode.REQUEST:
      return 'ConcreteRequest';

    case RelayConcreteNode.SPLIT_OPERATION:
      return 'NormalizationSplitOperation';

    case RelayConcreteNode.INLINE_DATA_FRAGMENT:
      return 'ReaderInlineDataFragment';

    default:
      node;
      !false ? process.env.NODE_ENV !== "production" ? invariant(false, 'Unexpected GeneratedNode kind: `%s`.', node.kind) : invariant(false) : void 0;
  }
}

function writeRelayGeneratedFile(schema, codegenDir, definition, _generatedNode, formatModule, typeText, _persistQuery, sourceHash, extension) {
  var printModuleDependency = arguments.length > 9 && arguments[9] !== undefined ? arguments[9] : createPrintRequireModuleDependency(extension);
  var shouldRepersist = arguments.length > 10 ? arguments[10] : undefined;
  var writeQueryParameters = arguments.length > 11 ? arguments[11] : undefined;
  var languagePlugin = arguments.length > 12 ? arguments[12] : undefined;
  var generatedNode = _generatedNode; // Copy to const so Flow can refine.

  var persistQuery = _persistQuery;
  var operationName = generatedNode.kind === 'Request' ? generatedNode.params.name : generatedNode.name;
  var moduleName = (languagePlugin === null || languagePlugin === void 0 ? void 0 : languagePlugin.getModuleName) ? languagePlugin.getModuleName(operationName) : operationName + '.graphql';
  var filename = moduleName + '.' + extension;
  var queryParametersFilename = generatedNode.kind === 'Request' ? "".concat(generatedNode.params.name, "$Parameters.").concat(extension) : null;
  var typeName = getConcreteType(generatedNode);
  var docText;

  if (generatedNode.kind === RelayConcreteNode.REQUEST) {
    docText = generatedNode.params.text;
  } // Use `Promise.resolve` to work around a Babel 7.8/7.9 issue.


  return Promise.resolve().then( /*#__PURE__*/_asyncToGenerator(function* () {
    var hash = null;

    if (generatedNode.kind === RelayConcreteNode.REQUEST && persistQuery) {
      var _text = generatedNode.params.text;
      !(_text != null) ? process.env.NODE_ENV !== "production" ? invariant(false, 'writeRelayGeneratedFile: Expected `text` in order to persist query') : invariant(false) : void 0;
      hash = md5(_text);
      var id = null;

      if (!shouldRepersist) {
        // Unless we `shouldRepersist` the query, check if the @relayHash matches
        // the operation text of the current text and re-use the persisted
        // operation id.
        var oldContent = codegenDir.read(filename);
        var oldHash = extractHash(oldContent);
        var oldRequestID = extractRelayRequestID(oldContent);

        if (hash === oldHash && oldRequestID != null) {
          id = oldRequestID;
        }
      }

      if (id == null) {
        id = yield persistQuery(_text);
      }

      generatedNode = _objectSpread({}, generatedNode, {
        params: {
          id: id,
          metadata: generatedNode.params.metadata,
          name: generatedNode.params.name,
          operationKind: generatedNode.params.operationKind,
          text: null
        }
      });
    }

    var moduleText = formatModule({
      moduleName: moduleName,
      documentType: typeName,
      definition: definition,
      kind: generatedNode.kind,
      docText: docText,
      typeText: typeText,
      hash: hash != null ? "@relayHash ".concat(hash) : null,
      concreteText: CodeMarker.postProcess(dedupeJSONStringify(generatedNode), printModuleDependency),
      sourceHash: sourceHash,
      node: generatedNode,
      schema: schema
    });
    codegenDir.writeFile(filename, moduleText, shouldRepersist);

    if (writeQueryParameters && queryParametersFilename != null && generatedNode.kind === RelayConcreteNode.REQUEST && generatedNode.params.operationKind === 'query') {
      writeQueryParameters(codegenDir, queryParametersFilename, moduleName, generatedNode.params);
    }

    return generatedNode;
  }));
}

function extractHash(text) {
  if (text == null || text.length === 0) {
    return null;
  }

  if (/<<<<<|>>>>>/.test(text)) {
    // looks like a merge conflict
    return null;
  }

  var match = text.match(/@relayHash (\w{32})\b/m);
  return match && match[1];
}

function extractRelayRequestID(text) {
  if (text == null || text.length === 0) {
    return null;
  }

  if (/<<<<<|>>>>>/.test(text)) {
    // looks like a merge conflict
    return null;
  }

  var match = text.match(/@relayRequestID (.+)/);
  return match ? match[1] : null;
}

module.exports = writeRelayGeneratedFile;