import { GraphQLSchema } from 'graphql';
import { Transform, IFieldResolver, IResolvers, Request, FieldNodeMappers, ExecutionResult } from '@graphql-tools/utils';
import { ObjectValueTransformerMap, ErrorsTransformer } from '../types';
export default class ExtendSchema implements Transform {
    private readonly typeDefs;
    private readonly resolvers;
    private readonly defaultFieldResolver;
    private readonly transformer;
    constructor({ typeDefs, resolvers, defaultFieldResolver, fieldNodeTransformerMap, objectValueTransformerMap, errorsTransformer, }: {
        typeDefs?: string;
        resolvers?: IResolvers;
        defaultFieldResolver?: IFieldResolver<any, any>;
        fieldNodeTransformerMap?: FieldNodeMappers;
        objectValueTransformerMap?: ObjectValueTransformerMap;
        errorsTransformer?: ErrorsTransformer;
    });
    transformSchema(schema: GraphQLSchema): GraphQLSchema;
    transformRequest(originalRequest: Request, delegationContext?: Record<string, any>, transformationContext?: Record<string, any>): Request;
    transformResult(originalResult: ExecutionResult, delegationContext?: Record<string, any>, transformationContext?: Record<string, any>): ExecutionResult;
}
