import { GraphQLSchema, GraphQLError } from 'graphql';
import { Request, ExecutionResult } from './Interfaces';
export declare type ValueVisitor = (value: any) => any;
export declare type ObjectValueVisitor = {
    __enter?: ValueVisitor;
    __leave?: ValueVisitor;
} & Record<string, ValueVisitor>;
export declare type ResultVisitorMap = Record<string, ValueVisitor | ObjectValueVisitor>;
export declare type ErrorVisitor = (error: GraphQLError, pathIndex: number) => GraphQLError;
export declare type ErrorVisitorMap = Record<string, Record<string, ErrorVisitor>>;
export declare function visitData(data: any, enter?: ValueVisitor, leave?: ValueVisitor): any;
export declare function visitErrors(errors: ReadonlyArray<GraphQLError>, visitor: (error: GraphQLError) => GraphQLError): Array<GraphQLError>;
export declare function visitResult(result: ExecutionResult, request: Request, schema: GraphQLSchema, resultVisitorMap?: ResultVisitorMap, errorVisitorMap?: ErrorVisitorMap): any;
