import { __assign, __spread, __read, __awaiter, __generator, __values } from 'tslib';
import { Kind, typeFromAST, TypeInfo, visit, visitWithTypeInfo, print, getNamedType, isAbstractType, isInterfaceType, isObjectType, TypeNameMetaFieldDef, getNullableType, isLeafType, isCompositeType, isListType, getOperationAST, isSchema, execute, subscribe, validate, defaultFieldResolver, parse } from 'graphql';
import isPromise from 'is-promise';
import { applySchemaTransforms, serializeInputValue, updateArgument, collectFields, implementsAbstractType, relocatedError, getErrorsByPathSegment, mergeDeep, ERROR_SYMBOL, typesContainSelectionSet, setErrors, slicedError, getResponseKeyFromInfo, mapAsyncIterator, getErrors, concatInlineFragments } from '@graphql-tools/utils/es5';
import AggregateError from '@ardatan/aggregate-error';
import DataLoader from 'dataloader';

var OBJECT_SUBSCHEMA_SYMBOL = Symbol('initialSubschema');
var FIELD_SUBSCHEMA_MAP_SYMBOL = Symbol('subschemaMap');

function getSubschema(result, responseKey) {
    var subschema = result[FIELD_SUBSCHEMA_MAP_SYMBOL] && result[FIELD_SUBSCHEMA_MAP_SYMBOL][responseKey];
    return subschema || result[OBJECT_SUBSCHEMA_SYMBOL];
}
function setObjectSubschema(result, subschema) {
    result[OBJECT_SUBSCHEMA_SYMBOL] = subschema;
}
function isSubschemaConfig(value) {
    return Boolean(value.schema && value.permutations === undefined);
}
function isSubschema(value) {
    return Boolean(value.transformedSchema);
}
var Subschema = /** @class */ (function () {
    function Subschema(config) {
        var _a;
        this.schema = config.schema;
        this.executor = config.executor;
        this.subscriber = config.subscriber;
        this.createProxyingResolver = config.createProxyingResolver;
        this.transforms = (_a = config.transforms) !== null && _a !== void 0 ? _a : [];
        this.merge = config.merge;
        this.transformedSchema = applySchemaTransforms(this.schema, this.transforms);
    }
    return Subschema;
}());

function getDelegatingOperation(parentType, schema) {
    if (parentType === schema.getMutationType()) {
        return 'mutation';
    }
    else if (parentType === schema.getSubscriptionType()) {
        return 'subscription';
    }
    return 'query';
}
function createRequestFromInfo(_a) {
    var info = _a.info, operationName = _a.operationName, _b = _a.operation, operation = _b === void 0 ? getDelegatingOperation(info.parentType, info.schema) : _b, _c = _a.fieldName, fieldName = _c === void 0 ? info.fieldName : _c, selectionSet = _a.selectionSet, _d = _a.fieldNodes, fieldNodes = _d === void 0 ? info.fieldNodes : _d;
    return createRequest({
        sourceSchema: info.schema,
        sourceParentType: info.parentType,
        sourceFieldName: info.fieldName,
        fragments: info.fragments,
        variableDefinitions: info.operation.variableDefinitions,
        variableValues: info.variableValues,
        targetOperationName: operationName,
        targetOperation: operation,
        targetFieldName: fieldName,
        selectionSet: selectionSet,
        fieldNodes: fieldNodes,
    });
}
function createRequest(_a) {
    var _b;
    var sourceSchema = _a.sourceSchema, sourceParentType = _a.sourceParentType, sourceFieldName = _a.sourceFieldName, fragments = _a.fragments, variableDefinitions = _a.variableDefinitions, variableValues = _a.variableValues, targetOperationName = _a.targetOperationName, targetOperation = _a.targetOperation, targetFieldName = _a.targetFieldName, selectionSet = _a.selectionSet, fieldNodes = _a.fieldNodes;
    var newSelectionSet;
    var argumentNodeMap;
    if (selectionSet != null) {
        newSelectionSet = selectionSet;
        argumentNodeMap = Object.create(null);
    }
    else {
        var selections = fieldNodes.reduce(function (acc, fieldNode) { return (fieldNode.selectionSet != null ? acc.concat(fieldNode.selectionSet.selections) : acc); }, []);
        newSelectionSet = selections.length
            ? {
                kind: Kind.SELECTION_SET,
                selections: selections,
            }
            : undefined;
        argumentNodeMap = {};
        var args = (_b = fieldNodes[0]) === null || _b === void 0 ? void 0 : _b.arguments;
        if (args) {
            argumentNodeMap = args.reduce(function (prev, curr) {
                var _a;
                return (__assign(__assign({}, prev), (_a = {}, _a[curr.name.value] = curr, _a)));
            }, argumentNodeMap);
        }
    }
    var newVariables = Object.create(null);
    var variableDefinitionMap = Object.create(null);
    if (sourceSchema != null && variableDefinitions != null) {
        variableDefinitions.forEach(function (def) {
            var varName = def.variable.name.value;
            variableDefinitionMap[varName] = def;
            var varType = typeFromAST(sourceSchema, def.type);
            var serializedValue = serializeInputValue(varType, variableValues[varName]);
            if (serializedValue !== undefined) {
                newVariables[varName] = serializedValue;
            }
        });
    }
    if (sourceParentType != null) {
        updateArgumentsWithDefaults(sourceParentType, sourceFieldName, argumentNodeMap, variableDefinitionMap, newVariables);
    }
    var rootfieldNode = {
        kind: Kind.FIELD,
        arguments: Object.keys(argumentNodeMap).map(function (argName) { return argumentNodeMap[argName]; }),
        name: {
            kind: Kind.NAME,
            value: targetFieldName || fieldNodes[0].name.value,
        },
        selectionSet: newSelectionSet,
    };
    var operationName = targetOperationName
        ? {
            kind: Kind.NAME,
            value: targetOperationName,
        }
        : undefined;
    var operationDefinition = {
        kind: Kind.OPERATION_DEFINITION,
        name: operationName,
        operation: targetOperation,
        variableDefinitions: Object.keys(variableDefinitionMap).map(function (varName) { return variableDefinitionMap[varName]; }),
        selectionSet: {
            kind: Kind.SELECTION_SET,
            selections: [rootfieldNode],
        },
    };
    var definitions = [operationDefinition];
    if (fragments != null) {
        definitions = definitions.concat(Object.keys(fragments).map(function (fragmentName) { return fragments[fragmentName]; }));
    }
    var document = {
        kind: Kind.DOCUMENT,
        definitions: definitions,
    };
    return {
        document: document,
        variables: newVariables,
    };
}
function updateArgumentsWithDefaults(sourceParentType, sourceFieldName, argumentNodeMap, variableDefinitionMap, variableValues) {
    var sourceField = sourceParentType.getFields()[sourceFieldName];
    sourceField.args.forEach(function (argument) {
        var argName = argument.name;
        var sourceArgType = argument.type;
        if (argumentNodeMap[argName] === undefined) {
            var defaultValue = argument.defaultValue;
            if (defaultValue !== undefined) {
                updateArgument(argName, sourceArgType, argumentNodeMap, variableDefinitionMap, variableValues, serializeInputValue(sourceArgType, defaultValue));
            }
        }
    });
}

function memoizeInfoAnd2Objects(fn) {
    var cache1;
    function memoized(a1, a2, a3) {
        if (!cache1) {
            cache1 = new WeakMap();
            var cache2_1 = new WeakMap();
            cache1.set(a1.fieldNodes, cache2_1);
            var cache3_1 = new WeakMap();
            cache2_1.set(a2, cache3_1);
            var newValue = fn(a1, a2, a3);
            cache3_1.set(a3, newValue);
            return newValue;
        }
        var cache2 = cache1.get(a1.fieldNodes);
        if (!cache2) {
            cache2 = new WeakMap();
            cache1.set(a1.fieldNodes, cache2);
            var cache3_2 = new WeakMap();
            cache2.set(a2, cache3_2);
            var newValue = fn(a1, a2, a3);
            cache3_2.set(a3, newValue);
            return newValue;
        }
        var cache3 = cache2.get(a2);
        if (!cache3) {
            cache3 = new WeakMap();
            cache2.set(a2, cache3);
            var newValue = fn(a1, a2, a3);
            cache3.set(a3, newValue);
            return newValue;
        }
        var cachedValue = cache3.get(a3);
        if (cachedValue === undefined) {
            var newValue = fn(a1, a2, a3);
            cache3.set(a3, newValue);
            return newValue;
        }
        return cachedValue;
    }
    return memoized;
}
function memoize4(fn) {
    var cache1;
    function memoized(a1, a2, a3, a4) {
        if (!cache1) {
            cache1 = new WeakMap();
            var cache2_2 = new WeakMap();
            cache1.set(a1, cache2_2);
            var cache3_3 = new WeakMap();
            cache2_2.set(a2, cache3_3);
            var cache4_1 = new WeakMap();
            cache3_3.set(a3, cache4_1);
            var newValue = fn(a1, a2, a3, a4);
            cache4_1.set(a4, newValue);
            return newValue;
        }
        var cache2 = cache1.get(a1);
        if (!cache2) {
            cache2 = new WeakMap();
            cache1.set(a1, cache2);
            var cache3_4 = new WeakMap();
            cache2.set(a2, cache3_4);
            var cache4_2 = new WeakMap();
            cache3_4.set(a3, cache4_2);
            var newValue = fn(a1, a2, a3, a4);
            cache4_2.set(a4, newValue);
            return newValue;
        }
        var cache3 = cache2.get(a2);
        if (!cache3) {
            cache3 = new WeakMap();
            cache2.set(a2, cache3);
            var cache4_3 = new WeakMap();
            cache3.set(a3, cache4_3);
            var newValue = fn(a1, a2, a3, a4);
            cache4_3.set(a4, newValue);
            return newValue;
        }
        var cache4 = cache3.get(a3);
        if (!cache4) {
            var cache4_4 = new WeakMap();
            cache3.set(a3, cache4_4);
            var newValue = fn(a1, a2, a3, a4);
            cache4_4.set(a4, newValue);
            return newValue;
        }
        var cachedValue = cache4.get(a4);
        if (cachedValue === undefined) {
            var newValue = fn(a1, a2, a3, a4);
            cache4.set(a4, newValue);
            return newValue;
        }
        return cachedValue;
    }
    return memoized;
}
function memoize3(fn) {
    var cache1;
    function memoized(a1, a2, a3) {
        if (!cache1) {
            cache1 = new WeakMap();
            var cache2_3 = new WeakMap();
            cache1.set(a1, cache2_3);
            var cache3_5 = new WeakMap();
            cache2_3.set(a2, cache3_5);
            var newValue = fn(a1, a2, a3);
            cache3_5.set(a3, newValue);
            return newValue;
        }
        var cache2 = cache1.get(a1);
        if (!cache2) {
            cache2 = new WeakMap();
            cache1.set(a1, cache2);
            var cache3_6 = new WeakMap();
            cache2.set(a2, cache3_6);
            var newValue = fn(a1, a2, a3);
            cache3_6.set(a3, newValue);
            return newValue;
        }
        var cache3 = cache2.get(a2);
        if (!cache3) {
            cache3 = new WeakMap();
            cache2.set(a2, cache3);
            var newValue = fn(a1, a2, a3);
            cache3.set(a3, newValue);
            return newValue;
        }
        var cachedValue = cache3.get(a3);
        if (cachedValue === undefined) {
            var newValue = fn(a1, a2, a3);
            cache3.set(a3, newValue);
            return newValue;
        }
        return cachedValue;
    }
    return memoized;
}
function memoize2(fn) {
    var cache1;
    function memoized(a1, a2) {
        if (!cache1) {
            cache1 = new WeakMap();
            var cache2_4 = new WeakMap();
            cache1.set(a1, cache2_4);
            var newValue = fn(a1, a2);
            cache2_4.set(a2, newValue);
            return newValue;
        }
        var cache2 = cache1.get(a1);
        if (!cache2) {
            cache2 = new WeakMap();
            cache1.set(a1, cache2);
            var newValue = fn(a1, a2);
            cache2.set(a2, newValue);
            return newValue;
        }
        var cachedValue = cache2.get(a2);
        if (cachedValue === undefined) {
            var newValue = fn(a1, a2);
            cache2.set(a2, newValue);
            return newValue;
        }
        return cachedValue;
    }
    return memoized;
}
function memoize2of3(fn) {
    var cache1;
    function memoized(a1, a2, a3) {
        if (!cache1) {
            cache1 = new WeakMap();
            var cache2_5 = new WeakMap();
            cache1.set(a1, cache2_5);
            var newValue = fn(a1, a2, a3);
            cache2_5.set(a2, newValue);
            return newValue;
        }
        var cache2 = cache1.get(a1);
        if (!cache2) {
            cache2 = new WeakMap();
            cache1.set(a1, cache2);
            var newValue = fn(a1, a2, a3);
            cache2.set(a2, newValue);
            return newValue;
        }
        var cachedValue = cache2.get(a2);
        if (cachedValue === undefined) {
            var newValue = fn(a1, a2, a3);
            cache2.set(a2, newValue);
            return newValue;
        }
        return cachedValue;
    }
    return memoized;
}

var VisitSelectionSets = /** @class */ (function () {
    function VisitSelectionSets(schema, initialType, visitor) {
        this.schema = schema;
        this.initialType = initialType;
        this.visitor = visitor;
    }
    VisitSelectionSets.prototype.transformRequest = function (originalRequest) {
        var document = visitSelectionSets(originalRequest, this.schema, this.initialType, this.visitor);
        return __assign(__assign({}, originalRequest), { document: document });
    };
    return VisitSelectionSets;
}());
function visitSelectionSets(request, schema, initialType, visitor) {
    var document = request.document, variables = request.variables;
    var operations = [];
    var fragments = Object.create(null);
    document.definitions.forEach(function (def) {
        if (def.kind === Kind.OPERATION_DEFINITION) {
            operations.push(def);
        }
        else if (def.kind === Kind.FRAGMENT_DEFINITION) {
            fragments[def.name.value] = def;
        }
    });
    var partialExecutionContext = {
        schema: schema,
        variableValues: variables,
        fragments: fragments,
    };
    var typeInfo = new TypeInfo(schema, undefined, initialType);
    var newDefinitions = operations.map(function (operation) {
        var type = operation.operation === 'query'
            ? schema.getQueryType()
            : operation.operation === 'mutation'
                ? schema.getMutationType()
                : schema.getSubscriptionType();
        var fields = collectFields(partialExecutionContext, type, operation.selectionSet, Object.create(null), Object.create(null));
        var newSelections = [];
        Object.keys(fields).forEach(function (responseKey) {
            var fieldNodes = fields[responseKey];
            fieldNodes.forEach(function (fieldNode) {
                var _a;
                var selectionSet = fieldNode.selectionSet;
                if (selectionSet == null) {
                    newSelections.push(fieldNode);
                    return;
                }
                var newSelectionSet = visit(selectionSet, visitWithTypeInfo(typeInfo, (_a = {},
                    _a[Kind.SELECTION_SET] = function (node) { return visitor(node, typeInfo); },
                    _a)));
                if (newSelectionSet === selectionSet) {
                    newSelections.push(fieldNode);
                    return;
                }
                newSelections.push(__assign(__assign({}, fieldNode), { selectionSet: newSelectionSet }));
            });
        });
        return __assign(__assign({}, operation), { selectionSet: {
                kind: Kind.SELECTION_SET,
                selections: newSelections,
            } });
    });
    Object.values(fragments).forEach(function (fragment) {
        var _a;
        newDefinitions.push(visit(fragment, visitWithTypeInfo(typeInfo, (_a = {},
            _a[Kind.SELECTION_SET] = function (node) { return visitor(node, typeInfo); },
            _a))));
    });
    return __assign(__assign({}, document), { definitions: newDefinitions });
}

var AddSelectionSets = /** @class */ (function () {
    function AddSelectionSets(sourceSchema, initialType, selectionSetsByType, selectionSetsByField, dynamicSelectionSetsByField) {
        this.transformer = new VisitSelectionSets(sourceSchema, initialType, function (node, typeInfo) {
            return visitSelectionSet(node, typeInfo, selectionSetsByType, selectionSetsByField, dynamicSelectionSetsByField);
        });
    }
    AddSelectionSets.prototype.transformRequest = function (originalRequest) {
        return this.transformer.transformRequest(originalRequest);
    };
    return AddSelectionSets;
}());
function visitSelectionSet(node, typeInfo, selectionSetsByType, selectionSetsByField, dynamicSelectionSetsByField) {
    var parentType = typeInfo.getParentType();
    var newSelections = new Map();
    if (parentType != null) {
        var parentTypeName_1 = parentType.name;
        addSelectionsToMap(newSelections, node);
        if (parentTypeName_1 in selectionSetsByType) {
            var selectionSet = selectionSetsByType[parentTypeName_1];
            addSelectionsToMap(newSelections, selectionSet);
        }
        if (parentTypeName_1 in selectionSetsByField) {
            node.selections.forEach(function (selection) {
                if (selection.kind === Kind.FIELD) {
                    var name_1 = selection.name.value;
                    var selectionSet = selectionSetsByField[parentTypeName_1][name_1];
                    if (selectionSet != null) {
                        addSelectionsToMap(newSelections, selectionSet);
                    }
                }
            });
        }
        if (parentTypeName_1 in dynamicSelectionSetsByField) {
            node.selections.forEach(function (selection) {
                if (selection.kind === Kind.FIELD) {
                    var name_2 = selection.name.value;
                    var dynamicSelectionSets = dynamicSelectionSetsByField[parentTypeName_1][name_2];
                    if (dynamicSelectionSets != null) {
                        dynamicSelectionSets.forEach(function (selectionSetFn) {
                            var selectionSet = selectionSetFn(selection);
                            if (selectionSet != null) {
                                addSelectionsToMap(newSelections, selectionSet);
                            }
                        });
                    }
                }
            });
        }
        return __assign(__assign({}, node), { selections: Array.from(newSelections.values()) });
    }
}
var addSelectionsToMap = memoize2(function (map, selectionSet) {
    selectionSet.selections.forEach(function (selection) {
        map.set(print(selection), selection);
    });
});

var ExpandAbstractTypes = /** @class */ (function () {
    function ExpandAbstractTypes(sourceSchema, targetSchema) {
        this.targetSchema = targetSchema;
        var _a = extractPossibleTypes(sourceSchema, targetSchema), possibleTypesMap = _a.possibleTypesMap, interfaceExtensionsMap = _a.interfaceExtensionsMap;
        this.possibleTypesMap = possibleTypesMap;
        this.reversePossibleTypesMap = flipMapping(this.possibleTypesMap);
        this.interfaceExtensionsMap = interfaceExtensionsMap;
    }
    ExpandAbstractTypes.prototype.transformRequest = function (originalRequest) {
        var document = expandAbstractTypes(this.targetSchema, this.possibleTypesMap, this.reversePossibleTypesMap, this.interfaceExtensionsMap, originalRequest.document);
        return __assign(__assign({}, originalRequest), { document: document });
    };
    return ExpandAbstractTypes;
}());
function extractPossibleTypes(sourceSchema, targetSchema) {
    var typeMap = sourceSchema.getTypeMap();
    var possibleTypesMap = Object.create(null);
    var interfaceExtensionsMap = Object.create(null);
    Object.keys(typeMap).forEach(function (typeName) {
        var type = typeMap[typeName];
        if (isAbstractType(type)) {
            var targetType = targetSchema.getType(typeName);
            if (isInterfaceType(type) && isInterfaceType(targetType)) {
                var targetTypeFields_1 = targetType.getFields();
                var extensionFields_1 = Object.create(null);
                Object.keys(type.getFields()).forEach(function (fieldName) {
                    if (!targetTypeFields_1[fieldName]) {
                        extensionFields_1[fieldName] = true;
                    }
                });
                if (Object.keys(extensionFields_1).length) {
                    interfaceExtensionsMap[typeName] = extensionFields_1;
                }
            }
            if (!isAbstractType(targetType) || typeName in interfaceExtensionsMap) {
                var implementations = sourceSchema.getPossibleTypes(type);
                possibleTypesMap[typeName] = implementations
                    .filter(function (impl) { return targetSchema.getType(impl.name); })
                    .map(function (impl) { return impl.name; });
            }
        }
    });
    return { possibleTypesMap: possibleTypesMap, interfaceExtensionsMap: interfaceExtensionsMap };
}
function flipMapping(mapping) {
    var result = Object.create(null);
    Object.keys(mapping).forEach(function (typeName) {
        var toTypeNames = mapping[typeName];
        toTypeNames.forEach(function (toTypeName) {
            if (!(toTypeName in result)) {
                result[toTypeName] = [];
            }
            result[toTypeName].push(typeName);
        });
    });
    return result;
}
function expandAbstractTypes(targetSchema, possibleTypesMap, reversePossibleTypesMap, interfaceExtensionsMap, document) {
    var _a;
    var operations = document.definitions.filter(function (def) { return def.kind === Kind.OPERATION_DEFINITION; });
    var fragments = document.definitions.filter(function (def) { return def.kind === Kind.FRAGMENT_DEFINITION; });
    var existingFragmentNames = fragments.map(function (fragment) { return fragment.name.value; });
    var fragmentCounter = 0;
    var generateFragmentName = function (typeName) {
        var fragmentName;
        do {
            fragmentName = "_" + typeName + "_Fragment" + fragmentCounter.toString();
            fragmentCounter++;
        } while (existingFragmentNames.indexOf(fragmentName) !== -1);
        return fragmentName;
    };
    var generateInlineFragment = function (typeName, selectionSet) {
        return {
            kind: Kind.INLINE_FRAGMENT,
            typeCondition: {
                kind: Kind.NAMED_TYPE,
                name: {
                    kind: Kind.NAME,
                    value: typeName,
                },
            },
            selectionSet: selectionSet,
        };
    };
    var newFragments = [];
    var fragmentReplacements = Object.create(null);
    fragments.forEach(function (fragment) {
        newFragments.push(fragment);
        var possibleTypes = possibleTypesMap[fragment.typeCondition.name.value];
        if (possibleTypes != null) {
            fragmentReplacements[fragment.name.value] = [];
            possibleTypes.forEach(function (possibleTypeName) {
                var name = generateFragmentName(possibleTypeName);
                existingFragmentNames.push(name);
                var newFragment = {
                    kind: Kind.FRAGMENT_DEFINITION,
                    name: {
                        kind: Kind.NAME,
                        value: name,
                    },
                    typeCondition: {
                        kind: Kind.NAMED_TYPE,
                        name: {
                            kind: Kind.NAME,
                            value: possibleTypeName,
                        },
                    },
                    selectionSet: fragment.selectionSet,
                };
                newFragments.push(newFragment);
                fragmentReplacements[fragment.name.value].push({
                    fragmentName: name,
                    typeName: possibleTypeName,
                });
            });
        }
    });
    var newDocument = __assign(__assign({}, document), { definitions: __spread(operations, newFragments) });
    var typeInfo = new TypeInfo(targetSchema);
    return visit(newDocument, visitWithTypeInfo(typeInfo, (_a = {},
        _a[Kind.SELECTION_SET] = function (node) {
            var newSelections = node.selections;
            var addedSelections = [];
            var maybeType = typeInfo.getParentType();
            if (maybeType != null) {
                var parentType_1 = getNamedType(maybeType);
                var interfaceExtension_1 = interfaceExtensionsMap[parentType_1.name];
                var interfaceExtensionFields_1 = [];
                node.selections.forEach(function (selection) {
                    if (selection.kind === Kind.INLINE_FRAGMENT) {
                        if (selection.typeCondition != null) {
                            var possibleTypes = possibleTypesMap[selection.typeCondition.name.value];
                            if (possibleTypes != null) {
                                possibleTypes.forEach(function (possibleType) {
                                    var maybePossibleType = targetSchema.getType(possibleType);
                                    if (maybePossibleType != null &&
                                        implementsAbstractType(targetSchema, parentType_1, maybePossibleType)) {
                                        addedSelections.push(generateInlineFragment(possibleType, selection.selectionSet));
                                    }
                                });
                            }
                        }
                    }
                    else if (selection.kind === Kind.FRAGMENT_SPREAD) {
                        var fragmentName = selection.name.value;
                        if (fragmentName in fragmentReplacements) {
                            fragmentReplacements[fragmentName].forEach(function (replacement) {
                                var typeName = replacement.typeName;
                                var maybeReplacementType = targetSchema.getType(typeName);
                                if (maybeReplacementType != null && implementsAbstractType(targetSchema, parentType_1, maybeType)) {
                                    addedSelections.push({
                                        kind: Kind.FRAGMENT_SPREAD,
                                        name: {
                                            kind: Kind.NAME,
                                            value: replacement.fragmentName,
                                        },
                                    });
                                }
                            });
                        }
                    }
                    else if (interfaceExtension_1 != null &&
                        interfaceExtension_1[selection.name.value] &&
                        selection.kind === Kind.FIELD) {
                        interfaceExtensionFields_1.push(selection);
                    }
                });
                if (parentType_1.name in reversePossibleTypesMap) {
                    addedSelections.push({
                        kind: Kind.FIELD,
                        name: {
                            kind: Kind.NAME,
                            value: '__typename',
                        },
                    });
                }
                if (interfaceExtensionFields_1.length) {
                    var possibleTypes = possibleTypesMap[parentType_1.name];
                    if (possibleTypes != null) {
                        possibleTypes.forEach(function (possibleType) {
                            addedSelections.push(generateInlineFragment(possibleType, {
                                kind: Kind.SELECTION_SET,
                                selections: interfaceExtensionFields_1,
                            }));
                        });
                        newSelections = newSelections.filter(function (selection) {
                            return !(selection.kind === Kind.FIELD && interfaceExtension_1[selection.name.value]);
                        });
                    }
                }
            }
            if (addedSelections.length) {
                return __assign(__assign({}, node), { selections: newSelections.concat(addedSelections) });
            }
        },
        _a)));
}

// For motivation, see https://github.com/ardatan/graphql-tools/issues/751
var WrapConcreteTypes = /** @class */ (function () {
    function WrapConcreteTypes(returnType, targetSchema) {
        this.returnType = returnType;
        this.targetSchema = targetSchema;
    }
    WrapConcreteTypes.prototype.transformRequest = function (originalRequest) {
        var document = wrapConcreteTypes(this.returnType, this.targetSchema, originalRequest.document);
        return __assign(__assign({}, originalRequest), { document: document });
    };
    return WrapConcreteTypes;
}());
function wrapConcreteTypes(returnType, targetSchema, document) {
    var _a;
    var namedType = getNamedType(returnType);
    if (!isObjectType(namedType)) {
        return document;
    }
    var queryRootType = targetSchema.getQueryType();
    var mutationRootType = targetSchema.getMutationType();
    var subscriptionRootType = targetSchema.getSubscriptionType();
    var typeInfo = new TypeInfo(targetSchema);
    var newDocument = visit(document, visitWithTypeInfo(typeInfo, (_a = {},
        _a[Kind.FIELD] = function (node) {
            var maybeType = typeInfo.getParentType();
            if (maybeType == null) {
                return false;
            }
            var parentType = getNamedType(maybeType);
            if (parentType !== queryRootType && parentType !== mutationRootType && parentType !== subscriptionRootType) {
                return false;
            }
            if (!isAbstractType(getNamedType(typeInfo.getType()))) {
                return false;
            }
            return __assign(__assign({}, node), { selectionSet: {
                    kind: Kind.SELECTION_SET,
                    selections: [
                        {
                            kind: Kind.INLINE_FRAGMENT,
                            typeCondition: {
                                kind: Kind.NAMED_TYPE,
                                name: {
                                    kind: Kind.NAME,
                                    value: namedType.name,
                                },
                            },
                            selectionSet: node.selectionSet,
                        },
                    ],
                } });
        },
        _a)));
    return newDocument;
}

var FilterToSchema = /** @class */ (function () {
    function FilterToSchema(targetSchema) {
        this.targetSchema = targetSchema;
    }
    FilterToSchema.prototype.transformRequest = function (originalRequest) {
        return __assign(__assign({}, originalRequest), filterToSchema(this.targetSchema, originalRequest.document, originalRequest.variables));
    };
    return FilterToSchema;
}());
function filterToSchema(targetSchema, document, variables) {
    var operations = document.definitions.filter(function (def) { return def.kind === Kind.OPERATION_DEFINITION; });
    var fragments = document.definitions.filter(function (def) { return def.kind === Kind.FRAGMENT_DEFINITION; });
    var usedVariables = [];
    var usedFragments = [];
    var newOperations = [];
    var newFragments = [];
    var validFragments = fragments.filter(function (fragment) {
        var typeName = fragment.typeCondition.name.value;
        return Boolean(targetSchema.getType(typeName));
    });
    var validFragmentsWithType = validFragments.reduce(function (prev, fragment) {
        var _a;
        return (__assign(__assign({}, prev), (_a = {}, _a[fragment.name.value] = targetSchema.getType(fragment.typeCondition.name.value), _a)));
    }, {});
    var fragmentSet = Object.create(null);
    operations.forEach(function (operation) {
        var type;
        if (operation.operation === 'subscription') {
            type = targetSchema.getSubscriptionType();
        }
        else if (operation.operation === 'mutation') {
            type = targetSchema.getMutationType();
        }
        else {
            type = targetSchema.getQueryType();
        }
        var _a = filterSelectionSet(targetSchema, type, validFragmentsWithType, operation.selectionSet), selectionSet = _a.selectionSet, operationUsedFragments = _a.usedFragments, operationUsedVariables = _a.usedVariables;
        usedFragments = union(usedFragments, operationUsedFragments);
        var _b = collectFragmentVariables(targetSchema, fragmentSet, validFragments, validFragmentsWithType, usedFragments), collectedUsedVariables = _b.usedVariables, collectedNewFragments = _b.newFragments, collectedFragmentSet = _b.fragmentSet;
        var operationOrFragmentVariables = union(operationUsedVariables, collectedUsedVariables);
        usedVariables = union(usedVariables, operationOrFragmentVariables);
        newFragments = collectedNewFragments;
        fragmentSet = collectedFragmentSet;
        var variableDefinitions = operation.variableDefinitions.filter(function (variable) { return operationOrFragmentVariables.indexOf(variable.variable.name.value) !== -1; });
        newOperations.push({
            kind: Kind.OPERATION_DEFINITION,
            operation: operation.operation,
            name: operation.name,
            directives: operation.directives,
            variableDefinitions: variableDefinitions,
            selectionSet: selectionSet,
        });
    });
    var newVariables = usedVariables.reduce(function (acc, variableName) {
        var variableValue = variables[variableName];
        if (variableValue !== undefined) {
            acc[variableName] = variableValue;
        }
        return acc;
    }, {});
    return {
        document: {
            kind: Kind.DOCUMENT,
            definitions: __spread(newOperations, newFragments),
        },
        variables: newVariables,
    };
}
function collectFragmentVariables(targetSchema, fragmentSet, validFragments, validFragmentsWithType, usedFragments) {
    var remainingFragments = usedFragments.slice();
    var usedVariables = [];
    var newFragments = [];
    var _loop_1 = function () {
        var nextFragmentName = remainingFragments.pop();
        var fragment = validFragments.find(function (fr) { return fr.name.value === nextFragmentName; });
        if (fragment != null) {
            var name_1 = nextFragmentName;
            var typeName = fragment.typeCondition.name.value;
            var type = targetSchema.getType(typeName);
            var _a = filterSelectionSet(targetSchema, type, validFragmentsWithType, fragment.selectionSet), selectionSet = _a.selectionSet, fragmentUsedFragments = _a.usedFragments, fragmentUsedVariables = _a.usedVariables;
            remainingFragments = union(remainingFragments, fragmentUsedFragments);
            usedVariables = union(usedVariables, fragmentUsedVariables);
            if (!(name_1 in fragmentSet)) {
                fragmentSet[name_1] = true;
                newFragments.push({
                    kind: Kind.FRAGMENT_DEFINITION,
                    name: {
                        kind: Kind.NAME,
                        value: name_1,
                    },
                    typeCondition: fragment.typeCondition,
                    selectionSet: selectionSet,
                });
            }
        }
    };
    while (remainingFragments.length !== 0) {
        _loop_1();
    }
    return {
        usedVariables: usedVariables,
        newFragments: newFragments,
        fragmentSet: fragmentSet,
    };
}
function filterSelectionSet(schema, type, validFragments, selectionSet) {
    var _a;
    var usedFragments = [];
    var usedVariables = [];
    var typeInfo = new TypeInfo(schema, undefined, type);
    var filteredSelectionSet = visit(selectionSet, visitWithTypeInfo(typeInfo, (_a = {},
        _a[Kind.FIELD] = {
            enter: function (node) {
                var parentType = typeInfo.getParentType();
                if (isObjectType(parentType) || isInterfaceType(parentType)) {
                    var fields = parentType.getFields();
                    var field = node.name.value === '__typename' ? TypeNameMetaFieldDef : fields[node.name.value];
                    if (!field) {
                        return null;
                    }
                    var argNames_1 = (field.args != null ? field.args : []).map(function (arg) { return arg.name; });
                    if (node.arguments != null) {
                        var args = node.arguments.filter(function (arg) { return argNames_1.indexOf(arg.name.value) !== -1; });
                        if (args.length !== node.arguments.length) {
                            return __assign(__assign({}, node), { arguments: args });
                        }
                    }
                }
            },
            leave: function (node) {
                var _a;
                var resolvedType = getNamedType(typeInfo.getType());
                if (isObjectType(resolvedType) || isInterfaceType(resolvedType)) {
                    var selections = node.selectionSet != null ? node.selectionSet.selections : null;
                    if (selections == null || selections.length === 0) {
                        // need to remove any added variables. Is there a better way to do this?
                        visit(node, (_a = {},
                            _a[Kind.VARIABLE] = function (variableNode) {
                                var index = usedVariables.indexOf(variableNode.name.value);
                                if (index !== -1) {
                                    usedVariables.splice(index, 1);
                                }
                            },
                            _a));
                        return null;
                    }
                }
            },
        },
        _a[Kind.FRAGMENT_SPREAD] = function (node) {
            if (node.name.value in validFragments) {
                var parentType = typeInfo.getParentType();
                var innerType = validFragments[node.name.value];
                if (!implementsAbstractType(schema, parentType, innerType)) {
                    return null;
                }
                usedFragments.push(node.name.value);
                return;
            }
            return null;
        },
        _a[Kind.INLINE_FRAGMENT] = {
            enter: function (node) {
                if (node.typeCondition != null) {
                    var parentType = typeInfo.getParentType();
                    var innerType = schema.getType(node.typeCondition.name.value);
                    if (!implementsAbstractType(schema, parentType, innerType)) {
                        return null;
                    }
                }
            },
        },
        _a[Kind.VARIABLE] = function (node) {
            usedVariables.push(node.name.value);
        },
        _a)));
    return {
        selectionSet: filteredSelectionSet,
        usedFragments: usedFragments,
        usedVariables: usedVariables,
    };
}
function union() {
    var arrays = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        arrays[_i] = arguments[_i];
    }
    var cache = Object.create(null);
    var result = [];
    arrays.forEach(function (array) {
        array.forEach(function (item) {
            if (!(item in cache)) {
                cache[item] = true;
                result.push(item);
            }
        });
    });
    return result;
}

var AddFragmentsByField = /** @class */ (function () {
    function AddFragmentsByField(targetSchema, mapping) {
        this.targetSchema = targetSchema;
        this.mapping = mapping;
    }
    AddFragmentsByField.prototype.transformRequest = function (originalRequest) {
        var document = addFragmentsByField(this.targetSchema, originalRequest.document, this.mapping);
        return __assign(__assign({}, originalRequest), { document: document });
    };
    return AddFragmentsByField;
}());
function addFragmentsByField(targetSchema, document, mapping) {
    var _a;
    var typeInfo = new TypeInfo(targetSchema);
    return visit(document, visitWithTypeInfo(typeInfo, (_a = {},
        _a[Kind.SELECTION_SET] = function (node) {
            var parentType = typeInfo.getParentType();
            if (parentType != null) {
                var parentTypeName_1 = parentType.name;
                var selections_1 = node.selections;
                if (parentTypeName_1 in mapping) {
                    node.selections.forEach(function (selection) {
                        if (selection.kind === Kind.FIELD) {
                            var name_1 = selection.name.value;
                            var fragment = mapping[parentTypeName_1][name_1];
                            if (fragment != null) {
                                selections_1 = selections_1.concat(fragment);
                            }
                        }
                    });
                }
                if (selections_1 !== node.selections) {
                    return __assign(__assign({}, node), { selections: selections_1 });
                }
            }
        },
        _a)));
}

var AddTypenameToAbstract = /** @class */ (function () {
    function AddTypenameToAbstract(targetSchema) {
        this.targetSchema = targetSchema;
    }
    AddTypenameToAbstract.prototype.transformRequest = function (originalRequest) {
        var document = addTypenameToAbstract(this.targetSchema, originalRequest.document);
        return __assign(__assign({}, originalRequest), { document: document });
    };
    return AddTypenameToAbstract;
}());
function addTypenameToAbstract(targetSchema, document) {
    var _a;
    var typeInfo = new TypeInfo(targetSchema);
    return visit(document, visitWithTypeInfo(typeInfo, (_a = {},
        _a[Kind.SELECTION_SET] = function (node) {
            var parentType = typeInfo.getParentType();
            var selections = node.selections;
            if (parentType != null && isAbstractType(parentType)) {
                selections = selections.concat({
                    kind: Kind.FIELD,
                    name: {
                        kind: Kind.NAME,
                        value: '__typename',
                    },
                });
            }
            if (selections !== node.selections) {
                return __assign(__assign({}, node), { selections: selections });
            }
        },
        _a)));
}

function handleNull(errors) {
    if (errors.length) {
        if (errors.some(function (error) { return !error.path || error.path.length < 2; })) {
            if (errors.length > 1) {
                var combinedError = new AggregateError(errors);
                return combinedError;
            }
            var error = errors[0];
            return error.originalError || relocatedError(error, null);
        }
        else if (errors.some(function (error) { return typeof error.path[1] === 'string'; })) {
            var childErrors_1 = getErrorsByPathSegment(errors);
            var result_1 = {};
            Object.keys(childErrors_1).forEach(function (pathSegment) {
                result_1[pathSegment] = handleNull(childErrors_1[pathSegment]);
            });
            return result_1;
        }
        var childErrors_2 = getErrorsByPathSegment(errors);
        var result_2 = [];
        Object.keys(childErrors_2).forEach(function (pathSegment) {
            result_2.push(handleNull(childErrors_2[pathSegment]));
        });
        return result_2;
    }
    return null;
}

function mergeProxiedResults(target) {
    var _a;
    var sources = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        sources[_i - 1] = arguments[_i];
    }
    var results = sources.filter(function (source) { return !(source instanceof Error); });
    var fieldSubschemaMap = results.reduce(function (acc, source) {
        var subschema = source[OBJECT_SUBSCHEMA_SYMBOL];
        Object.keys(source).forEach(function (key) {
            acc[key] = subschema;
        });
        return acc;
    }, {});
    var result = results.reduce(mergeDeep, target);
    result[FIELD_SUBSCHEMA_MAP_SYMBOL] = target[FIELD_SUBSCHEMA_MAP_SYMBOL]
        ? Object.assign({}, target[FIELD_SUBSCHEMA_MAP_SYMBOL], fieldSubschemaMap)
        : fieldSubschemaMap;
    var errors = sources.map(function (source) { return (source instanceof Error ? source : source[ERROR_SYMBOL]); });
    result[ERROR_SYMBOL] = (_a = target[ERROR_SYMBOL]).concat.apply(_a, __spread(errors));
    return result;
}

var sortSubschemasByProxiability = memoize4(function (mergedTypeInfo, sourceSubschemaOrSourceSubschemas, targetSubschemas, fieldNodes) {
    // 1.  calculate if possible to delegate to given subschema
    var proxiableSubschemas = [];
    var nonProxiableSubschemas = [];
    targetSubschemas.forEach(function (t) {
        var selectionSet = mergedTypeInfo.selectionSets.get(t);
        var fieldSelectionSets = mergedTypeInfo.fieldSelectionSets.get(t);
        if (selectionSet != null &&
            !subschemaTypesContainSelectionSet(mergedTypeInfo, sourceSubschemaOrSourceSubschemas, selectionSet)) {
            nonProxiableSubschemas.push(t);
        }
        else {
            if (fieldSelectionSets == null ||
                fieldNodes.every(function (fieldNode) {
                    var fieldName = fieldNode.name.value;
                    var fieldSelectionSet = fieldSelectionSets[fieldName];
                    return (fieldSelectionSet == null ||
                        subschemaTypesContainSelectionSet(mergedTypeInfo, sourceSubschemaOrSourceSubschemas, fieldSelectionSet));
                })) {
                proxiableSubschemas.push(t);
            }
            else {
                nonProxiableSubschemas.push(t);
            }
        }
    });
    return {
        proxiableSubschemas: proxiableSubschemas,
        nonProxiableSubschemas: nonProxiableSubschemas,
    };
});
var buildDelegationPlan = memoize3(function (mergedTypeInfo, fieldNodes, proxiableSubschemas) {
    var uniqueFields = mergedTypeInfo.uniqueFields, nonUniqueFields = mergedTypeInfo.nonUniqueFields;
    var unproxiableFieldNodes = [];
    // 2. for each selection:
    var delegationMap = new Map();
    fieldNodes.forEach(function (fieldNode) {
        if (fieldNode.name.value === '__typename') {
            return;
        }
        // 2a. use uniqueFields map to assign fields to subschema if one of possible subschemas
        var uniqueSubschema = uniqueFields[fieldNode.name.value];
        if (uniqueSubschema != null) {
            if (!proxiableSubschemas.includes(uniqueSubschema)) {
                unproxiableFieldNodes.push(fieldNode);
                return;
            }
            var existingSubschema_1 = delegationMap.get(uniqueSubschema);
            if (existingSubschema_1 != null) {
                existingSubschema_1.push(fieldNode);
            }
            else {
                delegationMap.set(uniqueSubschema, [fieldNode]);
            }
            return;
        }
        // 2b. use nonUniqueFields to assign to a possible subschema,
        //     preferring one of the subschemas already targets of delegation
        var nonUniqueSubschemas = nonUniqueFields[fieldNode.name.value];
        if (nonUniqueSubschemas == null) {
            unproxiableFieldNodes.push(fieldNode);
            return;
        }
        nonUniqueSubschemas = nonUniqueSubschemas.filter(function (s) { return proxiableSubschemas.includes(s); });
        if (nonUniqueSubschemas == null) {
            unproxiableFieldNodes.push(fieldNode);
            return;
        }
        var subschemas = Array.from(delegationMap.keys());
        var existingSubschema = nonUniqueSubschemas.find(function (s) { return subschemas.includes(s); });
        if (existingSubschema != null) {
            delegationMap.get(existingSubschema).push(fieldNode);
        }
        else {
            delegationMap.set(nonUniqueSubschemas[0], [fieldNode]);
        }
    });
    var finalDelegationMap = new Map();
    delegationMap.forEach(function (selections, subschema) {
        finalDelegationMap.set(subschema, {
            kind: Kind.SELECTION_SET,
            selections: selections,
        });
    });
    return {
        delegationMap: finalDelegationMap,
        unproxiableFieldNodes: unproxiableFieldNodes,
    };
});
var combineSubschemas = memoize2(function (subschemaOrSubschemas, additionalSubschemas) {
    return Array.isArray(subschemaOrSubschemas)
        ? subschemaOrSubschemas.concat(additionalSubschemas)
        : [subschemaOrSubschemas].concat(additionalSubschemas);
});
function mergeFields(mergedTypeInfo, typeName, object, fieldNodes, sourceSubschemaOrSourceSubschemas, targetSubschemas, context, info) {
    if (!fieldNodes.length) {
        return object;
    }
    var _a = sortSubschemasByProxiability(mergedTypeInfo, sourceSubschemaOrSourceSubschemas, targetSubschemas, fieldNodes), proxiableSubschemas = _a.proxiableSubschemas, nonProxiableSubschemas = _a.nonProxiableSubschemas;
    var _b = buildDelegationPlan(mergedTypeInfo, fieldNodes, proxiableSubschemas), delegationMap = _b.delegationMap, unproxiableFieldNodes = _b.unproxiableFieldNodes;
    if (!delegationMap.size) {
        return object;
    }
    var containsPromises = false;
    var maybePromises = [];
    delegationMap.forEach(function (selectionSet, s) {
        var maybePromise = s.merge[typeName].resolve(object, context, info, s, selectionSet);
        maybePromises.push(maybePromise);
        if (!containsPromises && isPromise(maybePromise)) {
            containsPromises = true;
        }
    });
    return containsPromises
        ? Promise.all(maybePromises).then(function (results) {
            return mergeFields(mergedTypeInfo, typeName, mergeProxiedResults.apply(void 0, __spread([object], results)), unproxiableFieldNodes, combineSubschemas(sourceSubschemaOrSourceSubschemas, proxiableSubschemas), nonProxiableSubschemas, context, info);
        })
        : mergeFields(mergedTypeInfo, typeName, mergeProxiedResults.apply(void 0, __spread([object], maybePromises)), unproxiableFieldNodes, combineSubschemas(sourceSubschemaOrSourceSubschemas, proxiableSubschemas), nonProxiableSubschemas, context, info);
}
var subschemaTypesContainSelectionSet = memoize3(function (mergedTypeInfo, sourceSubschemaOrSourceSubschemas, selectionSet) {
    if (Array.isArray(sourceSubschemaOrSourceSubschemas)) {
        return typesContainSelectionSet(sourceSubschemaOrSourceSubschemas.map(function (sourceSubschema) { return sourceSubschema.schema.getType(mergedTypeInfo.typeName); }), selectionSet);
    }
    return typesContainSelectionSet([sourceSubschemaOrSourceSubschemas.schema.getType(mergedTypeInfo.typeName)], selectionSet);
});

function collectSubFields(info, typeName) {
    var subFieldNodes = Object.create(null);
    var visitedFragmentNames = Object.create(null);
    var type = info.schema.getType(typeName);
    var partialExecutionContext = {
        schema: info.schema,
        variableValues: info.variableValues,
        fragments: info.fragments,
    };
    info.fieldNodes.forEach(function (fieldNode) {
        subFieldNodes = collectFields(partialExecutionContext, type, fieldNode.selectionSet, subFieldNodes, visitedFragmentNames);
    });
    var stitchingInfo = info.schema.extensions.stitchingInfo;
    var selectionSetsByField = stitchingInfo.selectionSetsByField;
    Object.keys(subFieldNodes).forEach(function (responseName) {
        var _a;
        var fieldName = subFieldNodes[responseName][0].name.value;
        var fieldSelectionSet = (_a = selectionSetsByField === null || selectionSetsByField === void 0 ? void 0 : selectionSetsByField[typeName]) === null || _a === void 0 ? void 0 : _a[fieldName];
        if (fieldSelectionSet != null) {
            subFieldNodes = collectFields(partialExecutionContext, type, fieldSelectionSet, subFieldNodes, visitedFragmentNames);
        }
    });
    return subFieldNodes;
}
var getFieldsNotInSubschema = memoizeInfoAnd2Objects(function (info, subschema, mergedTypeInfo) {
    var typeMap = isSubschemaConfig(subschema) ? mergedTypeInfo.typeMaps.get(subschema) : subschema.getTypeMap();
    var typeName = mergedTypeInfo.typeName;
    var fields = typeMap[typeName].getFields();
    var subFieldNodes = collectSubFields(info, typeName);
    var fieldsNotInSchema = [];
    Object.keys(subFieldNodes).forEach(function (responseName) {
        var fieldName = subFieldNodes[responseName][0].name.value;
        if (!(fieldName in fields)) {
            fieldsNotInSchema = fieldsNotInSchema.concat(subFieldNodes[responseName]);
        }
    });
    return fieldsNotInSchema;
});

function handleObject(type, object, errors, subschema, context, info, skipTypeMerging) {
    var _a;
    var stitchingInfo = (_a = info === null || info === void 0 ? void 0 : info.schema.extensions) === null || _a === void 0 ? void 0 : _a.stitchingInfo;
    setErrors(object, errors.map(function (error) { return slicedError(error); }));
    setObjectSubschema(object, subschema);
    if (skipTypeMerging || !stitchingInfo) {
        return object;
    }
    var typeName = isAbstractType(type) ? info.schema.getTypeMap()[object.__typename].name : type.name;
    var mergedTypeInfo = stitchingInfo.mergedTypes[typeName];
    var targetSubschemas;
    if (mergedTypeInfo != null) {
        targetSubschemas = mergedTypeInfo.targetSubschemas.get(subschema);
    }
    if (!targetSubschemas) {
        return object;
    }
    var fieldNodes = getFieldsNotInSubschema(info, subschema, mergedTypeInfo);
    return mergeFields(mergedTypeInfo, typeName, object, fieldNodes, subschema, targetSubschemas, context, info);
}

function handleList(type, list, errors, subschema, context, info, skipTypeMerging) {
    var childErrors = getErrorsByPathSegment(errors);
    return list.map(function (listMember, index) {
        return handleListMember(getNullableType(type.ofType), listMember, index in childErrors ? childErrors[index] : [], subschema, context, info, skipTypeMerging);
    });
}
function handleListMember(type, listMember, errors, subschema, context, info, skipTypeMerging) {
    if (listMember == null) {
        return handleNull(errors);
    }
    if (isLeafType(type)) {
        return type.parseValue(listMember);
    }
    else if (isCompositeType(type)) {
        return handleObject(type, listMember, errors, subschema, context, info, skipTypeMerging);
    }
    else if (isListType(type)) {
        return handleList(type, listMember, errors, subschema, context, info, skipTypeMerging);
    }
}

function handleResult(result, errors, subschema, context, info, returnType, skipTypeMerging) {
    if (returnType === void 0) { returnType = info.returnType; }
    var type = getNullableType(returnType);
    if (result == null) {
        return handleNull(errors);
    }
    if (isLeafType(type)) {
        return type.parseValue(result);
    }
    else if (isCompositeType(type)) {
        return handleObject(type, result, errors, subschema, context, info, skipTypeMerging);
    }
    else if (isListType(type)) {
        return handleList(type, result, errors, subschema, context, info, skipTypeMerging);
    }
}

var CheckResultAndHandleErrors = /** @class */ (function () {
    function CheckResultAndHandleErrors(info, fieldName, subschema, context, returnType, typeMerge) {
        if (returnType === void 0) { returnType = info.returnType; }
        this.context = context;
        this.info = info;
        this.fieldName = fieldName;
        this.subschema = subschema;
        this.returnType = returnType;
        this.typeMerge = typeMerge;
    }
    CheckResultAndHandleErrors.prototype.transformResult = function (result) {
        return checkResultAndHandleErrors(result, this.context != null ? this.context : {}, this.info, this.fieldName, this.subschema, this.returnType, this.typeMerge);
    };
    return CheckResultAndHandleErrors;
}());
function checkResultAndHandleErrors(result, context, info, responseKey, subschema, returnType, skipTypeMerging) {
    if (responseKey === void 0) { responseKey = getResponseKeyFromInfo(info); }
    if (returnType === void 0) { returnType = info.returnType; }
    var errors = result.errors != null ? result.errors : [];
    var data = result.data != null ? result.data[responseKey] : undefined;
    return handleResult(data, errors, subschema, context, info, returnType, skipTypeMerging);
}

var AddArgumentsAsVariables = /** @class */ (function () {
    function AddArgumentsAsVariables(targetSchema, args) {
        this.targetSchema = targetSchema;
        this.args = Object.entries(args).reduce(function (prev, _a) {
            var _b;
            var _c = __read(_a, 2), key = _c[0], val = _c[1];
            return (__assign(__assign({}, prev), (_b = {}, _b[key] = val, _b)));
        }, {});
    }
    AddArgumentsAsVariables.prototype.transformRequest = function (originalRequest) {
        var _a = addVariablesToRootField(this.targetSchema, originalRequest, this.args), document = _a.document, variables = _a.variables;
        return __assign(__assign({}, originalRequest), { document: document,
            variables: variables });
    };
    return AddArgumentsAsVariables;
}());
function addVariablesToRootField(targetSchema, originalRequest, args) {
    var document = originalRequest.document;
    var variableValues = originalRequest.variables;
    var operations = document.definitions.filter(function (def) { return def.kind === Kind.OPERATION_DEFINITION; });
    var fragments = document.definitions.filter(function (def) { return def.kind === Kind.FRAGMENT_DEFINITION; });
    var newOperations = operations.map(function (operation) {
        var variableDefinitionMap = operation.variableDefinitions.reduce(function (prev, def) {
            var _a;
            return (__assign(__assign({}, prev), (_a = {}, _a[def.variable.name.value] = def, _a)));
        }, {});
        var type;
        if (operation.operation === 'subscription') {
            type = targetSchema.getSubscriptionType();
        }
        else if (operation.operation === 'mutation') {
            type = targetSchema.getMutationType();
        }
        else {
            type = targetSchema.getQueryType();
        }
        var newSelectionSet = [];
        operation.selectionSet.selections.forEach(function (selection) {
            if (selection.kind === Kind.FIELD) {
                var argumentNodes = selection.arguments;
                var argumentNodeMap_1 = argumentNodes.reduce(function (prev, argument) {
                    var _a;
                    return (__assign(__assign({}, prev), (_a = {}, _a[argument.name.value] = argument, _a)));
                }, {});
                var targetField = type.getFields()[selection.name.value];
                // excludes __typename
                if (targetField != null) {
                    updateArguments(targetField, argumentNodeMap_1, variableDefinitionMap, variableValues, args);
                }
                newSelectionSet.push(__assign(__assign({}, selection), { arguments: Object.keys(argumentNodeMap_1).map(function (argName) { return argumentNodeMap_1[argName]; }) }));
            }
            else {
                newSelectionSet.push(selection);
            }
        });
        return __assign(__assign({}, operation), { variableDefinitions: Object.keys(variableDefinitionMap).map(function (varName) { return variableDefinitionMap[varName]; }), selectionSet: {
                kind: Kind.SELECTION_SET,
                selections: newSelectionSet,
            } });
    });
    return {
        document: __assign(__assign({}, document), { definitions: __spread(newOperations, fragments) }),
        variables: variableValues,
    };
}
function updateArguments(targetField, argumentNodeMap, variableDefinitionMap, variableValues, newArgs) {
    targetField.args.forEach(function (argument) {
        var argName = argument.name;
        var argType = argument.type;
        if (argName in newArgs) {
            updateArgument(argName, argType, argumentNodeMap, variableDefinitionMap, variableValues, serializeInputValue(argType, newArgs[argName]));
        }
    });
}

function defaultDelegationBinding(delegationContext) {
    var _a;
    var schemaOrSubschemaConfig = delegationContext.subschema, targetSchema = delegationContext.targetSchema, fieldName = delegationContext.fieldName, args = delegationContext.args, context = delegationContext.context, info = delegationContext.info, returnType = delegationContext.returnType, _b = delegationContext.transforms, transforms = _b === void 0 ? [] : _b, skipTypeMerging = delegationContext.skipTypeMerging;
    var stitchingInfo = (_a = info === null || info === void 0 ? void 0 : info.schema.extensions) === null || _a === void 0 ? void 0 : _a.stitchingInfo;
    var transformedSchema = stitchingInfo === null || stitchingInfo === void 0 ? void 0 : stitchingInfo.transformedSchemas.get(schemaOrSubschemaConfig);
    if (transformedSchema != null) {
        delegationContext.transformedSchema = transformedSchema;
    }
    else {
        transformedSchema = delegationContext.transformedSchema;
    }
    var delegationTransforms = [
        new CheckResultAndHandleErrors(info, fieldName, schemaOrSubschemaConfig, context, returnType, skipTypeMerging),
    ];
    if (stitchingInfo != null) {
        delegationTransforms = delegationTransforms.concat([
            new AddSelectionSets(info.schema, returnType, {}, stitchingInfo.selectionSetsByField, stitchingInfo.dynamicSelectionSetsByField),
            new WrapConcreteTypes(returnType, transformedSchema),
            new ExpandAbstractTypes(info.schema, transformedSchema),
        ]);
    }
    else if (info != null) {
        delegationTransforms = delegationTransforms.concat([
            new WrapConcreteTypes(returnType, transformedSchema),
            new ExpandAbstractTypes(info.schema, transformedSchema),
        ]);
    }
    else {
        delegationTransforms.push(new WrapConcreteTypes(returnType, transformedSchema));
    }
    delegationTransforms = delegationTransforms.concat(transforms.slice().reverse());
    if (stitchingInfo != null) {
        delegationTransforms.push(new AddFragmentsByField(targetSchema, stitchingInfo.fragmentsByField));
    }
    if (args != null) {
        delegationTransforms.push(new AddArgumentsAsVariables(targetSchema, args));
    }
    delegationTransforms = delegationTransforms.concat([
        new FilterToSchema(targetSchema),
        new AddTypenameToAbstract(targetSchema),
    ]);
    return delegationTransforms;
}

var Transformer = /** @class */ (function () {
    function Transformer(context, binding) {
        var _this = this;
        if (binding === void 0) { binding = defaultDelegationBinding; }
        this.transformations = [];
        this.delegationContext = context;
        var delegationTransforms = binding(this.delegationContext);
        delegationTransforms.forEach(function (transform) { return _this.addTransform(transform, {}); });
    }
    Transformer.prototype.addTransform = function (transform, context) {
        if (context === void 0) { context = {}; }
        this.transformations.push({ transform: transform, context: context });
    };
    Transformer.prototype.transformRequest = function (originalRequest) {
        var _this = this;
        return this.transformations.reduce(function (request, transformation) {
            return transformation.transform.transformRequest != null
                ? transformation.transform.transformRequest(request, _this.delegationContext, transformation.context)
                : request;
        }, originalRequest);
    };
    Transformer.prototype.transformResult = function (originalResult) {
        var _this = this;
        return this.transformations.reduceRight(function (result, transformation) {
            return transformation.transform.transformResult != null
                ? transformation.transform.transformResult(result, _this.delegationContext, transformation.context)
                : result;
        }, originalResult);
    };
    return Transformer;
}());

// adapted from https://github.com/gatsbyjs/gatsby/blob/master/packages/gatsby-source-graphql/src/batching/merge-queries.js
function createPrefix(index) {
    return "graphqlTools" + index + "_";
}
function parseKey(prefixedKey) {
    var match = /^graphqlTools([\d]+)_(.*)$/.exec(prefixedKey);
    if (match && match.length === 3 && !isNaN(Number(match[1])) && match[2]) {
        return { index: Number(match[1]), originalKey: match[2] };
    }
    return null;
}

// adapted from https://github.com/gatsbyjs/gatsby/blob/master/packages/gatsby-source-graphql/src/batching/merge-queries.js
/**
 * Merge multiple queries into a single query in such a way that query results
 * can be split and transformed as if they were obtained by running original queries.
 *
 * Merging algorithm involves several transformations:
 *  1. Replace top-level fragment spreads with inline fragments (... on Query {})
 *  2. Add unique aliases to all top-level query fields (including those on inline fragments)
 *  3. Prefix all variable definitions and variable usages
 *  4. Prefix names (and spreads) of fragments
 *
 * i.e transform:
 *   [
 *     `query Foo($id: ID!) { foo, bar(id: $id), ...FooQuery }
 *     fragment FooQuery on Query { baz }`,
 *
 *    `query Bar($id: ID!) { foo: baz, bar(id: $id), ... on Query { baz } }`
 *   ]
 * to:
 *   query (
 *     $graphqlTools1_id: ID!
 *     $graphqlTools2_id: ID!
 *   ) {
 *     graphqlTools1_foo: foo,
 *     graphqlTools1_bar: bar(id: $graphqlTools1_id)
 *     ... on Query {
 *       graphqlTools1__baz: baz
 *     }
 *     graphqlTools1__foo: baz
 *     graphqlTools1__bar: bar(id: $graphqlTools1__id)
 *     ... on Query {
 *       graphqlTools1__baz: baz
 *     }
 *   }
 */
function mergeExecutionParams(execs, extensionsReducer) {
    var mergedVariables = Object.create(null);
    var mergedVariableDefinitions = [];
    var mergedSelections = [];
    var mergedFragmentDefinitions = [];
    var mergedExtensions = Object.create(null);
    var operation;
    execs.forEach(function (executionParams, index) {
        var prefixedExecutionParams = prefixExecutionParams(createPrefix(index), executionParams);
        prefixedExecutionParams.document.definitions.forEach(function (def) {
            var _a;
            if (isOperationDefinition(def)) {
                operation = def.operation;
                mergedSelections.push.apply(mergedSelections, __spread(def.selectionSet.selections));
                mergedVariableDefinitions.push.apply(mergedVariableDefinitions, __spread(((_a = def.variableDefinitions) !== null && _a !== void 0 ? _a : [])));
            }
            if (isFragmentDefinition(def)) {
                mergedFragmentDefinitions.push(def);
            }
        });
        Object.assign(mergedVariables, prefixedExecutionParams.variables);
        mergedExtensions = extensionsReducer(mergedExtensions, executionParams);
    });
    var mergedOperationDefinition = {
        kind: Kind.OPERATION_DEFINITION,
        operation: operation,
        variableDefinitions: mergedVariableDefinitions,
        selectionSet: {
            kind: Kind.SELECTION_SET,
            selections: mergedSelections,
        },
    };
    return {
        document: {
            kind: Kind.DOCUMENT,
            definitions: __spread([mergedOperationDefinition], mergedFragmentDefinitions),
        },
        variables: mergedVariables,
        extensions: mergedExtensions,
        context: execs[0].context,
        info: execs[0].info,
    };
}
function prefixExecutionParams(prefix, executionParams) {
    var _a;
    var document = aliasTopLevelFields(prefix, executionParams.document);
    var variableNames = Object.keys(executionParams.variables);
    if (variableNames.length === 0) {
        return __assign(__assign({}, executionParams), { document: document });
    }
    document = visit(document, (_a = {},
        _a[Kind.VARIABLE] = function (node) { return prefixNodeName(node, prefix); },
        _a[Kind.FRAGMENT_DEFINITION] = function (node) { return prefixNodeName(node, prefix); },
        _a[Kind.FRAGMENT_SPREAD] = function (node) { return prefixNodeName(node, prefix); },
        _a));
    var prefixedVariables = variableNames.reduce(function (acc, name) {
        acc[prefix + name] = executionParams.variables[name];
        return acc;
    }, Object.create(null));
    return {
        document: document,
        variables: prefixedVariables,
    };
}
/**
 * Adds prefixed aliases to top-level fields of the query.
 *
 * @see aliasFieldsInSelection for implementation details
 */
function aliasTopLevelFields(prefix, document) {
    var _a, _b;
    var transformer = (_a = {},
        _a[Kind.OPERATION_DEFINITION] = function (def) {
            var selections = def.selectionSet.selections;
            return __assign(__assign({}, def), { selectionSet: __assign(__assign({}, def.selectionSet), { selections: aliasFieldsInSelection(prefix, selections, document) }) });
        },
        _a);
    return visit(document, transformer, (_b = {}, _b[Kind.DOCUMENT] = ["definitions"], _b));
}
/**
 * Add aliases to fields of the selection, including top-level fields of inline fragments.
 * Fragment spreads are converted to inline fragments and their top-level fields are also aliased.
 *
 * Note that this method is shallow. It adds aliases only to the top-level fields and doesn't
 * descend to field sub-selections.
 *
 * For example, transforms:
 *   {
 *     foo
 *     ... on Query { foo }
 *     ...FragmentWithBarField
 *   }
 * To:
 *   {
 *     graphqlTools1_foo: foo
 *     ... on Query { graphqlTools1_foo: foo }
 *     ... on Query { graphqlTools1_bar: bar }
 *   }
 */
function aliasFieldsInSelection(prefix, selections, document) {
    return selections.map(function (selection) {
        switch (selection.kind) {
            case Kind.INLINE_FRAGMENT:
                return aliasFieldsInInlineFragment(prefix, selection, document);
            case Kind.FRAGMENT_SPREAD: {
                var inlineFragment = inlineFragmentSpread(selection, document);
                return aliasFieldsInInlineFragment(prefix, inlineFragment, document);
            }
            case Kind.FIELD:
            default:
                return aliasField(selection, prefix);
        }
    });
}
/**
 * Add aliases to top-level fields of the inline fragment.
 * Returns new inline fragment node.
 *
 * For Example, transforms:
 *   ... on Query { foo, ... on Query { bar: foo } }
 * To
 *   ... on Query { graphqlTools1_foo: foo, ... on Query { graphqlTools1_bar: foo } }
 */
function aliasFieldsInInlineFragment(prefix, fragment, document) {
    var selections = fragment.selectionSet.selections;
    return __assign(__assign({}, fragment), { selectionSet: __assign(__assign({}, fragment.selectionSet), { selections: aliasFieldsInSelection(prefix, selections, document) }) });
}
/**
 * Replaces fragment spread with inline fragment
 *
 * Example:
 *   query { ...Spread }
 *   fragment Spread on Query { bar }
 *
 * Transforms to:
 *   query { ... on Query { bar } }
 */
function inlineFragmentSpread(spread, document) {
    var fragment = document.definitions.find(function (def) { return isFragmentDefinition(def) && def.name.value === spread.name.value; });
    if (!fragment) {
        throw new Error("Fragment " + spread.name.value + " does not exist");
    }
    var typeCondition = fragment.typeCondition, selectionSet = fragment.selectionSet;
    return {
        kind: Kind.INLINE_FRAGMENT,
        typeCondition: typeCondition,
        selectionSet: selectionSet,
        directives: spread.directives,
    };
}
function prefixNodeName(namedNode, prefix) {
    return __assign(__assign({}, namedNode), { name: __assign(__assign({}, namedNode.name), { value: prefix + namedNode.name.value }) });
}
/**
 * Returns a new FieldNode with prefixed alias
 *
 * Example. Given prefix === "graphqlTools1_" transforms:
 *   { foo } -> { graphqlTools1_foo: foo }
 *   { foo: bar } -> { graphqlTools1_foo: bar }
 */
function aliasField(field, aliasPrefix) {
    var aliasNode = field.alias ? field.alias : field.name;
    return __assign(__assign({}, field), { alias: __assign(__assign({}, aliasNode), { value: aliasPrefix + aliasNode.value }) });
}
function isOperationDefinition(def) {
    return def.kind === Kind.OPERATION_DEFINITION;
}
function isFragmentDefinition(def) {
    return def.kind === Kind.FRAGMENT_DEFINITION;
}

// adapted from https://github.com/gatsbyjs/gatsby/blob/master/packages/gatsby-source-graphql/src/batching/merge-queries.js
/**
 * Split and transform result of the query produced by the `merge` function
 */
function splitResult(mergedResult, numResults) {
    var splitResults = [];
    for (var i = 0; i < numResults; i++) {
        splitResults.push({});
    }
    var data = mergedResult.data;
    if (data) {
        Object.keys(data).forEach(function (prefixedKey) {
            var _a;
            var _b = parseKey(prefixedKey), index = _b.index, originalKey = _b.originalKey;
            if (!splitResults[index].data) {
                splitResults[index].data = (_a = {}, _a[originalKey] = data[prefixedKey], _a);
            }
            else {
                splitResults[index].data[originalKey] = data[prefixedKey];
            }
        });
    }
    var errors = mergedResult.errors;
    if (errors) {
        var newErrors_1 = Object.create(null);
        errors.forEach(function (error) {
            if (error.path) {
                var parsedKey = parseKey(error.path[0]);
                if (parsedKey) {
                    var index = parsedKey.index, originalKey = parsedKey.originalKey;
                    var newError = relocatedError(error, __spread([originalKey], error.path.slice(1)));
                    if (!newErrors_1[index]) {
                        newErrors_1[index] = [newError];
                    }
                    else {
                        newErrors_1[index].push(newError);
                    }
                    return;
                }
            }
            splitResults.forEach(function (_splitResult, index) {
                if (!newErrors_1[index]) {
                    newErrors_1[index] = [error];
                }
                else {
                    newErrors_1[index].push(error);
                }
            });
        });
        Object.keys(newErrors_1).forEach(function (index) {
            splitResults[index].errors = newErrors_1[index];
        });
    }
    return splitResults;
}

var getBatchingExecutor = memoize2of3(function (_context, endpoint, executor) {
    var _a, _b, _c;
    var loader = new DataLoader(createLoadFn(executor !== null && executor !== void 0 ? executor : endpoint.executor, (_b = (_a = endpoint.batchingOptions) === null || _a === void 0 ? void 0 : _a.extensionsReducer) !== null && _b !== void 0 ? _b : defaultExtensionsReducer), (_c = endpoint.batchingOptions) === null || _c === void 0 ? void 0 : _c.dataLoaderOptions);
    return function (executionParams) { return loader.load(executionParams); };
});
function createLoadFn(executor, extensionsReducer) {
    var _this = this;
    return function (execs) { return __awaiter(_this, void 0, void 0, function () {
        var execBatches, index, exec, currentBatch, operationType, currentOperationType, containsPromises, executionResults, results;
        return __generator(this, function (_a) {
            execBatches = [];
            index = 0;
            exec = execs[index];
            currentBatch = [exec];
            execBatches.push(currentBatch);
            operationType = getOperationAST(exec.document, undefined).operation;
            while (++index < execs.length) {
                currentOperationType = getOperationAST(execs[index].document, undefined).operation;
                if (operationType === currentOperationType) {
                    currentBatch.push(execs[index]);
                }
                else {
                    currentBatch = [execs[index]];
                    execBatches.push(currentBatch);
                }
            }
            containsPromises = false;
            executionResults = [];
            execBatches.forEach(function (execBatch) {
                var mergedExecutionParams = mergeExecutionParams(execBatch, extensionsReducer);
                var executionResult = executor(mergedExecutionParams);
                if (isPromise(executionResult)) {
                    containsPromises = true;
                }
                executionResults.push(executionResult);
            });
            if (containsPromises) {
                return [2 /*return*/, Promise.all(executionResults).then(function (resultBatches) {
                        var results = [];
                        resultBatches.forEach(function (resultBatch, index) {
                            results = results.concat(splitResult(resultBatch, execBatches[index].length));
                        });
                        return results;
                    })];
            }
            results = [];
            executionResults.forEach(function (resultBatch, index) {
                results = results.concat(splitResult(resultBatch, execBatches[index].length));
            });
            return [2 /*return*/, results];
        });
    }); };
}
function defaultExtensionsReducer(mergedExtensions, executionParams) {
    var newExtensions = executionParams.extensions;
    if (newExtensions != null) {
        Object.assign(mergedExtensions, newExtensions);
    }
    return mergedExtensions;
}

function delegateToSchema(options) {
    if (isSchema(options)) {
        throw new Error('Passing positional arguments to delegateToSchema is deprecated. ' + 'Please pass named parameters instead.');
    }
    var info = options.info, operationName = options.operationName, _a = options.operation, operation = _a === void 0 ? getDelegatingOperation(info.parentType, info.schema) : _a, _b = options.fieldName, fieldName = _b === void 0 ? info.fieldName : _b, _c = options.returnType, returnType = _c === void 0 ? info.returnType : _c, selectionSet = options.selectionSet, fieldNodes = options.fieldNodes;
    var request = createRequestFromInfo({
        info: info,
        operation: operation,
        fieldName: fieldName,
        selectionSet: selectionSet,
        fieldNodes: fieldNodes,
        operationName: operationName,
    });
    return delegateRequest(__assign(__assign({}, options), { request: request,
        operation: operation,
        fieldName: fieldName,
        returnType: returnType }));
}
function getDelegationReturnType(targetSchema, operation, fieldName) {
    var rootType;
    if (operation === 'query') {
        rootType = targetSchema.getQueryType();
    }
    else if (operation === 'mutation') {
        rootType = targetSchema.getMutationType();
    }
    else {
        rootType = targetSchema.getSubscriptionType();
    }
    return rootType.getFields()[fieldName].type;
}
function delegateRequest(_a) {
    var _b, _c, _d;
    var request = _a.request, subschemaOrSubschemaConfig = _a.schema, rootValue = _a.rootValue, info = _a.info, operation = _a.operation, fieldName = _a.fieldName, args = _a.args, returnType = _a.returnType, context = _a.context, _e = _a.transforms, transforms = _e === void 0 ? [] : _e, transformedSchema = _a.transformedSchema, skipValidation = _a.skipValidation, skipTypeMerging = _a.skipTypeMerging, binding = _a.binding;
    var operationDefinition;
    var targetOperation;
    var targetFieldName;
    if (operation == null) {
        operationDefinition = getOperationAST(request.document, undefined);
        targetOperation = operationDefinition.operation;
    }
    else {
        targetOperation = operation;
    }
    if (fieldName == null) {
        operationDefinition = operationDefinition !== null && operationDefinition !== void 0 ? operationDefinition : getOperationAST(request.document, undefined);
        targetFieldName = operationDefinition.selectionSet.selections[0].name.value;
    }
    else {
        targetFieldName = fieldName;
    }
    var targetSchema;
    var targetRootValue;
    var subschemaConfig;
    var endpoint;
    var allTransforms;
    if (isSubschemaConfig(subschemaOrSubschemaConfig)) {
        subschemaConfig = subschemaOrSubschemaConfig;
        targetSchema = subschemaConfig.schema;
        allTransforms =
            subschemaOrSubschemaConfig.transforms != null
                ? subschemaOrSubschemaConfig.transforms.concat(transforms)
                : transforms;
        if (typeof subschemaConfig.endpoint === 'object') {
            endpoint = subschemaConfig.endpoint;
        }
        else if (typeof subschemaConfig.endpoint === 'string') {
            var stitchingInfo = (_b = info === null || info === void 0 ? void 0 : info.schema.extensions) === null || _b === void 0 ? void 0 : _b.stitchingInfo;
            endpoint = stitchingInfo.endpoints[subschemaConfig.endpoint];
        }
        else {
            endpoint = subschemaConfig;
        }
        targetRootValue = (_c = rootValue !== null && rootValue !== void 0 ? rootValue : endpoint === null || endpoint === void 0 ? void 0 : endpoint.rootValue) !== null && _c !== void 0 ? _c : info === null || info === void 0 ? void 0 : info.rootValue;
    }
    else {
        targetSchema = subschemaOrSubschemaConfig;
        targetRootValue = rootValue !== null && rootValue !== void 0 ? rootValue : info === null || info === void 0 ? void 0 : info.rootValue;
        allTransforms = transforms;
    }
    var delegationContext = {
        subschema: subschemaOrSubschemaConfig,
        targetSchema: targetSchema,
        operation: targetOperation,
        fieldName: targetFieldName,
        args: args,
        context: context,
        info: info,
        returnType: (_d = returnType !== null && returnType !== void 0 ? returnType : info === null || info === void 0 ? void 0 : info.returnType) !== null && _d !== void 0 ? _d : getDelegationReturnType(targetSchema, targetOperation, targetFieldName),
        transforms: allTransforms,
        transformedSchema: transformedSchema !== null && transformedSchema !== void 0 ? transformedSchema : targetSchema,
        skipTypeMerging: skipTypeMerging,
    };
    var transformer = new Transformer(delegationContext, binding);
    var processedRequest = transformer.transformRequest(request);
    if (!skipValidation) {
        validateRequest(targetSchema, processedRequest.document);
    }
    if (targetOperation === 'query' || targetOperation === 'mutation') {
        var executor = (endpoint === null || endpoint === void 0 ? void 0 : endpoint.executor) || createDefaultExecutor(targetSchema, (subschemaConfig === null || subschemaConfig === void 0 ? void 0 : subschemaConfig.rootValue) || targetRootValue);
        if (endpoint === null || endpoint === void 0 ? void 0 : endpoint.batch) {
            executor = getBatchingExecutor(context, endpoint, executor);
        }
        var executionResult = executor(__assign(__assign({}, processedRequest), { context: context,
            info: info }));
        if (isPromise(executionResult)) {
            return executionResult.then(function (originalResult) { return transformer.transformResult(originalResult); });
        }
        return transformer.transformResult(executionResult);
    }
    var subscriber = (endpoint === null || endpoint === void 0 ? void 0 : endpoint.subscriber) || createDefaultSubscriber(targetSchema, (subschemaConfig === null || subschemaConfig === void 0 ? void 0 : subschemaConfig.rootValue) || targetRootValue);
    return subscriber(__assign(__assign({}, processedRequest), { context: context,
        info: info })).then(function (subscriptionResult) {
        if (Symbol.asyncIterator in subscriptionResult) {
            // "subscribe" to the subscription result and map the result through the transforms
            return mapAsyncIterator(subscriptionResult, function (originalResult) {
                var _a;
                return (_a = {},
                    _a[targetFieldName] = transformer.transformResult(originalResult),
                    _a);
            });
        }
        return transformer.transformResult(subscriptionResult);
    });
}
function validateRequest(targetSchema, document) {
    var errors = validate(targetSchema, document);
    if (errors.length > 0) {
        if (errors.length > 1) {
            var combinedError = new AggregateError(errors);
            throw combinedError;
        }
        var error = errors[0];
        throw error.originalError || error;
    }
}
function createDefaultExecutor(schema, rootValue) {
    return function (_a) {
        var document = _a.document, context = _a.context, variables = _a.variables, info = _a.info;
        return execute({
            schema: schema,
            document: document,
            contextValue: context,
            variableValues: variables,
            rootValue: rootValue !== null && rootValue !== void 0 ? rootValue : info === null || info === void 0 ? void 0 : info.rootValue,
        });
    };
}
function createDefaultSubscriber(schema, rootValue) {
    return function (_a) {
        var document = _a.document, context = _a.context, variables = _a.variables, info = _a.info;
        return subscribe({
            schema: schema,
            document: document,
            contextValue: context,
            variableValues: variables,
            rootValue: rootValue !== null && rootValue !== void 0 ? rootValue : info === null || info === void 0 ? void 0 : info.rootValue,
        });
    };
}

/**
 * Resolver that knows how to:
 * a) handle aliases for proxied schemas
 * b) handle errors from proxied schemas
 * c) handle external to internal enum coversion
 */
function defaultMergedResolver(parent, args, context, info) {
    if (!parent) {
        return null;
    }
    var responseKey = getResponseKeyFromInfo(info);
    var errors = getErrors(parent, responseKey);
    // check to see if parent is not a proxied result, i.e. if parent resolver was manually overwritten
    // See https://github.com/apollographql/graphql-tools/issues/967
    if (!errors) {
        return defaultFieldResolver(parent, args, context, info);
    }
    var result = parent[responseKey];
    var subschema = getSubschema(parent, responseKey);
    return handleResult(result, errors, subschema, context, info);
}

function unwrapResult(parent, path) {
    var newParent = parent;
    var pathLength = path.length;
    for (var i = 0; i < pathLength; i++) {
        var responseKey = path[i];
        var errors = getErrors(newParent, responseKey);
        var subschema = getSubschema(newParent, responseKey);
        var object = newParent[responseKey];
        if (object == null) {
            return handleNull(errors);
        }
        setErrors(object, errors.map(function (error) { return relocatedError(error, error.path != null ? error.path.slice(1) : undefined); }));
        setObjectSubschema(object, subschema);
        newParent = object;
    }
    return newParent;
}
function dehoistResult(parent, delimeter) {
    if (delimeter === void 0) { delimeter = '__gqltf__'; }
    var result = Object.create(null);
    Object.keys(parent).forEach(function (alias) {
        var obj = result;
        var fieldNames = alias.split(delimeter);
        var fieldName = fieldNames.pop();
        fieldNames.forEach(function (key) {
            obj = obj[key] = obj[key] || Object.create(null);
        });
        obj[fieldName] = parent[alias];
    });
    result[ERROR_SYMBOL] = parent[ERROR_SYMBOL].map(function (error) {
        if (error.path != null) {
            var path = error.path.slice();
            var pathSegment = path.shift();
            var expandedPathSegment = pathSegment.split(delimeter);
            return relocatedError(error, expandedPathSegment.concat(path));
        }
        return error;
    });
    result[OBJECT_SUBSCHEMA_SYMBOL] = parent[OBJECT_SUBSCHEMA_SYMBOL];
    return result;
}
function createMergedResolver(_a) {
    var fromPath = _a.fromPath, dehoist = _a.dehoist, _b = _a.delimeter, delimeter = _b === void 0 ? '__gqltf__' : _b;
    var parentErrorResolver = function (parent, args, context, info) {
        return parent instanceof Error ? parent : defaultMergedResolver(parent, args, context, info);
    };
    var unwrappingResolver = fromPath != null
        ? function (parent, args, context, info) { return parentErrorResolver(unwrapResult(parent, fromPath), args, context, info); }
        : parentErrorResolver;
    var dehoistingResolver = dehoist
        ? function (parent, args, context, info) { return unwrappingResolver(dehoistResult(parent, delimeter), args, context, info); }
        : unwrappingResolver;
    var noParentResolver = function (parent, args, context, info) {
        return parent ? dehoistingResolver(parent, args, context, info) : {};
    };
    return noParentResolver;
}

var AddSelectionSetsByField = /** @class */ (function () {
    function AddSelectionSetsByField(schema, mapping) {
        this.schema = schema;
        this.mapping = mapping;
    }
    AddSelectionSetsByField.prototype.transformRequest = function (originalRequest) {
        var document = addSelectionSetsByField(this.schema, originalRequest.document, this.mapping);
        return __assign(__assign({}, originalRequest), { document: document });
    };
    return AddSelectionSetsByField;
}());
function addSelectionSetsByField(schema, document, mapping) {
    var _a;
    var typeInfo = new TypeInfo(schema);
    return visit(document, visitWithTypeInfo(typeInfo, (_a = {},
        _a[Kind.SELECTION_SET] = function (node) {
            var parentType = typeInfo.getParentType();
            if (parentType != null) {
                var parentTypeName_1 = parentType.name;
                var selections_1 = node.selections;
                if (parentTypeName_1 in mapping) {
                    node.selections.forEach(function (selection) {
                        if (selection.kind === Kind.FIELD) {
                            var name_1 = selection.name.value;
                            var selectionSet = mapping[parentTypeName_1][name_1];
                            if (selectionSet != null) {
                                selections_1 = selections_1.concat(selectionSet.selections);
                            }
                        }
                    });
                }
                if (selections_1 !== node.selections) {
                    return __assign(__assign({}, node), { selections: selections_1 });
                }
            }
        },
        _a)));
}

var AddSelectionSetsByType = /** @class */ (function () {
    function AddSelectionSetsByType(targetSchema, mapping) {
        this.targetSchema = targetSchema;
        this.mapping = mapping;
    }
    AddSelectionSetsByType.prototype.transformRequest = function (originalRequest) {
        var document = addSelectionSetsByType(this.targetSchema, originalRequest.document, this.mapping);
        return __assign(__assign({}, originalRequest), { document: document });
    };
    return AddSelectionSetsByType;
}());
function addSelectionSetsByType(targetSchema, document, mapping) {
    var _a;
    var typeInfo = new TypeInfo(targetSchema);
    return visit(document, visitWithTypeInfo(typeInfo, (_a = {},
        _a[Kind.SELECTION_SET] = function (node) {
            var parentType = typeInfo.getParentType();
            if (parentType != null) {
                var parentTypeName = parentType.name;
                var selections = node.selections;
                if (parentTypeName in mapping) {
                    var selectionSet = mapping[parentTypeName];
                    if (selectionSet != null) {
                        selections = selections.concat(selectionSet.selections);
                    }
                }
                if (selections !== node.selections) {
                    return __assign(__assign({}, node), { selections: selections });
                }
            }
        },
        _a)));
}

var ReplaceFieldWithFragment = /** @class */ (function () {
    function ReplaceFieldWithFragment(targetSchema, fragments) {
        var e_1, _a;
        this.targetSchema = targetSchema;
        this.mapping = {};
        try {
            for (var fragments_1 = __values(fragments), fragments_1_1 = fragments_1.next(); !fragments_1_1.done; fragments_1_1 = fragments_1.next()) {
                var _b = fragments_1_1.value, field = _b.field, fragment = _b.fragment;
                var parsedFragment = parseFragmentToInlineFragment(fragment);
                var actualTypeName = parsedFragment.typeCondition.name.value;
                if (!(actualTypeName in this.mapping)) {
                    this.mapping[actualTypeName] = Object.create(null);
                }
                var typeMapping = this.mapping[actualTypeName];
                if (!(field in typeMapping)) {
                    typeMapping[field] = [parsedFragment];
                }
                else {
                    typeMapping[field].push(parsedFragment);
                }
            }
        }
        catch (e_1_1) { e_1 = { error: e_1_1 }; }
        finally {
            try {
                if (fragments_1_1 && !fragments_1_1.done && (_a = fragments_1.return)) _a.call(fragments_1);
            }
            finally { if (e_1) throw e_1.error; }
        }
    }
    ReplaceFieldWithFragment.prototype.transformRequest = function (originalRequest) {
        var document = replaceFieldsWithFragments(this.targetSchema, originalRequest.document, this.mapping);
        return __assign(__assign({}, originalRequest), { document: document });
    };
    return ReplaceFieldWithFragment;
}());
function replaceFieldsWithFragments(targetSchema, document, mapping) {
    var _a;
    var typeInfo = new TypeInfo(targetSchema);
    return visit(document, visitWithTypeInfo(typeInfo, (_a = {},
        _a[Kind.SELECTION_SET] = function (node) {
            var parentType = typeInfo.getParentType();
            if (parentType != null) {
                var parentTypeName_1 = parentType.name;
                var selections_1 = node.selections;
                if (parentTypeName_1 in mapping) {
                    node.selections.forEach(function (selection) {
                        if (selection.kind === Kind.FIELD) {
                            var name_1 = selection.name.value;
                            var fragments = mapping[parentTypeName_1][name_1];
                            if (fragments != null && fragments.length > 0) {
                                var fragment = concatInlineFragments(parentTypeName_1, fragments);
                                selections_1 = selections_1.concat(fragment);
                            }
                        }
                    });
                }
                if (selections_1 !== node.selections) {
                    return __assign(__assign({}, node), { selections: selections_1 });
                }
            }
        },
        _a)));
}
function parseFragmentToInlineFragment(definitions) {
    var e_2, _a, e_3, _b;
    if (definitions.trim().startsWith('fragment')) {
        var document_1 = parse(definitions);
        try {
            for (var _c = __values(document_1.definitions), _d = _c.next(); !_d.done; _d = _c.next()) {
                var definition = _d.value;
                if (definition.kind === Kind.FRAGMENT_DEFINITION) {
                    return {
                        kind: Kind.INLINE_FRAGMENT,
                        typeCondition: definition.typeCondition,
                        selectionSet: definition.selectionSet,
                    };
                }
            }
        }
        catch (e_2_1) { e_2 = { error: e_2_1 }; }
        finally {
            try {
                if (_d && !_d.done && (_a = _c.return)) _a.call(_c);
            }
            finally { if (e_2) throw e_2.error; }
        }
    }
    var query = parse("{" + definitions + "}").definitions[0];
    try {
        for (var _e = __values(query.selectionSet.selections), _f = _e.next(); !_f.done; _f = _e.next()) {
            var selection = _f.value;
            if (selection.kind === Kind.INLINE_FRAGMENT) {
                return selection;
            }
        }
    }
    catch (e_3_1) { e_3 = { error: e_3_1 }; }
    finally {
        try {
            if (_f && !_f.done && (_b = _e.return)) _b.call(_e);
        }
        finally { if (e_3) throw e_3.error; }
    }
    throw new Error('Could not parse fragment');
}

export { AddArgumentsAsVariables, AddFragmentsByField, AddSelectionSetsByType as AddMergedTypeSelectionSets, AddSelectionSets, AddSelectionSetsByField, AddTypenameToAbstract, CheckResultAndHandleErrors, ExpandAbstractTypes, FilterToSchema, ReplaceFieldWithFragment, Subschema, VisitSelectionSets, checkResultAndHandleErrors, createMergedResolver, createRequest, createRequestFromInfo, defaultDelegationBinding, defaultMergedResolver, delegateRequest, delegateToSchema, getSubschema, handleResult, isSubschema, isSubschemaConfig };
//# sourceMappingURL=index.esm.js.map
