import { DocumentNode } from 'graphql';
import { Transaction } from '../core/cache';
import { StoreObject, StoreValue, Reference } from '../../utilities';
import { FieldValueGetter } from './entityStore';
import { KeyFieldsFunction } from './policies';
import { Modifier, Modifiers, ToReferenceFunction, CanReadFunction } from '../core/types/common';
export { StoreObject, StoreValue, Reference };
export interface IdGetterObj extends Object {
    __typename?: string;
    id?: string;
    _id?: string;
}
export declare type IdGetter = (value: IdGetterObj) => string | undefined;
export interface NormalizedCache {
    has(dataId: string): boolean;
    get(dataId: string, fieldName: string): StoreValue;
    merge(dataId: string, incoming: StoreObject): void;
    modify(dataId: string, fields: Modifiers | Modifier<any>): boolean;
    delete(dataId: string, fieldName?: string): boolean;
    clear(): void;
    toObject(): NormalizedCacheObject;
    replace(newData: NormalizedCacheObject): void;
    retain(rootId: string): number;
    release(rootId: string): number;
    getFieldValue: FieldValueGetter;
    toReference: ToReferenceFunction;
    canRead: CanReadFunction;
}
export interface NormalizedCacheObject {
    [dataId: string]: StoreObject | undefined;
}
export declare type OptimisticStoreItem = {
    id: string;
    data: NormalizedCacheObject;
    transaction: Transaction<NormalizedCacheObject>;
};
export declare type ReadQueryOptions = {
    store: NormalizedCache;
    query: DocumentNode;
    variables?: Object;
    previousResult?: any;
    rootId?: string;
    config?: ApolloReducerConfig;
};
export declare type DiffQueryAgainstStoreOptions = ReadQueryOptions & {
    returnPartialData?: boolean;
};
export declare type ApolloReducerConfig = {
    dataIdFromObject?: KeyFieldsFunction;
    addTypename?: boolean;
};
export interface ReadMergeModifyContext {
    store: NormalizedCache;
    variables?: Record<string, any>;
    varString?: string;
}
//# sourceMappingURL=types.d.ts.map