import type { CacheKeyOptions, TransformOptions, TransformedSource, Transformer } from '@jest/transform';
import type { Config } from '@jest/types';
import { ConfigSet } from './config/config-set';
import type { TsJestGlobalOptions } from './types';
export declare class TsJestTransformer implements Transformer {
    private readonly logger;
    private readonly id;
    private readonly options;
    constructor(baseOptions?: TsJestGlobalOptions);
    /**
     * Use by e2e, don't mark as internal
     */
    configsFor(jestConfig: Config.ProjectConfig): ConfigSet;
    process(input: string, filePath: Config.Path, jestConfig: Config.ProjectConfig, transformOptions?: TransformOptions): TransformedSource | string;
    /**
     * Jest uses this to cache the compiled version of a file
     *
     * @see https://github.com/facebook/jest/blob/v23.5.0/packages/jest-runtime/src/script_transformer.js#L61-L90
     * @param fileContent The content of the file
     * @param filePath The full path to the file
     * @param _jestConfigStr The JSON-encoded version of jest config
     * @param transformOptions
     * @param transformOptions.instrument Whether the content will be instrumented by our transformer (always false)
     * @param transformOptions.rootDir Jest current rootDir
     */
    getCacheKey(fileContent: string, filePath: string, _jestConfigStr: string, transformOptions: CacheKeyOptions): string;
}
