"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initializeTranspilerInstance = void 0;
/**
 * @internal
 */
exports.initializeTranspilerInstance = function (configs, logger) {
    logger.debug('initializeTranspilerInstance(): create typescript compiler');
    var _a = configs.parsedTsConfig, options = _a.options, fileNames = _a.fileNames;
    var ts = configs.compilerModule;
    var program = ts.createProgram(fileNames, options);
    return {
        compileFn: function (code, fileName) {
            logger.debug({ fileName: fileName }, 'compileFn(): compiling as isolated module');
            var result = ts.transpileModule(code, {
                fileName: fileName,
                transformers: configs.tsCustomTransformers,
                compilerOptions: options,
                reportDiagnostics: configs.shouldReportDiagnostic(fileName),
            });
            if (result.diagnostics && configs.shouldReportDiagnostic(fileName)) {
                configs.raiseDiagnostics(result.diagnostics, fileName, logger);
            }
            // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
            return [result.outputText, result.sourceMapText];
        },
        program: program,
    };
};
