/**
 * This is the core of settings and so ts-jest.
 * Since configuration are used to create a good cache key, everything
 * depending on it is here. Fast jest relies on correct cache keys
 * depending on all settings that could affect the generated output.
 *
 * The big issue is that jest calls first `getCacheKey()` with stringified
 * version of the `jest.ProjectConfig`, and then later it calls `process()`
 * with the complete, object version of it.
 */
import type { Config } from '@jest/types';
import { Logger } from 'bs-logger';
import type { TsCompiler, TsJestGlobalOptions, TTypeScript } from '../types';
export declare class ConfigSet {
    readonly parentOptions?: TsJestGlobalOptions | undefined;
    /**
     * Use by e2e, don't mark as internal
     */
    get versions(): Record<string, string>;
    /**
     * This API can be used by custom transformers
     */
    get compilerModule(): TTypeScript;
    get tsCompiler(): TsCompiler;
    /**
     * Use by e2e, don't mark as internal
     */
    get tsJestDigest(): string;
    readonly logger: Logger;
    constructor(jestConfig: Config.ProjectConfig, parentOptions?: TsJestGlobalOptions | undefined, parentLogger?: Logger);
}
