"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.normalize = exports.parse = exports.stringify = void 0;
/* eslint-disable no-redeclare */
var stableStringify = require("fast-json-stable-stringify");
var UNDEFINED = 'undefined';
/**
 * @internal
 */
function stringify(input) {
    return input === undefined ? UNDEFINED : stableStringify(input);
}
exports.stringify = stringify;
/**
 * @internal
 */
function parse(input) {
    return input === UNDEFINED ? undefined : JSON.parse(input);
}
exports.parse = parse;
/**
 * @internal
 */
function normalize(input, _a) {
    var _b = (_a === void 0 ? {} : _a).parse, parser = _b === void 0 ? parse : _b;
    var result;
    if (normalize.cache.has(input)) {
        result = normalize.cache.get(input);
    }
    else {
        var data = parser(input);
        result = stringify(data);
        if (result === input)
            result = undefined;
        normalize.cache.set(input, result);
    }
    return result === undefined ? input : result;
}
exports.normalize = normalize;
/**
 * @internal
 */
// eslint-disable-next-line @typescript-eslint/no-namespace
(function (normalize) {
    normalize.cache = new Map();
})(normalize = exports.normalize || (exports.normalize = {}));
