var provider = {
  letters: 'явертъуиопшщасдфгхйклзьцжбнмчюЯВЕРТЪУИОПШЩАСДФГХЙКЛЗЬЦЖБНМЮЧ',

  words_list: [
    'на', 'и', 'в', 'потребител', 'е', 'от', 'за', 'се', 'пр', 'беседа', 'б', 'специални',
    'приноси', 'с', 'да', 'г', 'категория', 'по', 'през', 'са', 'като', 'а', 'си', 'не', 'година',
    'до', 'българия', 'шаблон', 'че', 'след', 'име', 'това', 'му', 'при', 'най', 'към', 'български',
    'език', 'или', 'картинка', 'флаг', 'има', 'които', 'но', 'дата', 'място', 'той', 'софия',
    'който', 'мъниче', 'град', 'н', 'роден', 'те', 'община', 'във', 'област', 'икона', 'време',
    'години', 'македония', 'война', 'част', 'виж', 'век', 'население', 'което', 'село', 'която',
    'със', 'много', 'сащ', 'описание', 'други', 'може', 'окръг', 'код', 'уикипедия', 'препратки',
    'един', 'история', 'външни', 'също', 'американски', 'този', 'вид', 'всички', 'около', 'та',
    'между', 'отбор', 'още', 'починал', 'карта', 'група', 'инфо', 'страна', 'селото', 'само', 'го',
    'п', 'м', 'става', 'английски', 'то', 'под', 'така', 'според', 'ще', 'източници', 'както',
    'германия', 'република', 'май', 'август', 'една', 'файл', 'когато', 'юли', 'септември',
    'биография', 'франция', 'тази', 'империя', 'юни', 'ширина', 'иван', 'р', 'височина', 'октомври',
    'януари', 'март', 'където', 'души', 'намира', 'стр', 'голяма', 'ноември', 'тя', 'срещу', 'мини',
    'им', 'т', 'април', 'георги', 'щати', 'награда', 'декември', 'център', 'тези', 'него', 'площ',
    'футбол', 'портрет', 'над', 'река', 'км', 'италия', 'името', 'ако', 'национален', 'февруари',
    'няколко', 'съединени', 'късно', 'жители', 'започва', 'някои', 'преди', 'сайт', 'българска',
    'държава', 'фк', 'русия', 'тях', 'края', 'димитър', 'началото', 'световна', 'бъде', 'две',
    'населението', 'градове', 'града', 'път', 'край', 'днес', 'без', 'портал', 'гърция', 'трябва',
    'селище', 'състав', 'заедно', 'няма', 'първата', 'александър', 'дължина', 'район', 'бил',
    'пояснение', 'бележки', 'страница', 'англия', 'върху', 'първенство', 'дем', 'официален',
    'страната', 'македоно', 'регион', 'провинция', 'страници', 'често', 'филм', 'европа', 'я',
    'поради', 'села', 'армия', 'вече', 'повече', 'какво', 'различни', 'литература', 'университет',
    'сезон', 'петър', 'сорткат', 'хора', 'министър', 'българи', 'чрез', 'д', 'съюз', 'партия',
    'география', 'васил', 'консул', 'българската', 'въпреки', 'два', 'малко', 'дясно', 'система',
    'испания', 'к', 'наставка', 'света', 'три', 'данни', 'едно', 'северна', 'футболист', 'могат',
    'албум', 'вижте', 'герб', 'друго', 'използва', 'южна', 'ги', 'смъртта', 'работи', 'получава',
    'у', 'сайта', 'били', 'организация', 'статия', 'св', 'имат', 'българско', 'участва', 'първи',
    'втората', 'ти', 'списък', 'френски', 'пфк', 'там', 'руски', 'сред', 'заглавие', 'музика',
    'ден', 'римски', 'политик', 'църква', 'христо', 'прави', 'завършва', 'обаче', 'управление',
    'формула', 'марк', 'пловдив', 'стефан', 'училище', 'информация', 'общо', 'никола', 'др',
    'първа', 'филми', 'тук', 'места', 'отново', 'император', 'член', 'актьор', 'генерал', 'всеки',
    'статистика', 'син', 'джон', 'района', 'свети', 'ми', 'великобритания', 'части', 'немски',
    'надразделение', 'пост', 'левски', 'нова', 'нея', 'период', 'все', 'писател', 'тип', 'времето',
    'резултат', 'тъй', 'групата', 'ист', 'втора', 'например', 'известен', 'освен', 'бразилия',
    'начин', 'де', 'сили', 'аз', 'баща', 'първият', 'добре', 'първите', 'голям', 'съм', 'живот',
    'купа', 'море', 'крал', 'превод', 'докато', 'мария', 'пощенски', 'деца', 'насам', 'шаблони',
    'дни', 'рим', 'личности', 'пренасочване', 'гръцки', 'революционер', 'автор', 'дори', 'битка',
    'ксн', 'подс', 'сочи', 'своя', 'защото', 'нови', 'връзка', 'главно', 'тогава', 'брой',
    'събития', 'николай', 'сърбия', 'първо', 'страни', 'ню', 'гр', 'африка', 'швеция', 'гео',
    'председател', 'остров', 'раждане', 'уеб', 'отбори', 'статии', 'луций', 'бъдат', 'право',
    'варна', 'била', 'белгия', 'семейство', 'би', 'човек', 'култура', 'лига', 'умира', 'планина',
    'имена', 'играе', 'против', 'надморска', 'езици', 'обикновено', 'двете', 'води', 'сан',
    'америка', 'стадион', 'политика', 'периода', 'стара', 'разположение', 'големи', 'почти',
    'актьори', 'о', 'фон', 'дивизия', 'уебсайт', 'заради', 'пред', 'режисьор', 'кръг', 'ссср',
    'опълчение', 'щата', 'договор', 'войната', 'отбора', 'номер', 'щат', 'текст', 'представка',
    'голямата', 'западна', 'било', 'острови', 'групи', 'световен', 'борис', 'голове', 'награди',
    'значение', 'първия', 'печели', 'изтриване', 'османската', 'римска', 'позиция', 'михаил', 'год',
    'остава', 'ли', 'цар', 'цска', 'статут', 'статията', 'полша', 'малки', 'областта', 'играч',
    'москва', 'съвет', 'телефонен', 'работа', 'игри', 'президент', 'всяка', 'турция', 'историята',
    'север', 'пъти', 'константин', 'румъния', 'гай', 'препратка', 'япония', 'австралия', 'цел',
    'мача', 'италиански', 'стил', 'египет', 'изток', 'й', 'видове', 'повечето', 'род', 'жени',
    'шампион', 'въстание', 'известни', 'треньор', 'минути', 'австрия', 'шампионат', 'селища',
    'дава', 'включва', 'поле', 'участие', 'унгария', 'степен', 'тел', 'манастир', 'среща', 'азия',
    'втори', 'вода', 'таблицата', 'административен', 'родени', 'нов', 'използват', 'етнография',
    'николов', 'хората', 'карл', 'друг', 'църквата', 'песен', 'региона', 'калифорния', 'продължава',
    'ред', 'вероятно', 'разположен', 'особено', 'вморо', 'живота', 'пише', 'сега', 'исторически',
    'книга', 'футболисти', 'своята', 'власт',
  ],

  transliteration_map: {
    "а": "a", "А": "A",
    "б": "b", "Б": "B",
    "в": "v", "В": "V",
    "г": "g", "Г": "G",
    "д": "d", "Д": "D",
    "е": "e", "Е": "E",
    "ж": "zh", "Ж": "Zh",
    "з": "z", "З": "Z",
    "и": "i", "И": "I",
    "й": "y", "Й": "Y",
    "к": "k", "К": "K",
    "л": "l", "Л": "L",
    "м": "m", "М": "M",
    "н": "n", "Н": "N",
    "о": "o", "О": "O",
    "п": "p", "П": "P",
    "р": "r", "Р": "R",
    "с": "s", "С": "S",
    "т": "t", "Т": "T",
    "у": "u", "У": "U",
    "ф": "f", "Ф": "F",
    "х": "h", "Х": "H",
    "ц": "ts", "Ц": "Ts",
    "ч": "ch", "Ч": "Ch",
    "ш": "sh", "Ш": "Sh",
    "щ": "sht", "Щ": "Sht",
    "ъ": "a", "Ъ": "A",
    "ь": "y", "Ь": "Y",
    "ю": "yu", "Ю": "Yu",
    "я": "ya", "Я": "Ya",
  },

  transliterate: function(str) {
    if (typeof str !== 'string' && !(str instanceof String)) {
      return '';
    }

    transliteration_map = this.transliteration_map;

    return str.split('').map(function(c) {
      if (transliteration_map[c]) {
        return transliteration_map[c];
      }

      return c;
    }).join('');  },
};

module.exports = provider;
