/**
 * This file was auto-generated by openapi-typescript.
 * Do not make direct changes to the file.
 */

export interface paths {
  "/": {
    get: operations["meta/root"];
  };
  "/app": {
    get: operations["apps/get-authenticated"];
  };
  "/app-manifests/{code}/conversions": {
    post: operations["apps/create-from-manifest"];
  };
  "/app/hook/config": {
    get: operations["apps/get-webhook-config-for-app"];
    patch: operations["apps/update-webhook-config-for-app"];
  };
  "/app/installations": {
    get: operations["apps/list-installations"];
  };
  "/app/installations/{installation_id}": {
    get: operations["apps/get-installation"];
    delete: operations["apps/delete-installation"];
  };
  "/app/installations/{installation_id}/access_tokens": {
    post: operations["apps/create-installation-access-token"];
  };
  "/app/installations/{installation_id}/suspended": {
    put: operations["apps/suspend-installation"];
    delete: operations["apps/unsuspend-installation"];
  };
  "/applications/grants": {
    get: operations["oauth-authorizations/list-grants"];
  };
  "/applications/grants/{grant_id}": {
    get: operations["oauth-authorizations/get-grant"];
    delete: operations["oauth-authorizations/delete-grant"];
  };
  "/applications/{client_id}/grant": {
    delete: operations["apps/delete-authorization"];
  };
  "/applications/{client_id}/grants/{access_token}": {
    delete: operations["apps/revoke-grant-for-application"];
  };
  "/applications/{client_id}/token": {
    post: operations["apps/check-token"];
    patch: operations["apps/reset-token"];
    delete: operations["apps/delete-token"];
  };
  "/applications/{client_id}/token/scoped": {
    post: operations["apps/scope-token"];
  };
  "/applications/{client_id}/tokens/{access_token}": {
    get: operations["apps/check-authorization"];
    post: operations["apps/reset-authorization"];
    delete: operations["apps/revoke-authorization-for-application"];
  };
  "/apps/{app_slug}": {
    get: operations["apps/get-by-slug"];
  };
  "/authorizations": {
    get: operations["oauth-authorizations/list-authorizations"];
    post: operations["oauth-authorizations/create-authorization"];
  };
  "/authorizations/clients/{client_id}": {
    put: operations["oauth-authorizations/get-or-create-authorization-for-app"];
  };
  "/authorizations/clients/{client_id}/{fingerprint}": {
    put: operations["oauth-authorizations/get-or-create-authorization-for-app-and-fingerprint"];
  };
  "/authorizations/{authorization_id}": {
    get: operations["oauth-authorizations/get-authorization"];
    patch: operations["oauth-authorizations/update-authorization"];
    delete: operations["oauth-authorizations/delete-authorization"];
  };
  "/codes_of_conduct": {
    get: operations["codes-of-conduct/get-all-codes-of-conduct"];
  };
  "/codes_of_conduct/{key}": {
    get: operations["codes-of-conduct/get-conduct-code"];
  };
  "/content_references/{content_reference_id}/attachments": {
    post: operations["apps/create-content-attachment"];
  };
  "/emojis": {
    get: operations["emojis/get"];
  };
  "/enterprises/{enterprise}/actions/permissions": {
    get: operations["enterprise-admin/get-github-actions-permissions-enterprise"];
    put: operations["enterprise-admin/set-github-actions-permissions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions/organizations": {
    get: operations["enterprise-admin/list-selected-organizations-enabled-github-actions-enterprise"];
    put: operations["enterprise-admin/set-selected-organizations-enabled-github-actions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions/organizations/{org_id}": {
    put: operations["enterprise-admin/enable-selected-organization-github-actions-enterprise"];
    delete: operations["enterprise-admin/disable-selected-organization-github-actions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/permissions/selected-actions": {
    get: operations["enterprise-admin/get-allowed-actions-enterprise"];
    put: operations["enterprise-admin/set-allowed-actions-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups": {
    get: operations["enterprise-admin/list-self-hosted-runner-groups-for-enterprise"];
    post: operations["enterprise-admin/create-self-hosted-runner-group-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}": {
    get: operations["enterprise-admin/get-self-hosted-runner-group-for-enterprise"];
    patch: operations["enterprise-admin/update-self-hosted-runner-group-for-enterprise"];
    delete: operations["enterprise-admin/delete-self-hosted-runner-group-from-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations": {
    get: operations["enterprise-admin/list-org-access-to-self-hosted-runner-group-in-enterprise"];
    put: operations["enterprise-admin/set-org-access-to-self-hosted-runner-group-in-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/organizations/{org_id}": {
    put: operations["enterprise-admin/add-org-access-to-self-hosted-runner-group-in-enterprise"];
    delete: operations["enterprise-admin/remove-org-access-to-self-hosted-runner-group-in-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners": {
    get: operations["enterprise-admin/list-self-hosted-runners-in-group-for-enterprise"];
    put: operations["enterprise-admin/set-self-hosted-runners-in-group-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runner-groups/{runner_group_id}/runners/{runner_id}": {
    put: operations["enterprise-admin/add-self-hosted-runner-to-group-for-enterprise"];
    delete: operations["enterprise-admin/remove-self-hosted-runner-from-group-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners": {
    get: operations["enterprise-admin/list-self-hosted-runners-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/downloads": {
    get: operations["enterprise-admin/list-runner-applications-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/registration-token": {
    post: operations["enterprise-admin/create-registration-token-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/remove-token": {
    post: operations["enterprise-admin/create-remove-token-for-enterprise"];
  };
  "/enterprises/{enterprise}/actions/runners/{runner_id}": {
    get: operations["enterprise-admin/get-self-hosted-runner-for-enterprise"];
    delete: operations["enterprise-admin/delete-self-hosted-runner-from-enterprise"];
  };
  "/enterprises/{enterprise}/audit-log": {
    get: operations["audit-log/get-audit-log"];
  };
  "/enterprises/{enterprise}/settings/billing/actions": {
    get: operations["billing/get-github-actions-billing-ghe"];
  };
  "/enterprises/{enterprise}/settings/billing/packages": {
    get: operations["billing/get-github-packages-billing-ghe"];
  };
  "/enterprises/{enterprise}/settings/billing/shared-storage": {
    get: operations["billing/get-shared-storage-billing-ghe"];
  };
  "/events": {
    get: operations["activity/list-public-events"];
  };
  "/feeds": {
    get: operations["activity/get-feeds"];
  };
  "/gists": {
    get: operations["gists/list"];
    post: operations["gists/create"];
  };
  "/gists/public": {
    get: operations["gists/list-public"];
  };
  "/gists/starred": {
    get: operations["gists/list-starred"];
  };
  "/gists/{gist_id}": {
    get: operations["gists/get"];
    patch: operations["gists/update"];
    delete: operations["gists/delete"];
  };
  "/gists/{gist_id}/comments": {
    get: operations["gists/list-comments"];
    post: operations["gists/create-comment"];
  };
  "/gists/{gist_id}/comments/{comment_id}": {
    get: operations["gists/get-comment"];
    patch: operations["gists/update-comment"];
    delete: operations["gists/delete-comment"];
  };
  "/gists/{gist_id}/commits": {
    get: operations["gists/list-commits"];
  };
  "/gists/{gist_id}/forks": {
    get: operations["gists/list-forks"];
    post: operations["gists/fork"];
  };
  "/gists/{gist_id}/star": {
    get: operations["gists/check-is-starred"];
    put: operations["gists/star"];
    delete: operations["gists/unstar"];
  };
  "/gists/{gist_id}/{sha}": {
    get: operations["gists/get-revision"];
  };
  "/gitignore/templates": {
    get: operations["gitignore/get-all-templates"];
  };
  "/gitignore/templates/{name}": {
    get: operations["gitignore/get-template"];
  };
  "/installation/repositories": {
    get: operations["apps/list-repos-accessible-to-installation"];
  };
  "/installation/token": {
    delete: operations["apps/revoke-installation-access-token"];
  };
  "/issues": {
    get: operations["issues/list"];
  };
  "/licenses": {
    get: operations["licenses/get-all-commonly-used"];
  };
  "/licenses/{license}": {
    get: operations["licenses/get"];
  };
  "/markdown": {
    post: operations["markdown/render"];
  };
  "/markdown/raw": {
    post: operations["markdown/render-raw"];
  };
  "/marketplace_listing/accounts/{account_id}": {
    get: operations["apps/get-subscription-plan-for-account"];
  };
  "/marketplace_listing/plans": {
    get: operations["apps/list-plans"];
  };
  "/marketplace_listing/plans/{plan_id}/accounts": {
    get: operations["apps/list-accounts-for-plan"];
  };
  "/marketplace_listing/stubbed/accounts/{account_id}": {
    get: operations["apps/get-subscription-plan-for-account-stubbed"];
  };
  "/marketplace_listing/stubbed/plans": {
    get: operations["apps/list-plans-stubbed"];
  };
  "/marketplace_listing/stubbed/plans/{plan_id}/accounts": {
    get: operations["apps/list-accounts-for-plan-stubbed"];
  };
  "/meta": {
    get: operations["meta/get"];
  };
  "/networks/{owner}/{repo}/events": {
    get: operations["activity/list-public-events-for-repo-network"];
  };
  "/notifications": {
    get: operations["activity/list-notifications-for-authenticated-user"];
    put: operations["activity/mark-notifications-as-read"];
  };
  "/notifications/threads/{thread_id}": {
    get: operations["activity/get-thread"];
    patch: operations["activity/mark-thread-as-read"];
  };
  "/notifications/threads/{thread_id}/subscription": {
    get: operations["activity/get-thread-subscription-for-authenticated-user"];
    put: operations["activity/set-thread-subscription"];
    delete: operations["activity/delete-thread-subscription"];
  };
  "/octocat": {
    get: operations["meta/get-octocat"];
  };
  "/organizations": {
    get: operations["orgs/list"];
  };
  "/orgs/{org}": {
    get: operations["orgs/get"];
    patch: operations["orgs/update"];
  };
  "/orgs/{org}/actions/permissions": {
    get: operations["actions/get-github-actions-permissions-organization"];
    put: operations["actions/set-github-actions-permissions-organization"];
  };
  "/orgs/{org}/actions/permissions/repositories": {
    get: operations["actions/list-selected-repositories-enabled-github-actions-organization"];
    put: operations["actions/set-selected-repositories-enabled-github-actions-organization"];
  };
  "/orgs/{org}/actions/permissions/repositories/{repository_id}": {
    put: operations["actions/enable-selected-repository-github-actions-organization"];
    delete: operations["actions/disable-selected-repository-github-actions-organization"];
  };
  "/orgs/{org}/actions/permissions/selected-actions": {
    get: operations["actions/get-allowed-actions-organization"];
    put: operations["actions/set-allowed-actions-organization"];
  };
  "/orgs/{org}/actions/runner-groups": {
    get: operations["actions/list-self-hosted-runner-groups-for-org"];
    post: operations["actions/create-self-hosted-runner-group-for-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}": {
    get: operations["actions/get-self-hosted-runner-group-for-org"];
    patch: operations["actions/update-self-hosted-runner-group-for-org"];
    delete: operations["actions/delete-self-hosted-runner-group-from-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories": {
    get: operations["actions/list-repo-access-to-self-hosted-runner-group-in-org"];
    put: operations["actions/set-repo-access-to-self-hosted-runner-group-in-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/repositories/{repository_id}": {
    put: operations["actions/add-repo-access-to-self-hosted-runner-group-in-org"];
    delete: operations["actions/remove-repo-access-to-self-hosted-runner-group-in-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/runners": {
    get: operations["actions/list-self-hosted-runners-in-group-for-org"];
    put: operations["actions/set-self-hosted-runners-in-group-for-org"];
  };
  "/orgs/{org}/actions/runner-groups/{runner_group_id}/runners/{runner_id}": {
    put: operations["actions/add-self-hosted-runner-to-group-for-org"];
    delete: operations["actions/remove-self-hosted-runner-from-group-for-org"];
  };
  "/orgs/{org}/actions/runners": {
    get: operations["actions/list-self-hosted-runners-for-org"];
  };
  "/orgs/{org}/actions/runners/downloads": {
    get: operations["actions/list-runner-applications-for-org"];
  };
  "/orgs/{org}/actions/runners/registration-token": {
    post: operations["actions/create-registration-token-for-org"];
  };
  "/orgs/{org}/actions/runners/remove-token": {
    post: operations["actions/create-remove-token-for-org"];
  };
  "/orgs/{org}/actions/runners/{runner_id}": {
    get: operations["actions/get-self-hosted-runner-for-org"];
    delete: operations["actions/delete-self-hosted-runner-from-org"];
  };
  "/orgs/{org}/actions/secrets": {
    get: operations["actions/list-org-secrets"];
  };
  "/orgs/{org}/actions/secrets/public-key": {
    get: operations["actions/get-org-public-key"];
  };
  "/orgs/{org}/actions/secrets/{secret_name}": {
    get: operations["actions/get-org-secret"];
    put: operations["actions/create-or-update-org-secret"];
    delete: operations["actions/delete-org-secret"];
  };
  "/orgs/{org}/actions/secrets/{secret_name}/repositories": {
    get: operations["actions/list-selected-repos-for-org-secret"];
    put: operations["actions/set-selected-repos-for-org-secret"];
  };
  "/orgs/{org}/actions/secrets/{secret_name}/repositories/{repository_id}": {
    put: operations["actions/add-selected-repo-to-org-secret"];
    delete: operations["actions/remove-selected-repo-from-org-secret"];
  };
  "/orgs/{org}/audit-log": {
    get: operations["orgs/get-audit-log"];
  };
  "/orgs/{org}/blocks": {
    get: operations["orgs/list-blocked-users"];
  };
  "/orgs/{org}/blocks/{username}": {
    get: operations["orgs/check-blocked-user"];
    put: operations["orgs/block-user"];
    delete: operations["orgs/unblock-user"];
  };
  "/orgs/{org}/credential-authorizations": {
    get: operations["orgs/list-saml-sso-authorizations"];
  };
  "/orgs/{org}/credential-authorizations/{credential_id}": {
    delete: operations["orgs/remove-saml-sso-authorization"];
  };
  "/orgs/{org}/events": {
    get: operations["activity/list-public-org-events"];
  };
  "/orgs/{org}/hooks": {
    get: operations["orgs/list-webhooks"];
    post: operations["orgs/create-webhook"];
  };
  "/orgs/{org}/hooks/{hook_id}": {
    get: operations["orgs/get-webhook"];
    patch: operations["orgs/update-webhook"];
    delete: operations["orgs/delete-webhook"];
  };
  "/orgs/{org}/hooks/{hook_id}/config": {
    get: operations["orgs/get-webhook-config-for-org"];
    patch: operations["orgs/update-webhook-config-for-org"];
  };
  "/orgs/{org}/hooks/{hook_id}/pings": {
    post: operations["orgs/ping-webhook"];
  };
  "/orgs/{org}/installation": {
    get: operations["apps/get-org-installation"];
  };
  "/orgs/{org}/installations": {
    get: operations["orgs/list-app-installations"];
  };
  "/orgs/{org}/interaction-limits": {
    get: operations["interactions/get-restrictions-for-org"];
    put: operations["interactions/set-restrictions-for-org"];
    delete: operations["interactions/remove-restrictions-for-org"];
  };
  "/orgs/{org}/invitations": {
    get: operations["orgs/list-pending-invitations"];
    post: operations["orgs/create-invitation"];
  };
  "/orgs/{org}/invitations/{invitation_id}/teams": {
    get: operations["orgs/list-invitation-teams"];
  };
  "/orgs/{org}/issues": {
    get: operations["issues/list-for-org"];
  };
  "/orgs/{org}/members": {
    get: operations["orgs/list-members"];
  };
  "/orgs/{org}/members/{username}": {
    get: operations["orgs/check-membership-for-user"];
    delete: operations["orgs/remove-member"];
  };
  "/orgs/{org}/memberships/{username}": {
    get: operations["orgs/get-membership-for-user"];
    put: operations["orgs/set-membership-for-user"];
    delete: operations["orgs/remove-membership-for-user"];
  };
  "/orgs/{org}/migrations": {
    get: operations["migrations/list-for-org"];
    post: operations["migrations/start-for-org"];
  };
  "/orgs/{org}/migrations/{migration_id}": {
    get: operations["migrations/get-status-for-org"];
  };
  "/orgs/{org}/migrations/{migration_id}/archive": {
    get: operations["migrations/download-archive-for-org"];
    delete: operations["migrations/delete-archive-for-org"];
  };
  "/orgs/{org}/migrations/{migration_id}/repos/{repo_name}/lock": {
    delete: operations["migrations/unlock-repo-for-org"];
  };
  "/orgs/{org}/migrations/{migration_id}/repositories": {
    get: operations["migrations/list-repos-for-org"];
  };
  "/orgs/{org}/outside_collaborators": {
    get: operations["orgs/list-outside-collaborators"];
  };
  "/orgs/{org}/outside_collaborators/{username}": {
    put: operations["orgs/convert-member-to-outside-collaborator"];
    delete: operations["orgs/remove-outside-collaborator"];
  };
  "/orgs/{org}/projects": {
    get: operations["projects/list-for-org"];
    post: operations["projects/create-for-org"];
  };
  "/orgs/{org}/public_members": {
    get: operations["orgs/list-public-members"];
  };
  "/orgs/{org}/public_members/{username}": {
    get: operations["orgs/check-public-membership-for-user"];
    put: operations["orgs/set-public-membership-for-authenticated-user"];
    delete: operations["orgs/remove-public-membership-for-authenticated-user"];
  };
  "/orgs/{org}/repos": {
    get: operations["repos/list-for-org"];
    post: operations["repos/create-in-org"];
  };
  "/orgs/{org}/settings/billing/actions": {
    get: operations["billing/get-github-actions-billing-org"];
  };
  "/orgs/{org}/settings/billing/packages": {
    get: operations["billing/get-github-packages-billing-org"];
  };
  "/orgs/{org}/settings/billing/shared-storage": {
    get: operations["billing/get-shared-storage-billing-org"];
  };
  "/orgs/{org}/team-sync/groups": {
    get: operations["teams/list-idp-groups-for-org"];
  };
  "/orgs/{org}/teams": {
    get: operations["teams/list"];
    post: operations["teams/create"];
  };
  "/orgs/{org}/teams/{team_slug}": {
    get: operations["teams/get-by-name"];
    patch: operations["teams/update-in-org"];
    delete: operations["teams/delete-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions": {
    get: operations["teams/list-discussions-in-org"];
    post: operations["teams/create-discussion-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}": {
    get: operations["teams/get-discussion-in-org"];
    patch: operations["teams/update-discussion-in-org"];
    delete: operations["teams/delete-discussion-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments": {
    get: operations["teams/list-discussion-comments-in-org"];
    post: operations["teams/create-discussion-comment-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}": {
    get: operations["teams/get-discussion-comment-in-org"];
    patch: operations["teams/update-discussion-comment-in-org"];
    delete: operations["teams/delete-discussion-comment-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions": {
    get: operations["reactions/list-for-team-discussion-comment-in-org"];
    post: operations["reactions/create-for-team-discussion-comment-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/comments/{comment_number}/reactions/{reaction_id}": {
    delete: operations["reactions/delete-for-team-discussion-comment"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions": {
    get: operations["reactions/list-for-team-discussion-in-org"];
    post: operations["reactions/create-for-team-discussion-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/discussions/{discussion_number}/reactions/{reaction_id}": {
    delete: operations["reactions/delete-for-team-discussion"];
  };
  "/orgs/{org}/teams/{team_slug}/invitations": {
    get: operations["teams/list-pending-invitations-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/members": {
    get: operations["teams/list-members-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/memberships/{username}": {
    get: operations["teams/get-membership-for-user-in-org"];
    put: operations["teams/add-or-update-membership-for-user-in-org"];
    delete: operations["teams/remove-membership-for-user-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/projects": {
    get: operations["teams/list-projects-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/projects/{project_id}": {
    get: operations["teams/check-permissions-for-project-in-org"];
    put: operations["teams/add-or-update-project-permissions-in-org"];
    delete: operations["teams/remove-project-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/repos": {
    get: operations["teams/list-repos-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/repos/{owner}/{repo}": {
    get: operations["teams/check-permissions-for-repo-in-org"];
    put: operations["teams/add-or-update-repo-permissions-in-org"];
    delete: operations["teams/remove-repo-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/team-sync/group-mappings": {
    get: operations["teams/list-idp-groups-in-org"];
    patch: operations["teams/create-or-update-idp-group-connections-in-org"];
  };
  "/orgs/{org}/teams/{team_slug}/teams": {
    get: operations["teams/list-child-in-org"];
  };
  "/projects/columns/cards/{card_id}": {
    get: operations["projects/get-card"];
    patch: operations["projects/update-card"];
    delete: operations["projects/delete-card"];
  };
  "/projects/columns/cards/{card_id}/moves": {
    post: operations["projects/move-card"];
  };
  "/projects/columns/{column_id}": {
    get: operations["projects/get-column"];
    patch: operations["projects/update-column"];
    delete: operations["projects/delete-column"];
  };
  "/projects/columns/{column_id}/cards": {
    get: operations["projects/list-cards"];
    post: operations["projects/create-card"];
  };
  "/projects/columns/{column_id}/moves": {
    post: operations["projects/move-column"];
  };
  "/projects/{project_id}": {
    get: operations["projects/get"];
    patch: operations["projects/update"];
    delete: operations["projects/delete"];
  };
  "/projects/{project_id}/collaborators": {
    get: operations["projects/list-collaborators"];
  };
  "/projects/{project_id}/collaborators/{username}": {
    put: operations["projects/add-collaborator"];
    delete: operations["projects/remove-collaborator"];
  };
  "/projects/{project_id}/collaborators/{username}/permission": {
    get: operations["projects/get-permission-for-user"];
  };
  "/projects/{project_id}/columns": {
    get: operations["projects/list-columns"];
    post: operations["projects/create-column"];
  };
  "/rate_limit": {
    get: operations["rate-limit/get"];
  };
  "/reactions/{reaction_id}": {
    delete: operations["reactions/delete-legacy"];
  };
  "/repos/{owner}/{repo}": {
    get: operations["repos/get"];
    patch: operations["repos/update"];
    delete: operations["repos/delete"];
  };
  "/repos/{owner}/{repo}/actions/artifacts": {
    get: operations["actions/list-artifacts-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/artifacts/{artifact_id}": {
    get: operations["actions/get-artifact"];
    delete: operations["actions/delete-artifact"];
  };
  "/repos/{owner}/{repo}/actions/artifacts/{artifact_id}/{archive_format}": {
    get: operations["actions/download-artifact"];
  };
  "/repos/{owner}/{repo}/actions/jobs/{job_id}": {
    get: operations["actions/get-job-for-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/jobs/{job_id}/logs": {
    get: operations["actions/download-job-logs-for-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/permissions": {
    get: operations["actions/get-github-actions-permissions-repository"];
    put: operations["actions/set-github-actions-permissions-repository"];
  };
  "/repos/{owner}/{repo}/actions/permissions/selected-actions": {
    get: operations["actions/get-allowed-actions-repository"];
    put: operations["actions/set-allowed-actions-repository"];
  };
  "/repos/{owner}/{repo}/actions/runners": {
    get: operations["actions/list-self-hosted-runners-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/downloads": {
    get: operations["actions/list-runner-applications-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/registration-token": {
    post: operations["actions/create-registration-token-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/remove-token": {
    post: operations["actions/create-remove-token-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runners/{runner_id}": {
    get: operations["actions/get-self-hosted-runner-for-repo"];
    delete: operations["actions/delete-self-hosted-runner-from-repo"];
  };
  "/repos/{owner}/{repo}/actions/runs": {
    get: operations["actions/list-workflow-runs-for-repo"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}": {
    get: operations["actions/get-workflow-run"];
    delete: operations["actions/delete-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/artifacts": {
    get: operations["actions/list-workflow-run-artifacts"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/cancel": {
    post: operations["actions/cancel-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/jobs": {
    get: operations["actions/list-jobs-for-workflow-run"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/logs": {
    get: operations["actions/download-workflow-run-logs"];
    delete: operations["actions/delete-workflow-run-logs"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/rerun": {
    post: operations["actions/re-run-workflow"];
  };
  "/repos/{owner}/{repo}/actions/runs/{run_id}/timing": {
    get: operations["actions/get-workflow-run-usage"];
  };
  "/repos/{owner}/{repo}/actions/secrets": {
    get: operations["actions/list-repo-secrets"];
  };
  "/repos/{owner}/{repo}/actions/secrets/public-key": {
    get: operations["actions/get-repo-public-key"];
  };
  "/repos/{owner}/{repo}/actions/secrets/{secret_name}": {
    get: operations["actions/get-repo-secret"];
    put: operations["actions/create-or-update-repo-secret"];
    delete: operations["actions/delete-repo-secret"];
  };
  "/repos/{owner}/{repo}/actions/workflows": {
    get: operations["actions/list-repo-workflows"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}": {
    get: operations["actions/get-workflow"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/disable": {
    put: operations["actions/disable-workflow"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/dispatches": {
    post: operations["actions/create-workflow-dispatch"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/enable": {
    put: operations["actions/enable-workflow"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/runs": {
    get: operations["actions/list-workflow-runs"];
  };
  "/repos/{owner}/{repo}/actions/workflows/{workflow_id}/timing": {
    get: operations["actions/get-workflow-usage"];
  };
  "/repos/{owner}/{repo}/assignees": {
    get: operations["issues/list-assignees"];
  };
  "/repos/{owner}/{repo}/assignees/{assignee}": {
    get: operations["issues/check-user-can-be-assigned"];
  };
  "/repos/{owner}/{repo}/automated-security-fixes": {
    put: operations["repos/enable-automated-security-fixes"];
    delete: operations["repos/disable-automated-security-fixes"];
  };
  "/repos/{owner}/{repo}/branches": {
    get: operations["repos/list-branches"];
  };
  "/repos/{owner}/{repo}/branches/{branch}": {
    get: operations["repos/get-branch"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection": {
    get: operations["repos/get-branch-protection"];
    put: operations["repos/update-branch-protection"];
    delete: operations["repos/delete-branch-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/enforce_admins": {
    get: operations["repos/get-admin-branch-protection"];
    post: operations["repos/set-admin-branch-protection"];
    delete: operations["repos/delete-admin-branch-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_pull_request_reviews": {
    get: operations["repos/get-pull-request-review-protection"];
    patch: operations["repos/update-pull-request-review-protection"];
    delete: operations["repos/delete-pull-request-review-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_signatures": {
    get: operations["repos/get-commit-signature-protection"];
    post: operations["repos/create-commit-signature-protection"];
    delete: operations["repos/delete-commit-signature-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks": {
    get: operations["repos/get-status-checks-protection"];
    patch: operations["repos/update-status-check-protection"];
    delete: operations["repos/remove-status-check-protection"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/required_status_checks/contexts": {
    get: operations["repos/get-all-status-check-contexts"];
    post: operations["repos/add-status-check-contexts"];
    put: operations["repos/set-status-check-contexts"];
    delete: operations["repos/remove-status-check-contexts"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions": {
    get: operations["repos/get-access-restrictions"];
    delete: operations["repos/delete-access-restrictions"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/apps": {
    get: operations["repos/get-apps-with-access-to-protected-branch"];
    post: operations["repos/add-app-access-restrictions"];
    put: operations["repos/set-app-access-restrictions"];
    delete: operations["repos/remove-app-access-restrictions"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/teams": {
    get: operations["repos/get-teams-with-access-to-protected-branch"];
    post: operations["repos/add-team-access-restrictions"];
    put: operations["repos/set-team-access-restrictions"];
    delete: operations["repos/remove-team-access-restrictions"];
  };
  "/repos/{owner}/{repo}/branches/{branch}/protection/restrictions/users": {
    get: operations["repos/get-users-with-access-to-protected-branch"];
    post: operations["repos/add-user-access-restrictions"];
    put: operations["repos/set-user-access-restrictions"];
    delete: operations["repos/remove-user-access-restrictions"];
  };
  "/repos/{owner}/{repo}/check-runs": {
    post: operations["checks/create"];
  };
  "/repos/{owner}/{repo}/check-runs/{check_run_id}": {
    get: operations["checks/get"];
    patch: operations["checks/update"];
  };
  "/repos/{owner}/{repo}/check-runs/{check_run_id}/annotations": {
    get: operations["checks/list-annotations"];
  };
  "/repos/{owner}/{repo}/check-suites": {
    post: operations["checks/create-suite"];
  };
  "/repos/{owner}/{repo}/check-suites/preferences": {
    patch: operations["checks/set-suites-preferences"];
  };
  "/repos/{owner}/{repo}/check-suites/{check_suite_id}": {
    get: operations["checks/get-suite"];
  };
  "/repos/{owner}/{repo}/check-suites/{check_suite_id}/check-runs": {
    get: operations["checks/list-for-suite"];
  };
  "/repos/{owner}/{repo}/check-suites/{check_suite_id}/rerequest": {
    post: operations["checks/rerequest-suite"];
  };
  "/repos/{owner}/{repo}/code-scanning/alerts": {
    get: operations["code-scanning/list-alerts-for-repo"];
  };
  "/repos/{owner}/{repo}/code-scanning/alerts/{alert_number}": {
    get: operations["code-scanning/get-alert"];
    patch: operations["code-scanning/update-alert"];
  };
  "/repos/{owner}/{repo}/code-scanning/analyses": {
    get: operations["code-scanning/list-recent-analyses"];
  };
  "/repos/{owner}/{repo}/code-scanning/sarifs": {
    post: operations["code-scanning/upload-sarif"];
  };
  "/repos/{owner}/{repo}/collaborators": {
    get: operations["repos/list-collaborators"];
  };
  "/repos/{owner}/{repo}/collaborators/{username}": {
    get: operations["repos/check-collaborator"];
    put: operations["repos/add-collaborator"];
    delete: operations["repos/remove-collaborator"];
  };
  "/repos/{owner}/{repo}/collaborators/{username}/permission": {
    get: operations["repos/get-collaborator-permission-level"];
  };
  "/repos/{owner}/{repo}/comments": {
    get: operations["repos/list-commit-comments-for-repo"];
  };
  "/repos/{owner}/{repo}/comments/{comment_id}": {
    get: operations["repos/get-commit-comment"];
    patch: operations["repos/update-commit-comment"];
    delete: operations["repos/delete-commit-comment"];
  };
  "/repos/{owner}/{repo}/comments/{comment_id}/reactions": {
    get: operations["reactions/list-for-commit-comment"];
    post: operations["reactions/create-for-commit-comment"];
  };
  "/repos/{owner}/{repo}/comments/{comment_id}/reactions/{reaction_id}": {
    delete: operations["reactions/delete-for-commit-comment"];
  };
  "/repos/{owner}/{repo}/commits": {
    get: operations["repos/list-commits"];
  };
  "/repos/{owner}/{repo}/commits/{commit_sha}/branches-where-head": {
    get: operations["repos/list-branches-for-head-commit"];
  };
  "/repos/{owner}/{repo}/commits/{commit_sha}/comments": {
    get: operations["repos/list-comments-for-commit"];
    post: operations["repos/create-commit-comment"];
  };
  "/repos/{owner}/{repo}/commits/{commit_sha}/pulls": {
    get: operations["repos/list-pull-requests-associated-with-commit"];
  };
  "/repos/{owner}/{repo}/commits/{ref}": {
    get: operations["repos/get-commit"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/check-runs": {
    get: operations["checks/list-for-ref"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/check-suites": {
    get: operations["checks/list-suites-for-ref"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/status": {
    get: operations["repos/get-combined-status-for-ref"];
  };
  "/repos/{owner}/{repo}/commits/{ref}/statuses": {
    get: operations["repos/list-commit-statuses-for-ref"];
  };
  "/repos/{owner}/{repo}/community/code_of_conduct": {
    get: operations["codes-of-conduct/get-for-repo"];
  };
  "/repos/{owner}/{repo}/community/profile": {
    get: operations["repos/get-community-profile-metrics"];
  };
  "/repos/{owner}/{repo}/compare/{base}...{head}": {
    get: operations["repos/compare-commits"];
  };
  "/repos/{owner}/{repo}/contents/{path}": {
    get: operations["repos/get-content"];
    put: operations["repos/create-or-update-file-contents"];
    delete: operations["repos/delete-file"];
  };
  "/repos/{owner}/{repo}/contributors": {
    get: operations["repos/list-contributors"];
  };
  "/repos/{owner}/{repo}/deployments": {
    get: operations["repos/list-deployments"];
    post: operations["repos/create-deployment"];
  };
  "/repos/{owner}/{repo}/deployments/{deployment_id}": {
    get: operations["repos/get-deployment"];
    delete: operations["repos/delete-deployment"];
  };
  "/repos/{owner}/{repo}/deployments/{deployment_id}/statuses": {
    get: operations["repos/list-deployment-statuses"];
    post: operations["repos/create-deployment-status"];
  };
  "/repos/{owner}/{repo}/deployments/{deployment_id}/statuses/{status_id}": {
    get: operations["repos/get-deployment-status"];
  };
  "/repos/{owner}/{repo}/dispatches": {
    post: operations["repos/create-dispatch-event"];
  };
  "/repos/{owner}/{repo}/events": {
    get: operations["activity/list-repo-events"];
  };
  "/repos/{owner}/{repo}/forks": {
    get: operations["repos/list-forks"];
    post: operations["repos/create-fork"];
  };
  "/repos/{owner}/{repo}/git/blobs": {
    post: operations["git/create-blob"];
  };
  "/repos/{owner}/{repo}/git/blobs/{file_sha}": {
    get: operations["git/get-blob"];
  };
  "/repos/{owner}/{repo}/git/commits": {
    post: operations["git/create-commit"];
  };
  "/repos/{owner}/{repo}/git/commits/{commit_sha}": {
    get: operations["git/get-commit"];
  };
  "/repos/{owner}/{repo}/git/matching-refs/{ref}": {
    get: operations["git/list-matching-refs"];
  };
  "/repos/{owner}/{repo}/git/ref/{ref}": {
    get: operations["git/get-ref"];
  };
  "/repos/{owner}/{repo}/git/refs": {
    post: operations["git/create-ref"];
  };
  "/repos/{owner}/{repo}/git/refs/{ref}": {
    patch: operations["git/update-ref"];
    delete: operations["git/delete-ref"];
  };
  "/repos/{owner}/{repo}/git/tags": {
    post: operations["git/create-tag"];
  };
  "/repos/{owner}/{repo}/git/tags/{tag_sha}": {
    get: operations["git/get-tag"];
  };
  "/repos/{owner}/{repo}/git/trees": {
    post: operations["git/create-tree"];
  };
  "/repos/{owner}/{repo}/git/trees/{tree_sha}": {
    get: operations["git/get-tree"];
  };
  "/repos/{owner}/{repo}/hooks": {
    get: operations["repos/list-webhooks"];
    post: operations["repos/create-webhook"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}": {
    get: operations["repos/get-webhook"];
    patch: operations["repos/update-webhook"];
    delete: operations["repos/delete-webhook"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/config": {
    get: operations["repos/get-webhook-config-for-repo"];
    patch: operations["repos/update-webhook-config-for-repo"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/pings": {
    post: operations["repos/ping-webhook"];
  };
  "/repos/{owner}/{repo}/hooks/{hook_id}/tests": {
    post: operations["repos/test-push-webhook"];
  };
  "/repos/{owner}/{repo}/import": {
    get: operations["migrations/get-import-status"];
    put: operations["migrations/start-import"];
    patch: operations["migrations/update-import"];
    delete: operations["migrations/cancel-import"];
  };
  "/repos/{owner}/{repo}/import/authors": {
    get: operations["migrations/get-commit-authors"];
  };
  "/repos/{owner}/{repo}/import/authors/{author_id}": {
    patch: operations["migrations/map-commit-author"];
  };
  "/repos/{owner}/{repo}/import/large_files": {
    get: operations["migrations/get-large-files"];
  };
  "/repos/{owner}/{repo}/import/lfs": {
    patch: operations["migrations/set-lfs-preference"];
  };
  "/repos/{owner}/{repo}/installation": {
    get: operations["apps/get-repo-installation"];
  };
  "/repos/{owner}/{repo}/interaction-limits": {
    get: operations["interactions/get-restrictions-for-repo"];
    put: operations["interactions/set-restrictions-for-repo"];
    delete: operations["interactions/remove-restrictions-for-repo"];
  };
  "/repos/{owner}/{repo}/invitations": {
    get: operations["repos/list-invitations"];
  };
  "/repos/{owner}/{repo}/invitations/{invitation_id}": {
    patch: operations["repos/update-invitation"];
    delete: operations["repos/delete-invitation"];
  };
  "/repos/{owner}/{repo}/issues": {
    get: operations["issues/list-for-repo"];
    post: operations["issues/create"];
  };
  "/repos/{owner}/{repo}/issues/comments": {
    get: operations["issues/list-comments-for-repo"];
  };
  "/repos/{owner}/{repo}/issues/comments/{comment_id}": {
    get: operations["issues/get-comment"];
    patch: operations["issues/update-comment"];
    delete: operations["issues/delete-comment"];
  };
  "/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions": {
    get: operations["reactions/list-for-issue-comment"];
    post: operations["reactions/create-for-issue-comment"];
  };
  "/repos/{owner}/{repo}/issues/comments/{comment_id}/reactions/{reaction_id}": {
    delete: operations["reactions/delete-for-issue-comment"];
  };
  "/repos/{owner}/{repo}/issues/events": {
    get: operations["issues/list-events-for-repo"];
  };
  "/repos/{owner}/{repo}/issues/events/{event_id}": {
    get: operations["issues/get-event"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}": {
    get: operations["issues/get"];
    patch: operations["issues/update"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/assignees": {
    post: operations["issues/add-assignees"];
    delete: operations["issues/remove-assignees"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/comments": {
    get: operations["issues/list-comments"];
    post: operations["issues/create-comment"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/events": {
    get: operations["issues/list-events"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/labels": {
    get: operations["issues/list-labels-on-issue"];
    post: operations["issues/add-labels"];
    put: operations["issues/set-labels"];
    delete: operations["issues/remove-all-labels"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/labels/{name}": {
    delete: operations["issues/remove-label"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/lock": {
    put: operations["issues/lock"];
    delete: operations["issues/unlock"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/reactions": {
    get: operations["reactions/list-for-issue"];
    post: operations["reactions/create-for-issue"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/reactions/{reaction_id}": {
    delete: operations["reactions/delete-for-issue"];
  };
  "/repos/{owner}/{repo}/issues/{issue_number}/timeline": {
    get: operations["issues/list-events-for-timeline"];
  };
  "/repos/{owner}/{repo}/keys": {
    get: operations["repos/list-deploy-keys"];
    post: operations["repos/create-deploy-key"];
  };
  "/repos/{owner}/{repo}/keys/{key_id}": {
    get: operations["repos/get-deploy-key"];
    delete: operations["repos/delete-deploy-key"];
  };
  "/repos/{owner}/{repo}/labels": {
    get: operations["issues/list-labels-for-repo"];
    post: operations["issues/create-label"];
  };
  "/repos/{owner}/{repo}/labels/{name}": {
    get: operations["issues/get-label"];
    patch: operations["issues/update-label"];
    delete: operations["issues/delete-label"];
  };
  "/repos/{owner}/{repo}/languages": {
    get: operations["repos/list-languages"];
  };
  "/repos/{owner}/{repo}/license": {
    get: operations["licenses/get-for-repo"];
  };
  "/repos/{owner}/{repo}/merges": {
    post: operations["repos/merge"];
  };
  "/repos/{owner}/{repo}/milestones": {
    get: operations["issues/list-milestones"];
    post: operations["issues/create-milestone"];
  };
  "/repos/{owner}/{repo}/milestones/{milestone_number}": {
    get: operations["issues/get-milestone"];
    patch: operations["issues/update-milestone"];
    delete: operations["issues/delete-milestone"];
  };
  "/repos/{owner}/{repo}/milestones/{milestone_number}/labels": {
    get: operations["issues/list-labels-for-milestone"];
  };
  "/repos/{owner}/{repo}/notifications": {
    get: operations["activity/list-repo-notifications-for-authenticated-user"];
    put: operations["activity/mark-repo-notifications-as-read"];
  };
  "/repos/{owner}/{repo}/pages": {
    get: operations["repos/get-pages"];
    post: operations["repos/create-pages-site"];
    put: operations["repos/update-information-about-pages-site"];
    delete: operations["repos/delete-pages-site"];
  };
  "/repos/{owner}/{repo}/pages/builds": {
    get: operations["repos/list-pages-builds"];
    post: operations["repos/request-pages-build"];
  };
  "/repos/{owner}/{repo}/pages/builds/latest": {
    get: operations["repos/get-latest-pages-build"];
  };
  "/repos/{owner}/{repo}/pages/builds/{build_id}": {
    get: operations["repos/get-pages-build"];
  };
  "/repos/{owner}/{repo}/projects": {
    get: operations["projects/list-for-repo"];
    post: operations["projects/create-for-repo"];
  };
  "/repos/{owner}/{repo}/pulls": {
    get: operations["pulls/list"];
    post: operations["pulls/create"];
  };
  "/repos/{owner}/{repo}/pulls/comments": {
    get: operations["pulls/list-review-comments-for-repo"];
  };
  "/repos/{owner}/{repo}/pulls/comments/{comment_id}": {
    get: operations["pulls/get-review-comment"];
    patch: operations["pulls/update-review-comment"];
    delete: operations["pulls/delete-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions": {
    get: operations["reactions/list-for-pull-request-review-comment"];
    post: operations["reactions/create-for-pull-request-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/comments/{comment_id}/reactions/{reaction_id}": {
    delete: operations["reactions/delete-for-pull-request-comment"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}": {
    get: operations["pulls/get"];
    patch: operations["pulls/update"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/comments": {
    get: operations["pulls/list-review-comments"];
    post: operations["pulls/create-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/comments/{comment_id}/replies": {
    post: operations["pulls/create-reply-for-review-comment"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/commits": {
    get: operations["pulls/list-commits"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/files": {
    get: operations["pulls/list-files"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/merge": {
    get: operations["pulls/check-if-merged"];
    put: operations["pulls/merge"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/requested_reviewers": {
    get: operations["pulls/list-requested-reviewers"];
    post: operations["pulls/request-reviewers"];
    delete: operations["pulls/remove-requested-reviewers"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews": {
    get: operations["pulls/list-reviews"];
    post: operations["pulls/create-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}": {
    get: operations["pulls/get-review"];
    put: operations["pulls/update-review"];
    delete: operations["pulls/delete-pending-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/comments": {
    get: operations["pulls/list-comments-for-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/dismissals": {
    put: operations["pulls/dismiss-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/reviews/{review_id}/events": {
    post: operations["pulls/submit-review"];
  };
  "/repos/{owner}/{repo}/pulls/{pull_number}/update-branch": {
    put: operations["pulls/update-branch"];
  };
  "/repos/{owner}/{repo}/readme": {
    get: operations["repos/get-readme"];
  };
  "/repos/{owner}/{repo}/releases": {
    get: operations["repos/list-releases"];
    post: operations["repos/create-release"];
  };
  "/repos/{owner}/{repo}/releases/assets/{asset_id}": {
    get: operations["repos/get-release-asset"];
    patch: operations["repos/update-release-asset"];
    delete: operations["repos/delete-release-asset"];
  };
  "/repos/{owner}/{repo}/releases/latest": {
    get: operations["repos/get-latest-release"];
  };
  "/repos/{owner}/{repo}/releases/tags/{tag}": {
    get: operations["repos/get-release-by-tag"];
  };
  "/repos/{owner}/{repo}/releases/{release_id}": {
    get: operations["repos/get-release"];
    patch: operations["repos/update-release"];
    delete: operations["repos/delete-release"];
  };
  "/repos/{owner}/{repo}/releases/{release_id}/assets": {
    get: operations["repos/list-release-assets"];
    post: operations["repos/upload-release-asset"];
  };
  "/repos/{owner}/{repo}/secret-scanning/alerts": {
    get: operations["secret-scanning/list-alerts-for-repo"];
  };
  "/repos/{owner}/{repo}/secret-scanning/alerts/{alert_number}": {
    get: operations["secret-scanning/get-alert"];
    patch: operations["secret-scanning/update-alert"];
  };
  "/repos/{owner}/{repo}/stargazers": {
    get: operations["activity/list-stargazers-for-repo"];
  };
  "/repos/{owner}/{repo}/stats/code_frequency": {
    get: operations["repos/get-code-frequency-stats"];
  };
  "/repos/{owner}/{repo}/stats/commit_activity": {
    get: operations["repos/get-commit-activity-stats"];
  };
  "/repos/{owner}/{repo}/stats/contributors": {
    get: operations["repos/get-contributors-stats"];
  };
  "/repos/{owner}/{repo}/stats/participation": {
    get: operations["repos/get-participation-stats"];
  };
  "/repos/{owner}/{repo}/stats/punch_card": {
    get: operations["repos/get-punch-card-stats"];
  };
  "/repos/{owner}/{repo}/statuses/{sha}": {
    post: operations["repos/create-commit-status"];
  };
  "/repos/{owner}/{repo}/subscribers": {
    get: operations["activity/list-watchers-for-repo"];
  };
  "/repos/{owner}/{repo}/subscription": {
    get: operations["activity/get-repo-subscription"];
    put: operations["activity/set-repo-subscription"];
    delete: operations["activity/delete-repo-subscription"];
  };
  "/repos/{owner}/{repo}/tags": {
    get: operations["repos/list-tags"];
  };
  "/repos/{owner}/{repo}/tarball/{ref}": {
    get: operations["repos/download-tarball-archive"];
  };
  "/repos/{owner}/{repo}/teams": {
    get: operations["repos/list-teams"];
  };
  "/repos/{owner}/{repo}/topics": {
    get: operations["repos/get-all-topics"];
    put: operations["repos/replace-all-topics"];
  };
  "/repos/{owner}/{repo}/traffic/clones": {
    get: operations["repos/get-clones"];
  };
  "/repos/{owner}/{repo}/traffic/popular/paths": {
    get: operations["repos/get-top-paths"];
  };
  "/repos/{owner}/{repo}/traffic/popular/referrers": {
    get: operations["repos/get-top-referrers"];
  };
  "/repos/{owner}/{repo}/traffic/views": {
    get: operations["repos/get-views"];
  };
  "/repos/{owner}/{repo}/transfer": {
    post: operations["repos/transfer"];
  };
  "/repos/{owner}/{repo}/vulnerability-alerts": {
    get: operations["repos/check-vulnerability-alerts"];
    put: operations["repos/enable-vulnerability-alerts"];
    delete: operations["repos/disable-vulnerability-alerts"];
  };
  "/repos/{owner}/{repo}/zipball/{ref}": {
    get: operations["repos/download-zipball-archive"];
  };
  "/repos/{template_owner}/{template_repo}/generate": {
    post: operations["repos/create-using-template"];
  };
  "/repositories": {
    get: operations["repos/list-public"];
  };
  "/scim/v2/enterprises/{enterprise}/Groups": {
    get: operations["enterprise-admin/list-provisioned-groups-enterprise"];
    post: operations["enterprise-admin/provision-and-invite-enterprise-group"];
  };
  "/scim/v2/enterprises/{enterprise}/Groups/{scim_group_id}": {
    get: operations["enterprise-admin/get-provisioning-information-for-enterprise-group"];
    put: operations["enterprise-admin/set-information-for-provisioned-enterprise-group"];
    patch: operations["enterprise-admin/update-attribute-for-enterprise-group"];
    delete: operations["enterprise-admin/delete-scim-group-from-enterprise"];
  };
  "/scim/v2/enterprises/{enterprise}/Users": {
    get: operations["enterprise-admin/list-provisioned-identities-enterprise"];
    post: operations["enterprise-admin/provision-and-invite-enterprise-user"];
  };
  "/scim/v2/enterprises/{enterprise}/Users/{scim_user_id}": {
    get: operations["enterprise-admin/get-provisioning-information-for-enterprise-user"];
    put: operations["enterprise-admin/set-information-for-provisioned-enterprise-user"];
    patch: operations["enterprise-admin/update-attribute-for-enterprise-user"];
    delete: operations["enterprise-admin/delete-user-from-enterprise"];
  };
  "/scim/v2/organizations/{org}/Users": {
    get: operations["scim/list-provisioned-identities"];
    post: operations["scim/provision-and-invite-user"];
  };
  "/scim/v2/organizations/{org}/Users/{scim_user_id}": {
    get: operations["scim/get-provisioning-information-for-user"];
    put: operations["scim/set-information-for-provisioned-user"];
    patch: operations["scim/update-attribute-for-user"];
    delete: operations["scim/delete-user-from-org"];
  };
  "/search/code": {
    get: operations["search/code"];
  };
  "/search/commits": {
    get: operations["search/commits"];
  };
  "/search/issues": {
    get: operations["search/issues-and-pull-requests"];
  };
  "/search/labels": {
    get: operations["search/labels"];
  };
  "/search/repositories": {
    get: operations["search/repos"];
  };
  "/search/topics": {
    get: operations["search/topics"];
  };
  "/search/users": {
    get: operations["search/users"];
  };
  "/teams/{team_id}": {
    get: operations["teams/get-legacy"];
    patch: operations["teams/update-legacy"];
    delete: operations["teams/delete-legacy"];
  };
  "/teams/{team_id}/discussions": {
    get: operations["teams/list-discussions-legacy"];
    post: operations["teams/create-discussion-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}": {
    get: operations["teams/get-discussion-legacy"];
    patch: operations["teams/update-discussion-legacy"];
    delete: operations["teams/delete-discussion-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/comments": {
    get: operations["teams/list-discussion-comments-legacy"];
    post: operations["teams/create-discussion-comment-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}": {
    get: operations["teams/get-discussion-comment-legacy"];
    patch: operations["teams/update-discussion-comment-legacy"];
    delete: operations["teams/delete-discussion-comment-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/comments/{comment_number}/reactions": {
    get: operations["reactions/list-for-team-discussion-comment-legacy"];
    post: operations["reactions/create-for-team-discussion-comment-legacy"];
  };
  "/teams/{team_id}/discussions/{discussion_number}/reactions": {
    get: operations["reactions/list-for-team-discussion-legacy"];
    post: operations["reactions/create-for-team-discussion-legacy"];
  };
  "/teams/{team_id}/invitations": {
    get: operations["teams/list-pending-invitations-legacy"];
  };
  "/teams/{team_id}/members": {
    get: operations["teams/list-members-legacy"];
  };
  "/teams/{team_id}/members/{username}": {
    get: operations["teams/get-member-legacy"];
    put: operations["teams/add-member-legacy"];
    delete: operations["teams/remove-member-legacy"];
  };
  "/teams/{team_id}/memberships/{username}": {
    get: operations["teams/get-membership-for-user-legacy"];
    put: operations["teams/add-or-update-membership-for-user-legacy"];
    delete: operations["teams/remove-membership-for-user-legacy"];
  };
  "/teams/{team_id}/projects": {
    get: operations["teams/list-projects-legacy"];
  };
  "/teams/{team_id}/projects/{project_id}": {
    get: operations["teams/check-permissions-for-project-legacy"];
    put: operations["teams/add-or-update-project-permissions-legacy"];
    delete: operations["teams/remove-project-legacy"];
  };
  "/teams/{team_id}/repos": {
    get: operations["teams/list-repos-legacy"];
  };
  "/teams/{team_id}/repos/{owner}/{repo}": {
    get: operations["teams/check-permissions-for-repo-legacy"];
    put: operations["teams/add-or-update-repo-permissions-legacy"];
    delete: operations["teams/remove-repo-legacy"];
  };
  "/teams/{team_id}/team-sync/group-mappings": {
    get: operations["teams/list-idp-groups-for-legacy"];
    patch: operations["teams/create-or-update-idp-group-connections-legacy"];
  };
  "/teams/{team_id}/teams": {
    get: operations["teams/list-child-legacy"];
  };
  "/user": {
    get: operations["users/get-authenticated"];
    patch: operations["users/update-authenticated"];
  };
  "/user/blocks": {
    get: operations["users/list-blocked-by-authenticated"];
  };
  "/user/blocks/{username}": {
    get: operations["users/check-blocked"];
    put: operations["users/block"];
    delete: operations["users/unblock"];
  };
  "/user/email/visibility": {
    patch: operations["users/set-primary-email-visibility-for-authenticated"];
  };
  "/user/emails": {
    get: operations["users/list-emails-for-authenticated"];
    post: operations["users/add-email-for-authenticated"];
    delete: operations["users/delete-email-for-authenticated"];
  };
  "/user/followers": {
    get: operations["users/list-followers-for-authenticated-user"];
  };
  "/user/following": {
    get: operations["users/list-followed-by-authenticated"];
  };
  "/user/following/{username}": {
    get: operations["users/check-person-is-followed-by-authenticated"];
    put: operations["users/follow"];
    delete: operations["users/unfollow"];
  };
  "/user/gpg_keys": {
    get: operations["users/list-gpg-keys-for-authenticated"];
    post: operations["users/create-gpg-key-for-authenticated"];
  };
  "/user/gpg_keys/{gpg_key_id}": {
    get: operations["users/get-gpg-key-for-authenticated"];
    delete: operations["users/delete-gpg-key-for-authenticated"];
  };
  "/user/installations": {
    get: operations["apps/list-installations-for-authenticated-user"];
  };
  "/user/installations/{installation_id}/repositories": {
    get: operations["apps/list-installation-repos-for-authenticated-user"];
  };
  "/user/installations/{installation_id}/repositories/{repository_id}": {
    put: operations["apps/add-repo-to-installation"];
    delete: operations["apps/remove-repo-from-installation"];
  };
  "/user/interaction-limits": {
    get: operations["interactions/get-restrictions-for-your-public-repos"];
    put: operations["interactions/set-restrictions-for-your-public-repos"];
    delete: operations["interactions/remove-restrictions-for-your-public-repos"];
  };
  "/user/issues": {
    get: operations["issues/list-for-authenticated-user"];
  };
  "/user/keys": {
    get: operations["users/list-public-ssh-keys-for-authenticated"];
    post: operations["users/create-public-ssh-key-for-authenticated"];
  };
  "/user/keys/{key_id}": {
    get: operations["users/get-public-ssh-key-for-authenticated"];
    delete: operations["users/delete-public-ssh-key-for-authenticated"];
  };
  "/user/marketplace_purchases": {
    get: operations["apps/list-subscriptions-for-authenticated-user"];
  };
  "/user/marketplace_purchases/stubbed": {
    get: operations["apps/list-subscriptions-for-authenticated-user-stubbed"];
  };
  "/user/memberships/orgs": {
    get: operations["orgs/list-memberships-for-authenticated-user"];
  };
  "/user/memberships/orgs/{org}": {
    get: operations["orgs/get-membership-for-authenticated-user"];
    patch: operations["orgs/update-membership-for-authenticated-user"];
  };
  "/user/migrations": {
    get: operations["migrations/list-for-authenticated-user"];
    post: operations["migrations/start-for-authenticated-user"];
  };
  "/user/migrations/{migration_id}": {
    get: operations["migrations/get-status-for-authenticated-user"];
  };
  "/user/migrations/{migration_id}/archive": {
    get: operations["migrations/get-archive-for-authenticated-user"];
    delete: operations["migrations/delete-archive-for-authenticated-user"];
  };
  "/user/migrations/{migration_id}/repos/{repo_name}/lock": {
    delete: operations["migrations/unlock-repo-for-authenticated-user"];
  };
  "/user/migrations/{migration_id}/repositories": {
    get: operations["migrations/list-repos-for-user"];
  };
  "/user/orgs": {
    get: operations["orgs/list-for-authenticated-user"];
  };
  "/user/projects": {
    post: operations["projects/create-for-authenticated-user"];
  };
  "/user/public_emails": {
    get: operations["users/list-public-emails-for-authenticated"];
  };
  "/user/repos": {
    get: operations["repos/list-for-authenticated-user"];
    post: operations["repos/create-for-authenticated-user"];
  };
  "/user/repository_invitations": {
    get: operations["repos/list-invitations-for-authenticated-user"];
  };
  "/user/repository_invitations/{invitation_id}": {
    patch: operations["repos/accept-invitation"];
    delete: operations["repos/decline-invitation"];
  };
  "/user/starred": {
    get: operations["activity/list-repos-starred-by-authenticated-user"];
  };
  "/user/starred/{owner}/{repo}": {
    get: operations["activity/check-repo-is-starred-by-authenticated-user"];
    put: operations["activity/star-repo-for-authenticated-user"];
    delete: operations["activity/unstar-repo-for-authenticated-user"];
  };
  "/user/subscriptions": {
    get: operations["activity/list-watched-repos-for-authenticated-user"];
  };
  "/user/teams": {
    get: operations["teams/list-for-authenticated-user"];
  };
  "/users": {
    get: operations["users/list"];
  };
  "/users/{username}": {
    get: operations["users/get-by-username"];
  };
  "/users/{username}/events": {
    get: operations["activity/list-events-for-authenticated-user"];
  };
  "/users/{username}/events/orgs/{org}": {
    get: operations["activity/list-org-events-for-authenticated-user"];
  };
  "/users/{username}/events/public": {
    get: operations["activity/list-public-events-for-user"];
  };
  "/users/{username}/followers": {
    get: operations["users/list-followers-for-user"];
  };
  "/users/{username}/following": {
    get: operations["users/list-following-for-user"];
  };
  "/users/{username}/following/{target_user}": {
    get: operations["users/check-following-for-user"];
  };
  "/users/{username}/gists": {
    get: operations["gists/list-for-user"];
  };
  "/users/{username}/gpg_keys": {
    get: operations["users/list-gpg-keys-for-user"];
  };
  "/users/{username}/hovercard": {
    get: operations["users/get-context-for-user"];
  };
  "/users/{username}/installation": {
    get: operations["apps/get-user-installation"];
  };
  "/users/{username}/keys": {
    get: operations["users/list-public-keys-for-user"];
  };
  "/users/{username}/orgs": {
    get: operations["orgs/list-for-user"];
  };
  "/users/{username}/projects": {
    get: operations["projects/list-for-user"];
  };
  "/users/{username}/received_events": {
    get: operations["activity/list-received-events-for-user"];
  };
  "/users/{username}/received_events/public": {
    get: operations["activity/list-received-public-events-for-user"];
  };
  "/users/{username}/repos": {
    get: operations["repos/list-for-user"];
  };
  "/users/{username}/settings/billing/actions": {
    get: operations["billing/get-github-actions-billing-user"];
  };
  "/users/{username}/settings/billing/packages": {
    get: operations["billing/get-github-packages-billing-user"];
  };
  "/users/{username}/settings/billing/shared-storage": {
    get: operations["billing/get-shared-storage-billing-user"];
  };
  "/users/{username}/starred": {
    get: operations["activity/list-repos-starred-by-user"];
  };
  "/users/{username}/subscriptions": {
    get: operations["activity/list-repos-watched-by-user"];
  };
  "/zen": {
    get: operations["meta/get-zen"];
  };
}

export interface operations {
  /**
   * Get Hypermedia links to resources accessible in GitHub's REST API
   */
  "meta/root": {
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          current_user_url: string;
          current_user_authorizations_html_url: string;
          authorizations_url: string;
          code_search_url: string;
          commit_search_url: string;
          emails_url: string;
          emojis_url: string;
          events_url: string;
          feeds_url: string;
          followers_url: string;
          following_url: string;
          gists_url: string;
          hub_url: string;
          issue_search_url: string;
          issues_url: string;
          keys_url: string;
          label_search_url: string;
          notifications_url: string;
          organization_url: string;
          organization_repositories_url: string;
          organization_teams_url: string;
          public_gists_url: string;
          rate_limit_url: string;
          repository_url: string;
          repository_search_url: string;
          current_user_repositories_url: string;
          starred_url: string;
          starred_gists_url: string;
          topic_search_url?: string;
          user_url: string;
          user_organizations_url: string;
          user_repositories_url: string;
          user_search_url: string;
        };
      };
    };
  };
  /**
   * Returns the GitHub App associated with the authentication credentials used. To see how many app installations are associated with this GitHub App, see the `installations_count` in the response. For more details about your app's installations, see the "[List installations for the authenticated app](https://docs.github.com/rest/reference/apps#list-installations-for-the-authenticated-app)" endpoint.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-authenticated": {
    parameters: {};
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["integration"];
      };
    };
  };
  /**
   * Use this endpoint to complete the handshake necessary when implementing the [GitHub App Manifest flow](https://docs.github.com/apps/building-github-apps/creating-github-apps-from-a-manifest/). When you create a GitHub App with the manifest flow, you receive a temporary `code` used to retrieve the GitHub App's `id`, `pem` (private key), and `webhook_secret`.
   */
  "apps/create-from-manifest": {
    parameters: {
      path: {
        code: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["integration"] &
          ({
            client_id: string;
            client_secret: string;
            webhook_secret: string;
            pem: string;
          } & { [key: string]: any });
      };
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Returns the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-webhook-config-for-app": {
    responses: {
      /**
       * Default response
       */
      "200": {
        "application/json": components["schemas"]["webhook-config"];
      };
    };
  };
  /**
   * Updates the webhook configuration for a GitHub App. For more information about configuring a webhook for your app, see "[Creating a GitHub App](/developers/apps/creating-a-github-app)."
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/update-webhook-config-for-app": {
    requestBody: {
      "application/json": {
        url?: components["schemas"]["webhook-config-url"];
        content_type?: components["schemas"]["webhook-config-content-type"];
        secret?: components["schemas"]["webhook-config-secret"];
        insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
      };
    };
    responses: {
      /**
       * Default response
       */
      "200": {
        "application/json": components["schemas"]["webhook-config"];
      };
    };
  };
  /**
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   *
   * The permissions the installation has are included under the `permissions` key.
   */
  "apps/list-installations": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
        since?: components["parameters"]["since"];
        outdated?: string;
      };
    };
    responses: {
      /**
       * The permissions the installation has are included under the `permissions` key.
       */
      "200": {
        "application/json": components["schemas"]["installation"][];
      };
    };
  };
  /**
   * Enables an authenticated GitHub App to find an installation's information using the installation id. The installation's account type (`target_type`) will be either an organization or a user account, depending which account the repository belongs to.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-installation": {
    parameters: {
      path: {
        installation_id: components["parameters"]["installation_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["installation"];
      };
      "404": unknown;
      "415": unknown;
    };
  };
  /**
   * Uninstalls a GitHub App on a user, organization, or business account. If you prefer to temporarily suspend an app's access to your account's resources, then we recommend the "[Suspend an app installation](https://docs.github.com/v3/apps/#suspend-an-app-installation)" endpoint.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/delete-installation": {
    parameters: {
      path: {
        installation_id: components["parameters"]["installation_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
    };
  };
  /**
   * Creates an installation access token that enables a GitHub App to make authenticated API requests for the app's installation on an organization or individual account. Installation tokens expire one hour from the time you create them. Using an expired token produces a status code of `401 - Unauthorized`, and requires creating a new installation token. By default the installation token has access to all repositories that the installation can access. To restrict the access to specific repositories, you can provide the `repository_ids` when creating the token. When you omit `repository_ids`, the response does not contain the `repositories` key.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/create-installation-access-token": {
    parameters: {
      path: {
        installation_id: components["parameters"]["installation_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * List of repository names that the token should have access to
         */
        repositories?: string[];
        /**
         * List of repository IDs that the token should have access to
         */
        repository_ids?: number[];
        permissions?: {
          contents?: string;
          issues?: string;
          deployments?: string;
          single_file?: string;
          def_not_a_repo?: string;
        };
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["installation-token"];
      };
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * **Note:** Suspending a GitHub App installation is currently in beta and subject to change. Before you can suspend a GitHub App, the app owner must enable suspending installations for the app by opting-in to the beta. For more information, see "[Suspending a GitHub App installation](https://docs.github.com/apps/managing-github-apps/suspending-a-github-app-installation/)."
   *
   * Suspends a GitHub App on a user, organization, or business account, which blocks the app from accessing the account's resources. When a GitHub App is suspended, the app's access to the GitHub API or webhook events is blocked for that account.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/suspend-installation": {
    parameters: {
      path: {
        installation_id: components["parameters"]["installation_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
    };
  };
  /**
   * **Note:** Suspending a GitHub App installation is currently in beta and subject to change. Before you can suspend a GitHub App, the app owner must enable suspending installations for the app by opting-in to the beta. For more information, see "[Suspending a GitHub App installation](https://docs.github.com/apps/managing-github-apps/suspending-a-github-app-installation/)."
   *
   * Removes a GitHub App installation suspension.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/unsuspend-installation": {
    parameters: {
      path: {
        installation_id: components["parameters"]["installation_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * You can use this API to list the set of OAuth applications that have been granted access to your account. Unlike the [list your authorizations](https://docs.github.com/rest/reference/oauth-authorizations#list-your-authorizations) API, this API does not manage individual tokens. This API will return one entry for each OAuth application that has been granted access to your account, regardless of the number of tokens an application has generated for your user. The list of OAuth applications returned matches what is shown on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized). The `scopes` returned are the union of scopes authorized for the application. For example, if an application has one token with `repo` scope and another token with `user` scope, the grant will return `["repo", "user"]`.
   */
  "oauth-authorizations/list-grants": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["application-grant"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   */
  "oauth-authorizations/get-grant": {
    parameters: {
      path: {
        grant_id: components["parameters"]["grant_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["application-grant"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for your user. Once deleted, the application has no access to your account and is no longer listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
   */
  "oauth-authorizations/delete-grant": {
    parameters: {
      path: {
        grant_id: components["parameters"]["grant_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  /**
   * OAuth application owners can revoke a grant for their OAuth application and a specific user. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. You must also provide a valid OAuth `access_token` as an input parameter and the grant for the token's owner will be deleted.
   * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the application authorizations settings screen within GitHub](https://github.com/settings/applications#authorized).
   */
  "apps/delete-authorization": {
    parameters: {
      path: {
        client_id: components["parameters"]["client-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The OAuth access token used to authenticate to the GitHub API.
         */
        access_token?: string;
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "422": unknown;
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue OAuth endpoints that contain `access_token` in the path parameter. We have introduced new endpoints that allow you to securely manage tokens for OAuth Apps by moving `access_token` to the request body. For more information, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-app-endpoint/).
   *
   * OAuth application owners can revoke a grant for their OAuth application and a specific user. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. You must also provide a valid token as `:access_token` and the grant for the token's owner will be deleted.
   *
   * Deleting an OAuth application's grant will also delete all OAuth tokens associated with the application for the user. Once deleted, the application will have no access to the user's account and will no longer be listed on [the Applications settings page under "Authorized OAuth Apps" on GitHub](https://github.com/settings/applications#authorized).
   */
  "apps/revoke-grant-for-application": {
    parameters: {
      path: {
        client_id: components["parameters"]["client-id"];
        access_token: components["parameters"]["access-token"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * OAuth applications can use a special API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) to use this endpoint, where the username is the OAuth application `client_id` and the password is its `client_secret`. Invalid tokens will return `404 NOT FOUND`.
   */
  "apps/check-token": {
    parameters: {
      path: {
        client_id: components["parameters"]["client-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The access_token of the OAuth application.
         */
        access_token: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["authorization"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * OAuth applications can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
   */
  "apps/reset-token": {
    parameters: {
      path: {
        client_id: components["parameters"]["client-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The access_token of the OAuth application.
         */
        access_token: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["authorization"];
      };
      "422": unknown;
    };
  };
  /**
   * OAuth application owners can revoke a single token for an OAuth application. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password.
   */
  "apps/delete-token": {
    parameters: {
      path: {
        client_id: components["parameters"]["client-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The OAuth access token used to authenticate to the GitHub API.
         */
        access_token?: string;
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "422": unknown;
    };
  };
  /**
   * Exchanges a non-repository scoped user-to-server OAuth access token for a repository scoped user-to-server OAuth access token. You can specify which repositories the token can access and which permissions are granted to the token. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
   */
  "apps/scope-token": {
    parameters: {
      path: {
        client_id: components["parameters"]["client-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * **Required.** The OAuth access token used to authenticate to the GitHub API.
         */
        access_token?: string;
        /**
         * The name of the user or organization to scope the user-to-server access token to. **Required** unless `target_id` is specified.
         */
        target?: string;
        /**
         * The ID of the user or organization to scope the user-to-server access token to. **Required** unless `target` is specified.
         */
        target_id?: number;
        /**
         * The list of repository IDs to scope the user-to-server access token to. `repositories` may not be specified if `repository_ids` is specified.
         */
        repositories?: string[];
        /**
         * The list of repository names to scope the user-to-server access token to. `repository_ids` may not be specified if `repositories` is specified.
         */
        repository_ids?: number[];
        permissions?: components["schemas"]["app-permissions"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["authorization"];
      };
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue OAuth endpoints that contain `access_token` in the path parameter. We have introduced new endpoints that allow you to securely manage tokens for OAuth Apps by moving `access_token` to the request body. For more information, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-app-endpoint/).
   *
   * OAuth applications can use a special API method for checking OAuth token validity without exceeding the normal rate limits for failed login attempts. Authentication works differently with this particular endpoint. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
   */
  "apps/check-authorization": {
    parameters: {
      path: {
        client_id: components["parameters"]["client-id"];
        access_token: components["parameters"]["access-token"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["authorization"];
      };
      "404": unknown;
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue OAuth endpoints that contain `access_token` in the path parameter. We have introduced new endpoints that allow you to securely manage tokens for OAuth Apps by moving `access_token` to the request body. For more information, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-app-endpoint/).
   *
   * OAuth applications can use this API method to reset a valid OAuth token without end-user involvement. Applications must save the "token" property in the response because changes take effect immediately. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password. Invalid tokens will return `404 NOT FOUND`.
   */
  "apps/reset-authorization": {
    parameters: {
      path: {
        client_id: components["parameters"]["client-id"];
        access_token: components["parameters"]["access-token"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["authorization"];
      };
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue OAuth endpoints that contain `access_token` in the path parameter. We have introduced new endpoints that allow you to securely manage tokens for OAuth Apps by moving `access_token` to the request body. For more information, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-app-endpoint/).
   *
   * OAuth application owners can revoke a single token for an OAuth application. You must use [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) when accessing this endpoint, using the OAuth application's `client_id` and `client_secret` as the username and password.
   */
  "apps/revoke-authorization-for-application": {
    parameters: {
      path: {
        client_id: components["parameters"]["client-id"];
        access_token: components["parameters"]["access-token"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * **Note**: The `:app_slug` is just the URL-friendly name of your GitHub App. You can find this on the settings page for your GitHub App (e.g., `https://github.com/settings/apps/:app_slug`).
   *
   * If the GitHub App you specify is public, you can access this endpoint without authenticating. If the GitHub App you specify is private, you must authenticate with a [personal access token](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line/) or an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
   */
  "apps/get-by-slug": {
    parameters: {
      path: {
        app_slug: components["parameters"]["app_slug"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["integration"];
      };
      "403": unknown;
      "404": unknown;
      "415": unknown;
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   */
  "oauth-authorizations/list-authorizations": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["authorization"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * **Warning:** Apps must use the [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
   *
   * Creates OAuth tokens using [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication). If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
   *
   * To create tokens for a particular OAuth application using this endpoint, you must authenticate as the user you want to create an authorization for and provide the app's client ID and secret, found on your OAuth application's settings page. If your OAuth application intends to create multiple tokens for one user, use `fingerprint` to differentiate between them.
   *
   * You can also create tokens on GitHub from the [personal access tokens settings](https://github.com/settings/tokens) page. Read more about these tokens in [the GitHub Help documentation](https://help.github.com/articles/creating-an-access-token-for-command-line-use).
   *
   * Organizations that enforce SAML SSO require personal access tokens to be allowed. Read more about allowing tokens in [the GitHub Help documentation](https://help.github.com/articles/about-identity-and-access-management-with-saml-single-sign-on).
   */
  "oauth-authorizations/create-authorization": {
    parameters: {};
    requestBody: {
      "application/json": {
        /**
         * A list of scopes that this authorization is in.
         */
        scopes?: string[] | null;
        /**
         * A note to remind you what the OAuth token is for.
         */
        note?: string;
        /**
         * A URL to remind you what app the OAuth token is for.
         */
        note_url?: string;
        /**
         * The OAuth app client key for which to create the token.
         */
        client_id?: string;
        /**
         * The OAuth app client secret for which to create the token.
         */
        client_secret?: string;
        /**
         * A unique string to distinguish an authorization from others created for the same client ID and user.
         */
        fingerprint?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["authorization"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "410": unknown;
      "422": unknown;
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * **Warning:** Apps must use the [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
   *
   * Creates a new authorization for the specified OAuth application, only if an authorization for that application doesn't already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
   *
   * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
   *
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   */
  "oauth-authorizations/get-or-create-authorization-for-app": {
    parameters: {
      path: {
        client_id: components["parameters"]["client-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The OAuth app client secret for which to create the token.
         */
        client_secret: string;
        /**
         * A list of scopes that this authorization is in.
         */
        scopes?: string[] | null;
        /**
         * A note to remind you what the OAuth token is for.
         */
        note?: string;
        /**
         * A URL to remind you what app the OAuth token is for.
         */
        note_url?: string;
        /**
         * A unique string to distinguish an authorization from others created for the same client ID and user.
         */
        fingerprint?: string;
      };
    };
    responses: {
      /**
       * Response if returning an existing token
       */
      "200": {
        "application/json": components["schemas"]["authorization"];
      };
      /**
       * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
       */
      "201": {
        "application/json": components["schemas"]["authorization"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * **Warning:** Apps must use the [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow) to obtain OAuth tokens that work with GitHub SAML organizations. OAuth tokens created using the Authorizations API will be unable to access GitHub SAML organizations. For more information, see the [blog post](https://developer.github.com/changes/2019-11-05-deprecated-passwords-and-authorizations-api).
   *
   * This method will create a new authorization for the specified OAuth application, only if an authorization for that application and fingerprint do not already exist for the user. The URL includes the 20 character client ID for the OAuth app that is requesting the token. `fingerprint` is a unique string to distinguish an authorization from others created for the same client ID and user. It returns the user's existing authorization for the application if one is present. Otherwise, it creates and returns a new one.
   *
   * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
   */
  "oauth-authorizations/get-or-create-authorization-for-app-and-fingerprint": {
    parameters: {
      path: {
        client_id: components["parameters"]["client-id"];
        fingerprint: string;
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The OAuth app client secret for which to create the token.
         */
        client_secret: string;
        /**
         * A list of scopes that this authorization is in.
         */
        scopes?: string[] | null;
        /**
         * A note to remind you what the OAuth token is for.
         */
        note?: string;
        /**
         * A URL to remind you what app the OAuth token is for.
         */
        note_url?: string;
      };
    };
    responses: {
      /**
       * Response if returning an existing token
       */
      "200": {
        "application/json": components["schemas"]["authorization"];
      };
      /**
       * Response if returning a new token
       */
      "201": {
        "application/json": components["schemas"]["authorization"];
      };
      "422": unknown;
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   */
  "oauth-authorizations/get-authorization": {
    parameters: {
      path: {
        authorization_id: components["parameters"]["authorization_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["authorization"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations/), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/developers/apps/authorizing-oauth-apps#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   *
   * If you have two-factor authentication setup, Basic Authentication for this endpoint requires that you use a one-time password (OTP) and your username and password instead of tokens. For more information, see "[Working with two-factor authentication](https://docs.github.com/rest/overview/other-authentication-methods#working-with-two-factor-authentication)."
   *
   * You can only send one of these scope keys at a time.
   */
  "oauth-authorizations/update-authorization": {
    parameters: {
      path: {
        authorization_id: components["parameters"]["authorization_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * A list of scopes that this authorization is in.
         */
        scopes?: string[] | null;
        /**
         * A list of scopes to add to this authorization.
         */
        add_scopes?: string[];
        /**
         * A list of scopes to remove from this authorization.
         */
        remove_scopes?: string[];
        /**
         * A note to remind you what the OAuth token is for.
         */
        note?: string;
        /**
         * A URL to remind you what app the OAuth token is for.
         */
        note_url?: string;
        /**
         * A unique string to distinguish an authorization from others created for the same client ID and user.
         */
        fingerprint?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["authorization"];
      };
      "422": unknown;
    };
  };
  /**
   * **Deprecation Notice:** GitHub will discontinue the [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations), which is used by integrations to create personal access tokens and OAuth tokens, and you must now create these tokens using our [web application flow](https://docs.github.com/apps/building-oauth-apps/authorizing-oauth-apps/#web-application-flow). The [OAuth Authorizations API](https://docs.github.com/rest/reference/oauth-authorizations) will be removed on November, 13, 2020. For more information, including scheduled brownouts, see the [blog post](https://developer.github.com/changes/2020-02-14-deprecating-oauth-auth-endpoint/).
   */
  "oauth-authorizations/delete-authorization": {
    parameters: {
      path: {
        authorization_id: components["parameters"]["authorization_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  "codes-of-conduct/get-all-codes-of-conduct": {
    parameters: {};
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["code-of-conduct"][];
      };
      "304": never;
      "415": unknown;
    };
  };
  "codes-of-conduct/get-conduct-code": {
    parameters: {
      path: {
        key: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["code-of-conduct"];
      };
      "304": never;
      "404": unknown;
      "415": unknown;
    };
  };
  /**
   * Creates an attachment under a content reference URL in the body or comment of an issue or pull request. Use the `id` of the content reference from the [`content_reference` event](https://docs.github.com/webhooks/event-payloads/#content_reference) to create an attachment.
   *
   * The app must create a content attachment within six hours of the content reference URL being posted. See "[Using content attachments](https://docs.github.com/apps/using-content-attachments/)" for details about content attachments.
   *
   * You must use an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
   */
  "apps/create-content-attachment": {
    parameters: {
      path: {
        content_reference_id: number;
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The title of the attachment
         */
        title: string;
        /**
         * The body of the attachment
         */
        body: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["content-reference-attachment"];
      };
      "304": never;
      "403": unknown;
      "404": unknown;
      "410": unknown;
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * Lists all the emojis available to use on GitHub.
   */
  "emojis/get": {
    parameters: {};
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": { [key: string]: string };
      };
      "304": never;
    };
  };
  /**
   * Gets the GitHub Actions permissions policy for organizations and allowed actions in an enterprise.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/get-github-actions-permissions-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["actions-enterprise-permissions"];
      };
    };
  };
  /**
   * Sets the GitHub Actions permissions policy for organizations and allowed actions in an enterprise.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-github-actions-permissions-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
    };
    requestBody: {
      "application/json": {
        enabled_organizations: components["schemas"]["enabled-organizations"];
        allowed_actions?: components["schemas"]["allowed-actions"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists the organizations that are selected to have GitHub Actions enabled in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-selected-organizations-enabled-github-actions-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          organizations: components["schemas"]["organization-simple"][];
        };
      };
    };
  };
  /**
   * Replaces the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-selected-organizations-enabled-github-actions-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * List of organization IDs to enable for GitHub Actions.
         */
        selected_organization_ids: number[];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Adds an organization to the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/enable-selected-organization-github-actions-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        org_id: components["parameters"]["org_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Removes an organization from the list of selected organizations that are enabled for GitHub Actions in an enterprise. To use this endpoint, the enterprise permission policy for `enabled_organizations` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/disable-selected-organization-github-actions-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        org_id: components["parameters"]["org_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Gets the selected actions that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/get-allowed-actions-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["selected-actions"];
      };
    };
  };
  /**
   * Sets the actions that are allowed in an enterprise. To use this endpoint, the enterprise permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an enterprise](#set-github-actions-permissions-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-allowed-actions-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
    };
    requestBody: {
      "application/json": components["schemas"]["selected-actions"];
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists all self-hosted runner groups for an enterprise.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-self-hosted-runner-groups-for-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          runner_groups: components["schemas"]["runner-groups-enterprise"][];
        };
      };
    };
  };
  /**
   * Creates a new self-hosted runner group for an enterprise.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/create-self-hosted-runner-group-for-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Name of the runner group.
         */
        name: string;
        /**
         * Visibility of a runner group. You can select all organizations or select individual organization. Can be one of: `all` or `selected`
         */
        visibility?: "selected" | "all";
        /**
         * List of organization IDs that can access the runner group.
         */
        selected_organization_ids?: number[];
        /**
         * List of runner IDs to add to the runner group.
         */
        runners?: number[];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["runner-groups-enterprise"];
      };
    };
  };
  /**
   * Gets a specific self-hosted runner group for an enterprise.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/get-self-hosted-runner-group-for-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        runner_group_id: components["parameters"]["runner_group_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["runner-groups-enterprise"];
      };
    };
  };
  /**
   * Updates the `name` and `visibility` of a self-hosted runner group in an enterprise.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/update-self-hosted-runner-group-for-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        runner_group_id: components["parameters"]["runner_group_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Name of the runner group.
         */
        name?: string;
        /**
         * Visibility of a runner group. You can select all organizations or select individual organizations. Can be one of: `all` or `selected`
         */
        visibility?: "selected" | "all";
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["runner-groups-enterprise"];
      };
    };
  };
  /**
   * Deletes a self-hosted runner group for an enterprise.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/delete-self-hosted-runner-group-from-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        runner_group_id: components["parameters"]["runner_group_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists the organizations with access to a self-hosted runner group.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-org-access-to-self-hosted-runner-group-in-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        runner_group_id: components["parameters"]["runner_group_id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          organizations: components["schemas"]["organization-simple"][];
        };
      };
    };
  };
  /**
   * Replaces the list of organizations that have access to a self-hosted runner configured in an enterprise.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-org-access-to-self-hosted-runner-group-in-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        runner_group_id: components["parameters"]["runner_group_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * List of organization IDs that can access the runner group.
         */
        selected_organization_ids: number[];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Adds an organization to the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/add-org-access-to-self-hosted-runner-group-in-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        runner_group_id: components["parameters"]["runner_group_id"];
        org_id: components["parameters"]["org_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Removes an organization from the list of selected organizations that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an enterprise](#create-a-self-hosted-runner-group-for-an-enterprise)."
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/remove-org-access-to-self-hosted-runner-group-in-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        runner_group_id: components["parameters"]["runner_group_id"];
        org_id: components["parameters"]["org_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists the self-hosted runners that are in a specific enterprise group.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-self-hosted-runners-in-group-for-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        runner_group_id: components["parameters"]["runner_group_id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          runners: components["schemas"]["runner"][];
        };
      };
    };
  };
  /**
   * Replaces the list of self-hosted runners that that are part of an enterprise runner group.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/set-self-hosted-runners-in-group-for-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        runner_group_id: components["parameters"]["runner_group_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * List of runner IDs to add to the runner group.
         */
        runners: number[];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Adds a self-hosted runner to a runner group configured in an enterprise.
   *
   * You must authenticate using an access token with the `admin:enterprise`
   * scope to use this endpoint.
   */
  "enterprise-admin/add-self-hosted-runner-to-group-for-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        runner_group_id: components["parameters"]["runner_group_id"];
        runner_id: components["parameters"]["runner_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Removes a self-hosted runner from a group configured in an enterprise. The runner is then returned to the default group.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/remove-self-hosted-runner-from-group-for-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        runner_group_id: components["parameters"]["runner_group_id"];
        runner_id: components["parameters"]["runner_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists all self-hosted runners configured for an enterprise.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-self-hosted-runners-for-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count?: number;
          runners?: components["schemas"]["runner"][];
        };
      };
    };
  };
  /**
   * Lists binaries for the runner application that you can download and run.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/list-runner-applications-for-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["runner-application"][];
      };
    };
  };
  /**
   * Returns a token that you can pass to the `config` script. The token expires after one hour.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   *
   * #### Example using registration token
   *
   * Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
   *
   * ```
   * ./config.sh --url https://github.com/enterprises/octo-enterprise --token TOKEN
   * ```
   */
  "enterprise-admin/create-registration-token-for-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["authentication-token"];
      };
    };
  };
  /**
   * Returns a token that you can pass to the `config` script to remove a self-hosted runner from an enterprise. The token expires after one hour.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   *
   * #### Example using remove token
   *
   * To remove your self-hosted runner from an enterprise, replace `TOKEN` with the remove token provided by this
   * endpoint.
   *
   * ```
   * ./config.sh remove --token TOKEN
   * ```
   */
  "enterprise-admin/create-remove-token-for-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["authentication-token"];
      };
    };
  };
  /**
   * Gets a specific self-hosted runner configured in an enterprise.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/get-self-hosted-runner-for-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        runner_id: components["parameters"]["runner_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["runner"];
      };
    };
  };
  /**
   * Forces the removal of a self-hosted runner from an enterprise. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
   *
   * You must authenticate using an access token with the `admin:enterprise` scope to use this endpoint.
   */
  "enterprise-admin/delete-self-hosted-runner-from-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        runner_id: components["parameters"]["runner_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * **Note:** The audit log REST API is currently in beta and is subject to change. To join the beta, talk to your services or sales contact at GitHub.
   *
   * Gets the audit log for an enterprise. To use this endpoint, you must be an enterprise admin, and you must use an access token with the `admin:enterprise` scope.
   */
  "audit-log/get-audit-log": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        phrase?: components["parameters"]["audit-log-phrase"];
        include?: components["parameters"]["audit-log-include"];
        after?: components["parameters"]["audit-log-after"];
        before?: components["parameters"]["audit-log-before"];
        per_page?: components["parameters"]["per_page"];
      };
    };
    responses: {
      /**
       * Response
       */
      "200": {
        "application/json": components["schemas"]["audit-log-event"][];
      };
    };
  };
  /**
   * Gets the summary of the free and paid GitHub Actions minutes used.
   *
   * Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://help.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
   *
   * The authenticated user must be an enterprise admin.
   */
  "billing/get-github-actions-billing-ghe": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["actions-billing-usage"];
      };
    };
  };
  /**
   * Gets the free and paid storage used for GitHub Packages in gigabytes.
   *
   * Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://help.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
   *
   * The authenticated user must be an enterprise admin.
   */
  "billing/get-github-packages-billing-ghe": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["packages-billing-usage"];
      };
    };
  };
  /**
   * Gets the estimated paid and estimated total storage used for GitHub Actions and Github Packages.
   *
   * Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://help.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
   *
   * The authenticated user must be an enterprise admin.
   */
  "billing/get-shared-storage-billing-ghe": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["combined-billing-usage"];
      };
    };
  };
  /**
   * We delay the public events feed by five minutes, which means the most recent event returned by the public events API actually occurred at least five minutes ago.
   */
  "activity/list-public-events": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["event"][];
      };
      "304": never;
      "403": unknown;
      "503": unknown;
    };
  };
  /**
   * GitHub provides several timeline resources in [Atom](http://en.wikipedia.org/wiki/Atom_(standard)) format. The Feeds API lists all the feeds available to the authenticated user:
   *
   * *   **Timeline**: The GitHub global public timeline
   * *   **User**: The public timeline for any user, using [URI template](https://docs.github.com/rest/overview/resources-in-the-rest-api#hypermedia)
   * *   **Current user public**: The public timeline for the authenticated user
   * *   **Current user**: The private timeline for the authenticated user
   * *   **Current user actor**: The private timeline for activity created by the authenticated user
   * *   **Current user organizations**: The private timeline for the organizations the authenticated user is a member of.
   * *   **Security advisories**: A collection of public announcements that provide information about security-related vulnerabilities in software on GitHub.
   *
   * **Note**: Private feeds are only returned when [authenticating via Basic Auth](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) since current feed URIs use the older, non revocable auth tokens.
   */
  "activity/get-feeds": {
    parameters: {};
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["feed"];
      };
    };
  };
  /**
   * Lists the authenticated user's gists or if called anonymously, this endpoint returns all public gists:
   */
  "gists/list": {
    parameters: {
      query: {
        since?: components["parameters"]["since"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["base-gist"][];
      };
      "304": never;
      "403": unknown;
    };
  };
  /**
   * Allows you to add a new gist with one or more files.
   *
   * **Note:** Don't name your files "gistfile" with a numerical suffix. This is the format of the automatic naming scheme that Gist uses internally.
   */
  "gists/create": {
    parameters: {};
    requestBody: {
      "application/json": {
        /**
         * Description of the gist
         */
        description?: string;
        /**
         * Names and content for the files that make up the gist
         */
        files: {
          [key: string]: {
            /**
             * Content of the file
             */
            content: string;
          };
        };
        public?: boolean | ("true" | "false");
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["gist-full"];
      };
      "304": never;
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * List public gists sorted by most recently updated to least recently updated.
   *
   * Note: With [pagination](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination), you can fetch up to 3000 gists. For example, you can fetch 100 pages with 30 gists per page or 30 pages with 100 gists per page.
   */
  "gists/list-public": {
    parameters: {
      query: {
        since?: components["parameters"]["since"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["base-gist"][];
      };
      "304": never;
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * List the authenticated user's starred gists:
   */
  "gists/list-starred": {
    parameters: {
      query: {
        since?: components["parameters"]["since"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["base-gist"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  "gists/get": {
    parameters: {
      path: {
        gist_id: components["parameters"]["gist_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["gist-full"];
      };
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Allows you to update or delete a gist file and rename gist files. Files from the previous version of the gist that aren't explicitly changed during an edit are unchanged.
   */
  "gists/update": {
    parameters: {
      path: {
        gist_id: components["parameters"]["gist_id"];
      };
    };
    requestBody: {
      "application/json": Partial<{ [key: string]: any }> &
        Partial<{ [key: string]: any }>;
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["gist-full"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  "gists/delete": {
    parameters: {
      path: {
        gist_id: components["parameters"]["gist_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  "gists/list-comments": {
    parameters: {
      path: {
        gist_id: components["parameters"]["gist_id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["gist-comment"][];
      };
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  "gists/create-comment": {
    parameters: {
      path: {
        gist_id: components["parameters"]["gist_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The comment text.
         */
        body: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["gist-comment"];
      };
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  "gists/get-comment": {
    parameters: {
      path: {
        gist_id: components["parameters"]["gist_id"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["gist-comment"];
      };
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  "gists/update-comment": {
    parameters: {
      path: {
        gist_id: components["parameters"]["gist_id"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The comment text.
         */
        body: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["gist-comment"];
      };
      "404": unknown;
    };
  };
  "gists/delete-comment": {
    parameters: {
      path: {
        gist_id: components["parameters"]["gist_id"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  "gists/list-commits": {
    parameters: {
      path: {
        gist_id: components["parameters"]["gist_id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["gist-commit"][];
      };
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  "gists/list-forks": {
    parameters: {
      path: {
        gist_id: components["parameters"]["gist_id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["gist-full"][];
      };
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * **Note**: This was previously `/gists/:gist_id/fork`.
   */
  "gists/fork": {
    parameters: {
      path: {
        gist_id: components["parameters"]["gist_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["base-gist"];
      };
      "304": never;
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  "gists/check-is-starred": {
    parameters: {
      path: {
        gist_id: components["parameters"]["gist_id"];
      };
    };
    responses: {
      /**
       * Response if gist is starred
       */
      "204": never;
      "304": never;
      "403": unknown;
      /**
       * Response if gist is not starred
       */
      "404": {
        "application/json": { [key: string]: any };
      };
    };
  };
  /**
   * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
   */
  "gists/star": {
    parameters: {
      path: {
        gist_id: components["parameters"]["gist_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  "gists/unstar": {
    parameters: {
      path: {
        gist_id: components["parameters"]["gist_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  "gists/get-revision": {
    parameters: {
      path: {
        gist_id: components["parameters"]["gist_id"];
        sha: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["gist-full"];
      };
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * List all templates available to pass as an option when [creating a repository](https://docs.github.com/rest/reference/repos#create-a-repository-for-the-authenticated-user).
   */
  "gitignore/get-all-templates": {
    parameters: {};
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": string[];
      };
      "304": never;
    };
  };
  /**
   * The API also allows fetching the source of a single template.
   * Use the raw [media type](https://docs.github.com/rest/overview/media-types/) to get the raw contents.
   */
  "gitignore/get-template": {
    parameters: {
      path: {
        name: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["gitignore-template"];
      };
      "304": never;
    };
  };
  /**
   * List repositories that an app installation can access.
   *
   * You must use an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
   */
  "apps/list-repos-accessible-to-installation": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          repositories: components["schemas"]["repository"][];
          repository_selection?: string;
        };
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  /**
   * Revokes the installation token you're using to authenticate as an installation and access this endpoint.
   *
   * Once an installation token is revoked, the token is invalidated and cannot be used. Other endpoints that require the revoked installation token must have a new installation token to work. You can create a new token using the "[Create an installation access token for an app](https://docs.github.com/rest/reference/apps#create-an-installation-access-token-for-an-app)" endpoint.
   *
   * You must use an [installation access token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-an-installation) to access this endpoint.
   */
  "apps/revoke-installation-access-token": {
    parameters: {};
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * List issues assigned to the authenticated user across all visible repositories including owned repositories, member
   * repositories, and organization repositories. You can use the `filter` query parameter to fetch issues that are not
   * necessarily assigned to you.
   *
   *
   * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
   * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
   * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
   * request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
   */
  "issues/list": {
    parameters: {
      query: {
        /**
         * Indicates which sorts of issues to return. Can be one of:
         * \* `assigned`: Issues assigned to you
         * \* `created`: Issues created by you
         * \* `mentioned`: Issues mentioning you
         * \* `subscribed`: Issues you're subscribed to updates for
         * \* `all`: All issues the authenticated user can see, regardless of participation or creation
         */
        filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
        /**
         * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
         */
        state?: "open" | "closed" | "all";
        labels?: components["parameters"]["labels"];
        /**
         * What to sort results by. Can be either `created`, `updated`, `comments`.
         */
        sort?: "created" | "updated" | "comments";
        direction?: components["parameters"]["direction"];
        since?: components["parameters"]["since"];
        collab?: boolean;
        orgs?: boolean;
        owned?: boolean;
        pulls?: boolean;
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["issue"][];
      };
      "304": never;
      "404": unknown;
      "422": unknown;
    };
  };
  "licenses/get-all-commonly-used": {
    parameters: {
      query: {
        featured?: boolean;
        per_page?: components["parameters"]["per_page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["license-simple"][];
      };
      "304": never;
    };
  };
  "licenses/get": {
    parameters: {
      path: {
        license: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["license"];
      };
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  "markdown/render": {
    parameters: {};
    requestBody: {
      "application/json": {
        /**
         * The Markdown text to render in HTML.
         */
        text: string;
        /**
         * The rendering mode.
         */
        mode?: "markdown" | "gfm";
        /**
         * The repository context to use when creating references in `gfm` mode.
         */
        context?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": unknown;
      "304": never;
    };
  };
  /**
   * You must send Markdown as plain text (using a `Content-Type` header of `text/plain` or `text/x-markdown`) to this endpoint, rather than using JSON format. In raw mode, [GitHub Flavored Markdown](https://github.github.com/gfm/) is not supported and Markdown will be rendered in plain format like a README.md file. Markdown content must be 400 KB or less.
   */
  "markdown/render-raw": {
    parameters: {};
    requestBody: {
      "text/plain": string;
      "text/x-markdown": string;
    };
    responses: {
      /**
       * response
       */
      "200": {
        "text/html": string;
      };
      "304": never;
    };
  };
  /**
   * Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
   *
   * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
   */
  "apps/get-subscription-plan-for-account": {
    parameters: {
      path: {
        account_id: components["parameters"]["account_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["marketplace-purchase"];
      };
      "401": unknown;
      /**
       * Response when the account has not purchased the listing
       */
      "404": {
        "application/json": components["schemas"]["basic-error"];
      };
    };
  };
  /**
   * Lists all plans that are part of your GitHub Marketplace listing.
   *
   * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
   */
  "apps/list-plans": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["marketplace-listing-plan"][];
      };
      "401": unknown;
      "404": unknown;
    };
  };
  /**
   * Returns user and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
   *
   * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
   */
  "apps/list-accounts-for-plan": {
    parameters: {
      path: {
        plan_id: components["parameters"]["plan_id"];
      };
      query: {
        sort?: components["parameters"]["sort"];
        /**
         * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
         */
        direction?: "asc" | "desc";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["marketplace-purchase"][];
      };
      "401": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Shows whether the user or organization account actively subscribes to a plan listed by the authenticated GitHub App. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
   *
   * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
   */
  "apps/get-subscription-plan-for-account-stubbed": {
    parameters: {
      path: {
        account_id: components["parameters"]["account_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["marketplace-purchase"];
      };
      "401": unknown;
      /**
       * Response when the account has not purchased the listing
       */
      "404": unknown;
    };
  };
  /**
   * Lists all plans that are part of your GitHub Marketplace listing.
   *
   * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
   */
  "apps/list-plans-stubbed": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["marketplace-listing-plan"][];
      };
      "401": unknown;
    };
  };
  /**
   * Returns repository and organization accounts associated with the specified plan, including free plans. For per-seat pricing, you see the list of accounts that have purchased the plan, including the number of seats purchased. When someone submits a plan change that won't be processed until the end of their billing cycle, you will also see the upcoming pending change.
   *
   * GitHub Apps must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint. OAuth Apps must use [basic authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication) with their client ID and client secret to access this endpoint.
   */
  "apps/list-accounts-for-plan-stubbed": {
    parameters: {
      path: {
        plan_id: components["parameters"]["plan_id"];
      };
      query: {
        sort?: components["parameters"]["sort"];
        /**
         * To return the oldest accounts first, set to `asc`. Can be one of `asc` or `desc`. Ignored without the `sort` parameter.
         */
        direction?: "asc" | "desc";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["marketplace-purchase"][];
      };
      "401": unknown;
    };
  };
  /**
   * This endpoint provides a list of GitHub's IP addresses. For more information, see "[About GitHub's IP addresses](https://help.github.com/articles/about-github-s-ip-addresses/)."
   */
  "meta/get": {
    parameters: {};
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["api-overview"];
      };
      "304": never;
    };
  };
  "activity/list-public-events-for-repo-network": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["event"][];
      };
      "301": never;
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * List all notifications for the current user, sorted by most recently updated.
   */
  "activity/list-notifications-for-authenticated-user": {
    parameters: {
      query: {
        all?: components["parameters"]["all"];
        participating?: components["parameters"]["participating"];
        since?: components["parameters"]["since"];
        before?: components["parameters"]["before"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["thread"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * Marks all notifications as "read" removes it from the [default view on GitHub](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List notifications for the authenticated user](https://docs.github.com/rest/reference/activity#list-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.
   */
  "activity/mark-notifications-as-read": {
    parameters: {};
    requestBody: {
      "application/json": {
        /**
         * Describes the last point that notifications were checked.
         */
        last_read_at?: string;
        /**
         * Whether the notification has been read.
         */
        read?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "202": {
        "application/json": { message?: string };
      };
      /**
       * response
       */
      "205": unknown;
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  "activity/get-thread": {
    parameters: {
      path: {
        thread_id: components["parameters"]["thread_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["thread"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  "activity/mark-thread-as-read": {
    parameters: {
      path: {
        thread_id: components["parameters"]["thread_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "205": unknown;
      "304": never;
      "403": unknown;
    };
  };
  /**
   * This checks to see if the current user is subscribed to a thread. You can also [get a repository subscription](https://docs.github.com/rest/reference/activity#get-a-repository-subscription).
   *
   * Note that subscriptions are only generated if a user is participating in a conversation--for example, they've replied to the thread, were **@mentioned**, or manually subscribe to a thread.
   */
  "activity/get-thread-subscription-for-authenticated-user": {
    parameters: {
      path: {
        thread_id: components["parameters"]["thread_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["thread-subscription"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  /**
   * If you are watching a repository, you receive notifications for all threads by default. Use this endpoint to ignore future notifications for threads until you comment on the thread or get an **@mention**.
   *
   * You can also use this endpoint to subscribe to threads that you are currently not receiving notifications for or to subscribed to threads that you have previously ignored.
   *
   * Unsubscribing from a conversation in a repository that you are not watching is functionally equivalent to the [Delete a thread subscription](https://docs.github.com/rest/reference/activity#delete-a-thread-subscription) endpoint.
   */
  "activity/set-thread-subscription": {
    parameters: {
      path: {
        thread_id: components["parameters"]["thread_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Whether to block all notifications from a thread.
         */
        ignored?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["thread-subscription"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  /**
   * Mutes all future notifications for a conversation until you comment on the thread or get an **@mention**. If you are watching the repository of the thread, you will still receive notifications. To ignore future notifications for a repository you are watching, use the [Set a thread subscription](https://docs.github.com/rest/reference/activity#set-a-thread-subscription) endpoint and set `ignore` to `true`.
   */
  "activity/delete-thread-subscription": {
    parameters: {
      path: {
        thread_id: components["parameters"]["thread_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  /**
   * Get the octocat as ASCII art
   */
  "meta/get-octocat": {
    parameters: {
      query: {
        /**
         * The words to show in Octocat's speech bubble
         */
        s?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/octocat-stream": string;
      };
    };
  };
  /**
   * Lists all organizations, in the order that they were created on GitHub.
   *
   * **Note:** Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of organizations.
   */
  "orgs/list": {
    parameters: {
      query: {
        since?: components["parameters"]["since-org"];
        per_page?: components["parameters"]["per_page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["organization-simple"][];
      };
      "304": never;
    };
  };
  /**
   * To see many of the organization response values, you need to be an authenticated organization owner with the `admin:org` scope. When the value of `two_factor_requirement_enabled` is `true`, the organization requires all members, billing managers, and outside collaborators to enable [two-factor authentication](https://help.github.com/articles/securing-your-account-with-two-factor-authentication-2fa/).
   *
   * GitHub Apps with the `Organization plan` permission can use this endpoint to retrieve information about an organization's GitHub plan. See "[Authenticating with GitHub Apps](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/)" for details. For an example response, see 'Response with GitHub plan information' below."
   */
  "orgs/get": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["organization-full"];
      };
      "404": unknown;
    };
  };
  /**
   * **Parameter Deprecation Notice:** GitHub will replace and discontinue `members_allowed_repository_creation_type` in favor of more granular permissions. The new input parameters are `members_can_create_public_repositories`, `members_can_create_private_repositories` for all organizations and `members_can_create_internal_repositories` for organizations associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. For more information, see the [blog post](https://developer.github.com/changes/2019-12-03-internal-visibility-changes).
   *
   * Enables an authenticated organization owner with the `admin:org` scope to update the organization's profile and member privileges.
   */
  "orgs/update": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Billing email address. This address is not publicized.
         */
        billing_email?: string;
        /**
         * The company name.
         */
        company?: string;
        /**
         * The publicly visible email address.
         */
        email?: string;
        /**
         * The Twitter username of the company.
         */
        twitter_username?: string;
        /**
         * The location.
         */
        location?: string;
        /**
         * The shorthand name of the company.
         */
        name?: string;
        /**
         * The description of the company.
         */
        description?: string;
        /**
         * Toggles whether an organization can use organization projects.
         */
        has_organization_projects?: boolean;
        /**
         * Toggles whether repositories that belong to the organization can use repository projects.
         */
        has_repository_projects?: boolean;
        /**
         * Default permission level members have for organization repositories:
         * \* `read` - can pull, but not push to or administer this repository.
         * \* `write` - can pull and push, but not administer this repository.
         * \* `admin` - can pull, push, and administer this repository.
         * \* `none` - no permissions granted by default.
         */
        default_repository_permission?: "read" | "write" | "admin" | "none";
        /**
         * Toggles the ability of non-admin organization members to create repositories. Can be one of:
         * \* `true` - all organization members can create repositories.
         * \* `false` - only organization owners can create repositories.
         * Default: `true`
         * **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details. **Note:** A parameter can override this parameter. See `members_allowed_repository_creation_type` in this table for details.
         */
        members_can_create_repositories?: boolean;
        /**
         * Toggles whether organization members can create internal repositories, which are visible to all enterprise members. You can only allow members to create internal repositories if your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+. Can be one of:
         * \* `true` - all organization members can create internal repositories.
         * \* `false` - only organization owners can create internal repositories.
         * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
         */
        members_can_create_internal_repositories?: boolean;
        /**
         * Toggles whether organization members can create private repositories, which are visible to organization members with permission. Can be one of:
         * \* `true` - all organization members can create private repositories.
         * \* `false` - only organization owners can create private repositories.
         * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
         */
        members_can_create_private_repositories?: boolean;
        /**
         * Toggles whether organization members can create public repositories, which are visible to anyone. Can be one of:
         * \* `true` - all organization members can create public repositories.
         * \* `false` - only organization owners can create public repositories.
         * Default: `true`. For more information, see "[Restricting repository creation in your organization](https://help.github.com/github/setting-up-and-managing-organizations-and-teams/restricting-repository-creation-in-your-organization)" in the GitHub Help documentation.
         */
        members_can_create_public_repositories?: boolean;
        /**
         * Specifies which types of repositories non-admin organization members can create. Can be one of:
         * \* `all` - all organization members can create public and private repositories.
         * \* `private` - members can create private repositories. This option is only available to repositories that are part of an organization on GitHub Enterprise Cloud.
         * \* `none` - only admin members can create repositories.
         * **Note:** This parameter is deprecated and will be removed in the future. Its return value ignores internal repositories. Using this parameter overrides values set in `members_can_create_repositories`. See the parameter deprecation notice in the operation description for details.
         */
        members_allowed_repository_creation_type?: "all" | "private" | "none";
        /**
         * Toggles whether organization members can create GitHub Pages sites. Can be one of:
         * \* `true` - all organization members can create GitHub Pages sites.
         * \* `false` - no organization members can create GitHub Pages sites. Existing published sites will not be impacted.
         * Default: `true`.
         */
        members_can_create_pages?: boolean;
        blog?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["organization-full"];
      };
      "409": unknown;
      "415": unknown;
      /**
       * Validation Failed
       */
      "422": {
        "application/json":
          | components["schemas"]["validation-error"]
          | components["schemas"]["validation-error-simple"];
      };
    };
  };
  /**
   * Gets the GitHub Actions permissions policy for repositories and allowed actions in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/get-github-actions-permissions-organization": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["actions-organization-permissions"];
      };
    };
  };
  /**
   * Sets the GitHub Actions permissions policy for repositories and allowed actions in an organization.
   *
   * If the organization belongs to an enterprise that has set restrictive permissions at the enterprise level, such as `allowed_actions` to `selected` actions, then you cannot override them for the organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/set-github-actions-permissions-organization": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    requestBody: {
      "application/json": {
        enabled_repositories: components["schemas"]["enabled-repositories"];
        allowed_actions?: components["schemas"]["allowed-actions"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists the selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/list-selected-repositories-enabled-github-actions-organization": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          repositories: components["schemas"]["repository"][];
        };
      };
    };
  };
  /**
   * Replaces the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/set-selected-repositories-enabled-github-actions-organization": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * List of repository IDs to enable for GitHub Actions.
         */
        selected_repository_ids: number[];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Adds a repository to the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/enable-selected-repository-github-actions-organization": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        repository_id: components["parameters"]["repository_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Removes a repository from the list of selected repositories that are enabled for GitHub Actions in an organization. To use this endpoint, the organization permission policy for `enabled_repositories` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/disable-selected-repository-github-actions-organization": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        repository_id: components["parameters"]["repository_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Gets the selected actions that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization).""
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/get-allowed-actions-organization": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["selected-actions"];
      };
    };
  };
  /**
   * Sets the actions that are allowed in an organization. To use this endpoint, the organization permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for an organization](#set-github-actions-permissions-for-an-organization)."
   *
   * If the organization belongs to an enterprise that has `selected` actions set at the enterprise level, then you cannot override any of the enterprise's allowed actions settings.
   *
   * To use the `patterns_allowed` setting for private repositories, the organization must belong to an enterprise. If the organization does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories in the organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `administration` organization permission to use this API.
   */
  "actions/set-allowed-actions-organization": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    requestBody: {
      "application/json": components["schemas"]["selected-actions"];
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Lists all self-hosted runner groups configured in an organization and inherited from an enterprise.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-self-hosted-runner-groups-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          runner_groups: components["schemas"]["runner-groups-org"][];
        };
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud and GitHub Enterprise Server. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Creates a new self-hosted runner group for an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/create-self-hosted-runner-group-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Name of the runner group.
         */
        name: string;
        /**
         * Visibility of a runner group. You can select all repositories, select individual repositories, or limit access to private repositories. Can be one of: `all`, `selected`, or `private`.
         */
        visibility?: "selected" | "all" | "private";
        /**
         * List of repository IDs that can access the runner group.
         */
        selected_repository_ids?: number[];
        /**
         * List of runner IDs to add to the runner group.
         */
        runners?: number[];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["runner-groups-org"];
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Gets a specific self-hosted runner group for an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/get-self-hosted-runner-group-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        runner_group_id: components["parameters"]["runner_group_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["runner-groups-org"];
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Updates the `name` and `visibility` of a self-hosted runner group in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/update-self-hosted-runner-group-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        runner_group_id: components["parameters"]["runner_group_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Name of the runner group.
         */
        name?: string;
        /**
         * Visibility of a runner group. You can select all repositories, select individual repositories, or all private repositories. Can be one of: `all`, `selected`, or `private`.
         */
        visibility?: "selected" | "all" | "private";
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["runner-groups-org"];
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Deletes a self-hosted runner group for an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/delete-self-hosted-runner-group-from-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        runner_group_id: components["parameters"]["runner_group_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud and GitHub Enterprise Server. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Lists the repositories with access to a self-hosted runner group configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-repo-access-to-self-hosted-runner-group-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        runner_group_id: components["parameters"]["runner_group_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          repositories: components["schemas"]["repository"][];
        };
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Replaces the list of repositories that have access to a self-hosted runner group configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/set-repo-access-to-self-hosted-runner-group-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        runner_group_id: components["parameters"]["runner_group_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * List of repository IDs that can access the runner group.
         */
        selected_repository_ids: number[];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   *
   * Adds a repository to the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org`
   * scope to use this endpoint.
   */
  "actions/add-repo-access-to-self-hosted-runner-group-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        runner_group_id: components["parameters"]["runner_group_id"];
        repository_id: components["parameters"]["repository_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   *
   * Removes a repository from the list of selected repositories that can access a self-hosted runner group. The runner group must have `visibility` set to `selected`. For more information, see "[Create a self-hosted runner group for an organization](#create-a-self-hosted-runner-group-for-an-organization)."
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/remove-repo-access-to-self-hosted-runner-group-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        runner_group_id: components["parameters"]["runner_group_id"];
        repository_id: components["parameters"]["repository_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Lists self-hosted runners that are in a specific organization group.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-self-hosted-runners-in-group-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        runner_group_id: components["parameters"]["runner_group_id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          runners: components["schemas"]["runner"][];
        };
      };
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   * Replaces the list of self-hosted runners that are part of an organization runner group.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/set-self-hosted-runners-in-group-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        runner_group_id: components["parameters"]["runner_group_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * List of runner IDs to add to the runner group.
         */
        runners: number[];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   *
   * Adds a self-hosted runner to a runner group configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org`
   * scope to use this endpoint.
   */
  "actions/add-self-hosted-runner-to-group-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        runner_group_id: components["parameters"]["runner_group_id"];
        runner_id: components["parameters"]["runner_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * The self-hosted runner groups REST API is available with GitHub Enterprise Cloud. For more information, see "[GitHub's products](https://docs.github.com/github/getting-started-with-github/githubs-products)."
   *
   *
   * Removes a self-hosted runner from a group configured in an organization. The runner is then returned to the default group.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/remove-self-hosted-runner-from-group-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        runner_group_id: components["parameters"]["runner_group_id"];
        runner_id: components["parameters"]["runner_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists all self-hosted runners configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-self-hosted-runners-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          runners: components["schemas"]["runner"][];
        };
      };
    };
  };
  /**
   * Lists binaries for the runner application that you can download and run.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/list-runner-applications-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["runner-application"][];
      };
    };
  };
  /**
   * Returns a token that you can pass to the `config` script. The token expires after one hour.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   *
   * #### Example using registration token
   *
   * Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
   *
   * ```
   * ./config.sh --url https://github.com/octo-org --token TOKEN
   * ```
   */
  "actions/create-registration-token-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["authentication-token"];
      };
    };
  };
  /**
   * Returns a token that you can pass to the `config` script to remove a self-hosted runner from an organization. The token expires after one hour.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   *
   * #### Example using remove token
   *
   * To remove your self-hosted runner from an organization, replace `TOKEN` with the remove token provided by this
   * endpoint.
   *
   * ```
   * ./config.sh remove --token TOKEN
   * ```
   */
  "actions/create-remove-token-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["authentication-token"];
      };
    };
  };
  /**
   * Gets a specific self-hosted runner configured in an organization.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/get-self-hosted-runner-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        runner_id: components["parameters"]["runner_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["runner"];
      };
    };
  };
  /**
   * Forces the removal of a self-hosted runner from an organization. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
   *
   * You must authenticate using an access token with the `admin:org` scope to use this endpoint.
   */
  "actions/delete-self-hosted-runner-from-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        runner_id: components["parameters"]["runner_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists all secrets available in an organization without revealing their encrypted values. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
   */
  "actions/list-org-secrets": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          secrets: components["schemas"]["organization-actions-secret"][];
        };
      };
    };
  };
  /**
   * Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
   */
  "actions/get-org-public-key": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["actions-public-key"];
      };
    };
  };
  /**
   * Gets a single organization secret without revealing its encrypted value. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
   */
  "actions/get-org-secret": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        secret_name: components["parameters"]["secret_name"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["organization-actions-secret"];
      };
    };
  };
  /**
   * Creates or updates an organization secret with an encrypted value. Encrypt your secret using
   * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
   * token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to
   * use this endpoint.
   *
   * #### Example encrypting a secret using Node.js
   *
   * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
   *
   * ```
   * const sodium = require('tweetsodium');
   *
   * const key = "base64-encoded-public-key";
   * const value = "plain-text-secret";
   *
   * // Convert the message and key to Uint8Array's (Buffer implements that interface)
   * const messageBytes = Buffer.from(value);
   * const keyBytes = Buffer.from(key, 'base64');
   *
   * // Encrypt using LibSodium.
   * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
   *
   * // Base64 the encrypted secret
   * const encrypted = Buffer.from(encryptedBytes).toString('base64');
   *
   * console.log(encrypted);
   * ```
   *
   *
   * #### Example encrypting a secret using Python
   *
   * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/stable/public/#nacl-public-sealedbox) with Python 3.
   *
   * ```
   * from base64 import b64encode
   * from nacl import encoding, public
   *
   * def encrypt(public_key: str, secret_value: str) -> str:
   *   """Encrypt a Unicode string using the public key."""
   *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
   *   sealed_box = public.SealedBox(public_key)
   *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
   *   return b64encode(encrypted).decode("utf-8")
   * ```
   *
   * #### Example encrypting a secret using C#
   *
   * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
   *
   * ```
   * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
   * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
   *
   * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
   *
   * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
   * ```
   *
   * #### Example encrypting a secret using Ruby
   *
   * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
   *
   * ```ruby
   * require "rbnacl"
   * require "base64"
   *
   * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
   * public_key = RbNaCl::PublicKey.new(key)
   *
   * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
   * encrypted_secret = box.encrypt("my_secret")
   *
   * # Print the base64 encoded secret
   * puts Base64.strict_encode64(encrypted_secret)
   * ```
   */
  "actions/create-or-update-org-secret": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        secret_name: components["parameters"]["secret_name"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get an organization public key](https://docs.github.com/rest/reference/actions#get-an-organization-public-key) endpoint.
         */
        encrypted_value?: string;
        /**
         * ID of the key you used to encrypt the secret.
         */
        key_id?: string;
        /**
         * Configures the access that repositories have to the organization secret. Can be one of:
         * \- `all` - All repositories in an organization can access the secret.
         * \- `private` - Private repositories in an organization can access the secret.
         * \- `selected` - Only specific repositories can access the secret.
         */
        visibility?: "all" | "private" | "selected";
        /**
         * An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can manage the list of selected repositories using the [List selected repositories for an organization secret](https://docs.github.com/rest/reference/actions#list-selected-repositories-for-an-organization-secret), [Set selected repositories for an organization secret](https://docs.github.com/rest/reference/actions#set-selected-repositories-for-an-organization-secret), and [Remove selected repository from an organization secret](https://docs.github.com/rest/reference/actions#remove-selected-repository-from-an-organization-secret) endpoints.
         */
        selected_repository_ids?: string[];
      };
    };
    responses: {
      /**
       * Response when creating a secret
       */
      "201": unknown;
      /**
       * Response when updating a secret
       */
      "204": never;
    };
  };
  /**
   * Deletes a secret in an organization using the secret name. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
   */
  "actions/delete-org-secret": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        secret_name: components["parameters"]["secret_name"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists all repositories that have been selected when the `visibility` for repository access to a secret is set to `selected`. You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
   */
  "actions/list-selected-repos-for-org-secret": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        secret_name: components["parameters"]["secret_name"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          repositories: components["schemas"]["minimal-repository"][];
        };
      };
    };
  };
  /**
   * Replaces all repositories for an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
   */
  "actions/set-selected-repos-for-org-secret": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        secret_name: components["parameters"]["secret_name"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * An array of repository ids that can access the organization secret. You can only provide a list of repository ids when the `visibility` is set to `selected`. You can add and remove individual repositories using the [Set selected repositories for an organization secret](https://docs.github.com/rest/reference/actions#set-selected-repositories-for-an-organization-secret) and [Remove selected repository from an organization secret](https://docs.github.com/rest/reference/actions#remove-selected-repository-from-an-organization-secret) endpoints.
         */
        selected_repository_ids?: number[];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Adds a repository to an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
   */
  "actions/add-selected-repo-to-org-secret": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        secret_name: components["parameters"]["secret_name"];
        repository_id: number;
      };
    };
    responses: {
      /**
       * Response when repository was added to the selected list
       */
      "204": never;
      /**
       * Response when visibility type is not set to selected
       */
      "409": unknown;
    };
  };
  /**
   * Removes a repository from an organization secret when the `visibility` for repository access is set to `selected`. The visibility is set when you [Create or update an organization secret](https://docs.github.com/rest/reference/actions#create-or-update-an-organization-secret). You must authenticate using an access token with the `admin:org` scope to use this endpoint. GitHub Apps must have the `secrets` organization permission to use this endpoint.
   */
  "actions/remove-selected-repo-from-org-secret": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        secret_name: components["parameters"]["secret_name"];
        repository_id: number;
      };
    };
    responses: {
      /**
       * Response when repository was removed from the selected list
       */
      "204": never;
      /**
       * Response when visibility type not set to selected
       */
      "409": unknown;
    };
  };
  /**
   * **Note:** The audit log REST API is currently in beta and is subject to change. To join the beta, talk to your services or sales contact at GitHub.
   *
   * Gets the audit log for an organization. For more information, see "[Reviewing the audit log for your organization](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization)."
   *
   * To use this endpoint, you must be an organization owner, and you must use an access token with the `admin:org` scope. GitHub Apps must have the `organization_administration` read permission to use this endpoint.
   */
  "orgs/get-audit-log": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        phrase?: components["parameters"]["audit-log-phrase"];
        include?: components["parameters"]["audit-log-include"];
        after?: components["parameters"]["audit-log-after"];
        before?: components["parameters"]["audit-log-before"];
        per_page?: components["parameters"]["per_page"];
      };
    };
    responses: {
      /**
       * Response
       */
      "200": {
        "application/json": components["schemas"]["audit-log-event"][];
      };
    };
  };
  /**
   * List the users blocked by an organization.
   */
  "orgs/list-blocked-users": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
      "415": unknown;
    };
  };
  "orgs/check-blocked-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * If the user is blocked:
       */
      "204": never;
      /**
       * If the user is not blocked:
       */
      "404": {
        "application/json": components["schemas"]["basic-error"];
      };
    };
  };
  "orgs/block-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "422": unknown;
    };
  };
  "orgs/unblock-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Listing and deleting credential authorizations is available to organizations with GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products).
   *
   * An authenticated organization owner with the `read:org` scope can list all credential authorizations for an organization that uses SAML single sign-on (SSO). The credentials are either personal access tokens or SSH keys that organization members have authorized for the organization. For more information, see [About authentication with SAML single sign-on](https://help.github.com/en/articles/about-authentication-with-saml-single-sign-on).
   */
  "orgs/list-saml-sso-authorizations": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["credential-authorization"][];
      };
    };
  };
  /**
   * Listing and deleting credential authorizations is available to organizations with GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products).
   *
   * An authenticated organization owner with the `admin:org` scope can remove a credential authorization for an organization that uses SAML SSO. Once you remove someone's credential authorization, they will need to create a new personal access token or SSH key and authorize it for the organization they want to access.
   */
  "orgs/remove-saml-sso-authorization": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        credential_id: number;
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
    };
  };
  "activity/list-public-org-events": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["event"][];
      };
    };
  };
  "orgs/list-webhooks": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["org-hook"][];
      };
      "404": unknown;
    };
  };
  /**
   * Here's how you can create a hook that posts payloads in JSON format:
   */
  "orgs/create-webhook": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Must be passed as "web".
         */
        name: string;
        /**
         * Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/rest/reference/orgs#create-hook-config-params).
         */
        config: {
          url: components["schemas"]["webhook-config-url"];
          content_type?: components["schemas"]["webhook-config-content-type"];
          secret?: components["schemas"]["webhook-config-secret"];
          insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
          username?: string;
          password?: string;
        };
        /**
         * Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for.
         */
        events?: string[];
        /**
         * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
         */
        active?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["org-hook"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Returns a webhook configured in an organization. To get only the webhook `config` properties, see "[Get a webhook configuration for an organization](/rest/reference/orgs#get-a-webhook-configuration-for-an-organization)."
   */
  "orgs/get-webhook": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["org-hook"];
      };
      "404": unknown;
    };
  };
  /**
   * Updates a webhook configured in an organization. When you update a webhook, the `secret` will be overwritten. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for an organization](/rest/reference/orgs#update-a-webhook-configuration-for-an-organization)."
   */
  "orgs/update-webhook": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        hook_id: components["parameters"]["hook-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/rest/reference/orgs#update-hook-config-params).
         */
        config?: {
          url: components["schemas"]["webhook-config-url"];
          content_type?: components["schemas"]["webhook-config-content-type"];
          secret?: components["schemas"]["webhook-config-secret"];
          insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
        };
        /**
         * Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for.
         */
        events?: string[];
        /**
         * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
         */
        active?: boolean;
        name?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["org-hook"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  "orgs/delete-webhook": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
    };
  };
  /**
   * Returns the webhook configuration for an organization. To get more information about the webhook, including the `active` state and `events`, use "[Get an organization webhook ](/rest/reference/orgs#get-an-organization-webhook)."
   *
   * Access tokens must have the `admin:org_hook` scope, and GitHub Apps must have the `organization_hooks:read` permission.
   */
  "orgs/get-webhook-config-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /**
       * Default response
       */
      "200": {
        "application/json": components["schemas"]["webhook-config"];
      };
    };
  };
  /**
   * Updates the webhook configuration for an organization. To update more information about the webhook, including the `active` state and `events`, use "[Update an organization webhook ](/rest/reference/orgs#update-an-organization-webhook)."
   *
   * Access tokens must have the `admin:org_hook` scope, and GitHub Apps must have the `organization_hooks:write` permission.
   */
  "orgs/update-webhook-config-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        hook_id: components["parameters"]["hook-id"];
      };
    };
    requestBody: {
      "application/json": {
        url?: components["schemas"]["webhook-config-url"];
        content_type?: components["schemas"]["webhook-config-content-type"];
        secret?: components["schemas"]["webhook-config-secret"];
        insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
      };
    };
    responses: {
      /**
       * Default response
       */
      "200": {
        "application/json": components["schemas"]["webhook-config"];
      };
    };
  };
  /**
   * This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event) to be sent to the hook.
   */
  "orgs/ping-webhook": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
    };
  };
  /**
   * Enables an authenticated GitHub App to find the organization's installation information.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-org-installation": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["installation"];
      };
    };
  };
  /**
   * Lists all GitHub Apps in an organization. The installation count includes all GitHub Apps installed on repositories in the organization. You must be an organization owner with `admin:read` scope to use this endpoint.
   */
  "orgs/list-app-installations": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          installations: components["schemas"]["installation"][];
        };
      };
    };
  };
  /**
   * Shows which type of GitHub user can interact with this organization and when the restriction expires. If there is no restrictions, you will see an empty response.
   */
  "interactions/get-restrictions-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["interaction-limit-response"];
      };
    };
  };
  /**
   * Temporarily restricts interactions to a certain type of GitHub user in any public repository in the given organization. You must be an organization owner to set these restrictions. Setting the interaction limit at the organization level will overwrite any interaction limits that are set for individual repositories owned by the organization.
   */
  "interactions/set-restrictions-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    requestBody: {
      "application/json": components["schemas"]["interaction-limit"];
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["interaction-limit-response"];
      };
      "422": unknown;
    };
  };
  /**
   * Removes all interaction restrictions from public repositories in the given organization. You must be an organization owner to remove restrictions.
   */
  "interactions/remove-restrictions-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
   */
  "orgs/list-pending-invitations": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["organization-invitation"][];
      };
      "404": unknown;
    };
  };
  /**
   * Invite people to an organization by using their GitHub user ID or their email address. In order to create invitations in an organization, the authenticated user must be an organization owner.
   *
   * This endpoint triggers [notifications](https://help.github.com/articles/about-notifications/). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
   */
  "orgs/create-invitation": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * **Required unless you provide `email`**. GitHub user ID for the person you are inviting.
         */
        invitee_id?: number;
        /**
         * **Required unless you provide `invitee_id`**. Email address of the person you are inviting, which can be an existing GitHub user.
         */
        email?: string;
        /**
         * Specify role for new member. Can be one of:
         * \* `admin` - Organization owners with full administrative rights to the organization and complete access to all repositories and teams.
         * \* `direct_member` - Non-owner organization members with ability to see other members and join teams by invitation.
         * \* `billing_manager` - Non-owner organization members with ability to manage the billing settings of your organization.
         */
        role?: "admin" | "direct_member" | "billing_manager";
        /**
         * Specify IDs for the teams you want to invite new members to.
         */
        team_ids?: number[];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["organization-invitation"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * List all teams associated with an invitation. In order to see invitations in an organization, the authenticated user must be an organization owner.
   */
  "orgs/list-invitation-teams": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        invitation_id: components["parameters"]["invitation_id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team"][];
      };
      "404": unknown;
    };
  };
  /**
   * List issues in an organization assigned to the authenticated user.
   *
   * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
   * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
   * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
   * request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
   */
  "issues/list-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        /**
         * Indicates which sorts of issues to return. Can be one of:
         * \* `assigned`: Issues assigned to you
         * \* `created`: Issues created by you
         * \* `mentioned`: Issues mentioning you
         * \* `subscribed`: Issues you're subscribed to updates for
         * \* `all`: All issues the authenticated user can see, regardless of participation or creation
         */
        filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
        /**
         * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
         */
        state?: "open" | "closed" | "all";
        labels?: components["parameters"]["labels"];
        /**
         * What to sort results by. Can be either `created`, `updated`, `comments`.
         */
        sort?: "created" | "updated" | "comments";
        direction?: components["parameters"]["direction"];
        since?: components["parameters"]["since"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["issue"][];
      };
      "404": unknown;
    };
  };
  /**
   * List all users who are members of an organization. If the authenticated user is also a member of this organization then both concealed and public members will be returned.
   */
  "orgs/list-members": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        /**
         * Filter members returned in the list. Can be one of:
         * \* `2fa_disabled` - Members without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled. Available for organization owners.
         * \* `all` - All members the authenticated user can see.
         */
        filter?: "2fa_disabled" | "all";
        /**
         * Filter members returned by their role. Can be one of:
         * \* `all` - All members of the organization, regardless of role.
         * \* `admin` - Organization owners.
         * \* `member` - Non-owner organization members.
         */
        role?: "all" | "admin" | "member";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
      /**
       * Response if requester is not an organization member
       */
      "302": never;
      "422": unknown;
    };
  };
  /**
   * Check if a user is, publicly or privately, a member of the organization.
   */
  "orgs/check-membership-for-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Response if requester is an organization member and user is a member
       */
      "204": never;
      /**
       * Response if requester is not an organization member
       */
      "302": never;
      /**
       * Response if requester is an organization member and user is not a member
       */
      "404": unknown;
    };
  };
  /**
   * Removing a user from this list will remove them from all teams and they will no longer have any access to the organization's repositories.
   */
  "orgs/remove-member": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "403": unknown;
    };
  };
  /**
   * In order to get a user's membership with an organization, the authenticated user must be an organization member.
   */
  "orgs/get-membership-for-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["org-membership"];
      };
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Only authenticated organization owners can add a member to the organization or update the member's role.
   *
   * *   If the authenticated user is _adding_ a member to the organization, the invited user will receive an email inviting them to the organization. The user's [membership status](https://docs.github.com/rest/reference/orgs#get-organization-membership-for-a-user) will be `pending` until they accept the invitation.
   *
   * *   Authenticated users can _update_ a user's membership by passing the `role` parameter. If the authenticated user changes a member's role to `admin`, the affected user will receive an email notifying them that they've been made an organization owner. If the authenticated user changes an owner's role to `member`, no email will be sent.
   *
   * **Rate limits**
   *
   * To prevent abuse, the authenticated user is limited to 50 organization invitations per 24 hour period. If the organization is more than one month old or on a paid plan, the limit is 500 invitations per 24 hour period.
   */
  "orgs/set-membership-for-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        username: components["parameters"]["username"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The role to give the user in the organization. Can be one of:
         * \* `admin` - The user will become an owner of the organization.
         * \* `member` - The user will become a non-owner member of the organization.
         */
        role?: "admin" | "member";
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["org-membership"];
      };
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * In order to remove a user's membership with an organization, the authenticated user must be an organization owner.
   *
   * If the specified user is an active member of the organization, this will remove them from the organization. If the specified user has been invited to the organization, this will cancel their invitation. The specified user will receive an email notification in both cases.
   */
  "orgs/remove-membership-for-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Lists the most recent migrations.
   */
  "migrations/list-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["migration"][];
      };
    };
  };
  /**
   * Initiates the generation of a migration archive.
   */
  "migrations/start-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * A list of arrays indicating which repositories should be migrated.
         */
        repositories: string[];
        /**
         * Indicates whether repositories should be locked (to prevent manipulation) while migrating data.
         */
        lock_repositories?: boolean;
        /**
         * Indicates whether attachments should be excluded from the migration (to reduce migration archive file size).
         */
        exclude_attachments?: boolean;
        exclude?: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["migration"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Fetches the status of a migration.
   *
   * The `state` of a migration can be one of the following values:
   *
   * *   `pending`, which means the migration hasn't started yet.
   * *   `exporting`, which means the migration is in progress.
   * *   `exported`, which means the migration finished successfully.
   * *   `failed`, which means the migration failed.
   */
  "migrations/get-status-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        migration_id: components["parameters"]["migration_id"];
      };
    };
    responses: {
      /**
       * *   `pending`, which means the migration hasn't started yet.
       * *   `exporting`, which means the migration is in progress.
       * *   `exported`, which means the migration finished successfully.
       * *   `failed`, which means the migration failed.
       */
      "200": {
        "application/json": components["schemas"]["migration"];
      };
      "404": unknown;
    };
  };
  /**
   * Fetches the URL to a migration archive.
   */
  "migrations/download-archive-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        migration_id: components["parameters"]["migration_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "302": never;
      "404": unknown;
    };
  };
  /**
   * Deletes a previous migration archive. Migration archives are automatically deleted after seven days.
   */
  "migrations/delete-archive-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        migration_id: components["parameters"]["migration_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
    };
  };
  /**
   * Unlocks a repository that was locked for migration. You should unlock each migrated repository and [delete them](https://docs.github.com/rest/reference/repos#delete-a-repository) when the migration is complete and you no longer need the source data.
   */
  "migrations/unlock-repo-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        migration_id: components["parameters"]["migration_id"];
        repo_name: components["parameters"]["repo_name"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
    };
  };
  /**
   * List all the repositories for this organization migration.
   */
  "migrations/list-repos-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        migration_id: components["parameters"]["migration_id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["minimal-repository"][];
      };
      "404": unknown;
    };
  };
  /**
   * List all users who are outside collaborators of an organization.
   */
  "orgs/list-outside-collaborators": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        /**
         * Filter the list of outside collaborators. Can be one of:
         * \* `2fa_disabled`: Outside collaborators without [two-factor authentication](https://github.com/blog/1614-two-factor-authentication) enabled.
         * \* `all`: All outside collaborators.
         */
        filter?: "2fa_disabled" | "all";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
    };
  };
  /**
   * When an organization member is converted to an outside collaborator, they'll only have access to the repositories that their current team membership allows. The user will no longer be a member of the organization. For more information, see "[Converting an organization member to an outside collaborator](https://help.github.com/articles/converting-an-organization-member-to-an-outside-collaborator/)".
   */
  "orgs/convert-member-to-outside-collaborator": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * User is getting converted asynchronously
       */
      "202": unknown;
      /**
       * User was converted
       */
      "204": never;
      /**
       * response
       */
      "403": {
        "application/json": { message?: string; documentation_url?: string };
      };
      "404": unknown;
    };
  };
  /**
   * Removing a user from this list will remove them from all the organization's repositories.
   */
  "orgs/remove-outside-collaborator": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      /**
       * Response if user is a member of the organization
       */
      "422": {
        "application/json": { message?: string; documentation_url?: string };
      };
    };
  };
  /**
   * Lists the projects in an organization. Returns a `404 Not Found` status if projects are disabled in the organization. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
   */
  "projects/list-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        /**
         * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
         */
        state?: "open" | "closed" | "all";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["project"][];
      };
      "422": unknown;
    };
  };
  /**
   * Creates an organization project board. Returns a `404 Not Found` status if projects are disabled in the organization. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
   */
  "projects/create-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The name of the project.
         */
        name: string;
        /**
         * The description of the project.
         */
        body?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["project"];
      };
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "410": unknown;
      "422": unknown;
    };
  };
  /**
   * Members of an organization can choose to have their membership publicized or not.
   */
  "orgs/list-public-members": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
    };
  };
  "orgs/check-public-membership-for-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Response if user is a public member
       */
      "204": never;
      /**
       * Response if user is not a public member
       */
      "404": unknown;
    };
  };
  /**
   * The user can publicize their own membership. (A user cannot publicize the membership for another user.)
   *
   * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
   */
  "orgs/set-public-membership-for-authenticated-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "403": unknown;
    };
  };
  "orgs/remove-public-membership-for-authenticated-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists repositories for the specified organization.
   */
  "repos/list-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        /**
         * Specifies the types of repositories you want returned. Can be one of `all`, `public`, `private`, `forks`, `sources`, `member`, `internal`. Default: `all`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `type` can also be `internal`.
         */
        type?:
          | "all"
          | "public"
          | "private"
          | "forks"
          | "sources"
          | "member"
          | "internal";
        /**
         * Can be one of `created`, `updated`, `pushed`, `full_name`.
         */
        sort?: "created" | "updated" | "pushed" | "full_name";
        /**
         * Can be one of `asc` or `desc`. Default: when using `full_name`: `asc`, otherwise `desc`
         */
        direction?: "asc" | "desc";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["minimal-repository"][];
      };
    };
  };
  /**
   * Creates a new repository in the specified organization. The authenticated user must be a member of the organization.
   *
   * **OAuth scope requirements**
   *
   * When using [OAuth](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
   *
   * *   `public_repo` scope or `repo` scope to create a public repository
   * *   `repo` scope to create a private repository
   */
  "repos/create-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The name of the repository.
         */
        name: string;
        /**
         * A short description of the repository.
         */
        description?: string;
        /**
         * A URL with more information about the repository.
         */
        homepage?: string;
        /**
         * Either `true` to create a private repository or `false` to create a public one.
         */
        private?: boolean;
        /**
         * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `visibility` can also be `internal`. For more information, see "[Creating an internal repository](https://help.github.com/en/github/creating-cloning-and-archiving-repositories/about-repository-visibility#about-internal-repositories)" in the GitHub Help documentation.
         * The `visibility` parameter overrides the `private` parameter when you use both parameters with the `nebula-preview` preview header.
         */
        visibility?: "public" | "private" | "visibility" | "internal";
        /**
         * Either `true` to enable issues for this repository or `false` to disable them.
         */
        has_issues?: boolean;
        /**
         * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
         */
        has_projects?: boolean;
        /**
         * Either `true` to enable the wiki for this repository or `false` to disable it.
         */
        has_wiki?: boolean;
        /**
         * Either `true` to make this repo available as a template repository or `false` to prevent it.
         */
        is_template?: boolean;
        /**
         * The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
         */
        team_id?: number;
        /**
         * Pass `true` to create an initial commit with empty README.
         */
        auto_init?: boolean;
        /**
         * Desired language or platform [.gitignore template](https://github.com/github/gitignore) to apply. Use the name of the template without the extension. For example, "Haskell".
         */
        gitignore_template?: string;
        /**
         * Choose an [open source license template](https://choosealicense.com/) that best suits your needs, and then use the [license keyword](https://help.github.com/articles/licensing-a-repository/#searching-github-by-license-type) as the `license_template` string. For example, "mit" or "mpl-2.0".
         */
        license_template?: string;
        /**
         * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
         */
        allow_squash_merge?: boolean;
        /**
         * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
         */
        allow_merge_commit?: boolean;
        /**
         * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
         */
        allow_rebase_merge?: boolean;
        /**
         * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
         */
        delete_branch_on_merge?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["repository"];
      };
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * Gets the summary of the free and paid GitHub Actions minutes used.
   *
   * Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://help.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
   *
   * Access tokens must have the `repo` or `admin:org` scope.
   */
  "billing/get-github-actions-billing-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["actions-billing-usage"];
      };
    };
  };
  /**
   * Gets the free and paid storage usued for GitHub Packages in gigabytes.
   *
   * Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://help.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
   *
   * Access tokens must have the `repo` or `admin:org` scope.
   */
  "billing/get-github-packages-billing-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["packages-billing-usage"];
      };
    };
  };
  /**
   * Gets the estimated paid and estimated total storage used for GitHub Actions and Github Packages.
   *
   * Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://help.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
   *
   * Access tokens must have the `repo` or `admin:org` scope.
   */
  "billing/get-shared-storage-billing-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["combined-billing-usage"];
      };
    };
  };
  /**
   * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * List IdP groups available in an organization. You can limit your page results using the `per_page` parameter. GitHub generates a url-encoded `page` token using a cursor value for where the next page begins. For more information on cursor pagination, see "[Offset and Cursor Pagination explained](https://dev.to/jackmarchant/offset-and-cursor-pagination-explained-b89)."
   *
   * The `per_page` parameter provides pagination for a list of IdP groups the authenticated user can access in an organization. For example, if the user `octocat` wants to see two groups per page in `octo-org` via cURL, it would look like this:
   */
  "teams/list-idp-groups-for-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["group-mapping"];
      };
    };
  };
  /**
   * Lists all teams in an organization that are visible to the authenticated user.
   */
  "teams/list": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team"][];
      };
      "403": unknown;
    };
  };
  /**
   * To create a team, the authenticated user must be a member or owner of `{org}`. By default, organization members can create teams. Organization owners can limit team creation to organization owners. For more information, see "[Setting team creation permissions](https://help.github.com/en/articles/setting-team-creation-permissions-in-your-organization)."
   *
   * When you create a new team, you automatically become a team maintainer without explicitly adding yourself to the optional array of `maintainers`. For more information, see "[About teams](https://help.github.com/en/github/setting-up-and-managing-organizations-and-teams/about-teams)".
   */
  "teams/create": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The name of the team.
         */
        name: string;
        /**
         * The description of the team.
         */
        description?: string;
        /**
         * List GitHub IDs for organization members who will become team maintainers.
         */
        maintainers?: string[];
        /**
         * The full name (e.g., "organization-name/repository-name") of repositories to add the team to.
         */
        repo_names?: string[];
        /**
         * The level of privacy this team should have. The options are:
         * **For a non-nested team:**
         * \* `secret` - only visible to organization owners and members of this team.
         * \* `closed` - visible to all members of this organization.
         * Default: `secret`
         * **For a parent or child team:**
         * \* `closed` - visible to all members of this organization.
         * Default for child team: `closed`
         */
        privacy?: "secret" | "closed";
        /**
         * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
         * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
         * \* `push` - team members can pull and push, but not administer newly-added repositories.
         * \* `admin` - team members can pull, push and administer newly-added repositories.
         */
        permission?: "pull" | "push" | "admin";
        /**
         * The ID of a team to set as the parent team.
         */
        parent_team_id?: number;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["team-full"];
      };
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * Gets a team using the team's `slug`. GitHub generates the `slug` from the team `name`.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}`.
   */
  "teams/get-by-name": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-full"];
      };
      "404": unknown;
    };
  };
  /**
   * To edit a team, the authenticated user must either be an organization owner or a team maintainer.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}`.
   */
  "teams/update-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The name of the team.
         */
        name: string;
        /**
         * The description of the team.
         */
        description?: string;
        /**
         * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. When a team is nested, the `privacy` for parent teams cannot be `secret`. The options are:
         * **For a non-nested team:**
         * \* `secret` - only visible to organization owners and members of this team.
         * \* `closed` - visible to all members of this organization.
         * **For a parent or child team:**
         * \* `closed` - visible to all members of this organization.
         */
        privacy?: "secret" | "closed";
        /**
         * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
         * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
         * \* `push` - team members can pull and push, but not administer newly-added repositories.
         * \* `admin` - team members can pull, push and administer newly-added repositories.
         */
        permission?: "pull" | "push" | "admin";
        /**
         * The ID of a team to set as the parent team.
         */
        parent_team_id?: number;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["team-full"];
      };
    };
  };
  /**
   * To delete a team, the authenticated user must be an organization owner or team maintainer.
   *
   * If you are an organization owner, deleting a parent team will delete all of its child teams as well.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}`.
   */
  "teams/delete-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * List all discussions on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions`.
   */
  "teams/list-discussions-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
      };
      query: {
        direction?: components["parameters"]["direction"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-discussion"][];
      };
    };
  };
  /**
   * Creates a new discussion post on a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * This endpoint triggers [notifications](https://help.github.com/articles/about-notifications/). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions`.
   */
  "teams/create-discussion-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The discussion post's title.
         */
        title: string;
        /**
         * The discussion post's body text.
         */
        body: string;
        /**
         * Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
         */
        private?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["team-discussion"];
      };
    };
  };
  /**
   * Get a specific discussion on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
   */
  "teams/get-discussion-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        discussion_number: components["parameters"]["discussion-number"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-discussion"];
      };
    };
  };
  /**
   * Edits the title and body text of a discussion post. Only the parameters you provide are updated. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
   */
  "teams/update-discussion-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        discussion_number: components["parameters"]["discussion-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The discussion post's title.
         */
        title?: string;
        /**
         * The discussion post's body text.
         */
        body?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-discussion"];
      };
    };
  };
  /**
   * Delete a discussion from a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}`.
   */
  "teams/delete-discussion-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        discussion_number: components["parameters"]["discussion-number"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * List all comments on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
   */
  "teams/list-discussion-comments-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        discussion_number: components["parameters"]["discussion-number"];
      };
      query: {
        direction?: components["parameters"]["direction"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-discussion-comment"][];
      };
    };
  };
  /**
   * Creates a new comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * This endpoint triggers [notifications](https://help.github.com/articles/about-notifications/). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments`.
   */
  "teams/create-discussion-comment-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        discussion_number: components["parameters"]["discussion-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The discussion comment's body text.
         */
        body: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["team-discussion-comment"];
      };
    };
  };
  /**
   * Get a specific comment on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
   */
  "teams/get-discussion-comment-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        discussion_number: components["parameters"]["discussion-number"];
        comment_number: components["parameters"]["comment-number"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-discussion-comment"];
      };
    };
  };
  /**
   * Edits the body text of a discussion comment. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
   */
  "teams/update-discussion-comment-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        discussion_number: components["parameters"]["discussion-number"];
        comment_number: components["parameters"]["comment-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The discussion comment's body text.
         */
        body: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-discussion-comment"];
      };
    };
  };
  /**
   * Deletes a comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/discussions/{discussion_number}/comments/{comment_number}`.
   */
  "teams/delete-discussion-comment-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        discussion_number: components["parameters"]["discussion-number"];
        comment_number: components["parameters"]["comment-number"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * List the reactions to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments/). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
   */
  "reactions/list-for-team-discussion-comment-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        discussion_number: components["parameters"]["discussion-number"];
        comment_number: components["parameters"]["comment-number"];
      };
      query: {
        /**
         * Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
         */
        content?:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["reaction"][];
      };
    };
  };
  /**
   * Create a reaction to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with a `Status: 200 OK` means that you already added the reaction type to this team discussion comment.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions`.
   */
  "reactions/create-for-team-discussion-comment-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        discussion_number: components["parameters"]["discussion-number"];
        comment_number: components["parameters"]["comment-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the team discussion comment.
         */
        content:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["reaction"];
      };
    };
  };
  /**
   * **Note:** You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/comments/:comment_number/reactions/:reaction_id`.
   *
   * Delete a reaction to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "reactions/delete-for-team-discussion-comment": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        discussion_number: components["parameters"]["discussion-number"];
        comment_number: components["parameters"]["comment-number"];
        reaction_id: components["parameters"]["reaction-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * List the reactions to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
   */
  "reactions/list-for-team-discussion-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        discussion_number: components["parameters"]["discussion-number"];
      };
      query: {
        /**
         * Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a team discussion.
         */
        content?:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["reaction"][];
      };
    };
  };
  /**
   * Create a reaction to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with a `Status: 200 OK` means that you already added the reaction type to this team discussion.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `POST /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions`.
   */
  "reactions/create-for-team-discussion-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        discussion_number: components["parameters"]["discussion-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the team discussion.
         */
        content:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["reaction"];
      };
    };
  };
  /**
   * **Note:** You can also specify a team or organization with `team_id` and `org_id` using the route `DELETE /organizations/:org_id/team/:team_id/discussions/:discussion_number/reactions/:reaction_id`.
   *
   * Delete a reaction to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "reactions/delete-for-team-discussion": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        discussion_number: components["parameters"]["discussion-number"];
        reaction_id: components["parameters"]["reaction-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/invitations`.
   */
  "teams/list-pending-invitations-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["organization-invitation"][];
      };
    };
  };
  /**
   * Team members will include the members of child teams.
   *
   * To list members in a team, the team must be visible to the authenticated user.
   */
  "teams/list-members-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
      };
      query: {
        /**
         * Filters members returned by their role in the team. Can be one of:
         * \* `member` - normal members of the team.
         * \* `maintainer` - team maintainers.
         * \* `all` - all members of the team.
         */
        role?: "member" | "maintainer" | "all";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
    };
  };
  /**
   * Team members will include the members of child teams.
   *
   * To get a user's membership with a team, the team must be visible to the authenticated user.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/memberships/{username}`.
   *
   * **Note:** The `role` for organization owners returns as `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/rest/reference/teams#create-a-team).
   */
  "teams/get-membership-for-user-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-membership"];
      };
      /**
       * Response if user has no team membership
       */
      "404": unknown;
    };
  };
  /**
   * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Adds an organization member to a team. An authenticated organization owner or team maintainer can add organization members to a team.
   *
   * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
   *
   * An organization owner can add someone who is not part of the team's organization to a team. When an organization owner adds someone to a team who is not an organization member, this endpoint will send an invitation to the person via email. This newly-created membership will be in the "pending" state until the person accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team.
   *
   * If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/memberships/{username}`.
   */
  "teams/add-or-update-membership-for-user-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        username: components["parameters"]["username"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The role that this user should have in the team. Can be one of:
         * \* `member` - a normal member of the team.
         * \* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
         */
        role?: "member" | "maintainer";
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-membership"];
      };
      /**
       * Response if team synchronization is set up
       */
      "403": unknown;
      /**
       * Response if you attempt to add an organization to a team
       */
      "422": {
        "application/json": {
          message?: string;
          errors?: { code?: string; field?: string; resource?: string }[];
        };
      };
    };
  };
  /**
   * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
   *
   * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/memberships/{username}`.
   */
  "teams/remove-membership-for-user-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      /**
       * Response if team synchronization is set up
       */
      "403": unknown;
    };
  };
  /**
   * Lists the organization projects for a team.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/projects`.
   */
  "teams/list-projects-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-project"][];
      };
    };
  };
  /**
   * Checks whether a team has `read`, `write`, or `admin` permissions for an organization project. The response includes projects inherited from a parent team.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
   */
  "teams/check-permissions-for-project-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        project_id: components["parameters"]["project-id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-project"];
      };
      /**
       * Response if project is not managed by this team
       */
      "404": unknown;
    };
  };
  /**
   * Adds an organization project to a team. To add a project to a team or update the team's permission on a project, the authenticated user must have `admin` permissions for the project. The project and team must be part of the same organization.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
   */
  "teams/add-or-update-project-permissions-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        project_id: components["parameters"]["project-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The permission to grant to the team for this project. Can be one of:
         * \* `read` - team members can read, but not write to or administer this project.
         * \* `write` - team members can read and write, but not administer this project.
         * \* `admin` - team members can read, write and administer this project.
         * Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
         */
        permission?: "read" | "write" | "admin";
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      /**
       * Response if the project is not owned by the organization
       */
      "403": {
        "application/json": { message?: string; documentation_url?: string };
      };
    };
  };
  /**
   * Removes an organization project from a team. An organization owner or a team maintainer can remove any project from the team. To remove a project from a team as an organization member, the authenticated user must have `read` access to both the team and project, or `admin` access to the team or project. This endpoint removes the project from the team, but does not delete the project.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/projects/{project_id}`.
   */
  "teams/remove-project-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        project_id: components["parameters"]["project-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists a team's repositories visible to the authenticated user.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos`.
   */
  "teams/list-repos-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["minimal-repository"][];
      };
    };
  };
  /**
   * Checks whether a team has `admin`, `push`, `maintain`, `triage`, or `pull` permission for a repository. Repositories inherited through a parent team will also be checked.
   *
   * You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `application/vnd.github.v3.repository+json` accept header.
   *
   * If a team doesn't have permission for the repository, you will receive a `404 Not Found` response status.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
   */
  "teams/check-permissions-for-repo-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Alternative response with repository permissions
       */
      "200": {
        "application/vnd.github.v3.repository+json": components["schemas"]["team-repository"];
      };
      /**
       * Response if team has permission for the repository
       */
      "204": never;
      /**
       * Response if team does not have permission for the repository
       */
      "404": unknown;
    };
  };
  /**
   * To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PUT /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
   *
   * For more information about the permission levels, see "[Repository permission levels for an organization](https://help.github.com/en/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)".
   */
  "teams/add-or-update-repo-permissions-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The permission to grant the team on this repository. Can be one of:
         * \* `pull` - team members can pull, but not push to or administer this repository.
         * \* `push` - team members can pull and push, but not administer this repository.
         * \* `admin` - team members can pull, push and administer this repository.
         * \* `maintain` - team members can manage the repository without access to sensitive or destructive actions. Recommended for project managers. Only applies to repositories owned by organizations.
         * \* `triage` - team members can proactively manage issues and pull requests without write access. Recommended for contributors who triage a repository. Only applies to repositories owned by organizations.
         *
         * If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
         */
        permission?: "pull" | "push" | "admin" | "maintain" | "triage";
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. This does not delete the repository, it just removes it from the team.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `DELETE /organizations/{org_id}/team/{team_id}/repos/{owner}/{repo}`.
   */
  "teams/remove-repo-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * List IdP groups connected to a team on GitHub.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/team-sync/group-mappings`.
   */
  "teams/list-idp-groups-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["group-mapping"];
      };
    };
  };
  /**
   * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Creates, updates, or removes a connection between a team and an IdP group. When adding groups to a team, you must include all new and existing groups to avoid replacing existing groups with the new ones. Specifying an empty `groups` array will remove all connections for a team.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `PATCH /organizations/{org_id}/team/{team_id}/team-sync/group-mappings`.
   */
  "teams/create-or-update-idp-group-connections-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The IdP groups you want to connect to a GitHub team. When updating, the new `groups` object will replace the original one. You must include any existing groups that you don't want to remove.
         */
        groups: {
          /**
           * ID of the IdP group.
           */
          group_id: string;
          /**
           * Name of the IdP group.
           */
          group_name: string;
          /**
           * Description of the IdP group.
           */
          group_description: string;
        }[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["group-mapping"];
      };
    };
  };
  /**
   * Lists the child teams of the team specified by `{team_slug}`.
   *
   * **Note:** You can also specify a team by `org_id` and `team_id` using the route `GET /organizations/{org_id}/team/{team_id}/teams`.
   */
  "teams/list-child-in-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        team_slug: components["parameters"]["team_slug"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * Response if child teams exist
       */
      "200": {
        "application/json": components["schemas"]["team"][];
      };
    };
  };
  "projects/get-card": {
    parameters: {
      path: {
        card_id: components["parameters"]["card_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["project-card"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  "projects/update-card": {
    parameters: {
      path: {
        card_id: components["parameters"]["card_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The project card's note
         */
        note?: string | null;
        /**
         * Whether or not the card is archived
         */
        archived?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["project-card"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  "projects/delete-card": {
    parameters: {
      path: {
        card_id: components["parameters"]["card_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      /**
       * Forbidden
       */
      "403": {
        "application/json": {
          message?: string;
          documentation_url?: string;
          errors?: string[];
        };
      };
      "404": unknown;
    };
  };
  "projects/move-card": {
    parameters: {
      path: {
        card_id: components["parameters"]["card_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The position of the card in a column
         */
        position: string;
        /**
         * The unique identifier of the column the card should be moved to
         */
        column_id?: number;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": { [key: string]: any };
      };
      "304": never;
      "401": unknown;
      /**
       * Forbidden
       */
      "403": {
        "application/json": {
          message?: string;
          documentation_url?: string;
          errors?: {
            code?: string;
            message?: string;
            resource?: string;
            field?: string;
          }[];
        };
      };
      "422": unknown;
      /**
       * Service Unavailable
       */
      "503": {
        "application/json": {
          code?: string;
          message?: string;
          documentation_url?: string;
          errors?: { code?: string; message?: string }[];
        };
      };
    };
  };
  "projects/get-column": {
    parameters: {
      path: {
        column_id: components["parameters"]["column_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["project-column"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  "projects/update-column": {
    parameters: {
      path: {
        column_id: components["parameters"]["column_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Name of the project column
         */
        name: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["project-column"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  "projects/delete-column": {
    parameters: {
      path: {
        column_id: components["parameters"]["column_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  "projects/list-cards": {
    parameters: {
      path: {
        column_id: components["parameters"]["column_id"];
      };
      query: {
        /**
         * Filters the project cards that are returned by the card's state. Can be one of `all`,`archived`, or `not_archived`.
         */
        archived_state?: "all" | "archived" | "not_archived";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["project-card"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  /**
   * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by the `pull_request` key.
   *
   * Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
   */
  "projects/create-card": {
    parameters: {
      path: {
        column_id: components["parameters"]["column_id"];
      };
    };
    requestBody: {
      "application/json":
        | {
            /**
             * The project card's note
             */
            note: string | null;
          }
        | {
            /**
             * The unique identifier of the content associated with the card
             */
            content_id: number;
            /**
             * The piece of content associated with the card
             */
            content_type: string;
          };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["project-card"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      /**
       * Validation Failed
       */
      "422": {
        "application/json":
          | components["schemas"]["validation-error"]
          | components["schemas"]["validation-error-simple"];
      };
      /**
       * Service Unavailable
       */
      "503": {
        "application/json": {
          code?: string;
          message?: string;
          documentation_url?: string;
          errors?: { code?: string; message?: string }[];
        };
      };
    };
  };
  "projects/move-column": {
    parameters: {
      path: {
        column_id: components["parameters"]["column_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The position of the column in a project
         */
        position: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": { [key: string]: any };
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * Gets a project by its `id`. Returns a `404 Not Found` status if projects are disabled. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
   */
  "projects/get": {
    parameters: {
      path: {
        project_id: components["parameters"]["project-id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["project"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  /**
   * Updates a project board's information. Returns a `404 Not Found` status if projects are disabled. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
   */
  "projects/update": {
    parameters: {
      path: {
        project_id: components["parameters"]["project-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Name of the project
         */
        name?: string;
        /**
         * Body of the project
         */
        body?: string | null;
        /**
         * State of the project; either 'open' or 'closed'
         */
        state?: string;
        /**
         * The baseline permission that all organization members have on this project
         */
        organization_permission?: "read" | "write" | "admin" | "none";
        /**
         * Whether or not this project can be seen by everyone.
         */
        private?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["project"];
      };
      "304": never;
      "401": unknown;
      /**
       * Forbidden
       */
      "403": {
        "application/json": {
          message?: string;
          documentation_url?: string;
          errors?: string[];
        };
      };
      /**
       * Response if the authenticated user does not have access to the project
       */
      "404": unknown;
      "410": unknown;
      "422": unknown;
    };
  };
  /**
   * Deletes a project board. Returns a `404 Not Found` status if projects are disabled.
   */
  "projects/delete": {
    parameters: {
      path: {
        project_id: components["parameters"]["project-id"];
      };
    };
    responses: {
      /**
       * Delete Success
       */
      "204": never;
      "304": never;
      "401": unknown;
      /**
       * Forbidden
       */
      "403": {
        "application/json": {
          message?: string;
          documentation_url?: string;
          errors?: string[];
        };
      };
      "404": unknown;
      "410": unknown;
    };
  };
  /**
   * Lists the collaborators for an organization project. For a project, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners. You must be an organization owner or a project `admin` to list collaborators.
   */
  "projects/list-collaborators": {
    parameters: {
      path: {
        project_id: components["parameters"]["project-id"];
      };
      query: {
        /**
         * Filters the collaborators by their affiliation. Can be one of:
         * \* `outside`: Outside collaborators of a project that are not a member of the project's organization.
         * \* `direct`: Collaborators with permissions to a project, regardless of organization membership status.
         * \* `all`: All collaborators the authenticated user can see.
         */
        affiliation?: "outside" | "direct" | "all";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * Adds a collaborator to an organization project and sets their permission level. You must be an organization owner or a project `admin` to add a collaborator.
   */
  "projects/add-collaborator": {
    parameters: {
      path: {
        project_id: components["parameters"]["project-id"];
        username: components["parameters"]["username"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The permission to grant the collaborator.
         */
        permission?: "read" | "write" | "admin";
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * Removes a collaborator from an organization project. You must be an organization owner or a project `admin` to remove a collaborator.
   */
  "projects/remove-collaborator": {
    parameters: {
      path: {
        project_id: components["parameters"]["project-id"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * Returns the collaborator's permission level for an organization project. Possible values for the `permission` key: `admin`, `write`, `read`, `none`. You must be an organization owner or a project `admin` to review a user's permission level.
   */
  "projects/get-permission-for-user": {
    parameters: {
      path: {
        project_id: components["parameters"]["project-id"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["repository-collaborator-permission"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "415": unknown;
      "422": unknown;
    };
  };
  "projects/list-columns": {
    parameters: {
      path: {
        project_id: components["parameters"]["project-id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["project-column"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  "projects/create-column": {
    parameters: {
      path: {
        project_id: components["parameters"]["project-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Name of the project column
         */
        name: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["project-column"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * **Note:** Accessing this endpoint does not count against your REST API rate limit.
   *
   * **Note:** The `rate` object is deprecated. If you're writing new API client code or updating existing code, you should use the `core` object instead of the `rate` object. The `core` object contains the same information that is present in the `rate` object.
   */
  "rate-limit/get": {
    parameters: {};
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["rate-limit-overview"];
      };
      "304": never;
      "404": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Reactions API. We recommend migrating your existing code to use the new delete reactions endpoints. For more information, see this [blog post](https://developer.github.com/changes/2020-02-26-new-delete-reactions-endpoints/).
   *
   * OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), when deleting a [team discussion](https://docs.github.com/rest/reference/teams#discussions) or [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments).
   */
  "reactions/delete-legacy": {
    parameters: {
      path: {
        reaction_id: components["parameters"]["reaction-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      "410": unknown;
      "415": unknown;
    };
  };
  /**
   * When you pass the `scarlet-witch-preview` media type, requests to get a repository will also return the repository's code of conduct if it can be detected from the repository's code of conduct file.
   *
   * The `parent` and `source` objects are present when the repository is a fork. `parent` is the repository this repository was forked from, `source` is the ultimate source for the network.
   */
  "repos/get": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["full-repository"];
      };
      "301": never;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * **Note**: To edit a repository's topics, use the [Replace all repository topics](https://docs.github.com/rest/reference/repos#replace-all-repository-topics) endpoint.
   */
  "repos/update": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The name of the repository.
         */
        name?: string;
        /**
         * A short description of the repository.
         */
        description?: string;
        /**
         * A URL with more information about the repository.
         */
        homepage?: string;
        /**
         * Either `true` to make the repository private or `false` to make it public. Default: `false`.
         * **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private. **Note**: You will get a `422` error if the organization restricts [changing repository visibility](https://help.github.com/articles/repository-permission-levels-for-an-organization#changing-the-visibility-of-repositories) to organization owners and a non-owner tries to change the value of private.
         */
        private?: boolean;
        /**
         * Can be `public` or `private`. If your organization is associated with an enterprise account using GitHub Enterprise Cloud or GitHub Enterprise Server 2.20+, `visibility` can also be `internal`. The `visibility` parameter overrides the `private` parameter when you use both along with the `nebula-preview` preview header.
         */
        visibility?: "public" | "private" | "visibility" | "internal";
        /**
         * Either `true` to enable issues for this repository or `false` to disable them.
         */
        has_issues?: boolean;
        /**
         * Either `true` to enable projects for this repository or `false` to disable them. **Note:** If you're creating a repository in an organization that has disabled repository projects, the default is `false`, and if you pass `true`, the API returns an error.
         */
        has_projects?: boolean;
        /**
         * Either `true` to enable the wiki for this repository or `false` to disable it.
         */
        has_wiki?: boolean;
        /**
         * Either `true` to make this repo available as a template repository or `false` to prevent it.
         */
        is_template?: boolean;
        /**
         * Updates the default branch for this repository.
         */
        default_branch?: string;
        /**
         * Either `true` to allow squash-merging pull requests, or `false` to prevent squash-merging.
         */
        allow_squash_merge?: boolean;
        /**
         * Either `true` to allow merging pull requests with a merge commit, or `false` to prevent merging pull requests with merge commits.
         */
        allow_merge_commit?: boolean;
        /**
         * Either `true` to allow rebase-merging pull requests, or `false` to prevent rebase-merging.
         */
        allow_rebase_merge?: boolean;
        /**
         * Either `true` to allow automatically deleting head branches when pull requests are merged, or `false` to prevent automatic deletion.
         */
        delete_branch_on_merge?: boolean;
        /**
         * `true` to archive this repository. **Note**: You cannot unarchive repositories through the API.
         */
        archived?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["full-repository"];
      };
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Deleting a repository requires admin access. If OAuth is used, the `delete_repo` scope is required.
   *
   * If an organization owner has configured the organization to prevent members from deleting organization-owned
   * repositories, you will get a `403 Forbidden` response.
   */
  "repos/delete": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      /**
       * If an organization owner has configured the organization to prevent members from deleting organization-owned repositories, a member will get this response:
       */
      "403": {
        "application/json": { message?: string; documentation_url?: string };
      };
      "404": unknown;
    };
  };
  /**
   * Lists all artifacts for a repository. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
   */
  "actions/list-artifacts-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          artifacts: components["schemas"]["artifact"][];
        };
      };
    };
  };
  /**
   * Gets a specific artifact for a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
   */
  "actions/get-artifact": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        artifact_id: components["parameters"]["artifact_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["artifact"];
      };
    };
  };
  /**
   * Deletes an artifact for a workflow run. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
   */
  "actions/delete-artifact": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        artifact_id: components["parameters"]["artifact_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Gets a redirect URL to download an archive for a repository. This URL expires after 1 minute. Look for `Location:` in
   * the response header to find the URL for the download. The `:archive_format` must be `zip`. Anyone with read access to
   * the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope.
   * GitHub Apps must have the `actions:read` permission to use this endpoint.
   */
  "actions/download-artifact": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        artifact_id: components["parameters"]["artifact_id"];
        archive_format: string;
      };
    };
    responses: {
      /**
       * response
       */
      "302": never;
    };
  };
  /**
   * Gets a specific job in a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
   */
  "actions/get-job-for-workflow-run": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        job_id: components["parameters"]["job_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "202": {
        "application/json": components["schemas"]["job"];
      };
    };
  };
  /**
   * Gets a redirect URL to download a plain text file of logs for a workflow job. This link expires after 1 minute. Look
   * for `Location:` in the response header to find the URL for the download. Anyone with read access to the repository can
   * use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must
   * have the `actions:read` permission to use this endpoint.
   */
  "actions/download-job-logs-for-workflow-run": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        job_id: components["parameters"]["job_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "302": never;
    };
  };
  /**
   * Gets the GitHub Actions permissions policy for a repository, including whether GitHub Actions is enabled and the actions allowed to run in the repository.
   *
   * You must authenticate using an access token with the `repo` scope to use this
   * endpoint. GitHub Apps must have the `administration` repository permission to use this API.
   */
  "actions/get-github-actions-permissions-repository": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["actions-repository-permissions"];
      };
    };
  };
  /**
   * Sets the GitHub Actions permissions policy for enabling GitHub Actions and allowed actions in the repository.
   *
   * If the repository belongs to an organization or enterprise that has set restrictive permissions at the organization or enterprise levels, such as `allowed_actions` to `selected` actions, then you cannot override them for the repository.
   *
   * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
   */
  "actions/set-github-actions-permissions-repository": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        enabled: components["schemas"]["actions-enabled"];
        allowed_actions?: components["schemas"]["allowed-actions"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Gets the settings for selected actions that are allowed in a repository. To use this endpoint, the repository policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
   *
   * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
   */
  "actions/get-allowed-actions-repository": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["selected-actions"];
      };
    };
  };
  /**
   * Sets the actions that are allowed in a repository. To use this endpoint, the repository permission policy for `allowed_actions` must be configured to `selected`. For more information, see "[Set GitHub Actions permissions for a repository](#set-github-actions-permissions-for-a-repository)."
   *
   * If the repository belongs to an organization or enterprise that has `selected` actions set at the organization or enterprise levels, then you cannot override any of the allowed actions settings.
   *
   * To use the `patterns_allowed` setting for private repositories, the repository must belong to an enterprise. If the repository does not belong to an enterprise, then the `patterns_allowed` setting only applies to public repositories.
   *
   * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `administration` repository permission to use this API.
   */
  "actions/set-allowed-actions-repository": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": components["schemas"]["selected-actions"];
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists all self-hosted runners configured in a repository. You must authenticate using an access token with the `repo` scope to use this endpoint.
   */
  "actions/list-self-hosted-runners-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          runners: components["schemas"]["runner"][];
        };
      };
    };
  };
  /**
   * Lists binaries for the runner application that you can download and run.
   *
   * You must authenticate using an access token with the `repo` scope to use this endpoint.
   */
  "actions/list-runner-applications-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["runner-application"][];
      };
    };
  };
  /**
   * Returns a token that you can pass to the `config` script. The token expires after one hour. You must authenticate
   * using an access token with the `repo` scope to use this endpoint.
   *
   * #### Example using registration token
   *
   * Configure your self-hosted runner, replacing `TOKEN` with the registration token provided by this endpoint.
   *
   * ```
   * ./config.sh --url https://github.com/octo-org/octo-repo-artifacts --token TOKEN
   * ```
   */
  "actions/create-registration-token-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["authentication-token"];
      };
    };
  };
  /**
   * Returns a token that you can pass to remove a self-hosted runner from a repository. The token expires after one hour.
   * You must authenticate using an access token with the `repo` scope to use this endpoint.
   *
   * #### Example using remove token
   *
   * To remove your self-hosted runner from a repository, replace TOKEN with the remove token provided by this endpoint.
   *
   * ```
   * ./config.sh remove --token TOKEN
   * ```
   */
  "actions/create-remove-token-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["authentication-token"];
      };
    };
  };
  /**
   * Gets a specific self-hosted runner configured in a repository.
   *
   * You must authenticate using an access token with the `repo` scope to use this
   * endpoint.
   */
  "actions/get-self-hosted-runner-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        runner_id: components["parameters"]["runner_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["runner"];
      };
    };
  };
  /**
   * Forces the removal of a self-hosted runner from a repository. You can use this endpoint to completely remove the runner when the machine you were using no longer exists.
   *
   * You must authenticate using an access token with the `repo`
   * scope to use this endpoint.
   */
  "actions/delete-self-hosted-runner-from-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        runner_id: components["parameters"]["runner_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists all workflow runs for a repository. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/overview/resources-in-the-rest-api#parameters).
   *
   * Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
   */
  "actions/list-workflow-runs-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        actor?: components["parameters"]["actor"];
        branch?: components["parameters"]["workflow-run-branch"];
        event?: components["parameters"]["event"];
        status?: components["parameters"]["workflow-run-status"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          workflow_runs: components["schemas"]["workflow-run"][];
        };
      };
    };
  };
  /**
   * Gets a specific workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
   */
  "actions/get-workflow-run": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        run_id: components["parameters"]["run-id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["workflow-run"];
      };
    };
  };
  /**
   * Delete a specific workflow run. Anyone with write access to the repository can use this endpoint. If the repository is
   * private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:write` permission to use
   * this endpoint.
   */
  "actions/delete-workflow-run": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        run_id: components["parameters"]["run-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists artifacts for a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
   */
  "actions/list-workflow-run-artifacts": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        run_id: components["parameters"]["run-id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          artifacts: components["schemas"]["artifact"][];
        };
      };
    };
  };
  /**
   * Cancels a workflow run using its `id`. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
   */
  "actions/cancel-workflow-run": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        run_id: components["parameters"]["run-id"];
      };
    };
    responses: {
      /**
       * response
       */
      "202": unknown;
    };
  };
  /**
   * Lists jobs for a workflow run. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/overview/resources-in-the-rest-api#parameters).
   */
  "actions/list-jobs-for-workflow-run": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        run_id: components["parameters"]["run-id"];
      };
      query: {
        /**
         * Filters jobs by their `completed_at` timestamp. Can be one of:
         * \* `latest`: Returns jobs from the most recent execution of the workflow run.
         * \* `all`: Returns all jobs for a workflow run, including from old executions of the workflow run.
         */
        filter?: "latest" | "all";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          jobs: components["schemas"]["job"][];
        };
      };
    };
  };
  /**
   * Gets a redirect URL to download an archive of log files for a workflow run. This link expires after 1 minute. Look for
   * `Location:` in the response header to find the URL for the download. Anyone with read access to the repository can use
   * this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have
   * the `actions:read` permission to use this endpoint.
   */
  "actions/download-workflow-run-logs": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        run_id: components["parameters"]["run-id"];
      };
    };
    responses: {
      /**
       * response
       */
      "302": never;
    };
  };
  /**
   * Deletes all logs for a workflow run. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
   */
  "actions/delete-workflow-run-logs": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        run_id: components["parameters"]["run-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Re-runs your workflow run using its `id`. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
   */
  "actions/re-run-workflow": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        run_id: components["parameters"]["run-id"];
      };
    };
    responses: {
      /**
       * response
       */
      "201": unknown;
    };
  };
  /**
   * Gets the number of billable minutes and total run time for a specific workflow run. Billable minutes only apply to workflows in private repositories that use GitHub-hosted runners. Usage is listed for each GitHub-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://help.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
   *
   * Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
   */
  "actions/get-workflow-run-usage": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        run_id: components["parameters"]["run-id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["workflow-run-usage"];
      };
    };
  };
  /**
   * Lists all secrets available in a repository without revealing their encrypted values. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint.
   */
  "actions/list-repo-secrets": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          secrets: components["schemas"]["actions-secret"][];
        };
      };
    };
  };
  /**
   * Gets your public key, which you need to encrypt secrets. You need to encrypt a secret before you can create or update secrets. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `secrets` repository permission to use this endpoint.
   */
  "actions/get-repo-public-key": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["actions-public-key"];
      };
    };
  };
  /**
   * Gets a single repository secret without revealing its encrypted value. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint.
   */
  "actions/get-repo-secret": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        secret_name: components["parameters"]["secret_name"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["actions-secret"];
      };
    };
  };
  /**
   * Creates or updates a repository secret with an encrypted value. Encrypt your secret using
   * [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages). You must authenticate using an access
   * token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use
   * this endpoint.
   *
   * #### Example encrypting a secret using Node.js
   *
   * Encrypt your secret using the [tweetsodium](https://github.com/github/tweetsodium) library.
   *
   * ```
   * const sodium = require('tweetsodium');
   *
   * const key = "base64-encoded-public-key";
   * const value = "plain-text-secret";
   *
   * // Convert the message and key to Uint8Array's (Buffer implements that interface)
   * const messageBytes = Buffer.from(value);
   * const keyBytes = Buffer.from(key, 'base64');
   *
   * // Encrypt using LibSodium.
   * const encryptedBytes = sodium.seal(messageBytes, keyBytes);
   *
   * // Base64 the encrypted secret
   * const encrypted = Buffer.from(encryptedBytes).toString('base64');
   *
   * console.log(encrypted);
   * ```
   *
   *
   * #### Example encrypting a secret using Python
   *
   * Encrypt your secret using [pynacl](https://pynacl.readthedocs.io/en/stable/public/#nacl-public-sealedbox) with Python 3.
   *
   * ```
   * from base64 import b64encode
   * from nacl import encoding, public
   *
   * def encrypt(public_key: str, secret_value: str) -> str:
   *   """Encrypt a Unicode string using the public key."""
   *   public_key = public.PublicKey(public_key.encode("utf-8"), encoding.Base64Encoder())
   *   sealed_box = public.SealedBox(public_key)
   *   encrypted = sealed_box.encrypt(secret_value.encode("utf-8"))
   *   return b64encode(encrypted).decode("utf-8")
   * ```
   *
   * #### Example encrypting a secret using C#
   *
   * Encrypt your secret using the [Sodium.Core](https://www.nuget.org/packages/Sodium.Core/) package.
   *
   * ```
   * var secretValue = System.Text.Encoding.UTF8.GetBytes("mySecret");
   * var publicKey = Convert.FromBase64String("2Sg8iYjAxxmI2LvUXpJjkYrMxURPc8r+dB7TJyvvcCU=");
   *
   * var sealedPublicKeyBox = Sodium.SealedPublicKeyBox.Create(secretValue, publicKey);
   *
   * Console.WriteLine(Convert.ToBase64String(sealedPublicKeyBox));
   * ```
   *
   * #### Example encrypting a secret using Ruby
   *
   * Encrypt your secret using the [rbnacl](https://github.com/RubyCrypto/rbnacl) gem.
   *
   * ```ruby
   * require "rbnacl"
   * require "base64"
   *
   * key = Base64.decode64("+ZYvJDZMHUfBkJdyq5Zm9SKqeuBQ4sj+6sfjlH4CgG0=")
   * public_key = RbNaCl::PublicKey.new(key)
   *
   * box = RbNaCl::Boxes::Sealed.from_public_key(public_key)
   * encrypted_secret = box.encrypt("my_secret")
   *
   * # Print the base64 encoded secret
   * puts Base64.strict_encode64(encrypted_secret)
   * ```
   */
  "actions/create-or-update-repo-secret": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        secret_name: components["parameters"]["secret_name"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Value for your secret, encrypted with [LibSodium](https://libsodium.gitbook.io/doc/bindings_for_other_languages) using the public key retrieved from the [Get a repository public key](https://docs.github.com/rest/reference/actions#get-a-repository-public-key) endpoint.
         */
        encrypted_value?: string;
        /**
         * ID of the key you used to encrypt the secret.
         */
        key_id?: string;
      };
    };
    responses: {
      /**
       * Response when creating a secret
       */
      "201": unknown;
      /**
       * Response when updating a secret
       */
      "204": never;
    };
  };
  /**
   * Deletes a secret in a repository using the secret name. You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `secrets` repository permission to use this endpoint.
   */
  "actions/delete-repo-secret": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        secret_name: components["parameters"]["secret_name"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists the workflows in a repository. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
   */
  "actions/list-repo-workflows": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          workflows: components["schemas"]["workflow"][];
        };
      };
    };
  };
  /**
   * Gets a specific workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
   */
  "actions/get-workflow": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        workflow_id: components["parameters"]["workflow-id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["workflow"];
      };
    };
  };
  /**
   * Disables a workflow and sets the `state` of the workflow to `disabled_manually`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
   *
   * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
   */
  "actions/disable-workflow": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        workflow_id: components["parameters"]["workflow-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * You can use this endpoint to manually trigger a GitHub Actions workflow run. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
   *
   * You must configure your GitHub Actions workflow to run when the [`workflow_dispatch` webhook](/developers/webhooks-and-events/webhook-events-and-payloads#workflow_dispatch) event occurs. The `inputs` are configured in the workflow file. For more information about how to configure the `workflow_dispatch` event in the workflow file, see "[Events that trigger workflows](/actions/reference/events-that-trigger-workflows#workflow_dispatch)."
   *
   * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint. For more information, see "[Creating a personal access token for the command line](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line)."
   */
  "actions/create-workflow-dispatch": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        workflow_id: components["parameters"]["workflow-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The git reference for the workflow. The reference can be a branch or tag name.
         */
        ref: string;
        /**
         * Input keys and values configured in the workflow file. The maximum number of properties is 10. Any default properties configured in the workflow file will be used when `inputs` are omitted.
         */
        inputs?: { [key: string]: string };
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Enables a workflow and sets the `state` of the workflow to `active`. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`.
   *
   * You must authenticate using an access token with the `repo` scope to use this endpoint. GitHub Apps must have the `actions:write` permission to use this endpoint.
   */
  "actions/enable-workflow": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        workflow_id: components["parameters"]["workflow-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * List all workflow runs for a workflow. You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. You can use parameters to narrow the list of results. For more information about using parameters, see [Parameters](https://docs.github.com/rest/overview/resources-in-the-rest-api#parameters).
   *
   * Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope.
   */
  "actions/list-workflow-runs": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        workflow_id: components["parameters"]["workflow-id"];
      };
      query: {
        actor?: components["parameters"]["actor"];
        branch?: components["parameters"]["workflow-run-branch"];
        event?: components["parameters"]["event"];
        status?: components["parameters"]["workflow-run-status"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          workflow_runs: components["schemas"]["workflow-run"][];
        };
      };
    };
  };
  /**
   * Gets the number of billable minutes used by a specific workflow during the current billing cycle. Billable minutes only apply to workflows in private repositories that use GitHub-hosted runners. Usage is listed for each GitHub-hosted runner operating system in milliseconds. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://help.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
   *
   * You can replace `workflow_id` with the workflow file name. For example, you could use `main.yaml`. Anyone with read access to the repository can use this endpoint. If the repository is private you must use an access token with the `repo` scope. GitHub Apps must have the `actions:read` permission to use this endpoint.
   */
  "actions/get-workflow-usage": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        workflow_id: components["parameters"]["workflow-id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["workflow-usage"];
      };
    };
  };
  /**
   * Lists the [available assignees](https://help.github.com/articles/assigning-issues-and-pull-requests-to-other-github-users/) for issues in a repository.
   */
  "issues/list-assignees": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
      "404": unknown;
    };
  };
  /**
   * Checks if a user has permission to be assigned to an issue in this repository.
   *
   * If the `assignee` can be assigned to issues in the repository, a `204` header with no content is returned.
   *
   * Otherwise a `404` status code is returned.
   */
  "issues/check-user-can-be-assigned": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        assignee: string;
      };
    };
    responses: {
      /**
       * If the `assignee` can be assigned to issues in the repository, a `204` header with no content is returned.
       */
      "204": never;
      /**
       * Otherwise a `404` status code is returned.
       */
      "404": {
        "application/json": components["schemas"]["basic-error"];
      };
    };
  };
  /**
   * Enables automated security fixes for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring automated security fixes](https://help.github.com/en/articles/configuring-automated-security-fixes)".
   */
  "repos/enable-automated-security-fixes": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Disables automated security fixes for a repository. The authenticated user must have admin access to the repository. For more information, see "[Configuring automated security fixes](https://help.github.com/en/articles/configuring-automated-security-fixes)".
   */
  "repos/disable-automated-security-fixes": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  "repos/list-branches": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        /**
         * Setting to `true` returns only protected branches. When set to `false`, only unprotected branches are returned. Omitting this parameter returns all branches.
         */
        protected?: boolean;
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["short-branch"][];
      };
      "404": unknown;
    };
  };
  "repos/get-branch": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["branch-with-protection"];
      };
      "404": unknown;
      "415": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   */
  "repos/get-branch-protection": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["branch-protection"];
      };
      "404": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Protecting a branch requires admin or owner permissions to the repository.
   *
   * **Note**: Passing new arrays of `users` and `teams` replaces their previous values.
   *
   * **Note**: The list of users, apps, and teams in total is limited to 100 items.
   */
  "repos/update-branch-protection": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Require status checks to pass before merging. Set to `null` to disable.
         */
        required_status_checks: {
          /**
           * Require branches to be up to date before merging.
           */
          strict: boolean;
          /**
           * The list of status checks to require in order to merge into this branch
           */
          contexts: string[];
        } | null;
        /**
         * Enforce all configured restrictions for administrators. Set to `true` to enforce required status checks for repository administrators. Set to `null` to disable.
         */
        enforce_admins: boolean | null;
        /**
         * Require at least one approving review on a pull request, before merging. Set to `null` to disable.
         */
        required_pull_request_reviews: {
          /**
           * Specify which users and teams can dismiss pull request reviews. Pass an empty `dismissal_restrictions` object to disable. User and team `dismissal_restrictions` are only available for organization-owned repositories. Omit this parameter for personal repositories.
           */
          dismissal_restrictions?: {
            /**
             * The list of user `login`s with dismissal access
             */
            users?: string[];
            /**
             * The list of team `slug`s with dismissal access
             */
            teams?: string[];
          };
          /**
           * Set to `true` if you want to automatically dismiss approving reviews when someone pushes a new commit.
           */
          dismiss_stale_reviews?: boolean;
          /**
           * Blocks merging pull requests until [code owners](https://help.github.com/articles/about-code-owners/) review them.
           */
          require_code_owner_reviews?: boolean;
          /**
           * Specify the number of reviewers required to approve pull requests. Use a number between 1 and 6.
           */
          required_approving_review_count?: number;
        } | null;
        /**
         * Restrict who can push to the protected branch. User, app, and team `restrictions` are only available for organization-owned repositories. Set to `null` to disable.
         */
        restrictions: {
          /**
           * The list of user `login`s with push access
           */
          users: string[];
          /**
           * The list of team `slug`s with push access
           */
          teams: string[];
          /**
           * The list of app `slug`s with push access
           */
          apps?: string[];
        } | null;
        /**
         * Enforces a linear commit Git history, which prevents anyone from pushing merge commits to a branch. Set to `true` to enforce a linear commit history. Set to `false` to disable a linear commit Git history. Your repository must allow squash merging or rebase merging before you can enable a linear commit history. Default: `false`. For more information, see "[Requiring a linear commit history](https://help.github.com/github/administering-a-repository/requiring-a-linear-commit-history)" in the GitHub Help documentation.
         */
        required_linear_history?: boolean;
        /**
         * Permits force pushes to the protected branch by anyone with write access to the repository. Set to `true` to allow force pushes. Set to `false` or `null` to block force pushes. Default: `false`. For more information, see "[Enabling force pushes to a protected branch](https://help.github.com/en/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)" in the GitHub Help documentation."
         */
        allow_force_pushes?: boolean | null;
        /**
         * Allows deletion of the protected branch by anyone with write access to the repository. Set to `false` to prevent deletion of the protected branch. Default: `false`. For more information, see "[Enabling force pushes to a protected branch](https://help.github.com/en/github/administering-a-repository/enabling-force-pushes-to-a-protected-branch)" in the GitHub Help documentation.
         */
        allow_deletions?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["protected-branch"];
      };
      "403": unknown;
      "404": unknown;
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   */
  "repos/delete-branch-protection": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "403": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   */
  "repos/get-admin-branch-protection": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["protected-branch-admin-enforced"];
      };
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Adding admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
   */
  "repos/set-admin-branch-protection": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["protected-branch-admin-enforced"];
      };
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Removing admin enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
   */
  "repos/delete-admin-branch-protection": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * No Content
       */
      "204": never;
      "404": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   */
  "repos/get-pull-request-review-protection": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/vnd.github.luke-cage-preview+json": components["schemas"]["protected-branch-pull-request-review"];
      };
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Updating pull request review enforcement requires admin or owner permissions to the repository and branch protection to be enabled.
   *
   * **Note**: Passing new arrays of `users` and `teams` replaces their previous values.
   */
  "repos/update-pull-request-review-protection": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Specify which users and teams can dismiss pull request reviews. Pass an empty `dismissal_restrictions` object to disable. User and team `dismissal_restrictions` are only available for organization-owned repositories. Omit this parameter for personal repositories.
         */
        dismissal_restrictions?: {
          /**
           * The list of user `login`s with dismissal access
           */
          users?: string[];
          /**
           * The list of team `slug`s with dismissal access
           */
          teams?: string[];
        };
        /**
         * Set to `true` if you want to automatically dismiss approving reviews when someone pushes a new commit.
         */
        dismiss_stale_reviews?: boolean;
        /**
         * Blocks merging pull requests until [code owners](https://help.github.com/articles/about-code-owners/) have reviewed.
         */
        require_code_owner_reviews?: boolean;
        /**
         * Specifies the number of reviewers required to approve pull requests. Use a number between 1 and 6.
         */
        required_approving_review_count?: number;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["protected-branch-pull-request-review"];
      };
      "422": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   */
  "repos/delete-pull-request-review-protection": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * No Content
       */
      "204": never;
      "404": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * When authenticated with admin or owner permissions to the repository, you can use this endpoint to check whether a branch requires signed commits. An enabled status of `true` indicates you must sign commits on this branch. For more information, see [Signing commits with GPG](https://help.github.com/articles/signing-commits-with-gpg) in GitHub Help.
   *
   * **Note**: You must enable branch protection to require signed commits.
   */
  "repos/get-commit-signature-protection": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["protected-branch-admin-enforced"];
      };
      "404": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * When authenticated with admin or owner permissions to the repository, you can use this endpoint to require signed commits on a branch. You must enable branch protection to require signed commits.
   */
  "repos/create-commit-signature-protection": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["protected-branch-admin-enforced"];
      };
      "404": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * When authenticated with admin or owner permissions to the repository, you can use this endpoint to disable required signed commits on a branch. You must enable branch protection to require signed commits.
   */
  "repos/delete-commit-signature-protection": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * No Content
       */
      "204": never;
      "404": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   */
  "repos/get-status-checks-protection": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["status-check-policy"];
      };
      "404": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Updating required status checks requires admin or owner permissions to the repository and branch protection to be enabled.
   */
  "repos/update-status-check-protection": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Require branches to be up to date before merging.
         */
        strict?: boolean;
        /**
         * The list of status checks to require in order to merge into this branch
         */
        contexts?: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["status-check-policy"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   */
  "repos/remove-status-check-protection": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * No Content
       */
      "204": never;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   */
  "repos/get-all-status-check-contexts": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": string[];
      };
      "404": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   */
  "repos/add-status-check-contexts": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * contexts parameter
         */
        contexts: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": string[];
      };
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   */
  "repos/set-status-check-contexts": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * contexts parameter
         */
        contexts: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": string[];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   */
  "repos/remove-status-check-contexts": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * contexts parameter
         */
        contexts: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": string[];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Lists who has access to this protected branch.
   *
   * **Note**: Users, apps, and teams `restrictions` are only available for organization-owned repositories.
   */
  "repos/get-access-restrictions": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["branch-restriction-policy"];
      };
      "404": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Disables the ability to restrict who can push to this branch.
   */
  "repos/delete-access-restrictions": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * No Content
       */
      "204": never;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Lists the GitHub Apps that have push access to this branch. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
   */
  "repos/get-apps-with-access-to-protected-branch": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["integration"][];
      };
      "404": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Grants the specified apps push access for this branch. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
   *
   * | Type    | Description                                                                                                                                                |
   * | ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
   * | `array` | The GitHub Apps that have push access to this branch. Use the app's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
   */
  "repos/add-app-access-restrictions": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * apps parameter
         */
        apps: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["integration"][];
      };
      "422": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Replaces the list of apps that have push access to this branch. This removes all apps that previously had push access and grants push access to the new list of apps. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
   *
   * | Type    | Description                                                                                                                                                |
   * | ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
   * | `array` | The GitHub Apps that have push access to this branch. Use the app's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
   */
  "repos/set-app-access-restrictions": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * apps parameter
         */
        apps: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["integration"][];
      };
      "422": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Removes the ability of an app to push to this branch. Only installed GitHub Apps with `write` access to the `contents` permission can be added as authorized actors on a protected branch.
   *
   * | Type    | Description                                                                                                                                                |
   * | ------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------- |
   * | `array` | The GitHub Apps that have push access to this branch. Use the app's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
   */
  "repos/remove-app-access-restrictions": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * apps parameter
         */
        apps: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["integration"][];
      };
      "422": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Lists the teams who have push access to this branch. The list includes child teams.
   */
  "repos/get-teams-with-access-to-protected-branch": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team"][];
      };
      "404": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Grants the specified teams push access for this branch. You can also give push access to child teams.
   *
   * | Type    | Description                                                                                                                                |
   * | ------- | ------------------------------------------------------------------------------------------------------------------------------------------ |
   * | `array` | The teams that can have push access. Use the team's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
   */
  "repos/add-team-access-restrictions": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * teams parameter
         */
        teams: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team"][];
      };
      "422": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Replaces the list of teams that have push access to this branch. This removes all teams that previously had push access and grants push access to the new list of teams. Team restrictions include child teams.
   *
   * | Type    | Description                                                                                                                                |
   * | ------- | ------------------------------------------------------------------------------------------------------------------------------------------ |
   * | `array` | The teams that can have push access. Use the team's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
   */
  "repos/set-team-access-restrictions": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * teams parameter
         */
        teams: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team"][];
      };
      "422": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Removes the ability of a team to push to this branch. You can also remove push access for child teams.
   *
   * | Type    | Description                                                                                                                                         |
   * | ------- | --------------------------------------------------------------------------------------------------------------------------------------------------- |
   * | `array` | Teams that should no longer have push access. Use the team's `slug`. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
   */
  "repos/remove-team-access-restrictions": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * teams parameter
         */
        teams: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team"][];
      };
      "422": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Lists the people who have push access to this branch.
   */
  "repos/get-users-with-access-to-protected-branch": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
      "404": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Grants the specified people push access for this branch.
   *
   * | Type    | Description                                                                                                                   |
   * | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
   * | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
   */
  "repos/add-user-access-restrictions": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * users parameter
         */
        users: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
      "422": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Replaces the list of people that have push access to this branch. This removes all people that previously had push access and grants push access to the new list of people.
   *
   * | Type    | Description                                                                                                                   |
   * | ------- | ----------------------------------------------------------------------------------------------------------------------------- |
   * | `array` | Usernames for people who can have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
   */
  "repos/set-user-access-restrictions": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * users parameter
         */
        users: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
      "422": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Removes the ability of a user to push to this branch.
   *
   * | Type    | Description                                                                                                                                   |
   * | ------- | --------------------------------------------------------------------------------------------------------------------------------------------- |
   * | `array` | Usernames of the people who should no longer have push access. **Note**: The list of users, apps, and teams in total is limited to 100 items. |
   */
  "repos/remove-user-access-restrictions": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        branch: components["parameters"]["branch"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * users parameter
         */
        users: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
      "422": unknown;
    };
  };
  /**
   * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
   *
   * Creates a new check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to create check runs.
   *
   * In a check suite, GitHub limits the number of check runs with the same name to 1000. Once these check runs exceed 1000, GitHub will start to automatically delete older check runs.
   */
  "checks/create": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The name of the check. For example, "code-coverage".
         */
        name: string;
        /**
         * The SHA of the commit.
         */
        head_sha: string;
        /**
         * The URL of the integrator's site that has the full details of the check. If the integrator does not provide this, then the homepage of the GitHub app is used.
         */
        details_url?: string;
        /**
         * A reference for the run on the integrator's system.
         */
        external_id?: string;
        /**
         * The current status. Can be one of `queued`, `in_progress`, or `completed`.
         */
        status?: "queued" | "in_progress" | "completed";
        /**
         * The time that the check run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
         */
        started_at?: string;
        /**
         * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `skipped`, `timed_out`, or `action_required`. When the conclusion is `action_required`, additional details should be provided on the site specified by `details_url`.
         * **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. Only GitHub can change a check run conclusion to `stale`.
         */
        conclusion?:
          | "success"
          | "failure"
          | "neutral"
          | "cancelled"
          | "skipped"
          | "timed_out"
          | "action_required";
        /**
         * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
         */
        completed_at?: string;
        /**
         * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://docs.github.com/rest/reference/checks#output-object) description.
         */
        output?: {
          /**
           * The title of the check run.
           */
          title: string;
          /**
           * The summary of the check run. This parameter supports Markdown.
           */
          summary: string;
          /**
           * The details of the check run. This parameter supports Markdown.
           */
          text?: string;
          /**
           * Adds information from your analysis to specific lines of code. Annotations are visible on GitHub in the **Checks** and **Files changed** tab of the pull request. The Checks API limits the number of annotations to a maximum of 50 per API request. To create more than 50 annotations, you have to make multiple requests to the [Update a check run](https://docs.github.com/rest/reference/checks#update-a-check-run) endpoint. Each time you update the check run, annotations are appended to the list of annotations that already exist for the check run. For details about how you can view annotations on GitHub, see "[About status checks](https://help.github.com/articles/about-status-checks#checks)". See the [`annotations` object](https://docs.github.com/rest/reference/checks#annotations-object) description for details about how to use this parameter.
           */
          annotations?: {
            /**
             * The path of the file to add an annotation to. For example, `assets/css/main.css`.
             */
            path: string;
            /**
             * The start line of the annotation.
             */
            start_line: number;
            /**
             * The end line of the annotation.
             */
            end_line: number;
            /**
             * The start column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values.
             */
            start_column?: number;
            /**
             * The end column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values.
             */
            end_column?: number;
            /**
             * The level of the annotation. Can be one of `notice`, `warning`, or `failure`.
             */
            annotation_level: "notice" | "warning" | "failure";
            /**
             * A short description of the feedback for these lines of code. The maximum size is 64 KB.
             */
            message: string;
            /**
             * The title that represents the annotation. The maximum size is 255 characters.
             */
            title?: string;
            /**
             * Details about this annotation. The maximum size is 64 KB.
             */
            raw_details?: string;
          }[];
          /**
           * Adds images to the output displayed in the GitHub pull request UI. See the [`images` object](https://docs.github.com/rest/reference/checks#images-object) description for details.
           */
          images?: {
            /**
             * The alternative text for the image.
             */
            alt: string;
            /**
             * The full URL of the image.
             */
            image_url: string;
            /**
             * A short image description.
             */
            caption?: string;
          }[];
        };
        /**
         * Displays a button on GitHub that can be clicked to alert your app to do additional tasks. For example, a code linting app can display a button that automatically fixes detected errors. The button created in this object is displayed after the check run completes. When a user clicks the button, GitHub sends the [`check_run.requested_action` webhook](https://docs.github.com/webhooks/event-payloads/#check_run) to your app. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](https://docs.github.com/rest/reference/checks#actions-object) description. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://docs.github.com/rest/reference/checks#check-runs-and-requested-actions)." To learn more about check runs and requested actions, see "[Check runs and requested actions](https://docs.github.com/rest/reference/checks#check-runs-and-requested-actions)."
         */
        actions?: {
          /**
           * The text to be displayed on a button in the web UI. The maximum size is 20 characters.
           */
          label: string;
          /**
           * A short explanation of what this action would do. The maximum size is 40 characters.
           */
          description: string;
          /**
           * A reference for the action on the integrator's system. The maximum size is 20 characters.
           */
          identifier: string;
        }[];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["check-run"];
      };
    };
  };
  /**
   * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
   *
   * Gets a single check run using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
   */
  "checks/get": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        check_run_id: components["parameters"]["check_run_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["check-run"];
      };
    };
  };
  /**
   * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
   *
   * Updates a check run for a specific commit in a repository. Your GitHub App must have the `checks:write` permission to edit check runs.
   */
  "checks/update": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        check_run_id: components["parameters"]["check_run_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The name of the check. For example, "code-coverage".
         */
        name?: string;
        /**
         * The URL of the integrator's site that has the full details of the check.
         */
        details_url?: string;
        /**
         * A reference for the run on the integrator's system.
         */
        external_id?: string;
        /**
         * This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
         */
        started_at?: string;
        /**
         * The current status. Can be one of `queued`, `in_progress`, or `completed`.
         */
        status?: "queued" | "in_progress" | "completed";
        /**
         * **Required if you provide `completed_at` or a `status` of `completed`**. The final conclusion of the check. Can be one of `success`, `failure`, `neutral`, `cancelled`, `skipped`, `timed_out`, or `action_required`.
         * **Note:** Providing `conclusion` will automatically set the `status` parameter to `completed`. Only GitHub can change a check run conclusion to `stale`.
         */
        conclusion?:
          | "success"
          | "failure"
          | "neutral"
          | "cancelled"
          | "skipped"
          | "timed_out"
          | "action_required";
        /**
         * The time the check completed. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
         */
        completed_at?: string;
        /**
         * Check runs can accept a variety of data in the `output` object, including a `title` and `summary` and can optionally provide descriptive details about the run. See the [`output` object](https://docs.github.com/rest/reference/checks#output-object-1) description.
         */
        output?: {
          /**
           * **Required**.
           */
          title?: string;
          /**
           * Can contain Markdown.
           */
          summary: string;
          /**
           * Can contain Markdown.
           */
          text?: string;
          /**
           * Adds information from your analysis to specific lines of code. Annotations are visible in GitHub's pull request UI. Annotations are visible in GitHub's pull request UI. The Checks API limits the number of annotations to a maximum of 50 per API request. To create more than 50 annotations, you have to make multiple requests to the [Update a check run](https://docs.github.com/rest/reference/checks#update-a-check-run) endpoint. Each time you update the check run, annotations are appended to the list of annotations that already exist for the check run. For details about annotations in the UI, see "[About status checks](https://help.github.com/articles/about-status-checks#checks)". See the [`annotations` object](https://docs.github.com/rest/reference/checks#annotations-object-1) description for details.
           */
          annotations?: {
            /**
             * The path of the file to add an annotation to. For example, `assets/css/main.css`.
             */
            path: string;
            /**
             * The start line of the annotation.
             */
            start_line: number;
            /**
             * The end line of the annotation.
             */
            end_line: number;
            /**
             * The start column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values.
             */
            start_column?: number;
            /**
             * The end column of the annotation. Annotations only support `start_column` and `end_column` on the same line. Omit this parameter if `start_line` and `end_line` have different values.
             */
            end_column?: number;
            /**
             * The level of the annotation. Can be one of `notice`, `warning`, or `failure`.
             */
            annotation_level: "notice" | "warning" | "failure";
            /**
             * A short description of the feedback for these lines of code. The maximum size is 64 KB.
             */
            message: string;
            /**
             * The title that represents the annotation. The maximum size is 255 characters.
             */
            title?: string;
            /**
             * Details about this annotation. The maximum size is 64 KB.
             */
            raw_details?: string;
          }[];
          /**
           * Adds images to the output displayed in the GitHub pull request UI. See the [`images` object](https://docs.github.com/rest/reference/checks#annotations-object-1) description for details.
           */
          images?: {
            /**
             * The alternative text for the image.
             */
            alt: string;
            /**
             * The full URL of the image.
             */
            image_url: string;
            /**
             * A short image description.
             */
            caption?: string;
          }[];
        };
        /**
         * Possible further actions the integrator can perform, which a user may trigger. Each action includes a `label`, `identifier` and `description`. A maximum of three actions are accepted. See the [`actions` object](https://docs.github.com/rest/reference/checks#actions-object) description. To learn more about check runs and requested actions, see "[Check runs and requested actions](https://docs.github.com/rest/reference/checks#check-runs-and-requested-actions)."
         */
        actions?: {
          /**
           * The text to be displayed on a button in the web UI. The maximum size is 20 characters.
           */
          label: string;
          /**
           * A short explanation of what this action would do. The maximum size is 40 characters.
           */
          description: string;
          /**
           * A reference for the action on the integrator's system. The maximum size is 20 characters.
           */
          identifier: string;
        }[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["check-run"];
      };
    };
  };
  /**
   * Lists annotations for a check run using the annotation `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get annotations for a check run. OAuth Apps and authenticated users must have the `repo` scope to get annotations for a check run in a private repository.
   */
  "checks/list-annotations": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        check_run_id: components["parameters"]["check_run_id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["check-annotation"][];
      };
    };
  };
  /**
   * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
   *
   * By default, check suites are automatically created when you create a [check run](https://docs.github.com/rest/reference/checks#check-runs). You only need to use this endpoint for manually creating check suites when you've disabled automatic creation using "[Update repository preferences for check suites](https://docs.github.com/rest/reference/checks#update-repository-preferences-for-check-suites)". Your GitHub App must have the `checks:write` permission to create check suites.
   */
  "checks/create-suite": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The sha of the head commit.
         */
        head_sha: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["check-suite"];
      };
    };
  };
  /**
   * Changes the default automatic flow when creating check suites. By default, a check suite is automatically created each time code is pushed to a repository. When you disable the automatic creation of check suites, you can manually [Create a check suite](https://docs.github.com/rest/reference/checks#create-a-check-suite). You must have admin permissions in the repository to set preferences for check suites.
   */
  "checks/set-suites-preferences": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Enables or disables automatic creation of CheckSuite events upon pushes to the repository. Enabled by default. See the [`auto_trigger_checks` object](https://docs.github.com/rest/reference/checks#auto_trigger_checks-object) description for details.
         */
        auto_trigger_checks?: {
          /**
           * The `id` of the GitHub App.
           */
          app_id: number;
          /**
           * Set to `true` to enable automatic creation of CheckSuite events upon pushes to the repository, or `false` to disable them.
           */
          setting: boolean;
        }[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["check-suite-preference"];
      };
    };
  };
  /**
   * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
   *
   * Gets a single check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
   */
  "checks/get-suite": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        check_suite_id: components["parameters"]["check_suite_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["check-suite"];
      };
    };
  };
  /**
   * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
   *
   * Lists check runs for a check suite using its `id`. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
   */
  "checks/list-for-suite": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        check_suite_id: components["parameters"]["check_suite_id"];
      };
      query: {
        check_name?: components["parameters"]["check_name"];
        status?: components["parameters"]["status"];
        /**
         * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
         */
        filter?: "latest" | "all";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          check_runs: components["schemas"]["check-run"][];
        };
      };
    };
  };
  /**
   * Triggers GitHub to rerequest an existing check suite, without pushing new code to a repository. This endpoint will trigger the [`check_suite` webhook](https://docs.github.com/webhooks/event-payloads/#check_suite) event with the action `rerequested`. When a check suite is `rerequested`, its `status` is reset to `queued` and the `conclusion` is cleared.
   *
   * To rerequest a check suite, your GitHub App must have the `checks:read` permission on a private repository or pull access to a public repository.
   */
  "checks/rerequest-suite": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        check_suite_id: components["parameters"]["check_suite_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "201": unknown;
    };
  };
  /**
   * Lists all open code scanning alerts for the default branch (usually `main` or `master`). You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` read permission to use this endpoint.
   */
  "code-scanning/list-alerts-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        /**
         * Set to `open`, `fixed`, or `dismissed` to list code scanning alerts in a specific state.
         */
        state?: components["schemas"]["code-scanning-alert-state"];
        /**
         * Set a full Git reference to list alerts for a specific branch. The `ref` must be formatted as `refs/heads/<branch name>`.
         */
        ref?: components["schemas"]["code-scanning-alert-ref"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["code-scanning-alert-code-scanning-alert-items"][];
      };
      /**
       * Response if github advanced security is not enabled for this repository
       */
      "403": unknown;
      /**
       * Response if the ref does not match an existing ref
       */
      "404": unknown;
      "503": unknown;
    };
  };
  /**
   * Gets a single code scanning alert. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` read permission to use this endpoint.
   *
   * The security `alert_number` is found at the end of the security alert's URL. For example, the security alert ID for `https://github.com/Octo-org/octo-repo/security/code-scanning/88` is `88`.
   */
  "code-scanning/get-alert": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        alert_number: number;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["code-scanning-alert-code-scanning-alert"];
      };
      /**
       * Response if github advanced security is not enabled for this repository
       */
      "403": unknown;
      "404": unknown;
      "503": unknown;
    };
  };
  /**
   * Updates the status of a single code scanning alert. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` write permission to use this endpoint.
   */
  "code-scanning/update-alert": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        alert_number: components["parameters"]["alert_number"];
      };
    };
    requestBody: {
      "application/json": {
        state: components["schemas"]["code-scanning-alert-set-state"];
        dismissed_reason?: components["schemas"]["code-scanning-alert-dismissed-reason"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["code-scanning-alert-code-scanning-alert"];
      };
      /**
       * Response if the repository is archived, or if github advanced security is not enabled for this repository
       */
      "403": unknown;
      /**
       * Response when code scanning is not available and you should try again at a later time
       */
      "503": unknown;
    };
  };
  /**
   * List the details of recent code scanning analyses for a repository. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` read permission to use this endpoint.
   */
  "code-scanning/list-recent-analyses": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        /**
         * Set a full Git reference to list alerts for a specific branch. The `ref` must be formatted as `refs/heads/<branch name>`.
         */
        ref?: components["schemas"]["code-scanning-analysis-ref"];
        /**
         * Set a single code scanning tool name to filter alerts by tool.
         */
        tool_name?: components["schemas"]["code-scanning-analysis-tool-name"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["code-scanning-analysis-code-scanning-analysis"][];
      };
      /**
       * Response if github advanced security is not enabled for this repository
       */
      "403": unknown;
    };
  };
  /**
   * Upload a SARIF file containing the results of a code scanning analysis to make the results available in a repository. You must use an access token with the `security_events` scope to use this endpoint. GitHub Apps must have the `security_events` write permission to use this endpoint.
   */
  "code-scanning/upload-sarif": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        commit_sha: components["schemas"]["code-scanning-analysis-commit-sha"];
        ref: components["schemas"]["code-scanning-analysis-ref"];
        sarif: components["schemas"]["code-scanning-analysis-sarif-file"];
        /**
         * The base directory used in the analysis, as it appears in the SARIF file.
         * This property is used to convert file paths from absolute to relative, so that alerts can be mapped to their correct location in the repository.
         */
        checkout_uri?: string;
        /**
         * The time that the analysis run began. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
         */
        started_at?: string;
        tool_name: components["schemas"]["code-scanning-analysis-tool-name"];
      };
    };
    responses: {
      /**
       * response
       */
      "202": unknown;
      /**
       * Response if the `sarif` field is invalid
       */
      "400": unknown;
      /**
       * Response if the repository is archived, or if github advanced security is not enabled for this repository
       */
      "403": unknown;
      /**
       * Response if `commit_sha` or `ref` cannot be found
       */
      "404": unknown;
      /**
       * Response if the `sarif` field is too large
       */
      "413": unknown;
    };
  };
  /**
   * For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
   *
   * Team members will include the members of child teams.
   */
  "repos/list-collaborators": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        /**
         * Filter collaborators returned by their affiliation. Can be one of:
         * \* `outside`: All outside collaborators of an organization-owned repository.
         * \* `direct`: All collaborators with permissions to an organization-owned repository, regardless of organization membership status.
         * \* `all`: All collaborators the authenticated user can see.
         */
        affiliation?: "outside" | "direct" | "all";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["collaborator"][];
      };
      "404": unknown;
    };
  };
  /**
   * For organization-owned repositories, the list of collaborators includes outside collaborators, organization members that are direct collaborators, organization members with access through team memberships, organization members with access through default organization permissions, and organization owners.
   *
   * Team members will include the members of child teams.
   */
  "repos/check-collaborator": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Response if user is a collaborator
       */
      "204": never;
      /**
       * Response if user is not a collaborator
       */
      "404": unknown;
    };
  };
  /**
   * This endpoint triggers [notifications](https://help.github.com/articles/about-notifications/). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
   *
   * For more information the permission levels, see "[Repository permission levels for an organization](https://help.github.com/en/github/setting-up-and-managing-organizations-and-teams/repository-permission-levels-for-an-organization#permission-levels-for-repositories-owned-by-an-organization)".
   *
   * Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
   *
   * The invitee will receive a notification that they have been invited to the repository, which they must accept or decline. They may do this via the notifications page, the email they receive, or by using the [repository invitations API endpoints](https://docs.github.com/rest/reference/repos#invitations).
   *
   * **Rate limits**
   *
   * To prevent abuse, you are limited to sending 50 invitations to a repository per 24 hour period. Note there is no limit if you are inviting organization members to an organization repository.
   */
  "repos/add-collaborator": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        username: components["parameters"]["username"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The permission to grant the collaborator. **Only valid on organization-owned repositories.** Can be one of:
         * \* `pull` - can pull, but not push to or administer this repository.
         * \* `push` - can pull and push, but not administer this repository.
         * \* `admin` - can pull, push and administer this repository.
         * \* `maintain` - Recommended for project managers who need to manage the repository without access to sensitive or destructive actions.
         * \* `triage` - Recommended for contributors who need to proactively manage issues and pull requests without write access.
         */
        permission?: "pull" | "push" | "admin" | "maintain" | "triage";
        permissions?: string;
      };
    };
    responses: {
      /**
       * Response when a new invitation is created
       */
      "201": {
        "application/json": components["schemas"]["repository-invitation"];
      };
      /**
       * Response when person is already a collaborator
       */
      "204": never;
      "403": unknown;
      "422": unknown;
    };
  };
  "repos/remove-collaborator": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Checks the repository permission of a collaborator. The possible repository permissions are `admin`, `write`, `read`, and `none`.
   */
  "repos/get-collaborator-permission-level": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Response if user has admin permissions
       */
      "200": {
        "application/json": components["schemas"]["repository-collaborator-permission"];
      };
      "404": unknown;
    };
  };
  /**
   * Commit Comments use [these custom media types](https://docs.github.com/rest/reference/repos#custom-media-types). You can read more about the use of media types in the API [here](https://docs.github.com/rest/overview/media-types/).
   *
   * Comments are ordered by ascending ID.
   */
  "repos/list-commit-comments-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["commit-comment"][];
      };
    };
  };
  "repos/get-commit-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["commit-comment"];
      };
      "404": unknown;
    };
  };
  "repos/update-commit-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The contents of the comment
         */
        body: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["commit-comment"];
      };
      "404": unknown;
    };
  };
  "repos/delete-commit-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
    };
  };
  /**
   * List the reactions to a [commit comment](https://docs.github.com/rest/reference/repos#comments).
   */
  "reactions/list-for-commit-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
      };
      query: {
        /**
         * Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a commit comment.
         */
        content?:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["reaction"][];
      };
      "404": unknown;
      "415": unknown;
    };
  };
  /**
   * Create a reaction to a [commit comment](https://docs.github.com/rest/reference/repos#comments). A response with a `Status: 200 OK` means that you already added the reaction type to this commit comment.
   */
  "reactions/create-for-commit-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the commit comment.
         */
        content:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
      };
    };
    responses: {
      /**
       * Reaction exists
       */
      "200": {
        "application/json": components["schemas"]["reaction"];
      };
      /**
       * Reaction created
       */
      "201": {
        "application/json": components["schemas"]["reaction"];
      };
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/comments/:comment_id/reactions/:reaction_id`.
   *
   * Delete a reaction to a [commit comment](https://docs.github.com/rest/reference/repos#comments).
   */
  "reactions/delete-for-commit-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
        reaction_id: components["parameters"]["reaction-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * **Signature verification object**
   *
   * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
   *
   * | Name | Type | Description |
   * | ---- | ---- | ----------- |
   * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
   * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
   * | `signature` | `string` | The signature that was extracted from the commit. |
   * | `payload` | `string` | The value that was signed. |
   *
   * These are the possible values for `reason` in the `verification` object:
   *
   * | Value | Description |
   * | ----- | ----------- |
   * | `expired_key` | The key that made the signature is expired. |
   * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
   * | `gpgverify_error` | There was an error communicating with the signature verification service. |
   * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
   * | `unsigned` | The object does not include a signature. |
   * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
   * | `no_user` | No user was associated with the `committer` email address in the commit. |
   * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
   * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
   * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
   * | `malformed_signature` | There was an error parsing the signature. |
   * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
   * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
   */
  "repos/list-commits": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        /**
         * SHA or branch to start listing commits from. Default: the repository’s default branch (usually `master`).
         */
        sha?: string;
        /**
         * Only commits containing this file path will be returned.
         */
        path?: string;
        /**
         * GitHub login or email address by which to filter by commit author.
         */
        author?: string;
        since?: components["parameters"]["since"];
        /**
         * Only commits before this date will be returned. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
         */
        until?: string;
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["commit"][];
      };
      "400": unknown;
      "404": unknown;
      "409": unknown;
      "500": unknown;
    };
  };
  /**
   * Protected branches are available in public repositories with GitHub Free and GitHub Free for organizations, and in public and private repositories with GitHub Pro, GitHub Team, GitHub Enterprise Cloud, and GitHub Enterprise Server. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Returns all branches where the given commit SHA is the HEAD, or latest commit for the branch.
   */
  "repos/list-branches-for-head-commit": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        commit_sha: components["parameters"]["commit_sha"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["branch-short"][];
      };
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * Use the `:commit_sha` to specify the commit that will have its comments listed.
   */
  "repos/list-comments-for-commit": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        commit_sha: components["parameters"]["commit_sha"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["commit-comment"][];
      };
    };
  };
  /**
   * Create a comment for a commit using its `:commit_sha`.
   *
   * This endpoint triggers [notifications](https://help.github.com/articles/about-notifications/). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
   */
  "repos/create-commit-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        commit_sha: components["parameters"]["commit_sha"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The contents of the comment.
         */
        body: string;
        /**
         * Relative path of the file to comment on.
         */
        path?: string;
        /**
         * Line index in the diff to comment on.
         */
        position?: number;
        /**
         * **Deprecated**. Use **position** parameter instead. Line number in the file to comment on.
         */
        line?: number;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["commit-comment"];
      };
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * Lists all pull requests containing the provided commit SHA, which can be from any point in the commit history. The results will include open and closed pull requests. Additional preview headers may be required to see certain details for associated pull requests, such as whether a pull request is in a draft state. For more information about previews that might affect this endpoint, see the [List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests) endpoint.
   */
  "repos/list-pull-requests-associated-with-commit": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        commit_sha: components["parameters"]["commit_sha"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["pull-request-simple"][];
      };
      "415": unknown;
    };
  };
  /**
   * Returns the contents of a single commit reference. You must have `read` access for the repository to use this endpoint.
   *
   * **Note:** If there are more than 300 files in the commit diff, the response will include pagination link headers for the remaining files, up to a limit of 3000 files. Each page contains the static commit information, and the only changes are to the file listing.
   *
   * You can pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to  fetch `diff` and `patch` formats. Diffs with binary data will have no `patch` property.
   *
   * To return only the SHA-1 hash of the commit reference, you can provide the `sha` custom [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) in the `Accept` header. You can use this endpoint to check if a remote reference's SHA-1 hash is the same as your local reference's SHA-1 hash by providing the local SHA-1 reference as the ETag.
   *
   * **Signature verification object**
   *
   * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
   *
   * | Name | Type | Description |
   * | ---- | ---- | ----------- |
   * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
   * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
   * | `signature` | `string` | The signature that was extracted from the commit. |
   * | `payload` | `string` | The value that was signed. |
   *
   * These are the possible values for `reason` in the `verification` object:
   *
   * | Value | Description |
   * | ----- | ----------- |
   * | `expired_key` | The key that made the signature is expired. |
   * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
   * | `gpgverify_error` | There was an error communicating with the signature verification service. |
   * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
   * | `unsigned` | The object does not include a signature. |
   * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
   * | `no_user` | No user was associated with the `committer` email address in the commit. |
   * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
   * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
   * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
   * | `malformed_signature` | There was an error parsing the signature. |
   * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
   * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
   */
  "repos/get-commit": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        /**
         * ref+ parameter
         */
        ref: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["commit"];
      };
      "404": unknown;
      "422": unknown;
      "500": unknown;
    };
  };
  /**
   * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array.
   *
   * Lists check runs for a commit ref. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to get check runs. OAuth Apps and authenticated users must have the `repo` scope to get check runs in a private repository.
   */
  "checks/list-for-ref": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        /**
         * ref+ parameter
         */
        ref: string;
      };
      query: {
        check_name?: components["parameters"]["check_name"];
        status?: components["parameters"]["status"];
        /**
         * Filters check runs by their `completed_at` timestamp. Can be one of `latest` (returning the most recent check runs) or `all`.
         */
        filter?: "latest" | "all";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          check_runs: components["schemas"]["check-run"][];
        };
      };
    };
  };
  /**
   * **Note:** The Checks API only looks for pushes in the repository where the check suite or check run were created. Pushes to a branch in a forked repository are not detected and return an empty `pull_requests` array and a `null` value for `head_branch`.
   *
   * Lists check suites for a commit `ref`. The `ref` can be a SHA, branch name, or a tag name. GitHub Apps must have the `checks:read` permission on a private repository or pull access to a public repository to list check suites. OAuth Apps and authenticated users must have the `repo` scope to get check suites in a private repository.
   */
  "checks/list-suites-for-ref": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        /**
         * ref+ parameter
         */
        ref: string;
      };
      query: {
        /**
         * Filters check suites by GitHub App `id`.
         */
        app_id?: number;
        check_name?: components["parameters"]["check_name"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          check_suites: components["schemas"]["check-suite"][];
        };
      };
    };
  };
  /**
   * Users with pull access in a repository can access a combined view of commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name.
   *
   * The most recent status for each context is returned, up to 100. This field [paginates](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination) if there are over 100 contexts.
   *
   * Additionally, a combined `state` is returned. The `state` is one of:
   *
   * *   **failure** if any of the contexts report as `error` or `failure`
   * *   **pending** if there are no statuses or a context is `pending`
   * *   **success** if the latest status for all contexts is `success`
   */
  "repos/get-combined-status-for-ref": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        /**
         * ref+ parameter
         */
        ref: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["combined-commit-status"];
      };
      "404": unknown;
    };
  };
  /**
   * Users with pull access in a repository can view commit statuses for a given ref. The ref can be a SHA, a branch name, or a tag name. Statuses are returned in reverse chronological order. The first status in the list will be the latest one.
   *
   * This resource is also available via a legacy route: `GET /repos/:owner/:repo/statuses/:ref`.
   */
  "repos/list-commit-statuses-for-ref": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        /**
         * ref+ parameter
         */
        ref: string;
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["status"][];
      };
      "301": never;
    };
  };
  /**
   * Returns the contents of the repository's code of conduct file, if one is detected.
   *
   * A code of conduct is detected if there is a file named `CODE_OF_CONDUCT` in the root directory of the repository. GitHub detects which code of conduct it is using fuzzy matching.
   */
  "codes-of-conduct/get-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["code-of-conduct"];
      };
    };
  };
  /**
   * This endpoint will return all community profile metrics, including an
   * overall health score, repository description, the presence of documentation, detected
   * code of conduct, detected license, and the presence of ISSUE\_TEMPLATE, PULL\_REQUEST\_TEMPLATE,
   * README, and CONTRIBUTING files.
   *
   * The `health_percentage` score is defined as a percentage of how many of
   * these four documents are present: README, CONTRIBUTING, LICENSE, and
   * CODE_OF_CONDUCT. For example, if all four documents are present, then
   * the `health_percentage` is `100`. If only one is present, then the
   * `health_percentage` is `25`.
   *
   * `content_reports_enabled` is only returned for organization-owned repositories.
   */
  "repos/get-community-profile-metrics": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["community-profile"];
      };
    };
  };
  /**
   * Both `:base` and `:head` must be branch names in `:repo`. To compare branches across other repositories in the same network as `:repo`, use the format `<USERNAME>:branch`.
   *
   * The response from the API is equivalent to running the `git log base..head` command; however, commits are returned in chronological order. Pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
   *
   * The response also includes details on the files that were changed between the two commits. This includes the status of the change (for example, if a file was added, removed, modified, or renamed), and details of the change itself. For example, files with a `renamed` status have a `previous_filename` field showing the previous filename of the file, and files with a `modified` status have a `patch` field showing the changes made to the file.
   *
   * **Working with large comparisons**
   *
   * The response will include a comparison of up to 250 commits. If you are working with a larger commit range, you can use the [List commits](https://docs.github.com/rest/reference/repos#list-commits) to enumerate all commits in the range.
   *
   * For comparisons with extremely large diffs, you may receive an error response indicating that the diff took too long
   * to generate. You can typically resolve this error by using a smaller commit range.
   *
   * **Signature verification object**
   *
   * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
   *
   * | Name | Type | Description |
   * | ---- | ---- | ----------- |
   * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
   * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
   * | `signature` | `string` | The signature that was extracted from the commit. |
   * | `payload` | `string` | The value that was signed. |
   *
   * These are the possible values for `reason` in the `verification` object:
   *
   * | Value | Description |
   * | ----- | ----------- |
   * | `expired_key` | The key that made the signature is expired. |
   * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
   * | `gpgverify_error` | There was an error communicating with the signature verification service. |
   * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
   * | `unsigned` | The object does not include a signature. |
   * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
   * | `no_user` | No user was associated with the `committer` email address in the commit. |
   * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
   * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
   * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
   * | `malformed_signature` | There was an error parsing the signature. |
   * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
   * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
   */
  "repos/compare-commits": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        base: string;
        head: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["commit-comparison"];
      };
      "404": unknown;
      "500": unknown;
    };
  };
  /**
   * Gets the contents of a file or directory in a repository. Specify the file path or directory in `:path`. If you omit
   * `:path`, you will receive the contents of the repository's root directory. See the description below regarding what the API response includes for directories.
   *
   * Files and symlinks support [a custom media type](https://docs.github.com/rest/reference/repos#custom-media-types) for
   * retrieving the raw content or rendered HTML (when supported). All content types support [a custom media
   * type](https://docs.github.com/rest/reference/repos#custom-media-types) to ensure the content is returned in a consistent
   * object format.
   *
   * **Note**:
   * *   To get a repository's contents recursively, you can [recursively get the tree](https://docs.github.com/rest/reference/git#trees).
   * *   This API has an upper limit of 1,000 files for a directory. If you need to retrieve more files, use the [Git Trees
   * API](https://docs.github.com/rest/reference/git#get-a-tree).
   * *   This API supports files up to 1 megabyte in size.
   *
   * #### If the content is a directory
   * The response will be an array of objects, one object for each item in the directory.
   * When listing the contents of a directory, submodules have their "type" specified as "file". Logically, the value
   * _should_ be "submodule". This behavior exists in API v3 [for backwards compatibility purposes](https://git.io/v1YCW).
   * In the next major version of the API, the type will be returned as "submodule".
   *
   * #### If the content is a symlink
   * If the requested `:path` points to a symlink, and the symlink's target is a normal file in the repository, then the
   * API responds with the content of the file (in the format shown in the example. Otherwise, the API responds with an object
   * describing the symlink itself.
   *
   * #### If the content is a submodule
   * The `submodule_git_url` identifies the location of the submodule repository, and the `sha` identifies a specific
   * commit within the submodule repository. Git uses the given URL when cloning the submodule repository, and checks out
   * the submodule at that specific commit.
   *
   * If the submodule repository is not hosted on github.com, the Git URLs (`git_url` and `_links["git"]`) and the
   * github.com URLs (`html_url` and `_links["html"]`) will have null values.
   */
  "repos/get-content": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        /**
         * path+ parameter
         */
        path: string;
      };
      query: {
        /**
         * The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
         */
        ref?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/vnd.github.v3.object": components["schemas"]["content-tree"];
        "application/json":
          | components["schemas"]["content-directory"]
          | components["schemas"]["content-file"]
          | components["schemas"]["content-symlink"]
          | components["schemas"]["content-submodule"];
      };
      "302": never;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Creates a new file or replaces an existing file in a repository.
   */
  "repos/create-or-update-file-contents": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        /**
         * path+ parameter
         */
        path: string;
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The commit message.
         */
        message: string;
        /**
         * The new file content, using Base64 encoding.
         */
        content: string;
        /**
         * **Required if you are updating a file**. The blob SHA of the file being replaced.
         */
        sha?: string;
        /**
         * The branch name. Default: the repository’s default branch (usually `master`)
         */
        branch?: string;
        /**
         * The person that committed the file. Default: the authenticated user.
         */
        committer?: {
          /**
           * The name of the author or committer of the commit. You'll receive a `422` status code if `name` is omitted.
           */
          name: string;
          /**
           * The email of the author or committer of the commit. You'll receive a `422` status code if `email` is omitted.
           */
          email: string;
          date?: string;
        };
        /**
         * The author of the file. Default: The `committer` or the authenticated user if you omit `committer`.
         */
        author?: {
          /**
           * The name of the author or committer of the commit. You'll receive a `422` status code if `name` is omitted.
           */
          name: string;
          /**
           * The email of the author or committer of the commit. You'll receive a `422` status code if `email` is omitted.
           */
          email: string;
          date?: string;
        };
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["file-commit"];
      };
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["file-commit"];
      };
      "404": unknown;
      "409": unknown;
      "422": unknown;
    };
  };
  /**
   * Deletes a file in a repository.
   *
   * You can provide an additional `committer` parameter, which is an object containing information about the committer. Or, you can provide an `author` parameter, which is an object containing information about the author.
   *
   * The `author` section is optional and is filled in with the `committer` information if omitted. If the `committer` information is omitted, the authenticated user's information is used.
   *
   * You must provide values for both `name` and `email`, whether you choose to use `author` or `committer`. Otherwise, you'll receive a `422` status code.
   */
  "repos/delete-file": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        /**
         * path+ parameter
         */
        path: string;
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The commit message.
         */
        message: string;
        /**
         * The blob SHA of the file being replaced.
         */
        sha: string;
        /**
         * The branch name. Default: the repository’s default branch (usually `master`)
         */
        branch?: string;
        /**
         * object containing information about the committer.
         */
        committer?: {
          /**
           * The name of the author (or committer) of the commit
           */
          name?: string;
          /**
           * The email of the author (or committer) of the commit
           */
          email?: string;
        };
        /**
         * object containing information about the author.
         */
        author?: {
          /**
           * The name of the author (or committer) of the commit
           */
          name?: string;
          /**
           * The email of the author (or committer) of the commit
           */
          email?: string;
        };
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["file-commit"];
      };
      "404": unknown;
      "409": unknown;
      "422": unknown;
      "503": unknown;
    };
  };
  /**
   * Lists contributors to the specified repository and sorts them by the number of commits per contributor in descending order. This endpoint may return information that is a few hours old because the GitHub REST API v3 caches contributor data to improve performance.
   *
   * GitHub identifies contributors by author email address. This endpoint groups contribution counts by GitHub user, which includes all associated email addresses. To improve performance, only the first 500 author email addresses in the repository link to GitHub users. The rest will appear as anonymous contributors without associated GitHub user information.
   */
  "repos/list-contributors": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        /**
         * Set to `1` or `true` to include anonymous contributors in results.
         */
        anon?: string;
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * Response if repository contains content
       */
      "200": {
        "application/json": components["schemas"]["contributor"][];
      };
      /**
       * Response if repository is empty
       */
      "204": never;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Simple filtering of deployments is available via query parameters:
   */
  "repos/list-deployments": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        /**
         * The SHA recorded at creation time.
         */
        sha?: string;
        /**
         * The name of the ref. This can be a branch, tag, or SHA.
         */
        ref?: string;
        /**
         * The name of the task for the deployment (e.g., `deploy` or `deploy:migrations`).
         */
        task?: string;
        /**
         * The name of the environment that was deployed to (e.g., `staging` or `production`).
         */
        environment?: string;
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["deployment"][];
      };
    };
  };
  /**
   * Deployments offer a few configurable parameters with certain defaults.
   *
   * The `ref` parameter can be any named branch, tag, or SHA. At GitHub we often deploy branches and verify them
   * before we merge a pull request.
   *
   * The `environment` parameter allows deployments to be issued to different runtime environments. Teams often have
   * multiple environments for verifying their applications, such as `production`, `staging`, and `qa`. This parameter
   * makes it easier to track which environments have requested deployments. The default environment is `production`.
   *
   * The `auto_merge` parameter is used to ensure that the requested ref is not behind the repository's default branch. If
   * the ref _is_ behind the default branch for the repository, we will attempt to merge it for you. If the merge succeeds,
   * the API will return a successful merge commit. If merge conflicts prevent the merge from succeeding, the API will
   * return a failure response.
   *
   * By default, [commit statuses](https://docs.github.com/rest/reference/repos#statuses) for every submitted context must be in a `success`
   * state. The `required_contexts` parameter allows you to specify a subset of contexts that must be `success`, or to
   * specify contexts that have not yet been submitted. You are not required to use commit statuses to deploy. If you do
   * not require any contexts or create any commit statuses, the deployment will always succeed.
   *
   * The `payload` parameter is available for any extra information that a deployment system might need. It is a JSON text
   * field that will be passed on when a deployment event is dispatched.
   *
   * The `task` parameter is used by the deployment system to allow different execution paths. In the web world this might
   * be `deploy:migrations` to run schema changes on the system. In the compiled world this could be a flag to compile an
   * application with debugging enabled.
   *
   * Users with `repo` or `repo_deployment` scopes can create a deployment for a given ref.
   *
   * #### Merged branch response
   * You will see this response when GitHub automatically merges the base branch into the topic branch instead of creating
   * a deployment. This auto-merge happens when:
   * *   Auto-merge option is enabled in the repository
   * *   Topic branch does not include the latest changes on the base branch, which is `master` in the response example
   * *   There are no merge conflicts
   *
   * If there are no new commits in the base branch, a new request to create a deployment should give a successful
   * response.
   *
   * #### Merge conflict response
   * This error happens when the `auto_merge` option is enabled and when the default branch (in this case `master`), can't
   * be merged into the branch that's being deployed (in this case `topic-branch`), due to merge conflicts.
   *
   * #### Failed commit status checks
   * This error happens when the `required_contexts` parameter indicates that one or more contexts need to have a `success`
   * status for the commit to be deployed, but one or more of the required contexts do not have a state of `success`.
   */
  "repos/create-deployment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The ref to deploy. This can be a branch, tag, or SHA.
         */
        ref: string;
        /**
         * Specifies a task to execute (e.g., `deploy` or `deploy:migrations`).
         */
        task?: string;
        /**
         * Attempts to automatically merge the default branch into the requested ref, if it's behind the default branch.
         */
        auto_merge?: boolean;
        /**
         * The [status](https://docs.github.com/rest/reference/repos#statuses) contexts to verify against commit status checks. If you omit this parameter, GitHub verifies all unique contexts before creating a deployment. To bypass checking entirely, pass an empty array. Defaults to all unique contexts.
         */
        required_contexts?: string[];
        /**
         * JSON payload with extra information about the deployment.
         */
        payload?: string;
        /**
         * Name for the target deployment environment (e.g., `production`, `staging`, `qa`).
         */
        environment?: string;
        /**
         * Short description of the deployment.
         */
        description?: string | null;
        /**
         * Specifies if the given environment is specific to the deployment and will no longer exist at some point in the future. Default: `false`
         * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://docs.github.com/rest/overview/api-previews#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://docs.github.com/rest/overview/api-previews#enhanced-deployments) custom media type.
         */
        transient_environment?: boolean;
        /**
         * Specifies if the given environment is one that end-users directly interact with. Default: `true` when `environment` is `production` and `false` otherwise.
         * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://docs.github.com/rest/overview/api-previews#enhanced-deployments) custom media type.
         */
        production_environment?: boolean;
        created_at?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["deployment"];
      };
      /**
       * Merged branch response
       */
      "202": {
        "application/json": { message?: string };
      };
      /**
       * response
       */
      "409": {
        "application/json": { message?: string; documentation_url?: string };
      };
      "422": unknown;
    };
  };
  "repos/get-deployment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        deployment_id: components["parameters"]["deployment_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["deployment"];
      };
      "404": unknown;
    };
  };
  /**
   * To ensure there can always be an active deployment, you can only delete an _inactive_ deployment. Anyone with `repo` or `repo_deployment` scopes can delete an inactive deployment.
   *
   * To set a deployment as inactive, you must:
   *
   * *   Create a new deployment that is active so that the system has a record of the current state, then delete the previously active deployment.
   * *   Mark the active deployment as inactive by adding any non-successful deployment status.
   *
   * For more information, see "[Create a deployment](https://docs.github.com/rest/reference/repos/#create-a-deployment)" and "[Create a deployment status](https://docs.github.com/rest/reference/repos#create-a-deployment-status)."
   */
  "repos/delete-deployment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        deployment_id: components["parameters"]["deployment_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Users with pull access can view deployment statuses for a deployment:
   */
  "repos/list-deployment-statuses": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        deployment_id: components["parameters"]["deployment_id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["deployment-status"][];
      };
      "404": unknown;
    };
  };
  /**
   * Users with `push` access can create deployment statuses for a given deployment.
   *
   * GitHub Apps require `read & write` access to "Deployments" and `read-only` access to "Repo contents" (for private repos). OAuth Apps require the `repo_deployment` scope.
   */
  "repos/create-deployment-status": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        deployment_id: components["parameters"]["deployment_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The state of the status. Can be one of `error`, `failure`, `inactive`, `in_progress`, `queued` `pending`, or `success`. **Note:** To use the `inactive` state, you must provide the [`application/vnd.github.ant-man-preview+json`](https://docs.github.com/rest/overview/api-previews#enhanced-deployments) custom media type. To use the `in_progress` and `queued` states, you must provide the [`application/vnd.github.flash-preview+json`](https://docs.github.com/rest/overview/api-previews#deployment-statuses) custom media type. When you set a transient deployment to `inactive`, the deployment will be shown as `destroyed` in GitHub.
         */
        state:
          | "error"
          | "failure"
          | "inactive"
          | "in_progress"
          | "queued"
          | "pending"
          | "success";
        /**
         * The target URL to associate with this status. This URL should contain output to keep the user updated while the task is running or serve as historical information for what happened in the deployment. **Note:** It's recommended to use the `log_url` parameter, which replaces `target_url`.
         */
        target_url?: string;
        /**
         * The full URL of the deployment's output. This parameter replaces `target_url`. We will continue to accept `target_url` to support legacy uses, but we recommend replacing `target_url` with `log_url`. Setting `log_url` will automatically set `target_url` to the same value. Default: `""`
         * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://docs.github.com/rest/overview/api-previews#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://docs.github.com/rest/overview/api-previews#enhanced-deployments) custom media type.
         */
        log_url?: string;
        /**
         * A short description of the status. The maximum description length is 140 characters.
         */
        description?: string;
        /**
         * Name for the target deployment environment, which can be changed when setting a deploy status. For example, `production`, `staging`, or `qa`. **Note:** This parameter requires you to use the [`application/vnd.github.flash-preview+json`](https://docs.github.com/rest/overview/api-previews#deployment-statuses) custom media type.
         */
        environment?: "production" | "staging" | "qa";
        /**
         * Sets the URL for accessing your environment. Default: `""`
         * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://docs.github.com/rest/overview/api-previews#enhanced-deployments) custom media type. **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://docs.github.com/rest/overview/api-previews#enhanced-deployments) custom media type.
         */
        environment_url?: string;
        /**
         * Adds a new `inactive` status to all prior non-transient, non-production environment deployments with the same repository and `environment` name as the created status's deployment. An `inactive` status is only added to deployments that had a `success` state. Default: `true`
         * **Note:** To add an `inactive` status to `production` environments, you must use the [`application/vnd.github.flash-preview+json`](https://docs.github.com/rest/overview/api-previews#deployment-statuses) custom media type.
         * **Note:** This parameter requires you to use the [`application/vnd.github.ant-man-preview+json`](https://docs.github.com/rest/overview/api-previews#enhanced-deployments) custom media type.
         */
        auto_inactive?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["deployment-status"];
      };
      "422": unknown;
    };
  };
  /**
   * Users with pull access can view a deployment status for a deployment:
   */
  "repos/get-deployment-status": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        deployment_id: components["parameters"]["deployment_id"];
        status_id: number;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["deployment-status"];
      };
      "404": unknown;
      "415": unknown;
    };
  };
  /**
   * You can use this endpoint to trigger a webhook event called `repository_dispatch` when you want activity that happens outside of GitHub to trigger a GitHub Actions workflow or GitHub App webhook. You must configure your GitHub Actions workflow or GitHub App to run when the `repository_dispatch` event occurs. For an example `repository_dispatch` webhook payload, see "[RepositoryDispatchEvent](https://docs.github.com/webhooks/event-payloads/#repository_dispatch)."
   *
   * The `client_payload` parameter is available for any extra information that your workflow might need. This parameter is a JSON payload that will be passed on when the webhook event is dispatched. For example, the `client_payload` can include a message that a user would like to send using a GitHub Actions workflow. Or the `client_payload` can be used as a test to debug your workflow.
   *
   * To give you write access to the repository, you must use a personal access token with the `repo` scope. For more information, see "[Creating a personal access token for the command line](https://help.github.com/articles/creating-a-personal-access-token-for-the-command-line)" in the GitHub Help documentation.
   *
   * This input example shows how you can use the `client_payload` as a test to debug your workflow.
   */
  "repos/create-dispatch-event": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * A custom webhook event name.
         */
        event_type: string;
        /**
         * JSON payload with extra information about the webhook event that your action or worklow may use.
         */
        client_payload?: { [key: string]: any };
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "422": unknown;
    };
  };
  "activity/list-repo-events": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["event"][];
      };
    };
  };
  "repos/list-forks": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        /**
         * The sort order. Can be either `newest`, `oldest`, or `stargazers`.
         */
        sort?: "newest" | "oldest" | "stargazers";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["minimal-repository"][];
      };
      "400": unknown;
    };
  };
  /**
   * Create a fork for the authenticated user.
   *
   * **Note**: Forking a Repository happens asynchronously. You may have to wait a short period of time before you can access the git objects. If this takes longer than 5 minutes, be sure to contact [GitHub Support](https://github.com/contact) or [GitHub Premium Support](https://premium.githubsupport.com).
   */
  "repos/create-fork": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Optional parameter to specify the organization name if forking into an organization.
         */
        organization?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "202": {
        "application/json": components["schemas"]["repository"];
      };
      "400": unknown;
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  "git/create-blob": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The new blob's content.
         */
        content: string;
        /**
         * The encoding used for `content`. Currently, `"utf-8"` and `"base64"` are supported.
         */
        encoding?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["short-blob"];
      };
      "403": unknown;
      "404": unknown;
      "409": unknown;
      "422": unknown;
    };
  };
  /**
   * The `content` in the response will always be Base64 encoded.
   *
   * _Note_: This API supports blobs up to 100 megabytes in size.
   */
  "git/get-blob": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        file_sha: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["blob"];
      };
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Creates a new Git [commit object](https://git-scm.com/book/en/v1/Git-Internals-Git-Objects#Commit-Objects).
   *
   * **Signature verification object**
   *
   * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
   *
   * | Name | Type | Description |
   * | ---- | ---- | ----------- |
   * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
   * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
   * | `signature` | `string` | The signature that was extracted from the commit. |
   * | `payload` | `string` | The value that was signed. |
   *
   * These are the possible values for `reason` in the `verification` object:
   *
   * | Value | Description |
   * | ----- | ----------- |
   * | `expired_key` | The key that made the signature is expired. |
   * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
   * | `gpgverify_error` | There was an error communicating with the signature verification service. |
   * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
   * | `unsigned` | The object does not include a signature. |
   * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
   * | `no_user` | No user was associated with the `committer` email address in the commit. |
   * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
   * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
   * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
   * | `malformed_signature` | There was an error parsing the signature. |
   * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
   * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
   */
  "git/create-commit": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The commit message
         */
        message: string;
        /**
         * The SHA of the tree object this commit points to
         */
        tree: string;
        /**
         * The SHAs of the commits that were the parents of this commit. If omitted or empty, the commit will be written as a root commit. For a single parent, an array of one SHA should be provided; for a merge commit, an array of more than one should be provided.
         */
        parents?: string[];
        /**
         * Information about the author of the commit. By default, the `author` will be the authenticated user and the current date. See the `author` and `committer` object below for details.
         */
        author?: {
          /**
           * The name of the author (or committer) of the commit
           */
          name?: string;
          /**
           * The email of the author (or committer) of the commit
           */
          email?: string;
          /**
           * Indicates when this commit was authored (or committed). This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
           */
          date?: string;
        };
        /**
         * Information about the person who is making the commit. By default, `committer` will use the information set in `author`. See the `author` and `committer` object below for details.
         */
        committer?: {
          /**
           * The name of the author (or committer) of the commit
           */
          name?: string;
          /**
           * The email of the author (or committer) of the commit
           */
          email?: string;
          /**
           * Indicates when this commit was authored (or committed). This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
           */
          date?: string;
        };
        /**
         * The [PGP signature](https://en.wikipedia.org/wiki/Pretty_Good_Privacy) of the commit. GitHub adds the signature to the `gpgsig` header of the created commit. For a commit signature to be verifiable by Git or GitHub, it must be an ASCII-armored detached PGP signature over the string commit as it would be written to the object database. To pass a `signature` parameter, you need to first manually create a valid PGP signature, which can be complicated. You may find it easier to [use the command line](https://git-scm.com/book/id/v2/Git-Tools-Signing-Your-Work) to create signed commits.
         */
        signature?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["git-commit"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Gets a Git [commit object](https://git-scm.com/book/en/v1/Git-Internals-Git-Objects#Commit-Objects).
   *
   * **Signature verification object**
   *
   * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
   *
   * | Name | Type | Description |
   * | ---- | ---- | ----------- |
   * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
   * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
   * | `signature` | `string` | The signature that was extracted from the commit. |
   * | `payload` | `string` | The value that was signed. |
   *
   * These are the possible values for `reason` in the `verification` object:
   *
   * | Value | Description |
   * | ----- | ----------- |
   * | `expired_key` | The key that made the signature is expired. |
   * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
   * | `gpgverify_error` | There was an error communicating with the signature verification service. |
   * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
   * | `unsigned` | The object does not include a signature. |
   * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
   * | `no_user` | No user was associated with the `committer` email address in the commit. |
   * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
   * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
   * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
   * | `malformed_signature` | There was an error parsing the signature. |
   * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
   * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
   */
  "git/get-commit": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        commit_sha: components["parameters"]["commit_sha"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["git-commit"];
      };
      "404": unknown;
    };
  };
  /**
   * Returns an array of references from your Git database that match the supplied name. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't exist in the repository, but existing refs start with `:ref`, they will be returned as an array.
   *
   * When you use this endpoint without providing a `:ref`, it will return an array of all the references from your Git database, including notes and stashes if they exist on the server. Anything in the namespace is returned, not just `heads` and `tags`.
   *
   * **Note:** You need to explicitly [request a pull request](https://docs.github.com/rest/reference/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
   *
   * If you request matching references for a branch named `feature` but the branch `feature` doesn't exist, the response can still include other matching head refs that start with the word `feature`, such as `featureA` and `featureB`.
   */
  "git/list-matching-refs": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        /**
         * ref+ parameter
         */
        ref: string;
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["git-ref"][];
      };
    };
  };
  /**
   * Returns a single reference from your Git database. The `:ref` in the URL must be formatted as `heads/<branch name>` for branches and `tags/<tag name>` for tags. If the `:ref` doesn't match an existing ref, a `404` is returned.
   *
   * **Note:** You need to explicitly [request a pull request](https://docs.github.com/rest/reference/pulls#get-a-pull-request) to trigger a test merge commit, which checks the mergeability of pull requests. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
   */
  "git/get-ref": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        /**
         * ref+ parameter
         */
        ref: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["git-ref"];
      };
      "404": unknown;
    };
  };
  /**
   * Creates a reference for your repository. You are unable to create new references for empty repositories, even if the commit SHA-1 hash used exists. Empty repositories are repositories without branches.
   */
  "git/create-ref": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The name of the fully qualified reference (ie: `refs/heads/master`). If it doesn't start with 'refs' and have at least two slashes, it will be rejected.
         */
        ref: string;
        /**
         * The SHA1 value for this reference.
         */
        sha: string;
        key?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["git-ref"];
      };
      "422": unknown;
    };
  };
  "git/update-ref": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        /**
         * ref+ parameter
         */
        ref: string;
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The SHA1 value to set this reference to
         */
        sha: string;
        /**
         * Indicates whether to force the update or to make sure the update is a fast-forward update. Leaving this out or setting it to `false` will make sure you're not overwriting work.
         */
        force?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["git-ref"];
      };
      "422": unknown;
    };
  };
  "git/delete-ref": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        /**
         * ref+ parameter
         */
        ref: string;
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "422": unknown;
    };
  };
  /**
   * Note that creating a tag object does not create the reference that makes a tag in Git. If you want to create an annotated tag in Git, you have to do this call to create the tag object, and then [create](https://docs.github.com/rest/reference/git#create-a-reference) the `refs/tags/[tag]` reference. If you want to create a lightweight tag, you only have to [create](https://docs.github.com/rest/reference/git#create-a-reference) the tag reference - this call would be unnecessary.
   *
   * **Signature verification object**
   *
   * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
   *
   * | Name | Type | Description |
   * | ---- | ---- | ----------- |
   * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
   * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
   * | `signature` | `string` | The signature that was extracted from the commit. |
   * | `payload` | `string` | The value that was signed. |
   *
   * These are the possible values for `reason` in the `verification` object:
   *
   * | Value | Description |
   * | ----- | ----------- |
   * | `expired_key` | The key that made the signature is expired. |
   * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
   * | `gpgverify_error` | There was an error communicating with the signature verification service. |
   * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
   * | `unsigned` | The object does not include a signature. |
   * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
   * | `no_user` | No user was associated with the `committer` email address in the commit. |
   * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
   * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
   * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
   * | `malformed_signature` | There was an error parsing the signature. |
   * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
   * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
   */
  "git/create-tag": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The tag's name. This is typically a version (e.g., "v0.0.1").
         */
        tag: string;
        /**
         * The tag message.
         */
        message: string;
        /**
         * The SHA of the git object this is tagging.
         */
        object: string;
        /**
         * The type of the object we're tagging. Normally this is a `commit` but it can also be a `tree` or a `blob`.
         */
        type: "commit" | "tree" | "blob";
        /**
         * An object with information about the individual creating the tag.
         */
        tagger?: {
          /**
           * The name of the author of the tag
           */
          name?: string;
          /**
           * The email of the author of the tag
           */
          email?: string;
          /**
           * When this object was tagged. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
           */
          date?: string;
        };
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["git-tag"];
      };
      "422": unknown;
    };
  };
  /**
   * **Signature verification object**
   *
   * The response will include a `verification` object that describes the result of verifying the commit's signature. The following fields are included in the `verification` object:
   *
   * | Name | Type | Description |
   * | ---- | ---- | ----------- |
   * | `verified` | `boolean` | Indicates whether GitHub considers the signature in this commit to be verified. |
   * | `reason` | `string` | The reason for verified value. Possible values and their meanings are enumerated in table below. |
   * | `signature` | `string` | The signature that was extracted from the commit. |
   * | `payload` | `string` | The value that was signed. |
   *
   * These are the possible values for `reason` in the `verification` object:
   *
   * | Value | Description |
   * | ----- | ----------- |
   * | `expired_key` | The key that made the signature is expired. |
   * | `not_signing_key` | The "signing" flag is not among the usage flags in the GPG key that made the signature. |
   * | `gpgverify_error` | There was an error communicating with the signature verification service. |
   * | `gpgverify_unavailable` | The signature verification service is currently unavailable. |
   * | `unsigned` | The object does not include a signature. |
   * | `unknown_signature_type` | A non-PGP signature was found in the commit. |
   * | `no_user` | No user was associated with the `committer` email address in the commit. |
   * | `unverified_email` | The `committer` email address in the commit was associated with a user, but the email address is not verified on her/his account. |
   * | `bad_email` | The `committer` email address in the commit is not included in the identities of the PGP key that made the signature. |
   * | `unknown_key` | The key that made the signature has not been registered with any user's account. |
   * | `malformed_signature` | There was an error parsing the signature. |
   * | `invalid` | The signature could not be cryptographically verified using the key whose key-id was found in the signature. |
   * | `valid` | None of the above errors applied, so the signature is considered to be verified. |
   */
  "git/get-tag": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        tag_sha: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["git-tag"];
      };
      "404": unknown;
    };
  };
  /**
   * The tree creation API accepts nested entries. If you specify both a tree and a nested path modifying that tree, this endpoint will overwrite the contents of the tree with the new path contents, and create a new tree structure.
   *
   * If you use this endpoint to add, delete, or modify the file contents in a tree, you will need to commit the tree and then update a branch to point to the commit. For more information see "[Create a commit](https://docs.github.com/rest/reference/git#create-a-commit)" and "[Update a reference](https://docs.github.com/rest/reference/git#update-a-reference)."
   */
  "git/create-tree": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Objects (of `path`, `mode`, `type`, and `sha`) specifying a tree structure.
         */
        tree: {
          /**
           * The file referenced in the tree.
           */
          path?: string;
          /**
           * The file mode; one of `100644` for file (blob), `100755` for executable (blob), `040000` for subdirectory (tree), `160000` for submodule (commit), or `120000` for a blob that specifies the path of a symlink.
           */
          mode?: "100644" | "100755" | "040000" | "160000" | "120000";
          /**
           * Either `blob`, `tree`, or `commit`.
           */
          type?: "blob" | "tree" | "commit";
          /**
           * The SHA1 checksum ID of the object in the tree. Also called `tree.sha`. If the value is `null` then the file will be deleted.
           *
           * **Note:** Use either `tree.sha` or `content` to specify the contents of the entry. Using both `tree.sha` and `content` will return an error.
           */
          sha?: string | null;
          /**
           * The content you want this file to have. GitHub will write this blob out and use that SHA for this entry. Use either this, or `tree.sha`.
           *
           * **Note:** Use either `tree.sha` or `content` to specify the contents of the entry. Using both `tree.sha` and `content` will return an error.
           */
          content?: string;
        }[];
        /**
         * The SHA1 of an existing Git tree object which will be used as the base for the new tree. If provided, a new Git tree object will be created from entries in the Git tree object pointed to by `base_tree` and entries defined in the `tree` parameter. Entries defined in the `tree` parameter will overwrite items from `base_tree` with the same `path`. If you're creating new changes on a branch, then normally you'd set `base_tree` to the SHA1 of the Git tree object of the current latest commit on the branch you're working on.
         * If not provided, GitHub will create a new Git tree object from only the entries defined in the `tree` parameter. If you create a new commit pointing to such a tree, then all files which were a part of the parent commit's tree and were not defined in the `tree` parameter will be listed as deleted by the new commit.
         */
        base_tree?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["git-tree"];
      };
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Returns a single tree using the SHA1 value for that tree.
   *
   * If `truncated` is `true` in the response then the number of items in the `tree` array exceeded our maximum limit. If you need to fetch more items, use the non-recursive method of fetching trees, and fetch one sub-tree at a time.
   */
  "git/get-tree": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        tree_sha: string;
      };
      query: {
        /**
         * Setting this parameter to any value returns the objects or subtrees referenced by the tree specified in `:tree_sha`. For example, setting `recursive` to any of the following will enable returning objects or subtrees: `0`, `1`, `"true"`, and `"false"`. Omit this parameter to prevent recursively returning objects or subtrees.
         */
        recursive?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["git-tree"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  "repos/list-webhooks": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["hook"][];
      };
      "404": unknown;
    };
  };
  /**
   * Repositories can have multiple webhooks installed. Each webhook should have a unique `config`. Multiple webhooks can
   * share the same `config` as long as those webhooks do not have any `events` that overlap.
   */
  "repos/create-webhook": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Use `web` to create a webhook. Default: `web`. This parameter only accepts the value `web`.
         */
        name?: string;
        /**
         * Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/rest/reference/repos#create-hook-config-params).
         */
        config: {
          url: components["schemas"]["webhook-config-url"];
          content_type?: components["schemas"]["webhook-config-content-type"];
          secret?: components["schemas"]["webhook-config-secret"];
          insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
          token?: string;
          digest?: string;
        };
        /**
         * Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for.
         */
        events?: string[];
        /**
         * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
         */
        active?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["hook"];
      };
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Returns a webhook configured in a repository. To get only the webhook `config` properties, see "[Get a webhook configuration for a repository](/rest/reference/repos#get-a-webhook-configuration-for-a-repository)."
   */
  "repos/get-webhook": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["hook"];
      };
      "404": unknown;
    };
  };
  /**
   * Updates a webhook configured in a repository. If you previously had a `secret` set, you must provide the same `secret` or set a new `secret` or the secret will be removed. If you are only updating individual webhook `config` properties, use "[Update a webhook configuration for a repository](/rest/reference/repos#update-a-webhook-configuration-for-a-repository)."
   */
  "repos/update-webhook": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        hook_id: components["parameters"]["hook-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Key/value pairs to provide settings for this webhook. [These are defined below](https://docs.github.com/rest/reference/repos#create-hook-config-params).
         */
        config?: {
          url: components["schemas"]["webhook-config-url"];
          content_type?: components["schemas"]["webhook-config-content-type"];
          secret?: components["schemas"]["webhook-config-secret"];
          insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
          address?: string;
          room?: string;
        };
        /**
         * Determines what [events](https://docs.github.com/webhooks/event-payloads) the hook is triggered for. This replaces the entire array of events.
         */
        events?: string[];
        /**
         * Determines a list of events to be added to the list of events that the Hook triggers for.
         */
        add_events?: string[];
        /**
         * Determines a list of events to be removed from the list of events that the Hook triggers for.
         */
        remove_events?: string[];
        /**
         * Determines if notifications are sent when the webhook is triggered. Set to `true` to send notifications.
         */
        active?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["hook"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  "repos/delete-webhook": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
    };
  };
  /**
   * Returns the webhook configuration for a repository. To get more information about the webhook, including the `active` state and `events`, use "[Get a repository webhook](/rest/reference/orgs#get-a-repository-webhook)."
   *
   * Access tokens must have the `read:repo_hook` or `repo` scope, and GitHub Apps must have the `repository_hooks:read` permission.
   */
  "repos/get-webhook-config-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /**
       * Default response
       */
      "200": {
        "application/json": components["schemas"]["webhook-config"];
      };
    };
  };
  /**
   * Updates the webhook configuration for a repository. To update more information about the webhook, including the `active` state and `events`, use "[Update a repository webhook](/rest/reference/orgs#update-a-repository-webhook)."
   *
   * Access tokens must have the `write:repo_hook` or `repo` scope, and GitHub Apps must have the `repository_hooks:write` permission.
   */
  "repos/update-webhook-config-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        hook_id: components["parameters"]["hook-id"];
      };
    };
    requestBody: {
      "application/json": {
        url?: components["schemas"]["webhook-config-url"];
        content_type?: components["schemas"]["webhook-config-content-type"];
        secret?: components["schemas"]["webhook-config-secret"];
        insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
      };
    };
    responses: {
      /**
       * Default response
       */
      "200": {
        "application/json": components["schemas"]["webhook-config"];
      };
    };
  };
  /**
   * This will trigger a [ping event](https://docs.github.com/webhooks/#ping-event) to be sent to the hook.
   */
  "repos/ping-webhook": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
    };
  };
  /**
   * This will trigger the hook with the latest push to the current repository if the hook is subscribed to `push` events. If the hook is not subscribed to `push` events, the server will respond with 204 but no test POST will be generated.
   *
   * **Note**: Previously `/repos/:owner/:repo/hooks/:hook_id/test`
   */
  "repos/test-push-webhook": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        hook_id: components["parameters"]["hook-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
    };
  };
  /**
   * View the progress of an import.
   *
   * **Import status**
   *
   * This section includes details about the possible values of the `status` field of the Import Progress response.
   *
   * An import that does not have errors will progress through these steps:
   *
   * *   `detecting` - the "detection" step of the import is in progress because the request did not include a `vcs` parameter. The import is identifying the type of source control present at the URL.
   * *   `importing` - the "raw" step of the import is in progress. This is where commit data is fetched from the original repository. The import progress response will include `commit_count` (the total number of raw commits that will be imported) and `percent` (0 - 100, the current progress through the import).
   * *   `mapping` - the "rewrite" step of the import is in progress. This is where SVN branches are converted to Git branches, and where author updates are applied. The import progress response does not include progress information.
   * *   `pushing` - the "push" step of the import is in progress. This is where the importer updates the repository on GitHub. The import progress response will include `push_percent`, which is the percent value reported by `git push` when it is "Writing objects".
   * *   `complete` - the import is complete, and the repository is ready on GitHub.
   *
   * If there are problems, you will see one of these in the `status` field:
   *
   * *   `auth_failed` - the import requires authentication in order to connect to the original repository. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/reference/migrations#update-an-import) section.
   * *   `error` - the import encountered an error. The import progress response will include the `failed_step` and an error message. Contact [GitHub Support](https://github.com/contact) or [GitHub Premium Support](https://premium.githubsupport.com) for more information.
   * *   `detection_needs_auth` - the importer requires authentication for the originating repository to continue detection. To update authentication for the import, please see the [Update an import](https://docs.github.com/rest/reference/migrations#update-an-import) section.
   * *   `detection_found_nothing` - the importer didn't recognize any source control at the URL. To resolve, [Cancel the import](https://docs.github.com/rest/reference/migrations#cancel-an-import) and [retry](https://docs.github.com/rest/reference/migrations#start-an-import) with the correct URL.
   * *   `detection_found_multiple` - the importer found several projects or repositories at the provided URL. When this is the case, the Import Progress response will also include a `project_choices` field with the possible project choices as values. To update project choice, please see the [Update an import](https://docs.github.com/rest/reference/migrations#update-an-import) section.
   *
   * **The project_choices field**
   *
   * When multiple projects are found at the provided URL, the response hash will include a `project_choices` field, the value of which is an array of hashes each representing a project choice. The exact key/value pairs of the project hashes will differ depending on the version control type.
   *
   * **Git LFS related fields**
   *
   * This section includes details about Git LFS related fields that may be present in the Import Progress response.
   *
   * *   `use_lfs` - describes whether the import has been opted in or out of using Git LFS. The value can be `opt_in`, `opt_out`, or `undecided` if no action has been taken.
   * *   `has_large_files` - the boolean value describing whether files larger than 100MB were found during the `importing` step.
   * *   `large_files_size` - the total size in gigabytes of files larger than 100MB found in the originating repository.
   * *   `large_files_count` - the total number of files larger than 100MB found in the originating repository. To see a list of these files, make a "Get Large Files" request.
   */
  "migrations/get-import-status": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["import"];
      };
      "404": unknown;
    };
  };
  /**
   * Start a source import to a GitHub repository using GitHub Importer.
   */
  "migrations/start-import": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The URL of the originating repository.
         */
        vcs_url: string;
        /**
         * The originating VCS type. Can be one of `subversion`, `git`, `mercurial`, or `tfvc`. Please be aware that without this parameter, the import job will take additional time to detect the VCS type before beginning the import. This detection step will be reflected in the response.
         */
        vcs?: "subversion" | "git" | "mercurial" | "tfvc";
        /**
         * If authentication is required, the username to provide to `vcs_url`.
         */
        vcs_username?: string;
        /**
         * If authentication is required, the password to provide to `vcs_url`.
         */
        vcs_password?: string;
        /**
         * For a tfvc import, the name of the project that is being imported.
         */
        tfvc_project?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["import"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * An import can be updated with credentials or a project choice by passing in the appropriate parameters in this API
   * request. If no parameters are provided, the import will be restarted.
   */
  "migrations/update-import": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The username to provide to the originating repository.
         */
        vcs_username?: string;
        /**
         * The password to provide to the originating repository.
         */
        vcs_password?: string;
        vcs?: string;
        tfvc_project?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["import"];
      };
    };
  };
  /**
   * Stop an import for a repository.
   */
  "migrations/cancel-import": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Each type of source control system represents authors in a different way. For example, a Git commit author has a display name and an email address, but a Subversion commit author just has a username. The GitHub Importer will make the author information valid, but the author might not be correct. For example, it will change the bare Subversion username `hubot` into something like `hubot <hubot@12341234-abab-fefe-8787-fedcba987654>`.
   *
   * This endpoint and the [Map a commit author](https://docs.github.com/rest/reference/migrations#map-a-commit-author) endpoint allow you to provide correct Git author information.
   */
  "migrations/get-commit-authors": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        since?: components["parameters"]["since-user"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["porter-author"][];
      };
      "404": unknown;
    };
  };
  /**
   * Update an author's identity for the import. Your application can continue updating authors any time before you push new commits to the repository.
   */
  "migrations/map-commit-author": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        author_id: number;
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The new Git author email.
         */
        email?: string;
        /**
         * The new Git author name.
         */
        name?: string;
        remote_id?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["porter-author"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * List files larger than 100MB found during the import
   */
  "migrations/get-large-files": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["porter-large-file"][];
      };
    };
  };
  /**
   * You can import repositories from Subversion, Mercurial, and TFS that include files larger than 100MB. This ability is powered by [Git LFS](https://git-lfs.github.com). You can learn more about our LFS feature and working with large files [on our help site](https://help.github.com/articles/versioning-large-files/).
   */
  "migrations/set-lfs-preference": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Can be one of `opt_in` (large files will be stored using Git LFS) or `opt_out` (large files will be removed during the import).
         */
        use_lfs: "opt_in" | "opt_out";
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["import"];
      };
      "422": unknown;
    };
  };
  /**
   * Enables an authenticated GitHub App to find the repository's installation information. The installation's account type will be either an organization or a user account, depending which account the repository belongs to.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-repo-installation": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["installation"];
      };
      "301": never;
      "404": unknown;
    };
  };
  /**
   * Shows which type of GitHub user can interact with this repository and when the restriction expires. If there are no restrictions, you will see an empty response.
   */
  "interactions/get-restrictions-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["interaction-limit-response"];
      };
    };
  };
  /**
   * Temporarily restricts interactions to a certain type of GitHub user within the given repository. You must have owner or admin access to set these restrictions. If an interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.
   */
  "interactions/set-restrictions-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": components["schemas"]["interaction-limit"];
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["interaction-limit-response"];
      };
      /**
       * Conflict
       */
      "409": unknown;
    };
  };
  /**
   * Removes all interaction restrictions from the given repository. You must have owner or admin access to remove restrictions. If the interaction limit is set for the user or organization that owns this repository, you will receive a `409 Conflict` response and will not be able to use this endpoint to change the interaction limit for a single repository.
   */
  "interactions/remove-restrictions-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      /**
       * Conflict
       */
      "409": unknown;
    };
  };
  /**
   * When authenticating as a user with admin rights to a repository, this endpoint will list all currently open repository invitations.
   */
  "repos/list-invitations": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["repository-invitation"][];
      };
    };
  };
  "repos/update-invitation": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        invitation_id: components["parameters"]["invitation_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The permissions that the associated user will have on the repository. Valid values are `read`, `write`, `maintain`, `triage`, and `admin`.
         */
        permissions?: "read" | "write" | "maintain" | "triage" | "admin";
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["repository-invitation"];
      };
    };
  };
  "repos/delete-invitation": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        invitation_id: components["parameters"]["invitation_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * List issues in a repository.
   *
   * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
   * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
   * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
   * request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
   */
  "issues/list-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        /**
         * If an `integer` is passed, it should refer to a milestone by its `number` field. If the string `*` is passed, issues with any milestone are accepted. If the string `none` is passed, issues without milestones are returned.
         */
        milestone?: string;
        /**
         * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
         */
        state?: "open" | "closed" | "all";
        /**
         * Can be the name of a user. Pass in `none` for issues with no assigned user, and `*` for issues assigned to any user.
         */
        assignee?: string;
        /**
         * The user that created the issue.
         */
        creator?: string;
        /**
         * A user that's mentioned in the issue.
         */
        mentioned?: string;
        labels?: components["parameters"]["labels"];
        /**
         * What to sort results by. Can be either `created`, `updated`, `comments`.
         */
        sort?: "created" | "updated" | "comments";
        direction?: components["parameters"]["direction"];
        since?: components["parameters"]["since"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["issue-simple"][];
      };
      "301": never;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Any user with pull access to a repository can create an issue. If [issues are disabled in the repository](https://help.github.com/articles/disabling-issues/), the API returns a `410 Gone` status.
   *
   * This endpoint triggers [notifications](https://help.github.com/articles/about-notifications/). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-abuse-rate-limits)" for details.
   */
  "issues/create": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The title of the issue.
         */
        title: string;
        /**
         * The contents of the issue.
         */
        body?: string;
        /**
         * Login for the user that this issue should be assigned to. _NOTE: Only users with push access can set the assignee for new issues. The assignee is silently dropped otherwise. **This field is deprecated.**_
         */
        assignee?: string | null;
        /**
         * The `number` of the milestone to associate this issue with. _NOTE: Only users with push access can set the milestone for new issues. The milestone is silently dropped otherwise._
         */
        milestone?: number | null;
        /**
         * Labels to associate with this issue. _NOTE: Only users with push access can set labels for new issues. Labels are silently dropped otherwise._
         */
        labels?: (
          | string
          | { id?: number; name?: string; description?: string; color?: string }
        )[];
        /**
         * Logins for Users to assign to this issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
         */
        assignees?: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["issue"];
      };
      "403": unknown;
      "404": unknown;
      "410": unknown;
      "422": unknown;
      "503": unknown;
    };
  };
  /**
   * By default, Issue Comments are ordered by ascending ID.
   */
  "issues/list-comments-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        sort?: components["parameters"]["sort"];
        /**
         * Either `asc` or `desc`. Ignored without the `sort` parameter.
         */
        direction?: "asc" | "desc";
        since?: components["parameters"]["since"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["issue-comment"][];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  "issues/get-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["issue-comment"];
      };
      "404": unknown;
    };
  };
  "issues/update-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The contents of the comment.
         */
        body: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["issue-comment"];
      };
      "422": unknown;
    };
  };
  "issues/delete-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * List the reactions to an [issue comment](https://docs.github.com/rest/reference/issues#comments).
   */
  "reactions/list-for-issue-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
      };
      query: {
        /**
         * Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to an issue comment.
         */
        content?:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["reaction"][];
      };
      "404": unknown;
      "415": unknown;
    };
  };
  /**
   * Create a reaction to an [issue comment](https://docs.github.com/rest/reference/issues#comments). A response with a `Status: 200 OK` means that you already added the reaction type to this issue comment.
   */
  "reactions/create-for-issue-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the issue comment.
         */
        content:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
      };
    };
    responses: {
      /**
       * Reaction exists
       */
      "200": {
        "application/json": components["schemas"]["reaction"];
      };
      /**
       * Reaction created
       */
      "201": {
        "application/json": components["schemas"]["reaction"];
      };
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * **Note:** You can also specify a repository by `repository_id` using the route `DELETE delete /repositories/:repository_id/issues/comments/:comment_id/reactions/:reaction_id`.
   *
   * Delete a reaction to an [issue comment](https://docs.github.com/rest/reference/issues#comments).
   */
  "reactions/delete-for-issue-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
        reaction_id: components["parameters"]["reaction-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  "issues/list-events-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["issue-event"][];
      };
      "422": unknown;
    };
  };
  "issues/get-event": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        event_id: number;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["issue-event"];
      };
      "403": unknown;
      "404": unknown;
      "410": unknown;
    };
  };
  /**
   * The API returns a [`301 Moved Permanently` status](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-redirects-redirects) if the issue was
   * [transferred](https://help.github.com/articles/transferring-an-issue-to-another-repository/) to another repository. If
   * the issue was transferred to or deleted from a repository where the authenticated user lacks read access, the API
   * returns a `404 Not Found` status. If the issue was deleted from a repository where the authenticated user has read
   * access, the API returns a `410 Gone` status. To receive webhook events for transferred and deleted issues, subscribe
   * to the [`issues`](https://docs.github.com/webhooks/event-payloads/#issues) webhook.
   *
   * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
   * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
   * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
   * request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
   */
  "issues/get": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["issue"];
      };
      "301": never;
      "304": never;
      "404": unknown;
      "410": unknown;
    };
  };
  /**
   * Issue owners and users with push access can edit an issue.
   */
  "issues/update": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The title of the issue.
         */
        title?: string;
        /**
         * The contents of the issue.
         */
        body?: string;
        /**
         * Login for the user that this issue should be assigned to. **This field is deprecated.**
         */
        assignee?: string;
        /**
         * State of the issue. Either `open` or `closed`.
         */
        state?: "open" | "closed";
        /**
         * The `number` of the milestone to associate this issue with or `null` to remove current. _NOTE: Only users with push access can set the milestone for issues. The milestone is silently dropped otherwise._
         */
        milestone?: number | null;
        /**
         * Labels to associate with this issue. Pass one or more Labels to _replace_ the set of Labels on this Issue. Send an empty array (`[]`) to clear all Labels from the Issue. _NOTE: Only users with push access can set labels for issues. Labels are silently dropped otherwise._
         */
        labels?: (
          | string
          | { id?: number; name?: string; description?: string; color?: string }
        )[];
        /**
         * Logins for Users to assign to this issue. Pass one or more user logins to _replace_ the set of assignees on this Issue. Send an empty array (`[]`) to clear all assignees from the Issue. _NOTE: Only users with push access can set assignees for new issues. Assignees are silently dropped otherwise._
         */
        assignees?: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["issue"];
      };
      "301": never;
      "403": unknown;
      "404": unknown;
      "410": unknown;
      "422": unknown;
      "503": unknown;
    };
  };
  /**
   * Adds up to 10 assignees to an issue. Users already assigned to an issue are not replaced.
   */
  "issues/add-assignees": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Usernames of people to assign this issue to. _NOTE: Only users with push access can add assignees to an issue. Assignees are silently ignored otherwise._
         */
        assignees?: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["issue-simple"];
      };
    };
  };
  /**
   * Removes one or more assignees from an issue.
   */
  "issues/remove-assignees": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Usernames of assignees to remove from an issue. _NOTE: Only users with push access can remove assignees from an issue. Assignees are silently ignored otherwise._
         */
        assignees?: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["issue-simple"];
      };
    };
  };
  /**
   * Issue Comments are ordered by ascending ID.
   */
  "issues/list-comments": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
      query: {
        since?: components["parameters"]["since"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["issue-comment"][];
      };
      "404": unknown;
      "410": unknown;
    };
  };
  /**
   * This endpoint triggers [notifications](https://help.github.com/articles/about-notifications/). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-abuse-rate-limits)" for details.
   */
  "issues/create-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The contents of the comment.
         */
        body: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["issue-comment"];
      };
      "403": unknown;
      "404": unknown;
      "410": unknown;
      "422": unknown;
    };
  };
  "issues/list-events": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["issue-event-for-issue"][];
      };
      "410": unknown;
    };
  };
  "issues/list-labels-on-issue": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["label"][];
      };
      "410": unknown;
    };
  };
  "issues/add-labels": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The name of the label to add to the issue. Must contain at least one label. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
         */
        labels: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["label"][];
      };
      "410": unknown;
      "422": unknown;
    };
  };
  /**
   * Removes any previous labels and sets the new labels for an issue.
   */
  "issues/set-labels": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The names of the labels to add to the issue. You can pass an empty array to remove all labels. **Note:** Alternatively, you can pass a single label as a `string` or an `array` of labels directly, but GitHub recommends passing an object with the `labels` key.
         */
        labels?: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["label"][];
      };
      "410": unknown;
      "422": unknown;
    };
  };
  "issues/remove-all-labels": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "410": unknown;
    };
  };
  /**
   * Removes the specified label from the issue, and returns the remaining labels on the issue. This endpoint returns a `404 Not Found` status if the label does not exist.
   */
  "issues/remove-label": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
        name: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["label"][];
      };
      "404": unknown;
      "410": unknown;
    };
  };
  /**
   * Users with push access can lock an issue or pull request's conversation.
   *
   * Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
   */
  "issues/lock": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The reason for locking the issue or pull request conversation. Lock will fail if you don't use one of these reasons:
         * \* `off-topic`
         * \* `too heated`
         * \* `resolved`
         * \* `spam`
         */
        lock_reason?: "off-topic" | "too heated" | "resolved" | "spam";
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "403": unknown;
      "404": unknown;
      "410": unknown;
      "422": unknown;
    };
  };
  /**
   * Users with push access can unlock an issue's conversation.
   */
  "issues/unlock": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * List the reactions to an [issue](https://docs.github.com/rest/reference/issues).
   */
  "reactions/list-for-issue": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
      query: {
        /**
         * Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to an issue.
         */
        content?:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["reaction"][];
      };
      "404": unknown;
      "410": unknown;
      "415": unknown;
    };
  };
  /**
   * Create a reaction to an [issue](https://docs.github.com/rest/reference/issues/). A response with a `Status: 200 OK` means that you already added the reaction type to this issue.
   */
  "reactions/create-for-issue": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the issue.
         */
        content:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["reaction"];
      };
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/issues/:issue_number/reactions/:reaction_id`.
   *
   * Delete a reaction to an [issue](https://docs.github.com/rest/reference/issues/).
   */
  "reactions/delete-for-issue": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
        reaction_id: components["parameters"]["reaction-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  "issues/list-events-for-timeline": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        issue_number: components["parameters"]["issue_number"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["issue-event-for-issue"][];
      };
      "404": unknown;
      "410": unknown;
      "415": unknown;
    };
  };
  "repos/list-deploy-keys": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["deploy-key"][];
      };
    };
  };
  /**
   * You can create a read-only deploy key.
   */
  "repos/create-deploy-key": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * A name for the key.
         */
        title?: string;
        /**
         * The contents of the key.
         */
        key: string;
        /**
         * If `true`, the key will only be able to read repository contents. Otherwise, the key will be able to read and write.
         *
         * Deploy keys with write access can perform the same actions as an organization member with admin access, or a collaborator on a personal repository. For more information, see "[Repository permission levels for an organization](https://help.github.com/articles/repository-permission-levels-for-an-organization/)" and "[Permission levels for a user account repository](https://help.github.com/articles/permission-levels-for-a-user-account-repository/)."
         */
        read_only?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["deploy-key"];
      };
      "422": unknown;
    };
  };
  "repos/get-deploy-key": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        key_id: components["parameters"]["key_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["deploy-key"];
      };
      "404": unknown;
    };
  };
  /**
   * Deploy keys are immutable. If you need to update a key, remove the key and create a new one instead.
   */
  "repos/delete-deploy-key": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        key_id: components["parameters"]["key_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  "issues/list-labels-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["label"][];
      };
      "404": unknown;
    };
  };
  "issues/create-label": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
         */
        name: string;
        /**
         * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
         */
        color?: string;
        /**
         * A short description of the label.
         */
        description?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["label"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  "issues/get-label": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        name: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["label"];
      };
      "404": unknown;
    };
  };
  "issues/update-label": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        name: string;
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The new name of the label. Emoji can be added to label names, using either native emoji or colon-style markup. For example, typing `:strawberry:` will render the emoji ![:strawberry:](https://github.githubassets.com/images/icons/emoji/unicode/1f353.png ":strawberry:"). For a full list of available emoji and codes, see [emoji-cheat-sheet.com](http://emoji-cheat-sheet.com/).
         */
        new_name?: string;
        /**
         * The [hexadecimal color code](http://www.color-hex.com/) for the label, without the leading `#`.
         */
        color?: string;
        /**
         * A short description of the label.
         */
        description?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["label"];
      };
    };
  };
  "issues/delete-label": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        name: string;
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Lists languages for the specified repository. The value shown for each language is the number of bytes of code written in that language.
   */
  "repos/list-languages": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["language"];
      };
    };
  };
  /**
   * This method returns the contents of the repository's license file, if one is detected.
   *
   * Similar to [Get repository content](https://docs.github.com/rest/reference/repos#get-repository-content), this method also supports [custom media types](https://docs.github.com/rest/overview/media-types) for retrieving the raw license content or rendered license HTML.
   */
  "licenses/get-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["license-content"];
      };
    };
  };
  "repos/merge": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The name of the base branch that the head will be merged into.
         */
        base: string;
        /**
         * The head to merge. This can be a branch name or a commit SHA1.
         */
        head: string;
        /**
         * Commit message to use for the merge commit. If omitted, a default message will be used.
         */
        commit_message?: string;
      };
    };
    responses: {
      /**
       * Successful Response (The resulting merge commit)
       */
      "201": {
        "application/json": components["schemas"]["commit"];
      };
      "403": unknown;
      /**
       * response
       */
      "404": {
        "application/json": { message?: string; documentation_url?: string };
      };
      /**
       * Merge conflict response
       */
      "409": {
        "application/json": { message?: string; documentation_url?: string };
      };
      "422": unknown;
    };
  };
  "issues/list-milestones": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        /**
         * The state of the milestone. Either `open`, `closed`, or `all`.
         */
        state?: "open" | "closed" | "all";
        /**
         * What to sort results by. Either `due_on` or `completeness`.
         */
        sort?: "due_on" | "completeness";
        /**
         * The direction of the sort. Either `asc` or `desc`.
         */
        direction?: "asc" | "desc";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["milestone"][];
      };
      "404": unknown;
    };
  };
  "issues/create-milestone": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The title of the milestone.
         */
        title: string;
        /**
         * The state of the milestone. Either `open` or `closed`.
         */
        state?: "open" | "closed";
        /**
         * A description of the milestone.
         */
        description?: string;
        /**
         * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
         */
        due_on?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["milestone"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  "issues/get-milestone": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        milestone_number: components["parameters"]["milestone_number"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["milestone"];
      };
      "404": unknown;
    };
  };
  "issues/update-milestone": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        milestone_number: components["parameters"]["milestone_number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The title of the milestone.
         */
        title?: string;
        /**
         * The state of the milestone. Either `open` or `closed`.
         */
        state?: "open" | "closed";
        /**
         * A description of the milestone.
         */
        description?: string;
        /**
         * The milestone due date. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
         */
        due_on?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["milestone"];
      };
    };
  };
  "issues/delete-milestone": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        milestone_number: components["parameters"]["milestone_number"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
    };
  };
  "issues/list-labels-for-milestone": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        milestone_number: components["parameters"]["milestone_number"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["label"][];
      };
    };
  };
  /**
   * List all notifications for the current user.
   */
  "activity/list-repo-notifications-for-authenticated-user": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        all?: components["parameters"]["all"];
        participating?: components["parameters"]["participating"];
        since?: components["parameters"]["since"];
        before?: components["parameters"]["before"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["thread"][];
      };
    };
  };
  /**
   * Marks all notifications in a repository as "read" removes them from the [default view on GitHub](https://github.com/notifications). If the number of notifications is too large to complete in one request, you will receive a `202 Accepted` status and GitHub will run an asynchronous process to mark notifications as "read." To check whether any "unread" notifications remain, you can use the [List repository notifications for the authenticated user](https://docs.github.com/rest/reference/activity#list-repository-notifications-for-the-authenticated-user) endpoint and pass the query parameter `all=false`.
   */
  "activity/mark-repo-notifications-as-read": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Describes the last point that notifications were checked. Anything updated since this time will not be marked as read. If you omit this parameter, all notifications are marked as read. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`. Default: The current timestamp.
         */
        last_read_at?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "202": unknown;
    };
  };
  "repos/get-pages": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["page"];
      };
      "404": unknown;
    };
  };
  /**
   * Configures a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages)."
   */
  "repos/create-pages-site": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The source branch and directory used to publish your Pages site.
         */
        source: {
          /**
           * The repository branch used to publish your site's source files.
           */
          branch: string;
          /**
           * The repository directory that includes the source files for the Pages site. Allowed paths are `/` or `/docs`. Default: `/`
           */
          path?: "/" | "/docs";
        };
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["page"];
      };
      "409": unknown;
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * Updates information for a GitHub Pages site. For more information, see "[About GitHub Pages](/github/working-with-github-pages/about-github-pages).
   */
  "repos/update-information-about-pages-site": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Specify a custom domain for the repository. Sending a `null` value will remove the custom domain. For more about custom domains, see "[Using a custom domain with GitHub Pages](https://help.github.com/articles/using-a-custom-domain-with-github-pages/)."
         */
        cname?: string | null;
        source: Partial<"gh-pages" | "master" | "master /docs"> &
          Partial<{
            /**
             * The repository branch used to publish your site's source files.
             */
            branch: string;
            /**
             * The repository directory that includes the source files for the Pages site. Allowed paths are `/` or `/docs`.
             */
            path: "/" | "/docs";
          }>;
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "400": unknown;
      "422": unknown;
    };
  };
  "repos/delete-pages-site": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
      "415": unknown;
      "422": unknown;
    };
  };
  "repos/list-pages-builds": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["page-build"][];
      };
    };
  };
  /**
   * You can request that your site be built from the latest revision on the default branch. This has the same effect as pushing a commit to your default branch, but does not require an additional commit. Manually triggering page builds can be helpful when diagnosing build warnings and failures.
   *
   * Build requests are limited to one concurrent build per repository and one concurrent build per requester. If you request a build while another is still in progress, the second request will be queued until the first completes.
   */
  "repos/request-pages-build": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["page-build-status"];
      };
    };
  };
  "repos/get-latest-pages-build": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["page-build"];
      };
    };
  };
  "repos/get-pages-build": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        build_id: number;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["page-build"];
      };
    };
  };
  /**
   * Lists the projects in a repository. Returns a `404 Not Found` status if projects are disabled in the repository. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
   */
  "projects/list-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        /**
         * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
         */
        state?: "open" | "closed" | "all";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["project"][];
      };
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "410": unknown;
      "422": unknown;
    };
  };
  /**
   * Creates a repository project board. Returns a `404 Not Found` status if projects are disabled in the repository. If you do not have sufficient privileges to perform this action, a `401 Unauthorized` or `410 Gone` status is returned.
   */
  "projects/create-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The name of the project.
         */
        name: string;
        /**
         * The description of the project.
         */
        body?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["project"];
      };
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "410": unknown;
      "422": unknown;
    };
  };
  /**
   * Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   */
  "pulls/list": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        /**
         * Either `open`, `closed`, or `all` to filter by state.
         */
        state?: "open" | "closed" | "all";
        /**
         * Filter pulls by head user or head organization and branch name in the format of `user:ref-name` or `organization:ref-name`. For example: `github:new-script-format` or `octocat:test-branch`.
         */
        head?: string;
        /**
         * Filter pulls by base branch name. Example: `gh-pages`.
         */
        base?: string;
        /**
         * What to sort results by. Can be either `created`, `updated`, `popularity` (comment count) or `long-running` (age, filtering by pulls updated in the last month).
         */
        sort?: "created" | "updated" | "popularity" | "long-running";
        /**
         * The direction of the sort. Can be either `asc` or `desc`. Default: `desc` when sort is `created` or sort is not specified, otherwise `asc`.
         */
        direction?: "asc" | "desc";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["pull-request-simple"][];
      };
      "304": never;
      "422": unknown;
    };
  };
  /**
   * Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
   *
   * You can create a new pull request.
   *
   * This endpoint triggers [notifications](https://help.github.com/articles/about-notifications/). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
   */
  "pulls/create": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The title of the new pull request.
         */
        title?: string;
        /**
         * The name of the branch where your changes are implemented. For cross-repository pull requests in the same network, namespace `head` with a user like this: `username:branch`.
         */
        head: string;
        /**
         * The name of the branch you want the changes pulled into. This should be an existing branch on the current repository. You cannot submit a pull request to one repository that requests a merge to a base of another repository.
         */
        base: string;
        /**
         * The contents of the pull request.
         */
        body?: string;
        /**
         * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
         */
        maintainer_can_modify?: boolean;
        /**
         * Indicates whether the pull request is a draft. See "[Draft Pull Requests](https://help.github.com/en/articles/about-pull-requests#draft-pull-requests)" in the GitHub Help documentation to learn more.
         */
        draft?: boolean;
        issue?: number;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["pull-request"];
      };
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * Lists review comments for all pull requests in a repository. By default, review comments are in ascending order by ID.
   */
  "pulls/list-review-comments-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        sort?: components["parameters"]["sort"];
        /**
         * Can be either `asc` or `desc`. Ignored without `sort` parameter.
         */
        direction?: "asc" | "desc";
        since?: components["parameters"]["since"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["pull-request-review-comment"][];
      };
    };
  };
  /**
   * Provides details for a review comment.
   */
  "pulls/get-review-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["pull-request-review-comment"];
      };
      "404": unknown;
    };
  };
  /**
   * Enables you to edit a review comment.
   */
  "pulls/update-review-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The text of the reply to the review comment.
         */
        body: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["pull-request-review-comment"];
      };
    };
  };
  /**
   * Deletes a review comment.
   */
  "pulls/delete-review-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
    };
  };
  /**
   * List the reactions to a [pull request review comment](https://docs.github.com/rest/reference/pulls#review-comments).
   */
  "reactions/list-for-pull-request-review-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
      };
      query: {
        /**
         * Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a pull request review comment.
         */
        content?:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["reaction"][];
      };
      "404": unknown;
      "415": unknown;
    };
  };
  /**
   * Create a reaction to a [pull request review comment](https://docs.github.com/rest/reference/pulls#comments). A response with a `Status: 200 OK` means that you already added the reaction type to this pull request review comment.
   */
  "reactions/create-for-pull-request-review-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the pull request review comment.
         */
        content:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
      };
    };
    responses: {
      /**
       * Reaction exists
       */
      "200": {
        "application/json": components["schemas"]["reaction"];
      };
      /**
       * Reaction created
       */
      "201": {
        "application/json": components["schemas"]["reaction"];
      };
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * **Note:** You can also specify a repository by `repository_id` using the route `DELETE /repositories/:repository_id/pulls/comments/:comment_id/reactions/:reaction_id.`
   *
   * Delete a reaction to a [pull request review comment](https://docs.github.com/rest/reference/pulls#review-comments).
   */
  "reactions/delete-for-pull-request-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        comment_id: components["parameters"]["comment_id"];
        reaction_id: components["parameters"]["reaction-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Lists details of a pull request by providing its number.
   *
   * When you get, [create](https://docs.github.com/rest/reference/pulls/#create-a-pull-request), or [edit](https://docs.github.com/rest/reference/pulls#update-a-pull-request) a pull request, GitHub creates a merge commit to test whether the pull request can be automatically merged into the base branch. This test commit is not added to the base branch or the head branch. You can review the status of the test commit using the `mergeable` key. For more information, see "[Checking mergeability of pull requests](https://docs.github.com/rest/guides/getting-started-with-the-git-database-api#checking-mergeability-of-pull-requests)".
   *
   * The value of the `mergeable` attribute can be `true`, `false`, or `null`. If the value is `null`, then GitHub has started a background job to compute the mergeability. After giving the job time to complete, resubmit the request. When the job finishes, you will see a non-`null` value for the `mergeable` attribute in the response. If `mergeable` is `true`, then `merge_commit_sha` will be the SHA of the _test_ merge commit.
   *
   * The value of the `merge_commit_sha` attribute changes depending on the state of the pull request. Before merging a pull request, the `merge_commit_sha` attribute holds the SHA of the _test_ merge commit. After merging a pull request, the `merge_commit_sha` attribute changes depending on how you merged the pull request:
   *
   * *   If merged as a [merge commit](https://help.github.com/articles/about-merge-methods-on-github/), `merge_commit_sha` represents the SHA of the merge commit.
   * *   If merged via a [squash](https://help.github.com/articles/about-merge-methods-on-github/#squashing-your-merge-commits), `merge_commit_sha` represents the SHA of the squashed commit on the base branch.
   * *   If [rebased](https://help.github.com/articles/about-merge-methods-on-github/#rebasing-and-merging-your-commits), `merge_commit_sha` represents the commit that the base branch was updated to.
   *
   * Pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
   */
  "pulls/get": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
      };
    };
    responses: {
      /**
       * Pass the appropriate [media type](https://docs.github.com/rest/overview/media-types/#commits-commit-comparison-and-pull-requests) to fetch diff and patch formats.
       */
      "200": {
        "application/json": components["schemas"]["pull-request"];
      };
      "304": never;
      "404": unknown;
      "500": unknown;
    };
  };
  /**
   * Draft pull requests are available in public repositories with GitHub Free and GitHub Free for organizations, GitHub Pro, and legacy per-repository billing plans, and in public and private repositories with GitHub Team and GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * To open or update a pull request in a public repository, you must have write access to the head or the source branch. For organization-owned repositories, you must be a member of the organization that owns the repository to open or update a pull request.
   */
  "pulls/update": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The title of the pull request.
         */
        title?: string;
        /**
         * The contents of the pull request.
         */
        body?: string;
        /**
         * State of this Pull Request. Either `open` or `closed`.
         */
        state?: "open" | "closed";
        /**
         * The name of the branch you want your changes pulled into. This should be an existing branch on the current repository. You cannot update the base branch on a pull request to point to another repository.
         */
        base?: string;
        /**
         * Indicates whether [maintainers can modify](https://help.github.com/articles/allowing-changes-to-a-pull-request-branch-created-from-a-fork/) the pull request.
         */
        maintainer_can_modify?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["pull-request"];
      };
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * Lists all review comments for a pull request. By default, review comments are in ascending order by ID.
   */
  "pulls/list-review-comments": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
      };
      query: {
        sort?: components["parameters"]["sort"];
        /**
         * Can be either `asc` or `desc`. Ignored without `sort` parameter.
         */
        direction?: "asc" | "desc";
        since?: components["parameters"]["since"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["pull-request-review-comment"][];
      };
    };
  };
  /**
   * Creates a review comment in the pull request diff. To add a regular comment to a pull request timeline, see "[Create an issue comment](https://docs.github.com/rest/reference/issues#create-an-issue-comment)." We recommend creating a review comment using `line`, `side`, and optionally `start_line` and `start_side` if your comment applies to more than one line in the pull request diff.
   *
   * You can still create a review comment using the `position` parameter. When you use `position`, the `line`, `side`, `start_line`, and `start_side` parameters are not required. For more information, see the [`comfort-fade` preview notice](https://docs.github.com/rest/reference/pulls#create-a-review-comment-for-a-pull-request-preview-notices).
   *
   * **Note:** The position value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
   *
   * This endpoint triggers [notifications](https://help.github.com/articles/about-notifications/). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
   */
  "pulls/create-review-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The text of the review comment.
         */
        body: string;
        /**
         * The SHA of the commit needing a comment. Not using the latest commit SHA may render your comment outdated if a subsequent commit modifies the line you specify as the `position`.
         */
        commit_id?: string;
        /**
         * The relative path to the file that necessitates a comment.
         */
        path: string;
        /**
         * **Required without `comfort-fade` preview**. The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note above.
         */
        position?: number;
        /**
         * **Required with `comfort-fade` preview**. In a split diff view, the side of the diff that the pull request's changes appear on. Can be `LEFT` or `RIGHT`. Use `LEFT` for deletions that appear in red. Use `RIGHT` for additions that appear in green or unchanged lines that appear in white and are shown for context. For a multi-line comment, side represents whether the last line of the comment range is a deletion or addition. For more information, see "[Diff view options](https://help.github.com/en/articles/about-comparing-branches-in-pull-requests#diff-view-options)" in the GitHub Help documentation.
         */
        side?: "LEFT" | "RIGHT";
        /**
         * **Required with `comfort-fade` preview**. The line of the blob in the pull request diff that the comment applies to. For a multi-line comment, the last line of the range that your comment applies to.
         */
        line?: number;
        /**
         * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_line` is the first line in the pull request diff that your multi-line comment applies to. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation.
         */
        start_line?: number;
        /**
         * **Required when using multi-line comments**. To create multi-line comments, you must use the `comfort-fade` preview header. The `start_side` is the starting side of the diff that the comment applies to. Can be `LEFT` or `RIGHT`. To learn more about multi-line comments, see "[Commenting on a pull request](https://help.github.com/en/articles/commenting-on-a-pull-request#adding-line-comments-to-a-pull-request)" in the GitHub Help documentation. See `side` in this table for additional context.
         */
        start_side?: "LEFT" | "RIGHT" | "side";
        in_reply_to?: number;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["pull-request-review-comment"];
      };
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * Creates a reply to a review comment for a pull request. For the `comment_id`, provide the ID of the review comment you are replying to. This must be the ID of a _top-level review comment_, not a reply to that comment. Replies to replies are not supported.
   *
   * This endpoint triggers [notifications](https://help.github.com/articles/about-notifications/). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
   */
  "pulls/create-reply-for-review-comment": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
        comment_id: components["parameters"]["comment_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The text of the review comment.
         */
        body: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["pull-request-review-comment"];
      };
      "404": unknown;
    };
  };
  /**
   * Lists a maximum of 250 commits for a pull request. To receive a complete commit list for pull requests with more than 250 commits, use the [List commits](https://docs.github.com/rest/reference/repos#list-commits) endpoint.
   */
  "pulls/list-commits": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["commit"][];
      };
    };
  };
  /**
   * **Note:** Responses include a maximum of 3000 files. The paginated response returns 30 files per page by default.
   */
  "pulls/list-files": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["diff-entry"][];
      };
      "422": unknown;
      "500": unknown;
    };
  };
  "pulls/check-if-merged": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
      };
    };
    responses: {
      /**
       * Response if pull request has been merged
       */
      "204": never;
      /**
       * Response if pull request has not been merged
       */
      "404": unknown;
    };
  };
  /**
   * This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-abuse-rate-limits)" for details.
   */
  "pulls/merge": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Title for the automatic commit message.
         */
        commit_title?: string;
        /**
         * Extra detail to append to automatic commit message.
         */
        commit_message?: string;
        /**
         * SHA that pull request head must match to allow merge.
         */
        sha?: string;
        /**
         * Merge method to use. Possible values are `merge`, `squash` or `rebase`. Default is `merge`.
         */
        merge_method?: "merge" | "squash" | "rebase";
      };
    };
    responses: {
      /**
       * Response if merge was successful
       */
      "200": {
        "application/json": components["schemas"]["pull-request-merge-result"];
      };
      "403": unknown;
      "404": unknown;
      /**
       * Response if merge cannot be performed
       */
      "405": {
        "application/json": { message?: string; documentation_url?: string };
      };
      /**
       * Response if sha was provided and pull request head did not match
       */
      "409": {
        "application/json": { message?: string; documentation_url?: string };
      };
      "422": unknown;
    };
  };
  "pulls/list-requested-reviewers": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["pull-request-review-request"];
      };
    };
  };
  /**
   * This endpoint triggers [notifications](https://docs.github.com/github/managing-subscriptions-and-notifications-on-github/about-notifications). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-abuse-rate-limits)" for details.
   */
  "pulls/request-reviewers": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * An array of user `login`s that will be requested.
         */
        reviewers?: string[];
        /**
         * An array of team `slug`s that will be requested.
         */
        team_reviewers?: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["pull-request-simple"];
      };
      "403": unknown;
      /**
       * Response if user is not a collaborator
       */
      "422": unknown;
    };
  };
  "pulls/remove-requested-reviewers": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * An array of user `login`s that will be removed.
         */
        reviewers?: string[];
        /**
         * An array of team `slug`s that will be removed.
         */
        team_reviewers?: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": unknown;
      "422": unknown;
    };
  };
  /**
   * The list of reviews returns in chronological order.
   */
  "pulls/list-reviews": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * The list of reviews returns in chronological order.
       */
      "200": {
        "application/json": components["schemas"]["pull-request-review"][];
      };
    };
  };
  /**
   * This endpoint triggers [notifications](https://help.github.com/articles/about-notifications/). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
   *
   * Pull request reviews created in the `PENDING` state do not include the `submitted_at` property in the response.
   *
   * **Note:** To comment on a specific line in a file, you need to first determine the _position_ of that line in the diff. The GitHub REST API v3 offers the `application/vnd.github.v3.diff` [media type](https://docs.github.com/rest/overview/media-types#commits-commit-comparison-and-pull-requests). To see a pull request diff, add this media type to the `Accept` header of a call to the [single pull request](https://docs.github.com/rest/reference/pulls#get-a-pull-request) endpoint.
   *
   * The `position` value equals the number of lines down from the first "@@" hunk header in the file you want to add a comment. The line just below the "@@" line is position 1, the next line is position 2, and so on. The position in the diff continues to increase through lines of whitespace and additional hunks until the beginning of a new file.
   */
  "pulls/create-review": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The SHA of the commit that needs a review. Not using the latest commit SHA may render your review comment outdated if a subsequent commit modifies the line you specify as the `position`. Defaults to the most recent commit in the pull request when you do not specify a value.
         */
        commit_id?: string;
        /**
         * **Required** when using `REQUEST_CHANGES` or `COMMENT` for the `event` parameter. The body text of the pull request review.
         */
        body?: string;
        /**
         * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. By leaving this blank, you set the review action state to `PENDING`, which means you will need to [submit the pull request review](https://docs.github.com/rest/reference/pulls#submit-a-review-for-a-pull-request) when you are ready.
         */
        event?: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
        /**
         * Use the following table to specify the location, destination, and contents of the draft review comment.
         */
        comments?: {
          /**
           * The relative path to the file that necessitates a review comment.
           */
          path: string;
          /**
           * The position in the diff where you want to add a review comment. Note this value is not the same as the line number in the file. For help finding the position value, read the note below.
           */
          position?: number;
          /**
           * Text of the review comment.
           */
          body: string;
          line?: number;
          side?: string;
          start_line?: number;
          start_side?: string;
        }[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["pull-request-review"];
      };
      "403": unknown;
      "422": unknown;
    };
  };
  "pulls/get-review": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
        review_id: components["parameters"]["review_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["pull-request-review"];
      };
      "404": unknown;
    };
  };
  /**
   * Update the review summary comment with new text.
   */
  "pulls/update-review": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
        review_id: components["parameters"]["review_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The body text of the pull request review.
         */
        body: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["pull-request-review"];
      };
      "422": unknown;
    };
  };
  "pulls/delete-pending-review": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
        review_id: components["parameters"]["review_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["pull-request-review"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * List comments for a specific pull request review.
   */
  "pulls/list-comments-for-review": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
        review_id: components["parameters"]["review_id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["review-comment"][];
      };
      "404": unknown;
    };
  };
  /**
   * **Note:** To dismiss a pull request review on a [protected branch](https://docs.github.com/rest/reference/repos#branches), you must be a repository administrator or be included in the list of people or teams who can dismiss pull request reviews.
   */
  "pulls/dismiss-review": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
        review_id: components["parameters"]["review_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The message for the pull request review dismissal
         */
        message: string;
        event?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["pull-request-review"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  "pulls/submit-review": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
        review_id: components["parameters"]["review_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The body text of the pull request review
         */
        body?: string;
        /**
         * The review action you want to perform. The review actions include: `APPROVE`, `REQUEST_CHANGES`, or `COMMENT`. When you leave this blank, the API returns _HTTP 422 (Unrecognizable entity)_ and sets the review action state to `PENDING`, which means you will need to re-submit the pull request review using a review action.
         */
        event: "APPROVE" | "REQUEST_CHANGES" | "COMMENT";
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["pull-request-review"];
      };
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Updates the pull request branch with the latest upstream changes by merging HEAD from the base branch into the pull request branch.
   */
  "pulls/update-branch": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        pull_number: components["parameters"]["pull-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The expected SHA of the pull request's HEAD ref. This is the most recent commit on the pull request's branch. If the expected SHA does not match the pull request's HEAD, you will receive a `422 Unprocessable Entity` status. You can use the "[List commits](https://docs.github.com/rest/reference/repos#list-commits)" endpoint to find the most recent commit SHA. Default: SHA of the pull request's current HEAD ref.
         */
        expected_head_sha?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "202": {
        "application/json": { message?: string; url?: string };
      };
      "403": unknown;
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * Gets the preferred README for a repository.
   *
   * READMEs support [custom media types](https://docs.github.com/rest/reference/repos#custom-media-types) for retrieving the raw content or rendered HTML.
   */
  "repos/get-readme": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        /**
         * The name of the commit/branch/tag. Default: the repository’s default branch (usually `master`)
         */
        ref?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["content-file"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * This returns a list of releases, which does not include regular Git tags that have not been associated with a release. To get a list of Git tags, use the [Repository Tags API](https://docs.github.com/rest/reference/repos#list-repository-tags).
   *
   * Information about published releases are available to everyone. Only users with push access will receive listings for draft releases.
   */
  "repos/list-releases": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["release"][];
      };
      "404": unknown;
    };
  };
  /**
   * Users with push access to the repository can create a release.
   *
   * This endpoint triggers [notifications](https://help.github.com/articles/about-notifications/). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
   */
  "repos/create-release": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The name of the tag.
         */
        tag_name: string;
        /**
         * Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch (usually `master`).
         */
        target_commitish?: string;
        /**
         * The name of the release.
         */
        name?: string;
        /**
         * Text describing the contents of the tag.
         */
        body?: string;
        /**
         * `true` to create a draft (unpublished) release, `false` to create a published one.
         */
        draft?: boolean;
        /**
         * `true` to identify the release as a prerelease. `false` to identify the release as a full release.
         */
        prerelease?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["release"];
      };
      "422": unknown;
    };
  };
  /**
   * To download the asset's binary content, set the `Accept` header of the request to [`application/octet-stream`](https://docs.github.com/rest/overview/media-types). The API will either redirect the client to the location, or stream it directly if possible. API clients should handle both a `200` or `302` response.
   */
  "repos/get-release-asset": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        asset_id: components["parameters"]["asset_id"];
      };
    };
    responses: {
      /**
       * To download the asset's binary content, set the `Accept` header of the request to [`application/octet-stream`](https://docs.github.com/rest/overview/media-types). The API will either redirect the client to the location, or stream it directly if possible. API clients should handle both a `200` or `302` response.
       */
      "200": {
        "application/json": components["schemas"]["release-asset"];
      };
      "302": never;
      "404": unknown;
      "415": unknown;
    };
  };
  /**
   * Users with push access to the repository can edit a release asset.
   */
  "repos/update-release-asset": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        asset_id: components["parameters"]["asset_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The file name of the asset.
         */
        name?: string;
        /**
         * An alternate short description of the asset. Used in place of the filename.
         */
        label?: string;
        state?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["release-asset"];
      };
    };
  };
  "repos/delete-release-asset": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        asset_id: components["parameters"]["asset_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * View the latest published full release for the repository.
   *
   * The latest release is the most recent non-prerelease, non-draft release, sorted by the `created_at` attribute. The `created_at` attribute is the date of the commit used for the release, and not the date when the release was drafted or published.
   */
  "repos/get-latest-release": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["release"];
      };
    };
  };
  /**
   * Get a published release with the specified tag.
   */
  "repos/get-release-by-tag": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        /**
         * tag+ parameter
         */
        tag: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["release"];
      };
      "404": unknown;
    };
  };
  /**
   * **Note:** This returns an `upload_url` key corresponding to the endpoint for uploading release assets. This key is a [hypermedia resource](https://docs.github.com/rest/overview/resources-in-the-rest-api#hypermedia).
   */
  "repos/get-release": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        release_id: components["parameters"]["release_id"];
      };
    };
    responses: {
      /**
       * **Note:** This returns an `upload_url` key corresponding to the endpoint for uploading release assets. This key is a [hypermedia resource](https://docs.github.com/rest/overview/resources-in-the-rest-api#hypermedia).
       */
      "200": {
        "application/json": components["schemas"]["release"];
      };
      "404": unknown;
    };
  };
  /**
   * Users with push access to the repository can edit a release.
   */
  "repos/update-release": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        release_id: components["parameters"]["release_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The name of the tag.
         */
        tag_name?: string;
        /**
         * Specifies the commitish value that determines where the Git tag is created from. Can be any branch or commit SHA. Unused if the Git tag already exists. Default: the repository's default branch (usually `master`).
         */
        target_commitish?: string;
        /**
         * The name of the release.
         */
        name?: string;
        /**
         * Text describing the contents of the tag.
         */
        body?: string;
        /**
         * `true` makes the release a draft, and `false` publishes the release.
         */
        draft?: boolean;
        /**
         * `true` to identify the release as a prerelease, `false` to identify the release as a full release.
         */
        prerelease?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["release"];
      };
    };
  };
  /**
   * Users with push access to the repository can delete a release.
   */
  "repos/delete-release": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        release_id: components["parameters"]["release_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  "repos/list-release-assets": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        release_id: components["parameters"]["release_id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["release-asset"][];
      };
    };
  };
  /**
   * This endpoint makes use of [a Hypermedia relation](https://docs.github.com/rest/overview/resources-in-the-rest-api#hypermedia) to determine which URL to access. The endpoint you call to upload release assets is specific to your release. Use the `upload_url` returned in
   * the response of the [Create a release endpoint](https://docs.github.com/rest/reference/repos#create-a-release) to upload a release asset.
   *
   * You need to use an HTTP client which supports [SNI](http://en.wikipedia.org/wiki/Server_Name_Indication) to make calls to this endpoint.
   *
   * Most libraries will set the required `Content-Length` header automatically. Use the required `Content-Type` header to provide the media type of the asset. For a list of media types, see [Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). For example:
   *
   * `application/zip`
   *
   * GitHub expects the asset data in its raw binary form, rather than JSON. You will send the raw binary content of the asset as the request body. Everything else about the endpoint is the same as the rest of the API. For example,
   * you'll still need to pass your authentication to be able to upload an asset.
   *
   * When an upstream failure occurs, you will receive a `502 Bad Gateway` status. This may leave an empty asset with a state of `starter`. It can be safely deleted.
   *
   * **Notes:**
   * *   GitHub renames asset filenames that have special characters, non-alphanumeric characters, and leading or trailing periods. The "[List assets for a release](https://docs.github.com/rest/reference/repos#list-assets-for-a-release)"
   * endpoint lists the renamed filenames. For more information and help, contact [GitHub Support](https://github.com/contact).
   * *   If you upload an asset with the same filename as another uploaded asset, you'll receive an error and must delete the old file before you can re-upload the new asset.
   */
  "repos/upload-release-asset": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        release_id: components["parameters"]["release_id"];
      };
      query: {
        name?: string;
        label?: string;
      };
    };
    requestBody: {
      "*/*": string;
    };
    responses: {
      /**
       * Response for successful upload
       */
      "201": {
        "application/json": components["schemas"]["release-asset"];
      };
    };
  };
  /**
   * Lists all secret scanning alerts for a private repository, from newest to oldest. To use this endpoint, you must be an administrator for the repository or organization, and you must use an access token with the `repo` scope or `security_events` scope.
   *
   * GitHub Apps must have the `secret_scanning_alerts` read permission to use this endpoint.
   */
  "secret-scanning/list-alerts-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        /**
         * Set to `open` or `resolved` to only list secret scanning alerts in a specific state.
         */
        state?: "open" | "resolved";
        page?: components["parameters"]["page"];
        per_page?: components["parameters"]["per_page"];
      };
    };
    responses: {
      /**
       * Response
       */
      "200": {
        "application/json": components["schemas"]["secret-scanning-alert"][];
      };
      /**
       * Repository is public or secret scanning is disabled for the repository
       */
      "404": unknown;
      "503": unknown;
    };
  };
  /**
   * Gets a single secret scanning alert detected in a private repository. To use this endpoint, you must be an administrator for the repository or organization, and you must use an access token with the `repo` scope or `security_events` scope.
   *
   * GitHub Apps must have the `secret_scanning_alerts` read permission to use this endpoint.
   */
  "secret-scanning/get-alert": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        alert_number: components["parameters"]["alert_number"];
      };
    };
    responses: {
      /**
       * Default response
       */
      "200": {
        "application/json": components["schemas"]["secret-scanning-alert"];
      };
      /**
       * Repository is public, or secret scanning is disabled for the repository, or the resource is not found
       */
      "404": unknown;
      "503": unknown;
    };
  };
  /**
   * Updates the status of a secret scanning alert in a private repository. To use this endpoint, you must be an administrator for the repository or organization, and you must use an access token with the `repo` scope or `security_events` scope.
   *
   * GitHub Apps must have the `secret_scanning_alerts` write permission to use this endpoint.
   */
  "secret-scanning/update-alert": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        alert_number: components["parameters"]["alert_number"];
      };
    };
    requestBody: {
      "application/json": {
        state: components["schemas"]["secret-scanning-alert-state"];
        resolution?: components["schemas"]["secret-scanning-alert-resolution"];
      };
    };
    responses: {
      /**
       * Default response
       */
      "200": {
        "application/json": components["schemas"]["secret-scanning-alert"];
      };
      /**
       * Repository is public, or secret scanning is disabled for the repository, or the resource is not found
       */
      "404": unknown;
      /**
       * State does not match the resolution
       */
      "422": unknown;
      "503": unknown;
    };
  };
  /**
   * Lists the people that have starred the repository.
   *
   * You can also find out _when_ stars were created by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
   */
  "activity/list-stargazers-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
        "application/vnd.github.v3.star+json": components["schemas"]["stargazer"][];
      };
      "422": unknown;
    };
  };
  /**
   * Returns a weekly aggregate of the number of additions and deletions pushed to a repository.
   */
  "repos/get-code-frequency-stats": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Returns a weekly aggregate of the number of additions and deletions pushed to a repository.
       */
      "200": {
        "application/json": components["schemas"]["code-frequency-stat"][];
      };
    };
  };
  /**
   * Returns the last year of commit activity grouped by week. The `days` array is a group of commits per day, starting on `Sunday`.
   */
  "repos/get-commit-activity-stats": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["commit-activity"][];
      };
    };
  };
  /**
   * Returns the `total` number of commits authored by the contributor. In addition, the response includes a Weekly Hash (`weeks` array) with the following information:
   *
   * *   `w` - Start of the week, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time).
   * *   `a` - Number of additions
   * *   `d` - Number of deletions
   * *   `c` - Number of commits
   */
  "repos/get-contributors-stats": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * *   `w` - Start of the week, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time).
       * *   `a` - Number of additions
       * *   `d` - Number of deletions
       * *   `c` - Number of commits
       */
      "200": {
        "application/json": components["schemas"]["contributor-activity"][];
      };
    };
  };
  /**
   * Returns the total commit counts for the `owner` and total commit counts in `all`. `all` is everyone combined, including the `owner` in the last 52 weeks. If you'd like to get the commit counts for non-owners, you can subtract `owner` from `all`.
   *
   * The array order is oldest week (index 0) to most recent week.
   */
  "repos/get-participation-stats": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * The array order is oldest week (index 0) to most recent week.
       */
      "200": {
        "application/json": components["schemas"]["participation-stats"];
      };
      "404": unknown;
    };
  };
  /**
   * Each array contains the day number, hour number, and number of commits:
   *
   * *   `0-6`: Sunday - Saturday
   * *   `0-23`: Hour of day
   * *   Number of commits
   *
   * For example, `[2, 14, 25]` indicates that there were 25 total commits, during the 2:00pm hour on Tuesdays. All times are based on the time zone of individual commits.
   */
  "repos/get-punch-card-stats": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * For example, `[2, 14, 25]` indicates that there were 25 total commits, during the 2:00pm hour on Tuesdays. All times are based on the time zone of individual commits.
       */
      "200": {
        "application/json": components["schemas"]["code-frequency-stat"][];
      };
    };
  };
  /**
   * Users with push access in a repository can create commit statuses for a given SHA.
   *
   * Note: there is a limit of 1000 statuses per `sha` and `context` within a repository. Attempts to create more than 1000 statuses will result in a validation error.
   */
  "repos/create-commit-status": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        sha: string;
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The state of the status. Can be one of `error`, `failure`, `pending`, or `success`.
         */
        state: "error" | "failure" | "pending" | "success";
        /**
         * The target URL to associate with this status. This URL will be linked from the GitHub UI to allow users to easily see the source of the status.
         * For example, if your continuous integration system is posting build status, you would want to provide the deep link for the build output for this specific SHA:
         * `http://ci.example.com/user/repo/build/sha`
         */
        target_url?: string;
        /**
         * A short description of the status.
         */
        description?: string;
        /**
         * A string label to differentiate this status from the status of other systems.
         */
        context?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["status"];
      };
    };
  };
  /**
   * Lists the people watching the specified repository.
   */
  "activity/list-watchers-for-repo": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
    };
  };
  "activity/get-repo-subscription": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Response if you subscribe to the repository
       */
      "200": {
        "application/json": components["schemas"]["repository-subscription"];
      };
      "403": unknown;
      /**
       * Response if you don't subscribe to the repository
       */
      "404": unknown;
    };
  };
  /**
   * If you would like to watch a repository, set `subscribed` to `true`. If you would like to ignore notifications made within a repository, set `ignored` to `true`. If you would like to stop watching a repository, [delete the repository's subscription](https://docs.github.com/rest/reference/activity#delete-a-repository-subscription) completely.
   */
  "activity/set-repo-subscription": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Determines if notifications should be received from this repository.
         */
        subscribed?: boolean;
        /**
         * Determines if all notifications should be blocked from this repository.
         */
        ignored?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["repository-subscription"];
      };
    };
  };
  /**
   * This endpoint should only be used to stop watching a repository. To control whether or not you wish to receive notifications from a repository, [set the repository's subscription manually](https://docs.github.com/rest/reference/activity#set-a-repository-subscription).
   */
  "activity/delete-repo-subscription": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  "repos/list-tags": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["tag"][];
      };
    };
  };
  /**
   * Gets a redirect URL to download a tar archive for a repository. If you omit `:ref`, the repository’s default branch (usually
   * `master`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
   * the `Location` header to make a second `GET` request.
   * **Note**: For private repositories, these links are temporary and expire after five minutes.
   */
  "repos/download-tarball-archive": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        ref: string;
      };
    };
    responses: {
      /**
       * response
       */
      "302": never;
    };
  };
  "repos/list-teams": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team"][];
      };
    };
  };
  "repos/get-all-topics": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["topic"];
      };
      "404": unknown;
      "415": unknown;
    };
  };
  "repos/replace-all-topics": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * An array of topics to add to the repository. Pass one or more topics to _replace_ the set of existing topics. Send an empty array (`[]`) to clear all topics from the repository. **Note:** Topic `names` cannot contain uppercase letters.
         */
        names: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["topic"];
      };
      "404": unknown;
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * Get the total number of clones and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.
   */
  "repos/get-clones": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per?: components["parameters"]["per"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["clone-traffic"];
      };
      "403": unknown;
    };
  };
  /**
   * Get the top 10 popular contents over the last 14 days.
   */
  "repos/get-top-paths": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["content-traffic"][];
      };
      "403": unknown;
    };
  };
  /**
   * Get the top 10 referrers over the last 14 days.
   */
  "repos/get-top-referrers": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["referrer-traffic"][];
      };
      "403": unknown;
    };
  };
  /**
   * Get the total number of views and breakdown per day or week for the last 14 days. Timestamps are aligned to UTC midnight of the beginning of the day or week. Week begins on Monday.
   */
  "repos/get-views": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
      query: {
        per?: components["parameters"]["per"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["view-traffic"];
      };
      "403": unknown;
    };
  };
  /**
   * A transfer request will need to be accepted by the new owner when transferring a personal repository to another user. The response will contain the original `owner`, and the transfer will continue asynchronously. For more details on the requirements to transfer personal and organization-owned repositories, see [about repository transfers](https://help.github.com/articles/about-repository-transfers/).
   */
  "repos/transfer": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * **Required:** The username or organization name the repository will be transferred to.
         */
        new_owner?: string;
        /**
         * ID of the team or teams to add to the repository. Teams can only be added to organization-owned repositories.
         */
        team_ids?: number[];
      };
    };
    responses: {
      /**
       * response
       */
      "202": {
        "application/json": components["schemas"]["repository"];
      };
    };
  };
  /**
   * Shows whether dependency alerts are enabled or disabled for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://help.github.com/en/articles/about-security-alerts-for-vulnerable-dependencies)".
   */
  "repos/check-vulnerability-alerts": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Response if repository is enabled with vulnerability alerts
       */
      "204": never;
      /**
       * Response if repository is not enabled with vulnerability alerts
       */
      "404": unknown;
    };
  };
  /**
   * Enables dependency alerts and the dependency graph for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://help.github.com/en/articles/about-security-alerts-for-vulnerable-dependencies)".
   */
  "repos/enable-vulnerability-alerts": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Disables dependency alerts and the dependency graph for a repository. The authenticated user must have admin access to the repository. For more information, see "[About security alerts for vulnerable dependencies](https://help.github.com/en/articles/about-security-alerts-for-vulnerable-dependencies)".
   */
  "repos/disable-vulnerability-alerts": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Gets a redirect URL to download a zip archive for a repository. If you omit `:ref`, the repository’s default branch (usually
   * `master`) will be used. Please make sure your HTTP framework is configured to follow redirects or you will need to use
   * the `Location` header to make a second `GET` request.
   * **Note**: For private repositories, these links are temporary and expire after five minutes.
   */
  "repos/download-zipball-archive": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
        ref: string;
      };
    };
    responses: {
      /**
       * response
       */
      "302": never;
    };
  };
  /**
   * Creates a new repository using a repository template. Use the `template_owner` and `template_repo` route parameters to specify the repository to use as the template. The authenticated user must own or be a member of an organization that owns the repository. To check if a repository is available to use as a template, get the repository's information using the [Get a repository](https://docs.github.com/rest/reference/repos#get-a-repository) endpoint and check that the `is_template` key is `true`.
   *
   * **OAuth scope requirements**
   *
   * When using [OAuth](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
   *
   * *   `public_repo` scope or `repo` scope to create a public repository
   * *   `repo` scope to create a private repository
   */
  "repos/create-using-template": {
    parameters: {
      path: {
        template_owner: string;
        template_repo: string;
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The organization or person who will own the new repository. To create a new repository in an organization, the authenticated user must be a member of the specified organization.
         */
        owner?: string;
        /**
         * The name of the new repository.
         */
        name: string;
        /**
         * A short description of the new repository.
         */
        description?: string;
        /**
         * Set to `true` to include the directory structure and files from all branches in the template repository, and not just the default branch. Default: `false`.
         */
        include_all_branches?: boolean;
        /**
         * Either `true` to create a new private repository or `false` to create a new public one.
         */
        private?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["repository"];
      };
    };
  };
  /**
   * Lists all public repositories in the order that they were created.
   *
   * Note: Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of repositories.
   */
  "repos/list-public": {
    parameters: {
      query: {
        since?: components["parameters"]["since-repo"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["minimal-repository"][];
      };
      "304": never;
      "422": unknown;
    };
  };
  /**
   * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
   */
  "enterprise-admin/list-provisioned-groups-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        startIndex?: components["parameters"]["start_index"];
        count?: components["parameters"]["count"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["scim-group-list-enterprise"];
      };
    };
  };
  /**
   * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
   *
   * Provision an enterprise group, and invite users to the group. This sends invitation emails to the email address of the invited users to join the GitHub organization that the SCIM group corresponds to.
   */
  "enterprise-admin/provision-and-invite-enterprise-group": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The SCIM schema URIs.
         */
        schemas: string[];
        /**
         * The name of the SCIM group. This must match the GitHub organization that the group maps to.
         */
        displayName: string;
        members?: {
          /**
           * The SCIM user ID for a user.
           */
          value: string;
        }[];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["scim-enterprise-group"];
      };
    };
  };
  /**
   * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
   */
  "enterprise-admin/get-provisioning-information-for-enterprise-group": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        scim_group_id: components["parameters"]["scim_group_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["scim-enterprise-group"];
      };
    };
  };
  /**
   * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
   *
   * Replaces an existing provisioned group’s information. You must provide all the information required for the group as if you were provisioning it for the first time. Any existing group information that you don't provide will be removed, including group membership. If you want to only update a specific attribute, use the [Update an attribute for a SCIM enterprise group](#update-an-attribute-for-a-scim-enterprise-group) endpoint instead.
   */
  "enterprise-admin/set-information-for-provisioned-enterprise-group": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        scim_group_id: components["parameters"]["scim_group_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The SCIM schema URIs.
         */
        schemas: string[];
        /**
         * The name of the SCIM group. This must match the GitHub organization that the group maps to.
         */
        displayName: string;
        members?: {
          /**
           * The SCIM user ID for a user.
           */
          value: string;
        }[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["scim-enterprise-group"];
      };
    };
  };
  /**
   * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
   *
   * Allows you to change a provisioned group’s individual attributes. To change a group’s values, you must provide a specific Operations JSON format that contains at least one of the add, remove, or replace operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).
   */
  "enterprise-admin/update-attribute-for-enterprise-group": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        scim_group_id: components["parameters"]["scim_group_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The SCIM schema URIs.
         */
        schemas: string[];
        /**
         * Array of [SCIM operations](https://tools.ietf.org/html/rfc7644#section-3.5.2).
         */
        Operations: { [key: string]: any }[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["scim-enterprise-group"];
      };
    };
  };
  /**
   * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
   */
  "enterprise-admin/delete-scim-group-from-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        scim_group_id: components["parameters"]["scim_group_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
   *
   * Retrieves a paginated list of all provisioned enterprise members, including pending invitations.
   *
   * When a user with a SAML-provisioned external identity leaves (or is removed from) an enterprise, the account's metadata is immediately removed. However, the returned list of user accounts might not always match the organization or enterprise member list you see on GitHub. This can happen in certain cases where an external identity associated with an organization will not match an organization member:
   *   - When a user with a SCIM-provisioned external identity is removed from an enterprise, the account's metadata is preserved to allow the user to re-join the organization in the future.
   *   - When inviting a user to join an organization, you can expect to see their external identity in the results before they accept the invitation, or if the invitation is cancelled (or never accepted).
   *   - When a user is invited over SCIM, an external identity is created that matches with the invitee's email address. However, this identity is only linked to a user account when the user accepts the invitation by going through SAML SSO.
   *
   * The returned list of external identities can include an entry for a `null` user. These are unlinked SAML identities that are created when a user goes through the following Single Sign-On (SSO) process but does not sign in to their GitHub account after completing SSO:
   *
   * 1. The user is granted access by the IdP and is not a member of the GitHub enterprise.
   *
   * 1. The user attempts to access the GitHub enterprise and initiates the SAML SSO process, and is not currently signed in to their GitHub account.
   *
   * 1. After successfully authenticating with the SAML SSO IdP, the `null` external identity entry is created and the user is prompted to sign in to their GitHub account:
   *    - If the user signs in, their GitHub account is linked to this entry.
   *    - If the user does not sign in (or does not create a new account when prompted), they are not added to the GitHub enterprise, and the external identity `null` entry remains in place.
   */
  "enterprise-admin/list-provisioned-identities-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
      query: {
        startIndex?: components["parameters"]["start_index"];
        count?: components["parameters"]["count"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["scim-user-list-enterprise"];
      };
    };
  };
  /**
   * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
   *
   * Provision enterprise membership for a user, and send organization invitation emails to the email address.
   *
   * You can optionally include the groups a user will be invited to join. If you do not provide a list of `groups`, the user is provisioned for the enterprise, but no organization invitation emails will be sent.
   */
  "enterprise-admin/provision-and-invite-enterprise-user": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The SCIM schema URIs.
         */
        schemas: string[];
        /**
         * The username for the user.
         */
        userName: string;
        name: {
          /**
           * The first name of the user.
           */
          givenName: string;
          /**
           * The last name of the user.
           */
          familyName: string;
        };
        /**
         * List of user emails.
         */
        emails: {
          /**
           * The email address.
           */
          value: string;
          /**
           * The type of email address.
           */
          type: string;
          /**
           * Whether this email address is the primary address.
           */
          primary: boolean;
        }[];
        /**
         * List of SCIM group IDs the user is a member of.
         */
        groups?: { value?: string }[];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["scim-enterprise-user"];
      };
    };
  };
  /**
   * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
   */
  "enterprise-admin/get-provisioning-information-for-enterprise-user": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        scim_user_id: components["parameters"]["scim_user_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["scim-enterprise-user"];
      };
    };
  };
  /**
   * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
   *
   * Replaces an existing provisioned user's information. You must provide all the information required for the user as if you were provisioning them for the first time. Any existing user information that you don't provide will be removed. If you want to only update a specific attribute, use the [Update an attribute for a SCIM user](#update-an-attribute-for-an-enterprise-scim-user) endpoint instead.
   *
   * You must at least provide the required values for the user: `userName`, `name`, and `emails`.
   *
   * **Warning:** Setting `active: false` removes the user from the enterprise, deletes the external identity, and deletes the associated `{scim_user_id}`.
   */
  "enterprise-admin/set-information-for-provisioned-enterprise-user": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        scim_user_id: components["parameters"]["scim_user_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The SCIM schema URIs.
         */
        schemas: string[];
        /**
         * The username for the user.
         */
        userName: string;
        name: {
          /**
           * The first name of the user.
           */
          givenName: string;
          /**
           * The last name of the user.
           */
          familyName: string;
        };
        /**
         * List of user emails.
         */
        emails: {
          /**
           * The email address.
           */
          value: string;
          /**
           * The type of email address.
           */
          type: string;
          /**
           * Whether this email address is the primary address.
           */
          primary: boolean;
        }[];
        /**
         * List of SCIM group IDs the user is a member of.
         */
        groups?: { value?: string }[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["scim-enterprise-user"];
      };
    };
  };
  /**
   * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
   *
   * Allows you to change a provisioned user's individual attributes. To change a user's values, you must provide a specific `Operations` JSON format that contains at least one of the `add`, `remove`, or `replace` operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).
   *
   * **Note:** Complicated SCIM `path` selectors that include filters are not supported. For example, a `path` selector defined as `"path": "emails[type eq \"work\"]"` will not work.
   *
   * **Warning:** If you set `active:false` using the `replace` operation (as shown in the JSON example below), it removes the user from the enterprise, deletes the external identity, and deletes the associated `:scim_user_id`.
   *
   * ```
   * {
   *   "Operations":[{
   *     "op":"replace",
   *     "value":{
   *       "active":false
   *     }
   *   }]
   * }
   * ```
   */
  "enterprise-admin/update-attribute-for-enterprise-user": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        scim_user_id: components["parameters"]["scim_user_id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The SCIM schema URIs.
         */
        schemas: string[];
        /**
         * Array of [SCIM operations](https://tools.ietf.org/html/rfc7644#section-3.5.2).
         */
        Operations: { [key: string]: any }[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["scim-enterprise-user"];
      };
    };
  };
  /**
   * **Note:** The SCIM API endpoints for enterprise accounts are currently in beta and are subject to change.
   */
  "enterprise-admin/delete-user-from-enterprise": {
    parameters: {
      path: {
        enterprise: components["parameters"]["enterprise"];
        scim_user_id: components["parameters"]["scim_user_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * Retrieves a paginated list of all provisioned organization members, including pending invitations. If you provide the `filter` parameter, the resources for all matching provisions members are returned.
   *
   * When a user with a SAML-provisioned external identity leaves (or is removed from) an organization, the account's metadata is immediately removed. However, the returned list of user accounts might not always match the organization or enterprise member list you see on GitHub. This can happen in certain cases where an external identity associated with an organization will not match an organization member:
   *   - When a user with a SCIM-provisioned external identity is removed from an organization, the account's metadata is preserved to allow the user to re-join the organization in the future.
   *   - When inviting a user to join an organization, you can expect to see their external identity in the results before they accept the invitation, or if the invitation is cancelled (or never accepted).
   *   - When a user is invited over SCIM, an external identity is created that matches with the invitee's email address. However, this identity is only linked to a user account when the user accepts the invitation by going through SAML SSO.
   *
   * The returned list of external identities can include an entry for a `null` user. These are unlinked SAML identities that are created when a user goes through the following Single Sign-On (SSO) process but does not sign in to their GitHub account after completing SSO:
   *
   * 1. The user is granted access by the IdP and is not a member of the GitHub organization.
   *
   * 1. The user attempts to access the GitHub organization and initiates the SAML SSO process, and is not currently signed in to their GitHub account.
   *
   * 1. After successfully authenticating with the SAML SSO IdP, the `null` external identity entry is created and the user is prompted to sign in to their GitHub account:
   *    - If the user signs in, their GitHub account is linked to this entry.
   *    - If the user does not sign in (or does not create a new account when prompted), they are not added to the GitHub organization, and the external identity `null` entry remains in place.
   */
  "scim/list-provisioned-identities": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
      query: {
        /**
         * Used for pagination: the index of the first result to return.
         */
        startIndex?: number;
        /**
         * Used for pagination: the number of results to return.
         */
        count?: number;
        /**
         * Filters results using the equals query parameter operator (`eq`). You can filter results that are equal to `id`, `userName`, `emails`, and `external_id`. For example, to search for an identity with the `userName` Octocat, you would use this query:
         *
         * `?filter=userName%20eq%20\"Octocat\"`.
         *
         * To filter results for for the identity with the email `octocat@github.com`, you would use this query:
         *
         * `?filter=emails%20eq%20\"octocat@github.com\"`.
         */
        filter?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/scim+json": components["schemas"]["scim-user-list"];
      };
      "304": never;
      "400": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Provision organization membership for a user, and send an activation email to the email address.
   */
  "scim/provision-and-invite-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * Configured by the admin. Could be an email, login, or username
         */
        userName: string;
        /**
         * The name of the user, suitable for display to end-users
         */
        displayName?: string;
        name: { givenName: string; familyName: string; formatted?: string };
        /**
         * user emails
         */
        emails: { value: string; primary?: boolean; type?: string }[];
        schemas?: string[];
        externalId?: string;
        groups?: string[];
        active?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/scim+json": components["schemas"]["scim-user"];
      };
      "304": never;
      "400": unknown;
      "403": unknown;
      "404": unknown;
      "409": unknown;
      "500": unknown;
    };
  };
  "scim/get-provisioning-information-for-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        scim_user_id: components["parameters"]["scim_user_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/scim+json": components["schemas"]["scim-user"];
      };
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Replaces an existing provisioned user's information. You must provide all the information required for the user as if you were provisioning them for the first time. Any existing user information that you don't provide will be removed. If you want to only update a specific attribute, use the [Update an attribute for a SCIM user](https://docs.github.com/rest/reference/scim#update-an-attribute-for-a-scim-user) endpoint instead.
   *
   * You must at least provide the required values for the user: `userName`, `name`, and `emails`.
   *
   * **Warning:** Setting `active: false` removes the user from the organization, deletes the external identity, and deletes the associated `{scim_user_id}`.
   */
  "scim/set-information-for-provisioned-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        scim_user_id: components["parameters"]["scim_user_id"];
      };
    };
    requestBody: {
      "application/json": {
        schemas?: string[];
        /**
         * The name of the user, suitable for display to end-users
         */
        displayName?: string;
        externalId?: string;
        groups?: string[];
        active?: boolean;
        /**
         * Configured by the admin. Could be an email, login, or username
         */
        userName: string;
        name: { givenName: string; familyName: string; formatted?: string };
        /**
         * user emails
         */
        emails: { type?: string; value: string; primary?: boolean }[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/scim+json": components["schemas"]["scim-user"];
      };
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Allows you to change a provisioned user's individual attributes. To change a user's values, you must provide a specific `Operations` JSON format that contains at least one of the `add`, `remove`, or `replace` operations. For examples and more information on the SCIM operations format, see the [SCIM specification](https://tools.ietf.org/html/rfc7644#section-3.5.2).
   *
   * **Note:** Complicated SCIM `path` selectors that include filters are not supported. For example, a `path` selector defined as `"path": "emails[type eq \"work\"]"` will not work.
   *
   * **Warning:** If you set `active:false` using the `replace` operation (as shown in the JSON example below), it removes the user from the organization, deletes the external identity, and deletes the associated `:scim_user_id`.
   *
   * ```
   * {
   *   "Operations":[{
   *     "op":"replace",
   *     "value":{
   *       "active":false
   *     }
   *   }]
   * }
   * ```
   */
  "scim/update-attribute-for-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        scim_user_id: components["parameters"]["scim_user_id"];
      };
    };
    requestBody: {
      "application/json": {
        schemas?: string[];
        /**
         * Set of operations to be performed
         */
        Operations: {
          op: "add" | "remove" | "replace";
          path?: string;
          value?:
            | {
                active?: boolean | null;
                userName?: string | null;
                externalId?: string | null;
                givenName?: string | null;
                familyName?: string | null;
              }
            | { value?: string; primary?: boolean }[]
            | string;
        }[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/scim+json": components["schemas"]["scim-user"];
      };
      "304": never;
      "400": unknown;
      "403": unknown;
      "404": unknown;
      /**
       * Too many requests
       */
      "429": {
        "application/json": components["schemas"]["basic-error"];
      };
    };
  };
  "scim/delete-user-from-org": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
        scim_user_id: components["parameters"]["scim_user_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Searches for query terms inside of a file. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
   *
   * When searching for code, you can get text match metadata for the file **content** and file **path** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
   *
   * For example, if you want to find the definition of the `addClass` function inside [jQuery](https://github.com/jquery/jquery) repository, your query would look something like this:
   *
   * `q=addClass+in:file+language:js+repo:jquery/jquery`
   *
   * This query searches for the keyword `addClass` within a file's contents. The query limits the search to files where the language is JavaScript in the `jquery/jquery` repository.
   *
   * #### Considerations for code search
   *
   * Due to the complexity of searching code, there are a few restrictions on how searches are performed:
   *
   * *   Only the _default branch_ is considered. In most cases, this will be the `master` branch.
   * *   Only files smaller than 384 KB are searchable.
   * *   You must always include at least one search term when searching source code. For example, searching for [`language:go`](https://github.com/search?utf8=%E2%9C%93&q=language%3Ago&type=Code) is not valid, while [`amazing
   * language:go`](https://github.com/search?utf8=%E2%9C%93&q=amazing+language%3Ago&type=Code) is.
   */
  "search/code": {
    parameters: {
      query: {
        /**
         * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query). See "[Searching code](https://help.github.com/articles/searching-code/)" for a detailed list of qualifiers.
         */
        q: string;
        /**
         * Sorts the results of your query. Can only be `indexed`, which indicates how recently a file has been indexed by the GitHub search infrastructure. Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
         */
        sort?: "indexed";
        order?: components["parameters"]["order"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          incomplete_results: boolean;
          items: components["schemas"]["code-search-result-item"][];
        };
      };
      "304": never;
      "403": unknown;
      "422": unknown;
      "503": unknown;
    };
  };
  /**
   * Find commits via various criteria on the default branch (usually `master`). This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
   *
   * When searching for commits, you can get text match metadata for the **message** field when you provide the `text-match` media type. For more details about how to receive highlighted search results, see [Text match
   * metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
   *
   * For example, if you want to find commits related to CSS in the [octocat/Spoon-Knife](https://github.com/octocat/Spoon-Knife) repository. Your query would look something like this:
   *
   * `q=repo:octocat/Spoon-Knife+css`
   */
  "search/commits": {
    parameters: {
      query: {
        /**
         * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query). See "[Searching commits](https://help.github.com/articles/searching-commits/)" for a detailed list of qualifiers.
         */
        q: string;
        /**
         * Sorts the results of your query by `author-date` or `committer-date`. Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
         */
        sort?: "author-date" | "committer-date";
        order?: components["parameters"]["order"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          incomplete_results: boolean;
          items: components["schemas"]["commit-search-result-item"][];
        };
      };
      "304": never;
      "415": unknown;
    };
  };
  /**
   * Find issues by state and keyword. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
   *
   * When searching for issues, you can get text match metadata for the issue **title**, issue **body**, and issue **comment body** fields when you pass the `text-match` media type. For more details about how to receive highlighted
   * search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
   *
   * For example, if you want to find the oldest unresolved Python bugs on Windows. Your query might look something like this.
   *
   * `q=windows+label:bug+language:python+state:open&sort=created&order=asc`
   *
   * This query searches for the keyword `windows`, within any open issue that is labeled as `bug`. The search runs across repositories whose primary language is Python. The results are sorted by creation date in ascending order, which means the oldest issues appear first in the search results.
   *
   * **Note:** For [user-to-server](https://docs.github.com/developers/apps/identifying-and-authorizing-users-for-github-apps#user-to-server-requests) GitHub App requests, you can't retrieve a combination of issues and pull requests in a single query. Requests that don't include the `is:issue` or `is:pull-request` qualifier will receive an HTTP `422 Unprocessable Entity` response. To get results for both issues and pull requests, you must send separate queries for issues and pull requests. For more information about the `is` qualifier, see "[Searching only issues or pull requests](https://docs.github.com/github/searching-for-information-on-github/searching-issues-and-pull-requests#search-only-issues-or-pull-requests)."
   */
  "search/issues-and-pull-requests": {
    parameters: {
      query: {
        /**
         * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query). See "[Searching issues and pull requests](https://help.github.com/articles/searching-issues-and-pull-requests/)" for a detailed list of qualifiers.
         */
        q: string;
        /**
         * Sorts the results of your query by the number of `comments`, `reactions`, `reactions-+1`, `reactions--1`, `reactions-smile`, `reactions-thinking_face`, `reactions-heart`, `reactions-tada`, or `interactions`. You can also sort results by how recently the items were `created` or `updated`, Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
         */
        sort?:
          | "comments"
          | "reactions"
          | "reactions-+1"
          | "reactions--1"
          | "reactions-smile"
          | "reactions-thinking_face"
          | "reactions-heart"
          | "reactions-tada"
          | "interactions"
          | "created"
          | "updated";
        order?: components["parameters"]["order"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          incomplete_results: boolean;
          items: components["schemas"]["issue-search-result-item"][];
        };
      };
      "304": never;
      "403": unknown;
      "422": unknown;
      "503": unknown;
    };
  };
  /**
   * Find labels in a repository with names or descriptions that match search keywords. Returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
   *
   * When searching for labels, you can get text match metadata for the label **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
   *
   * For example, if you want to find labels in the `linguist` repository that match `bug`, `defect`, or `enhancement`. Your query might look like this:
   *
   * `q=bug+defect+enhancement&repository_id=64778136`
   *
   * The labels that best match the query appear first in the search results.
   */
  "search/labels": {
    parameters: {
      query: {
        /**
         * The id of the repository.
         */
        repository_id: number;
        /**
         * The search keywords. This endpoint does not accept qualifiers in the query. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query).
         */
        q: string;
        /**
         * Sorts the results of your query by when the label was `created` or `updated`. Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
         */
        sort?: "created" | "updated";
        order?: components["parameters"]["order"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          incomplete_results: boolean;
          items: components["schemas"]["label-search-result-item"][];
        };
      };
      "304": never;
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Find repositories via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
   *
   * When searching for repositories, you can get text match metadata for the **name** and **description** fields when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
   *
   * For example, if you want to search for popular Tetris repositories written in assembly code, your query might look like this:
   *
   * `q=tetris+language:assembly&sort=stars&order=desc`
   *
   * This query searches for repositories with the word `tetris` in the name, the description, or the README. The results are limited to repositories where the primary language is assembly. The results are sorted by stars in descending order, so that the most popular repositories appear first in the search results.
   *
   * When you include the `mercy` preview header, you can also search for multiple topics by adding more `topic:` instances. For example, your query might look like this:
   *
   * `q=topic:ruby+topic:rails`
   */
  "search/repos": {
    parameters: {
      query: {
        /**
         * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query). See "[Searching for repositories](https://help.github.com/articles/searching-for-repositories/)" for a detailed list of qualifiers.
         */
        q: string;
        /**
         * Sorts the results of your query by number of `stars`, `forks`, or `help-wanted-issues` or how recently the items were `updated`. Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
         */
        sort?: "stars" | "forks" | "help-wanted-issues" | "updated";
        order?: components["parameters"]["order"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          incomplete_results: boolean;
          items: components["schemas"]["repo-search-result-item"][];
        };
      };
      "304": never;
      "422": unknown;
      "503": unknown;
    };
  };
  /**
   * Find topics via various criteria. Results are sorted by best match. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination). See "[Searching topics](https://help.github.com/articles/searching-topics/)" for a detailed list of qualifiers.
   *
   * When searching for topics, you can get text match metadata for the topic's **short\_description**, **description**, **name**, or **display\_name** field when you pass the `text-match` media type. For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
   *
   * For example, if you want to search for topics related to Ruby that are featured on https://github.com/topics. Your query might look like this:
   *
   * `q=ruby+is:featured`
   *
   * This query searches for topics with the keyword `ruby` and limits the results to find only topics that are featured. The topics that are the best match for the query appear first in the search results.
   */
  "search/topics": {
    parameters: {
      query: {
        /**
         * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query).
         */
        q: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          incomplete_results: boolean;
          items: components["schemas"]["topic-search-result-item"][];
        };
      };
      "304": never;
      "415": unknown;
    };
  };
  /**
   * Find users via various criteria. This method returns up to 100 results [per page](https://docs.github.com/rest/overview/resources-in-the-rest-api#pagination).
   *
   * When searching for users, you can get text match metadata for the issue **login**, **email**, and **name** fields when you pass the `text-match` media type. For more details about highlighting search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata). For more details about how to receive highlighted search results, see [Text match metadata](https://docs.github.com/rest/reference/search#text-match-metadata).
   *
   * For example, if you're looking for a list of popular users, you might try this query:
   *
   * `q=tom+repos:%3E42+followers:%3E1000`
   *
   * This query searches for users with the name `tom`. The results are restricted to users with more than 42 repositories and over 1,000 followers.
   */
  "search/users": {
    parameters: {
      query: {
        /**
         * The query contains one or more search keywords and qualifiers. Qualifiers allow you to limit your search to specific areas of GitHub. The REST API supports the same qualifiers as GitHub.com. To learn more about the format of the query, see [Constructing a search query](https://docs.github.com/rest/reference/search#constructing-a-search-query). See "[Searching users](https://help.github.com/articles/searching-users/)" for a detailed list of qualifiers.
         */
        q: string;
        /**
         * Sorts the results of your query by number of `followers` or `repositories`, or when the person `joined` GitHub. Default: [best match](https://docs.github.com/rest/reference/search#ranking-search-results)
         */
        sort?: "followers" | "repositories" | "joined";
        order?: components["parameters"]["order"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": {
          total_count: number;
          incomplete_results: boolean;
          items: components["schemas"]["user-search-result-item"][];
        };
      };
      "304": never;
      "422": unknown;
      "503": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the [Get a team by name](https://docs.github.com/rest/reference/teams#get-a-team-by-name) endpoint.
   */
  "teams/get-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-full"];
      };
      "404": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a team](https://docs.github.com/rest/reference/teams#update-a-team) endpoint.
   *
   * To edit a team, the authenticated user must either be an organization owner or a team maintainer.
   *
   * **Note:** With nested teams, the `privacy` for parent teams cannot be `secret`.
   */
  "teams/update-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The name of the team.
         */
        name: string;
        /**
         * The description of the team.
         */
        description?: string;
        /**
         * The level of privacy this team should have. Editing teams without specifying this parameter leaves `privacy` intact. The options are:
         * **For a non-nested team:**
         * \* `secret` - only visible to organization owners and members of this team.
         * \* `closed` - visible to all members of this organization.
         * **For a parent or child team:**
         * \* `closed` - visible to all members of this organization.
         */
        privacy?: "secret" | "closed";
        /**
         * **Deprecated**. The permission that new repositories will be added to the team with when none is specified. Can be one of:
         * \* `pull` - team members can pull, but not push to or administer newly-added repositories.
         * \* `push` - team members can pull and push, but not administer newly-added repositories.
         * \* `admin` - team members can pull, push and administer newly-added repositories.
         */
        permission?: "pull" | "push" | "admin";
        /**
         * The ID of a team to set as the parent team.
         */
        parent_team_id?: number | null;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["team-full"];
      };
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a team](https://docs.github.com/rest/reference/teams#delete-a-team) endpoint.
   *
   * To delete a team, the authenticated user must be an organization owner or team maintainer.
   *
   * If you are an organization owner, deleting a parent team will delete all of its child teams as well.
   */
  "teams/delete-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List discussions`](https://docs.github.com/rest/reference/teams#list-discussions) endpoint.
   *
   * List all discussions on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "teams/list-discussions-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
      };
      query: {
        direction?: components["parameters"]["direction"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-discussion"][];
      };
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create a discussion`](https://docs.github.com/rest/reference/teams#create-a-discussion) endpoint.
   *
   * Creates a new discussion post on a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * This endpoint triggers [notifications](https://help.github.com/articles/about-notifications/). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
   */
  "teams/create-discussion-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The discussion post's title.
         */
        title: string;
        /**
         * The discussion post's body text.
         */
        body: string;
        /**
         * Private posts are only visible to team members, organization owners, and team maintainers. Public posts are visible to all members of the organization. Set to `true` to create a private post.
         */
        private?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["team-discussion"];
      };
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion](https://docs.github.com/rest/reference/teams#get-a-discussion) endpoint.
   *
   * Get a specific discussion on a team's page. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "teams/get-discussion-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        discussion_number: components["parameters"]["discussion-number"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-discussion"];
      };
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion](https://docs.github.com/rest/reference/teams#update-a-discussion) endpoint.
   *
   * Edits the title and body text of a discussion post. Only the parameters you provide are updated. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "teams/update-discussion-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        discussion_number: components["parameters"]["discussion-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The discussion post's title.
         */
        title?: string;
        /**
         * The discussion post's body text.
         */
        body?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-discussion"];
      };
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Delete a discussion`](https://docs.github.com/rest/reference/teams#delete-a-discussion) endpoint.
   *
   * Delete a discussion from a team's page. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "teams/delete-discussion-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        discussion_number: components["parameters"]["discussion-number"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [List discussion comments](https://docs.github.com/rest/reference/teams#list-discussion-comments) endpoint.
   *
   * List all comments on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "teams/list-discussion-comments-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        discussion_number: components["parameters"]["discussion-number"];
      };
      query: {
        direction?: components["parameters"]["direction"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-discussion-comment"][];
      };
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Create a discussion comment](https://docs.github.com/rest/reference/teams#create-a-discussion-comment) endpoint.
   *
   * Creates a new comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   *
   * This endpoint triggers [notifications](https://help.github.com/articles/about-notifications/). Creating content too quickly using this endpoint may result in abuse rate limiting. See "[Abuse rate limits](https://docs.github.com/rest/overview/resources-in-the-rest-api#abuse-rate-limits)" and "[Dealing with abuse rate limits](https://docs.github.com/rest/guides/best-practices-for-integrators#dealing-with-rate-limits)" for details.
   */
  "teams/create-discussion-comment-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        discussion_number: components["parameters"]["discussion-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The discussion comment's body text.
         */
        body: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["team-discussion-comment"];
      };
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get a discussion comment](https://docs.github.com/rest/reference/teams#get-a-discussion-comment) endpoint.
   *
   * Get a specific comment on a team discussion. OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "teams/get-discussion-comment-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        discussion_number: components["parameters"]["discussion-number"];
        comment_number: components["parameters"]["comment-number"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-discussion-comment"];
      };
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Update a discussion comment](https://docs.github.com/rest/reference/teams#update-a-discussion-comment) endpoint.
   *
   * Edits the body text of a discussion comment. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "teams/update-discussion-comment-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        discussion_number: components["parameters"]["discussion-number"];
        comment_number: components["parameters"]["comment-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The discussion comment's body text.
         */
        body: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-discussion-comment"];
      };
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Delete a discussion comment](https://docs.github.com/rest/reference/teams#delete-a-discussion-comment) endpoint.
   *
   * Deletes a comment on a team discussion. OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "teams/delete-discussion-comment-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        discussion_number: components["parameters"]["discussion-number"];
        comment_number: components["parameters"]["comment-number"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion comment`](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-team-discussion-comment) endpoint.
   *
   * List the reactions to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "reactions/list-for-team-discussion-comment-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        discussion_number: components["parameters"]["discussion-number"];
        comment_number: components["parameters"]["comment-number"];
      };
      query: {
        /**
         * Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a team discussion comment.
         */
        content?:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["reaction"][];
      };
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Create reaction for a team discussion comment](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-team-discussion-comment)" endpoint.
   *
   * Create a reaction to a [team discussion comment](https://docs.github.com/rest/reference/teams#discussion-comments). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with a `Status: 200 OK` means that you already added the reaction type to this team discussion comment.
   */
  "reactions/create-for-team-discussion-comment-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        discussion_number: components["parameters"]["discussion-number"];
        comment_number: components["parameters"]["comment-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the team discussion comment.
         */
        content:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["reaction"];
      };
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List reactions for a team discussion`](https://docs.github.com/rest/reference/reactions#list-reactions-for-a-team-discussion) endpoint.
   *
   * List the reactions to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `read:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "reactions/list-for-team-discussion-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        discussion_number: components["parameters"]["discussion-number"];
      };
      query: {
        /**
         * Returns a single [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types). Omit this parameter to list all reactions to a team discussion.
         */
        content?:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["reaction"][];
      };
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create reaction for a team discussion`](https://docs.github.com/rest/reference/reactions#create-reaction-for-a-team-discussion) endpoint.
   *
   * Create a reaction to a [team discussion](https://docs.github.com/rest/reference/teams#discussions). OAuth access tokens require the `write:discussion` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/). A response with a `Status: 200 OK` means that you already added the reaction type to this team discussion.
   */
  "reactions/create-for-team-discussion-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        discussion_number: components["parameters"]["discussion-number"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The [reaction type](https://docs.github.com/rest/reference/reactions#reaction-types) to add to the team discussion.
         */
        content:
          | "+1"
          | "-1"
          | "laugh"
          | "confused"
          | "heart"
          | "hooray"
          | "rocket"
          | "eyes";
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["reaction"];
      };
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List pending team invitations`](https://docs.github.com/rest/reference/teams#list-pending-team-invitations) endpoint.
   *
   * The return hash contains a `role` field which refers to the Organization Invitation role and will be one of the following values: `direct_member`, `admin`, `billing_manager`, `hiring_manager`, or `reinstate`. If the invitee is not a GitHub member, the `login` field in the return hash will be `null`.
   */
  "teams/list-pending-invitations-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["organization-invitation"][];
      };
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team members`](https://docs.github.com/rest/reference/teams#list-team-members) endpoint.
   *
   * Team members will include the members of child teams.
   */
  "teams/list-members-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
      };
      query: {
        /**
         * Filters members returned by their role in the team. Can be one of:
         * \* `member` - normal members of the team.
         * \* `maintainer` - team maintainers.
         * \* `all` - all members of the team.
         */
        role?: "member" | "maintainer" | "all";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
      "404": unknown;
    };
  };
  /**
   * The "Get team member" endpoint (described below) is deprecated.
   *
   * We recommend using the [Get team membership for a user](https://docs.github.com/rest/reference/teams#get-team-membership-for-a-user) endpoint instead. It allows you to get both active and pending memberships.
   *
   * To list members in a team, the team must be visible to the authenticated user.
   */
  "teams/get-member-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Response if user is a member
       */
      "204": never;
      /**
       * Response if user is not a member
       */
      "404": unknown;
    };
  };
  /**
   * The "Add team member" endpoint (described below) is deprecated.
   *
   * We recommend using the [Add or update team membership for a user](https://docs.github.com/rest/reference/teams#add-or-update-team-membership-for-a-user) endpoint instead. It allows you to invite new organization members to your teams.
   *
   * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * To add someone to a team, the authenticated user must be an organization owner or a team maintainer in the team they're changing. The person being added to the team must be a member of the team's organization.
   *
   * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
   *
   * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
   */
  "teams/add-member-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "403": unknown;
      /**
       * Response if team synchronization is set up
       */
      "404": unknown;
      /**
       * response
       */
      "422": {
        "application/json": {
          message?: string;
          errors?: { code?: string; field?: string; resource?: string }[];
          documentation_url?: string;
        };
      };
    };
  };
  /**
   * The "Remove team member" endpoint (described below) is deprecated.
   *
   * We recommend using the [Remove team membership for a user](https://docs.github.com/rest/reference/teams#remove-team-membership-for-a-user) endpoint instead. It allows you to remove both active and pending memberships.
   *
   * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * To remove a team member, the authenticated user must have 'admin' permissions to the team or be an owner of the org that the team is associated with. Removing a team member does not delete the user, it just removes them from the team.
   *
   * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
   */
  "teams/remove-member-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      /**
       * Response if team synchronization is setup
       */
      "404": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Get team membership for a user](https://docs.github.com/rest/reference/teams#get-team-membership-for-a-user) endpoint.
   *
   * Team members will include the members of child teams.
   *
   * To get a user's membership with a team, the team must be visible to the authenticated user.
   *
   * **Note:** The `role` for organization owners returns as `maintainer`. For more information about `maintainer` roles, see [Create a team](https://docs.github.com/rest/reference/teams#create-a-team).
   */
  "teams/get-membership-for-user-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-membership"];
      };
      "404": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team membership for a user](https://docs.github.com/rest/reference/teams#add-or-update-team-membership-for-a-user) endpoint.
   *
   * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * If the user is already a member of the team's organization, this endpoint will add the user to the team. To add a membership between an organization member and a team, the authenticated user must be an organization owner or a team maintainer.
   *
   * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
   *
   * If the user is unaffiliated with the team's organization, this endpoint will send an invitation to the user via email. This newly-created membership will be in the "pending" state until the user accepts the invitation, at which point the membership will transition to the "active" state and the user will be added as a member of the team. To add a membership between an unaffiliated user and a team, the authenticated user must be an organization owner.
   *
   * If the user is already a member of the team, this endpoint will update the role of the team member's role. To update the membership of a team member, the authenticated user must be an organization owner or a team maintainer.
   */
  "teams/add-or-update-membership-for-user-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        username: components["parameters"]["username"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The role that this user should have in the team. Can be one of:
         * \* `member` - a normal member of the team.
         * \* `maintainer` - a team maintainer. Able to add/remove other team members, promote other team members to team maintainer, and edit the team's name and description.
         */
        role?: "member" | "maintainer";
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-membership"];
      };
      /**
       * Response if team synchronization is set up
       */
      "403": unknown;
      "404": unknown;
      /**
       * Response if you attempt to add an organization to a team
       */
      "422": {
        "application/json": {
          message?: string;
          errors?: { code?: string; field?: string; resource?: string }[];
          documentation_url?: string;
        };
      };
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove team membership for a user](https://docs.github.com/rest/reference/teams#remove-team-membership-for-a-user) endpoint.
   *
   * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * To remove a membership between a user and a team, the authenticated user must have 'admin' permissions to the team or be an owner of the organization that the team is associated with. Removing team membership does not delete the user, it just removes their membership from the team.
   *
   * **Note:** When you have team synchronization set up for a team with your organization's identity provider (IdP), you will see an error if you attempt to use the API for making changes to the team's membership. If you have access to manage group membership in your IdP, you can manage GitHub team membership through your identity provider, which automatically adds and removes team members in an organization. For more information, see "[Synchronizing teams between your identity provider and GitHub](https://help.github.com/articles/synchronizing-teams-between-your-identity-provider-and-github/)."
   */
  "teams/remove-membership-for-user-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      /**
       * Response if team synchronization is set up
       */
      "403": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List team projects`](https://docs.github.com/rest/reference/teams#list-team-projects) endpoint.
   *
   * Lists the organization projects for a team.
   */
  "teams/list-projects-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-project"][];
      };
      "404": unknown;
      "415": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a project](https://docs.github.com/rest/reference/teams#check-team-permissions-for-a-project) endpoint.
   *
   * Checks whether a team has `read`, `write`, or `admin` permissions for an organization project. The response includes projects inherited from a parent team.
   */
  "teams/check-permissions-for-project-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        project_id: components["parameters"]["project-id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-project"];
      };
      /**
       * Response if project is not managed by this team
       */
      "404": unknown;
      "415": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Add or update team project permissions](https://docs.github.com/rest/reference/teams#add-or-update-team-project-permissions) endpoint.
   *
   * Adds an organization project to a team. To add a project to a team or update the team's permission on a project, the authenticated user must have `admin` permissions for the project. The project and team must be part of the same organization.
   */
  "teams/add-or-update-project-permissions-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        project_id: components["parameters"]["project-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The permission to grant to the team for this project. Can be one of:
         * \* `read` - team members can read, but not write to or administer this project.
         * \* `write` - team members can read and write, but not administer this project.
         * \* `admin` - team members can read, write and administer this project.
         * Default: the team's `permission` attribute will be used to determine what permission to grant the team on this project. Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
         */
        permission?: "read" | "write" | "admin";
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      /**
       * Response if the project is not owned by the organization
       */
      "403": {
        "application/json": { message?: string; documentation_url?: string };
      };
      "404": unknown;
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a project from a team](https://docs.github.com/rest/reference/teams#remove-a-project-from-a-team) endpoint.
   *
   * Removes an organization project from a team. An organization owner or a team maintainer can remove any project from the team. To remove a project from a team as an organization member, the authenticated user must have `read` access to both the team and project, or `admin` access to the team or project. **Note:** This endpoint removes the project from the team, but does not delete it.
   */
  "teams/remove-project-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        project_id: components["parameters"]["project-id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "404": unknown;
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [List team repositories](https://docs.github.com/rest/reference/teams#list-team-repositories) endpoint.
   */
  "teams/list-repos-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["minimal-repository"][];
      };
      "404": unknown;
    };
  };
  /**
   * **Note**: Repositories inherited through a parent team will also be checked.
   *
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Check team permissions for a repository](https://docs.github.com/rest/reference/teams#check-team-permissions-for-a-repository) endpoint.
   *
   * You can also get information about the specified repository, including what permissions the team grants on it, by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
   */
  "teams/check-permissions-for-repo-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Alternative response with extra repository information
       */
      "200": {
        "application/vnd.github.v3.repository+json": components["schemas"]["team-repository"];
      };
      /**
       * Response if repository is managed by this team
       */
      "204": never;
      /**
       * Response if repository is not managed by this team
       */
      "404": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new "[Add or update team repository permissions](https://docs.github.com/rest/reference/teams#add-or-update-team-repository-permissions)" endpoint.
   *
   * To add a repository to a team or update the team's permission on a repository, the authenticated user must have admin access to the repository, and must be able to see the team. The repository must be owned by the organization, or a direct fork of a repository owned by the organization. You will get a `422 Unprocessable Entity` status if you attempt to add a repository to a team that is not owned by the organization.
   *
   * Note that, if you choose not to pass any parameters, you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
   */
  "teams/add-or-update-repo-permissions-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The permission to grant the team on this repository. Can be one of:
         * \* `pull` - team members can pull, but not push to or administer this repository.
         * \* `push` - team members can pull and push, but not administer this repository.
         * \* `admin` - team members can pull, push and administer this repository.
         *
         * If no permission is specified, the team's `permission` attribute will be used to determine what permission to grant the team on this repository.
         */
        permission?: "pull" | "push" | "admin";
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [Remove a repository from a team](https://docs.github.com/rest/reference/teams#remove-a-repository-from-a-team) endpoint.
   *
   * If the authenticated user is an organization owner or a team maintainer, they can remove any repositories from the team. To remove a repository from a team as an organization member, the authenticated user must have admin access to the repository and must be able to see the team. NOTE: This does not delete the repository, it just removes it from the team.
   */
  "teams/remove-repo-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List IdP groups for a team`](https://docs.github.com/rest/reference/teams#list-idp-groups-for-a-team) endpoint.
   *
   * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * List IdP groups connected to a team on GitHub.
   */
  "teams/list-idp-groups-for-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["group-mapping"];
      };
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`Create or update IdP group connections`](https://docs.github.com/rest/reference/teams#create-or-update-idp-group-connections) endpoint.
   *
   * Team synchronization is available for organizations using GitHub Enterprise Cloud. For more information, see [GitHub's products](https://help.github.com/github/getting-started-with-github/githubs-products) in the GitHub Help documentation.
   *
   * Creates, updates, or removes a connection between a team and an IdP group. When adding groups to a team, you must include all new and existing groups to avoid replacing existing groups with the new ones. Specifying an empty `groups` array will remove all connections for a team.
   */
  "teams/create-or-update-idp-group-connections-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The IdP groups you want to connect to a GitHub team. When updating, the new `groups` object will replace the original one. You must include any existing groups that you don't want to remove.
         */
        groups: {
          /**
           * ID of the IdP group.
           */
          group_id: string;
          /**
           * Name of the IdP group.
           */
          group_name: string;
          /**
           * Description of the IdP group.
           */
          group_description: string;
          id?: string;
          name?: string;
          description?: string;
        }[];
        synced_at?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["group-mapping"];
      };
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * **Deprecation Notice:** This endpoint route is deprecated and will be removed from the Teams API. We recommend migrating your existing code to use the new [`List child teams`](https://docs.github.com/rest/reference/teams#list-child-teams) endpoint.
   */
  "teams/list-child-legacy": {
    parameters: {
      path: {
        team_id: components["parameters"]["team-id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * Response if child teams exist
       */
      "200": {
        "application/json": components["schemas"]["team"][];
      };
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * If the authenticated user is authenticated through basic authentication or OAuth with the `user` scope, then the response lists public and private profile information.
   *
   * If the authenticated user is authenticated through OAuth without the `user` scope, then the response lists only public profile information.
   */
  "users/get-authenticated": {
    parameters: {};
    responses: {
      /**
       * response
       */
      "200": {
        "application/json":
          | components["schemas"]["private-user"]
          | components["schemas"]["public-user"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  /**
   * **Note:** If your email is set to private and you send an `email` parameter as part of this request to update your profile, your privacy settings are still enforced: the email address will not be displayed on your public profile or via the API.
   */
  "users/update-authenticated": {
    parameters: {};
    requestBody: {
      "application/json": {
        /**
         * The new name of the user.
         */
        name?: string;
        /**
         * The publicly visible email address of the user.
         */
        email?: string;
        /**
         * The new blog URL of the user.
         */
        blog?: string;
        /**
         * The new Twitter username of the user.
         */
        twitter_username?: string | null;
        /**
         * The new company of the user.
         */
        company?: string;
        /**
         * The new location of the user.
         */
        location?: string;
        /**
         * The new hiring availability of the user.
         */
        hireable?: boolean;
        /**
         * The new short biography of the user.
         */
        bio?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["private-user"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * List the users you've blocked on your personal account.
   */
  "users/list-blocked-by-authenticated": {
    parameters: {};
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "415": unknown;
    };
  };
  "users/check-blocked": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * If the user is blocked:
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      /**
       * If the user is not blocked:
       */
      "404": {
        "application/json": components["schemas"]["basic-error"];
      };
    };
  };
  "users/block": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  "users/unblock": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Sets the visibility for your primary email addresses.
   */
  "users/set-primary-email-visibility-for-authenticated": {
    parameters: {};
    requestBody: {
      "application/json": {
        /**
         * An email address associated with the GitHub user account to manage.
         */
        email: string;
        /**
         * Denotes whether an email is publically visible.
         */
        visibility: "public" | "private";
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["email"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Lists all of your email addresses, and specifies which one is visible to the public. This endpoint is accessible with the `user:email` scope.
   */
  "users/list-emails-for-authenticated": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["email"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * This endpoint is accessible with the `user` scope.
   */
  "users/add-email-for-authenticated": {
    parameters: {};
    requestBody: {
      "application/json":
        | {
            /**
             * Adds one or more email addresses to your GitHub account. Must contain at least one email address. **Note:** Alternatively, you can pass a single email address or an `array` of emails addresses directly, but we recommend that you pass an object using the `emails` key.
             */
            emails: string[];
          }
        | string[]
        | string;
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["email"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * This endpoint is accessible with the `user` scope.
   */
  "users/delete-email-for-authenticated": {
    parameters: {};
    requestBody: {
      "application/json":
        | {
            /**
             * Email addresses associated with the GitHub user account.
             */
            emails: string[];
          }
        | string[]
        | string;
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Lists the people following the authenticated user.
   */
  "users/list-followers-for-authenticated-user": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  /**
   * Lists the people who the authenticated user follows.
   */
  "users/list-followed-by-authenticated": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  "users/check-person-is-followed-by-authenticated": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Response if the person is followed by the authenticated user
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      /**
       * Response if the person is not followed by the authenticated user
       */
      "404": {
        "application/json": components["schemas"]["basic-error"];
      };
    };
  };
  /**
   * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
   *
   * Following a user requires the user to be logged in and authenticated with basic auth or OAuth with the `user:follow` scope.
   */
  "users/follow": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Unfollowing a user requires the user to be logged in and authenticated with basic auth or OAuth with the `user:follow` scope.
   */
  "users/unfollow": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Lists the current user's GPG keys. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "users/list-gpg-keys-for-authenticated": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["gpg-key"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Adds a GPG key to the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth, or OAuth with at least `write:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "users/create-gpg-key-for-authenticated": {
    parameters: {};
    requestBody: {
      "application/json": {
        /**
         * A GPG key in ASCII-armored format.
         */
        armored_public_key: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["gpg-key"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * View extended details for a single GPG key. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "users/get-gpg-key-for-authenticated": {
    parameters: {
      path: {
        gpg_key_id: components["parameters"]["gpg_key_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["gpg-key"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Removes a GPG key from the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `admin:gpg_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "users/delete-gpg-key-for-authenticated": {
    parameters: {
      path: {
        gpg_key_id: components["parameters"]["gpg_key_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Lists installations of your GitHub App that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
   *
   * You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.
   *
   * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
   *
   * You can find the permissions for the installation under the `permissions` key.
   */
  "apps/list-installations-for-authenticated-user": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * You can find the permissions for the installation under the `permissions` key.
       */
      "200": {
        "application/json": {
          total_count: number;
          installations: components["schemas"]["installation"][];
        };
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "415": unknown;
    };
  };
  /**
   * List repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access for an installation.
   *
   * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
   *
   * You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint.
   *
   * The access the user has to each repository is included in the hash under the `permissions` key.
   */
  "apps/list-installation-repos-for-authenticated-user": {
    parameters: {
      path: {
        installation_id: components["parameters"]["installation_id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * The access the user has to each repository is included in the hash under the `permissions` key.
       */
      "200": {
        "application/json": {
          total_count: number;
          repository_selection?: string;
          repositories: components["schemas"]["repository"][];
        };
      };
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Add a single repository to an installation. The authenticated user must have admin access to the repository.
   *
   * You must use a personal access token (which you can create via the [command line](https://docs.github.com/github/authenticating-to-github/creating-a-personal-access-token) or [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication)) to access this endpoint.
   */
  "apps/add-repo-to-installation": {
    parameters: {
      path: {
        installation_id: components["parameters"]["installation_id"];
        repository_id: components["parameters"]["repository_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Remove a single repository from an installation. The authenticated user must have admin access to the repository.
   *
   * You must use a personal access token (which you can create via the [command line](https://docs.github.com/github/authenticating-to-github/creating-a-personal-access-token) or [Basic Authentication](https://docs.github.com/rest/overview/other-authentication-methods#basic-authentication)) to access this endpoint.
   */
  "apps/remove-repo-from-installation": {
    parameters: {
      path: {
        installation_id: components["parameters"]["installation_id"];
        repository_id: components["parameters"]["repository_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Shows which type of GitHub user can interact with your public repositories and when the restriction expires. If there are no restrictions, you will see an empty response.
   */
  "interactions/get-restrictions-for-your-public-repos": {
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["interaction-limit-response"];
      };
    };
  };
  /**
   * Temporarily restricts which type of GitHub user can interact with your public repositories. Setting the interaction limit at the user level will overwrite any interaction limits that are set for individual repositories owned by the user.
   */
  "interactions/set-restrictions-for-your-public-repos": {
    requestBody: {
      "application/json": components["schemas"]["interaction-limit"];
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["interaction-limit-response"];
      };
      "422": unknown;
    };
  };
  /**
   * Removes any interaction restrictions from your public repositories.
   */
  "interactions/remove-restrictions-for-your-public-repos": {
    responses: {
      /**
       * Empty response
       */
      "204": never;
    };
  };
  /**
   * List issues across owned and member repositories assigned to the authenticated user.
   *
   * **Note**: GitHub's REST API v3 considers every pull request an issue, but not every issue is a pull request. For this
   * reason, "Issues" endpoints may return both issues and pull requests in the response. You can identify pull requests by
   * the `pull_request` key. Be aware that the `id` of a pull request returned from "Issues" endpoints will be an _issue id_. To find out the pull
   * request id, use the "[List pull requests](https://docs.github.com/rest/reference/pulls#list-pull-requests)" endpoint.
   */
  "issues/list-for-authenticated-user": {
    parameters: {
      query: {
        /**
         * Indicates which sorts of issues to return. Can be one of:
         * \* `assigned`: Issues assigned to you
         * \* `created`: Issues created by you
         * \* `mentioned`: Issues mentioning you
         * \* `subscribed`: Issues you're subscribed to updates for
         * \* `all`: All issues the authenticated user can see, regardless of participation or creation
         */
        filter?: "assigned" | "created" | "mentioned" | "subscribed" | "all";
        /**
         * Indicates the state of the issues to return. Can be either `open`, `closed`, or `all`.
         */
        state?: "open" | "closed" | "all";
        labels?: components["parameters"]["labels"];
        /**
         * What to sort results by. Can be either `created`, `updated`, `comments`.
         */
        sort?: "created" | "updated" | "comments";
        direction?: components["parameters"]["direction"];
        since?: components["parameters"]["since"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["issue"][];
      };
      "304": never;
      "404": unknown;
    };
  };
  /**
   * Lists the public SSH keys for the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "users/list-public-ssh-keys-for-authenticated": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["key"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Adds a public SSH key to the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth, or OAuth with at least `write:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "users/create-public-ssh-key-for-authenticated": {
    parameters: {};
    requestBody: {
      "application/json": {
        /**
         * A descriptive name for the new key.
         */
        title?: string;
        /**
         * The public SSH key to add to your GitHub account.
         */
        key: string;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["key"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * View extended details for a single public SSH key. Requires that you are authenticated via Basic Auth or via OAuth with at least `read:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "users/get-public-ssh-key-for-authenticated": {
    parameters: {
      path: {
        key_id: components["parameters"]["key_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["key"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Removes a public SSH key from the authenticated user's GitHub account. Requires that you are authenticated via Basic Auth or via OAuth with at least `admin:public_key` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/).
   */
  "users/delete-public-ssh-key-for-authenticated": {
    parameters: {
      path: {
        key_id: components["parameters"]["key_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Lists the active subscriptions for the authenticated user. You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint. . OAuth Apps must authenticate using an [OAuth token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/).
   */
  "apps/list-subscriptions-for-authenticated-user": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["user-marketplace-purchase"][];
      };
      "304": never;
      "401": unknown;
      "404": unknown;
    };
  };
  /**
   * Lists the active subscriptions for the authenticated user. You must use a [user-to-server OAuth access token](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/#identifying-users-on-your-site), created for a user who has authorized your GitHub App, to access this endpoint. . OAuth Apps must authenticate using an [OAuth token](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/).
   */
  "apps/list-subscriptions-for-authenticated-user-stubbed": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["user-marketplace-purchase"][];
      };
      "304": never;
      "401": unknown;
    };
  };
  "orgs/list-memberships-for-authenticated-user": {
    parameters: {
      query: {
        /**
         * Indicates the state of the memberships to return. Can be either `active` or `pending`. If not specified, the API returns both active and pending memberships.
         */
        state?: "active" | "pending";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["org-membership"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "422": unknown;
    };
  };
  "orgs/get-membership-for-authenticated-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["org-membership"];
      };
      "403": unknown;
      "404": unknown;
    };
  };
  "orgs/update-membership-for-authenticated-user": {
    parameters: {
      path: {
        org: components["parameters"]["org"];
      };
    };
    requestBody: {
      "application/json": {
        /**
         * The state that the membership should be in. Only `"active"` will be accepted.
         */
        state: "active";
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["org-membership"];
      };
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Lists all migrations a user has started.
   */
  "migrations/list-for-authenticated-user": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["migration"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  /**
   * Initiates the generation of a user migration archive.
   */
  "migrations/start-for-authenticated-user": {
    parameters: {};
    requestBody: {
      "application/json": {
        /**
         * Lock the repositories being migrated at the start of the migration
         */
        lock_repositories?: boolean;
        /**
         * Do not include attachments in the migration
         */
        exclude_attachments?: boolean;
        /**
         * Exclude attributes from the API response to improve performance
         */
        exclude?: "repositories"[];
        repositories: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["migration"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * Fetches a single user migration. The response includes the `state` of the migration, which can be one of the following values:
   *
   * *   `pending` - the migration hasn't started yet.
   * *   `exporting` - the migration is in progress.
   * *   `exported` - the migration finished successfully.
   * *   `failed` - the migration failed.
   *
   * Once the migration has been `exported` you can [download the migration archive](https://docs.github.com/rest/reference/migrations#download-a-user-migration-archive).
   */
  "migrations/get-status-for-authenticated-user": {
    parameters: {
      path: {
        migration_id: components["parameters"]["migration_id"];
      };
      query: {
        exclude?: string[];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["migration"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Fetches the URL to download the migration archive as a `tar.gz` file. Depending on the resources your repository uses, the migration archive can contain JSON files with data for these objects:
   *
   * *   attachments
   * *   bases
   * *   commit\_comments
   * *   issue\_comments
   * *   issue\_events
   * *   issues
   * *   milestones
   * *   organizations
   * *   projects
   * *   protected\_branches
   * *   pull\_request\_reviews
   * *   pull\_requests
   * *   releases
   * *   repositories
   * *   review\_comments
   * *   schema
   * *   users
   *
   * The archive will also contain an `attachments` directory that includes all attachment files uploaded to GitHub.com and a `repositories` directory that contains the repository's Git data.
   */
  "migrations/get-archive-for-authenticated-user": {
    parameters: {
      path: {
        migration_id: components["parameters"]["migration_id"];
      };
    };
    responses: {
      /**
       * response
       */
      "302": never;
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  /**
   * Deletes a previous migration archive. Downloadable migration archives are automatically deleted after seven days. Migration metadata, which is returned in the [List user migrations](https://docs.github.com/rest/reference/migrations#list-user-migrations) and [Get a user migration status](https://docs.github.com/rest/reference/migrations#get-a-user-migration-status) endpoints, will continue to be available even after an archive is deleted.
   */
  "migrations/delete-archive-for-authenticated-user": {
    parameters: {
      path: {
        migration_id: components["parameters"]["migration_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Unlocks a repository. You can lock repositories when you [start a user migration](https://docs.github.com/rest/reference/migrations#start-a-user-migration). Once the migration is complete you can unlock each repository to begin using it again or [delete the repository](https://docs.github.com/rest/reference/repos#delete-a-repository) if you no longer need the source data. Returns a status of `404 Not Found` if the repository is not locked.
   */
  "migrations/unlock-repo-for-authenticated-user": {
    parameters: {
      path: {
        migration_id: components["parameters"]["migration_id"];
        repo_name: components["parameters"]["repo_name"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Lists all the repositories for this user migration.
   */
  "migrations/list-repos-for-user": {
    parameters: {
      path: {
        migration_id: components["parameters"]["migration_id"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["minimal-repository"][];
      };
      "404": unknown;
    };
  };
  /**
   * List organizations for the authenticated user.
   *
   * **OAuth scope requirements**
   *
   * This only lists organizations that your authorization allows you to operate on in some way (e.g., you can list teams with `read:org` scope, you can publicize your organization membership with `user` scope, etc.). Therefore, this API requires at least `user` or `read:org` scope. OAuth requests with insufficient scope receive a `403 Forbidden` response.
   */
  "orgs/list-for-authenticated-user": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["organization-simple"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  "projects/create-for-authenticated-user": {
    parameters: {};
    requestBody: {
      "application/json": {
        /**
         * Name of the project
         */
        name: string;
        /**
         * Body of the project
         */
        body?: string | null;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["project"];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * Lists your publicly visible email address, which you can set with the [Set primary email visibility for the authenticated user](https://docs.github.com/rest/reference/users#set-primary-email-visibility-for-the-authenticated-user) endpoint. This endpoint is accessible with the `user:email` scope.
   */
  "users/list-public-emails-for-authenticated": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["email"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Lists repositories that the authenticated user has explicit permission (`:read`, `:write`, or `:admin`) to access.
   *
   * The authenticated user has explicit permission to access repositories they own, repositories where they are a collaborator, and repositories that they can access through an organization membership.
   */
  "repos/list-for-authenticated-user": {
    parameters: {
      query: {
        /**
         * Can be one of `all`, `public`, or `private`.
         */
        visibility?: "all" | "public" | "private";
        /**
         * Comma-separated list of values. Can include:
         * \* `owner`: Repositories that are owned by the authenticated user.
         * \* `collaborator`: Repositories that the user has been added to as a collaborator.
         * \* `organization_member`: Repositories that the user has access to through being a member of an organization. This includes every repository on every team that the user is on.
         */
        affiliation?: string;
        /**
         * Can be one of `all`, `owner`, `public`, `private`, `member`. Default: `all`
         *
         * Will cause a `422` error if used in the same request as **visibility** or **affiliation**. Will cause a `422` error if used in the same request as **visibility** or **affiliation**.
         */
        type?: "all" | "owner" | "public" | "private" | "member";
        /**
         * Can be one of `created`, `updated`, `pushed`, `full_name`.
         */
        sort?: "created" | "updated" | "pushed" | "full_name";
        /**
         * Can be one of `asc` or `desc`. Default: `asc` when using `full_name`, otherwise `desc`
         */
        direction?: "asc" | "desc";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
        since?: components["parameters"]["since"];
        before?: components["parameters"]["before"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["repository"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "422": unknown;
    };
  };
  /**
   * Creates a new repository for the authenticated user.
   *
   * **OAuth scope requirements**
   *
   * When using [OAuth](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/), authorizations must include:
   *
   * *   `public_repo` scope or `repo` scope to create a public repository
   * *   `repo` scope to create a private repository
   */
  "repos/create-for-authenticated-user": {
    parameters: {};
    requestBody: {
      "application/json": {
        /**
         * The name of the repository.
         */
        name: string;
        /**
         * A short description of the repository.
         */
        description?: string;
        /**
         * A URL with more information about the repository.
         */
        homepage?: string;
        /**
         * Whether the repository is private or public.
         */
        private?: boolean;
        /**
         * Whether issues are enabled.
         */
        has_issues?: boolean;
        /**
         * Whether projects are enabled.
         */
        has_projects?: boolean;
        /**
         * Whether the wiki is enabled.
         */
        has_wiki?: boolean;
        /**
         * The id of the team that will be granted access to this repository. This is only valid when creating a repository in an organization.
         */
        team_id?: number;
        /**
         * Whether the repository is initialized with a minimal README.
         */
        auto_init?: boolean;
        /**
         * The desired language or platform to apply to the .gitignore.
         */
        gitignore_template?: string;
        /**
         * The license keyword of the open source license for this repository.
         */
        license_template?: string;
        /**
         * Whether to allow squash merges for pull requests.
         */
        allow_squash_merge?: boolean;
        /**
         * Whether to allow merge commits for pull requests.
         */
        allow_merge_commit?: boolean;
        /**
         * Whether to allow rebase merges for pull requests.
         */
        allow_rebase_merge?: boolean;
        /**
         * Whether to delete head branches when pull requests are merged
         */
        delete_branch_on_merge?: boolean;
        /**
         * Whether downloads are enabled.
         */
        has_downloads?: boolean;
        /**
         * Whether this repository acts as a template that can be used to generate new repositories.
         */
        is_template?: boolean;
      };
    };
    responses: {
      /**
       * response
       */
      "201": {
        "application/json": components["schemas"]["repository"];
      };
      "304": never;
      "400": unknown;
      "401": unknown;
      "403": unknown;
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * When authenticating as a user, this endpoint will list all currently open repository invitations for that user.
   */
  "repos/list-invitations-for-authenticated-user": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["repository-invitation"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  "repos/accept-invitation": {
    parameters: {
      path: {
        invitation_id: components["parameters"]["invitation_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "403": unknown;
      "404": unknown;
      "409": unknown;
    };
  };
  "repos/decline-invitation": {
    parameters: {
      path: {
        invitation_id: components["parameters"]["invitation_id"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "403": unknown;
      "404": unknown;
      "409": unknown;
    };
  };
  /**
   * Lists repositories the authenticated user has starred.
   *
   * You can also find out _when_ stars were created by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
   */
  "activity/list-repos-starred-by-authenticated-user": {
    parameters: {
      query: {
        sort?: components["parameters"]["sort"];
        direction?: components["parameters"]["direction"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["repository"][];
        "application/vnd.github.v3.star+json": components["schemas"]["starred-repository"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  "activity/check-repo-is-starred-by-authenticated-user": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Response if this repository is starred by you
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      /**
       * Response if this repository is not starred by you
       */
      "404": {
        "application/json": components["schemas"]["basic-error"];
      };
    };
  };
  /**
   * Note that you'll need to set `Content-Length` to zero when calling out to this endpoint. For more information, see "[HTTP verbs](https://docs.github.com/rest/overview/resources-in-the-rest-api#http-verbs)."
   */
  "activity/star-repo-for-authenticated-user": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  "activity/unstar-repo-for-authenticated-user": {
    parameters: {
      path: {
        owner: components["parameters"]["owner"];
        repo: components["parameters"]["repo"];
      };
    };
    responses: {
      /**
       * Empty response
       */
      "204": never;
      "304": never;
      "401": unknown;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Lists repositories the authenticated user is watching.
   */
  "activity/list-watched-repos-for-authenticated-user": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["minimal-repository"][];
      };
      "304": never;
      "401": unknown;
      "403": unknown;
    };
  };
  /**
   * List all of the teams across all of the organizations to which the authenticated user belongs. This method requires `user`, `repo`, or `read:org` [scope](https://docs.github.com/apps/building-oauth-apps/understanding-scopes-for-oauth-apps/) when authenticating via [OAuth](https://docs.github.com/apps/building-oauth-apps/).
   */
  "teams/list-for-authenticated-user": {
    parameters: {
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["team-full"][];
      };
      "304": never;
      "403": unknown;
      "404": unknown;
    };
  };
  /**
   * Lists all users, in the order that they signed up on GitHub. This list includes personal user accounts and organization accounts.
   *
   * Note: Pagination is powered exclusively by the `since` parameter. Use the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header) to get the URL for the next page of users.
   */
  "users/list": {
    parameters: {
      query: {
        since?: components["parameters"]["since-user"];
        per_page?: components["parameters"]["per_page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
      "304": never;
    };
  };
  /**
   * Provides publicly available information about someone with a GitHub account.
   *
   * GitHub Apps with the `Plan` user permission can use this endpoint to retrieve information about a user's GitHub plan. The GitHub App must be authenticated as a user. See "[Identifying and authorizing users for GitHub Apps](https://docs.github.com/apps/building-github-apps/identifying-and-authorizing-users-for-github-apps/)" for details about authentication. For an example response, see 'Response with GitHub plan information' below"
   *
   * The `email` key in the following response is the publicly visible email address from your GitHub [profile page](https://github.com/settings/profile). When setting up your profile, you can select a primary email address to be “public” which provides an email entry for this endpoint. If you do not set a public email address for `email`, then it will have a value of `null`. You only see publicly visible email addresses when authenticated with GitHub. For more information, see [Authentication](https://docs.github.com/rest/overview/resources-in-the-rest-api#authentication).
   *
   * The Emails API enables you to list all of your email addresses, and toggle a primary email to be visible publicly. For more information, see "[Emails API](https://docs.github.com/rest/reference/users#emails)".
   */
  "users/get-by-username": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json":
          | components["schemas"]["private-user"]
          | components["schemas"]["public-user"];
      };
      "404": unknown;
    };
  };
  /**
   * If you are authenticated as the given user, you will see your private events. Otherwise, you'll only see public events.
   */
  "activity/list-events-for-authenticated-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["event"][];
      };
    };
  };
  /**
   * This is the user's organization dashboard. You must be authenticated as the user to view this.
   */
  "activity/list-org-events-for-authenticated-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
        org: components["parameters"]["org"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["event"][];
      };
    };
  };
  "activity/list-public-events-for-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["event"][];
      };
    };
  };
  /**
   * Lists the people following the specified user.
   */
  "users/list-followers-for-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
    };
  };
  /**
   * Lists the people who the specified user follows.
   */
  "users/list-following-for-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["simple-user"][];
      };
    };
  };
  "users/check-following-for-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
        target_user: string;
      };
    };
    responses: {
      /**
       * Response if the user follows the target user
       */
      "204": never;
      /**
       * Response if the user does not follow the target user
       */
      "404": unknown;
    };
  };
  /**
   * Lists public gists for the specified user:
   */
  "gists/list-for-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
      query: {
        since?: components["parameters"]["since"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["base-gist"][];
      };
      "422": unknown;
    };
  };
  /**
   * Lists the GPG keys for a user. This information is accessible by anyone.
   */
  "users/list-gpg-keys-for-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["gpg-key"][];
      };
    };
  };
  /**
   * Provides hovercard information when authenticated through basic auth or OAuth with the `repo` scope. You can find out more about someone in relation to their pull requests, issues, repositories, and organizations.
   *
   * The `subject_type` and `subject_id` parameters provide context for the person's hovercard, which returns more information than without the parameters. For example, if you wanted to find out more about `octocat` who owns the `Spoon-Knife` repository via cURL, it would look like this:
   *
   * ```shell
   *  curl -u username:token
   *   https://api.github.com/users/octocat/hovercard?subject_type=repository&subject_id=1300192
   * ```
   */
  "users/get-context-for-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
      query: {
        /**
         * Identifies which additional information you'd like to receive about the person's hovercard. Can be `organization`, `repository`, `issue`, `pull_request`. **Required** when using `subject_id`.
         */
        subject_type?: "organization" | "repository" | "issue" | "pull_request";
        /**
         * Uses the ID for the `subject_type` you specified. **Required** when using `subject_type`.
         */
        subject_id?: string;
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["hovercard"];
      };
      "404": unknown;
      "422": unknown;
    };
  };
  /**
   * Enables an authenticated GitHub App to find the user’s installation information.
   *
   * You must use a [JWT](https://docs.github.com/apps/building-github-apps/authenticating-with-github-apps/#authenticating-as-a-github-app) to access this endpoint.
   */
  "apps/get-user-installation": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["installation"];
      };
    };
  };
  /**
   * Lists the _verified_ public SSH keys for a user. This is accessible by anyone.
   */
  "users/list-public-keys-for-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["key-simple"][];
      };
    };
  };
  /**
   * List [public organization memberships](https://help.github.com/articles/publicizing-or-concealing-organization-membership) for the specified user.
   *
   * This method only lists _public_ memberships, regardless of authentication. If you need to fetch all of the organization memberships (public and private) for the authenticated user, use the [List organizations for the authenticated user](https://docs.github.com/rest/reference/orgs#list-organizations-for-the-authenticated-user) API instead.
   */
  "orgs/list-for-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["organization-simple"][];
      };
    };
  };
  "projects/list-for-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
      query: {
        /**
         * Indicates the state of the projects to return. Can be either `open`, `closed`, or `all`.
         */
        state?: "open" | "closed" | "all";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["project"][];
      };
      "415": unknown;
      "422": unknown;
    };
  };
  /**
   * These are events that you've received by watching repos and following users. If you are authenticated as the given user, you will see private events. Otherwise, you'll only see public events.
   */
  "activity/list-received-events-for-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["event"][];
      };
    };
  };
  "activity/list-received-public-events-for-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["event"][];
      };
    };
  };
  /**
   * Lists public repositories for the specified user.
   */
  "repos/list-for-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
      query: {
        /**
         * Can be one of `all`, `owner`, `member`.
         */
        type?: "all" | "owner" | "member";
        /**
         * Can be one of `created`, `updated`, `pushed`, `full_name`.
         */
        sort?: "created" | "updated" | "pushed" | "full_name";
        /**
         * Can be one of `asc` or `desc`. Default: `asc` when using `full_name`, otherwise `desc`
         */
        direction?: "asc" | "desc";
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["minimal-repository"][];
      };
    };
  };
  /**
   * Gets the summary of the free and paid GitHub Actions minutes used.
   *
   * Paid minutes only apply to workflows in private repositories that use GitHub-hosted runners. Minutes used is listed for each GitHub-hosted runner operating system. Any job re-runs are also included in the usage. The usage does not include the multiplier for macOS and Windows runners and is not rounded up to the nearest whole minute. For more information, see "[Managing billing for GitHub Actions](https://help.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-actions)".
   *
   * Access tokens must have the `user` scope.
   */
  "billing/get-github-actions-billing-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["actions-billing-usage"];
      };
    };
  };
  /**
   * Gets the free and paid storage used for GitHub Packages in gigabytes.
   *
   * Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://help.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
   *
   * Access tokens must have the `user` scope.
   */
  "billing/get-github-packages-billing-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["packages-billing-usage"];
      };
    };
  };
  /**
   * Gets the estimated paid and estimated total storage used for GitHub Actions and Github Packages.
   *
   * Paid minutes only apply to packages stored for private repositories. For more information, see "[Managing billing for GitHub Packages](https://help.github.com/github/setting-up-and-managing-billing-and-payments-on-github/managing-billing-for-github-packages)."
   *
   * Access tokens must have the `user` scope.
   */
  "billing/get-shared-storage-billing-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["combined-billing-usage"];
      };
    };
  };
  /**
   * Lists repositories a user has starred.
   *
   * You can also find out _when_ stars were created by passing the following custom [media type](https://docs.github.com/rest/overview/media-types/) via the `Accept` header:
   */
  "activity/list-repos-starred-by-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
      query: {
        sort?: components["parameters"]["sort"];
        direction?: components["parameters"]["direction"];
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["repository"][];
        "application/vnd.github.v3.star+json": components["schemas"]["starred-repository"][];
      };
    };
  };
  /**
   * Lists repositories a user is watching.
   */
  "activity/list-repos-watched-by-user": {
    parameters: {
      path: {
        username: components["parameters"]["username"];
      };
      query: {
        per_page?: components["parameters"]["per_page"];
        page?: components["parameters"]["page"];
      };
    };
    responses: {
      /**
       * response
       */
      "200": {
        "application/json": components["schemas"]["minimal-repository"][];
      };
    };
  };
  /**
   * Get a random sentence from the Zen of GitHub
   */
  "meta/get-zen": {
    responses: {
      /**
       * response
       */
      "200": {
        "text/plain": string;
      };
    };
  };
}

export interface components {
  parameters: {
    /**
     * Results per page (max 100)
     */
    per_page: number;
    /**
     * Page number of the results to fetch.
     */
    page: number;
    /**
     * Only show notifications updated after the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    since: string;
    /**
     * installation_id parameter
     */
    installation_id: number;
    /**
     * grant_id parameter
     */
    grant_id: number;
    /**
     * The client ID of your GitHub app.
     */
    "client-id": string;
    "access-token": string;
    app_slug: string;
    /**
     * authorization_id parameter
     */
    authorization_id: number;
    /**
     * The slug version of the enterprise name. You can also substitute this value with the enterprise id.
     */
    enterprise: string;
    /**
     * Unique identifier of an organization.
     */
    org_id: number;
    /**
     * Unique identifier of the self-hosted runner group.
     */
    runner_group_id: number;
    /**
     * Unique identifier of the self-hosted runner.
     */
    runner_id: number;
    /**
     * A search phrase. For more information, see [Searching the audit log](https://docs.github.com/github/setting-up-and-managing-organizations-and-teams/reviewing-the-audit-log-for-your-organization#searching-the-audit-log).
     */
    "audit-log-phrase": string;
    /**
     * The event types to include:
     *
     * - `web` - returns web (non-Git) events
     * - `git` - returns Git events
     * - `all` - returns both web and Git events
     *
     * The default is `web`.
     */
    "audit-log-include": "web" | "git" | "all";
    /**
     * A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events after this cursor.
     */
    "audit-log-after": string;
    /**
     * A cursor, as given in the [Link header](https://docs.github.com/rest/overview/resources-in-the-rest-api#link-header). If specified, the query only searches for events before this cursor.
     */
    "audit-log-before": string;
    /**
     * gist_id parameter
     */
    gist_id: string;
    /**
     * comment_id parameter
     */
    comment_id: number;
    /**
     * A list of comma separated label names. Example: `bug,ui,@high`
     */
    labels: string;
    /**
     * One of `asc` (ascending) or `desc` (descending).
     */
    direction: "asc" | "desc";
    /**
     * account_id parameter
     */
    account_id: number;
    /**
     * plan_id parameter
     */
    plan_id: number;
    /**
     * One of `created` (when the repository was starred) or `updated` (when it was last pushed to).
     */
    sort: "created" | "updated";
    owner: string;
    repo: string;
    /**
     * If `true`, show notifications marked as read.
     */
    all: boolean;
    /**
     * If `true`, only shows notifications in which the user is directly participating or mentioned.
     */
    participating: boolean;
    /**
     * Only show notifications updated before the given time. This is a timestamp in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    before: string;
    /**
     * thread_id parameter
     */
    thread_id: number;
    /**
     * An organization ID. Only return organizations with an ID greater than this ID.
     */
    "since-org": number;
    org: string;
    repository_id: number;
    /**
     * secret_name parameter
     */
    secret_name: string;
    username: string;
    "hook-id": number;
    /**
     * invitation_id parameter
     */
    invitation_id: number;
    /**
     * migration_id parameter
     */
    migration_id: number;
    /**
     * repo_name parameter
     */
    repo_name: string;
    /**
     * team_slug parameter
     */
    team_slug: string;
    "discussion-number": number;
    "comment-number": number;
    "reaction-id": number;
    "project-id": number;
    /**
     * card_id parameter
     */
    card_id: number;
    /**
     * column_id parameter
     */
    column_id: number;
    /**
     * artifact_id parameter
     */
    artifact_id: number;
    /**
     * job_id parameter
     */
    job_id: number;
    /**
     * Returns someone's workflow runs. Use the login for the user who created the `push` associated with the check suite or workflow run.
     */
    actor: string;
    /**
     * Returns workflow runs associated with a branch. Use the name of the branch of the `push`.
     */
    "workflow-run-branch": string;
    /**
     * Returns workflow run triggered by the event you specify. For example, `push`, `pull_request` or `issue`. For more information, see "[Events that trigger workflows](https://help.github.com/en/actions/automating-your-workflow-with-github-actions/events-that-trigger-workflows)."
     */
    event: string;
    /**
     * Returns workflow runs associated with the check run `status` or `conclusion` you specify. For example, a conclusion can be `success` or a status can be `completed`. For more information, see the `status` and `conclusion` options available in "[Create a check run](https://docs.github.com/rest/reference/checks#create-a-check-run)."
     */
    "workflow-run-status": "completed" | "status" | "conclusion";
    "run-id": number;
    /**
     * The ID of the workflow. You can also pass the workflow file name as a string.
     */
    "workflow-id": number | string;
    /**
     * branch+ parameter
     */
    branch: string;
    /**
     * check_run_id parameter
     */
    check_run_id: number;
    /**
     * check_suite_id parameter
     */
    check_suite_id: number;
    /**
     * Returns check runs with the specified `name`.
     */
    check_name: string;
    /**
     * Returns check runs with the specified `status`. Can be one of `queued`, `in_progress`, or `completed`.
     */
    status: "queued" | "in_progress" | "completed";
    /**
     * The security alert number, found at the end of the security alert's URL.
     */
    alert_number: components["schemas"]["alert-number"];
    /**
     * commit_sha+ parameter
     */
    commit_sha: string;
    /**
     * deployment_id parameter
     */
    deployment_id: number;
    /**
     * A user ID. Only return users with an ID greater than this ID.
     */
    "since-user": number;
    /**
     * issue_number parameter
     */
    issue_number: number;
    /**
     * key_id parameter
     */
    key_id: number;
    /**
     * milestone_number parameter
     */
    milestone_number: number;
    "pull-number": number;
    /**
     * review_id parameter
     */
    review_id: number;
    /**
     * asset_id parameter
     */
    asset_id: number;
    /**
     * release_id parameter
     */
    release_id: number;
    /**
     * Must be one of: `day`, `week`.
     */
    per: "day" | "week";
    /**
     * A repository ID. Only return repositories with an ID greater than this ID.
     */
    "since-repo": number;
    /**
     * Used for pagination: the index of the first result to return.
     */
    start_index: number;
    /**
     * Used for pagination: the number of results to return.
     */
    count: number;
    /**
     * Identifier generated by the GitHub SCIM endpoint.
     */
    scim_group_id: string;
    /**
     * scim_user_id parameter
     */
    scim_user_id: string;
    /**
     * Determines whether the first search result returned is the highest number of matches (`desc`) or lowest number of matches (`asc`). This parameter is ignored unless you provide `sort`.
     */
    order: "desc" | "asc";
    "team-id": number;
    /**
     * gpg_key_id parameter
     */
    gpg_key_id: number;
  };
  schemas: {
    /**
     * Simple User
     */
    "simple-user": {
      login: string;
      id: number;
      node_id: string;
      avatar_url: string;
      gravatar_id: string | null;
      url: string;
      html_url: string;
      followers_url: string;
      following_url: string;
      gists_url: string;
      starred_url: string;
      subscriptions_url: string;
      organizations_url: string;
      repos_url: string;
      events_url: string;
      received_events_url: string;
      type: string;
      site_admin: boolean;
      starred_at?: string;
    } | null;
    /**
     * GitHub apps are a new way to extend GitHub. They can be installed directly on organizations and user accounts and granted access to specific repositories. They come with granular permissions and built-in webhooks. GitHub apps are first class actors within GitHub.
     */
    integration: {
      /**
       * Unique identifier of the GitHub app
       */
      id: number;
      /**
       * The slug name of the GitHub app
       */
      slug?: string;
      node_id: string;
      owner: components["schemas"]["simple-user"] | null;
      /**
       * The name of the GitHub app
       */
      name: string;
      description: string | null;
      external_url: string;
      html_url: string;
      created_at: string;
      updated_at: string;
      /**
       * The set of permissions for the GitHub app
       */
      permissions: {
        issues?: string;
        checks?: string;
        metadata?: string;
        contents?: string;
        deployments?: string;
      } & { [key: string]: string };
      /**
       * The list of events for the GitHub app
       */
      events: string[];
      /**
       * The number of installations associated with the GitHub app
       */
      installations_count?: number;
      client_id?: string;
      client_secret?: string;
      webhook_secret?: string;
      pem?: string;
    } & { [key: string]: any };
    /**
     * Basic Error
     */
    "basic-error": { message?: string; documentation_url?: string };
    /**
     * Validation Error Simple
     */
    "validation-error-simple": {
      message: string;
      documentation_url: string;
      errors?: string[];
    };
    /**
     * The URL to which the payloads will be delivered.
     */
    "webhook-config-url": string;
    /**
     * The media type used to serialize the payloads. Supported values include `json` and `form`. The default is `form`.
     */
    "webhook-config-content-type": string;
    /**
     * If provided, the `secret` will be used as the `key` to generate the HMAC hex digest value for [delivery signature headers](https://docs.github.com/webhooks/event-payloads/#delivery-headers).
     */
    "webhook-config-secret": string;
    /**
     * Determines whether the SSL certificate of the host for `url` will be verified when delivering payloads. Supported values include `0` (verification is performed) and `1` (verification is not performed). The default is `0`. **We strongly recommend not setting this to `1` as you are subject to man-in-the-middle and other attacks.**
     */
    "webhook-config-insecure-ssl": string;
    /**
     * Configuration object of the webhook
     */
    "webhook-config": {
      url?: components["schemas"]["webhook-config-url"];
      content_type?: components["schemas"]["webhook-config-content-type"];
      secret?: components["schemas"]["webhook-config-secret"];
      insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
    };
    /**
     * An enterprise account
     */
    enterprise: {
      /**
       * A short description of the enterprise.
       */
      description?: string | null;
      html_url: string;
      /**
       * The enterprise's website URL.
       */
      website_url?: string | null;
      /**
       * Unique identifier of the enterprise
       */
      id: number;
      node_id: string;
      /**
       * The name of the enterprise.
       */
      name: string;
      /**
       * The slug url identifier for the enterprise.
       */
      slug: string;
      created_at: string | null;
      updated_at: string | null;
      avatar_url: string;
    };
    /**
     * Installation
     */
    installation: {
      /**
       * The ID of the installation.
       */
      id: number;
      account:
        | (Partial<components["schemas"]["simple-user"]> &
            Partial<components["schemas"]["enterprise"]>)
        | null;
      /**
       * Describe whether all repositories have been selected or there's a selection involved
       */
      repository_selection: "all" | "selected";
      access_tokens_url: string;
      repositories_url: string;
      html_url: string;
      app_id: number;
      /**
       * The ID of the user or organization this token is being scoped to.
       */
      target_id: number;
      target_type: string;
      permissions: {
        deployments?: string;
        checks?: string;
        metadata?: string;
        contents?: string;
        pull_requests?: string;
        statuses?: string;
        issues?: string;
        organization_administration?: string;
      };
      events: string[];
      created_at: string;
      updated_at: string;
      single_file_name: string | null;
      has_multiple_single_files?: boolean;
      single_file_paths?: string[];
      app_slug: string;
      suspended_by?: components["schemas"]["simple-user"] | null;
      suspended_at?: string | null;
      contact_email?: string | null;
    };
    /**
     * License Simple
     */
    "license-simple": {
      key: string;
      name: string;
      url: string | null;
      spdx_id: string | null;
      node_id: string;
      html_url?: string;
    };
    /**
     * A git repository
     */
    repository: {
      /**
       * Unique identifier of the repository
       */
      id: number;
      node_id: string;
      /**
       * The name of the repository.
       */
      name: string;
      full_name: string;
      license: components["schemas"]["license-simple"] | null;
      forks: number;
      permissions?: {
        admin: boolean;
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
      };
      owner: components["schemas"]["simple-user"] | null;
      /**
       * Whether the repository is private or public.
       */
      private: boolean;
      html_url: string;
      description: string | null;
      fork: boolean;
      url: string;
      archive_url: string;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      contributors_url: string;
      deployments_url: string;
      downloads_url: string;
      events_url: string;
      forks_url: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url: string;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      languages_url: string;
      merges_url: string;
      milestones_url: string;
      notifications_url: string;
      pulls_url: string;
      releases_url: string;
      ssh_url: string;
      stargazers_url: string;
      statuses_url: string;
      subscribers_url: string;
      subscription_url: string;
      tags_url: string;
      teams_url: string;
      trees_url: string;
      clone_url: string;
      mirror_url: string | null;
      hooks_url: string;
      svn_url: string;
      homepage: string | null;
      language: string | null;
      forks_count: number;
      stargazers_count: number;
      watchers_count: number;
      size: number;
      /**
       * The default branch of the repository.
       */
      default_branch: string;
      open_issues_count: number;
      /**
       * Whether this repository acts as a template that can be used to generate new repositories.
       */
      is_template?: boolean;
      topics?: string[];
      /**
       * Whether issues are enabled.
       */
      has_issues: boolean;
      /**
       * Whether projects are enabled.
       */
      has_projects: boolean;
      /**
       * Whether the wiki is enabled.
       */
      has_wiki: boolean;
      has_pages: boolean;
      /**
       * Whether downloads are enabled.
       */
      has_downloads: boolean;
      /**
       * Whether the repository is archived.
       */
      archived: boolean;
      /**
       * Returns whether or not this repository disabled.
       */
      disabled: boolean;
      /**
       * The repository visibility: public, private, or internal.
       */
      visibility?: string;
      pushed_at: string | null;
      created_at: string | null;
      updated_at: string | null;
      /**
       * Whether to allow rebase merges for pull requests.
       */
      allow_rebase_merge?: boolean;
      template_repository?: {
        id?: number;
        node_id?: string;
        name?: string;
        full_name?: string;
        owner?: {
          login?: string;
          id?: number;
          node_id?: string;
          avatar_url?: string;
          gravatar_id?: string;
          url?: string;
          html_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          starred_url?: string;
          subscriptions_url?: string;
          organizations_url?: string;
          repos_url?: string;
          events_url?: string;
          received_events_url?: string;
          type?: string;
          site_admin?: boolean;
        };
        private?: boolean;
        html_url?: string;
        description?: string;
        fork?: boolean;
        url?: string;
        archive_url?: string;
        assignees_url?: string;
        blobs_url?: string;
        branches_url?: string;
        collaborators_url?: string;
        comments_url?: string;
        commits_url?: string;
        compare_url?: string;
        contents_url?: string;
        contributors_url?: string;
        deployments_url?: string;
        downloads_url?: string;
        events_url?: string;
        forks_url?: string;
        git_commits_url?: string;
        git_refs_url?: string;
        git_tags_url?: string;
        git_url?: string;
        issue_comment_url?: string;
        issue_events_url?: string;
        issues_url?: string;
        keys_url?: string;
        labels_url?: string;
        languages_url?: string;
        merges_url?: string;
        milestones_url?: string;
        notifications_url?: string;
        pulls_url?: string;
        releases_url?: string;
        ssh_url?: string;
        stargazers_url?: string;
        statuses_url?: string;
        subscribers_url?: string;
        subscription_url?: string;
        tags_url?: string;
        teams_url?: string;
        trees_url?: string;
        clone_url?: string;
        mirror_url?: string;
        hooks_url?: string;
        svn_url?: string;
        homepage?: string;
        language?: string;
        forks_count?: number;
        stargazers_count?: number;
        watchers_count?: number;
        size?: number;
        default_branch?: string;
        open_issues_count?: number;
        is_template?: boolean;
        topics?: string[];
        has_issues?: boolean;
        has_projects?: boolean;
        has_wiki?: boolean;
        has_pages?: boolean;
        has_downloads?: boolean;
        archived?: boolean;
        disabled?: boolean;
        visibility?: string;
        pushed_at?: string;
        created_at?: string;
        updated_at?: string;
        permissions?: { admin?: boolean; push?: boolean; pull?: boolean };
        allow_rebase_merge?: boolean;
        temp_clone_token?: string;
        allow_squash_merge?: boolean;
        delete_branch_on_merge?: boolean;
        allow_merge_commit?: boolean;
        subscribers_count?: number;
        network_count?: number;
      } | null;
      temp_clone_token?: string;
      /**
       * Whether to allow squash merges for pull requests.
       */
      allow_squash_merge?: boolean;
      /**
       * Whether to delete head branches when pull requests are merged
       */
      delete_branch_on_merge?: boolean;
      /**
       * Whether to allow merge commits for pull requests.
       */
      allow_merge_commit?: boolean;
      subscribers_count?: number;
      network_count?: number;
      open_issues: number;
      watchers: number;
      master_branch?: string;
      starred_at?: string;
    };
    /**
     * Authentication token for a GitHub App installed on a user or org.
     */
    "installation-token": {
      token: string;
      expires_at: string;
      permissions?: {
        issues?: string;
        contents?: string;
        metadata?: string;
        single_file?: string;
      };
      repository_selection?: "all" | "selected";
      repositories?: components["schemas"]["repository"][];
      single_file?: string;
      has_multiple_single_files?: boolean;
      single_file_paths?: string[];
    };
    /**
     * Validation Error
     */
    "validation-error": {
      message: string;
      documentation_url: string;
      errors?: {
        resource?: string;
        field?: string;
        message?: string;
        code: string;
        index?: number;
        value?: string | number | string[];
      }[];
    };
    /**
     * The authorization associated with an OAuth Access.
     */
    "application-grant": {
      id: number;
      url: string;
      app: { client_id: string; name: string; url: string };
      created_at: string;
      updated_at: string;
      scopes: string[];
      user?: components["schemas"]["simple-user"] | null;
    };
    /**
     * The permissions granted to the user-to-server access token.
     */
    "app-permissions": {
      /**
       * The level of permission to grant the access token for GitHub Actions workflows, workflow runs, and artifacts. Can be one of: `read` or `write`.
       */
      actions?: "read" | "write";
      /**
       * The level of permission to grant the access token for repository creation, deletion, settings, teams, and collaborators creation. Can be one of: `read` or `write`.
       */
      administration?: "read" | "write";
      /**
       * The level of permission to grant the access token for checks on code. Can be one of: `read` or `write`.
       */
      checks?: "read" | "write";
      /**
       * The level of permission to grant the access token for notification of content references and creation content attachments. Can be one of: `read` or `write`.
       */
      content_references?: "read" | "write";
      /**
       * The level of permission to grant the access token for repository contents, commits, branches, downloads, releases, and merges. Can be one of: `read` or `write`.
       */
      contents?: "read" | "write";
      /**
       * The level of permission to grant the access token for deployments and deployment statuses. Can be one of: `read` or `write`.
       */
      deployments?: "read" | "write";
      /**
       * The level of permission to grant the access token for managing repository environments. Can be one of: `read` or `write`.
       */
      environments?: "read" | "write";
      /**
       * The level of permission to grant the access token for issues and related comments, assignees, labels, and milestones. Can be one of: `read` or `write`.
       */
      issues?: "read" | "write";
      /**
       * The level of permission to grant the access token to search repositories, list collaborators, and access repository metadata. Can be one of: `read` or `write`.
       */
      metadata?: "read" | "write";
      /**
       * The level of permission to grant the access token for packages published to GitHub Packages. Can be one of: `read` or `write`.
       */
      packages?: "read" | "write";
      /**
       * The level of permission to grant the access token to retrieve Pages statuses, configuration, and builds, as well as create new builds. Can be one of: `read` or `write`.
       */
      pages?: "read" | "write";
      /**
       * The level of permission to grant the access token for pull requests and related comments, assignees, labels, milestones, and merges. Can be one of: `read` or `write`.
       */
      pull_requests?: "read" | "write";
      /**
       * The level of permission to grant the access token to manage the post-receive hooks for a repository. Can be one of: `read` or `write`.
       */
      repository_hooks?: "read" | "write";
      /**
       * The level of permission to grant the access token to manage repository projects, columns, and cards. Can be one of: `read`, `write`, or `admin`.
       */
      repository_projects?: "read" | "write" | "admin";
      /**
       * The level of permission to grant the access token to view and manage secret scanning alerts. Can be one of: `read` or `write`.
       */
      secret_scanning_alerts?: "read" | "write";
      /**
       * The level of permission to grant the access token to manage repository secrets. Can be one of: `read` or `write`.
       */
      secrets?: "read" | "write";
      /**
       * The level of permission to grant the access token to view and manage security events like code scanning alerts. Can be one of: `read` or `write`.
       */
      security_events?: "read" | "write";
      /**
       * The level of permission to grant the access token to manage just a single file. Can be one of: `read` or `write`.
       */
      single_file?: "read" | "write";
      /**
       * The level of permission to grant the access token for commit statuses. Can be one of: `read` or `write`.
       */
      statuses?: "read" | "write";
      /**
       * The level of permission to grant the access token to retrieve Dependabot alerts. Can be one of: `read`.
       */
      vulnerability_alerts?: "read";
      /**
       * The level of permission to grant the access token to update GitHub Actions workflow files. Can be one of: `write`.
       */
      workflows?: "write";
      /**
       * The level of permission to grant the access token for organization teams and members. Can be one of: `read` or `write`.
       */
      members?: "read" | "write";
      /**
       * The level of permission to grant the access token to manage access to an organization. Can be one of: `read` or `write`.
       */
      organization_administration?: "read" | "write";
      /**
       * The level of permission to grant the access token to manage the post-receive hooks for an organization. Can be one of: `read` or `write`.
       */
      organization_hooks?: "read" | "write";
      /**
       * The level of permission to grant the access token for viewing an organization's plan. Can be one of: `read`.
       */
      organization_plan?: "read";
      /**
       * The level of permission to grant the access token to manage organization projects, columns, and cards. Can be one of: `read`, `write`, or `admin`.
       */
      organization_projects?: "read" | "write" | "admin";
      /**
       * The level of permission to grant the access token to manage organization secrets. Can be one of: `read` or `write`.
       */
      organization_secrets?: "read" | "write";
      /**
       * The level of permission to grant the access token to view and manage GitHub Actions self-hosted runners available to an organization. Can be one of: `read` or `write`.
       */
      organization_self_hosted_runners?: "read" | "write";
      /**
       * The level of permission to grant the access token to view and manage users blocked by the organization. Can be one of: `read` or `write`.
       */
      organization_user_blocking?: "read" | "write";
      /**
       * The level of permission to grant the access token to manage team discussions and related comments. Can be one of: `read` or `write`.
       */
      team_discussions?: "read" | "write";
    };
    "scoped-installation": {
      permissions: components["schemas"]["app-permissions"];
      /**
       * Describe whether all repositories have been selected or there's a selection involved
       */
      repository_selection: "all" | "selected";
      single_file_name: string | null;
      has_multiple_single_files?: boolean;
      single_file_paths?: string[];
      repositories_url: string;
      account: components["schemas"]["simple-user"];
    };
    /**
     * The authorization for an OAuth app, GitHub App, or a Personal Access Token.
     */
    authorization: {
      id: number;
      url: string;
      /**
       * A list of scopes that this authorization is in.
       */
      scopes: string[] | null;
      token: string;
      token_last_eight: string | null;
      hashed_token: string | null;
      app: { client_id: string; name: string; url: string };
      note: string | null;
      note_url: string | null;
      updated_at: string;
      created_at: string;
      fingerprint: string | null;
      user?: components["schemas"]["simple-user"] | null;
      installation?: components["schemas"]["scoped-installation"] | null;
    };
    /**
     * Code Of Conduct
     */
    "code-of-conduct": {
      key: string;
      name: string;
      url: string;
      body?: string;
      html_url: string | null;
    };
    /**
     * Content Reference attachments allow you to provide context around URLs posted in comments
     */
    "content-reference-attachment": {
      /**
       * The ID of the attachment
       */
      id: number;
      /**
       * The title of the attachment
       */
      title: string;
      /**
       * The body of the attachment
       */
      body: string;
      /**
       * The node_id of the content attachment
       */
      node_id?: string;
    };
    /**
     * The policy that controls the organizations in the enterprise that are allowed to run GitHub Actions. Can be one of: `all`, `none`, or `selected`.
     */
    "enabled-organizations": "all" | "none" | "selected";
    /**
     * The permissions policy that controls the actions that are allowed to run. Can be one of: `all`, `local_only`, or `selected`.
     */
    "allowed-actions": "all" | "local_only" | "selected";
    /**
     * The API URL to use to get or set the actions that are allowed to run, when `allowed_actions` is set to `selected`.
     */
    "selected-actions-url": string;
    "actions-enterprise-permissions": {
      enabled_organizations: components["schemas"]["enabled-organizations"];
      /**
       * The API URL to use to get or set the selected organizations that are allowed to run GitHub Actions, when `enabled_organizations` is set to `selected`.
       */
      selected_organizations_url?: string;
      allowed_actions: components["schemas"]["allowed-actions"];
      selected_actions_url?: components["schemas"]["selected-actions-url"];
    };
    /**
     * Organization Simple
     */
    "organization-simple": {
      login: string;
      id: number;
      node_id: string;
      url: string;
      repos_url: string;
      events_url: string;
      hooks_url: string;
      issues_url: string;
      members_url: string;
      public_members_url: string;
      avatar_url: string;
      description: string | null;
    };
    "selected-actions": {
      /**
       * Whether GitHub-owned actions are allowed. For example, this includes the actions in the `actions` organization.
       */
      github_owned_allowed: boolean;
      /**
       * Whether actions in GitHub Marketplace from verified creators are allowed. Set to `true` to allow all GitHub Marketplace actions by verified creators.
       */
      verified_allowed: boolean;
      /**
       * Specifies a list of string-matching patterns to allow specific action(s). Wildcards, tags, and SHAs are allowed. For example, `monalisa/octocat@*`, `monalisa/octocat@v2`, `monalisa/*`."
       */
      patterns_allowed: string[];
    };
    "runner-groups-enterprise": {
      id: number;
      name: string;
      visibility: string;
      default: boolean;
      selected_organizations_url?: string;
      runners_url: string;
      allows_public_repositories: boolean;
    };
    /**
     * A self hosted runner
     */
    runner: {
      /**
       * The id of the runner.
       */
      id: number;
      /**
       * The name of the runner.
       */
      name: string;
      /**
       * The Operating System of the runner.
       */
      os: string;
      /**
       * The status of the runner.
       */
      status: string;
      busy: boolean;
      labels: {
        /**
         * Unique identifier of the label.
         */
        id?: number;
        /**
         * Name of the label.
         */
        name?: string;
        /**
         * The type of label. Read-only labels are applied automatically when the runner is configured.
         */
        type?: "read-only" | "custom";
      }[];
    };
    /**
     * Runner Application
     */
    "runner-application": {
      os: string;
      architecture: string;
      download_url: string;
      filename: string;
    };
    /**
     * Authentication Token
     */
    "authentication-token": {
      /**
       * The token used for authentication
       */
      token: string;
      /**
       * The time this token expires
       */
      expires_at: string;
      permissions?: { [key: string]: any };
      /**
       * The repositories this token has access to
       */
      repositories?: components["schemas"]["repository"][];
      single_file?: string | null;
      /**
       * Describe whether all repositories have been selected or there's a selection involved
       */
      repository_selection?: "all" | "selected";
    };
    "audit-log-event": {
      /**
       * The time the audit log event occurred, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time).
       */
      "@timestamp"?: number;
      /**
       * The name of the action that was performed, for example `user.login` or `repo.create`.
       */
      action?: string;
      active?: boolean;
      active_was?: boolean;
      /**
       * The actor who performed the action.
       */
      actor?: string;
      /**
       * The username of the account being blocked.
       */
      blocked_user?: string;
      business?: string;
      config?: any[];
      config_was?: any[];
      content_type?: string;
      /**
       * The time the audit log event was recorded, given as a [Unix timestamp](http://en.wikipedia.org/wiki/Unix_time).
       */
      created_at?: number;
      deploy_key_fingerprint?: string;
      emoji?: string;
      events?: any[];
      events_were?: any[];
      explanation?: string;
      fingerprint?: string;
      hook_id?: number;
      limited_availability?: boolean;
      message?: string;
      name?: string;
      old_user?: string;
      openssh_public_key?: string;
      org?: string;
      previous_visibility?: string;
      read_only?: boolean;
      /**
       * The name of the repository.
       */
      repo?: string;
      /**
       * The name of the repository.
       */
      repository?: string;
      repository_public?: boolean;
      target_login?: string;
      team?: string;
      /**
       * The type of protocol (for example, HTTP or SSH) used to transfer Git data.
       */
      transport_protocol?: number;
      /**
       * A human readable name for the protocol (for example, HTTP or SSH) used to transfer Git data.
       */
      transport_protocol_name?: string;
      /**
       * The user that was affected by the action performed (if available).
       */
      user?: string;
      /**
       * The repository visibility, for example `public` or `private`.
       */
      visibility?: string;
    };
    "actions-billing-usage": {
      /**
       * The sum of the free and paid GitHub Actions minutes used.
       */
      total_minutes_used: number;
      /**
       * The total paid GitHub Actions minutes used.
       */
      total_paid_minutes_used: number;
      /**
       * The amount of free GitHub Actions minutes available.
       */
      included_minutes: number;
      minutes_used_breakdown: {
        /**
         * Total minutes used on Ubuntu runner machines.
         */
        UBUNTU?: number;
        /**
         * Total minutes used on macOS runner machines.
         */
        MACOS?: number;
        /**
         * Total minutes used on Windows runner machines.
         */
        WINDOWS?: number;
      };
    };
    "packages-billing-usage": {
      /**
       * Sum of the free and paid storage space (GB) for GitHuub Packages.
       */
      total_gigabytes_bandwidth_used: number;
      /**
       * Total paid storage space (GB) for GitHuub Packages.
       */
      total_paid_gigabytes_bandwidth_used: number;
      /**
       * Free storage space (GB) for GitHub Packages.
       */
      included_gigabytes_bandwidth: number;
    };
    "combined-billing-usage": {
      /**
       * Numbers of days left in billing cycle.
       */
      days_left_in_billing_cycle: number;
      /**
       * Estimated storage space (GB) used in billing cycle.
       */
      estimated_paid_storage_for_month: number;
      /**
       * Estimated sum of free and paid storage space (GB) used in billing cycle.
       */
      estimated_storage_for_month: number;
    };
    /**
     * Actor
     */
    actor: {
      id: number;
      login: string;
      display_login?: string;
      gravatar_id: string | null;
      url: string;
      avatar_url: string;
    };
    /**
     * Color-coded labels help you categorize and filter your issues (just like labels in Gmail).
     */
    label: {
      id: number;
      node_id: string;
      /**
       * URL for the label
       */
      url: string;
      /**
       * The name of the label.
       */
      name: string;
      description: string | null;
      /**
       * 6-character hex code, without the leading #, identifying the color
       */
      color: string;
      default: boolean;
    };
    /**
     * A collection of related issues and pull requests.
     */
    milestone: {
      url: string;
      html_url: string;
      labels_url: string;
      id: number;
      node_id: string;
      /**
       * The number of the milestone.
       */
      number: number;
      /**
       * The state of the milestone.
       */
      state: "open" | "closed";
      /**
       * The title of the milestone.
       */
      title: string;
      description: string | null;
      creator: components["schemas"]["simple-user"] | null;
      open_issues: number;
      closed_issues: number;
      created_at: string;
      updated_at: string;
      closed_at: string | null;
      due_on: string | null;
    };
    /**
     * Issue Simple
     */
    "issue-simple": {
      id: number;
      node_id: string;
      url: string;
      repository_url: string;
      labels_url: string;
      comments_url: string;
      events_url: string;
      html_url: string;
      number: number;
      state: string;
      title: string;
      body?: string;
      user: components["schemas"]["simple-user"] | null;
      labels: components["schemas"]["label"][];
      assignee: components["schemas"]["simple-user"] | null;
      assignees?: components["schemas"]["simple-user"][] | null;
      milestone: components["schemas"]["milestone"] | null;
      locked: boolean;
      active_lock_reason?: string | null;
      comments: number;
      pull_request?: {
        merged_at?: string | null;
        diff_url: string | null;
        html_url: string | null;
        patch_url: string | null;
        url: string | null;
      };
      closed_at: string | null;
      created_at: string;
      updated_at: string;
      author_association: string;
      body_html?: string;
      body_text?: string;
      timeline_url?: string;
      repository?: components["schemas"]["repository"];
      performed_via_github_app?: components["schemas"]["integration"] | null;
    };
    "reaction-rollup": {
      url: string;
      total_count: number;
      "+1": number;
      "-1": number;
      laugh: number;
      confused: number;
      heart: number;
      hooray: number;
      eyes: number;
      rocket: number;
    };
    /**
     * Comments provide a way for people to collaborate on an issue.
     */
    "issue-comment": {
      /**
       * Unique identifier of the issue comment
       */
      id: number;
      node_id: string;
      /**
       * URL for the issue comment
       */
      url: string;
      /**
       * Contents of the issue comment
       */
      body?: string;
      body_text?: string;
      body_html?: string;
      html_url: string;
      user: components["schemas"]["simple-user"] | null;
      created_at: string;
      updated_at: string;
      issue_url: string;
      author_association:
        | "collaborator"
        | "contributor"
        | "first_timer"
        | "first_time_contributor"
        | "mannequin"
        | "member"
        | "none"
        | "owner";
      performed_via_github_app?: components["schemas"]["integration"] | null;
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Event
     */
    event: {
      id: string;
      type: string | null;
      actor: components["schemas"]["actor"];
      repo: { id: number; name: string; url: string };
      org?: components["schemas"]["actor"];
      payload: {
        action: string;
        issue?: components["schemas"]["issue-simple"];
        comment?: components["schemas"]["issue-comment"];
        pages?: {
          page_name?: string;
          title?: string;
          summary?: string | null;
          action?: string;
          sha?: string;
          html_url?: string;
        }[];
      };
      public: boolean;
      created_at: string | null;
    };
    /**
     * Hypermedia Link with Type
     */
    "link-with-type": { href: string; type: string };
    /**
     * Feed
     */
    feed: {
      timeline_url: string;
      user_url: string;
      current_user_public_url?: string;
      current_user_url?: string;
      current_user_actor_url?: string;
      current_user_organization_url?: string;
      current_user_organization_urls?: string[];
      security_advisories_url?: string;
      _links: {
        timeline: components["schemas"]["link-with-type"];
        user: components["schemas"]["link-with-type"];
        security_advisories?: components["schemas"]["link-with-type"];
        current_user?: components["schemas"]["link-with-type"];
        current_user_public?: components["schemas"]["link-with-type"];
        current_user_actor?: components["schemas"]["link-with-type"];
        current_user_organization?: components["schemas"]["link-with-type"];
        current_user_organizations?: components["schemas"]["link-with-type"][];
      };
    };
    /**
     * Base Gist
     */
    "base-gist": {
      url: string;
      forks_url: string;
      commits_url: string;
      id: string;
      node_id: string;
      git_pull_url: string;
      git_push_url: string;
      html_url: string;
      files: {
        [key: string]: {
          filename?: string;
          type?: string;
          language?: string;
          raw_url?: string;
          size?: number;
        };
      };
      public: boolean;
      created_at: string;
      updated_at: string;
      description: string | null;
      comments: number;
      user: components["schemas"]["simple-user"] | null;
      comments_url: string;
      owner?: components["schemas"]["simple-user"] | null;
      truncated?: boolean;
      forks?: { [key: string]: any }[];
      history?: { [key: string]: any }[];
    };
    /**
     * Gist Simple
     */
    "gist-simple": {
      url?: string;
      forks_url?: string;
      commits_url?: string;
      id?: string;
      node_id?: string;
      git_pull_url?: string;
      git_push_url?: string;
      html_url?: string;
      files?: {
        [key: string]: {
          filename?: string;
          type?: string;
          language?: string;
          raw_url?: string;
          size?: number;
          truncated?: boolean;
          content?: string;
        };
      };
      public?: boolean;
      created_at?: string;
      updated_at?: string;
      description?: string | null;
      comments?: number;
      user?: string | null;
      comments_url?: string;
      owner?: components["schemas"]["simple-user"];
      truncated?: boolean;
    };
    /**
     * Gist Full
     */
    "gist-full": components["schemas"]["gist-simple"] & {
      forks?: {
        user?: {
          login?: string;
          id?: number;
          node_id?: string;
          avatar_url?: string;
          gravatar_id?: string;
          url?: string;
          html_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          starred_url?: string;
          subscriptions_url?: string;
          organizations_url?: string;
          repos_url?: string;
          events_url?: string;
          received_events_url?: string;
          type?: string;
          site_admin?: boolean;
        };
        url?: string;
        id?: string;
        created_at?: string;
        updated_at?: string;
      }[];
      history?: {
        url?: string;
        version?: string;
        user?: {
          login?: string;
          id?: number;
          node_id?: string;
          avatar_url?: string;
          gravatar_id?: string;
          url?: string;
          html_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          starred_url?: string;
          subscriptions_url?: string;
          organizations_url?: string;
          repos_url?: string;
          events_url?: string;
          received_events_url?: string;
          type?: string;
          site_admin?: boolean;
        } | null;
        change_status?: {
          deletions?: number;
          additions?: number;
          total?: number;
        };
        committed_at?: string;
      }[];
      fork_of?: components["schemas"]["gist-simple"] | null;
      url?: string;
      forks_url?: string;
      commits_url?: string;
      id?: string;
      node_id?: string;
      git_pull_url?: string;
      git_push_url?: string;
      html_url?: string;
      created_at?: string;
      updated_at?: string;
      description?: string | null;
      comments?: number;
      comments_url?: string;
    };
    /**
     * A comment made to a gist.
     */
    "gist-comment": {
      id: number;
      node_id: string;
      url: string;
      /**
       * The comment text.
       */
      body: string;
      user: components["schemas"]["simple-user"] | null;
      created_at: string;
      updated_at: string;
      author_association: string;
    };
    /**
     * Gist Commit
     */
    "gist-commit": {
      url: string;
      version: string;
      user: components["schemas"]["simple-user"] | null;
      change_status: { total?: number; additions?: number; deletions?: number };
      committed_at: string;
    };
    /**
     * Gitignore Template
     */
    "gitignore-template": { name: string; source: string };
    /**
     * Issues are a great way to keep track of tasks, enhancements, and bugs for your projects.
     */
    issue: {
      id: number;
      node_id: string;
      /**
       * URL for the issue
       */
      url: string;
      repository_url: string;
      labels_url: string;
      comments_url: string;
      events_url: string;
      html_url: string;
      /**
       * Number uniquely identifying the issue within its repository
       */
      number: number;
      /**
       * State of the issue; either 'open' or 'closed'
       */
      state: string;
      /**
       * Title of the issue
       */
      title: string;
      /**
       * Contents of the issue
       */
      body?: string;
      user: components["schemas"]["simple-user"] | null;
      /**
       * Labels to associate with this issue; pass one or more label names to replace the set of labels on this issue; send an empty array to clear all labels from the issue; note that the labels are silently dropped for users without push access to the repository
       */
      labels: (
        | string
        | {
            id?: number;
            node_id?: string;
            url?: string;
            name?: string;
            description?: string | null;
            color?: string | null;
            default?: boolean;
          }
      )[];
      assignee: components["schemas"]["simple-user"] | null;
      assignees?: components["schemas"]["simple-user"][] | null;
      milestone: components["schemas"]["milestone"] | null;
      locked: boolean;
      active_lock_reason?: string | null;
      comments: number;
      pull_request?: {
        merged_at?: string | null;
        diff_url: string | null;
        html_url: string | null;
        patch_url: string | null;
        url: string | null;
      };
      closed_at: string | null;
      created_at: string;
      updated_at: string;
      closed_by?: components["schemas"]["simple-user"] | null;
      body_html?: string;
      body_text?: string;
      timeline_url?: string;
      repository?: components["schemas"]["repository"];
      performed_via_github_app?: components["schemas"]["integration"] | null;
      author_association: string;
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * License
     */
    license: {
      key: string;
      name: string;
      spdx_id: string | null;
      url: string | null;
      node_id: string;
      html_url: string;
      description: string;
      implementation: string;
      permissions: string[];
      conditions: string[];
      limitations: string[];
      body: string;
      featured: boolean;
    };
    /**
     * Marketplace Listing Plan
     */
    "marketplace-listing-plan": {
      url: string;
      accounts_url: string;
      id: number;
      number: number;
      name: string;
      description: string;
      monthly_price_in_cents: number;
      yearly_price_in_cents: number;
      price_model: string;
      has_free_trial: boolean;
      unit_name: string | null;
      state: string;
      bullets: string[];
    };
    /**
     * Marketplace Purchase
     */
    "marketplace-purchase": {
      url: string;
      type: string;
      id: number;
      login: string;
      organization_billing_email?: string;
      marketplace_pending_change?: {
        is_installed?: boolean;
        effective_date?: string;
        unit_count?: number | null;
        id?: number;
        plan?: components["schemas"]["marketplace-listing-plan"];
      } | null;
      marketplace_purchase: {
        billing_cycle?: string;
        next_billing_date?: string | null;
        is_installed?: boolean;
        unit_count?: number | null;
        on_free_trial?: boolean;
        free_trial_ends_on?: string | null;
        updated_at?: string;
        plan?: components["schemas"]["marketplace-listing-plan"];
      };
    };
    /**
     * Api Overview
     */
    "api-overview": {
      verifiable_password_authentication: boolean;
      ssh_key_fingerprints?: { SHA256_RSA?: string; SHA256_DSA?: string };
      hooks?: string[];
      web?: string[];
      api?: string[];
      git?: string[];
      pages?: string[];
      importer?: string[];
      github_services_sha?: string;
      installed_version?: string;
    };
    /**
     * Minimal Repository
     */
    "minimal-repository": {
      id: number;
      node_id: string;
      name: string;
      full_name: string;
      owner: components["schemas"]["simple-user"] | null;
      private: boolean;
      html_url: string;
      description: string | null;
      fork: boolean;
      url: string;
      archive_url: string;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      contributors_url: string;
      deployments_url: string;
      downloads_url: string;
      events_url: string;
      forks_url: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url?: string;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      languages_url: string;
      merges_url: string;
      milestones_url: string;
      notifications_url: string;
      pulls_url: string;
      releases_url: string;
      ssh_url?: string;
      stargazers_url: string;
      statuses_url: string;
      subscribers_url: string;
      subscription_url: string;
      tags_url: string;
      teams_url: string;
      trees_url: string;
      clone_url?: string;
      mirror_url?: string | null;
      hooks_url: string;
      svn_url?: string;
      homepage?: string | null;
      language?: string | null;
      forks_count?: number;
      stargazers_count?: number;
      watchers_count?: number;
      size?: number;
      default_branch?: string;
      open_issues_count?: number;
      is_template?: boolean;
      topics?: string[];
      has_issues?: boolean;
      has_projects?: boolean;
      has_wiki?: boolean;
      has_pages?: boolean;
      has_downloads?: boolean;
      archived?: boolean;
      disabled?: boolean;
      visibility?: string;
      pushed_at?: string | null;
      created_at?: string | null;
      updated_at?: string | null;
      permissions?: { admin?: boolean; push?: boolean; pull?: boolean };
      template_repository?: components["schemas"]["repository"] | null;
      temp_clone_token?: string;
      delete_branch_on_merge?: boolean;
      subscribers_count?: number;
      network_count?: number;
      license?: {
        key?: string;
        name?: string;
        spdx_id?: string;
        url?: string;
        node_id?: string;
      } | null;
      forks?: number;
      open_issues?: number;
      watchers?: number;
    };
    /**
     * Thread
     */
    thread: {
      id: string;
      repository: components["schemas"]["minimal-repository"];
      subject: {
        title: string;
        url: string;
        latest_comment_url: string;
        type: string;
      };
      reason: string;
      unread: boolean;
      updated_at: string;
      last_read_at: string | null;
      url: string;
      subscription_url: string;
    };
    /**
     * Thread Subscription
     */
    "thread-subscription": {
      subscribed: boolean;
      ignored: boolean;
      reason: string | null;
      created_at: string | null;
      url: string;
      thread_url?: string;
      repository_url?: string;
    };
    /**
     * Organization Full
     */
    "organization-full": {
      login: string;
      id: number;
      node_id: string;
      url: string;
      repos_url: string;
      events_url: string;
      hooks_url: string;
      issues_url: string;
      members_url: string;
      public_members_url: string;
      avatar_url: string;
      description: string | null;
      name?: string;
      company?: string;
      blog?: string;
      location?: string;
      email?: string;
      twitter_username?: string | null;
      is_verified?: boolean;
      has_organization_projects: boolean;
      has_repository_projects: boolean;
      public_repos: number;
      public_gists: number;
      followers: number;
      following: number;
      html_url: string;
      created_at: string;
      type: string;
      total_private_repos?: number;
      owned_private_repos?: number;
      private_gists?: number | null;
      disk_usage?: number | null;
      collaborators?: number | null;
      billing_email?: string | null;
      plan?: {
        name: string;
        space: number;
        private_repos: number;
        filled_seats?: number;
        seats?: number;
      };
      default_repository_permission?: string | null;
      members_can_create_repositories?: boolean | null;
      two_factor_requirement_enabled?: boolean | null;
      members_allowed_repository_creation_type?: string;
      members_can_create_public_repositories?: boolean;
      members_can_create_private_repositories?: boolean;
      members_can_create_internal_repositories?: boolean;
      members_can_create_pages?: boolean;
      updated_at: string;
    };
    /**
     * The policy that controls the repositories in the organization that are allowed to run GitHub Actions. Can be one of: `all`, `none`, or `selected`.
     */
    "enabled-repositories": "all" | "none" | "selected";
    "actions-organization-permissions": {
      enabled_repositories: components["schemas"]["enabled-repositories"];
      /**
       * The API URL to use to get or set the selected repositories that are allowed to run GitHub Actions, when `enabled_repositories` is set to `selected`.
       */
      selected_repositories_url?: string;
      allowed_actions: components["schemas"]["allowed-actions"];
      selected_actions_url?: components["schemas"]["selected-actions-url"];
    };
    "runner-groups-org": {
      id: number;
      name: string;
      visibility: string;
      default: boolean;
      /**
       * Link to the selected repositories resource for this runner group. Not present unless visibility was set to `selected`
       */
      selected_repositories_url?: string;
      runners_url: string;
      inherited: boolean;
      inherited_allows_public_repositories?: boolean;
      allows_public_repositories: boolean;
    };
    /**
     * Secrets for GitHub Actions for an organization.
     */
    "organization-actions-secret": {
      /**
       * The name of the secret.
       */
      name: string;
      created_at: string;
      updated_at: string;
      /**
       * Visibility of a secret
       */
      visibility: "all" | "private" | "selected";
      selected_repositories_url?: string;
    };
    /**
     * The public key used for setting Actions Secrets.
     */
    "actions-public-key": {
      /**
       * The identifier for the key.
       */
      key_id: string;
      /**
       * The Base64 encoded public key.
       */
      key: string;
      id?: number;
      url?: string;
      title?: string;
      created_at?: string;
    };
    /**
     * Credential Authorization
     */
    "credential-authorization": {
      /**
       * User login that owns the underlying credential.
       */
      login: string;
      /**
       * Unique identifier for the credential.
       */
      credential_id: number;
      /**
       * Human-readable description of the credential type.
       */
      credential_type: string;
      /**
       * Last eight characters of the credential. Only included in responses with credential_type of personal access token.
       */
      token_last_eight?: string;
      /**
       * Date when the credential was authorized for use.
       */
      credential_authorized_at: string;
      /**
       * List of oauth scopes the token has been granted.
       */
      scopes?: string[];
      /**
       * Unique string to distinguish the credential. Only included in responses with credential_type of SSH Key.
       */
      fingerprint?: string;
      /**
       * Date when the credential was last accessed. May be null if it was never accessed
       */
      credential_accessed_at?: string | null;
      authorized_credential_id?: number | null;
      /**
       * The title given to the ssh key. This will only be present when the credential is an ssh key.
       */
      authorized_credential_title?: string;
      /**
       * The note given to the token. This will only be present when the credential is a token.
       */
      authorized_credential_note?: string;
    };
    /**
     * Org Hook
     */
    "org-hook": {
      id: number;
      url: string;
      ping_url: string;
      name: string;
      events: string[];
      active: boolean;
      config: {
        url?: string;
        insecure_ssl?: string;
        content_type?: string;
        secret?: string;
      };
      updated_at: string;
      created_at: string;
      type: string;
    };
    /**
     * The type of GitHub user that can comment, open issues, or create pull requests while the interaction limit is in effect. Can be one of: `existing_users`, `contributors_only`, `collaborators_only`.
     */
    "interaction-group":
      | "existing_users"
      | "contributors_only"
      | "collaborators_only";
    /**
     * Interaction limit settings.
     */
    "interaction-limit-response": {
      limit: components["schemas"]["interaction-group"];
      origin: string;
      expires_at: string;
    };
    /**
     * The duration of the interaction restriction. Can be one of: `one_day`, `three_days`, `one_week`, `one_month`, `six_months`. Default: `one_day`.
     */
    "interaction-expiry":
      | "one_day"
      | "three_days"
      | "one_week"
      | "one_month"
      | "six_months";
    /**
     * Limit interactions to a specific type of user for a specified duration
     */
    "interaction-limit": {
      limit: components["schemas"]["interaction-group"];
      expiry?: components["schemas"]["interaction-expiry"];
    };
    /**
     * Organization Invitation
     */
    "organization-invitation": {
      id: number;
      login: string | null;
      email: string | null;
      role: string;
      created_at: string;
      inviter: components["schemas"]["simple-user"];
      team_count: number;
      invitation_team_url: string;
      node_id: string;
      invitation_teams_url?: string;
    };
    /**
     * Groups of organization members that gives permissions on specified repositories.
     */
    "team-simple": {
      /**
       * Unique identifier of the team
       */
      id: number;
      node_id: string;
      /**
       * URL for the team
       */
      url: string;
      members_url: string;
      /**
       * Name of the team
       */
      name: string;
      /**
       * Description of the team
       */
      description: string | null;
      /**
       * Permission that the team will have for its repositories
       */
      permission: string;
      /**
       * The level of privacy this team should have
       */
      privacy?: string;
      html_url: string;
      repositories_url: string;
      slug: string;
      /**
       * Distinguished Name (DN) that team maps to within LDAP environment
       */
      ldap_dn?: string;
    } | null;
    /**
     * Groups of organization members that gives permissions on specified repositories.
     */
    team: {
      id: number;
      node_id: string;
      name: string;
      slug: string;
      description: string | null;
      privacy?: string;
      permission: string;
      url: string;
      html_url: string;
      members_url: string;
      repositories_url: string;
      parent?: components["schemas"]["team-simple"] | null;
    };
    /**
     * Org Membership
     */
    "org-membership": {
      url: string;
      state: string;
      role: string;
      organization_url: string;
      organization: components["schemas"]["organization-simple"];
      user: components["schemas"]["simple-user"] | null;
      permissions?: { can_create_repository: boolean };
    };
    /**
     * A migration.
     */
    migration: {
      id: number;
      owner: components["schemas"]["simple-user"] | null;
      guid: string;
      state: string;
      lock_repositories: boolean;
      exclude_attachments: boolean;
      repositories: components["schemas"]["repository"][];
      url: string;
      created_at: string;
      updated_at: string;
      node_id: string;
      archive_url?: string;
      exclude?: { [key: string]: any }[];
    };
    /**
     * Projects are a way to organize columns and cards of work.
     */
    project: {
      owner_url: string;
      url: string;
      html_url: string;
      columns_url: string;
      id: number;
      node_id: string;
      /**
       * Name of the project
       */
      name: string;
      /**
       * Body of the project
       */
      body: string | null;
      number: number;
      /**
       * State of the project; either 'open' or 'closed'
       */
      state: string;
      creator: components["schemas"]["simple-user"] | null;
      created_at: string;
      updated_at: string;
      /**
       * The baseline permission that all organization members have on this project. Only present if owner is an organization.
       */
      organization_permission?: "read" | "write" | "admin" | "none";
      /**
       * Whether or not this project can be seen by everyone. Only present if owner is an organization.
       */
      private?: boolean;
    };
    /**
     * External Groups to be mapped to a team for membership
     */
    "group-mapping": {
      /**
       * Array of groups to be mapped to this team
       */
      groups?: {
        /**
         * The ID of the group
         */
        group_id: string;
        /**
         * The name of the group
         */
        group_name: string;
        /**
         * a description of the group
         */
        group_description: string;
      }[];
      /**
       * The ID of the group
       */
      group_id?: string;
      /**
       * The name of the group
       */
      group_name?: string;
      /**
       * a description of the group
       */
      group_description?: string;
      /**
       * synchronization status for this group mapping
       */
      status?: string;
      /**
       * the time of the last sync for this group-mapping
       */
      synced_at?: string;
    };
    /**
     * Groups of organization members that gives permissions on specified repositories.
     */
    "team-full": {
      /**
       * Unique identifier of the team
       */
      id: number;
      node_id: string;
      /**
       * URL for the team
       */
      url: string;
      html_url: string;
      /**
       * Name of the team
       */
      name: string;
      slug: string;
      description: string | null;
      /**
       * The level of privacy this team should have
       */
      privacy?: "closed" | "secret";
      /**
       * Permission that the team will have for its repositories
       */
      permission: string;
      members_url: string;
      repositories_url: string;
      parent?: components["schemas"]["team-simple"] | null;
      members_count: number;
      repos_count: number;
      created_at: string;
      updated_at: string;
      organization: components["schemas"]["organization-full"];
      /**
       * Distinguished Name (DN) that team maps to within LDAP environment
       */
      ldap_dn?: string;
    };
    /**
     * A team discussion is a persistent record of a free-form conversation within a team.
     */
    "team-discussion": {
      author: components["schemas"]["simple-user"] | null;
      /**
       * The main text of the discussion.
       */
      body: string;
      body_html: string;
      /**
       * The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
       */
      body_version: string;
      comments_count: number;
      comments_url: string;
      created_at: string;
      last_edited_at: string | null;
      html_url: string;
      node_id: string;
      /**
       * The unique sequence number of a team discussion.
       */
      number: number;
      /**
       * Whether or not this discussion should be pinned for easy retrieval.
       */
      pinned: boolean;
      /**
       * Whether or not this discussion should be restricted to team members and organization administrators.
       */
      private: boolean;
      team_url: string;
      /**
       * The title of the discussion.
       */
      title: string;
      updated_at: string;
      url: string;
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * A reply to a discussion within a team.
     */
    "team-discussion-comment": {
      author: components["schemas"]["simple-user"] | null;
      /**
       * The main text of the comment.
       */
      body: string;
      body_html: string;
      /**
       * The current version of the body content. If provided, this update operation will be rejected if the given version does not match the latest version on the server.
       */
      body_version: string;
      created_at: string;
      last_edited_at: string | null;
      discussion_url: string;
      html_url: string;
      node_id: string;
      /**
       * The unique sequence number of a team discussion comment.
       */
      number: number;
      updated_at: string;
      url: string;
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Reactions to conversations provide a way to help people express their feelings more simply and effectively.
     */
    reaction: {
      id: number;
      node_id: string;
      user: components["schemas"]["simple-user"] | null;
      /**
       * The reaction to use
       */
      content:
        | "+1"
        | "-1"
        | "laugh"
        | "confused"
        | "heart"
        | "hooray"
        | "rocket"
        | "eyes";
      created_at: string;
    };
    /**
     * Team Membership
     */
    "team-membership": {
      url: string;
      /**
       * The role of the user in the team.
       */
      role: "member" | "maintainer";
      state: string;
    };
    /**
     * A team's access to a project.
     */
    "team-project": {
      owner_url: string;
      url: string;
      html_url: string;
      columns_url: string;
      id: number;
      node_id: string;
      name: string;
      body: string | null;
      number: number;
      state: string;
      creator: components["schemas"]["simple-user"];
      created_at: string;
      updated_at: string;
      /**
       * The organization permission for this project. Only present when owner is an organization.
       */
      organization_permission?: string;
      /**
       * Whether the project is private or not. Only present when owner is an organization.
       */
      private?: boolean;
      permissions: { read: boolean; write: boolean; admin: boolean };
    };
    /**
     * A team's access to a repository.
     */
    "team-repository": {
      /**
       * Unique identifier of the repository
       */
      id: number;
      node_id: string;
      /**
       * The name of the repository.
       */
      name: string;
      full_name: string;
      license: components["schemas"]["license-simple"] | null;
      forks: number;
      permissions?: {
        admin: boolean;
        pull: boolean;
        triage?: boolean;
        push: boolean;
        maintain?: boolean;
      };
      owner: components["schemas"]["simple-user"] | null;
      /**
       * Whether the repository is private or public.
       */
      private: boolean;
      html_url: string;
      description: string | null;
      fork: boolean;
      url: string;
      archive_url: string;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      contributors_url: string;
      deployments_url: string;
      downloads_url: string;
      events_url: string;
      forks_url: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url: string;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      languages_url: string;
      merges_url: string;
      milestones_url: string;
      notifications_url: string;
      pulls_url: string;
      releases_url: string;
      ssh_url: string;
      stargazers_url: string;
      statuses_url: string;
      subscribers_url: string;
      subscription_url: string;
      tags_url: string;
      teams_url: string;
      trees_url: string;
      clone_url: string;
      mirror_url: string | null;
      hooks_url: string;
      svn_url: string;
      homepage: string | null;
      language: string | null;
      forks_count: number;
      stargazers_count: number;
      watchers_count: number;
      size: number;
      /**
       * The default branch of the repository.
       */
      default_branch: string;
      open_issues_count: number;
      /**
       * Whether this repository acts as a template that can be used to generate new repositories.
       */
      is_template?: boolean;
      topics?: string[];
      /**
       * Whether issues are enabled.
       */
      has_issues: boolean;
      /**
       * Whether projects are enabled.
       */
      has_projects: boolean;
      /**
       * Whether the wiki is enabled.
       */
      has_wiki: boolean;
      has_pages: boolean;
      /**
       * Whether downloads are enabled.
       */
      has_downloads: boolean;
      /**
       * Whether the repository is archived.
       */
      archived: boolean;
      /**
       * Returns whether or not this repository disabled.
       */
      disabled: boolean;
      /**
       * The repository visibility: public, private, or internal.
       */
      visibility?: string;
      pushed_at: string | null;
      created_at: string | null;
      updated_at: string | null;
      /**
       * Whether to allow rebase merges for pull requests.
       */
      allow_rebase_merge?: boolean;
      template_repository?: components["schemas"]["repository"] | null;
      temp_clone_token?: string;
      /**
       * Whether to allow squash merges for pull requests.
       */
      allow_squash_merge?: boolean;
      /**
       * Whether to delete head branches when pull requests are merged
       */
      delete_branch_on_merge?: boolean;
      /**
       * Whether to allow merge commits for pull requests.
       */
      allow_merge_commit?: boolean;
      subscribers_count?: number;
      network_count?: number;
      open_issues: number;
      watchers: number;
      master_branch?: string;
    };
    /**
     * Project cards represent a scope of work.
     */
    "project-card": {
      url: string;
      /**
       * The project card's ID
       */
      id: number;
      node_id: string;
      note: string | null;
      creator: components["schemas"]["simple-user"] | null;
      created_at: string;
      updated_at: string;
      /**
       * Whether or not the card is archived
       */
      archived?: boolean;
      column_url: string;
      content_url?: string;
      project_url: string;
    };
    /**
     * Project columns contain cards of work.
     */
    "project-column": {
      url: string;
      project_url: string;
      cards_url: string;
      /**
       * The unique identifier of the project column
       */
      id: number;
      node_id: string;
      /**
       * Name of the project column
       */
      name: string;
      created_at: string;
      updated_at: string;
    };
    /**
     * Repository Collaborator Permission
     */
    "repository-collaborator-permission": {
      permission: string;
      user: components["schemas"]["simple-user"] | null;
    };
    "rate-limit": { limit: number; remaining: number; reset: number };
    /**
     * Rate Limit Overview
     */
    "rate-limit-overview": {
      resources: {
        core: components["schemas"]["rate-limit"];
        graphql?: components["schemas"]["rate-limit"];
        search: components["schemas"]["rate-limit"];
        source_import?: components["schemas"]["rate-limit"];
        integration_manifest?: components["schemas"]["rate-limit"];
        code_scanning_upload?: components["schemas"]["rate-limit"];
      };
      rate: components["schemas"]["rate-limit"];
    };
    /**
     * Full Repository
     */
    "full-repository": {
      id: number;
      node_id: string;
      name: string;
      full_name: string;
      owner: components["schemas"]["simple-user"] | null;
      private: boolean;
      html_url: string;
      description: string | null;
      fork: boolean;
      url: string;
      archive_url: string;
      assignees_url: string;
      blobs_url: string;
      branches_url: string;
      collaborators_url: string;
      comments_url: string;
      commits_url: string;
      compare_url: string;
      contents_url: string;
      contributors_url: string;
      deployments_url: string;
      downloads_url: string;
      events_url: string;
      forks_url: string;
      git_commits_url: string;
      git_refs_url: string;
      git_tags_url: string;
      git_url: string;
      issue_comment_url: string;
      issue_events_url: string;
      issues_url: string;
      keys_url: string;
      labels_url: string;
      languages_url: string;
      merges_url: string;
      milestones_url: string;
      notifications_url: string;
      pulls_url: string;
      releases_url: string;
      ssh_url: string;
      stargazers_url: string;
      statuses_url: string;
      subscribers_url: string;
      subscription_url: string;
      tags_url: string;
      teams_url: string;
      trees_url: string;
      clone_url: string;
      mirror_url: string | null;
      hooks_url: string;
      svn_url: string;
      homepage: string | null;
      language: string | null;
      forks_count: number;
      stargazers_count: number;
      watchers_count: number;
      size: number;
      default_branch: string;
      open_issues_count: number;
      is_template?: boolean;
      topics?: string[];
      has_issues: boolean;
      has_projects: boolean;
      has_wiki: boolean;
      has_pages: boolean;
      has_downloads: boolean;
      archived: boolean;
      /**
       * Returns whether or not this repository disabled.
       */
      disabled: boolean;
      /**
       * The repository visibility: public, private, or internal.
       */
      visibility?: string;
      pushed_at: string;
      created_at: string;
      updated_at: string;
      permissions?: { admin: boolean; pull: boolean; push: boolean };
      allow_rebase_merge?: boolean;
      template_repository?: components["schemas"]["repository"] | null;
      temp_clone_token?: string | null;
      allow_squash_merge?: boolean;
      delete_branch_on_merge?: boolean;
      allow_merge_commit?: boolean;
      subscribers_count: number;
      network_count: number;
      license: components["schemas"]["license-simple"] | null;
      organization?: components["schemas"]["simple-user"] | null;
      parent?: components["schemas"]["repository"];
      source?: components["schemas"]["repository"];
      forks: number;
      master_branch?: string;
      open_issues: number;
      watchers: number;
      /**
       * Whether anonymous git access is allowed.
       */
      anonymous_access_enabled?: boolean;
    };
    /**
     * An artifact
     */
    artifact: {
      id: number;
      node_id: string;
      /**
       * The name of the artifact.
       */
      name: string;
      /**
       * The size in bytes of the artifact.
       */
      size_in_bytes: number;
      url: string;
      archive_download_url: string;
      /**
       * Whether or not the artifact has expired.
       */
      expired: boolean;
      created_at: string | null;
      expires_at: string;
      updated_at: string | null;
    };
    /**
     * Information of a job execution in a workflow run
     */
    job: {
      /**
       * The id of the job.
       */
      id: number;
      /**
       * The id of the associated workflow run.
       */
      run_id: number;
      run_url: string;
      node_id: string;
      /**
       * The SHA of the commit that is being run.
       */
      head_sha: string;
      url: string;
      html_url: string | null;
      /**
       * The phase of the lifecycle that the job is currently in.
       */
      status: "queued" | "in_progress" | "completed";
      /**
       * The outcome of the job.
       */
      conclusion: string | null;
      /**
       * The time that the job started, in ISO 8601 format.
       */
      started_at: string;
      /**
       * The time that the job finished, in ISO 8601 format.
       */
      completed_at: string | null;
      /**
       * The name of the job.
       */
      name: string;
      /**
       * Steps in this job.
       */
      steps?: {
        /**
         * The phase of the lifecycle that the job is currently in.
         */
        status: "queued" | "in_progress" | "completed";
        /**
         * The outcome of the job.
         */
        conclusion: string | null;
        /**
         * The name of the job.
         */
        name: string;
        number: number;
        /**
         * The time that the step started, in ISO 8601 format.
         */
        started_at?: string | null;
        /**
         * The time that the job finished, in ISO 8601 format.
         */
        completed_at?: string | null;
      }[];
      check_run_url: string;
    };
    /**
     * Whether GitHub Actions is enabled on the repository.
     */
    "actions-enabled": boolean;
    "actions-repository-permissions": {
      enabled: components["schemas"]["actions-enabled"];
      allowed_actions: components["schemas"]["allowed-actions"];
      selected_actions_url?: components["schemas"]["selected-actions-url"];
    };
    "pull-request-minimal": {
      id: number;
      number: number;
      url: string;
      head: {
        ref: string;
        sha: string;
        repo: { id: number; url: string; name: string };
      };
      base: {
        ref: string;
        sha: string;
        repo: { id: number; url: string; name: string };
      };
    };
    /**
     * Simple Commit
     */
    "simple-commit": {
      id: string;
      tree_id: string;
      message: string;
      timestamp: string;
      author: { name: string; email: string } | null;
      committer: { name: string; email: string } | null;
    };
    /**
     * An invocation of a workflow
     */
    "workflow-run": {
      /**
       * The ID of the workflow run.
       */
      id: number;
      /**
       * The name of the workflow run.
       */
      name?: string;
      node_id: string;
      head_branch: string | null;
      /**
       * The SHA of the head commit that points to the version of the worflow being run.
       */
      head_sha: string;
      /**
       * The auto incrementing run number for the workflow run.
       */
      run_number: number;
      event: string;
      status: string | null;
      conclusion: string | null;
      /**
       * The ID of the parent workflow.
       */
      workflow_id: number;
      /**
       * The URL to the workflow run.
       */
      url: string;
      html_url: string;
      pull_requests: components["schemas"]["pull-request-minimal"][] | null;
      created_at: string;
      updated_at: string;
      /**
       * The URL to the jobs for the workflow run.
       */
      jobs_url: string;
      /**
       * The URL to download the logs for the workflow run.
       */
      logs_url: string;
      /**
       * The URL to the associated check suite.
       */
      check_suite_url: string;
      /**
       * The URL to the artifacts for the workflow run.
       */
      artifacts_url: string;
      /**
       * The URL to cancel the workflow run.
       */
      cancel_url: string;
      /**
       * The URL to rerun the workflow run.
       */
      rerun_url: string;
      /**
       * The URL to the workflow.
       */
      workflow_url: string;
      head_commit: components["schemas"]["simple-commit"];
      repository: components["schemas"]["minimal-repository"];
      head_repository: components["schemas"]["minimal-repository"];
      head_repository_id?: number;
    };
    /**
     * Workflow Run Usage
     */
    "workflow-run-usage": {
      billable: {
        UBUNTU?: { total_ms: number; jobs?: number };
        MACOS?: { total_ms: number; jobs?: number };
        WINDOWS?: { total_ms: number; jobs: number };
      };
      run_duration_ms: number;
    };
    /**
     * Set secrets for GitHub Actions.
     */
    "actions-secret": {
      /**
       * The name of the secret.
       */
      name: string;
      created_at: string;
      updated_at: string;
    };
    /**
     * A GitHub Actions workflow
     */
    workflow: {
      id: number;
      node_id: string;
      name: string;
      path: string;
      state: "active" | "deleted";
      created_at: string;
      updated_at: string;
      url: string;
      html_url: string;
      badge_url: string;
      deleted_at?: string;
    };
    /**
     * Workflow Usage
     */
    "workflow-usage": {
      billable: {
        UBUNTU?: { total_ms?: number };
        MACOS?: { total_ms?: number };
        WINDOWS?: { total_ms?: number };
      };
    };
    /**
     * Protected Branch Admin Enforced
     */
    "protected-branch-admin-enforced": { url: string; enabled: boolean };
    /**
     * Protected Branch Pull Request Review
     */
    "protected-branch-pull-request-review": {
      url?: string;
      dismissal_restrictions?: {
        /**
         * The list of users with review dismissal access.
         */
        users?: components["schemas"]["simple-user"][];
        /**
         * The list of teams with review dismissal access.
         */
        teams?: components["schemas"]["team"][];
        url?: string;
        users_url?: string;
        teams_url?: string;
      };
      dismiss_stale_reviews: boolean;
      require_code_owner_reviews: boolean;
      required_approving_review_count?: number;
    };
    /**
     * Branch Restriction Policy
     */
    "branch-restriction-policy": {
      url: string;
      users_url: string;
      teams_url: string;
      apps_url: string;
      users: {
        login?: string;
        id?: number;
        node_id?: string;
        avatar_url?: string;
        gravatar_id?: string;
        url?: string;
        html_url?: string;
        followers_url?: string;
        following_url?: string;
        gists_url?: string;
        starred_url?: string;
        subscriptions_url?: string;
        organizations_url?: string;
        repos_url?: string;
        events_url?: string;
        received_events_url?: string;
        type?: string;
        site_admin?: boolean;
      }[];
      teams: {
        id?: number;
        node_id?: string;
        url?: string;
        html_url?: string;
        name?: string;
        slug?: string;
        description?: string | null;
        privacy?: string;
        permission?: string;
        members_url?: string;
        repositories_url?: string;
        parent?: string | null;
      }[];
      apps: {
        id?: number;
        slug?: string;
        node_id?: string;
        owner?: {
          login?: string;
          id?: number;
          node_id?: string;
          url?: string;
          repos_url?: string;
          events_url?: string;
          hooks_url?: string;
          issues_url?: string;
          members_url?: string;
          public_members_url?: string;
          avatar_url?: string;
          description?: string;
          gravatar_id?: string;
          html_url?: string;
          followers_url?: string;
          following_url?: string;
          gists_url?: string;
          starred_url?: string;
          subscriptions_url?: string;
          organizations_url?: string;
          received_events_url?: string;
          type?: string;
        };
        name?: string;
        description?: string;
        external_url?: string;
        html_url?: string;
        created_at?: string;
        updated_at?: string;
        permissions?: {
          metadata?: string;
          contents?: string;
          issues?: string;
          single_file?: string;
        };
        events?: string[];
      }[];
    };
    /**
     * Branch Protection
     */
    "branch-protection": {
      url?: string;
      required_status_checks: {
        url?: string;
        enforcement_level: string;
        contexts: string[];
        contexts_url?: string;
      };
      enforce_admins?: components["schemas"]["protected-branch-admin-enforced"];
      required_pull_request_reviews?: components["schemas"]["protected-branch-pull-request-review"];
      restrictions?: components["schemas"]["branch-restriction-policy"];
      required_linear_history?: { enabled?: boolean };
      allow_force_pushes?: { enabled?: boolean };
      allow_deletions?: { enabled?: boolean };
      enabled: boolean;
      name?: string;
      protection_url?: string;
    };
    /**
     * Short Branch
     */
    "short-branch": {
      name: string;
      commit: { sha: string; url: string };
      protected: boolean;
      protection?: components["schemas"]["branch-protection"];
      protection_url?: string;
    };
    /**
     * Metaproperties for Git author/committer information.
     */
    "git-user": { name?: string; email?: string; date?: string };
    verification: {
      verified: boolean;
      reason: string;
      payload: string | null;
      signature: string | null;
    };
    /**
     * Commit
     */
    commit: {
      url: string;
      sha: string;
      node_id: string;
      html_url: string;
      comments_url: string;
      commit: {
        url: string;
        author: components["schemas"]["git-user"] | null;
        committer: components["schemas"]["git-user"] | null;
        message: string;
        comment_count: number;
        tree: { sha: string; url: string };
        verification?: components["schemas"]["verification"];
      };
      author: components["schemas"]["simple-user"] | null;
      committer: components["schemas"]["simple-user"] | null;
      parents: { sha: string; url: string; html_url?: string }[];
      stats?: { additions?: number; deletions?: number; total?: number };
      files?: {
        filename?: string;
        additions?: number;
        deletions?: number;
        changes?: number;
        status?: string;
        raw_url?: string;
        blob_url?: string;
        patch?: string;
        sha?: string;
        contents_url?: string;
        previous_filename?: string;
      }[];
    };
    /**
     * Branch With Protection
     */
    "branch-with-protection": {
      name: string;
      commit: components["schemas"]["commit"];
      _links: { html: string; self: string };
      protected: boolean;
      protection: components["schemas"]["branch-protection"];
      protection_url: string;
      pattern?: string;
      required_approving_review_count?: number;
    };
    /**
     * Status Check Policy
     */
    "status-check-policy": {
      url: string;
      strict: boolean;
      contexts: string[];
      contexts_url: string;
    };
    /**
     * Branch protections protect branches
     */
    "protected-branch": {
      url: string;
      required_status_checks?: components["schemas"]["status-check-policy"];
      required_pull_request_reviews?: {
        url: string;
        dismiss_stale_reviews?: boolean;
        require_code_owner_reviews?: boolean;
        required_approving_review_count?: number;
        dismissal_restrictions?: {
          url: string;
          users_url: string;
          teams_url: string;
          users: components["schemas"]["simple-user"][];
          teams: components["schemas"]["team"][];
        };
      };
      required_signatures?: { url: string; enabled: boolean };
      enforce_admins?: { url: string; enabled: boolean };
      required_linear_history?: { enabled: boolean };
      allow_force_pushes?: { enabled: boolean };
      allow_deletions?: { enabled: boolean };
      restrictions?: components["schemas"]["branch-restriction-policy"];
    };
    /**
     * A check performed on the code of a given code change
     */
    "check-run": {
      /**
       * The id of the check.
       */
      id: number;
      /**
       * The SHA of the commit that is being checked.
       */
      head_sha: string;
      node_id: string;
      external_id: string | null;
      url: string;
      html_url: string | null;
      details_url: string | null;
      /**
       * The phase of the lifecycle that the check is currently in.
       */
      status: "queued" | "in_progress" | "completed";
      conclusion:
        | (
            | "success"
            | "failure"
            | "neutral"
            | "cancelled"
            | "skipped"
            | "timed_out"
            | "action_required"
          )
        | null;
      started_at: string | null;
      completed_at: string | null;
      output: {
        title: string | null;
        summary: string | null;
        text: string | null;
        annotations_count: number;
        annotations_url: string;
      };
      /**
       * The name of the check.
       */
      name: string;
      check_suite: { id: number } | null;
      app: components["schemas"]["integration"] | null;
      pull_requests: components["schemas"]["pull-request-minimal"][];
    };
    /**
     * Check Annotation
     */
    "check-annotation": {
      path: string;
      start_line: number;
      end_line: number;
      start_column: number | null;
      end_column: number | null;
      annotation_level: string | null;
      title: string | null;
      message: string | null;
      raw_details: string | null;
      blob_href: string;
    };
    /**
     * A suite of checks performed on the code of a given code change
     */
    "check-suite": {
      id: number;
      node_id: string;
      head_branch: string | null;
      /**
       * The SHA of the head commit that is being checked.
       */
      head_sha: string;
      status: ("queued" | "in_progress" | "completed") | null;
      conclusion:
        | (
            | "success"
            | "failure"
            | "neutral"
            | "cancelled"
            | "skipped"
            | "timed_out"
            | "action_required"
          )
        | null;
      url: string | null;
      before: string | null;
      after: string | null;
      pull_requests: components["schemas"]["pull-request-minimal"][] | null;
      app: components["schemas"]["integration"] | null;
      repository: components["schemas"]["minimal-repository"];
      created_at: string | null;
      updated_at: string | null;
      head_commit: components["schemas"]["simple-commit"];
      latest_check_runs_count: number;
      check_runs_url: string;
    };
    /**
     * Check suite configuration preferences for a repository.
     */
    "check-suite-preference": {
      preferences: {
        auto_trigger_checks?: { app_id: number; setting: boolean }[];
      };
      repository: components["schemas"]["repository"];
    };
    /**
     * State of a code scanning alert.
     */
    "code-scanning-alert-state": "open" | "dismissed" | "fixed";
    /**
     * The full Git reference, formatted as `refs/heads/<branch name>`.
     */
    "code-scanning-alert-ref": string;
    /**
     * The security alert number.
     */
    "alert-number": number;
    /**
     * The time that the alert was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    "alert-created-at": string;
    /**
     * The REST API URL of the alert resource.
     */
    "alert-url": string;
    /**
     * The GitHub URL of the alert resource.
     */
    "alert-html-url": string;
    /**
     * The time that the alert was dismissed in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    "code-scanning-alert-dismissed-at": string | null;
    /**
     * **Required when the state is dismissed.** The reason for dismissing or closing the alert. Can be one of: `false positive`, `won't fix`, and `used in tests`.
     */
    "code-scanning-alert-dismissed-reason": string | null;
    "code-scanning-alert-rule": {
      /**
       * A unique identifier for the rule used to detect the alert.
       */
      id?: string | null;
      /**
       * The severity of the alert.
       */
      severity?: ("none" | "note" | "warning" | "error") | null;
      /**
       * A short description of the rule used to detect the alert.
       */
      description?: string;
    };
    /**
     * The name of the tool used to generate the code scanning analysis alert.
     */
    "code-scanning-analysis-tool-name": string;
    "code-scanning-analysis-tool": {
      name?: components["schemas"]["code-scanning-analysis-tool-name"];
      /**
       * The version of the tool used to detect the alert.
       */
      version?: string | null;
    };
    "code-scanning-alert-code-scanning-alert-items": {
      number: components["schemas"]["alert-number"];
      created_at: components["schemas"]["alert-created-at"];
      url: components["schemas"]["alert-url"];
      html_url: components["schemas"]["alert-html-url"];
      state: components["schemas"]["code-scanning-alert-state"];
      dismissed_by: components["schemas"]["simple-user"];
      dismissed_at: components["schemas"]["code-scanning-alert-dismissed-at"];
      dismissed_reason: components["schemas"]["code-scanning-alert-dismissed-reason"];
      rule: components["schemas"]["code-scanning-alert-rule"];
      tool: components["schemas"]["code-scanning-analysis-tool"];
    };
    /**
     * Identifies the configuration under which the analysis was executed. For example, in GitHub Actions this includes the workflow filename and job name.
     */
    "code-scanning-analysis-analysis-key": string;
    /**
     * Identifies the variable values associated with the environment in which the analysis that generated this alert instance was performed, such as the language that was analyzed.
     */
    "code-scanning-alert-environment": string;
    "code-scanning-alert-instances":
      | {
          ref?: components["schemas"]["code-scanning-alert-ref"];
          analysis_key?: components["schemas"]["code-scanning-analysis-analysis-key"];
          environment?: components["schemas"]["code-scanning-alert-environment"];
          matrix_vars?: string | null;
          state?: components["schemas"]["code-scanning-alert-state"];
        }[]
      | null;
    "code-scanning-alert-code-scanning-alert": {
      number: components["schemas"]["alert-number"];
      created_at: components["schemas"]["alert-created-at"];
      url: components["schemas"]["alert-url"];
      html_url: components["schemas"]["alert-html-url"];
      instances: components["schemas"]["code-scanning-alert-instances"];
      state: components["schemas"]["code-scanning-alert-state"];
      dismissed_by: components["schemas"]["simple-user"];
      dismissed_at: components["schemas"]["code-scanning-alert-dismissed-at"];
      dismissed_reason: components["schemas"]["code-scanning-alert-dismissed-reason"];
      rule: components["schemas"]["code-scanning-alert-rule"];
      tool: components["schemas"]["code-scanning-analysis-tool"];
    };
    /**
     * Sets the state of the code scanning alert. Can be one of `open` or `dismissed`. You must provide `dismissed_reason` when you set the state to `dismissed`.
     */
    "code-scanning-alert-set-state": "open" | "dismissed";
    /**
     * The full Git reference of the code scanning analysis file, formatted as `refs/heads/<branch name>`.
     */
    "code-scanning-analysis-ref": string;
    /**
     * The commit SHA of the code scanning analysis file.
     */
    "code-scanning-analysis-commit-sha": string;
    /**
     * The time that the analysis was created in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
     */
    "code-scanning-analysis-created-at": string;
    /**
     * Identifies the variable values associated with the environment in which this analysis was performed.
     */
    "code-scanning-analysis-environment": string;
    "code-scanning-analysis-code-scanning-analysis": {
      commit_sha: components["schemas"]["code-scanning-analysis-commit-sha"];
      ref: components["schemas"]["code-scanning-analysis-ref"];
      analysis_key: components["schemas"]["code-scanning-analysis-analysis-key"];
      created_at: components["schemas"]["code-scanning-analysis-created-at"];
      tool_name: components["schemas"]["code-scanning-analysis-tool-name"];
      error: string;
      environment: components["schemas"]["code-scanning-analysis-environment"];
    };
    /**
     * A Base64 string representing the SARIF file to upload. You must first compress your SARIF file using [`gzip`](http://www.gnu.org/software/gzip/manual/gzip.html) and then translate the contents of the file into a Base64 encoding string.
     */
    "code-scanning-analysis-sarif-file": string;
    /**
     * Collaborator
     */
    collaborator: {
      login: string;
      id: number;
      node_id: string;
      avatar_url: string;
      gravatar_id: string | null;
      url: string;
      html_url: string;
      followers_url: string;
      following_url: string;
      gists_url: string;
      starred_url: string;
      subscriptions_url: string;
      organizations_url: string;
      repos_url: string;
      events_url: string;
      received_events_url: string;
      type: string;
      site_admin: boolean;
      permissions?: { pull: boolean; push: boolean; admin: boolean };
    };
    /**
     * Repository invitations let you manage who you collaborate with.
     */
    "repository-invitation": {
      /**
       * Unique identifier of the repository invitation.
       */
      id: number;
      repository: components["schemas"]["minimal-repository"];
      invitee: components["schemas"]["simple-user"] | null;
      inviter: components["schemas"]["simple-user"] | null;
      /**
       * The permission associated with the invitation.
       */
      permissions: "read" | "write" | "admin";
      created_at: string;
      /**
       * Whether or not the invitation has expired
       */
      expired?: boolean;
      /**
       * URL for the repository invitation
       */
      url: string;
      html_url: string;
      node_id: string;
    };
    /**
     * Commit Comment
     */
    "commit-comment": {
      html_url: string;
      url: string;
      id: number;
      node_id: string;
      body: string;
      path: string | null;
      position: number | null;
      line: number | null;
      commit_id: string;
      user: components["schemas"]["simple-user"] | null;
      created_at: string;
      updated_at: string;
      author_association: string;
      reactions?: components["schemas"]["reaction-rollup"];
    };
    /**
     * Scim Error
     */
    "scim-error": {
      message?: string | null;
      documentation_url?: string | null;
      detail?: string | null;
      status?: number;
      scimType?: string | null;
      schemas?: string[];
    };
    /**
     * Branch Short
     */
    "branch-short": {
      name: string;
      commit: { sha: string; url: string };
      protected: boolean;
    };
    /**
     * Hypermedia Link
     */
    link: { href: string };
    /**
     * Pull Request Simple
     */
    "pull-request-simple": {
      url: string;
      id: number;
      node_id: string;
      html_url: string;
      diff_url: string;
      patch_url: string;
      issue_url: string;
      commits_url: string;
      review_comments_url: string;
      review_comment_url: string;
      comments_url: string;
      statuses_url: string;
      number: number;
      state: string;
      locked: boolean;
      title: string;
      user: components["schemas"]["simple-user"] | null;
      body: string | null;
      labels: {
        id?: number;
        node_id?: string;
        url?: string;
        name?: string;
        description?: string;
        color?: string;
        default?: boolean;
      }[];
      milestone: components["schemas"]["milestone"] | null;
      active_lock_reason?: string | null;
      created_at: string;
      updated_at: string;
      closed_at: string | null;
      merged_at: string | null;
      merge_commit_sha: string | null;
      assignee: components["schemas"]["simple-user"] | null;
      assignees?: components["schemas"]["simple-user"][] | null;
      requested_reviewers?: components["schemas"]["simple-user"][] | null;
      requested_teams?: components["schemas"]["team-simple"][] | null;
      head: {
        label: string;
        ref: string;
        repo: components["schemas"]["repository"];
        sha: string;
        user: components["schemas"]["simple-user"] | null;
      };
      base: {
        label: string;
        ref: string;
        repo: components["schemas"]["repository"];
        sha: string;
        user: components["schemas"]["simple-user"] | null;
      };
      _links: {
        comments: components["schemas"]["link"];
        commits: components["schemas"]["link"];
        statuses: components["schemas"]["link"];
        html: components["schemas"]["link"];
        issue: components["schemas"]["link"];
        review_comments: components["schemas"]["link"];
        review_comment: components["schemas"]["link"];
        self: components["schemas"]["link"];
      };
      author_association: string;
      /**
       * Indicates whether or not the pull request is a draft.
       */
      draft?: boolean;
    };
    "simple-commit-status": {
      description: string | null;
      id: number;
      node_id: string;
      state: string;
      context: string;
      target_url: string;
      required?: boolean | null;
      avatar_url: string | null;
      url: string;
      created_at: string;
      updated_at: string;
    };
    /**
     * Combined Commit Status
     */
    "combined-commit-status": {
      state: string;
      statuses: components["schemas"]["simple-commit-status"][];
      sha: string;
      total_count: number;
      repository: components["schemas"]["minimal-repository"];
      commit_url: string;
      url: string;
    };
    /**
     * The status of a commit.
     */
    status: {
      url: string;
      avatar_url: string | null;
      id: number;
      node_id: string;
      state: string;
      description: string;
      target_url: string;
      context: string;
      created_at: string;
      updated_at: string;
      creator: components["schemas"]["simple-user"];
    };
    /**
     * Code of Conduct Simple
     */
    "code-of-conduct-simple": {
      url: string;
      key: string;
      name: string;
      html_url: string | null;
    };
    "community-health-file": { url: string; html_url: string };
    /**
     * Community Profile
     */
    "community-profile": {
      health_percentage: number;
      description: string | null;
      documentation: string | null;
      files: {
        code_of_conduct: components["schemas"]["code-of-conduct-simple"] | null;
        license: components["schemas"]["license-simple"] | null;
        contributing: components["schemas"]["community-health-file"] | null;
        readme: components["schemas"]["community-health-file"] | null;
        issue_template: components["schemas"]["community-health-file"] | null;
        pull_request_template:
          | components["schemas"]["community-health-file"]
          | null;
      };
      updated_at: string | null;
      content_reports_enabled?: boolean;
    };
    /**
     * Diff Entry
     */
    "diff-entry": {
      sha: string;
      filename: string;
      status: string;
      additions: number;
      deletions: number;
      changes: number;
      blob_url: string;
      raw_url: string;
      contents_url: string;
      patch?: string;
      previous_filename?: string;
    };
    /**
     * Commit Comparison
     */
    "commit-comparison": {
      url: string;
      html_url: string;
      permalink_url: string;
      diff_url: string;
      patch_url: string;
      base_commit: components["schemas"]["commit"];
      merge_base_commit: components["schemas"]["commit"];
      status: "diverged" | "ahead" | "behind" | "identical";
      ahead_by: number;
      behind_by: number;
      total_commits: number;
      commits: components["schemas"]["commit"][];
      files: components["schemas"]["diff-entry"][];
    };
    /**
     * Content Tree
     */
    "content-tree": {
      type: string;
      size: number;
      name: string;
      path: string;
      sha: string;
      url: string;
      git_url: string | null;
      html_url: string | null;
      download_url: string | null;
      entries?: {
        type: string;
        size: number;
        name: string;
        path: string;
        content?: string;
        sha: string;
        url: string;
        git_url: string | null;
        html_url: string | null;
        download_url: string | null;
        _links: { git: string | null; html: string | null; self: string };
      }[];
      _links: { git: string | null; html: string | null; self: string };
    };
    /**
     * A list of directory items
     */
    "content-directory": {
      type: string;
      size: number;
      name: string;
      path: string;
      content?: string;
      sha: string;
      url: string;
      git_url: string | null;
      html_url: string | null;
      download_url: string | null;
      _links: { git: string | null; html: string | null; self: string };
    }[];
    /**
     * Content File
     */
    "content-file": {
      type: string;
      encoding: string;
      size: number;
      name: string;
      path: string;
      content: string;
      sha: string;
      url: string;
      git_url: string | null;
      html_url: string | null;
      download_url: string | null;
      _links: { git: string | null; html: string | null; self: string };
      target?: string;
      submodule_git_url?: string;
    };
    /**
     * An object describing a symlink
     */
    "content-symlink": {
      type: string;
      target: string;
      size: number;
      name: string;
      path: string;
      sha: string;
      url: string;
      git_url: string | null;
      html_url: string | null;
      download_url: string | null;
      _links: { git: string | null; html: string | null; self: string };
    };
    /**
     * An object describing a symlink
     */
    "content-submodule": {
      type: string;
      submodule_git_url: string;
      size: number;
      name: string;
      path: string;
      sha: string;
      url: string;
      git_url: string | null;
      html_url: string | null;
      download_url: string | null;
      _links: { git: string | null; html: string | null; self: string };
    };
    /**
     * File Commit
     */
    "file-commit": {
      content: {
        name?: string;
        path?: string;
        sha?: string;
        size?: number;
        url?: string;
        html_url?: string;
        git_url?: string;
        download_url?: string;
        type?: string;
        _links?: { self?: string; git?: string; html?: string };
      } | null;
      commit: {
        sha?: string;
        node_id?: string;
        url?: string;
        html_url?: string;
        author?: { date?: string; name?: string; email?: string };
        committer?: { date?: string; name?: string; email?: string };
        message?: string;
        tree?: { url?: string; sha?: string };
        parents?: { url?: string; html_url?: string; sha?: string }[];
        verification?: {
          verified?: boolean;
          reason?: string;
          signature?: string | null;
          payload?: string | null;
        };
      };
    };
    /**
     * Contributor
     */
    contributor: {
      login?: string;
      id?: number;
      node_id?: string;
      avatar_url?: string;
      gravatar_id?: string | null;
      url?: string;
      html_url?: string;
      followers_url?: string;
      following_url?: string;
      gists_url?: string;
      starred_url?: string;
      subscriptions_url?: string;
      organizations_url?: string;
      repos_url?: string;
      events_url?: string;
      received_events_url?: string;
      type: string;
      site_admin?: boolean;
      contributions: number;
      email?: string;
      name?: string;
    };
    /**
     * A request for a specific ref(branch,sha,tag) to be deployed
     */
    deployment: {
      url: string;
      /**
       * Unique identifier of the deployment
       */
      id: number;
      node_id: string;
      sha: string;
      /**
       * The ref to deploy. This can be a branch, tag, or sha.
       */
      ref: string;
      /**
       * Parameter to specify a task to execute
       */
      task: string;
      payload: { [key: string]: any };
      original_environment?: string;
      /**
       * Name for the target deployment environment.
       */
      environment: string;
      description: string | null;
      creator: components["schemas"]["simple-user"] | null;
      created_at: string;
      updated_at: string;
      statuses_url: string;
      repository_url: string;
      /**
       * Specifies if the given environment is will no longer exist at some point in the future. Default: false.
       */
      transient_environment?: boolean;
      /**
       * Specifies if the given environment is one that end-users directly interact with. Default: false.
       */
      production_environment?: boolean;
      performed_via_github_app?: components["schemas"]["integration"] | null;
    };
    /**
     * The status of a deployment.
     */
    "deployment-status": {
      url: string;
      id: number;
      node_id: string;
      /**
       * The state of the status.
       */
      state:
        | "error"
        | "failure"
        | "inactive"
        | "pending"
        | "success"
        | "queued"
        | "in_progress";
      creator: components["schemas"]["simple-user"] | null;
      /**
       * A short description of the status.
       */
      description: string;
      /**
       * The environment of the deployment that the status is for.
       */
      environment?: string;
      /**
       * Deprecated: the URL to associate with this status.
       */
      target_url: string;
      created_at: string;
      updated_at: string;
      deployment_url: string;
      repository_url: string;
      /**
       * The URL for accessing your environment.
       */
      environment_url?: string;
      /**
       * The URL to associate with this status.
       */
      log_url?: string;
      performed_via_github_app?: components["schemas"]["integration"] | null;
    };
    /**
     * Short Blob
     */
    "short-blob": { url: string; sha: string };
    /**
     * Blob
     */
    blob: {
      content: string;
      encoding: string;
      url: string;
      sha: string;
      size: number | null;
      node_id: string;
      highlighted_content?: string;
    };
    /**
     * Low-level Git commit operations within a repository
     */
    "git-commit": {
      /**
       * SHA for the commit
       */
      sha: string;
      node_id: string;
      url: string;
      /**
       * Identifying information for the git-user
       */
      author: {
        /**
         * Timestamp of the commit
         */
        date: string;
        /**
         * Git email address of the user
         */
        email: string;
        /**
         * Name of the git user
         */
        name: string;
      };
      /**
       * Identifying information for the git-user
       */
      committer: {
        /**
         * Timestamp of the commit
         */
        date: string;
        /**
         * Git email address of the user
         */
        email: string;
        /**
         * Name of the git user
         */
        name: string;
      };
      /**
       * Message describing the purpose of the commit
       */
      message: string;
      tree: {
        /**
         * SHA for the commit
         */
        sha: string;
        url: string;
      };
      parents: {
        /**
         * SHA for the commit
         */
        sha: string;
        url: string;
        html_url: string;
      }[];
      verification: {
        verified: boolean;
        reason: string;
        signature: string | null;
        payload: string | null;
      };
      html_url: string;
    };
    /**
     * Git references within a repository
     */
    "git-ref": {
      ref: string;
      node_id: string;
      url: string;
      object: {
        type: string;
        /**
         * SHA for the reference
         */
        sha: string;
        url: string;
      };
    };
    /**
     * Metadata for a Git tag
     */
    "git-tag": {
      node_id: string;
      /**
       * Name of the tag
       */
      tag: string;
      sha: string;
      /**
       * URL for the tag
       */
      url: string;
      /**
       * Message describing the purpose of the tag
       */
      message: string;
      tagger: { date: string; email: string; name: string };
      object: { sha: string; type: string; url: string };
      verification?: components["schemas"]["verification"];
    };
    /**
     * The hierarchy between files in a Git repository.
     */
    "git-tree": {
      sha: string;
      url: string;
      truncated: boolean;
      /**
       * Objects specifying a tree structure
       */
      tree: {
        path?: string;
        mode?: string;
        type?: string;
        sha?: string;
        size?: number;
        url?: string;
      }[];
    };
    "hook-response": {
      code: number | null;
      status: string | null;
      message: string | null;
    };
    /**
     * Webhooks for repositories.
     */
    hook: {
      type: string;
      /**
       * Unique identifier of the webhook.
       */
      id: number;
      /**
       * The name of a valid service, use 'web' for a webhook.
       */
      name: string;
      /**
       * Determines whether the hook is actually triggered on pushes.
       */
      active: boolean;
      /**
       * Determines what events the hook is triggered for. Default: ['push'].
       */
      events: string[];
      config: {
        email?: string;
        password?: string;
        room?: string;
        subdomain?: string;
        url?: components["schemas"]["webhook-config-url"];
        insecure_ssl?: components["schemas"]["webhook-config-insecure-ssl"];
        content_type?: components["schemas"]["webhook-config-content-type"];
        digest?: string;
        secret?: components["schemas"]["webhook-config-secret"];
        token?: string;
      };
      updated_at: string;
      created_at: string;
      url: string;
      test_url: string;
      ping_url: string;
      last_response: components["schemas"]["hook-response"];
    };
    /**
     * A repository import from an external source.
     */
    import: {
      vcs: string | null;
      use_lfs?: string;
      /**
       * The URL of the originating repository.
       */
      vcs_url: string;
      svc_root?: string;
      tfvc_project?: string;
      status:
        | "auth"
        | "error"
        | "none"
        | "detecting"
        | "choose"
        | "auth_failed"
        | "importing"
        | "mapping"
        | "waiting_to_push"
        | "pushing"
        | "complete"
        | "setup"
        | "unknown"
        | "detection_found_multiple"
        | "detection_found_nothing"
        | "detection_needs_auth";
      status_text?: string | null;
      failed_step?: string | null;
      error_message?: string | null;
      import_percent?: number | null;
      commit_count?: number | null;
      push_percent?: number | null;
      has_large_files?: boolean;
      large_files_size?: number;
      large_files_count?: number;
      project_choices?: {
        vcs?: string;
        tfvc_project?: string;
        human_name?: string;
      }[];
      message?: string;
      authors_count?: number | null;
      url: string;
      html_url: string;
      authors_url: string;
      repository_url: string;
      svn_root?: string;
    };
    /**
     * Porter Author
     */
    "porter-author": {
      id: number;
      remote_id: string;
      remote_name: string;
      email: string;
      name: string;
      url: string;
      import_url: string;
    };
    /**
     * Porter Large File
     */
    "porter-large-file": {
      ref_name: string;
      path: string;
      oid: string;
      size: number;
    };
    /**
     * Issue Event Label
     */
    "issue-event-label": { name: string | null; color: string | null };
    "issue-event-dismissed-review": {
      state: string;
      review_id: number;
      dismissal_message: string | null;
      dismissal_commit_id?: string | null;
    };
    /**
     * Issue Event Milestone
     */
    "issue-event-milestone": { title: string };
    /**
     * Issue Event Project Card
     */
    "issue-event-project-card": {
      url: string;
      id: number;
      project_url: string;
      project_id: number;
      column_name: string;
      previous_column_name?: string;
    };
    /**
     * Issue Event Rename
     */
    "issue-event-rename": { from: string; to: string };
    /**
     * Issue Event
     */
    "issue-event": {
      id: number;
      node_id: string;
      url: string;
      actor: components["schemas"]["simple-user"] | null;
      event: string;
      commit_id: string | null;
      commit_url: string | null;
      created_at: string;
      issue?: components["schemas"]["issue-simple"];
      label?: components["schemas"]["issue-event-label"];
      assignee?: components["schemas"]["simple-user"] | null;
      assigner?: components["schemas"]["simple-user"] | null;
      review_requester?: components["schemas"]["simple-user"] | null;
      requested_reviewer?: components["schemas"]["simple-user"] | null;
      requested_team?: components["schemas"]["team"];
      dismissed_review?: components["schemas"]["issue-event-dismissed-review"];
      milestone?: components["schemas"]["issue-event-milestone"];
      project_card?: components["schemas"]["issue-event-project-card"];
      rename?: components["schemas"]["issue-event-rename"];
      author_association?: string;
      lock_reason?: string | null;
    };
    /**
     * Issue Event for Issue
     */
    "issue-event-for-issue": {
      id?: number;
      node_id?: string;
      url?: string;
      actor?: components["schemas"]["simple-user"];
      event?: string;
      commit_id?: string | null;
      commit_url?: string | null;
      created_at?: string;
      sha?: string;
      html_url?: string;
      message?: string;
      issue_url?: string;
      updated_at?: string;
      author_association?: string;
      body?: string;
      lock_reason?: string;
      submitted_at?: string;
      state?: string;
      pull_request_url?: string;
      body_html?: string;
      body_text?: string;
    };
    /**
     * An SSH key granting access to a single repository.
     */
    "deploy-key": {
      id: number;
      key: string;
      url: string;
      title: string;
      verified: boolean;
      created_at: string;
      read_only: boolean;
    };
    /**
     * Language
     */
    language: { [key: string]: number };
    /**
     * License Content
     */
    "license-content": {
      name: string;
      path: string;
      sha: string;
      size: number;
      url: string;
      html_url: string | null;
      git_url: string | null;
      download_url: string | null;
      type: string;
      content: string;
      encoding: string;
      _links: { git: string | null; html: string | null; self: string };
      license: components["schemas"]["license-simple"] | null;
    };
    "pages-source-hash": { branch: string; path: string };
    /**
     * The configuration for GitHub Pages for a repository.
     */
    page: {
      /**
       * The API address for accessing this Page resource.
       */
      url: string;
      /**
       * The status of the most recent build of the Page.
       */
      status: ("built" | "building" | "errored") | null;
      /**
       * The Pages site's custom domain
       */
      cname: string | null;
      /**
       * Whether the Page has a custom 404 page.
       */
      custom_404: boolean;
      /**
       * The web address the Page can be accessed from.
       */
      html_url?: string;
      source?: components["schemas"]["pages-source-hash"];
    };
    /**
     * Page Build
     */
    "page-build": {
      url: string;
      status: string;
      error: { message: string | null };
      pusher: components["schemas"]["simple-user"] | null;
      commit: string;
      duration: number;
      created_at: string;
      updated_at: string;
    };
    /**
     * Page Build Status
     */
    "page-build-status": { url: string; status: string };
    /**
     * Pull requests let you tell others about changes you've pushed to a repository on GitHub. Once a pull request is sent, interested parties can review the set of changes, discuss potential modifications, and even push follow-up commits if necessary.
     */
    "pull-request": {
      url: string;
      id: number;
      node_id: string;
      html_url: string;
      diff_url: string;
      patch_url: string;
      issue_url: string;
      commits_url: string;
      review_comments_url: string;
      review_comment_url: string;
      comments_url: string;
      statuses_url: string;
      /**
       * Number uniquely identifying the pull request within its repository.
       */
      number: number;
      /**
       * State of this Pull Request. Either `open` or `closed`.
       */
      state: "open" | "closed";
      locked: boolean;
      /**
       * The title of the pull request.
       */
      title: string;
      user: components["schemas"]["simple-user"] | null;
      body: string | null;
      labels: {
        id?: number;
        node_id?: string;
        url?: string;
        name?: string;
        description?: string | null;
        color?: string;
        default?: boolean;
      }[];
      milestone: components["schemas"]["milestone"] | null;
      active_lock_reason?: string | null;
      created_at: string;
      updated_at: string;
      closed_at: string | null;
      merged_at: string | null;
      merge_commit_sha: string | null;
      assignee: components["schemas"]["simple-user"] | null;
      assignees?: components["schemas"]["simple-user"][] | null;
      requested_reviewers?: components["schemas"]["simple-user"][] | null;
      requested_teams?: components["schemas"]["team-simple"][] | null;
      head: {
        label: string;
        ref: string;
        repo: {
          archive_url: string;
          assignees_url: string;
          blobs_url: string;
          branches_url: string;
          collaborators_url: string;
          comments_url: string;
          commits_url: string;
          compare_url: string;
          contents_url: string;
          contributors_url: string;
          deployments_url: string;
          description: string | null;
          downloads_url: string;
          events_url: string;
          fork: boolean;
          forks_url: string;
          full_name: string;
          git_commits_url: string;
          git_refs_url: string;
          git_tags_url: string;
          hooks_url: string;
          html_url: string;
          id: number;
          node_id: string;
          issue_comment_url: string;
          issue_events_url: string;
          issues_url: string;
          keys_url: string;
          labels_url: string;
          languages_url: string;
          merges_url: string;
          milestones_url: string;
          name: string;
          notifications_url: string;
          owner: {
            avatar_url: string;
            events_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            gravatar_id: string | null;
            html_url: string;
            id: number;
            node_id: string;
            login: string;
            organizations_url: string;
            received_events_url: string;
            repos_url: string;
            site_admin: boolean;
            starred_url: string;
            subscriptions_url: string;
            type: string;
            url: string;
          };
          private: boolean;
          pulls_url: string;
          releases_url: string;
          stargazers_url: string;
          statuses_url: string;
          subscribers_url: string;
          subscription_url: string;
          tags_url: string;
          teams_url: string;
          trees_url: string;
          url: string;
          clone_url: string;
          default_branch: string;
          forks: number;
          forks_count: number;
          git_url: string;
          has_downloads: boolean;
          has_issues: boolean;
          has_projects: boolean;
          has_wiki: boolean;
          has_pages: boolean;
          homepage: string | null;
          language: string | null;
          master_branch?: string;
          archived: boolean;
          disabled: boolean;
          mirror_url: string | null;
          open_issues: number;
          open_issues_count: number;
          permissions?: { admin: boolean; pull: boolean; push: boolean };
          temp_clone_token?: string;
          allow_merge_commit?: boolean;
          allow_squash_merge?: boolean;
          allow_rebase_merge?: boolean;
          license: {
            key: string;
            name: string;
            url: string | null;
            spdx_id: string | null;
            node_id: string;
          } | null;
          pushed_at: string;
          size: number;
          ssh_url: string;
          stargazers_count: number;
          svn_url: string;
          topics?: string[];
          watchers: number;
          watchers_count: number;
          created_at: string;
          updated_at: string;
        };
        sha: string;
        user: {
          avatar_url: string;
          events_url: string;
          followers_url: string;
          following_url: string;
          gists_url: string;
          gravatar_id: string | null;
          html_url: string;
          id: number;
          node_id: string;
          login: string;
          organizations_url: string;
          received_events_url: string;
          repos_url: string;
          site_admin: boolean;
          starred_url: string;
          subscriptions_url: string;
          type: string;
          url: string;
        };
      };
      base: {
        label: string;
        ref: string;
        repo: {
          archive_url: string;
          assignees_url: string;
          blobs_url: string;
          branches_url: string;
          collaborators_url: string;
          comments_url: string;
          commits_url: string;
          compare_url: string;
          contents_url: string;
          contributors_url: string;
          deployments_url: string;
          description: string | null;
          downloads_url: string;
          events_url: string;
          fork: boolean;
          forks_url: string;
          full_name: string;
          git_commits_url: string;
          git_refs_url: string;
          git_tags_url: string;
          hooks_url: string;
          html_url: string;
          id: number;
          node_id: string;
          issue_comment_url: string;
          issue_events_url: string;
          issues_url: string;
          keys_url: string;
          labels_url: string;
          languages_url: string;
          merges_url: string;
          milestones_url: string;
          name: string;
          notifications_url: string;
          owner: {
            avatar_url: string;
            events_url: string;
            followers_url: string;
            following_url: string;
            gists_url: string;
            gravatar_id: string | null;
            html_url: string;
            id: number;
            node_id: string;
            login: string;
            organizations_url: string;
            received_events_url: string;
            repos_url: string;
            site_admin: boolean;
            starred_url: string;
            subscriptions_url: string;
            type: string;
            url: string;
          };
          private: boolean;
          pulls_url: string;
          releases_url: string;
          stargazers_url: string;
          statuses_url: string;
          subscribers_url: string;
          subscription_url: string;
          tags_url: string;
          teams_url: string;
          trees_url: string;
          url: string;
          clone_url: string;
          default_branch: string;
          forks: number;
          forks_count: number;
          git_url: string;
          has_downloads: boolean;
          has_issues: boolean;
          has_projects: boolean;
          has_wiki: boolean;
          has_pages: boolean;
          homepage: string | null;
          language: string | null;
          master_branch?: string;
          archived: boolean;
          disabled: boolean;
          mirror_url: string | null;
          open_issues: number;
          open_issues_count: number;
          permissions?: { admin: boolean; pull: boolean; push: boolean };
          temp_clone_token?: string;
          allow_merge_commit?: boolean;
          allow_squash_merge?: boolean;
          allow_rebase_merge?: boolean;
          license: components["schemas"]["license-simple"] | null;
          pushed_at: string;
          size: number;
          ssh_url: string;
          stargazers_count: number;
          svn_url: string;
          topics?: string[];
          watchers: number;
          watchers_count: number;
          created_at: string;
          updated_at: string;
        };
        sha: string;
        user: {
          avatar_url: string;
          events_url: string;
          followers_url: string;
          following_url: string;
          gists_url: string;
          gravatar_id: string | null;
          html_url: string;
          id: number;
          node_id: string;
          login: string;
          organizations_url: string;
          received_events_url: string;
          repos_url: string;
          site_admin: boolean;
          starred_url: string;
          subscriptions_url: string;
          type: string;
          url: string;
        };
      };
      _links: {
        comments: components["schemas"]["link"];
        commits: components["schemas"]["link"];
        statuses: components["schemas"]["link"];
        html: components["schemas"]["link"];
        issue: components["schemas"]["link"];
        review_comments: components["schemas"]["link"];
        review_comment: components["schemas"]["link"];
        self: components["schemas"]["link"];
      };
      author_association: string;
      /**
       * Indicates whether or not the pull request is a draft.
       */
      draft?: boolean;
      merged: boolean;
      mergeable: boolean | null;
      rebaseable?: boolean | null;
      mergeable_state: string;
      merged_by: components["schemas"]["simple-user"] | null;
      comments: number;
      review_comments: number;
      /**
       * Indicates whether maintainers can modify the pull request.
       */
      maintainer_can_modify: boolean;
      commits: number;
      additions: number;
      deletions: number;
      changed_files: number;
    };
    /**
     * Pull Request Review Comments are comments on a portion of the Pull Request's diff.
     */
    "pull-request-review-comment": {
      /**
       * URL for the pull request review comment
       */
      url: string;
      /**
       * The ID of the pull request review to which the comment belongs.
       */
      pull_request_review_id: number | null;
      /**
       * The ID of the pull request review comment.
       */
      id: number;
      /**
       * The node ID of the pull request review comment.
       */
      node_id: string;
      /**
       * The diff of the line that the comment refers to.
       */
      diff_hunk: string;
      /**
       * The relative path of the file to which the comment applies.
       */
      path: string;
      /**
       * The line index in the diff to which the comment applies.
       */
      position: number;
      /**
       * The index of the original line in the diff to which the comment applies.
       */
      original_position: number;
      /**
       * The SHA of the commit to which the comment applies.
       */
      commit_id: string;
      /**
       * The SHA of the original commit to which the comment applies.
       */
      original_commit_id: string;
      /**
       * The comment ID to reply to.
       */
      in_reply_to_id?: number;
      user: components["schemas"]["simple-user"];
      /**
       * The text of the comment.
       */
      body: string;
      created_at: string;
      updated_at: string;
      /**
       * HTML URL for the pull request review comment.
       */
      html_url: string;
      /**
       * URL for the pull request that the review comment belongs to.
       */
      pull_request_url: string;
      /**
       * How the author of the comment is associated with the pull request.
       */
      author_association: string;
      _links: {
        self: { href: string };
        html: { href: string };
        pull_request: { href: string };
      };
      /**
       * The first line of the range for a multi-line comment.
       */
      start_line?: number | null;
      /**
       * The first line of the range for a multi-line comment.
       */
      original_start_line?: number | null;
      /**
       * The side of the first line of the range for a multi-line comment.
       */
      start_side?: ("LEFT" | "RIGHT") | null;
      /**
       * The line of the blob to which the comment applies. The last line of the range for a multi-line comment
       */
      line?: number;
      /**
       * The line of the blob to which the comment applies. The last line of the range for a multi-line comment
       */
      original_line?: number;
      /**
       * The side of the diff to which the comment applies. The side of the last line of the range for a multi-line comment
       */
      side?: "LEFT" | "RIGHT";
      reactions?: components["schemas"]["reaction-rollup"];
      body_html?: string;
      body_text?: string;
    };
    /**
     * Pull Request Merge Result
     */
    "pull-request-merge-result": {
      sha: string;
      merged: boolean;
      message: string;
    };
    /**
     * Pull Request Review Request
     */
    "pull-request-review-request": {
      users: components["schemas"]["simple-user"][];
      teams: components["schemas"]["team-simple"][];
    };
    /**
     * Pull Request Reviews are reviews on pull requests.
     */
    "pull-request-review": {
      /**
       * Unique identifier of the review
       */
      id: number;
      node_id: string;
      user: components["schemas"]["simple-user"] | null;
      /**
       * The text of the review.
       */
      body: string;
      state: string;
      html_url: string;
      pull_request_url: string;
      _links: { html: { href: string }; pull_request: { href: string } };
      submitted_at?: string;
      /**
       * A commit SHA for the review.
       */
      commit_id: string;
      body_html?: string;
      body_text?: string;
      author_association: string;
    };
    /**
     * Legacy Review Comment
     */
    "review-comment": {
      url: string;
      pull_request_review_id: number | null;
      id: number;
      node_id: string;
      diff_hunk: string;
      path: string;
      position: number | null;
      original_position: number;
      commit_id: string;
      original_commit_id: string;
      in_reply_to_id?: number;
      user: components["schemas"]["simple-user"] | null;
      body: string;
      created_at: string;
      updated_at: string;
      html_url: string;
      pull_request_url: string;
      author_association: string;
      _links: {
        self: components["schemas"]["link"];
        html: components["schemas"]["link"];
        pull_request: components["schemas"]["link"];
      };
      body_text?: string;
      body_html?: string;
      /**
       * The side of the first line of the range for a multi-line comment.
       */
      side?: "LEFT" | "RIGHT";
      /**
       * The side of the first line of the range for a multi-line comment.
       */
      start_side?: ("LEFT" | "RIGHT") | null;
      /**
       * The line of the blob to which the comment applies. The last line of the range for a multi-line comment
       */
      line?: number;
      /**
       * The original line of the blob to which the comment applies. The last line of the range for a multi-line comment
       */
      original_line?: number;
      /**
       * The first line of the range for a multi-line comment.
       */
      start_line?: number | null;
      /**
       * The original first line of the range for a multi-line comment.
       */
      original_start_line?: number | null;
    };
    /**
     * Data related to a release.
     */
    "release-asset": {
      url: string;
      browser_download_url: string;
      id: number;
      node_id: string;
      /**
       * The file name of the asset.
       */
      name: string;
      label: string | null;
      /**
       * State of the release asset.
       */
      state: "uploaded" | "open";
      content_type: string;
      size: number;
      download_count: number;
      created_at: string;
      updated_at: string;
      uploader: components["schemas"]["simple-user"] | null;
    };
    /**
     * A release.
     */
    release: {
      url: string;
      html_url: string;
      assets_url: string;
      upload_url: string;
      tarball_url: string | null;
      zipball_url: string | null;
      id: number;
      node_id: string;
      /**
       * The name of the tag.
       */
      tag_name: string;
      /**
       * Specifies the commitish value that determines where the Git tag is created from.
       */
      target_commitish: string;
      name: string | null;
      body?: string | null;
      /**
       * true to create a draft (unpublished) release, false to create a published one.
       */
      draft: boolean;
      /**
       * Whether to identify the release as a prerelease or a full release.
       */
      prerelease: boolean;
      created_at: string;
      published_at: string | null;
      author: components["schemas"]["simple-user"];
      assets: components["schemas"]["release-asset"][];
      body_html?: string;
      body_text?: string;
    };
    /**
     * Sets the state of the secret scanning alert. Can be either `open` or `resolved`. You must provide `resolution` when you set the state to `resolved`.
     */
    "secret-scanning-alert-state": "open" | "resolved";
    /**
     * **Required when the `state` is `resolved`.** The reason for resolving the alert. Can be one of `false_positive`, `wont_fix`, `revoked`, or `used_in_tests`.
     */
    "secret-scanning-alert-resolution": string | null;
    "secret-scanning-alert": {
      number?: components["schemas"]["alert-number"];
      created_at?: components["schemas"]["alert-created-at"];
      url?: components["schemas"]["alert-url"];
      html_url?: components["schemas"]["alert-html-url"];
      state?: components["schemas"]["secret-scanning-alert-state"];
      resolution?: components["schemas"]["secret-scanning-alert-resolution"];
      /**
       * The time that the alert was resolved in ISO 8601 format: `YYYY-MM-DDTHH:MM:SSZ`.
       */
      resolved_at?: string | null;
      resolved_by?: components["schemas"]["simple-user"];
      /**
       * The type of secret that secret scanning detected.
       */
      secret_type?: string;
      /**
       * The secret that was detected.
       */
      secret?: string;
    };
    /**
     * Stargazer
     */
    stargazer: {
      starred_at: string;
      user: components["schemas"]["simple-user"] | null;
    };
    /**
     * Code Frequency Stat
     */
    "code-frequency-stat": number[];
    /**
     * Commit Activity
     */
    "commit-activity": { days: number[]; total: number; week: number };
    /**
     * Contributor Activity
     */
    "contributor-activity": {
      author: components["schemas"]["simple-user"] | null;
      total: number;
      weeks: { w?: string; a?: number; d?: number; c?: number }[];
    };
    "participation-stats": { all: number[]; owner: number[] };
    /**
     * Repository invitations let you manage who you collaborate with.
     */
    "repository-subscription": {
      /**
       * Determines if notifications should be received from this repository.
       */
      subscribed: boolean;
      /**
       * Determines if all notifications should be blocked from this repository.
       */
      ignored: boolean;
      reason: string | null;
      created_at: string;
      url: string;
      repository_url: string;
    };
    /**
     * Tag
     */
    tag: {
      name: string;
      commit: { sha: string; url: string };
      zipball_url: string;
      tarball_url: string;
      node_id: string;
    };
    /**
     * A topic aggregates entities that are related to a subject.
     */
    topic: { names: string[] };
    traffic: { timestamp: string; uniques: number; count: number };
    /**
     * Clone Traffic
     */
    "clone-traffic": {
      count: number;
      uniques: number;
      clones: components["schemas"]["traffic"][];
    };
    /**
     * Content Traffic
     */
    "content-traffic": {
      path: string;
      title: string;
      count: number;
      uniques: number;
    };
    /**
     * Referrer Traffic
     */
    "referrer-traffic": { referrer: string; count: number; uniques: number };
    /**
     * View Traffic
     */
    "view-traffic": {
      count: number;
      uniques: number;
      views: components["schemas"]["traffic"][];
    };
    "scim-group-list-enterprise": {
      schemas: string[];
      totalResults: number;
      itemsPerPage: number;
      startIndex: number;
      Resources: {
        schemas: string[];
        id: string;
        externalId?: string | null;
        displayName?: string;
        members?: { value?: string; $ref?: string; display?: string }[];
        meta?: {
          resourceType?: string;
          created?: string;
          lastModified?: string;
          location?: string;
        };
      }[];
    };
    "scim-enterprise-group": {
      schemas: string[];
      id: string;
      externalId?: string | null;
      displayName?: string;
      members?: { value?: string; $ref?: string; display?: string }[];
      meta?: {
        resourceType?: string;
        created?: string;
        lastModified?: string;
        location?: string;
      };
    };
    "scim-user-list-enterprise": {
      schemas: string[];
      totalResults: number;
      itemsPerPage: number;
      startIndex: number;
      Resources: {
        schemas: string[];
        id: string;
        externalId?: string;
        userName?: string;
        name?: { givenName?: string; familyName?: string };
        emails?: { value?: string; primary?: boolean; type?: string }[];
        groups?: { value?: string }[];
        active?: boolean;
        meta?: {
          resourceType?: string;
          created?: string;
          lastModified?: string;
          location?: string;
        };
      }[];
    };
    "scim-enterprise-user": {
      schemas: string[];
      id: string;
      externalId?: string;
      userName?: string;
      name?: { givenName?: string; familyName?: string };
      emails?: { value?: string; type?: string; primary?: boolean }[];
      groups?: { value?: string }[];
      active?: boolean;
      meta?: {
        resourceType?: string;
        created?: string;
        lastModified?: string;
        location?: string;
      };
    };
    /**
     * SCIM /Users provisioning endpoints
     */
    "scim-user": {
      /**
       * SCIM schema used.
       */
      schemas: string[];
      /**
       * Unique identifier of an external identity
       */
      id: string;
      /**
       * The ID of the User.
       */
      externalId: string | null;
      /**
       * Configured by the admin. Could be an email, login, or username
       */
      userName: string | null;
      /**
       * The name of the user, suitable for display to end-users
       */
      displayName?: string | null;
      name: {
        givenName: string | null;
        familyName: string | null;
        formatted?: string | null;
      };
      /**
       * user emails
       */
      emails: { value: string; primary?: boolean }[];
      /**
       * The active status of the User.
       */
      active: boolean;
      meta: {
        resourceType?: string;
        created?: string;
        lastModified?: string;
        location?: string;
      };
      /**
       * The ID of the organization.
       */
      organization_id?: number;
      /**
       * Set of operations to be performed
       */
      operations?: {
        op: "add" | "remove" | "replace";
        path?: string;
        value?: string | { [key: string]: any } | { [key: string]: any }[];
      }[];
      /**
       * associated groups
       */
      groups?: { value?: string; display?: string }[];
    };
    /**
     * SCIM User List
     */
    "scim-user-list": {
      /**
       * SCIM schema used.
       */
      schemas: string[];
      totalResults: number;
      itemsPerPage: number;
      startIndex: number;
      Resources: components["schemas"]["scim-user"][];
    };
    "search-result-text-matches": {
      object_url?: string;
      object_type?: string | null;
      property?: string;
      fragment?: string;
      matches?: { text?: string; indices?: number[] }[];
    }[];
    /**
     * Code Search Result Item
     */
    "code-search-result-item": {
      name: string;
      path: string;
      sha: string;
      url: string;
      git_url: string;
      html_url: string;
      repository: components["schemas"]["minimal-repository"];
      score: number;
      file_size?: number;
      language?: string | null;
      last_modified_at?: string;
      line_numbers?: string[];
      text_matches?: components["schemas"]["search-result-text-matches"];
    };
    /**
     * Commit Search Result Item
     */
    "commit-search-result-item": {
      url: string;
      sha: string;
      html_url: string;
      comments_url: string;
      commit: {
        author: { name: string; email: string; date: string };
        committer: components["schemas"]["git-user"] | null;
        comment_count: number;
        message: string;
        tree: { sha: string; url: string };
        url: string;
        verification?: components["schemas"]["verification"];
      };
      author: components["schemas"]["simple-user"] | null;
      committer: components["schemas"]["git-user"] | null;
      parents: { url?: string; html_url?: string; sha?: string }[];
      repository: components["schemas"]["minimal-repository"];
      score: number;
      node_id: string;
      text_matches?: components["schemas"]["search-result-text-matches"];
    };
    /**
     * Issue Search Result Item
     */
    "issue-search-result-item": {
      url: string;
      repository_url: string;
      labels_url: string;
      comments_url: string;
      events_url: string;
      html_url: string;
      id: number;
      node_id: string;
      number: number;
      title: string;
      locked: boolean;
      active_lock_reason?: string | null;
      assignees?: components["schemas"]["simple-user"][] | null;
      user: components["schemas"]["simple-user"] | null;
      labels: {
        id?: number;
        node_id?: string;
        url?: string;
        name?: string;
        color?: string;
        default?: boolean;
        description?: string | null;
      }[];
      state: string;
      assignee: components["schemas"]["simple-user"] | null;
      milestone: components["schemas"]["milestone"] | null;
      comments: number;
      created_at: string;
      updated_at: string;
      closed_at: string | null;
      text_matches?: components["schemas"]["search-result-text-matches"];
      pull_request?: {
        merged_at?: string | null;
        diff_url: string | null;
        html_url: string | null;
        patch_url: string | null;
        url: string | null;
      };
      body?: string;
      score: number;
      author_association: string;
      draft?: boolean;
      repository?: components["schemas"]["repository"];
      body_html?: string;
      body_text?: string;
      timeline_url?: string;
      performed_via_github_app?: components["schemas"]["integration"] | null;
    };
    /**
     * Label Search Result Item
     */
    "label-search-result-item": {
      id: number;
      node_id: string;
      url: string;
      name: string;
      color: string;
      default: boolean;
      description: string | null;
      score: number;
      text_matches?: components["schemas"]["search-result-text-matches"];
    };
    /**
     * Repo Search Result Item
     */
    "repo-search-result-item": {
      id: number;
      node_id: string;
      name: string;
      full_name: string;
      owner: components["schemas"]["simple-user"] | null;
      private: boolean;
      html_url: string;
      description: string | null;
      fork: boolean;
      url: string;
      created_at: string;
      updated_at: string;
      pushed_at: string;
      homepage: string | null;
      size: number;
      stargazers_count: number;
      watchers_count: number;
      language: string | null;
      forks_count: number;
      open_issues_count: number;
      master_branch?: string;
      default_branch: string;
      score: number;
      forks_url: string;
      keys_url: string;
      collaborators_url: string;
      teams_url: string;
      hooks_url: string;
      issue_events_url: string;
      events_url: string;
      assignees_url: string;
      branches_url: string;
      tags_url: string;
      blobs_url: string;
      git_tags_url: string;
      git_refs_url: string;
      trees_url: string;
      statuses_url: string;
      languages_url: string;
      stargazers_url: string;
      contributors_url: string;
      subscribers_url: string;
      subscription_url: string;
      commits_url: string;
      git_commits_url: string;
      comments_url: string;
      issue_comment_url: string;
      contents_url: string;
      compare_url: string;
      merges_url: string;
      archive_url: string;
      downloads_url: string;
      issues_url: string;
      pulls_url: string;
      milestones_url: string;
      notifications_url: string;
      labels_url: string;
      releases_url: string;
      deployments_url: string;
      git_url: string;
      ssh_url: string;
      clone_url: string;
      svn_url: string;
      forks: number;
      open_issues: number;
      watchers: number;
      topics?: string[];
      mirror_url: string | null;
      has_issues: boolean;
      has_projects: boolean;
      has_pages: boolean;
      has_wiki: boolean;
      has_downloads: boolean;
      archived: boolean;
      /**
       * Returns whether or not this repository disabled.
       */
      disabled: boolean;
      license: components["schemas"]["license-simple"] | null;
      permissions?: { admin: boolean; pull: boolean; push: boolean };
      text_matches?: components["schemas"]["search-result-text-matches"];
      temp_clone_token?: string;
      allow_merge_commit?: boolean;
      allow_squash_merge?: boolean;
      allow_rebase_merge?: boolean;
      delete_branch_on_merge?: boolean;
    };
    /**
     * Topic Search Result Item
     */
    "topic-search-result-item": {
      name: string;
      display_name: string | null;
      short_description: string | null;
      description: string | null;
      created_by: string | null;
      released: string | null;
      created_at: string;
      updated_at: string;
      featured: boolean;
      curated: boolean;
      score: number;
      repository_count?: number | null;
      logo_url?: string | null;
      text_matches?: components["schemas"]["search-result-text-matches"];
      related?:
        | {
            topic_relation?: {
              id?: number;
              name?: string;
              topic_id?: number;
              relation_type?: string;
            };
          }[]
        | null;
      aliases?:
        | {
            topic_relation?: {
              id?: number;
              name?: string;
              topic_id?: number;
              relation_type?: string;
            };
          }[]
        | null;
    };
    /**
     * User Search Result Item
     */
    "user-search-result-item": {
      login: string;
      id: number;
      node_id: string;
      avatar_url: string;
      gravatar_id: string | null;
      url: string;
      html_url: string;
      followers_url: string;
      subscriptions_url: string;
      organizations_url: string;
      repos_url: string;
      received_events_url: string;
      type: string;
      score: number;
      following_url: string;
      gists_url: string;
      starred_url: string;
      events_url: string;
      public_repos?: number;
      public_gists?: number;
      followers?: number;
      following?: number;
      created_at?: string;
      updated_at?: string;
      name?: string | null;
      bio?: string | null;
      email?: string | null;
      location?: string | null;
      site_admin: boolean;
      hireable?: boolean | null;
      text_matches?: components["schemas"]["search-result-text-matches"];
      blog?: string | null;
      company?: string | null;
      suspended_at?: string | null;
    };
    /**
     * Private User
     */
    "private-user": {
      login: string;
      id: number;
      node_id: string;
      avatar_url: string;
      gravatar_id: string | null;
      url: string;
      html_url: string;
      followers_url: string;
      following_url: string;
      gists_url: string;
      starred_url: string;
      subscriptions_url: string;
      organizations_url: string;
      repos_url: string;
      events_url: string;
      received_events_url: string;
      type: string;
      site_admin: boolean;
      name: string | null;
      company: string | null;
      blog: string | null;
      location: string | null;
      email: string | null;
      hireable: boolean | null;
      bio: string | null;
      twitter_username?: string | null;
      public_repos: number;
      public_gists: number;
      followers: number;
      following: number;
      created_at: string;
      updated_at: string;
      private_gists: number;
      total_private_repos: number;
      owned_private_repos: number;
      disk_usage: number;
      collaborators: number;
      two_factor_authentication: boolean;
      plan?: {
        collaborators: number;
        name: string;
        space: number;
        private_repos: number;
      };
      suspended_at?: string | null;
      business_plus?: boolean;
      ldap_dn?: string;
    };
    /**
     * Public User
     */
    "public-user": {
      login: string;
      id: number;
      node_id: string;
      avatar_url: string;
      gravatar_id: string | null;
      url: string;
      html_url: string;
      followers_url: string;
      following_url: string;
      gists_url: string;
      starred_url: string;
      subscriptions_url: string;
      organizations_url: string;
      repos_url: string;
      events_url: string;
      received_events_url: string;
      type: string;
      site_admin: boolean;
      name: string | null;
      company: string | null;
      blog: string | null;
      location: string | null;
      email: string | null;
      hireable: boolean | null;
      bio: string | null;
      twitter_username?: string | null;
      public_repos: number;
      public_gists: number;
      followers: number;
      following: number;
      created_at: string;
      updated_at: string;
      plan?: {
        collaborators: number;
        name: string;
        space: number;
        private_repos: number;
      };
      suspended_at?: string | null;
      private_gists?: number;
      total_private_repos?: number;
      owned_private_repos?: number;
      disk_usage?: number;
      collaborators?: number;
    };
    /**
     * Email
     */
    email:
      | {
          email: string;
          primary: boolean;
          verified: boolean;
          visibility: string | null;
        }
      | string;
    /**
     * A unique encryption key
     */
    "gpg-key": {
      id: number;
      primary_key_id: number | null;
      key_id: string;
      public_key: string;
      emails: { email?: string; verified?: boolean }[];
      subkeys: {
        id?: number;
        primary_key_id?: number;
        key_id?: string;
        public_key?: string;
        emails?: { [key: string]: any }[];
        subkeys?: { [key: string]: any }[];
        can_sign?: boolean;
        can_encrypt_comms?: boolean;
        can_encrypt_storage?: boolean;
        can_certify?: boolean;
        created_at?: string;
        expires_at?: string | null;
        raw_key?: string | null;
      }[];
      can_sign: boolean;
      can_encrypt_comms: boolean;
      can_encrypt_storage: boolean;
      can_certify: boolean;
      created_at: string;
      expires_at: string | null;
      raw_key: string | null;
    };
    /**
     * Key
     */
    key: {
      key_id: string;
      key: string;
      id: number;
      url: string;
      title: string;
      created_at: string;
      verified: boolean;
      read_only: boolean;
    };
    "marketplace-account": {
      url: string;
      id: number;
      type: string;
      node_id?: string;
      login: string;
      email?: string | null;
      organization_billing_email?: string | null;
    };
    /**
     * User Marketplace Purchase
     */
    "user-marketplace-purchase": {
      billing_cycle: string;
      next_billing_date: string | null;
      unit_count: number | null;
      on_free_trial: boolean;
      free_trial_ends_on: string | null;
      updated_at: string | null;
      account: components["schemas"]["marketplace-account"];
      plan: components["schemas"]["marketplace-listing-plan"];
    };
    /**
     * Starred Repository
     */
    "starred-repository": {
      starred_at: string;
      repo: components["schemas"]["repository"];
    };
    /**
     * Hovercard
     */
    hovercard: { contexts: { message: string; octicon: string }[] };
    /**
     * Key Simple
     */
    "key-simple": { id: number; key: string };
  };
  responses: {
    /**
     * Resource Not Found
     */
    not_found: { [key: string]: any };
    /**
     * Validation Failed
     */
    validation_failed_simple: { [key: string]: any };
    /**
     * Preview Header Missing
     */
    preview_header_missing: { [key: string]: any };
    /**
     * Forbidden
     */
    forbidden: { [key: string]: any };
    /**
     * Requires Authentication
     */
    requires_authentication: { [key: string]: any };
    /**
     * Validation Failed
     */
    validation_failed: { [key: string]: any };
    /**
     * Not Modified
     */
    not_modified: { [key: string]: any };
    /**
     * Gone
     */
    gone: { [key: string]: any };
    /**
     * Service Unavailable
     */
    service_unavailable: { [key: string]: any };
    /**
     * Forbidden Gist
     */
    forbidden_gist: { [key: string]: any };
    /**
     * Moved Permanently
     */
    moved_permanently: { [key: string]: any };
    /**
     * Conflict
     */
    conflict: { [key: string]: any };
    /**
     * Internal Error
     */
    internal_error: { [key: string]: any };
    /**
     * Bad Request
     */
    bad_request: { [key: string]: any };
    /**
     * Found
     */
    found: { [key: string]: any };
    /**
     * Resource Not Found
     */
    scim_not_found: { [key: string]: any };
    /**
     * Forbidden
     */
    scim_forbidden: { [key: string]: any };
    /**
     * Bad Request
     */
    scim_bad_request: { [key: string]: any };
    /**
     * Internal Error
     */
    scim_internal_error: { [key: string]: any };
    /**
     * Conflict
     */
    scim_conflict: { [key: string]: any };
  };
}
