/** *****************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2018. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 * Copyright (c) 2020 Red Hat, Inc.
 ****************************************************************************** */

export const mockResponse = {
  body: {
    paths: [
      '/api',
      '/api/v1',
      '/apis',
      '/apis/',
      '/apis/admissionregistration.k8s.io',
      '/apis/admissionregistration.k8s.io/v1alpha1',
      '/apis/admissionregistration.k8s.io/v1beta1',
      '/apis/agent.open-cluster-management.io',
      '/apis/agent.open-cluster-management.io/v1',
      '/apis/apiextensions.k8s.io',
      '/apis/apiextensions.k8s.io/v1beta1',
      '/apis/apiregistration.k8s.io',
      '/apis/apiregistration.k8s.io/v1',
      '/apis/apiregistration.k8s.io/v1beta1',
      '/apis/apps',
      '/apis/apps/v1',
      '/apis/apps/v1beta1',
      '/apis/apps/v1beta2',
      '/apis/authentication.k8s.io',
      '/apis/authentication.k8s.io/v1',
      '/apis/authentication.k8s.io/v1beta1',
      '/apis/authorization.k8s.io',
      '/apis/authorization.k8s.io/v1',
      '/apis/authorization.k8s.io/v1beta1',
      '/apis/autoscaling',
      '/apis/autoscaling/v1',
      '/apis/autoscaling/v2beta1',
      '/apis/batch',
      '/apis/batch/v1',
      '/apis/batch/v1beta1',
      '/apis/batch/v2alpha1',
      '/apis/certificates.k8s.io',
      '/apis/certificates.k8s.io/v1beta1',
      '/apis/certmanager.k8s.io',
      '/apis/certmanager.k8s.io/v1alpha1',
      '/apis/cluster.open-cluster-management.io',
      '/apis/cluster.open-cluster-management.io/v1',
      '/apis/compliance.mcm.ibm.com',
      '/apis/compliance.mcm.ibm.com/v1alpha1',
      '/apis/custom.metrics.k8s.io',
      '/apis/custom.metrics.k8s.io/v1beta1',
      '/apis/events.k8s.io',
      '/apis/events.k8s.io/v1beta1',
      '/apis/extensions',
      '/apis/extensions/v1beta1',
      '/apis/icp.ibm.com',
      '/apis/icp.ibm.com/v1',
      '/apis/mcm.ibm.com',
      '/apis/mcm.ibm.com/v1alpha1',
      '/apis/metrics.k8s.io',
      '/apis/metrics.k8s.io/v1beta1',
      '/apis/networking.k8s.io',
      '/apis/networking.k8s.io/v1',
      '/apis/policy',
      '/apis/policy.open-cluster-management.io',
      '/apis/policy.open-cluster-management.io/v1',
      '/apis/policy/v1',
      '/apis/rbac.authorization.k8s.io',
      '/apis/rbac.authorization.k8s.io/v1',
      '/apis/rbac.authorization.k8s.io/v1beta1',
      '/apis/scheduling.k8s.io',
      '/apis/scheduling.k8s.io/v1beta1',
      '/apis/securityenforcement.admission.cloud.ibm.com',
      '/apis/securityenforcement.admission.cloud.ibm.com/v1beta1',
      '/apis/servicecatalog.k8s.io',
      '/apis/servicecatalog.k8s.io/v1beta1',
      '/apis/storage.k8s.io',
      '/apis/storage.k8s.io/v1',
      '/apis/storage.k8s.io/v1beta1',
      '/healthz',
      '/healthz/autoregister-completion',
      '/healthz/etcd',
      '/healthz/ping',
      '/healthz/poststarthook/apiservice-openapi-controller',
      '/healthz/poststarthook/apiservice-registration-controller',
      '/healthz/poststarthook/apiservice-status-available-controller',
      '/healthz/poststarthook/bootstrap-controller',
      '/healthz/poststarthook/ca-registration',
      '/healthz/poststarthook/generic-apiserver-start-informers',
      '/healthz/poststarthook/kube-apiserver-autoregistration',
      '/healthz/poststarthook/rbac/bootstrap-roles',
      '/healthz/poststarthook/scheduling/bootstrap-system-priority-classes',
      '/healthz/poststarthook/start-apiextensions-controllers',
      '/healthz/poststarthook/start-apiextensions-informers',
      '/healthz/poststarthook/start-kube-aggregator-informers',
      '/healthz/poststarthook/start-kube-apiserver-admission-initializer',
      '/healthz/poststarthook/start-kube-apiserver-informers',
      '/logs',
      '/metrics',
      '/openapi/v2',
      '/swagger-2.0.0.json',
      '/swagger-2.0.0.pb-v1',
      '/swagger-2.0.0.pb-v1.gz',
      '/swagger.json',
      '/swaggerapi',
      '/version',
    ],
  },
};

export const mcmApiPath = {
  body: {
    kind: 'APIResourceList',
    apiVersion: 'v1',
    groupVersion: 'mcm.ibm.com/v1alpha1',
    resources: [
      {
        name: 'applicationrelationships',
        singularName: '',
        namespaced: true,
        kind: 'ApplicationRelationship',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'rel',
        ],
      },
      {
        name: 'applicationrelationships/status',
        singularName: '',
        namespaced: true,
        kind: 'ApplicationRelationship',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'applications',
        singularName: '',
        namespaced: true,
        kind: 'Application',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
      },
      {
        name: 'channels',
        singularName: '',
        namespaced: true,
        kind: 'Channel',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
      },
      {
        name: 'subscriptions',
        singularName: '',
        namespaced: true,
        kind: 'Subscription',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
      },
      {
        name: 'placementrules',
        singularName: '',
        namespaced: true,
        kind: 'PlacementRule',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
      },
      {
        name: 'applications/status',
        singularName: '',
        namespaced: true,
        kind: 'Application',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'clusterjoinrequests',
        singularName: '',
        namespaced: false,
        kind: 'ClusterJoinRequest',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
      },
      {
        name: 'clusterjoinrequests/status',
        singularName: '',
        namespaced: false,
        kind: 'ClusterJoinRequest',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'clusterstatuses',
        singularName: '',
        namespaced: true,
        kind: 'ClusterStatus',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
      },
      {
        name: 'clusterstatuses/topology',
        singularName: '',
        namespaced: true,
        kind: 'ClusterStatusTopology',
        verbs: [
          'create',
        ],
      },
      {
        name: 'deployableoverrides',
        singularName: '',
        namespaced: true,
        kind: 'DeployableOverride',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'do',
        ],
      },
      {
        name: 'deployableoverrides/status',
        singularName: '',
        namespaced: true,
        kind: 'DeployableOverride',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'deployables',
        singularName: '',
        namespaced: true,
        kind: 'Deployable',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
      },
      {
        name: 'deployables/status',
        singularName: '',
        namespaced: true,
        kind: 'Deployable',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'placementbindings',
        singularName: '',
        namespaced: true,
        kind: 'PlacementBinding',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'pb',
        ],
      },
      {
        name: 'placementpolicies',
        singularName: '',
        namespaced: true,
        kind: 'PlacementPolicy',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'pp',
        ],
      },
      {
        name: 'placementrules',
        singularName: '',
        namespaced: true,
        kind: 'placementrule',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'pr',
        ],
      },
      {
        name: 'placementpolicies/status',
        singularName: '',
        namespaced: true,
        kind: 'PlacementPolicy',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'resourceviews',
        singularName: '',
        namespaced: true,
        kind: 'ResourceView',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
      },
      {
        name: 'resourceviews/status',
        singularName: '',
        namespaced: true,
        kind: 'ResourceView',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'works',
        singularName: '',
        namespaced: true,
        kind: 'Work',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
      },
      {
        name: 'works/result',
        singularName: '',
        namespaced: true,
        kind: 'ResourceViewResult',
        verbs: [
          'create',
        ],
      },
      {
        name: 'works/status',
        singularName: '',
        namespaced: true,
        kind: 'Work',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'worksets',
        singularName: '',
        namespaced: true,
        kind: 'WorkSet',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
      },
      {
        name: 'worksets/status',
        singularName: '',
        namespaced: true,
        kind: 'WorkSet',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
    ],
  },
};

export const complianceApiPath = {
  body: {
    kind: 'APIResourceList',
    apiVersion: 'v1',
    groupVersion: 'compliance.mcm.ibm.com/v1alpha1',
    resources: [
      {
        name: 'compliances',
        singularName: '',
        namespaced: true,
        kind: 'Compliance',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
      },
    ],
  },
};

export const ocmClusterApiPath = {
  body: {
    kind: 'APIResourceList',
    apiVersion: 'v1',
    groupVersion: 'cluster.open-cluster-management.io/v1',
    resources: [
      {
        name: 'managedclusters',
        singularName: 'managedcluster',
        namespaced: false,
        kind: 'ManagedCluster',
        verbs: [
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'create',
          'update',
          'watch',
        ],
        storageVersionHash: 'DuqQMgCnGgw=',
      },
      {
        name: 'managedclusters/status',
        singularName: '',
        namespaced: false,
        kind: 'ManagedCluster',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
    ],
  },
};

export const ocmAgentApiPath = {
  body: {
    kind: 'APIResourceList',
    apiVersion: 'v1',
    groupVersion: 'agent.open-cluster-management.io/v1',
    resources: [
      {
        name: 'klusterletaddonconfigs',
        singularName: 'klusterletaddonconfig',
        namespaced: true,
        kind: 'KlusterletAddonConfig',
        verbs: [
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'create',
          'update',
          'watch',
        ],
        storageVersionHash: 'XAiWNFFUtMs=',
      },
      {
        name: 'klusterletaddonconfigs/status',
        singularName: '',
        namespaced: true,
        kind: 'KlusterletAddonConfig',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
    ],
  },
};

export const apiPath = {
  body: {
    kind: 'APIResourceList',
    groupVersion: 'v1',
    resources: [
      {
        name: 'bindings',
        singularName: '',
        namespaced: true,
        kind: 'Binding',
        verbs: [
          'create',
        ],
      },
      {
        name: 'componentstatuses',
        singularName: '',
        namespaced: false,
        kind: 'ComponentStatus',
        verbs: [
          'get',
          'list',
        ],
        shortNames: [
          'cs',
        ],
      },
      {
        name: 'configmaps',
        singularName: '',
        namespaced: true,
        kind: 'ConfigMap',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'cm',
        ],
        storageVersionHash: 'qFsyl6wFWjQ=',
      },
      {
        name: 'endpoints',
        singularName: '',
        namespaced: true,
        kind: 'Endpoints',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'ep',
        ],
        storageVersionHash: 'fWeeMqaN/OA=',
      },
      {
        name: 'events',
        singularName: '',
        namespaced: true,
        kind: 'Event',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'ev',
        ],
        storageVersionHash: 'r2yiGXH7wu8=',
      },
      {
        name: 'limitranges',
        singularName: '',
        namespaced: true,
        kind: 'LimitRange',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'limits',
        ],
        storageVersionHash: 'EBKMFVe6cwo=',
      },
      {
        name: 'namespaces',
        singularName: '',
        namespaced: false,
        kind: 'Namespace',
        verbs: [
          'create',
          'delete',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'ns',
        ],
        storageVersionHash: 'Q3oi5N2YM8M=',
      },
      {
        name: 'namespaces/finalize',
        singularName: '',
        namespaced: false,
        kind: 'Namespace',
        verbs: [
          'update',
        ],
      },
      {
        name: 'namespaces/status',
        singularName: '',
        namespaced: false,
        kind: 'Namespace',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'nodes',
        singularName: '',
        namespaced: false,
        kind: 'Node',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'no',
        ],
        storageVersionHash: 'XwShjMxG9Fs=',
      },
      {
        name: 'nodes/proxy',
        singularName: '',
        namespaced: false,
        kind: 'NodeProxyOptions',
        verbs: [
          'create',
          'delete',
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'nodes/status',
        singularName: '',
        namespaced: false,
        kind: 'Node',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'persistentvolumeclaims',
        singularName: '',
        namespaced: true,
        kind: 'PersistentVolumeClaim',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'pvc',
        ],
        storageVersionHash: 'QWTyNDq0dC4=',
      },
      {
        name: 'persistentvolumeclaims/status',
        singularName: '',
        namespaced: true,
        kind: 'PersistentVolumeClaim',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'persistentvolumes',
        singularName: '',
        namespaced: false,
        kind: 'PersistentVolume',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'pv',
        ],
        storageVersionHash: 'HN/zwEC+JgM=',
      },
      {
        name: 'persistentvolumes/status',
        singularName: '',
        namespaced: false,
        kind: 'PersistentVolume',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'pods',
        singularName: '',
        namespaced: true,
        kind: 'Pod',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'po',
        ],
        categories: [
          'all',
        ],
        storageVersionHash: 'xPOwRZ+Yhw8=',
      },
      {
        name: 'pods/attach',
        singularName: '',
        namespaced: true,
        kind: 'PodAttachOptions',
        verbs: [
          'create',
          'get',
        ],
      },
      {
        name: 'pods/binding',
        singularName: '',
        namespaced: true,
        kind: 'Binding',
        verbs: [
          'create',
        ],
      },
      {
        name: 'pods/eviction',
        singularName: '',
        namespaced: true,
        group: 'policy',
        version: 'v1beta1',
        kind: 'Eviction',
        verbs: [
          'create',
        ],
      },
      {
        name: 'pods/exec',
        singularName: '',
        namespaced: true,
        kind: 'PodExecOptions',
        verbs: [
          'create',
          'get',
        ],
      },
      {
        name: 'pods/log',
        singularName: '',
        namespaced: true,
        kind: 'Pod',
        verbs: [
          'get',
        ],
      },
      {
        name: 'pods/portforward',
        singularName: '',
        namespaced: true,
        kind: 'PodPortForwardOptions',
        verbs: [
          'create',
          'get',
        ],
      },
      {
        name: 'pods/proxy',
        singularName: '',
        namespaced: true,
        kind: 'PodProxyOptions',
        verbs: [
          'create',
          'delete',
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'pods/status',
        singularName: '',
        namespaced: true,
        kind: 'Pod',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'podtemplates',
        singularName: '',
        namespaced: true,
        kind: 'PodTemplate',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        storageVersionHash: 'LIXB2x4IFpk=',
      },
      {
        name: 'replicationcontrollers',
        singularName: '',
        namespaced: true,
        kind: 'ReplicationController',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'rc',
        ],
        categories: [
          'all',
        ],
        storageVersionHash: 'Jond2If31h0=',
      },
      {
        name: 'replicationcontrollers/scale',
        singularName: '',
        namespaced: true,
        group: 'autoscaling',
        version: 'v1',
        kind: 'Scale',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'replicationcontrollers/status',
        singularName: '',
        namespaced: true,
        kind: 'ReplicationController',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'resourcequotas',
        singularName: '',
        namespaced: true,
        kind: 'ResourceQuota',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'quota',
        ],
        storageVersionHash: '8uhSgffRX6w=',
      },
      {
        name: 'resourcequotas/status',
        singularName: '',
        namespaced: true,
        kind: 'ResourceQuota',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'secrets',
        singularName: '',
        namespaced: true,
        kind: 'Secret',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        storageVersionHash: 'S6u1pOWzb84=',
      },
      {
        name: 'serviceaccounts',
        singularName: '',
        namespaced: true,
        kind: 'ServiceAccount',
        verbs: [
          'create',
          'delete',
          'deletecollection',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'sa',
        ],
        storageVersionHash: 'pbx9ZvyFpBE=',
      },
      {
        name: 'serviceaccounts/token',
        singularName: '',
        namespaced: true,
        group: 'authentication.k8s.io',
        version: 'v1',
        kind: 'TokenRequest',
        verbs: [
          'create',
        ],
      },
      {
        name: 'services',
        singularName: '',
        namespaced: true,
        kind: 'Service',
        verbs: [
          'create',
          'delete',
          'get',
          'list',
          'patch',
          'update',
          'watch',
        ],
        shortNames: [
          'svc',
        ],
        categories: [
          'all',
        ],
        storageVersionHash: '0/CO1lhkEBI=',
      },
      {
        name: 'services/proxy',
        singularName: '',
        namespaced: true,
        kind: 'ServiceProxyOptions',
        verbs: [
          'create',
          'delete',
          'get',
          'patch',
          'update',
        ],
      },
      {
        name: 'services/status',
        singularName: '',
        namespaced: true,
        kind: 'Service',
        verbs: [
          'get',
          'patch',
          'update',
        ],
      },
    ],
  },
};
