/*******************************************************************************
 * Licensed Materials - Property of IBM
 * (c) Copyright IBM Corporation 2017. All Rights Reserved.
 *
 * Note to U.S. Government Users Restricted Rights:
 * Use, duplication or disclosure restricted by GSA ADP Schedule
 * Contract with IBM Corp.
 *******************************************************************************/
'use strict'

const CFC_ACCESS_COOKIE = 'cfc-access-token-cookie'
const CFC_USER_COOKIE = 'cfc-acs-auth-cookie'

exports.isLoggedIn = function(req) {
  return !!exports.getAccessToken(req) && !!exports.getUserToken(req)
}

exports.getAccessToken = function(req) {
  if (req.cookies && req.cookies[CFC_ACCESS_COOKIE]){
    return req.cookies[CFC_ACCESS_COOKIE]
  }
}

exports.getUserToken = function(req) {
  if (req.cookies && req.cookies[CFC_USER_COOKIE]) {
    return req.cookies[CFC_USER_COOKIE]
  }
}
